/*++ BUILD Version: 0005    // Increment this if a change has global effects

Copyright (c) 1991-1993  Microsoft Corporation

Module Name:

    ntstatus.h

Abstract:

    Constant definitions for the NTSTATUS values.

Author:

    Portable Systems Group 30-Mar-1989

Revision History:

Notes:

    This file is generated by the MC tool from the winerror.msg file.

    Please add new error values to the end of the file.  To do otherwise
    will jumble the error values.

--*/

#ifndef _NTSTATUS_
#define _NTSTATUS_

#ifndef WIN32_NO_STATUS // winnt
// begin_ntsecapi

/*lint -save -e767 */  // Don't complain about different definitions // winnt



/////////////////////////////////////////////////////////////////////////
//
// Standard Success values
//
//
/////////////////////////////////////////////////////////////////////////


//
// The success status codes 0 - 63 are reserved for wait completion status.
//
#define STATUS_SUCCESS                          ((NTSTATUS)0x00000000L) // ntsubauth

//
//  Values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//
#define FACILITY_RPC_STUBS               0x3
#define FACILITY_RPC_RUNTIME             0x2
#define FACILITY_IO_ERROR_CODE           0x4


//
// Define the severity codes
//
#define STATUS_SEVERITY_WARNING          0x2
#define STATUS_SEVERITY_SUCCESS          0x0
#define STATUS_SEVERITY_INFORMATIONAL    0x1
#define STATUS_SEVERITY_ERROR            0x3


//
// MessageId: STATUS_WAIT_0
//
// MessageText:
//
//  STATUS_WAIT_0
//
#define STATUS_WAIT_0                    ((NTSTATUS)0x00000000L)    // winnt

//
// MessageId: STATUS_WAIT_1
//
// MessageText:
//
//  STATUS_WAIT_1
//
#define STATUS_WAIT_1                    ((NTSTATUS)0x00000001L)

//
// MessageId: STATUS_WAIT_2
//
// MessageText:
//
//  STATUS_WAIT_2
//
#define STATUS_WAIT_2                    ((NTSTATUS)0x00000002L)

//
// MessageId: STATUS_WAIT_3
//
// MessageText:
//
//  STATUS_WAIT_3
//
#define STATUS_WAIT_3                    ((NTSTATUS)0x00000003L)

//
// MessageId: STATUS_WAIT_63
//
// MessageText:
//
//  STATUS_WAIT_63
//
#define STATUS_WAIT_63                   ((NTSTATUS)0x0000003FL)


//
// The success status codes 128 - 191 are reserved for wait completion
// status with an abandoned mutant object.
//
#define STATUS_ABANDONED                        ((NTSTATUS)0x00000080L)

//
// MessageId: STATUS_ABANDONED_WAIT_0
//
// MessageText:
//
//  STATUS_ABANDONED_WAIT_0
//
#define STATUS_ABANDONED_WAIT_0          ((NTSTATUS)0x00000080L)    // winnt

//
// MessageId: STATUS_ABANDONED_WAIT_63
//
// MessageText:
//
//  STATUS_ABANDONED_WAIT_63
//
#define STATUS_ABANDONED_WAIT_63         ((NTSTATUS)0x000000BFL)

//
// MessageId: STATUS_USER_APC
//
// MessageText:
//
//  The success status codes 256, 257, 258, and 258 are reserved for
//  User APC, Kernel APC, Alerted, and Timeout.
//
#define STATUS_USER_APC                  ((NTSTATUS)0x000000C0L)    // winnt

//
// MessageId: STATUS_KERNEL_APC
//
// MessageText:
//
//  The success status codes 256, 257, 258, and 258 are reserved for
//  User APC, Kernel APC, Alerted, and Timeout.
//
#define STATUS_KERNEL_APC                ((NTSTATUS)0x00000100L)

//
// MessageId: STATUS_ALERTED
//
// MessageText:
//
//  The success status codes 256, 257, 258, and 258 are reserved for
//  User APC, Kernel APC, Alerted, and Timeout.
//
#define STATUS_ALERTED                   ((NTSTATUS)0x00000101L)

//
// MessageId: STATUS_TIMEOUT
//
// MessageText:
//
//  The success status codes 256, 257, 258, and 258 are reserved for
//  User APC, Kernel APC, Alerted, and Timeout.
//
#define STATUS_TIMEOUT                   ((NTSTATUS)0x00000102L)    // winnt

//
// MessageId: STATUS_PENDING
//
// MessageText:
//
//  The operation that was requested is pending completion.
//
#define STATUS_PENDING                   ((NTSTATUS)0x00000103L)    // winnt

//
// MessageId: STATUS_REPARSE
//
// MessageText:
//
//  A reparse should be performed by the Object Manager since the name of the
//  file resulted in a symbolic link.
//
#define STATUS_REPARSE                   ((NTSTATUS)0x00000104L)

//
// MessageId: STATUS_MORE_ENTRIES
//
// MessageText:
//
//  Returned by enumeration APIs to indicate more information is available
//  to successive calls.
//
#define STATUS_MORE_ENTRIES              ((NTSTATUS)0x00000105L)

//
// MessageId: STATUS_NOT_ALL_ASSIGNED
//
// MessageText:
//
//  Indicates not all privileges referenced are assigned to the caller.
//  This allows, for example, all privileges to be disabled without having
//  to know exactly which privileges are assigned.
//
#define STATUS_NOT_ALL_ASSIGNED          ((NTSTATUS)0x00000106L)

//
// MessageId: STATUS_SOME_NOT_MAPPED
//
// MessageText:
//
//  Some of the information to be translated has not been translated.
//
#define STATUS_SOME_NOT_MAPPED           ((NTSTATUS)0x00000107L)

//
// MessageId: STATUS_OPLOCK_BREAK_IN_PROGRESS
//
// MessageText:
//
//  An open/create operation completed while an oplock break is
//  underway.
//
#define STATUS_OPLOCK_BREAK_IN_PROGRESS  ((NTSTATUS)0x00000108L)

//
// MessageId: STATUS_VOLUME_MOUNTED
//
// MessageText:
//
//  A new volume has been mounted by a file system.
//
#define STATUS_VOLUME_MOUNTED            ((NTSTATUS)0x00000109L)

//
// MessageId: STATUS_RXACT_COMMITTED
//
// MessageText:
//
//  This success level status indicates that the transaction state already
//  exists for the registry sub-tree, but that a transaction commit was
//  previously aborted.  The commit has now been completed.
//  This status value is returned by the runtime library (RTL) registry
//  transaction package (RXact).
//
#define STATUS_RXACT_COMMITTED           ((NTSTATUS)0x0000010AL)

//
// MessageId: STATUS_NOTIFY_CLEANUP
//
// MessageText:
//
//  This indicates that a notify change request has been completed due to
//  closing the handle which made the notify change request.
//
#define STATUS_NOTIFY_CLEANUP            ((NTSTATUS)0x0000010BL)

//
// MessageId: STATUS_NOTIFY_ENUM_DIR
//
// MessageText:
//
//  This indicates that a notify change request is being completed and that the
//  information is not being returned in the caller's buffer.  The caller now
//  needs to enumerate the files to find the changes.
//
#define STATUS_NOTIFY_ENUM_DIR           ((NTSTATUS)0x0000010CL)

//
// MessageId: STATUS_NO_QUOTAS_FOR_ACCOUNT
//
// MessageText:
//
//  {No Quotas}
//  No system quota limits are specifically set for this account.
//
#define STATUS_NO_QUOTAS_FOR_ACCOUNT     ((NTSTATUS)0x0000010DL)

//
// MessageId: STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED
//
// MessageText:
//
//  {Connect Failure on Primary Transport}
//  An attempt was made to connect to the remote server %s on the primary transport, but the
//  connection failed.  The computer WAS able to connect on a secondary transport.
//
#define STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED ((NTSTATUS)0x0000010EL)

//
// MessageId: STATUS_PAGE_FAULT_TRANSITION
//
// MessageText:
//
//  Page fault was a transition fault.
//
#define STATUS_PAGE_FAULT_TRANSITION     ((NTSTATUS)0x00000110L)

//
// MessageId: STATUS_PAGE_FAULT_DEMAND_ZERO
//
// MessageText:
//
//  Page fault was a demand zero fault.
//
#define STATUS_PAGE_FAULT_DEMAND_ZERO    ((NTSTATUS)0x00000111L)

//
// MessageId: STATUS_PAGE_FAULT_COPY_ON_WRITE
//
// MessageText:
//
//  Page fault was a demand zero fault.
//
#define STATUS_PAGE_FAULT_COPY_ON_WRITE  ((NTSTATUS)0x00000112L)

//
// MessageId: STATUS_PAGE_FAULT_GUARD_PAGE
//
// MessageText:
//
//  Page fault was a demand zero fault.
//
#define STATUS_PAGE_FAULT_GUARD_PAGE     ((NTSTATUS)0x00000113L)

//
// MessageId: STATUS_PAGE_FAULT_PAGING_FILE
//
// MessageText:
//
//  Page fault was satisfied by reading from a secondary storage device.
//
#define STATUS_PAGE_FAULT_PAGING_FILE    ((NTSTATUS)0x00000114L)

//
// MessageId: STATUS_CACHE_PAGE_LOCKED
//
// MessageText:
//
//  Cached page was locked during operation.
//
#define STATUS_CACHE_PAGE_LOCKED         ((NTSTATUS)0x00000115L)

//
// MessageId: STATUS_CRASH_DUMP
//
// MessageText:
//
//  Crash dump exists in paging file.
//
#define STATUS_CRASH_DUMP                ((NTSTATUS)0x00000116L)

//
// MessageId: STATUS_BUFFER_ALL_ZEROS
//
// MessageText:
//
//  Specified buffer contains all zeros.
//
#define STATUS_BUFFER_ALL_ZEROS          ((NTSTATUS)0x00000117L)

//
// MessageId: STATUS_REPARSE_OBJECT
//
// MessageText:
//
//  A reparse should be performed by the Object Manager since the name of the
//  file resulted in a symbolic link.
//
#define STATUS_REPARSE_OBJECT            ((NTSTATUS)0x00000118L)



/////////////////////////////////////////////////////////////////////////
//
// Standard Information values
//
/////////////////////////////////////////////////////////////////////////

//
// MessageId: STATUS_OBJECT_NAME_EXISTS
//
// MessageText:
//
//  {Object Exists}
//  An attempt was made to create an object and the object name already existed.
//
#define STATUS_OBJECT_NAME_EXISTS        ((NTSTATUS)0x40000000L)

//
// MessageId: STATUS_THREAD_WAS_SUSPENDED
//
// MessageText:
//
//  {Thread Suspended}
//  A thread termination occurred while the thread was suspended. The
//  thread was resumed, and termination proceeded.
//
#define STATUS_THREAD_WAS_SUSPENDED      ((NTSTATUS)0x40000001L)

//
// MessageId: STATUS_WORKING_SET_LIMIT_RANGE
//
// MessageText:
//
//  {Working Set Range Error}
//  An attempt was made to set the working set minimum or maximum
//  to values which are outside of the allowable range.
//
#define STATUS_WORKING_SET_LIMIT_RANGE   ((NTSTATUS)0x40000002L)

//
// MessageId: STATUS_IMAGE_NOT_AT_BASE
//
// MessageText:
//
//  {Image Relocated}
//  An image file could not be mapped at the address specified in
//  the image file.  Local fixups must be performed on this image.
//
#define STATUS_IMAGE_NOT_AT_BASE         ((NTSTATUS)0x40000003L)

//
// MessageId: STATUS_RXACT_STATE_CREATED
//
// MessageText:
//
//  This informational level status indicates that a specified registry
//  sub-tree transaction state did not yet exist and had to be created.
//  This status value is returned by the runtime library (RTL) registry
//  transaction package (RXact).
//
#define STATUS_RXACT_STATE_CREATED       ((NTSTATUS)0x40000004L)

//
// MessageId: STATUS_SEGMENT_NOTIFICATION
//
// MessageText:
//
//  {Segment Load}
//  A virtual DOS machine (VDM) is loading, unloading, or moving an MS-DOS
//  or Win16 program segment image. An exception is raised so a debugger can
//  load, unload or track symbols and breakpoints within these 16-bit segments.
//
#define STATUS_SEGMENT_NOTIFICATION      ((NTSTATUS)0x40000005L)    // winnt

//
// MessageId: STATUS_LOCAL_USER_SESSION_KEY
//
// MessageText:
//
//  {Local Session Key}
//  A user session key was requested for a local RPC connection. The session key
//  returned is a constant value and not unique to this connection.
//
#define STATUS_LOCAL_USER_SESSION_KEY    ((NTSTATUS)0x40000006L)

//
// MessageId: STATUS_BAD_CURRENT_DIRECTORY
//
// MessageText:
//
//  {Invalid Current Directory}
//  The process cannot switch to the startup current directory %s.
//  Select OK to set current directory to %s, or select CANCEL
//  to exit.
//
#define STATUS_BAD_CURRENT_DIRECTORY     ((NTSTATUS)0x40000007L)

//
// MessageId: STATUS_SERIAL_MORE_WRITES
//
// MessageText:
//
//  {Serial IOCTL Complete}
//  A serial I/O operation was completed by another write to a serial port.
//  (The IOCTL_SERIAL_XOFF_COUNTER reached zero.)
//
#define STATUS_SERIAL_MORE_WRITES        ((NTSTATUS)0x40000008L)

//
// MessageId: STATUS_REGISTRY_RECOVERED
//
// MessageText:
//
//  {Registry Recovery}
//  One of the files containing the system's Registry data had to be recovered
//  by use of a log or alternate copy.  The recovery was successful.
//
#define STATUS_REGISTRY_RECOVERED        ((NTSTATUS)0x40000009L)

//
// MessageId: STATUS_FT_READ_RECOVERY_FROM_BACKUP
//
// MessageText:
//
//  {Redundant Read}
//  To satisfy a read request, the NT fault-tolerant file system successfully
//  read the requested data from a redundant copy. This was done because
//  the file system encountered a failure on a member of the fault-tolerant
//  volume, but was unable to reassign the failing area of the device.
//
#define STATUS_FT_READ_RECOVERY_FROM_BACKUP ((NTSTATUS)0x4000000AL)

//
// MessageId: STATUS_FT_WRITE_RECOVERY
//
// MessageText:
//
//  {Redundant Write}
//  To satisfy a write request, the NT fault-tolerant file system successfully
//  wrote a redundant copy of the information. This was done because the
//  file system encountered a failure on a member of the fault-tolerant
//  volume, but was not able to reassign the failing area of the device.
//
#define STATUS_FT_WRITE_RECOVERY         ((NTSTATUS)0x4000000BL)

//
// MessageId: STATUS_SERIAL_COUNTER_TIMEOUT
//
// MessageText:
//
//  {Serial IOCTL Timeout}
//  A serial I/O operation completed because the time-out period expired.
//  (The IOCTL_SERIAL_XOFF_COUNTER had not reached zero.)
//
#define STATUS_SERIAL_COUNTER_TIMEOUT    ((NTSTATUS)0x4000000CL)

//
// MessageId: STATUS_NULL_LM_PASSWORD
//
// MessageText:
//
//  {Password Too Complex}
//  The NT password is too complex to be converted to a LAN Manager password.
//  The LAN Manager password returned is a NULL string.
//
#define STATUS_NULL_LM_PASSWORD          ((NTSTATUS)0x4000000DL)

//
// MessageId: STATUS_IMAGE_MACHINE_TYPE_MISMATCH
//
// MessageText:
//
//  {Machine Type Mismatch}
//  The image file %s is valid, but is for a machine type other than the current machine. Select OK to continue, or CANCEL to fail the DLL load.
//
#define STATUS_IMAGE_MACHINE_TYPE_MISMATCH ((NTSTATUS)0x4000000EL)

//
// MessageId: STATUS_RECEIVE_PARTIAL
//
// MessageText:
//
//  {Partial Data Received}
//  The network transport returned partial data to its client. The remaining
//  data will be sent later.
//
#define STATUS_RECEIVE_PARTIAL           ((NTSTATUS)0x4000000FL)

//
// MessageId: STATUS_RECEIVE_EXPEDITED
//
// MessageText:
//
//  {Expedited Data Received}
//  The network transport returned data to its client that was marked as
//  expedited by the remote system.
//
#define STATUS_RECEIVE_EXPEDITED         ((NTSTATUS)0x40000010L)

//
// MessageId: STATUS_RECEIVE_PARTIAL_EXPEDITED
//
// MessageText:
//
//  {Partial Expedited Data Received}
//  The network transport returned partial data to its client and this data
//  was marked as expedited by the remote system. The remaining data will
//  be sent later.
//
#define STATUS_RECEIVE_PARTIAL_EXPEDITED ((NTSTATUS)0x40000011L)

//
// MessageId: STATUS_EVENT_DONE
//
// MessageText:
//
//  {TDI Event Done}
//  The TDI indication has completed successfully.
//
#define STATUS_EVENT_DONE                ((NTSTATUS)0x40000012L)

//
// MessageId: STATUS_EVENT_PENDING
//
// MessageText:
//
//  {TDI Event Pending}
//  The TDI indication has entered the pending state.
//
#define STATUS_EVENT_PENDING             ((NTSTATUS)0x40000013L)

//
// MessageId: STATUS_CHECKING_FILE_SYSTEM
//
// MessageText:
//
//  Checking file system on %wZ
//
#define STATUS_CHECKING_FILE_SYSTEM      ((NTSTATUS)0x40000014L)

//
// MessageId: STATUS_FATAL_APP_EXIT
//
// MessageText:
//
//  {Fatal Application Exit}
//  %s
//
#define STATUS_FATAL_APP_EXIT            ((NTSTATUS)0x40000015L)

//
// MessageId: STATUS_PREDEFINED_HANDLE
//
// MessageText:
//
//  The specified registry key is referenced by a predefined handle.
//
#define STATUS_PREDEFINED_HANDLE         ((NTSTATUS)0x40000016L)

//
// MessageId: STATUS_WAS_UNLOCKED
//
// MessageText:
//
//  {Page Unlocked}
//  The page protection of a locked page was changed to 'No Access'
//  and the page was unlocked from memory and from the process.
//
#define STATUS_WAS_UNLOCKED              ((NTSTATUS)0x40000017L)

//
// MessageId: STATUS_SERVICE_NOTIFICATION
//
// MessageText:
//
//  %s
//
#define STATUS_SERVICE_NOTIFICATION      ((NTSTATUS)0x40000018L)

//
// MessageId: STATUS_WAS_LOCKED
//
// MessageText:
//
//  {Page Locked}
//  One of the pages to lock was already locked.
//
#define STATUS_WAS_LOCKED                ((NTSTATUS)0x40000019L)

//
// MessageId: STATUS_LOG_HARD_ERROR
//
// MessageText:
//
//  Application popup: %1 : %2
//
#define STATUS_LOG_HARD_ERROR            ((NTSTATUS)0x4000001AL)

//
// MessageId: STATUS_ALREADY_WIN32
//
// MessageText:
//
//  STATUS_ALREADY_WIN32
//
#define STATUS_ALREADY_WIN32             ((NTSTATUS)0x4000001BL)

//
// MessageId: STATUS_WX86_UNSIMULATE
//
// MessageText:
//
//  Exception status code used by Win32 x86 emulation subsystem.
//
#define STATUS_WX86_UNSIMULATE           ((NTSTATUS)0x4000001CL)

//
// MessageId: STATUS_WX86_CONTINUE
//
// MessageText:
//
//  Exception status code used by Win32 x86 emulation subsystem.
//
#define STATUS_WX86_CONTINUE             ((NTSTATUS)0x4000001DL)

//
// MessageId: STATUS_WX86_SINGLE_STEP
//
// MessageText:
//
//  Exception status code used by Win32 x86 emulation subsystem.
//
#define STATUS_WX86_SINGLE_STEP          ((NTSTATUS)0x4000001EL)

//
// MessageId: STATUS_WX86_BREAKPOINT
//
// MessageText:
//
//  Exception status code used by Win32 x86 emulation subsystem.
//
#define STATUS_WX86_BREAKPOINT           ((NTSTATUS)0x4000001FL)

//
// MessageId: STATUS_WX86_EXCEPTION_CONTINUE
//
// MessageText:
//
//  Exception status code used by Win32 x86 emulation subsystem.
//
#define STATUS_WX86_EXCEPTION_CONTINUE   ((NTSTATUS)0x40000020L)

//
// MessageId: STATUS_WX86_EXCEPTION_LASTCHANCE
//
// MessageText:
//
//  Exception status code used by Win32 x86 emulation subsystem.
//
#define STATUS_WX86_EXCEPTION_LASTCHANCE ((NTSTATUS)0x40000021L)

//
// MessageId: STATUS_WX86_EXCEPTION_CHAIN
//
// MessageText:
//
//  Exception status code used by Win32 x86 emulation subsystem.
//
#define STATUS_WX86_EXCEPTION_CHAIN      ((NTSTATUS)0x40000022L)

//
// MessageId: STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE
//
// MessageText:
//
//  {Machine Type Mismatch}
//  The image file %s is valid, but is for a machine type other than the current machine.
//
#define STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE ((NTSTATUS)0x40000023L)

//
// MessageId: STATUS_NO_YIELD_PERFORMED
//
// MessageText:
//
//  A yield execution was performed and no thread was available to run.
//
#define STATUS_NO_YIELD_PERFORMED        ((NTSTATUS)0x40000024L)

//
// MessageId: STATUS_TIMER_RESUME_IGNORED
//
// MessageText:
//
//  The resumeable flag to a timer API was ignored.
//
#define STATUS_TIMER_RESUME_IGNORED      ((NTSTATUS)0x40000025L)



/////////////////////////////////////////////////////////////////////////
//
// Standard Warning values
//
//
// Note:  Do NOT use the value 0x80000000L, as this is a non-portable value
//        for the NT_SUCCESS macro.  Warning values start with a code of 1.
//
/////////////////////////////////////////////////////////////////////////

//
// MessageId: STATUS_GUARD_PAGE_VIOLATION
//
// MessageText:
//
//  {EXCEPTION}
//  Guard Page Exception
//  A page of memory that marks the end of a data structure, such as a stack
//  or an array, has been accessed.
//
#define STATUS_GUARD_PAGE_VIOLATION      ((NTSTATUS)0x80000001L)    // winnt

//
// MessageId: STATUS_DATATYPE_MISALIGNMENT
//
// MessageText:
//
//  {EXCEPTION}
//  Alignment Fault
//  A datatype misalignment was detected in a load or store instruction.
//
#define STATUS_DATATYPE_MISALIGNMENT     ((NTSTATUS)0x80000002L)    // winnt

//
// MessageId: STATUS_BREAKPOINT
//
// MessageText:
//
//  {EXCEPTION}
//  Breakpoint
//  A breakpoint has been reached.
//
#define STATUS_BREAKPOINT                ((NTSTATUS)0x80000003L)    // winnt

//
// MessageId: STATUS_SINGLE_STEP
//
// MessageText:
//
//  {EXCEPTION}
//  Single Step
//  A single step or trace operation has just been completed.
//
#define STATUS_SINGLE_STEP               ((NTSTATUS)0x80000004L)    // winnt

//
// MessageId: STATUS_BUFFER_OVERFLOW
//
// MessageText:
//
//  {Buffer Overflow}
//  The data was too large to fit into the specified buffer.
//
#define STATUS_BUFFER_OVERFLOW           ((NTSTATUS)0x80000005L)

//
// MessageId: STATUS_NO_MORE_FILES
//
// MessageText:
//
//  {No More Files}
//  No more files were found which match the file specification.
//
#define STATUS_NO_MORE_FILES             ((NTSTATUS)0x80000006L)

//
// MessageId: STATUS_WAKE_SYSTEM_DEBUGGER
//
// MessageText:
//
//  {Kernel Debugger Awakened}
//  the system debugger was awakened by an interrupt.
//
#define STATUS_WAKE_SYSTEM_DEBUGGER      ((NTSTATUS)0x80000007L)

//
// MessageId: STATUS_HANDLES_CLOSED
//
// MessageText:
//
//  {Handles Closed}
//  Handles to objects have been automatically closed as a result of the
//  requested operation.
//
#define STATUS_HANDLES_CLOSED            ((NTSTATUS)0x8000000AL)

//
// MessageId: STATUS_NO_INHERITANCE
//
// MessageText:
//
//  {Non-Inheritable ACL}
//  An access control list (ACL) contains no components that can be inherited.
//
#define STATUS_NO_INHERITANCE            ((NTSTATUS)0x8000000BL)

//
// MessageId: STATUS_GUID_SUBSTITUTION_MADE
//
// MessageText:
//
//  {GUID Substitution}
//  During the translation of a global identifier (GUID) to a Windows NT
//  security ID (SID), no administratively-defined GUID prefix was found.
//  A substitute prefix was used, which will not compromise system security.
//  However, this may provide a more restrictive access than intended.
//
#define STATUS_GUID_SUBSTITUTION_MADE    ((NTSTATUS)0x8000000CL)

//
// MessageId: STATUS_PARTIAL_COPY
//
// MessageText:
//
//  {Partial Copy}
//  Due to protection conflicts not all the requested bytes could be
//  copied.
//
#define STATUS_PARTIAL_COPY              ((NTSTATUS)0x8000000DL)

//
// MessageId: STATUS_DEVICE_PAPER_EMPTY
//
// MessageText:
//
//  {Out of Paper}
//  The printer is out of paper.
//
#define STATUS_DEVICE_PAPER_EMPTY        ((NTSTATUS)0x8000000EL)

//
// MessageId: STATUS_DEVICE_POWERED_OFF
//
// MessageText:
//
//  {Device Power Is Off}
//  The printer power has been turned off.
//
#define STATUS_DEVICE_POWERED_OFF        ((NTSTATUS)0x8000000FL)

//
// MessageId: STATUS_DEVICE_OFF_LINE
//
// MessageText:
//
//  {Device Offline}
//  The printer has been taken offline.
//
#define STATUS_DEVICE_OFF_LINE           ((NTSTATUS)0x80000010L)

//
// MessageId: STATUS_DEVICE_BUSY
//
// MessageText:
//
//  {Device Busy}
//  The device is currently busy.
//
#define STATUS_DEVICE_BUSY               ((NTSTATUS)0x80000011L)

//
// MessageId: STATUS_NO_MORE_EAS
//
// MessageText:
//
//  {No More EAs}
//  No more extended attributes (EAs) were found for the file.
//
#define STATUS_NO_MORE_EAS               ((NTSTATUS)0x80000012L)

//
// MessageId: STATUS_INVALID_EA_NAME
//
// MessageText:
//
//  {Illegal EA}
//  The specified extended attribute (EA) name contains at least one illegal
//  character.
//
#define STATUS_INVALID_EA_NAME           ((NTSTATUS)0x80000013L)

//
// MessageId: STATUS_EA_LIST_INCONSISTENT
//
// MessageText:
//
//  {Inconsistent EA List}
//  The extended attribute (EA) list is inconsistent.
//
#define STATUS_EA_LIST_INCONSISTENT      ((NTSTATUS)0x80000014L)

//
// MessageId: STATUS_INVALID_EA_FLAG
//
// MessageText:
//
//  {Invalid EA Flag}
//  An invalid extended attribute (EA) flag was set.
//
#define STATUS_INVALID_EA_FLAG           ((NTSTATUS)0x80000015L)

//
// MessageId: STATUS_VERIFY_REQUIRED
//
// MessageText:
//
//  {Verifying Disk}
//  The media has changed and a verify operation is in progress so no
//  reads or writes may be performed to the device, except those used in
//  the verify operation.
//
#define STATUS_VERIFY_REQUIRED           ((NTSTATUS)0x80000016L)

//
// MessageId: STATUS_EXTRANEOUS_INFORMATION
//
// MessageText:
//
//  {Too Much Information}
//  The specified access control list (ACL) contained more information than
//  was expected.
//
#define STATUS_EXTRANEOUS_INFORMATION    ((NTSTATUS)0x80000017L)

//
// MessageId: STATUS_RXACT_COMMIT_NECESSARY
//
// MessageText:
//
//  This warning level status indicates that the transaction state already
//  exists for the registry sub-tree, but that a transaction commit was
//  previously aborted.  The commit has NOT been completed, but has not been
//  rolled back either (so it may still be committed if desired).
//  This status value is returned by the runtime library (RTL) registry
//  transaction package (RXact).
//
#define STATUS_RXACT_COMMIT_NECESSARY    ((NTSTATUS)0x80000018L)

//
// MessageId: STATUS_NO_MORE_ENTRIES
//
// MessageText:
//
//  {No More Entries}
//  No more entries are available from an enumeration operation.
//
#define STATUS_NO_MORE_ENTRIES           ((NTSTATUS)0x8000001AL)

//
// MessageId: STATUS_FILEMARK_DETECTED
//
// MessageText:
//
//  {Filemark Found}
//  A filemark was detected.
//
#define STATUS_FILEMARK_DETECTED         ((NTSTATUS)0x8000001BL)

//
// MessageId: STATUS_MEDIA_CHANGED
//
// MessageText:
//
//  {Media Changed}
//  The media may have changed.
//
#define STATUS_MEDIA_CHANGED             ((NTSTATUS)0x8000001CL)

//
// MessageId: STATUS_BUS_RESET
//
// MessageText:
//
//  {I/O Bus Reset}
//  An I/O bus reset was detected.
//
#define STATUS_BUS_RESET                 ((NTSTATUS)0x8000001DL)

//
// MessageId: STATUS_END_OF_MEDIA
//
// MessageText:
//
//  {End of Media}
//  The end of the media was encountered.
//
#define STATUS_END_OF_MEDIA              ((NTSTATUS)0x8000001EL)

//
// MessageId: STATUS_BEGINNING_OF_MEDIA
//
// MessageText:
//
//  Beginning of tape or partition has been detected.
//
#define STATUS_BEGINNING_OF_MEDIA        ((NTSTATUS)0x8000001FL)

//
// MessageId: STATUS_MEDIA_CHECK
//
// MessageText:
//
//  {Media Changed}
//  The media may have changed.
//
#define STATUS_MEDIA_CHECK               ((NTSTATUS)0x80000020L)

//
// MessageId: STATUS_SETMARK_DETECTED
//
// MessageText:
//
//  A tape access reached a setmark.
//
#define STATUS_SETMARK_DETECTED          ((NTSTATUS)0x80000021L)

//
// MessageId: STATUS_NO_DATA_DETECTED
//
// MessageText:
//
//  During a tape access, the end of the data written is reached.
//
#define STATUS_NO_DATA_DETECTED          ((NTSTATUS)0x80000022L)

//
// MessageId: STATUS_REDIRECTOR_HAS_OPEN_HANDLES
//
// MessageText:
//
//  The redirector is in use and cannot be unloaded.
//
#define STATUS_REDIRECTOR_HAS_OPEN_HANDLES ((NTSTATUS)0x80000023L)

//
// MessageId: STATUS_SERVER_HAS_OPEN_HANDLES
//
// MessageText:
//
//  The server is in use and cannot be unloaded.
//
#define STATUS_SERVER_HAS_OPEN_HANDLES   ((NTSTATUS)0x80000024L)

//
// MessageId: STATUS_ALREADY_DISCONNECTED
//
// MessageText:
//
//  The specified connection has already been disconnected.
//
#define STATUS_ALREADY_DISCONNECTED      ((NTSTATUS)0x80000025L)

//
// MessageId: STATUS_LONGJUMP
//
// MessageText:
//
//  A long jump has been executed.
//
#define STATUS_LONGJUMP                  ((NTSTATUS)0x80000026L)



/////////////////////////////////////////////////////////////////////////
//
//  Standard Error values
//
/////////////////////////////////////////////////////////////////////////

//
// MessageId: STATUS_UNSUCCESSFUL
//
// MessageText:
//
//  {Operation Failed}
//  The requested operation was unsuccessful.
//
#define STATUS_UNSUCCESSFUL              ((NTSTATUS)0xC0000001L)

//
// MessageId: STATUS_NOT_IMPLEMENTED
//
// MessageText:
//
//  {Not Implemented}
//  The requested operation is not implemented.
//
#define STATUS_NOT_IMPLEMENTED           ((NTSTATUS)0xC0000002L)

//
// MessageId: STATUS_INVALID_INFO_CLASS
//
// MessageText:
//
//  {Invalid Parameter}
//  The specified information class is not a valid information class for
//  the specified object.
//
#define STATUS_INVALID_INFO_CLASS        ((NTSTATUS)0xC0000003L)    // ntsubauth

//
// MessageId: STATUS_INFO_LENGTH_MISMATCH
//
// MessageText:
//
//  The specified information record length does not match the length
//  required for the specified information class.
//
#define STATUS_INFO_LENGTH_MISMATCH      ((NTSTATUS)0xC0000004L)

//
// MessageId: STATUS_ACCESS_VIOLATION
//
// MessageText:
//
//  The instruction at "0x%08lx" referenced memory at "0x%08lx". The memory
//  could not be "%s".
//
#define STATUS_ACCESS_VIOLATION          ((NTSTATUS)0xC0000005L)    // winnt ntsubauth

//
// MessageId: STATUS_IN_PAGE_ERROR
//
// MessageText:
//
//  The instruction at "0x%08lx" referenced memory at "0x%08lx". The required
//  data was not placed into memory because of an I/O error status of "0x%08lx".
//
#define STATUS_IN_PAGE_ERROR             ((NTSTATUS)0xC0000006L)    // winnt

//
// MessageId: STATUS_PAGEFILE_QUOTA
//
// MessageText:
//
//  The pagefile quota for the process has been exhausted.
//
#define STATUS_PAGEFILE_QUOTA            ((NTSTATUS)0xC0000007L)

//
// MessageId: STATUS_INVALID_HANDLE
//
// MessageText:
//
//  An invalid HANDLE was specified.
//
#define STATUS_INVALID_HANDLE            ((NTSTATUS)0xC0000008L)    // winnt

//
// MessageId: STATUS_BAD_INITIAL_STACK
//
// MessageText:
//
//  An invalid initial stack was specified in a call to NtCreateThread.
//
#define STATUS_BAD_INITIAL_STACK         ((NTSTATUS)0xC0000009L)

//
// MessageId: STATUS_BAD_INITIAL_PC
//
// MessageText:
//
//  An invalid initial start address was specified in a call to NtCreateThread.
//
#define STATUS_BAD_INITIAL_PC            ((NTSTATUS)0xC000000AL)

//
// MessageId: STATUS_INVALID_CID
//
// MessageText:
//
//  An invalid Client ID was specified.
//
#define STATUS_INVALID_CID               ((NTSTATUS)0xC000000BL)

//
// MessageId: STATUS_TIMER_NOT_CANCELED
//
// MessageText:
//
//  An attempt was made to cancel or set a timer that has an associated APC
//  and the subject thread is not the thread that originally set the timer
//  with an associated APC routine.
//
#define STATUS_TIMER_NOT_CANCELED        ((NTSTATUS)0xC000000CL)

//
// MessageId: STATUS_INVALID_PARAMETER
//
// MessageText:
//
//  An invalid parameter was passed to a service or function.
//
#define STATUS_INVALID_PARAMETER         ((NTSTATUS)0xC000000DL)

//
// MessageId: STATUS_NO_SUCH_DEVICE
//
// MessageText:
//
//  A device which does not exist was specified.
//
#define STATUS_NO_SUCH_DEVICE            ((NTSTATUS)0xC000000EL)

//
// MessageId: STATUS_NO_SUCH_FILE
//
// MessageText:
//
//  {File Not Found}
//  The file %s does not exist.
//
#define STATUS_NO_SUCH_FILE              ((NTSTATUS)0xC000000FL)

//
// MessageId: STATUS_INVALID_DEVICE_REQUEST
//
// MessageText:
//
//  The specified request is not a valid operation for the target device.
//
#define STATUS_INVALID_DEVICE_REQUEST    ((NTSTATUS)0xC0000010L)

//
// MessageId: STATUS_END_OF_FILE
//
// MessageText:
//
//  The end-of-file marker has been reached.  There is no valid data in the
//  file beyond this marker.
//
#define STATUS_END_OF_FILE               ((NTSTATUS)0xC0000011L)

//
// MessageId: STATUS_WRONG_VOLUME
//
// MessageText:
//
//  {Wrong Volume}
//  The wrong volume is in the drive.
//  Please insert volume %s into drive %s.
//
#define STATUS_WRONG_VOLUME              ((NTSTATUS)0xC0000012L)

//
// MessageId: STATUS_NO_MEDIA_IN_DEVICE
//
// MessageText:
//
//  {No Disk}
//  There is no disk in the drive.
//  Please insert a disk into drive %s.
//
#define STATUS_NO_MEDIA_IN_DEVICE        ((NTSTATUS)0xC0000013L)

//
// MessageId: STATUS_UNRECOGNIZED_MEDIA
//
// MessageText:
//
//  {Unknown Disk Format}
//  The disk in drive %s is not formatted properly.
//  Please check the disk, and reformat if necessary.
//
#define STATUS_UNRECOGNIZED_MEDIA        ((NTSTATUS)0xC0000014L)

//
// MessageId: STATUS_NONEXISTENT_SECTOR
//
// MessageText:
//
//  {Sector Not Found}
//  The specified sector does not exist.
//
#define STATUS_NONEXISTENT_SECTOR        ((NTSTATUS)0xC0000015L)

//
// MessageId: STATUS_MORE_PROCESSING_REQUIRED
//
// MessageText:
//
//  {Still Busy}
//  The specified I/O request packet (IRP) cannot be disposed of because the
//  I/O operation is not complete.
//
#define STATUS_MORE_PROCESSING_REQUIRED  ((NTSTATUS)0xC0000016L)

//
// MessageId: STATUS_NO_MEMORY
//
// MessageText:
//
//  {Not Enough Quota}
//  Not enough virtual memory or paging file quota is available to complete
//  the specified operation.
//
#define STATUS_NO_MEMORY                 ((NTSTATUS)0xC0000017L)    // winnt

//
// MessageId: STATUS_CONFLICTING_ADDRESSES
//
// MessageText:
//
//  {Conflicting Address Range}
//  The specified address range conflicts with the address space.
//
#define STATUS_CONFLICTING_ADDRESSES     ((NTSTATUS)0xC0000018L)

//
// MessageId: STATUS_NOT_MAPPED_VIEW
//
// MessageText:
//
//  Address range to unmap is not a mapped view.
//
#define STATUS_NOT_MAPPED_VIEW           ((NTSTATUS)0xC0000019L)

//
// MessageId: STATUS_UNABLE_TO_FREE_VM
//
// MessageText:
//
//  Virtual memory cannot be freed.
//
#define STATUS_UNABLE_TO_FREE_VM         ((NTSTATUS)0xC000001AL)

//
// MessageId: STATUS_UNABLE_TO_DELETE_SECTION
//
// MessageText:
//
//  Specified section cannot be deleted.
//
#define STATUS_UNABLE_TO_DELETE_SECTION  ((NTSTATUS)0xC000001BL)

//
// MessageId: STATUS_INVALID_SYSTEM_SERVICE
//
// MessageText:
//
//  An invalid system service was specified in a system service call.
//
#define STATUS_INVALID_SYSTEM_SERVICE    ((NTSTATUS)0xC000001CL)

//
// MessageId: STATUS_ILLEGAL_INSTRUCTION
//
// MessageText:
//
//  {EXCEPTION}
//  Illegal Instruction
//  An attempt was made to execute an illegal instruction.
//
#define STATUS_ILLEGAL_INSTRUCTION       ((NTSTATUS)0xC000001DL)    // winnt

//
// MessageId: STATUS_INVALID_LOCK_SEQUENCE
//
// MessageText:
//
//  {Invalid Lock Sequence}
//  An attempt was made to execute an invalid lock sequence.
//
#define STATUS_INVALID_LOCK_SEQUENCE     ((NTSTATUS)0xC000001EL)

//
// MessageId: STATUS_INVALID_VIEW_SIZE
//
// MessageText:
//
//  {Invalid Mapping}
//  An attempt was made to create a view for a section which is bigger
//  than the section.
//
#define STATUS_INVALID_VIEW_SIZE         ((NTSTATUS)0xC000001FL)

//
// MessageId: STATUS_INVALID_FILE_FOR_SECTION
//
// MessageText:
//
//  {Bad File}
//  The attributes of the specified mapping file for a section of memory
//  cannot be read.
//
#define STATUS_INVALID_FILE_FOR_SECTION  ((NTSTATUS)0xC0000020L)

//
// MessageId: STATUS_ALREADY_COMMITTED
//
// MessageText:
//
//  {Already Committed}
//  The specified address range is already committed.
//
#define STATUS_ALREADY_COMMITTED         ((NTSTATUS)0xC0000021L)

//
// MessageId: STATUS_ACCESS_DENIED
//
// MessageText:
//
//  {Access Denied}
//  A process has requested access to an object, but has not been granted
//  those access rights.
//
#define STATUS_ACCESS_DENIED             ((NTSTATUS)0xC0000022L)

//
// MessageId: STATUS_BUFFER_TOO_SMALL
//
// MessageText:
//
//  {Buffer Too Small}
//  The buffer is too small to contain the entry.  No information has been
//  written to the buffer.
//
#define STATUS_BUFFER_TOO_SMALL          ((NTSTATUS)0xC0000023L)

//
// MessageId: STATUS_OBJECT_TYPE_MISMATCH
//
// MessageText:
//
//  {Wrong Type}
//  There is a mismatch between the type of object required by the requested
//  operation and the type of object that is specified in the request.
//
#define STATUS_OBJECT_TYPE_MISMATCH      ((NTSTATUS)0xC0000024L)

//
// MessageId: STATUS_NONCONTINUABLE_EXCEPTION
//
// MessageText:
//
//  {EXCEPTION}
//  Cannot Continue
//  Windows NT cannot continue from this exception.
//
#define STATUS_NONCONTINUABLE_EXCEPTION  ((NTSTATUS)0xC0000025L)    // winnt

//
// MessageId: STATUS_INVALID_DISPOSITION
//
// MessageText:
//
//  An invalid exception disposition was returned by an exception handler.
//
#define STATUS_INVALID_DISPOSITION       ((NTSTATUS)0xC0000026L)    // winnt

//
// MessageId: STATUS_UNWIND
//
// MessageText:
//
//  Unwind exception code.
//
#define STATUS_UNWIND                    ((NTSTATUS)0xC0000027L)

//
// MessageId: STATUS_BAD_STACK
//
// MessageText:
//
//  An invalid or unaligned stack was encountered during an unwind operation.
//
#define STATUS_BAD_STACK                 ((NTSTATUS)0xC0000028L)

//
// MessageId: STATUS_INVALID_UNWIND_TARGET
//
// MessageText:
//
//  An invalid unwind target was encountered during an unwind operation.
//
#define STATUS_INVALID_UNWIND_TARGET     ((NTSTATUS)0xC0000029L)

//
// MessageId: STATUS_NOT_LOCKED
//
// MessageText:
//
//  An attempt was made to unlock a page of memory which was not locked.
//
#define STATUS_NOT_LOCKED                ((NTSTATUS)0xC000002AL)

//
// MessageId: STATUS_PARITY_ERROR
//
// MessageText:
//
//  Device parity error on I/O operation.
//
#define STATUS_PARITY_ERROR              ((NTSTATUS)0xC000002BL)

//
// MessageId: STATUS_UNABLE_TO_DECOMMIT_VM
//
// MessageText:
//
//  An attempt was made to decommit uncommitted virtual memory.
//
#define STATUS_UNABLE_TO_DECOMMIT_VM     ((NTSTATUS)0xC000002CL)

//
// MessageId: STATUS_NOT_COMMITTED
//
// MessageText:
//
//  An attempt was made to change the attributes on memory that
//  has not been committed.
//
#define STATUS_NOT_COMMITTED             ((NTSTATUS)0xC000002DL)

//
// MessageId: STATUS_INVALID_PORT_ATTRIBUTES
//
// MessageText:
//
//  Invalid Object Attributes specified to NtCreatePort or invalid
//  Port Attributes specified to NtConnectPort
//
#define STATUS_INVALID_PORT_ATTRIBUTES   ((NTSTATUS)0xC000002EL)

//
// MessageId: STATUS_PORT_MESSAGE_TOO_LONG
//
// MessageText:
//
//  Length of message passed to NtRequestPort or NtRequestWaitReplyPort
//  was longer than the maximum message allowed by the port.
//
#define STATUS_PORT_MESSAGE_TOO_LONG     ((NTSTATUS)0xC000002FL)

//
// MessageId: STATUS_INVALID_PARAMETER_MIX
//
// MessageText:
//
//  An invalid combination of parameters was specified.
//
#define STATUS_INVALID_PARAMETER_MIX     ((NTSTATUS)0xC0000030L)

//
// MessageId: STATUS_INVALID_QUOTA_LOWER
//
// MessageText:
//
//  An attempt was made to lower a quota limit below the current usage.
//
#define STATUS_INVALID_QUOTA_LOWER       ((NTSTATUS)0xC0000031L)

//
// MessageId: STATUS_DISK_CORRUPT_ERROR
//
// MessageText:
//
//  {Corrupt Disk}
//  The file system structure on the disk is corrupt and unusable.
//  Please run the Chkdsk utility on the volume %s.
//
#define STATUS_DISK_CORRUPT_ERROR        ((NTSTATUS)0xC0000032L)

//
// MessageId: STATUS_OBJECT_NAME_INVALID
//
// MessageText:
//
//  Object Name invalid.
//
#define STATUS_OBJECT_NAME_INVALID       ((NTSTATUS)0xC0000033L)

//
// MessageId: STATUS_OBJECT_NAME_NOT_FOUND
//
// MessageText:
//
//  Object Name not found.
//
#define STATUS_OBJECT_NAME_NOT_FOUND     ((NTSTATUS)0xC0000034L)

//
// MessageId: STATUS_OBJECT_NAME_COLLISION
//
// MessageText:
//
//  Object Name already exists.
//
#define STATUS_OBJECT_NAME_COLLISION     ((NTSTATUS)0xC0000035L)

//
// MessageId: STATUS_PORT_DISCONNECTED
//
// MessageText:
//
//  Attempt to send a message to a disconnected communication port.
//
#define STATUS_PORT_DISCONNECTED         ((NTSTATUS)0xC0000037L)

//
// MessageId: STATUS_DEVICE_ALREADY_ATTACHED
//
// MessageText:
//
//  An attempt was made to attach to a device that was already attached to
//  another device.
//
#define STATUS_DEVICE_ALREADY_ATTACHED   ((NTSTATUS)0xC0000038L)

//
// MessageId: STATUS_OBJECT_PATH_INVALID
//
// MessageText:
//
//  Object Path Component was not a directory object.
//
#define STATUS_OBJECT_PATH_INVALID       ((NTSTATUS)0xC0000039L)

//
// MessageId: STATUS_OBJECT_PATH_NOT_FOUND
//
// MessageText:
//
//  {Path Not Found}
//  The path %s does not exist.
//
#define STATUS_OBJECT_PATH_NOT_FOUND     ((NTSTATUS)0xC000003AL)

//
// MessageId: STATUS_OBJECT_PATH_SYNTAX_BAD
//
// MessageText:
//
//  Object Path Component was not a directory object.
//
#define STATUS_OBJECT_PATH_SYNTAX_BAD    ((NTSTATUS)0xC000003BL)

//
// MessageId: STATUS_DATA_OVERRUN
//
// MessageText:
//
//  {Data Overrun}
//  A data overrun error occurred.
//
#define STATUS_DATA_OVERRUN              ((NTSTATUS)0xC000003CL)

//
// MessageId: STATUS_DATA_LATE_ERROR
//
// MessageText:
//
//  {Data Late}
//  A data late error occurred.
//
#define STATUS_DATA_LATE_ERROR           ((NTSTATUS)0xC000003DL)

//
// MessageId: STATUS_DATA_ERROR
//
// MessageText:
//
//  {Data Error}
//  An error in reading or writing data occurred.
//
#define STATUS_DATA_ERROR                ((NTSTATUS)0xC000003EL)

//
// MessageId: STATUS_CRC_ERROR
//
// MessageText:
//
//  {Bad CRC}
//  A cyclic redundancy check (CRC) checksum error occurred.
//
#define STATUS_CRC_ERROR                 ((NTSTATUS)0xC000003FL)

//
// MessageId: STATUS_SECTION_TOO_BIG
//
// MessageText:
//
//  {Section Too Large}
//  The specified section is too big to map the file.
//
#define STATUS_SECTION_TOO_BIG           ((NTSTATUS)0xC0000040L)

//
// MessageId: STATUS_PORT_CONNECTION_REFUSED
//
// MessageText:
//
//  The NtConnectPort request is refused.
//
#define STATUS_PORT_CONNECTION_REFUSED   ((NTSTATUS)0xC0000041L)

//
// MessageId: STATUS_INVALID_PORT_HANDLE
//
// MessageText:
//
//  The type of port handle is invalid for the operation requested.
//
#define STATUS_INVALID_PORT_HANDLE       ((NTSTATUS)0xC0000042L)

//
// MessageId: STATUS_SHARING_VIOLATION
//
// MessageText:
//
//  A file cannot be opened because the share access flags are
//  incompatible.
//
#define STATUS_SHARING_VIOLATION         ((NTSTATUS)0xC0000043L)

//
// MessageId: STATUS_QUOTA_EXCEEDED
//
// MessageText:
//
//  Insufficient quota exists to complete the operation
//
#define STATUS_QUOTA_EXCEEDED            ((NTSTATUS)0xC0000044L)

//
// MessageId: STATUS_INVALID_PAGE_PROTECTION
//
// MessageText:
//
//  The specified page protection was not valid.
//
#define STATUS_INVALID_PAGE_PROTECTION   ((NTSTATUS)0xC0000045L)

//
// MessageId: STATUS_MUTANT_NOT_OWNED
//
// MessageText:
//
//  An attempt to release a mutant object was made by a thread that was not the
//  owner of the mutant object.
//
#define STATUS_MUTANT_NOT_OWNED          ((NTSTATUS)0xC0000046L)

//
// MessageId: STATUS_SEMAPHORE_LIMIT_EXCEEDED
//
// MessageText:
//
//  An attempt was made to release a semaphore such that its maximum count
//  would have been exceeded.
//
#define STATUS_SEMAPHORE_LIMIT_EXCEEDED  ((NTSTATUS)0xC0000047L)

//
// MessageId: STATUS_PORT_ALREADY_SET
//
// MessageText:
//
//  An attempt to set a processes DebugPort or ExceptionPort was made,
//  but a port already exists in the process.
//
#define STATUS_PORT_ALREADY_SET          ((NTSTATUS)0xC0000048L)

//
// MessageId: STATUS_SECTION_NOT_IMAGE
//
// MessageText:
//
//  An attempt was made to query image information on a section
//  which does not map an image.
//
#define STATUS_SECTION_NOT_IMAGE         ((NTSTATUS)0xC0000049L)

//
// MessageId: STATUS_SUSPEND_COUNT_EXCEEDED
//
// MessageText:
//
//  An attempt was made to suspend a thread whose suspend count
//  was at its maximum.
//
#define STATUS_SUSPEND_COUNT_EXCEEDED    ((NTSTATUS)0xC000004AL)

//
// MessageId: STATUS_THREAD_IS_TERMINATING
//
// MessageText:
//
//  An attempt was made to suspend a thread that has begun
//  termination.
//
#define STATUS_THREAD_IS_TERMINATING     ((NTSTATUS)0xC000004BL)

//
// MessageId: STATUS_BAD_WORKING_SET_LIMIT
//
// MessageText:
//
//  An attempt was made to set the working set limit to an
//  invalid value (minimum greater than maximum, etc).
//
#define STATUS_BAD_WORKING_SET_LIMIT     ((NTSTATUS)0xC000004CL)

//
// MessageId: STATUS_INCOMPATIBLE_FILE_MAP
//
// MessageText:
//
//  A section was created to map a file which is not compatible
//  to an already existing section which maps the same file.
//
#define STATUS_INCOMPATIBLE_FILE_MAP     ((NTSTATUS)0xC000004DL)

//
// MessageId: STATUS_SECTION_PROTECTION
//
// MessageText:
//
//  A view to a section specifies a protection which is incompatible
//  with the initial view's protection.
//
#define STATUS_SECTION_PROTECTION        ((NTSTATUS)0xC000004EL)

//
// MessageId: STATUS_EAS_NOT_SUPPORTED
//
// MessageText:
//
//  An operation involving EAs failed because the file system does not
//  support EAs.
//
#define STATUS_EAS_NOT_SUPPORTED         ((NTSTATUS)0xC000004FL)

//
// MessageId: STATUS_EA_TOO_LARGE
//
// MessageText:
//
//  An EA operation failed because EA set is too large.
//
#define STATUS_EA_TOO_LARGE              ((NTSTATUS)0xC0000050L)

//
// MessageId: STATUS_NONEXISTENT_EA_ENTRY
//
// MessageText:
//
//  An EA operation failed because the name or EA index is invalid.
//
#define STATUS_NONEXISTENT_EA_ENTRY      ((NTSTATUS)0xC0000051L)

//
// MessageId: STATUS_NO_EAS_ON_FILE
//
// MessageText:
//
//  The file for which EAs were requested has no EAs.
//
#define STATUS_NO_EAS_ON_FILE            ((NTSTATUS)0xC0000052L)

//
// MessageId: STATUS_EA_CORRUPT_ERROR
//
// MessageText:
//
//  The EA is corrupt and non-readable.
//
#define STATUS_EA_CORRUPT_ERROR          ((NTSTATUS)0xC0000053L)

//
// MessageId: STATUS_FILE_LOCK_CONFLICT
//
// MessageText:
//
//  A requested read/write cannot be granted due to a conflicting file lock.
//
#define STATUS_FILE_LOCK_CONFLICT        ((NTSTATUS)0xC0000054L)

//
// MessageId: STATUS_LOCK_NOT_GRANTED
//
// MessageText:
//
//  A requested file lock cannot be granted due to other existing locks.
//
#define STATUS_LOCK_NOT_GRANTED          ((NTSTATUS)0xC0000055L)

//
// MessageId: STATUS_DELETE_PENDING
//
// MessageText:
//
//  A non close operation has been requested of a file object with a
//  delete pending.
//
#define STATUS_DELETE_PENDING            ((NTSTATUS)0xC0000056L)

//
// MessageId: STATUS_CTL_FILE_NOT_SUPPORTED
//
// MessageText:
//
//  An attempt was made to set the control attribute on a file.  This
//  attribute is not supported in the target file system.
//
#define STATUS_CTL_FILE_NOT_SUPPORTED    ((NTSTATUS)0xC0000057L)

//
// MessageId: STATUS_UNKNOWN_REVISION
//
// MessageText:
//
//  Indicates a revision number encountered or specified is not one
//  known by the service.  It may be a more recent revision than the
//  service is aware of.
//
#define STATUS_UNKNOWN_REVISION          ((NTSTATUS)0xC0000058L)

//
// MessageId: STATUS_REVISION_MISMATCH
//
// MessageText:
//
//  Indicates two revision levels are incompatible.
//
#define STATUS_REVISION_MISMATCH         ((NTSTATUS)0xC0000059L)

//
// MessageId: STATUS_INVALID_OWNER
//
// MessageText:
//
//  Indicates a particular Security ID may not be assigned as the
//  owner of an object.
//
#define STATUS_INVALID_OWNER             ((NTSTATUS)0xC000005AL)

//
// MessageId: STATUS_INVALID_PRIMARY_GROUP
//
// MessageText:
//
//  Indicates a particular Security ID may not be assigned as the
//  primary group of an object.
//
#define STATUS_INVALID_PRIMARY_GROUP     ((NTSTATUS)0xC000005BL)

//
// MessageId: STATUS_NO_IMPERSONATION_TOKEN
//
// MessageText:
//
//  An attempt has been made to operate on an impersonation token
//  by a thread that is not currently impersonating a client.
//
#define STATUS_NO_IMPERSONATION_TOKEN    ((NTSTATUS)0xC000005CL)

//
// MessageId: STATUS_CANT_DISABLE_MANDATORY
//
// MessageText:
//
//  A mandatory group may not be disabled.
//
#define STATUS_CANT_DISABLE_MANDATORY    ((NTSTATUS)0xC000005DL)

//
// MessageId: STATUS_NO_LOGON_SERVERS
//
// MessageText:
//
//  There are currently no logon servers available to service the logon
//  request.
//
#define STATUS_NO_LOGON_SERVERS          ((NTSTATUS)0xC000005EL)

//
// MessageId: STATUS_NO_SUCH_LOGON_SESSION
//
// MessageText:
//
//   A specified logon session does not exist.  It may already have
//   been terminated.
//
#define STATUS_NO_SUCH_LOGON_SESSION     ((NTSTATUS)0xC000005FL)

//
// MessageId: STATUS_NO_SUCH_PRIVILEGE
//
// MessageText:
//
//   A specified privilege does not exist.
//
#define STATUS_NO_SUCH_PRIVILEGE         ((NTSTATUS)0xC0000060L)

//
// MessageId: STATUS_PRIVILEGE_NOT_HELD
//
// MessageText:
//
//   A required privilege is not held by the client.
//
#define STATUS_PRIVILEGE_NOT_HELD        ((NTSTATUS)0xC0000061L)

//
// MessageId: STATUS_INVALID_ACCOUNT_NAME
//
// MessageText:
//
//  The name provided is not a properly formed account name.
//
#define STATUS_INVALID_ACCOUNT_NAME      ((NTSTATUS)0xC0000062L)

//
// MessageId: STATUS_USER_EXISTS
//
// MessageText:
//
//  The specified user already exists.
//
#define STATUS_USER_EXISTS               ((NTSTATUS)0xC0000063L)

//
// MessageId: STATUS_NO_SUCH_USER
//
// MessageText:
//
//  The specified user does not exist.
//
#define STATUS_NO_SUCH_USER              ((NTSTATUS)0xC0000064L)     // ntsubauth

//
// MessageId: STATUS_GROUP_EXISTS
//
// MessageText:
//
//  The specified group already exists.
//
#define STATUS_GROUP_EXISTS              ((NTSTATUS)0xC0000065L)

//
// MessageId: STATUS_NO_SUCH_GROUP
//
// MessageText:
//
//  The specified group does not exist.
//
#define STATUS_NO_SUCH_GROUP             ((NTSTATUS)0xC0000066L)

//
// MessageId: STATUS_MEMBER_IN_GROUP
//
// MessageText:
//
//  The specified user account is already in the specified group account.
//  Also used to indicate a group cannot be deleted because it contains
//  a member.
//
#define STATUS_MEMBER_IN_GROUP           ((NTSTATUS)0xC0000067L)

//
// MessageId: STATUS_MEMBER_NOT_IN_GROUP
//
// MessageText:
//
//  The specified user account is not a member of the specified group account.
//
#define STATUS_MEMBER_NOT_IN_GROUP       ((NTSTATUS)0xC0000068L)

//
// MessageId: STATUS_LAST_ADMIN
//
// MessageText:
//
//  Indicates the requested operation would disable or delete the last
//  remaining administration account.  This is not allowed to prevent
//  creating a situation in which the system cannot be administrated.
//
#define STATUS_LAST_ADMIN                ((NTSTATUS)0xC0000069L)

//
// MessageId: STATUS_WRONG_PASSWORD
//
// MessageText:
//
//  When trying to update a password, this return status indicates that
//  the value provided as the current password is not correct.
//
#define STATUS_WRONG_PASSWORD            ((NTSTATUS)0xC000006AL)     // ntsubauth

//
// MessageId: STATUS_ILL_FORMED_PASSWORD
//
// MessageText:
//
//  When trying to update a password, this return status indicates that
//  the value provided for the new password contains values that are
//  not allowed in passwords.
//
#define STATUS_ILL_FORMED_PASSWORD       ((NTSTATUS)0xC000006BL)

//
// MessageId: STATUS_PASSWORD_RESTRICTION
//
// MessageText:
//
//  When trying to update a password, this status indicates that some
//  password update rule has been violated.  For example, the password
//  may not meet length criteria.
//
#define STATUS_PASSWORD_RESTRICTION      ((NTSTATUS)0xC000006CL)     // ntsubauth

//
// MessageId: STATUS_LOGON_FAILURE
//
// MessageText:
//
//  The attempted logon is invalid.  This is either due to a bad username
//  or authentication information.
//
#define STATUS_LOGON_FAILURE             ((NTSTATUS)0xC000006DL)     // ntsubauth

//
// MessageId: STATUS_ACCOUNT_RESTRICTION
//
// MessageText:
//
//  Indicates a referenced user name and authentication information are
//  valid, but some user account restriction has prevented successful
//  authentication (such as time-of-day restrictions).
//
#define STATUS_ACCOUNT_RESTRICTION       ((NTSTATUS)0xC000006EL)     // ntsubauth

//
// MessageId: STATUS_INVALID_LOGON_HOURS
//
// MessageText:
//
//  The user account has time restrictions and may not be logged onto
//  at this time.
//
#define STATUS_INVALID_LOGON_HOURS       ((NTSTATUS)0xC000006FL)     // ntsubauth

//
// MessageId: STATUS_INVALID_WORKSTATION
//
// MessageText:
//
//  The user account is restricted such that it may not be used to
//  log on from the source workstation.
//
#define STATUS_INVALID_WORKSTATION       ((NTSTATUS)0xC0000070L)     // ntsubauth

//
// MessageId: STATUS_PASSWORD_EXPIRED
//
// MessageText:
//
//  The user account's password has expired.
//
#define STATUS_PASSWORD_EXPIRED          ((NTSTATUS)0xC0000071L)     // ntsubauth

//
// MessageId: STATUS_ACCOUNT_DISABLED
//
// MessageText:
//
//  The referenced account is currently disabled and may not be logged on to.
//
#define STATUS_ACCOUNT_DISABLED          ((NTSTATUS)0xC0000072L)     // ntsubauth

//
// MessageId: STATUS_NONE_MAPPED
//
// MessageText:
//
//  None of the information to be translated has been translated.
//
#define STATUS_NONE_MAPPED               ((NTSTATUS)0xC0000073L)

//
// MessageId: STATUS_TOO_MANY_LUIDS_REQUESTED
//
// MessageText:
//
//  The number of LUIDs requested may not be allocated with a single
//  allocation.
//
#define STATUS_TOO_MANY_LUIDS_REQUESTED  ((NTSTATUS)0xC0000074L)

//
// MessageId: STATUS_LUIDS_EXHAUSTED
//
// MessageText:
//
//  Indicates there are no more LUIDs to allocate.
//
#define STATUS_LUIDS_EXHAUSTED           ((NTSTATUS)0xC0000075L)

//
// MessageId: STATUS_INVALID_SUB_AUTHORITY
//
// MessageText:
//
//  Indicates the sub-authority value is invalid for the particular use.
//
#define STATUS_INVALID_SUB_AUTHORITY     ((NTSTATUS)0xC0000076L)

//
// MessageId: STATUS_INVALID_ACL
//
// MessageText:
//
//  Indicates the ACL structure is not valid.
//
#define STATUS_INVALID_ACL               ((NTSTATUS)0xC0000077L)

//
// MessageId: STATUS_INVALID_SID
//
// MessageText:
//
//  Indicates the SID structure is not valid.
//
#define STATUS_INVALID_SID               ((NTSTATUS)0xC0000078L)

//
// MessageId: STATUS_INVALID_SECURITY_DESCR
//
// MessageText:
//
//  Indicates the SECURITY_DESCRIPTOR structure is not valid.
//
#define STATUS_INVALID_SECURITY_DESCR    ((NTSTATUS)0xC0000079L)

//
// MessageId: STATUS_PROCEDURE_NOT_FOUND
//
// MessageText:
//
//  Indicates the specified procedure address cannot be found in the
//  DLL.
//
#define STATUS_PROCEDURE_NOT_FOUND       ((NTSTATUS)0xC000007AL)

//
// MessageId: STATUS_INVALID_IMAGE_FORMAT
//
// MessageText:
//
//  {Bad Image}
//  The application or DLL %s is not a valid Windows NT image.
//  Please check this against your installation diskette.
//
#define STATUS_INVALID_IMAGE_FORMAT      ((NTSTATUS)0xC000007BL)

//
// MessageId: STATUS_NO_TOKEN
//
// MessageText:
//
//  An attempt was made to reference a token that doesn't exist.
//  This is typically done by referencing the token associated with a thread
//  when the thread is not impersonating a client.
//
#define STATUS_NO_TOKEN                  ((NTSTATUS)0xC000007CL)

//
// MessageId: STATUS_BAD_INHERITANCE_ACL
//
// MessageText:
//
//  Indicates that an attempt to build either an inherited ACL or ACE
//  was not successful.
//  This can be caused by a number of things.  One of the more probable
//  causes is the replacement of a CreatorId with an SID that didn't fit
//  into the ACE or ACL.
//
#define STATUS_BAD_INHERITANCE_ACL       ((NTSTATUS)0xC000007DL)

//
// MessageId: STATUS_RANGE_NOT_LOCKED
//
// MessageText:
//
//  The range specified in NtUnlockFile was not locked.
//
#define STATUS_RANGE_NOT_LOCKED          ((NTSTATUS)0xC000007EL)

//
// MessageId: STATUS_DISK_FULL
//
// MessageText:
//
//  An operation failed because the disk was full.
//
#define STATUS_DISK_FULL                 ((NTSTATUS)0xC000007FL)

//
// MessageId: STATUS_SERVER_DISABLED
//
// MessageText:
//
//  The GUID allocation server is [already] disabled at the moment.
//
#define STATUS_SERVER_DISABLED           ((NTSTATUS)0xC0000080L)

//
// MessageId: STATUS_SERVER_NOT_DISABLED
//
// MessageText:
//
//  The GUID allocation server is [already] enabled at the moment.
//
#define STATUS_SERVER_NOT_DISABLED       ((NTSTATUS)0xC0000081L)

//
// MessageId: STATUS_TOO_MANY_GUIDS_REQUESTED
//
// MessageText:
//
//  Too many GUIDs were requested from the allocation server at once.
//
#define STATUS_TOO_MANY_GUIDS_REQUESTED  ((NTSTATUS)0xC0000082L)

//
// MessageId: STATUS_GUIDS_EXHAUSTED
//
// MessageText:
//
//  The GUIDs could not be allocated because the Authority Agent was
//  exhausted.
//
#define STATUS_GUIDS_EXHAUSTED           ((NTSTATUS)0xC0000083L)

//
// MessageId: STATUS_INVALID_ID_AUTHORITY
//
// MessageText:
//
//  The value provided was an invalid value for an identifier authority.
//
#define STATUS_INVALID_ID_AUTHORITY      ((NTSTATUS)0xC0000084L)

//
// MessageId: STATUS_AGENTS_EXHAUSTED
//
// MessageText:
//
//  There are no more authority agent values available for the given
//  identifier authority value.
//
#define STATUS_AGENTS_EXHAUSTED          ((NTSTATUS)0xC0000085L)

//
// MessageId: STATUS_INVALID_VOLUME_LABEL
//
// MessageText:
//
//  An invalid volume label has been specified.
//
#define STATUS_INVALID_VOLUME_LABEL      ((NTSTATUS)0xC0000086L)

//
// MessageId: STATUS_SECTION_NOT_EXTENDED
//
// MessageText:
//
//  A mapped section could not be extended.
//
#define STATUS_SECTION_NOT_EXTENDED      ((NTSTATUS)0xC0000087L)

//
// MessageId: STATUS_NOT_MAPPED_DATA
//
// MessageText:
//
//  Specified section to flush does not map a data file.
//
#define STATUS_NOT_MAPPED_DATA           ((NTSTATUS)0xC0000088L)

//
// MessageId: STATUS_RESOURCE_DATA_NOT_FOUND
//
// MessageText:
//
//  Indicates the specified image file did not contain a resource
//  section.
//
#define STATUS_RESOURCE_DATA_NOT_FOUND   ((NTSTATUS)0xC0000089L)

//
// MessageId: STATUS_RESOURCE_TYPE_NOT_FOUND
//
// MessageText:
//
//  Indicates the specified resource type cannot be found in the
//  image file.
//
#define STATUS_RESOURCE_TYPE_NOT_FOUND   ((NTSTATUS)0xC000008AL)

//
// MessageId: STATUS_RESOURCE_NAME_NOT_FOUND
//
// MessageText:
//
//  Indicates the specified resource name cannot be found in the
//  image file.
//
#define STATUS_RESOURCE_NAME_NOT_FOUND   ((NTSTATUS)0xC000008BL)

//
// MessageId: STATUS_ARRAY_BOUNDS_EXCEEDED
//
// MessageText:
//
//  {EXCEPTION}
//  Array bounds exceeded.
//
#define STATUS_ARRAY_BOUNDS_EXCEEDED     ((NTSTATUS)0xC000008CL)    // winnt

//
// MessageId: STATUS_FLOAT_DENORMAL_OPERAND
//
// MessageText:
//
//  {EXCEPTION}
//  Floating-point denormal operand.
//
#define STATUS_FLOAT_DENORMAL_OPERAND    ((NTSTATUS)0xC000008DL)    // winnt

//
// MessageId: STATUS_FLOAT_DIVIDE_BY_ZERO
//
// MessageText:
//
//  {EXCEPTION}
//  Floating-point division by zero.
//
#define STATUS_FLOAT_DIVIDE_BY_ZERO      ((NTSTATUS)0xC000008EL)    // winnt

//
// MessageId: STATUS_FLOAT_INEXACT_RESULT
//
// MessageText:
//
//  {EXCEPTION}
//  Floating-point inexact result.
//
#define STATUS_FLOAT_INEXACT_RESULT      ((NTSTATUS)0xC000008FL)    // winnt

//
// MessageId: STATUS_FLOAT_INVALID_OPERATION
//
// MessageText:
//
//  {EXCEPTION}
//  Floating-point invalid operation.
//
#define STATUS_FLOAT_INVALID_OPERATION   ((NTSTATUS)0xC0000090L)    // winnt

//
// MessageId: STATUS_FLOAT_OVERFLOW
//
// MessageText:
//
//  {EXCEPTION}
//  Floating-point overflow.
//
#define STATUS_FLOAT_OVERFLOW            ((NTSTATUS)0xC0000091L)    // winnt

//
// MessageId: STATUS_FLOAT_STACK_CHECK
//
// MessageText:
//
//  {EXCEPTION}
//  Floating-point stack check.
//
#define STATUS_FLOAT_STACK_CHECK         ((NTSTATUS)0xC0000092L)    // winnt

//
// MessageId: STATUS_FLOAT_UNDERFLOW
//
// MessageText:
//
//  {EXCEPTION}
//  Floating-point underflow.
//
#define STATUS_FLOAT_UNDERFLOW           ((NTSTATUS)0xC0000093L)    // winnt

//
// MessageId: STATUS_INTEGER_DIVIDE_BY_ZERO
//
// MessageText:
//
//  {EXCEPTION}
//  Integer division by zero.
//
#define STATUS_INTEGER_DIVIDE_BY_ZERO    ((NTSTATUS)0xC0000094L)    // winnt

//
// MessageId: STATUS_INTEGER_OVERFLOW
//
// MessageText:
//
//  {EXCEPTION}
//  Integer overflow.
//
#define STATUS_INTEGER_OVERFLOW          ((NTSTATUS)0xC0000095L)    // winnt

//
// MessageId: STATUS_PRIVILEGED_INSTRUCTION
//
// MessageText:
//
//  {EXCEPTION}
//  Privileged instruction.
//
#define STATUS_PRIVILEGED_INSTRUCTION    ((NTSTATUS)0xC0000096L)    // winnt

//
// MessageId: STATUS_TOO_MANY_PAGING_FILES
//
// MessageText:
//
//  An attempt was made to install more paging files than the
//  system supports.
//
#define STATUS_TOO_MANY_PAGING_FILES     ((NTSTATUS)0xC0000097L)

//
// MessageId: STATUS_FILE_INVALID
//
// MessageText:
//
//  The volume for a file has been externally altered such that the
//  opened file is no longer valid.
//
#define STATUS_FILE_INVALID              ((NTSTATUS)0xC0000098L)

//
// MessageId: STATUS_ALLOTTED_SPACE_EXCEEDED
//
// MessageText:
//
//  When a block of memory is allotted for future updates, such as the memory
//  allocated to hold discretionary access control and primary group information,
//  successive updates may exceed the amount of memory originally allotted.
//  Since quota may already have been charged to several processes which have
//  handles to the object, it is not reasonable to alter the size of the
//  allocated memory.  Instead, a request that requires more memory than has
//  been allotted must fail and the STATUS_ALLOTED_SPACE_EXCEEDED error returned.
//
#define STATUS_ALLOTTED_SPACE_EXCEEDED   ((NTSTATUS)0xC0000099L)

//
// MessageId: STATUS_INSUFFICIENT_RESOURCES
//
// MessageText:
//
//  Insufficient system resources exist to complete the API.
//
#define STATUS_INSUFFICIENT_RESOURCES    ((NTSTATUS)0xC000009AL)     // ntsubauth

//
// MessageId: STATUS_DFS_EXIT_PATH_FOUND
//
// MessageText:
//
//  An attempt has been made to open a DFS exit path control file.
//
#define STATUS_DFS_EXIT_PATH_FOUND       ((NTSTATUS)0xC000009BL)

//
// MessageId: STATUS_DEVICE_DATA_ERROR
//
// MessageText:
//
//  STATUS_DEVICE_DATA_ERROR
//
#define STATUS_DEVICE_DATA_ERROR         ((NTSTATUS)0xC000009CL)

//
// MessageId: STATUS_DEVICE_NOT_CONNECTED
//
// MessageText:
//
//  STATUS_DEVICE_NOT_CONNECTED
//
#define STATUS_DEVICE_NOT_CONNECTED      ((NTSTATUS)0xC000009DL)

//
// MessageId: STATUS_DEVICE_POWER_FAILURE
//
// MessageText:
//
//  STATUS_DEVICE_POWER_FAILURE
//
#define STATUS_DEVICE_POWER_FAILURE      ((NTSTATUS)0xC000009EL)

//
// MessageId: STATUS_FREE_VM_NOT_AT_BASE
//
// MessageText:
//
//  Virtual memory cannot be freed as base address is not the base
//  of the region and a region size of zero was specified.
//
#define STATUS_FREE_VM_NOT_AT_BASE       ((NTSTATUS)0xC000009FL)

//
// MessageId: STATUS_MEMORY_NOT_ALLOCATED
//
// MessageText:
//
//  An attempt was made to free virtual memory which is not allocated.
//
#define STATUS_MEMORY_NOT_ALLOCATED      ((NTSTATUS)0xC00000A0L)

//
// MessageId: STATUS_WORKING_SET_QUOTA
//
// MessageText:
//
//  The working set is not big enough to allow the requested pages to be
//  locked.
//
#define STATUS_WORKING_SET_QUOTA         ((NTSTATUS)0xC00000A1L)

//
// MessageId: STATUS_MEDIA_WRITE_PROTECTED
//
// MessageText:
//
//  {Write Protect Error}
//  The disk cannot be written to because it is write protected.
//  Please remove the write protection from the volume %s in drive %s.
//
#define STATUS_MEDIA_WRITE_PROTECTED     ((NTSTATUS)0xC00000A2L)

//
// MessageId: STATUS_DEVICE_NOT_READY
//
// MessageText:
//
//  {Drive Not Ready}
//  The drive is not ready for use; its door may be open.
//  Please check drive %s and make sure that a disk is inserted
//  and that the drive door is closed.
//
#define STATUS_DEVICE_NOT_READY          ((NTSTATUS)0xC00000A3L)

//
// MessageId: STATUS_INVALID_GROUP_ATTRIBUTES
//
// MessageText:
//
//  The specified attributes are invalid, or incompatible with the
//  attributes for the group as a whole.
//
#define STATUS_INVALID_GROUP_ATTRIBUTES  ((NTSTATUS)0xC00000A4L)

//
// MessageId: STATUS_BAD_IMPERSONATION_LEVEL
//
// MessageText:
//
//  A specified impersonation level is invalid.
//  Also used to indicate a required impersonation level was not provided.
//
#define STATUS_BAD_IMPERSONATION_LEVEL   ((NTSTATUS)0xC00000A5L)

//
// MessageId: STATUS_CANT_OPEN_ANONYMOUS
//
// MessageText:
//
//  An attempt was made to open an Anonymous level token.
//  Anonymous tokens may not be opened.
//
#define STATUS_CANT_OPEN_ANONYMOUS       ((NTSTATUS)0xC00000A6L)

//
// MessageId: STATUS_BAD_VALIDATION_CLASS
//
// MessageText:
//
//  The validation information class requested was invalid.
//
#define STATUS_BAD_VALIDATION_CLASS      ((NTSTATUS)0xC00000A7L)

//
// MessageId: STATUS_BAD_TOKEN_TYPE
//
// MessageText:
//
//  The type of a token object is inappropriate for its attempted use.
//
#define STATUS_BAD_TOKEN_TYPE            ((NTSTATUS)0xC00000A8L)

//
// MessageId: STATUS_BAD_MASTER_BOOT_RECORD
//
// MessageText:
//
//  The type of a token object is inappropriate for its attempted use.
//
#define STATUS_BAD_MASTER_BOOT_RECORD    ((NTSTATUS)0xC00000A9L)

//
// MessageId: STATUS_INSTRUCTION_MISALIGNMENT
//
// MessageText:
//
//  An attempt was made to execute an instruction at an unaligned address
//  and the host system does not support unaligned instruction references.
//
#define STATUS_INSTRUCTION_MISALIGNMENT  ((NTSTATUS)0xC00000AAL)

//
// MessageId: STATUS_INSTANCE_NOT_AVAILABLE
//
// MessageText:
//
//  The maximum named pipe instance count has been reached.
//
#define STATUS_INSTANCE_NOT_AVAILABLE    ((NTSTATUS)0xC00000ABL)

//
// MessageId: STATUS_PIPE_NOT_AVAILABLE
//
// MessageText:
//
//  An instance of a named pipe cannot be found in the listening state.
//
#define STATUS_PIPE_NOT_AVAILABLE        ((NTSTATUS)0xC00000ACL)

//
// MessageId: STATUS_INVALID_PIPE_STATE
//
// MessageText:
//
//  The named pipe is not in the connected or closing state.
//
#define STATUS_INVALID_PIPE_STATE        ((NTSTATUS)0xC00000ADL)

//
// MessageId: STATUS_PIPE_BUSY
//
// MessageText:
//
//  The specified pipe is set to complete operations and there are current
//  I/O operations queued so it cannot be changed to queue operations.
//
#define STATUS_PIPE_BUSY                 ((NTSTATUS)0xC00000AEL)

//
// MessageId: STATUS_ILLEGAL_FUNCTION
//
// MessageText:
//
//  The specified handle is not open to the server end of the named pipe.
//
#define STATUS_ILLEGAL_FUNCTION          ((NTSTATUS)0xC00000AFL)

//
// MessageId: STATUS_PIPE_DISCONNECTED
//
// MessageText:
//
//  The specified named pipe is in the disconnected state.
//
#define STATUS_PIPE_DISCONNECTED         ((NTSTATUS)0xC00000B0L)

//
// MessageId: STATUS_PIPE_CLOSING
//
// MessageText:
//
//  The specified named pipe is in the closing state.
//
#define STATUS_PIPE_CLOSING              ((NTSTATUS)0xC00000B1L)

//
// MessageId: STATUS_PIPE_CONNECTED
//
// MessageText:
//
//  The specified named pipe is in the connected state.
//
#define STATUS_PIPE_CONNECTED            ((NTSTATUS)0xC00000B2L)

//
// MessageId: STATUS_PIPE_LISTENING
//
// MessageText:
//
//  The specified named pipe is in the listening state.
//
#define STATUS_PIPE_LISTENING            ((NTSTATUS)0xC00000B3L)

//
// MessageId: STATUS_INVALID_READ_MODE
//
// MessageText:
//
//  The specified named pipe is not in message mode.
//
#define STATUS_INVALID_READ_MODE         ((NTSTATUS)0xC00000B4L)

//
// MessageId: STATUS_IO_TIMEOUT
//
// MessageText:
//
//  {Device Timeout}
//  The specified I/O operation on %s was not completed before the time-out
//  period expired.
//
#define STATUS_IO_TIMEOUT                ((NTSTATUS)0xC00000B5L)

//
// MessageId: STATUS_FILE_FORCED_CLOSED
//
// MessageText:
//
//  The specified file has been closed by another process.
//
#define STATUS_FILE_FORCED_CLOSED        ((NTSTATUS)0xC00000B6L)

//
// MessageId: STATUS_PROFILING_NOT_STARTED
//
// MessageText:
//
//  Profiling not started.
//
#define STATUS_PROFILING_NOT_STARTED     ((NTSTATUS)0xC00000B7L)

//
// MessageId: STATUS_PROFILING_NOT_STOPPED
//
// MessageText:
//
//  Profiling not stopped.
//
#define STATUS_PROFILING_NOT_STOPPED     ((NTSTATUS)0xC00000B8L)

//
// MessageId: STATUS_COULD_NOT_INTERPRET
//
// MessageText:
//
//  The passed ACL did not contain the minimum required information.
//
#define STATUS_COULD_NOT_INTERPRET       ((NTSTATUS)0xC00000B9L)

//
// MessageId: STATUS_FILE_IS_A_DIRECTORY
//
// MessageText:
//
//  The file that was specified as a target is a directory and the caller
//  specified that it could be anything but a directory.
//
#define STATUS_FILE_IS_A_DIRECTORY       ((NTSTATUS)0xC00000BAL)

//
// Network specific errors.
//
//
//
// MessageId: STATUS_NOT_SUPPORTED
//
// MessageText:
//
//  The network request is not supported.
//
#define STATUS_NOT_SUPPORTED             ((NTSTATUS)0xC00000BBL)

//
// MessageId: STATUS_REMOTE_NOT_LISTENING
//
// MessageText:
//
//  This remote computer is not listening.
//
#define STATUS_REMOTE_NOT_LISTENING      ((NTSTATUS)0xC00000BCL)

//
// MessageId: STATUS_DUPLICATE_NAME
//
// MessageText:
//
//  A duplicate name exists on the network.
//
#define STATUS_DUPLICATE_NAME            ((NTSTATUS)0xC00000BDL)

//
// MessageId: STATUS_BAD_NETWORK_PATH
//
// MessageText:
//
//  The network path cannot be located.
//
#define STATUS_BAD_NETWORK_PATH          ((NTSTATUS)0xC00000BEL)

//
// MessageId: STATUS_NETWORK_BUSY
//
// MessageText:
//
//  The network is busy.
//
#define STATUS_NETWORK_BUSY              ((NTSTATUS)0xC00000BFL)

//
// MessageId: STATUS_DEVICE_DOES_NOT_EXIST
//
// MessageText:
//
//  This device does not exist.
//
#define STATUS_DEVICE_DOES_NOT_EXIST     ((NTSTATUS)0xC00000C0L)

//
// MessageId: STATUS_TOO_MANY_COMMANDS
//
// MessageText:
//
//  The network BIOS command limit has been reached.
//
#define STATUS_TOO_MANY_COMMANDS         ((NTSTATUS)0xC00000C1L)

//
// MessageId: STATUS_ADAPTER_HARDWARE_ERROR
//
// MessageText:
//
//  An I/O adapter hardware error has occurred.
//
#define STATUS_ADAPTER_HARDWARE_ERROR    ((NTSTATUS)0xC00000C2L)

//
// MessageId: STATUS_INVALID_NETWORK_RESPONSE
//
// MessageText:
//
//  The network responded incorrectly.
//
#define STATUS_INVALID_NETWORK_RESPONSE  ((NTSTATUS)0xC00000C3L)

//
// MessageId: STATUS_UNEXPECTED_NETWORK_ERROR
//
// MessageText:
//
//  An unexpected network error occurred.
//
#define STATUS_UNEXPECTED_NETWORK_ERROR  ((NTSTATUS)0xC00000C4L)

//
// MessageId: STATUS_BAD_REMOTE_ADAPTER
//
// MessageText:
//
//  The remote adapter is not compatible.
//
#define STATUS_BAD_REMOTE_ADAPTER        ((NTSTATUS)0xC00000C5L)

//
// MessageId: STATUS_PRINT_QUEUE_FULL
//
// MessageText:
//
//  The printer queue is full.
//
#define STATUS_PRINT_QUEUE_FULL          ((NTSTATUS)0xC00000C6L)

//
// MessageId: STATUS_NO_SPOOL_SPACE
//
// MessageText:
//
//  Space to store the file waiting to be printed is not available on the server.
//
#define STATUS_NO_SPOOL_SPACE            ((NTSTATUS)0xC00000C7L)

//
// MessageId: STATUS_PRINT_CANCELLED
//
// MessageText:
//
//  The requested print file has been canceled.
//
#define STATUS_PRINT_CANCELLED           ((NTSTATUS)0xC00000C8L)

//
// MessageId: STATUS_NETWORK_NAME_DELETED
//
// MessageText:
//
//  The network name was deleted.
//
#define STATUS_NETWORK_NAME_DELETED      ((NTSTATUS)0xC00000C9L)

//
// MessageId: STATUS_NETWORK_ACCESS_DENIED
//
// MessageText:
//
//  Network access is denied.
//
#define STATUS_NETWORK_ACCESS_DENIED     ((NTSTATUS)0xC00000CAL)

//
// MessageId: STATUS_BAD_DEVICE_TYPE
//
// MessageText:
//
//  {Incorrect Network Resource Type}
//  The specified device type (LPT, for example) conflicts with the actual
//  device type on the remote resource.
//
#define STATUS_BAD_DEVICE_TYPE           ((NTSTATUS)0xC00000CBL)

//
// MessageId: STATUS_BAD_NETWORK_NAME
//
// MessageText:
//
//  {Network Name Not Found}
//  The specified share name cannot be found on the remote server.
//
#define STATUS_BAD_NETWORK_NAME          ((NTSTATUS)0xC00000CCL)

//
// MessageId: STATUS_TOO_MANY_NAMES
//
// MessageText:
//
//  The name limit for the local computer network adapter card was exceeded.
//
#define STATUS_TOO_MANY_NAMES            ((NTSTATUS)0xC00000CDL)

//
// MessageId: STATUS_TOO_MANY_SESSIONS
//
// MessageText:
//
//  The network BIOS session limit was exceeded.
//
#define STATUS_TOO_MANY_SESSIONS         ((NTSTATUS)0xC00000CEL)

//
// MessageId: STATUS_SHARING_PAUSED
//
// MessageText:
//
//  File sharing has been temporarily paused.
//
#define STATUS_SHARING_PAUSED            ((NTSTATUS)0xC00000CFL)

//
// MessageId: STATUS_REQUEST_NOT_ACCEPTED
//
// MessageText:
//
//  No more connections can be made to this remote computer at this time
//  because there are already as many connections as the computer can accept.
//
#define STATUS_REQUEST_NOT_ACCEPTED      ((NTSTATUS)0xC00000D0L)

//
// MessageId: STATUS_REDIRECTOR_PAUSED
//
// MessageText:
//
//  Print or disk redirection is temporarily paused.
//
#define STATUS_REDIRECTOR_PAUSED         ((NTSTATUS)0xC00000D1L)

//
// MessageId: STATUS_NET_WRITE_FAULT
//
// MessageText:
//
//  A network data fault occurred.
//
#define STATUS_NET_WRITE_FAULT           ((NTSTATUS)0xC00000D2L)

//
// MessageId: STATUS_PROFILING_AT_LIMIT
//
// MessageText:
//
//  The number of active profiling objects is at the maximum and no more may be started.
//
#define STATUS_PROFILING_AT_LIMIT        ((NTSTATUS)0xC00000D3L)

//
// MessageId: STATUS_NOT_SAME_DEVICE
//
// MessageText:
//
//  {Incorrect Volume}
//  The target file of a rename request is located on a different device
//  than the source of the rename request.
//
#define STATUS_NOT_SAME_DEVICE           ((NTSTATUS)0xC00000D4L)

//
// MessageId: STATUS_FILE_RENAMED
//
// MessageText:
//
//  The file specified has been renamed and thus cannot be modified.
//
#define STATUS_FILE_RENAMED              ((NTSTATUS)0xC00000D5L)

//
// MessageId: STATUS_VIRTUAL_CIRCUIT_CLOSED
//
// MessageText:
//
//  {Network Request Timeout}
//  The session with a remote server has been disconnected because the time-out
//  interval for a request has expired.
//
#define STATUS_VIRTUAL_CIRCUIT_CLOSED    ((NTSTATUS)0xC00000D6L)

//
// MessageId: STATUS_NO_SECURITY_ON_OBJECT
//
// MessageText:
//
//  Indicates an attempt was made to operate on the security of
//  an object that does not have security associated with it.
//
#define STATUS_NO_SECURITY_ON_OBJECT     ((NTSTATUS)0xC00000D7L)

//
// MessageId: STATUS_CANT_WAIT
//
// MessageText:
//
//  Used to indicate that an operation cannot continue without blocking
//  for I/O.
//
#define STATUS_CANT_WAIT                 ((NTSTATUS)0xC00000D8L)

//
// MessageId: STATUS_PIPE_EMPTY
//
// MessageText:
//
//  Used to indicate that a read operation was done on an empty pipe.
//
#define STATUS_PIPE_EMPTY                ((NTSTATUS)0xC00000D9L)

//
// MessageId: STATUS_CANT_ACCESS_DOMAIN_INFO
//
// MessageText:
//
//  Indicates a Windows NT Server could not be contacted or that
//  objects within the domain are protected such that necessary
//  information could not be retrieved.
//
#define STATUS_CANT_ACCESS_DOMAIN_INFO   ((NTSTATUS)0xC00000DAL)

//
// MessageId: STATUS_CANT_TERMINATE_SELF
//
// MessageText:
//
//  Indicates that a thread attempted to terminate itself by default
//  (called NtTerminateThread with NULL) and it was the last thread
//  in the current process.
//
#define STATUS_CANT_TERMINATE_SELF       ((NTSTATUS)0xC00000DBL)

//
// MessageId: STATUS_INVALID_SERVER_STATE
//
// MessageText:
//
//  Indicates the Sam Server was in the wrong state to
//  perform the desired operation.
//
#define STATUS_INVALID_SERVER_STATE      ((NTSTATUS)0xC00000DCL)

//
// MessageId: STATUS_INVALID_DOMAIN_STATE
//
// MessageText:
//
//  Indicates the Domain was in the wrong state to
//  perform the desired operation.
//
#define STATUS_INVALID_DOMAIN_STATE      ((NTSTATUS)0xC00000DDL)

//
// MessageId: STATUS_INVALID_DOMAIN_ROLE
//
// MessageText:
//
//  This operation is only allowed for the Primary Domain Controller of the domain.
//
#define STATUS_INVALID_DOMAIN_ROLE       ((NTSTATUS)0xC00000DEL)

//
// MessageId: STATUS_NO_SUCH_DOMAIN
//
// MessageText:
//
//  The specified Domain did not exist.
//
#define STATUS_NO_SUCH_DOMAIN            ((NTSTATUS)0xC00000DFL)

//
// MessageId: STATUS_DOMAIN_EXISTS
//
// MessageText:
//
//  The specified Domain already exists.
//
#define STATUS_DOMAIN_EXISTS             ((NTSTATUS)0xC00000E0L)

//
// MessageId: STATUS_DOMAIN_LIMIT_EXCEEDED
//
// MessageText:
//
//  An attempt was made to exceed the limit on the number of domains per server
//  for this release.
//
#define STATUS_DOMAIN_LIMIT_EXCEEDED     ((NTSTATUS)0xC00000E1L)

//
// MessageId: STATUS_OPLOCK_NOT_GRANTED
//
// MessageText:
//
//  Error status returned when oplock request is denied.
//
#define STATUS_OPLOCK_NOT_GRANTED        ((NTSTATUS)0xC00000E2L)

//
// MessageId: STATUS_INVALID_OPLOCK_PROTOCOL
//
// MessageText:
//
//  Error status returned when an invalid oplock acknowledgment
//  is received by a file system.
//
#define STATUS_INVALID_OPLOCK_PROTOCOL   ((NTSTATUS)0xC00000E3L)

//
// MessageId: STATUS_INTERNAL_DB_CORRUPTION
//
// MessageText:
//
//  This error indicates that the requested operation cannot be
//  completed due to a catastrophic media failure or on-disk data
//  structure corruption.
//
#define STATUS_INTERNAL_DB_CORRUPTION    ((NTSTATUS)0xC00000E4L)

//
// MessageId: STATUS_INTERNAL_ERROR
//
// MessageText:
//
//  This error indicates that the SAM server has encountered an
//  internal consistency error in its database.  This catastrophic
//  failure will prevent further operation of SAM.
//
#define STATUS_INTERNAL_ERROR            ((NTSTATUS)0xC00000E5L)

//
// MessageId: STATUS_GENERIC_NOT_MAPPED
//
// MessageText:
//
//  Indicates generic access types were contained in an access mask
//  which should already be mapped to non-generic access types.
//
#define STATUS_GENERIC_NOT_MAPPED        ((NTSTATUS)0xC00000E6L)

//
// MessageId: STATUS_BAD_DESCRIPTOR_FORMAT
//
// MessageText:
//
//  Indicates a security descriptor is not in the necessary format (absolute
//  or self-relative).
//
#define STATUS_BAD_DESCRIPTOR_FORMAT     ((NTSTATUS)0xC00000E7L)

//
// Status codes raised by the Cache Manager which must be considered as
// "expected" by its callers.
//
//
// MessageId: STATUS_INVALID_USER_BUFFER
//
// MessageText:
//
//  An access to a user buffer failed at an "expected" point in time.
//  This code is defined since the caller does not want to accept
//  STATUS_ACCESS_VIOLATION in its filter.
//
#define STATUS_INVALID_USER_BUFFER       ((NTSTATUS)0xC00000E8L)

//
// MessageId: STATUS_UNEXPECTED_IO_ERROR
//
// MessageText:
//
//  If an I/O error is returned which is not defined in the standard FsRtl filter,
//  it is converted to the following error which is guaranteed to be in the
//  filter.  In this case information is lost, however, the filter correctly
//  handles the exception.
//
#define STATUS_UNEXPECTED_IO_ERROR       ((NTSTATUS)0xC00000E9L)

//
// MessageId: STATUS_UNEXPECTED_MM_CREATE_ERR
//
// MessageText:
//
//  If an MM error is returned which is not defined in the standard FsRtl filter,
//  it is converted to one of the following errors which is guaranteed to be in the
//  filter.  In this case information is lost, however, the filter correctly
//  handles the exception.
//
#define STATUS_UNEXPECTED_MM_CREATE_ERR  ((NTSTATUS)0xC00000EAL)

//
// MessageId: STATUS_UNEXPECTED_MM_MAP_ERROR
//
// MessageText:
//
//  If an MM error is returned which is not defined in the standard FsRtl filter,
//  it is converted to one of the following errors which is guaranteed to be in the
//  filter.  In this case information is lost, however, the filter correctly
//  handles the exception.
//
#define STATUS_UNEXPECTED_MM_MAP_ERROR   ((NTSTATUS)0xC00000EBL)

//
// MessageId: STATUS_UNEXPECTED_MM_EXTEND_ERR
//
// MessageText:
//
//  If an MM error is returned which is not defined in the standard FsRtl filter,
//  it is converted to one of the following errors which is guaranteed to be in the
//  filter.  In this case information is lost, however, the filter correctly
//  handles the exception.
//
#define STATUS_UNEXPECTED_MM_EXTEND_ERR  ((NTSTATUS)0xC00000ECL)

//
// MessageId: STATUS_NOT_LOGON_PROCESS
//
// MessageText:
//
//  The requested action is restricted for use by logon processes
//  only.  The calling process has not registered as a logon process.
//
#define STATUS_NOT_LOGON_PROCESS         ((NTSTATUS)0xC00000EDL)

//
// MessageId: STATUS_LOGON_SESSION_EXISTS
//
// MessageText:
//
//  An attempt has been made to start a new session manager or
//  LSA logon session with an ID that is already in use.
//
#define STATUS_LOGON_SESSION_EXISTS      ((NTSTATUS)0xC00000EEL)

//
// MessageId: STATUS_INVALID_PARAMETER_1
//
// MessageText:
//
//  An invalid parameter was passed to a service or function as
//  the first argument.
//
#define STATUS_INVALID_PARAMETER_1       ((NTSTATUS)0xC00000EFL)

//
// MessageId: STATUS_INVALID_PARAMETER_2
//
// MessageText:
//
//  An invalid parameter was passed to a service or function as
//  the second argument.
//
#define STATUS_INVALID_PARAMETER_2       ((NTSTATUS)0xC00000F0L)

//
// MessageId: STATUS_INVALID_PARAMETER_3
//
// MessageText:
//
//  An invalid parameter was passed to a service or function as
//  the third argument.
//
#define STATUS_INVALID_PARAMETER_3       ((NTSTATUS)0xC00000F1L)

//
// MessageId: STATUS_INVALID_PARAMETER_4
//
// MessageText:
//
//  An invalid parameter was passed to a service or function as
//  the fourth argument.
//
#define STATUS_INVALID_PARAMETER_4       ((NTSTATUS)0xC00000F2L)

//
// MessageId: STATUS_INVALID_PARAMETER_5
//
// MessageText:
//
//  An invalid parameter was passed to a service or function as
//  the fifth argument.
//
#define STATUS_INVALID_PARAMETER_5       ((NTSTATUS)0xC00000F3L)

//
// MessageId: STATUS_INVALID_PARAMETER_6
//
// MessageText:
//
//  An invalid parameter was passed to a service or function as
//  the sixth argument.
//
#define STATUS_INVALID_PARAMETER_6       ((NTSTATUS)0xC00000F4L)

//
// MessageId: STATUS_INVALID_PARAMETER_7
//
// MessageText:
//
//  An invalid parameter was passed to a service or function as
//  the seventh argument.
//
#define STATUS_INVALID_PARAMETER_7       ((NTSTATUS)0xC00000F5L)

//
// MessageId: STATUS_INVALID_PARAMETER_8
//
// MessageText:
//
//  An invalid parameter was passed to a service or function as
//  the eighth argument.
//
#define STATUS_INVALID_PARAMETER_8       ((NTSTATUS)0xC00000F6L)

//
// MessageId: STATUS_INVALID_PARAMETER_9
//
// MessageText:
//
//  An invalid parameter was passed to a service or function as
//  the ninth argument.
//
#define STATUS_INVALID_PARAMETER_9       ((NTSTATUS)0xC00000F7L)

//
// MessageId: STATUS_INVALID_PARAMETER_10
//
// MessageText:
//
//  An invalid parameter was passed to a service or function as
//  the tenth argument.
//
#define STATUS_INVALID_PARAMETER_10      ((NTSTATUS)0xC00000F8L)

//
// MessageId: STATUS_INVALID_PARAMETER_11
//
// MessageText:
//
//  An invalid parameter was passed to a service or function as
//  the eleventh argument.
//
#define STATUS_INVALID_PARAMETER_11      ((NTSTATUS)0xC00000F9L)

//
// MessageId: STATUS_INVALID_PARAMETER_12
//
// MessageText:
//
//  An invalid parameter was passed to a service or function as
//  the twelfth argument.
//
#define STATUS_INVALID_PARAMETER_12      ((NTSTATUS)0xC00000FAL)

//
// MessageId: STATUS_REDIRECTOR_NOT_STARTED
//
// MessageText:
//
//   An attempt was made to access a network file, but the network software
//   was not yet started.
//
#define STATUS_REDIRECTOR_NOT_STARTED    ((NTSTATUS)0xC00000FBL)

//
// MessageId: STATUS_REDIRECTOR_STARTED
//
// MessageText:
//
//   An attempt was made to start the redirector, but the redirector
//   has already been started.
//
#define STATUS_REDIRECTOR_STARTED        ((NTSTATUS)0xC00000FCL)

//
// MessageId: STATUS_STACK_OVERFLOW
//
// MessageText:
//
//  A new guard page for the stack cannot be created.
//
#define STATUS_STACK_OVERFLOW            ((NTSTATUS)0xC00000FDL)    // winnt

//
// MessageId: STATUS_NO_SUCH_PACKAGE
//
// MessageText:
//
//  A specified authentication package is unknown.
//
#define STATUS_NO_SUCH_PACKAGE           ((NTSTATUS)0xC00000FEL)

//
// MessageId: STATUS_BAD_FUNCTION_TABLE
//
// MessageText:
//
//  A malformed function table was encountered during an unwind operation.
//
#define STATUS_BAD_FUNCTION_TABLE        ((NTSTATUS)0xC00000FFL)

//
// MessageId: STATUS_VARIABLE_NOT_FOUND
//
// MessageText:
//
//  Indicates the specified environment variable name was not found
//  in the specified environment block.
//
#define STATUS_VARIABLE_NOT_FOUND        ((NTSTATUS)0xC0000100L)

//
// MessageId: STATUS_DIRECTORY_NOT_EMPTY
//
// MessageText:
//
//  Indicates that the directory trying to be deleted is not empty.
//
#define STATUS_DIRECTORY_NOT_EMPTY       ((NTSTATUS)0xC0000101L)

//
// MessageId: STATUS_FILE_CORRUPT_ERROR
//
// MessageText:
//
//  {Corrupt File}
//  The file or directory %s is corrupt and unreadable.
//  Please run the Chkdsk utility.
//
#define STATUS_FILE_CORRUPT_ERROR        ((NTSTATUS)0xC0000102L)

//
// MessageId: STATUS_NOT_A_DIRECTORY
//
// MessageText:
//
//  A requested opened file is not a directory.
//
#define STATUS_NOT_A_DIRECTORY           ((NTSTATUS)0xC0000103L)

//
// MessageId: STATUS_BAD_LOGON_SESSION_STATE
//
// MessageText:
//
//  The logon session is not in a state that is consistent with the
//  requested operation.
//
#define STATUS_BAD_LOGON_SESSION_STATE   ((NTSTATUS)0xC0000104L)

//
// MessageId: STATUS_LOGON_SESSION_COLLISION
//
// MessageText:
//
//  An internal LSA error has occurred.  An authentication package has
//  requested the creation of a Logon Session but the ID of an already
//  existing Logon Session has been specified.
//
#define STATUS_LOGON_SESSION_COLLISION   ((NTSTATUS)0xC0000105L)

//
// MessageId: STATUS_NAME_TOO_LONG
//
// MessageText:
//
//  A specified name string is too long for its intended use.
//
#define STATUS_NAME_TOO_LONG             ((NTSTATUS)0xC0000106L)

//
// MessageId: STATUS_FILES_OPEN
//
// MessageText:
//
//  The user attempted to force close the files on a redirected
//  drive, but there were opened files on the drive, and the user
//  did not specify a sufficient level of force.
//
#define STATUS_FILES_OPEN                ((NTSTATUS)0xC0000107L)

//
// MessageId: STATUS_CONNECTION_IN_USE
//
// MessageText:
//
//  The user attempted to force close the files on a redirected
//  drive, but there were opened directories on the drive, and the user
//  did not specify a sufficient level of force.
//
#define STATUS_CONNECTION_IN_USE         ((NTSTATUS)0xC0000108L)

//
// MessageId: STATUS_MESSAGE_NOT_FOUND
//
// MessageText:
//
//  RtlFindMessage could not locate the requested message ID in the
//  message table resource.
//
#define STATUS_MESSAGE_NOT_FOUND         ((NTSTATUS)0xC0000109L)

//
// MessageId: STATUS_PROCESS_IS_TERMINATING
//
// MessageText:
//
//  An attempt was made to duplicate an object handle into or out
//  of an exiting process.
//
#define STATUS_PROCESS_IS_TERMINATING    ((NTSTATUS)0xC000010AL)

//
// MessageId: STATUS_INVALID_LOGON_TYPE
//
// MessageText:
//
//  Indicates an invalid value has been provided for the LogonType
//  requested.
//
#define STATUS_INVALID_LOGON_TYPE        ((NTSTATUS)0xC000010BL)

//
// MessageId: STATUS_NO_GUID_TRANSLATION
//
// MessageText:
//
//  Indicates that an attempt was made to assign protection to a
//  file system file or directory and one of the SIDs in the security
//  descriptor could not be translated into a GUID that could be stored
//  by the file system.
//  This causes the protection attempt to fail, which may cause a file
//  creation attempt to fail.
//
#define STATUS_NO_GUID_TRANSLATION       ((NTSTATUS)0xC000010CL)

//
// MessageId: STATUS_CANNOT_IMPERSONATE
//
// MessageText:
//
//  Indicates that an attempt has been made to impersonate via a named
//  pipe that has not yet been read from.
//
#define STATUS_CANNOT_IMPERSONATE        ((NTSTATUS)0xC000010DL)

//
// MessageId: STATUS_IMAGE_ALREADY_LOADED
//
// MessageText:
//
//  Indicates that the specified image is already loaded.
//
#define STATUS_IMAGE_ALREADY_LOADED      ((NTSTATUS)0xC000010EL)


//
// ============================================================
// NOTE: The following ABIOS error code should be reserved on
//       non ABIOS kernel.  Eventually, I will remove the ifdef
//       ABIOS.
// ============================================================
//
//
// MessageId: STATUS_ABIOS_NOT_PRESENT
//
// MessageText:
//
//  STATUS_ABIOS_NOT_PRESENT
//
#define STATUS_ABIOS_NOT_PRESENT         ((NTSTATUS)0xC000010FL)

//
// MessageId: STATUS_ABIOS_LID_NOT_EXIST
//
// MessageText:
//
//  STATUS_ABIOS_LID_NOT_EXIST
//
#define STATUS_ABIOS_LID_NOT_EXIST       ((NTSTATUS)0xC0000110L)

//
// MessageId: STATUS_ABIOS_LID_ALREADY_OWNED
//
// MessageText:
//
//  STATUS_ABIOS_LID_ALREADY_OWNED
//
#define STATUS_ABIOS_LID_ALREADY_OWNED   ((NTSTATUS)0xC0000111L)

//
// MessageId: STATUS_ABIOS_NOT_LID_OWNER
//
// MessageText:
//
//  STATUS_ABIOS_NOT_LID_OWNER
//
#define STATUS_ABIOS_NOT_LID_OWNER       ((NTSTATUS)0xC0000112L)

//
// MessageId: STATUS_ABIOS_INVALID_COMMAND
//
// MessageText:
//
//  STATUS_ABIOS_INVALID_COMMAND
//
#define STATUS_ABIOS_INVALID_COMMAND     ((NTSTATUS)0xC0000113L)

//
// MessageId: STATUS_ABIOS_INVALID_LID
//
// MessageText:
//
//  STATUS_ABIOS_INVALID_LID
//
#define STATUS_ABIOS_INVALID_LID         ((NTSTATUS)0xC0000114L)

//
// MessageId: STATUS_ABIOS_SELECTOR_NOT_AVAILABLE
//
// MessageText:
//
//  STATUS_ABIOS_SELECTOR_NOT_AVAILABLE
//
#define STATUS_ABIOS_SELECTOR_NOT_AVAILABLE ((NTSTATUS)0xC0000115L)

//
// MessageId: STATUS_ABIOS_INVALID_SELECTOR
//
// MessageText:
//
//  STATUS_ABIOS_INVALID_SELECTOR
//
#define STATUS_ABIOS_INVALID_SELECTOR    ((NTSTATUS)0xC0000116L)

//
// MessageId: STATUS_NO_LDT
//
// MessageText:
//
//  Indicates that an attempt was made to change the size of the LDT for
//  a process that has no LDT.
//
#define STATUS_NO_LDT                    ((NTSTATUS)0xC0000117L)

//
// MessageId: STATUS_INVALID_LDT_SIZE
//
// MessageText:
//
//  Indicates that an attempt was made to grow an LDT by setting its size,
//  or that the size was not an even number of selectors.
//
#define STATUS_INVALID_LDT_SIZE          ((NTSTATUS)0xC0000118L)

//
// MessageId: STATUS_INVALID_LDT_OFFSET
//
// MessageText:
//
//  Indicates that the starting value for the LDT information was not
//  an integral multiple of the selector size.
//
#define STATUS_INVALID_LDT_OFFSET        ((NTSTATUS)0xC0000119L)

//
// MessageId: STATUS_INVALID_LDT_DESCRIPTOR
//
// MessageText:
//
//  Indicates that the user supplied an invalid descriptor when trying
//  to set up Ldt descriptors.
//
#define STATUS_INVALID_LDT_DESCRIPTOR    ((NTSTATUS)0xC000011AL)

//
// MessageId: STATUS_INVALID_IMAGE_NE_FORMAT
//
// MessageText:
//
//  The specified image file did not have the correct format. It
//  appears to be NE format.
//
#define STATUS_INVALID_IMAGE_NE_FORMAT   ((NTSTATUS)0xC000011BL)

//
// MessageId: STATUS_RXACT_INVALID_STATE
//
// MessageText:
//
//  Indicates that the transaction state of a registry sub-tree is
//  incompatible with the requested operation.
//  For example, a request has been made to start a new transaction with
//  one already in progress, or a request has been made to apply a transaction
//  when one is not currently in progress.
//  This status value is returned by the runtime library (RTL) registry
//  transaction package (RXact).
//
#define STATUS_RXACT_INVALID_STATE       ((NTSTATUS)0xC000011CL)

//
// MessageId: STATUS_RXACT_COMMIT_FAILURE
//
// MessageText:
//
//  Indicates an error has occurred during a registry transaction commit.
//  The database has been left in an unknown, but probably inconsistent,
//  state.  The state of the registry transaction is left as COMMITTING.
//  This status value is returned by the runtime library (RTL) registry
//  transaction package (RXact).
//
#define STATUS_RXACT_COMMIT_FAILURE      ((NTSTATUS)0xC000011DL)

//
// MessageId: STATUS_MAPPED_FILE_SIZE_ZERO
//
// MessageText:
//
//  An attempt was made to map a file of size zero with the
//  maximum size specified as zero.
//
#define STATUS_MAPPED_FILE_SIZE_ZERO     ((NTSTATUS)0xC000011EL)

//
// MessageId: STATUS_TOO_MANY_OPENED_FILES
//
// MessageText:
//
//  Too many files are opened on a remote server.  This error should only
//  be returned by the NT redirector on a remote drive.
//
#define STATUS_TOO_MANY_OPENED_FILES     ((NTSTATUS)0xC000011FL)

//
// MessageId: STATUS_CANCELLED
//
// MessageText:
//
//  The I/O request was canceled.
//
#define STATUS_CANCELLED                 ((NTSTATUS)0xC0000120L)

//
// MessageId: STATUS_CANNOT_DELETE
//
// MessageText:
//
//  An attempt has been made to remove a file or directory that cannot
//  be deleted.
//
#define STATUS_CANNOT_DELETE             ((NTSTATUS)0xC0000121L)

//
// MessageId: STATUS_INVALID_COMPUTER_NAME
//
// MessageText:
//
//  Indicates a name specified as a remote computer name is syntactically
//  invalid.
//
#define STATUS_INVALID_COMPUTER_NAME     ((NTSTATUS)0xC0000122L)

//
// MessageId: STATUS_FILE_DELETED
//
// MessageText:
//
//  An I/O request other than close was performed on a file after it has
//  been deleted, which can only happen to a request which did not complete
//  before the last handle was closed via NtClose.
//
#define STATUS_FILE_DELETED              ((NTSTATUS)0xC0000123L)

//
// MessageId: STATUS_SPECIAL_ACCOUNT
//
// MessageText:
//
//  Indicates an operation has been attempted on a built-in (special)
//  SAM account which is incompatible with built-in accounts.  For
//  example, built-in accounts cannot be deleted.
//
#define STATUS_SPECIAL_ACCOUNT           ((NTSTATUS)0xC0000124L)

//
// MessageId: STATUS_SPECIAL_GROUP
//
// MessageText:
//
//  The operation requested may not be performed on the specified
//  group because it is a built-in special group.
//
#define STATUS_SPECIAL_GROUP             ((NTSTATUS)0xC0000125L)

//
// MessageId: STATUS_SPECIAL_USER
//
// MessageText:
//
//  The operation requested may not be performed on the specified
//  user because it is a built-in special user.
//
#define STATUS_SPECIAL_USER              ((NTSTATUS)0xC0000126L)

//
// MessageId: STATUS_MEMBERS_PRIMARY_GROUP
//
// MessageText:
//
//  Indicates a member cannot be removed from a group because the
//  group is currently the member's primary group.
//
#define STATUS_MEMBERS_PRIMARY_GROUP     ((NTSTATUS)0xC0000127L)

//
// MessageId: STATUS_FILE_CLOSED
//
// MessageText:
//
//  An I/O request other than close and several other special case
//  operations was attempted using a file object that had already been
//  closed.
//
#define STATUS_FILE_CLOSED               ((NTSTATUS)0xC0000128L)

//
// MessageId: STATUS_TOO_MANY_THREADS
//
// MessageText:
//
//  Indicates a process has too many threads to perform the requested
//  action.  For example, assignment of a primary token may only be
//  performed when a process has zero or one threads.
//
#define STATUS_TOO_MANY_THREADS          ((NTSTATUS)0xC0000129L)

//
// MessageId: STATUS_THREAD_NOT_IN_PROCESS
//
// MessageText:
//
//  An attempt was made to operate on a thread within a specific process,
//  but the thread specified is not in the process specified.
//
#define STATUS_THREAD_NOT_IN_PROCESS     ((NTSTATUS)0xC000012AL)

//
// MessageId: STATUS_TOKEN_ALREADY_IN_USE
//
// MessageText:
//
//  An attempt was made to establish a token for use as a primary token
//  but the token is already in use.  A token can only be the primary token
//  of one process at a time.
//
#define STATUS_TOKEN_ALREADY_IN_USE      ((NTSTATUS)0xC000012BL)

//
// MessageId: STATUS_PAGEFILE_QUOTA_EXCEEDED
//
// MessageText:
//
//  Page file quota was exceeded.
//
#define STATUS_PAGEFILE_QUOTA_EXCEEDED   ((NTSTATUS)0xC000012CL)

//
// MessageId: STATUS_COMMITMENT_LIMIT
//
// MessageText:
//
//  {Out of Virtual Memory}
//  Your system is running low on virtual memory.  Please close some
//  applications.  You can then start the System option in the Control Panel
//  and choose the Virtual Memory button to create an additional paging file
//  or to increase the size of your current paging file.
//
#define STATUS_COMMITMENT_LIMIT          ((NTSTATUS)0xC000012DL)

//
// MessageId: STATUS_INVALID_IMAGE_LE_FORMAT
//
// MessageText:
//
//  The specified image file did not have the correct format, it
//  appears to be LE format.
//
#define STATUS_INVALID_IMAGE_LE_FORMAT   ((NTSTATUS)0xC000012EL)

//
// MessageId: STATUS_INVALID_IMAGE_NOT_MZ
//
// MessageText:
//
//  The specified image file did not have the correct format, it
//  did not have an initial MZ.
//
#define STATUS_INVALID_IMAGE_NOT_MZ      ((NTSTATUS)0xC000012FL)

//
// MessageId: STATUS_INVALID_IMAGE_PROTECT
//
// MessageText:
//
//  The specified image file did not have the correct format, it
//  did not have a proper e_lfarlc in the MZ header.
//
#define STATUS_INVALID_IMAGE_PROTECT     ((NTSTATUS)0xC0000130L)

//
// MessageId: STATUS_INVALID_IMAGE_WIN_16
//
// MessageText:
//
//  The specified image file did not have the correct format, it
//  appears to be a 16-bit Windows image.
//
#define STATUS_INVALID_IMAGE_WIN_16      ((NTSTATUS)0xC0000131L)

//
// MessageId: STATUS_LOGON_SERVER_CONFLICT
//
// MessageText:
//
//  The Netlogon service cannot start because another Netlogon service running
//  in the domain conflicts with the specified role.
//
#define STATUS_LOGON_SERVER_CONFLICT     ((NTSTATUS)0xC0000132L)

//
// MessageId: STATUS_TIME_DIFFERENCE_AT_DC
//
// MessageText:
//
//  The time at the Primary Domain Controller is different than the
//  time at the Backup Domain Controller or member server by too large
//  an amount.
//
#define STATUS_TIME_DIFFERENCE_AT_DC     ((NTSTATUS)0xC0000133L)

//
// MessageId: STATUS_SYNCHRONIZATION_REQUIRED
//
// MessageText:
//
//  The SAM database on a Windows NT Server is
//  significantly out of synchronization with the copy on the Domain
//  Controller.  A complete synchronization is required.
//
#define STATUS_SYNCHRONIZATION_REQUIRED  ((NTSTATUS)0xC0000134L)

//
// MessageId: STATUS_DLL_NOT_FOUND
//
// MessageText:
//
//  {Unable To Locate DLL}
//  The dynamic link library %s could not be found in the specified path %s.
//
#define STATUS_DLL_NOT_FOUND             ((NTSTATUS)0xC0000135L)

//
// MessageId: STATUS_OPEN_FAILED
//
// MessageText:
//
//  The NtCreateFile API failed.  This error should never be returned to an
//  application, it is a place holder for the NT Lan Manager Redirector to
//  use in its internal error mapping routines.
//
#define STATUS_OPEN_FAILED               ((NTSTATUS)0xC0000136L)

//
// MessageId: STATUS_IO_PRIVILEGE_FAILED
//
// MessageText:
//
//  {Privilege Failed}
//  The I/O permissions for the process could not be changed.
//
#define STATUS_IO_PRIVILEGE_FAILED       ((NTSTATUS)0xC0000137L)

//
// MessageId: STATUS_ORDINAL_NOT_FOUND
//
// MessageText:
//
//  {Ordinal Not Found}
//  The ordinal %ld could not be located in the dynamic link library %s.
//
#define STATUS_ORDINAL_NOT_FOUND         ((NTSTATUS)0xC0000138L)

//
// MessageId: STATUS_ENTRYPOINT_NOT_FOUND
//
// MessageText:
//
//  {Entry Point Not Found}
//  The procedure entry point %s could not be located in the dynamic link library %s.
//
#define STATUS_ENTRYPOINT_NOT_FOUND      ((NTSTATUS)0xC0000139L)

//
// MessageId: STATUS_CONTROL_C_EXIT
//
// MessageText:
//
//  {Application Exit by CTRL+C}
//  The application terminated as a result of a CTRL+C.
//
#define STATUS_CONTROL_C_EXIT            ((NTSTATUS)0xC000013AL)    // winnt

//
// MessageId: STATUS_LOCAL_DISCONNECT
//
// MessageText:
//
//  {Virtual Circuit Closed}
//  The network transport on your computer has closed a network
//  connection. There may or may not be I/O requests outstanding.
//
#define STATUS_LOCAL_DISCONNECT          ((NTSTATUS)0xC000013BL)

//
// MessageId: STATUS_REMOTE_DISCONNECT
//
// MessageText:
//
//  {Virtual Circuit Closed}
//  The network transport on a remote computer has closed a network
//  connection. There may or may not be I/O requests outstanding.
//
#define STATUS_REMOTE_DISCONNECT         ((NTSTATUS)0xC000013CL)

//
// MessageId: STATUS_REMOTE_RESOURCES
//
// MessageText:
//
//  {Insufficient Resources on Remote Computer}
//  The remote computer has insufficient resources to complete the
//  network request. For instance, there may not be enough memory
//  available on the remote computer to carry out the request at
//  this time.
//
#define STATUS_REMOTE_RESOURCES          ((NTSTATUS)0xC000013DL)

//
// MessageId: STATUS_LINK_FAILED
//
// MessageText:
//
//  {Virtual Circuit Closed}
//  An existing connection (virtual circuit) has been broken at the
//  remote computer. There is probably something wrong with the
//  network software protocol or the network hardware on the
//  remote computer.
//
#define STATUS_LINK_FAILED               ((NTSTATUS)0xC000013EL)

//
// MessageId: STATUS_LINK_TIMEOUT
//
// MessageText:
//
//  {Virtual Circuit Closed}
//  The network transport on your computer has closed a network
//  connection because it had to wait too long for a response
//  from the remote computer.
//
#define STATUS_LINK_TIMEOUT              ((NTSTATUS)0xC000013FL)

//
// MessageId: STATUS_INVALID_CONNECTION
//
// MessageText:
//
//  The connection handle given to the transport was invalid.
//
#define STATUS_INVALID_CONNECTION        ((NTSTATUS)0xC0000140L)

//
// MessageId: STATUS_INVALID_ADDRESS
//
// MessageText:
//
//  The address handle given to the transport was invalid.
//
#define STATUS_INVALID_ADDRESS           ((NTSTATUS)0xC0000141L)

//
// MessageId: STATUS_DLL_INIT_FAILED
//
// MessageText:
//
//  {DLL Initialization Failed}
//  Initialization of the dynamic link library %s failed. The process is
//  terminating abnormally.
//
#define STATUS_DLL_INIT_FAILED           ((NTSTATUS)0xC0000142L)

//
// MessageId: STATUS_MISSING_SYSTEMFILE
//
// MessageText:
//
//  {Missing System File}
//  The required system file %s is bad or missing.
//
#define STATUS_MISSING_SYSTEMFILE        ((NTSTATUS)0xC0000143L)

//
// MessageId: STATUS_UNHANDLED_EXCEPTION
//
// MessageText:
//
//  {Application Error}
//  The exception %s (0x%08lx) occurred in the application at location 0x%08lx.
//
#define STATUS_UNHANDLED_EXCEPTION       ((NTSTATUS)0xC0000144L)

//
// MessageId: STATUS_APP_INIT_FAILURE
//
// MessageText:
//
//  {Application Error}
//  The application failed to initialize properly (0x%lx).  Click on OK to
//  terminate the application.
//
#define STATUS_APP_INIT_FAILURE          ((NTSTATUS)0xC0000145L)

//
// MessageId: STATUS_PAGEFILE_CREATE_FAILED
//
// MessageText:
//
//  {Unable to Create Paging File}
//  The creation of the paging file %s failed (%lx). The requested size was %ld.
//
#define STATUS_PAGEFILE_CREATE_FAILED    ((NTSTATUS)0xC0000146L)

//
// MessageId: STATUS_NO_PAGEFILE
//
// MessageText:
//
//  {No Paging File Specified}
//  No paging file was specified in the system configuration.
//
#define STATUS_NO_PAGEFILE               ((NTSTATUS)0xC0000147L)

//
// MessageId: STATUS_INVALID_LEVEL
//
// MessageText:
//
//  {Incorrect System Call Level}
//  An invalid level was passed into the specified system call.
//
#define STATUS_INVALID_LEVEL             ((NTSTATUS)0xC0000148L)

//
// MessageId: STATUS_WRONG_PASSWORD_CORE
//
// MessageText:
//
//  {Incorrect Password to LAN Manager Server}
//  You specified an incorrect password to a LAN Manager 2.x or MS-NET server.
//
#define STATUS_WRONG_PASSWORD_CORE       ((NTSTATUS)0xC0000149L)

//
// MessageId: STATUS_ILLEGAL_FLOAT_CONTEXT
//
// MessageText:
//
//  {EXCEPTION}
//  A real-mode application issued a floating-point instruction and floating-point
//  hardware is not present.
//
#define STATUS_ILLEGAL_FLOAT_CONTEXT     ((NTSTATUS)0xC000014AL)

//
// MessageId: STATUS_PIPE_BROKEN
//
// MessageText:
//
//  The pipe operation has failed because the other end of the pipe has been
//  closed.
//
#define STATUS_PIPE_BROKEN               ((NTSTATUS)0xC000014BL)

//
// MessageId: STATUS_REGISTRY_CORRUPT
//
// MessageText:
//
//  {The Registry Is Corrupt}
//  The structure of one of the files that contains Registry data is corrupt, or
//  the image of the file in memory is corrupt, or the file could not
//  be recovered because the alternate copy or log was absent or corrupt.
//
#define STATUS_REGISTRY_CORRUPT          ((NTSTATUS)0xC000014CL)

//
// MessageId: STATUS_REGISTRY_IO_FAILED
//
// MessageText:
//
//  An I/O operation initiated by the Registry failed unrecoverably.
//  The Registry could not read in, or write out, or flush, one of the files
//  that contain the system's image of the Registry.
//
#define STATUS_REGISTRY_IO_FAILED        ((NTSTATUS)0xC000014DL)

//
// MessageId: STATUS_NO_EVENT_PAIR
//
// MessageText:
//
//  An event pair synchronization operation was performed using the thread
//  specific client/server event pair object, but no event pair object was
//  associated with the thread.
//
#define STATUS_NO_EVENT_PAIR             ((NTSTATUS)0xC000014EL)

//
// MessageId: STATUS_UNRECOGNIZED_VOLUME
//
// MessageText:
//
//  The volume does not contain a recognized file system.
//  Please make sure that all required file system drivers are loaded and that the
//  volume is not corrupt.
//
#define STATUS_UNRECOGNIZED_VOLUME       ((NTSTATUS)0xC000014FL)

//
// MessageId: STATUS_SERIAL_NO_DEVICE_INITED
//
// MessageText:
//
//  No serial device was successfully initialized.  The serial driver will unload.
//
#define STATUS_SERIAL_NO_DEVICE_INITED   ((NTSTATUS)0xC0000150L)

//
// MessageId: STATUS_NO_SUCH_ALIAS
//
// MessageText:
//
//  The specified local group does not exist.
//
#define STATUS_NO_SUCH_ALIAS             ((NTSTATUS)0xC0000151L)

//
// MessageId: STATUS_MEMBER_NOT_IN_ALIAS
//
// MessageText:
//
//  The specified account name is not a member of the local group.
//
#define STATUS_MEMBER_NOT_IN_ALIAS       ((NTSTATUS)0xC0000152L)

//
// MessageId: STATUS_MEMBER_IN_ALIAS
//
// MessageText:
//
//  The specified account name is already a member of the local group.
//
#define STATUS_MEMBER_IN_ALIAS           ((NTSTATUS)0xC0000153L)

//
// MessageId: STATUS_ALIAS_EXISTS
//
// MessageText:
//
//  The specified local group already exists.
//
#define STATUS_ALIAS_EXISTS              ((NTSTATUS)0xC0000154L)

//
// MessageId: STATUS_LOGON_NOT_GRANTED
//
// MessageText:
//
//  A requested type of logon (e.g., Interactive, Network, Service) is not
//  granted by the target system's local security policy.  Please ask the
//  system administrator to grant the necessary form of logon.
//
#define STATUS_LOGON_NOT_GRANTED         ((NTSTATUS)0xC0000155L)

//
// MessageId: STATUS_TOO_MANY_SECRETS
//
// MessageText:
//
//  The maximum number of secrets that may be stored in a single system has been
//  exceeded.  The length and number of secrets is limited to satisfy United
//  States State Department export restrictions.
//
#define STATUS_TOO_MANY_SECRETS          ((NTSTATUS)0xC0000156L)

//
// MessageId: STATUS_SECRET_TOO_LONG
//
// MessageText:
//
//  The length of a secret exceeds the maximum length allowed.  The length and
//  number of secrets is limited to satisfy United States State Department
//  export restrictions.
//
#define STATUS_SECRET_TOO_LONG           ((NTSTATUS)0xC0000157L)

//
// MessageId: STATUS_INTERNAL_DB_ERROR
//
// MessageText:
//
//  The Local Security Authority (LSA) database contains an internal inconsistency.
//
#define STATUS_INTERNAL_DB_ERROR         ((NTSTATUS)0xC0000158L)

//
// MessageId: STATUS_FULLSCREEN_MODE
//
// MessageText:
//
//  The requested operation cannot be performed in fullscreen mode.
//
#define STATUS_FULLSCREEN_MODE           ((NTSTATUS)0xC0000159L)

//
// MessageId: STATUS_TOO_MANY_CONTEXT_IDS
//
// MessageText:
//
//  During a logon attempt, the user's security context accumulated too many
//  security IDs.  This is a very unusual situation.  Remove the user from
//  some global or local groups to reduce the number of security ids to
//  incorporate into the security context.
//
#define STATUS_TOO_MANY_CONTEXT_IDS      ((NTSTATUS)0xC000015AL)

//
// MessageId: STATUS_LOGON_TYPE_NOT_GRANTED
//
// MessageText:
//
//  A user has requested a type of logon (e.g., interactive or network) that
//  has not been granted.  An administrator has control over who may logon
//  interactively and through the network.
//
#define STATUS_LOGON_TYPE_NOT_GRANTED    ((NTSTATUS)0xC000015BL)

//
// MessageId: STATUS_NOT_REGISTRY_FILE
//
// MessageText:
//
//  The system has attempted to load or restore a file into the registry, and the
//  specified file is not in the format of a registry file.
//
#define STATUS_NOT_REGISTRY_FILE         ((NTSTATUS)0xC000015CL)

//
// MessageId: STATUS_NT_CROSS_ENCRYPTION_REQUIRED
//
// MessageText:
//
//  An attempt was made to change a user password in the security account manager
//  without providing the necessary NT cross-encrypted password.
//
#define STATUS_NT_CROSS_ENCRYPTION_REQUIRED ((NTSTATUS)0xC000015DL)

//
// MessageId: STATUS_DOMAIN_CTRLR_CONFIG_ERROR
//
// MessageText:
//
//  A Windows NT Server has incorrect configuration.
//
#define STATUS_DOMAIN_CTRLR_CONFIG_ERROR ((NTSTATUS)0xC000015EL)

//
// MessageId: STATUS_FT_MISSING_MEMBER
//
// MessageText:
//
//  An attempt was made to explicitly access the secondary copy of information
//  via a device control to the Fault Tolerance driver and the secondary copy
//  is not present in the system.
//
#define STATUS_FT_MISSING_MEMBER         ((NTSTATUS)0xC000015FL)

//
// MessageId: STATUS_ILL_FORMED_SERVICE_ENTRY
//
// MessageText:
//
//  A configuration registry node representing a driver service entry was ill-formed
//  and did not contain required value entries.
//
#define STATUS_ILL_FORMED_SERVICE_ENTRY  ((NTSTATUS)0xC0000160L)

//
// MessageId: STATUS_ILLEGAL_CHARACTER
//
// MessageText:
//
//  An illegal character was encountered.  For a multi-byte character set this
//  includes a lead byte without a succeeding trail byte.  For the Unicode character set
//  this includes the characters 0xFFFF and 0xFFFE.
//
#define STATUS_ILLEGAL_CHARACTER         ((NTSTATUS)0xC0000161L)

//
// MessageId: STATUS_UNMAPPABLE_CHARACTER
//
// MessageText:
//
//  No mapping for the Unicode character exists in the target multi-byte code page.
//
#define STATUS_UNMAPPABLE_CHARACTER      ((NTSTATUS)0xC0000162L)

//
// MessageId: STATUS_UNDEFINED_CHARACTER
//
// MessageText:
//
//  The Unicode character is not defined in the Unicode character set installed on
//  the system.
//
#define STATUS_UNDEFINED_CHARACTER       ((NTSTATUS)0xC0000163L)

//
// MessageId: STATUS_FLOPPY_VOLUME
//
// MessageText:
//
//  The paging file cannot be created on a floppy diskette.
//
#define STATUS_FLOPPY_VOLUME             ((NTSTATUS)0xC0000164L)

//
// MessageId: STATUS_FLOPPY_ID_MARK_NOT_FOUND
//
// MessageText:
//
//  {Floppy Disk Error}
//  While accessing a floppy disk, an ID address mark was not found.
//
#define STATUS_FLOPPY_ID_MARK_NOT_FOUND  ((NTSTATUS)0xC0000165L)

//
// MessageId: STATUS_FLOPPY_WRONG_CYLINDER
//
// MessageText:
//
//  {Floppy Disk Error}
//  While accessing a floppy disk, the track address from the sector ID field
//  was found to be different than the track address maintained by the controller.
//
#define STATUS_FLOPPY_WRONG_CYLINDER     ((NTSTATUS)0xC0000166L)

//
// MessageId: STATUS_FLOPPY_UNKNOWN_ERROR
//
// MessageText:
//
//  {Floppy Disk Error}
//  The floppy disk controller reported an error that is not recognized by the
//  floppy disk driver.
//
#define STATUS_FLOPPY_UNKNOWN_ERROR      ((NTSTATUS)0xC0000167L)

//
// MessageId: STATUS_FLOPPY_BAD_REGISTERS
//
// MessageText:
//
//  {Floppy Disk Error}
//  While accessing a floppy-disk, the controller returned inconsistent results
//  via its registers.
//
#define STATUS_FLOPPY_BAD_REGISTERS      ((NTSTATUS)0xC0000168L)

//
// MessageId: STATUS_DISK_RECALIBRATE_FAILED
//
// MessageText:
//
//  {Hard Disk Error}
//  While accessing the hard disk, a recalibrate operation failed, even after retries.
//
#define STATUS_DISK_RECALIBRATE_FAILED   ((NTSTATUS)0xC0000169L)

//
// MessageId: STATUS_DISK_OPERATION_FAILED
//
// MessageText:
//
//  {Hard Disk Error}
//  While accessing the hard disk, a disk operation failed even after retries.
//
#define STATUS_DISK_OPERATION_FAILED     ((NTSTATUS)0xC000016AL)

//
// MessageId: STATUS_DISK_RESET_FAILED
//
// MessageText:
//
//  {Hard Disk Error}
//  While accessing the hard disk, a disk controller reset was needed, but even that failed.
//
#define STATUS_DISK_RESET_FAILED         ((NTSTATUS)0xC000016BL)

//
// MessageId: STATUS_SHARED_IRQ_BUSY
//
// MessageText:
//
//  An attempt was made to open a device that was sharing an IRQ with other devices.
//  At least one other device that uses that IRQ was already opened.  Two concurrent
//  opens of devices that share an IRQ and only work via interrupts is not supported
//  for the particular bus type that the devices use.
//
#define STATUS_SHARED_IRQ_BUSY           ((NTSTATUS)0xC000016CL)

//
// MessageId: STATUS_FT_ORPHANING
//
// MessageText:
//
//  {FT Orphaning}
//  A disk that is part of a fault-tolerant volume can no longer be accessed.
//
#define STATUS_FT_ORPHANING              ((NTSTATUS)0xC000016DL)

//
// MessageId: STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT
//
// MessageText:
//
//  The system bios failed to connect a system interrupt to the device or bus for
//  which the device is connected.
//
#define STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT ((NTSTATUS)0xC000016EL)

//
// MessageId: STATUS_PARTITION_FAILURE
//
// MessageText:
//
//  Tape could not be partitioned.
//
#define STATUS_PARTITION_FAILURE         ((NTSTATUS)0xC0000172L)

//
// MessageId: STATUS_INVALID_BLOCK_LENGTH
//
// MessageText:
//
//  When accessing a new tape of a multivolume partition, the current
//  blocksize is incorrect.
//
#define STATUS_INVALID_BLOCK_LENGTH      ((NTSTATUS)0xC0000173L)

//
// MessageId: STATUS_DEVICE_NOT_PARTITIONED
//
// MessageText:
//
//  Tape partition information could not be found when loading a tape.
//
#define STATUS_DEVICE_NOT_PARTITIONED    ((NTSTATUS)0xC0000174L)

//
// MessageId: STATUS_UNABLE_TO_LOCK_MEDIA
//
// MessageText:
//
//  Attempt to lock the eject media mechanism fails.
//
#define STATUS_UNABLE_TO_LOCK_MEDIA      ((NTSTATUS)0xC0000175L)

//
// MessageId: STATUS_UNABLE_TO_UNLOAD_MEDIA
//
// MessageText:
//
//  Unload media fails.
//
#define STATUS_UNABLE_TO_UNLOAD_MEDIA    ((NTSTATUS)0xC0000176L)

//
// MessageId: STATUS_EOM_OVERFLOW
//
// MessageText:
//
//  Physical end of tape was detected.
//
#define STATUS_EOM_OVERFLOW              ((NTSTATUS)0xC0000177L)

//
// MessageId: STATUS_NO_MEDIA
//
// MessageText:
//
//  {No Media}
//  There is no media in the drive.
//  Please insert media into drive %s.
//
#define STATUS_NO_MEDIA                  ((NTSTATUS)0xC0000178L)

//
// MessageId: STATUS_NO_SUCH_MEMBER
//
// MessageText:
//
//  A new member could not be added to a local group because the member does
//  not exist.
//
#define STATUS_NO_SUCH_MEMBER            ((NTSTATUS)0xC000017AL)

//
// MessageId: STATUS_INVALID_MEMBER
//
// MessageText:
//
//  A new member could not be added to a local group because the member has the
//  wrong account type.
//
#define STATUS_INVALID_MEMBER            ((NTSTATUS)0xC000017BL)

//
// MessageId: STATUS_KEY_DELETED
//
// MessageText:
//
//  Illegal operation attempted on a registry key which has been marked for deletion.
//
#define STATUS_KEY_DELETED               ((NTSTATUS)0xC000017CL)

//
// MessageId: STATUS_NO_LOG_SPACE
//
// MessageText:
//
//  System could not allocate required space in a registry log.
//
#define STATUS_NO_LOG_SPACE              ((NTSTATUS)0xC000017DL)

//
// MessageId: STATUS_TOO_MANY_SIDS
//
// MessageText:
//
//  Too many Sids have been specified.
//
#define STATUS_TOO_MANY_SIDS             ((NTSTATUS)0xC000017EL)

//
// MessageId: STATUS_LM_CROSS_ENCRYPTION_REQUIRED
//
// MessageText:
//
//  An attempt was made to change a user password in the security account manager
//  without providing the necessary LM cross-encrypted password.
//
#define STATUS_LM_CROSS_ENCRYPTION_REQUIRED ((NTSTATUS)0xC000017FL)

//
// MessageId: STATUS_KEY_HAS_CHILDREN
//
// MessageText:
//
//  An attempt was made to create a symbolic link in a registry key that already
//  has subkeys or values.
//
#define STATUS_KEY_HAS_CHILDREN          ((NTSTATUS)0xC0000180L)

//
// MessageId: STATUS_CHILD_MUST_BE_VOLATILE
//
// MessageText:
//
//  An attempt was made to create a Stable subkey under a Volatile parent key.
//
#define STATUS_CHILD_MUST_BE_VOLATILE    ((NTSTATUS)0xC0000181L)

//
// MessageId: STATUS_DEVICE_CONFIGURATION_ERROR
//
// MessageText:
//
//  The I/O device is configured incorrectly or the configuration parameters to the
//  driver are incorrect.
//
#define STATUS_DEVICE_CONFIGURATION_ERROR ((NTSTATUS)0xC0000182L)

//
// MessageId: STATUS_DRIVER_INTERNAL_ERROR
//
// MessageText:
//
//  An error was detected between two drivers or within an I/O driver.
//
#define STATUS_DRIVER_INTERNAL_ERROR     ((NTSTATUS)0xC0000183L)

//
// MessageId: STATUS_INVALID_DEVICE_STATE
//
// MessageText:
//
//  The device is not in a valid state to perform this request.
//
#define STATUS_INVALID_DEVICE_STATE      ((NTSTATUS)0xC0000184L)

//
// MessageId: STATUS_IO_DEVICE_ERROR
//
// MessageText:
//
//  The I/O device reported an I/O error.
//
#define STATUS_IO_DEVICE_ERROR           ((NTSTATUS)0xC0000185L)

//
// MessageId: STATUS_DEVICE_PROTOCOL_ERROR
//
// MessageText:
//
//  A protocol error was detected between the driver and the device.
//
#define STATUS_DEVICE_PROTOCOL_ERROR     ((NTSTATUS)0xC0000186L)

//
// MessageId: STATUS_BACKUP_CONTROLLER
//
// MessageText:
//
//  This operation is only allowed for the Primary Domain Controller of the domain.
//
#define STATUS_BACKUP_CONTROLLER         ((NTSTATUS)0xC0000187L)

//
// MessageId: STATUS_LOG_FILE_FULL
//
// MessageText:
//
//  Log file space is insufficient to support this operation.
//
#define STATUS_LOG_FILE_FULL             ((NTSTATUS)0xC0000188L)

//
// MessageId: STATUS_TOO_LATE
//
// MessageText:
//
//  A write operation was attempted to a volume after it was dismounted.
//
#define STATUS_TOO_LATE                  ((NTSTATUS)0xC0000189L)

//
// MessageId: STATUS_NO_TRUST_LSA_SECRET
//
// MessageText:
//
//  The workstation does not have a trust secret for the primary domain in
//  the local LSA database.
//
#define STATUS_NO_TRUST_LSA_SECRET       ((NTSTATUS)0xC000018AL)

//
// MessageId: STATUS_NO_TRUST_SAM_ACCOUNT
//
// MessageText:
//
//  The SAM database on the Windows NT Server does not have a computer
//  account for this workstation trust relationship.
//
#define STATUS_NO_TRUST_SAM_ACCOUNT      ((NTSTATUS)0xC000018BL)

//
// MessageId: STATUS_TRUSTED_DOMAIN_FAILURE
//
// MessageText:
//
//  The logon request failed because the trust relationship between the
//  primary domain and the trusted domain failed.
//
#define STATUS_TRUSTED_DOMAIN_FAILURE    ((NTSTATUS)0xC000018CL)

//
// MessageId: STATUS_TRUSTED_RELATIONSHIP_FAILURE
//
// MessageText:
//
//  The logon request failed because the trust relationship between this
//  workstation and the primary domain failed.
//
#define STATUS_TRUSTED_RELATIONSHIP_FAILURE ((NTSTATUS)0xC000018DL)

//
// MessageId: STATUS_EVENTLOG_FILE_CORRUPT
//
// MessageText:
//
//  The Eventlog log file is corrupt.
//
#define STATUS_EVENTLOG_FILE_CORRUPT     ((NTSTATUS)0xC000018EL)

//
// MessageId: STATUS_EVENTLOG_CANT_START
//
// MessageText:
//
//  No Eventlog log file could be opened.  The Eventlog service did not start.
//
#define STATUS_EVENTLOG_CANT_START       ((NTSTATUS)0xC000018FL)

//
// MessageId: STATUS_TRUST_FAILURE
//
// MessageText:
//
//  The network logon failed. This may be because the validation authority can't
//  be reached.
//
#define STATUS_TRUST_FAILURE             ((NTSTATUS)0xC0000190L)

//
// MessageId: STATUS_MUTANT_LIMIT_EXCEEDED
//
// MessageText:
//
//  An attempt was made to acquire a mutant such that its maximum count
//  would have been exceeded.
//
#define STATUS_MUTANT_LIMIT_EXCEEDED     ((NTSTATUS)0xC0000191L)

//
// MessageId: STATUS_NETLOGON_NOT_STARTED
//
// MessageText:
//
//   An attempt was made to logon, but the netlogon service was not started.
//
#define STATUS_NETLOGON_NOT_STARTED      ((NTSTATUS)0xC0000192L)

//
// MessageId: STATUS_ACCOUNT_EXPIRED
//
// MessageText:
//
//  The user's account has expired.
//
#define STATUS_ACCOUNT_EXPIRED           ((NTSTATUS)0xC0000193L)    // ntsubauth

//
// MessageId: STATUS_POSSIBLE_DEADLOCK
//
// MessageText:
//
//  {EXCEPTION}
//  Possible deadlock condition.
//
#define STATUS_POSSIBLE_DEADLOCK         ((NTSTATUS)0xC0000194L)

//
// MessageId: STATUS_NETWORK_CREDENTIAL_CONFLICT
//
// MessageText:
//
//  The credentials supplied conflict with an existing set of credentials.
//
#define STATUS_NETWORK_CREDENTIAL_CONFLICT ((NTSTATUS)0xC0000195L)

//
// MessageId: STATUS_REMOTE_SESSION_LIMIT
//
// MessageText:
//
//  An attempt was made to establish a session to a network server, but there
//  are already too many sessions established to that server.
//
#define STATUS_REMOTE_SESSION_LIMIT      ((NTSTATUS)0xC0000196L)

//
// MessageId: STATUS_EVENTLOG_FILE_CHANGED
//
// MessageText:
//
//  The log file has changed between reads.
//
#define STATUS_EVENTLOG_FILE_CHANGED     ((NTSTATUS)0xC0000197L)

//
// MessageId: STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT
//
// MessageText:
//
//  The account used is an Interdomain Trust account.  Use your global user account or local user account to access this server.
//
#define STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT ((NTSTATUS)0xC0000198L)

//
// MessageId: STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT
//
// MessageText:
//
//  The account used is a Computer Account.  Use your global user account or local user account to access this server.
//
#define STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT ((NTSTATUS)0xC0000199L)

//
// MessageId: STATUS_NOLOGON_SERVER_TRUST_ACCOUNT
//
// MessageText:
//
//  The account used is an Server Trust account.  Use your global user account or local user account to access this server.
//
#define STATUS_NOLOGON_SERVER_TRUST_ACCOUNT ((NTSTATUS)0xC000019AL)

//
// MessageId: STATUS_DOMAIN_TRUST_INCONSISTENT
//
// MessageText:
//
//  The name or SID of the domain specified is inconsistent with the trust information for that domain.
//
#define STATUS_DOMAIN_TRUST_INCONSISTENT ((NTSTATUS)0xC000019BL)

//
// MessageId: STATUS_FS_DRIVER_REQUIRED
//
// MessageText:
//
//  A volume has been accessed for which a file system driver is required that has not yet been loaded.
//
#define STATUS_FS_DRIVER_REQUIRED        ((NTSTATUS)0xC000019CL)

//
// MessageId: STATUS_NO_USER_SESSION_KEY
//
// MessageText:
//
//  There is no user session key for the specified logon session.
//
#define STATUS_NO_USER_SESSION_KEY       ((NTSTATUS)0xC0000202L)

//
// MessageId: STATUS_USER_SESSION_DELETED
//
// MessageText:
//
//  The remote user session has been deleted.
//
#define STATUS_USER_SESSION_DELETED      ((NTSTATUS)0xC0000203L)

//
// MessageId: STATUS_RESOURCE_LANG_NOT_FOUND
//
// MessageText:
//
//  Indicates the specified resource language ID cannot be found in the
//  image file.
//
#define STATUS_RESOURCE_LANG_NOT_FOUND   ((NTSTATUS)0xC0000204L)

//
// MessageId: STATUS_INSUFF_SERVER_RESOURCES
//
// MessageText:
//
//  Insufficient server resources exist to complete the request.
//
#define STATUS_INSUFF_SERVER_RESOURCES   ((NTSTATUS)0xC0000205L)

//
// MessageId: STATUS_INVALID_BUFFER_SIZE
//
// MessageText:
//
//  The size of the buffer is invalid for the specified operation.
//
#define STATUS_INVALID_BUFFER_SIZE       ((NTSTATUS)0xC0000206L)

//
// MessageId: STATUS_INVALID_ADDRESS_COMPONENT
//
// MessageText:
//
//  The transport rejected the network address specified as invalid.
//
#define STATUS_INVALID_ADDRESS_COMPONENT ((NTSTATUS)0xC0000207L)

//
// MessageId: STATUS_INVALID_ADDRESS_WILDCARD
//
// MessageText:
//
//  The transport rejected the network address specified due to an
//  invalid use of a wildcard.
//
#define STATUS_INVALID_ADDRESS_WILDCARD  ((NTSTATUS)0xC0000208L)

//
// MessageId: STATUS_TOO_MANY_ADDRESSES
//
// MessageText:
//
//  The transport address could not be opened because all the available
//  addresses are in use.
//
#define STATUS_TOO_MANY_ADDRESSES        ((NTSTATUS)0xC0000209L)

//
// MessageId: STATUS_ADDRESS_ALREADY_EXISTS
//
// MessageText:
//
//  The transport address could not be opened because it already exists.
//
#define STATUS_ADDRESS_ALREADY_EXISTS    ((NTSTATUS)0xC000020AL)

//
// MessageId: STATUS_ADDRESS_CLOSED
//
// MessageText:
//
//  The transport address is now closed.
//
#define STATUS_ADDRESS_CLOSED            ((NTSTATUS)0xC000020BL)

//
// MessageId: STATUS_CONNECTION_DISCONNECTED
//
// MessageText:
//
//  The transport connection is now disconnected.
//
#define STATUS_CONNECTION_DISCONNECTED   ((NTSTATUS)0xC000020CL)

//
// MessageId: STATUS_CONNECTION_RESET
//
// MessageText:
//
//  The transport connection has been reset.
//
#define STATUS_CONNECTION_RESET          ((NTSTATUS)0xC000020DL)

//
// MessageId: STATUS_TOO_MANY_NODES
//
// MessageText:
//
//  The transport cannot dynamically acquire any more nodes.
//
#define STATUS_TOO_MANY_NODES            ((NTSTATUS)0xC000020EL)

//
// MessageId: STATUS_TRANSACTION_ABORTED
//
// MessageText:
//
//  The transport aborted a pending transaction.
//
#define STATUS_TRANSACTION_ABORTED       ((NTSTATUS)0xC000020FL)

//
// MessageId: STATUS_TRANSACTION_TIMED_OUT
//
// MessageText:
//
//  The transport timed out a request waiting for a response.
//
#define STATUS_TRANSACTION_TIMED_OUT     ((NTSTATUS)0xC0000210L)

//
// MessageId: STATUS_TRANSACTION_NO_RELEASE
//
// MessageText:
//
//  The transport did not receive a release for a pending response.
//
#define STATUS_TRANSACTION_NO_RELEASE    ((NTSTATUS)0xC0000211L)

//
// MessageId: STATUS_TRANSACTION_NO_MATCH
//
// MessageText:
//
//  The transport did not find a transaction matching the specific
//  token.
//
#define STATUS_TRANSACTION_NO_MATCH      ((NTSTATUS)0xC0000212L)

//
// MessageId: STATUS_TRANSACTION_RESPONDED
//
// MessageText:
//
//  The transport had previously responded to a transaction request.
//
#define STATUS_TRANSACTION_RESPONDED     ((NTSTATUS)0xC0000213L)

//
// MessageId: STATUS_TRANSACTION_INVALID_ID
//
// MessageText:
//
//  The transport does not recognized the transaction request
//  identifier specified.
//
#define STATUS_TRANSACTION_INVALID_ID    ((NTSTATUS)0xC0000214L)

//
// MessageId: STATUS_TRANSACTION_INVALID_TYPE
//
// MessageText:
//
//  The transport does not recognize the transaction request
//  type specified.
//
#define STATUS_TRANSACTION_INVALID_TYPE  ((NTSTATUS)0xC0000215L)

//
// MessageId: STATUS_NOT_SERVER_SESSION
//
// MessageText:
//
//  The transport can only process the specified request on
//  the server side of a session.
//
#define STATUS_NOT_SERVER_SESSION        ((NTSTATUS)0xC0000216L)

//
// MessageId: STATUS_NOT_CLIENT_SESSION
//
// MessageText:
//
//  The transport can only process the specified request on
//  the client side of a session.
//
#define STATUS_NOT_CLIENT_SESSION        ((NTSTATUS)0xC0000217L)

//
// MessageId: STATUS_CANNOT_LOAD_REGISTRY_FILE
//
// MessageText:
//
//  {Registry File Failure}
//  The registry cannot load the hive (file):
//  %s
//  or its log or alternate.
//  It is corrupt, absent, or not writeable.
//
#define STATUS_CANNOT_LOAD_REGISTRY_FILE ((NTSTATUS)0xC0000218L)

//
// MessageId: STATUS_DEBUG_ATTACH_FAILED
//
// MessageText:
//
//  {Unexpected Failure in DebugActiveProcess}
//  An unexpected failure occurred while processing a DebugActiveProcess API
//  request.  You may choose OK to terminate the process, or Cancel to
//  ignore the error.
//
#define STATUS_DEBUG_ATTACH_FAILED       ((NTSTATUS)0xC0000219L)

//
// MessageId: STATUS_SYSTEM_PROCESS_TERMINATED
//
// MessageText:
//
//  {Fatal System Error}
//  The %s system process terminated unexpectedly
//  with a status of 0x%08x (0x%08x 0x%08x).
//  The system has been shut down.
//
#define STATUS_SYSTEM_PROCESS_TERMINATED ((NTSTATUS)0xC000021AL)

//
// MessageId: STATUS_DATA_NOT_ACCEPTED
//
// MessageText:
//
//  {Data Not Accepted}
//  The TDI client could not handle the data received during an
//  indication.
//
#define STATUS_DATA_NOT_ACCEPTED         ((NTSTATUS)0xC000021BL)

//
// MessageId: STATUS_NO_BROWSER_SERVERS_FOUND
//
// MessageText:
//
//  {Unable to Retrieve Browser Server List}
//  The list of servers for this workgroup is not currently available.
//
#define STATUS_NO_BROWSER_SERVERS_FOUND  ((NTSTATUS)0xC000021CL)

//
// MessageId: STATUS_VDM_HARD_ERROR
//
// MessageText:
//
//  NTVDM encountered a hard error.
//
#define STATUS_VDM_HARD_ERROR            ((NTSTATUS)0xC000021DL)

//
// MessageId: STATUS_DRIVER_CANCEL_TIMEOUT
//
// MessageText:
//
//  {Cancel Timeout}
//  The driver %s failed to complete a cancelled I/O request in the allotted time.
//
#define STATUS_DRIVER_CANCEL_TIMEOUT     ((NTSTATUS)0xC000021EL)

//
// MessageId: STATUS_REPLY_MESSAGE_MISMATCH
//
// MessageText:
//
//  {Reply Message Mismatch}
//  An attempt was made to reply to an LPC message, but the thread specified
//  by the client ID in the message was not waiting on that message.
//
#define STATUS_REPLY_MESSAGE_MISMATCH    ((NTSTATUS)0xC000021FL)

//
// MessageId: STATUS_MAPPED_ALIGNMENT
//
// MessageText:
//
//  {Mapped View Aligment Incorrect}
//  An attempt was made to map a view of a file, but either the specified base
//  address or the offset into the file were not aligned on the proper
//  allocation granularity.
//
#define STATUS_MAPPED_ALIGNMENT          ((NTSTATUS)0xC0000220L)

//
// MessageId: STATUS_IMAGE_CHECKSUM_MISMATCH
//
// MessageText:
//
//  {Bad Image Checksum}
//  The image %s is possibly corrupt. The header checksum does not
//  match the computed checksum.
//
#define STATUS_IMAGE_CHECKSUM_MISMATCH   ((NTSTATUS)0xC0000221L)

//
// MessageId: STATUS_LOST_WRITEBEHIND_DATA
//
// MessageText:
//
//  {Lost Delayed-Write Data}
//  The system was attempting to transfer file data from buffers to %s.
//  The write operation failed, and only some of the data may have been
//  written to the file.
//
#define STATUS_LOST_WRITEBEHIND_DATA     ((NTSTATUS)0xC0000222L)

//
// MessageId: STATUS_CLIENT_SERVER_PARAMETERS_INVALID
//
// MessageText:
//
//  The parameter(s) passed to the server in the client/server shared memory
//  window were invalid. Too much data may have been put in the shared memory
//  window.
//
#define STATUS_CLIENT_SERVER_PARAMETERS_INVALID ((NTSTATUS)0xC0000223L)

//
// MessageId: STATUS_PASSWORD_MUST_CHANGE
//
// MessageText:
//
//  The user must change his password before he logs on the first time.
//
#define STATUS_PASSWORD_MUST_CHANGE      ((NTSTATUS)0xC0000224L)    // ntsubauth

//
// MessageId: STATUS_NOT_FOUND
//
// MessageText:
//
//  The object was not found.
//
#define STATUS_NOT_FOUND                 ((NTSTATUS)0xC0000225L)

//
// MessageId: STATUS_NOT_TINY_STREAM
//
// MessageText:
//
//  The stream is not a tiny stream.
//
#define STATUS_NOT_TINY_STREAM           ((NTSTATUS)0xC0000226L)

//
// MessageId: STATUS_RECOVERY_FAILURE
//
// MessageText:
//
//  A transaction recover failed.
//
#define STATUS_RECOVERY_FAILURE          ((NTSTATUS)0xC0000227L)

//
// MessageId: STATUS_STACK_OVERFLOW_READ
//
// MessageText:
//
//  The request must be handled by the stack overflow code.
//
#define STATUS_STACK_OVERFLOW_READ       ((NTSTATUS)0xC0000228L)

//
// MessageId: STATUS_FAIL_CHECK
//
// MessageText:
//
//  A consistancy check failed.
//
#define STATUS_FAIL_CHECK                ((NTSTATUS)0xC0000229L)

//
// MessageId: STATUS_DUPLICATE_OBJECTID
//
// MessageText:
//
//  The attempt to insert the ID in the index failed because the
//  ID is already in the index.
//
#define STATUS_DUPLICATE_OBJECTID        ((NTSTATUS)0xC000022AL)

//
// MessageId: STATUS_OBJECTID_EXISTS
//
// MessageText:
//
//  The attempt to set the object's ID failed because the object
//  already has an ID.
//
#define STATUS_OBJECTID_EXISTS           ((NTSTATUS)0xC000022BL)

//
// MessageId: STATUS_CONVERT_TO_LARGE
//
// MessageText:
//
//  Internal OFS status codes indicating how an allocation operation is
//  handled.  Either it is retried after the containing onode is moved
//  or the extent stream is converted to a large stream.
//
#define STATUS_CONVERT_TO_LARGE          ((NTSTATUS)0xC000022CL)

//
// MessageId: STATUS_RETRY
//
// MessageText:
//
//  The request needs to be retried.
//
#define STATUS_RETRY                     ((NTSTATUS)0xC000022DL)

//
// MessageId: STATUS_FOUND_OUT_OF_SCOPE
//
// MessageText:
//
//  The attempt to find the object found an object matching by ID
//  on the volume but it is out of the scope of the handle used
//  for the operation.
//
#define STATUS_FOUND_OUT_OF_SCOPE        ((NTSTATUS)0xC000022EL)

//
// MessageId: STATUS_ALLOCATE_BUCKET
//
// MessageText:
//
//  The bucket array must be grown.  Retry transaction after doing so.
//
#define STATUS_ALLOCATE_BUCKET           ((NTSTATUS)0xC000022FL)

//
// MessageId: STATUS_PROPSET_NOT_FOUND
//
// MessageText:
//
//  The property set specified does not exist on the object.
//
#define STATUS_PROPSET_NOT_FOUND         ((NTSTATUS)0xC0000230L)

//
// MessageId: STATUS_MARSHALL_OVERFLOW
//
// MessageText:
//
//  The user/kernel marshalling buffer has overflowed.
//
#define STATUS_MARSHALL_OVERFLOW         ((NTSTATUS)0xC0000231L)

//
// MessageId: STATUS_INVALID_VARIANT
//
// MessageText:
//
//  The supplied variant structure contains invalid data.
//
#define STATUS_INVALID_VARIANT           ((NTSTATUS)0xC0000232L)

//
// MessageId: STATUS_DOMAIN_CONTROLLER_NOT_FOUND
//
// MessageText:
//
//  Could not find a domain controller for this domain.
//
#define STATUS_DOMAIN_CONTROLLER_NOT_FOUND ((NTSTATUS)0xC0000233L)

//
// MessageId: STATUS_ACCOUNT_LOCKED_OUT
//
// MessageText:
//
//  The user account has been automatically locked because too many invalid logon
//  attempts or password change attempts have been requested.
//
#define STATUS_ACCOUNT_LOCKED_OUT        ((NTSTATUS)0xC0000234L)    // ntsubauth

//
// MessageId: STATUS_HANDLE_NOT_CLOSABLE
//
// MessageText:
//
//  NtClose was called on a handle that was protected from close via NtSetInformationObject.
//
#define STATUS_HANDLE_NOT_CLOSABLE       ((NTSTATUS)0xC0000235L)

//
// MessageId: STATUS_CONNECTION_REFUSED
//
// MessageText:
//
//  The transport connection attempt was refused by the remote system.
//
#define STATUS_CONNECTION_REFUSED        ((NTSTATUS)0xC0000236L)

//
// MessageId: STATUS_GRACEFUL_DISCONNECT
//
// MessageText:
//
//  The transport connection was gracefully closed.
//
#define STATUS_GRACEFUL_DISCONNECT       ((NTSTATUS)0xC0000237L)

//
// MessageId: STATUS_ADDRESS_ALREADY_ASSOCIATED
//
// MessageText:
//
//  The transport endpoint already has an address associated with it.
//
#define STATUS_ADDRESS_ALREADY_ASSOCIATED ((NTSTATUS)0xC0000238L)

//
// MessageId: STATUS_ADDRESS_NOT_ASSOCIATED
//
// MessageText:
//
//  An address has not yet been associated with the transport endpoint.
//
#define STATUS_ADDRESS_NOT_ASSOCIATED    ((NTSTATUS)0xC0000239L)

//
// MessageId: STATUS_CONNECTION_INVALID
//
// MessageText:
//
//  An operation was attempted on a nonexistent transport connection.
//
#define STATUS_CONNECTION_INVALID        ((NTSTATUS)0xC000023AL)

//
// MessageId: STATUS_CONNECTION_ACTIVE
//
// MessageText:
//
//  An invalid operation was attempted on an active transport connection.
//
#define STATUS_CONNECTION_ACTIVE         ((NTSTATUS)0xC000023BL)

//
// MessageId: STATUS_NETWORK_UNREACHABLE
//
// MessageText:
//
//  The remote network is not reachable by the transport.
//
#define STATUS_NETWORK_UNREACHABLE       ((NTSTATUS)0xC000023CL)

//
// MessageId: STATUS_HOST_UNREACHABLE
//
// MessageText:
//
//  The remote system is not reachable by the transport.
//
#define STATUS_HOST_UNREACHABLE          ((NTSTATUS)0xC000023DL)

//
// MessageId: STATUS_PROTOCOL_UNREACHABLE
//
// MessageText:
//
//  The remote system does not support the transport protocol.
//
#define STATUS_PROTOCOL_UNREACHABLE      ((NTSTATUS)0xC000023EL)

//
// MessageId: STATUS_PORT_UNREACHABLE
//
// MessageText:
//
//  No service is operating at the destination port of the transport
//  on the remote system.
//
#define STATUS_PORT_UNREACHABLE          ((NTSTATUS)0xC000023FL)

//
// MessageId: STATUS_REQUEST_ABORTED
//
// MessageText:
//
//  The request was aborted.
//
#define STATUS_REQUEST_ABORTED           ((NTSTATUS)0xC0000240L)

//
// MessageId: STATUS_CONNECTION_ABORTED
//
// MessageText:
//
//  The transport connection was aborted by the local system.
//
#define STATUS_CONNECTION_ABORTED        ((NTSTATUS)0xC0000241L)

//
// MessageId: STATUS_BAD_COMPRESSION_BUFFER
//
// MessageText:
//
//  The specified buffer contains ill-formed data.
//
#define STATUS_BAD_COMPRESSION_BUFFER    ((NTSTATUS)0xC0000242L)

//
// MessageId: STATUS_USER_MAPPED_FILE
//
// MessageText:
//
//  The requested operation cannot be performed on a file with a user mapped section open.
//
#define STATUS_USER_MAPPED_FILE          ((NTSTATUS)0xC0000243L)

//
// MessageId: STATUS_AUDIT_FAILED
//
// MessageText:
//
//  {Audit Failed}
//  An attempt to generate a security audit failed.
//
#define STATUS_AUDIT_FAILED              ((NTSTATUS)0xC0000244L)

//
// MessageId: STATUS_TIMER_RESOLUTION_NOT_SET
//
// MessageText:
//
//  The timer resolution was not previously set by the current process.
//
#define STATUS_TIMER_RESOLUTION_NOT_SET  ((NTSTATUS)0xC0000245L)

//
// MessageId: STATUS_CONNECTION_COUNT_LIMIT
//
// MessageText:
//
//  A connection to the server could not be made because the limit on the number of
//  concurrent connections for this account has been reached.
//
#define STATUS_CONNECTION_COUNT_LIMIT    ((NTSTATUS)0xC0000246L)

//
// MessageId: STATUS_LOGIN_TIME_RESTRICTION
//
// MessageText:
//
//  Attempting to login during an unauthorized time of day for this account.
//
#define STATUS_LOGIN_TIME_RESTRICTION    ((NTSTATUS)0xC0000247L)

//
// MessageId: STATUS_LOGIN_WKSTA_RESTRICTION
//
// MessageText:
//
//  The account is not authorized to login from this station.
//
#define STATUS_LOGIN_WKSTA_RESTRICTION   ((NTSTATUS)0xC0000248L)

//
// MessageId: STATUS_IMAGE_MP_UP_MISMATCH
//
// MessageText:
//
//  {UP/MP Image Mismatch}
//  The image %s has been modified for use on a uniprocessor system,
//  but you are running it on a multiprocessor machine.
//  Please reinstall the image file.
//
#define STATUS_IMAGE_MP_UP_MISMATCH      ((NTSTATUS)0xC0000249L)

//
// MessageId: STATUS_INSUFFICIENT_LOGON_INFO
//
// MessageText:
//
//  There is insufficient account information to log you on.
//
#define STATUS_INSUFFICIENT_LOGON_INFO   ((NTSTATUS)0xC0000250L)

//
// MessageId: STATUS_BAD_DLL_ENTRYPOINT
//
// MessageText:
//
//  {Invalid DLL Entrypoint}
//  The dynamic link library %s is not written correctly. The stack pointer has been left in an inconsistent state.
//  The entrypoint should be declared as WINAPI or STDCALL. Select YES to fail the DLL load. Select NO to continue
//  execution. Selecting NO may cause the application to operate incorrectly.
//
#define STATUS_BAD_DLL_ENTRYPOINT        ((NTSTATUS)0xC0000251L)

//
// MessageId: STATUS_BAD_SERVICE_ENTRYPOINT
//
// MessageText:
//
//  {Invalid Service Callback Entrypoint}
//  The %s service is not written correctly. The stack pointer has been left in an inconsistent state.
//  The callback entrypoint should be declared as WINAPI or STDCALL. Selecting OK will cause the
//  service to continue operation. However, the service process may operate incorrectly.
//
#define STATUS_BAD_SERVICE_ENTRYPOINT    ((NTSTATUS)0xC0000252L)

//
// MessageId: STATUS_LPC_REPLY_LOST
//
// MessageText:
//
//  The server received the messages but did not send a reply.
//
#define STATUS_LPC_REPLY_LOST            ((NTSTATUS)0xC0000253L)

//
// MessageId: STATUS_IP_ADDRESS_CONFLICT1
//
// MessageText:
//
//  The system has detected an IP address conflict with another system on the
//  network. The local interface has been disabled. More details are available in
//  the system event log. Consult your network administrator to resolve the
//  conflict.
//
#define STATUS_IP_ADDRESS_CONFLICT1      ((NTSTATUS)0xC0000254L)

//
// MessageId: STATUS_IP_ADDRESS_CONFLICT2
//
// MessageText:
//
//  The system has detected an IP address conflict with another system on the
//  network. Network operations on this system may be disrupted as a result.
//  More details are available in the system event log. Consult your network
//  administrator immediately to resolve the conflict.
//
#define STATUS_IP_ADDRESS_CONFLICT2      ((NTSTATUS)0xC0000255L)

//
// MessageId: STATUS_REGISTRY_QUOTA_LIMIT
//
// MessageText:
//
//  {Low on Registry Quota}
//  Your system is running low on registry quota.
//  Start the System option in the Control Panel and choose the Virtual Memory button to increase the registry quota.
//
#define STATUS_REGISTRY_QUOTA_LIMIT      ((NTSTATUS)0xC0000256L)

//
// MessageId: STATUS_PATH_NOT_COVERED
//
// MessageText:
//
//  The contacted server does not support the indicated part of the DFS namespace.
//
#define STATUS_PATH_NOT_COVERED          ((NTSTATUS)0xC0000257L)

//
// MessageId: STATUS_NO_CALLBACK_ACTIVE
//
// MessageText:
//
//  A callback return system service cannot be executed when no callback is active.
//
#define STATUS_NO_CALLBACK_ACTIVE        ((NTSTATUS)0xC0000258L)

//
// MessageId: STATUS_LICENSE_QUOTA_EXCEEDED
//
// MessageText:
//
//  The service being accessed is licensed for a particular number of connections.
//  No more connections can be made to the service at this time
//  because there are already as many connections as the service can accept.
//
#define STATUS_LICENSE_QUOTA_EXCEEDED    ((NTSTATUS)0xC0000259L)

//
// MessageId: STATUS_PWD_TOO_SHORT
//
// MessageText:
//
//  The password provided is too short to meet the policy of your user account.
//  Please choose a longer password.
//
#define STATUS_PWD_TOO_SHORT             ((NTSTATUS)0xC000025AL)

//
// MessageId: STATUS_PWD_TOO_RECENT
//
// MessageText:
//
//  The policy of your user account does not allow you to change passwords too
//  frequently.  This is done to prevent users from changing back to a familiar, but
//  potentially discovered, password.  If you feel your password has been compromised
//  then please contact your administrator immediately to have a new one assigned.
//
#define STATUS_PWD_TOO_RECENT            ((NTSTATUS)0xC000025BL)

//
// MessageId: STATUS_PWD_HISTORY_CONFLICT
//
// MessageText:
//
//  You have attempted to change your password to one that you have used in the past.
//  The policy of your user account does not allow this.  Please select a password
//  that you have not previously used.
//
#define STATUS_PWD_HISTORY_CONFLICT      ((NTSTATUS)0xC000025CL)

//
// MessageId: STATUS_PLUGPLAY_NO_DEVICE
//
// MessageText:
//
//  You have attempted to load a legacy device driver while its device instance had
//  been disabled.
//
#define STATUS_PLUGPLAY_NO_DEVICE        ((NTSTATUS)0xC000025EL)

//
// MessageId: STATUS_UNSUPPORTED_COMPRESSION
//
// MessageText:
//
//  The specified compression format is unsupported.
//
#define STATUS_UNSUPPORTED_COMPRESSION   ((NTSTATUS)0xC000025FL)

//
// MessageId: STATUS_INVALID_HW_PROFILE
//
// MessageText:
//
//  The specified hardware profile configuration is invalid.
//
#define STATUS_INVALID_HW_PROFILE        ((NTSTATUS)0xC0000260L)

//
// MessageId: STATUS_INVALID_PLUGPLAY_DEVICE_PATH
//
// MessageText:
//
//  The specified Plug and Play registry device path is invalid.
//
#define STATUS_INVALID_PLUGPLAY_DEVICE_PATH ((NTSTATUS)0xC0000261L)

//
// MessageId: STATUS_DRIVER_ORDINAL_NOT_FOUND
//
// MessageText:
//
//  {Driver Entry Point Not Found}
//  The %s device driver could not locate the ordinal %ld in driver %s.
//
#define STATUS_DRIVER_ORDINAL_NOT_FOUND  ((NTSTATUS)0xC0000262L)

//
// MessageId: STATUS_DRIVER_ENTRYPOINT_NOT_FOUND
//
// MessageText:
//
//  {Driver Entry Point Not Found}
//  The %s device driver could not locate the entry point %s in driver %s.
//
#define STATUS_DRIVER_ENTRYPOINT_NOT_FOUND ((NTSTATUS)0xC0000263L)

//
// MessageId: STATUS_RESOURCE_NOT_OWNED
//
// MessageText:
//
//  {Application Error}
//  The application attempted to release a resource it did not own.  Click on OK to
//  terminate the application.
//
#define STATUS_RESOURCE_NOT_OWNED        ((NTSTATUS)0xC0000264L)

//
// MessageId: STATUS_TOO_MANY_LINKS
//
// MessageText:
//
//  An attempt was made to create more links on a file than
//  the file system supports.
//
#define STATUS_TOO_MANY_LINKS            ((NTSTATUS)0xC0000265L)

//
// MessageId: STATUS_QUOTA_LIST_INCONSISTENT
//
// MessageText:
//
//  The specified quota list is internally inconsistent with its descriptor.
//
#define STATUS_QUOTA_LIST_INCONSISTENT   ((NTSTATUS)0xC0000266L)

//
// MessageId: STATUS_FILE_IS_OFFLINE
//
// MessageText:
//
//  The specified file has been relocated to offline storage.
//
#define STATUS_FILE_IS_OFFLINE           ((NTSTATUS)0xC0000267L)

//
// MessageId: STATUS_EVALUATION_EXPIRATION
//
// MessageText:
//
//  {Windows NT Evaluation Notification}
//  The evaluation period for this installation of Windows NT has expired.
//  This system will shutdown in 1 hour. To restore access to this installation
//  of Windows NT, please upgrade this installation using a licensed distribution
//  of this product.
//
#define STATUS_EVALUATION_EXPIRATION     ((NTSTATUS)0xC0000268L)

//
// MessageId: STATUS_ILLEGAL_DLL_RELOCATION
//
// MessageText:
//
//  {Illegal System DLL Relocation}
//  The system DLL %s was relocated in memory. The application will not run properly.
//  The relocation occured because the DLL %s occupied an address range reserved for
//  Windows NT system DLL's. The vendor supplying the DLL should be contacted for a new DLL.
//
#define STATUS_ILLEGAL_DLL_RELOCATION    ((NTSTATUS)0xC0000269L)

//
// MessageId: STATUS_LICENSE_VIOLATION
//
// MessageText:
//
//  {License Violation}
//  The system has detected tampering with your registered product type. This is a violation
//  of your software license. Tampering with product type is not permitted.
//
#define STATUS_LICENSE_VIOLATION         ((NTSTATUS)0xC000026AL)

//
// MessageId: STATUS_DLL_INIT_FAILED_LOGOFF
//
// MessageText:
//
//  {DLL Initialization Failed}
//  The application failed to initialize because the window station is shutting down.
//
#define STATUS_DLL_INIT_FAILED_LOGOFF    ((NTSTATUS)0xC000026BL)

//
// MessageId: STATUS_DRIVER_UNABLE_TO_LOAD
//
// MessageText:
//
//  {Unable to Load Device Driver}
//  %s device driver could not be loaded.
//  Error Status was 0x%x
//
#define STATUS_DRIVER_UNABLE_TO_LOAD     ((NTSTATUS)0xC000026CL)

//
// MessageId: STATUS_DFS_UNAVAILABLE
//
// MessageText:
//
//  DFS is unavailable on the contacted server.
//
#define STATUS_DFS_UNAVAILABLE           ((NTSTATUS)0xC000026DL)

//
// MessageId: STATUS_VOLUME_DISMOUNTED
//
// MessageText:
//
//  An operation was attempted to a volume after it was dismounted.
//
#define STATUS_VOLUME_DISMOUNTED         ((NTSTATUS)0xC000026EL)

//
// MessageId: STATUS_WX86_INTERNAL_ERROR
//
// MessageText:
//
//  An internal error occurred in the Win32 x86 emulation subsystem.
//
#define STATUS_WX86_INTERNAL_ERROR       ((NTSTATUS)0xC000026FL)

//
// MessageId: STATUS_WX86_FLOAT_STACK_CHECK
//
// MessageText:
//
//  Win32 x86 emulation subsystem Floating-point stack check.
//
#define STATUS_WX86_FLOAT_STACK_CHECK    ((NTSTATUS)0xC0000270L)

//
// MessageId: STATUS_WOW_ASSERTION
//
// MessageText:
//
//  WOW Assertion Error.
//
#define STATUS_WOW_ASSERTION             ((NTSTATUS)0xC0009898L)

//
// MessageId: RPC_NT_INVALID_STRING_BINDING
//
// MessageText:
//
//  The string binding is invalid.
//
#define RPC_NT_INVALID_STRING_BINDING    ((NTSTATUS)0xC0020001L)

//
// MessageId: RPC_NT_WRONG_KIND_OF_BINDING
//
// MessageText:
//
//  The binding handle is not the correct type.
//
#define RPC_NT_WRONG_KIND_OF_BINDING     ((NTSTATUS)0xC0020002L)

//
// MessageId: RPC_NT_INVALID_BINDING
//
// MessageText:
//
//  The binding handle is invalid.
//
#define RPC_NT_INVALID_BINDING           ((NTSTATUS)0xC0020003L)

//
// MessageId: RPC_NT_PROTSEQ_NOT_SUPPORTED
//
// MessageText:
//
//  The RPC protocol sequence is not supported.
//
#define RPC_NT_PROTSEQ_NOT_SUPPORTED     ((NTSTATUS)0xC0020004L)

//
// MessageId: RPC_NT_INVALID_RPC_PROTSEQ
//
// MessageText:
//
//  The RPC protocol sequence is invalid.
//
#define RPC_NT_INVALID_RPC_PROTSEQ       ((NTSTATUS)0xC0020005L)

//
// MessageId: RPC_NT_INVALID_STRING_UUID
//
// MessageText:
//
//  The string UUID is invalid.
//
#define RPC_NT_INVALID_STRING_UUID       ((NTSTATUS)0xC0020006L)

//
// MessageId: RPC_NT_INVALID_ENDPOINT_FORMAT
//
// MessageText:
//
//  The endpoint format is invalid.
//
#define RPC_NT_INVALID_ENDPOINT_FORMAT   ((NTSTATUS)0xC0020007L)

//
// MessageId: RPC_NT_INVALID_NET_ADDR
//
// MessageText:
//
//  The network address is invalid.
//
#define RPC_NT_INVALID_NET_ADDR          ((NTSTATUS)0xC0020008L)

//
// MessageId: RPC_NT_NO_ENDPOINT_FOUND
//
// MessageText:
//
//  No endpoint was found.
//
#define RPC_NT_NO_ENDPOINT_FOUND         ((NTSTATUS)0xC0020009L)

//
// MessageId: RPC_NT_INVALID_TIMEOUT
//
// MessageText:
//
//  The timeout value is invalid.
//
#define RPC_NT_INVALID_TIMEOUT           ((NTSTATUS)0xC002000AL)

//
// MessageId: RPC_NT_OBJECT_NOT_FOUND
//
// MessageText:
//
//  The object UUID was not found.
//
#define RPC_NT_OBJECT_NOT_FOUND          ((NTSTATUS)0xC002000BL)

//
// MessageId: RPC_NT_ALREADY_REGISTERED
//
// MessageText:
//
//  The object UUID has already been registered.
//
#define RPC_NT_ALREADY_REGISTERED        ((NTSTATUS)0xC002000CL)

//
// MessageId: RPC_NT_TYPE_ALREADY_REGISTERED
//
// MessageText:
//
//  The type UUID has already been registered.
//
#define RPC_NT_TYPE_ALREADY_REGISTERED   ((NTSTATUS)0xC002000DL)

//
// MessageId: RPC_NT_ALREADY_LISTENING
//
// MessageText:
//
//  The RPC server is already listening.
//
#define RPC_NT_ALREADY_LISTENING         ((NTSTATUS)0xC002000EL)

//
// MessageId: RPC_NT_NO_PROTSEQS_REGISTERED
//
// MessageText:
//
//  No protocol sequences have been registered.
//
#define RPC_NT_NO_PROTSEQS_REGISTERED    ((NTSTATUS)0xC002000FL)

//
// MessageId: RPC_NT_NOT_LISTENING
//
// MessageText:
//
//  The RPC server is not listening.
//
#define RPC_NT_NOT_LISTENING             ((NTSTATUS)0xC0020010L)

//
// MessageId: RPC_NT_UNKNOWN_MGR_TYPE
//
// MessageText:
//
//  The manager type is unknown.
//
#define RPC_NT_UNKNOWN_MGR_TYPE          ((NTSTATUS)0xC0020011L)

//
// MessageId: RPC_NT_UNKNOWN_IF
//
// MessageText:
//
//  The interface is unknown.
//
#define RPC_NT_UNKNOWN_IF                ((NTSTATUS)0xC0020012L)

//
// MessageId: RPC_NT_NO_BINDINGS
//
// MessageText:
//
//  There are no bindings.
//
#define RPC_NT_NO_BINDINGS               ((NTSTATUS)0xC0020013L)

//
// MessageId: RPC_NT_NO_PROTSEQS
//
// MessageText:
//
//  There are no protocol sequences.
//
#define RPC_NT_NO_PROTSEQS               ((NTSTATUS)0xC0020014L)

//
// MessageId: RPC_NT_CANT_CREATE_ENDPOINT
//
// MessageText:
//
//  The endpoint cannot be created.
//
#define RPC_NT_CANT_CREATE_ENDPOINT      ((NTSTATUS)0xC0020015L)

//
// MessageId: RPC_NT_OUT_OF_RESOURCES
//
// MessageText:
//
//  Not enough resources are available to complete this operation.
//
#define RPC_NT_OUT_OF_RESOURCES          ((NTSTATUS)0xC0020016L)

//
// MessageId: RPC_NT_SERVER_UNAVAILABLE
//
// MessageText:
//
//  The RPC server is unavailable.
//
#define RPC_NT_SERVER_UNAVAILABLE        ((NTSTATUS)0xC0020017L)

//
// MessageId: RPC_NT_SERVER_TOO_BUSY
//
// MessageText:
//
//  The RPC server is too busy to complete this operation.
//
#define RPC_NT_SERVER_TOO_BUSY           ((NTSTATUS)0xC0020018L)

//
// MessageId: RPC_NT_INVALID_NETWORK_OPTIONS
//
// MessageText:
//
//  The network options are invalid.
//
#define RPC_NT_INVALID_NETWORK_OPTIONS   ((NTSTATUS)0xC0020019L)

//
// MessageId: RPC_NT_NO_CALL_ACTIVE
//
// MessageText:
//
//  There is not a remote procedure call active in this thread.
//
#define RPC_NT_NO_CALL_ACTIVE            ((NTSTATUS)0xC002001AL)

//
// MessageId: RPC_NT_CALL_FAILED
//
// MessageText:
//
//  The remote procedure call failed.
//
#define RPC_NT_CALL_FAILED               ((NTSTATUS)0xC002001BL)

//
// MessageId: RPC_NT_CALL_FAILED_DNE
//
// MessageText:
//
//  The remote procedure call failed and did not execute.
//
#define RPC_NT_CALL_FAILED_DNE           ((NTSTATUS)0xC002001CL)

//
// MessageId: RPC_NT_PROTOCOL_ERROR
//
// MessageText:
//
//  An RPC protocol error occurred.
//
#define RPC_NT_PROTOCOL_ERROR            ((NTSTATUS)0xC002001DL)

//
// MessageId: RPC_NT_UNSUPPORTED_TRANS_SYN
//
// MessageText:
//
//  The transfer syntax is not supported by the RPC server.
//
#define RPC_NT_UNSUPPORTED_TRANS_SYN     ((NTSTATUS)0xC002001FL)

//
// MessageId: RPC_NT_UNSUPPORTED_TYPE
//
// MessageText:
//
//  The type UUID is not supported.
//
#define RPC_NT_UNSUPPORTED_TYPE          ((NTSTATUS)0xC0020021L)

//
// MessageId: RPC_NT_INVALID_TAG
//
// MessageText:
//
//  The tag is invalid.
//
#define RPC_NT_INVALID_TAG               ((NTSTATUS)0xC0020022L)

//
// MessageId: RPC_NT_INVALID_BOUND
//
// MessageText:
//
//  The array bounds are invalid.
//
#define RPC_NT_INVALID_BOUND             ((NTSTATUS)0xC0020023L)

//
// MessageId: RPC_NT_NO_ENTRY_NAME
//
// MessageText:
//
//  The binding does not contain an entry name.
//
#define RPC_NT_NO_ENTRY_NAME             ((NTSTATUS)0xC0020024L)

//
// MessageId: RPC_NT_INVALID_NAME_SYNTAX
//
// MessageText:
//
//  The name syntax is invalid.
//
#define RPC_NT_INVALID_NAME_SYNTAX       ((NTSTATUS)0xC0020025L)

//
// MessageId: RPC_NT_UNSUPPORTED_NAME_SYNTAX
//
// MessageText:
//
//  The name syntax is not supported.
//
#define RPC_NT_UNSUPPORTED_NAME_SYNTAX   ((NTSTATUS)0xC0020026L)

//
// MessageId: RPC_NT_UUID_NO_ADDRESS
//
// MessageText:
//
//  No network address is available to use to construct a UUID.
//
#define RPC_NT_UUID_NO_ADDRESS           ((NTSTATUS)0xC0020028L)

//
// MessageId: RPC_NT_DUPLICATE_ENDPOINT
//
// MessageText:
//
//  The endpoint is a duplicate.
//
#define RPC_NT_DUPLICATE_ENDPOINT        ((NTSTATUS)0xC0020029L)

//
// MessageId: RPC_NT_UNKNOWN_AUTHN_TYPE
//
// MessageText:
//
//  The authentication type is unknown.
//
#define RPC_NT_UNKNOWN_AUTHN_TYPE        ((NTSTATUS)0xC002002AL)

//
// MessageId: RPC_NT_MAX_CALLS_TOO_SMALL
//
// MessageText:
//
//  The maximum number of calls is too small.
//
#define RPC_NT_MAX_CALLS_TOO_SMALL       ((NTSTATUS)0xC002002BL)

//
// MessageId: RPC_NT_STRING_TOO_LONG
//
// MessageText:
//
//  The string is too long.
//
#define RPC_NT_STRING_TOO_LONG           ((NTSTATUS)0xC002002CL)

//
// MessageId: RPC_NT_PROTSEQ_NOT_FOUND
//
// MessageText:
//
//  The RPC protocol sequence was not found.
//
#define RPC_NT_PROTSEQ_NOT_FOUND         ((NTSTATUS)0xC002002DL)

//
// MessageId: RPC_NT_PROCNUM_OUT_OF_RANGE
//
// MessageText:
//
//  The procedure number is out of range.
//
#define RPC_NT_PROCNUM_OUT_OF_RANGE      ((NTSTATUS)0xC002002EL)

//
// MessageId: RPC_NT_BINDING_HAS_NO_AUTH
//
// MessageText:
//
//  The binding does not contain any authentication information.
//
#define RPC_NT_BINDING_HAS_NO_AUTH       ((NTSTATUS)0xC002002FL)

//
// MessageId: RPC_NT_UNKNOWN_AUTHN_SERVICE
//
// MessageText:
//
//  The authentication service is unknown.
//
#define RPC_NT_UNKNOWN_AUTHN_SERVICE     ((NTSTATUS)0xC0020030L)

//
// MessageId: RPC_NT_UNKNOWN_AUTHN_LEVEL
//
// MessageText:
//
//  The authentication level is unknown.
//
#define RPC_NT_UNKNOWN_AUTHN_LEVEL       ((NTSTATUS)0xC0020031L)

//
// MessageId: RPC_NT_INVALID_AUTH_IDENTITY
//
// MessageText:
//
//  The security context is invalid.
//
#define RPC_NT_INVALID_AUTH_IDENTITY     ((NTSTATUS)0xC0020032L)

//
// MessageId: RPC_NT_UNKNOWN_AUTHZ_SERVICE
//
// MessageText:
//
//  The authorization service is unknown.
//
#define RPC_NT_UNKNOWN_AUTHZ_SERVICE     ((NTSTATUS)0xC0020033L)

//
// MessageId: EPT_NT_INVALID_ENTRY
//
// MessageText:
//
//  The entry is invalid.
//
#define EPT_NT_INVALID_ENTRY             ((NTSTATUS)0xC0020034L)

//
// MessageId: EPT_NT_CANT_PERFORM_OP
//
// MessageText:
//
//  The operation cannot be performed.
//
#define EPT_NT_CANT_PERFORM_OP           ((NTSTATUS)0xC0020035L)

//
// MessageId: EPT_NT_NOT_REGISTERED
//
// MessageText:
//
//  There are no more endpoints available from the endpoint mapper.
//
#define EPT_NT_NOT_REGISTERED            ((NTSTATUS)0xC0020036L)

//
// MessageId: RPC_NT_NOTHING_TO_EXPORT
//
// MessageText:
//
//  No interfaces have been exported.
//
#define RPC_NT_NOTHING_TO_EXPORT         ((NTSTATUS)0xC0020037L)

//
// MessageId: RPC_NT_INCOMPLETE_NAME
//
// MessageText:
//
//  The entry name is incomplete.
//
#define RPC_NT_INCOMPLETE_NAME           ((NTSTATUS)0xC0020038L)

//
// MessageId: RPC_NT_INVALID_VERS_OPTION
//
// MessageText:
//
//  The version option is invalid.
//
#define RPC_NT_INVALID_VERS_OPTION       ((NTSTATUS)0xC0020039L)

//
// MessageId: RPC_NT_NO_MORE_MEMBERS
//
// MessageText:
//
//  There are no more members.
//
#define RPC_NT_NO_MORE_MEMBERS           ((NTSTATUS)0xC002003AL)

//
// MessageId: RPC_NT_NOT_ALL_OBJS_UNEXPORTED
//
// MessageText:
//
//  There is nothing to unexport.
//
#define RPC_NT_NOT_ALL_OBJS_UNEXPORTED   ((NTSTATUS)0xC002003BL)

//
// MessageId: RPC_NT_INTERFACE_NOT_FOUND
//
// MessageText:
//
//  The interface was not found.
//
#define RPC_NT_INTERFACE_NOT_FOUND       ((NTSTATUS)0xC002003CL)

//
// MessageId: RPC_NT_ENTRY_ALREADY_EXISTS
//
// MessageText:
//
//  The entry already exists.
//
#define RPC_NT_ENTRY_ALREADY_EXISTS      ((NTSTATUS)0xC002003DL)

//
// MessageId: RPC_NT_ENTRY_NOT_FOUND
//
// MessageText:
//
//  The entry is not found.
//
#define RPC_NT_ENTRY_NOT_FOUND           ((NTSTATUS)0xC002003EL)

//
// MessageId: RPC_NT_NAME_SERVICE_UNAVAILABLE
//
// MessageText:
//
//  The name service is unavailable.
//
#define RPC_NT_NAME_SERVICE_UNAVAILABLE  ((NTSTATUS)0xC002003FL)

//
// MessageId: RPC_NT_INVALID_NAF_ID
//
// MessageText:
//
//  The network address family is invalid.
//
#define RPC_NT_INVALID_NAF_ID            ((NTSTATUS)0xC0020040L)

//
// MessageId: RPC_NT_CANNOT_SUPPORT
//
// MessageText:
//
//  The requested operation is not supported.
//
#define RPC_NT_CANNOT_SUPPORT            ((NTSTATUS)0xC0020041L)

//
// MessageId: RPC_NT_NO_CONTEXT_AVAILABLE
//
// MessageText:
//
//  No security context is available to allow impersonation.
//
#define RPC_NT_NO_CONTEXT_AVAILABLE      ((NTSTATUS)0xC0020042L)

//
// MessageId: RPC_NT_INTERNAL_ERROR
//
// MessageText:
//
//  An internal error occurred in RPC.
//
#define RPC_NT_INTERNAL_ERROR            ((NTSTATUS)0xC0020043L)

//
// MessageId: RPC_NT_ZERO_DIVIDE
//
// MessageText:
//
//  The RPC server attempted an integer divide by zero.
//
#define RPC_NT_ZERO_DIVIDE               ((NTSTATUS)0xC0020044L)

//
// MessageId: RPC_NT_ADDRESS_ERROR
//
// MessageText:
//
//  An addressing error occurred in the RPC server.
//
#define RPC_NT_ADDRESS_ERROR             ((NTSTATUS)0xC0020045L)

//
// MessageId: RPC_NT_FP_DIV_ZERO
//
// MessageText:
//
//  A floating point operation at the RPC server caused a divide by zero.
//
#define RPC_NT_FP_DIV_ZERO               ((NTSTATUS)0xC0020046L)

//
// MessageId: RPC_NT_FP_UNDERFLOW
//
// MessageText:
//
//  A floating point underflow occurred at the RPC server.
//
#define RPC_NT_FP_UNDERFLOW              ((NTSTATUS)0xC0020047L)

//
// MessageId: RPC_NT_FP_OVERFLOW
//
// MessageText:
//
//  A floating point overflow occurred at the RPC server.
//
#define RPC_NT_FP_OVERFLOW               ((NTSTATUS)0xC0020048L)

//
// MessageId: RPC_NT_NO_MORE_ENTRIES
//
// MessageText:
//
//  The list of RPC servers available for auto-handle binding has been exhausted.
//
#define RPC_NT_NO_MORE_ENTRIES           ((NTSTATUS)0xC0030001L)

//
// MessageId: RPC_NT_SS_CHAR_TRANS_OPEN_FAIL
//
// MessageText:
//
//  The file designated by DCERPCCHARTRANS cannot be opened.
//
#define RPC_NT_SS_CHAR_TRANS_OPEN_FAIL   ((NTSTATUS)0xC0030002L)

//
// MessageId: RPC_NT_SS_CHAR_TRANS_SHORT_FILE
//
// MessageText:
//
//  The file containing the character translation table has fewer than
//  512 bytes.
//
#define RPC_NT_SS_CHAR_TRANS_SHORT_FILE  ((NTSTATUS)0xC0030003L)

//
// MessageId: RPC_NT_SS_IN_NULL_CONTEXT
//
// MessageText:
//
//  A null context handle is passed as an [in] parameter.
//
#define RPC_NT_SS_IN_NULL_CONTEXT        ((NTSTATUS)0xC0030004L)

//
// MessageId: RPC_NT_SS_CONTEXT_MISMATCH
//
// MessageText:
//
//  The context handle does not match any known context handles.
//
#define RPC_NT_SS_CONTEXT_MISMATCH       ((NTSTATUS)0xC0030005L)

//
// MessageId: RPC_NT_SS_CONTEXT_DAMAGED
//
// MessageText:
//
//  The context handle changed during a call.
//
#define RPC_NT_SS_CONTEXT_DAMAGED        ((NTSTATUS)0xC0030006L)

//
// MessageId: RPC_NT_SS_HANDLES_MISMATCH
//
// MessageText:
//
//  The binding handles passed to a remote procedure call do not match.
//
#define RPC_NT_SS_HANDLES_MISMATCH       ((NTSTATUS)0xC0030007L)

//
// MessageId: RPC_NT_SS_CANNOT_GET_CALL_HANDLE
//
// MessageText:
//
//  The stub is unable to get the call handle.
//
#define RPC_NT_SS_CANNOT_GET_CALL_HANDLE ((NTSTATUS)0xC0030008L)

//
// MessageId: RPC_NT_NULL_REF_POINTER
//
// MessageText:
//
//  A null reference pointer was passed to the stub.
//
#define RPC_NT_NULL_REF_POINTER          ((NTSTATUS)0xC0030009L)

//
// MessageId: RPC_NT_ENUM_VALUE_OUT_OF_RANGE
//
// MessageText:
//
//  The enumeration value is out of range.
//
#define RPC_NT_ENUM_VALUE_OUT_OF_RANGE   ((NTSTATUS)0xC003000AL)

//
// MessageId: RPC_NT_BYTE_COUNT_TOO_SMALL
//
// MessageText:
//
//  The byte count is too small.
//
#define RPC_NT_BYTE_COUNT_TOO_SMALL      ((NTSTATUS)0xC003000BL)

//
// MessageId: RPC_NT_BAD_STUB_DATA
//
// MessageText:
//
//  The stub received bad data.
//
#define RPC_NT_BAD_STUB_DATA             ((NTSTATUS)0xC003000CL)

//
// MessageId: RPC_NT_CALL_IN_PROGRESS
//
// MessageText:
//
//  A remote procedure call is already in progress for this thread.
//
#define RPC_NT_CALL_IN_PROGRESS          ((NTSTATUS)0xC0020049L)

//
// MessageId: RPC_NT_NO_MORE_BINDINGS
//
// MessageText:
//
//  There are no more bindings.
//
#define RPC_NT_NO_MORE_BINDINGS          ((NTSTATUS)0xC002004AL)

//
// MessageId: RPC_NT_GROUP_MEMBER_NOT_FOUND
//
// MessageText:
//
//  The group member was not found.
//
#define RPC_NT_GROUP_MEMBER_NOT_FOUND    ((NTSTATUS)0xC002004BL)

//
// MessageId: EPT_NT_CANT_CREATE
//
// MessageText:
//
//  The endpoint mapper database could not be created.
//
#define EPT_NT_CANT_CREATE               ((NTSTATUS)0xC002004CL)

//
// MessageId: RPC_NT_INVALID_OBJECT
//
// MessageText:
//
//  The object UUID is the nil UUID.
//
#define RPC_NT_INVALID_OBJECT            ((NTSTATUS)0xC002004DL)

//
// MessageId: RPC_NT_NO_INTERFACES
//
// MessageText:
//
//  No interfaces have been registered.
//
#define RPC_NT_NO_INTERFACES             ((NTSTATUS)0xC002004FL)

//
// MessageId: RPC_NT_CALL_CANCELLED
//
// MessageText:
//
//  The server was altered while processing this call.
//
#define RPC_NT_CALL_CANCELLED            ((NTSTATUS)0xC0020050L)

//
// MessageId: RPC_NT_BINDING_INCOMPLETE
//
// MessageText:
//
//  The binding handle does not contain all required information.
//
#define RPC_NT_BINDING_INCOMPLETE        ((NTSTATUS)0xC0020051L)

//
// MessageId: RPC_NT_COMM_FAILURE
//
// MessageText:
//
//  Communications failure.
//
#define RPC_NT_COMM_FAILURE              ((NTSTATUS)0xC0020052L)

//
// MessageId: RPC_NT_UNSUPPORTED_AUTHN_LEVEL
//
// MessageText:
//
//  The requested authentication level is not supported.
//
#define RPC_NT_UNSUPPORTED_AUTHN_LEVEL   ((NTSTATUS)0xC0020053L)

//
// MessageId: RPC_NT_NO_PRINC_NAME
//
// MessageText:
//
//  No principal name registered.
//
#define RPC_NT_NO_PRINC_NAME             ((NTSTATUS)0xC0020054L)

//
// MessageId: RPC_NT_NOT_RPC_ERROR
//
// MessageText:
//
//  The error specified is not a valid Windows NT RPC error code.
//
#define RPC_NT_NOT_RPC_ERROR             ((NTSTATUS)0xC0020055L)

//
// MessageId: RPC_NT_UUID_LOCAL_ONLY
//
// MessageText:
//
//  A UUID that is valid only on this computer has been allocated.
//
#define RPC_NT_UUID_LOCAL_ONLY           ((NTSTATUS)0x40020056L)

//
// MessageId: RPC_NT_SEC_PKG_ERROR
//
// MessageText:
//
//  A security package specific error occurred.
//
#define RPC_NT_SEC_PKG_ERROR             ((NTSTATUS)0xC0020057L)

//
// MessageId: RPC_NT_NOT_CANCELLED
//
// MessageText:
//
//  Thread is not cancelled.
//
#define RPC_NT_NOT_CANCELLED             ((NTSTATUS)0xC0020058L)

//
// MessageId: RPC_NT_INVALID_ES_ACTION
//
// MessageText:
//
//  Invalid operation on the encoding/decoding handle.
//
#define RPC_NT_INVALID_ES_ACTION         ((NTSTATUS)0xC0030059L)

//
// MessageId: RPC_NT_WRONG_ES_VERSION
//
// MessageText:
//
//  Incompatible version of the serializing package.
//
#define RPC_NT_WRONG_ES_VERSION          ((NTSTATUS)0xC003005AL)

//
// MessageId: RPC_NT_WRONG_STUB_VERSION
//
// MessageText:
//
//  Incompatible version of the RPC stub.
//
#define RPC_NT_WRONG_STUB_VERSION        ((NTSTATUS)0xC003005BL)

//
// MessageId: RPC_NT_INVALID_PIPE_OBJECT
//
// MessageText:
//
//  The idl pipe object is invalid or corrupted.
//
#define RPC_NT_INVALID_PIPE_OBJECT       ((NTSTATUS)0xC003005CL)

//
// MessageId: RPC_NT_INVALID_PIPE_OPERATION
//
// MessageText:
//
//  The operation is invalid for a given idl pipe object.
//
#define RPC_NT_INVALID_PIPE_OPERATION    ((NTSTATUS)0xC003005DL)

//
// MessageId: RPC_NT_WRONG_PIPE_VERSION
//
// MessageText:
//
//  The idl pipe version is not supported.
//
#define RPC_NT_WRONG_PIPE_VERSION        ((NTSTATUS)0xC003005EL)

//
// MessageId: RPC_NT_SEND_INCOMPLETE
//
// MessageText:
//
//  Some data remains to be sent in the request buffer.
//
#define RPC_NT_SEND_INCOMPLETE           ((NTSTATUS)0x400200AFL)

/*lint -restore */  // Resume checking for different macro definitions // winnt
// end_ntsecapi

#endif // WIN32_NO_STATUS // winnt
#endif // _NTSTATUS_
