/***************************************************************************
 * ELSEUSER.H - Supplemental header file with compiler flags for the
 *              ElseWare PANOSE(tm) font mapper.
 *
 * $keywords: elseuser.h 1.8 19-Jul-93 11:11:47 AM$
 *
 * Copyright (C) 1991-93 ElseWare Corporation.  All rights reserved.
 ***************************************************************************/

#ifndef __ELSEUSER_H__
#define __ELSEUSER_H__

/* Compiler flags.
 *
 * NOELSEARGS      - Suppress argument list in procedure prototypes.
 * NOELSEPANCONST  - Suppress list of PANOSE constants.
 * NOELSEPANDATA   - Suppress penalty db, see details below.
 * NOELSEPANSCRIPT - Suppress constants for Latin Script.
 * NOELSEPANKANJI  - Suppress PANOSE constants for Kanji.
 * NOELSEPICKFONTS - Excludes unPANPickFonts(), and default routines.
 * NOELSETHRESHOLD - Excludes threshold routines.
 * NOELSEWEIGHTS   - Exclude mapper custom weight controls.
 * ELSEPENALTYDB   - Include constants and structures for penalty tables.
 *
 * PAN_MATCH_ERROR <val> - Match result indicating no match, should equal
 *                         the max allowable unsigned value for EW_USHORT.
 *
 * ELSEMAXSHORT <val>    - The maximum allowable positive signed value for
 *                         EW_SHORT (should be less than PAN_MATCH_ERROR).
 *
 * ELSEDEFTHRESHOLD <val> - Default mapper threshold value (30 if not
 *                          specified). Set equal to ELSEMAXSHORT to
 *                          entirely disable threshold checking.
 */

/* Macros.
 *
 * Override these macros with system-dependant equivalents to improve
 * the performance of the mapper.
 *
 * M_ELSELMUL(a,b)     - Long multiply a * b.
 * M_ELSELDIV(a,b)     - Long divide a / b.
 * M_ELSEMULDIV(a,b,c) - Long multiply & divide, a * b / c, rounded.
 * M_ELSEMEMCPY(dst,src,len) - memcpy(dst,src,len).
 */

/* NOELSEPANDATA: Penalty database override
 *
 * The default behavior of the mapper is to declare a static data
 * structure containing the penalty database. The structure is
 * defined in the file PAN1PTBL.H, which is included in ELSEPAN.C.
 * The file is generated by the program PAN1PTBL, which reads the
 * file PAN1PTBL.TXT.
 *
 * To override this behavior, define NOELSEPANDATA and provide
 * replacements for the following macros:
 *
 * M_lAllocPAN1DATA()       - Allocate database, return 4-byte handle.
 * M_lLockPAN1DATA(hData)   - Lock penalty database.
 * M_bUnlockPAN1DATA(hData) - Unlock penalty database.
 * M_bFreePAN1DATA(hData)   - Free penalty database.
 *
 * The PAN1PTBL program can be used to create a binary file containing
 * the memory picture of the structure (type the program name at the
 * command line to recieve a usage statement).
 */

#ifndef MACINTOSH
#define NOELSEPANKANJI

/* overrides for Windows */
#if 0
#ifdef WIN32
int __stdcall MulDiv(int, int, int);
#else
int far pascal MulDiv(int, int, int);
#endif
#endif
#define M_ELSEMULDIV(a, b, c) MulDiv((a), (b), (c))

#include <memory.h>
#ifdef WIN32
#define M_ELSEMEMCPY(dst, src, len) memcpy((dst), (src), (len))
#else
#define M_ELSEMEMCPY(dst, src, len) _fmemcpy((dst), (src), (len))
#endif

#endif    /* ! MACINTOSH */

#endif /* ifndef __ELSEUSER_H__ */

/***************************************************************************
 * Revision log:
 ***************************************************************************/
/*
 * $lgb$
 * 1.0    21-Jan-93    msd New file taken from project MAI.
 * 1.1    31-Jan-93    msd Replaced Expanded PANOSE (1.1) mapper with 10-digit (1.0) mapper.
 * 1.2     1-Feb-93    msd Remove _huge reference.
 * 1.3     2-Feb-93    msd Removed huge pointer stuff.
 * 1.4     3-Feb-93    msd Removed ctrl-Z at EOF.
 * 1.5     3-Feb-93    msd Fixed bug caused by vcs check-in.
 * 1.6    16-Mar-93    msd Enable PANOSE constants.
 * 1.7    27-Apr-93    msd Enabled script constants.
 * 1.8    19-Jul-93    msd Added compilation flags to selectively disable mapper routines.
 * $lge$
 */
