/*
 * indirect.h - Object synchronization engine API types for type-safe indirect
 *              calling.
 */


/*
 * N.b., these API types must match the function prototypes defined in
 * <synceng.h>.  An API function pointer variable may be declared and called in
 * a type-safe manner as an instance of one of the given types, e.g.,
 *
 * HINSTANCE hinstSyncEng;
 *
 * hinstSyncEng = LoadLibrary("synceng.dll");
 *
 * if (hinstSyncEng > HINSTANCE_ERROR)
 * {
 *    OPENBRIEFCASEINDIRECT OpenBriefcaseIndirect;
 *
 *    OpenBriefcaseIndirect = (OPENBRIEFCASEINDIRECT)GetProcAddress(hinstSyncEng, "OpenBriefcase");
 *
 *    if (OpenBriefcaseIndirect)
 *    {
 *       TWINRESULT tr;
 *       HBRFCASE hbr;
 *
 *       tr = (*OpenBriefcaseIndirect)("c:\\chicago\\desktop\\foo.bfc\\briefcase.bfc", OB_FL_TANSLATE_DB_FOLDER, &hbr);
 *    }
 * }
 */


/* Types
 ********/

/* briefcase interface */

typedef SYNCENGAPI TWINRESULT (WINAPI *OPENBRIEFCASEINDIRECT)(LPCTSTR, DWORD, HWND, PHBRFCASE);
typedef SYNCENGAPI TWINRESULT (WINAPI *SAVEBRIEFCASEINDIRECT)(HBRFCASE);
typedef SYNCENGAPI TWINRESULT (WINAPI *CLOSEBRIEFCASEINDIRECT)(HBRFCASE);
typedef SYNCENGAPI TWINRESULT (WINAPI *DELETEBRIEFCASEINDIRECT)(LPCTSTR);
typedef SYNCENGAPI TWINRESULT (WINAPI *GETOPENBRIEFCASEINFOINDIRECT)(HBRFCASE, POPENBRFCASEINFO);
typedef SYNCENGAPI TWINRESULT (WINAPI *CLEARBRIEFCASECACHEINDIRECT)(HBRFCASE);
typedef SYNCENGAPI TWINRESULT (WINAPI *FINDFIRSTBRIEFCASEINDIRECT)(PHBRFCASEITER, PBRFCASEINFO);
typedef SYNCENGAPI TWINRESULT (WINAPI *FINDNEXTBRIEFCASEINDIRECT)(HBRFCASEITER, PBRFCASEINFO);
typedef SYNCENGAPI TWINRESULT (WINAPI *FINDBRIEFCASECLOSEINDIRECT)(HBRFCASEITER);

/* twin interface */

typedef SYNCENGAPI TWINRESULT (WINAPI *ADDOBJECTTWININDIRECT)(HBRFCASE, PCNEWOBJECTTWIN, PHTWINFAMILY);
typedef SYNCENGAPI TWINRESULT (WINAPI *ADDFOLDERTWININDIRECT)(HBRFCASE, PCNEWFOLDERTWIN, PHFOLDERTWIN);
typedef SYNCENGAPI TWINRESULT (WINAPI *RELEASETWINHANDLEINDIRECT)(HTWIN);
typedef SYNCENGAPI TWINRESULT (WINAPI *DELETETWININDIRECT)(HTWIN);
typedef SYNCENGAPI TWINRESULT (WINAPI *GETOBJECTTWINHANDLEINDIRECT)(HBRFCASE, LPCTSTR, LPCTSTR, PHOBJECTTWIN);
typedef SYNCENGAPI TWINRESULT (WINAPI *ISFOLDERTWININDIRECT)(HBRFCASE, LPCTSTR, PBOOL);
typedef SYNCENGAPI TWINRESULT (WINAPI *CREATEFOLDERTWINLISTINDIRECT)(HBRFCASE, LPCTSTR, PFOLDERTWINLIST *);
typedef SYNCENGAPI TWINRESULT (WINAPI *DESTROYFOLDERTWINLISTINDIRECT)(PFOLDERTWINLIST);
typedef SYNCENGAPI TWINRESULT (WINAPI *ISORPHANOBJECTTWININDIRECT)(HOBJECTTWIN, PBOOL);
typedef SYNCENGAPI TWINRESULT (WINAPI *COUNTSOURCEFOLDERTWINSINDIRECT)(HOBJECTTWIN, PULONG);
typedef SYNCENGAPI TWINRESULT (WINAPI *ANYTWINSINDIRECT)(HBRFCASE, PBOOL);

/* twin list interface */

typedef SYNCENGAPI TWINRESULT (WINAPI *CREATETWINLISTINDIRECT)(HBRFCASE, PHTWINLIST);
typedef SYNCENGAPI TWINRESULT (WINAPI *DESTROYTWINLISTINDIRECT)(HTWINLIST);
typedef SYNCENGAPI TWINRESULT (WINAPI *ADDTWINTOTWINLISTINDIRECT)(HTWINLIST, HTWIN);
typedef SYNCENGAPI TWINRESULT (WINAPI *ADDALLTWINSTOTWINLISTINDIRECT)(HTWINLIST);
typedef SYNCENGAPI TWINRESULT (WINAPI *REMOVETWINFROMTWINLISTINDIRECT)(HTWINLIST, HTWIN);
typedef SYNCENGAPI TWINRESULT (WINAPI *REMOVEALLTWINSFROMTWINLISTINDIRECT)(HTWINLIST);

/* reconciliation list interface */

typedef SYNCENGAPI TWINRESULT (WINAPI *CREATERECLISTINDIRECT)(HTWINLIST, CREATERECLISTPROC, LPARAM, PRECLIST *);
typedef SYNCENGAPI TWINRESULT (WINAPI *DESTROYRECLISTINDIRECT)(PRECLIST);
typedef SYNCENGAPI TWINRESULT (WINAPI *RECONCILEITEMINDIRECT)(PCRECITEM, RECSTATUSPROC, LPARAM, DWORD, HWND, HWND);
typedef SYNCENGAPI TWINRESULT (WINAPI *BEGINRECONCILIATIONINDIRECT)(HBRFCASE);
typedef SYNCENGAPI TWINRESULT (WINAPI *ENDRECONCILIATIONINDIRECT)(HBRFCASE);
typedef SYNCENGAPI TWINRESULT (WINAPI *GETFOLDERTWINSTATUSINDIRECT)(HFOLDERTWIN, CREATERECLISTPROC, LPARAM, PFOLDERTWINSTATUS);

/* file stamp interface */

typedef SYNCENGAPI TWINRESULT (WINAPI *GETFILESTAMPINDIRECT)(LPCTSTR, PFILESTAMP);
typedef SYNCENGAPI TWINRESULT (WINAPI *COMPAREFILESTAMPSINDIRECT)(PCFILESTAMP, PCFILESTAMP, PCOMPARISONRESULT);

/* volume ID interface */

typedef SYNCENGAPI TWINRESULT (WINAPI *ISPATHONVOLUMEINDIRECT)(LPCTSTR, HVOLUMEID, PBOOL);
typedef SYNCENGAPI TWINRESULT (WINAPI *GETVOLUMEDESCRIPTIONINDIRECT)(HVOLUMEID, PVOLUMEDESC);

