#include <nt.h>
#include <ntrtl.h>
#include <nturtl.h>
#include <stddef.h>
#include <stdio.h>
#include <windows.h>

#include "types.h"
#include "render.h"
#include "context.h"

#define PRINT(a,b)  fprintf(out, "#define %-30s 0x%08x\n", a, b)
#define PRINT0(a)   fprintf(out, a);
#define PRINT1(a,b) fprintf(out, a, b);

int main(int argc, char** argv)
{
    __GLcontext *gc = 0;
    __GLvertex *vx = 0;
    __GLtransform *tr = 0;
    __GLmatrix *m = 0;
    __GLfloat one = (__GLfloat)1;
    __GLcolor *color = 0;
    __GLlightSourceMachine *lsm = 0;
    __GLlightSourcePerMaterialMachine *lspmm = 0;
    __GLmaterialMachine *msm = 0;
    FILE *out;
    
    struct prda *pr = 0;

#ifdef __GL_LINT
    argc = argc;
    argv = argv;
#endif
    if (argc != 2) {
        fprintf(stderr, "Usage: %s file_name\n", argv[0]);
        exit(1);
    }

    out = fopen(argv[1], "w");
    if (NULL == out) {
        fprintf(stderr, "Cannot open %s\n", argv[1]);
        exit(1);
    }

    PRINT0("/* DO NOT EDIT - THIS FILE IS AUTOMATICALLY GENERATED */\n");
    PRINT1("/* Size of core context = %d bytes */\n", sizeof(*gc));
    PRINT1( "/* Size of core attrib record = %d bytes */\n", sizeof(gc->state));
    PRINT0("\n");

    PRINT0("#include \"asm.h\"\n\n");

    //PRINT0("/* Context offset */\n");
    //PRINT("__GL_CONTEXT", &__gl_context);
    PRINT0("/* Context structure offsets */\n");
#if 0
// Add as needed
    PRINT("__GC_TRANSFORM_MODELVIEW", &gc->transform.modelView);
    PRINT("__GC_TRANSFORM_CLIPX0", &gc->transform.clipX0);
    PRINT("__GC_TRANSFORM_CLIPX1", &gc->transform.clipX1);
    PRINT("__GC_TRANSFORM_CLIPY0", &gc->transform.clipY0);
    PRINT("__GC_TRANSFORM_CLIPY1", &gc->transform.clipY1);
    PRINT("__GC_TRANSFORM_MINX", &gc->transform.minx);
    PRINT("__GC_TRANSFORM_MINY", &gc->transform.miny);
    PRINT("__GC_TRANSFORM_MAXX", &gc->transform.maxx);
    PRINT("__GC_TRANSFORM_MAXY", &gc->transform.maxy);
    PRINT("__GC_TRANSFORM_FMINX", &gc->transform.fminx);
    PRINT("__GC_TRANSFORM_FMINY", &gc->transform.fminy);
    PRINT("__GC_TRANSFORM_FMAXX", &gc->transform.fmaxx);
    PRINT("__GC_TRANSFORM_FMAXY", &gc->transform.fmaxy);
    PRINT("__GC_TRANSFORM_MATRIX2D", &gc->transform.matrix2D);
    PRINT0("\n");
    PRINT("__GC_CURRENT_EDGETAG", &gc->state.current.edgeTag);
    PRINT("__GC_CURRENT_USERCOLOR_R", &gc->state.current.userColor.r);
    PRINT("__GC_CURRENT_USERCOLOR_G", &gc->state.current.userColor.g);
    PRINT("__GC_CURRENT_USERCOLOR_B", &gc->state.current.userColor.b);
    PRINT("__GC_CURRENT_USERCOLOR_A", &gc->state.current.userColor.a);
    PRINT("__GC_CURRENT_USERCOLORINDEX", &gc->state.current.userColorIndex);
    PRINT("__GC_CURRENT_COLOR_R", &gc->state.current.color.r);
    PRINT("__GC_CURRENT_COLOR_G", &gc->state.current.color.g);
    PRINT("__GC_CURRENT_COLOR_B", &gc->state.current.color.b);
    PRINT("__GC_CURRENT_COLOR_A", &gc->state.current.color.a);
    PRINT("__GC_CURRENT_NORMAL_X", &gc->state.current.normal.x);
    PRINT("__GC_CURRENT_NORMAL_Y", &gc->state.current.normal.y);
    PRINT("__GC_CURRENT_NORMAL_Z", &gc->state.current.normal.z);
    PRINT("__GC_CURRENT_TEXTURE_X", &gc->state.current.texture.x);
    PRINT("__GC_CURRENT_TEXTURE_Y", &gc->state.current.texture.y);
    PRINT("__GC_CURRENT_TEXTURE_Z", &gc->state.current.texture.z);
    PRINT("__GC_CURRENT_TEXTURE_W", &gc->state.current.texture.w);
    PRINT("__GC_FOG_COLOR", &gc->state.fog.color);
    PRINT("__GC_FRONTBUFFER_REDSCALE", &gc->frontBuffer.redScale);
    PRINT("__GC_FRONTBUFFER_GREENSCALE", &gc->frontBuffer.greenScale);
    PRINT("__GC_FRONTBUFFER_BLUESCALE", &gc->frontBuffer.blueScale);
    PRINT("__GC_FRONTBUFFER_ALPHASCALE", &gc->frontBuffer.alphaScale);
    PRINT0("\n");
    PRINT("__GC_VERTEX_V0", &gc->vertex.v0);
    PRINT("__GC_VERTEX_V1", &gc->vertex.v1);
    PRINT("__GC_VERTEX_VBUF0", &gc->vertex.vbuf[0]);
    PRINT("__GC_VERTEX_VBUF1", &gc->vertex.vbuf[1]);
    PRINT("__GC_VERTEX_PROVOKING", &gc->vertex.provoking);
    PRINT("__GC_VERTEX_NEEDS", &gc->vertex.needs);
    PRINT("__GC_VERTEX_FRONTFACE_NEEDS", &gc->vertex.faceNeeds[__GL_FRONTFACE]);
    PRINT0("\n");
    PRINT("__GC_LINE_NOTRESETSTIPPLE", &gc->line.notResetStipple);
    PRINT("__GC_LINE_ALIASEDWIDTH", &gc->state.line.aliasedWidth);
    PRINT0("\n");
    PRINT("__GC_VIEWPORT_XCENTER", &gc->state.viewport.xCenter);
    PRINT("__GC_VIEWPORT_YCENTER", &gc->state.viewport.yCenter);
    PRINT("__GC_VIEWPORT_ZCENTER", &gc->state.viewport.zCenter);
    PRINT("__GC_VIEWPORT_XSCALE", &gc->state.viewport.xScale);
    PRINT("__GC_VIEWPORT_YSCALE", &gc->state.viewport.yScale);
    PRINT("__GC_VIEWPORT_ZSCALE", &gc->state.viewport.zScale);
    PRINT("__GC_VIEWPORT_HEIGHT", &gc->state.viewport.height);
    PRINT("__GC_VIEWPORT_WIDTH", &gc->state.viewport.width);
    PRINT0("\n");
    PRINT("__GC_PROCS_VERTEX", &gc->procs.vertex);
    PRINT("__GC_PROCS_VALIDATEVERTEX2", &gc->procs.validateVertex2);
    PRINT("__GC_PROCS_VALIDATEVERTEX3", &gc->procs.validateVertex3);
    PRINT("__GC_PROCS_VALIDATEVERTEX4", &gc->procs.validateVertex4);
    PRINT("__GC_PROCS_V", &gc->procs.v);
    PRINT("__GC_PROCS_FILLTRIANGLE", &gc->procs.fillTriangle);
    PRINT("__GC_PROCS_RENDERTRIANGLE", &gc->procs.renderTriangle);
    PRINT("__GC_PROCS_MATVALIDATE", &gc->procs.matValidate);
    PRINT("__GC_PROCS_LINE_DEPTHTESTPIXEL", &gc->procs.line.depthTestPixel);
    PRINT("__GC_PROCS_LINE_DEPTHTESTSPIXEL", &gc->procs.line.depthTestSPixel);
    PRINT("__GC_PROCS_LINE_DEPTHTESTPIXELSF", &gc->procs.line.depthTestPixelSF);
    PRINT("__GC_PROCS_LINE_DEPTHTESTSPIXELSF", &gc->procs.line.depthTestSPixelSF);
    PRINT("__GC_PROCS_CLIPCHECK2", &gc->procs.clipCheck2);
    PRINT("__GC_PROCS_CLIPCHECK3", &gc->procs.clipCheck3);
    PRINT("__GC_PROCS_CLIPCHECK4", &gc->procs.clipCheck4);
    PRINT("__GC_PROCS_RENDERLINE", &gc->procs.renderLine);
    PRINT("__GC_PROCS_CLIPLINE", &gc->procs.clipLine);
    PRINT("__GC_PROCS_RENDERPOINT", &gc->procs.renderPoint);
    PRINT("__GC_PROCS_CALCCOLOR", &gc->procs.calcColor);
    PRINT("__GC_PROCS_CALCTEXTURE", &gc->procs.calcTexture);
    PRINT("__GC_PROCS_FOGVERTEX", &gc->procs.fogVertex);
    PRINT("__GC_PROCS_NORMALIZE", &gc->procs.normalize);
    PRINT("__GC_PROCS_COMPUTEINVERSETRANSPOSE", &gc->procs.computeInverseTranspose);
    PRINT0("\n");
    PRINT("__GC_ENABLES_GENERAL", &gc->state.enables.general);
    PRINT0("\n");
    PRINT("__GC_STATE_LIGHT_FRONT", &gc->state.light.front);
    PRINT("__GC_STATE_LIGHT_BACK", &gc->state.light.back);
    PRINT("__GC_LIGHT_FRONT", &gc->light.front);
    PRINT("__GC_LIGHT_BACK", &gc->light.back);
    PRINT("__GC_LIGHT_SOURCES", &gc->light.sources);
    PRINT0("\n");
    PRINT("__GC_LINE_OPTIONS_XSTART", &gc->line.options.xStart);
    PRINT("__GC_LINE_OPTIONS_YSTART", &gc->line.options.yStart);
    PRINT("__GC_LINE_OPTIONS_XLITTLE", &gc->line.options.xLittle);
    PRINT("__GC_LINE_OPTIONS_YLITTLE", &gc->line.options.yLittle);
    PRINT("__GC_LINE_OPTIONS_XBIG", &gc->line.options.xBig);
    PRINT("__GC_LINE_OPTIONS_YBIG", &gc->line.options.yBig);
    PRINT("__GC_LINE_OPTIONS_FRACTION", &gc->line.options.fraction);
    PRINT("__GC_LINE_OPTIONS_DFRACTION", &gc->line.options.dfraction);
    PRINT("__GC_LINE_OPTIONS_AXIS", &gc->line.options.axis);
    PRINT("__GC_LINE_OPTIONS_VERT0", &gc->line.options.v0);
    PRINT("__GC_LINE_OPTIONS_VERT1", &gc->line.options.v1);
    PRINT("__GC_LINE_OPTIONS_WIDTH", &gc->line.options.width);
    PRINT("__GC_LINE_OPTIONS_LENGTH", &gc->line.options.length);
    PRINT("__GC_LINE_OPTIONS_NUMPIXELS", &gc->line.options.numPixels);
    PRINT("__GC_LINE_OPTIONS_OFFSET", &gc->line.options.offset);
    PRINT0("\n");
    PRINT("__GC_CONSTANTS_VIEWPORTXADJUST", &gc->constants.viewportXAdjust);
    PRINT("__GC_CONSTANTS_VIEWPORTYADJUST", &gc->constants.viewportYAdjust);
    PRINT("__GC_CONSTANTS_FVIEWPORTXADJUST", &gc->constants.fviewportXAdjust);
    PRINT("__GC_CONSTANTS_FVIEWPORTYADJUST", &gc->constants.fviewportYAdjust);
    PRINT("__GC_CONSTANTS_VIEWPORTEPSILON", &gc->constants.viewportEpsilon);
    PRINT("__GC_CONSTANTS_YINVERTED", &gc->constants.yInverted);
    PRINT0("\n");
    PRINT("__GC_POLYGON_CULLFACE", &gc->polygon.cullFace);
    PRINT("__GC_POLYGON_FACE", &gc->polygon.face[0]);
    PRINT("__GC_POLYGON_SHADER_AREA", &gc->polygon.shader.area);
    PRINT("__GC_POLYGON_SHADER_DXAC", &gc->polygon.shader.dxAC);
    PRINT("__GC_POLYGON_SHADER_DYAC", &gc->polygon.shader.dyAC);
    PRINT("__GC_POLYGON_SHADER_DXBC", &gc->polygon.shader.dxBC);
    PRINT("__GC_POLYGON_SHADER_DYBC", &gc->polygon.shader.dyBC);
    PRINT("__GC_POLYGON_SHADER_DRDX", &gc->polygon.shader.drdx);
    PRINT("__GC_POLYGON_SHADER_DRDY", &gc->polygon.shader.drdy);
    PRINT("__GC_POLYGON_SHADER_DGDX", &gc->polygon.shader.dgdx);
    PRINT("__GC_POLYGON_SHADER_DGDY", &gc->polygon.shader.dgdy);
    PRINT("__GC_POLYGON_SHADER_DBDX", &gc->polygon.shader.dbdx);
    PRINT("__GC_POLYGON_SHADER_DBDY", &gc->polygon.shader.dbdy);
    PRINT("__GC_POLYGON_SHADER_DZDX", &gc->polygon.shader.dzdx);
    PRINT("__GC_POLYGON_SHADER_DZDXF", &gc->polygon.shader.dzdxf);
    PRINT("__GC_POLYGON_SHADER_DZDYF", &gc->polygon.shader.dzdyf);
    PRINT("__GC_POLYGON_SHADER_FRAG_COLOR_R", &gc->polygon.shader.frag.color.r);
    PRINT("__GC_POLYGON_SHADER_FRAG_COLOR_G", &gc->polygon.shader.frag.color.g);
    PRINT("__GC_POLYGON_SHADER_FRAG_COLOR_B", &gc->polygon.shader.frag.color.b);
    PRINT("__GC_POLYGON_SHADER_FRAG_Z", &gc->polygon.shader.frag.z);
    PRINT("__GC_POLYGON_SHADER_LENGTH", &gc->polygon.shader.length);
    PRINT("__GC_POLYGON_SHADER_RBIG", &gc->polygon.shader.rBig);
    PRINT("__GC_POLYGON_SHADER_GBIG", &gc->polygon.shader.gBig);
    PRINT("__GC_POLYGON_SHADER_BBIG", &gc->polygon.shader.bBig);
    PRINT("__GC_POLYGON_SHADER_RLITTLE", &gc->polygon.shader.rLittle);
    PRINT("__GC_POLYGON_SHADER_GLITTLE", &gc->polygon.shader.gLittle);
    PRINT("__GC_POLYGON_SHADER_BLITTLE", &gc->polygon.shader.bLittle);
    PRINT("__GC_POLYGON_SHADER_IXLEFT", &gc->polygon.shader.ixLeft);
    PRINT("__GC_POLYGON_SHADER_IXLEFTFRAC", &gc->polygon.shader.ixLeftFrac);
    PRINT("__GC_POLYGON_SHADER_DXLEFTFRAC", &gc->polygon.shader.dxLeftFrac);
    PRINT("__GC_POLYGON_SHADER_IXRIGHT", &gc->polygon.shader.ixRight);
    PRINT("__GC_POLYGON_SHADER_IXRIGHTFRAC", &gc->polygon.shader.ixRightFrac);
    PRINT("__GC_POLYGON_SHADER_DXRIGHTFRAC", &gc->polygon.shader.dxRightFrac);
    PRINT("__GC_POLYGON_SHADER_DXRIGHTBIG", &gc->polygon.shader.dxRightBig);
    PRINT("__GC_POLYGON_SHADER_DXRIGHTLITTLE", &gc->polygon.shader.dxRightLittle);
    PRINT("__GC_POLYGON_SHADER_DXLEFTBIG", &gc->polygon.shader.dxLeftBig);
    PRINT("__GC_POLYGON_SHADER_DXLEFTLITTLE", &gc->polygon.shader.dxLeftLittle);
    PRINT("__GC_POLYGON_SHADER_DZDX", &gc->polygon.shader.dzdx);
    PRINT("__GC_POLYGON_SHADER_ZBUF", &gc->polygon.shader.zbuf);
    PRINT("__GC_POLYGON_SHADER_ZBUFBIG", &gc->polygon.shader.zbufBig);
    PRINT("__GC_POLYGON_SHADER_ZBUFLITTLE", &gc->polygon.shader.zbufLittle);
    PRINT("__GC_POLYGON_SHADER_ZBIG", &gc->polygon.shader.zBig);
    PRINT("__GC_POLYGON_SHADER_ZLITTLE", &gc->polygon.shader.zLittle);
    PRINT("__GC_POLYGON_SHADER_SBUF", &gc->polygon.shader.sbuf);
    PRINT("__GC_POLYGON_SHADER_MODEFLAGS", &gc->polygon.shader.modeFlags);
    PRINT("__GC_POLYGON_SHADER_COLORS", &gc->polygon.shader.colors);
    PRINT("__GC_POLYGON_SHADER_STIPPLEPAT", &gc->polygon.shader.stipplePat);
    PRINT("__GC_POLYGON_SHADER_DONE", &gc->polygon.shader.done);
    PRINT0("\n");
    PRINT("__GC_DEPTHBUFFER_BUF_BASE", &gc->depthBuffer.buf.base);
    PRINT("__GC_DEPTHBUFFER_BUF_OUTERWIDTH", &gc->depthBuffer.buf.outerWidth);
    PRINT0("\n");
    PRINT("__GC_STENCIL_MASK", &gc->state.stencil.mask);
    PRINT("__GC_STENCIL_TESTFUNCTABLE", &gc->stencilBuffer.testFuncTable);
    PRINT("__GC_STENCIL_FAILOPTABLE", &gc->stencilBuffer.failOpTable);
    PRINT0("\n");
    PRINT("__GC_PROCS_SPAN_DEPTHTESTPIXEL", &gc->procs.span.depthTestPixel);

    PRINT0("/* Mode flags */\n");
    PRINT("__GL_SHADE_DEPTH_TEST", __GL_SHADE_DEPTH_TEST);
    PRINT("__GL_SHADE_SMOOTH", __GL_SHADE_SMOOTH);
    PRINT("__GL_SHADE_RGB", __GL_SHADE_RGB);
    PRINT("__GL_SHADE_DITHER", __GL_SHADE_DITHER);
    PRINT("__GL_SHADE_BLEND", __GL_SHADE_BLEND);
    PRINT("__GL_SHADE_TWOSIDED", __GL_SHADE_TWOSIDED);

    PRINT0("/* Enables */\n");
    PRINT("__GL_LINE_STIPPLE_ENABLE", __GL_LINE_STIPPLE_ENABLE);
    PRINT0("\n");

    PRINT0("/* Transform structure offsets */\n");
    PRINT("__TR_MATRIX", &tr->matrix);
    PRINT("__TR_MATRIX_MATRIXTYPE", &tr->matrix.matrixType);
    PRINT("__TR_UPDATEINVERSE", &tr->updateInverse);
    PRINT("__TR_MATRIX_XF2", &tr->matrix.xf2);
    PRINT("__TR_MATRIX_XF3", &tr->matrix.xf3);
    PRINT("__TR_MATRIX_XF4", &tr->matrix.xf4);
    PRINT("__TR_INVERSETRANSPOSE", &tr->inverseTranspose);
    PRINT("__TR_INVERSETRANSPOSE_XF3", &tr->inverseTranspose.xf3);
    PRINT("__TR_INVERSETRANSPOSE_XF4", &tr->inverseTranspose.xf4);
    PRINT("__TR_MVP", &tr->mvp);
    PRINT("__TR_MVP_MATRIX", &tr->mvp.matrix[0][0]);
    PRINT("__TR_MVP_XF2", &tr->mvp.xf2);
    PRINT("__TR_MVP_XF3", &tr->mvp.xf3);
    PRINT("__TR_MVP_XF4", &tr->mvp.xf4);
    PRINT0("\n");

    PRINT0("/* Matrix structure offsets */\n");
    PRINT("__MATRIX_M00", &m->matrix[0][0]);
    PRINT("__MATRIX_M01", &m->matrix[0][1]);
    PRINT("__MATRIX_M02", &m->matrix[0][2]);
    PRINT("__MATRIX_M03", &m->matrix[0][3]);
    PRINT("__MATRIX_M10", &m->matrix[1][0]);
    PRINT("__MATRIX_M11", &m->matrix[1][1]);
    PRINT("__MATRIX_M12", &m->matrix[1][2]);
    PRINT("__MATRIX_M13", &m->matrix[1][3]);
    PRINT("__MATRIX_M20", &m->matrix[2][0]);
    PRINT("__MATRIX_M21", &m->matrix[2][1]);
    PRINT("__MATRIX_M22", &m->matrix[2][2]);
    PRINT("__MATRIX_M23", &m->matrix[2][3]);
    PRINT("__MATRIX_M30", &m->matrix[3][0]);
    PRINT("__MATRIX_M31", &m->matrix[3][1]);
    PRINT("__MATRIX_M32", &m->matrix[3][2]);
    PRINT("__MATRIX_M33", &m->matrix[3][3]);
    PRINT0("\n");

    PRINT0("/* Consts structure offsets */\n");
    PRINT("__GC_CONSTS_ALMOSTHALF", &gc->constants.viewportAlmostHalf);
    PRINT("__GC_CONSTS_HALF", &gc->constants.half);
    PRINT("__GC_CONSTS_ONE", &gc->constants.one);
    PRINT0("\n");

    PRINT0("/* Vertex structure offsets */\n");
    PRINT("__VX_HAS", &vx->has);
    PRINT("__VX_VALIDATE", &vx->validate);
    PRINT("__VX_CLIPCODE", &vx->clipCode);
    PRINT("__VX_BOUNDARYEDGE", &vx->boundaryEdge);
    PRINT("__VX_OBJ_X", &vx->obj.x);
    PRINT("__VX_OBJ_Y", &vx->obj.y);
    PRINT("__VX_OBJ_Z", &vx->obj.z);
    PRINT("__VX_OBJ_W", &vx->obj.w);
    PRINT("__VX_NORMAL_X", &vx->normal.x);
    PRINT("__VX_NORMAL_Y", &vx->normal.y);
    PRINT("__VX_NORMAL_Z", &vx->normal.z);
    PRINT("__VX_NORMAL_W", &vx->normal.w);
    PRINT("__VX_CLIP_X", &vx->clip.x);
    PRINT("__VX_CLIP_Y", &vx->clip.y);
    PRINT("__VX_CLIP_Z", &vx->clip.z);
    PRINT("__VX_CLIP_W", &vx->clip.w);
    PRINT("__VX_WINDOW_X", &vx->window.x);
    PRINT("__VX_WINDOW_Y", &vx->window.y);
    PRINT("__VX_WINDOW_Z", &vx->window.z);
    PRINT("__VX_WINDOW_W", &vx->window.w);
    PRINT("__VX_EYE_X", &vx->eye.x);
    PRINT("__VX_EYE_Y", &vx->eye.y);
    PRINT("__VX_EYE_Z", &vx->eye.z);
    PRINT("__VX_EYE_W", &vx->eye.w);
    PRINT("__VX_TEXTURE_X", &vx->texture.x);
    PRINT("__VX_TEXTURE_Y", &vx->texture.y);
    PRINT("__VX_TEXTURE_Z", &vx->texture.z);
    PRINT("__VX_TEXTURE_W", &vx->texture.w);
    PRINT("__VX_FOG", &vx->fog);
    PRINT("__VX_COLOR", &vx->color);
    PRINT("__VX_COLORS", &(vx->colors[0]));
    PRINT0("\n");

    PRINT0("/* Color structure offsets */\n");
    PRINT("__COLOR_R", &color->r);
    PRINT("__COLOR_G", &color->g);
    PRINT("__COLOR_B", &color->b);
    PRINT("__COLOR_A", &color->a);
    PRINT("__COLOR_SIZE", sizeof(__GLcolor));

    PRINT0("/* Light machines offsets */\n");
    PRINT("__LSM_FRONT", &lsm->front);
    PRINT("__LSM_HHAT_X", &lsm->hHat.x);
    PRINT("__LSM_HHAT_Y", &lsm->hHat.y);
    PRINT("__LSM_HHAT_Z", &lsm->hHat.z);
    PRINT("__LSM_UNITVPPLI_X", &lsm->unitVPpli.x);
    PRINT("__LSM_UNITVPPLI_Y", &lsm->unitVPpli.y);
    PRINT("__LSM_UNITVPPLI_Z", &lsm->unitVPpli.z);
    PRINT("__LSM_NEXT", &lsm->next);

    PRINT("__LSPMM_AMBIENT_R", &lspmm->ambient.r);
    PRINT("__LSPMM_AMBIENT_G", &lspmm->ambient.g);
    PRINT("__LSPMM_AMBIENT_B", &lspmm->ambient.b);
    PRINT("__LSPMM_SPECULAR_R", &lspmm->specular.r);
    PRINT("__LSPMM_SPECULAR_G", &lspmm->specular.g);
    PRINT("__LSPMM_SPECULAR_B", &lspmm->specular.b);
    PRINT("__LSPMM_DIFFUSE_R", &lspmm->diffuse.r);
    PRINT("__LSPMM_DIFFUSE_G", &lspmm->diffuse.g);
    PRINT("__LSPMM_DIFFUSE_B", &lspmm->diffuse.b);
    PRINT("__LSPMM_SIZE", sizeof(__GLlightSourcePerMaterialMachine));

    PRINT0("/* Material machine offsets */\n");
    PRINT("__MSM_SCENECOLOR_R", &msm->sceneColor.r);
    PRINT("__MSM_SCENECOLOR_G", &msm->sceneColor.g);
    PRINT("__MSM_SCENECOLOR_B", &msm->sceneColor.b);
    PRINT("__MSM_THRESHOLD", &msm->threshold);
    PRINT("__MSM_SCALE", &msm->scale);
    PRINT("__MSM_SPECTABLE", &msm->specTable);
    PRINT("__MSM_ALPHA", &msm->alpha);

    PRINT0("/* Constants */\n");
    PRINT("__GL_CLIP_LEFT", __GL_CLIP_LEFT);
    PRINT("__GL_CLIP_RIGHT", __GL_CLIP_RIGHT);
    PRINT("__GL_CLIP_BOTTOM", __GL_CLIP_BOTTOM);
    PRINT("__GL_CLIP_TOP", __GL_CLIP_TOP);
    PRINT("__GL_CLIP_NEAR", __GL_CLIP_NEAR);
    PRINT("__GL_CLIP_FAR", __GL_CLIP_FAR);
    PRINT("__GL_SIZEOF_VERTEX", sizeof(*vx));

    PRINT("__GL_TRUE", GL_TRUE);

    PRINT("__GL_HAS_EYE", __GL_HAS_EYE);
    PRINT("__GL_HAS_NORMAL", __GL_HAS_NORMAL);
    PRINT("__GL_HAS_LIGHTING", __GL_HAS_LIGHTING);
    PRINT("__GL_HAS_FOG", __GL_HAS_FOG);
    PRINT("__GL_HAS_CLIP", __GL_HAS_CLIP);
    PRINT("__GL_HAS_TEXTURE", __GL_HAS_TEXTURE);
    PRINT("__GL_HAS_FRONT_COLOR", __GL_HAS_FRONT_COLOR);
    PRINT("__GL_HAS_BACK_COLOR", __GL_HAS_BACK_COLOR);
    PRINT("__GL_FRONTFACE", __GL_FRONTFACE);
    PRINT("__GL_BACKFACE", __GL_BACKFACE);
    PRINT("__GL_MT_GENERAL", __GL_MT_GENERAL);
    PRINT("__GL_NORMALIZE_ENABLE", __GL_NORMALIZE_ENABLE);

    PRINT("__GL_SPEC_LOOKUP_TABLE_SIZE", __GL_SPEC_LOOKUP_TABLE_SIZE);
    PRINT0("\n");

    PRINT0("/* Other constants */\n");
    PRINT("__FLOAT_ONE", *(long*)&one);
    PRINT0("\n");
#endif

    return 0;
}
