
/*++

      File: Zadvapi.c

	Profiling dll for ADVAPI32.dll

        NOTE: This file is generated by WRAPPER code generator

--*/
#include <nt.h>
#include <ntrtl.h>
#include <nturtl.h>
#include "windows.h"
#include "zwinadv.h"
#include "api32prf.h"     //Data Structures

extern BOOLEAN fInitDone;



BOOL  ZAbortSystemShutdownA (LPSTR lpMachineName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = AbortSystemShutdownA(lpMachineName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_AbortSystemShutdownA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZAbortSystemShutdownW (LPWSTR lpMachineName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = AbortSystemShutdownW(lpMachineName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_AbortSystemShutdownW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZAccessCheck (PSECURITY_DESCRIPTOR pSecurityDescriptor,HANDLE ClientToken,DWORD DesiredAccess,PGENERIC_MAPPING GenericMapping,PPRIVILEGE_SET PrivilegeSet,LPDWORD PrivilegeSetLength,LPDWORD GrantedAccess,LPBOOL AccessStatus)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = AccessCheck(pSecurityDescriptor,ClientToken,DesiredAccess,GenericMapping,PrivilegeSet,PrivilegeSetLength,GrantedAccess,AccessStatus);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_AccessCheck, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZAccessCheckAndAuditAlarmA (LPCSTR SubsystemName,LPVOID HandleId,LPSTR ObjectTypeName,LPSTR ObjectName,PSECURITY_DESCRIPTOR SecurityDescriptor,DWORD DesiredAccess,PGENERIC_MAPPING GenericMapping,BOOL ObjectCreation,LPDWORD GrantedAccess,LPBOOL AccessStatus,LPBOOL pfGenerateOnClose)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = AccessCheckAndAuditAlarmA(SubsystemName,HandleId,ObjectTypeName,ObjectName,SecurityDescriptor,DesiredAccess,GenericMapping,ObjectCreation,GrantedAccess,AccessStatus,pfGenerateOnClose);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_AccessCheckAndAuditAlarmA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZAccessCheckAndAuditAlarmW (LPCWSTR SubsystemName,LPVOID HandleId,LPWSTR ObjectTypeName,LPWSTR ObjectName,PSECURITY_DESCRIPTOR SecurityDescriptor,DWORD DesiredAccess,PGENERIC_MAPPING GenericMapping,BOOL ObjectCreation,LPDWORD GrantedAccess,LPBOOL AccessStatus,LPBOOL pfGenerateOnClose)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = AccessCheckAndAuditAlarmW(SubsystemName,HandleId,ObjectTypeName,ObjectName,SecurityDescriptor,DesiredAccess,GenericMapping,ObjectCreation,GrantedAccess,AccessStatus,pfGenerateOnClose);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_AccessCheckAndAuditAlarmW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZAddAccessAllowedAce (PACL pAcl,DWORD dwAceRevision,DWORD AccessMask,PSID pSid)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = AddAccessAllowedAce(pAcl,dwAceRevision,AccessMask,pSid);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_AddAccessAllowedAce, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZAddAccessDeniedAce (PACL pAcl,DWORD dwAceRevision,DWORD AccessMask,PSID pSid)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = AddAccessDeniedAce(pAcl,dwAceRevision,AccessMask,pSid);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_AddAccessDeniedAce, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZAddAce (PACL pAcl,DWORD dwAceRevision,DWORD dwStartingAceIndex,LPVOID pAceList,DWORD nAceListLength)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = AddAce(pAcl,dwAceRevision,dwStartingAceIndex,pAceList,nAceListLength);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_AddAce, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZAddAuditAccessAce (PACL pAcl,DWORD dwAceRevision,DWORD dwAccessMask,PSID pSid,BOOL bAuditSuccess,BOOL bAuditFailure)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = AddAuditAccessAce(pAcl,dwAceRevision,dwAccessMask,pSid,bAuditSuccess,bAuditFailure);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_AddAuditAccessAce, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZAdjustTokenGroups (HANDLE TokenHandle,BOOL ResetToDefault,PTOKEN_GROUPS NewState,DWORD BufferLength,PTOKEN_GROUPS PreviousState,PDWORD ReturnLength)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = AdjustTokenGroups(TokenHandle,ResetToDefault,NewState,BufferLength,PreviousState,ReturnLength);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_AdjustTokenGroups, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZAdjustTokenPrivileges (HANDLE TokenHandle,BOOL DisableAllPrivileges,PTOKEN_PRIVILEGES NewState,DWORD BufferLength,PTOKEN_PRIVILEGES PreviousState,PDWORD ReturnLength)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = AdjustTokenPrivileges(TokenHandle,DisableAllPrivileges,NewState,BufferLength,PreviousState,ReturnLength);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_AdjustTokenPrivileges, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZAllocateAndInitializeSid (PSID_IDENTIFIER_AUTHORITY pIdentifierAuthority,BYTE nSubAuthorityCount,DWORD nSubAuthority0,DWORD nSubAuthority1,DWORD nSubAuthority2,DWORD nSubAuthority3,DWORD nSubAuthority4,DWORD nSubAuthority5,DWORD nSubAuthority6,DWORD nSubAuthority7,PSID* pSid)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = AllocateAndInitializeSid(pIdentifierAuthority,nSubAuthorityCount,nSubAuthority0,nSubAuthority1,nSubAuthority2,nSubAuthority3,nSubAuthority4,nSubAuthority5,nSubAuthority6,nSubAuthority7,pSid);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_AllocateAndInitializeSid, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZAllocateLocallyUniqueId (PLUID Luid)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = AllocateLocallyUniqueId(Luid);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_AllocateLocallyUniqueId, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZAreAllAccessesGranted (DWORD GrantedAccess,DWORD DesiredAccess)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = AreAllAccessesGranted(GrantedAccess,DesiredAccess);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_AreAllAccessesGranted, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZAreAnyAccessesGranted (DWORD GrantedAccess,DWORD DesiredAccess)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = AreAnyAccessesGranted(GrantedAccess,DesiredAccess);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_AreAnyAccessesGranted, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZBackupEventLogA (HANDLE hEventLog,LPCSTR lpBackupFileName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = BackupEventLogA(hEventLog,lpBackupFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_BackupEventLogA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZBackupEventLogW (HANDLE hEventLog,LPCWSTR lpBackupFileName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = BackupEventLogW(hEventLog,lpBackupFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_BackupEventLogW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZChangeServiceConfigA (SC_HANDLE hService,DWORD dwServiceType,DWORD dwStartType,DWORD dwErrorControl,LPCSTR lpBinaryPathName,LPCSTR lpLoadOrderGroup,LPDWORD lpdwTagId,LPCSTR lpDependencies,LPCSTR lpServiceStartName,LPCSTR lpPassword,LPCSTR lpDisplayName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ChangeServiceConfigA(hService,dwServiceType,dwStartType,dwErrorControl,lpBinaryPathName,lpLoadOrderGroup,lpdwTagId,lpDependencies,lpServiceStartName,lpPassword,lpDisplayName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ChangeServiceConfigA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZChangeServiceConfigW (SC_HANDLE hService,DWORD dwServiceType,DWORD dwStartType,DWORD dwErrorControl,LPCWSTR lpBinaryPathName,LPCWSTR lpLoadOrderGroup,LPDWORD lpdwTagId,LPCWSTR lpDependencies,LPCWSTR lpServiceStartName,LPCWSTR lpPassword,LPCWSTR lpDisplayName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ChangeServiceConfigW(hService,dwServiceType,dwStartType,dwErrorControl,lpBinaryPathName,lpLoadOrderGroup,lpdwTagId,lpDependencies,lpServiceStartName,lpPassword,lpDisplayName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ChangeServiceConfigW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZClearEventLogA (HANDLE hEventLog,LPCSTR lpBackupFileName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ClearEventLogA(hEventLog,lpBackupFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ClearEventLogA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZClearEventLogW (HANDLE hEventLog,LPCWSTR lpBackupFileName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ClearEventLogW(hEventLog,lpBackupFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ClearEventLogW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZCloseEventLog (HANDLE hEventLog)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CloseEventLog(hEventLog);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CloseEventLog, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZCloseServiceHandle (SC_HANDLE hSCObject)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CloseServiceHandle(hSCObject);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CloseServiceHandle, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZControlService (SC_HANDLE hService,DWORD dwControl,LPSERVICE_STATUS lpServiceStatus)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ControlService(hService,dwControl,lpServiceStatus);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ControlService, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZCopySid (DWORD nDestinationSidLength,PSID pDestinationSid,PSID pSourceSid)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CopySid(nDestinationSidLength,pDestinationSid,pSourceSid);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CopySid, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZCreatePrivateObjectSecurity (PSECURITY_DESCRIPTOR ParentDescriptor,PSECURITY_DESCRIPTOR CreatorDescriptor,PSECURITY_DESCRIPTOR* NewDescriptor,BOOL IsDirectoryObject,HANDLE Token,PGENERIC_MAPPING GenericMapping)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreatePrivateObjectSecurity(ParentDescriptor,CreatorDescriptor,NewDescriptor,IsDirectoryObject,Token,GenericMapping);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreatePrivateObjectSecurity, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

SC_HANDLE  ZCreateServiceA (SC_HANDLE hSCManager,LPCSTR lpServiceName,LPCSTR lpDisplayName,DWORD dwDesiredAccess,DWORD dwServiceType,DWORD dwStartType,DWORD dwErrorControl,LPCSTR lpBinaryPathName,LPCSTR lpLoadOrderGroup,LPDWORD lpdwTagId,LPCSTR lpDependencies,LPCSTR lpServiceStartName,LPCSTR lpPassword)
{

    SC_HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateServiceA(hSCManager,lpServiceName,lpDisplayName,dwDesiredAccess,dwServiceType,dwStartType,dwErrorControl,lpBinaryPathName,lpLoadOrderGroup,lpdwTagId,lpDependencies,lpServiceStartName,lpPassword);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateServiceA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

SC_HANDLE  ZCreateServiceW (SC_HANDLE hSCManager,LPCWSTR lpServiceName,LPCWSTR lpDisplayName,DWORD dwDesiredAccess,DWORD dwServiceType,DWORD dwStartType,DWORD dwErrorControl,LPCWSTR lpBinaryPathName,LPCWSTR lpLoadOrderGroup,LPDWORD lpdwTagId,LPCWSTR lpDependencies,LPCWSTR lpServiceStartName,LPCWSTR lpPassword)
{

    SC_HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateServiceW(hSCManager,lpServiceName,lpDisplayName,dwDesiredAccess,dwServiceType,dwStartType,dwErrorControl,lpBinaryPathName,lpLoadOrderGroup,lpdwTagId,lpDependencies,lpServiceStartName,lpPassword);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateServiceW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZDeleteAce (PACL pAcl,DWORD dwAceIndex)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = DeleteAce(pAcl,dwAceIndex);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_DeleteAce, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZDeleteService (SC_HANDLE hService)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = DeleteService(hService);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_DeleteService, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZDeregisterEventSource (HANDLE hEventLog)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = DeregisterEventSource(hEventLog);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_DeregisterEventSource, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZDestroyPrivateObjectSecurity (PSECURITY_DESCRIPTOR* ObjectDescriptor)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = DestroyPrivateObjectSecurity(ObjectDescriptor);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_DestroyPrivateObjectSecurity, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZDuplicateToken (HANDLE ExistingTokenHandle,SECURITY_IMPERSONATION_LEVEL ImpersonationLevel,PHANDLE DuplicateTokenHandle)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = DuplicateToken(ExistingTokenHandle,ImpersonationLevel,DuplicateTokenHandle);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_DuplicateToken, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZEnumDependentServicesA (SC_HANDLE hService,DWORD dwServiceState,LPENUM_SERVICE_STATUSA lpServices,DWORD cbBufSize,LPDWORD pcbBytesNeeded,LPDWORD lpServicesReturned)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = EnumDependentServicesA(hService,dwServiceState,lpServices,cbBufSize,pcbBytesNeeded,lpServicesReturned);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_EnumDependentServicesA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZEnumDependentServicesW (SC_HANDLE hService,DWORD dwServiceState,LPENUM_SERVICE_STATUSW lpServices,DWORD cbBufSize,LPDWORD pcbBytesNeeded,LPDWORD lpServicesReturned)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = EnumDependentServicesW(hService,dwServiceState,lpServices,cbBufSize,pcbBytesNeeded,lpServicesReturned);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_EnumDependentServicesW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZEnumServicesStatusA (SC_HANDLE hSCManager,DWORD dwServiceType,DWORD dwServiceState,LPENUM_SERVICE_STATUSA lpServices,DWORD cbBufSize,LPDWORD pcbBytesNeeded,LPDWORD lpServicesReturned,LPDWORD lpResumeHandle)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = EnumServicesStatusA(hSCManager,dwServiceType,dwServiceState,lpServices,cbBufSize,pcbBytesNeeded,lpServicesReturned,lpResumeHandle);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_EnumServicesStatusA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZEnumServicesStatusW (SC_HANDLE hSCManager,DWORD dwServiceType,DWORD dwServiceState,LPENUM_SERVICE_STATUSW lpServices,DWORD cbBufSize,LPDWORD pcbBytesNeeded,LPDWORD lpServicesReturned,LPDWORD lpResumeHandle)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = EnumServicesStatusW(hSCManager,dwServiceType,dwServiceState,lpServices,cbBufSize,pcbBytesNeeded,lpServicesReturned,lpResumeHandle);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_EnumServicesStatusW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZEqualPrefixSid (PSID pSid1,PSID pSid2)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = EqualPrefixSid(pSid1,pSid2);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_EqualPrefixSid, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZEqualSid (PSID pSid1,PSID pSid2)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = EqualSid(pSid1,pSid2);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_EqualSid, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZFindFirstFreeAce (PACL pAcl,LPVOID* pAce)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FindFirstFreeAce(pAcl,pAce);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FindFirstFreeAce, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

PVOID  ZFreeSid (PSID pSid)
{

    PVOID RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FreeSid(pSid);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FreeSid, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetAce (PACL pAcl,DWORD dwAceIndex,LPVOID* pAce)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetAce(pAcl,dwAceIndex,pAce);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetAce, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetAclInformation (PACL pAcl,LPVOID pAclInformation,DWORD nAclInformationLength,ACL_INFORMATION_CLASS dwAclInformationClass)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetAclInformation(pAcl,pAclInformation,nAclInformationLength,dwAclInformationClass);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetAclInformation, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetFileSecurityA (LPCSTR lpFileName,SECURITY_INFORMATION RequestedInformation,PSECURITY_DESCRIPTOR pSecurityDescriptor,DWORD nLength,LPDWORD lpnLengthNeeded)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetFileSecurityA(lpFileName,RequestedInformation,pSecurityDescriptor,nLength,lpnLengthNeeded);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetFileSecurityA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetFileSecurityW (LPCWSTR lpFileName,SECURITY_INFORMATION RequestedInformation,PSECURITY_DESCRIPTOR pSecurityDescriptor,DWORD nLength,LPDWORD lpnLengthNeeded)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetFileSecurityW(lpFileName,RequestedInformation,pSecurityDescriptor,nLength,lpnLengthNeeded);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetFileSecurityW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetKernelObjectSecurity (HANDLE Handle,SECURITY_INFORMATION RequestedInformation,PSECURITY_DESCRIPTOR pSecurityDescriptor,DWORD nLength,LPDWORD lpnLengthNeeded)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetKernelObjectSecurity(Handle,RequestedInformation,pSecurityDescriptor,nLength,lpnLengthNeeded);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetKernelObjectSecurity, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetLengthSid (PSID pSid)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetLengthSid(pSid);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetLengthSid, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetNumberOfEventLogRecords (HANDLE hEventLog,PDWORD NumberOfRecords)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetNumberOfEventLogRecords(hEventLog,NumberOfRecords);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetNumberOfEventLogRecords, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetOldestEventLogRecord (HANDLE hEventLog,PDWORD OldestRecord)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetOldestEventLogRecord(hEventLog,OldestRecord);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetOldestEventLogRecord, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetPrivateObjectSecurity (PSECURITY_DESCRIPTOR ObjectDescriptor,SECURITY_INFORMATION SecurityInformation,PSECURITY_DESCRIPTOR ResultantDescriptor,DWORD DescriptorLength,PDWORD ReturnLength)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetPrivateObjectSecurity(ObjectDescriptor,SecurityInformation,ResultantDescriptor,DescriptorLength,ReturnLength);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetPrivateObjectSecurity, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetSecurityDescriptorControl (PSECURITY_DESCRIPTOR pSecurityDescriptor,PSECURITY_DESCRIPTOR_CONTROL pControl,LPDWORD lpdwRevision)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetSecurityDescriptorControl(pSecurityDescriptor,pControl,lpdwRevision);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetSecurityDescriptorControl, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetSecurityDescriptorDacl (PSECURITY_DESCRIPTOR pSecurityDescriptor,LPBOOL lpbDaclPresent,PACL* pDacl,LPBOOL lpbDaclDefaulted)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetSecurityDescriptorDacl(pSecurityDescriptor,lpbDaclPresent,pDacl,lpbDaclDefaulted);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetSecurityDescriptorDacl, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetSecurityDescriptorGroup (PSECURITY_DESCRIPTOR pSecurityDescriptor,PSID* pGroup,LPBOOL lpbGroupDefaulted)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetSecurityDescriptorGroup(pSecurityDescriptor,pGroup,lpbGroupDefaulted);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetSecurityDescriptorGroup, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetSecurityDescriptorLength (PSECURITY_DESCRIPTOR pSecurityDescriptor)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetSecurityDescriptorLength(pSecurityDescriptor);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetSecurityDescriptorLength, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetSecurityDescriptorOwner (PSECURITY_DESCRIPTOR pSecurityDescriptor,PSID* pOwner,LPBOOL lpbOwnerDefaulted)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetSecurityDescriptorOwner(pSecurityDescriptor,pOwner,lpbOwnerDefaulted);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetSecurityDescriptorOwner, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetSecurityDescriptorSacl (PSECURITY_DESCRIPTOR pSecurityDescriptor,LPBOOL lpbSaclPresent,PACL* pSacl,LPBOOL lpbSaclDefaulted)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetSecurityDescriptorSacl(pSecurityDescriptor,lpbSaclPresent,pSacl,lpbSaclDefaulted);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetSecurityDescriptorSacl, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetServiceDisplayNameA (SC_HANDLE hSCManager,LPCSTR lpServiceName,LPSTR lpDisplayName,LPDWORD lpcchBuffer)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetServiceDisplayNameA(hSCManager,lpServiceName,lpDisplayName,lpcchBuffer);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetServiceDisplayNameA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetServiceDisplayNameW (SC_HANDLE hSCManager,LPCWSTR lpServiceName,LPWSTR lpDisplayName,LPDWORD lpcchBuffer)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetServiceDisplayNameW(hSCManager,lpServiceName,lpDisplayName,lpcchBuffer);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetServiceDisplayNameW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetServiceKeyNameA (SC_HANDLE hSCManager,LPCSTR lpDisplayName,LPSTR lpServiceName,LPDWORD lpcchBuffer)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetServiceKeyNameA(hSCManager,lpDisplayName,lpServiceName,lpcchBuffer);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetServiceKeyNameA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetServiceKeyNameW (SC_HANDLE hSCManager,LPCWSTR lpDisplayName,LPWSTR lpServiceName,LPDWORD lpcchBuffer)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetServiceKeyNameW(hSCManager,lpDisplayName,lpServiceName,lpcchBuffer);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetServiceKeyNameW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

PSID_IDENTIFIER_AUTHORITY  ZGetSidIdentifierAuthority (PSID pSid)
{

    PSID_IDENTIFIER_AUTHORITY RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetSidIdentifierAuthority(pSid);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetSidIdentifierAuthority, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetSidLengthRequired (UCHAR nSubAuthorityCount)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetSidLengthRequired(nSubAuthorityCount);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetSidLengthRequired, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

PDWORD  ZGetSidSubAuthority (PSID pSid,DWORD nSubAuthority)
{

    PDWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetSidSubAuthority(pSid,nSubAuthority);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetSidSubAuthority, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

PUCHAR  ZGetSidSubAuthorityCount (PSID pSid)
{

    PUCHAR RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetSidSubAuthorityCount(pSid);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetSidSubAuthorityCount, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetTokenInformation (HANDLE TokenHandle,TOKEN_INFORMATION_CLASS TokenInformationClass,LPVOID TokenInformation,DWORD TokenInformationLength,PDWORD ReturnLength)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetTokenInformation(TokenHandle,TokenInformationClass,TokenInformation,TokenInformationLength,ReturnLength);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetTokenInformation, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetUserNameA (LPSTR lpBuffer,LPDWORD nSize)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetUserNameA(lpBuffer,nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetUserNameA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetUserNameW (LPWSTR lpBuffer,LPDWORD nSize)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetUserNameW(lpBuffer,nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetUserNameW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZImpersonateNamedPipeClient (HANDLE hNamedPipe)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ImpersonateNamedPipeClient(hNamedPipe);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ImpersonateNamedPipeClient, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZImpersonateSelf (SECURITY_IMPERSONATION_LEVEL ImpersonationLevel)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ImpersonateSelf(ImpersonationLevel);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ImpersonateSelf, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZInitializeAcl (PACL pAcl,DWORD nAclLength,DWORD dwAclRevision)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = InitializeAcl(pAcl,nAclLength,dwAclRevision);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_InitializeAcl, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZInitializeSecurityDescriptor (PSECURITY_DESCRIPTOR pSecurityDescriptor,DWORD dwRevision)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = InitializeSecurityDescriptor(pSecurityDescriptor,dwRevision);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_InitializeSecurityDescriptor, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZInitializeSid (PSID Sid,PSID_IDENTIFIER_AUTHORITY pIdentifierAuthority,BYTE nSubAuthorityCount)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = InitializeSid(Sid,pIdentifierAuthority,nSubAuthorityCount);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_InitializeSid, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZInitiateSystemShutdownA (LPSTR lpMachineName,LPSTR lpMessage,DWORD dwTimeout,BOOL bForceAppsClosed,BOOL bRebootAfterShutdown)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = InitiateSystemShutdownA(lpMachineName,lpMessage,dwTimeout,bForceAppsClosed,bRebootAfterShutdown);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_InitiateSystemShutdownA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZInitiateSystemShutdownW (LPWSTR lpMachineName,LPWSTR lpMessage,DWORD dwTimeout,BOOL bForceAppsClosed,BOOL bRebootAfterShutdown)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = InitiateSystemShutdownW(lpMachineName,lpMessage,dwTimeout,bForceAppsClosed,bRebootAfterShutdown);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_InitiateSystemShutdownW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZIsValidAcl (PACL pAcl)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = IsValidAcl(pAcl);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_IsValidAcl, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZIsValidSecurityDescriptor (PSECURITY_DESCRIPTOR pSecurityDescriptor)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = IsValidSecurityDescriptor(pSecurityDescriptor);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_IsValidSecurityDescriptor, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZIsValidSid (PSID pSid)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = IsValidSid(pSid);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_IsValidSid, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

SC_LOCK  ZLockServiceDatabase (SC_HANDLE hSCManager)
{

    SC_LOCK RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LockServiceDatabase(hSCManager);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LockServiceDatabase, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZLookupAccountNameA (LPCSTR lpSystemName,LPCSTR lpAccountName,PSID Sid,LPDWORD cbSid,LPSTR ReferencedDomainName,LPDWORD cbReferencedDomainName,PSID_NAME_USE peUse)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LookupAccountNameA(lpSystemName,lpAccountName,Sid,cbSid,ReferencedDomainName,cbReferencedDomainName,peUse);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LookupAccountNameA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZLookupAccountNameW (LPCWSTR lpSystemName,LPCWSTR lpAccountName,PSID Sid,LPDWORD cbSid,LPWSTR ReferencedDomainName,LPDWORD cbReferencedDomainName,PSID_NAME_USE peUse)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LookupAccountNameW(lpSystemName,lpAccountName,Sid,cbSid,ReferencedDomainName,cbReferencedDomainName,peUse);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LookupAccountNameW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZLookupAccountSidA (LPCSTR lpSystemName,PSID Sid,LPSTR Name,LPDWORD cbName,LPSTR ReferencedDomainName,LPDWORD cbReferencedDomainName,PSID_NAME_USE peUse)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LookupAccountSidA(lpSystemName,Sid,Name,cbName,ReferencedDomainName,cbReferencedDomainName,peUse);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LookupAccountSidA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZLookupAccountSidW (LPCWSTR lpSystemName,PSID Sid,LPWSTR Name,LPDWORD cbName,LPWSTR ReferencedDomainName,LPDWORD cbReferencedDomainName,PSID_NAME_USE peUse)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LookupAccountSidW(lpSystemName,Sid,Name,cbName,ReferencedDomainName,cbReferencedDomainName,peUse);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LookupAccountSidW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZLookupPrivilegeDisplayNameA (LPCSTR lpSystemName,LPCSTR lpName,LPSTR lpDisplayName,LPDWORD cbDisplayName,LPDWORD lpLanguageId)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LookupPrivilegeDisplayNameA(lpSystemName,lpName,lpDisplayName,cbDisplayName,lpLanguageId);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LookupPrivilegeDisplayNameA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZLookupPrivilegeDisplayNameW (LPCWSTR lpSystemName,LPCWSTR lpName,LPWSTR lpDisplayName,LPDWORD cbDisplayName,LPDWORD lpLanguageId)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LookupPrivilegeDisplayNameW(lpSystemName,lpName,lpDisplayName,cbDisplayName,lpLanguageId);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LookupPrivilegeDisplayNameW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZLookupPrivilegeNameA (LPCSTR lpSystemName,PLUID lpLuid,LPSTR lpName,LPDWORD cbName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LookupPrivilegeNameA(lpSystemName,lpLuid,lpName,cbName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LookupPrivilegeNameA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZLookupPrivilegeNameW (LPCWSTR lpSystemName,PLUID lpLuid,LPWSTR lpName,LPDWORD cbName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LookupPrivilegeNameW(lpSystemName,lpLuid,lpName,cbName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LookupPrivilegeNameW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZLookupPrivilegeValueA (LPCSTR lpSystemName,LPCSTR lpName,PLUID lpLuid)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LookupPrivilegeValueA(lpSystemName,lpName,lpLuid);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LookupPrivilegeValueA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZLookupPrivilegeValueW (LPCWSTR lpSystemName,LPCWSTR lpName,PLUID lpLuid)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LookupPrivilegeValueW(lpSystemName,lpName,lpLuid);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LookupPrivilegeValueW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZMakeAbsoluteSD (PSECURITY_DESCRIPTOR pSelfRelativeSecurityDescriptor,PSECURITY_DESCRIPTOR pAbsoluteSecurityDescriptor,LPDWORD lpdwAbsoluteSecurityDescriptorSize,PACL pDacl,LPDWORD lpdwDaclSize,PACL pSacl,LPDWORD lpdwSaclSize,PSID pOwner,LPDWORD lpdwOwnerSize,PSID pPrimaryGroup,LPDWORD lpdwPrimaryGroupSize)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = MakeAbsoluteSD(pSelfRelativeSecurityDescriptor,pAbsoluteSecurityDescriptor,lpdwAbsoluteSecurityDescriptorSize,pDacl,lpdwDaclSize,pSacl,lpdwSaclSize,pOwner,lpdwOwnerSize,pPrimaryGroup,lpdwPrimaryGroupSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_MakeAbsoluteSD, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZMakeSelfRelativeSD (PSECURITY_DESCRIPTOR pAbsoluteSecurityDescriptor,PSECURITY_DESCRIPTOR pSelfRelativeSecurityDescriptor,LPDWORD lpdwBufferLength)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = MakeSelfRelativeSD(pAbsoluteSecurityDescriptor,pSelfRelativeSecurityDescriptor,lpdwBufferLength);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_MakeSelfRelativeSD, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

void  ZMapGenericMask (PDWORD AccessMask,PGENERIC_MAPPING GenericMapping)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    MapGenericMask(AccessMask,GenericMapping);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_MapGenericMask, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

BOOL  ZNotifyBootConfigStatus (BOOL BootAcceptable)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = NotifyBootConfigStatus(BootAcceptable);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_NotifyBootConfigStatus, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZObjectCloseAuditAlarmA (LPCSTR SubsystemName,LPVOID HandleId,BOOL GenerateOnClose)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ObjectCloseAuditAlarmA(SubsystemName,HandleId,GenerateOnClose);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ObjectCloseAuditAlarmA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZObjectCloseAuditAlarmW (LPCWSTR SubsystemName,LPVOID HandleId,BOOL GenerateOnClose)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ObjectCloseAuditAlarmW(SubsystemName,HandleId,GenerateOnClose);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ObjectCloseAuditAlarmW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZObjectOpenAuditAlarmA (LPCSTR SubsystemName,LPVOID HandleId,LPSTR ObjectTypeName,LPSTR ObjectName,PSECURITY_DESCRIPTOR pSecurityDescriptor,HANDLE ClientToken,DWORD DesiredAccess,DWORD GrantedAccess,PPRIVILEGE_SET Privileges,BOOL ObjectCreation,BOOL AccessGranted,LPBOOL GenerateOnClose)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ObjectOpenAuditAlarmA(SubsystemName,HandleId,ObjectTypeName,ObjectName,pSecurityDescriptor,ClientToken,DesiredAccess,GrantedAccess,Privileges,ObjectCreation,AccessGranted,GenerateOnClose);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ObjectOpenAuditAlarmA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZObjectOpenAuditAlarmW (LPCWSTR SubsystemName,LPVOID HandleId,LPWSTR ObjectTypeName,LPWSTR ObjectName,PSECURITY_DESCRIPTOR pSecurityDescriptor,HANDLE ClientToken,DWORD DesiredAccess,DWORD GrantedAccess,PPRIVILEGE_SET Privileges,BOOL ObjectCreation,BOOL AccessGranted,LPBOOL GenerateOnClose)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ObjectOpenAuditAlarmW(SubsystemName,HandleId,ObjectTypeName,ObjectName,pSecurityDescriptor,ClientToken,DesiredAccess,GrantedAccess,Privileges,ObjectCreation,AccessGranted,GenerateOnClose);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ObjectOpenAuditAlarmW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZObjectPrivilegeAuditAlarmA (LPCSTR SubsystemName,LPVOID HandleId,HANDLE ClientToken,DWORD DesiredAccess,PPRIVILEGE_SET Privileges,BOOL AccessGranted)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ObjectPrivilegeAuditAlarmA(SubsystemName,HandleId,ClientToken,DesiredAccess,Privileges,AccessGranted);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ObjectPrivilegeAuditAlarmA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZObjectPrivilegeAuditAlarmW (LPCWSTR SubsystemName,LPVOID HandleId,HANDLE ClientToken,DWORD DesiredAccess,PPRIVILEGE_SET Privileges,BOOL AccessGranted)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ObjectPrivilegeAuditAlarmW(SubsystemName,HandleId,ClientToken,DesiredAccess,Privileges,AccessGranted);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ObjectPrivilegeAuditAlarmW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZOpenBackupEventLogA (LPCSTR lpUNCServerName,LPCSTR lpFileName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = OpenBackupEventLogA(lpUNCServerName,lpFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_OpenBackupEventLogA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZOpenBackupEventLogW (LPCWSTR lpUNCServerName,LPCWSTR lpFileName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = OpenBackupEventLogW(lpUNCServerName,lpFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_OpenBackupEventLogW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZOpenEventLogA (LPCSTR lpUNCServerName,LPCSTR lpSourceName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = OpenEventLogA(lpUNCServerName,lpSourceName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_OpenEventLogA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZOpenEventLogW (LPCWSTR lpUNCServerName,LPCWSTR lpSourceName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = OpenEventLogW(lpUNCServerName,lpSourceName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_OpenEventLogW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZOpenProcessToken (HANDLE ProcessHandle,DWORD DesiredAccess,PHANDLE TokenHandle)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = OpenProcessToken(ProcessHandle,DesiredAccess,TokenHandle);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_OpenProcessToken, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

SC_HANDLE  ZOpenSCManagerA (LPCSTR lpMachineName,LPCSTR lpDatabaseName,DWORD dwDesiredAccess)
{

    SC_HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = OpenSCManagerA(lpMachineName,lpDatabaseName,dwDesiredAccess);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_OpenSCManagerA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

SC_HANDLE  ZOpenSCManagerW (LPCWSTR lpMachineName,LPCWSTR lpDatabaseName,DWORD dwDesiredAccess)
{

    SC_HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = OpenSCManagerW(lpMachineName,lpDatabaseName,dwDesiredAccess);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_OpenSCManagerW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

SC_HANDLE  ZOpenServiceA (SC_HANDLE hSCManager,LPCSTR lpServiceName,DWORD dwDesiredAccess)
{

    SC_HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = OpenServiceA(hSCManager,lpServiceName,dwDesiredAccess);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_OpenServiceA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

SC_HANDLE  ZOpenServiceW (SC_HANDLE hSCManager,LPCWSTR lpServiceName,DWORD dwDesiredAccess)
{

    SC_HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = OpenServiceW(hSCManager,lpServiceName,dwDesiredAccess);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_OpenServiceW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZOpenThreadToken (HANDLE ThreadHandle,DWORD DesiredAccess,BOOL OpenAsSelf,PHANDLE TokenHandle)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = OpenThreadToken(ThreadHandle,DesiredAccess,OpenAsSelf,TokenHandle);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_OpenThreadToken, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZPrivilegeCheck (HANDLE ClientToken,PPRIVILEGE_SET RequiredPrivileges,LPBOOL pfResult)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = PrivilegeCheck(ClientToken,RequiredPrivileges,pfResult);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_PrivilegeCheck, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZPrivilegedServiceAuditAlarmA (LPCSTR SubsystemName,LPCSTR ServiceName,HANDLE ClientToken,PPRIVILEGE_SET Privileges,BOOL AccessGranted)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = PrivilegedServiceAuditAlarmA(SubsystemName,ServiceName,ClientToken,Privileges,AccessGranted);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_PrivilegedServiceAuditAlarmA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZPrivilegedServiceAuditAlarmW (LPCWSTR SubsystemName,LPCWSTR ServiceName,HANDLE ClientToken,PPRIVILEGE_SET Privileges,BOOL AccessGranted)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = PrivilegedServiceAuditAlarmW(SubsystemName,ServiceName,ClientToken,Privileges,AccessGranted);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_PrivilegedServiceAuditAlarmW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZQueryServiceConfigA (SC_HANDLE hService,LPQUERY_SERVICE_CONFIGA lpServiceConfig,DWORD cbBufSize,LPDWORD pcbBytesNeeded)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = QueryServiceConfigA(hService,lpServiceConfig,cbBufSize,pcbBytesNeeded);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_QueryServiceConfigA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZQueryServiceConfigW (SC_HANDLE hService,LPQUERY_SERVICE_CONFIGW lpServiceConfig,DWORD cbBufSize,LPDWORD pcbBytesNeeded)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = QueryServiceConfigW(hService,lpServiceConfig,cbBufSize,pcbBytesNeeded);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_QueryServiceConfigW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZQueryServiceLockStatusA (SC_HANDLE hSCManager,LPQUERY_SERVICE_LOCK_STATUSA lpLockStatus,DWORD cbBufSize,LPDWORD pcbBytesNeeded)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = QueryServiceLockStatusA(hSCManager,lpLockStatus,cbBufSize,pcbBytesNeeded);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_QueryServiceLockStatusA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZQueryServiceLockStatusW (SC_HANDLE hSCManager,LPQUERY_SERVICE_LOCK_STATUSW lpLockStatus,DWORD cbBufSize,LPDWORD pcbBytesNeeded)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = QueryServiceLockStatusW(hSCManager,lpLockStatus,cbBufSize,pcbBytesNeeded);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_QueryServiceLockStatusW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZQueryServiceObjectSecurity (SC_HANDLE hService,SECURITY_INFORMATION dwSecurityInformation,PSECURITY_DESCRIPTOR lpSecurityDescriptor,DWORD cbBufSize,LPDWORD pcbBytesNeeded)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = QueryServiceObjectSecurity(hService,dwSecurityInformation,lpSecurityDescriptor,cbBufSize,pcbBytesNeeded);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_QueryServiceObjectSecurity, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZQueryServiceStatus (SC_HANDLE hService,LPSERVICE_STATUS lpServiceStatus)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = QueryServiceStatus(hService,lpServiceStatus);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_QueryServiceStatus, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZReadEventLogA (HANDLE hEventLog,DWORD dwReadFlags,DWORD dwRecordOffset,LPVOID lpBuffer,DWORD nNumberOfBytesToRead,DWORD* pnBytesRead,DWORD* pnMinNumberOfBytesNeeded)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ReadEventLogA(hEventLog,dwReadFlags,dwRecordOffset,lpBuffer,nNumberOfBytesToRead,pnBytesRead,pnMinNumberOfBytesNeeded);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ReadEventLogA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZReadEventLogW (HANDLE hEventLog,DWORD dwReadFlags,DWORD dwRecordOffset,LPVOID lpBuffer,DWORD nNumberOfBytesToRead,DWORD* pnBytesRead,DWORD* pnMinNumberOfBytesNeeded)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ReadEventLogW(hEventLog,dwReadFlags,dwRecordOffset,lpBuffer,nNumberOfBytesToRead,pnBytesRead,pnMinNumberOfBytesNeeded);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ReadEventLogW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegCloseKey (HKEY hKey)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegCloseKey(hKey);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegCloseKey, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegConnectRegistryA (LPSTR lpMachineName,HKEY hKey,PHKEY phkResult)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegConnectRegistryA(lpMachineName,hKey,phkResult);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegConnectRegistryA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegConnectRegistryW (LPWSTR lpMachineName,HKEY hKey,PHKEY phkResult)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegConnectRegistryW(lpMachineName,hKey,phkResult);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegConnectRegistryW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegCreateKeyA (HKEY hKey,LPCSTR lpSubKey,PHKEY phkResult)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegCreateKeyA(hKey,lpSubKey,phkResult);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegCreateKeyA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegCreateKeyExA (HKEY hKey,LPCSTR lpSubKey,DWORD Reserved,LPSTR lpClass,DWORD dwOptions,REGSAM samDesired,LPSECURITY_ATTRIBUTES lpSecurityAttributes,PHKEY phkResult,LPDWORD lpdwDisposition)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegCreateKeyExA(hKey,lpSubKey,Reserved,lpClass,dwOptions,samDesired,lpSecurityAttributes,phkResult,lpdwDisposition);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegCreateKeyExA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegCreateKeyExW (HKEY hKey,LPCWSTR lpSubKey,DWORD Reserved,LPWSTR lpClass,DWORD dwOptions,REGSAM samDesired,LPSECURITY_ATTRIBUTES lpSecurityAttributes,PHKEY phkResult,LPDWORD lpdwDisposition)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegCreateKeyExW(hKey,lpSubKey,Reserved,lpClass,dwOptions,samDesired,lpSecurityAttributes,phkResult,lpdwDisposition);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegCreateKeyExW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegCreateKeyW (HKEY hKey,LPCWSTR lpSubKey,PHKEY phkResult)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegCreateKeyW(hKey,lpSubKey,phkResult);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegCreateKeyW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegDeleteKeyA (HKEY hKey,LPCSTR lpSubKey)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegDeleteKeyA(hKey,lpSubKey);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegDeleteKeyA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegDeleteKeyW (HKEY hKey,LPCWSTR lpSubKey)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegDeleteKeyW(hKey,lpSubKey);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegDeleteKeyW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegDeleteValueA (HKEY hKey,LPSTR lpValueName)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegDeleteValueA(hKey,lpValueName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegDeleteValueA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegDeleteValueW (HKEY hKey,LPWSTR lpValueName)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegDeleteValueW(hKey,lpValueName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegDeleteValueW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegEnumKeyA (HKEY hKey,DWORD dwIndex,LPSTR lpName,DWORD cbName)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegEnumKeyA(hKey,dwIndex,lpName,cbName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegEnumKeyA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegEnumKeyExA (HKEY hKey,DWORD dwIndex,LPSTR lpName,LPDWORD lpcbName,LPDWORD lpReserved,LPSTR lpClass,LPDWORD lpcbClass,PFILETIME lpftLastWriteTime)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegEnumKeyExA(hKey,dwIndex,lpName,lpcbName,lpReserved,lpClass,lpcbClass,lpftLastWriteTime);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegEnumKeyExA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegEnumKeyExW (HKEY hKey,DWORD dwIndex,LPWSTR lpName,LPDWORD lpcbName,LPDWORD lpReserved,LPWSTR lpClass,LPDWORD lpcbClass,PFILETIME lpftLastWriteTime)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegEnumKeyExW(hKey,dwIndex,lpName,lpcbName,lpReserved,lpClass,lpcbClass,lpftLastWriteTime);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegEnumKeyExW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegEnumKeyW (HKEY hKey,DWORD dwIndex,LPWSTR lpName,DWORD cbName)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegEnumKeyW(hKey,dwIndex,lpName,cbName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegEnumKeyW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegEnumValueA (HKEY hKey,DWORD dwIndex,LPSTR lpValueName,LPDWORD lpcbValueName,LPDWORD lpReserved,LPDWORD lpType,LPBYTE lpData,LPDWORD lpcbData)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegEnumValueA(hKey,dwIndex,lpValueName,lpcbValueName,lpReserved,lpType,lpData,lpcbData);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegEnumValueA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegEnumValueW (HKEY hKey,DWORD dwIndex,LPWSTR lpValueName,LPDWORD lpcbValueName,LPDWORD lpReserved,LPDWORD lpType,LPBYTE lpData,LPDWORD lpcbData)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegEnumValueW(hKey,dwIndex,lpValueName,lpcbValueName,lpReserved,lpType,lpData,lpcbData);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegEnumValueW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegFlushKey (HKEY hKey)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegFlushKey(hKey);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegFlushKey, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegGetKeySecurity (HKEY hKey,SECURITY_INFORMATION SecurityInformation,PSECURITY_DESCRIPTOR pSecurityDescriptor,LPDWORD lpcbSecurityDescriptor)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegGetKeySecurity(hKey,SecurityInformation,pSecurityDescriptor,lpcbSecurityDescriptor);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegGetKeySecurity, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegLoadKeyA (HKEY hKey,LPCSTR lpSubKey,LPCSTR lpFile)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegLoadKeyA(hKey,lpSubKey,lpFile);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegLoadKeyA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegLoadKeyW (HKEY hKey,LPCWSTR lpSubKey,LPCWSTR lpFile)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegLoadKeyW(hKey,lpSubKey,lpFile);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegLoadKeyW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegNotifyChangeKeyValue (HKEY hKey,BOOL bWatchSubtree,DWORD dwNotifyFilter,HANDLE hEvent,BOOL fAsynchronus)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegNotifyChangeKeyValue(hKey,bWatchSubtree,dwNotifyFilter,hEvent,fAsynchronus);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegNotifyChangeKeyValue, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegOpenKeyA (HKEY hKey,LPCSTR lpSubKey,PHKEY phkResult)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegOpenKeyA(hKey,lpSubKey,phkResult);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegOpenKeyA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegOpenKeyExA (HKEY hKey,LPCSTR lpSubKey,DWORD ulOptions,REGSAM samDesired,PHKEY phkResult)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegOpenKeyExA(hKey,lpSubKey,ulOptions,samDesired,phkResult);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegOpenKeyExA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegOpenKeyExW (HKEY hKey,LPCWSTR lpSubKey,DWORD ulOptions,REGSAM samDesired,PHKEY phkResult)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegOpenKeyExW(hKey,lpSubKey,ulOptions,samDesired,phkResult);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegOpenKeyExW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegOpenKeyW (HKEY hKey,LPCWSTR lpSubKey,PHKEY phkResult)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegOpenKeyW(hKey,lpSubKey,phkResult);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegOpenKeyW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegQueryInfoKeyA (HKEY hKey,LPSTR lpClass,LPDWORD lpcbClass,LPDWORD lpReserved,LPDWORD lpcSubKeys,LPDWORD lpcbMaxSubKeyLen,LPDWORD lpcbMaxClassLen,LPDWORD lpcValues,LPDWORD lpcbMaxValueNameLen,LPDWORD lpcbMaxValueLen,LPDWORD lpcbSecurityDescriptor,PFILETIME lpftLastWriteTime)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegQueryInfoKeyA(hKey,lpClass,lpcbClass,lpReserved,lpcSubKeys,lpcbMaxSubKeyLen,lpcbMaxClassLen,lpcValues,lpcbMaxValueNameLen,lpcbMaxValueLen,lpcbSecurityDescriptor,lpftLastWriteTime);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegQueryInfoKeyA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegQueryInfoKeyW (HKEY hKey,LPWSTR lpClass,LPDWORD lpcbClass,LPDWORD lpReserved,LPDWORD lpcSubKeys,LPDWORD lpcbMaxSubKeyLen,LPDWORD lpcbMaxClassLen,LPDWORD lpcValues,LPDWORD lpcbMaxValueNameLen,LPDWORD lpcbMaxValueLen,LPDWORD lpcbSecurityDescriptor,PFILETIME lpftLastWriteTime)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegQueryInfoKeyW(hKey,lpClass,lpcbClass,lpReserved,lpcSubKeys,lpcbMaxSubKeyLen,lpcbMaxClassLen,lpcValues,lpcbMaxValueNameLen,lpcbMaxValueLen,lpcbSecurityDescriptor,lpftLastWriteTime);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegQueryInfoKeyW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegQueryValueA (HKEY hKey,LPCSTR lpSubKey,LPSTR lpValue,PLONG lpcbValue)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegQueryValueA(hKey,lpSubKey,lpValue,lpcbValue);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegQueryValueA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegQueryValueExA (HKEY hKey,LPSTR lpValueName,LPDWORD lpReserved,LPDWORD lpType,LPBYTE lpData,LPDWORD lpcbData)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegQueryValueExA(hKey,lpValueName,lpReserved,lpType,lpData,lpcbData);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegQueryValueExA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegQueryValueExW (HKEY hKey,LPWSTR lpValueName,LPDWORD lpReserved,LPDWORD lpType,LPBYTE lpData,LPDWORD lpcbData)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegQueryValueExW(hKey,lpValueName,lpReserved,lpType,lpData,lpcbData);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegQueryValueExW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegQueryValueW (HKEY hKey,LPCWSTR lpSubKey,LPWSTR lpValue,PLONG lpcbValue)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegQueryValueW(hKey,lpSubKey,lpValue,lpcbValue);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegQueryValueW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegReplaceKeyA (HKEY hKey,LPCSTR lpSubKey,LPCSTR lpNewFile,LPCSTR lpOldFile)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegReplaceKeyA(hKey,lpSubKey,lpNewFile,lpOldFile);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegReplaceKeyA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegReplaceKeyW (HKEY hKey,LPCWSTR lpSubKey,LPCWSTR lpNewFile,LPCWSTR lpOldFile)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegReplaceKeyW(hKey,lpSubKey,lpNewFile,lpOldFile);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegReplaceKeyW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegRestoreKeyA (HKEY hKey,LPCSTR lpFile,DWORD dwFlags)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegRestoreKeyA(hKey,lpFile,dwFlags);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegRestoreKeyA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegRestoreKeyW (HKEY hKey,LPCWSTR lpFile,DWORD dwFlags)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegRestoreKeyW(hKey,lpFile,dwFlags);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegRestoreKeyW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegSaveKeyA (HKEY hKey,LPCSTR lpFile,LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegSaveKeyA(hKey,lpFile,lpSecurityAttributes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegSaveKeyA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegSaveKeyW (HKEY hKey,LPCWSTR lpFile,LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegSaveKeyW(hKey,lpFile,lpSecurityAttributes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegSaveKeyW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegSetKeySecurity (HKEY hKey,SECURITY_INFORMATION SecurityInformation,PSECURITY_DESCRIPTOR pSecurityDescriptor)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegSetKeySecurity(hKey,SecurityInformation,pSecurityDescriptor);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegSetKeySecurity, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegSetValueA (HKEY hKey,LPCSTR lpSubKey,DWORD dwType,LPCSTR lpData,DWORD cbData)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegSetValueA(hKey,lpSubKey,dwType,lpData,cbData);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegSetValueA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegSetValueExA (HKEY hKey,LPCSTR lpValueName,DWORD Reserved,DWORD dwType,const BYTE* lpData,DWORD cbData)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegSetValueExA(hKey,lpValueName,Reserved,dwType,lpData,cbData);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegSetValueExA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegSetValueExW (HKEY hKey,LPCWSTR lpValueName,DWORD Reserved,DWORD dwType,const BYTE* lpData,DWORD cbData)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegSetValueExW(hKey,lpValueName,Reserved,dwType,lpData,cbData);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegSetValueExW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegSetValueW (HKEY hKey,LPCWSTR lpSubKey,DWORD dwType,LPCWSTR lpData,DWORD cbData)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegSetValueW(hKey,lpSubKey,dwType,lpData,cbData);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegSetValueW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegUnLoadKeyA (HKEY hKey,LPCSTR lpSubKey)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegUnLoadKeyA(hKey,lpSubKey);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegUnLoadKeyA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZRegUnLoadKeyW (HKEY hKey,LPCWSTR lpSubKey)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegUnLoadKeyW(hKey,lpSubKey);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegUnLoadKeyW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZRegisterEventSourceA (LPCSTR lpUNCServerName,LPCSTR lpSourceName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegisterEventSourceA(lpUNCServerName,lpSourceName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegisterEventSourceA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZRegisterEventSourceW (LPCWSTR lpUNCServerName,LPCWSTR lpSourceName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegisterEventSourceW(lpUNCServerName,lpSourceName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegisterEventSourceW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

SERVICE_STATUS_HANDLE  ZRegisterServiceCtrlHandlerA (LPCSTR lpServiceName,LPHANDLER_FUNCTION lpHandlerProc)
{

    SERVICE_STATUS_HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegisterServiceCtrlHandlerA(lpServiceName,lpHandlerProc);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegisterServiceCtrlHandlerA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

SERVICE_STATUS_HANDLE  ZRegisterServiceCtrlHandlerW (LPCWSTR lpServiceName,LPHANDLER_FUNCTION lpHandlerProc)
{

    SERVICE_STATUS_HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RegisterServiceCtrlHandlerW(lpServiceName,lpHandlerProc);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RegisterServiceCtrlHandlerW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZReportEventA (HANDLE hEventLog,WORD wType,WORD wCategory,DWORD dwEventID,PSID lpUserSid,WORD wNumStrings,DWORD dwDataSize,LPCSTR* lpStrings,LPVOID lpRawData)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ReportEventA(hEventLog,wType,wCategory,dwEventID,lpUserSid,wNumStrings,dwDataSize,lpStrings,lpRawData);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ReportEventA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZReportEventW (HANDLE hEventLog,WORD wType,WORD wCategory,DWORD dwEventID,PSID lpUserSid,WORD wNumStrings,DWORD dwDataSize,LPCWSTR* lpStrings,LPVOID lpRawData)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ReportEventW(hEventLog,wType,wCategory,dwEventID,lpUserSid,wNumStrings,dwDataSize,lpStrings,lpRawData);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ReportEventW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZRevertToSelf ()
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RevertToSelf();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RevertToSelf, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetAclInformation (PACL pAcl,LPVOID pAclInformation,DWORD nAclInformationLength,ACL_INFORMATION_CLASS dwAclInformationClass)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetAclInformation(pAcl,pAclInformation,nAclInformationLength,dwAclInformationClass);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetAclInformation, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetFileSecurityA (LPCSTR lpFileName,SECURITY_INFORMATION SecurityInformation,PSECURITY_DESCRIPTOR pSecurityDescriptor)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetFileSecurityA(lpFileName,SecurityInformation,pSecurityDescriptor);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetFileSecurityA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetFileSecurityW (LPCWSTR lpFileName,SECURITY_INFORMATION SecurityInformation,PSECURITY_DESCRIPTOR pSecurityDescriptor)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetFileSecurityW(lpFileName,SecurityInformation,pSecurityDescriptor);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetFileSecurityW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetKernelObjectSecurity (HANDLE Handle,SECURITY_INFORMATION SecurityInformation,PSECURITY_DESCRIPTOR SecurityDescriptor)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetKernelObjectSecurity(Handle,SecurityInformation,SecurityDescriptor);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetKernelObjectSecurity, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetPrivateObjectSecurity (SECURITY_INFORMATION SecurityInformation,PSECURITY_DESCRIPTOR ModificationDescriptor,PSECURITY_DESCRIPTOR* ObjectsSecurityDescriptor,PGENERIC_MAPPING GenericMapping,HANDLE Token)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetPrivateObjectSecurity(SecurityInformation,ModificationDescriptor,ObjectsSecurityDescriptor,GenericMapping,Token);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetPrivateObjectSecurity, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetSecurityDescriptorDacl (PSECURITY_DESCRIPTOR pSecurityDescriptor,BOOL bDaclPresent,PACL pDacl,BOOL bDaclDefaulted)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetSecurityDescriptorDacl(pSecurityDescriptor,bDaclPresent,pDacl,bDaclDefaulted);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetSecurityDescriptorDacl, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetSecurityDescriptorGroup (PSECURITY_DESCRIPTOR pSecurityDescriptor,PSID pGroup,BOOL bGroupDefaulted)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetSecurityDescriptorGroup(pSecurityDescriptor,pGroup,bGroupDefaulted);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetSecurityDescriptorGroup, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetSecurityDescriptorOwner (PSECURITY_DESCRIPTOR pSecurityDescriptor,PSID pOwner,BOOL bOwnerDefaulted)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetSecurityDescriptorOwner(pSecurityDescriptor,pOwner,bOwnerDefaulted);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetSecurityDescriptorOwner, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetSecurityDescriptorSacl (PSECURITY_DESCRIPTOR pSecurityDescriptor,BOOL bSaclPresent,PACL pSacl,BOOL bSaclDefaulted)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetSecurityDescriptorSacl(pSecurityDescriptor,bSaclPresent,pSacl,bSaclDefaulted);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetSecurityDescriptorSacl, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetServiceObjectSecurity (SC_HANDLE hService,SECURITY_INFORMATION dwSecurityInformation,PSECURITY_DESCRIPTOR lpSecurityDescriptor)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetServiceObjectSecurity(hService,dwSecurityInformation,lpSecurityDescriptor);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetServiceObjectSecurity, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetServiceStatus (SERVICE_STATUS_HANDLE hServiceStatus,LPSERVICE_STATUS lpServiceStatus)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetServiceStatus(hServiceStatus,lpServiceStatus);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetServiceStatus, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetTokenInformation (HANDLE TokenHandle,TOKEN_INFORMATION_CLASS TokenInformationClass,LPVOID TokenInformation,DWORD TokenInformationLength)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetTokenInformation(TokenHandle,TokenInformationClass,TokenInformation,TokenInformationLength);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetTokenInformation, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZStartServiceA (SC_HANDLE hService,DWORD dwNumServiceArgs,LPCSTR* lpServiceArgVectors)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = StartServiceA(hService,dwNumServiceArgs,lpServiceArgVectors);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_StartServiceA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZStartServiceCtrlDispatcherA (LPSERVICE_TABLE_ENTRYA lpServiceStartTable)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = StartServiceCtrlDispatcherA(lpServiceStartTable);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_StartServiceCtrlDispatcherA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZStartServiceCtrlDispatcherW (LPSERVICE_TABLE_ENTRYW lpServiceStartTable)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = StartServiceCtrlDispatcherW(lpServiceStartTable);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_StartServiceCtrlDispatcherW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZStartServiceW (SC_HANDLE hService,DWORD dwNumServiceArgs,LPCWSTR* lpServiceArgVectors)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = StartServiceW(hService,dwNumServiceArgs,lpServiceArgVectors);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_StartServiceW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZUnlockServiceDatabase (SC_LOCK ScLock)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle,MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = UnlockServiceDatabase(ScLock);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_UnlockServiceDatabase, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}
