/***
*sprintf.c - print formatted to string
*
*	Copyright (c) 1985-1995, Microsoft Corporation. All rights reserved.
*
*Purpose:
*	defines sprintf() and _snprintf() - print formatted data to string
*
*Revision History:
*	09-02-83  RN	initial version
*	04-13-87  JCR	added const to declaration
*	06-24-87  JCR	(1) Made declaration conform to ANSI prototype and use
*			the va_ macros; (2) removed SS_NE_DS conditionals.
*	11-07-87  JCR	Multi-thread support
*	12-11-87  JCR	Added "_LOAD_DS" to declaration
*	05-27-88  PHG	Merged DLL and normal versions
*	06-13-88  JCR	Fake _iob entry is now static so that other routines
*			can assume _iob entries are in DGROUP.
*	08-25-88  GJF	Define MAXSTR to be INT_MAX (from LIMITS.H).
*	06-06-89  JCR	386 mthread support
*	08-18-89  GJF	Clean up, now specific to OS/2 2.0 (i.e., 386 flat
*			model). Also fixed copyright and indents.
*	02-16-90  GJF	Fixed copyright
*	03-19-90  GJF	Made calling type _CALLTYPE2, added #include
*			<cruntime.h> and removed #include <register.h>.
*	07-23-90  SBM	Replaced <assertm.h> by <assert.h>
*	10-03-90  GJF	New-style function declarator.
*	09-24-91  JCR	Added _snprintf()
*	04-06-93  SKS	Replace _CRTAPI* with __cdecl
*	09-05-94  SKS	Change "#ifdef" inside comments to "*ifdef" to avoid
*			problems with CRTL source release process.
*	02-06-94  CFW	assert -> _ASSERTE.
*
*******************************************************************************/

#include <cruntime.h>
#include <stdio.h>
#include <dbgint.h>
#include <stdarg.h>
#include <internal.h>
#include <limits.h>
#include <mtdll.h>

#define MAXSTR INT_MAX


/***
*ifndef _COUNT_
*int sprintf(string, format, ...) - print formatted data to string
*else
*int _snprintf(string, cnt, format, ...) - print formatted data to string
*endif
*
*Purpose:
*	Prints formatted data to the using the format string to
*	format data and getting as many arguments as called for
*	Sets up a FILE so file i/o operations can be used, make
*	string look like a huge buffer to it, but _flsbuf will
*	refuse to flush it if it fills up.  Appends '\0' to make
*	it a true string. _output does the real work here
*
*	Allocate the 'fake' _iob[] entry statically instead of on
*	the stack so that other routines can assume that _iob[]
*	entries are in are in DGROUP and, thus, are near.
*
*ifdef _COUNT_
*	The _snprintf() flavor takes a count argument that is
*	the max number of bytes that should be written to the
*	user's buffer.
*endif
*
*	Multi-thread: (1) Since there is no stream, this routine must
*	never try to get the stream lock (i.e., there is no stream
*	lock either). (2) Also, since there is only one statically
*	allocated 'fake' iob, we must lock/unlock to prevent collisions.
*
*Entry:
*	char *string - pointer to place to put output
*ifdef _COUNT_
*	size_t count - max number of bytes to put in buffer
*endif
*	char *format - format string to control data format/number
*	of arguments followed by list of arguments, number and type
*	controlled by format string
*
*Exit:
*	returns number of characters printed
*
*Exceptions:
*
*******************************************************************************/

#ifndef _COUNT_

int __cdecl sprintf (
	char *string,
	const char *format,
	...
	)
#else

int __cdecl _snprintf (
	char *string,
	size_t count,
	const char *format,
	...
	)
#endif

{
	FILE str;
	REG1 FILE *outfile = &str;
	va_list arglist;
	REG2 int retval;

	va_start(arglist, format);

	_ASSERTE(string != NULL);
	_ASSERTE(format != NULL);

	outfile->_flag = _IOWRT|_IOSTRG;
	outfile->_ptr = outfile->_base = string;
#ifndef _COUNT_
	outfile->_cnt = MAXSTR;
#else
	outfile->_cnt = count;
#endif

	retval = _output(outfile,format,arglist);

	_putc_lk('\0',outfile); /* no-lock version */

	return(retval);
}
