/*
 * TOKENS - This file contains the initialized tables of text, token pairs for
 * all the C language symbols and keywords, and the mapped value for YACC
 * and inline assembler.
 *
 * IMPORTANT : this MUST be in the same order as the %token list in grammar.y
 *
 */
/* token	TEXT		MAPPED TO 	IL OPCODE	ASM TOKEN */

DAT(L_NOTOKEN,	"newline",	L_NOTOKEN,	MAX_OPCODE,	ML_NL)
DAT(L_IDENT,	"identifier",	L_IDENT,	OPname,		ML_IDENT)
DAT(L_STRING,	"string",	L_STRING,	OPconstant,	ML_NOTOKEN)
DAT(L_CFLOAT,	"float constant", L_CONSTANT,	OPconstant,	ML_NOTOKEN)
DAT(L_CDOUBLE,	"double constant", L_CONSTANT,	OPconstant,	ML_NOTOKEN)
DAT(L_CLDOUBLE,	"long double constant",L_CONSTANT, OPconstant,	ML_NOTOKEN)
DAT(L_CINTEGER,	"int constant",	L_CONSTANT,	OPconstant,	ML_CONSTANT)
DAT(L_LONGINT,	"long constant", L_CONSTANT,	OPconstant,	ML_CONSTANT)
DAT(L_CUNSIGNED,"unsigned int constant",L_CONSTANT,OPconstant,	ML_CONSTANT)
DAT(L_LONGUNSIGNED,"unsigned long constant",L_CONSTANT,OPconstant,ML_CONSTANT)
DAT(L_AUTO,	"auto",		L_CLASS,	MAX_OPCODE,	ML_IDENT)
DAT(L_STATIC,	"static",	L_CLASS,	MAX_OPCODE,	ML_IDENT)
DAT(L_EXTERN,	"extern",	L_CLASS,	MAX_OPCODE,	ML_IDENT)
DAT(L_REGISTER,	"register",	L_CLASS,	MAX_OPCODE,	ML_IDENT)
DAT(L_TYPEDEF,	"typedef",	L_CLASS,	MAX_OPCODE,	ML_IDENT)
DAT(L_FORTRAN,	Fortran_str,	L_MODIFIER,	MAX_OPCODE,	ML_IDENT)
DAT(L_PASCAL,	Pascal_str,	L_MODIFIER,	MAX_OPCODE,	ML_IDENT)
DAT(L_C,	Cdecl_str,	L_MODIFIER,	MAX_OPCODE,	ML_IDENT)
DAT(L_INTERRUPT,"interrupt",	L_MODIFIER,	MAX_OPCODE,	ML_IDENT)
DAT(L_SAVEREGS,	"saveregs",	L_MODIFIER,	MAX_OPCODE,	ML_IDENT)
DAT(L_LOADDS,	"loadds",	L_MODIFIER,	MAX_OPCODE,	ML_IDENT)
DAT(L_EXPORT,	"export",	L_MODIFIER,	MAX_OPCODE,	ML_IDENT)
DAT(L_ASM,	"_asm",		L_ASM,		MAX_OPCODE,	ML_NL)
DAT(L_NEAR,	"near",		L_MODIFIER,	MAX_OPCODE,	ML_IDENT)
DAT(L_FAR,	"far",		L_MODIFIER,	MAX_OPCODE,	ML_IDENT)
DAT(L_HUGE,	"huge",		L_MODIFIER,	MAX_OPCODE,	ML_IDENT)
DAT(L_CONST,	"const",	L_MODIFIER,	MAX_OPCODE,	ML_CDATATYPE)
DAT(L_VOLATILE,	"volatile",	L_MODIFIER,	MAX_OPCODE,	ML_CDATATYPE)
DAT(L_CHAR,	"char",		L_TYPE,		MAX_OPCODE,	ML_CDATATYPE)
DAT(L_INT,	"int",		L_TYPE,		MAX_OPCODE,	ML_CDATATYPE)
DAT(L_FLOAT,	"float",	L_TYPE,		MAX_OPCODE,	ML_CDATATYPE)
DAT(L_DOUBLE,	"double",	L_TYPE,		MAX_OPCODE,	ML_CDATATYPE)
DAT(L_SHORT,	"short",	L_TYPE,		MAX_OPCODE,	ML_CDATATYPE)
DAT(L_LONG,	"long",		L_TYPE,		MAX_OPCODE,	ML_CDATATYPE)
DAT(L_VOID,	"void",		L_TYPE,		MAX_OPCODE,	ML_IDENT)
DAT(L_SIGNED,	"signed",	L_TYPE,		MAX_OPCODE,	ML_CDATATYPE)
DAT(L_UNSIGNED,	"unsigned",	L_TYPE,		MAX_OPCODE,	ML_CDATATYPE)
DAT(L_ENUM,	"enum",		L_ENUM,		MAX_OPCODE,	ML_IDENT)
DAT(L_ENUM_TAG,	"enum tag",	L_ENUM_TAG,	MAX_OPCODE,	ML_NOTOKEN)
DAT(L_STRUCT,	"struct",	L_STRUCT,	MAX_OPCODE,	ML_IDENT)
DAT(L_STRUCT_TAG,"struct tag",	L_STRUCT_TAG,	MAX_OPCODE,	ML_NOTOKEN)
DAT(L_UNION,	"union",	L_UNION,	MAX_OPCODE,	ML_IDENT)
DAT(L_UNION_TAG,"union tag",	L_UNION_TAG,	MAX_OPCODE,	ML_NOTOKEN)
DAT(L_AND,	"&",		L_AND,		OPband,		ML_AND)
DAT(L_ANDAND,	"&&",		L_ANDAND,	OPandif,	ML_NOTOKEN)
DAT(L_ANDEQ,	"&=",		L_ASOP,		OPandeq,	ML_NOTOKEN)
DAT(L_ASSIGN,	"=",		L_ASSIGN,	OPassign,	ML_NOTOKEN)
DAT(L_BIT,	"bit field",	L_BIT,		OPbit,		ML_NOTOKEN)
DAT(L_COLON,	":",		L_COLON, 	OPcolon,	ML_COLON)
DAT(L_COMMA,	",", 		L_COMMA,	OPcomma,	ML_COMMA)
DAT(L_DECR,	"--",		L_INCOP,	OPpostdecr,	ML_NOTOKEN)
DAT(L_DIV,	"/",		L_DIVOP,	OPdiv,		ML_DIV)
DAT(L_DIVEQ,	"/=",		L_ASOP,		OPdiveq,	ML_NOTOKEN)
DAT(L_EQUALS,	"==",		L_EQUOP,	OPeq,		ML_EQ)
DAT(L_EXCLAIM,	"!",		L_EXCLAIM,	OPnot,		ML_NOTOKEN)
DAT(L_EXTRACT,	"*",		L_EXTRACT,	OPextract,	ML_NOTOKEN)
DAT(L_GT,	">",		L_RELOP,	OPgt,		ML_GT)
DAT(L_GTEQ,	">=",		L_RELOP,	OPge,		ML_GE)
DAT(L_INCR,	"++",		L_INCOP,	OPpostincr,	ML_NOTOKEN)
DAT(L_LBRACK,	"[",		L_LBRACK,	OPindex,	ML_LBRACK)
DAT(L_LSHFTEQ,	"<<=",		L_ASOP,		OPlsheq,	ML_NOTOKEN)
DAT(L_LSHIFT,	"<<",		L_SHIFTOP,	OPlshift,	ML_SHL)
DAT(L_LT,	"<",		L_RELOP,	OPlt,		ML_LT)
DAT(L_LTEQ,	"<=",		L_RELOP,	OPle,		ML_LE)
DAT(L_MINUS,	"-",		L_MINUS,	OPminus,	ML_SUB)
DAT(L_MINUSEQ,	"-=",		L_ASOP,		OPminuseq,	ML_NOTOKEN)
DAT(L_MOD,	"%",		L_DIVOP,	OPrem,		ML_MOD)
DAT(L_MODEQ,	"%=",		L_ASOP,		OPremeq,	ML_NOTOKEN)
DAT(L_MULT,	"*",		L_MULT,		OPmult,		ML_MUL)
DAT(L_MULTEQ,	"*=",		L_ASOP,		OPmulteq,	ML_NOTOKEN)
DAT(L_NOTEQ,	"!=",		L_EQUOP,	OPne,		ML_NE)
DAT(L_OR,	"|",		L_OR,		OPbor,		ML_OR)
DAT(L_OREQ,	"|=",		L_ASOP,		OPoreq,		ML_NOTOKEN)
DAT(L_OROR,	"||",		L_OROR,		OPorelse,	ML_NOTOKEN)
DAT(L_PERIOD,	".",		L_STUNOP,	OPfield,	ML_PERIOD)
DAT(L_PLUS,	"+",		L_PLUS,		OPplus,		ML_ADD)
DAT(L_PLUSEQ,	"+=",		L_ASOP,		OPpluseq,	ML_NOTOKEN)
DAT(L_POINTSTO,	"->",		L_STUNOP,	OPfield,	ML_NOTOKEN)
DAT(L_PREDECR,	"--",		L_INCOP,	OPminuseq,	ML_NOTOKEN)
DAT(L_PREINCR,	"++",		L_INCOP,	OPpluseq,	ML_NOTOKEN)
DAT(L_QUEST,	"?",		L_QUEST,	OPquestion,	ML_NOTOKEN)
DAT(L_RSHFTEQ,	">>=",		L_ASOP,		OPrsheq,	ML_NOTOKEN)
DAT(L_RSHIFT,	">>",		L_SHIFTOP,	OPrshift,	ML_SHR)
DAT(L_TILDE,	"~",		L_TILDE,	OPcompl,	ML_NOT)
DAT(L_UMINUS,	"unary minus",	L_UMINUS,	OPneg,		ML_NOTOKEN)
DAT(L_XOR,	"^",		L_XOR,		OPxor,		ML_XOR)
DAT(L_XOREQ,	"^=",		L_ASOP,		OPxoreq,	ML_NOTOKEN)
DAT(L_ARG,	"argument",	L_ARG,		OPargument,	ML_NOTOKEN)
DAT(L_ASOP,	"assign op",	L_ASOP,		MAX_OPCODE,	ML_NOTOKEN)
DAT(L_BREAK,	"break",	L_BREAK,	MAX_OPCODE,	ML_IDENT)
DAT(L_CASE,	"case",		L_CASE,		OPcase,		ML_IDENT)
DAT(L_CAST,	"cast",		L_CAST,		OPcast,		ML_NOTOKEN)
DAT(L_CLASS,	"storage class",L_CLASS,	MAX_OPCODE,	ML_IDENT)
DAT(L_CONSTANT,	"constant",	L_CONSTANT,	MAX_OPCODE,	ML_MAPPED)
DAT(L_CONTINUE,	"continue",	L_CONTINUE,	MAX_OPCODE,	ML_IDENT)
DAT(L_DEFAULT,	"default",	L_DEFAULT,	MAX_OPCODE,	ML_IDENT)
DAT(L_DIVOP,	"div op",	L_DIVOP,	MAX_OPCODE,	ML_MAPPED)
DAT(L_DO,	"do",		L_DO,		MAX_OPCODE,	ML_IDENT)
DAT(L_ELLIPSIS,	"...",		L_ELLIPSIS,	MAX_OPCODE,	ML_NOTOKEN)
DAT(L_ELSE,	"else",		L_ELSE,		MAX_OPCODE,	ML_IDENT)
DAT(L_ENTRY,	"entry",	L_ENTRY,	OPentry,	ML_NOTOKEN)
DAT(L_EOF,	"end of file",	0,		MAX_OPCODE,	ML_EOF)
DAT(L_EQUOP,	"equ op",	L_EQUOP,	MAX_OPCODE,	ML_NOTOKEN)
DAT(L_FILE,	0,		L_FILE,		MAX_OPCODE,	ML_NOTOKEN)
DAT(L_FOR,	"for",		L_FOR,		MAX_OPCODE,	ML_IDENT)
DAT(L_FUNCTION,	"argument",	L_FUNCTION,	MAX_OPCODE,	ML_NOTOKEN)
DAT(L_GOTO,	"goto",		L_GOTO,		MAX_OPCODE,	ML_IDENT)
DAT(L_IF,	"if",		L_IF,		MAX_OPCODE,	ML_IDENT)
DAT(L_INCOP,	"incr op",	L_INCOP,	MAX_OPCODE,	ML_NOTOKEN)
DAT(L_INIT,	"initializing",	L_INIT,		MAX_OPCODE,	ML_NOTOKEN)
DAT(L_LCURLY,	"{",		L_LCURLY,	MAX_OPCODE,	ML_LCURLY)
DAT(L_LINE,	"line",		L_LINE,		MAX_OPCODE,	ML_NOTOKEN)
DAT(L_LPAREN,	"(",		L_LPAREN,	OPfunction,	ML_LPAREN)
DAT(L_INTRINSIC,"intrinsic",	L_INTRINSIC,	OPintrinsic,	ML_NOTOKEN)
DAT(L_MODIFIER,	"modifier",	L_MODIFIER,	MAX_OPCODE,	ML_MAPPED)
DAT(L_MODULE,	"module",	L_MODULE,	MAX_OPCODE,	ML_NOTOKEN)
DAT(L_RBRACK,	"]",		L_RBRACK,	MAX_OPCODE,	ML_RBRACK)
DAT(L_RCURLY,	"}",		L_RCURLY,	MAX_OPCODE,	ML_NL)
DAT(L_RELOP,	"rel op",	L_RELOP,	MAX_OPCODE,	ML_MAPPED)
DAT(L_RETURN,	"return",	L_RETURN,	MAX_OPCODE,	ML_IDENT)
DAT(L_RPAREN,	")",		L_RPAREN,	MAX_OPCODE,	ML_RPAREN)
DAT(L_SELF,	"_self",	L_SELF,		OPself,		ML_IDENT)
DAT(L_SEMI,	";",		L_SEMI,		MAX_OPCODE,	ML_SEMI)
DAT(L_SHIFTOP,	"shift op",	L_SHIFTOP,	MAX_OPCODE,	ML_MAPPED)
DAT(L_SIZEOF,	"sizeof",	L_SIZEOF,	MAX_OPCODE,	ML_IDENT)
DAT(L_STUNOP,	"struct op",	L_STUNOP,	MAX_OPCODE,	ML_MAPPED)
DAT(L_SW,	"switch",	L_SW,		OPswitch,	ML_IDENT)
DAT(L_SWEXP,	0,		L_SWEXP,	OPswexp,	ML_NOTOKEN)
DAT(L_TYPE,	"type",		L_TYPE,		MAX_OPCODE,	ML_MAPPED)
DAT(L_TYPENAME,	"typedef name",	L_TYPENAME,	MAX_OPCODE,	ML_CTYPENAME)
DAT(L_UPLUS,	"unary plus", 	L_UPLUS,	OPparen,	ML_NOTOKEN)
DAT(L_WHILE,	"while",	L_WHILE,	MAX_OPCODE,	ML_IDENT)
DAT(0,	0,		0,	MAX_OPCODE,	ML_NOTOKEN)
