/*++ BUILD Version: 0001    // Increment this if a change has global effects

Copyright (c) 1992  Microsoft Corporation

Module Name:

    datatcp.c

Abstract:

    The file containing the constant data structures
    for the Performance Monitor data for the TCP/IP 
    Extensible Objects (Network Interface, IP, ICMP, TCP
    and UDP).

    This file contains a set of constant data structures which are
    currently defined for the TCP/IP Extensible Objects.  This is an 
    example of how other such objects could be defined.

Created:

    Christos Tsollis  08/28/92 

Revision History:

--*/
//
//
//  Include Files
//

#include <nt.h>
#include <ntrtl.h>
#include <nturtl.h>
#include <windows.h>
#include <winperf.h>
#include "datatcp.h"

//
//  Constant structure initializations
//


NET_INTERFACE_DATA_DEFINITION NetInterfaceDataDefinition = {

    {   sizeof(NET_INTERFACE_DATA_DEFINITION) + SIZE_OF_IF_DATA,
        sizeof(NET_INTERFACE_DATA_DEFINITION),
        sizeof(PERF_OBJECT_TYPE),
        510,
        0,
        511,
        0,
        PERF_DETAIL_ADVANCED,
        (sizeof(NET_INTERFACE_DATA_DEFINITION)-sizeof(PERF_OBJECT_TYPE))/
        sizeof(PERF_COUNTER_DEFINITION),
        0,     // default is Byte Total/sec  
        0,
        0
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        388,
        0,
        513,
        0,
        -4,
        PERF_DETAIL_ADVANCED, 
        PERF_COUNTER_COUNTER, 
        sizeof(DWORD),
        IF_OCTETS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        400,
        0,
        515,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        IF_PACKETS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        266,
        0,
        517,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        IF_INPKTS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        452,
        0,
        519,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        IF_OUTPKTS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        520,
        0,
        521,
        0,
        -6,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        IF_SPEED_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        264,
        0,
        523,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        IF_INOCTETS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        524,
        0,
        525,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        IF_INUCASTPKTS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        526,
        0,
        527,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        IF_INNUCASTPKTS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        528,
        0,
        529,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        IF_INDISCARDS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        530,
        0,
        531,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        IF_INERRORS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        532,
        0,
        533,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        IF_INUNKNOWNPROTOS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        506,
        0,
        535,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        IF_OUTOCTETS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        536,
        0,
        537,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        IF_OUTUCASTPKTS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        538,
        0,
        539,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        IF_OUTNUCASTPKTS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        540,
        0,
        541,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        IF_OUTDISCARDS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        542,
        0,
        543,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        IF_OUTERRORS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        544,
        0,
        545,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        IF_OUTQLEN_OFFSET
    }
};




IP_DATA_DEFINITION IpDataDefinition = {

    {   sizeof(IP_DATA_DEFINITION) + SIZE_OF_IP_DATA,
        sizeof(IP_DATA_DEFINITION),
        sizeof(PERF_OBJECT_TYPE),
        546,
        0,
        547,
        0,
        PERF_DETAIL_ADVANCED,
        (sizeof(IP_DATA_DEFINITION)-sizeof(PERF_OBJECT_TYPE))/
        sizeof(PERF_COUNTER_DEFINITION),
        0,
        -1,
        0
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        438,
        0,
        549,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        IP_DATAGRAMS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        446,
        0,
        551,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        IP_INRECEIVES_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        552,
        0,
        553,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        IP_INHDRERRORS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        554,
        0,
        555,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        IP_INADDRERRORS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        556,
        0,
        557,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        IP_FORWDATAGRAMS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        558,
        0,
        559,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        IP_INUNKNOWNPROTOS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        560,
        0,
        561,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        IP_INDISCARDS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        562,
        0,
        563,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        IP_INDELIVERS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        442,
        0,
        565,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        IP_OUTREQUESTS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        566,
        0,
        567,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        IP_OUTDISCARDS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        568,
        0,
        569,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        IP_OUTNOROUTES_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        570,
        0,
        571,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        IP_REASMREQDS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        572,
        0,
        573,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        IP_REASMOKS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        574,
        0,
        575,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        IP_REASMFAILS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        576,
        0,
        577,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        IP_FRAGOKS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        578,
        0,
        579,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        IP_FRAGFAILS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        580,
        0,
        581,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        IP_FRAGCREATES_OFFSET
    }
};



ICMP_DATA_DEFINITION IcmpDataDefinition = {

    {   sizeof(ICMP_DATA_DEFINITION) + SIZE_OF_ICMP_DATA,
        sizeof(ICMP_DATA_DEFINITION),
        sizeof(PERF_OBJECT_TYPE),
        582,
        0,
        583,
        0,
        PERF_DETAIL_ADVANCED,
        (sizeof(ICMP_DATA_DEFINITION)-sizeof(PERF_OBJECT_TYPE))/
        sizeof(PERF_COUNTER_DEFINITION),
        0,
        -1,
        0
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        584,
        0,
        585,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        ICMP_MESSAGES_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        586,
        0,
        587,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        ICMP_INMSGS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        588,
        0,
        589,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        ICMP_INERRORS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        590,
        0,
        591,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        ICMP_INDESTUNREACHS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        592,
        0,
        593,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        ICMP_INTIMEEXCDS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        594,
        0,
        595,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        ICMP_INPARMPROBS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        596,
        0,
        597,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        ICMP_INSRCQUENCHS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        598,
        0,
        599,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        ICMP_INREDIRECTS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        600,
        0,
        601,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        ICMP_INECHOS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        602,
        0,
        603,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        ICMP_INECHOREPS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        604,
        0,
        605,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        ICMP_INTIMESTAMPS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        606,
        0,
        607,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        ICMP_INTIMESTAMPREPS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        608,
        0,
        609,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        ICMP_INADDRMASKS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        610,
        0,
        611,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        ICMP_INADDRMASKREPS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        612,
        0,
        613,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        ICMP_OUTMSGS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        614,
        0,
        615,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        ICMP_OUTERRORS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        616,
        0,
        617,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        ICMP_OUTDESTUNREACHS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        618,
        0,
        619,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        ICMP_OUTTIMEEXCDS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        620,
        0,
        621,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        ICMP_OUTPARMPROBS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        622,
        0,
        623,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        ICMP_OUTSRCQUENCHS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        624,
        0,
        625,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        ICMP_OUTREDIRECTS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        626,
        0,
        627,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        ICMP_OUTECHOS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        628,
        0,
        629,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        ICMP_OUTECHOREPS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        630,
        0,
        631,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        ICMP_OUTTIMESTAMPS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        632,
        0,
        633,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        ICMP_OUTTIMESTAMPREPS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        634,
        0,
        635,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        ICMP_OUTADDRMASKS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        636,
        0,
        637,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        ICMP_OUTADDRMASKREPS_OFFSET
    }
};



TCP_DATA_DEFINITION TcpDataDefinition = {

    {   sizeof(TCP_DATA_DEFINITION) + SIZE_OF_TCP_DATA,
        sizeof(TCP_DATA_DEFINITION),
        sizeof(PERF_OBJECT_TYPE),
        638,
        0,
        639,
        0,
        PERF_DETAIL_ADVANCED,
        (sizeof(TCP_DATA_DEFINITION)-sizeof(PERF_OBJECT_TYPE))/
        sizeof(PERF_COUNTER_DEFINITION),
        0,
        -1,
        0
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        640,
        0,
        641,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        TCP_SEGMENTS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        642,
        0,
        643,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        TCP_CURRESTAB_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        644,
        0,
        645,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        TCP_ACTIVEOPENS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        646,
        0,
        647,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        TCP_PASSIVEOPENS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        648,
        0,
        649,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        TCP_ATTEMPTFAILS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        650,
        0,
        651,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        TCP_ESTABRESETS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        652,
        0,
        653,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        TCP_INSEGS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        654,
        0,
        655,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        TCP_OUTSEGS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        656,
        0,
        657,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        TCP_RETRANSSEGS_OFFSET
    }
};




UDP_DATA_DEFINITION UdpDataDefinition = {

    {   sizeof(UDP_DATA_DEFINITION) + SIZE_OF_UDP_DATA,
        sizeof(UDP_DATA_DEFINITION),
        sizeof(PERF_OBJECT_TYPE),
        658,
        0,
        659,
        0,
        PERF_DETAIL_ADVANCED,
        (sizeof(UDP_DATA_DEFINITION)-sizeof(PERF_OBJECT_TYPE))/
        sizeof(PERF_COUNTER_DEFINITION),
        0,
        -1,
        0
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        438,
        0,
        661,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        UDP_DATAGRAMS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        446,
        0,
        663,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        UDP_INDATAGRAMS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        664,
        0,
        665,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        UDP_NOPORTS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        666,
        0,
        667,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        UDP_INERRORS_OFFSET
    },
    {        sizeof(PERF_COUNTER_DEFINITION),
        442,
        0,
        669,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        UDP_OUTDATAGRAMS_OFFSET
    }
};



