/***
*cltypes.hxx - Class Lib component-wide header file.
*
*  Copyright (C) 1991, Microsoft Corporation.  All Rights Reserved.
*  Information Contained Herein Is Proprietary and Confidential.
*
*Purpose:
*  Component-wide stuff.  See \silver\doc\client\tmembers.doc for
*   more info on these definitions.
*
*  This file defines the following:
*     enum    TYPEKIND
*     enum    PERSISTENCEKIND
*     typedef HMEMBER
*     typedef HIMPTYPE
*     enum    ACCESS
*     enum    VAR_KIND
*     enum    DECLKIND
*     enum    TYPEDESCKIND
*     enum    PTRKIND
*     enum    FUNC_KIND
*     enum    CALLINGCONVENTION
*     enum    PARAMKIND
*     enum    SPECIALKIND
*     enum    INFOKIND
*     enum    VARDESCKIND
*     enum    DEFNKIND
*     struct  VAROFS
*     struct  VMETHOFS
*     struct  VBASEPOS
*     struct  VARPOS
*     struct  VMETHPOS
*     struct  EDITKIND
*
*
*Revision History:
*	25-Feb-91 ilanc:    Created
*  [01] 25-Feb-91 petergo:  Added HIMPTYPE
*  [02] 27-Feb-91 ilanc:    Added DECLKIND
*  [03] 28-Feb-91 ilanc:    Moved to ..\cl
*  [04] 07-Mar-91 petergo:  Add HLNAM_Nil
*  [05] 10-Mar-91 ilanc:    Added VKIND_Formal, VKIND_Local, ACCESS_Ignore
*  [06] 21-May-91 ilanc:    Added PARAMKIND enum
*  [07] 06-Jun-91 ilanc:    Windowsian typedefs...
*  [08] 31-Oct-91 ilanc:    Added TKIND_Alias
*  [09] 15-Nov-91 ilanc:    Added SPECIALKIND enum.
*  [10] 02-Mar-91 petergo:  Added HGNAM_Nil.
*  [11] 16-Mar-92 ilanc:    Added EDITKIND
*  [12] 02-Apr-92 ilanc:    Added VARDESCKIND.
*  [13] 20-Apr-92 stevenl:  Added DEFNKIND.
*  [14] 03-Jun-92 w-peterh: Added HMEMBER Accessor functions
*  [15] 16-Jun-92 w-peterh: Added DEFNKIND DK_RecTypeDefn
*  [16] 02-Jul-92 w-peterh: Added INFOKIND INFOKIND_NestedType
*  [17] 30-Jul-92 w-peterh: Added IsMatchOfVisibility()
*  [18] 18-Aug-92 w-peterh: Added IMPADDR(from impmgr.hxx)
*  [19] 22-Oct-92 w-peterh: Added HRESDESCTBL
*  [20] 14-Nov-92 ilanc:    Added INVOKEKIND
*  [21] 21-Nov-92 Rajiv:    Updated Edit Kind.
*  [22] 25-Nov-92 ilanc:    Made HMEMBER/sHMEMBER 32 bits.
*  [23] 14-Dec-92 w-peterh: Moved INVOKEKIND to clhost.h
*  [24] 12-Feb-93 w-peterh: added VDK_Base*, PARAMKIND_Ignore
*  [25] 30-Apr-93 w-jeffc:  added sACCESS, sDEFNKIND and layout strings
*                           for virtual function structures
*
*Implementation Notes:
*   Note: we assume (for now) large-model compilation on 16-bit.
*         I.e. all pointers are far.  If and when we distribute
*         header files we probably need to make sure that pointer
*         types are explicitly far.
*
*****************************************************************************/

#ifndef CLTYPES_HXX_INCLUDED
#define CLTYPES_HXX_INCLUDED

// enum TYPEDESCKIND - tdesckind
//
// 	defined in tdesck.hxx
//
// WARNING:
//  There is an array in dumptlib.cxx that is indexed by this enum.

#include "silver.hxx"
#include "tdesck.hxx"
#include <limits.h>

#if ID_DEBUG
#undef SZ_FILE_NAME
ASSERTNAME(g_szCLTYPES_HXX)
#define SZ_FILE_NAME g_szCLTYPES_HXX
#endif  


typedef CALLCONV CALLINGCONVENTION;

// Error codes generated by methods of the CLASSLIB protocols are
// of type TIPERROR.  The error code are defined in cliberrs.hxx.
// NOTE: tiperrs.hxx is defined in types.h
// typedef USHORT TIPERROR;

class TYPEMGR;
typedef TYPEMGR *LPTYPEMGR;
typedef LPTYPEMGR *LPLPTYPEMGR;

typedef ITypeLibA *LPITypeLib;
typedef LPITypeLib *LPLPITypeLib;

class TYPEINFO;
typedef TYPEINFO* LPTYPE_INFO;
typedef LPTYPE_INFO* LPLPTYPEINFO;

class DYN_TYPEMEMBERS;
typedef DYN_TYPEMEMBERS* LPDYNTYPEMEMBERS;
typedef LPDYNTYPEMEMBERS* LPLPDYNTYPEMEMBERS;

class TYPEFIXUPS;
typedef TYPEFIXUPS* LPTYPEFIXUPS;
typedef LPTYPEFIXUPS* LPLPTYPEFIXUPS;

class DEFN_TYPEBIND;
typedef DEFN_TYPEBIND* LPDEFNTBIND;
typedef LPDEFNTBIND* LPLPDEFNTBIND;

typedef LPOLESTR TYPEID;
typedef TYPEID* LPTYPEID;
typedef LPTYPEID* LPLPTYPEID;


// PERSISTENCEKIND enum - pkind
//
// WARNING:
//  There is an array in dumptlib.cxx that is indexed by this enum.
enum PERSISTENCEKIND
{
    PKIND_None,
    PKIND_Serializable,
    PKIND_Persistent
};


// HMEMBER - hmember: entry import handle
// HIMPTYPE - himptype: type imp
// HLNAM - hlnam: local name handle
// HGNAM - hgnam: global name handle
typedef ULONG	  HMEMBER;	// 25-Nov-92: now 32bit
typedef HMEMBER  sHMEMBER;
typedef UINT	 HIMPTYPE;
typedef USHORT  sHIMPTYPE;
typedef UINT     HIMPADDR;
typedef USHORT  sHIMPADDR;
typedef HCHUNK	 HLNAM;
typedef sHCHUNK sHLNAM;
typedef HCHUNK	 HNAMSTR;
typedef sHCHUNK sHNAMSTR;
typedef ULONG	 HGNAM;
typedef ULONG	sHGNAM;
typedef LPVOID	 IMPADDR;


// Constants that go with these types
const HLNAM HLNAM_Nil = HCHUNK_Nil;
const HGNAM HGNAM_Nil = 0x00000000;
const HIMPTYPE HIMPTYPE_Nil = 0xFFFF;
const HIMPADDR HIMPADDR_Nil = 0xFFFF;

/* HMEMBERs The Full story (part II):
*
*   HMEMBERs are handles to a modules data or function members and
*   are unique (except property fn.)  within a TypeInfo's scope.
*
*   HMEMBERs have the following form:
*
*     01<user bits:4><unused:4><nesting level:6><offset:16>
*
*   Where the user bits can have any value, the unused bits are always
*   zero (reserved for future use) and the nesting level is equal to
*   the number of inhertence levels below the current TypeInfo.
*
****************************************************************************/

const HMEMBER HMEMBER_Nil = (HMEMBER)DISPID_UNKNOWN;

#define HMEMBER_ReservedBits (0x80000000)    // Reserved
#define HMEMBER_StdOleId (0x40000000)	     // Standard OLE Hmember

#define HMEMBER_UserBits (0x3C000000)
#define HMEMBER_BrkModeBit  (0x04000000)
#define HMEMBER_UserBitsShift 26

#define HMEMBER_Unused (0x03C00000)
#define HMEMBER_UnusedShift 22

#define HMEMBER_NestDepth (0x003F0000)
#define HMEMBER_NestDepthShift 16
#define HMEMBER_NestDepthSize 6

#define HMEMBER_Offset (0x0000FFFF)

// Hmember helpers.

inline UINT UserBits(HMEMBER hmember)
{
    return (UINT)((hmember & HMEMBER_UserBits) >> HMEMBER_UserBitsShift);
}

inline UINT NestDepth(HMEMBER hmember)
{
    return (UINT)((hmember & HMEMBER_NestDepth) >> HMEMBER_NestDepthShift);
}

inline UINT Offset(HMEMBER hmember)
{
    return (UINT)(hmember & HMEMBER_Offset);
}

inline BOOL IsStdOleHmember(HMEMBER hmember)
{
    return !(hmember & HMEMBER_ReservedBits)
	   && (hmember & HMEMBER_StdOleId);
}

inline HMEMBER SetUserBits(UINT bits)
{
    DebAssert(!(((LONG)bits << HMEMBER_UserBitsShift) & ~HMEMBER_UserBits),
	      "Invalid field.");

    return (LONG)bits << HMEMBER_UserBitsShift;
}

inline HMEMBER SetNestDepth(UINT bits)
{
    DebAssert(!(((LONG)bits << HMEMBER_NestDepthShift) & ~HMEMBER_NestDepth),
	      "Invalid field.");

    return (LONG)bits << HMEMBER_NestDepthShift;
}


/*  OLE HMEMBERS -- the full story (part II)
*
*   The hmember is set as above with the first set of user bits is
*   formatted as follows:
*
*     <is FuncDesc>0000
*
*   The offset is the index of the Desc.
*
****************************************************************************/

#define HMEMBER_Func (0x8)	 // offset is for FuncDesc

const UINT HMEMBER_PredeclId   = (UINT)ID_DEFAULTINST;

inline BOOL AddedInBrkMode(HMEMBER hmember)
{
    DebAssert(hmember != HMEMBER_Nil, "Bad hmember");

    return (BOOL) ((hmember & HMEMBER_BrkModeBit) == 0);
}



inline BOOL IsFunction(HMEMBER hmember)
{
    DebAssert(hmember != HMEMBER_Nil, "Bad hmember");

    return (BOOL) UserBits(hmember) & HMEMBER_Func;
}

inline HMEMBER FunctionHmemberOfOffset(UINT offset, UINT nestDepth)
{
    return HMEMBER_StdOleId
	   | SetUserBits(HMEMBER_Func)
	   | SetNestDepth(nestDepth)
	   | (HMEMBER)(offset);
}

inline HMEMBER DataHmemberOfOffset(UINT offset, UINT nestDepth)
{
    return HMEMBER_StdOleId
	   | SetNestDepth(nestDepth)
	   | (HMEMBER)(offset);
}


// enum ACCESS - access
//
// WARNING:
//  There is an array in dumptlib.cxx that is indexed by this enum.
enum ACCESS
{
    ACCESS_Private,
    ACCESS_Public
};

typedef USHORT sACCESS;


/***
*PROTECTED IsMatchOfVisibility - Filter on visibility.
*Purpose:
*   Filter on visibility.
*
*Implementation Notes:
*   // *** WRITE SOME MORE HERE ****
*Entry:
*
*Exit:
*   None.
*
*Errors:
*   BOOL
*
***********************************************************************/

inline BOOL IsMatchOfVisibility(ACCESS accessMbr, ACCESS accessClient)
{
    return (accessMbr >= accessClient);
}


// enum VAR_KIND - vkind
//
// WARNING:
//  There is an array in dumptlib.cxx that is indexed by this enum.
enum VAR_KIND
{
     VKIND_DataMember
    ,VKIND_Base
    ,VKIND_Enumerator
    ,VKIND_Formal
};


// enum DECLKIND - declkind
//
enum DECLKIND
{
    DECLKIND_Implicit,
    DECLKIND_Typechar,
    DECLKIND_Explicit
};



// enum PTRKIND - ptrkind
//
// WARNING:
//  There is an array in dumptlib.cxx that is indexed by this enum.
enum PTRKIND
{
    PTRKIND_Ignore,
    PTRKIND_Near,
    PTRKIND_Far,
    PTRKIND_Near32,
    PTRKIND_Far32,
    PTRKIND_Based,
    PTRKIND_Huge,
    PTRKIND_Basic,
};


// enum FUNC_KIND - fkind
//
enum FUNC_KIND
{
    FKIND_NonVirtual,
    FKIND_Virtual,
    FKIND_Static,
    FKIND_Dispatch
};


// enum PARAMKIND - paramkind
//
enum PARAMKIND
{
    PARAMKIND_In,
    PARAMKIND_Out,
    PARAMKIND_InOut,
    PARAMKIND_Ignore
};


// enum SPECIALKIND - specialkind
// Purpose:
//  Enumerates different kinds of special functions.
//
enum SPECIALKIND
{
    SPECIALKIND_Normal,
    SPECIALKIND_Ctor,
    SPECIALKIND_Dtor
};


// enum INFOKIND - infokind
// Purpose:
//  Enumerates different kinds of INFOs.
//
enum INFOKIND
{
    INFOKIND_Var,
    INFOKIND_Func,
    INFOKIND_Param,
    INFOKIND_NestedType
};


// enum VARDESCKIND - vdesckind
// Purpose:
//  Enumerates different kinds Basic variables.
//
enum VARDESCKIND
{
    VDK_Unknown,
    VDK_LocalIntrinsic,
    VDK_LocalRecord,
    VDK_LocalObject,
    VDK_ByvalIntrinsic,
    VDK_ByvalRecord,
    VDK_ByvalObject,		    // illegal
    VDK_ByrefIntrinsic,
    VDK_ByrefRecord,
    VDK_ByrefObject,
    VDK_ByptrIntrinsic, 	   // illegal
    VDK_ByptrRecord,		   // illegal
    VDK_ByptrObject,
    VDK_DataMemberIntrinsic,
    VDK_DataMemberRecord,
    VDK_DataMemberObject,
    VDK_BaseIntrinsic,		   // Illegal
    VDK_BaseRecord,		   // Illegal
    VDK_BaseObject
};


// enum DEFNKIND - dk
// Purpose:
//  Enumerates different kinds of defns.
//  Includes some defns that don't derive
//  from DEFN, like DLLENTRY_DEFN.
//  Specifically excludes MEMBER_DEFN, since
//  it only exists to be included in MBR_VAR_DEFN, etc.
//
enum DEFNKIND
{
    DK_VarDefn,
    DK_ParamDefn,
    DK_MbrVarDefn,
    DK_FuncDefn,
    DK_VirtualFuncDefn,
    DK_DllEntryDefn,
    DK_RecTypeDefn
};

typedef USHORT  sDEFNKIND;


// enum BASICVARKIND - basicvkind
// Purpose:
//  enumerates different "classes" of basic Variable kinds
//
enum BASICVARKIND
{
    BVKIND_Intrinsic,
    BVKIND_Record,
    BVKIND_Object
};


// enum COMPSTATE
// enumeration specifying the various possible compilation states
//
enum COMPSTATE {
    CS_UNDECLARED,
    CS_SEMIDECLARED,
    CS_DECLARED,
    CS_REGENERATE,
    CS_COMPILED,
    CS_ADDRESSABLE,
    CS_QUASIDECLARED,
    CS_QUASIUNDECLARED,
    CS_RUNNABLE
};


#pragma pack(2)			// want all these guys to word-align

// struct VAROFS - vo
// Purpose:
//  Structure for describing the offset within an instance to
//   a data member, non-virtual base member or virtual function
//   table pointer.
//
// *** if you modify this structure, also update the layout string below
//     (see SwapStruct() for more info)
//
// CONSIDER: vba2
//   struct VAROFS
//   {
//       LONG oVar;
//       inline VAROFS() { oVar = -1; }
//   };
//
//   // layout string for TYPE_DATA byte swapping
//   #define VAROFS_LAYOUT       "l"


// struct VMETHOFS - vmo
// Purpose:
//  Extends VAROFS to describe the offset w/in the vft indicated
//   by VAROFS::oVar of the slot of a virtual function.
//
// *** if you modify this structure, also update the layout string below
//     (see SwapStruct() for more info)
//
// CONSIDER: vba2
//   struct VMETHOFS: public VAROFS
struct VMETHOFS
{
    SHORT ovft;
    inline VMETHOFS() { ovft = -1; }
};

// layout string for TYPE_DATA byte swapping
// CONSIDER: vba2
//   #define VMETHOFS_LAYOUT     VAROFS_LAYOUT "s"
#define VMETHOFS_LAYOUT "s"

// struct VBASEPOS - vbp
// Purpose:
//  Structure for describing the position of a virtual base member.
//   This entails determining (1) where the appropriate vbt is and
//   (2) what the offset with that table is (that offset itself
//   contains the offset from THIS where the virtual base may be
//   found.
//
// *** if you modify this structure, also update the layout string below
//     (see SwapStruct() for more info)
//     
// CONSIDER: vba2
//   struct VBASEPOS
//   {
//       LONG oPvbt;
//       LONG oFixup;
//       SHORT ovbt;
//       inline VBASEPOS() { oPvbt = -1; ovbt = -1; oFixup = -1; }
//   };
//   
//   // layout string for TYPE_DATA byte swapping
//   #define VBASEPOS_LAYOUT     "lls"


// struct VARPOS - vp
// Purpose:
//  Combines VBASEPOS and VAROFS to describe the position of
//   a data member, non-virtual base member or Pvft.
//   
// CONSIDER: vba2
//   struct VARPOS : public VBASEPOS, public VAROFS
//   {
//       // NOTE: no introduced members.
//   };


// struct VMETHPOS - vmp
// Purpose:
//  Combines VMETHOFS and VBASEPOS to describe a
//   virtual method slot.  Used to describe overridden methods in
//   base classes to subclassing clients.  The VBASEPOS part
//   describes how to access a virtual base member that is or
//   contains the introducing class of the method.  The VMETHOFS
//   part completes the description with the accessor to the
//   virtual method slot itself.  For instance, the VAROFS part
//   might indicate how to access the pvft in the embedded
//   introducing class given a virtual base member.
//
// *** if you modify this structure, also update the layout string below
//     (see SwapStruct() for more info)
//   
// CONSIDER: vba2
//   struct VMETHPOS : public VMETHOFS, public VBASEPOS
struct VMETHPOS : public VMETHOFS
{
    // NOTE: no introduced members
};

// layout string for TYPE_DATA byte swapping
// CONSIDER: vba2
//   #define VMETHPOS_LAYOUT     VMETHOFS_LAYOUT VBASEPOS_LAYOUT
#define VMETHPOS_LAYOUT    VMETHOFS_LAYOUT                                                             
                                                             
#pragma pack()			// reset to default

// struct VBASECPOS - vbcp
// Purpose:
//  Structure for "canonically" describing the position of a
//   virtual base member.
//  A "canonic" description is simply encoded as the TYPEID to
//   the TYPEINFO of the virtual base class.
//
// CONSIDER: vba2
//   struct VBASECPOS
//   {
//       LPSTR szTypeIdVbase;
//       inline VBASECPOS() { szTypeIdVbase = NULL; }
//   };


// struct VARCPOS - vcp
// Purpose:
//  Combines VBASECPOS and VAROFS to describe the "canonical" position of
//   a data member, non-virtual base member or Pvft.
//  Canonical since it is possibly in terms of the TYPEID to
//   the virtual base "owner" of the table.
//
// CONSIDER: vba2
//   struct VARCPOS : public VBASECPOS, public VAROFS
//   {
//       // NOTE: no introduced members.
//   };


// struct VMETHCPOS - vmcp
// Purpose:
//  Combines VMETHOFS and VBASECPOS to describe a "canonic"
//   virtual method slot.  Used to describe overridden methods in
//   base classes to subclassing clients.  If virtual method is
//   defined by a virtual base then VBASECPOS::szTypeIdVbase
//   attribute is the TYPEID ot the TYPEINFO of that base.
//   Otherwise (i.e. not defined by a virtual base) this is NULL.
//
// CONSIDER: vba2
//   struct VMETHCPOS : public VMETHOFS, public VBASECPOS
//   {
//       // NOTE: no introduced members
//   };

//   struct VMETHCPOSLIST;
//   typedef VMETHCPOSLIST* LPVMETHCPOSLIST;
//   typedef LPVMETHCPOSLIST* LPLPVMETHCPOSLIST;

// These are stub declarations...
//
struct VBTDEFN;
typedef VBTDEFN* LPVBTDEFN;
typedef LPVBTDEFN* LPLPVBTDEFN;

struct VBTDEFNLIST;
typedef VBTDEFNLIST* LPVBTDEFNLIST;
typedef LPVBTDEFNLIST* LPLPVBTDEFNLIST;

struct VBASEDEFN;
typedef VBASEDEFN* LPVBASEDEFN;
typedef LPVBASEDEFN* LPLPVBASEDEFN;

struct VBASEDEFNLIST;
typedef VBASEDEFNLIST* LPVBASEDEFNLIST;
typedef LPVBASEDEFNLIST* LPLPVBASEDEFNLIST;


#if OE_MACPPC
/***
*struct DLLTEMPLATECALLBLOCK
*Purpose:
* Structure that holds Mac/PPC Dll Template Calling information.
* This structure is used by entrymgr.cxx and instmgr.cxx when
* resolving Dll entry points.
*
* [Note: The structure itself resides inside the Declare template and,
* thus, this MUST match asm description in template.s.]
*
***********************************************************************/

struct DLLTEMPLATECALLBLOCK {
    void * pvTargetAddr;            // target address for Dll template
    void * pv68KAddr;               // target 68k address (if applicable)
    ProcInfoType theProcInfo;       // Apple OS ProcInfoType value
    UniversalProcPtr theProcPtr;    // Apple OS Universal Proc Ptr
    unsigned short usTargetRefnum;  // target refnum
    unsigned short usSavedRefnum;   // saved refnum
};
#endif    // OE_MACPPC


#endif   // ! CLTYPES_HXX_INCLUDED
