/*
 *
 *			Copyright (C) 1993 by
 *		DIGITAL EQUIPMENT CORPORATION, Maynard, MA.
 *
 *  This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the inclusion
 * of the above copyright notice.  This software or any other copies there-
 * of may not be provided or otherwise made available to any other person.
 * No title to and ownership of the software is hereby transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by DIGITAL EQUIPMENT COR-
 * PORATION.
 *
 * DIGITAL assumes no responsibility for the use or reliability of its
 * software on equipment which is not supplied by DIGITAL.
 *
 *******************************************************************************
 *
 * Module:	table.c
 *
 * Abstract:	Contain various tables required by TGA NT user-mode
 *		display driver.
 *
 * HISTORY
 *
 * 01-Nov-1993	Bob Seitsinger
 *	Original version.
 *
 *  2-Mar-1994  Barry Tannenbaum
 *      Added reverse_byte
 *
 * 16-May-1994	Bob Seitsinger
 *	Modify rop conversion table to convert '0x0A' rop 
 *	into TGA_ROP_AND TGA rop.
 *
 * 31-May-1994	Bob Seitsinger
 *	Delete ulTGARop table. Superceded by ulAccelRops, found
 *	in bitblt.c.
 *
 * 24-Aug-1994  Barry Tannenbaum
 *      Added mix_to_rop
 *
 * 25-Aug-1994  Bob Seitsinger
 *      - Add rop_to_mix - even though not currently using.
 *      - Delete #ifdef around *32*mask arrays.
 */

#include "windef.h"
#include "tgaparam.h"

long mix_to_rop[16] =       // Table to convert a ROP2 to a TGA ROP
{
    TGA_ROP_SET,            // 16 - R2_WHITE
    TGA_ROP_CLEAR,          //  1 - R2_BLACK
    TGA_ROP_NOR,            //  2 - R2_NOTMERGEPEN
    TGA_ROP_AND_INVERTED,   //  3 - R2_MASKNOTPEN
    TGA_ROP_COPY_INVERTED,  //  4 - R2_NOTCOPYPEN
    TGA_ROP_AND_REVERSE,    //  5 - R2_MASKPENNOT
    TGA_ROP_INVERT,         //  6 - R2_NOT
    TGA_ROP_XOR,            //  7 - R2_XORPEN
    TGA_ROP_NAND,           //  8 - R2_NOTMASKPEN
    TGA_ROP_AND,            //  9 - R2_MASKPEN
    TGA_ROP_EQUIV,          // 10 - R2_NOTXORPEN
    TGA_ROP_NOP,            // 11 - R2_NOP
    TGA_ROP_OR_INVERTED,    // 12 - R2_MERGENOTPEN
    TGA_ROP_COPY,           // 13 - R2_COPYPEN
    TGA_ROP_OR_REVERSE,     // 14 - R2_MERGEPENNOT
    TGA_ROP_OR              // 15 - R2_MERGEPEN
};

#if 0
// Even though we're not using this table, keep it in the
// source file in the event we ever need to convert mix
// to rops. The translation 'grunt' work would already
// have been done.

ULONG rop_to_mix[256] =
{
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x03
  0x00000000, 0x00000202, 0x00000000, 0x00000000, // 0x07
  0x00000000, 0x00000000, 0x00000303, 0x00000000, // 0x0b
  0x00000000, 0x00000000, 0x00000000, 0x00000404, // 0x0f

  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x13
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x17
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x1b
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x1f

  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x23
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x27
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x2b
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x2f

  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x33
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x37
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x3b
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x3f

  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x43
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x47
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x4b
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x4f

  0x00000505, 0x00000000, 0x00000000, 0x00000000, // 0x53
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x57
  0x00000000, 0x00000000, 0x00000707, 0x00000000, // 0x5b
  0x00000000, 0x00000000, 0x00000000, 0x00000808, // 0x5f

  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x63
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x67
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x6b
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x6f

  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x73
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x77
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x7b
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x7f

  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x83
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x87
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x8b
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x8f

  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x93
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x97
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x9b
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0x9f

  0x00000909, 0x00000000, 0x00000000, 0x00000000, // 0xa3
  0x00000000, 0x00000a0a, 0x00000000, 0x00000000, // 0xa7
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0xab
  0x00000000, 0x00000000, 0x00000000, 0x00000c0c, // 0xaf

  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0xb3
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0xb7
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0xbb
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0xbf

  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0xc3
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0xc7
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0xcb
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0xcf

  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0xd3
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0xd7
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0xdb
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0xdf

  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0xe3
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0xe7
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0xeb
  0x00000000, 0x00000000, 0x00000000, 0x00000000, // 0xef

  0x00000d0d, 0x00000000, 0x00000000, 0x00000000, // 0xf3
  0x00000000, 0x00000e0e, 0x00000000, 0x00000000, // 0xf7
  0x00000000, 0x00000000, 0x00000f0f, 0x00000000, // 0xfb
  0x00000000, 0x00000000, 0x00000000, 0x00000000  // 0xff
};
#endif

/* XXX: figure out how to make tgagen do this */
/*
 * For 8-bit pix, hdwe reads lowest available byte of mask at a time and decodes lo-to-hi.
 * for 32-bit pix, it reads a lowest available nibble at a time, and decodes lo-to-hi.
 * vram writes are 64 bits; this is 2 big pixels, or 8 little guys.  Turn on the bit
 * corresponding to the pixel you want lit --- the screen is lit from left to right, 
 * from low bit enable to high.  So on a 32-bit screen, the pixels are numbered
 * {1,2,1,2,1,...}; on an 8-bit screen they go {1,2,4,8,1,2,4,8,1...8..}.
 */
CommandWord TGA32BackLeftMask[16] = {
    /* num masked pix to paint */	/* mask */
           /* 16*/			0xffff,
           /* 1	*/		    	0x2,
           /* 2 */                  	0x3,  		/* 0x2 | 0x1 */
           /* 3 */                  	0xb,		/* 0x8 | 0x3 */
           /* 4 */                  	0xf,		/* 0xc | 0x3 */
           /* 5 */                  	0x2f,		/* 0x20 | 0xf */
           /* 6 */                  	0x3f,		/* 0x20 | 0x10 | 0xf */
           /* 7 */                  	0xbf,		/* 0x80 | 0x30 | 0xf */
           /* 8 */                  	0xff,
           /* 9 */                  	0x2ff,
           /* 10*/                  	0x3ff,
           /* 11*/                  	0xbff,
           /* 12*/                  	0xfff,
           /* 13*/                  	0x2fff,
           /* 14*/                  	0x3fff,
           /* 15*/                  	0xbfff
	   };

CommandWord TGA32BackRightMask[3] = {
    /* pixel alignment of dst */	/* mask */
    /* after correction       */	/* always skip last pix */
           /* -2 */			0xfff4,	/* skip last 3 pix (2 + 1) */
	   /* -1 */			0xfffc, /* skip last 2 pix (1 + 1) */
	   /*  0 */			0xfffd  /* skip last 1 pix (0 + 1) */
	   };

// Array used to "reverse" the bits of a byte

ULONG reverse_byte[256] =
{   
    0x00, 0x80, 0x40, 0xc0, 0x20, 0xa0, 0x60, 0xe0, // 0x00 - 0x07
    0x10, 0x90, 0x50, 0xd0, 0x30, 0xb0, 0x70, 0xf0, // 0x08 - 0x0f
    0x08, 0x88, 0x48, 0xc8, 0x28, 0xa8, 0x68, 0xe8, // 0x10 - 0x17
    0x18, 0x98, 0x58, 0xd8, 0x38, 0xb8, 0x78, 0xf8, // 0x18 - 0x1f
    0x04, 0x84, 0x44, 0xc4, 0x24, 0xa4, 0x64, 0xe4, // 0x20 - 0x27
    0x14, 0x94, 0x54, 0xd4, 0x34, 0xb4, 0x74, 0xf4, // 0x28 - 0x2f
    0x0c, 0x8c, 0x4c, 0xcc, 0x2c, 0xac, 0x6c, 0xec, // 0x30 - 0x37
    0x1c, 0x9c, 0x5c, 0xdc, 0x3c, 0xbc, 0x7c, 0xfc, // 0x38 - 0x3f
    0x02, 0x82, 0x42, 0xc2, 0x22, 0xa2, 0x62, 0xe2, // 0x40 - 0x47
    0x12, 0x92, 0x52, 0xd2, 0x32, 0xb2, 0x72, 0xf2, // 0x48 - 0x4f
    0x0a, 0x8a, 0x4a, 0xca, 0x2a, 0xaa, 0x6a, 0xea, // 0x50 - 0x57
    0x1a, 0x9a, 0x5a, 0xda, 0x3a, 0xba, 0x7a, 0xfa, // 0x58 - 0x5f
    0x06, 0x86, 0x46, 0xc6, 0x26, 0xa6, 0x66, 0xe6, // 0x60 - 0x67
    0x16, 0x96, 0x56, 0xd6, 0x36, 0xb6, 0x76, 0xf6, // 0x68 - 0x6f
    0x0e, 0x8e, 0x4e, 0xce, 0x2e, 0xae, 0x6e, 0xee, // 0x70 - 0x77
    0x1e, 0x9e, 0x5e, 0xde, 0x3e, 0xbe, 0x7e, 0xfe, // 0x78 - 0x7f
    0x01, 0x81, 0x41, 0xc1, 0x21, 0xa1, 0x61, 0xe1, // 0x80 - 0x87
    0x11, 0x91, 0x51, 0xd1, 0x31, 0xb1, 0x71, 0xf1, // 0x88 - 0x8f
    0x09, 0x89, 0x49, 0xc9, 0x29, 0xa9, 0x69, 0xe9, // 0x90 - 0x97
    0x19, 0x99, 0x59, 0xd9, 0x39, 0xb9, 0x79, 0xf9, // 0x98 - 0x9f
    0x05, 0x85, 0x45, 0xc5, 0x25, 0xa5, 0x65, 0xe5, // 0xa0 - 0xa7
    0x15, 0x95, 0x55, 0xd5, 0x35, 0xb5, 0x75, 0xf5, // 0xa8 - 0xaf
    0x0d, 0x8d, 0x4d, 0xcd, 0x2d, 0xad, 0x6d, 0xed, // 0xb0 - 0xb7
    0x1d, 0x9d, 0x5d, 0xdd, 0x3d, 0xbd, 0x7d, 0xfd, // 0xb8 - 0xbf
    0x03, 0x83, 0x43, 0xc3, 0x23, 0xa3, 0x63, 0xe3, // 0xc0 - 0xc7
    0x13, 0x93, 0x53, 0xd3, 0x33, 0xb3, 0x73, 0xf3, // 0xc8 - 0xcf
    0x0b, 0x8b, 0x4b, 0xcb, 0x2b, 0xab, 0x6b, 0xeb, // 0xd0 - 0xd7
    0x1b, 0x9b, 0x5b, 0xdb, 0x3b, 0xbb, 0x7b, 0xfb, // 0xd8 - 0xdf
    0x07, 0x87, 0x47, 0xc7, 0x27, 0xa7, 0x67, 0xe7, // 0xe0 - 0xe7
    0x17, 0x97, 0x57, 0xd7, 0x37, 0xb7, 0x77, 0xf7, // 0xe8 - 0xef
    0x0f, 0x8f, 0x4f, 0xcf, 0x2f, 0xaf, 0x6f, 0xef, // 0xf0 - 0xf7
    0x1f, 0x9f, 0x5f, 0xdf, 0x3f, 0xbf, 0x7f, 0xff, // 0xf8 - 0xff
};
