/*
Copyright (c) 1990  Microsoft Corporation

Module Name:

    rxhwlog.h

Abstract:

    This module is the header file that describes hardware addresses
    for the r98B system.

Author:



Revision History:

--*/

#ifndef _RXHWLOG_
#define _RXHWLOG_

#include "halp.h"


#define	NVRAM_HWLOG_PHYSIACL_ADDRESS	0x1F084000
#define	NVRAM_HWLOG_END			0x1F08C000
#define	NVRAM_HWLOG_BASE		(KSEG1_BASE|NVRAM_HWLOG_PHYSIACL_ADDRESS)
#define NVRAM_HWLOG_MAX_ENTRY		(((NVRAM_HWLOG_END - NVRAM_HWLOG_PHYSIACL_ADDRESS)\
					  - sizeof(HWLOG_CONTROL_INFO)) / HWLOG_RECORD_SIZE)

#define	HWLOG_RECORD_SIZE	0x20
#define	HWLOG_REV1_RECORD_SIZE	(0x200)
//
//	 Log Record	RCT field
//
#define	RCT_EPU			0x00
#define	RCT_MEMORY		0x01
#define	RCT_SYSBUS		0x03
#define	RCT_IOBUS		0x04
#define	RCT_CACHE		0x05
#define	RCT_SVP			0x06
#define	RCT_POWER		0x08
#define RCT_COLUMNUS_SYSBUS	0x03


//
// Log Record	ST1 field
//	 PC: PCI BusNumber
//	 EC: Errcode
//	 MP: MPU Number
//
#define	ST1_WDT_RUNOUT		0x00
#define	ST1_SVPNMI		0x08
#define	ST1_MPU			0x10
#define	ST1_SYS_IF_TRACE_LOG	0x12
#define	ST1_MEMORY_2BIT_ERR	0x00
#define	ST1_MEMORY_1BIT_HARD1	0x01
#define	ST1_MEMORY_1BIT_HARDN	0x02
#define	ST1_MEMORY_1BIT_HARD	0x03
#define	ST1_MEMORY_INTERNAL	0x10
//#define	ST1_COLUMNBUS_SYSBUS	0xEC
//#define	ST1_PONCE_SYSBUS	0xEC
//#define	ST1_MAGELLAN_SYSBUS	0xEC
#define	ST1_SYSBUS_TRACE_LOG	0x09
//#define	ST1_PCI_BUS_ERR		PC
#define	ST1_EISA_BUS_ERR	0x07
//#define	ST1_CACHE_ERR_R4400	MP
//#define	ST1_CACHE_ERR_R10000	MP
#define	ST1_SVP_COM		0x01
#define	ST1_POWER_ALARM		0x20
#define	ST1_FAN_ALARM		0x21
#define	ST1_NPCI2_ALARM		0x22
#define	ST1_SVP_ALARM		0x23


//
// Log Record	DTLEN
//

#define	DTLEN_WDT		0x8001
#define	DTLEN_SVPNMI		0x6001
#define	DTLEN_MPU_INTERNAL	0x0002
#define	DTLEN_SYSTEM_IF_TRACE_LOG	0x0002
#define	DTLEN_ECC1_BIT		0x0002

//
// Log Record	FRU1
//
#define	FRU1_WDT	"MPUx"
#define	FRU1_SVPNMI	"MPUx"

#pragma pack(1)

typedef struct _MPU_REGISTER {
    ULONG Long;
    ULONG Fill;
} MPU_REGISTER, *PMPU_REGISTER;

typedef struct _HWLOG_CONTROL_INFO {
    USHORT PAD0;
    USHORT BASE;

    USHORT PAD1;
    USHORT NREC;

    USHORT PAD2;
    UCHAR  PAD3;
    UCHAR  LOGNUM;

    USHORT PAD4;
    UCHAR  PAD5;
    UCHAR  STAT;

    USHORT PAD6;
    USHORT TBASE;

    USHORT PAD7;
    USHORT TN;

    USHORT PAD8;
    USHORT RBASE;

    USHORT PAD9;
    USHORT RN;

} HWLOG_CONTROL_INFO,*PHWLOG_CONTROL_INFO;


typedef struct _HW_LOG_AREA_HEADER {
    USHORT Ident;
    UCHAR  YY;
    UCHAR  MM;

    UCHAR  DD;
    UCHAR  hh;
    UCHAR  mm;
    UCHAR  ss;

    UCHAR  RCT;
    UCHAR  ST1;
    UCHAR  ST2;
    UCHAR  ST3;

    USHORT DTLEN;
    UCHAR  LGN;
    UCHAR  CSM;

    ULONG  FRU1[2];
    ULONG  FRU2[2];

}HW_LOG_AREA_HEADER,*PHW_LOG_AREA_HEADER;


#define	HEADER_IDENT_REV0	0xFFFFF
#define HEADER_PANIC		0x10
#define HEADER_NOT_PANIC	0x11
typedef struct _HW_LOG_CPU_CONTEXT {
    MPU_REGISTER	At;
    MPU_REGISTER	V0;
    MPU_REGISTER	V1;
    MPU_REGISTER	V2;
    MPU_REGISTER	A0;
    MPU_REGISTER	A1;
    MPU_REGISTER	A2;
    MPU_REGISTER	A3;
    MPU_REGISTER	T0;
    MPU_REGISTER	T1;
    MPU_REGISTER	T2;
    MPU_REGISTER	T3;
    MPU_REGISTER	T4;
    MPU_REGISTER	T5;
    MPU_REGISTER	T6;
    MPU_REGISTER	T7;
    MPU_REGISTER	S0;
    MPU_REGISTER	S1;
    MPU_REGISTER	S2;
    MPU_REGISTER	S3;
    MPU_REGISTER	S4;
    MPU_REGISTER	S5;
    MPU_REGISTER	S6;
    MPU_REGISTER	S7;
    MPU_REGISTER	T8;
    MPU_REGISTER	T9;
    MPU_REGISTER	K0;
    MPU_REGISTER	GP;
    MPU_REGISTER	SP;
    MPU_REGISTER	FP;
    MPU_REGISTER	RA;
    MPU_REGISTER	ENTRYLO0;
    MPU_REGISTER	ENTRYLO1;
    MPU_REGISTER	CONTEXT;
    MPU_REGISTER	BADVADDR;
    MPU_REGISTER	ENTRYHI;
    ULONG		STATUS;
    ULONG		CAUSE;
    MPU_REGISTER	EPC;
    ULONG		PAGEMASK;
    ULONG		PRID;
    ULONG		CONFIG;
    ULONG		LLADDR;
    ULONG		WATCHLO;
    ULONG		WATCHHI;    
    MPU_REGISTER	XCONTEXT;
    ULONG		ECC;
    ULONG		CASEER;
    ULONG		TAGLO;
    ULONG		TAGHI;
    MPU_REGISTER	ERREPC;
}HW_LOG_CPU_CONTEXT,*PHW_LOG_CPU_CONTEXT;


typedef struct _HW_LOG_WDT_CONTEXT {
    HW_LOG_AREA_HEADER	Header;
    HW_LOG_CPU_CONTEXT	Cpu;
    ULONG		COLUMNBS_NMIR;
    ULONG		COLUMNBS_CNFG;
    ULONG		COLUMNBS_WDTSR;
    ULONG		COLUMNBS_WDT;
    COLUMNBUS_REGISTER	IPR;
    COLUMNBUS_REGISTER	MKR;
}HW_LOG_WDT_CONTEXT,*PHW_LOG_WDT_CONTEXT;


typedef struct _HW_LOG_SVP_CONTEXT {
    HW_LOG_AREA_HEADER	Header;
    HW_LOG_CPU_CONTEXT	Cpu;
}HW_LOG_SVP_CONTEXT,*PHW_LOG_SVP_CONTEXT;


typedef struct _HW_LOG_MPU_INTERNAL_CONTEXT {
    HW_LOG_AREA_HEADER	Header;

    MPU_REGISTER	EPC;    
    ULONG		STATUS;
    ULONG		CAUSE;
    ULONG		CONFIG;
    ULONG		LLADR;
    ULONG		RPID;
    ULONG		CASHEER;
    MPU_REGISTER	ERREPC;

    ULONG		COLUMNBS_NMIR;
    ULONG		COLUMNBS_CNFG;
    ULONG		COLUMNBS_STSR;
    ULONG		COLUMNBS_ERRNOD;
    ULONG		COLUMNBS_AERR;
    ULONG		COLUMNBS_AERR2;
    ULONG		COLUMNBS_FERR;
    ULONG		COLUMNBS_FERR2;
    ULONG		COLUMNBS_ERRMK;
    ULONG		COLUMNBS_ERRMK2;
    ULONG		COLUMNBS_ERRI;
    ULONG		COLUMNBS_ERRI2;
    ULONG		COLUMNBS_NMIM;
    ULONG		COLUMNBS_NMIM2;
    ULONG		COLUMNBS_ARTYCT;
    ULONG		COLUMNBS_DRTYCT;
    ULONG		COLUMNBS_REVR;
    ULONG		COLUMNBS_MODE;
    COLUMNBUS_REGISTER	IPR;
    COLUMNBUS_REGISTER	MKR;
    COLUMNBUS_REGISTER	RRMTXX[8];
    ULONG		COLUMNBS_SYNDM;
    ULONG		COLUMNBS_STCON;
    ULONG		COLUMNBS_STSAD;
    ULONG		COLUMNBS_STADMK;
    COLUMNBUS_REGISTER	TRACE[64];
}HW_LOG_MPU_INTERNAL_CONTEXT,*PHW_LOG_MPU_INTERNAL_CONTEXT;

#define HW_LOG_COLUMNBS_SYSBUS_CONTEXT    HW_LOG_MPU_INTERNAL_CONTEXT
#define PHW_LOG_COLUMNBS_SYSBUS_CONTEXT   PHW_LOG_MPU_INTERNAL_CONTEXT

#define HW_BUSERROR_MPU_CONTEXT           HW_LOG_MPU_INTERNAL_CONTEXT
#define PHW_BUSERROR_MPU_CONTEXT          PHW_LOG_MPU_INTERNAL_CONTEXT

#define HW_NMI_COLUMNBS_CONTEXT           HW_LOG_MPU_INTERNAL_CONTEXT
#define PHW_NMI_COLUMNBS_CONTEXT          PHW_LOG_MPU_INTERNAL_CONTEXT

#define HW_LOG_ECC1_CONTEXT               HW_LOG_MAGELLAN_SYSBUS_CONTEXT
#define PHW_LOG_ECC1_CONTEXT              PHW_LOG_MAGELLAN_SYSBUS_CONTEXT

#if 0
typedef	struct HW_LOG_MPU_INTERNAL_CONTEXT	HW_LOG_COLUMNBS_SYSBUS_CONTEXT;
typedef	struct HW_LOG_COLUMNBS_SYSBUS_CONTEXT *	PHW_LOG_COLUMNBS_SYSBUS_CONTEXT;
typedef	struct HW_LOG_MPU_INTERNAL_CONTEXT	HW_BUSERROR_MPU_CONTEXT,*PHW_BUSERROR_MPU_CONTEXT;
typedef	struct HW_LOG_MPU_INTERNAL_CONTEXT	HW_NMI_COLUMNBS_CONTEXT,*PHW_NMI_COLUMNBS_CONTEXT;
typedef struct HW_LOG_MAGELLAN_SYSBUS_CONTEXT	HW_LOG_ECC1_CONTEXT,*PHW_LOG_ECC1_CONTEXT;
#endif

typedef struct _HW_LOG_SYSTEM_IF_CONTEXT {
    HW_LOG_AREA_HEADER	Header;
    COLUMNBUS_REGISTER	SYNDM;
    COLUMNBUS_REGISTER	STCON;
    COLUMNBUS_REGISTER	STSAD;
    COLUMNBUS_REGISTER	STADMK;
    USHORT	STDATHL[64][2];
}HW_LOG_SYSTEM_IF_CONTEXT,*PHW_LOG_SYSTEM_IF_CONTEXT;



typedef struct _HW_LOG_MAGELLAN_SYSBUS_CONTEXT {
    HW_LOG_AREA_HEADER	Header;
    ULONG		MAGELLAN_AERR;
    ULONG		MAGELLAN_FERR;
    ULONG		MAGELLAN_ERRM;
    ULONG		MAGELLAN_ERRI;
    ULONG		MAGELLAN_NMIM;
    ULONG		MAGELLAN_EAHI;
    ULONG		MAGELLAN_EALI;
    ULONG		MAGELLAN_CKE0;
    ULONG		MAGELLAN_SECT;
    ULONG		MAGELLAN_STS1;
    MAGELLAN_REGISTER	MAGELLAN_DATM;
    MAGELLAN_REGISTER	MAGELLAN_DSRG;
    MAGELLAN_REGISTER	MAGELLAN_SDLM;
    ULONG		COLUMNBS_ERRNOD;
    ULONG		ECC1ERROR_COUNT;
    ULONG		SIMM_ITF_RESULT;
    ULONG		MEMORYMAP_ITF_RESULT;
    ULONG		MAGELLAN_INLC;
    ULONG		MAGELLAN_RCFD;
    ULONG		MAGELLAN_DTRG;
    ULONG		MAGELLAN_REVR;
    ULONG		MAGELLAN_ADECX[4];
    ULONG		MAGELLAN_EADECX[2];
    MPU_REGISTER	EPC;
    ULONG		MAGELLAN_TMODE;
    ULONG		MAGELLAN_TRA;
    ULONG		TRMX[32][3];
}HW_LOG_MAGELLAN_SYSBUS_CONTEXT,*PHW_LOG_MAGELLAN_SYSBUS_CONTEXT;

typedef struct _HW_LOG_PONCE_CONTEXT {
    HW_LOG_AREA_HEADER	Header;
    MPU_REGISTER	EPC;
    ULONG		COLUMNBS_ERRNOD;
    ULONG		PONCE_REVR;
    ULONG		PONCE_AERR;
    ULONG		PONCE_FERR;
    ULONG		PONCE_ERRM;
    ULONG		PONCE_ERRI;
    ULONG		PONCE_EAHI;
    ULONG		PONCE_EALI;
    ULONG		PONCE_PAERR;
    ULONG		PONCE_PFERR;
    ULONG		PONCE_PERRM;
    ULONG		PONCE_PERRI;
    ULONG		PONCE_PTOL;
    ULONG		PONCE_PNRT;
    ULONG		PONCE_PRCOL;
    ULONG		PONCE_PMDL;
    ULONG		PONCE_ANRC;
    ULONG		PONCE_DNRC;
    ULONG		PONCE_PCMDN;
    ULONG		PONCE_PSTAT;
    ULONG		PONCE_REVID;
    ULONG		PONCE_LTNCY;
    PONCE_REGISTER	PONCE_RRMTX[8];
    ULONG		PONCE_TRSM;
    ULONG		PONCE_TROM;
    ULONG		PONCE_TRAC;
    ULONG		PONCE_TRDS;
    UCHAR		PONCE_BUSTRACE[344];		//All 0
}HW_LOG_PONCE_CONTEXT,*PHW_LOG_PONCE_CONTEXT;

typedef struct _HW_LOG_SYSBUS_TRACE_CONTEXT {
    HW_LOG_AREA_HEADER	Header;
    ULONG		MAGELLAN_TMOD;
    ULONG		MAGELLAN_TRA;
    ULONG		TRMX[42][3];    
}HW_LOG_SYSBUS_TRACE_CONTEXT,*PHW_LOG_SYSBUS_TRACE_CONTEXT;
    

typedef struct _HW_LOG_EISA_CONTEXT {
    HW_LOG_AREA_HEADER	Header;
    ULONG		COLUMNBS_ERRNOD;
    ULONG		ESC_NMISC;
    ULONG		ESC_NMIERTC;
    ULONG		ESC_NMIESC;
    ULONG		ESC_SOFTNMI;
}HW_LOG_EISA_CONTEXT,*PHW_LOG_EISA_CONTEXT;
    

    

typedef struct _HW_LOG_SVP_CON_CONTEXT {
    HW_LOG_AREA_HEADER	Header;
}HW_LOG_SVP_CON_CONTEXT,*PHW_LOG_SVP_CON_CONTEXT;


typedef struct _HW_LOG_POWER_CONTEXT {
    HW_LOG_AREA_HEADER	Header;
    ULONG		COLUMNBS_ERRNOD;
    USHORT		LOCAL_ALARM;
    USHORT		LOCAL_ALMINH;
}HW_LOG_POWER_CONTEXT,*PHW_LOG_POWER_CONTEXT;

#pragma pack(4)


#define	HWLOG_MPU_INTERNAL		0x1
#define HWLOG_COLUMNBS_SYSBUS		0x2

#define HWLOG_PCI_BUSERROR		0x100
#define HWLOG_PONCE_SYSBUS		0x200
#define HWLOG_MAGELLAN_SYSBUS		0x400

#define HWLOG_EISA			0x10
#define HWLOG_POWER			0x20
#define HWLOG_2BITERROR			0x40

#define HWLOG_CACHEERR_R4400		0x80
#define HWLOG_CACHEERR_R10000		0x1000
#define HWLOG_SYSCORERR			0x2000
#define HWLOG_NMI_WDT			0x4000


#define HWLOG_NMI_SVP			0x100000
#define HWLOG_ECC1			0x200000


#define HW_LOG_MPU_INTERNAL_AERR        0x37f
#define HW_LOG_MPU_INTERNAL_AERR2       0xffffffff


#define PONCE0_NODE     0
#define PONCE1_NODE     1
#define COLUMBUS0_NODE  4
#define COLUMBUS1_NODE  5
#define COLUMBUS2_NODE  6
#define COLUMBUS3_NODE  7

#define MAGELLAN0_NODE  8
#define MAGELLAN1_NODE  9

//Cache Error Log

typedef struct _HW_LOG_CACHE_ERROR{
    HW_LOG_AREA_HEADER	Header;
    ULONG	EPC_cpu;
    ULONG	Rev;
    ULONG	Psr_cpu;
    ULONG	CFG_cpu;
    ULONG	PRID_cpu;
    ULONG	CHERR_cpu;
    ULONG	CheAdd_p;
    ULONG	CheAdd_s;
    ULONG	TagLo_p;
    ULONG	ECC_p;
    ULONG	TagLo_s;
    ULONG	ECC_s;
    LONGLONG	data_s;
    LONGLONG	Good_data_s;
    ULONG	Good_TagLo_s;
    ULONG	Good_ECC_s;
    ULONG	tag_synd_s;
    ULONG	data_synd_s;
    LONGLONG	xkphs_share;
}HW_LOG_CACHE_ERROR,*PHW_LOG_CACHE_ERROR;    




#endif // _RXHWLOG_




