/*++ BUILD Version: 0001    // Increment this if a change has global effects

Copyright (c) 1989  Microsoft Corporation

Module Name:

    exlevels.h

Abstract:

    This file contains all of the MUTEX level numbers used by the NT
    executive.  A thread is only allowed to acquire mutexes with levels
    numerically higher than the highest mutex level already owned.

Author:

    Steve Wood (stevewo) 08-May-1989

Revision History:

--*/

//
// Kernel Mutex Level Numbers (must be globallly assigned within executive)
// The third token in the name is the sub-component name that defines and
// uses the level number.
//

//
// Used by Vdm for protecting io simulation structures
//

#define MUTEX_LEVEL_VDM_IO                  (ULONG)0x00000001

#define MUTEX_LEVEL_EX_PROFILE              (ULONG)0x00000040

//
// The LANMAN Redirector uses the file system major function, but defines
// it's own mutex levels.  We can do this safely because we know that the
// local filesystem will never call the remote filesystem and vice versa.
//

#define MUTEX_LEVEL_RDR_FILESYS_DATABASE    (ULONG)0x10100000
#define MUTEX_LEVEL_RDR_FILESYS_SECURITY    (ULONG)0x10100001

//
// File System levels.
//

#define MUTEX_LEVEL_FILESYSTEM_RAW_VCB      (ULONG)0x11000006

//
// In the NT STREAMS environment, a mutex is used to serialize open, close
// and Scheduler threads executing in a subsystem-parallelized stack.
//

#define MUTEX_LEVEL_STREAMS_SUBSYS          (ULONG)0x11001001

//
// Mutex level used by LDT support on x86
//

#define MUTEX_LEVEL_PS_LDT                  (ULONG)0x1F000000
