;/*++ BUILD Version: 0001    // Increment this if a change has global effects
;
;Copyright (c) 1992-1996  Microsoft Corporation
;
;Module Name:
;
;    netevent.h
;
;Abstract:
;
;    Definitions for network events.
;
;Author:
;
;    Portable Systems Group 6-May-1992
;
;Revision History:
;
;Notes:
;
;    This file is generated by the MC tool from the netevent.mc file.
;
;--*/
;
;#ifndef _NETEVENT_
;#define _NETEVENT_
;

SeverityNames=(Success=0x0:STATUS_SEVERITY_SUCCESS
               Informational=0x1:STATUS_SEVERITY_INFORMATIONAL
               Warning=0x2:STATUS_SEVERITY_WARNING
               Error=0x3:STATUS_SEVERITY_ERROR
              )

;
;/////////////////////////////////////////////////////////////////////////
;//
;// Lanman Server Events (2000 - 2999)
;//     2000-2499 are generated by the server driver (kernel mode)
;//     2500-2999 are generated by the server service (user mode)
;//
;/////////////////////////////////////////////////////////////////////////
;

;
;// Server driver events, issued from kernel mode.  Don't use %1 for
;// server-supplied insertion strings -- the I/O system provides the
;// first string.
;

MessageId=2000 Severity=Error SymbolicName=EVENT_SRV_SERVICE_FAILED
Language=English
The server's call to a system service failed unexpectedly.
.

MessageId=2001 Severity=Error SymbolicName=EVENT_SRV_RESOURCE_SHORTAGE
Language=English
The server was unable to perform an operation due to a shortage of available resources.
.

MessageId=2002 Severity=Error SymbolicName=EVENT_SRV_CANT_CREATE_DEVICE
Language=English
The server could not create its device.  The server could not be started.
.

MessageId=2003 Severity=Error SymbolicName=EVENT_SRV_CANT_CREATE_PROCESS
Language=English
The server could not create a process.  The server could not be started.
.

MessageId=2004 Severity=Error SymbolicName=EVENT_SRV_CANT_CREATE_THREAD
Language=English
The server could not create a startup thread.  The server could not be started.
.

MessageId=2005 Severity=Error SymbolicName=EVENT_SRV_UNEXPECTED_DISC
Language=English
The server received an unexpected disconnection from a client.
.

MessageId=2006 Severity=Error SymbolicName=EVENT_SRV_INVALID_REQUEST
Language=English
The server received an incorrectly formatted request from %2.
.

MessageId=2007 Severity=Error SymbolicName=EVENT_SRV_CANT_OPEN_NPFS
Language=English
The server could not open the named pipe file system.  Remote named pipes are disabled.
.

MessageId=2009 Severity=Error SymbolicName=EVENT_SRV_CANT_GROW_TABLE
Language=English
The server could not expand a table because the table reached the maximum size.
.

MessageId=2010 Severity=Error SymbolicName=EVENT_SRV_CANT_START_SCAVENGER
Language=English
The server could not start the scavenger thread.  The server could not be started.
.

MessageId=2011 Severity=Error SymbolicName=EVENT_SRV_IRP_STACK_SIZE
Language=English
The server's configuration parameter "irpstacksize" is too small for the server to use a local device.  Please increase the value of this parameter.
.

MessageId=2012 Severity=Error SymbolicName=EVENT_SRV_NETWORK_ERROR
Language=English
The server has encountered a network error.
.

MessageId=2013 Severity=Warning SymbolicName=EVENT_SRV_DISK_FULL
Language=English
The %2 disk is at or near capacity.  You may need to delete some files.
.

MessageId=2016 Severity=Error SymbolicName=EVENT_SRV_NO_VIRTUAL_MEMORY
Language=English
The server was unable to allocate virtual memory.
.

MessageId=2017 Severity=Error SymbolicName=EVENT_SRV_NONPAGED_POOL_LIMIT
Language=English
The server was unable to allocate from the system nonpaged pool because the server reached the configured limit for nonpaged pool allocations.
.

MessageId=2018 Severity=Error SymbolicName=EVENT_SRV_PAGED_POOL_LIMIT
Language=English
The server was unable to allocate from the system paged pool because the server reached the configured limit for paged pool allocations.
.

MessageId=2019 Severity=Error SymbolicName=EVENT_SRV_NO_NONPAGED_POOL
Language=English
The server was unable to allocate from the system nonpaged pool because the pool was empty.
.

MessageId=2020 Severity=Error SymbolicName=EVENT_SRV_NO_PAGED_POOL
Language=English
The server was unable to allocate from the system paged pool because the pool was empty.
.

MessageId=2021 Severity=Warning SymbolicName=EVENT_SRV_NO_WORK_ITEM
Language=English
The server was unable to allocate a work item %2 times in the last %3 seconds.
.

MessageId=2022 Severity=Warning SymbolicName=EVENT_SRV_NO_FREE_CONNECTIONS
Language=English
The server was unable to find a free connection %2 times in the last %3 seconds.
.

MessageId=2023 Severity=Warning SymbolicName=EVENT_SRV_NO_FREE_RAW_WORK_ITEM
Language=English
The server was unable to find a free raw work item %2 times in the last %3 seconds.
.

MessageId=2024 Severity=Warning SymbolicName=EVENT_SRV_NO_BLOCKING_IO
Language=English
The server was unable to allocate resources for blocking I/O %2 times in the last %3 seconds.
.

;
;// Server service events, issued from user mode.  %1 is the first
;// service-supplied insertion string.
;

MessageId=2501 Severity=Error SymbolicName=EVENT_SRV_KEY_NOT_FOUND
Language=English
The server's Registry key %1 was not present.  The server could not start.
.

MessageId=2502 Severity=Error SymbolicName=EVENT_SRV_KEY_NOT_CREATED
Language=English
The server's Registry key %1 was not present and could not be created.  The server could not start.
.

MessageId=2503 Severity=Error SymbolicName=EVENT_SRV_NO_TRANSPORTS_BOUND
Language=English
The server did not bind to any transports.  The server could not start.
.

MessageId=2504 Severity=Warning SymbolicName=EVENT_SRV_CANT_BIND_TO_TRANSPORT
Language=English
The server could not bind to the transport %1.
.

MessageId=2505 Severity=Error SymbolicName=EVENT_SRV_CANT_BIND_DUP_NAME
Language=English
The server could not bind to the transport %1 because another computer on the network has the same name.  The server could not start.
.

MessageId=2506 Severity=Warning SymbolicName=EVENT_SRV_INVALID_REGISTRY_VALUE
Language=English
The value named %1 in the server's Registry key %2 was invalid.  The value was ignored, and processing continued.
.

MessageId=2507 Severity=Warning SymbolicName=EVENT_SRV_INVALID_SD
Language=English
The security descriptor stored in the Registry for the share %1 was invalid.  The share was not automatically recreated.
.

MessageId=2508 Severity=Warning SymbolicName=EVENT_SRV_CANT_LOAD_DRIVER
Language=English
The server service was unable to load the server driver.
.

MessageId=2509 Severity=Warning SymbolicName=EVENT_SRV_CANT_UNLOAD_DRIVER
Language=English
The server service was unable to unload the server driver.
.

MessageId=2510 Severity=Warning SymbolicName=EVENT_SRV_CANT_MAP_ERROR
Language=English
The server service was unable to map error code %1.
.

MessageId=2511 Severity=Warning SymbolicName=EVENT_SRV_CANT_RECREATE_SHARE
Language=English
The server service was unable to recreate the share %1 because the directory %2 no longer exists.
.

;
;/////////////////////////////////////////////////////////////////////////
;//
;// Lanman Redirector Events
;//
;//
;/////////////////////////////////////////////////////////////////////////
;
;

MessageId=3001  SymbolicName=EVENT_RDR_RESOURCE_SHORTAGE
Language=English
The redirector was unable to allocate memory.
.

MessageId=3002  SymbolicName=EVENT_RDR_CANT_CREATE_DEVICE
Language=English
The redirector could not create its device.  The redirector could not be started.
.

MessageId=3003  SymbolicName=EVENT_RDR_CANT_CREATE_THREAD
Language=English
The redirector could not create a system thread.
.

MessageId=3004  SymbolicName=EVENT_RDR_CANT_SET_THREAD
Language=English
The redirector could not set the priority for a system thread.
.

MessageId=3005  SymbolicName=EVENT_RDR_INVALID_REPLY
Language=English
The redirector received an incorrectly formatted response from %2.
.

MessageId=3006  SymbolicName=EVENT_RDR_INVALID_SMB
Language=English
The redirector received an SMB that was too short.
.

MessageId=3007  SymbolicName=EVENT_RDR_INVALID_LOCK_REPLY
Language=English
The redirector received an incorrect response from %2 to a lock request.
.

MessageId=3009  SymbolicName=EVENT_RDR_FAILED_UNLOCK
Language=English
The redirector failed to unlock part of a file on server %2.
.

MessageId=3011  SymbolicName=EVENT_RDR_CLOSE_BEHIND
Language=English
The redirector failed to write data to server %2 after the file was closed.
.

MessageId=3012  SymbolicName=EVENT_RDR_UNEXPECTED_ERROR
Language=English
An unexpected network error has occurred on the virtual circuit to %2.
.

MessageId=3013  SymbolicName=EVENT_RDR_TIMEOUT
Language=English
The redirector has timed out a request to %2.
.

MessageId=3014  SymbolicName=EVENT_RDR_INVALID_OPLOCK
Language=English
The redirector received an invalid oplock level from %2.
.

MessageId=3015  SymbolicName=EVENT_RDR_CONNECTION_REFERENCE
Language=English
The redirector dereferenced a connection through zero.
.

MessageId=3016  SymbolicName=EVENT_RDR_SERVER_REFERENCE
Language=English
The redirector dereferenced a server through zero.
.

MessageId=3017  SymbolicName=EVENT_RDR_SMB_REFERENCE
Language=English
The redirector dereferenced the allocated SMB count through zero.
.

MessageId=3018  SymbolicName=EVENT_RDR_ENCRYPT
Language=English
The redirector accessed a share-level server that indicates it encrypts passwords.
This combination is not supported.
.

MessageId=3019  SymbolicName=EVENT_RDR_CONNECTION
Language=English
The redirector failed to determine the connection type.
.

MessageId=3021  SymbolicName=EVENT_RDR_MAXCMDS
Language=English
The redirector failed to allocate a multiplex table entry.  This indicates that
the MAXCMDS parameter to the redirector is insufficient for the users needs.
.

MessageId=3022  SymbolicName=EVENT_RDR_OPLOCK_SMB
Language=English
The redirector failed to allocate a buffer for an oplock break.
.


MessageId=3023  SymbolicName=EVENT_RDR_DISPOSITION
Language=English
The redirector failed to map the requested file disposition (for NtCreateFile).
.

MessageId=3024  SymbolicName=EVENT_RDR_CONTEXTS
Language=English
The redirector is allocating additional resources for input/output request packet contexts.  This is
probably caused by a resource leak in the redirector.
.


MessageId=3025  SymbolicName=EVENT_RDR_WRITE_BEHIND_FLUSH_FAILED
Language=English
A write-behind operation has failed to the remote server %2.  The data contains the amount requested to write and the amount actually written.
.

MessageId=3026  SymbolicName=EVENT_RDR_AT_THREAD_MAX
Language=English
The redirector was unable to create a worker thread because it has already created the maximum number of configured work threads.
.

MessageId=3027  SymbolicName=EVENT_RDR_CANT_READ_REGISTRY
Language=English
The redirector was unable to initialize variables from the Registry.
.

MessageId=3028  SymbolicName=EVENT_RDR_TIMEZONE_BIAS_TOO_LARGE
Language=English
The time zone bias calculated between %2 and the current workstation is too
large.  The data specifies the number of 100ns units between the workstation
and server.  Make sure that the time of day on the workstation and server are
correct.
.

MessageId=3029  SymbolicName=EVENT_RDR_PRIMARY_TRANSPORT_CONNECT_FAILED
Language=English
The redirector has failed to connect to the server %2 on the primary transport.  The data contains the error.
.

MessageId=3030  SymbolicName=EVENT_RDR_DELAYED_SET_ATTRIBUTES_FAILED
Language=English
The redirector was unable to update the file attributes on a file located on server %2.
The data contains the name of the file.
.
MessageId=3031  SymbolicName=EVENT_RDR_DELETEONCLOSE_FAILED
Language=English
The redirector was unable to delete the file specified on server %2 when it was closed by the application.
The data contains the name of the file.
.

;
;
;/////////////////////////////////////////////////////////////////////////
;//
;// STREAMS Environment Events
;//
;// Codes 4000 - 4099
;//
;/////////////////////////////////////////////////////////////////////////
;
;

MessageId=4000 Severity=Error SymbolicName=EVENT_STREAMS_STRLOG
Language=English
%2.
.

MessageId=4001 Severity=Warning SymbolicName=EVENT_STREAMS_ALLOCB_FAILURE
Language=English
Unable to allocate a %2 byte message.
.

MessageId=4002  Severity=Warning SymbolicName=EVENT_STREAMS_ALLOCB_FAILURE_CNT
Language=English
%2 message allocations have failed since initialization.
.

MessageId=4003  Severity=Warning SymbolicName=EVENT_STREAMS_ESBALLOC_FAILURE
Language=English
Unable to allocate a %2 byte external message.
.

MessageId=4004  Severity=Warning SymbolicName=EVENT_STREAMS_ESBALLOC_FAILURE_CNT
Language=English
%2 external message allocations have failed since initialization.
.

;
;
;/////////////////////////////////////////////////////////////////////////
;//
;// TCP/IP Events
;//
;// Codes 4100 - 4299
;//
;/////////////////////////////////////////////////////////////////////////
;
;
;//
;// Common TCP/IP messages
;//
;// Codes 4100 - 4149
;//
;//
;
MessageId=4100 Severity=Error SymbolicName=EVENT_TCPIP_CREATE_DEVICE_FAILED
Language=English
Unable to create device object %2. Initialization failed.
.

MessageId=4101 Severity=Error SymbolicName=EVENT_TCPIP_NO_RESOURCES_FOR_INIT
Language=English
Unable to allocate required resources. Initialization failed.
.

;
;//
;// ARP messages
;//
;// Codes 4150-4174
;

;
;//
;// IP Loopback messages
;//
;// Codes 4175-4184
;//
;

;
;//
;// IP/ICMP messages
;//
;// Codes 4185 - 4224
;
MessageId=4185 Severity=Error SymbolicName=EVENT_TCPIP_TOO_MANY_NETS
Language=English
IP has been bound to more than the maximum number of supported interfaces.
Some interfaces on adapter %2 will not be initialized.
.

MessageId=4186 Severity=Error SymbolicName=EVENT_TCPIP_NO_MASK
Language=English
No subnet mask was specified for interface %2. This interface and
all subsequent interfaces on adapter %3 cannot be initialized.
.

MessageId=4187 Severity=Error SymbolicName=EVENT_TCPIP_INVALID_ADDRESS
Language=English
Invalid address %2 was specified for adapter %3. This interface
cannot be initialized.
.

MessageId=4188 Severity=Error SymbolicName=EVENT_TCPIP_INVALID_MASK
Language=English
Invalid subnet mask %2 was specified for address %3 on adapter %4.
This interface cannot be initialized.
.

MessageId=4189 Severity=Error SymbolicName=EVENT_TCPIP_NO_ADAPTER_RESOURCES
Language=English
IP could not allocate some resources required to configure adapter %2.
Some interfaces on this adapter will not be initialized.
.

MessageId=4190 Severity=Warning SymbolicName=EVENT_TCPIP_DHCP_INIT_FAILED
Language=English
IP was unable to initialize adapter %2 for configuration by DHCP.
If DHCP is enabled on this adapter, the primary interface may not be
configured properly. Interfaces on this adapter not configured by
DHCP will be unaffected.
.

MessageId=4191 Severity=Error SymbolicName=EVENT_TCPIP_ADAPTER_REG_FAILURE
Language=English
IP could not open the registry key for adapter %2.
Interfaces on this adapter will not be initialized.
.

MessageId=4192 Severity=Warning SymbolicName=EVENT_TCPIP_INVALID_DEFAULT_GATEWAY
Language=English
Invalid default gateway address %2 was specified for adapter %3.
Some remote networks may not be reachable as a result.
.

MessageId=4193 Severity=Error SymbolicName=EVENT_TCPIP_NO_ADDRESS_LIST
Language=English
Unable to read the configured IP addresses for adapter %2.
IP interfaces will not be initialized on this adapter.
.

MessageId=4194 Severity=Error SymbolicName=EVENT_TCPIP_NO_MASK_LIST
Language=English
Unable to read the configured subnet masks for adapter %2.
IP interfaces will not be initialized on this adapter.
.

MessageId=4195 Severity=Error SymbolicName=EVENT_TCPIP_NO_BINDINGS
Language=English
IP was unable to read its bindings from the registry. No network interfaces
were configured.
.

MessageId=4196 Severity=Error SymbolicName=EVENT_TCPIP_IP_INIT_FAILED
Language=English
Initialization of IP failed.
.

MessageId=4197 Severity=Warning SymbolicName=EVENT_TCPIP_TOO_MANY_GATEWAYS
Language=English
More than the maximum number of default gateways were specified for
adapter %2. Some remote networks may not be reachable as a result.
.

MessageId=4198 Severity=Error SymbolicName=EVENT_TCPIP_ADDRESS_CONFLICT1
Language=English
The system detected an address conflict for IP address %2 with the system
having network hardware address %3. The local interface has been disabled.
.

MessageId=4199 Severity=Error SymbolicName=EVENT_TCPIP_ADDRESS_CONFLICT2
Language=English
The system detected an address conflict for IP address %2 with the system
having network hardware address %3. Network operations on this system may
be disrupted as a result.
.


;
;//
;// TCP messages
;//
;// Codes 4225 - 4264
;//
;
MessageId=4225 Severity=Error SymbolicName=EVENT_TCPIP_TCP_INIT_FAILED
Language=English
Initialization of TCP/UDP failed.
.


;
;//
;// UDP messages
;//
;// Codes 4265 - 4299
;//
;


;
;
;/////////////////////////////////////////////////////////////////////////
;//
;// NBT Events
;//
;// Codes 4300 - 4399
;//
;/////////////////////////////////////////////////////////////////////////
;
;
;
;// Don't use %1 for driver supplied insertion strings.  The IO subsystem
;// supplies the first string!!
;
MessageId=4300 Severity=Error SymbolicName=EVENT_NBT_CREATE_DRIVER
Language=English
The driver could not be created.
.
MessageId=4301 Severity=Error SymbolicName=EVENT_NBT_OPEN_REG_PARAMS
Language=English
Unable to open the Registry Parameters to read configuration information.
.
MessageId=4302 Severity=Warning SymbolicName=EVENT_NBT_NO_BACKUP_WINS
Language=English
The backup WINS server address is not configured in the registry.
.
MessageId=4303 Severity=Warning SymbolicName=EVENT_NBT_NO_WINS
Language=English
The primary WINS server address is not configured in the registry.
.
MessageId=4304 Severity=Warning SymbolicName=EVENT_NBT_BAD_BACKUP_WINS_ADDR
Language=English
The backup WINS server address is not formated correctly in the registry.
.
MessageId=4305 Severity=Warning SymbolicName=EVENT_NBT_BAD_PRIMARY_WINS_ADDR
Language=English
The primary WINS server address is not formated correctly in the registry.
.
MessageId=4306 Severity=Error SymbolicName=EVENT_NBT_NAME_SERVER_ADDRS
Language=English
Unable to configure the addresses of the WINS servers.
.
MessageId=4307 Severity=Error SymbolicName=EVENT_NBT_CREATE_ADDRESS
Language=English
Initialization failed because the transport refused to open initial Addresses.
.
MessageId=4308 Severity=Error SymbolicName=EVENT_NBT_CREATE_CONNECTION
Language=English
Initialization failed because the transport refused to open initial Connections.
.
MessageId=4309 Severity=Error SymbolicName=EVENT_NBT_NON_OS_INIT
Language=English
Data structure initialization failed.
.
MessageId=4310 Severity=Error SymbolicName=EVENT_NBT_TIMERS
Language=English
Initialization failed because the timers could not be started.
.
MessageId=4311 Severity=Error SymbolicName=EVENT_NBT_CREATE_DEVICE
Language=English
Initialization failed because the driver device could not be created.
.
MessageId=4312 Severity=Warning SymbolicName=EVENT_NBT_NO_DEVICES
Language=English
There are no adapters configured for this protocol stack.
.
MessageId=4313 Severity=Error SymbolicName=EVENT_NBT_OPEN_REG_LINKAGE
Language=English
Unable to open the Registry Linkage to read configuration information.
.
MessageId=4314 Severity=Error SymbolicName=EVENT_NBT_READ_BIND
Language=English
Unable to read the driver's bindings to the transport from the registry.
.
MessageId=4315 Severity=Error SymbolicName=EVENT_NBT_READ_EXPORT
Language=English
Unable to read the driver's exported linkage configuration information.
.
MessageId=4316 Severity=Warning SymbolicName=EVENT_NBT_OPEN_REG_NAMESERVER
Language=English
Unable to open the Registry to read the WINS server addresses.
.
MessageId=4317 Severity=Warning SymbolicName=EVENT_SCOPE_LABEL_TOO_LONG
Language=English
The Netbios Name Scope has a component longer than 63 characters. Each label
in the Scope cannot be longer than 63 bytes.  Use the Control Panel, Network
applet to change the scope.
.
MessageId=4318 Severity=Warning SymbolicName=EVENT_SCOPE_TOO_LONG
Language=English
The Netbios Name Scope is too long. The scope cannot be longer than
255 bytes. Use the Control Panel, Network applet to change the scope.
.
MessageId=4319 Severity=Error SymbolicName=EVENT_NBT_DUPLICATE_NAME
Language=English
A duplicate name has been detected on the TCP network.  The IP address of
the machine that sent the message is in the data. Use nbtstat -n in a
command window to see which name is in the Conflict state.
.
MessageId=4320 Severity=Error SymbolicName=EVENT_NBT_NAME_RELEASE
Language=English
Another machine has sent a name release message to this machine probably
because a duplicate name has been detected on the TCP network.  The IP address
of the node that sent the message is in the data. Use nbtstat -n in a
command window to see which name is in the Conflict state.
.


;
;/////////////////////////////////////////////////////////////////////////
;//
;// NDIS Environment Events
;//
;// Codes 5000 - 5099
;//
;/////////////////////////////////////////////////////////////////////////
;
;


MessageId=5000  Severity=Error SymbolicName=EVENT_NDIS_RESOURCE_CONFLICT
Language=English
%2 : Has encountered a conflict in resources and could not load.
.

MessageId=5001  Severity=Error SymbolicName=EVENT_NDIS_OUT_OF_RESOURCE
Language=English
%2 : Could not allocate the resources necessary for operation.
.

MessageId=5002  Severity=Error SymbolicName=EVENT_NDIS_HARDWARE_FAILURE
Language=English
%2 : Has determined that the adapter is not functioning properly.
.

MessageId=5003  Severity=Error SymbolicName=EVENT_NDIS_ADAPTER_NOT_FOUND
Language=English
%2 : Could not find an adapter.
.

MessageId=5004  Severity=Error SymbolicName=EVENT_NDIS_INTERRUPT_CONNECT
Language=English
%2 : Could not connect to the interrupt number supplied.
.

MessageId=5005  Severity=Error SymbolicName=EVENT_NDIS_DRIVER_FAILURE
Language=English
%2 : Has encountered an internal error and has failed.
.

MessageId=5006  Severity=Error SymbolicName=EVENT_NDIS_BAD_VERSION
Language=English
%2 : The version number is incorrect for this driver.
.

MessageId=5007  Severity=Warning SymbolicName=EVENT_NDIS_TIMEOUT
Language=English
%2 : Timed out during an operation.
.

MessageId=5008  Severity=Error SymbolicName=EVENT_NDIS_NETWORK_ADDRESS
Language=English
%2 : Has encountered an invalid network address.
.

MessageId=5009  Severity=Error SymbolicName=EVENT_NDIS_UNSUPPORTED_CONFIGURATION
Language=English
%2 : Does not support the configuration supplied.
.

MessageId=5010  Severity=Error SymbolicName=EVENT_NDIS_INVALID_VALUE_FROM_ADAPTER
Language=English
%2 : The adapter has returned an invalid value to the driver.
.

MessageId=5011  Severity=Error SymbolicName=EVENT_NDIS_MISSING_CONFIGURATION_PARAMETER
Language=English
%2 : A required parameter is missing from the Registry.
.

MessageId=5012  Severity=Error SymbolicName=EVENT_NDIS_BAD_IO_BASE_ADDRESS
Language=English
%2 : The I/O base address supplied does not match the jumpers on the adapter.
.

MessageId=5013  Severity=Informational SymbolicName=EVENT_NDIS_RECEIVE_SPACE_SMALL
Language=English
%2 : The adapter is configured such that the receive space is smaller than
the maximum packet size.  Some packets may be lost.
.

MessageId=5014  Severity=Warning SymbolicName=EVENT_NDIS_ADAPTER_DISABLED
Language=English
%2 : The adapter is disabled.  The driver cannot open the adapter.
.

MessageId=5015  Severity=Warning SymbolicName=EVENT_NDIS_IO_PORT_CONFLICT
Language=English
%2 : There is an I/O port conflict.
.

MessageId=5016  Severity=Warning SymbolicName=EVENT_NDIS_PORT_OR_DMA_CONFLICT
Language=English
%2 : There is an I/O port or DMA channel conflict.
.

MessageId=5017  Severity=Warning SymbolicName=EVENT_NDIS_MEMORY_CONFLICT
Language=English
%2 : There is a memory conflict at address 0x%3.
.

MessageId=5018  Severity=Warning SymbolicName=EVENT_NDIS_INTERRUPT_CONFLICT
Language=English
%2 : There is a interrupt conflict at interrupt number %3.
.

MessageId=5019  Severity=Warning SymbolicName=EVENT_NDIS_DMA_CONFLICT
Language=English
%2 : There is a resource conflict at DMA channel %3.
.

MessageId=5020 Severity=Error  SymbolicName=EVENT_NDIS_INVALID_DOWNLOAD_FILE_ERROR
Language=English
%2 : The download file is invalid.  The driver is unable to load.
.
MessageId=5021 Severity=Warning  SymbolicName=EVENT_NDIS_MAXRECEIVES_ERROR
Language=English
%2 : The specified Registry entry MaxReceives is out of range.  Using
default value.
.
MessageId=5022 Severity=Warning  SymbolicName=EVENT_NDIS_MAXTRANSMITS_ERROR
Language=English
%2 : The specified Registry entry MaxTransmits is out of range.  Using
default value.
.
MessageId=5023 Severity=Warning  SymbolicName=EVENT_NDIS_MAXFRAMESIZE_ERROR
Language=English
%2 : The specified Registry entry MaxFrameSize is out of range.  Using
default value.
.
MessageId=5024 Severity=Warning  SymbolicName=EVENT_NDIS_MAXINTERNALBUFS_ERROR
Language=English
%2 : The specified Registry entry MaxInternalBufs is out of range.  Using
default value.
.
MessageId=5025 Severity=Warning  SymbolicName=EVENT_NDIS_MAXMULTICAST_ERROR
Language=English
%2 : The specified Registry entry MaxMulticast is out of range.  Using
default value.
.
MessageId=5026 Severity=Warning  SymbolicName=EVENT_NDIS_PRODUCTID_ERROR
Language=English
%2 : The specified Registry entry ProductId is out of range.  Using
default value.
.
MessageId=5027 Severity=Warning  SymbolicName=EVENT_NDIS_LOBE_FAILUE_ERROR
Language=English
%2 : A Token Ring Lobe Wire Fault has occurred.  Verify cable
connections.  The adapter will continue to try to reinsert back
into the ring.
.
MessageId=5028 Severity=Warning  SymbolicName=EVENT_NDIS_SIGNAL_LOSS_ERROR
Language=English
%2 : The adapter had detected a loss of signal on the ring.  The adapter
will continue to try to reinsert back into the ring.
.
MessageId=5029 Severity=Warning  SymbolicName=EVENT_NDIS_REMOVE_RECEIVED_ERROR
Language=English
%2 : The adapter has received a request to deinsert from the
ring.  The adapter will continue to try to reinsert back into the ring.
.
MessageId=5030 Severity=Informational  SymbolicName=EVENT_NDIS_TOKEN_RING_CORRECTION
Language=English
%2 : The adapter has successfully reinserted back into the ring.
.
MessageId=5031 Severity=Error  SymbolicName=EVENT_NDIS_ADAPTER_CHECK_ERROR
Language=English
%2 : The adapter has detected an Adapter Check as a result of some
unrecoverable hardware of software error.  Please contact your service provider.
.
MessageId=5032 Severity=Warning  SymbolicName=EVENT_NDIS_RESET_FAILURE_ERROR
Language=English
%2 : The adapter failed to reset within a specified time.  The adapter will
continue to try to reset.  This could be the result of a hardware failure.
.
MessageId=5033 Severity=Warning  SymbolicName=EVENT_NDIS_CABLE_DISCONNECTED_ERROR
Language=English
%2 : The adapter has detected that the Token Ring cable is disconnected from
the adapter.  Please reconnect the Token Ring cable.  The adapter will continue
to try to reset until the connection is repaired.
.
MessageId=5034 Severity=Warning  SymbolicName=EVENT_NDIS_RESET_FAILURE_CORRECTION
Language=English
%2 : The adapter has successfully completed a previously failed reset.
.


;
;/////////////////////////////////////////////////////////////////////////
;//
;// General NT System Events
;//
;/////////////////////////////////////////////////////////////////////////
;

;//
;// Eventlog Events 6000 - 6099
;//

MessageId=6000  SymbolicName=EVENT_LOG_FULL
Language=English
The %1 log file is full.
.

MessageId=6001  SymbolicName=EVENT_LogFileNotOpened
Language=English
The %1 log file cannot be opened.
.

MessageId=6002  SymbolicName=EVENT_LogFileCorrupt
Language=English
The %1 log file is corrupted and will be cleared.
.

MessageId=6003  SymbolicName=EVENT_DefaultLogCorrupt
Language=English
The Application log file could not be opened.  %1 will be used as the default
log file.
.

MessageId=6004  SymbolicName=EVENT_BadDriverPacket
Language=English
A driver packet received from the I/O subsystem was invalid.  The data is the
packet.
.

MessageId=6005  SymbolicName=EVENT_EventlogStarted
Language=English
The Event log service was started.
.

MessageId=6006  SymbolicName=EVENT_EventlogStopped
Language=English
The Event log service was stopped.
.

MessageId=6007  SymbolicName=TITLE_EventlogMessageBox
Language=English
Eventlog Service %0
.

;//
;// System Events 6100 - 6199
;//

MessageId=6100  SymbolicName=EVENT_UP_DRIVER_ON_MP
Language=English
A uniprocessor-specific driver was loaded on a multiprocessor system.  The driver could not load.
.

;//
;// Service Controller Events 7000 - 7899
;//

MessageId=7000  SymbolicName=EVENT_SERVICE_START_FAILED
Language=English
The %1 service failed to start due to the following error: %n%2
.

MessageId=7001  SymbolicName=EVENT_SERVICE_START_FAILED_II
Language=English
The %1 service depends on the %2 service which failed to start because of the following error: %n%3
.

MessageId=7002  SymbolicName=EVENT_SERVICE_START_FAILED_GROUP
Language=English
The %1 service depends on the %2 group and no member of this group started.
.

MessageId=7003  SymbolicName=EVENT_SERVICE_START_FAILED_NONE
Language=English
The %1 service depends on the following nonexistent service: %2
.

MessageId=7005  SymbolicName=EVENT_CALL_TO_FUNCTION_FAILED
Language=English
The %1 call failed with the following error: %n%2
.

MessageId=7006  SymbolicName=EVENT_CALL_TO_FUNCTION_FAILED_II
Language=English
The %1 call failed for %2 with the following error: %n%3
.

MessageId=7007  SymbolicName=EVENT_REVERTED_TO_LASTKNOWNGOOD
Language=English
The system reverted to its last known good configuration.  The system is restarting....
.

MessageId=7008  SymbolicName=EVENT_BAD_ACCOUNT_NAME
Language=English
No backslash is in the account name.
.

MessageId=7009  SymbolicName=EVENT_CONNECTION_TIMEOUT
Language=English
Timeout (%1 milliseconds) waiting for service to connect.
.

MessageId=7010  SymbolicName=EVENT_READFILE_TIMEOUT
Language=English
Timeout (%1 milliseconds) waiting for ReadFile.
.

MessageId=7011  SymbolicName=EVENT_TRANSACT_TIMEOUT
Language=English
Timeout (%1 milliseconds) waiting for transaction response.
.

MessageId=7012  SymbolicName=EVENT_TRANSACT_INVALID
Language=English
Message returned in transaction has incorrect size.
.

MessageId=7013  SymbolicName=EVENT_FIRST_LOGON_FAILED
Language=English
Logon attempt with current password failed with the following error: %n%1
.

MessageId=7014  SymbolicName=EVENT_SECOND_LOGON_FAILED
Language=English
Second logon attempt with old password also failed with the following error: %n%1
.

MessageId=7015  SymbolicName=EVENT_INVALID_DRIVER_DEPENDENCY
Language=English
Boot-start or system-start driver (%1) must not depend on a service.
.

MessageId=7016  SymbolicName=EVENT_BAD_SERVICE_STATE
Language=English
The %1 service has reported an invalid current state %2.
.

MessageId=7017  SymbolicName=EVENT_CIRCULAR_DEPENDENCY_DEMAND
Language=English
Detected circular dependencies demand starting %1.
.

MessageId=7018  SymbolicName=EVENT_CIRCULAR_DEPENDENCY_AUTO
Language=English
Detected circular dependencies auto-starting services.
.

MessageId=7019  SymbolicName=EVENT_DEPEND_ON_LATER_SERVICE
Language=English
Circular dependency: The %1 service depends on a service in a group which starts later.
.

MessageId=7020  SymbolicName=EVENT_DEPEND_ON_LATER_GROUP
Language=English
Circular dependency: The %1 service depends on a group which starts later.
.

MessageId=7021  SymbolicName=EVENT_SEVERE_SERVICE_FAILED
Language=English
About to revert to the last known good configuration because the %1 service failed to start.
.

MessageId=7022  SymbolicName=EVENT_SERVICE_START_HUNG
Language=English
The %1 service hung on starting.
.

MessageId=7023  SymbolicName=EVENT_SERVICE_EXIT_FAILED
Language=English
The %1 service terminated with the following error: %n%2
.

MessageId=7024  SymbolicName=EVENT_SERVICE_EXIT_FAILED_SPECIFIC
Language=English
The %1 service terminated with service-specific error %2.
.

MessageId=7025  SymbolicName=EVENT_SERVICE_START_AT_BOOT_FAILED
Language=English
At least one service or driver failed during system startup.  Use Event Viewer to examine the event log for details.
.

MessageId=7026  SymbolicName=EVENT_BOOT_SYSTEM_DRIVERS_FAILED
Language=English
The following boot-start or system-start driver(s) failed to load: %1
.

MessageId=7027  SymbolicName=EVENT_RUNNING_LASTKNOWNGOOD
Language=English
Windows NT could not be started as configured.  A previous working configuration was used instead.
.

MessageId=7028  SymbolicName=EVENT_TAKE_OWNERSHIP
Language=English
The %1 Registry key denied access to SYSTEM account programs so the Service Control Manager took ownership of the Registry key.
.

;//
;// This Text is used as a title for the message box used to display
;// MessageId 7027.  It is not an event or error message.
;//
MessageId=7029  SymbolicName=TITLE_SC_MESSAGE_BOX
Language=English
Service Control Manager %0
.

MessageId=7030  SymbolicName=EVENT_SERVICE_NOT_INTERACTIVE
Language=English
The %1 service is marked as an interactive service.  However, the system is configured to not allow interactive services.  This service may not function properly.
.

;//
;// Schedule (AT command) Service Events 7900 - 7999
;//

MessageId=7900  SymbolicName=EVENT_COMMAND_NOT_INTERACTIVE
Language=English
The %1 command is marked as an interactive command.  However, the system is
configured to not allow interactive command execution.  This command may not
function properly.
.

MessageId=7901  SymbolicName=EVENT_COMMAND_START_FAILED
Language=English
The %1 command failed to start due to the following error: %n%2
.

;
;/////////////////////////////////////////////////////////////////////////
;//
;// Lanman Bowser/Browser Events (8000-8499)
;//
;//
;/////////////////////////////////////////////////////////////////////////
;
;

MessageId=8003 Severity=Error SymbolicName=EVENT_BOWSER_OTHER_MASTER_ON_NET
Language=English
The master browser has received a server announcement from the computer %2
that believes that it is the master browser for the domain on transport %3.
The master browser is stopping or an election is being forced.
.

MessageId=8004 Severity=Warning SymbolicName=EVENT_BOWSER_PROMOTED_WHILE_ALREADY_MASTER
Language=English
A request has been submitted to promote the computer to backup when it is already a
master browser.
.

MessageId=8005 Severity=Warning SymbolicName=EVENT_BOWSER_NON_MASTER_MASTER_ANNOUNCE
Language=English
The browser has received a server announcement indicating that the computer %2
is a master browser, but this computer is not a master browser.
.

MessageId=8006 Severity=Warning SymbolicName=EVENT_BOWSER_ILLEGAL_DATAGRAM
Language=English
The browser has received an illegal datagram from the remote computer %2 to name %3 on transport %4.  The data is the datagram.
.

MessageId=8007 Severity=Error SymbolicName=EVENT_BROWSER_STATUS_BITS_UPDATE_FAILED
Language=English
The browser was unable to update the service status bits.  The data is the error.
.

MessageId=8008 Severity=Error SymbolicName=EVENT_BROWSER_ROLE_CHANGE_FAILED
Language=English
The browser was unable to update its role.  The data is the error.
.

MessageId=8009 Severity=Error SymbolicName=EVENT_BROWSER_MASTER_PROMOTION_FAILED
Language=English
The browser was unable to promote itself to master browser.  The computer that currently
believes it is the master browser is %1.
.

MessageId=8010 Severity=Error SymbolicName=EVENT_BOWSER_NAME_CONVERSION_FAILED
Language=English
The browser driver was unable to convert a character string to a unicode string.
.

MessageId=8011 Severity=Error SymbolicName=EVENT_BROWSER_OTHERDOMAIN_ADD_FAILED
Language=English
The browser was unable to add the configuration parameter %1.
.

MessageId=8012 Severity=Success SymbolicName=EVENT_BOWSER_ELECTION_RECEIVED
Language=English
The browser driver has received an election packet from computer %2 on network %3.  The data is the packet received.
.

MessageId=8013 Severity=Informational SymbolicName=EVENT_BOWSER_ELECTION_SENT_GETBLIST_FAILED
Language=English
The browser driver has forced an election on network %2 because it was unable to find a master browser to retrieve a backup list on that network.
.

MessageId=8014 Severity=Informational SymbolicName=EVENT_BOWSER_ELECTION_SENT_FIND_MASTER_FAILED
Language=English
The browser driver has forced an election on network %2 because it was unable to find a master browser for that network.
.

MessageId=8015 Severity=Informational SymbolicName=EVENT_BROWSER_ELECTION_SENT_LANMAN_NT_STARTED
Language=English
The browser has forced an election on network %1 because a Windows NT Server (or domain master) browser is started.
.

MessageId=8016 Severity=Error SymbolicName=EVENT_BOWSER_ILLEGAL_DATAGRAM_THRESHOLD
Language=English
The browser driver has received too many illegal datagrams from the remote computer %2 to name %3 on transport %4.  The data is the datagram.
No more events will be generated until the reset frequency has expired.
.
MessageId=8017 Severity=Error SymbolicName=EVENT_BROWSER_DEPENDANT_SERVICE_FAILED
Language=English
The browser has failed to start because the dependent service %1 had invalid service status %2.
Status             Meaning
  1              Service Stopped%n
  2              Start Pending%n
  3              Stop Pending%n
  4              Running%n
  5              Continue Pending%n
  6              Pause Pending%n
  7              Paused%n
.
MessageId=8019 Severity=Error SymbolicName=EVENT_BROWSER_MASTER_PROMOTION_FAILED_STOPPING
Language=English
The browser was unable to promote itself to master browser.  The browser will continue
to attempt to promote itself to the master browser, but will no longer log any events in the event log in Event Viewer.
.
MessageId=8020 Severity=Error SymbolicName=EVENT_BROWSER_MASTER_PROMOTION_FAILED_NO_MASTER
Language=English
The browser was unable to promote itself to master browser.  The computer that currently
believes it is the master browser is unknown.
.
MessageId=8021 Severity=Warning SymbolicName=EVENT_BROWSER_SERVER_LIST_FAILED
Language=English
The browser was unable to retrieve a list of servers from the browser master %1 on the network %2.
The data is the error code.
.
MessageId=8022 Severity=Warning SymbolicName=EVENT_BROWSER_DOMAIN_LIST_FAILED
Language=English
The browser was unable to retrieve a list of domains from the browser master %1 on the network %2.
The data is the error code.
.
MessageId=8023 Severity=Warning SymbolicName=EVENT_BROWSER_ILLEGAL_CONFIG
Language=English
The value for the parameter %1 to the browser service was illegal.
.
MessageId=8024 Severity=Informational SymbolicName=EVENT_BOWSER_OLD_BACKUP_FOUND
Language=English
The backup browser server %2 is out-of-date.  Consider upgrading this computer.
.
MessageId=8025 Severity=Success SymbolicName=EVENT_BROWSER_SERVER_LIST_RETRIEVED
Language=English
The browser has retrieved a list of servers from remote computer %1 on transport %2.%n
There were %3 entries read, and %4 total entries.
.
MessageId=8026 Severity=Success SymbolicName=EVENT_BROWSER_DOMAIN_LIST_RETRIEVED
Language=English
The browser has retrieved a list of domains from remote computer %1 on transport %2.%n
There were %3 entries read, and %4 total entries.
.
MessageId=8027 Severity=Informational SymbolicName=EVENT_BOWSER_PDC_LOST_ELECTION
Language=English
The browser running on the Domain Controller has lost an election.  The computer that won the election is %2, on the transport %3.%n
The data contains the election version, election criteria, and remote computer time up, and the same information for
the current computer.
.

MessageId=8028 Severity=Informational SymbolicName=EVENT_BOWSER_NON_PDC_WON_ELECTION
Language=English
The browser running on this computer has won a browser election on network %2.
This computer is a member of a domain, so the Domain Controller should become the master
browser.
.
MessageId=8029  SymbolicName=EVENT_BOWSER_CANT_READ_REGISTRY
Language=English
The browser driver was unable to initialize variables from the Registry.
.

MessageId=8030  SymbolicName=EVENT_BOWSER_MAILSLOT_DATAGRAM_THRESHOLD_EXCEEDED
Language=English
The browser driver has discarded too many mailslot messages.
.
MessageId=8031  SymbolicName=EVENT_BOWSER_GETBROWSERLIST_THRESHOLD_EXCEEDED
Language=English
The browser driver has discarded too many GetBrowserServerList requests.
.

MessageId=8032  Severity=Error SymbolicName=EVENT_BROWSER_BACKUP_STOPPED
Language=English
The browser service has failed to retrieve the backup list too many times on transport %1.
The backup browser is stopping.
.
MessageId=8033 Severity=Informational SymbolicName=EVENT_BROWSER_ELECTION_SENT_LANMAN_NT_STOPPED
Language=English
The browser has forced an election on network %1 because a master browser was stopped.
.

MessageId=8034 Severity=Error SymbolicName=EVENT_BROWSER_GETBLIST_RECEIVED_NOT_MASTER
Language=English
The browser has received a GetBrowserServerList request when it is not the master browser.
.

MessageId=8035 Severity=Informational SymbolicName=EVENT_BROWSER_ELECTION_SENT_ROLE_CHANGED
Language=English
The browser has forced an election on network %1 because the Domain Controller (or Server) has changed its role
.

MessageId=8036 Severity=Error SymbolicName=EVENT_BROWSER_NOT_STARTED_IPX_CONFIG_MISMATCH
Language=English
The browser has failed to start because of an error in the DirectHostBinding parameter to the browser.
.

;
;/////////////////////////////////////////////////////////////////////////
;//
;// Sap Agent Events (8500-8999)
;//
;//
;/////////////////////////////////////////////////////////////////////////
;
;

MessageId=8500 Severity=Error SymbolicName=NWSAP_EVENT_KEY_NOT_FOUND
Language=English
The Registry Key %1 was not present.  The Sap Agent could not start.
.

MessageId=8501 Severity=Error SymbolicName=NWSAP_EVENT_WSASTARTUP_FAILED
Language=English
Winsock startup routine failed.  The Sap Agent cannot continue.
.

MessageId=8502 Severity=Error SymbolicName=NWSAP_EVENT_SOCKET_FAILED
Language=English
Socket create call failed for main socket. The Sap Agent cannot continue.
.

MessageId=8503 Severity=Error SymbolicName=NWSAP_EVENT_SETOPTBCAST_FAILED
Language=English
Setting broadcast option on socket failed.  The Sap Agent cannot continue.
.

MessageId=8504 Severity=Error SymbolicName=NWSAP_EVENT_BIND_FAILED
Language=English
Binding to SAP Socket failed.  The Sap Agent cannot continue.
.

MessageId=8505 Severity=Error SymbolicName=NWSAP_EVENT_GETSOCKNAME_FAILED
Language=English
Getting bound address of socket failed.  The Sap Agent cannot continue.
.

MessageId=8506 Severity=Error SymbolicName=NWSAP_EVENT_OPTEXTENDEDADDR_FAILED
Language=English
Setting option EXTENDED_ADDRESS failed.  The Sap Agent cannot continue.
.

MessageId=8507 Severity=Error SymbolicName=NWSAP_EVENT_OPTBCASTINADDR_FAILED
Language=English
Setting NWLink option BCASTINTADDR failed.  The Sap Agent cannot continue.
.

MessageId=8508 Severity=Error SymbolicName=NWSAP_EVENT_CARDMALLOC_FAILED
Language=English
Error allocating memory to hold a card structure.  The Sap Agent cannot continue.
.

MessageId=8509 Severity=Error SymbolicName=NWSAP_EVENT_NOCARDS
Language=English
Enumeration of cards returned 0 cards.
.

MessageId=8510 Severity=Error SymbolicName=NWSAP_EVENT_THREADEVENT_FAIL
Language=English
Error creating thread counting event.  The Sap Agent cannot continue.
.

MessageId=8511 Severity=Error SymbolicName=NWSAP_EVENT_RECVSEM_FAIL
Language=English
Error creating receive semaphore.  The Sap Agent cannot continue.
.

MessageId=8512 Severity=Error SymbolicName=NWSAP_EVENT_SENDEVENT_FAIL
Language=English
Error creating send event.  The Sap Agent cannot continue.
.

MessageId=8513 Severity=Error SymbolicName=NWSAP_EVENT_STARTRECEIVE_ERROR
Language=English
Error starting receive thread.  The Sap Agent cannot continue.
.

MessageId=8514 Severity=Error SymbolicName=NWSAP_EVENT_STARTWORKER_ERROR
Language=English
Error starting worker thread.  The Sap Agent cannot continue.
.

MessageId=8515 Severity=Error SymbolicName=NWSAP_EVENT_TABLE_MALLOC_FAILED
Language=English
Error allocating database array.  The Sap Agent cannot continue.
.

MessageId=8516 Severity=Error SymbolicName=NWSAP_EVENT_HASHTABLE_MALLOC_FAILED
Language=English
Error allocating hash table.  The Sap Agent cannot continue.
.

MessageId=8517 Severity=Error SymbolicName=NWSAP_EVENT_STARTLPCWORKER_ERROR
Language=English
Error starting LPC worker thread.  The Sap Agent cannot continue.
.

MessageId=8518 Severity=Error SymbolicName=NWSAP_EVENT_CREATELPCPORT_ERROR
Language=English
Error creating the LPC port.  The Sap Agent cannot continue.
.

MessageId=8519 Severity=Error SymbolicName=NWSAP_EVENT_CREATELPCEVENT_ERROR
Language=English
Error creating the LPC thread event.  The Sap Agent cannot continue.
.

MessageId=8520 Severity=Error SymbolicName=NWSAP_EVENT_LPCLISTENMEMORY_ERROR
Language=English
Error allocating memory for an LPC Client structure.  The Sap Agent cannot continue.
.

MessageId=8521 Severity=Error SymbolicName=NWSAP_EVENT_LPCHANDLEMEMORY_ERROR
Language=English
Error allocating buffer to hold LPC worker thread handles.  The Sap Agent cannot continue.
.

MessageId=8522 Severity=Error SymbolicName=NWSAP_EVENT_BADWANFILTER_VALUE
Language=English
The value for WANFilter in the registry must be 0-2.  The Sap Agent cannot continue.
.

MessageId=8523 Severity=Error SymbolicName=NWSAP_EVENT_CARDLISTEVENT_FAIL
Language=English
Error creating event for card list access synchronization.  The Sap Agent cannot continue.
.

MessageId=8524 Severity=Error SymbolicName=NWSAP_EVENT_SDMDEVENT_FAIL
Language=English
Error creating event for database access synchronization.  The Sap Agent cannot continue.
.

MessageId=8525 Severity=Warning SymbolicName=NWSAP_EVENT_INVALID_FILTERNAME
Language=English
Name too long in key %1: Name = %s.  The Sap Agent cannot continue.
.

MessageId=8526 Severity=Error SymbolicName=NWSAP_EVENT_WANSEM_FAIL
Language=English
Error creating WAN control semaphore.  The Sap Agent cannot continue.
.

MessageId=8527 Severity=Error SymbolicName=NWSAP_EVENT_WANSOCKET_FAILED
Language=English
Socket create call failed for WAN socket.  The Sap Agent cannot continue.
.

MessageId=8528 Severity=Error SymbolicName=NWSAP_EVENT_WANBIND_FAILED
Language=English
Binding to WAN socket failed.  The Sap Agent cannot continue.
.

MessageId=8529 Severity=Error SymbolicName=NWSAP_EVENT_STARTWANWORKER_ERROR
Language=English
Error starting WAN worker thread.  The Sap Agent cannot continue.
.

MessageId=8530 Severity=Error SymbolicName=NWSAP_EVENT_STARTWANCHECK_ERROR
Language=English
Error starting WAN check thread.  The Sap Agent cannot continue.
.

MessageId=8531 Severity=Error SymbolicName=NWSAP_EVENT_OPTMAXADAPTERNUM_ERROR
Language=English
Error on getsockopt IPX_MAX_ADAPTER_NUM.  Data is the error code.  The Sap Agent cannot continue.
.

MessageId=8532 Severity=Error SymbolicName=NWSAP_EVENT_WANHANDLEMEMORY_ERROR
Language=English
Error allocating buffer to hold WAN notify thread handles.  The Sap Agent cannot continue.
.

MessageId=8533 Severity=Error SymbolicName=NWSAP_EVENT_WANEVENT_ERROR
Language=English
Error creating the WAN thread event.  The Sap Agent cannot continue.
.

;
;/////////////////////////////////////////////////////////////////////////
;//
;// Transport Events (9000-9499)
;//
;//
;/////////////////////////////////////////////////////////////////////////
;
;

MessageId=9001 Severity=Warning  SymbolicName=EVENT_TRANSPORT_RESOURCE_POOL
Language=English
%2 could not allocate a resource of type %3 due to system resource problems.
.

MessageId=9002 Severity=Warning  SymbolicName=EVENT_TRANSPORT_RESOURCE_LIMIT
Language=English
%2 could not allocate a resource of type %3 due to its configured size of %4.
.

MessageId=9003 Severity=Warning  SymbolicName=EVENT_TRANSPORT_RESOURCE_SPECIFIC
Language=English
%2 could not allocate a resource of type %3 due to a specifically configured limit of %4.
.

MessageId=9004 Severity=Error  SymbolicName=EVENT_TRANSPORT_REGISTER_FAILED
Language=English
%2 failed to register itself with the NDIS wrapper.
.

MessageId=9005 Severity=Error  SymbolicName=EVENT_TRANSPORT_BINDING_FAILED
Language=English
%2 failed to bind to adapter %3.
.

MessageId=9006 Severity=Error  SymbolicName=EVENT_TRANSPORT_ADAPTER_NOT_FOUND
Language=English
%2 could not find adapter %3.
.

MessageId=9007 Severity=Error  SymbolicName=EVENT_TRANSPORT_SET_OID_FAILED
Language=English
%2 failed while setting OID %3 on adapter %4.
.

MessageId=9008 Severity=Error  SymbolicName=EVENT_TRANSPORT_QUERY_OID_FAILED
Language=English
%2 failed while querying OID %3 on adapter %4.
.

MessageId=9009 Severity=Informational  SymbolicName=EVENT_TRANSPORT_TRANSFER_DATA
Language=English
%2 could not transfer a packet from the adapter.  The packet was dropped.
.

MessageId=9010 Severity=Informational  SymbolicName=EVENT_TRANSPORT_TOO_MANY_LINKS
Language=English
%2 could not create a link to a remote computer.  Your computer has exceeded the number of connections it can make to that remote computer.
.

MessageId=9011 Severity=Informational  SymbolicName=EVENT_TRANSPORT_BAD_PROTOCOL
Language=English
%2 received an unexpected %3 packet from a remote computer.
.

;
;/////////////////////////////////////////////////////////////////////////
;//
;// IPX/SPX Events (9500-9999)
;//
;//
;/////////////////////////////////////////////////////////////////////////
;
;

MessageId=9501 Severity=Informational  SymbolicName=EVENT_IPX_NEW_DEFAULT_TYPE
Language=English
The default frame type for auto-detection on %2 was changed to %3.
This type is now the default if no frame type can be detected.
.

MessageId=9502 Severity=Warning  SymbolicName=EVENT_IPX_SAP_ANNOUNCE
Language=English
A SAP announcement was sent over %2 which is configured for multiple
networks, but no internal network is configured. This may prevent
machines on some networks from locating the advertised service.
.

MessageId=9503 Severity=Warning SymbolicName=EVENT_IPX_ILLEGAL_CONFIG
Language=English
The value for the %2 parameter %3 was illegal.
.

MessageId=9504 Severity=Error  SymbolicName=EVENT_IPX_INTERNAL_NET_INVALID
Language=English
%2 was configured with an internal network number of %3. This network
number conflicts with one of the attached networks. The configured
internal network number will be ignored.
.

MessageId=9505 Severity=Error SymbolicName=EVENT_IPX_NO_FRAME_TYPES
Language=English
%2 had no frame types configured for the binding to adapter %3.
.

MessageId=9506 Severity=Error SymbolicName=EVENT_IPX_CREATE_DEVICE
Language=English
%2 failed to initialize because the driver device could not be created.
.

MessageId=9507 Severity=Error SymbolicName=EVENT_IPX_NO_ADAPTERS
Language=English
%2 could not bind to any adapters. The transport could not start.
.


;
;/////////////////////////////////////////////////////////////////////////
;//
;// DCOM Events (10000-10999)
;//
;//
;/////////////////////////////////////////////////////////////////////////
;
;

MessageId=10000 Severity=Error SymbolicName=EVENT_RPCSS_CREATEPROCESS_FAILURE
Language=English
Unable to start a DCOM Server: %3.
The error:%n"%%%2"%nHappened while starting this command:%n%1
.

MessageId=10001 Severity=Error SymbolicName=EVENT_RPCSS_RUNAS_CREATEPROCESS_FAILURE
Language=English
Unable to start a DCOM Server: %3 as %4/%5.
The error:%n"%%%2"%nHappened while starting this command:%n%1
.

MessageId=10002 Severity=Error SymbolicName=EVENT_RPCSS_LAUNCH_ACCESS_DENIED
Language=English
Access denied attempting to launch a DCOM Server.
The server is:%n%1
.

MessageId=10003 Severity=Error SymbolicName=EVENT_RPCSS_DEFAULT_LAUNCH_ACCESS_DENIED
Language=English
Access denied attempting to launch a DCOM Server using DefaultLaunchPermssion.
The server is:%n%1
.

MessageId=10004 Severity=Error SymbolicName=EVENT_RPCSS_RUNAS_CANT_LOGIN
Language=English
DCOM got error "%%%1" and was unable to logon %2\%3
in order to run the server:%n%4
.

MessageId=10005 Severity=Error SymbolicName=EVENT_RPCSS_START_SERVICE_FAILURE
Language=English
DCOM got error "%%%1" attempting to start the service %2 with arguments "%3"
in order to run the server:%n%4
.

MessageId=10006 Severity=Error SymbolicName=EVENT_RPCSS_REMOTE_SIDE_ERROR
Language=English
DCOM got error "%%%1" from the computer %2 when attempting to
activate the server:%n%3
.

MessageId=10007 Severity=Error SymbolicName=EVENT_RPCSS_ACTIVATION_ERROR
Language=English
DCOM got error "%%%1" when attempting to
activate the server:%n%2
.

MessageId=10008 Severity=Error SymbolicName=EVENT_RPCSS_REMOTE_SIDE_ERROR_WITH_FILE
Language=English
DCOM got error "%%%1" from the computer %2 when attempting to
the server:%n%3 with file %4.
.

MessageId=10009 Severity=Error SymbolicName=EVENT_RPCSS_REMOTE_SIDE_UNAVAILABLE
Language=English
DCOM was unable to communicate with the computer %1 using any of the configured
protocols.
.

MessageId=10010 Severity=Error SymbolicName=EVENT_RPCSS_SERVER_START_TIMEOUT
Language=English
The server %1 did not register with DCOM within the required timeout.
.

MessageId=10011 Severity=Error SymbolicName=EVENT_RPCSS_SERVER_NOT_RESPONDING
Language=English
The server %1 could not be contacted to establish the connection to the client
.

;
;#endif // _NETEVENT
;
