/*++

Copyright (c) 1992-1993  Microsoft Corporation

Module Name:

    ReplConf.h

Abstract:

    This file contains structures, function prototypes, and definitions
    for the replicator "config API" workers.

Author:

    John Rogers (JohnRo) 15-Jan-1992

Environment:

    User Mode - Win32
    Portable to any flat, 32-bit environment.  (Uses Win32 typedefs.)
    Requires ANSI C extensions: slash-slash comments, long external names.

Notes:

    You must include LmCons.h before this file.

Revision History:

    15-Jan-1992 JohnRo
        Created.
    20-Jan-1992 JohnRo
        Netr prototypes are now generated by MIDL and put in repl.h.
    23-Jan-1992 JohnRo
        Added ReplConfigIsLevelValid() and some prototypes.
    13-Feb-1992 JohnRo
        Added ReplConfigIsApiRecordValid().
        Added ReplConfigReportBadParmValue().
        Clarify that certain functions can be called if service is not started.
    11-Mar-1992 JohnRo
        Added support for setinfo info levels in ReplConfigIsLevelValid().
    24-Mar-1992 JohnRo
        Renamed many ReplGlobal vars to ReplConfig vars.
    20-Jul-1992 JohnRo
        RAID 2252: repl should prevent export on Windows/NT.
    14-Aug-1992 JohnRo
        RAID 3601: repl APIs should checked import & export lists.
    01-Dec-1992 JohnRo
        RAID 3844: remote NetReplSetInfo uses local machine type.
    05-Jan-1993 JohnRo
        Repl WAN support (get rid of repl name list limits).
        Made changes suggested by PC-LINT 5.0

--*/


#ifndef _REPLCONF_
#define _REPLCONF_


#include <netlib.h>     // IN_RANGE().


BOOL
ReplConfigIsApiRecordValid (
    IN DWORD Level,
    IN LPVOID ApiRecord,
    OUT LPDWORD ParmError OPTIONAL
    );

// BOOL
// ReplConfigIsLevelValid(
//     IN DWORD Level,          // Info level
//     IN BOOL SetInfo          // Are setinfo levels allowed?
//     );
//
#define ReplConfigIsLevelValid(Level,SetInfo) \
    ( \
        /*lint -e506 */  /* don't complain about constant values here */ \
        ( (Level) == 0 ) \
          || ( (SetInfo) && (IN_RANGE((Level), 1000, 1003)) ) \
        /*lint +e506 */ \
    )


// Indicates whether or not the syntax of a list (export or import) is
// valid.  Does no checking for the existence of items in the list.
// Callable whether or not service is started.
BOOL
ReplConfigIsListValid(
    IN LPTSTR List OPTIONAL
    );


// Indicates whether the given role is allowed based on the current product
// type.  Callable whether or not service is started.
BOOL
ReplConfigIsRoleAllowed(
    IN LPTSTR UncServerName OPTIONAL,
    IN DWORD Role
    );

// Callable whether or not service is started.
NET_API_STATUS
ReplConfigAllocAndBuildApiRecord (
    IN DWORD Level,
    IN DWORD Role,
    IN LPTSTR ExportPath OPTIONAL,
    IN LPTSTR ExportList OPTIONAL,
    IN LPTSTR ImportPath OPTIONAL,
    IN LPTSTR ImportList OPTIONAL,
    IN LPTSTR LogonUserName OPTIONAL,
    IN DWORD Interval,
    IN DWORD Pulse,
    IN DWORD GuardTime,
    IN DWORD Random,
    OUT LPBYTE * BufPtr                 // Alloc and set pointer.
    );


// Callable whether or not service is started.
NET_API_STATUS
ReplConfigRead(
    IN LPTSTR UncServerName OPTIONAL,
    OUT LPDWORD Role,
    OUT LPTSTR ExportPath,
    OUT LPTSTR *ExportList,             // Alloc and set pointer.
    OUT LPTSTR ImportPath,
    OUT LPTSTR *ImportList,             // Alloc and set pointer.
    OUT LPTSTR LogonUserName,
    OUT LPDWORD Interval,
    OUT LPDWORD Pulse,
    OUT LPDWORD GuardTime,
    OUT LPDWORD Random
    );

// Routine to report a bad parm value.
// There are two different versions of this routine,
// in client/report.c and server/error.c
// client/report.c is callable whether or not service is started.
// server/error.c only runs when service is starting; it talks to the service
// controller.
VOID
ReplConfigReportBadParmValue(
    IN LPTSTR UncServerName OPTIONAL,
    IN LPTSTR SwitchName,
    IN LPTSTR TheValue OPTIONAL
    );

// Callable whether or not service is started.
NET_API_STATUS
ReplConfigWrite(
    IN LPTSTR UncServerName OPTIONAL,
    IN DWORD Role,
    IN LPTSTR ExportPath OPTIONAL,
    IN LPTSTR ExportList OPTIONAL,
    IN LPTSTR ImportPath OPTIONAL,
    IN LPTSTR ImportList OPTIONAL,
    IN LPTSTR LogonUserName OPTIONAL,
    IN DWORD Interval,
    IN DWORD Pulse,
    IN DWORD GuardTime,
    IN DWORD Random
    );


#endif // _REPLCONF_
