;/*++ BUILD Version: 0001    // Increment this if a change has global effects

;Copyright (c) 1994  Microsoft Corporation
;
;Module Name:
;
;    dhcpmsg.h
;
;Abstract:
;
;    Definitions for DHCP messages.
;
;Author:
;
;    Manny Weiser 8-Dec-1992
;
;Revision History:
;
;Notes:
;
;    This file is generated by the MC tool from the dhcpmsg.mc file.
;
;--*/

;#ifndef _DHCPMESSAGE_
;#define _DHCPMESSAGE_

;//
;//  1000 - 1099   Reserved for DHCP client events.
;//
;//
;//  Values are 32 bit values layed out as follows:
;//
;//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
;//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
;//  +---+-+-+-----------------------+-------------------------------+
;//  |Sev|C|R|     Facility          |               Code            |
;//  +---+-+-+-----------------------+-------------------------------+
;//
;//  where
;//
;//      Sev - is the severity code
;//
;//          00 - Success
;//          01 - Informational
;//          10 - Warning
;//          11 - Error
;//
;//      C - is the Customer code flag
;//
;//      R - is a reserved bit
;//
;//      Facility - is the facility code
;//
;//      Code - is the facility's status code
;//
;//
;// Define the facility codes
;//


;//
;// Define the severity codes
;//


;//
;// MessageId: EVENT_FAILED_TO_INITIALIZE
;//
;// MessageText:
;//
;//  Failed to initialize the card with network address %1.
;//
EVENT_FAILED_TO_INITIALIZE       EQU    1000

;//
;// MessageId: EVENT_LEASE_TERMINATED
;//
;// MessageText:
;//
;//  DHCP is unable to renew a lease for the card with network address %1.
;//  The lease for IP address %2 has been terminated.
;//
EVENT_LEASE_TERMINATED           EQU    1001

;//
;// MessageId: EVENT_UNKNOWN_DHCP_OPTION
;//
;// MessageText:
;//
;//  DHCP received an unknown option %1 of length %2. The raw option data is
;//  given below.
;//
EVENT_UNKNOWN_DHCP_OPTION        EQU    1002

;//
;// MessageId: EVENT_FAILED_TO_OBTAIN_LEASE
;//
;// MessageText:
;//
;//  DHCP failed to obtain a lease for the card with network address %1.
;//  The following error occurred : %n%2
;//
EVENT_FAILED_TO_OBTAIN_LEASE     EQU    1003

;//
;// MessageId: EVENT_NACK_LEASE
;//
;// MessageText:
;//
;//  DHCP IP address lease %1 for the card with network address %2 has been
;//  denied.
;//
EVENT_NACK_LEASE                 EQU    1004

;//
;// MessageId: EVENT_FAILED_TO_RENEW
;//
;// MessageText:
;//
;//  DHCP failed to renew a lease for the card with network address %1. The
;//  following error occurred : %n%2
;//
EVENT_FAILED_TO_RENEW            EQU    1005

;//
;// MessageId: EVENT_DHCP_SHUTDOWN
;//
;// MessageText:
;//
;//  DHCP service is shutting down. The following error occurred : %n%1
;//
EVENT_DHCP_SHUTDOWN              EQU    1006

;//
;// MessageId: EVENT_FAILED_TO_OBTAIN_LEASE_MULTI_HOME
;//
;// MessageText:
;//
;//  DHCP failed to obtain a lease for the card with network address %1.
;//  On multi-homed machine all subsequent adapters will also fail to obtain
;//  lease. The following error occurred : %n%2
;//
EVENT_FAILED_TO_OBTAIN_LEASE_MULTI_HOME EQU     1007

;//
;// 1100 - 1199   Reserved for User messages
;//
;//
;// MessageId: MESSAGE_FAILED_TO_INITIALIZE
;//
;// MessageText:
;//
;//  The DHCP client could not obtain an IP address.
;//
;//  If you want to see DHCP messages in the future, choose YES. If you do not want to see DHCP messages choose NO.
;//
MESSAGE_FAILED_TO_INITIALIZE     EQU    1100

;//
;// MessageId: MESSAGE_LEASE_TERMINATED
;//
;// MessageText:
;//
;//  The DHCP client lost the lease of the IP Address %1. The network is brought down.
;//
;//  If you want to see DHCP messages in the future, choose YES. Otherwise choose NO.
;//
MESSAGE_LEASE_TERMINATED         EQU    1101

;//
;// MessageId: MESSAGE_FAILED_TO_OBTAIN_LEASE
;//
;// MessageText:
;//
;//  The DHCP client could not obtain an IP address.
;//
;//  If you want to see DHCP messages in the future, choose YES. Otherwise choose NO.
;//
MESSAGE_FAILED_TO_OBTAIN_LEASE   EQU    1102

;//
;// MessageId: MESSAGE_FAILED_TO_RENEW_LEASE
;//
;// MessageText:
;//
;//  The DHCP client could not renew the lease of the IP Address %1. Your lease is valid until %2. DHCP will try to renew the lease before it expires.
;//
;//  If you want to see DHCP messages in the future, choose YES. Otherwise choose NO.
;//
MESSAGE_FAILED_TO_RENEW_LEASE    EQU    1103

;//
;// MessageId: MESSAGE_SUCCESSFUL_LEASE
;//
;// MessageText:
;//
;//  The DHCP client successfully leased the IP address %1. Your lease is valid until %2.
;//
;//  If you want to see DHCP messages in the future, choose YES. Otherwise choose NO.
;//
MESSAGE_SUCCESSFUL_LEASE         EQU    1104

;//
;// MessageId: MESSAGE_SUCCESSFUL_RENEW
;//
;// MessageText:
;//
;//  The DHCP client successfully renewed the IP address %1. Your lease is valid until %2.
;//
;//  If you want to see DHCP messages in the future, choose YES. Otherwise choose NO.
;//
MESSAGE_SUCCESSFUL_RENEW         EQU    1105

;//
;// MessageId: MESSAGE_POPUP_TITLE
;//
;// MessageText:
;//
;//  DHCP Client%0
;//
MESSAGE_POPUP_TITLE             EQU    1106
MESSAGE_ADDRESS_CONFLICT	EQU	1107



;#endif // _DHCPMESSAGE_
