/************************************************************/
/* Windows Write, Copyright 1985-1992 Microsoft Corporation */
/************************************************************/

/*  Include file with headers for functions in DOSLIB.ASM */

typedef unsigned DOSHND;        /* DOS handle */
typedef DOSHND typeOSFN;        /* General WRITE type for OS file handle */
struct TIM {                    /* Time structure returned by OsTime */
    CHAR minutes, hour, hsec, sec;
    };

int CchCurSzPath( CHAR *, CHAR );

#ifdef ENABLE   /* We are not currently using these */
int FFirst( CHAR near *, PSTR, int );
int FNext( CHAR near * );
DOSHND  WOpenSzFfname( CHAR *, int );
#endif

WORD    DaGetFileModeSz(CHAR *);
void    OsTime( struct TIM * );     /* NOTE: function moved to lib.asm */
DOSHND  WCreateNewSzFfname( CHAR *, int );
DOSHND  WCreateSzFfname( CHAR *, int );
int     CchReadDoshnd( DOSHND, CHAR FAR *, int );
int     CchWriteDoshnd( DOSHND, CHAR FAR *, int );
int     FCloseDoshnd( DOSHND );
WORD    WDosVersion( void );
int     DosxError( void );
long    DwSeekDw( DOSHND, long, int );
int     FpeDeleteSzFfname( CHAR * );
int     FpeRenameSzFfname( CHAR *, CHAR * );


#define DA_NORMAL       0x00    /* DOS File Attribute */
#define DA_READONLY     0x01    /* DOS File Attribute for read-only file */
#define DA_NIL          0xFFFF  /* Error DA */
#define dosxSharing     32      /* Extended error code for sharing viol. */
#define nErrNoAcc       5       /* OpenFile error code for Access Denied */
#define nErrFnf         2       /* OpenFile error code for File Not Found */
#define bSHARE_DENYRDWR 0x10    /* Sharing Open mode for exclusive use */

/* Error condition returned by "CCH" returning DOS functions, e.g. read */

#define FIsErrCchDisk(cch)   ((int)(cch) < 0)

#define cchDiskHardError    -1      /* Bogus error code, not returned by DOS */
#define fpeHardError        -1      /* also */

/* Error condition returned by functions that return DOS handles */

#define FIsErrDoshnd(doshnd)        ((int)(doshnd) < 0)

/* DOS Error codes */
/* These are the negative of the codes returned in AX by DOS functions */
#define fpeFnfError      -2      /* File Not Found */
#define fpeBadPathError  -3      /* Bad Path (path not found) */
#define fpeNoHndError    -4      /* No Handles Available */
#define fpeNoAccError    -5      /* Access Denied */
#define fpeBadHndError   -6      /* Bad handle passed in */
#define fpeNoDriveError  -15     /* Non-existent drive passed in */
#define fpeExistError    -80     /* File exists */

/* Seek-from type codes passed to DOS function 42H */

#define SF_BEGINNING    0       /* Seek from beginning of file */
#define SF_CURRENT      1       /* Seek from current file pointer */
#define SF_END          2       /* Seek from end of file */

/* Error test for seek position */

#define FIsErrDwSeek(dw)    ((long)(dw) < (long)0)

/* Error test for fpe-returning functions */

#define FIsErrFpe(fpe)     ((int)(fpe) < 0)

/* Tests whether an error is a hardware error.  Hardware errors are caught
   and prompted for by Windows, so we should not duplicate those prompts.
   Chrisp says these DOS 3.0 error codes are generated by Windows for all
   supported versions of DOS
   fpe is WRITE's error type; ofe is the unadulturated error returned by
   DOS or OpenFile */

#define ofeCaughtFirst      19
#define ofeCaughtLast       27

#define FIsCaughtOfe(ofe)   (((ofe)>=ofeCaughtFirst)&&((ofe)<=ofeCaughtLast))
#define FIsCaughtFpe(fpe)   FIsCaughtOfe(-(fpe))
#define FIsCaughtDwSeekErr(dw)  FIsCaughtFpe((int)(dw))

#define FpeFromCchDisk(cch) (cch)

#define fpeNoErr            0
