#ifndef _Bpi_c_h
#define _Bpi_c_h
enum BpiInstruction
{
	BpiStart = 0,
	BpiImmediate = 1,
	BpiNeedsAL = 2,
	BpiNeedsAX = 3,
	BpiNeedsEAX = 4,
	BpiNeedsBL = 5,
	BpiNeedsBX = 6,
	BpiNeedsEBX = 7,
	BpiNeedsCL = 8,
	BpiNeedsCX = 9,
	BpiNeedsECX = 10,
	BpiNeedsDL = 11,
	BpiNeedsDX = 12,
	BpiNeedsEDX = 13,
	BpiNeedsBP = 14,
	BpiNeedsEBP = 15,
	BpiNeedsSP = 16,
	BpiNeedsESP = 17,
	BpiNeedsSI = 18,
	BpiNeedsESI = 19,
	BpiNeedsDI = 20,
	BpiNeedsEDI = 21,
	BpiNeedsEFLAGS = 22,
	BpiGeneric = 23,
	BpiAdd = 24,
	BpiSub = 25,
	BpiAnd = 26,
	BpiOr = 27,
	BpiXor = 28,
	BpiLshift = 29,
	BpiRshift = 30,
	BpiTestEQ = 31,
	BpiTestNE = 32,
	BpiTestGE = 33,
	BpiTestLE = 34,
	BpiTestGT = 35,
	BpiTestLT = 36,
	BpiGet = 37,
	BpiSwap = 38,
	BpiGetAL = 39,
	BpiGetAX = 40,
	BpiGetEAX = 41,
	BpiGetBL = 42,
	BpiGetBX = 43,
	BpiGetEBX = 44,
	BpiGetCL = 45,
	BpiGetCX = 46,
	BpiGetECX = 47,
	BpiGetDL = 48,
	BpiGetDX = 49,
	BpiGetEDX = 50,
	BpiGetBP = 51,
	BpiGetEBP = 52,
	BpiGetSP = 53,
	BpiGetESP = 54,
	BpiGetSI = 55,
	BpiGetESI = 56,
	BpiGetDI = 57,
	BpiGetEDI = 58,
	BpiGetEIP = 59,
	BpiGetEFLAGS = 60,
	BpiGetCSbase = 61,
	BpiGetCSsel = 62,
	BpiGetDSbase = 63,
	BpiGetDSsel = 64,
	BpiGetESbase = 65,
	BpiGetESsel = 66,
	BpiGetFSbase = 67,
	BpiGetFSsel = 68,
	BpiGetGSbase = 69,
	BpiGetGSsel = 70,
	BpiGetSSbase = 71,
	BpiGetSSsel = 72,
	BpiGetFragment = 73,
	BpiPrefixKnown = 74,
	BpiPrefixWork = 75,
	BpiPrefixLabel = 76,
	BpiReadHostLs8 = 77,
	BpiReadHostLs16 = 78,
	BpiReadHostLs32 = 79,
	BpiReadHostLsHbit = 80,
	BpiReadCpuLs8 = 81,
	BpiReadCpuLs16 = 82,
	BpiReadCpuLs32 = 83,
	BpiLabel = 84,
	BpiStore = 85,
	BpiCallC = 86,
	BpiCall = 87,
	BpiIfBranch = 88,
	BpiElseBranch = 89,
	BpiIfGoto = 90,
	BpiElseGoto = 91,
	BpiIfReturn = 92,
	BpiElseReturn = 93,
	BpiIfSad = 94,
	BpiElseSad = 95,
	BpiSad = 96,
	BpiReturn = 97,
	BpiCheckI = 98,
	BpiGoto = 99,
	BpiGetUNIV = 100,
	BpiLastEntry = 101
};
#endif /* ! _Bpi_c_h */
