/*[
*************************************************************************

	Name:		ev_glue.c
	Author:		Simon Frost
	Created:	Janury 1994
	Derived from:	Original
	Sccs ID:	@(#)ev_glue.c	1.16 10/21/94
	Purpose:	Provides glue routines for C-E-vid functions
			and the Jcode calling conventions.

	(c)Copyright Insignia Solutions Ltd., 1994. All rights reserved.

*************************************************************************
]*/

#include "insignia.h"
#include "host_def.h"

#ifdef CCPU
#include "gmi.h"
#endif

#include "cpu_vid.h"
#include "video.h"
#include "egacpu.h"	/* for Vglob fn defns */
#include "ga_mark.h"	/* for mark fn pointers struct defn */
#include "evidfunc.h"	/* generated by build process */
#include "gdpvar.h"	/* generated by build process */

#undef FORWARDS		/* all these redefined in EDL code */
#undef BACKWARDS
#undef UNCHAINED
#include "Evid_c.h"	/* generated from Evid.edl */
#include "j_c_lang.h"   /* jcode to ccode register definition header */

EVID_WRT_POINTERS c_ev_write_ptr;
EVID_READ_POINTERS c_ev_read_ptr;

/* defines in j_c_lang.h
 *extern IUH jccc_parm1, jccc_parm2, jccc_parm3, jccc_parm4,
 *		jccc_parm5, jccc_gdp;
 */
extern IHP Gdp;

extern IU32 gvi_pc_low_regen;

#ifdef CCPU
IUH ega_gc_outb_mask;

IHP Gdp;
#endif

#ifdef C_VID
IHPE modeLookup;	/* CEvid extern */
IHPE EvidPortFuncs;	/* CEvid extern */
IHPE AdapCOutb;		/* CEvid extern */

IHPE EvidWriteFuncs, EvidReadFuncs, EvidMarkFuncs;	/* CEvid refs */


/* let the c jcode know the addresses so it can lea them */
/* NOTE These things are not accessed the jcode version of the code 
 * has been substituted with a c version 
 * LEAVE in so as not to get unresolved references 
 */
IHPE j_modeLookup	= (IHPE) &modeLookup ;
IHPE j_EvidPortFuncs	= (IHPE) &EvidPortFuncs ;
IHPE j_AdapCOutb	= (IHPE) &AdapCOutb;
IHPE j_EvidWriteFuncs	= (IHPE) &EvidWriteFuncs; 
IHPE j_EvidReadFuncs	= (IHPE) &EvidReadFuncs;
IHPE j_EvidMarkFuncs	= (IHPE) &EvidMarkFuncs;
/* Gdp is referenced */
IHP j_Gdp;	/*	=  Gdp ;  SPECIAL CASE Gdp is the correct address  see below for init */
/*(
=========================== CrulesRuntimeError =======================

PURPOSE: resolve c-rules requirment to have a runtime error routine

INPUT: message string.

OUTPUT: To be Decided .
====================================================================
)*/
GLOBAL void
CrulesRuntimeError IFN1( char * , message ) 
{
	printf("cevid runtime error: %s\r\n", message);
}

/*(
=========================== write_byte_ev_glue =======================

PURPOSE: Set up C evid parameters and call byte write function pointer

INPUT: Write offset & value to write

OUTPUT: None.

====================================================================
)*/
GLOBAL void
write_byte_ev_glue IFN2(IU32, eaOff, IU8, eaVal)
{
	jccc_parm1 = (IUH)eaOff - gvi_pc_low_regen;
	jccc_parm2 = (IUH)eaVal;
	jccc_gdp = (IUH)Gdp;

	(*c_ev_write_ptr.b_write)(eaOff, eaVal);
}

/*(
=========================== write_word_ev_glue =======================

PURPOSE: Set up C evid parameters and call word write function pointer

INPUT: Write offset & value to write

OUTPUT: None.

====================================================================
)*/
GLOBAL void
write_word_ev_glue IFN2(IU32, eaOff, IU16, eaVal)
{
	jccc_parm1 = (IUH)eaOff - gvi_pc_low_regen;
	jccc_parm2 = (IUH)eaVal;
	jccc_gdp = (IUH)Gdp;

	(*c_ev_write_ptr.w_write)(eaOff, eaVal);
}

/*(
=========================== write_dword_ev_glue =======================

PURPOSE: Set up C evid parameters and call dword write function pointer

INPUT: Write offset & value to write

OUTPUT: None.

====================================================================
)*/
GLOBAL void
write_dword_ev_glue IFN2(IU32, eaOff, IU32, eaVal)
{
	jccc_parm1 = (IUH)eaOff - gvi_pc_low_regen;
	jccc_parm2 = (IUH)eaVal;
	jccc_gdp = (IUH)Gdp;

	(*c_ev_write_ptr.d_write)(eaOff, eaVal);
}

/*(
=========================== fill_byte_ev_glue =======================

PURPOSE: Set up C evid parameters and call byte fill function pointer

INPUT: Write offset, value to write & fill count

OUTPUT: None.

====================================================================
*/
GLOBAL void
fill_byte_ev_glue IFN3(IU32, eaOff, IU8, eaVal, IU32, count)
{
	jccc_parm1 = (IUH)eaOff - gvi_pc_low_regen;
	jccc_parm2 = (IUH)eaVal;
	jccc_parm3 = (IUH)count;
	jccc_gdp = (IUH)Gdp;

	(*c_ev_write_ptr.b_fill)(eaOff, eaVal, count);
}

/*(
=========================== fill_word_ev_glue =======================

PURPOSE: Set up C evid parameters and call word fill function pointer

INPUT: Write offset, value to write & fill count

OUTPUT: None.

====================================================================
*/
GLOBAL void
fill_word_ev_glue IFN3(IU32, eaOff, IU16, eaVal, IU32, count)
{
	jccc_parm1 = (IUH)eaOff - gvi_pc_low_regen;
	jccc_parm2 = (IUH)eaVal;
	jccc_parm3 = (IUH)count;
	jccc_gdp = (IUH)Gdp;

	(*c_ev_write_ptr.w_fill)(eaOff, eaVal, count);
}

/*(
=========================== fill_dword_ev_glue =======================

PURPOSE: Set up C evid parameters and call dword fill function pointer

INPUT: Write offset, value to write & fill count

OUTPUT: None.

====================================================================
*/
GLOBAL void
fill_dword_ev_glue IFN3(IU32, eaOff, IU32, eaVal, IU32, count)
{
	jccc_parm1 = (IUH)eaOff - gvi_pc_low_regen;
	jccc_parm2 = (IUH)eaVal;
	jccc_parm3 = (IUH)count;
	jccc_gdp = (IUH)Gdp;

	(*c_ev_write_ptr.d_fill)(eaOff, eaVal, count);
}

/*(
=========================== move_byte_fwd_ev_glue =======================

PURPOSE: Set up C evid parameters and call byte fwd move function pointer

INPUT: Write dest offset, src offset, move count & src type indicator

OUTPUT: None.

====================================================================
*/
GLOBAL void
move_byte_fwd_ev_glue IFN4(IU32, eaOff, IHPE, fromOff, IU32, count, IBOOL, srcInRAM)
{
	jccc_parm1 = (IUH)eaOff - gvi_pc_low_regen;
	jccc_parm2 = (IUH)fromOff;
	if (!srcInRAM)
		jccc_parm2 -= gvi_pc_low_regen;
	jccc_parm3 = (IUH)count;
	jccc_parm4 = (IUH)srcInRAM;
	jccc_gdp = (IUH)Gdp;

	(*c_ev_write_ptr.b_fwd_move)(eaOff, fromOff, count, srcInRAM);
}

/*(
=========================== move_byte_bwd_ev_glue =======================

PURPOSE: Set up C evid parameters and call byte bwd move function pointer

INPUT: Write dest offset, src offset, move count & src type indicator

OUTPUT: None.

====================================================================
*/
GLOBAL void
move_byte_bwd_ev_glue IFN4(IU32, eaOff, IHPE, fromOff, IU32, count, IBOOL, srcInRAM)
{
	jccc_parm1 = (IUH)eaOff - gvi_pc_low_regen;
	jccc_parm2 = (IUH)fromOff;
	if (!srcInRAM)
		jccc_parm2 -= gvi_pc_low_regen;
	jccc_parm3 = (IUH)count;
	jccc_parm4 = (IUH)srcInRAM;
	jccc_gdp = (IUH)Gdp;

	(*c_ev_write_ptr.b_bwd_move)(eaOff, fromOff, count, srcInRAM);
}

/*(
=========================== move_word_fwd_ev_glue =======================

PURPOSE: Set up C evid parameters and call word fwd move function pointer

INPUT: Write dest offset, src offset, move count & src type indicator

OUTPUT: None.

====================================================================
*/
GLOBAL void
move_word_fwd_ev_glue IFN4(IU32, eaOff, IHPE, fromOff, IU32, count, IBOOL, srcInRAM)
{
	jccc_parm1 = (IUH)eaOff - gvi_pc_low_regen;
	jccc_parm2 = (IUH)fromOff;
	if (!srcInRAM)
		jccc_parm2 -= gvi_pc_low_regen;
	jccc_parm3 = (IUH)count;
	jccc_parm4 = (IUH)srcInRAM;
	jccc_gdp = (IUH)Gdp;

	(*c_ev_write_ptr.w_fwd_move)(eaOff, fromOff, count, srcInRAM);
}

/*(
=========================== move_word_bwd_ev_glue =======================

PURPOSE: Set up C evid parameters and call word bwd move function pointer

INPUT: Write dest offset, src offset, move count & src type indicator

OUTPUT: None.

====================================================================
*/
GLOBAL void
move_word_bwd_ev_glue IFN4(IU32, eaOff, IHPE, fromOff, IU32, count, IBOOL, srcInRAM)
{
	jccc_parm1 = (IUH)eaOff - gvi_pc_low_regen;
	jccc_parm2 = (IUH)fromOff;
	if (!srcInRAM)
		jccc_parm2 -= gvi_pc_low_regen;
	jccc_parm3 = (IUH)count;
	jccc_parm4 = (IUH)srcInRAM;
	jccc_gdp = (IUH)Gdp;

	(*c_ev_write_ptr.w_bwd_move)(eaOff, fromOff, count, srcInRAM);
}

/*(
=========================== move_dword_fwd_ev_glue =======================

PURPOSE: Set up C evid parameters and call dword fwd move function pointer

INPUT: Write dest offset, src offset, move count & src type indicator

OUTPUT: None.

====================================================================
*/
GLOBAL void
move_dword_fwd_ev_glue IFN4(IU32, eaOff, IHPE, fromOff, IU32, count, IBOOL, srcInRAM)
{
	jccc_parm1 = (IUH)eaOff - gvi_pc_low_regen;
	jccc_parm2 = (IUH)fromOff;
	if (!srcInRAM)
		jccc_parm2 -= gvi_pc_low_regen;
	jccc_parm3 = (IUH)count;
	jccc_parm4 = (IUH)srcInRAM;
	jccc_gdp = (IUH)Gdp;

	(*c_ev_write_ptr.d_fwd_move)(eaOff, fromOff, count, srcInRAM);
}

/*(
=========================== move_dword_bwd_ev_glue =======================

PURPOSE: Set up C evid parameters and call dword bwd move function pointer

INPUT: Write dest offset, src offset, move count & src type indicator

OUTPUT: None.

====================================================================
*/
GLOBAL void
move_dword_bwd_ev_glue IFN4(IU32, eaOff, IHPE, fromOff, IU32, count, IBOOL, srcInRAM)
{
	jccc_parm1 = (IUH)eaOff - gvi_pc_low_regen;
	jccc_parm2 = (IUH)fromOff;
	if (!srcInRAM)
		jccc_parm2 -= gvi_pc_low_regen;
	jccc_parm3 = (IUH)count;
	jccc_parm4 = (IUH)srcInRAM;
	jccc_gdp = (IUH)Gdp;

	(*c_ev_write_ptr.d_bwd_move)(eaOff, fromOff, count, srcInRAM);
}

/*(
=========================== read_byte_ev_glue =======================

PURPOSE: Set up C evid parameters and call read byte function pointer

INPUT: read offset in planes

OUTPUT: value read

====================================================================
*/
GLOBAL IU32
read_byte_ev_glue IFN1(IU32, eaOff)
{
	jccc_parm2 = (IUH)eaOff - gvi_pc_low_regen;
	jccc_gdp = (IUH)Gdp;

	(*c_ev_read_ptr.b_read)(eaOff);

	return((IU32)jccc_parm1);
}

/*(
=========================== read_word_ev_glue =======================

PURPOSE: Set up C evid parameters and call read word function pointer

INPUT: read offset in planes

OUTPUT: None.

====================================================================
*/
GLOBAL IU32
read_word_ev_glue IFN1(IU32, eaOff)
{
	jccc_parm2 = (IUH)eaOff - gvi_pc_low_regen;
	jccc_gdp = (IUH)Gdp;

	(*c_ev_read_ptr.w_read)(eaOff);

	return((IU32)jccc_parm1);
}

/*(
=========================== read_dword_ev_glue =======================

PURPOSE: Set up C evid parameters and call read dword function pointer

INPUT: read offset in planes

OUTPUT: None.

====================================================================
*/
GLOBAL IU32
read_dword_ev_glue IFN1(IU32, eaOff)
{
	jccc_parm2 = (IUH)eaOff - gvi_pc_low_regen;
	jccc_gdp = (IUH)Gdp;

	(*c_ev_read_ptr.d_read)(eaOff);

	return((IU32)jccc_parm1);
}

/*(
=========================== read_str_fwd_ev_glue =======================

PURPOSE: Set up C evid parameters and call read string fwd function pointer

INPUT: destination pointer, read offset in planes, number of bytes to read.

OUTPUT: None.

====================================================================
*/
GLOBAL void
read_str_fwd_ev_glue IFN3(IU8 *, dest, IU32, eaOff, IU32, count)
{
	jccc_parm1 = (IUH)dest;
	jccc_parm2 = (IUH)eaOff - gvi_pc_low_regen;
	jccc_parm3 = (IUH)count;
	jccc_parm4 = (IUH)1;	/* destination in RAM */
	jccc_gdp = (IUH)Gdp;

	(*c_ev_read_ptr.str_fwd_read)(dest, eaOff, count);
}

/*(
=========================== read_str_bwd_ev_glue =======================

PURPOSE: Set up C evid parameters and call read string bwd function pointer

INPUT: destination pointer, read offset in planes, number of bytes to read.

OUTPUT: None.

====================================================================
*/
GLOBAL void
read_str_bwd_ev_glue IFN3(IU8 *, dest, IU32, eaOff, IU32, count)
{
	jccc_parm1 = (IUH)dest;
	jccc_parm2 = (IUH)eaOff - gvi_pc_low_regen;
	jccc_parm3 = (IUH)count;
	jccc_parm4 = (IUH)1;	/* destination in RAM */
	jccc_gdp = (IUH)Gdp;

	(*c_ev_read_ptr.str_bwd_read)(dest, eaOff, count);
}

GLOBAL IBOOL cevid_verbose = FALSE;
/*(
=========================== setReadPointers =======================

PURPOSE: Set active struct entries for read functions. (c_ev_read_ptr).

INPUT: index used to select read set.

OUTPUT: None.

====================================================================
*/
GLOBAL void
setReadPointers IFN1(IUH, readset)
{
	IUH chain_index;	/* current chaining for read modes 0 & 1 */

	switch(readset)
	{
	case 0:	/* read mode 0 */
		chain_index = getVideochain();
		if (cevid_verbose) printf("Set Read Pointers Mode 0, chain %d\n", chain_index);
		c_ev_read_ptr.b_read = read_mode0_evid[chain_index].b_read;
		c_ev_read_ptr.w_read = read_mode0_evid[chain_index].w_read;
		c_ev_read_ptr.d_read = read_mode0_evid[chain_index].d_read;
		c_ev_read_ptr.str_fwd_read = read_mode0_evid[chain_index].str_fwd_read;
		c_ev_read_ptr.str_bwd_read = read_mode0_evid[chain_index].str_bwd_read;
		setVideoread_byte_addr(read_mode0_evid[chain_index].b_read);
		break;

	case 1:	/* read mode 1 */
		chain_index = getVideochain();
		if (cevid_verbose) printf("Set Read Pointers Mode 1, chain %d\n", chain_index);
		c_ev_read_ptr.b_read = read_mode1_evid[chain_index].b_read;
		c_ev_read_ptr.w_read = read_mode1_evid[chain_index].w_read;
		c_ev_read_ptr.d_read = read_mode1_evid[chain_index].d_read;
		c_ev_read_ptr.str_fwd_read = read_mode1_evid[chain_index].str_fwd_read;
		c_ev_read_ptr.str_bwd_read = read_mode1_evid[chain_index].str_bwd_read;
		setVideoread_byte_addr(read_mode1_evid[chain_index].b_read);
		break;

	case 2:	/* RAM disabled */
		if (cevid_verbose) printf("Set Read Pointers RAM disabled\n");
		c_ev_read_ptr.b_read = ram_dsbld_read_evid.b_read;
		c_ev_read_ptr.w_read = ram_dsbld_read_evid.w_read;
		c_ev_read_ptr.d_read = ram_dsbld_read_evid.d_read;
		c_ev_read_ptr.str_fwd_read = ram_dsbld_read_evid.str_fwd_read;
		c_ev_read_ptr.str_bwd_read = ram_dsbld_read_evid.str_bwd_read;
		setVideoread_byte_addr(ram_dsbld_read_evid.b_read);
		break;

	case 3:	/* Simple reads (non planed) */
		if (cevid_verbose) printf("Set Read Pointers Simple\n");
		c_ev_read_ptr.b_read = simple_read_evid.b_read;
		c_ev_read_ptr.w_read = simple_read_evid.w_read;
		c_ev_read_ptr.d_read = simple_read_evid.d_read;
		c_ev_read_ptr.str_fwd_read = simple_read_evid.str_fwd_read;
		c_ev_read_ptr.str_bwd_read = simple_read_evid.str_bwd_read;
		setVideoread_byte_addr(simple_read_evid.b_read);
		break;
	}
}

/*(
=========================== setWritePointers =======================

PURPOSE: Set active struct entries for write functions. (c_ev_write_ptr).

INPUT: None. (All information gleaned from Vglobs).

OUTPUT: None.

====================================================================
*/
GLOBAL void
setWritePointers IFN0()
{
	EVID_WRT_POINTERS *choice;	/* point to selected write set */
	IU8 chain;
	IU8 modelookup[] =
	      /*  0  1  2  3  4  5  6  7  8  9  10 11 12 13 14 15 */
		{ 0, 1, 2, 3, 2, 3, 2, 3, 0, 1, 2, 3, 2, 3, 2, 3,
	      /*  16 17 18  19  20  21  22 23 24 25 26  27  28  29  30  31 */
		  8, 9, 10, 11, 10, 11, 6, 7, 8, 9, 10, 11, 10, 11, 10, 11 };

	choice = (EVID_WRT_POINTERS *)0;	/* debug check */

	/* check for dithering 'override' of rest of checks */
	if (getVideodither() == 1)
	{
		if (cevid_verbose) printf("SetWritePointers Dither, Mode %d\n", getVideowrmode());	/*STF*/
		choice = &dith_evid[getVideowrmode()]; /* mode 0-3 */
	}
	else
	{
		chain = getVideochain();
		switch (chain)
		{
		case UNCHAINED:
		case CHAIN_4:
			if (getVideorotate() > 0)
			{
				if (cevid_verbose) printf("SetWritePointers Generic Override for Chain %d, Mode %d\n", chain, getVideowrmode());	/*STF*/
				if (cevid_verbose) printf("Rotates set to %d\n", getVideorotate());/*STF*/
				choice = &gricvid_evid;
			}
			else
			{
				if (chain == UNCHAINED)
				{
					if (cevid_verbose) printf("SetWritePointers Unchained, State %#x", getVideowrstate());	/*STF*/
					choice = &unchained_evid[0];
				}
				else
				{
					if (cevid_verbose) printf("SetWritePointers Chain4");	/*STF*/
					choice = &chain4_evid[0];
				}
				switch(getVideowrmode())
				{
					case MODE_0:
						if (cevid_verbose) printf(" Mode 0, index %d\n", modelookup[getVideowrstate()]);	/* STF */
						choice += modelookup[getVideowrstate()];
						break;

					case MODE_1:
						if (cevid_verbose) printf(" Mode 1\n");/* STF */
						choice += NUM_M0_WRITES;
						break;

					case MODE_2:
						if (cevid_verbose) printf(" Mode 2, index %d\n", modelookup[getVideowrstate() & 0xf]);/* STF */
						choice += NUM_M0_WRITES + NUM_M1_WRITES;
						choice += modelookup[getVideowrstate() & 0xf];
						break;

					case MODE_3:
						if (cevid_verbose) printf(" Mode 3, index %d\n", modelookup[getVideowrstate() & 0xf]);/* STF */
						choice += NUM_M0_WRITES + NUM_M1_WRITES + NUM_M23_WRITES;
						choice += modelookup[getVideowrstate() & 0xf];
						break;

					default:
						if (cevid_verbose) printf(" unknown write mode %d\n",getVideowrmode());
				}
			}
			break;

		case CHAIN_2:
			if (cevid_verbose) printf("SetWritePointers Chain2, Mode %d\n", getVideowrmode());	/*STF*/
			choice = &chain2_evid[getVideowrmode()];
			break;

		case SIMPLE_WRITES:
			if (cevid_verbose) printf("SetWritePointers Simple\n");	/*STF*/
			choice = &simple_evid;
			break;
		}
	}
	if (choice == (EVID_WRT_POINTERS *)0)
	{
		printf("setWritePointers: ERROR - BAD POINTER SELECTION\n");
		choice = &chain2_evid[4];
	}
	c_ev_write_ptr.b_write = choice->b_write;
	c_ev_write_ptr.w_write = choice->w_write;
	c_ev_write_ptr.d_write = choice->d_write;
	c_ev_write_ptr.b_fill = choice->b_fill;
	c_ev_write_ptr.w_fill = choice->w_fill;
	c_ev_write_ptr.d_fill = choice->d_fill;
	c_ev_write_ptr.b_fwd_move = choice->b_fwd_move;
	c_ev_write_ptr.b_bwd_move = choice->b_bwd_move;
	c_ev_write_ptr.w_fwd_move = choice->w_fwd_move;
	c_ev_write_ptr.w_bwd_move = choice->w_bwd_move;
	c_ev_write_ptr.d_fwd_move = choice->d_fwd_move;
	c_ev_write_ptr.d_bwd_move = choice->d_bwd_move;
}

/*(
=========================== setMarkPointers =======================

PURPOSE: Set VGlobs entries for mark functions

INPUT: index used to select mark set.

OUTPUT: None.

====================================================================
*/
GLOBAL void
setMarkPointers IFN1(IUH, markset)
{
	switch (markset)
	{

	case 0:	/* simple */
		if (cevid_verbose) printf("Set Mark Pointers Simple\n");
		setVideomark_byte(simple_mark_evid.b_mark);
		setVideomark_word(simple_mark_evid.w_mark);
		setVideomark_string(simple_mark_evid.str_mark);
		break;

	case 1:	/* CGA style */
		if (cevid_verbose) printf("Set Mark Pointers CGA\n");
		setVideomark_byte(cga_mark_evid.b_mark);
		setVideomark_word(cga_mark_evid.w_mark);
		setVideomark_string(cga_mark_evid.str_mark);
		break;

	case 2:	/* Unchained */
		if (cevid_verbose) printf("Set Mark Pointers Unchained\n");
		setVideomark_byte(unchained_mark_evid.b_mark);
		setVideomark_word(unchained_mark_evid.w_mark);
		setVideomark_string(unchained_mark_evid.str_mark);
		break;

	case 3:	/* Chain4 */
		if (cevid_verbose) printf("Set Mark Pointers Chain4\n");
		setVideomark_byte(chain4_mark_evid.b_mark);
		setVideomark_word(chain4_mark_evid.w_mark);
		setVideomark_string(chain4_mark_evid.str_mark);
		break;

	}
}

GLOBAL void
write_bios_byte IFN2(IU8, eaVal, IU32, eaOff)
{
	jccc_parm1 = (IUH)eaOff;
	jccc_parm2 = (IUH)eaVal;
	jccc_gdp = (IUH)Gdp;

	chain2_evid[4].b_write(eaOff, eaVal);
}

GLOBAL void
write_bios_word IFN2(IU16, eaVal, IU32, eaOff)
{
	jccc_parm1 = (IUH)eaOff;
	jccc_parm2 = (IUH)eaVal;
	jccc_gdp = (IUH)Gdp;

	chain2_evid[4].w_write(eaOff, eaVal);
}

/*(
=========================== SetBiosWrites =======================

PURPOSE: Set VGlobs entries for mark functions

INPUT: index used to select mark set.

OUTPUT: None.

====================================================================
*/
GLOBAL void
SetBiosWrites IFN1(IUH, markset)
{
	bios_ch2_byte_wrt_fn = write_bios_byte;
	bios_ch2_word_wrt_fn = write_bios_word;
}

#ifdef CCPU

#define SUBRRINGBUFFERSIZE 25
GLOBAL IUH SubrRingBuffer[SUBRRINGBUFFERSIZE];
/*(
=========================== setup_vga_globals =======================

PURPOSE: Point VGLOBS into correct portion on Gdp

INPUT: None.

OUTPUT: None.

====================================================================
*/

GLOBAL void
setup_vga_globals IFN0()
{
	EGA_CPU.globals = &(GLOBAL_VGAGlobals);

	/* support memory for subr id ring buffer */
        GLOBAL_SubrRingLowIncl = &SubrRingBuffer[0];
        GLOBAL_SubrRingHighIncl = GLOBAL_SubrRingLowIncl + (SUBRRINGBUFFERSIZE-1
);
        GLOBAL_SubrRingPtr = GLOBAL_SubrRingLowIncl;


#ifndef PROD
	if (getenv("CEVID_VERBOSE") != 0)
		cevid_verbose = TRUE;
#endif	/* PROD */
}

/*(
=========================== setup_global_data_ptr =======================

PURPOSE: Setup Gdp for CCPU/CEvid.

INPUT: None.

OUTPUT: None.

====================================================================
*/

GLOBAL IHP
setup_global_data_ptr IFN0()
{
	Gdp = (IHP)host_malloc(64 * 1024);
	/* Gdp holds the correct value so in jcode an lea wants the value not
         * the adrress of the data 
	 */
	j_Gdp = Gdp ;
	if (Gdp == (IHP)0)
		printf("Error - can't malloc memory for Gdp\n");

	return(Gdp);
}
#endif	/* CCPU */
#endif	/* C_VID */
