;
; M024 MD 01/28/91      Added new keyboard commands
;
;----------------------------------------------------------------------------
;               EQUATES                 :
;----------------------------------------------------------------------------
TTEST           EQU     0               ; CONDITIONAL ASM (TEST2.SRC)
KY_LOCK         EQU     0               ; CONDITIONAL ASM (TEST2.SRC)
KEY_NUMS        EQU     0               ; CONDITIONAL ASM (KYBD.SRC)
;----------------------------------------------------------------------------
X287            EQU     0F0H            ; MATH PROCESSOR
;----------------------------------------------------------------------------
LOOP_POST       EQU     020H            ; MFG LOOP POST JUMPER
;----------------------------------------------------------------------------
REFRESH_BIT     EQU     010H            ; REFRESH TEST BIT
;----------------------------------------------------------------------------
POST_SS         EQU     0H              ; POST STACK SEGMENT
POST_SP         EQU     8000H           ; POST STACK POINTER
TEMP_STACK_LO   EQU     0FFFFH          ;
TEMP_STACK_HI   EQU     0               ; SET PROTECTED MODE TEMP_SS
                                        ; 0:FFFFH
;----------------------------------------------------------------------------
PORT_A          EQU     60H             ; 8042 KEYBOARD SCAN/DIAG OUTPUTS
PORT_B          EQU     61H             ; 8042 READ WRITE REGISTER
PARITY_ERR      EQU     0C0H            ; RAM/IO CHANNEL PARITY ERROR
RAM_PAR_ON      EQU     11110011B       ; AND THIS VALUE
RAM_PAR_OFF     EQU     00001100B       ; OR THIS VALUE
IO_CHK          EQU     01000000B       ; IO CHECK?
PRTY_CHK        EQU     10000000B       ; PARITY CHECK?

STATUS_PORT     EQU     64H             ;8042 STATUS PORT
OUT_BUF_FULL    EQU     01H             ; 0 = +OUTPUT BUFFER FULL
INPT_BUF_FULL   EQU     02H             ; 1 = +INPUT BUFFER FULL
SYS_FLAG        EQU     04H             ; 2 = -SYSTEM FLAG -POR/-SELF TEST
CMD_DATA        EQU     08H             ; 3 = -COMMAND/+DATA
KYBD_INH        EQU     10H             ; 4 = +KEYBOARD INHIBITED
TRANS_TMOUT     EQU     20H             ; 5 = +TRANSMIT TIMEOUT
RCV_TMOUT       EQU     40H             ; 6 = +RECEIVE TIME OUT
PARITY_EVEN     EQU     80H             ; 7 = +PARITY IS EVEN
SHUT_CMD        EQU     0FEH            ; CAUSE A SHUTDOWN COMMAND
INTR_FACE_CK    EQU     0ABH            ; CHECK 8042 INTERFACE CMD
KYBD_CLK_DATA   EQU     0E0H            ; GET KYBD CLOCK AND DATA CMD
KYBD_CLK        EQU     001H            ; KEYBOARD CLOCK BIT 0
;----------MANUFACTURING PORT------------------------------------------------
MFG_PORT        EQU     80H             ; MANUFACTURING CHECKPOINT PORT
;----------MANUFACTURING BIT DEFINITION FOR MFG_ERR_FLAG+1-------------------
MEM_FAIL        EQU     00000001B      ; STORAGE TEST FAILED (ERROR 20X)
PRO_FAIL        EQU     00000010B      ; VIRTUAL MODE TEST FAILED (ERROR 104)
LMCS_FAIL       EQU     00000100B      ; LOW MEG CHIP SELECT FAILED (ERROR 109)
KYCLK_FAIL      EQU     00001000B      ; KEYBOARD CLOCK TEST FAILED (ERROR 304)
KY_SYS_FAIL     EQU     00010000B      ; KEYBOARD OR SYSTEM FAILED (ERROR 303)
KYBD_FAIL       EQU     00100000B      ; KEYBOARD FAILED (ERROR 301)
DSK_FAIL        EQU     01000000B      ; DISKETTE TEST FAILED (ERROR 601)
KEY_FAIL        EQU     10000000B      ; KEYBOARD LOCKED (ERROR 302)
;----------8042 INPUT PORT BIT DEFINITION------------------------------------
BASE_RAM        EQU     10H             ;BASE R/W MEMORY
MFG_JMP         EQU     20H             ;LOOP POST JUMPER
DSP_JMP         EQU     40H             ;DISPLAY TYPE JUMPER
KEY_BD_INHIB    EQU     80H             ;KEYBOARD INHIBIT SWITCH
;----------8042 RAM DEFINITION-----------------------------------------------
INH_KEYBOARD    EQU     10H             ;BYTE 0 BIT 4 OF 8042 RAM
;-------------- COMMANDS ----------------------------------------------------
READ_8042_RAM   EQU     20H             ; BITS 0-4 = ADDRESS (20-3F)
WRITE_8042_RAM  EQU     60H             ;
SELF_8042_TEST  EQU     0AAH            ; 8042 SELF TEST
READ_8042_INPUT EQU     0C0H            ; READ 8042 INPUT PORT
ENA_KBD         EQU     0AEH            ; ENABLE KEYBOARD COMMAND
DIS_KBD         EQU     0ADH            ; DISABLE KEYBOARD COMMAND
ENABLE_BIT20    EQU     0DFH            ; ENABLE ADDR LINE BIT 20
DISABLE_BIT20   EQU     0DDH            ; DISABLE ADDR LINE BIT 20
ENABLE_AUX      EQU     0A8H            ; ENABLE AUX DEVICE COMMAND    ;M024
DISABLE_AUX     EQU     0A7H            ; DISABLE AUX DEVICE COMMAND   ;M024
;-------------- KEYBOARD/LED COMMANDS --------------------------------------
KB_MENU         EQU     0F1H            ; SELECT MENU COMMAND
KB_TYPA_RD      EQU     0F3H            ; SET TYPAMATIC RATE/DELAY         RWV 10-07-85
KB_ENABLE       EQU     0F4H            ; KEYBOARD ENABLE
KB_MAKE_BREAK   EQU     0F7H            ; TYPAMATIC
KB_ECHO         EQU     0FEH            ; ECHO COMMAND
KB_RESET        EQU     0FFH            ; SELF DIAGNOSTIC COMMAND
LED_CMD         EQU     0EDH            ; LED WRITE COMMAND
;--------------- KEYBOARD RESPONSE -----------------------------------------
KB_OK           EQU     0AAH            ; RESPONSE FROM SELF DIAG
KB_ACK          EQU     0FAH            ; ACKNOWLEDGE FROM TRANSMISSION
KB_OVER_RUN     EQU     0FFH            ; OVER RUN
KB_RESEND       EQU     0FEH            ; RESEND REQUEST
KB_BREAK        EQU     0F0H            ; KEYBOARD BREAK CODE
;-------------- CMOS EQUATES -------------------------------------------------
CMOS_PORT       EQU     070H            ; IO ADDRESS OF CMOS PORT
CLK_UP          EQU     08AH            ; CLOCK UPDATE STATUS
CMOS_ALARM      EQU     08BH            ;
CMOS_BEGIN      EQU     090H            ;
CMOS_END        EQU     0ADH            ;
SHUT_DOWN       EQU     08FH            ; SHUTDOWN OFFSET
BATTERY_COND_STATUS EQU 08DH            ; BATTERY STATUS
M_SIZE_HI       EQU     0B1H            ; IO MEMORY SIZE HIGH BYTE (POST)
M_SIZE_LO       EQU     0B0H            ; IO MEMORY SIZE LO BYTE   (POST)
M1_SIZE_HI      EQU     096H            ; 0->640K CONFIG MEMORY SIZE (SETUP)
M1_SIZE_LO      EQU     095H            ;   LOW BYTE (SETUP)
M2_SIZE_HI      EQU     098H            ; 640K->UP CONFIG MEMORY SIZE (SETUP)
M2_SIZE_LO      EQU     097H            ;   LOW BYTE (SETUP)
C_EQUIP         EQU     094H            ; CMOS EQUIPMENT FLAG
HD_FILE_TYPE    EQU     092H            ; HARD FILE TYPE BYTE
PAGE
;--------------- CMOS DIAG_STATUS ERROR FLAGS--------------------------------
DIAG_STATUS     EQU     08EH            ; CMOS ADDRESS OF DIAG_STATUS
BAD_BAT         EQU     080H            ; DEAD BATTERY
BAD_CKSUM       EQU     040H            ; CHECKSUM ERROR
BAD_CONFIG      EQU     020H            ; MINIMUM CONFIG USED INSTEAD OF CMOS
W_MEM_SIZE      EQU     010H            ; MEMORY SIZE NOT EQUAL TO CONFIG
HF_FAIL         EQU     008H            ; HARD FILE FAILURE ON INIT
CMOS_CLK_FAIL   EQU     004H            ; CMOS CLK NOT UPDATING OR NOT VALID
;--------------- CMOS INFORMATION FLAGS--------------------------------------
INFO_STATUS     EQU     0B3H            ; CMOS ADDRESS OF INFO BYTE
M640K           EQU     080H            ; 512K -> 640K CARD INSTALLED
NEW_INST        EQU     040H            ; FLAG USED BY CMOS SETUP UTILITY
HF_BOOT         EQU     020H            ; BOOT HARD FILE FLAG
;--------------- INTERRUPT EQUATES ------------------------------------------
INTA00          EQU     20H             ; 8259 PORT
INTA01          EQU     21H             ; 8259 PORT
EOI             EQU     20H
INTB00          EQU     0A0H            ; 2ND 8259
INTB01          EQU     0A1H            ;
INT_TYPE        EQU     070H            ; START OF 8259 INTERRUPT TABLE LOCATION
INT_VIDEO       EQU     010H            ; VIDEO VECTOR
;---------------------------------------------------------------------------
TIMER           EQU     40H
TIM_CTL         EQU     43H             ; 8253 TIMER CONTROL PORT ADDR
TIMER0          EQU     40H             ; 8253 TIMER/CNTER 0 PORT ADDR
TMINT           EQU     01              ; TIMER 0 INTR RECVD MASK
;--------------------------------------------------------------------------
DMA08           EQU     08              ; DMA STATUS REG PORT ADDR
DMA             EQU     00              ; DMA CH.0 ADDR. REG PORT ADDR
;--------------------------------------------------------------------------
DMA18           EQU     0D0H            ; 2ND DMA STATUS PORT ADDR
DMA1            EQU     0C0H            ; 2ND DMA CH.0 ADDR. REG PORT ADDR
;--------------------------------------------------------------------------
DMA_PAGE        EQU     81H             ; START OF DMA PAGE REGISTERS
LAST_DMA_PAGE   EQU     8FH             ; LAST DMA PAGE REGISTER
;--------------------------------------------------------------------------
MAX_PERIOD      EQU     540H
MIN_PERIOD      EQU     410H
KBD_IN          EQU     60H             ; KEYBOARD DATA IN ADDR PORT
KBDINT          EQU     02              ; KEYBOARD INTR MASK
KB_DATA         EQU     60H             ; KEYBOARD SCAN CODE PORT
KB_CTL          EQU     61H             ; CONTROL BITS FOR KEYBOARD SENSE DATA
KB_ERR          EQU     80H             ; KEYBOARD TRANSMIT ERROR FLAG
;----- SHIFT FLAG EQUATES WITHIN KB_FLAG
INS_STATE       EQU     80H             ; INSERT STATE IS ACTIVE
CAPS_STATE      EQU     40H             ; CAPS LOCK STATE HAS BEEN TOGGLED
NUM_STATE       EQU     20H             ; NUM LOCK STATE HAS BEEN TOGGLED
SCROLL_STATE    EQU     10H             ; SCROLL LOCK STATE HAS BEEN TOGGLED
ALT_SHIFT       EQU     08H             ; ALTERNATE SHIFT KEY DEPRESSED
CTL_SHIFT       EQU     04H             ; CONTROL SHIFT KEY DEPRESSED
LEFT_SHIFT      EQU     02H             ; LEFT SHIFT KEY DEPRESSED
RIGHT_SHIFT     EQU     01H             ; RIGHT SHIFT KEY DEPRESSED
;----- SHIFT FLAG EQUATES WITHIN KB_FLAG_1
INS_SHIFT       EQU     80H             ; INSERT KEY IS DEPRESSED
CAPS_SHIFT      EQU     40H             ; CAPS LOCK KEY IS DEPRESSED
NUM_SHIFT       EQU     20H             ; NUM LOCK KEY IS DEPRESSED
SCROLL_SHIFT    EQU     10H             ; SCROLL LOCK KEY IS DEPRESSED
HOLD_STATE      EQU     08H             ; SUSPEND KEY HAS BEEN TOGGLED
SYS_SHIFT       EQU     04H             ; SYSTEM KEY DEPRESSED AND HELD
L_ALT_SHIFT     EQU     02H             ; LEFT ALT KEY DOWN                RWV 8-28-85
L_CTL_SHIFT     EQU     01H             ; LEFT CTL KEY DOWN                RWV 8-28-85
;---------------FLAGS WITHIN KB_FLAG_2
KB_ERR          EQU     80H             ; KEYBOARD TRANSMIT ERROR FLAG
KB_PR_LED       EQU     40H             ; MODE INDICATOR UPDATE
KB_FE           EQU     20H             ; RESEND RECEIVED FLAG
KB_FA           EQU     10H             ; ACK RECEIVED
CIRCUS_SYSTEM   EQU     08H             ; CIRCUS SYSTEM INDICATOR
KB_LEDS         EQU     07H             ; KEYBOARD LED STATE BITS
;                       04H             ; CAPS LOCK INDICATOR
;                       02H             ; NUM LOCK INDICATOR
;                       01H             ; SCROLL LOCK INDICATOR
;---------------FLAGS WITHIN KB_FLAG_3
RD_ID           EQU     80H             ; DOING A READ ID (MUST BE BIT0)   AEV
LC_AB           EQU     40H             ; LAST CHAR WAS FIRST ID CHAR      AEV
SET_NUM_LK      EQU     20H             ; FORCE NUM LOCK IF RD ID & KBX    AEV
KBX             EQU     10H             ; ENHANCED KEYBOARD INSTALLED      RWV 7-18-85
R_ALT_SHIFT     EQU     08H             ; RIGHT ALT KEY DOWN               RWV 7-18-85
GRAPH_ON        EQU     08H             ; ALT GRAPHICS KEY DOWN (WT ONLY)  AEV
R_CTL_SHIFT     EQU     04H             ; RIGHT CTL KEY DOWN               RWV 7-18-85
LC_E0           EQU     02H             ; LAST CODE WAS THE E0 HIDDEN CODE RWV 7-18-85
LC_E1           EQU     01H             ; LAST CODE WAS THE E1 HIDDEN CODE RWV 7-18-85
;----- SCAN CODE EQUATES FOR THE KEYBOARD
NUM_KEY         EQU     69              ; SCAN CODE FOR NUMBER LOCK
SCROLL_KEY      EQU     70              ; SCAN CODE FOR SCROLL LOCK
ALT_KEY         EQU     56              ; SCAN CODE FOR ALTERNATE KEY
CTL_KEY         EQU     29              ; SCAN CODE FOR CONTROL KEY
CAPS_KEY        EQU     58              ; SCAN CODE FOR SHIFT LOCK
LEFT_KEY        EQU     42              ; SCAN CODE FOR LEFT SHIFT
RIGHT_KEY       EQU     54              ; SCAN CODE FOR RIGHT SHIFT
INS_KEY         EQU     82              ; SCAN CODE FOR INSERT KEY
DEL_KEY         EQU     83              ; SCAN CODE FOR DELETE KEY
SYS_KEY         EQU     84              ; SCAN CODE FOR SYSTEM KEY
;-------------- ENHANCED KEYBOARD EQUATES
ID_1            EQU     0ABH            ; 1ST ID CHAR FOR KBX
ID_2            EQU     041H            ; 2ND ID CHAR FOR KBX              AEV
ID_2A           EQU     054H            ; ALTERNATE 2ND ID CHAR FOR KBX    RWV 8-16-85
F11_M           EQU     87              ; F11 KEY MAKE
F12_M           EQU     88              ; F12 KEY MAKE
MC_E0           EQU     224             ; GENERAL MARKER CODE
MC_E1           EQU     225             ; PAUSE KEY MARKER CODE

;-------------- DISKETTE EQUATES
INT_FLAG        EQU     080H            ; INTERRUPT OCCURRENCE FLAG
MOTOR_WAIT      EQU     37              ; 2 SECS OF COUNTS FOR MOTOR TURN OFF
TIME_OUT        EQU     80H             ; ATTACHMENT FAILED TO RESPOND
BAD_SEEK        EQU     40H             ; SEEK OPERATION FAILED
BAD_NEC         EQU     20H             ; NEC CONTROLLER HAS FAILED
BAD_CRC         EQU     10H             ; BAD CRC ON DISKETTE READ
DMA_BOUNDARY    EQU     09H             ; ATTEMPT TO DMA ACROSS 64K BOUNDARY
BAD_DMA         EQU     08H             ; DMA OVERRUN ON OPERATION
MEDIA_CHANGE    EQU     06H             ; MEDIA REMOVED ON DUAL ATTACH CARD
RECORD_NOT_FND  EQU     04H             ; REQUESTED SECTOR NOT FOUND
WRITE_PROTECT   EQU     03H             ; WRITE ATTEMPTED ON WRITE PROT DISK
BAD_ADDR_MARK   EQU     02H             ; ADDRESS MARK NOT FOUND
BAD_CMD         EQU     01H             ; BAD COMMAND PASSED TO DISKETTE I/O

XRATE           EQU     02H             ; 250KBS DATA TRANSFER RATE
DUAL            EQU     01H             ; DUAL ATTACH CARD PRESENT FLAG

DSK_CHG         EQU     080H            ; DISKETTE CHANGE FLAG MASK BIT
STATE_MSK       EQU     007H            ; USED TO STRIP OFF STATE OF MEDIA
REV_STATE       EQU     0F8H            ; USED AS MASK FOR STATE BITS
DETERMINED      EQU     010H            ; SET STATE DETERMINED IN STATE BITS
TRAN_MSK        EQU     03H             ; ISOLATE SHIFTED TRANSFER RATE BITS
DOUBLE_STEP     EQU     020H            ; MASK TO TURN ON DOUBLE STEPPING
MOTOR_MSK       EQU     0F0H            ; MASK TO CLEAR MOTOR ON BITS
MAX_DRV         EQU     002H            ; MAX NUMBER OF DRIVES
;HOME            EQU     010H            ; TRACK 0 MASK
SENSE_DRV_ST    EQU     004H            ; SENSE DRIVE STATUS COMMAND
ONE             EQU     001H            ; SEEK ONE TRACK
TRK_SLAP        EQU     030H            ; CRASH STOP (48 TPI DRIVES)
QUIET_SEEK      EQU     00AH            ; SEEK TO TRACK 10
HD12_SETTLE     EQU     015D            ; 1.2 M HEAD SETTLE TIME
HD320_SETTLE    EQU     020D            ; 320 K HEAD SETTLE TIME
WRITE_OP        EQU     080H            ; WRITE OPERATION FLAG
DD_MASK         EQU     010H            ; MASK TO INDICATE DRIVE IS 80 TRACKS
PAGE
;------ DISK CHANGE LINE EQUATES
NOCHGLN         EQU     001H            ; NO DISK CHANGE LINE AVAILABLE
CHGLN           EQU     002H            ; DISK CHANGE LINE AVAILABLE
;------ MEDIA/DRIVE STATE INDICATORS
M326D326        EQU     093H            ; STATE MACHINE - 320/360 MEDIA/DRIVE
M326D12         EQU     074H            ; STATE MACHINE - 320/360 MEDIA,1.2DRIVE
M12D12          EQU     015H            ; STATE MACHINE - 1.2 MEDIA/DRIVE
POA_DUAL        EQU     061H            ; 300K DATA TRANSFER RATE & STATE 1
POA_START       EQU     080H            ; 250K DATA TRANSFER RATE & STATE 0
TRK_80          EQU     008H            ; DISKETTE DRIVE HAS 80 TRACKS
;------ CMOS NON-VOLATILE RAM EQUATES
CMOSDSB_ADDR    EQU     00EH            ; DISKETTE STATUS BYTE ADDRESS
CADR_PRT        EQU     070H            ; CMOS ADDRESS PORT ADDRESS
CDATA_PRT       EQU     071H            ; CMOS DATA PORT ADDRESS
CMOS_GOOD       EQU     0C0H            ; BATTERY AND CHECKSUM INDICATOR
CMOSDSK_BYTE    EQU     010H            ; DISKETTE BYTE ADDRESS
LOWNIB          EQU     00FH            ; ISOLATE LOW NIBBLE IN REGISTER MASK
INVALID_DRV     EQU     002H            ; FIRST INVALID DISKETTE TYPE
;----------------------------------------
;       TIMER DATA AREA                 :
;----------------------------------------
; COUNTS_SEC    EQU     18
; COUNTS_MIN    EQU     1092
; COUNTS_HOUR   EQU     65543
; COUNTS_DAY    EQU     1573040 = 1800B0H
PAGE
