!IF 0

Copyright (c) 1994  Microsoft Corporation

Module Name:

    i386mk.inc

Abstract:

        This module contains the x86 specific build controls.  It is included
        by makefile.def.

Author:

    Jeff Havens (jhavens) 13-Feb-1994

Revision History:

!ENDIF

#
# x86 option control
#

UMBASE=$(UMBASE:*=i386)
UMLIBS=$(UMLIBS:*=i386)
NTRES=$(NTRES:*=i386)
UMRES=$(UMRES:*=i386)
UMOBJS=$(UMOBJS:*=i386)
LINKLIBS=$(LINKLIBS:*=i386)
DLLBASE=$(DLLBASE:*=i386)
DLLDEF=$(DLLDEF:*=i386)
MACHINE_TARGETLIBS=$(MACHINE_TARGETLIBS:*=i386)
TARGET=$(TARGET:*=i386)
DYNLINK_LIB=$(DYNLINK_LIB:*=i386)
TARGETEXEFILES=$(TARGETEXEFILES:*=i386)
TARGETLIBFILES=$(TARGETLIBFILES:*=i386)
TARGETOBJFILES=$(TARGETOBJFILES:*=i386)
UMOBJFILES=$(UMOBJFILES:*=i386)
UMEXEFILES=$(UMEXEFILES:*=i386)
HEADERFILE=$(HEADERFILE:*=i386)
HEADEROBJNAME=$(HEADEROBJNAME:*=i386)
HEADEROBJ=$(HEADEROBJ:*=i386)
PRECOMPILED=$(PRECOMPILED:*=i386)
PRECOMPILED_CXX=$(PRECOMPILED_CXX:*=i386)
PRECOMPILED_TARGET=$(PRECOMPILED_TARGET:*=i386)

!ifdef NTTARGETFILES
NTTARGETFILES=$(NTTARGETFILES:*=i386)
!endif
!ifdef NTTARGETFILE0
NTTARGETFILE0=$(NTTARGETFILE0:*=i386)
!endif
!ifdef NTTARGETFILE1
NTTARGETFILE1=$(NTTARGETFILE1:*=i386)
!endif

!IF "$(DLLENTRY)" != "-noentry"
DLLENTRY=$(DLLENTRY)@12
!ENDIF

!IFDEF STD_CALL_ENTRY
UMENTRY=$(UMENTRY)@4
!ENDIF

ENTRY_SUFFIX=@8

!IFDEF 386_WARNING_LEVEL
MSC_WARNING_LEVEL=$(386_WARNING_LEVEL)
!ENDIF
!IFDEF 386_OPTIMIZATION
MSC_OPTIMIZATION=$(386_OPTIMIZATION)
!message $(MAKEDIR)\sources (1) : Overriding default optimizations with $(386_OPTIMIZATION)
!ELSE
!IF "$(CBSTRING)" == ""
MSC_OPTIMIZATION=$(MSC_OPTIMIZATION) /Gf /QI6
!ELSE
MSC_OPTIMIZATION=$(MSC_OPTIMIZATION) /QI6
!ENDIF
!ENDIF
!IFDEF 386_CPPFLAGS
MSC_CPPFLAGS=$(386_CPPFLAGS)
!ENDIF

STDFLAGS= /c /Zel /Zp8 /Gy $(CBSTRING) $(MSC_WARNING_LEVEL) $(MSC_CALL_TYPE) $(MAX_ID_LENGTH) /G4

LINKLIBS=$(LINKLIBS) $(BASEDIR)\public\sdk\lib\i386\int64.lib

!IF "$(TARGETTYPE)"=="DRIVER" || \
    "$(TARGETTYPE)"=="MINIPORT"
#
#Drivers don't link with link libs.
#

MACHINE_TARGETLIBS=$(MACHINE_TARGETLIBS) $(BASEDIR)\public\sdk\lib\i386\int64.lib
!ENDIF

!IF "$(386_STDCALL)" == "0"
MSC_CALL_TYPE=/Gd
MSC_CALL_DEFINE=
!ELSE
!   IF "$(386_STDCALL)" == "2"
MSC_CALL_TYPE=/Gr
MSC_CALL_DEFINE=
!   ELSE
MSC_CALL_TYPE=/Gz
MSC_CALL_DEFINE=-DSTD_CALL
!   ENDIF
!ENDIF

!IF "$(NTDEBUG)" == "retail" || "$(NTDEBUG)" == ""
!   IFDEF NTNOFPO
TARGET_DBG_DEFINES= $(TARGET_DBG_DEFINES) -DFPO=0
DBGFLAGS=$(DBGFLAGS) /Oy-
!   ELSE
TARGET_DBG_DEFINES= $(TARGET_DBG_DEFINES) -DFPO=1
DBGFLAGS=$(DBGFLAGS) /Oy
!   ENDIF
!ELSE
TARGET_DBG_DEFINES= $(TARGET_DBG_DEFINES) -DFPO=0
DBGFLAGS=$(DBGFLAGS) /Oy-
!ENDIF

# Use /Z7 instead of /Zi

DBGFLAGS=$(DBGFLAGS:/Zi=/Z7)

!IFDEF NTLEGO
DBGFLAGS=$(DBGFLAGS) /Z7
386_ADBGFLAGS=/Zi
LINKER=$(LINKER) -debug:full -debugtype:cv,fixup
!ENDIF

!IF "$(BROWSER_INFO)" == "yes"
BROWSER= -FR$*.sbr
!ELSE
BROWSER=
!ENDIF


#
# 386 option control
#

ENV_DEFINES= $(MSC_CPPFLAGS) $(NTCPPFLAGS)

!IF "$(HALTYPE)" == ""
HALDEF=
!ELSE
HALDEF=-D$(HALTYPE)=1
!ENDIF

STD_DEFINES= -D_X86_=1 -Di386=1 $(HALDEF) $(MSC_CALL_DEFINE) $(STD_DEFINES)

CDEFINES=$(STD_DEFINES) $(TARGET_DBG_DEFINES) $(ENV_DEFINES) \
              $(LIBC_DEFINES) $(C_DEFINES) $(NET_C_DEFINES)
CFLAGS=$(386_FLAGS) $(NT386FLAGS) $(STDFLAGS) $(DBGFLAGS) \
              $(BROWSER) $(386_PERFFLAGS) $(USER_C_FLAGS)
386_ASMFLAGS=$(386_ADBGFLAGS) $(BROWSER) $(STD_DEFINES) \
              $(TARGET_DBG_DEFINES) $(ENV_DEFINES) $(ASM_DEFINES)

386_CDEFINES=$(CDEFINES)
386_CFLAGS=$(CFLAGS)

C_COMPILER=cl386 -nologo -I i386\ -I . $(INCPATH1) $(CDEFINES) $(PRECOMPILED) $(CFLAGS) $(CAIRO_WARNINGS)
CXX_COMPILER=cl386 -nologo -I i386\ -I . $(INCPATH1) $(CDEFINES) $(PRECOMPILED_CXX) $(CFLAGS)  $(CAIRO_WARNINGS)
C_PREPROCESSOR=cl386 -nologo /EP -I i386\ -I . $(INCPATH1) $(CDEFINES) $(CFLAGS) -Tc
386_ASSEMBLER=ml -c -coff -Cx -nologo -I i386\ -I . $(INCPATH1) -Zm $(386_ASMFLAGS)

ECHO_MSG=echo $(C_COMPILER) $<
ECHO_PRECOMPILED_MSG=echo $(C_COMPILER) /Yl$(TARGETNAME) $(HEADERFILE) $(HEADEROBJ) $(PRECOMPILED_FLAG) $(PRECOMPILED_INCLUDE)

{}.c{}.asm:
    $(C_COMPILER) /Fa $(MAKEDIR)\$(<F)

{..\i386\}.asm{}.lst:
    $(386_ASSEMBLER) /Fl$@ /Foobj\i386\$(@B).obj $<

{i386\}.asm{}.lst:
    $(386_ASSEMBLER) /Fl$@ /Fo$(MAKEDIR)\obj\i386\$(@B).obj $<

{..\i386\}.asm{obj\i386\}.obj:
    $(386_ASSEMBLER) -Fo$(MAKEDIR)\$@ $<

{i386\}.asm{obj\i386\}.obj:
    $(386_ASSEMBLER) -Fo$(MAKEDIR)\$@ $<

LINKFLAGS=$(LNKFLAGS)

# LIBRARIAN=$(LIBRARIAN:-machine:i386=-machine:ix86)
# LINKER=$(LINKER:-machine:i386=-machine:ix386)
LIBRARY_OBJS=$(LINKLIBS) $(OBJECTS)

!IFDEF CAIRO_PRODUCT
!IFDEF _CAIRO386TREE
_NTTREE=$(_CAIRO386TREE)
!ENDIF
!ELSEIFDEF CHICAGO_PRODUCT
!IFDEF _CHICAGO386TREE
_NTTREE=$(_CHICAGO386TREE)
!ENDIF
!ELSEIFDEF _NT386TREE
_NTTREE=$(_NT386TREE)
!ENDIF

!IFDEF _NT386LIBS
_NTLIBS=$(_NT386LIBS)
!ENDIF

COPYDST=$(386COPYDST)
LIB_COPY=nti386cp.cmd

!IF "$(NTDEBUGTYPE)" == "windbg" || "$(NTDEBUGTYPE)" == "both"
NTTEST_LINK_OPTIONS=-entry:main
!ELSE
NTTEST_LINK_OPTIONS=-fixed -base:0x80100000 -entry:main
!ENDIF
