#include "precomp.h"
#pragma hdrstop
#pragma hdrstop
#define FOREGROUND_WHITE (FOREGROUND_BLUE | FOREGROUND_GREEN | FOREGROUND_RED)


typedef struct _BITMAPINFOPAT
{
    BITMAPINFOHEADER                 bmiHeader;
    RGBQUAD                          bmiColors[16];
} BITMAPINFOPAT;

BITMAPINFOPAT bmiPat =
{
    {
        sizeof(BITMAPINFOHEADER),
        128,
        32,
        1,
        1,
        BI_RGB,
        (32 * 128 / 8),
        0,
        0,
        2,
        2
    },

    {                               // B    G    R
        { 0,   0,   0x80,0 },       // 1
        { 0,   0x80,0,   0 },       // 2
        { 0,   0,   0,   0 },       // 0
        { 0,   0x80,0x80,0 },       // 3
        { 0x80,0,   0,   0 },       // 4
        { 0x80,0,   0x80,0 },       // 5
        { 0x80,0x80,0,   0 },       // 6
        { 0xC0,0xC0,0xC0,0 },       // 7

        { 0x80,0x80,0x80,0 },       // 8
        { 0,   0,   0xFF,0 },       // 9
        { 0,   0xFF,0,   0 },       // 10
        { 0,   0xFF,0xFF,0 },       // 11
        { 0xFF,0,   0,   0 },       // 12
        { 0xFF,0,   0xFF,0 },       // 13
        { 0xFF,0xFF,0,   0 },       // 14
        { 0xFF,0xFF,0xFF,0 }        // 15
    }
};

static BYTE abBigCat[] = {
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,

                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,

                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,

                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};


DWORD
main(
    int argc,
    char *argv[]
    )
{
    SECURITY_ATTRIBUTES SecurityAttributes;
    HANDLE Handle;
    int i;
    CONSOLE_GRAPHICS_BUFFER_INFO GraphicsInfo;
    SMALL_RECT Rect;
    BOOL Success;
    ULONG NumWritten;

    DbgPrint( "TGRAPH: Entering graphics Test Program\n" );


        //
        // open a new console
        //

        SecurityAttributes.bInheritHandle = FALSE;
        SecurityAttributes.lpSecurityDescriptor = NULL;
        SecurityAttributes.nLength = sizeof (SECURITY_ATTRIBUTES);
        GraphicsInfo.dwBitMapInfoLength = sizeof(bmiPat);
        GraphicsInfo.lpBitMapInfo = &bmiPat;
        GraphicsInfo.dwUsage = DIB_RGB_COLORS;
        Handle = CreateConsoleScreenBuffer(GENERIC_READ | GENERIC_WRITE,
                                           FILE_SHARE_READ | FILE_SHARE_WRITE,
                                           &SecurityAttributes,
                                           CONSOLE_GRAPHICS_BUFFER,
                                           &GraphicsInfo
                                          );
        if (Handle == (HANDLE)-1) {
            DbgPrint("CreateConsoleScreenBuffer failed\n");
            return FALSE;
        }

        //
        // make it current
        //

        if (!SetConsoleActiveScreenBuffer(Handle)) {
            DbgPrint("SetConsoleActiveScreenBuffer failed\n");
            return FALSE;
        }
        /*
        //
        // try to write to it.  should fail.
        //

        Success = WriteFile(Handle,"foo",3,&NumWritten,NULL);
        if (!Success) {
            DbgPrint("WriteFile failed\n");
        }
        else {
            DbgPrint("WriteFile succeeded\n");
        }
        */
        //
        // grab mutex
        //

        Success = WaitForSingleObject(GraphicsInfo.hMutex,-1);
        if (Success) {
            DbgPrint("WaitForSingleObject failed\n");
        }
        else {
            DbgPrint("WaitForSingleObject succeeded\n");
        }

        //
        // write bitmap to memory
        //

        RtlCopyMemory(GraphicsInfo.lpBitMap,abBigCat,(32*128/8));

        //
        // release mutex
        //

        ReleaseMutex(GraphicsInfo.hMutex);

        //
        // write bitmap to memory
        //

        Rect.Left = 0;
        Rect.Top =  0;
        Rect.Right = 31;
        Rect.Bottom = 31;
        Success = InvalidateConsoleDIBits(Handle,&Rect);
        if (!Success) {
            DbgPrint("InvalidateConsoleDIBits failed\n");
        }
        else {
            DbgPrint("InvalidateConsoleDIBits succeeded\n");
        }

        /*
        i=0;
        while (i<20) {
            INPUT_RECORD Buffer;
            DWORD NumRead;

            ReadConsoleInput(GetStdHandle(STD_INPUT_HANDLE),
                             &Buffer,
                             1,
                             &NumRead);
            if (Buffer.EventType == MOUSE_EVENT) {
                DbgPrint("Mouse position is %d %d\n",
                          Buffer.Event.MouseEvent.dwMousePosition.X,
                          Buffer.Event.MouseEvent.dwMousePosition.Y);
                i++;
            }
        }
        */

        while (TRUE) {
            Sleep(10000);
        }

        if (!SetConsoleActiveScreenBuffer(GetStdHandle(STD_OUTPUT_HANDLE))) {
            DbgPrint("SetConsoleActiveScreenBuffer failed\n");
            return FALSE;
        }

        if (!CloseHandle(Handle)) {
            DbgPrint("CloseHandle failed\n");
            return FALSE;
        }

    DbgPrint( "TGRAPH: Exiting Test Program\n" );

    return TRUE;
}
