/*++ build version: 0002    // increment this if a change has global effects

/****************************** Module Header ******************************\
* Module Name: user.h
*
* Copyright (c) 1985-91, Microsoft Corporation
*
* This header file contains stuff shared by all the modules of the USER.DLL.
*
* History:
* 09-18-90 DarrinM      Created.
* 04-27-91 DarrinM      Merged in USERCALL.H, removed some dead wood.
\***************************************************************************/

#ifndef _USER_
#define _USER_

/***************************************************************************\
* Pre-#include constants
*
* Some constants need to be defined BEFORE windows.h and the other header
* files are included.  Group such constants here:
*
\***************************************************************************/

#if DBG
#define DEBUG
#endif

#define OEMRESOURCE 1

#include <windows.h>
#include <ddeml.h>
#include "ddemlp.h"
#include <winuserp.h>
#include <winbasep.h>
#include <winsecp.h>
#include <dde.h>
#include <ddetrack.h>
#include <stddef.h>
#include <winp.h>
#include "kbd.h"
#include <wowuserp.h>
#include <memory.h>
#include <string.h>
#include "vkoem.h"

#ifdef UNICODE
#define UTCHAR WCHAR
#else
#define UTCHAR UCHAR
#endif

/***************************************************************************\
* These cool constants can be used to specify rops
\***************************************************************************/

#define DESTINATION (DWORD)0x00AA0000
#define SOURCE      (DWORD)0x00CC0000
#define PATTERN     (DWORD)0x00F00000

/***************************************************************************\
* ANSI/Unicode function names
*
* For non-API Client/Server stubs, an "A" or "W" suffix must be added.
* (API function names are generated by running wcshdr.exe over winuser.x)
*
\***************************************************************************/
#ifdef UNICODE
#define TEXT_FN(fn) fn##W
#else
#define TEXT_FN(fn) fn##A
#endif

#ifdef UNICODE
#define BYTESTOCHARS(cb) ((cb) / sizeof(TCHAR))
#define CHARSTOBYTES(cch) ((cch) * sizeof(TCHAR))
#else
#define BYTESTOCHARS(cb) (cb)
#define CHARSTOBYTES(cch) (cch)
#endif

/*
 * These should be made public and moved to WINUSER.H.
 */
#define szMENUCLASS           MAKEINTATOM(0x8000)     /* Public Knowledge */
#define szEDITCLASS           TEXT("Edit")
#define szBUTTONCLASS         TEXT("Button")
#define szSTATICCLASS         TEXT("Static")
#define szLISTBOXCLASS        TEXT("ListBox")
#define szSCROLLBARCLASS      TEXT("ScrollBar")
#define szCOMBOLISTBOXCLASS   TEXT("ComboLBox")
#define szCOMBOBOXCLASS       TEXT("ComboBox")
#define szMDICLIENTCLASS      TEXT("MDIClient")
#define szDDEMLEVENTCLASS     TEXT("DDEMLEvent")
#define szDDEMLMOTHERCLASS    TEXT("DDEMLMom")
#define szDDEMLCLIENTCLASSW   L"DDEMLUnicodeClient"
#define szDDEMLSERVERCLASSW   L"DDEMLUnicodeServer"
#define szDDEMLCLIENTCLASSA   "DDEMLAnsiClient"
#define szDDEMLSERVERCLASSA   "DDEMLAnsiServer"


/***************************************************************************\
* Normal Stuff
*
* Nice normal typedefs, defines, prototypes, etc that everyone wants to share.
*
\***************************************************************************/


/*
 * These constants have to be known during pass one of the compilier because
 * they are used by in-line assembly so they are defined here and check at run
 * time by the TEBOffsetCheck macro in UserServerDllInitialization
 */

#define TEB_Win32ThreadInfo         0x40
#define TEB_Win32ProcessInfo        0x3C

#ifdef DBG
#define TEBOffsetCheck()    {UserAssert(TEB_Win32ThreadInfo  == FIELD_OFFSET(TEB, Win32ThreadInfo));  \
                             UserAssert(TEB_Win32ProcessInfo == FIELD_OFFSET(TEB, Win32ProcessInfo)); }
#else
#define TEBOffsetCheck()
#endif

/*
 * Generic message format used by several server side APIs.
 *
 * N.B. This MUST identically match the individual API structures since it
 *      is used by the User server API dispatcher.
 *
 */

typedef struct _FNGENERICMSG {
    CSR_QLPC_API_MSG csr;
    HWND hwnd;
    UINT msg;
    DWORD wParam;
    LONG lParam;
    DWORD xParam;
    DWORD xpfnProc;
} FNGENERICMSG, *PFNGENERICMSG;

/*
 * This is used by the cool client side DrawIcon code
 */
typedef struct _DRAWICONDATA {
    HBITMAP hbmMask;
    HBITMAP hbmColor;
    int cx;
    int cy;
} DRAWICONDATA;

/*
 * Version macros
 */
#define VER40           0x0400
#define VER31           0x030A
#define VER30           0x0300
#define VER20           0x0201

#define Is400Compat(dwExpWinVer)  (LOWORD(dwExpWinVer) >= 0x0400)
#define Is310Compat(dwExpWinVer)  (LOWORD(dwExpWinVer) >= 0x030A)
#define Is300Compat(dwExpWinVer)  (LOWORD(dwExpWinVer) >= 0x0300)

typedef struct tagCURSORRESOURCE {
    WORD xHotspot;
    WORD yHotspot;
    BITMAPINFOHEADER bih;
} CURSORRESOURCE, *PCURSORRESOURCE;

/*
 * We don't need 64-bit intermediate precision so we use this macro
 * instead of calling MulDiv.
 */
#define MultDiv(x, y, z)        (((INT)(x) * (INT)(y) + (INT)(z) / 2) / (INT)(z))

#define NextWordBoundary(p)     ((PBYTE)p + ((DWORD)p & 1))
#define NextDWordBoundary(p)    ((PBYTE)(p) + ((DWORD)(-(LONG)(p)) & 3))

typedef DWORD  ICH;
typedef ICH *LPICH;

typedef struct _PROPSET {
    HANDLE hData;
    ATOM atom;
} PROPSET, *PPROPSET;

#define UserGlobalAlloc(flags, size)        GlobalAlloc(flags, size)
#define UserGlobalReAlloc(pmem, cnt, flags) GlobalReAlloc(pmem,cnt,flags)
#define UserGlobalFree(pmem)                GlobalFree(pmem)
#define UserGlobalSize(pmem)                GlobalSize(pmem)
#define WOWGLOBALFREE(pmem)                 GlobalFree(pmem)

/*
 * Special internal codes for menu item bitmaps. So that internally, we can
 * have menu items with bitmaps without having to store a second (or more)
 * copy of the bitmap.  Currently, these are only used for MDI hacks to place
 * restore and close bitmaps into the menu bar.
 */
#define MENUHBM_CHILDCLOSE   (UINT)1
#define MENUHBM_RESTORE      (UINT)2
#define MENUHBM_MINIMIZE     (UINT)3
#define MENUHBM_MAX          (UINT)4

/*
 * Special internal combo box messages - used by client & server
 */
#define CBLISTBOXID         1000


// Event stuff --------------------------------------------

typedef struct tagEVENT_PACKET {
    DWORD EventType;    // == apropriate afCmd filter flag
    WORD  fSense;       // TRUE means flag on is passed.
    WORD  cbEventData;  // size of data starting at Data field.
    DWORD Data;         // event specific data - must be last
} EVENT_PACKET, *PEVENT_PACKET;

typedef struct tagREGISTER_EVENT_INFO {
    ATOM aService;
    HWND hwndInitiate;
} REGISTER_EVENT_INFO, *PREGISTER_EVENT_INFO;

// Window long offsets in mother window     (szDDEMLMOTHERCLASS)

#define GWL_INSTANCE_INFO   0       // PCL_INSTANCE_INFO


// Window long offsets in client window     (szDDEMLCLIENTCLASS)

#define GWL_PCI             0
#define GWL_CONVCONTEXT     GWL_PCI + sizeof(PVOID)
#define GWL_CONVSTATE       GWL_CONVCONTEXT + sizeof(CONVCONTEXT)   // See CLST_ flags
#define GWL_SHINST          GWL_CONVSTATE + sizeof(LONG)
#define GWL_CHINST          GWL_SHINST + sizeof(LONG)

#define CLST_CONNECTED              0
#define CLST_SINGLE_INITIALIZING    1
#define CLST_MULT_INITIALIZING      2

// Window long offsets in server window     (szDDEMLSERVERCLASS)

#define GWL_PSI             0

// Window long offsets in event window      (szDDEMLEVENTCLASS)

#define GWL_PSII            0


// DDEML stub prototypes

DWORD CsUpdateInstance(HANDLE hInst, LPDWORD pMonFlags,
    DWORD afCmd);
DWORD CsDdeInitialize(LPDWORD phInst, HWND *phwnd,
    LPDWORD pMonFlags, DWORD afCmd, PVOID pcii);
DWORD CsEvent(PEVENT_PACKET pep);
PVOID CsValidateInstance(HANDLE hInst);

/***************************************************************************\
* Internal ListBox messages
*
* History:
\***************************************************************************/

#define DF_WINDOWFRAME      (COLOR_WINDOWFRAME << 3)


/*
 * CreateWindowEx internal flags for dwExStyle
 */

#define WS_EX_MDICHILD      0x00000040L         // Internal
#define WS_EX_ANSICREATOR   0x80000000L         // Internal

/*
 * Calculate the byte offset of a field in a structure of type type.
 */
#define FIELDOFFSET(type, field)    ((UINT)&(((type *)0)->field))

#define FLASTKEY 0x80

/***************************************************************************\
* WOW Prototypes, Typedefs and Defines
*
* WOW registers resource callback functions so it can load 16 bit resources
* transparently for Win32.  At resource load time, these WOW functions are
* called.
*
\***************************************************************************/


/*
 * This is the structure these callback addresses are kept in.
 */
typedef struct _RESCALLS {
    PFNFINDA    pfnFindResourceExA;
    PFNFINDW    pfnFindResourceExW;
    PFNLOAD     pfnLoadResource;
    PFNLOCK     pfnLockResource;
    PFNUNLOCK   pfnUnlockResource;
    PFNFREE     pfnFreeResource;
    PFNSIZEOF   pfnSizeofResource;
} RESCALLS;
typedef RESCALLS *PRESCALLS;

BOOL  APIENTRY _FreeResource(HANDLE hResData, HANDLE hModule);
LPSTR APIENTRY _LockResource(HANDLE hResData, HANDLE hModule);
BOOL  APIENTRY _UnlockResource(HANDLE hResData, HANDLE hModule);

#define FINDRESOURCEA(hModule,lpName,lpType)         ((*(prescalls->pfnFindResourceExA))(hModule, lpType, lpName, 0))
#define FINDRESOURCEW(hModule,lpName,lpType)         ((*(prescalls->pfnFindResourceExW))(hModule, lpType, lpName, 0))
#define FINDRESOURCEEXA(hModule,lpName,lpType,wLang) ((*(prescalls->pfnFindResourceExA))(hModule, lpType, lpName, wLang))
#define FINDRESOURCEEXW(hModule,lpName,lpType,wLang) ((*(prescalls->pfnFindResourceExW))(hModule, lpType, lpName, wLang))
#define LOADRESOURCE(hModule,hResInfo)               ((*(prescalls->pfnLoadResource))(hModule, hResInfo))
#define LOCKRESOURCE(hResData, hModule)              ((*(prescalls->pfnLockResource))(hResData, hModule))
#define UNLOCKRESOURCE(hResData, hModule)            ((*(prescalls->pfnUnlockResource))(hResData, hModule))
#define FREERESOURCE(hResData, hModule)              ((*(prescalls->pfnFreeResource))(hResData, hModule))
#define SIZEOFRESOURCE(hModule,hResInfo)             ((*(prescalls->pfnSizeofResource))(hModule, hResInfo))
#define GETEXPWINVER(hModule)                        ((*(pfnGetExpWinVer))(hModule))

/*
 * Header of the resource file in the new format
 */
#ifndef RC_INVOKED       // RC can't handle #pragmas
#pragma pack(2)
typedef struct tagNEWHEADER {
    WORD reserved;
    WORD rt;
    WORD cResources;
} NEWHEADER, *LPNEWHEADER;

typedef struct tagICONDIR {
    BYTE Width;            /* 16, 32, 64 */
    BYTE Height;           /* 16, 32, 64 */
    BYTE ColorCount;       /* 2, 8, 16 */
    BYTE reserved;
} ICONDIR;

typedef struct tagCURSORDIR {
    WORD Width;
    WORD Height;
} CURSORDIR;

typedef struct tagRESDIR {
    union {
        ICONDIR Icon;
        CURSORDIR Cursor;
    } ResInfo;

    WORD Planes;
    WORD BitCount;
    DWORD BytesInRes;
    WORD idIcon;
} RESDIR;
typedef RESDIR *LPRESDIR;
#pragma pack()
#endif // !RC_INVOKED

typedef PVOID PBITMAPRESOURCE;

/***************************************************************************\
* Thank Prototypes
*
* This is what's left of USERCALL.H.
*
\***************************************************************************/

/*
 * Special types we've fabricated for special Thanks.
 */
typedef struct {
    POINT point1;
    POINT point2;
    POINT point3;
    POINT point4;
    POINT point5;
} POINT5, *LPPOINT5;

typedef struct {
    int int1;
    int int2;
} INT2, *LPINT2;

/*
 * Information about the current display.
 */
typedef struct tagDISPLAYINFO {   /* di */
    DWORD   cx;
    DWORD   cy;
    UINT    cxIcon;
    UINT    cyIcon;
    UINT    cxPixelsPerInch;  /* logical pixels per inch in X direction */
    UINT    cyPixelsPerInch;  /* logical pixels per inch in Y direction */
    UINT    cxCursor;
    UINT    cyCursor;
    UINT    cPlanes;
    UINT    cBitsPixel;
} DISPLAYINFO, *PDISPLAYINFO;

/*
 * Server side address constants. When we want to call a server side proc,
 * we pass an index indentifying the function, rather than the server side
 * address itself. More robust.  The functions between WNDPROCSTART/END
 * have client side sutbs which map to this routines.
 */
#define FNID_START                  0x0000029A
#define FNID_WNDPROCSTART           0x0000029A

#define FNID_BUTTON                 0x0000029A      // xxxButtonWndProc;
#define FNID_SCROLLBAR              0x0000029B      // xxxSBWndProc;
#define FNID_LISTBOX                0x0000029C      // xxxLBoxCtlWndProc;
#define FNID_STATIC                 0x0000029D      // xxxStaticWndProc;
#define FNID_DIALOG                 0x0000029E      // xxxDefDlgProc;
#define FNID_COMBOBOX               0x0000029F      // xxxComboBoxCtlWndProc
#define FNID_COMBOLISTBOX           0x000002A0      // xxxLBoxCtlWndProc;
#define FNID_MDICLIENT              0x000002A1      // xxxMDIClientWndProc;
#define FNID_ICONTITLE              0x000002A2      // xxxTitleWndProc;
#define FNID_MENU                   0x000002A3      // xxxMenuWindowProc;
#define FNID_MDIACTIVATEDLGPROC     0x000002A4      // xxxMDIActivateDlgProc
#define FNID_MB_DLGPROC             0x000002A5      // xxxMB_DlgProc;
#define FNID_DEFWINDOWPROC          0x000002A6      // xxxDefWindowProc;

#define FNID_WNDPROCEND             0x000002A6

#define FNID_DEFMDICHILDPROC        0x000002A7
#define FNID_DEFFRAMEPROC           0x000002A8

#define FNID_SERVERONLYWNDPROCEND   0x000002A8      // see PatchThreadWindows

#define FNID_HKINTRUEINLPCWPSTRUCT  0x000002A9
#define FNID_HKINFALSEINLPCWPSTRUCT 0x000002AA
#define FNID_EDIT                   0x000002AB      // No server side proc
#define FNID_SENDMESSAGE            0x000002AC
#define FNID_UNUSED                 0x000002AD      // !!! unused
#define FNID_CALLNEXTHOOKPROC       0x000002AE
#define FNID_SENDMESSAGEFF          0x000002AF
#define FNID_SENDMESSAGEEX          0x000002B0
#define FNID_CALLWINDOWPROC         0x000002B1
#define FNID_DESKTOP                0x000002B2

#define FNID_END                    0x000002B2

/*
 * The size of the server side function table is defined as a power of two
 * so a simple "and" operation can be used to determine if a function index
 * is legal or not. Unused entries in the table are fill with a routine that
 * catches invalid functions that have indices within range, but are not
 * implemented.
 */

#define FNID_ARRAY_SIZE             32
#if (FNID_END - FNID_START) > FNID_ARRAY_SIZE
#error "The size of the function array is greater than the allocated storage"
#endif

#define FNID_DELETED_BIT            0x00008000

#define FNID(s)     (gpsi->mpFnidPfn[((DWORD)(s) - FNID_START) & (FNID_ARRAY_SIZE - 1)])
#define STOCID(s)   (gpsi->aStoCidPfn[(DWORD)((s) & ~FNID_DELETED_BIT) - FNID_START])
#define CBFNID(s)   (gpsi->mpFnid_serverCBWndProc[(DWORD)((s) & ~FNID_DELETED_BIT) - FNID_START])
#define GETFNID(pwnd)       ((pwnd)->fnid & ~FNID_DELETED_BIT)

/*
 * Structure passed by client during process initialization that holds some
 * client-side callback addresses.
 */
typedef struct _PFNCLIENT {
    PROC pfnButtonWndProc;          // and must be paired Unicode then ANSI
    PROC pfnScrollBarWndProc;
    PROC pfnListBoxWndProc;
    PROC pfnStaticWndProc;
    PROC pfnDialogWndProc;
    PROC pfnComboBoxWndProc;
    PROC pfnComboListBoxProc;
    PROC pfnMDIClientWndProc;
    PROC pfnTitleWndProc;
    PROC pfnMenuWndProc;
    PROC pfnMDIActivateDlgProc;
    PROC pfnMB_DlgProc;
    PROC pfnDefWindowProc;

// Below not in FNID_WNDPROCSTART FNID_WNDPROCEND range

    PROC pfnHkINTRUEINLPCWPSTRUCT;  // client-side callback for hook thunks
    PROC pfnHkINFALSEINLPCWPSTRUCT; // client-side callback for hook thunks
    PROC pfnDispatchHook;
    PROC pfnDispatchMessage;
    PROC pfnDispatchDlgProc;
    PROC pfnEditWndProc;
} PFNCLIENT, *PPFNCLIENT;

/*
 * This structure is a clone of CREATESTRUCT except 'LPVOID lpCreateParams'
 * is changed to 'LPMDICREATESTRUCT lpmcs'.  We use this to generate a
 * special stub that can properly copy the WM_(NC)CREATE for MDI child
 * windows.
 */
typedef struct {
    LPMDICREATESTRUCT lpmcs;
    HANDLE      hModule;
    HANDLE      hMenu;
    HWND        hwndParent;
    int         cy;
    int         cx;
    int         y;
    int         x;
    LONG        style;
    LPCWSTR     lpszName;
    LPCWSTR     lpszClass;
    DWORD       dwExStyle;
} MDICHILDCREATESTRUCT, *LPMDICHILDCREATESTRUCT;

/*
 * These types are needed before they are fully defined.
 */
typedef struct tagWND *PWND;
typedef struct tagQ *PQ;
typedef struct tagTHREADINFO *PTHREADINFO;
typedef struct tagPROCESSINFO *PPROCESSINFO;

DECLARE_HANDLE(HQ);
DECLARE_HANDLE(HTHREADINFO);

typedef LONG (APIENTRY *WNDPROC_PWND)(PWND, UINT, DWORD, LONG);
typedef LONG (APIENTRY *WNDPROC_PWNDEX)(PWND, UINT, DWORD, LONG, DWORD);
typedef BOOL (APIENTRY *WNDENUMPROC_PWND)(PWND, LPARAM);

/*
 * Object types
 */

/*
 * NOTE: Changing this table means changing hard-coded arrays that depend
 * on the index number (in security.c and in debug.c)
 */
#define TYPE_FREE           0           // must be zero!
#define TYPE_WINDOW         1           // in order of use for C code lookups
#define TYPE_MENU           2
#define TYPE_CURSOR         3
#define TYPE_SETWINDOWPOS   4
#define TYPE_HOOK           5
#define TYPE_THREADINFO     6           // thread specific info structure
#define TYPE_INPUTQUEUE     7           // input queue structure
#define TYPE_CALLPROC       8
#define TYPE_ACCELTABLE     9
#define TYPE_WINDOWSTATION  10
#define TYPE_DESKTOP        11
#define TYPE_DDEACCESS      12
#define TYPE_DDECONV        13
#define TYPE_DDEXACT        14          // DDE transaction tracking info.
#define TYPE_ZOMBIE         15
#define TYPE_CTYPES         16
#define TYPE_CONSOLE        17          // used in end task processing
#define TYPE_GENERIC        255         // used for generic handle validation

#define CWINHOOKS       (WH_MAX - WH_MIN + 1)



/*
 * These flags are used in the internal version of xxxFindWindow
 */
#define FW_BOTH 0
#define FW_16BIT 1
#define FW_32BIT 2

/*
 * System object colors.
 */
#define CSYSCOLORS          21

typedef struct tagSYSCLROBJECTS {
    HBRUSH  hbrScrollbar;
    HBRUSH  hbrDesktop;
    HBRUSH  hbrActiveCaption;
    HBRUSH  hbrInactiveCaption;
    HBRUSH  hbrMenu;
    HBRUSH  hbrWindow;
    HBRUSH  hbrWindowFrame;
    HBRUSH  hbrMenuText;
    HBRUSH  hbrWindowText;
    HBRUSH  hbrCaptionText;
    HBRUSH  hbrActiveBorder;
    HBRUSH  hbrInactiveBorder;
    HBRUSH  hbrAppWorkspace;
    HBRUSH  hbrHiliteBk;
    HBRUSH  hbrHiliteText;
    HBRUSH  hbrBtnFace;
    HBRUSH  hbrBtnShadow;
    HBRUSH  hbrGrayText;
    HBRUSH  hbrBtnText;
    HBRUSH  hbrInactiveCaptionText;
    HBRUSH  hbrBtnHighlight;
} SYSCLROBJECTS;

typedef struct tagSYSCOLORS {
    LONG    clrScrollbar;
    LONG    clrDesktop;
    LONG    clrActiveCaption;
    LONG    clrInactiveCaption;
    LONG    clrMenu;
    LONG    clrWindow;
    LONG    clrWindowFrame;
    LONG    clrMenuText;
    LONG    clrWindowText;
    LONG    clrCaptionText;
    LONG    clrActiveBorder;
    LONG    clrInactiveBorder;
    LONG    clrAppWorkspace;
    LONG    clrHiliteBk;
    LONG    clrHiliteText;
    LONG    clrBtnFace;
    LONG    clrBtnShadow;
    LONG    clrGrayText;
    LONG    clrBtnText;
    LONG    clrInactiveCaptionText;
    LONG    clrBtnHighlight;
} SYSCOLORS;

#define RIPF_PROMPTONERROR      0x00000001
#define RIPF_PROMPTONWARNING    0x00000002
#define RIPF_PROMPTONVERBOSE    0x00000004
#define RIPF_PRINTVERBOSE       0x00000008
#define RIPF_PRINTFILELINE      0x00000010

#define SET_RIP_FLAG(f)         gpsi->RipFlags |= (f)
#define CLEAR_RIP_FLAG(f)       gpsi->RipFlags &= ~(f)
#define TEST_RIP_FLAG(f)        (gpsi->RipFlags & (f))
#define TOGGLE_RIP_FLAG(f)      gpsi->RipFlags ^= (f)

/*
 * One global instance of this structure is allocated into memory that is
 * mapped into all clients' address space.  Client-side functions will
 * read this data to avoid calling the server.
 */

typedef struct tagSERVERINFO {      // si
    UINT RipFlags;                  // RIPF_ flags
    struct _HANDLEENTRY *aheList;   // handle table pointer
    DWORD cHandleEntries;           // count of handle entries in list

    /*
     * Array of server-side function pointers.
     * Client passes servers function ID so they can be easily validated;
     * this array maps function ID into server-side function address.
     * The order of these are enforced by the FNID_ constants, and must match
     * the client-side mpFnidClientPfn[] order as well.
     */
    WNDPROC_PWNDEX mpFnidPfn[FNID_ARRAY_SIZE]; // function mapping table
    WNDPROC_PWND aStoCidPfn[(FNID_WNDPROCEND - FNID_START) + 1];

    // mapping of fnid to min bytes need by server side windproc user
    WORD mpFnid_serverCBWndProc[(FNID_WNDPROCEND - FNID_START) + 1];

    /*
     * Client side functions pointer structure.
     */
    struct _PFNCLIENT apfnClientA;
    struct _PFNCLIENT apfnClientW;

    /*
     * When an iconic window is moved around with a mouse, IsWindowVisible()
     * call returns FALSE! This is because, the window is internally hidden and
     * what is visible is only a mouse cursor! But how will the Tracer guys know
     * this? They won't! So, when an Icon window is moved around, its pwnd is
     * preserved in this global and IsWindowVisible() will return a true for
     * this window!
     */
    PWND spwndDragIcon;

    /*
     * This field is used for DLL preloading to allow custom functinality
     * for all windows processes.
     */
    LPWSTR pszDllList;

    DWORD dwDebugErrorLevel;

    /*
     * All of this information should be mapped to the server, but put in
     * the desktop section so it can vary from desktop to desktop.
     */

    DWORD adwSysMet[SM_CMETRICS];
    SYSCOLORS sysColors;
    POINT ptCursor;
    SYSCLROBJECTS sysClrObjects;
    DWORD cxReduce;
    DWORD cbHandleTable;
    DWORD nEvents;

    /*
     * Is the device palette managed ?
     */
    BOOL fPaletteDisplay;

    UINT maxDefWindowMsgs;
    BYTE *gabDefWindowMsgs;
    UINT maxDefWindowSpecMsgs;
    BYTE *gabDefWindowSpecMsgs;
    UINT maxButtonWndProc;
    BYTE *gabButtonWndProc;
    UINT maxMenuWndProc;
    BYTE *gabMenuWndProc;
    UINT maxScrollBarWndProc;
    BYTE *gabScrollBarWndProc;
    UINT maxListBoxWndProc;
    BYTE *gabListBoxWndProc;
    UINT maxComboBoxWndProc;
    BYTE *gabComboBoxWndProc;
    UINT maxMDIClientWndProc;
    BYTE *gabMDIClientWndProc;

    /*
     * Class atoms to allow fast checks on the client.
     */
    ATOM atomConsoleClass;
    ATOM atomDesktopClass;

    DWORD dwDefaultHeapBase;            // so WOW can do handle validation
    DWORD dwDefaultHeapSize;

    PCHAR pOemToAnsi;
    PCHAR pAnsiToOem;
} SERVERINFO, *PSERVERINFO;

VOID SetServerInfoPointer(PSERVERINFO psi);


#define rgwSysMet (gpsi->adwSysMet)
#define ptCursor (gpsi->ptCursor)

/*
 * The following is the header of all objects managed in the handle list.
 * (allocated as part of the object for easy access).
 */
typedef struct _HEAD {
    HANDLE h;
    DWORD cLockObj;
    DWORD cLockObjT;
} HEAD, *PHEAD;

typedef struct _THROBJHEAD {
    HANDLE h;
    DWORD cLockObj;
    DWORD cLockObjT;
    PTHREADINFO pti;
} THROBJHEAD, *PTHROBJHEAD;

typedef struct _PROCOBJHEAD {
    HANDLE h;
    DWORD cLockObj;
    DWORD cLockObjT;
    struct tagPROCESSINFO *ppi;
    DWORD hTaskWow;
} PROCOBJHEAD, *PPROCOBJHEAD;

typedef struct _SECOBJHEAD {
    HANDLE h;
    DWORD cLockObj;
    DWORD cLockObjT;
    struct tagPROCESSINFO *ppi;
    DWORD hTaskWow;
    PSECURITY_DESCRIPTOR psd;       /* security descriptor */
    DWORD cOpen;
} SECOBJHEAD, *PSECOBJHEAD;

typedef struct tagPROCESSACCESS {
    PSECOBJHEAD     phead;
    ACCESS_MASK     amGranted;
    BOOLEAN         bGenerateOnClose;
    BOOLEAN         bInherit;
} PROCESSACCESS, *PPROCESSACCESS;

#define HANDLEF_DESTROY        0x01
#define HANDLEF_INDESTROY      0x02
#define HANDLEF_INWAITFORDEATH 0x04
#define HANDLEF_FINALDESTROY   0x08
#define HANDLEF_MARKED_OK      0x10

#define GETPTI(p)           ((p)->head.pti)
#define GETPPI(p)           ((p)->head.ppi)
#define GETPWNDPPI(p)       ((p)->head.pti->ppi)

/*
 * Lock record structure for tracking locks (debug only)
 */
typedef struct _LOCKRECORD {
    struct _LOCKRECORD *plrNext;
    DWORD  cLockObj;
    PVOID  pfn;
    PVOID  ppobj;
} LOCKRECORD, *PLR;

/*
 * The following is a "thread lock structure". This structure lives on
 * the stack and is linked into a LIFO list that is rooted in the thread
 * information structure.
 */
typedef struct _TL {
    struct _TL *next;
    PVOID pobj;
#ifdef DEBUG
    PTHREADINFO pti;
    PVOID pfn;
#endif
} TL, *PTL;

/*
 * The following is a LOCK structure. This structure is recorded for
 * each threadlock so unlocks can occur at cleanup time.
 */
typedef struct _LOCK {
    PTHREADINFO pti;
    PVOID pobj;
    struct _TL *ptl;
#ifdef DEBUG
    PVOID pfn;                      // for debugging purposes only
    int ilNext;                     // for debugging purposes only
    int iilPrev;                    // for debugging purposes only
#endif
} LOCK, *PLOCK;

/*
 * The following is a handle table entry.
 *
 * Note that by keeping a pointer to the owning entity (process or
 * thread), cleanup will touch only those objects that belong to
 * the entity being destroyed.  This helps keep the working set
 * size down.  Look at DestroyProcessesObjects() for an example.
 */
typedef struct _HANDLEENTRY {
    PHEAD   phead;                  /* pointer to the real object */
    PVOID   pOwner;                 /* pointer to owning entity (pti or ppi) */
    BYTE    bType;                  /* type of object */
    BYTE    bFlags;                 /* flags - like destroy flag */
    WORD    wUniq;                  /* uniqueness count */
#ifdef DEBUG
    PLR     plr;                    /* lock record pointer */
#endif
} HANDLEENTRY, *PHE;

/*
 * Change HMINDEXBITS for bits that make up table index in handle
 * Change HMUNIQSHIFT for count of bits to shift uniqueness left.
 * Change HMUNIQBITS for bits that make up uniqueness.
 *
 * Currently 64K handles can be created, w/16 bits of uniqueness.
 */
#define HMINDEXBITS             0x0000FFFF      // bits where index is stored
#define HMUNIQSHIFT             16              // bits to shift uniqueness
#define HMUNIQBITS              0xFFFF          // valid uniqueness bits

#define HMHandleFromIndex(i)    ((HANDLE)(i | (gpsi->aheList[i].wUniq << HMUNIQSHIFT)))
#define HMIndexFromHandle(h)    (((DWORD)h) & HMINDEXBITS)
#define HMPheFromObject(p)      (&gpsi->aheList[HMIndexFromHandle(((PHEAD)p)->h)])
#define HMObjectFromHandle(h)   ((PVOID)(gpsi->aheList[HMIndexFromHandle(h)].phead))
#define HMUniqFromHandle(h)     ((WORD)((((DWORD)h) >> HMUNIQSHIFT) & HMUNIQBITS))
#define HMObjectType(p)         (HMPheFromObject(p)->bType)

#define HMIsMarkDestroy(p)      (HMPheFromObject(p)->bFlags & HANDLEF_DESTROY)

/*
 * NOTE!: there is code in exitwin.c that assumes HMIsMarkDestroy is defined as
 *      (HMPheFromObject(p)->bFlags & HANDLEF_DESTROY)
 */

/*
 * This macro makes sure an object is thread locked. DEBUG only.
 */
#ifdef DEBUG
VOID CheckLock(PVOID pobj);
#else
#define CheckLock(p)
#endif

/*
 * Validation, handle mapping, etc.
 */
#define HMRevalidateHandle(h)       HMValidateHandle(h, TYPE_GENERIC)
#define HMRevalidateHandleNoRip(h)  HMValidateHandleNoRip(h, TYPE_GENERIC)
#define RevalidateHwnd(hwndX)       HMValidateHandleNoRip(hwndX, TYPE_WINDOW)
#define RevalidateHmenu(hmenuX)     HMValidateHandleNoRip(hmenuX, TYPE_MENU)
#define HtoPq(h)    ((PVOID)HMObjectFromHandle(h))
#define HtoP(h)     ((PVOID)HMObjectFromHandle(h))
#define PtoH(p)     ((HANDLE)((p) == NULL ? NULL : ((PHEAD)(p))->h))
#define PtoHq(p)    ((HANDLE)(((PHEAD)p)->h))
#define HW(pwnd)    ((HWND)PtoH(pwnd))
#define PW(hwnd)    ((PWND)HtoP(hwnd))

#define CPD_ANSI_TO_UNICODE     0x0001      /* CPD represents ansi to U transition */
#define CPD_UNICODE_TO_ANSI     0x0002
#define CPD_TRANSITION_TYPES    (CPD_ANSI_TO_UNICODE|CPD_UNICODE_TO_ANSI)

#define CPD_CLASS               0x0010      /* Get CPD for a class */
#define CPD_WND                 0x0020
#define CPD_DIALOG              0x0040

#define CPDHANDLE_HI            0xFFFF
#define MAKE_CPDHANDLE(h)       (MAKELONG((WORD)h,CPDHANDLE_HI))
#define ISCPDTAG(x)             (HIWORD(x) == CPDHANDLE_HI)

/*
 * Call Proc Handle Info
 */
typedef struct _CALLPROCDATA {
    HEAD            head;
    PVOID           hheapDesktop;   /* Allocation source */
    struct _CALLPROCDATA *pcpdNext;
    DWORD           pfnClientPrevious;
    WORD            wType;
} CALLPROCDATA, *PCALLPROCDATA;


/*
 * This is the window class structure.  All window classes are linked
 * together in a master list pointed to by pclsList.
 *
 * RED ALERT!  Any new fields must be added BEFORE the 'begin: same as
 * wndclass' line or the value CFOFFSET will be incorrect and TestCF will
 * not behave as desired.
 */
typedef struct tagCLS
{
    /* NOTE: The order of the following fields is assumed. */
    struct tagCLS *pclsNext;
    ATOM        atomClassName;
    PVOID       hheapDesktop;       /* Allocation source */
    struct tagDESKTOP *spdeskParent;/* Parent desktop */
    struct tagDCE *pdce;            /* PDCE to DC associated with class */
    int         cWndReferenceCount; /* The number of windows registered
                                       with this class */
    DWORD       flags;              /* internal class flags */
    LPSTR       lpszClientAnsiMenuName;     /* string or resource ID */
    LPWSTR      lpszClientUnicodeMenuName;  /* string or resource ID */

    /*
     * These DWORDs are used by WOW only.  See wow32\walias.c for the WC
     * structure definition.
     */
    DWORD       adwWOW[2];
    DWORD       dwExpWinVer;        /* windows version expectd by hmodule */
    DWORD       hTaskWow;
    PCALLPROCDATA  spcpdFirst;      /* Pointer to first CallProcData element (or 0) */
    struct tagCLS *pclsBase;        /* Pointer to base class */
    struct tagCLS *pclsClone;       /* Pointer to clone class list */

//***************************************** begin: same as wndclass
    UINT        style;
    WNDPROC_PWND lpfnWndProc;       // HI BIT on means WOW PROC
    int         cbclsExtra;
    int         cbwndExtra;
    HANDLE      hModule;
    struct tagCURSOR *spicn;
    struct tagCURSOR *spcur;
    HBRUSH      hbrBackground;
    LPWSTR      lpszMenuName;
    LPSTR       lpszAnsiClassName;
//***************************************** end: same as wndclass
} CLS, *PCLS, *LPCLS, **PPCLS;

/*
 * This class flag is used to distinguish classes that were registered
 * by the server (most system classes) from those registered by the client.
 */
#define CSF_SERVERSIDEPROC      0x00000001
#define CSF_ANSIPROC            0x00000002
#define CSF_WOWDEFERDESTROY     0x00000004
#define CSF_SYSTEMCLASS         0x00000008

/*
 * Flags used for caching window names on the client side
 */
#define WNAME_OK            0x00
#define WNAME_SYNC          0x01
#define WNAME_LARGE         0x02    // too big for reasonable cache
#define WNAME_CACHE_SIZE    100     // max size to cache

#define WND_CNT_WOWDWORDS   0x3
/*
 * This is the window instance structure.  All the window instances are
 * linked together in a master list pointed to by pwndDesktop.
 */
typedef struct tagWND           // wnd
{
    THROBJHEAD    head;

    PVOID hheapDesktop;          // Allocation source
    struct tagWND *spwndNext;    // Handle to the next window
    struct tagWND *spwndParent;  // Backpointer to the parent window.
    struct tagWND *spwndChild;   // Handle to child
    struct tagWND *spwndOwner;   // Popup window owner field
    struct tagWND *pwndNextYX;   // Transient link for YX-sorted exclusion list
    struct tagDESKTOP *spdeskParent;

    #ifdef WINMAN
    PWINDOW       pwindow;      // WinMan window
    #endif

    PVOID         pwo;          // WNDOBJ in gdi that is associated with window

    RECT          rcWindow;     // Window outer rectangle
    RECT          rcClient;     // Client rectangle

    WNDPROC_PWND lpfnWndProc;   // HI BIT on means WOW PROC

    PCLS          pcls;         // Pointer to window class
    int           cbwndExtra;   // Extra bytes in window

    HRGN          hrgnUpdate;   // Accumulated paint region

    struct tagWND *spwndLastActive; // Last active in owner/ownee list
    struct tagPROP *ppropList;  // Pointer to first property in list
    int           *rgwScroll;   // Words used for scrolling

    struct tagMENU *spmenuSys;  // Handle to system menu
    struct tagMENU *spmenu;     // Menu handle or ID
    LPWSTR        pName;        // window text (used to be hName)

    /*
     * Fullscreen information
     */
    BYTE          bFullScreen;  // record full screen state info
    BYTE          cDC;          // count of DCs associated with window
    WORD          fnid;         // record window proc used by this hwnd
                                // access through GETFNID
    DWORD         dwExpWinVer;  // matches expwinver of hModule

    DWORD         dwUserData;   // Reserved for random application data
    HDC           hdcOwn;
    int           iHungRedraw;  // Index into hung redraw table
    /*
     * These DWORDs are used by WOW only.  See wow32\walias.h
     * for the WW structure definition.
     *
     * NOTE: adwWOW must immediately preceed the state field below.
     */
    DWORD         adwWOW[WND_CNT_WOWDWORDS];

    /*
     * NOTE: The order and size of the following 4 fields is assumed
     *       by the SetWF, ClrWF, TestWF, MaskWF macros.
     *       they be the last fields in the structure.
     *
     * NOTE: The order and size of the following 4 fields is *also* assumed
     *       by WOW32.  Specifically wow32\walias.h defines the WW structure
     *       which overlays the adwWOW array and these 4 fields.
     */
    DWORD         state;        // State flags (<= HACK STARTS HERE)
    DWORD         dwExStyle;    // Extended Style
    DWORD         style;        // Style flags

    HANDLE        hModule;      // Handle to module instance data (32-bit).
} WND;

#define NEEDSPAINT(pwnd)    (pwnd->hrgnUpdate != NULL || TestWF(pwnd, WFINTERNALPAINT))
#define NEEDSSYNCPAINT(pwnd) TestWF(pwnd, WFSENDERASEBKGND | WFSENDNCPAINT)

/* Areas to be painted during activation and inactivation */
#define NC_DRAWNONE    0x00
#define NC_DRAWCAPTION 0x01
#define NC_DRAWFRAME   0x02
#define NC_DRAWBOTH    (NC_DRAWCAPTION | NC_DRAWFRAME)

typedef struct tagCVR       // cvr
{
    WINDOWPOS   pos;        // MUST be first field of CVR!
    int         xClientNew; // New client rectangle
    int         yClientNew;
    int         cxClientNew;
    int         cyClientNew;
    RECT        rcBlt;
    int         dxBlt;      // Distance blt rectangle is moving
    int         dyBlt;
    UINT        fsRE;       // RE_ flags: whether hrgnVisOld is empty or not
    HRGN        hrgnVisOld; // Previous visrgn
    PTHREADINFO pti;        // The thread this SWP should be processed on
} CVR, *PCVR;

/*
 * CalcValidRects() "Region Empty" flag values
 * A set bit indicates the corresponding region is empty.
 */
#define RE_VISNEW       0x0001  // CVR "Region Empty" flag values
#define RE_VISOLD       0x0002  // A set bit indicates the
#define RE_VALID        0x0004  // corresponding region is empty.
#define RE_INVALID      0x0008
#define RE_SPB          0x0010
#define RE_VALIDSUM     0x0020
#define RE_INVALIDSUM   0x0040

typedef struct tagSMWP {    // smwp
    HEAD           head;
    int            ccvr;        // Number of CVRs in the SWMP
    int            ccvrAlloc;   // Number of actual CVRs allocated in the SMWP
    PCVR           acvr;        // Pointer to array of CVR structures
} SMWP, *PSMWP;

/*
 * Structures needed for hung app redraw.
 */
#define CHRLINCR 10

typedef struct _HUNGREDRAWLIST {
    int cEntries;
    int iFirstFree;
    PWND apwndRedraw[1];
} HUNGREDRAWLIST, *PHUNGREDRAWLIST;

/*
 * Private User Startupinfo
 */
typedef struct tagUSERSTARTUPINFO {
    DWORD   cb;
    DWORD   dwX;
    DWORD   dwY;
    DWORD   dwXSize;
    DWORD   dwYSize;
    DWORD   dwFlags;
    WORD    wShowWindow;
    WORD    cbReserved2;
} USERSTARTUPINFO, *PUSERSTARTUPINFO;

/*
 * Hook structure.
 */
#undef HOOKBATCH
typedef struct tagHOOK {   /* hk */
    THROBJHEAD      head;
    PVOID           hheapDesktop;       // Allocation source
    struct tagHOOK *sphkNext;
    int             iHook;              // WH_xxx hook type
    DWORD           offPfn;
    UINT            flags;              // HF_xxx flags
    int             ihmod;
    HTHREADINFO     htiHooked;
#ifdef HOOKBATCH
    DWORD           cEventMessages;     // Number of events in the cache
    DWORD           iCurrentEvent;      // Current cache event
    DWORD           CacheTimeOut;       // Timeout between keys
    PEVENTMSG       aEventCache;        // The array of Events
#endif // HOOKBATCH
} HOOK, *PHOOK;

/*
 * Hook defines.
 */
#define HF_GLOBAL       0x0001
#define HF_ANSI         0x0002
#define HF_NEEDHC_SKIP  0x0004
#define HF_HUNG         0x0008          // Hook Proc hung don't call if system
#define HF_HOOKFAULTED  0x0010          // Hook Proc faulted

/*
 * Macro to convert the WH_* index into a bit position for
 * the fsHooks fields of SERVERINFO and THREADINFO.
 */
#define WHF_FROM_WH(n)     (1 << (n + 1))

/*
 * Flags for IsHooked().
 */
#define WHF_MSGFILTER       WHF_FROM_WH(WH_MSGFILTER)
#define WHF_JOURNALRECORD   WHF_FROM_WH(WH_JOURNALRECORD)
#define WHF_JOURNALPLAYBACK WHF_FROM_WH(WH_JOURNALPLAYBACK)
#define WHF_KEYBOARD        WHF_FROM_WH(WH_KEYBOARD)
#define WHF_GETMESSAGE      WHF_FROM_WH(WH_GETMESSAGE)
#define WHF_CALLWNDPROC     WHF_FROM_WH(WH_CALLWNDPROC)
#define WHF_CBT             WHF_FROM_WH(WH_CBT)
#define WHF_SYSMSGFILTER    WHF_FROM_WH(WH_SYSMSGFILTER)
#define WHF_MOUSE           WHF_FROM_WH(WH_MOUSE)
#define WHF_HARDWARE        WHF_FROM_WH(WH_HARDWARE)
#define WHF_DEBUG           WHF_FROM_WH(WH_DEBUG)
#define WHF_SHELL           WHF_FROM_WH(WH_SHELL)
#define WHF_FOREGROUNDIDLE  WHF_FROM_WH(WH_FOREGROUNDIDLE)

#define IsHooked(pti, fsHook) \
    ((fsHook & (pti->fsHooks | pti->pDeskInfo->fsHooks)) != 0)


/*
 * Keyboard Layout structure
 */
typedef struct tagKL {   /* kl */
    struct tagKL *pklNext;     // next in layout cycle
    struct tagKL *pklPrev;     // prev in layout cycle
    WCHAR         awchKL[9];   // Name of Layout eg: L"00000409"
    ULONG         TitleIndex;  // index to human readable localized name
    HANDLE        hLibModule;  // handle of layout DLL
    DWORD         dwFlags;
    PKBDTABLES    pKbdTbl;     // pointer to kbd layout data.
} KL, *PKL;

/*
 * Windowstation and desktop enum list structure.
 */
typedef struct tagNAMELIST {
    DWORD cb;
    DWORD cNames;
    WCHAR awchNames[1];
} NAMELIST, *PNAMELIST;

/*
 * Special access type to control hooking across
 * logon sessions.
 */
#define DESKTOP_HOOKSESSION     MAXIMUM_ALLOWED

/*
 * Device Information structure
 */

typedef struct tagPHYSICAL_DEV_INFO {

    WCHAR szDeviceName[14];   // logical name of video device (\\.\DISPLAYx)
    HANDLE hDeviceHandle;     // handle for that device, if it exist.

} PHYSICAL_DEV_INFO, *PPHYSICAL_DEV_INFO;

/*
 * Desktop structure
 */
typedef struct tagDESKTOPINFO {
    struct tagDISPLAYINFO di;
    struct tagWND *spwnd;               // Desktop window

    /*
     * Desktop global hooks.
     */
    DWORD fsHooks;
    struct tagHOOK *asphkStart[CWINHOOKS];
} DESKTOPINFO, *PDESKTOPINFO;

typedef struct tagDESKTOP {
    SECOBJHEAD head;
    PDESKTOPINFO pDeskInfo;

    /*
     * Device Information
     */

    PPHYSICAL_DEV_INFO pdevinfo;
    PRTL_CRITICAL_SECTION hsem;
    HDEV hdev;
    HANDLE hDisplayModule;

    struct tagDESKTOP *spdeskNext;
    struct tagWINDOWSTATION *spwinstaParent;

    DWORD dwFlags;
    LPWSTR lpszDeskName;
    struct tagWND *spwnd;               // Desktop window (same as above)
    struct tagWND *spwndMenu;
    struct tagMENU *spmenuSys;
    struct tagMENU *spmenuDialogSys;
    struct tagWND *spwndForeground;
    BOOL fMenuInUse;
    HANDLE hsectionDesktop;
    PVOID hheapDesktop;

    DWORD dwConsoleThreadId;

    #ifdef WINMAN
    PLAYER player;              // layer associated with this desktop
    #endif

} DESKTOP, *PDESKTOP;

typedef struct tagDESKWND {
    WND wnd;
    DWORD idProcess;
    DWORD idThread;
    HBITMAP hbmDesktop;
} DESKWND, *PDESKWND;

/*
 * Windowstation structure
 */
#define WSF_SWITCHLOCK  0x1
#define WSF_OPENLOCK    0x2
#define WSF_NOIO        0x4
#define WSF_SHUTDOWN    0x8

typedef struct tagWINDOWSTATION {
    SECOBJHEAD head;
    struct tagWINDOWSTATION *spwinstaNext;
    LPWSTR lpszWinStaName;
    struct tagDESKTOP *spdeskList;
    struct tagDESKTOP *spdeskLogon;

    /*
     * Pointer to the currently active desktop for the window station.
     */

    struct tagDESKTOP *spcurrentdesk;

    struct tagWND *spwndDesktopOwner;
    struct tagWND *spwndLogonNotify;
    struct tagTHREADINFO *ptiDesktop;
    DWORD dwFlags;
    struct tagKL *pklList;
    LPWSTR pwchDiacritic;
    WCHAR awchDiacritic[5];
    HANDLE hEventInputReady;

    /*
     * Clipboard variables
     */
    PTHREADINFO ptiClipLock;
    PWND spwndClipOpen;
    PWND spwndClipViewer;
    PWND spwndClipOwner;
    struct tagCLIP *pClipBase;
    int cNumClipFormats;
    UINT fClipboardChanged : 1;
    UINT fDrawingClipboard : 1;

    /*
     * Global Atom table
     */
    PVOID pGlobalAtomTable;

    HANDLE hEventSwitchNotify;
    LUID luidEndSession;
    LUID luidUser;
} WINDOWSTATION, *PWINDOWSTATION;

typedef struct tagCURSOR {
    PROCOBJHEAD head;
    struct tagCURSOR *pcurNext;
    DWORD   flags;
    LPWSTR  rt;
    LPWSTR  lpName;
    LPWSTR  pszModName;

    DWORD   cx;
    DWORD   cy;
    SHORT   xHotspot;
    SHORT   yHotspot;
    HBITMAP hbmMask;
    HBITMAP hbmColor;
} CURSOR, *PCURSOR;

#define CURSOR_ALWAYSDESTROY    0
#define CURSOR_CALLFROMCLIENT   1
#define CURSOR_THREADCLEANUP    2

#define CURSORF_FROMRESOURCE    0x0001
#define CURSORF_PUBLIC          0x0002
#define CURSORF_ACON            0x0008

typedef struct tagACON {        // acon

    PROCOBJHEAD head;
    struct tagACON *pacnNext;   // NOTE: These fields must be the same
    DWORD flags;                //       as the first fields of the CURSOR
    LPWSTR rt;                  //       structure.
    LPWSTR lpName;              //
    LPWSTR pszModName;          //

    int cpcur;                  // Count of image frames
    int cicur;                  // Count of steps in animation sequence
    PCURSOR *apcur;             // Array of image frame pointers
    DWORD *aicur;               // Array of frame indices (sequence table)
    PJIF ajifRate;              // Array of time offsets
    int iicur;                  // Current step in animation
    DWORD fl;                   // Miscellaneous flags
} ACON, *PACON;

#define ACF_REVERSE_AT_END      0x0001
#define TID_ANICURSOR           (UINT)-3

/*
 * Flags for ServerLoadCreateCursorIcon
 */
#define LCCI_CLIENTLOAD     0x0001
#define LCCI_REPLACE        0x0002
#define LCCI_DEVICEDEFAULT  0x0004
#define LCCI_SETSYSTEMCURSOR 0x0008

#define PICON PCURSOR

/*
 * Accelerator Table structure
 */
typedef struct tagACCELTABLE {
    PROCOBJHEAD head;
    ACCEL accel[1];
} ACCELTABLE, *LPACCELTABLE;


/*** AWESOME HACK ALERT!
 *
 * Window Style and State Masks -
 *
 * High byte of word is byte index from the start of the state field
 * in the WND structure, low byte is the mask to use on the byte.
 * These masks assume the order of the state and style fields of a
 * window instance structure.
 *
 * This is how the Test/Set/Clr/MaskWF value ranges map to the corresponding
 * fields in the window structure.  Note that since the high-range bits of
 * dwExStyle are unused they can be doubled up with additional state info.
 *
 * state      = 0001 - 0180 (WFMPRESENT - WFMENUDRAW)
 * dwExStyle  = 0201 - 0580 (WEFDLGMODALFRAME - WEFNOPARENTNOTIFY)
 * style (lo) = 0601 - 0780 (reserved for control-specific flags)
 * style (hi) = 0801 - 0980 (WFTABSTOP - WFPOPUP)
 */

/*
 * State flags
 */
#define WFMPRESENT          0x0001
#define WFVPRESENT          0x0002
#define WFHPRESENT          0x0004
#define WFCPRESENT          0x0008
#define WFSENDSIZEMOVE      0x0010
#define WFNOPAINT           0x0020
#define WFFRAMEON           0x0040
#define WFHASSPB            0x0080
#define WFNONCPAINT         0x0101
#define WFSENDERASEBKGND    0x0102
#define WFERASEBKGND        0x0104
#define WFSENDNCPAINT       0x0108
#define WFINTERNALPAINT     0x0110
#define WFUPDATEDIRTY       0x0120
#define WFHIDDENPOPUP       0x0140
#define WFMENUDRAW          0x0180

/*
 * Place to throw more internal flags: in 0x02?? and 0x03??.
 */
#define WFDIALOGWINDOW      0x0201
#define WFTITLESET          0x0202
#define WFSERVERSIDEPROC    0x0204
#define WFANSIPROC          0x0208
#define WF16BIT             0x0210
#define WFHASPALETTE        0x0220
#define WFPAINTNOTPROCESSED 0x0240  // WM_PAINT message not processed
#define WFWIN31COMPAT       0x0280  // Win 3.1 compatible window
#define WFALWAYSSENDNCPAINT 0x0301  // Always send WM_NCPAINT to children
#define WFPIXIEHACK         0x0302  // Send (HRGN)1 to WM_NCPAINT (see PixieHack)
#define WFTOGGLETOPMOST     0x0304  // Toggle the WS_EX_TOPMOST bit ChangeStates
#define WFREDRAWIFHUNG      0x0308
#define WFREDRAWFRAMEIFHUNG 0x0310
#define WFANYHUNGREDRAW     0x0318
#define WFANSICREATOR       0x0320
#define WFPALETTEWINDOW     0x0340
#define WFDESTROYED         0x0380

/*
 * Window Extended Style
 */
#define WEFDLGMODALFRAME  0x0401
#define WEFDRAGOBJECT     0x0402
#define WEFNOPARENTNOTIFY 0x0404
#define WEFTOPMOST        0x0408
#define WEFACCEPTFILES    0x0410
#define WEFTRANSPARENT    0x0420    // "Transparent" child window
#define WEFMDICHILD       0x0440

/*
 * Window flags for Full Window Drag.
 */
#define WFWMPAINTSENT     0x0701
#define WFDONTVALIDATE    0x0702
#define WFSTARTPAINT      0x0704
#define WFWIN40COMPAT     0x0780  // Win 4.0 compatible app


/*
 * Window styles
 */
#define WFMAXBOX          0x0A01
#define WFTABSTOP         0x0A01
#define WFMINBOX          0x0A02
#define WFGROUP           0x0A02
#define WFSIZEBOX         0x0A04
#define WFSYSMENU         0x0A08
#define WFHSCROLL         0x0A10
#define WFVSCROLL         0x0A20
#define WFDLGFRAME        0x0A40
#define WFTOPLEVEL        0x0A40
#define WFBORDER          0x0A80
#define WFBORDERMASK      0x0AC0
#define WFCAPTION         0x0AC0

#define WFTILED           0x0B00
#define WFMAXIMIZED       0x0B01
#define WFCLIPCHILDREN    0x0B02
#define WFCLIPSIBLINGS    0x0B04
#define WFDISABLED        0x0B08
#define WFVISIBLE         0x0B10
#define WFMINIMIZED       0x0B20
#define WFCHILD           0x0B40
#define WFPOPUP           0x0B80
#define WFTYPEMASK        0x0BC0
#define WFICONICPOPUP     0x0BC0
#define WFICONIC          WFMINIMIZED

/*
 * Class styles
 */
#define CFVREDRAW         0x0001
#define CFHREDRAW         0x0002
#define CFKANJIWINDOW     0x0004
#define CFDBLCLKS         0x0008
#define CFSERVERSIDEPROC  0x0010    // documented as reserved in winuser.h
#define CFOWNDC           0x0020
#define CFCLASSDC         0x0040
#define CFPARENTDC        0x0080
#define CFNOKEYCVT        0x0101
#define CFNOCLOSE         0x0102
#define CFLVB             0x0104
#define CFSAVEBITS        0x0108
#define CFSAVEPOPUPBITS   CFSAVEBITS
#define CFBYTEALIGNCLIENT 0x0110
#define CFBYTEALIGNWINDOW 0x0120
#define CFOEMCHARS        0x0140


/*
 *
 */
#define SYS_ALTERNATE       0x2000
#define SYS_PREVKEYSTATE    0x4000

/*** AWESOME HACK ALERT!!!
 *
 * The low byte of the WF?PRESENT state flags must NOT be the
 * same as the low byte of the WFBORDER and WFCAPTION flags,
 * since these are used as paint hint masks.  The masks are calculated
 * with the MaskWF macro below.
 *
 * The magnitude of this hack compares favorably with that of the national debt.
 *
 * STATEOFFSET is the offset into the WND structure of the state field.
 * Be sure to change this definition if the WND structure changes.
 */
#define STATEOFFSET \
        (sizeof(WND) - sizeof(HANDLE) - \
        sizeof(DWORD) - sizeof(DWORD) - sizeof(DWORD))


/*
 * Offset from the beginning of the CLS structure to the WNDCLASS section.
 */
#define CFOFFSET             (sizeof(CLS) - sizeof(WNDCLASS))

/*
 * Redefine LOBYTE to get rid of compiler warning C4309:
 * 'cast' : truncation of constant value
 */
#ifdef LOBYTE
#undef LOBYTE
#endif
#define LOBYTE(w)            ((BYTE)((w) & 0x00FF))

#define TestWF(hwnd, flag)   (*(((BYTE *)(hwnd)) + STATEOFFSET + (int)HIBYTE(flag)) & LOBYTE(flag))
#define SetWF(hwnd, flag)    (*(((BYTE *)(hwnd)) + STATEOFFSET + (int)HIBYTE(flag)) |= LOBYTE(flag))
#define ClrWF(hwnd, flag)    (*(((BYTE *)(hwnd)) + STATEOFFSET + (int)HIBYTE(flag)) &= ~LOBYTE(flag))
#define MaskWF(flag)         ((WORD)( (HIBYTE(flag) & 1) ? LOBYTE(flag) << 8 : LOBYTE(flag)))

#define TestCF(hwnd, flag)   (*((BYTE *)((PWND)(hwnd))->pcls + CFOFFSET + HIBYTE(flag)) & LOBYTE(flag))
#define SetCF(hwnd, flag)    (*((BYTE *)((PWND)(hwnd))->pcls + CFOFFSET + HIBYTE(flag)) |= LOBYTE(flag))
#define TestCF2(pcls, flag)  (*((BYTE *)(pcls) + CFOFFSET + (int)HIBYTE(flag)) & LOBYTE(flag))
#define SetCF2(pcls, flag)   (*((BYTE *)(pcls) + CFOFFSET + (int)HIBYTE(flag)) |= LOBYTE(flag))

#define TestwndChild(hwnd)   (TestWF(hwnd, WFTYPEMASK) == LOBYTE(WFCHILD))
#define TestwndIPopup(hwnd)  (TestWF(hwnd, WFTYPEMASK) == LOBYTE(WFICONICPOPUP))
#define TestwndTiled(hwnd)   (TestWF(hwnd, WFTYPEMASK) == LOBYTE(WFTILED))
#define TestwndNIPopup(hwnd) (TestWF(hwnd, WFTYPEMASK) == LOBYTE(WFPOPUP))
#define TestwndPopup(hwnd)   (TestwndNIPopup(hwnd) || TestwndIPopup(hwnd))
#define TestwndHI(hwnd)      (TestwndTiled(hwnd) || TestwndIPopup(hwnd))

#define GetChildParent(pwnd) (TestwndChild(pwnd) ? pwnd->spwndParent : NULL)
#define TestwndFrameOn(pwnd) (TestWF(pwnd, WFFRAMEON) && (GETPTI(pwnd)->pq == gpqForeground))
//#define FTrueVis(pwnd)       (pwnd->fs & WF_TRUEVIS)
#define FTrueVis(pwnd)       (_IsWindowVisible(pwnd))

/*
 * Besides the desktop window used by the current thread, we also
 * need to get the desktop window of a window and the input desktop
 * window.
 */
#define PWNDDESKTOP(p)      ((p)->spdeskParent->spwnd)
#define INPUTPWNDDESKTOP()  (gspdeskRitInput->spwnd)


/*
 * Menu Item Structure
 */
typedef struct tagITEM {
    DWORD   fFlags;             /* Item Flags. Must be 1st in this structure. */
    struct tagMENU *spmenuCmd;  /* Handle to a popup */
    HANDLE  hbmpCheckMarkOn;    /* Bitmap for an on  check */
    HANDLE  hbmpCheckMarkOff;   /* Bitmap for an off check */

    HANDLE  hItem;              /* Handle to a bitmap or string */
    DWORD   xItem;
    DWORD   yItem;
    DWORD   cxItem;

    DWORD   cyItem;
    DWORD   dxTab;
    DWORD   ulX;                /* String: Underline start */
    DWORD   ulWidth;            /* String: underline width */

    DWORD   cch;                /* String: WCHAR count */
} ITEM, *PITEM, *LPITEM;

/*
 * Menu Structure
 */
typedef struct tagMENU {
    PROCOBJHEAD     head;
    PVOID           hheapDesktop;   /* Allocation source */
    struct tagDESKTOP *spdeskParent;/* Parent desktop */
    DWORD           fFlags;         /* Menu Flags */
    int             iItem;          /* Contains the position of the selected
                                       item in the menu. -1 if no selection */
    int             iPopupMenuItem; /* Contains the position of the hierarchical
                                       item menu popup */
    UINT            cItems;         /* Number of items in rgItems */

    DWORD           xMenu;
    DWORD           yMenu;
    DWORD           cxMenu;
    DWORD           cyMenu;
    struct tagWND *spwndNotify;     /* The owner hwnd of this menu */
    PITEM           rgItems;        /* The list of items in this menu */
} MENU, *PMENU;

/* NEW MENU STUFF */
typedef struct tagPOPUPMENU
{
  DWORD  fInsideMenuLoop:1;  /* Only valid on root ppopupMenuStruct. */
  DWORD  fIsMenuBar:1;       /* This is a hacked struct which refers to the
                              * menu bar associated with a app. Only true if
                              * in the root ppopupMenuStruct.
                              */
  DWORD  fHasMenuBar:1;      /* This popup is part of a series which has a
                              * menu bar (either a sys menu or top level menu
                              * bar)
                              */
  DWORD  fIsSystemMenu:1;    /* The system menu is here. */
  DWORD  fDroppedLeft:1;
  DWORD  fHierarchyDropped:1;
  DWORD  fHierarchyVisible:1;
  DWORD  fMouseButtonDown:1;
  DWORD  fFirstClick:1;      /* Keep track if this was the first click on the
                              * top level menu bar item.  If the user down/up
                              * clicks on a top level menu bar item twice, we
                              * want to cancel menu mode.
                              */
  DWORD  fTrackPopupMenuInitialMouseClk:1; /* Is the initial mouse click which
                                            * summoned the trackpopup menu
                                            * over?
                                            */
  DWORD  trackPopupMenuFlags; /* Flags if this is a track popupmenu struct */
  struct tagWND *spwndNotify;
                        /* Window who gets the notification messages. If this
                         * is a window with a menu bar, then this is the same
                         * as hwndPopupMenu.
                         */
  struct tagWND *spwndPopupMenu;
                        /* The window associated with this ppopupMenu struct.
                         * If this is a top level menubar, then hwndPopupMenu
                         * is the window the menu bar. ie. it isn't really a
                         * popup menu window.
                         */
  struct tagWND *spwndNextPopup;
                        /* The next popup in the hierarchy. Null if the last
                         * in chain
                         */
  struct tagWND *spwndPrevPopup;
                        /* The previous popup in the hierarchy. NULL if at top
                         */
  struct tagMENU *spmenu;/* The PMENU displayed in this window
                         */
  struct tagMENU *spmenuAlternate;
                        /* Alternate PMENU. If the system menu is displayed,
                         * and a menubar menu exists, this will contain the
                         * menubar menu. If menubar menu is displayed, this
                         * will contain the system menu. Use only on top level
                         * ppopupMenu structs so that we can handle windows
                         * with both a system menu and a menu bar menu.  Only
                         * used in the root ppopupMenuStruct.
                         */
  struct tagWND *spwndActivePopup;

  struct tagPOPUPMENU *ppopupmenuRoot;

  UINT   posSelectedItem;  /* Position of the selected item in this menu
                            */
  UINT   idShowTimer;      /* Timer id till we make the hierarchical visible.
                            */
  UINT   idHideTimer;      /* Timer id till we take away the currently active
                            * popup due to a mouse move.
                            */
  RECT   trackPopupMenuRc; /* Rectangle for track popup menu. User is allowed
                            * to up/down click within this rect and the popup
                            * remains.
                            */
} POPUPMENU;
typedef POPUPMENU *PPOPUPMENU;

typedef struct tagMENUWND {
    WND wnd;
    PPOPUPMENU ppopupmenu;
} MENUWND, *PMENUWND;

/*
 * Menu Control Structure
 */
typedef struct tagMENUSTATE {
    PPOPUPMENU pGlobalPopupMenu;
    DWORD   fFromIconMenu : 1;
    DWORD   fMenu : 1;
    DWORD   fSysMenu : 1;
    DWORD   fSysUp : 1;
    DWORD   fCmdSel : 1;
    DWORD   fInsideMenuLoop : 1;
    DWORD   fOnPopup : 1;
    DWORD   fInTrackPopupMenu : 1;
    DWORD   fSend : 1;
    POINT   ptLastMove;
    POINT   ptHideTimer;
    int     mnFocus;
    int     menuSelect;
    int     firstIdx;
} MENUSTATE, *PMENUSTATE;

/*
 * Queues are fixed so we can get away with this
 */
#define PWNDTOPMENUSTATE(pwnd)  ((PMENUSTATE)(&(GETPTI(pwnd)->MenuState)))


/*
 * Window Property structure
 */
typedef struct tagPROP {        // prop
    struct tagPROP *ppropNext;
    HANDLE hData;
    ATOM atomKey;
    UINT fs;
} PROP, *PPROP;

#define PROPF_INTERNAL   0x0001
#define PROPF_STRING     0x0002


/*
 * CheckPoint structure
 */
typedef struct tagCHECKPOINT {
    RECT rcNormal;
    POINT ptMin;
    POINT ptMax;
    struct tagWND *spwndTitle;
    int fDragged:1;
    int fWasMaximizedBeforeMinimized:1;
    int fWasMinimizedBeforeMaximized:1;
    int fParkAtTop:1;
} CHECKPOINT, *PCHECKPOINT;


#define dpHorzRes           HORZRES
#define dpVertRes           VERTRES

/*
 * Structure filled in by xxxWindowHitTest()
 */
typedef struct {
    struct tagWND *spwnd;
    int  iPart;
} WNDPOS;

/*
 * If the handle for CF_TEXT/CF_OEMTEXT is a dummy handle then this implies
 * that data is available in the other format (as CF_OEMTEXT/CF_TEXT)
 */
#define DUMMY_TEXT_HANDLE       0xFFFF
#define DATA_NOT_BANKED         0xFFFF

typedef struct tagCLIP {
    UINT    fmt;
    HANDLE  hData;
    BOOL    fGlobalHandle;
} CLIP, *PCLIP;

typedef struct tagSYSMSG {
    UINT     message;
    UINT     paramL;
    UINT     paramH;
    DWORD    time;
} SYSMSG;

typedef struct tagTIMERINFO {
    LONG resolution;
} TIMERINFO;

typedef struct tagKBINFO {
    BYTE  Begin_First_range;    /* Values used for Far East systems */
    BYTE  End_First_range;
    BYTE  Begin_Second_range;
    BYTE  End_Second_range;
    int   stateSize;            /* size of ToAscii()'s state block */
} KBINFO;

typedef struct tagMOUSEINFO {
    char  fExist;
    char  fRelative;
    int   cButton;
    int   cmsRate;
    int   xThreshold;
    int   yThreshold;
    int   cxResolution;  /* resolution needed for absolute mouse coordinate */
    int   cyResolution;
} MOUSEINFO;

typedef struct tagCURSORACCELINFO {
    UINT  csXRate;
    UINT  csYRate;
} CURSORACCELINFO;

typedef struct tagCARET {
    struct tagWND *spwnd;
    UINT    fVisible : 1;
    UINT    fOn      : 1;
    int     iHideLevel;
    int     x;
    int     y;
    int     cy;
    int     cx;
    HBITMAP hBitmap;
    UINT    hTimer;
    HTHREADINFO hti;
} CARET, *PCARET;

typedef struct tagSCRN {
    int     cy;
    int     cx;
    RECT    rc;
    int     cLock;
    int     cclm;           /* Number of organized columns. */
    int     cclmSave;
    int     cwnd;
} SCRN, *PSCRN;


/*
 * The following masks can be used along with the wDisableFlags field of SB
 * to find if the Up/Left or Down/Right arrow or Both are disabled;
 * Now it is possible to selectively Enable/Disable just one or both the
 * arrows in a scroll bar control;
 */
#define LTUPFLAG    0x0001  // Left/Up arrow disable flag.
#define RTDNFLAG    0x0002  // Right/Down arrow disable flag.
#define SBFLAGSINDEX  6     // Index of Scroll bar flags in Wnd->rgwScroll[]

/*
 * Scroll bar info structure
 */
typedef struct tagSBWND {
    WND    wnd;
    int    pos;
    int    min;
    int    max;
    BOOL   fVert;
    UINT   wDisableFlags;       /* Indicates which arrow is disabled; */
} SBWND, *PSBWND, *LPSBWND;

typedef struct tagSBSTATE {
    DWORD  fHitOld : 1;
    DWORD  fTrackVert : 1;
    DWORD  fVertSB : 1;     /* Using vertical scroll bar? */
    DWORD  fCtlSB : 1;
    PWND   spwndSB;
    PWND   spwndSBNotify;
    PWND   spwndTrack;
    UINT   cmdSB;
    DWORD  cmsTimerInterval;
    int    dpxThumb;        /* Offset from mouse point to start of thumb box */
    int    posOld;
    int    posStart;
    int    pxBottom;
    int    pxDownArrow;
    int    pxLeft;
    int    pxOld;           /* Previous position of thumb */
    int    pxRight;
    int    pxStart;         /* Initial position of thumb */
    int    pxThumbBottom;
    int    pxThumbTop;
    int    pxTop;
    int    pxUpArrow;
    int    pos;
    int    posMin;
    int    posMax;
    int    cpxThumb;
    int    cpxArrow;
    int    cpx;
    int    pxMin;
    RECT   rcSB;
    RECT   rcThumb;
    RECT   rcTrack;
    UINT   hTimerSB;
    VOID   (*xxxpfnSB)(PWND, UINT, DWORD, LONG);
    PWND   pwndCalc;
    int    nBar;
} SBSTATE, *PSBSTATE;

/*
 * Queues are fixed so we can get away with this
 */
#define PWNDTOPSBSTATE(pwnd) ((PSBSTATE)(&(GETPTI(pwnd)->SBState)))

PWND _GetNextQueueWindow(
    PWND pwnd,
    BOOL fDir, /* 1 backward 0 forward */
    BOOL fAltEsc);

/*
 * Task Data Block structure.
 */
typedef struct tagTDB {
    struct tagTDB   *ptdbNext;
    struct tagTDB   **pptdbPrevNext;  // see taskman.c InsertTask()
    int             nEvents;
    int             nPriority;
    HANDLE          hEventTask;
    PTHREADINFO     pti;
} TDB, *PTDB;

/*
 * DDEML instance structure
 */
typedef struct tagSVR_INSTANCE_INFO {
    HEAD head;
    struct tagSVR_INSTANCE_INFO *next;
    struct tagSVR_INSTANCE_INFO *nextInThisThread;
    DWORD afCmd;
    PWND spwndEvent;
    PVOID pcii;
} SVR_INSTANCE_INFO, *PSVR_INSTANCE_INFO;

/*
 * How many times a thread can spin through get/peek message without idling
 * before the system puts the app in the background.
 */
#define CSPINBACKGROUND 100

/*
 * Private QS_ bits.
 */
#define QS_SMSREPLY         0x0200
#define QS_SYSEXPUNGE       0x0400
#define QS_THREADATTACHED   0x0800
#define QS_EXCLUSIVE        0x1000      // wait for these events only!!
#define QS_EVENT            0x2000      // signifies event message

/*
 * QS_EVENT is used to clear the QS_EVENT bit, QS_EVENTSET is used to
 * set the bit.
 *
 * Include QS_SENDMESSAGE because the queue events
 * match what a win3.1 app would see as the QS_SENDMESSAGE bit. Plus 16 bit
 * apps don't even know about QS_EVENT.
 */
#define QS_EVENTSET        (QS_EVENT | QS_SENDMESSAGE)

#define MAXREGION       (HRGN)1

/*
 * SendMsgTimeout client/server transition struct
 */
typedef struct tagSNDMSGTIMEOUT {   /* smto */
    UINT fuFlags;                       // how to send the message, SMTO_BLOCK, SMTO_ABORTIFHUNG
    UINT uTimeout;                      // time-out duration
} SNDMSGTIMEOUT, *PSNDMSGTIMEOUT;

/*
 * MDI typedefs
 */
typedef struct tagMDIWND {
    WND     wnd;
    UINT    dwReserved;         // quattro pro 1.0 stores stuff here!!
    UINT    cKids;
    struct tagWND *spwndMaxedChild;
    struct tagWND *spwndActiveChild;
    struct tagMENU *spmenuWindow;
    UINT    idFirstChild;
    UINT    wScroll;
    LPWSTR  pTitle;
    UINT    iChildTileLevel;
} MDIWND, *PMDIWND;

/*
 * MDI defines
 */
#define WS_MDISTYLE     (WS_CHILD | WS_CLIPSIBLINGS | WS_SYSMENU|WS_CAPTION|WS_THICKFRAME|WS_MAXIMIZEBOX|WS_MINIMIZEBOX)
#define WS_MDICOMMANDS  (WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX)
#define WS_MDIALLOWED   (WS_MINIMIZE | WS_MAXIMIZE | WS_CLIPCHILDREN | WS_DISABLED | WS_HSCROLL | WS_VSCROLL | 0x0000FFFFL)

#define HAS_SBVERT      0x0100
#define HAS_SBHORZ      0x0200
#define OTHERMAXING     0x0400
#define CALCSCROLL      0x0800

#define SCROLLSUPPRESS  0x0003
#define SCROLLCOUNT     0x00FF

#define CKIDS(pwnd)     (((PMDIWND)pwnd)->cKids)
#define MAXED(pwnd)     (((PMDIWND)pwnd)->spwndMaxedChild)
#define ACTIVE(pwnd)    (((PMDIWND)pwnd)->spwndActiveChild)
#define WINDOW(pwnd)    (((PMDIWND)pwnd)->spmenuWindow)
#define FIRST(pwnd)     (((PMDIWND)pwnd)->idFirstChild)
#define SCROLL(pwnd)    (((PMDIWND)pwnd)->wScroll)
#define ITILELEVEL(pwnd)    (((PMDIWND)pwnd)->iChildTileLevel)
#define HTITLE(pwnd)    (((PMDIWND)pwnd)->pTitle)

#define PROP_MDICLIENT  MAKEINTRESOURCE(0x8CAC)

#define CCHTITLEMAX     80
#define CCHFILEMAX      MAX_PATH

/* maximum number of MDI children windows listed in "Window" menu */
#define MAXITEMS         10

/*
 * This is used by CreateWindow() - the 16 bit version of CW_USEDEFAULT,
 * that we still need to support.
 */
#define CW2_USEDEFAULT      0x8000
#define CW_FLAGS_DIFFHMOD   0x80000000

/*
 * Dialog box activation border width factor.
 */
#define CLDLGFRAME          4
#define CLDLGFRAMEWHITE     0



/*
 * Menu commands
 */
#define MENUBIT             (0x8000)
#define MENUUP              (0x8000 | VK_UP)
#define MENUDOWN            (0x8000 | VK_DOWN)
#define MENULEFT            (0x8000 | VK_LEFT)
#define MENURIGHT           (0x8000 | VK_RIGHT)
#define MENUEXECUTE         CR_CHAR         /* Return character */
#define MENUSYSMENU         SPACE_CHAR      /* Space character */
#define MENUCHILDSYSMENU    TEXT('-')       /* Hyphen */

/*
 * Menu flags for pItems.
 */
#define MRGFGRAYED             0x01
#define MRGFDISABLED           0x03
#define MFCHECKED              0x08
#define MRGFBREAK              0x60
#define MFENDMENU              0x80

#define MF_ALLSTATE  0x00FF
#define MF_MAINMENU  0xFFFF
#define MFMWFP_OFFMENU  0
#define MFMWFP_MAINMENU 0x0000FFFF
#define MFMWFP_NOITEM   (UINT)(-1)
#define MFMWFP_ALTMENU  (UINT)(-2)
#define MFMWFP_FIRSTITEM 0
#define SMS_NOMENU      (PMENU)(-1)

/*
 * For pMenu's
 */
#define MFISPOPUP     0x01
#define MFMULTIROW    0x04

/*
 * Defines for Menu focus
 */
#define FREEHOLD    0
#define MOUSEHOLD  -1 /* Mouse button held down and dragging */
#define KEYBDHOLD   1


/*
 * NOTE: SMF() can only be used on single bit flags (NOT MRGFDISABLED!).
 */
#define SetMF(pmenu, flag)    ((pmenu)->fFlags |=  flag)
#define ClearMF(pmenu, flag)  ((pmenu)->fFlags &= ~flag)
#define TestMF(pmenu, flag)   ((pmenu)->fFlags &   flag)



/*
 * Dialog structure (dlg). The window-words for the dialog structure must
 * be EXACTLY 30 bytes long! This is because Windows 3.0 exported a constant
 * called DLGWINDOWEXTRA that resolved to 30. Although we could redefine this
 * for 32-bit windows apps, we cannot redefine it for 16 bit apps (it is
 * a difficult problem). So instead we peg the window-words at 30 bytes
 * exactly, and allocate storage for the other information.
 */
typedef struct _DLG {
    int     cxChar;
    int     cyChar;
    struct tagWND *spwndFocusSave;
    UINT    fEnd      : 1;
    UINT    fDisabled : 1;
    int     result;         /* DialogBox result */
    HANDLE  hData;          /* Global handle for edit ctl storage. */
    HFONT   hUserFont;      /* Handle of the font mentioned by the user in template*/
    struct tagWND *spwndSysModalSave;  /* Previous sysmodal window saved here */
} DLG, *PDLG;

typedef struct _DIALOG {
    WND     wnd;
    long    resultWP;       /* window proc result */
    WNDPROC_PWND lpfnDlg;
    long    unused;         /* DWL_USER */
    DWORD   flags;          /* Various useful flags -- see definitions below */
// =================== Below Not accessible by apps
    PDLG    pdlg;
    BYTE    reserved[DLGWINDOWEXTRA - sizeof(PDLG)];
} DIALOG, *PDIALOG;

#define PDLG(pwnd) (((PDIALOG)pwnd)->pdlg)

/*
 * Flags definitions for DLG.flags
 */
#define DLGF_CLIENT         0x01    /* lpfnDlg is a client side proc */
#define DLGF_16BIT          0x02    /* lpfnDlg is a 16-bit client proc */
#define DLGF_ANSI           0x04    /* lpfnDlg is a ANSI client proc */
#define DLGF_CACHEDUSERFONT 0x08    /* hUserFont is from dialog font cahce */


BOOL MarkProcess(UINT uFlag);
/*
 * Structure definition for messages as they exist on a Q.  Same as MSG
 * structure except for the link-pointer and flags at the end.
 */
typedef struct tagQMSG {
    struct tagQMSG  *pqmsgNext;
    struct tagQMSG  *pqmsgPrev;
    MSG             msg;
    LONG            ExtraInfo;
    DWORD           dwQEvent;
    HTHREADINFO     hti;
} QMSG, *PQMSG;

/*
 * Flags for QMSG structure.
 */
#define QEVENT_SHOWWINDOW           0x0001
#define QEVENT_CANCELMODE           0x0002
#define QEVENT_SETWINDOWPOS         0x0003
#define QEVENT_UPDATEKEYSTATE       0x0004
#define QEVENT_DEACTIVATE           0x0005
#define QEVENT_ACTIVATE             0x0006
#define QEVENT_DESTROYWINDOW        0x0007
#define QEVENT_ASYNCSENDMSG         0x0008

#define QMF_MAXEVENT                0x000F

typedef struct _MOVESIZEDATA {
    struct tagWND *spwnd;
    RECT rcDrag;
    RECT rcParent;
    POINT ptMinTrack;
    POINT ptMaxTrack;
    RECT rcWindow;
    int dxMouse;
    int dyMouse;
    int cmd;
    int impx;
    int impy;
    POINT ptRestore;
    struct tagCURSOR *spicnDrag;
    UINT fInitSize         : 1;    // should we initialize cursor pos
    UINT fmsKbd            : 1;    // who knows
    UINT fLockWindowUpdate : 1;    // whether screen was locked ok
    UINT fTrackCancelled   : 1;    // Set if tracking ended by other thread.
    UINT fForeground       : 1;    // whether the tracking thread is foreground
                                   //  and if we should draw the drag-rect
    UINT fDragFullWindows  : 1;
} MOVESIZEDATA, *PMOVESIZEDATA;


/*
 * Pseudo Event stuff.  (fManualReset := TRUE, fInitState := FALSE)
 */

DWORD WaitOnPseudoEvent(HANDLE *phE, DWORD dwMilliseconds);

#define PSEUDO_EVENT_ON     ((HANDLE)0xFFFFFFFF)
#define PSEUDO_EVENT_OFF    ((HANDLE)0x00000000)
#define INIT_PSEUDO_EVENT(ph) *ph = PSEUDO_EVENT_OFF;

#define SET_PSEUDO_EVENT(phE)                                   \
    CheckCritIn();                                              \
    if (*(phE) == PSEUDO_EVENT_OFF) *(phE) = PSEUDO_EVENT_ON;   \
    else if (*(phE) != PSEUDO_EVENT_ON) {                       \
        NtSetEvent(*(phE), NULL);                               \
        NtClose(*(phE));                                        \
        *(phE) = PSEUDO_EVENT_ON;                               \
    }

#define RESET_PSEUDO_EVENT(phE)                                 \
    CheckCritIn();                                              \
    if (*(phE) == PSEUDO_EVENT_ON) *(phE) = PSEUDO_EVENT_OFF;   \
    else if (*(phE) != PSEUDO_EVENT_OFF) {                      \
        NtResetEvent(*(phE), NULL);                             \
    }

#define CLOSE_PSEUDO_EVENT(phE)                                 \
    CheckCritIn();                                              \
    if (*(phE) == PSEUDO_EVENT_ON) *(phE) = PSEUDO_EVENT_OFF;   \
    else if (*(phE) != PSEUDO_EVENT_OFF) {                      \
        NtSetEvent(*(phE), NULL);                               \
        NtClose(*(phE));                                        \
        *(phE) = PSEUDO_EVENT_OFF;                              \
    }


/*
 * Used for AttachThreadInput()
 */
typedef struct tagATTACHINFO {
    struct tagATTACHINFO *paiNext;
    PTHREADINFO pti1;
    PTHREADINFO pti2;
} ATTACHINFO, *PATTACHINFO;

typedef struct tagMLIST {
    PQMSG pqmsgRead;
    PQMSG pqmsgWriteLast;
    DWORD cMsgs;
} MLIST, *PMLIST;

/*
 * Thread Info structure.
 */
typedef struct tagCSRPERTHREADDATA {
    PDESKTOP pdesk;
    PTHREADINFO pti;
} CSRPERTHREADDATA, *PCSRPERTHREADDATA;

typedef struct tagTHREADINFO {
    HEAD     head;

    struct tagTHREADINFO *ptiNext;
    PTL      ptl;                   // Listhead for thread lock list
    PVOID    hheapDesktop;          // Allocation source

    struct tagPROCESSINFO *ppi;     // process info struct for this thread

    struct tagQ *pq;                // keyboard and mouse input queue

    MLIST   mlPost;                 // posted message list.

    HANDLE   hEventQueueClient;
    HANDLE   hEventQueueServer;
    UINT     fsChangeBits;          // Bits changes since last compared
    UINT     fsChangeBitsRemoved;   // Bits removed during PeekMessage
    UINT     fsWakeBits;            // Bits currently available
    UINT     fsWakeMask;            // Bits looking for when asleep

    PDESKTOP spdesk;
    PDESKTOPINFO pDeskInfo;         // Desktop info visible to client
    DWORD    flags;                 // TIF_ flags go here.

    DWORD    idProcess;
    DWORD    idThread;
    DWORD    idSequence;            // Process sequence number

    DWORD    idThreadServer;        // Server side thread id.
    LPWSTR   pszAppName;            // Application module name.

    DWORD    fsHooks;               // Flags for which hooks are installed
    PHOOK    asphkStart[CWINHOOKS]; // Hooks registered for this thread
    PHOOK    sphkCurrent;           // Hook this thread is currently processing

    struct tagSMS *psmsSent;        // Most recent SMS this thread has sent
    struct tagSMS *psmsCurrent;     // Received SMS this thread is currently processing
    struct tagSMS *psmsReceiveList; // SMSs to be processed

    LONG     ExtraInfo;             // Time, position, and ID of last message
    LONG     timeLast;              // and extrainfo
    POINT    ptLast;
    DWORD    idLast;
    LONG     lReturn;               // value passed back to the client from SMsgTimeOut

    int      cQuit;
    int      exitCode;

    DWORD    pcti;                  // client side pointer

    int      cPaintsReady;
    UINT     cTimersReady;

    MENUSTATE    MenuState;
    SBSTATE      SBState;

    PTDB     ptdb;                  // Win16Task Schedule data

    PSVR_INSTANCE_INFO psiiList;    // thread DDEML instance list
    DWORD    dwExpWinVer;
    DWORD    dwCompatFlags;         // The Win 3.1 Compat flags

    UINT     cWindows;              // Number of windows owned by this thread
    UINT     cVisWindows;           // Number of visible windows on this thread

    DWORD    hTaskWow;              // Wow cookie to find apps during shutdown
    HANDLE   hThreadClient;
    HANDLE   hThreadServer;

    PVOID    pcsrt;
#ifdef PTEB
    PTEB     pteb;
#else
    PVOID    pteb;
#endif

#ifdef DEBUG
    int      ilFirst;
#endif

    struct tagQ *pqAttach;          // calculation variabled used in
                                    // AttachThreadInput()

    int     iCursorLevel;           // keep track of each thread's level

    DWORD   cSpins;                 // how many times we go through
                                    // GetMessage() or PeekMessage() without
                                    // going idle. Used for priority adjustment

    DWORD   fsReserveKeys;          // Keys that must be sent to the active
                                    // active console window.
    struct tagTHREADINFO *ptiSibling;   // pointer to sibling thread info

    PMOVESIZEDATA pmsd;

} THREADINFO;

#define TIF_INCLEANUP                   (UINT)0x0001
#define TIF_16BIT                       (UINT)0x0002
#define TIF_SYSTEMTHREAD                (UINT)0x0004
#define TIF_TRACKRECTVISIBLE            (UINT)0x0010
#define TIF_ALLOWFOREGROUNDACTIVATE     (UINT)0x0020
#define TIF_DONTATTACHQUEUE             (UINT)0x0040
#define TIF_DONTJOURNALATTACH           (UINT)0x0080
#define TIF_SCREENSAVER                 (UINT)0x0100
#define TIF_INACTIVATEAPPMSG            (UINT)0x0200
#define TIF_SPINNING                    (UINT)0x0400
#define TIF_YIELDNOPEEKMSG              (UINT)0x0800
#define TIF_SHAREDWOW                   (UINT)0x1000
#define TIF_FIRSTIDLE                   (UINT)0x2000
#define TIF_WAITFORINPUTIDLE            (UINT)0x4000
#define TIF_MOVESIZETRACKING            (UINT)0x8000

#define SET_TIME_LAST_READ(pti)     (((PCSR_QLPC_TEB)((PTEB)pti->pteb)->CsrQlpcTeb)->   \
                                            MessageStack->TimeLastRead = NtGetTickCount())

/*
 * Process Info structure.
 */
#define PI_WINDOWSTATION    0
#define PI_DESKTOP          1

/*
 * The number of library module handles we can store in the dependency tables.
 */
#define CLIBS           32

typedef struct tagWOWPROCESSINFO {
    struct tagWOWPROCESSINFO *pwpiNext; // List of WOW ppi's, gppiFirstWow is head
    PTHREADINFO ptiScheduled;           // current thread in nonpreemptive scheduler
    DWORD       nTaskLock;              // nonpreemptive scheduler task lock count
    PTDB        ptdbHead;               // list of this process's WOW tasks
    DWORD       lpfnWowExitTask;        // func addr for wow exittask callback
    HANDLE      hEventWowExec;          // WowExec Virt HWint scheduler event
    HANDLE      hEventWowExecClient;    // client handle value for wowexec
    DWORD       nSendLock;              // Send Scheduler inter process Send count
    DWORD       nRecvLock;              // Send Scheduler inter process Receive count
}WOWPROCESSINFO, *PWOWPROCESSINFO;


typedef struct tagPROCESSINFO {
    struct tagPROCESSINFO *ppiNext;     // next ppi structure
    DWORD  idProcessClient;             // client process id
    DWORD  idSequence;                  // process sequence number
    HANDLE hEventInputIdle;             // event for pulsing input idle
    PTHREADINFO ptiMainThread;          // pti of "main thread"
    int    cThreads;                    // count of threads using this process info
    PDESKTOP spdeskStartup;             // initial desktop
    PCLS   pclsPrivateList;             // this processes' private classes
    PCLS   pclsPublicList;              // this processes' public classes
    HANDLE ahmodLibLoaded[CLIBS];       // process unique hmod array for hook dlls
    PROCESSACCESS paStdOpen[2];         // open windowstation and desktop handles
    int    cObjects;                    // # of slots in open object table
    PPROCESSACCESS pOpenObjectTable;    // open object table
    struct tagWINDOWSTATION *spwinsta;  // process windowstation
    USERSTARTUPINFO usi;                // process startup info
    DWORD  flags;                       // process structure flags
    DWORD  dwCompatFlags;               // per-process GetAppCompat() flags
    DWORD  timeStartCursorHide;         // when the app start cursor goes away
    DWORD  dwHotkey;                    // hot key from progman
    PVOID  pCsrProcess;                 // csr process structure
    struct tagPROCESSINFO *ppiCalcNext; // next ppi structure to calc for start cursor
    PWOWPROCESSINFO pwpi;               // Wow PerProcess Info
    PTHREADINFO ptiList;                // threads in this process
    LUID   luidSession;                 // logon session id
} PROCESSINFO;

#define PIF_CONSOLEAPPLICATION          0x00000001
#define PIF_APPSTARTING                 0x00000002
#define PIF_HAVECOMPATFLAGS             0x00000004
#define PIF_SYSTEMAPP                   0x00000008
#define PIF_FORCEOFFFEEDBACK            0x00000010
#define PIF_ALLOWFOREGROUNDACTIVATE     0x00000020
#define PIF_OWNDCCLEANUP                0x00000040
#define PIF_STARTGLASS                  0x00000080
#define PIF_SHOWSTARTGLASSCALLED        0x00000100
#define PIF_FORCEBACKGROUNDPRIORITY     0x00000200
#define PIF_TERMINATED                  0x00000400
#define PIF_READSCREENOK                0x00000800
#define PIF_CLASSESREGISTERED           0x00001000
#define PIF_THREADCONNECTED             0x00002000
#define PIF_WOW                         0x00004000
#define PIF_INITIALIZED                 0x00008000
#define PIF_WAKEWOWEXEC                 0x00010000
#define PIF_WAITFORINPUTIDLE            0x00020000

/*
 * vkey table counts, macros, etc. input synchonized key state tables have
 * 2 bits per vkey: fDown, fToggled. Async key state tables have 3 bits:
 * fDown, fToggled, fDownSinceLastRead.
 *
 * Important! The array gafAsyncKeyState matches the bit positions of the
 * afKeyState array in each thread info block. The fDownSinceLastRead bit
 * for the async state is stored in a separate bit array, called
 * gafAsyncKeyStateRecentDown.
 *
 * It is important that the bit positions of gafAsyncKeyState and
 * pti->afKeyState match because we copy from one to the other to maintain
 * key state synchronization between threads.
 *
 * These macros below MUST be used when setting / querying key state.
 */
#define CVKKEYSTATE                 256
#define CBKEYSTATE                  (CVKKEYSTATE >> 2)
#define CBKEYSTATERECENTDOWN        (CVKKEYSTATE >> 3)

#define TestKeyDownBit(pb, vk)\
        (pb[vk >> 2] & (1 << ((vk & 3) << 1)))
#define SetKeyDownBit(pb, vk)\
        (pb[vk >> 2] |= (1 << ((vk & 3) << 1)))
#define ClearKeyDownBit(pb, vk)\
        (pb[vk >> 2] &= ~(1 << ((vk & 3) << 1)))
#define TestKeyToggleBit(pb, vk)\
        (pb[vk >> 2] & (1 << (((vk & 3) << 1) + 1)))
#define SetKeyToggleBit(pb, vk)\
        (pb[vk >> 2] |= (1 << (((vk & 3) << 1) + 1)))
#define ClearKeyToggleBit(pb, vk)\
        (pb[vk >> 2] &= ~(1 << (((vk & 3) << 1) + 1)))
#define TestKeyRecentDownBit(pb, vk)\
        (pb[vk >> 3] & (1 << (vk & 7)))
#define SetKeyRecentDownBit(pb, vk)\
        (pb[vk >> 3] |= (1 << (vk & 7)))
#define ClearKeyRecentDownBit(pb, vk)\
        (pb[vk >> 3] &= ~(1 << (vk & 7)))

#define TestKeyStateDown(pq, vk)\
        TestKeyDownBit(pq->afKeyState, vk)
#define SetKeyStateDown(pq, vk)\
        SetKeyDownBit(pq->afKeyState, vk)
#define ClearKeyStateDown(pq, vk)\
        ClearKeyDownBit(pq->afKeyState, vk)
#define TestKeyStateToggle(pq, vk)\
        TestKeyToggleBit(pq->afKeyState, vk)
#define SetKeyStateToggle(pq, vk)\
        SetKeyToggleBit(pq->afKeyState, vk)
#define ClearKeyStateToggle(pq, vk)\
        ClearKeyToggleBit(pq->afKeyState, vk)

#define TestAsyncKeyStateDown(vk)\
        TestKeyDownBit(gafAsyncKeyState, vk)
#define SetAsyncKeyStateDown(vk)\
        SetKeyDownBit(gafAsyncKeyState, vk)
#define ClearAsyncKeyStateDown(vk)\
        ClearKeyDownBit(gafAsyncKeyState, vk)
#define TestAsyncKeyStateToggle(vk)\
        TestKeyToggleBit(gafAsyncKeyState, vk)
#define SetAsyncKeyStateToggle(vk)\
        SetKeyToggleBit(gafAsyncKeyState, vk)
#define ClearAsyncKeyStateToggle(vk)\
        ClearKeyToggleBit(gafAsyncKeyState, vk)

#define TestAsyncKeyStateRecentDown(vk)\
        TestKeyRecentDownBit(gafAsyncKeyStateRecentDown, vk)
#define SetAsyncKeyStateRecentDown(vk)\
        SetKeyRecentDownBit(gafAsyncKeyStateRecentDown, vk)
#define ClearAsyncKeyStateRecentDown(vk)\
        ClearKeyRecentDownBit(gafAsyncKeyStateRecentDown, vk)


/*
 * Message Queue structure.
 */
typedef struct tagQ {
    HEAD        head;

    struct tagQ *pqNext;
    PVOID       hheapDesktop;       // Allocation source

    MLIST       mlInput;            // raw mouse and key message list.

    PTHREADINFO ptiSysLock;         // Thread currently allowed to process input
    DWORD       idSysLock;          // Last message removed
    DWORD       idSysPeek;          // Last message peeked

    PTHREADINFO ptiMouse;           // Last thread to get mouse msg.
    PTHREADINFO ptiKeyboard;

    PWND        spwndCapture;
    PWND        spwndFocus;
    PWND        spwndActive;
    PWND        spwndActivePrev;

    UINT        codeCapture;
    UINT        msgDblClk;
    DWORD       timeDblClk;
    HWND        hwndDblClk;
    RECT        rcDblClk;

    BYTE        afKeyRecentDown[CBKEYSTATERECENTDOWN];
    BYTE        afKeyState[CBKEYSTATE];

    PWND        spwndAltTab;

    CARET       caret;

    PCURSOR     spcurCurrent;
    int         iCursorLevel;

    UINT        flags;              // QF_ flags go here

    UINT        cThreads;

    UINT        msgJournal;
    HCURSOR     hcurCurrent;
} Q;

/*
 * Flags for the Q structure.
 */
#define QF_UPDATEKEYSTATE   (UINT)0x0001
#define QF_INALTTAB         (UINT)0x0002
#define QF_FMENUSTATUSBREAK (UINT)0x0004
#define QF_FMENUSTATUS      (UINT)0x0008
#define QF_FF10STATUS       (UINT)0x0010
#define QF_MOUSEMOVED       (UINT)0x0020
#define QF_ACTIVATIONCHANGE (UINT)0x0040 // This flag is examined in the menu
                                         // loop code so that we exit from
                                         // menu mode if another window was
                                         // activated while we were tracking
                                         // menus. This flag is set whenever
                                         // we activate a new window.
#define QF_LOCKNOREMOVE     (UINT)0x0400
#define QF_FOCUSNULLSINCEACTIVE (UINT)0x0800
#define QF_DIALOGACTIVE     (UINT)0x4000
#define QF_EVENTDEACTIVATEREMOVED  (UINT)0x8000




#ifdef DEBUG
VOID CDECL Rip(DWORD idErr, LPSTR pszFile, int iLine, ...);
VOID CDECL Shred(DWORD idErr, LPSTR pszFile, int iLine, LPSTR pszFmt, ...);
VOID    RipOutput(DWORD idErr, LPSTR pszFile, int iLine, LPSTR pszErr,
        PEXCEPTION_POINTERS pexi);

#define RIP0(idErr) Rip(idErr | RIP_COMPONENT, __FILE__, __LINE__)
#define RIP1(idErr, p1) Rip(idErr | RIP_COMPONENT, __FILE__, __LINE__, p1)
#define SRIP0(idErr, szFmt) Shred(idErr | RIP_COMPONENT, __FILE__, __LINE__, szFmt)
#define SRIP1(idErr, szFmt, p1) Shred(idErr | RIP_COMPONENT, __FILE__, __LINE__, szFmt, p1)
#define SRIP2(idErr, szFmt, p1, p2) Shred(idErr | RIP_COMPONENT, __FILE__, __LINE__, szFmt, p1, p2)
#define SRIP3(idErr, szFmt, p1, p2, p3) Shred(idErr | RIP_COMPONENT, __FILE__, __LINE__, szFmt, p1, p2, p3)

#define UserAssert(exp) if (!(exp)) SRIP0(RIP_ERROR, "Assertion failed " #exp)

#else

#define RIP0(idErr) UserSetError(idErr)
#define RIP1(idErr, p1) UserSetError(idErr)
#define SRIP0(idErr, szFmt) UserSetError(idErr)
#define SRIP1(idErr, szFmt, p1) UserSetError(idErr)
#define SRIP2(idErr, szFmt, p1, p2) UserSetError(idErr)
#define SRIP3(idErr, szFmt, p1, p2, p3) UserSetError(idErr)

#define UserAssert(exp) {}

#endif

#if DBG

#define TRACE_INIT(str)  { if (TraceDisplayDriverLoad) {  KdPrint(str); }}

#else

#define TRACE_INIT(str) {}

#endif

/*
 * From HANDTABL.C
 */
BOOL HMInitHandleTable(VOID);
PVOID HMAllocObject(PTHREADINFO pti, BYTE btype, DWORD size);
BOOL HMFreeObject(PVOID pobj);
BOOL HMMarkObjectDestroy(PVOID pobj);
PVOID HMValidateHandle(HANDLE h, BYTE btype);
PVOID HMValidateHandleNoRip(HANDLE h, BYTE btype);
PVOID HMAssignmentLock(PVOID *ppobj, PVOID pobj);
PVOID HMAssignmentUnlock(PVOID *ppobj);

/*
 * Assignment lock macro -> used for locking objects embedded in structures
 * and globals. Threadlocks used for locking objects across callbacks.
 */

#define Lock(ppobj, pobj) HMAssignmentLock((PVOID *)ppobj, (PVOID)pobj)
#define Unlock(ppobj)     HMAssignmentUnlock((PVOID *)ppobj)

#ifdef DEBUG
VOID ThreadLock(PVOID pobj, PTL ptl);
#else
#define ThreadLock(_pobj_, _ptl_)          \
{                                          \
                                           \
    PTHREADINFO _pti_;                     \
                                           \
    _pti_ = PtiCurrent();                  \
    (_ptl_)->next = _pti_->ptl;            \
    _pti_->ptl = (_ptl_);                  \
    (_ptl_)->pobj = (_pobj_);              \
    if ((_pobj_) != NULL) {                \
        ((PHEAD)(_pobj_))->cLockObjT += 1; \
        HMLockObject((_pobj_));            \
    }                                      \
}
#endif

#ifdef DEBUG
#define ThreadLockAlways(_pobj_, _ptl_) ThreadLock(_pobj_, _ptl_)
#else
#define ThreadLockAlways(_pobj_, _ptl_)    \
{                                          \
                                           \
    PTHREADINFO _pti_;                     \
                                           \
    _pti_ = PtiCurrent();                  \
    (_ptl_)->next = _pti_->ptl;            \
    _pti_->ptl = (_ptl_);                  \
    (_ptl_)->pobj = (_pobj_);              \
    ((PHEAD)(_pobj_))->cLockObjT += 1;     \
    HMLockObject((_pobj_));                \
}
#endif

#ifdef DEBUG
#define ThreadLockAlwaysWithPti(_pti_, _pobj_, _ptl_)  \
UserAssert(_pti_ == PtiCurrent());   \
ThreadLock(_pobj_, _ptl_)
#else
#define ThreadLockAlwaysWithPti(_pti_, _pobj_, _ptl_)  \
{                                          \
    (_ptl_)->next = _pti_->ptl;            \
    _pti_->ptl = (_ptl_);                  \
    (_ptl_)->pobj = (_pobj_);              \
    ((PHEAD)(_pobj_))->cLockObjT += 1;     \
    HMLockObject((_pobj_));                \
}
#endif

#ifdef DEBUG
#define ThreadLockWithPti(_pti_, _pobj_, _ptl_)  \
    UserAssert(_pti_ == PtiCurrent());   \
    ThreadLock(_pobj_, _ptl_)
#else
#define ThreadLockWithPti(_pti_, _pobj_, _ptl_)  \
{                                          \
    (_ptl_)->next = _pti_->ptl;            \
    _pti_->ptl = (_ptl_);                  \
    (_ptl_)->pobj = (_pobj_);              \
    if ((_pobj_) != NULL) {                \
        ((PHEAD)(_pobj_))->cLockObjT += 1; \
        HMLockObject((_pobj_));            \
    }                                      \
}
#endif

#define ThreadUnlock(ptl) ThreadUnlock1()
PVOID ThreadUnlock1(VOID);

PVOID HMUnlockObjectInternal(PVOID pobj);
#define HMUnlockObject(pobj) \
    ( (--((PHEAD)pobj)->cLockObj == 0) ? HMUnlockObjectInternal(pobj) : pobj )

VOID HMChangeOwnerThread(PVOID pobj, PTHREADINFO pti);
#ifdef DEBUG
VOID HMLockObject(PVOID pobj);
BOOL HMRelocateLockRecord(PVOID ppobjOld, int cbDelta);
#else
#define HMLockObject(p)     (((PHEAD)p)->cLockObj++)
#endif

DWORD MapClientToServerPfn(DWORD dw);
DWORD MapClientNeuterToClientPfn(DWORD dw, BOOL bAnsi);
DWORD MapServerToClientPfn(DWORD dw, BOOL bAnsi);

/*
 * GETSET.C
 */
WINUSERAPI WORD  _GetWindowWord(PWND pwnd, int index);
WORD  _SetWindowWord(PWND pwnd, int index, WORD value);
WINUSERAPI DWORD _GetWindowLong(PWND pwnd, int index, BOOL bAnsi);
DWORD _ServerSetWindowLong(PWND pwnd, int index, DWORD value, BOOL bAnsi);
DWORD GetWindowData(PWND pwnd, int index, BOOL bAnsi);
DWORD SetWindowData(PWND pwnd, int index, DWORD dwData, BOOL bAnsi);

WINUSERAPI BOOL _GetClientRect(PWND pwnd, LPRECT prc);
WINUSERAPI BOOL _GetWindowRect(PWND pwnd, LPRECT prc);
WINUSERAPI PWND _GetLastActivePopup(PWND pwnd);
WINUSERAPI BOOL _IsChild(PWND pwndParent, PWND pwnd);
WINUSERAPI BOOL _IsWindowEnabled(PWND pwnd);
WINUSERAPI BOOL _AdjustWindowRectEx(LPRECT lprc, LONG style, BOOL fMenu, DWORD dwExStyle);
WINUSERAPI BOOL _ClientToScreen(PWND pwnd, PPOINT ppt);
WINUSERAPI BOOL _ScreenToClient(PWND pwnd, PPOINT ppt);
WINUSERAPI int _MapWindowPoints(PWND pwndFrom, PWND pwndTo, LPPOINT lppt, DWORD cpt);
WINUSERAPI BOOL _IsWindowVisible(PWND pwnd);
WINUSERAPI BOOL _IsIconic(PWND pwnd);
WINUSERAPI BOOL _IsZoomed(PWND pwnd);
WINUSERAPI BOOL _AnyPopup(VOID);
BOOL _IsWindow(HWND hwnd);
BOOL _GetWindowPlacement(PWND pwnd, PWINDOWPLACEMENT pwp);


PMENU _GetSystemMenu(PWND pWnd, BOOL bRevert);
PMENU _CreateMenu(VOID);
PMENU _CreatePopupMenu(VOID);
BOOL  _DestroyMenu(PMENU pMenu);
DWORD _CheckMenuItem(PMENU pMenu, UINT wIDCheckItem, UINT wCheck);
BOOL _EnableMenuItem(PMENU pMenu, UINT wIDEnableItem, UINT wEnable);
WINUSERAPI PMENU _GetSubMenu(PMENU pMenu, int nPos);
WINUSERAPI UINT  _GetMenuItemID(PMENU pMenu, int nPos);
WINUSERAPI UINT  _GetMenuItemCount(PMENU pMenu);

PMENU _GetMenu(PWND pWnd);
int   _GetMenuString(PMENU pMenu, UINT wIDItem, LPWSTR lpString,
        int nMaxCount, DWORD dwFlag);
WINUSERAPI UINT _GetMenuState(PMENU pMenu, UINT wID, UINT dwFlags);

UINT  _SetSystemTimer(PWND pwnd, UINT nIDEvent, DWORD dwElapse,
        WNDPROC_PWND pTimerFunc);
PITEM  LookupMenuItem(PMENU pMenu, UINT wCmd, DWORD dwFlags, PMENU *ppMenuItemIsOn);
PWND    GetPrevPwnd(PWND pwndList, PWND pwndFind);
WINUSERAPI PWND _GetWindow(PWND pwnd, UINT cmd);
WINUSERAPI PWND _GetTopWindow(PWND pwnd);
WINUSERAPI PWND _GetParent(PWND pwnd);
WINUSERAPI PWND _GetDesktopWindow(VOID);
BOOL _ServerSetClipboardData(UINT fmt, HANDLE hData, BOOL fGlobalHandle);
BOOL   _SetProp(PWND pwnd, LPWSTR pszKey, HANDLE hData);
HANDLE _RemoveProp(PWND pwnd, LPWSTR pszKey);
WORD   _SetClassWord(PWND pwnd, int index, WORD value);
DWORD  _ServerSetClassLong(PWND pwnd, int index, DWORD value, BOOL bAnsi);
WORD   _GetClassWord(PWND pwnd, int index);
DWORD  _GetClassLong(PWND pwnd, int index, BOOL bAnsi);
DWORD   ServerGetClassData(HWND hwnd, int index, BOOL bAnsi);
int    ServerGetClassName(HWND hwnd, LPWSTR lpClassName, int nMaxCount);
ATOM   _RegisterClass(LPWNDCLASS pwc, PVOID pszClientUnicodeMenuName,
       PVOID pszClientAnsiMenuName, DWORD dwFlags, LPDWORD pdwWOW);
LONG   _GetClassWOWWords(HANDLE hModule, LPWSTR lpszClassName);
BOOL  xxxHiliteMenuItem(PWND pwnd, PMENU pmenu, UINT cmd, UINT flags);
HANDLE _GetProp(PWND pwnd, LPWSTR pszKey);
PMENU  _CreatePopupMenu();
VOID FreePopupMenu(PPOPUPMENU ppopupMenu);
HANDLE _ServerCreateAcceleratorTable(LPACCEL paccel, int cbAccel);
HANDLE xxxGetInputEvent(DWORD dwWakeMask);
BOOL   _UnregisterClass(LPWSTR lpszClassName, HANDLE hModule,
        PVOID *ppszClientUnicodeMenuName, PVOID *ppszClientAnsiMenuName);
ATOM   _GetClassInfo(HANDLE hModule, LPWSTR lpszClassName, LPWNDCLASS pwc, LPWSTR *ppszMenuName, BOOL bAnsi);
PWND   _WindowFromDC(HDC hdc);
SHORT  _VkKeyScan(WCHAR cChar);
WINUSERAPI SHORT  _GetKeyState(int vk);
int    xxxServerTranslateAccelerator(PWND pwnd, LPACCELTABLE pat, LPMSG lpMsg);
PHOOK  _PhkNext(PHOOK phk);
int    xxxHkCallHook(PHOOK phk, int nCode, DWORD wParam, DWORD lParam);
PHOOK  _ServerSetWindowsHookEx(HANDLE hmod, LPWSTR pszLib, DWORD idThread,
       int nFilterType, PROC pfnFilterProc, BOOL bAnsi);
BOOL   _RegisterLogonProcess(DWORD dwProcessId, BOOL fSecure);
UINT   _LockWindowStation(PWINDOWSTATION pwinsta);
BOOL   _UnlockWindowStation(PWINDOWSTATION pwinsta);
BOOL   _SetWindowStationUser(PWINDOWSTATION pwinsta, PLUID pluidUser);
BOOL   _SetDesktopBitmap(PDESKTOP pdesk, HBITMAP hbitmap, DWORD dwStyle);
BOOL   _SetLogonNotifyWindow(PWINDOWSTATION pwinsta, PWND pwnd);
BOOL   _RegisterTasklist(PWND pwndTasklist);
int    _EnumPropsEx(PWND pwnd, PROPENUMPROCEX pfnEnum, DWORD lParam);
int    _EnumProps(PWND pwnd,PROPENUMPROC pfnEnum);
LONG   _GetMessageExtraInfo(VOID);
WINUSERAPI DWORD  _GetWindowThreadProcessId(PWND pwnd, LPDWORD lpdwProcessId);
BOOL   _MapDialogRect(PWND pwnd, LPRECT lprc);
VOID   xxxRemoveEvents(PQ pq, int nQueue, DWORD flags);
BOOL   ResStrCmp(LPCWSTR lpstr1, LPCWSTR lpstr2);
int    FindNCHit(PWND pwnd, LONG lPt);
WINUSERAPI PWND   _NextChild(PWND pwndDlg, PWND pwnd);
WINUSERAPI PWND   _PrevChild(PWND pwndDlg, PWND pwnd);
WINUSERAPI PWND   _GetNextDlgGroupItem(PWND, PWND, BOOL);
WINUSERAPI PWND   _GetNextDlgTabItem(PWND, PWND, BOOL);
WINUSERAPI PWND   _GetFirstLevelChild(PWND pwndDlg, PWND pwndLevel);

PPCLS _InnerGetClassPtr(ATOM atom, PPCLS ppclsList, HANDLE hModule);

BOOL DrawFrame(HDC hdc, LPRECT lprect, int clFrame, int cmd);
BOOL FillWindow(HWND hwndBrush, HWND hwndPaint,
        HDC hdc, HBRUSH hbr);
int ClientGetCharDimensions(HDC hDC, TEXTMETRICW *lpTextMetrics);
int _GetCharDimensions(HDC hDC, TEXTMETRICW *lpTextMetrics);
HBRUSH GetControlBrush(HWND hwnd, HDC hdc, UINT msg);
PINT InitPwSB(HWND);
BOOL PaintRect(HWND, HWND, HDC, HBRUSH, LPRECT);
BOOL SetEditText(BOOL);
BOOL DestroyListHeader(PVOID plh);
HHOOK SetWindowsHookAW(int nFilterType, HOOKPROC pfnFilterProc, BOOL bAnsi);
HHOOK ServerSetWindowsHookEx(HANDLE hmod, LPTSTR pszLib,
        DWORD idThread, int nFilterType, PROC pfnFilterProc, BOOL bAnsi);
BOOL CsReleaseDC(HDC hdc);
HANDLE GetInputEvent(DWORD dwWakeMask);
BOOL APIENTRY CsScrollDC(HDC hDC, int dx, int dy,
        CONST RECT *lprcScroll, CONST RECT *lprcClip,
        HRGN hrgnUpdate, LPRECT lprcUpdate);
BOOL  APIENTRY CsSetMenuItemBitmaps(HMENU hMenu, UINT nPosition,
   DWORD dwFlags, HBITMAP hBitmapUnchecked, HBITMAP hBitmapChecked);
BOOL APIENTRY CsDrawIcon(HDC hdc, int x, int y, HICON hicon, BOOL fMeta, DRAWICONDATA *pdid);
int  APIENTRY CsExcludeUpdateRgn(HDC hDC, HWND hWnd);
BOOL APIENTRY CsInvalidateRgn(HWND hWnd, HRGN hRgn,
        BOOL bErase);
BOOL APIENTRY CsValidateRgn(HWND hWnd, HRGN hRgn);
BOOL APIENTRY CsCreateCaret(HWND hWnd, HBITMAP hBitmap,
        int nWidth, int nHeight);
HWND CsCreateWindowEx(DWORD dwExStyle, LPCTSTR pClassName,
        LPCTSTR pWindowName, DWORD dwStyle, int x, int y,
        int nWidth, int nHeight, HWND hwndParent, HMENU hmenu,
        HANDLE hModule, LPVOID pParam, DWORD dwFlags, LPDWORD pWOW);
int  APIENTRY CsGetUpdateRgn(HWND hWnd, HRGN hRgn,
        BOOL bErase);
HDC APIENTRY CsGetDC(HWND hWnd);
HDC CsGetDCEx(HWND hwnd, HRGN hrgnClip, DWORD flags);

WINUSERAPI BOOL _FChildVisible(PWND pwnd);
HDC  APIENTRY CsBeginPaint(HWND hWnd, LPPAINTSTRUCT lpPaint);
BOOL APIENTRY CsEndPaint(HWND hWnd, LPPAINTSTRUCT lpPaint);
HDC APIENTRY CsGetWindowDC(HWND hWnd);

DWORD APIENTRY CsGetCPD(HWND hwnd, DWORD dwType, DWORD dwProc);

#define SCDLG_CLIENT            0x0001
#define SCDLG_ANSI              0x0002
#define SCDLG_NOREVALIDATE      0x0004

#define CH_PREFIX TEXT('&')


DWORD ClientGetListboxString(HWND hwnd, UINT msg,
        DWORD wParam, DWORD cb, LPTSTR lParam,
        DWORD xParam, DWORD xpfn, BOOL bAnsi, BOOL bNotString);
HCURSOR ClientLoadCreateCursorIcon(HANDLE hmod, LPCTSTR lpName,
        LPTSTR lpType);
HMENU ClientLoadCreateMenu(HANDLE hmod, LPTSTR lpName);
BOOL FChildVisible(HWND hwnd);
DWORD ClientGetCurrentDirectory(DWORD, LPTSTR);
BOOL ClientSetCurrentDirectory(LPTSTR);
HANDLE ClientFindFirstFile(LPTSTR, LPWIN32_FIND_DATA);
BOOL ClientFindNextFile(HANDLE, LPWIN32_FIND_DATA);
BOOL ClientFindClose(HANDLE);
HANDLE ClientLoadLibrary(LPTSTR pszLib);
BOOL ClientFreeLibrary(HANDLE hmod);
BOOL ClientExitProcess(PFNW32ET pfn, DWORD dwExitCode);
BOOL ClientGrayString(GRAYSTRINGPROC pfnOutProc, HDC hdc,
        DWORD lpData, int nCount);
DWORD ClientGetLogicalDrives(VOID);
void ClientEmptyClipboard(void);
BOOL CopyFromClient(LPBYTE lpByte, LPBYTE lpByteClient, DWORD cch,
        BOOL fString, BOOL fAnsi);
BOOL CopyToClient(LPBYTE lpByte, LPBYTE lpByteClient,
        DWORD cchMax, BOOL fAnsi);

/*
 * Hook thunks.
 */
DWORD CALLBACK fnHkINLPRECT(DWORD nCode,
        DWORD wParam, LPRECT lParam,
        DWORD xParam, DWORD xpfnProc);
DWORD CALLBACK fnHkINDWORD(DWORD nCode,
        DWORD wParam, LONG lParam,
        DWORD xParam, DWORD xpfnProc, LPDWORD lpFlags);
DWORD CALLBACK fnHkINLPMSG(DWORD nCode,
        DWORD wParam, LPMSG lParam,
        DWORD xParam, DWORD xpfnProc, BOOL bAnsi, LPDWORD lpFlags);
DWORD CALLBACK fnHkOPTINLPEVENTMSG(DWORD nCode,
        DWORD wParam, LPEVENTMSGMSG lParam,
        DWORD xParam, DWORD xpfnProc);
DWORD CALLBACK fnHkINLPDEBUGHOOKSTRUCT(DWORD nCode,
        DWORD wParam, LPDEBUGHOOKINFO lParam,
        DWORD xParam, DWORD xpfnProc);
DWORD CALLBACK fnHkINLPMOUSEHOOKSTRUCT(DWORD nCode,
        DWORD wParam, LPMOUSEHOOKSTRUCT lParam,
        DWORD xParam, DWORD xpfnProc, LPDWORD lpFlags);
DWORD CALLBACK fnHkINLPCBTACTIVATESTRUCT(DWORD nCode,
        DWORD wParam, LPCBTACTIVATESTRUCT lParam,
        DWORD xParam, DWORD xpfnProc);
DWORD CALLBACK fnHkINLPCBTCSTRUCT(UINT msg,
        DWORD wParam, LPCBT_CREATEWND pcbt,
        DWORD xpfnProc, BOOL bAnsi);
DWORD CALLBACK fnHkINLPCBTMDICCSTRUCT(UINT msg,
        DWORD wParam, LPCBT_CREATEWND pcbt,
        DWORD xpfnProc, BOOL bAnsi);

DWORD _WOWDlgInit(HWND hwndDlg, LONG lParam);
HANDLE _GetEditDS(VOID);
VOID _ReleaseEditDS(HANDLE h);

BOOL RtlWCSMessageWParamCharToMB(DWORD msg, PDWORD pWParam);
BOOL RtlMBMessageWParamCharToWCS(DWORD msg, PDWORD pWParam);

// LATER IanJa: use real _wsprintf() - this one is user\rtl\wsprintf.c
int cdecl _wsprintf(LPWSTR, LPSTR, ...);

/***************************************************************************\
* Stuff that uses structures defined above the thank section.
\***************************************************************************/

LONG ServerGetWindowLong(HWND hwnd,int nIndex,BOOL bAnsi);
DWORD RtlGetExpWinVer(HANDLE hmod);
PCURSORRESOURCE RtlLoadCursorIconResource(HANDLE, LPHANDLE, LPCTSTR, LPTSTR,
        PRESCALLS, PDISPLAYINFO, PDWORD);
void RtlFreeCursorIconResource(HANDLE, HANDLE, PRESCALLS);
int RtlLoadStringOrError(HANDLE, UINT, LPTSTR, int, LPTSTR, PRESCALLS, WORD);
int RtlGetIdFromDirectory(PBYTE, UINT, PDISPLAYINFO, PDWORD);

/***************************************************************************\
* Button Controls
*
\***************************************************************************/

typedef struct tagBUTNWND {
    WND wnd;
    UINT buttonState;
    HANDLE hFont;
} BUTNWND, *PBUTNWND;

#define BUTTONSTYLE(pwnd)  ((LOBYTE(pwnd->style))&(LOBYTE(~BS_LEFTTEXT)))
#define BUTTONSTATE(pwnd)   (((PBUTNWND)pwnd)->buttonState)

#define BM_CLICK        0x00F5

/*
 * buttonState values: these values are assumed for bit shifting operations
 */
#define BFCHECK     0x0003
#define BFSTATE     0x0004  /* set == Down, clear == Up ? */
#define BFFOCUS     0x0008
#define BFINCLICK   0x0010  /* Inside click code */
#define BFCAPTURED  0x0020  /* We have mouse capture */
#define BFMOUSE     0x0040  /* Mouse-initiated */
#define BFDONTCLICK 0x0080  /* Don't check on get focus */


/***************************************************************************\
*
* ComboBox
*
\***************************************************************************/

/*
 * ID numbers (hMenu) for the child controls in the combo box
 */
#define CBEDITID    1001
#define CBBUTTONID  1002

/*
 * For CBOX.c. BoxType field, we define the following combo box styles. These
 * numbers are the same as the CBS_ style codes as defined in windows.h.
 */
#define SSIMPLE         1
#define SDROPDOWN       2
#define SDROPDOWNLIST   3

/*
 * CBOX.OwnerDraw & LBIV.OwnerDraw types
 */
#define OWNERDRAWFIXED 1
#define OWNERDRAWVAR   2

/*
 * Special styles for static controls, edit controls & listboxes so that we
 * can do combo box specific stuff in their wnd procs.
 */
#define LBS_COMBOBOX    0x8000L

typedef struct tagCBox {
    struct tagWND *spwnd;      /* Window for the combo box */
    struct tagWND *spwndParent;/* Parent of the combo box */
    RECT    comboDownrc;       /* Rectangle used for the "dropped"
                                  (listbox visible) combo box */
    RECT    editrc;            /* Rectangle for the edit control/static text
                                  area */
    RECT    buttonrc;          /* Rectangle where the dropdown button is */
    struct tagWND *spwndEdit;  /* Edit control window handle */
    struct tagWND *spwndList;  /* List box control window handle */
    UINT    CBoxStyle;         /* Combo box style */
    UINT    OwnerDraw;         /* Owner draw combo box if nonzero. value
                                * specifies either fixed or varheight
                                */
    int     fFocus:1;          /* Combo box has focus? */
    int     fNoRedraw:1;       /* Stop drawing? */
    int     fNoEdit:1;         /* True if editing is not allowed in the edit
                                * window.
                                */
    int     fButtonDownClicked:1;/* Was the popdown button just clicked and
                                   mouse still down? */
    int     fButtonInverted:1; /* Is the dropdown button in an inverted state?
                                */
    int     fLBoxVisible:1;    /* Is list box visible? (dropped down?) */
    int     fKeyboardSelInListBox:1; /* Is the user keyboarding through the
                                      * listbox. So that we don't hide the
                                      * listbox on selchanges caused by the
                                      * user keyboard through it but we do
                                      * hide it if the mouse causes the
                                      * selchange.
                                      */
    UINT    fExtendedUI:1;     /* Are we doing TandyT's UI changes on this
                                * combo box?
                                */
    UINT    fUnicodeDir:1;     /* unicode cb_dir? */
    HANDLE  hFont;             /* Font for the combo box */
    LONG    styleSave;         /* Temp to save the style bits when creating
                                * window.  Needed because we strip off some
                                * bits and pass them on to the listbox or
                                * edit box.
                                */
} CBOX, *PCBOX;

typedef struct tagCOMBOWND {
    WND wnd;
    PCBOX pcbox;
} COMBOWND, *PCOMBOWND;

/*
 * combo.h - Include file for combo boxes.
 */

/*
 * This macro is used to isolate the combo box style bits.  Ie if it the combo
 * box is simple, atomic, dropdown, or a dropdown listbox.
 */
#define COMBOBOXSTYLE(style)   ((LOBYTE(style)) & 3)

#define IsComboVisible(pcbox) (!pcbox->fNoRedraw && IsVisible(pcbox->spwnd, TRUE))

/*
 * Note that I depend on the fact that these CBN_ defines are the same as
 * their listbox counterparts.  These defines are found in windows.h.
 * #define CBN_ERRSPACE  (-1)
 * #define CBN_SELCHANGE 1
 * #define CBN_DBLCLK    2
 */


/***************************************************************************\
*
* ListBox
*
\***************************************************************************/

#define IsLBoxVisible(plb)  (plb->fRedraw && IsVisible(plb->spwnd, TRUE))

#define ICHLB int

/*
 * Number of list box items we allocated whenever we grow the list box
 * structures.
 */
#define CITEMSALLOC     32

/* Return Values */
#define EQ        0
#define PREFIX    1
#define LT        2
#define GT        3

#define mod(a,b) (a - a/b*b)

#define         SINGLESEL       0
#define         MULTIPLESEL     1
#define         EXTENDEDSEL     2

/*
 * List Box Instance Variables
 */
typedef struct tagLBIV {
    struct tagWND *spwndParent;/* parent window */
    struct tagWND *spwnd;      /* lbox ctl window */
    INT     sTop;           /* index of top item displayed          */
    INT     sSel;           /* index of current item selected       */
    INT     sSelBase;       /* base sel for multiple selections     */
    INT     cItemFullMax;   /* cnt of Fully Visible items. Always contains
                               result of CItemInWindow(plb, FALSE) for fixed
                               height listboxes. Contains 1 for var height
                               listboxes. */
    INT     cMac;           /* cnt of items in listbox              */
    INT     cMax;           /* cnt of total # items allocated for rgpch.
                               Not all are necessarly in use    */
    HANDLE  rgpch;          /* handle to array of string offsets    */
    HANDLE  hStrings;       /* string storage handle                */
    ICHLB   cchStrings;     /* Size in bytes of hStrings            */
    ICHLB   ichAlloc;       /* Pointer to end of hStrings (end of last valid
                               string) */
    INT     cxChar;         /* Width of a character                 */
    INT     cyChar;         /* height of line                       */
    INT     cxColumn;       /* width of a column in multicolumn listboxes */
    INT     cRow;           /* for multicolumn listboxes */
    INT     cColumn;        /* for multicolumn listboxes */
    POINT   ptPrev;         /* coord of last tracked mouse pt. used for auto
                               scrolling the listbox during timer's */
    SHORT   OwnerDraw;      /* Owner draw styles. Non-zero if ownerdraw. */
    UINT    wMultiple;      /* SINGLESEL allows a single item to be selected.
                             * MULTIPLESEL allows simple toggle multi-selection
                             * EXTENDEDSEL allows extended multi selection;
                             */

    int     fRedraw:1;      /* if TRUE then do repaints             */
    int     fDeferUpdate:1; /* */
    int     fSort:1;        /* if TRUE the sort list                */
    int     fNotify:1;      /* if TRUE then Notify parent           */
    int     fMouseDown:1;   /* if TRUE then process mouse moves/mouseup */
    int     fCaret:1;       /* flashing caret allowed               */
    int     fDoubleClick:1; /* mouse down in double click           */
    int     fCaretOn:1;     /* if TRUE then caret is on             */
    int     fAddSelMode:1;  /* if TRUE, then it is in ADD selection mode */
    int     fHasStrings:1;  /* True if the listbox has a string associated
                             * with each item else it has an app suppled LONG
                             * value and is ownerdraw
                             */
    int     fNoData:1;      /* if TRUE, then lb doesn't keep any line data
                             * beyond selection state, but instead calls back
                             * to the client for each line's definition.
                             * Forces OwnerDraw==OWNERDRAWFIXED, !fSort,
                             * and !fHasStrings.
                             */
    int     fNewItemState:1; /* select/deselect mode? for multiselection lb
                              */
    int     fUseTabStops:1; /* True if the non-ownerdraw listbox should handle
                             * tabstops
                             */
    int     fMultiColumn:1; /* True if this is a multicolumn listbox */
    int     fNoIntegralHeight:1; /* True if we don't want to size the listbox
                                  * an integral lineheight
                                  */
    int     fWantKeyboardInput:1; /* True if we should pass on WM_KEY & CHAR
                                   * so that the app can go to special items
                                   * with them.
                                   */
    int     fDoScrollBarsExist:1;  /* True if either or both of the HORZ and
                                    * VERT scroll bar Styles exist when the
                                    * listbox was created.
                                    */
    int     fUnicodeDir:1;
    int     fAutoEnableDisableScrollBars:1; /* True if the listbox should
                                             * automatically Enable/disable
                                    * it's scroll bars. If false, the scroll
                                    * bars will be hidden/Shown automatically
                                    * if they are present.
                                    */
    INT     sLastSelection; /* Used for cancelable selection. Last selection
                             * in listbox for combo box support
                             */
    INT     sMouseDown;     /* For multiselection mouse click & drag extended
                             * selection. It is the ANCHOR point for range
                             * selections
                             */
    INT     sLastMouseMove; /* selection of listbox items */
    /*
     * IanJa/Win32: Tab positions remain int for 32-bit API ??
     */
    LPINT   iTabPixelPositions; /* List of positions for tabs */
    HANDLE  hFont;          /* User settable font for listboxes */
    int     xOrigin;        /* For horizontal scrolling. The current x origin */
    int     maxWidth;       /* Maximum width of listbox in pixels for
                               horizontal scrolling purposes */
    UINT    wFileDetails;   /* What details of a file must be shown ? */
    PCBOX   pcbox;          /* Combo box pointer */
    DWORD   dwLocaleId;     /* Locale used for sorting strings in list box */
} LBIV, *PLBIV;

/*
 *  The various bits of wFileDetails field are used as mentioned below:
 *      0x0001    Should the file name be in upper case.
 *      0x0002    Should the file size be shown.
 *      0x0004    Date stamp of the file to be shown ?
 *      0x0008    Time stamp of the file to be shown ?
 *      0x0010    The dos attributes of the file ?
 *      0x0020    In xxxDlgDirSelectEx(), along with file name
 *                all other details also will be returned
 *
 *  The idStaticPath parameter to xxxDlgDirList can have the following values
 *  ORed if the list box should show other details of the files along with
 *  the name of the files;
 */
#define LBD_UPPERCASE   0x8001    // Show name in upper case
#define LBD_SIZE        0x8002    // Show size
#define LBD_DATE        0x8004    // Show date stamp
#define LBD_TIME        0x8008    // Show time stamp
#define LBD_ATTRIBUTE   0x8010    // Show DOS attributes
#define LBD_FULLDETAILS 0x801E    // name + size, date, time and DOS attributes
#define LBD_SENDDETAILS 0x8020    // In xxxDlgDirSelectEx(), along with file name
                                  // all other details also will be returned


/*
 * rgpch is set up as follows:  First there are cMac 2 byte pointers to the
 * start of the strings in hStrings or if ownerdraw, it is 4 bytes of data
 * supplied by the app and hStrings is not used.  Then if multiselection
 * listboxes, there are cMac 1 byte selection state bytes (one for each item
 * in the list box).  If variable height owner draw, there will be cMac 1 byte
 * height bytes (once again, one for each item in the list box.).
 *
 * CHANGES DONE BY SANKAR:
 *      The selection byte in rgpch is divided into two nibbles. The lower
 * nibble is the selection state (1 => Selected; 0 => de-selected)
 * and higher nibble is the display state(1 => Hilited and 0 => de-hilited).
 * You must be wondering why on earth we should store this selection state and
 * the display state seperately.Well! The reason is as follows:
 *      While Ctrl+Dragging or Shift+Ctrl+Dragging, the user can adjust the
 * selection before the mouse button is up. If the user enlarges a range and
 * and before the button is up if he shrinks the range, then the old selection
 * state has to be preserved for the individual items that do not fall in the
 * range finally.
 *      Please note that the display state and the selection state for an item
 * will be the same except when the user is dragging his mouse. When the mouse
 * is dragged, only the display state is updated so that the range is hilited
 * or de-hilited) but the selection state is preserved. Only when the button
 * goes up, for all the individual items in the range, the selection state is
 * made the same as the display state.
 */

typedef struct tagLBItem {
    LONG offsz;
    DWORD itemData;
} LBItem, *lpLBItem;

typedef struct tagLBODItem {
    DWORD itemData;
} LBODItem, *lpLBODItem;

typedef struct tagLBWND {
    WND wnd;
    PLBIV pLBIV;
} LBWND, *PLBWND;

/***************************************************************************\
*
* Static Control
*
\***************************************************************************/

typedef struct tagSTATWND {
    WND     wnd;
    HANDLE  hFont;
    HANDLE  hBrush;
    struct tagCURSOR *spicn;
} STATWND, *PSTATWND;

/***************************************************************************\
*
* global function pointers
*
\***************************************************************************/

/*
 * These are all non-exported, manually linked, USER32 functions used
 * exclusively by winsrv.
 */
typedef int             (*PFN_CLIENTDRAWTEXT)(HDC, LPWSTR, int, LPRECT, UINT, BOOL);
typedef void            (*PFN_CLIENTPSMTEXTOUT)(HDC, int, int, LPWSTR, int);
typedef LONG            (*PFN_CLIENTTABTHETEXTOUTFORWIMPS)(HDC, int, int, LPCWSTR, int, int, LPINT, int, BOOL);
typedef LONG            (*PFN_GETPREFIXCOUNT)(LPWSTR, int, LPWSTR, int);
typedef DWORD           (*PFN_MAPCLIENTNEUTERTOCLIENTPFN)(DWORD, BOOL);
typedef DWORD           (*PFN_MAPSERVERTOCLIENTPFN)(DWORD, BOOL);
typedef void            (*PFN_RTLFREECURSORICONRESOURCE)(HANDLE, HANDLE, PRESCALLS);
typedef int             (*PFN_RTLGETIDFROMDIRECTORY)(PBYTE, UINT, PDISPLAYINFO, PDWORD);
typedef PCURSORRESOURCE (*PFN_RTLLOADCURSORICONRESOURCE)(HANDLE, LPHANDLE, LPCWSTR, LPWSTR, PRESCALLS, PDISPLAYINFO, PDWORD);
typedef int             (*PFN_RTLLOADSTRINGORERROR)(HANDLE, UINT, LPWSTR, int, LPTSTR, PRESCALLS, WORD);
typedef BOOL            (*PFN_RTLMBMESSAGEWPARAMCHARTOWCS)(DWORD, PDWORD);
typedef BOOL            (*PFN_RTLWCSMESSAGEWPARAMCHARTOMB)(DWORD, PDWORD);
typedef void            (*PFN_SETSERVERINFOPOINTER)(PSERVERINFO);
typedef int             (*PFN_WCSTOMBEX)(WORD, LPCWSTR, int, LPSTR *, int, BOOL);
typedef BOOL            (*PFN__ADJUSTWINDOWRECTEX)(LPRECT, LONG, BOOL, DWORD);
typedef BOOL            (*PFN__ANYPOPUP)(oid);
typedef BOOL            (*PFN__CLIENTTOSCREEN)(PWND, PPOINT);
typedef BOOL            (*PFN__FCHILDVISIBLE)(PWND);
typedef BOOL            (*PFN__GETCLIENTRECT)(PWND, LPRECT);
typedef PWND            (*PFN__GETDESKTOPWINDOW)(oid);
typedef PWND            (*PFN__GETFIRSTLEVELCHILD)(PWND, PWND);
typedef SHORT           (*PFN__GETKEYSTATE)(int);
typedef PWND            (*PFN__GETLASTACTIVEPOPUP)(PWND);
typedef UINT            (*PFN__GETMENUITEMCOUNT)(PMENU);
typedef UINT            (*PFN__GETMENUITEMID)(PMENU, int);
typedef UINT            (*PFN__GETMENUSTATE)(PMENU, UINT, UINT);
typedef PWND            (*PFN__GETNEXTDLGGROUPITEM)(PWND, PWND, BOOL);
typedef PWND            (*PFN__GETNEXTDLGTABITEM)(PWND, PWND, BOOL);
typedef PWND            (*PFN__GETPARENT)(PWND);
typedef PMENU           (*PFN__GETSUBMENU)(PMENU, int);
typedef PWND            (*PFN__GETTOPWINDOW)(PWND);
typedef PWND            (*PFN__GETWINDOW)(PWND, UINT);
typedef DWORD           (*PFN__GETWINDOWLONG)(PWND, int, BOOL);
typedef BOOL            (*PFN__GETWINDOWRECT)(PWND, LPRECT);
typedef WORD            (*PFN__GETWINDOWWORD)(PWND, int);
typedef BOOL            (*PFN__ISCHILD)(PWND, PWND);
typedef BOOL            (*PFN__ISICONIC)(PWND);
typedef BOOL            (*PFN__ISWINDOWENABLED)(PWND);
typedef BOOL            (*PFN__ISWINDOWVISIBLE)(PWND);
typedef BOOL            (*PFN__ISZOOMED)(PWND);
typedef int             (*PFN__MAPWINDOWPOINTS)(PWND, PWND, LPPOINT, DWORD);
typedef PWND            (*PFN__NEXTCHILD)(PWND, PWND);
typedef PHOOK           (*PFN__PHKNEXT)(PHOOK);
typedef PWND            (*PFN__PREVCHILD)(PWND, PWND);
typedef BOOL            (*PFN__SCREENTOCLIENT)(PWND, PPOINT);
typedef PVOID           (*PFN_HMVALIDATEHANDLE)(HANDLE, BYTE);
typedef PVOID           (*PFN_HMVALIDATEHANDLENORIP)(HANDLE, BYTE);
typedef PVOID           (*PFN_LOOKUPMENUITEM)(PMENU, UINT, DWORD, PMENU *);
typedef int             (*PFN_FINDNCHIT)(PWND, LONG);
#ifdef DEBUG
typedef void            (CDECL *PFN_RIP)(DWORD, LPSTR, int, ...);
typedef VOID            (*PFN_RIPOUTPUT)(DWORD, LPSTR, int, LPSTR, PEXCEPTION_POINTERS);
typedef void            (CDECL *PFN_SHRED)(DWORD, LPSTR, int, LPSTR, ...);
#endif // DEBUG

typedef struct tagCLIENTPFNS {
    PFN_CLIENTDRAWTEXT pfn_clientdrawtext;
    PFN_CLIENTPSMTEXTOUT pfn_clientpsmtextout;
    PFN_CLIENTTABTHETEXTOUTFORWIMPS pfn_clienttabthetextoutforwimps;
    PFN_GETPREFIXCOUNT pfn_getprefixcount;
    PFN_MAPCLIENTNEUTERTOCLIENTPFN pfn_mapclientneutertoclientpfn;
    PFN_MAPSERVERTOCLIENTPFN pfn_mapservertoclientpfn;
    PFN_RTLFREECURSORICONRESOURCE pfn_rtlfreecursoriconresource;
    PFN_RTLGETIDFROMDIRECTORY pfn_rtlgetidfromdirectory;
    PFN_RTLLOADCURSORICONRESOURCE pfn_rtlloadcursoriconresource;
    PFN_RTLLOADSTRINGORERROR pfn_rtlloadstringorerror;
    PFN_RTLMBMESSAGEWPARAMCHARTOWCS pfn_rtlmbmessagewparamchartowcs;
    PFN_RTLWCSMESSAGEWPARAMCHARTOMB pfn_rtlwcsmessagewparamchartomb;
    PFN_SETSERVERINFOPOINTER pfn_setserverinfopointer;
    PFN_WCSTOMBEX pfn_wcstombex;
    PFN__ADJUSTWINDOWRECTEX pfn__adjustwindowrectex;
    PFN__ANYPOPUP pfn__anypopup;
    PFN__CLIENTTOSCREEN pfn__clienttoscreen;
    PFN__FCHILDVISIBLE pfn__fchildvisible;
    PFN__GETCLIENTRECT pfn__getclientrect;
    PFN__GETDESKTOPWINDOW pfn__getdesktopwindow;
    PFN__GETFIRSTLEVELCHILD pfn__getfirstlevelchild;
    PFN__GETKEYSTATE pfn__getkeystate;
    PFN__GETLASTACTIVEPOPUP pfn__getlastactivepopup;
    PFN__GETMENUITEMCOUNT pfn__getmenuitemcount;
    PFN__GETMENUITEMID pfn__getmenuitemid;
    PFN__GETMENUSTATE pfn__getmenustate;
    PFN__GETNEXTDLGGROUPITEM pfn__getnextdlggroupitem;
    PFN__GETNEXTDLGTABITEM pfn__getnextdlgtabitem;
    PFN__GETPARENT pfn__getparent;
    PFN__GETSUBMENU pfn__getsubmenu;
    PFN__GETTOPWINDOW pfn__gettopwindow;
    PFN__GETWINDOW pfn__getwindow;
    PFN__GETWINDOWLONG pfn__getwindowlong;
    PFN__GETWINDOWRECT pfn__getwindowrect;
    PFN__GETWINDOWWORD pfn__getwindowword;
    PFN__ISCHILD pfn__ischild;
    PFN__ISICONIC pfn__isiconic;
    PFN__ISWINDOWENABLED pfn__iswindowenabled;
    PFN__ISWINDOWVISIBLE pfn__iswindowvisible;
    PFN__ISZOOMED pfn__iszoomed;
    PFN__MAPWINDOWPOINTS pfn__mapwindowpoints;
    PFN__NEXTCHILD pfn__nextchild;
    PFN__PHKNEXT pfn__phknext;
    PFN__PREVCHILD pfn__prevchild;
    PFN__SCREENTOCLIENT pfn__screentoclient;
    PFN_HMVALIDATEHANDLE pfn_hmvalidatehandle;
    PFN_HMVALIDATEHANDLENORIP pfn_hmvalidatehandlenorip;
    PFN_LOOKUPMENUITEM pfn_lookupmenuitem;
    PFN_FINDNCHIT pfn_findnchit;
#ifdef DEBUG
    PFN_RIP pfn_rip;
    PFN_RIPOUTPUT pfn_ripoutput;
    PFN_SHRED pfn_shred;
#endif // DEBUG
} CLIENTPFNS, *PCLIENTPFNS;

typedef BOOL (*PUSEREXTTEXTOUTW)(HDC, int, int, UINT, CONST RECT *,LPCWSTR, UINT, CONST INT *);
typedef BOOL (*PUSERGETTEXTMETRICSW)(HDC, LPTEXTMETRICW);
typedef BOOL (*PUSERGETTEXTEXTENTPOINTW)(HDC, LPCWSTR, int, LPSIZE);
typedef COLORREF (*PUSERSETBKCOLOR)(HDC, COLORREF);
typedef COLORREF (*PUSERGETTEXTCOLOR)(HDC);
typedef BOOL (*PUSERGETVIEWPORTEXTEX)(HDC, LPSIZE);
typedef BOOL (*PUSERGETWINDOWEXTEX)(HDC, LPSIZE);
typedef HRGN (*PUSERCREATERECTRGN)(int, int, int, int);
typedef int  (*PUSERGETCLIPRGN)(HDC, HRGN);
typedef BOOL (*PUSERDELETEOBJECT)(HGDIOBJ);
typedef int  (*PUSERINTERSECTCLIPRECT)(HDC, int, int, int, int);
typedef int  (*PUSEREXTSELECTCLIPRGN)(HDC, HRGN, int);
typedef int  (*PUSERGETBKMODE)(HDC);

void ServerSetFunctionPointers(
    PUSEREXTTEXTOUTW         pUserExtTextOutW,
    PUSERGETTEXTMETRICSW     pUserGetTextMetricsW,
    PUSERGETTEXTEXTENTPOINTW pUserGetTextExtentPointW,
    PUSERSETBKCOLOR          pUserSetBkColor,
    PUSERGETTEXTCOLOR        pUserGetTextColor,
    PUSERGETVIEWPORTEXTEX    pUserGetViewportExtEx,
    PUSERGETWINDOWEXTEX      pUserGetWindowExtEx,
    PUSERCREATERECTRGN       pUserCreateRectRgn,
    PUSERGETCLIPRGN          pUserGetClipRgn,
    PUSERDELETEOBJECT        pUserDeleteObject,
    PUSERINTERSECTCLIPRECT   pUserIntersectClipRect,
    PUSEREXTSELECTCLIPRGN    pUserExtSelectClipRgn,
    PUSERGETBKMODE           pUserGetBkMode,
    PCLIENTPFNS             *ppClientPfns);

/***************************************************************************\
*
* Shared function prototypes
*
\***************************************************************************/

typedef struct _TABTEXTDATA {
    int cxTab;
    int xLeft;
    int cxMax;
    int xsign;
    int cxMaxDraw;
    int cxChar;
} TABTEXTDATA, *PTABTEXTDATA;

int ClientDrawText(HDC hdc, LPWSTR lpchText, int cchText, LPRECT lprc,
        UINT format, BOOL fRecurse);

SHORT ClientTabText(HDC hdc, int cx, int y, LPWSTR lpchStart,
    LPWSTR lpchEnd, int format, int overHang, BOOL fSkipPrefix,
    PTABTEXTDATA pttd);

void ClientPSMTextOut( HDC hdc, int xLeft, int yTop, LPWSTR lpsz, int cch);

LONG ClientTabTheTextOutForWimps(HDC hdc, int x, int y, LPCWSTR lpstring,
    int cchChars, int nTabPositions, LPINT lpintTabStopPositions,
    int iTabOrigin, BOOL fDrawTheText);

#endif // _USER_
