; ========================================================

if 0

        REBOOT.ASM

        Copyright (c) 1991 - Microsoft Corp.
        All rights reserved.
        Microsoft Confidential

        johnhe - 12/01/89

endif

;-----------------------------------------------------------------------------;
;       K E Y B O A R D   S C A N   C O D E S                                 ;
;-----------------------------------------------------------------------------;

KB_INTERCEPT    EQU     4fh

DEL_KEY         EQU     53h
ALT_SHIFT       EQU     08h
CTL_SHIFT       EQU     04h

WARM_BOOT_CODE  EQU     1234h   

;-----------------------------------------------------------------------------;
;       BIOS DATA AREA LOCATED AT 40:00
;-----------------------------------------------------------------------------;

ROM_DATA SEGMENT AT 040h

        org     17h
KB_FLAG         LABEL BYTE


        org     072h
WarmBootFlag    LABEL WORD

ROM_DATA ENDS

;-----------------------------------------------------------------------------;
;       CPU POWER-ON STARTUP LOCATION AT ffff:00
;-----------------------------------------------------------------------------;

ROM_BIOS SEGMENT AT 0ffffh
        org     0

PowerOnReset    LABEL FAR

ROM_BIOS ENDS

;-----------------------------------------------------------------------------;

;include MODEL.INC

;-----------------------------------------------------------------------------;

;.CODE
    _TEXT segment public 'CODE'
    assume cs:_TEXT,ds:nothing

    public _DnaReboot
_DnaReboot PROC near
;RebootSystem PROC

        mov     AX,3515h
        int     21h                     ; Get int 15h vector in ES:BX
        mov     AX,ES                   ; AX == Segment
        or      AX,BX                   ; Is this a NULL ptr
        jz      WarmBoot                ; If zero we can't do an int 15h

DoInt15:
        mov     ax, seg WarmBootFlag
        mov     ds, ax
        assume  DS:ROM_DATA

        mov     KB_FLAG,ALT_SHIFT OR CTL_SHIFT
        mov     AX,(KB_INTERCEPT SHL 8) OR DEL_KEY
        int     15h                     ; Put Ctrl/Alt/Del into key buffer

WarmBoot:
        cli
        cld

        mov     ax, seg WarmBootFlag
        mov     ds, ax
        assume  DS:ROM_DATA
        mov     WarmBootFlag, WARM_BOOT_CODE
        jmp     PowerOnReset
                ; Jump to the processor power-on address FFFF:0000h

_DnaReboot ENDP
;RebootSystem    ENDP

; ========================================================


;++
;
; unsigned
; _cdecl
; DnAbsoluteSectorIo(
;    IN     unsigned Drive,             //0=A, etc
;    IN     ULONG    StartSector,
;    IN     USHORT   SectorCount,
;    IN OUT PVOID    Buffer,
;    IN     BOOLEAN  Write
;    )
;
;--

        public _DnAbsoluteSectorIo
_DnAbsoluteSectorIo PROC far

        push    bp
        mov     bp,sp

        push    ds
        push    es
        push    bx
        push    si
        push    di

        ;
        ; Dirty hack -- the int25/26 buffer is laid
        ; out exactly the way the parameters are passed
        ; on the stack.
        ;
        mov     al,[bp+6]       ; fetch drive
        mov     bx,ss
        mov     ds,bx
        lea     bx,[bp+8]       ; buffer points to struct on stack
        mov     cx,0ffffh       ; use parameter packet

        cmp     byte ptr [bp+18],0
        jz      readop
        int     26h
        jmp     did_io
readop: int     25h
did_io: pop     ax              ; int25/26 wierdness
        jc      err
        xor     ax,ax
        jmp     done
err:    xor     ah,ah
done:   pop     di
        pop     si
        pop     bx
        pop     es
        pop     ds
        pop     bp
        ret

_DnAbsoluteSectorIo ENDP

_TEXT ends

        END

; ========================================================
