/*
** Copyright 1991-1993, Silicon Graphics, Inc.
** All Rights Reserved.
** 
** This is UNPUBLISHED PROPRIETARY SOURCE CODE of Silicon Graphics, Inc.;
** the contents of this file may not be disclosed to third parties, copied or
** duplicated in any form, in whole or in part, without the prior written
** permission of Silicon Graphics, Inc.
** 
** RESTRICTED RIGHTS LEGEND:
** Use, duplication or disclosure by the Government is subject to restrictions
** as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data
** and Computer Software clause at DFARS 252.227-7013, and/or in similar or
** successor clauses in the FAR, DOD or NASA FAR Supplement. Unpublished -
** rights reserved under the Copyright Laws of the United States.
*/


/*
 * AUTOMATICALLY UPDATED OR GENERATED BY SGI: DO NOT EDIT
 * IF YOU MUST MODIFY THIS FILE, PLEASE CONTACT ptar@sgi.com 415-390-1483
 */

#define const           // Don't bother with const

/* Generic OpenGL Client using subbatching. */

#include <string.h>
#include <nt.h>
#include <ntrtl.h>
#include <nturtl.h>
#include <stddef.h>
#include <windows.h>

#include <GL/gl.h>

#include "glsbmsg.h"
#include "glsbmsgh.h"
#include "glsrvspt.h"

#include "subbatch.h"
#include "batchinf.h"
#include "glteb.h"
#include "glsbcltu.h"
#include "compsize.h"
#include "debug.h"

void APIENTRY
glcltNewList ( IN GLuint list, IN GLenum mode )
{
    GLCLIENT_BEGIN( NewList, NEWLIST )
        pMsg->list     = list    ;
        pMsg->mode     = mode    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltEndList ( void )
{
    GLCLIENT_BEGIN( EndList, ENDLIST )
    return;
    GLCLIENT_END
}

void APIENTRY
glcltCallList ( IN GLuint list )
{
    GLCLIENT_BEGIN( CallList, CALLLIST )
        pMsg->list     = list    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltCallLists ( IN GLsizei n, IN GLenum type, IN const GLvoid *lists )
{
    ULONG ulSize;

    ulSize = __glCallLists_size(n, type);

    GLCLIENT_BEGIN_LARGE_SET( CallLists, CALLLISTS, lists, ulSize, listsOff )
        pMsg->n        = n       ;
        pMsg->type     = type    ;
    GLCLIENT_END_LARGE_SET
    return;
}

void APIENTRY
glcltDeleteLists ( IN GLuint list, IN GLsizei range )
{
    GLCLIENT_BEGIN( DeleteLists, DELETELISTS )
        pMsg->list     = list    ;
        pMsg->range    = range   ;
    return;
    GLCLIENT_END
}

GLuint APIENTRY
glcltGenLists ( IN GLsizei range )
{
    GLCLIENT_BEGIN( GenLists, GENLISTS )
        pMsg->range    = range   ;
        GLTEB_CLTRETURNVALUE  = 0;              // assume error
        glsbAttention();
    return((GLuint)GLTEB_CLTRETURNVALUE);
    GLCLIENT_END
}

void APIENTRY
glcltListBase ( IN GLuint base )
{
    GLCLIENT_BEGIN( ListBase, LISTBASE )
        pMsg->base     = base    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltBegin ( IN GLenum mode )
{
    GLCLIENT_BEGIN( Begin, BEGIN )
        pMsg->mode     = mode    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor3b ( IN GLbyte red, IN GLbyte green, IN GLbyte blue )
{
    GLCLIENT_BEGIN( Color3b, COLOR3B )
        pMsg->red      = red     ;
        pMsg->green    = green   ;
        pMsg->blue     = blue    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor3bv ( IN const GLbyte v[3] )
{
    GLCLIENT_BEGIN( Color3bv, COLOR3BV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor3d ( IN GLdouble red, IN GLdouble green, IN GLdouble blue )
{
    GLCLIENT_BEGIN( Color3d, COLOR3D )
        pMsg->red      = red     ;
        pMsg->green    = green   ;
        pMsg->blue     = blue    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor3dv ( IN const GLdouble v[3] )
{
    GLCLIENT_BEGIN( Color3dv, COLOR3DV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor3f ( IN GLfloat red, IN GLfloat green, IN GLfloat blue )
{
    GLCLIENT_BEGIN( Color3f, COLOR3F )
        pMsg->red      = red     ;
        pMsg->green    = green   ;
        pMsg->blue     = blue    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor3fv ( IN const GLfloat v[3] )
{
    GLCLIENT_BEGIN( Color3fv, COLOR3FV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor3i ( IN GLint red, IN GLint green, IN GLint blue )
{
    GLCLIENT_BEGIN( Color3i, COLOR3I )
        pMsg->red      = red     ;
        pMsg->green    = green   ;
        pMsg->blue     = blue    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor3iv ( IN const GLint v[3] )
{
    GLCLIENT_BEGIN( Color3iv, COLOR3IV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor3s ( IN GLshort red, IN GLshort green, IN GLshort blue )
{
    GLCLIENT_BEGIN( Color3s, COLOR3S )
        pMsg->red      = red     ;
        pMsg->green    = green   ;
        pMsg->blue     = blue    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor3sv ( IN const GLshort v[3] )
{
    GLCLIENT_BEGIN( Color3sv, COLOR3SV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor3ub ( IN GLubyte red, IN GLubyte green, IN GLubyte blue )
{
    GLCLIENT_BEGIN( Color3ub, COLOR3UB )
        pMsg->red      = red     ;
        pMsg->green    = green   ;
        pMsg->blue     = blue    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor3ubv ( IN const GLubyte v[3] )
{
    GLCLIENT_BEGIN( Color3ubv, COLOR3UBV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor3ui ( IN GLuint red, IN GLuint green, IN GLuint blue )
{
    GLCLIENT_BEGIN( Color3ui, COLOR3UI )
        pMsg->red      = red     ;
        pMsg->green    = green   ;
        pMsg->blue     = blue    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor3uiv ( IN const GLuint v[3] )
{
    GLCLIENT_BEGIN( Color3uiv, COLOR3UIV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor3us ( IN GLushort red, IN GLushort green, IN GLushort blue )
{
    GLCLIENT_BEGIN( Color3us, COLOR3US )
        pMsg->red      = red     ;
        pMsg->green    = green   ;
        pMsg->blue     = blue    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor3usv ( IN const GLushort v[3] )
{
    GLCLIENT_BEGIN( Color3usv, COLOR3USV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor4b ( IN GLbyte red, IN GLbyte green, IN GLbyte blue, IN GLbyte alpha )
{
    GLCLIENT_BEGIN( Color4b, COLOR4B )
        pMsg->red      = red     ;
        pMsg->green    = green   ;
        pMsg->blue     = blue    ;
        pMsg->alpha    = alpha   ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor4bv ( IN const GLbyte v[4] )
{
    GLCLIENT_BEGIN( Color4bv, COLOR4BV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
        pMsg->v[ 3] = v[ 3];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor4d ( IN GLdouble red, IN GLdouble green, IN GLdouble blue, IN GLdouble alpha )
{
    GLCLIENT_BEGIN( Color4d, COLOR4D )
        pMsg->red      = red     ;
        pMsg->green    = green   ;
        pMsg->blue     = blue    ;
        pMsg->alpha    = alpha   ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor4dv ( IN const GLdouble v[4] )
{
    GLCLIENT_BEGIN( Color4dv, COLOR4DV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
        pMsg->v[ 3] = v[ 3];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor4f ( IN GLfloat red, IN GLfloat green, IN GLfloat blue, IN GLfloat alpha )
{
    GLCLIENT_BEGIN( Color4f, COLOR4F )
        pMsg->red      = red     ;
        pMsg->green    = green   ;
        pMsg->blue     = blue    ;
        pMsg->alpha    = alpha   ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor4fv ( IN const GLfloat v[4] )
{
    GLCLIENT_BEGIN( Color4fv, COLOR4FV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
        pMsg->v[ 3] = v[ 3];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor4i ( IN GLint red, IN GLint green, IN GLint blue, IN GLint alpha )
{
    GLCLIENT_BEGIN( Color4i, COLOR4I )
        pMsg->red      = red     ;
        pMsg->green    = green   ;
        pMsg->blue     = blue    ;
        pMsg->alpha    = alpha   ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor4iv ( IN const GLint v[4] )
{
    GLCLIENT_BEGIN( Color4iv, COLOR4IV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
        pMsg->v[ 3] = v[ 3];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor4s ( IN GLshort red, IN GLshort green, IN GLshort blue, IN GLshort alpha )
{
    GLCLIENT_BEGIN( Color4s, COLOR4S )
        pMsg->red      = red     ;
        pMsg->green    = green   ;
        pMsg->blue     = blue    ;
        pMsg->alpha    = alpha   ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor4sv ( IN const GLshort v[4] )
{
    GLCLIENT_BEGIN( Color4sv, COLOR4SV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
        pMsg->v[ 3] = v[ 3];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor4ub ( IN GLubyte red, IN GLubyte green, IN GLubyte blue, IN GLubyte alpha )
{
    GLCLIENT_BEGIN( Color4ub, COLOR4UB )
        pMsg->red      = red     ;
        pMsg->green    = green   ;
        pMsg->blue     = blue    ;
        pMsg->alpha    = alpha   ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor4ubv ( IN const GLubyte v[4] )
{
    GLCLIENT_BEGIN( Color4ubv, COLOR4UBV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
        pMsg->v[ 3] = v[ 3];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor4ui ( IN GLuint red, IN GLuint green, IN GLuint blue, IN GLuint alpha )
{
    GLCLIENT_BEGIN( Color4ui, COLOR4UI )
        pMsg->red      = red     ;
        pMsg->green    = green   ;
        pMsg->blue     = blue    ;
        pMsg->alpha    = alpha   ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor4uiv ( IN const GLuint v[4] )
{
    GLCLIENT_BEGIN( Color4uiv, COLOR4UIV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
        pMsg->v[ 3] = v[ 3];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor4us ( IN GLushort red, IN GLushort green, IN GLushort blue, IN GLushort alpha )
{
    GLCLIENT_BEGIN( Color4us, COLOR4US )
        pMsg->red      = red     ;
        pMsg->green    = green   ;
        pMsg->blue     = blue    ;
        pMsg->alpha    = alpha   ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColor4usv ( IN const GLushort v[4] )
{
    GLCLIENT_BEGIN( Color4usv, COLOR4USV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
        pMsg->v[ 3] = v[ 3];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltEdgeFlag ( IN GLboolean flag )
{
    GLCLIENT_BEGIN( EdgeFlag, EDGEFLAG )
        pMsg->flag     = flag    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltEdgeFlagv ( IN const GLboolean flag[1] )
{
    GLCLIENT_BEGIN( EdgeFlagv, EDGEFLAGV )
        pMsg->flag[ 0] = flag[ 0];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltEnd ( void )
{
    GLCLIENT_BEGIN( End, END )
    return;
    GLCLIENT_END
}

void APIENTRY
glcltIndexd ( IN GLdouble c )
{
    GLCLIENT_BEGIN( Indexd, INDEXD )
        pMsg->c        = c       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltIndexdv ( IN const GLdouble c[1] )
{
    GLCLIENT_BEGIN( Indexdv, INDEXDV )
        pMsg->c[ 0] = c[ 0];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltIndexf ( IN GLfloat c )
{
    GLCLIENT_BEGIN( Indexf, INDEXF )
        pMsg->c        = c       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltIndexfv ( IN const GLfloat c[1] )
{
    GLCLIENT_BEGIN( Indexfv, INDEXFV )
        pMsg->c[ 0] = c[ 0];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltIndexi ( IN GLint c )
{
    GLCLIENT_BEGIN( Indexi, INDEXI )
        pMsg->c        = c       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltIndexiv ( IN const GLint c[1] )
{
    GLCLIENT_BEGIN( Indexiv, INDEXIV )
        pMsg->c[ 0] = c[ 0];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltIndexs ( IN GLshort c )
{
    GLCLIENT_BEGIN( Indexs, INDEXS )
        pMsg->c        = c       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltIndexsv ( IN const GLshort c[1] )
{
    GLCLIENT_BEGIN( Indexsv, INDEXSV )
        pMsg->c[ 0] = c[ 0];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltNormal3b ( IN GLbyte nx, IN GLbyte ny, IN GLbyte nz )
{
    GLCLIENT_BEGIN( Normal3b, NORMAL3B )
        pMsg->nx       = nx      ;
        pMsg->ny       = ny      ;
        pMsg->nz       = nz      ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltNormal3bv ( IN const GLbyte v[3] )
{
    GLCLIENT_BEGIN( Normal3bv, NORMAL3BV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltNormal3d ( IN GLdouble nx, IN GLdouble ny, IN GLdouble nz )
{
    GLCLIENT_BEGIN( Normal3d, NORMAL3D )
        pMsg->nx       = nx      ;
        pMsg->ny       = ny      ;
        pMsg->nz       = nz      ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltNormal3dv ( IN const GLdouble v[3] )
{
    GLCLIENT_BEGIN( Normal3dv, NORMAL3DV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltNormal3f ( IN GLfloat nx, IN GLfloat ny, IN GLfloat nz )
{
    GLCLIENT_BEGIN( Normal3f, NORMAL3F )
        pMsg->nx       = nx      ;
        pMsg->ny       = ny      ;
        pMsg->nz       = nz      ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltNormal3fv ( IN const GLfloat v[3] )
{
    GLCLIENT_BEGIN( Normal3fv, NORMAL3FV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltNormal3i ( IN GLint nx, IN GLint ny, IN GLint nz )
{
    GLCLIENT_BEGIN( Normal3i, NORMAL3I )
        pMsg->nx       = nx      ;
        pMsg->ny       = ny      ;
        pMsg->nz       = nz      ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltNormal3iv ( IN const GLint v[3] )
{
    GLCLIENT_BEGIN( Normal3iv, NORMAL3IV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltNormal3s ( IN GLshort nx, IN GLshort ny, IN GLshort nz )
{
    GLCLIENT_BEGIN( Normal3s, NORMAL3S )
        pMsg->nx       = nx      ;
        pMsg->ny       = ny      ;
        pMsg->nz       = nz      ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltNormal3sv ( IN const GLshort v[3] )
{
    GLCLIENT_BEGIN( Normal3sv, NORMAL3SV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos2d ( IN GLdouble x, IN GLdouble y )
{
    GLCLIENT_BEGIN( RasterPos2d, RASTERPOS2D )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos2dv ( IN const GLdouble v[2] )
{
    GLCLIENT_BEGIN( RasterPos2dv, RASTERPOS2DV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos2f ( IN GLfloat x, IN GLfloat y )
{
    GLCLIENT_BEGIN( RasterPos2f, RASTERPOS2F )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos2fv ( IN const GLfloat v[2] )
{
    GLCLIENT_BEGIN( RasterPos2fv, RASTERPOS2FV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos2i ( IN GLint x, IN GLint y )
{
    GLCLIENT_BEGIN( RasterPos2i, RASTERPOS2I )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos2iv ( IN const GLint v[2] )
{
    GLCLIENT_BEGIN( RasterPos2iv, RASTERPOS2IV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos2s ( IN GLshort x, IN GLshort y )
{
    GLCLIENT_BEGIN( RasterPos2s, RASTERPOS2S )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos2sv ( IN const GLshort v[2] )
{
    GLCLIENT_BEGIN( RasterPos2sv, RASTERPOS2SV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos3d ( IN GLdouble x, IN GLdouble y, IN GLdouble z )
{
    GLCLIENT_BEGIN( RasterPos3d, RASTERPOS3D )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->z        = z       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos3dv ( IN const GLdouble v[3] )
{
    GLCLIENT_BEGIN( RasterPos3dv, RASTERPOS3DV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos3f ( IN GLfloat x, IN GLfloat y, IN GLfloat z )
{
    GLCLIENT_BEGIN( RasterPos3f, RASTERPOS3F )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->z        = z       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos3fv ( IN const GLfloat v[3] )
{
    GLCLIENT_BEGIN( RasterPos3fv, RASTERPOS3FV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos3i ( IN GLint x, IN GLint y, IN GLint z )
{
    GLCLIENT_BEGIN( RasterPos3i, RASTERPOS3I )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->z        = z       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos3iv ( IN const GLint v[3] )
{
    GLCLIENT_BEGIN( RasterPos3iv, RASTERPOS3IV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos3s ( IN GLshort x, IN GLshort y, IN GLshort z )
{
    GLCLIENT_BEGIN( RasterPos3s, RASTERPOS3S )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->z        = z       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos3sv ( IN const GLshort v[3] )
{
    GLCLIENT_BEGIN( RasterPos3sv, RASTERPOS3SV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos4d ( IN GLdouble x, IN GLdouble y, IN GLdouble z, IN GLdouble w )
{
    GLCLIENT_BEGIN( RasterPos4d, RASTERPOS4D )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->z        = z       ;
        pMsg->w        = w       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos4dv ( IN const GLdouble v[4] )
{
    GLCLIENT_BEGIN( RasterPos4dv, RASTERPOS4DV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
        pMsg->v[ 3] = v[ 3];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos4f ( IN GLfloat x, IN GLfloat y, IN GLfloat z, IN GLfloat w )
{
    GLCLIENT_BEGIN( RasterPos4f, RASTERPOS4F )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->z        = z       ;
        pMsg->w        = w       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos4fv ( IN const GLfloat v[4] )
{
    GLCLIENT_BEGIN( RasterPos4fv, RASTERPOS4FV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
        pMsg->v[ 3] = v[ 3];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos4i ( IN GLint x, IN GLint y, IN GLint z, IN GLint w )
{
    GLCLIENT_BEGIN( RasterPos4i, RASTERPOS4I )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->z        = z       ;
        pMsg->w        = w       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos4iv ( IN const GLint v[4] )
{
    GLCLIENT_BEGIN( RasterPos4iv, RASTERPOS4IV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
        pMsg->v[ 3] = v[ 3];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos4s ( IN GLshort x, IN GLshort y, IN GLshort z, IN GLshort w )
{
    GLCLIENT_BEGIN( RasterPos4s, RASTERPOS4S )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->z        = z       ;
        pMsg->w        = w       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRasterPos4sv ( IN const GLshort v[4] )
{
    GLCLIENT_BEGIN( RasterPos4sv, RASTERPOS4SV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
        pMsg->v[ 3] = v[ 3];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRectd ( IN GLdouble x1, IN GLdouble y1, IN GLdouble x2, IN GLdouble y2 )
{
    GLCLIENT_BEGIN( Rectd, RECTD )
        pMsg->x1       = x1      ;
        pMsg->y1       = y1      ;
        pMsg->x2       = x2      ;
        pMsg->y2       = y2      ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRectdv ( IN const GLdouble v1[2], IN const GLdouble v2[2] )
{
    GLCLIENT_BEGIN( Rectdv, RECTDV )
        pMsg->v1[ 0] = v1[ 0];
        pMsg->v1[ 1] = v1[ 1];
        pMsg->v2[ 0] = v2[ 0];
        pMsg->v2[ 1] = v2[ 1];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRectf ( IN GLfloat x1, IN GLfloat y1, IN GLfloat x2, IN GLfloat y2 )
{
    GLCLIENT_BEGIN( Rectf, RECTF )
        pMsg->x1       = x1      ;
        pMsg->y1       = y1      ;
        pMsg->x2       = x2      ;
        pMsg->y2       = y2      ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRectfv ( IN const GLfloat v1[2], IN const GLfloat v2[2] )
{
    GLCLIENT_BEGIN( Rectfv, RECTFV )
        pMsg->v1[ 0] = v1[ 0];
        pMsg->v1[ 1] = v1[ 1];
        pMsg->v2[ 0] = v2[ 0];
        pMsg->v2[ 1] = v2[ 1];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRecti ( IN GLint x1, IN GLint y1, IN GLint x2, IN GLint y2 )
{
    GLCLIENT_BEGIN( Recti, RECTI )
        pMsg->x1       = x1      ;
        pMsg->y1       = y1      ;
        pMsg->x2       = x2      ;
        pMsg->y2       = y2      ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRectiv ( IN const GLint v1[2], IN const GLint v2[2] )
{
    GLCLIENT_BEGIN( Rectiv, RECTIV )
        pMsg->v1[ 0] = v1[ 0];
        pMsg->v1[ 1] = v1[ 1];
        pMsg->v2[ 0] = v2[ 0];
        pMsg->v2[ 1] = v2[ 1];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRects ( IN GLshort x1, IN GLshort y1, IN GLshort x2, IN GLshort y2 )
{
    GLCLIENT_BEGIN( Rects, RECTS )
        pMsg->x1       = x1      ;
        pMsg->y1       = y1      ;
        pMsg->x2       = x2      ;
        pMsg->y2       = y2      ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRectsv ( IN const GLshort v1[2], IN const GLshort v2[2] )
{
    GLCLIENT_BEGIN( Rectsv, RECTSV )
        pMsg->v1[ 0] = v1[ 0];
        pMsg->v1[ 1] = v1[ 1];
        pMsg->v2[ 0] = v2[ 0];
        pMsg->v2[ 1] = v2[ 1];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord1d ( IN GLdouble s )
{
    GLCLIENT_BEGIN( TexCoord1d, TEXCOORD1D )
        pMsg->s        = s       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord1dv ( IN const GLdouble v[1] )
{
    GLCLIENT_BEGIN( TexCoord1dv, TEXCOORD1DV )
        pMsg->v[ 0] = v[ 0];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord1f ( IN GLfloat s )
{
    GLCLIENT_BEGIN( TexCoord1f, TEXCOORD1F )
        pMsg->s        = s       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord1fv ( IN const GLfloat v[1] )
{
    GLCLIENT_BEGIN( TexCoord1fv, TEXCOORD1FV )
        pMsg->v[ 0] = v[ 0];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord1i ( IN GLint s )
{
    GLCLIENT_BEGIN( TexCoord1i, TEXCOORD1I )
        pMsg->s        = s       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord1iv ( IN const GLint v[1] )
{
    GLCLIENT_BEGIN( TexCoord1iv, TEXCOORD1IV )
        pMsg->v[ 0] = v[ 0];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord1s ( IN GLshort s )
{
    GLCLIENT_BEGIN( TexCoord1s, TEXCOORD1S )
        pMsg->s        = s       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord1sv ( IN const GLshort v[1] )
{
    GLCLIENT_BEGIN( TexCoord1sv, TEXCOORD1SV )
        pMsg->v[ 0] = v[ 0];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord2d ( IN GLdouble s, IN GLdouble t )
{
    GLCLIENT_BEGIN( TexCoord2d, TEXCOORD2D )
        pMsg->s        = s       ;
        pMsg->t        = t       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord2dv ( IN const GLdouble v[2] )
{
    GLCLIENT_BEGIN( TexCoord2dv, TEXCOORD2DV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord2f ( IN GLfloat s, IN GLfloat t )
{
    GLCLIENT_BEGIN( TexCoord2f, TEXCOORD2F )
        pMsg->s        = s       ;
        pMsg->t        = t       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord2fv ( IN const GLfloat v[2] )
{
    GLCLIENT_BEGIN( TexCoord2fv, TEXCOORD2FV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord2i ( IN GLint s, IN GLint t )
{
    GLCLIENT_BEGIN( TexCoord2i, TEXCOORD2I )
        pMsg->s        = s       ;
        pMsg->t        = t       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord2iv ( IN const GLint v[2] )
{
    GLCLIENT_BEGIN( TexCoord2iv, TEXCOORD2IV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord2s ( IN GLshort s, IN GLshort t )
{
    GLCLIENT_BEGIN( TexCoord2s, TEXCOORD2S )
        pMsg->s        = s       ;
        pMsg->t        = t       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord2sv ( IN const GLshort v[2] )
{
    GLCLIENT_BEGIN( TexCoord2sv, TEXCOORD2SV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord3d ( IN GLdouble s, IN GLdouble t, IN GLdouble r )
{
    GLCLIENT_BEGIN( TexCoord3d, TEXCOORD3D )
        pMsg->s        = s       ;
        pMsg->t        = t       ;
        pMsg->r        = r       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord3dv ( IN const GLdouble v[3] )
{
    GLCLIENT_BEGIN( TexCoord3dv, TEXCOORD3DV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord3f ( IN GLfloat s, IN GLfloat t, IN GLfloat r )
{
    GLCLIENT_BEGIN( TexCoord3f, TEXCOORD3F )
        pMsg->s        = s       ;
        pMsg->t        = t       ;
        pMsg->r        = r       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord3fv ( IN const GLfloat v[3] )
{
    GLCLIENT_BEGIN( TexCoord3fv, TEXCOORD3FV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord3i ( IN GLint s, IN GLint t, IN GLint r )
{
    GLCLIENT_BEGIN( TexCoord3i, TEXCOORD3I )
        pMsg->s        = s       ;
        pMsg->t        = t       ;
        pMsg->r        = r       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord3iv ( IN const GLint v[3] )
{
    GLCLIENT_BEGIN( TexCoord3iv, TEXCOORD3IV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord3s ( IN GLshort s, IN GLshort t, IN GLshort r )
{
    GLCLIENT_BEGIN( TexCoord3s, TEXCOORD3S )
        pMsg->s        = s       ;
        pMsg->t        = t       ;
        pMsg->r        = r       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord3sv ( IN const GLshort v[3] )
{
    GLCLIENT_BEGIN( TexCoord3sv, TEXCOORD3SV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord4d ( IN GLdouble s, IN GLdouble t, IN GLdouble r, IN GLdouble q )
{
    GLCLIENT_BEGIN( TexCoord4d, TEXCOORD4D )
        pMsg->s        = s       ;
        pMsg->t        = t       ;
        pMsg->r        = r       ;
        pMsg->q        = q       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord4dv ( IN const GLdouble v[4] )
{
    GLCLIENT_BEGIN( TexCoord4dv, TEXCOORD4DV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
        pMsg->v[ 3] = v[ 3];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord4f ( IN GLfloat s, IN GLfloat t, IN GLfloat r, IN GLfloat q )
{
    GLCLIENT_BEGIN( TexCoord4f, TEXCOORD4F )
        pMsg->s        = s       ;
        pMsg->t        = t       ;
        pMsg->r        = r       ;
        pMsg->q        = q       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord4fv ( IN const GLfloat v[4] )
{
    GLCLIENT_BEGIN( TexCoord4fv, TEXCOORD4FV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
        pMsg->v[ 3] = v[ 3];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord4i ( IN GLint s, IN GLint t, IN GLint r, IN GLint q )
{
    GLCLIENT_BEGIN( TexCoord4i, TEXCOORD4I )
        pMsg->s        = s       ;
        pMsg->t        = t       ;
        pMsg->r        = r       ;
        pMsg->q        = q       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord4iv ( IN const GLint v[4] )
{
    GLCLIENT_BEGIN( TexCoord4iv, TEXCOORD4IV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
        pMsg->v[ 3] = v[ 3];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord4s ( IN GLshort s, IN GLshort t, IN GLshort r, IN GLshort q )
{
    GLCLIENT_BEGIN( TexCoord4s, TEXCOORD4S )
        pMsg->s        = s       ;
        pMsg->t        = t       ;
        pMsg->r        = r       ;
        pMsg->q        = q       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTexCoord4sv ( IN const GLshort v[4] )
{
    GLCLIENT_BEGIN( TexCoord4sv, TEXCOORD4SV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
        pMsg->v[ 3] = v[ 3];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex2d ( IN GLdouble x, IN GLdouble y )
{
    GLCLIENT_BEGIN( Vertex2d, VERTEX2D )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex2dv ( IN const GLdouble v[2] )
{
    GLCLIENT_BEGIN( Vertex2dv, VERTEX2DV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex2f ( IN GLfloat x, IN GLfloat y )
{
    GLCLIENT_BEGIN( Vertex2f, VERTEX2F )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex2fv ( IN const GLfloat v[2] )
{
    GLCLIENT_BEGIN( Vertex2fv, VERTEX2FV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex2i ( IN GLint x, IN GLint y )
{
    GLCLIENT_BEGIN( Vertex2i, VERTEX2I )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex2iv ( IN const GLint v[2] )
{
    GLCLIENT_BEGIN( Vertex2iv, VERTEX2IV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex2s ( IN GLshort x, IN GLshort y )
{
    GLCLIENT_BEGIN( Vertex2s, VERTEX2S )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex2sv ( IN const GLshort v[2] )
{
    GLCLIENT_BEGIN( Vertex2sv, VERTEX2SV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex3d ( IN GLdouble x, IN GLdouble y, IN GLdouble z )
{
    GLCLIENT_BEGIN( Vertex3d, VERTEX3D )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->z        = z       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex3dv ( IN const GLdouble v[3] )
{
    GLCLIENT_BEGIN( Vertex3dv, VERTEX3DV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex3f ( IN GLfloat x, IN GLfloat y, IN GLfloat z )
{
    GLCLIENT_BEGIN( Vertex3f, VERTEX3F )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->z        = z       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex3fv ( IN const GLfloat v[3] )
{
    GLCLIENT_BEGIN( Vertex3fv, VERTEX3FV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex3i ( IN GLint x, IN GLint y, IN GLint z )
{
    GLCLIENT_BEGIN( Vertex3i, VERTEX3I )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->z        = z       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex3iv ( IN const GLint v[3] )
{
    GLCLIENT_BEGIN( Vertex3iv, VERTEX3IV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex3s ( IN GLshort x, IN GLshort y, IN GLshort z )
{
    GLCLIENT_BEGIN( Vertex3s, VERTEX3S )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->z        = z       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex3sv ( IN const GLshort v[3] )
{
    GLCLIENT_BEGIN( Vertex3sv, VERTEX3SV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex4d ( IN GLdouble x, IN GLdouble y, IN GLdouble z, IN GLdouble w )
{
    GLCLIENT_BEGIN( Vertex4d, VERTEX4D )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->z        = z       ;
        pMsg->w        = w       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex4dv ( IN const GLdouble v[4] )
{
    GLCLIENT_BEGIN( Vertex4dv, VERTEX4DV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
        pMsg->v[ 3] = v[ 3];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex4f ( IN GLfloat x, IN GLfloat y, IN GLfloat z, IN GLfloat w )
{
    GLCLIENT_BEGIN( Vertex4f, VERTEX4F )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->z        = z       ;
        pMsg->w        = w       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex4fv ( IN const GLfloat v[4] )
{
    GLCLIENT_BEGIN( Vertex4fv, VERTEX4FV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
        pMsg->v[ 3] = v[ 3];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex4i ( IN GLint x, IN GLint y, IN GLint z, IN GLint w )
{
    GLCLIENT_BEGIN( Vertex4i, VERTEX4I )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->z        = z       ;
        pMsg->w        = w       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex4iv ( IN const GLint v[4] )
{
    GLCLIENT_BEGIN( Vertex4iv, VERTEX4IV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
        pMsg->v[ 3] = v[ 3];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex4s ( IN GLshort x, IN GLshort y, IN GLshort z, IN GLshort w )
{
    GLCLIENT_BEGIN( Vertex4s, VERTEX4S )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->z        = z       ;
        pMsg->w        = w       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltVertex4sv ( IN const GLshort v[4] )
{
    GLCLIENT_BEGIN( Vertex4sv, VERTEX4SV )
        pMsg->v[ 0] = v[ 0];
        pMsg->v[ 1] = v[ 1];
        pMsg->v[ 2] = v[ 2];
        pMsg->v[ 3] = v[ 3];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltClipPlane ( IN GLenum plane, IN const GLdouble equation[4] )
{
    GLCLIENT_BEGIN( ClipPlane, CLIPPLANE )
        pMsg->plane    = plane   ;
        pMsg->equation[ 0] = equation[ 0];
        pMsg->equation[ 1] = equation[ 1];
        pMsg->equation[ 2] = equation[ 2];
        pMsg->equation[ 3] = equation[ 3];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColorMaterial ( IN GLenum face, IN GLenum mode )
{
    GLCLIENT_BEGIN( ColorMaterial, COLORMATERIAL )
        pMsg->face     = face    ;
        pMsg->mode     = mode    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltCullFace ( IN GLenum mode )
{
    GLCLIENT_BEGIN( CullFace, CULLFACE )
        pMsg->mode     = mode    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltFrontFace ( IN GLenum mode )
{
    GLCLIENT_BEGIN( FrontFace, FRONTFACE )
        pMsg->mode     = mode    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltHint ( IN GLenum target, IN GLenum mode )
{
    GLCLIENT_BEGIN( Hint, HINT )
        pMsg->target   = target  ;
        pMsg->mode     = mode    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltLineStipple ( IN GLint factor, IN GLushort pattern )
{
    GLCLIENT_BEGIN( LineStipple, LINESTIPPLE )
        pMsg->factor   = factor  ;
        pMsg->pattern  = pattern ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltLineWidth ( IN GLfloat width )
{
    GLCLIENT_BEGIN( LineWidth, LINEWIDTH )
        pMsg->width    = width   ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltPointSize ( IN GLfloat size )
{
    GLCLIENT_BEGIN( PointSize, POINTSIZE )
        pMsg->size     = size    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltPolygonMode ( IN GLenum face, IN GLenum mode )
{
    GLCLIENT_BEGIN( PolygonMode, POLYGONMODE )
        pMsg->face     = face    ;
        pMsg->mode     = mode    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltScissor ( IN GLint x, IN GLint y, IN GLsizei width, IN GLsizei height )
{
    GLCLIENT_BEGIN( Scissor, SCISSOR )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->width    = width   ;
        pMsg->height   = height  ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltShadeModel ( IN GLenum mode )
{
    GLCLIENT_BEGIN( ShadeModel, SHADEMODEL )
        pMsg->mode     = mode    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltInitNames ( void )
{
    GLCLIENT_BEGIN( InitNames, INITNAMES )
    return;
    GLCLIENT_END
}

void APIENTRY
glcltLoadName ( IN GLuint name )
{
    GLCLIENT_BEGIN( LoadName, LOADNAME )
        pMsg->name     = name    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltPassThrough ( IN GLfloat token )
{
    GLCLIENT_BEGIN( PassThrough, PASSTHROUGH )
        pMsg->token    = token   ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltPopName ( void )
{
    GLCLIENT_BEGIN( PopName, POPNAME )
    return;
    GLCLIENT_END
}

void APIENTRY
glcltPushName ( IN GLuint name )
{
    GLCLIENT_BEGIN( PushName, PUSHNAME )
        pMsg->name     = name    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltDrawBuffer ( IN GLenum mode )
{
// We're doing something special here.  By doing a glsbAttention after
// putting a glDrawBuffer in the batch, we are guaranteeing that all
// drawing done in the batch is in the same drawing mode and that the
// drawing mode cannot change until the end of the batch.  This allows
// the server to sample the current drawing mode at the beginning of
// batch and to assume that it is constant for the entire batch.
//
// The server might be able to take advantage of the fact, for example,
// that all drawing in a batch is only to the back buffer.

    GLCLIENT_BEGIN( DrawBuffer, DRAWBUFFER )
        pMsg->mode     = mode    ;
        glsbAttention();
    return;
    GLCLIENT_END
}

void APIENTRY
glcltClear ( IN GLbitfield mask )
{
    GLCLIENT_BEGIN( Clear, CLEAR )
        pMsg->mask     = mask    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltClearAccum ( IN GLfloat red, IN GLfloat green, IN GLfloat blue, IN GLfloat alpha )
{
    GLCLIENT_BEGIN( ClearAccum, CLEARACCUM )
        pMsg->red      = red     ;
        pMsg->green    = green   ;
        pMsg->blue     = blue    ;
        pMsg->alpha    = alpha   ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltClearIndex ( IN GLfloat c )
{
    GLCLIENT_BEGIN( ClearIndex, CLEARINDEX )
        pMsg->c        = c       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltClearColor ( IN GLclampf red, IN GLclampf green, IN GLclampf blue, IN GLclampf alpha )
{
    GLCLIENT_BEGIN( ClearColor, CLEARCOLOR )
        pMsg->red      = red     ;
        pMsg->green    = green   ;
        pMsg->blue     = blue    ;
        pMsg->alpha    = alpha   ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltClearStencil ( IN GLint s )
{
    GLCLIENT_BEGIN( ClearStencil, CLEARSTENCIL )
        pMsg->s        = s       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltClearDepth ( IN GLclampd depth )
{
    GLCLIENT_BEGIN( ClearDepth, CLEARDEPTH )
        pMsg->depth    = depth   ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltStencilMask ( IN GLuint mask )
{
    GLCLIENT_BEGIN( StencilMask, STENCILMASK )
        pMsg->mask     = mask    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltColorMask ( IN GLboolean red, IN GLboolean green, IN GLboolean blue, IN GLboolean alpha )
{
    GLCLIENT_BEGIN( ColorMask, COLORMASK )
        pMsg->red      = red     ;
        pMsg->green    = green   ;
        pMsg->blue     = blue    ;
        pMsg->alpha    = alpha   ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltDepthMask ( IN GLboolean flag )
{
    GLCLIENT_BEGIN( DepthMask, DEPTHMASK )
        pMsg->flag     = flag    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltIndexMask ( IN GLuint mask )
{
    GLCLIENT_BEGIN( IndexMask, INDEXMASK )
        pMsg->mask     = mask    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltAccum ( IN GLenum op, IN GLfloat value )
{
    GLCLIENT_BEGIN( Accum, ACCUM )
        pMsg->op       = op      ;
        pMsg->value    = value   ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltDisable ( IN GLenum cap )
{
    GLCLIENT_BEGIN( Disable, DISABLE )
        pMsg->cap      = cap     ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltEnable ( IN GLenum cap )
{
    GLCLIENT_BEGIN( Enable, ENABLE )
        pMsg->cap      = cap     ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltFinish ( void )
{
// This function is invalid between glBegin and glEnd.  We ignore this
// error so that we don't have to call the server if there are no calls
// in the batch.

    glsbAttention();
}

void APIENTRY
glcltFlush ( void )
{
// This function is invalid between glBegin and glEnd.  We ignore this
// error so that we don't have to call the server if there are no calls
// in the batch.

    glsbAttention();
}

void APIENTRY
glcltPopAttrib ( void )
{
    GLCLIENT_BEGIN( PopAttrib, POPATTRIB )
    return;
    GLCLIENT_END
}

void APIENTRY
glcltPushAttrib ( IN GLbitfield mask )
{
    GLCLIENT_BEGIN( PushAttrib, PUSHATTRIB )
        pMsg->mask     = mask    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltMapGrid1d ( IN GLint un, IN GLdouble u1, IN GLdouble u2 )
{
    GLCLIENT_BEGIN( MapGrid1d, MAPGRID1D )
        pMsg->un       = un      ;
        pMsg->u1       = u1      ;
        pMsg->u2       = u2      ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltMapGrid1f ( IN GLint un, IN GLfloat u1, IN GLfloat u2 )
{
    GLCLIENT_BEGIN( MapGrid1f, MAPGRID1F )
        pMsg->un       = un      ;
        pMsg->u1       = u1      ;
        pMsg->u2       = u2      ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltMapGrid2d ( IN GLint un, IN GLdouble u1, IN GLdouble u2, IN GLint vn, IN GLdouble v1, IN GLdouble v2 )
{
    GLCLIENT_BEGIN( MapGrid2d, MAPGRID2D )
        pMsg->un       = un      ;
        pMsg->u1       = u1      ;
        pMsg->u2       = u2      ;
        pMsg->vn       = vn      ;
        pMsg->v1       = v1      ;
        pMsg->v2       = v2      ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltMapGrid2f ( IN GLint un, IN GLfloat u1, IN GLfloat u2, IN GLint vn, IN GLfloat v1, IN GLfloat v2 )
{
    GLCLIENT_BEGIN( MapGrid2f, MAPGRID2F )
        pMsg->un       = un      ;
        pMsg->u1       = u1      ;
        pMsg->u2       = u2      ;
        pMsg->vn       = vn      ;
        pMsg->v1       = v1      ;
        pMsg->v2       = v2      ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltEvalCoord1d ( IN GLdouble u )
{
    GLCLIENT_BEGIN( EvalCoord1d, EVALCOORD1D )
        pMsg->u        = u       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltEvalCoord1dv ( IN const GLdouble u[1] )
{
    GLCLIENT_BEGIN( EvalCoord1dv, EVALCOORD1DV )
        pMsg->u[ 0] = u[ 0];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltEvalCoord1f ( IN GLfloat u )
{
    GLCLIENT_BEGIN( EvalCoord1f, EVALCOORD1F )
        pMsg->u        = u       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltEvalCoord1fv ( IN const GLfloat u[1] )
{
    GLCLIENT_BEGIN( EvalCoord1fv, EVALCOORD1FV )
        pMsg->u[ 0] = u[ 0];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltEvalCoord2d ( IN GLdouble u, IN GLdouble v )
{
    GLCLIENT_BEGIN( EvalCoord2d, EVALCOORD2D )
        pMsg->u        = u       ;
        pMsg->v        = v       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltEvalCoord2dv ( IN const GLdouble u[2] )
{
    GLCLIENT_BEGIN( EvalCoord2dv, EVALCOORD2DV )
        pMsg->u[ 0] = u[ 0];
        pMsg->u[ 1] = u[ 1];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltEvalCoord2f ( IN GLfloat u, IN GLfloat v )
{
    GLCLIENT_BEGIN( EvalCoord2f, EVALCOORD2F )
        pMsg->u        = u       ;
        pMsg->v        = v       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltEvalCoord2fv ( IN const GLfloat u[2] )
{
    GLCLIENT_BEGIN( EvalCoord2fv, EVALCOORD2FV )
        pMsg->u[ 0] = u[ 0];
        pMsg->u[ 1] = u[ 1];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltEvalMesh1 ( IN GLenum mode, IN GLint i1, IN GLint i2 )
{
    GLCLIENT_BEGIN( EvalMesh1, EVALMESH1 )
        pMsg->mode     = mode    ;
        pMsg->i1       = i1      ;
        pMsg->i2       = i2      ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltEvalPoint1 ( IN GLint i )
{
    GLCLIENT_BEGIN( EvalPoint1, EVALPOINT1 )
        pMsg->i        = i       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltEvalMesh2 ( IN GLenum mode, IN GLint i1, IN GLint i2, IN GLint j1, IN GLint j2 )
{
    GLCLIENT_BEGIN( EvalMesh2, EVALMESH2 )
        pMsg->mode     = mode    ;
        pMsg->i1       = i1      ;
        pMsg->i2       = i2      ;
        pMsg->j1       = j1      ;
        pMsg->j2       = j2      ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltEvalPoint2 ( IN GLint i, IN GLint j )
{
    GLCLIENT_BEGIN( EvalPoint2, EVALPOINT2 )
        pMsg->i        = i       ;
        pMsg->j        = j       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltAlphaFunc ( IN GLenum func, IN GLclampf ref )
{
    GLCLIENT_BEGIN( AlphaFunc, ALPHAFUNC )
        pMsg->func     = func    ;
        pMsg->ref      = ref     ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltBlendFunc ( IN GLenum sfactor, IN GLenum dfactor )
{
    GLCLIENT_BEGIN( BlendFunc, BLENDFUNC )
        pMsg->sfactor  = sfactor ;
        pMsg->dfactor  = dfactor ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltLogicOp ( IN GLenum opcode )
{
    GLCLIENT_BEGIN( LogicOp, LOGICOP )
        pMsg->opcode   = opcode  ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltStencilFunc ( IN GLenum func, IN GLint ref, IN GLuint mask )
{
    GLCLIENT_BEGIN( StencilFunc, STENCILFUNC )
        pMsg->func     = func    ;
        pMsg->ref      = ref     ;
        pMsg->mask     = mask    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltStencilOp ( IN GLenum fail, IN GLenum zfail, IN GLenum zpass )
{
    GLCLIENT_BEGIN( StencilOp, STENCILOP )
        pMsg->fail     = fail    ;
        pMsg->zfail    = zfail   ;
        pMsg->zpass    = zpass   ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltDepthFunc ( IN GLenum func )
{
    GLCLIENT_BEGIN( DepthFunc, DEPTHFUNC )
        pMsg->func     = func    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltPixelZoom ( IN GLfloat xfactor, IN GLfloat yfactor )
{
    GLCLIENT_BEGIN( PixelZoom, PIXELZOOM )
        pMsg->xfactor  = xfactor ;
        pMsg->yfactor  = yfactor ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltPixelTransferf ( IN GLenum pname, IN GLfloat param )
{
    GLCLIENT_BEGIN( PixelTransferf, PIXELTRANSFERF )
        pMsg->pname    = pname   ;
        pMsg->param    = param   ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltPixelTransferi ( IN GLenum pname, IN GLint param )
{
    GLCLIENT_BEGIN( PixelTransferi, PIXELTRANSFERI )
        pMsg->pname    = pname   ;
        pMsg->param    = param   ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltPixelStoref ( IN GLenum pname, IN GLfloat param )
{
    GLCLIENT_BEGIN( PixelStoref, PIXELSTOREF )
        pMsg->pname    = pname   ;
        pMsg->param    = param   ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltPixelStorei ( IN GLenum pname, IN GLint param )
{
    GLCLIENT_BEGIN( PixelStorei, PIXELSTOREI )
        pMsg->pname    = pname   ;
        pMsg->param    = param   ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltPixelMapfv ( IN GLenum map, IN GLint mapsize, IN const GLfloat values[] )
{
    ULONG ulSize;

    ulSize = mapsize * sizeof(values[0]);

    GLCLIENT_BEGIN_LARGE_SET( PixelMapfv, PIXELMAPFV, values, ulSize, valuesOff )
        pMsg->map      = map     ;
        pMsg->mapsize  = mapsize ;
    GLCLIENT_END_LARGE_SET
    return;
}

void APIENTRY
glcltPixelMapuiv ( IN GLenum map, IN GLint mapsize, IN const GLuint values[] )
{
    ULONG ulSize;

    ulSize = mapsize * sizeof(values[0]);

    GLCLIENT_BEGIN_LARGE_SET( PixelMapuiv, PIXELMAPUIV, values, ulSize, valuesOff )
        pMsg->map      = map     ;
        pMsg->mapsize  = mapsize ;
    GLCLIENT_END_LARGE_SET
    return;
}

void APIENTRY
glcltPixelMapusv ( IN GLenum map, IN GLint mapsize, IN const GLushort values[] )
{
    ULONG ulSize;

    ulSize = mapsize * sizeof(values[0]);

    GLCLIENT_BEGIN_LARGE_SET( PixelMapusv, PIXELMAPUSV, values, ulSize, valuesOff )
        pMsg->map      = map     ;
        pMsg->mapsize  = mapsize ;
    GLCLIENT_END_LARGE_SET
    return;
}

void APIENTRY
glcltReadBuffer ( IN GLenum mode )
{
    GLCLIENT_BEGIN( ReadBuffer, READBUFFER )
        pMsg->mode     = mode    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltCopyPixels ( IN GLint x, IN GLint y, IN GLsizei width, IN GLsizei height, IN GLenum type )
{
    GLCLIENT_BEGIN( CopyPixels, COPYPIXELS )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->width    = width   ;
        pMsg->height   = height  ;
        pMsg->type     = type    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltGetClipPlane ( IN GLenum plane, OUT GLdouble equation[4] )
{
    GLCLIENT_BEGIN( GetClipPlane, GETCLIPPLANE )
        pMsg->plane    = plane   ;
        glsbAttention();
        equation[ 0] = pMsg->equation[ 0];
        equation[ 1] = pMsg->equation[ 1];
        equation[ 2] = pMsg->equation[ 2];
        equation[ 3] = pMsg->equation[ 3];
    return;
    GLCLIENT_END
}

GLenum APIENTRY
glcltGetError ( void )
{
    GLCLIENT_BEGIN( GetError, GETERROR )
        GLTEB_CLTRETURNVALUE  = GL_INVALID_OPERATION;   // assume error
        glsbAttention();
    return((GLenum)GLTEB_CLTRETURNVALUE);
    GLCLIENT_END
}

void APIENTRY
glcltGetMapdv ( IN GLenum target, IN GLenum query, OUT GLdouble v[] )
{
    ULONG ulSize;

    ulSize = __glGetMapdv_size(target,query);

    GLCLIENT_BEGIN_LARGE_GET( GetMapdv, GETMAPDV, v, ulSize, vOff )
        pMsg->target   = target  ;
        pMsg->query    = query   ;
    GLCLIENT_END_LARGE_GET
    return;
}

void APIENTRY
glcltGetMapfv ( IN GLenum target, IN GLenum query, OUT GLfloat v[] )
{
    ULONG ulSize;

    ulSize = __glGetMapfv_size(target,query);

    GLCLIENT_BEGIN_LARGE_GET( GetMapfv, GETMAPFV, v, ulSize, vOff )
        pMsg->target   = target  ;
        pMsg->query    = query   ;
    GLCLIENT_END_LARGE_GET
    return;
}

void APIENTRY
glcltGetMapiv ( IN GLenum target, IN GLenum query, OUT GLint v[] )
{
    ULONG ulSize;

    ulSize = __glGetMapiv_size(target,query);

    GLCLIENT_BEGIN_LARGE_GET( GetMapiv, GETMAPIV, v, ulSize, vOff )
        pMsg->target   = target  ;
        pMsg->query    = query   ;
    GLCLIENT_END_LARGE_GET
    return;
}

void APIENTRY
glcltGetPixelMapfv ( IN GLenum map, OUT GLfloat values[] )
{
    ULONG ulSize;

    ulSize = __glGetPixelMapfv_size(map);

    GLCLIENT_BEGIN_LARGE_GET( GetPixelMapfv, GETPIXELMAPFV, values, ulSize, valuesOff )
        pMsg->map      = map     ;
    GLCLIENT_END_LARGE_GET
    return;
}

void APIENTRY
glcltGetPixelMapuiv ( IN GLenum map, OUT GLuint values[] )
{
    ULONG ulSize;

    ulSize = __glGetPixelMapuiv_size(map);

    GLCLIENT_BEGIN_LARGE_GET( GetPixelMapuiv, GETPIXELMAPUIV, values, ulSize, valuesOff )
        pMsg->map      = map     ;
    GLCLIENT_END_LARGE_GET
    return;
}

void APIENTRY
glcltGetPixelMapusv ( IN GLenum map, OUT GLushort values[] )
{
    ULONG ulSize;

    ulSize = __glGetPixelMapusv_size(map);

    GLCLIENT_BEGIN_LARGE_GET( GetPixelMapusv, GETPIXELMAPUSV, values, ulSize, valuesOff )
        pMsg->map      = map     ;
    GLCLIENT_END_LARGE_GET
    return;
}

GLboolean APIENTRY
glcltIsEnabled ( IN GLenum cap )
{
    GLCLIENT_BEGIN( IsEnabled, ISENABLED )
        pMsg->cap      = cap     ;
        GLTEB_CLTRETURNVALUE  = 0;              // assume error
        glsbAttention();
    return((GLboolean)GLTEB_CLTRETURNVALUE);
    GLCLIENT_END
}

GLboolean APIENTRY
glcltIsList ( IN GLuint list )
{
    GLCLIENT_BEGIN( IsList, ISLIST )
        pMsg->list     = list    ;
        GLTEB_CLTRETURNVALUE  = 0;              // assume error
        glsbAttention();
    return((GLboolean)GLTEB_CLTRETURNVALUE);
    GLCLIENT_END
}

void APIENTRY
glcltDepthRange ( IN GLclampd zNear, IN GLclampd zFar )
{
    GLCLIENT_BEGIN( DepthRange, DEPTHRANGE )
        pMsg->zNear    = zNear   ;
        pMsg->zFar     = zFar    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltFrustum ( IN GLdouble left, IN GLdouble right, IN GLdouble bottom, IN GLdouble top, IN GLdouble zNear, IN GLdouble zFar )
{
    GLCLIENT_BEGIN( Frustum, FRUSTUM )
        pMsg->left     = left    ;
        pMsg->right    = right   ;
        pMsg->bottom   = bottom  ;
        pMsg->top      = top     ;
        pMsg->zNear    = zNear   ;
        pMsg->zFar     = zFar    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltLoadIdentity ( void )
{
    GLCLIENT_BEGIN( LoadIdentity, LOADIDENTITY )
    return;
    GLCLIENT_END
}

void APIENTRY
glcltLoadMatrixf ( IN const GLfloat m[16] )
{
    GLCLIENT_BEGIN( LoadMatrixf, LOADMATRIXF )
        pMsg->m[ 0] = m[ 0];
        pMsg->m[ 1] = m[ 1];
        pMsg->m[ 2] = m[ 2];
        pMsg->m[ 3] = m[ 3];
        pMsg->m[ 4] = m[ 4];
        pMsg->m[ 5] = m[ 5];
        pMsg->m[ 6] = m[ 6];
        pMsg->m[ 7] = m[ 7];
        pMsg->m[ 8] = m[ 8];
        pMsg->m[ 9] = m[ 9];
        pMsg->m[10] = m[10];
        pMsg->m[11] = m[11];
        pMsg->m[12] = m[12];
        pMsg->m[13] = m[13];
        pMsg->m[14] = m[14];
        pMsg->m[15] = m[15];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltLoadMatrixd ( IN const GLdouble m[16] )
{
    GLCLIENT_BEGIN( LoadMatrixd, LOADMATRIXD )
        pMsg->m[ 0] = m[ 0];
        pMsg->m[ 1] = m[ 1];
        pMsg->m[ 2] = m[ 2];
        pMsg->m[ 3] = m[ 3];
        pMsg->m[ 4] = m[ 4];
        pMsg->m[ 5] = m[ 5];
        pMsg->m[ 6] = m[ 6];
        pMsg->m[ 7] = m[ 7];
        pMsg->m[ 8] = m[ 8];
        pMsg->m[ 9] = m[ 9];
        pMsg->m[10] = m[10];
        pMsg->m[11] = m[11];
        pMsg->m[12] = m[12];
        pMsg->m[13] = m[13];
        pMsg->m[14] = m[14];
        pMsg->m[15] = m[15];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltMatrixMode ( IN GLenum mode )
{
    GLCLIENT_BEGIN( MatrixMode, MATRIXMODE )
        pMsg->mode     = mode    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltMultMatrixf ( IN const GLfloat m[16] )
{
    GLCLIENT_BEGIN( MultMatrixf, MULTMATRIXF )
        pMsg->m[ 0] = m[ 0];
        pMsg->m[ 1] = m[ 1];
        pMsg->m[ 2] = m[ 2];
        pMsg->m[ 3] = m[ 3];
        pMsg->m[ 4] = m[ 4];
        pMsg->m[ 5] = m[ 5];
        pMsg->m[ 6] = m[ 6];
        pMsg->m[ 7] = m[ 7];
        pMsg->m[ 8] = m[ 8];
        pMsg->m[ 9] = m[ 9];
        pMsg->m[10] = m[10];
        pMsg->m[11] = m[11];
        pMsg->m[12] = m[12];
        pMsg->m[13] = m[13];
        pMsg->m[14] = m[14];
        pMsg->m[15] = m[15];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltMultMatrixd ( IN const GLdouble m[16] )
{
    GLCLIENT_BEGIN( MultMatrixd, MULTMATRIXD )
        pMsg->m[ 0] = m[ 0];
        pMsg->m[ 1] = m[ 1];
        pMsg->m[ 2] = m[ 2];
        pMsg->m[ 3] = m[ 3];
        pMsg->m[ 4] = m[ 4];
        pMsg->m[ 5] = m[ 5];
        pMsg->m[ 6] = m[ 6];
        pMsg->m[ 7] = m[ 7];
        pMsg->m[ 8] = m[ 8];
        pMsg->m[ 9] = m[ 9];
        pMsg->m[10] = m[10];
        pMsg->m[11] = m[11];
        pMsg->m[12] = m[12];
        pMsg->m[13] = m[13];
        pMsg->m[14] = m[14];
        pMsg->m[15] = m[15];
    return;
    GLCLIENT_END
}

void APIENTRY
glcltOrtho ( IN GLdouble left, IN GLdouble right, IN GLdouble bottom, IN GLdouble top, IN GLdouble zNear, IN GLdouble zFar )
{
    GLCLIENT_BEGIN( Ortho, ORTHO )
        pMsg->left     = left    ;
        pMsg->right    = right   ;
        pMsg->bottom   = bottom  ;
        pMsg->top      = top     ;
        pMsg->zNear    = zNear   ;
        pMsg->zFar     = zFar    ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltPopMatrix ( void )
{
    GLCLIENT_BEGIN( PopMatrix, POPMATRIX )
    return;
    GLCLIENT_END
}

void APIENTRY
glcltPushMatrix ( void )
{
    GLCLIENT_BEGIN( PushMatrix, PUSHMATRIX )
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRotated ( IN GLdouble angle, IN GLdouble x, IN GLdouble y, IN GLdouble z )
{
    GLCLIENT_BEGIN( Rotated, ROTATED )
        pMsg->angle    = angle   ;
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->z        = z       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltRotatef ( IN GLfloat angle, IN GLfloat x, IN GLfloat y, IN GLfloat z )
{
    GLCLIENT_BEGIN( Rotatef, ROTATEF )
        pMsg->angle    = angle   ;
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->z        = z       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltScaled ( IN GLdouble x, IN GLdouble y, IN GLdouble z )
{
    GLCLIENT_BEGIN( Scaled, SCALED )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->z        = z       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltScalef ( IN GLfloat x, IN GLfloat y, IN GLfloat z )
{
    GLCLIENT_BEGIN( Scalef, SCALEF )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->z        = z       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTranslated ( IN GLdouble x, IN GLdouble y, IN GLdouble z )
{
    GLCLIENT_BEGIN( Translated, TRANSLATED )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->z        = z       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltTranslatef ( IN GLfloat x, IN GLfloat y, IN GLfloat z )
{
    GLCLIENT_BEGIN( Translatef, TRANSLATEF )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->z        = z       ;
    return;
    GLCLIENT_END
}

void APIENTRY
glcltViewport ( IN GLint x, IN GLint y, IN GLsizei width, IN GLsizei height )
{
    GLCLIENT_BEGIN( Viewport, VIEWPORT )
        pMsg->x        = x       ;
        pMsg->y        = y       ;
        pMsg->width    = width   ;
        pMsg->height   = height  ;
    return;
    GLCLIENT_END
}
