
/*++

       File: fernel32.c

	  Profiling dll for kernel32.dll

	  NOTE: This file is partially generated by WRAPPER code generator

--*/

#include <nt.h>
#include <ntrtl.h>
#include <nturtl.h>
#include "windows.h"
#include "baseprf.h"
#include "syncprf.h"
#include "timing.h"
#include "stdlib.h"

#define  NOTYPE		((UCHAR) 10)

WCHAR    MUTNAME[] = L"Mutex";
WCHAR    EVENAME[] = L"Event";
WCHAR	 SEMNAME[] = L"Semaphore";

void WriteFileAnsi (HANDLE hFile, LPVOID OutBuf, DWORD cChar, LPDWORD lpcWChar, LPOVERLAPPED lpOVerLapped);

void WriteFileAnsi (HANDLE hFile, LPVOID OutBuf, DWORD cChar, LPDWORD lpcWChar, LPOVERLAPPED lpOVerLapped )
{
	static CHAR achOutBuf[OUTLEN];

	wcstombs (achOutBuf, OutBuf, min(cChar, OUTLEN));
	WriteFile (hFile, achOutBuf, min(cChar,OUTLEN), lpcWChar, lpOVerLapped ) ;
}

#if 0
void DbgDump ( char * title , char * src )
{
	static char buf[100] ;
	char * dst = buf ;
	int x ;

	for ( x=0 ; x<10 ; x++ ) {
		if (isprint(*src))
			wsprintf ( dst , "%02x(%c) " , *src , *src ) ;
		else
			wsprintf ( dst , "%02x(.) " , *src ) ;
		while ( *dst ) dst++ ;
		src++ ;
	}
	wsprintf ( dst , "\n" , *src ) ;

	OutputDebugString ( title ) ;
	OutputDebugString ( "  --  " ) ;
	OutputDebugString ( buf ) ;
}
#endif


BOOL  FCloseHandle (HANDLE hObject)
{

    BOOL RetVal, bDiskFileType;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    UCHAR Type = NOTYPE;

    // Find the handle type now, because later the handle will be closed
    bDiskFileType = (GetFileType (hObject) == FILE_TYPE_DISK);
    if ( ! bDiskFileType ) {
      if ( NtQueryObject ( hObject, ObjectTypeInformation, &tiTypeInfo,
					 BUFSIZE, NULL ) == STATUS_SUCCESS ) {
	if ( lstrcmpi ( (LPCTSTR)TypeInfoBuffer, (LPCTSTR)EVENAME ) == 0 )
	    Type = EVENT;
	else if ( lstrcmpi ( (LPCTSTR)TypeInfoBuffer, (LPCTSTR)SEMNAME ) == 0 )
	    Type = SEMAPHORE;
	else if ( lstrcmpi ( (LPCTSTR)TypeInfoBuffer, (LPCTSTR)MUTNAME ) == 0 )
	    Type = MUTEX;
      }
    }

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CloseHandle(hObject);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( bDiskFileType && RetVal )  {
    		PFP_Handle phHandleData;
	WaitForSingleObject ( hMutex, INFINITE );
	phHandleData = DeactivateHandle ( (HFILE) hObject );
	ClosefAccounting ( phHandleData->pfHandleData, ulElapsedTime );
	if ( phHandleData == phDuplicated )
	    // The below field, unused for duplicated handles, is used to
	    // count the number of close operations on duplicated handles
	    phDuplicated->pfHandleData->Createf.nTimeOfOp.LowPart++;
	ReleaseMutex ( hMutex );
    }
    else if ( (Type != NOTYPE) && RetVal ) {
    		PSP_Handle phHandleData;
	WaitForSingleObject ( hSMutex[Type], INFINITE );
	phHandleData = DeactivateSyncHandle ( hObject, Type );
	ClosesAccounting ( phHandleData->psHandleData, ulElapsedTime );
	if ( phHandleData == phSDuplicated[Type] )
	    // The below field, unused for duplicated handles, is used to
	    // count the number of close operations on duplicated handles
	    phSDuplicated[Type]->psHandleData->Creates.nTimeOfOp.LowPart++;
	ReleaseMutex ( hSMutex[Type] );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



HANDLE  FCreateFileA (LPCSTR lpFileName,DWORD dwDesiredAccess,DWORD dwShareMode,LPSECURITY_ATTRIBUTES lpSecurityAttributes,DWORD dwCreationDisposition,DWORD dwFlagsAndAttributes,HANDLE hTemplateFile)
{

    HANDLE RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateFileA(lpFileName,dwDesiredAccess,dwShareMode,lpSecurityAttributes,dwCreationDisposition,dwFlagsAndAttributes,hTemplateFile);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( (RetVal != ((HANDLE)(-1)))&&(GetFileType (RetVal)==FILE_TYPE_DISK) ) {
	WaitForSingleObject ( hMutex, INFINITE );

	mbstowcs ((WCHAR *)wsNameBuffer, lpFileName, (BUFFERLEN/2));

	phHandleData = AddHandle ( (HFILE) RetVal, wsNameBuffer );
    	CreatefAccounting ( phHandleData->pfHandleData, ulElapsedTime );
    	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}


HANDLE  FCreateFileW (LPCWSTR lpFileName,DWORD dwDesiredAccess,DWORD dwShareMode,LPSECURITY_ATTRIBUTES lpSecurityAttributes,DWORD dwCreationDisposition,DWORD dwFlagsAndAttributes,HANDLE hTemplateFile)
{

    HANDLE RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateFileW(lpFileName,dwDesiredAccess,dwShareMode,lpSecurityAttributes,dwCreationDisposition,dwFlagsAndAttributes,hTemplateFile);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call

    if ( (RetVal != ((HANDLE)(-1)))&&(GetFileType (RetVal)==FILE_TYPE_DISK) ) {
    	WaitForSingleObject ( hMutex, INFINITE );
	phHandleData = AddHandle ( (HFILE) RetVal, (LPTSTR) lpFileName );
    	CreatefAccounting ( phHandleData->pfHandleData, ulElapsedTime );
    	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



BOOL  FFlushFileBuffers (HANDLE hFile)
{

    BOOL RetVal;
    SHORT sTimerHandle;
    ULONG  ulElapsedTime;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FlushFileBuffers(hFile);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( GetFileType ( hFile ) == FILE_TYPE_DISK )  {
	WaitForSingleObject ( hMutex, INFINITE );
	phHandleData = FindHandle ( (HFILE) hFile );
	FlushfAccounting ( phHandleData->pfHandleData, ulElapsedTime );
	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}


BOOL  FGetFileInformationByHandle (HANDLE hFile,LPBY_HANDLE_FILE_INFORMATION lpFileInformation)
{

    BOOL RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetFileInformationByHandle(hFile,lpFileInformation);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( GetFileType ( hFile ) == FILE_TYPE_DISK )  {
	WaitForSingleObject ( hMutex, INFINITE );
	phHandleData = FindHandle ( (HFILE) hFile );
	InfofAccounting ( phHandleData->pfHandleData, ulElapsedTime );
	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}


DWORD  FGetFileSize (HANDLE hFile,LPDWORD lpFileSizeHigh)
{

    DWORD RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetFileSize(hFile,lpFileSizeHigh);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( GetFileType ( hFile ) == FILE_TYPE_DISK )  {
	WaitForSingleObject ( hMutex, INFINITE );
	phHandleData = FindHandle ( (HFILE) hFile );
	InfofAccounting ( phHandleData->pfHandleData, ulElapsedTime );
	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



BOOL  FGetFileTime (HANDLE hFile,LPFILETIME lpCreationTime,LPFILETIME lpLastAccessTime,LPFILETIME lpLastWriteTime)
{

    BOOL RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetFileTime(hFile,lpCreationTime,lpLastAccessTime,lpLastWriteTime);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( GetFileType ( hFile ) == FILE_TYPE_DISK ) {
	WaitForSingleObject ( hMutex, INFINITE );
	phHandleData = FindHandle ( (HFILE) hFile );
	InfofAccounting ( phHandleData->pfHandleData, ulElapsedTime );
	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



DWORD  FGetFileType (HANDLE hFile)
{

    DWORD RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetFileType(hFile);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( GetFileType ( hFile ) == FILE_TYPE_DISK )  {
	WaitForSingleObject ( hMutex, INFINITE );
	phHandleData = FindHandle ( (HFILE) hFile );
	InfofAccounting ( phHandleData->pfHandleData, ulElapsedTime );
	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}


BOOL  FLockFile (HANDLE hFile,DWORD dwFileOffsetLow,DWORD dwFileOffsetHigh,DWORD nNumberOfBytesToLockLow,DWORD nNumberOfBytesToLockHigh)
{

    BOOL RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    LARGE_INTEGER nNumOfBytesToLock;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LockFile(hFile,dwFileOffsetLow,dwFileOffsetHigh,nNumberOfBytesToLockLow,nNumberOfBytesToLockHigh);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( GetFileType ( hFile ) == FILE_TYPE_DISK )  {
	WaitForSingleObject ( hMutex, INFINITE );
	phHandleData = FindHandle ( (HFILE) hFile );
	nNumOfBytesToLock.LowPart = nNumberOfBytesToLockLow;
	nNumOfBytesToLock.HighPart = nNumberOfBytesToLockHigh;
	LockfAccounting ( phHandleData->pfHandleData, ulElapsedTime, RetVal,
							    nNumOfBytesToLock );
	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}


BOOL  FLockFileEx (HANDLE hFile,DWORD dwFlags,DWORD dwKey,DWORD nNumberOfBytesToLockLow,DWORD nNumberOfBytesToLockHigh,LPOVERLAPPED lpOverlapped)
{

    BOOL RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    LARGE_INTEGER nNumOfBytesToLock;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LockFileEx(hFile,dwFlags,dwKey,nNumberOfBytesToLockLow,nNumberOfBytesToLockHigh,lpOverlapped);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( GetFileType ( hFile ) == FILE_TYPE_DISK )  {
	WaitForSingleObject ( hMutex, INFINITE );
	phHandleData = FindHandle ( (HFILE) hFile );
	nNumOfBytesToLock.LowPart = nNumberOfBytesToLockLow;
	nNumOfBytesToLock.HighPart = nNumberOfBytesToLockHigh;
	LockfAccounting ( phHandleData->pfHandleData, ulElapsedTime, RetVal,
							    nNumOfBytesToLock );
	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}


HFILE  FOpenFile (LPCSTR lpFileName,LPOFSTRUCT lpReOpenBuff,UINT uStyle)
{

    HFILE RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = OpenFile(lpFileName,lpReOpenBuff,uStyle);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( (RetVal != (-1)) && (GetFileType((HANDLE)RetVal) == FILE_TYPE_DISK) ) {
	WaitForSingleObject ( hMutex, INFINITE );

	mbstowcs ((WCHAR *)wsNameBuffer, lpFileName, (BUFFERLEN/2));

	phHandleData = AddHandle ( RetVal, wsNameBuffer );
    	OpenfAccounting ( phHandleData->pfHandleData, ulElapsedTime );
    	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}


BOOL  FReadFile (HANDLE hFile,LPVOID lpBuffer,DWORD nNumberOfBytesToRead,LPDWORD lpNumberOfBytesRead,LPOVERLAPPED lpOverlapped)
{

    BOOL RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ReadFile(hFile,lpBuffer,nNumberOfBytesToRead,lpNumberOfBytesRead,lpOverlapped);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( GetFileType ( hFile ) == FILE_TYPE_DISK )  {
	WaitForSingleObject ( hMutex, INFINITE );
	phHandleData = FindHandle ( (HFILE) hFile );
	ReadfAccounting ( phHandleData->pfHandleData, ulElapsedTime,
							 nNumberOfBytesToRead );
	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



BOOL  FReadFileEx (HANDLE hFile,LPVOID lpBuffer,DWORD nNumberOfBytesToRead,LPOVERLAPPED lpOverlapped,LPOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine)
{

    BOOL RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ReadFileEx(hFile,lpBuffer,nNumberOfBytesToRead,lpOverlapped,lpCompletionRoutine);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( GetFileType ( hFile ) == FILE_TYPE_DISK )  {
	WaitForSingleObject ( hMutex, INFINITE );
	phHandleData = FindHandle ( (HFILE) hFile );
	ReadfAccounting ( phHandleData->pfHandleData, ulElapsedTime,
							 nNumberOfBytesToRead );
	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



BOOL  FSetEndOfFile (HANDLE hFile)
{

    BOOL RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetEndOfFile(hFile);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( GetFileType ( hFile ) == FILE_TYPE_DISK )  {
	WaitForSingleObject ( hMutex, INFINITE );
	phHandleData = FindHandle ( (HFILE) hFile );
	SeteofAccounting ( phHandleData->pfHandleData, ulElapsedTime );
	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}


DWORD  FSetFilePointer (HANDLE hFile,LONG lDistanceToMove,PLONG lpDistanceToMoveHigh,DWORD dwMoveMethod)
{

    DWORD RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetFilePointer(hFile,lDistanceToMove,lpDistanceToMoveHigh,dwMoveMethod);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( GetFileType ( hFile ) == FILE_TYPE_DISK )  {
	WaitForSingleObject ( hMutex, INFINITE );
	phHandleData = FindHandle ( (HFILE) hFile );
	SeekfAccounting ( phHandleData->pfHandleData, ulElapsedTime );
	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}


BOOL  FSetFileTime (HANDLE hFile,LPFILETIME lpCreationTime,LPFILETIME lpLastAccessTime,LPFILETIME lpLastWriteTime)
{

    BOOL RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetFileTime(hFile,lpCreationTime,lpLastAccessTime,lpLastWriteTime);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( GetFileType ( hFile ) == FILE_TYPE_DISK )  {
	WaitForSingleObject ( hMutex, INFINITE );
	phHandleData = FindHandle ( (HFILE) hFile );
	InfofAccounting ( phHandleData->pfHandleData, ulElapsedTime );
	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}


BOOL  FUnlockFile (HANDLE hFile,DWORD dwFileOffsetLow,DWORD dwFileOffsetHigh,DWORD nNumberOfBytesToUnlockLow,DWORD nNumberOfBytesToUnlockHigh)
{

    BOOL RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = UnlockFile(hFile,dwFileOffsetLow,dwFileOffsetHigh,nNumberOfBytesToUnlockLow,nNumberOfBytesToUnlockHigh);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( GetFileType ( hFile ) == FILE_TYPE_DISK )  {
	WaitForSingleObject ( hMutex, INFINITE );
	phHandleData = FindHandle ( (HFILE) hFile );
	UnlockfAccounting ( phHandleData->pfHandleData, ulElapsedTime, RetVal );
	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}


BOOL  FUnlockFileEx (HANDLE hFile,DWORD dwKey,DWORD nNumberOfBytesToUnlockLow,DWORD nNumberOfBytesToUnlockHigh,LPOVERLAPPED lpOverlapped)
{

    BOOL RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = UnlockFileEx(hFile,dwKey,nNumberOfBytesToUnlockLow,nNumberOfBytesToUnlockHigh,lpOverlapped);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( GetFileType ( hFile ) == FILE_TYPE_DISK )  {
	WaitForSingleObject ( hMutex, INFINITE );
	phHandleData = FindHandle ( (HFILE) hFile );
	UnlockfAccounting ( phHandleData->pfHandleData, ulElapsedTime, RetVal );
	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}


BOOL  FWriteFile (HANDLE hFile,const void* lpBuffer,DWORD nNumberOfBytesToWrite,LPDWORD lpNumberOfBytesWritten,LPOVERLAPPED lpOverlapped)
{

    BOOL RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WriteFile(hFile,lpBuffer,nNumberOfBytesToWrite,lpNumberOfBytesWritten,lpOverlapped);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( GetFileType ( hFile ) == FILE_TYPE_DISK )  {
	WaitForSingleObject ( hMutex, INFINITE );
	phHandleData = FindHandle ( (HFILE) hFile );
	WritefAccounting ( phHandleData->pfHandleData, ulElapsedTime,
							nNumberOfBytesToWrite );
	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



BOOL  FWriteFileEx (HANDLE hFile,LPVOID lpBuffer,DWORD nNumberOfBytesToWrite,LPOVERLAPPED lpOverlapped,LPOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine)
{

    BOOL RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WriteFileEx(hFile,lpBuffer,nNumberOfBytesToWrite,lpOverlapped,lpCompletionRoutine);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( GetFileType ( hFile ) == FILE_TYPE_DISK )  {
	WaitForSingleObject ( hMutex, INFINITE );
	phHandleData = FindHandle ( (HFILE) hFile );
	WritefAccounting ( phHandleData->pfHandleData, ulElapsedTime,
							nNumberOfBytesToWrite );
	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}


HFILE  F_lclose (HFILE hFile)
{

    HFILE RetVal;
    SHORT sTimerHandle;
    BOOL  bDiskFileType;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;

    // Find the file type now, because later the handle will be closed
    bDiskFileType = (GetFileType ((HANDLE) hFile) == FILE_TYPE_DISK);

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = _lclose(hFile);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( bDiskFileType && (RetVal == (HFILE) 0) )  {
	WaitForSingleObject ( hMutex, INFINITE );
	phHandleData = DeactivateHandle ( hFile );
	ClosefAccounting ( phHandleData->pfHandleData, ulElapsedTime );
	if ( phHandleData == phDuplicated ) {
	    // The below field, unused for duplicated handles, counts the
	    // number of close operations on duplicated handles
	    phDuplicated->pfHandleData->Createf.nTimeOfOp.LowPart++;
	}
	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



HFILE  F_lcreat (LPCSTR lpPathName,int iAttribute)
{

    HFILE RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = _lcreat(lpPathName,iAttribute);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( (RetVal != (-1)) && (GetFileType((HANDLE)RetVal) ==FILE_TYPE_DISK ) ) {
	WaitForSingleObject ( hMutex, INFINITE );

	mbstowcs ((WCHAR *)wsNameBuffer, lpPathName, (BUFFERLEN/2));

	phHandleData = AddHandle ( RetVal, wsNameBuffer );
    	CreatefAccounting ( phHandleData->pfHandleData, ulElapsedTime );
    	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}


LONG  F_llseek (HFILE hFile,LONG lOffset,int iOrigin)
{

    LONG RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;


    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = _llseek(hFile,lOffset,iOrigin);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( GetFileType ( (HANDLE) hFile ) == FILE_TYPE_DISK )  {
	WaitForSingleObject ( hMutex , INFINITE );
	phHandleData = FindHandle ( hFile );
	SeekfAccounting ( phHandleData->pfHandleData, ulElapsedTime );
	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



HFILE  F_lopen (LPCSTR lpPathName,int iReadWrite)
{

    HFILE RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = _lopen(lpPathName,iReadWrite);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( (RetVal != (-1)) && (GetFileType((HANDLE)RetVal) == FILE_TYPE_DISK)) {
	WaitForSingleObject ( hMutex, INFINITE );

	mbstowcs ((WCHAR *)wsNameBuffer, lpPathName, (BUFFERLEN/2));

	phHandleData = AddHandle ( RetVal, wsNameBuffer );
    	OpenfAccounting ( phHandleData->pfHandleData, ulElapsedTime );
    	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



long  F_hread (HFILE hFile,LPVOID lpBuffer,long lBytes)
{

    long  RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = _hread(hFile,lpBuffer,lBytes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( GetFileType ( (HANDLE) hFile ) == FILE_TYPE_DISK )  {
	WaitForSingleObject ( hMutex, INFINITE );
	phHandleData = FindHandle ( hFile );
	ReadfAccounting ( phHandleData->pfHandleData, ulElapsedTime,
								(ULONG) lBytes);
	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



UINT  F_lread (HFILE hFile,LPVOID lpBuffer,UINT uBytes)
{

    UINT RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = _lread(hFile,lpBuffer,uBytes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( GetFileType ( (HANDLE) hFile ) == FILE_TYPE_DISK )  {
	WaitForSingleObject ( hMutex, INFINITE );
	phHandleData = FindHandle ( hFile );
	ReadfAccounting ( phHandleData->pfHandleData, ulElapsedTime,
								(ULONG) uBytes);
	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



long  F_hwrite (HFILE hFile,LPCSTR lpBuffer,long lBytes)
{

    long  RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = _hwrite(hFile,lpBuffer,lBytes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( GetFileType ( (HANDLE) hFile ) == FILE_TYPE_DISK )  {
	WaitForSingleObject ( hMutex, INFINITE );
	phHandleData = FindHandle ( hFile );
	WritefAccounting ( phHandleData->pfHandleData, ulElapsedTime,
								(ULONG) lBytes);
	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



UINT  F_lwrite (HFILE hFile,LPCSTR lpBuffer,UINT uBytes)
{

    UINT RetVal;
    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PFP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = _lwrite(hFile,lpBuffer,uBytes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle) - ulTimerOverhead;

    // Update the data structures with the information obtained from the new
    // API call
    if ( GetFileType ( (HANDLE) hFile ) == FILE_TYPE_DISK )  {
	WaitForSingleObject ( hMutex, INFINITE );
	phHandleData = FindHandle ( hFile );
	WritefAccounting ( phHandleData->pfHandleData, ulElapsedTime,
								(ULONG) uBytes);
	ReleaseMutex ( hMutex );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}




HANDLE  FCreateEventA (LPSECURITY_ATTRIBUTES lpEventAttributes,BOOL bManualReset,BOOL bInitialState,LPSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PSP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);

    //
    // Call the api
    //
    RetVal = CreateEventA(lpEventAttributes,bManualReset,bInitialState,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);

    if ( RetVal != NULL ) {
	WaitForSingleObject ( hBufferMutex, INFINITE );
	if ( lpName != (LPSTR) NULL )
		mbstowcs ((WCHAR *)wsSNameBuffer, lpName, (BUFFERLEN/2));
	else
	    *(wsSNameBuffer) = L'\0';
	WaitForSingleObject ( hSMutex[EVENT], INFINITE );
	if ( bManualReset )
	    phHandleData = AddSyncHandle ( RetVal, wsSNameBuffer, 1L, EVENT );
	else
	    phHandleData = AddSyncHandle ( RetVal, wsSNameBuffer, 0L, EVENT );
	ReleaseMutex ( hBufferMutex );
	CreatesAccounting ( phHandleData->psHandleData, ulElapsedTime );
	ReleaseMutex ( hSMutex[EVENT] );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



HANDLE  FCreateEventW (LPSECURITY_ATTRIBUTES lpEventAttributes,BOOL bManualReset,BOOL bInitialState,LPWSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PSP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);

    //
    // Call the api
    //
    RetVal = CreateEventW(lpEventAttributes,bManualReset,bInitialState,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);

    if ( RetVal != NULL ) {
	WaitForSingleObject ( hSMutex[EVENT], INFINITE );
	if ( bManualReset )
	    phHandleData = AddSyncHandle ( RetVal, (LPTSTR)lpName, 1L, EVENT );
	else
	    phHandleData = AddSyncHandle ( RetVal, (LPTSTR)lpName, 0L, EVENT );
	CreatesAccounting ( phHandleData->psHandleData, ulElapsedTime );
	ReleaseMutex ( hSMutex[EVENT] );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



HANDLE  FCreateMutexA (LPSECURITY_ATTRIBUTES lpMutexAttributes,BOOL bInitialOwner,LPSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PSP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);

    //
    // Call the api
    //
    RetVal = CreateMutexA(lpMutexAttributes,bInitialOwner,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);

    if ( RetVal != NULL ) {
	WaitForSingleObject ( hBufferMutex, INFINITE );
	if ( lpName != (LPSTR) NULL )
		mbstowcs ((WCHAR *)wsSNameBuffer, lpName, (BUFFERLEN/2));
	else
	    *(wsSNameBuffer) = L'\0';
	WaitForSingleObject ( hSMutex[MUTEX], INFINITE );
	phHandleData = AddSyncHandle ( RetVal, wsSNameBuffer, 0L, MUTEX );
	ReleaseMutex ( hBufferMutex );
	CreatesAccounting ( phHandleData->psHandleData, ulElapsedTime );
	ReleaseMutex ( hSMutex[MUTEX] );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



HANDLE  FCreateMutexW (LPSECURITY_ATTRIBUTES lpMutexAttributes,BOOL bInitialOwner,LPWSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PSP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);

    //
    // Call the api
    //
    RetVal = CreateMutexW(lpMutexAttributes,bInitialOwner,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);

    if ( RetVal != NULL ) {
	WaitForSingleObject ( hSMutex[MUTEX], INFINITE );
	phHandleData = AddSyncHandle ( RetVal, (LPTSTR)lpName, 0L, MUTEX );
	CreatesAccounting ( phHandleData->psHandleData, ulElapsedTime );
	ReleaseMutex ( hSMutex[MUTEX] );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}


HANDLE  FCreateSemaphoreA (LPSECURITY_ATTRIBUTES lpSemaphoreAttributes,LONG lInitialCount,LONG lMaximumCount,LPSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PSP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);

    //
    // Call the api
    //
    RetVal = CreateSemaphoreA(lpSemaphoreAttributes,lInitialCount,lMaximumCount,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);

    if ( RetVal != NULL ) {
	WaitForSingleObject ( hBufferMutex, INFINITE );
	if ( lpName != (LPSTR) NULL )
		mbstowcs ((WCHAR *)wsSNameBuffer, lpName, (BUFFERLEN/2));
	else
	    *(wsSNameBuffer) = L'\0';
	WaitForSingleObject ( hSMutex[SEMAPHORE], INFINITE );
	phHandleData = AddSyncHandle ( RetVal, wsSNameBuffer, lMaximumCount,
								    SEMAPHORE );
	ReleaseMutex ( hBufferMutex );
	CreatesAccounting ( phHandleData->psHandleData, ulElapsedTime );
	ReleaseMutex ( hSMutex[SEMAPHORE] );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



HANDLE  FCreateSemaphoreW (LPSECURITY_ATTRIBUTES lpSemaphoreAttributes,LONG lInitialCount,LONG lMaximumCount,LPWSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PSP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);

    //
    // Call the api
    //
    RetVal = CreateSemaphoreW(lpSemaphoreAttributes,lInitialCount,lMaximumCount,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);

    if ( RetVal != NULL ) {
	WaitForSingleObject ( hSMutex[SEMAPHORE], INFINITE );
	phHandleData = AddSyncHandle ( RetVal, (LPTSTR)lpName, lMaximumCount,
								    SEMAPHORE );
	CreatesAccounting ( phHandleData->psHandleData, ulElapsedTime );
	ReleaseMutex ( hSMutex[SEMAPHORE] );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



HANDLE  FOpenEventA (DWORD dwDesiredAccess,BOOL bInheritHandle,LPSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PSP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);

    //
    // Call the api
    //
    RetVal = OpenEventA(dwDesiredAccess,bInheritHandle,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);

    if ( RetVal != NULL ) {
	WaitForSingleObject ( hBufferMutex, INFINITE );
	if ( lpName != (LPSTR) NULL )
		mbstowcs ((WCHAR *)wsSNameBuffer, lpName, (BUFFERLEN/2));
	else
	    *(wsSNameBuffer) = L'\0';
	WaitForSingleObject ( hSMutex[EVENT], INFINITE );
	phHandleData = AddSyncHandle ( RetVal, wsSNameBuffer, -1L, EVENT );
	ReleaseMutex ( hBufferMutex );
	OpensAccounting ( phHandleData->psHandleData, ulElapsedTime );
	ReleaseMutex ( hSMutex[EVENT] );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}


HANDLE  FOpenEventW (DWORD dwDesiredAccess,BOOL bInheritHandle,LPWSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PSP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);

    //
    // Call the api
    //
    RetVal = OpenEventW(dwDesiredAccess,bInheritHandle,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);

    if ( RetVal != NULL ) {
	WaitForSingleObject ( hSMutex[EVENT], INFINITE );
	phHandleData = AddSyncHandle ( RetVal, (LPTSTR)lpName, -1L, EVENT );
	OpensAccounting ( phHandleData->psHandleData, ulElapsedTime );
	ReleaseMutex ( hSMutex[EVENT] );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



HANDLE  FOpenMutexA (DWORD dwDesiredAccess,BOOL bInheritHandle,LPSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PSP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);

    //
    // Call the api
    //
    RetVal = OpenMutexA(dwDesiredAccess,bInheritHandle,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);

    if ( RetVal != NULL ) {
	WaitForSingleObject ( hBufferMutex, INFINITE );
	if ( lpName != (LPSTR) NULL )
		mbstowcs ((WCHAR *)wsSNameBuffer, lpName, (BUFFERLEN/2));
	else
	    *(wsSNameBuffer) = L'\0';
	WaitForSingleObject ( hSMutex[MUTEX], INFINITE );
	phHandleData = AddSyncHandle ( RetVal, wsSNameBuffer, 0L, MUTEX );
	ReleaseMutex ( hBufferMutex );
	OpensAccounting ( phHandleData->psHandleData, ulElapsedTime );
	ReleaseMutex ( hSMutex[MUTEX] );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



HANDLE  FOpenMutexW (DWORD dwDesiredAccess,BOOL bInheritHandle,LPWSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PSP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);

    //
    // Call the api
    //
    RetVal = OpenMutexW(dwDesiredAccess,bInheritHandle,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);

    if ( RetVal != NULL ) {
	WaitForSingleObject ( hSMutex[MUTEX], INFINITE );
	phHandleData = AddSyncHandle ( RetVal, (LPTSTR)lpName, 0L, MUTEX );
	OpensAccounting ( phHandleData->psHandleData, ulElapsedTime );
	ReleaseMutex ( hSMutex[MUTEX] );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



HANDLE  FOpenSemaphoreA (DWORD dwDesiredAccess,BOOL bInheritHandle,LPSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PSP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);

    //
    // Call the api
    //
    RetVal = OpenSemaphoreA(dwDesiredAccess,bInheritHandle,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);

    if ( RetVal != NULL ) {
	WaitForSingleObject ( hBufferMutex, INFINITE );
	if ( lpName != (LPSTR) NULL )
		mbstowcs ((WCHAR *)wsSNameBuffer, lpName, (BUFFERLEN/2));
	else
	    *(wsSNameBuffer) = L'\0';
	WaitForSingleObject ( hSMutex[SEMAPHORE], INFINITE );
	phHandleData = AddSyncHandle ( RetVal, wsSNameBuffer, -1L, SEMAPHORE );
	ReleaseMutex ( hBufferMutex );
	OpensAccounting ( phHandleData->psHandleData, ulElapsedTime );
	ReleaseMutex ( hSMutex[SEMAPHORE] );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



HANDLE  FOpenSemaphoreW (DWORD dwDesiredAccess,BOOL bInheritHandle,LPWSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PSP_Handle phHandleData;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);

    //
    // Call the api
    //
    RetVal = OpenSemaphoreW(dwDesiredAccess,bInheritHandle,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);

    if ( RetVal != NULL ) {
	WaitForSingleObject ( hSMutex[SEMAPHORE], INFINITE );
	phHandleData = AddSyncHandle ( RetVal, (LPTSTR)lpName, -1L, SEMAPHORE );
	OpensAccounting ( phHandleData->psHandleData, ulElapsedTime );
	ReleaseMutex ( hSMutex[SEMAPHORE] );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



BOOL  FPulseEvent (HANDLE hEvent)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PSP_Handle phHandleData;
    UCHAR Type = NOTYPE;

    if ( NtQueryObject ( hEvent, ObjectTypeInformation, &tiTypeInfo, BUFSIZE,
						     NULL ) == STATUS_SUCCESS )
      if ( lstrcmpi ( (LPCTSTR)TypeInfoBuffer, (LPCTSTR)EVENAME ) == 0 )
	Type = EVENT;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);

    //
    // Call the api
    //
    RetVal = PulseEvent(hEvent);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);

    if ( Type == EVENT ) {
	WaitForSingleObject ( hSMutex[EVENT], INFINITE );
	phHandleData = FindSyncHandle ( hEvent, EVENT );
	PulsesAccounting ( phHandleData->psHandleData, ulElapsedTime );
	ReleaseMutex ( hSMutex[EVENT] );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}


BOOL  FReleaseMutex (HANDLE hMutex)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PSP_Handle phHandleData;
    UCHAR Type = NOTYPE;

    if ( NtQueryObject ( hMutex, ObjectTypeInformation, &tiTypeInfo, BUFSIZE,
						      NULL ) == STATUS_SUCCESS )
      if ( lstrcmpi ( (LPCTSTR)TypeInfoBuffer, (LPCTSTR)MUTNAME ) == 0 )
	Type = MUTEX;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);

    //
    // Call the api
    //
    RetVal = ReleaseMutex(hMutex);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);

    if ( Type == MUTEX ) {
	WaitForSingleObject ( hSMutex[MUTEX], INFINITE );
	phHandleData = FindSyncHandle ( hMutex, MUTEX );
	SignalsAccounting ( phHandleData->psHandleData, ulElapsedTime );
	ReleaseMutex ( hSMutex[MUTEX] );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



BOOL  FReleaseSemaphore (HANDLE hSemaphore,LONG lReleaseCount,LPLONG lpPreviousCount)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PSP_Handle phHandleData;
    UCHAR Type = NOTYPE;

    if ( NtQueryObject (hSemaphore, ObjectTypeInformation, &tiTypeInfo, BUFSIZE,
						       NULL) == STATUS_SUCCESS )
      if ( lstrcmpi ( (LPCTSTR)TypeInfoBuffer, (LPCTSTR)SEMNAME ) == 0 )
	Type = SEMAPHORE;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);

    //
    // Call the api
    //
    RetVal = ReleaseSemaphore(hSemaphore,lReleaseCount,lpPreviousCount);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);

    if ( Type == SEMAPHORE ) {
	WaitForSingleObject ( hSMutex[SEMAPHORE], INFINITE );
	phHandleData = FindSyncHandle ( hSemaphore, SEMAPHORE );
	SignalsAccounting ( phHandleData->psHandleData, ulElapsedTime );
	ReleaseMutex ( hSMutex[SEMAPHORE] );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}


BOOL  FResetEvent (HANDLE hEvent)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PSP_Handle phHandleData;
    UCHAR Type = NOTYPE;

    if ( NtQueryObject ( hEvent, ObjectTypeInformation, &tiTypeInfo, BUFSIZE,
					             NULL ) == STATUS_SUCCESS )
      if ( lstrcmpi ( (LPCTSTR)TypeInfoBuffer, (LPCTSTR)EVENAME ) == 0 )
	Type = EVENT;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);

    //
    // Call the api
    //
    RetVal = ResetEvent(hEvent);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);

    if ( Type == EVENT ) {
	WaitForSingleObject ( hSMutex[EVENT], INFINITE );
	phHandleData = FindSyncHandle ( hEvent, EVENT );
	ResetsAccounting ( phHandleData->psHandleData, ulElapsedTime );
	ReleaseMutex ( hSMutex[EVENT] );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}


BOOL  FSetEvent (HANDLE hEvent)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PSP_Handle phHandleData;
    UCHAR Type = NOTYPE;

    if ( NtQueryObject ( hEvent, ObjectTypeInformation, &tiTypeInfo, BUFSIZE,
						     NULL ) == STATUS_SUCCESS )
      if ( lstrcmpi ( (LPCTSTR)TypeInfoBuffer, (LPCTSTR)EVENAME ) == 0 )
	Type = EVENT;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);

    //
    // Call the api
    //
    RetVal = SetEvent(hEvent);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);

    if ( Type == EVENT ) {
	WaitForSingleObject ( hSMutex[EVENT], INFINITE );
	phHandleData = FindSyncHandle ( hEvent, EVENT );
	SignalsAccounting ( phHandleData->psHandleData, ulElapsedTime );
	ReleaseMutex ( hSMutex[EVENT] );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}


DWORD  FWaitForMultipleObjects (DWORD nCount,LPHANDLE lpHandles,BOOL bWaitAll,DWORD dwMilliseconds)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PSP_Handle phHandleData;
    DWORD i = 0;
    UCHAR Type;
    BOOL bSuccess, bAny, bSucc;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);

    //
    // Call the api
    //
    RetVal = WaitForMultipleObjects(nCount,lpHandles,bWaitAll,dwMilliseconds);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);

    bAny = (bWaitAll) ? FALSE : TRUE;
    bSucc = (RetVal != 0xFFFFFFFF) && (RetVal != WAIT_TIMEOUT) ;
    for ( ; i < nCount; i++ ) {
      Type = NOTYPE;
      if ( NtQueryObject ( *(lpHandles + i), ObjectTypeInformation,
			&tiTypeInfo, BUFSIZE, NULL ) == STATUS_SUCCESS ) {
    	if ( lstrcmpi ( (LPCTSTR)TypeInfoBuffer, (LPCTSTR)EVENAME ) == 0 )
	    Type = EVENT;
    	else if ( lstrcmpi ( (LPCTSTR)TypeInfoBuffer, (LPCTSTR)SEMNAME ) == 0 )
	    Type = SEMAPHORE;
    	else if ( lstrcmpi ( (LPCTSTR)TypeInfoBuffer, (LPCTSTR)MUTNAME ) == 0 )
	    Type = MUTEX;
      }
      if ( Type != NOTYPE ) {
	if ( bWaitAll )
	    bSuccess = bSucc;
	else
	    bSuccess = bSucc && ((RetVal == i) ||
			   		     ((RetVal-WAIT_ABANDONED_0) == i));
	WaitForSingleObject ( hSMutex[Type], INFINITE );
	phHandleData = FindSyncHandle ( *(lpHandles + i), Type );
	WaitsAccounting ( phHandleData->psHandleData, ulElapsedTime,
							 bSuccess, TRUE, bAny );
	ReleaseMutex ( hSMutex[Type] );
      }
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



DWORD  FWaitForMultipleObjectsEx (DWORD nCount,LPHANDLE lpHandles,BOOL bWaitAll,DWORD dwMilliseconds,BOOL bAlertable)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PSP_Handle phHandleData;
    DWORD i = 0;
    UCHAR Type;
    BOOL bSuccess, bAny, bSucc;

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);

    //
    // Call the api
    //
    RetVal = WaitForMultipleObjectsEx(nCount,lpHandles,bWaitAll,dwMilliseconds,bAlertable);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);

    bAny = ((bWaitAll) ? FALSE : TRUE);
    bSucc = (RetVal != 0xFFFFFFFF) && (RetVal != WAIT_TIMEOUT) &&
						 (RetVal != WAIT_IO_COMPLETION);
    for ( ; i < nCount; i++ ) {
	Type = NOTYPE;
    	if ( NtQueryObject ( *(lpHandles + i), ObjectTypeInformation,
			     &tiTypeInfo, BUFSIZE, NULL ) == STATUS_SUCCESS ) {
    	  if ( lstrcmpi ((LPCTSTR)TypeInfoBuffer, (LPCTSTR)EVENAME) == 0 )
	    Type = EVENT;
    	  else if ( lstrcmpi ((LPCTSTR)TypeInfoBuffer, (LPCTSTR)SEMNAME) == 0 )
	    Type = SEMAPHORE;
    	  else if ( lstrcmpi ((LPCTSTR)TypeInfoBuffer, (LPCTSTR)MUTNAME) == 0 )
	    Type = MUTEX;
	}
	if ( Type != NOTYPE ) {
	    if ( bWaitAll )
	    	bSuccess = bSucc;
	    else
		bSuccess = bSucc && ((RetVal == i) ||
					      ((RetVal-WAIT_ABANDONED_0) == i));
	    WaitForSingleObject ( hSMutex[Type], INFINITE );
	    phHandleData = FindSyncHandle ( *(lpHandles + i), Type );
	    WaitsAccounting ( phHandleData->psHandleData, ulElapsedTime,
							 bSuccess, TRUE, bAny );
	    ReleaseMutex ( hSMutex[Type] );
	}
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



DWORD  FWaitForSingleObject (HANDLE hHandle,DWORD dwMilliseconds)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PSP_Handle phHandleData;
    UCHAR Type = NOTYPE;
    BOOL bSuccess;

    if ( NtQueryObject (hHandle, ObjectTypeInformation, &tiTypeInfo, BUFSIZE,
						    NULL) == STATUS_SUCCESS ) {
      if ( lstrcmpi ( (LPCTSTR)TypeInfoBuffer, (LPCTSTR)EVENAME ) == 0 )
	Type = EVENT;
      else if ( lstrcmpi ( (LPCTSTR)TypeInfoBuffer, (LPCTSTR)SEMNAME ) == 0 )
	Type = SEMAPHORE;
      else if ( lstrcmpi ( (LPCTSTR)TypeInfoBuffer, (LPCTSTR)MUTNAME ) == 0 )
	Type = MUTEX;
    }

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);

    //
    // Call the api
    //
    RetVal = WaitForSingleObject(hHandle,dwMilliseconds);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);

    if ( Type != NOTYPE ) {
    	bSuccess = (RetVal != 0xFFFFFFFF) && (RetVal != WAIT_TIMEOUT);
	WaitForSingleObject ( hSMutex[Type], INFINITE );
	phHandleData = FindSyncHandle ( hHandle, Type );
	WaitsAccounting ( phHandleData->psHandleData, ulElapsedTime, bSuccess,
								 FALSE, FALSE );
	ReleaseMutex ( hSMutex[Type] );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}



DWORD  FWaitForSingleObjectEx (HANDLE hHandle,DWORD dwMilliseconds,BOOL bAlertable)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;
    PSP_Handle phHandleData;
    UCHAR Type = NOTYPE;
    BOOL bSuccess;

    if ( NtQueryObject (hHandle, ObjectTypeInformation, &tiTypeInfo, BUFSIZE,
						    NULL) == STATUS_SUCCESS ) {
      if ( lstrcmpi ( (LPCTSTR)TypeInfoBuffer, (LPCTSTR)EVENAME ) == 0 )
	Type = EVENT;
      else if ( lstrcmpi ( (LPCTSTR)TypeInfoBuffer, (LPCTSTR)SEMNAME ) == 0 )
	Type = SEMAPHORE;
      else if ( lstrcmpi ( (LPCTSTR)TypeInfoBuffer, (LPCTSTR)MUTNAME ) == 0 )
	Type = MUTEX;
    }

    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);

    //
    // Call the api
    //
    RetVal = WaitForSingleObjectEx(hHandle,dwMilliseconds,bAlertable);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);

    if ( Type != NOTYPE ) {
    	bSuccess = (RetVal == 0) || (RetVal == WAIT_ABANDONED);
	WaitForSingleObject ( hSMutex[Type], INFINITE );
	phHandleData = FindSyncHandle ( hHandle, Type );
	WaitsAccounting ( phHandleData->psHandleData, ulElapsedTime, bSuccess,
								 FALSE, FALSE );
	ReleaseMutex ( hSMutex[Type] );
    }

    TimerClose(sTimerHandle);

    return(RetVal);
}


