/************************************************************************/
/*									*/
/* RCPP - Resource Compiler Pre-Processor for NT system			*/
/*									*/
/* GETMSG.H - Include File for the message return function		*/
/*									*/
/* 28-Nov-90 w-BrianM	Created to replace need for MKMSG.EXE		*/
/*									*/
/************************************************************************/

/************************************************************************/
/****								     ****/
/**** NOTE - All changes in this file MUST be duplicated in MSGS.H!  ****/
/****								     ****/
/************************************************************************/

#include "msgs.h"

#define LASTMSG	-1

struct msgtable {
	int	usmsgnum;
	char * pmsg;
} MSG_TABLE[] = {

	/****************************************************************/
	/* Messages							*/
	/****************************************************************/

	{MSG_LEFT,	     "left"},
	{MSG_RIGHT,	     "right"},
	{MSG_UC_UNNAMED,     "UNNAMED"},
	{MSG_LC_UNNAMED,     "<unnamed>"},
	{MSG_COMMA,	     "trailing ',' used for variable argument list"},
	{MSG_CAST_LVAL,      "cast on lvalue"},
	{MSG_EXT_INIT,	     "extended initializer form"},
	{MSG_TYPEDEF,	     "benign typedef redefinition"},
	{MSG_EXT_REDEF,	     "redefined extern to static"},
	{MSG_MAC_FORMALS,    "macro formals in strings"},
	{MSG_NO_SEMI,	     "missing ';' following last struct/union member"},
	{MSG_BITFIELDS,	     "bitfield types other than int"},
	{MSG_WARN,	     "warning"},
	{MSG_ERROR,	     "error"},
	{MSG_FATAL,          "fatal error"},
	{MSG_BLOCK_FUNCDECL, "function given file scope"},
	{MSG_CASTTO_FUNC,    "cast of data pointer to function pointer"},
	{MSG_CASTTO_NONFUNC, "cast of function pointer to data pointer"},
	{MSG_ELLIPSIS,	     "function declaration used ellipsis"},
	{MSG_TOLEVEL0,	     "used function declaration from a previous block"},

	/****************************************************************/
	/* Fatals							*/
	/****************************************************************/

	{1001,	"Internal Compiler Error\n\t\t(compiler file '%s', line %d)\n\t\tPlease report this error to your local dealer"},
	{1002,	"out of heap space"},
	{1003,	"error count exceeds %d; stopping compilation"},
	{1004,	"unexpected EOF"},
	{1005,	"string too big for buffer"},
	{1006,	"write error on compiler intermediate file"},
	{1007,	"unrecognized flag '%s' in '%s'"},
	{1008,	"no input file specified"},
	{1009,	"compiler limit : macros too deeply nested"},
	{1010,	"compiler limit : macro expansion too big"},
	{1011,  "no output file specified"},
	{1012,	"bad parenthesis nesting - missing '%c'"},
	{1013,	"cannot open source file '%s'"},
	{1014,	"too many include files"},
	{1015,	"cannot open include file '%s'"},
	{1016,	"#if[n]def expected an identifier"},
	{1017,	"invalid integer constant expression"},
	{1018,	"unexpected '#elif'"},
	{1019,	"unexpected '#else'"},
	{1020,	"unexpected '#endif'"},
	{1021,	"bad preprocessor command '%s'"},
	{1022,	"expected '#endif'"},
	{1023,	"Could not open output file"},
	{1026,	"parser stack overflow, please simplify your program"},
	{1027,	"DGROUP data allocation exceeds 64K"	/* QC, c23 */},
	{1028,	"%s segment allocation exceeds 64K"	/* QC */},
	{1031,	"compiler limit : function calls too deeply nested"	/* QC, c23 */},
	{1032,	"cannot open object listing file '%s'"			/* QC, c23 */},
	{1035,	"expression too complex, please simplify"		/* QC, c23 */},
	{1037,	"cannot open object file '%s'"					/* QC, c23 */},
	{1041,	"cannot open compiler intermediate file - no more files"},
	{1042,	"cannot open compiler intermediate file - no such file or directory"},
	{1043,	"cannot open compiler intermediate file"},
	{1044,	"out of disk space for compiler intermediate file"},
	{1045,	"floating point overflow"},
	{1047,	"too many %s flags, '%s'"},
	{1048,	"unknown option '%c' in '%s'"},
	{1049,	"invalid numerical argument '%s'"},
	{1052,	"too many #if/#ifdef's"},
	{1053,	"compiler limit : struct/union nesting"},
	{1054,	"compiler limit : initializers too deeply nested"},
	{1055,	"compiler limit : out of keys"},
	{1056,	"compiler limit : out of macro expansion space"},
	{1057,	"unexpected EOF in macro expansion (missing ')'?)"},
	{1059,	"out of near heap space"},
	{1060,	"out of far heap space"},
	{1061,	"compiler limit : blocks too deeply nested"	/* QC */},
	{1062,	"error writing to preprocessor output file"},
	{1063,	"compiler limit : compiler stack overflow"	/* QC */},
	{1065,	"compiler limit : '%s': macro definition too big"},
	{1067,	"compiler limit : identifier overflowed internal buffer"},
	{1068,	"compiler error : possible binary file for input"},
	{1000,	"UNKNOWN FATAL ERROR\n\t\tPlease report this error to your local dealer"},

	/****************************************************************/
	/* Errors							*/
	/****************************************************************/

	{2001,	"newline in constant"},
	{2003,	"expected 'defined id'"},
	{2004,	"expected 'defined(id)'"},
	{2005,	"#line expected a line number, found '%s'"},
	{2006,	"#include expected a file name, found '%s'"},
	{2007,	"#define syntax"},
	{2008,	"'%c' : unexpected in macro definition"},
	{2009,	"reuse of macro formal '%s'"},
	{2010,	"'%c' : unexpected in formal list"},
	{2012,	"missing name following '<'"},
	{2013,	"missing '>'"},
	{2014,	"preprocessor command must start as first non-whitespace"},
	{2015,	"too many chars in constant"},
	{2016,	"no closing single quote"},
	{2017,	"illegal escape sequence"},
	{2018,	"unknown character '0x%x'"},
	{2019,	"expected preprocessor command, found '%c'"},
	{2020,	"illegal digit '%c' for base %d"},
	{2021,	"expected exponent value, not '%c'"},
	{2022,	"'%ld' : too big for char"},
	{2023,	"divide by 0"},
	{2024,	"mod by 0"},
	{2025,	"'%s' : enum/struct/union type redefinition"},
	{2026,	"'%s' : member of enum redefinition"},
	{2028,	"struct/union member needs to be inside a struct/union"},
	{2029,	"'%Fs' : bit-fields only allowed in structs"},
	{2030,	"'%Fs' : struct/union member redefinition"},
	{2031,	"'%Fs' : function cannot be struct/union member"},
	{2033,	"'%Fs' : bit-field cannot have indirection"},
	{2034,	"'%Fs' : bit-field type too small for number of bits"},
	{2035,	"struct/union '%Fs' : unknown size"},
	{2036,	"left of '%s%s' must have a struct/union type"},
	{2037,	"left of '%s' specifies undefined struct/union '%Fs'"},
	{2038,	"'%s' : not struct/union member"},
	{2039,	"'->' requires struct/union pointer"},
	{2040,	"'.' requires struct/union name"},
	{2042,	"signed/unsigned keywords mutually exclusive"},
	{2043,	"illegal break"},
	{2044,	"illegal continue"},
	{2045,	"'%s' : label redefined"},
	{2046,	"illegal case"},
	{2047,	"illegal default"},
	{2048,	"more than one default"},
	{2050,	"non-integral switch expression"},
	{2051,	"case expression not constant"},
	{2052,	"case expression not integral"},
	{2053,	"case value %d already used"},
	{2054,	"expected '(' to follow '%Fs'"},
	{2055,	"expected formal parameter list, not a type list"},
	{2056,	"illegal expression"},
	{2057,	"expected constant expression"},
	{2058,	"constant expression is not integral"},
	{2059,	"syntax error : '%s'"},
	{2060,	"syntax error : EOF"},
	{2061,	"syntax error : identifier '%s'"},
	{2062,	"type '%s' unexpected"},
	{2063,	"'%s' : not a function"},
	{2064,	"term does not evaluate to a function"},
	{2065,	"'%s' : undefined"},
	{2066,	"cast to function returning . . . is illegal"},
	{2067,	"cast to array type is illegal"},
	{2068,	"illegal cast"},
	{2069,	"cast of 'void' term to non-void"},
	{2070,	"'%Fs' : storage class must be 'extern'"},
	{2071,	"'%Fs' : bad storage class"},
	{2072,	"'%Fs' : initialization of a function"},
	{2075,	"'%Fs' : array initialization needs curly braces"},
	{2076,	"'%Fs' : struct/union initialization needs curly braces"},
	{2077,	"non-scalar field initializer '%Fs'"},
	{2078,	"too many initializers"},
	{2079,	"'%Fs' uses undefined struct/union '%Fs'"},
	{2082,	"redefinition of formal parameter '%Fs'"},
	{2084,	"function '%Fs' already has a body"},
	{2085,	"'%Fs' : not in formal parameter list"},
	{2086,	"'%Fs' : redefinition"},
	{2087,	"'%Fs' : missing subscript"},
	{2088,	"use of undefined enum/struct/union '%Fs'"},
	{2090,	"function returns array"},
	{2091,	"function returns function"},
	{2092,	"array element type cannot be function"},
	{2093,	"cannot initialize a static or struct with address of automatic vars"},
	{2094,	"label '%Fs' was undefined"},
	{2095,	"'%Fs' : actual has type 'void' : parameter %d"},
	{2096,	"struct/union comparison illegal"},
	{2097,	"illegal initialization"},
	{2098,	"non-address expression"},
	{2099,	"non-constant offset"},
	{2100,	"illegal indirection"},
	{2101,	"'&' on constant"},
	{2102,	"'&' requires lvalue"},
	{2103,	"'&' on register variable"},
	{2104,	"'&' on bit-field ignored"},
	{2105,	"'%s' needs lvalue"},
	{2106,	"'%s' : left operand must be lvalue"},
	{2107,	"illegal index, indirection not allowed"},
	{2108,	"non-integral index"},
	{2109,	"subscript on non-array"},
	{2110,	"'+' : 2 pointers"},
	{2111,	"pointer + non-integral value"},
	{2112,	"illegal pointer subtraction"},
	{2113,	"'-' : right operand pointer"},
	{2114,	"'%s' : pointer on left; needs integral right"},
	{2115,	"'%s' : incompatible types"},
	{2116,	"'%s' : bad %s operand"},
	{2117,	"'%s' : illegal for struct/union"},
	{2118,	"negative subscript"},
	{2119,	"'typedefs' both define indirection"},
	{2120,	"'void' illegal with all types"},
	{2125,	"%Fs : allocation exceeds 64K"		/* QC, c23 */},
	{2126,	"%Fs : auto allocation exceeds %s"	/* QC, c23 */},
	{2127,	"parameter allocation exceeds 32K"	/* QC, c23 */},
	{2130,	"#line expected a string containing the file name, found '%s'"},
	{2131,	"attributes specify more than one near/far/huge"},
	{2132,	"syntax error : unexpected identifier"},
	{2133,	"'%Fs' : unknown size"},
	{2134,	"'%Fs' : struct/union too large"},
	{2137,	"empty character constant"},
	{2138,	"unmatched close comment '*/'"},
	{2139,	"type following '%s' is illegal"},
	{2140,	"argument type cannot be function returning . . ."},
	{2141,	"value out of range for enum constant"},
	{2142,	"ellipsis requires three periods"},
	{2143,	"syntax error : missing '%s' before '%s'"},
	{2144,	"syntax error : missing '%s' before type '%Fs'"},
	{2145,	"syntax error : missing '%s' before identifier"},
	{2146,	"syntax error : missing '%s' before identifier '%s'"},
	{2147,	"unknown size"},
	{2148,	"array too large"},
	{2149,	"'%Fs' : named bit-field cannot have 0 width"},
	{2150,	"'%Fs' : bit-field must have type int, signed int, or unsigned int"},
	{2151,	"more than one cdecl/fortran/pascal attribute specified"},
	{2152,	"'%s' : pointers to functions with different attributes"},
	{2153,	"hex constants must have at least 1 hex digit"},
	{2154,	"'%s' : does not refer to a segment name"},
	{2155,	"'%s' : already in a segment"},
	{2156,	"pragma must be at outer level"},
	{2157,	"'%s' : must be declared before use in pragma list"},
	{2158,	"'%s' : is a function"},
	{2159,	"more than one storage class specified"},
	{2160,	"## cannot occur at the beginning of a macro definition"},
	{2161,	"## cannot occur at the end of a macro definition"},
	{2162,	"expected macro formal parameter"},
	{2163,	"'%s' : not available as an intrinsic"},
	{2164,	"'%s' : intrinsic was not declared"},
	{2165,	"'%s' : cannot modify pointers to data"},
	{2166,	"lval specifies 'const' object"},
	{2167,	"'%Fs' : too many actual parameters for intrinsic"},
	{2168,	"'%Fs' : too few actual parameters for intrinsic"},
	{2169,	"'%Fs' : is an intrinsic, it cannot be defined"},
	{2170,	"'%s' : intrinsic not declared as a function"},
	{2171,	"'%s' : bad operand"},
	{2172,	"'%Fs' : actual is not a pointer : parameter %d"},
	{2173,	"'%Fs' : actual is not a pointer : parameter %d, parameter list %d"},
	{2174,	"'%Fs' : actual has type 'void' : parameter %d, parameter list %d"},
	{2175,	"'%Fs' : unresolved external"	/* QC */},
	{2176,	"static far data not supported"	/* QC */},
	{2177,	"constant too big"},
	{2178,	"'%s' : storage class for same_seg variables must be 'extern'"},
	{2179,	"'%Fs' : was used in same_seg, but storage class is no longer 'extern'"},
	{2180,	"controlling expression has type 'void'"},
	{2181,	"pragma requires command line option '%s'"	/* QC */},
	{2182,	"'%Fs' : has type 'void'"},
	{2183,	"'interrupt' function must be 'far'"},
	{2184,	"'%s' function cannot be 'pascal/fortran'"},
	{2186,	"'saveregs/interrupt' modifiers mutually exclusive"},
	{2187,	"cast of near function pointer to far function pointer"},
	{2188,	"#error : %s"},
	{2190,	"'%s' : is a text segment"},
	{2191,	"'%s' : is a data segment"},
	{2198,	"'%Fs' : tried to be allocated in code segment '%Fs'"},
	{2199,	"'%Fs' : tried to be allocated in data segment '%Fs'"},
	{2200,	"'%Fs' : function has already been defined"},
	{2205,	"'%Fs' : cannot initialize 'extern' block scoped variables"},
	{2400,	"inline syntax error %s, found '%Fs'"},
	{2401,	"'%s' : register must be base %s"},
	{2402,	"'%s' : register must be index %s"},
	{2403,	"'%s' : register must be base/index %s"},
	{2404,	"'%s' : illegal register %s"},
	{2405,	"illegal short forward reference with offset"},
	{2406,	"'%s' : name undefined %s"},
	{2407,	"illegal float register %s"},
	{2408,	"illegal type on PTR operator %s"},
	{2409,	"illegal type used as operator %s"},
	{2410,	"'%s' : ambiguous member name %s"},
	{2411,	"'%s' : illegal struct/union member %s"},
	{2412,	"'%s' : label redefined"},
	{2413,	"'%s' : illegal align size"},
	{2414,	"illegal number of operands"},
	{2415,	"improper operand type"},
	{2416,	"'%s' : illegal opcode for processor"},
	{2417,	"divide by zero %s"},
	{2419,	"mod by zero %s"},
	{2420,	"'%s' : illegal symbol %s"},
	{2421,	"PTR operator used with register %s"},
	{2422,	"illegal segment override %s"},
	{2424,	"'%s' : improper expression %s"},
	{2425,	"'%s' : non-constant expression %s"},
	{2426,	"'%s' : illegal operator %s"},
	{2427,	"'%Fs' : jump referencing label is out of range"			/* QC */},
	{2428,	"_asm not implemented"},
	{2000,	"UNKNOWN ERROR\n\t\tPlease report this error to your local dealer"},
	/****************************************************************/
	/* Warnings							*/
	/****************************************************************/

	{4002,	"too many actual parameters for macro '%s'"},
	{4003,	"not enough actual parameters for macro '%s'"},
	{4004,	"missing close parenthesis after 'defined'"},
	{4005,	"'%s' : redefinition"},
	{4006,	"#undef expected an identifier"},
	{4009,	"string too big, trailing chars truncated"},
	{4011,	"identifier truncated to '%s'"},
	{4012,	"float constant in a cross compilation"},
	{4014,	"'%Fs' : bit-field type must be unsigned"},
	{4015,	"'%Fs' : bit-field type must be integral"},
	{4016,	"'%s' : no function return type, using 'int' as default"},
	{4017,	"cast of int expression to far pointer"},
	{4020,	"'%Fs' : too many actual parameters"},
	{4021,	"'%Fs' : too few actual parameters"},
	{4022,	"'%Fs' : pointer mismatch : parameter %d"},
	{4024,	"'%Fs' : different types : parameter %d"},
	{4026,	"function was declared with formal argument list"},
	{4027,	"function was declared without formal argument list"},
	{4028,	"parameter %d declaration different"},
	{4029,	"declared parameter list different from definition"},
	{4030,	"first parameter list is longer than the second"},
	{4031,	"second parameter list is longer than the first"},
	{4032,	"unnamed struct/union as parameter"},
	{4033,	"function must return a value"},
	{4034,	"sizeof returns 0"},
	{4035,	"'%Fs' : no return value"},
	{4037,	"'%Fs' : formal parameters ignored"},
	{4038,	"'%Fs' : formal parameter has bad storage class"},
	{4039,	"'%Fs' : function used as an argument"},
	{4040,	"near/far/huge on '%Fs' ignored"},
	{4042,	"'%Fs' : has bad storage class"},
	{4044,	"huge on '%Fs' ignored, must be an array"},
	{4045,	"'%s' : array bounds overflow"},
	{4046,	"'&' on function/array, ignored"},
	{4047,	"'%s' : different levels of indirection"},
	{4048,	"array's declared subscripts different"},
	{4049,	"'%s' : indirection to different types"},
	{4051,	"data conversion"},
	{4053,	"at least one void operand"},
	{4058,	"address of frame variable taken, DS != SS"	/* QC, c23 */},
	{4060,	"conversion of long address to short address"	/* QC, c23 */},
	{4061,	"long/short mismatch in argument : conversion supplied"	/* QC, c23 */},
	{4062,	"near/far mismatch in argument : conversion supplied"	/* QC, c23 */},
	{4067,	"unexpected characters following '%s' directive - newline expected"},
	{4068,	"unknown pragma"},
	{4071,	"'%Fs' : no function prototype given"},
	{4074,	"non standard extension used - '%s'"},
	{4075,	"size of switch expression or case constant too large - converted to int"},
	{4076,	"'%s' : may be used on integral types only"},
	{4077,	"unknown check_stack option"},
	{4079,	"unexpected token '%s'"},
	{4080,	"expected 'identifier' for segment name, found '%s'"},
	{4081,	"expected a comma, found '%s'"},
	{4082,	"expected an identifier, found '%s'"},
	{4083,	"expected '(', found '%s'"},
	{4084,	"expected a pragma keyword, found '%s'"},
	{4085,	"expected [on | off]"},
	{4086,	"expected [1 | 2 | 4]"},
	{4087,	"'%Fs' : declared with 'void' parameter list"},
	{4088,	"'%Fs' : pointer mismatch : parameter %d, parameter list %d"},
	{4089,	"'%Fs' : different types : parameter %d, parameter list %d"},
	{4090,	"different 'const' attributes"},
	{4091,	"no symbols were declared"},
	{4092,	"untagged enum/struct/union declared no symbols"},
	{4093,	"unescaped newline in character constant in non-active code"},
	{4095,	"expected ')', found '%s'"},
	{4098,	"void function returning a value"},
	{4100,	"'%Fs' : unreferenced formal parameter"},
	{4101,	"'%Fs' : unreferenced local variable"},
	{4102,	"'%Fs' : unreferenced label"},
	{4104,	"'%s' : near data in same_seg pragma, ignored"},
	{4105,	"'%Fs' : code modifiers only on function or pointer to function"},
	{4106,	"pragma requires integer between 1 and 127"},
	{4107,	"pragma requires integer between 15 and 255"},
	{4108,	"pragma requires integer between 79 and 132"},
	{4109,	"unexpected identifier '%s'"},
	{4110,	"unexpected token 'int constant'"},
	{4111,	"unexpected token 'string'"},
	{4112,	"macro name '%s' is reserved, %s ignored"},
	{4113,	"function parameter lists differed"},
	{4114,	"same type qualifier used more than once"},
	{4115,	"'%Fs' : type definition in formal parameter list"},
	{4116,	"<no tag> : type definition in formal parameter list"},
	{4118,	"pragma not supported"},
	{4401,	"'%s' : member is bitfield"},
	{4402,	"must use PTR operator"},
	{4403,	"illegal PTR operator"},
	{4404,	"period on directive ignored"},
	{4405,	"'%s' : identifier is reserved word"},
	{4406,	"operand on directive ignored"},
	{4407,	"operand size conflict"},
	{4408,	"'%s' : ambiguous label"},
	{4409,	"illegal instruction size"},
	{4410,	"illegal size for operand"},
	{4411,	"'%s' : symbol resolves to displacement register"},
	{4412,	"'%s' : identifier is also assembler mnemonic"},
	{4413,	"Cannot determine file type for '%s' : assuming 8-bit ascii"},
	{4000,	"UNKNOWN WARNING\n\t\tPlease report this error to your local dealer"},
	{LASTMSG, ""}
};
