/*++ BUILD Version: 0001    // Increment this if a change has global effects

Copyright (c) 1992  Microsoft Corporation

Module Name:

    p5data.c

Abstract:

    a file containing the constant data structures used by the Performance
    Monitor data for the P5 Extensible Objects.

    This file contains a set of constant data structures which are
    currently defined for the P5 Extensible Objects.  This is an
    example of how other such objects could be defined.

Created:

    Russ Blake  24 Dec 93

Revision History:

    None.

--*/
//
//  Include Files
//

#include <windows.h>
#include <winperf.h>
#include "p5ctrnam.h"
#include "p5data.h"

//
//  Constant structure initializations for the sturcture defined in p5data.h
//

P5_DATA_DEFINITION P5DataDefinition = {

   {
      sizeof(P5_DATA_DEFINITION) + SIZE_OF_P5_PERFORMANCE_DATA,
      sizeof(P5_DATA_DEFINITION),
      sizeof(PERF_OBJECT_TYPE),
      PENTIUM,
      0,
      PENTIUM,
      0,
      PERF_DETAIL_NOVICE,
      (sizeof(P5_DATA_DEFINITION)-sizeof(PERF_OBJECT_TYPE))/
         sizeof(PERF_COUNTER_DEFINITION),
      62,
      0,
      0
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      DATA_READ,
      0,
      DATA_READ,
      0,
      -4,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      DATA_READ_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      DATA_WRITE,
      0,
      DATA_WRITE,
      0,
      -4,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      DATA_WRITE_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      DATA_TLB_MISS,
      0,
      DATA_TLB_MISS,
      0,
      -2,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      DATA_TLB_MISS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      DATA_READ_MISS,
      0,
      DATA_READ_MISS,
      0,
      -3,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      DATA_READ_MISS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      DATA_WRITE_MISS,
      0,
      DATA_WRITE_MISS,
      0,
      -3,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      DATA_WRITE_MISS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      WRITE_HIT_TO_ME_LINE,
      0,
      WRITE_HIT_TO_ME_LINE,
      0,
      -4,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      WRITE_HIT_TO_ME_LINE_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      DATA_CACHE_LINE_WB,
      0,
      DATA_CACHE_LINE_WB,
      0,
      -2,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      DATA_CACHE_LINE_WB_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      DATA_CACHE_SNOOPS,
      0,
      DATA_CACHE_SNOOPS,
      0,
      -2,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      DATA_CACHE_SNOOPS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      DATA_CACHE_SNOOP_HITS,
      0,
      DATA_CACHE_SNOOP_HITS,
      0,
      -1,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      DATA_CACHE_SNOOP_HITS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      MEMORY_ACCESSES_IN_PIPES,
      0,
      MEMORY_ACCESSES_IN_PIPES,
      0,
      -3,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      MEMORY_ACCESSES_IN_PIPES_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      BANK_CONFLICTS,
      0,
      BANK_CONFLICTS,
      0,
      -3,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      BANK_CONFLICTS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      MISADLIGNED_DATA_REF,
      0,
      MISADLIGNED_DATA_REF,
      0,
      -2,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      MISADLIGNED_DATA_REF_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      CODE_READ,
      0,
      CODE_READ,
      0,
      -4,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      CODE_READ_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      CODE_TLB_MISS,
      0,
      CODE_TLB_MISS,
      0,
      -2,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      CODE_TLB_MISS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      CODE_CACHE_MISS,
      0,
      CODE_CACHE_MISS,
      0,
      -3,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      CODE_CACHE_MISS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      SEGMENT_LOADS,
      0,
      SEGMENT_LOADS,
      0,
      -2,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      SEGMENT_LOADS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      SEGMENT_CACHE_ACCESSES,
      0,
      SEGMENT_CACHE_ACCESSES,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      SEGMENT_CACHE_ACCESSES_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      SEGMENT_CACHE_HITS,
      0,
      SEGMENT_CACHE_HITS,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      SEGMENT_CACHE_HITS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      BRANCHES,
      0,
      BRANCHES,
      0,
      -4,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      BRANCHES_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      BTB_HITS,
      0,
      BTB_HITS,
      0,
      -3,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      BTB_HITS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      TAKEN_BRANCH_OR_BTB_HITS,
      0,
      TAKEN_BRANCH_OR_BTB_HITS,
      0,
      -4,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      TAKEN_BRANCH_OR_BTB_HITS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PIPELINE_FLUSHES,
      0,
      PIPELINE_FLUSHES,
      0,
      -3,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      PIPELINE_FLUSHES_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      INSTRUCTIONS_EXECUTED,
      0,
      INSTRUCTIONS_EXECUTED,
      0,
      -5,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      INSTRUCTIONS_EXECUTED_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      INSTRUCTIONS_EXECUTED_IN_VPIPE,
      0,
      INSTRUCTIONS_EXECUTED_IN_VPIPE,
      0,
      -4,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      INSTRUCTIONS_EXECUTED_IN_VPIPE_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      BUS_UTILIZATION,
      0,
      BUS_UTILIZATION,
      0,
      -5,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      BUS_UTILIZATION_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PIPE_STALLED_ON_WRITES,
      0,
      PIPE_STALLED_ON_WRITES,
      0,
      -4,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      PIPE_STALLED_ON_WRITES_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PIPE_STALLED_ON_READ,
      0,
      PIPE_STALLED_ON_READ,
      0,
      -4,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      PIPE_STALLED_ON_READ_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      STALLED_WHILE_EWBE,
      0,
      STALLED_WHILE_EWBE,
      0,
      -3,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      STALLED_WHILE_EWBE_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      LOCKED_BUS_CYCLE,
      0,
      LOCKED_BUS_CYCLE,
      0,
      -1,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      LOCKED_BUS_CYCLE_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      IO_RW_CYCLE,
      0,
      IO_RW_CYCLE,
      0,
      -3,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      IO_RW_CYCLE_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      NON_CACHED_MEMORY_REF,
      0,
      NON_CACHED_MEMORY_REF,
      0,
      -4,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      NON_CACHED_MEMORY_REF_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PIPE_STALLED_ON_ADDR_GEN,
      0,
      PIPE_STALLED_ON_ADDR_GEN,
      0,
      -3,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      PIPE_STALLED_ON_ADDR_GEN_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      DUMMY_CTR1,
      0,
      DUMMY_CTR1,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_NODATA,
      sizeof(LARGE_INTEGER),
      UNUSED1_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      DUMMY_CTR2,
      0,
      DUMMY_CTR2,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_NODATA,
      sizeof(LARGE_INTEGER),
      UNUSED2_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      FLOPS,
      0,
      FLOPS,
      0,
      -3,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      FLOPS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      DR0,
      0,
      DR0,
      0,
      -2,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      DR0_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      DR1,
      0,
      DR1,
      0,
      -2,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      DR1_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      DR2,
      0,
      DR2,
      0,
      -2,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      DR2_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      DR3,
      0,
      DR3,
      0,
      -2,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      DR3_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      INTERRUPTS,
      0,
      INTERRUPTS,
      0,
      -1,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      INTERRUPTS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      DATA_RW,
      0,
      DATA_RW,
      0,
      -4,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      DATA_RW_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      DATA_RW_MISS,
      0,
      DATA_RW_MISS,
      0,
      -3,
      PERF_DETAIL_NOVICE,
      PERF_COUNTER_BULK_COUNT,
      sizeof(LARGE_INTEGER),
      DATA_RW_MISS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PCT_DATA_READ_MISS,
      0,
      PCT_DATA_READ_MISS,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_SAMPLE_FRACTION,
      sizeof(DWORD),
      PCT_DATA_READ_MISS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PCT_DATA_READ_MISS,
      0,
      PCT_DATA_READ_MISS,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_SAMPLE_BASE,
      sizeof(DWORD),
      PCT_DATA_READ_BASE_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PCT_DATA_WRITE_MISS,
      0,
      PCT_DATA_WRITE_MISS,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_SAMPLE_FRACTION,
      sizeof(DWORD),
      PCT_DATA_WRITE_MISS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PCT_DATA_WRITE_MISS,
      0,
      PCT_DATA_WRITE_MISS,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_SAMPLE_BASE,
      sizeof(DWORD),
      PCT_DATA_WRITE_BASE_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PCT_DATA_RW_MISS,
      0,
      PCT_DATA_RW_MISS,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_SAMPLE_FRACTION,
      sizeof(DWORD),
      PCT_DATA_RW_MISS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PCT_DATA_RW_MISS,
      0,
      PCT_DATA_RW_MISS,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_SAMPLE_BASE,
      sizeof(DWORD),
      PCT_DATA_RW_BASE_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PCT_DATA_TLB_MISS,
      0,
      PCT_DATA_TLB_MISS,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_SAMPLE_FRACTION,
      sizeof(DWORD),
      PCT_DATA_TLB_MISS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PCT_DATA_TLB_MISS,
      0,
      PCT_DATA_TLB_MISS,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_SAMPLE_BASE,
      sizeof(DWORD),
      PCT_DATA_TLB_BASE_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PCT_DATA_SNOOP_HITS,
      0,
      PCT_DATA_SNOOP_HITS,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_SAMPLE_FRACTION,
      sizeof(DWORD),
      PCT_DATA_SNOOP_HITS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PCT_DATA_SNOOP_HITS,
      0,
      PCT_DATA_SNOOP_HITS,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_SAMPLE_BASE,
      sizeof(DWORD),
      PCT_DATA_SNOOP_BASE_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PCT_CODE_READ_MISS,
      0,
      PCT_CODE_READ_MISS,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_SAMPLE_FRACTION,
      sizeof(DWORD),
      PCT_CODE_READ_MISS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PCT_CODE_READ_MISS,
      0,
      PCT_CODE_READ_MISS,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_SAMPLE_BASE,
      sizeof(DWORD),
      PCT_CODE_READ_BASE_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PCT_CODE_TLB_MISS,
      0,
      PCT_CODE_TLB_MISS,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_SAMPLE_FRACTION,
      sizeof(DWORD),
      PCT_CODE_TLB_MISS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PCT_CODE_TLB_MISS,
      0,
      PCT_CODE_TLB_MISS,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_SAMPLE_BASE,
      sizeof(DWORD),
      PCT_CODE_TLB_BASE_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PCT_SEGMENT_CACHE_HITS,
      0,
      PCT_SEGMENT_CACHE_HITS,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_SAMPLE_FRACTION,
      sizeof(DWORD),
      PCT_SEGMENT_CACHE_HITS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PCT_SEGMENT_CACHE_HITS,
      0,
      PCT_SEGMENT_CACHE_HITS,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_SAMPLE_BASE,
      sizeof(DWORD),
      PCT_SEGMENT_CACHE_BASE_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PCT_BTB_HITS,
      0,
      PCT_BTB_HITS,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_SAMPLE_FRACTION,
      sizeof(DWORD),
      PCT_BTB_HITS_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PCT_BTB_HITS,
      0,
      PCT_BTB_HITS,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_SAMPLE_BASE,
      sizeof(DWORD),
      PCT_BTB_BASE_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PCT_VPIPE_INST,
      0,
      PCT_VPIPE_INST,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_SAMPLE_FRACTION,
      sizeof(DWORD),
      PCT_VPIPE_INST_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PCT_VPIPE_INST,
      0,
      PCT_VPIPE_INST,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_SAMPLE_BASE,
      sizeof(DWORD),
      PCT_VPIPE_BASE_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PCT_BRANCHES,
      0,
      PCT_BRANCHES,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_SAMPLE_FRACTION,
      sizeof(DWORD),
      PCT_BRANCHES_OFFSET
   },
   {
      sizeof(PERF_COUNTER_DEFINITION),
      PCT_BRANCHES,
      0,
      PCT_BRANCHES,
      0,
      0,
      PERF_DETAIL_NOVICE,
      PERF_SAMPLE_BASE,
      sizeof(DWORD),
      PCT_BRANCHES_BASE_OFFSET
   }
};
