/*
** thand.c
**
** Copyright(C) 1993,1994 Microsoft Corporation.
** All Rights Reserved.
**
** HISTORY:
**      Created: 01/27/94 - MarkRi
**
*/

#include <windows.h>
#include <stdarg.h>
#include <string.h>
#include "hooks.h"
#include "logger.h"

/*
** Some C functions which are not generated by the trace30.tt template
*/

LRESULT MesgProc(
    WNDPROC fp,
    HWND    hWnd,
    UINT    wMsg,
    WPARAM  wParam,
    LPARAM  lParam
) {
    LONG    l;

    LogIn( (LPSTR)"MSGCALL:FARPROC+HWND+MSGNUM+WORD+LONG+",
        fp, hWnd, wMsg, wParam, lParam );

    l = (* fp)( hWnd, wMsg, wParam, lParam );

    LogOut( (LPSTR)"MSGRET:LONG+FARPROC+MSGNUM+WORD+LONG+",
        l, fp, hWnd, wMsg, wParam, lParam );

    return( l );
}

BOOL DlgMesgProc(
    DLGPROC fp,
    HWND    hWnd,
    WORD    wMsg,
    WORD    wParam,
    LONG    lParam
) {
    BOOL    b;

    LogIn( (LPSTR)"MSGCALL:FARPROC+HWND+MSGNUM+WORD+LONG+",
        fp, hWnd, wMsg, wParam, lParam );

    b = (* fp)( hWnd, wMsg, wParam, lParam );

    LogOut( (LPSTR)"MSGRET:BOOL+FARPROC+MSGNUM+WORD+LONG+",
        b, fp, hWnd, wMsg, wParam, lParam );

    return( b );
}


ATOM zRegisterClassA( LPWNDCLASSA pp1 )
{
    BOOL r;
    WNDCLASSA wc;

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:RegisterClassA LPWNDCLASSA+",
        pp1 );
    wc = *pp1;

    wc.lpfnWndProc = (WNDPROC)HookAdd( (FARPROC)MesgProc, (FARPROC)pp1->lpfnWndProc );
    /*
    ** Call the API!
    */
    r = RegisterClass( (LPWNDCLASSA)&wc );
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:RegisterClassA ATOM++",
        r, (short)0 );

    return( r );
}


ATOM zRegisterClassW( LPWNDCLASSW pp1 )
{
    BOOL r;
    WNDCLASSW wc;

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:RegisterClassW LPWNDCLASSW+",
        pp1 );
    wc = *pp1;

    wc.lpfnWndProc = (WNDPROC)HookAdd( (FARPROC)MesgProc, (FARPROC)pp1->lpfnWndProc );
    /*
    ** Call the API!
    */
    r = RegisterClassW( (LPWNDCLASSW)&wc );
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:RegisterClassW ATOM++",
        r, (short)0 );

    return( r );
}


HWND zCreateDialog( HANDLE pp1, LPSTR pp2, HWND pp3, DLGPROC pp4 )
{
    HWND r;
    FARPROC fp ;

    fp = (FARPROC)pp4 ;

    pp4 = (DLGPROC)HookAdd( (FARPROC)DlgMesgProc, (FARPROC)fp );

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:CreateDialog HANDLE+LPSTR+HWND+FARPROC+",
        pp1, pp2, pp3, pp4 );

    /*
    ** Call the API!
    */
    r = CreateDialog(pp1,pp2,pp3,pp4);
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:CreateDialog HWND+++++",
        r, (short)0, (short)0, (short)0, (short)0 );

    return( r );
}

HWND zCreateDialogIndirect( HANDLE pp1, LPDLGTEMPLATE pp2, HWND pp3, DLGPROC pp4 )
{
    HWND r;
    FARPROC fp ;

    fp = (FARPROC)pp4 ;

    /*
        Changed 6-12-91 by BobK- if WNDPROC is null, don't hook it- it's
        already hooked at a higher level!
    */
    if  (pp4)
      pp4 = (DLGPROC)HookAdd( (FARPROC)DlgMesgProc, (FARPROC)fp );

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:CreateDialogIndirect HANDLE+LPSTR+HWND+FARPROC+",
        pp1, pp2, pp3, pp4 );

    /*
    ** Call the API!
    */
    r = CreateDialogIndirect(pp1,pp2,pp3,pp4);

    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:CreateDialogIndirect HWND+++++",
        r, (short)0, (short)0, (short)0, (short)0 );

    return( r );
}

HWND zCreateDialogIndirectParam( HANDLE pp1, LPDLGTEMPLATE pp2, HWND pp3, DLGPROC pp4, long pp5 )
{
    HWND r;
    FARPROC fp ;

    fp = (FARPROC)pp4 ;

    pp4 = (DLGPROC)HookAdd( (FARPROC)DlgMesgProc, (FARPROC)fp );

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:CreateDialogIndirectParam HANDLE+LPSTR+HWND+FARPROC+long+",
        pp1, pp2, pp3, pp4, pp5 );

    /*
    ** Call the API!
    */
    r = CreateDialogIndirectParam(pp1,pp2,pp3,pp4,pp5);

    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:CreateDialogIndirectParam HWND++++++",
        r, (short)0, (short)0, (short)0, (short)0, (short)0 );

    return( r );
}

HWND zCreateDialogParam( HANDLE pp1, LPSTR pp2, HWND pp3, DLGPROC pp4, long pp5 )
{
    HWND r;
    FARPROC fp ;

    fp = (FARPROC)pp4 ;

    pp4 = (DLGPROC)HookAdd( (FARPROC)DlgMesgProc, (FARPROC)fp );

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:CreateDialogParam HANDLE+LPSTR+HWND+FARPROC+long+",
        pp1, pp2, pp3, pp4, pp5 );

    /*
    ** Call the API!
    */
    r = CreateDialogParam(pp1,pp2,pp3,pp4,pp5);

    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:CreateDialogParam HWND++++++",
        r, (short)0, (short)0, (short)0, (short)0, (short)0 );

    return( r );
}


int zDialogBox( HANDLE pp1, LPSTR pp2, HWND pp3, DLGPROC pp4 )
{
    int r;
    FARPROC fp ;

    fp = (FARPROC)pp4 ;

    pp4 = (DLGPROC)HookAdd( (FARPROC)DlgMesgProc, (FARPROC)fp );

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:DialogBox HANDLE+LPSTR+HWND+FARPROC+",
        pp1, pp2, pp3, pp4 );

    /*
    ** Call the API!
    */
    r = DialogBox(pp1,pp2,pp3,pp4);
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:DialogBox int+++++",
        r, (short)0, (short)0, (short)0, (short)0 );

    return( r );
}

int zDialogBoxIndirect( HANDLE pp1, LPDLGTEMPLATE pp2, HWND pp3, DLGPROC pp4 )
{
    int r;
    FARPROC fp ;

    fp = (FARPROC)pp4 ;

    pp4 = (DLGPROC)HookAdd( (FARPROC)DlgMesgProc, (FARPROC)fp );

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:DialogBoxIndirect HANDLE+HANDLE+HWND+FARPROC+",
        pp1, pp2, pp3, pp4 );

    /*
    ** Call the API!
    */
    r = DialogBoxIndirect(pp1,pp2,pp3,pp4);

    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:DialogBoxIndirect int+++++",
        r, (short)0, (short)0, (short)0, (short)0 );

    return( r );
}

int zDialogBoxIndirectParam( HANDLE pp1, LPDLGTEMPLATE pp2, HWND pp3, DLGPROC pp4, long pp5 )
{
    int r;
    FARPROC fp ;

    fp = (FARPROC)pp4 ;

    pp4 = (DLGPROC)HookAdd( (FARPROC)DlgMesgProc, (FARPROC)fp );

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:DialogBoxIndirectParam HANDLE+HANDLE+HWND+FARPROC+long+",
        pp1, pp2, pp3, pp4, pp5 );

    /*
    ** Call the API!
    */
    r = DialogBoxIndirectParam(pp1,pp2,pp3,pp4,pp5);

    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:DialogBoxIndirectParam int++++++",
        r, (short)0, (short)0, (short)0, (short)0, (short)0 );

    return( r );
}

int zDialogBoxParam( HANDLE pp1, LPSTR pp2, HWND pp3, DLGPROC pp4, long pp5 )
{
    int r;
    FARPROC fp ;

    fp = (FARPROC)pp4 ;

    pp4 = (DLGPROC)HookAdd( (FARPROC)DlgMesgProc, (FARPROC)fp );

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:DialogBoxParam HANDLE+LPSTR+HWND+FARPROC+long+",
        pp1, pp2, pp3, pp4, pp5 );

    /*
    ** Call the API!
    */
    r = DialogBoxParam(pp1,pp2,pp3,pp4,pp5);

    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:DialogBoxParam int++++++",
        r, (short)0, (short)0, (short)0, (short)0, (short)0 );

    return( r );
}


/*
**
** HOOK STUFF
**
*/

LRESULT WH_CALLWNDPROCHook(
    HOOKPROC    fp,
    int         nCode,
    WPARAM      wParam,
    LPARAM      lParam
) {
    LRESULT l;

    LogIn( (LPSTR)"HOOKCALL:WH_CALLWNDPROC FARPROC+int+WPARAM+LPARAM+",
        fp, nCode, wParam, lParam );

    l = (* fp)( nCode, wParam, lParam );

    LogOut( (LPSTR)"HOOKRET:WH_CALLWNDPROC LONG+FARPROC+int+WPARAM+LPARAM+",
        l, fp, nCode, wParam, lParam );

    return( l );
}


LRESULT WH_GETMESSAGEHook(
    HOOKPROC    fp,
    int         nCode,
    WPARAM      wParam,
    LPARAM      lParam
) {
    LRESULT     l;

    LogIn( (LPSTR)"HOOKCALL:WH_GETMESSAGE FARPROC+int+WPARAM+LPMSG+",
        fp, nCode, wParam, lParam );

    l = (* fp)( nCode, wParam, lParam );

    LogOut( (LPSTR)"HOOKRET:WH_GETMESSAGE LONG+FARPROC+int+WPARAM+LPMSG+",
        l, fp, nCode, wParam, lParam );

    return( l );
}


LRESULT WH_JOURNALPLAYBACKHook(
    HOOKPROC    fp,
    int         nCode,
    WPARAM      wParam,
    LPARAM      lParam
) {
    LONG    l;

    LogIn( (LPSTR)"HOOKCALL:WH_JOURNALPLAYBACK FARPROC+int+WPARAM+LPMSG+",
        fp, nCode, wParam, lParam );

    l = (* fp)( nCode, wParam, lParam );

    LogOut( (LPSTR)"HOOKRET:WH_JOURNALPLAYBACK LONG+FARPROC+int+WPARAM+LPMSG+",
        l, fp, nCode, wParam, lParam );

    return( l );
}


LRESULT WH_JOURNALRECORDHook(
    HOOKPROC    fp,
    int         nCode,
    WPARAM      wParam,
    LPARAM      lParam
) {
    LRESULT     l;

    LogIn( (LPSTR)"HOOKCALL:WH_JOURNALRECORD FARPROC+int+WPARAM+LPMSG+",
        fp, nCode, wParam, lParam );

    l = (* fp)( nCode, wParam, lParam );

    LogOut( (LPSTR)"HOOKRET:WH_JOURNALRECORD LONG+FARPROC+int+WPARAM+LPMSG+",
        l, fp, nCode, wParam, lParam );

    return( l );
}


LRESULT WH_KEYBOARDHook(
    HOOKPROC    fp,
    int         nCode,
    WPARAM      wParam,
    LPARAM      lParam
) {
    LRESULT     l;

    LogIn( (LPSTR)"HOOKCALL:WH_KEYBOARD FARPROC+int+WPARAM+LONG+",
        fp, nCode, wParam, lParam );

    l = (* fp)( nCode, wParam, lParam );

    LogOut( (LPSTR)"HOOKRET:WH_KEYBOARD LONG+FARPROC+int+WPARAM+LONG+",
        l, fp, nCode, wParam, lParam );

    return( l );
}


LRESULT WH_MSGFILTERHook(
    HOOKPROC    fp,
    int         nCode,
    WPARAM      wParam,
    LPARAM      lParam
) {
    LRESULT     l;

    LogIn( (LPSTR)"HOOKCALL:WH_MSGFILTER FARPROC+int+WPARAM+LPMSG+",
        fp, nCode, wParam, lParam );

    l = (* fp)( nCode, wParam, lParam );

    LogOut( (LPSTR)"HOOKRET:WH_MSGFILTER LONG+FARPROC+int+WPARAM+LPMSG+",
        l, fp, nCode, wParam, lParam );

    return( l );
}


LPARAM WH_SYSMSGFILTERHook(
    HOOKPROC    fp,
    int         nCode,
    WPARAM      wParam,
    LPARAM      lParam
) {
    LRESULT     l;

    LogIn( (LPSTR)"HOOKCALL:WH_SYSMSGFILTER FARPROC+int+WPARAM+LPMSG+",
        fp, nCode, wParam, lParam );

    l = (* fp)( nCode, wParam, lParam );

    LogOut( (LPSTR)"HOOKRET:WH_SYSMSGFILTER LONG+FARPROC+int+WPARAM+LPMSG+",
        l, fp, nCode, wParam, lParam );

    return( l );
}

LPARAM WH_CBTHook(
    HOOKPROC    fp,
    int         nCode,
    WPARAM      wParam,
    LPARAM      lParam
) {
    LRESULT     l;

    LogIn( (LPSTR)"HOOKCALL:WH_CBT FARPROC+int+WORD+LONG+",
        fp, nCode, wParam, lParam );

    l = (* fp)( nCode, wParam, lParam );

    LogOut( (LPSTR)"HOOKRET:WH_CBT LONG+FARPROC+int+WORD+LONG+",
        l, fp, nCode, wParam, lParam );

    return( l );
}

LRESULT WH_MOUSEHook(
    HOOKPROC    fp,
    int         nCode,
    WPARAM      wParam,
    LPARAM      lParam
) {
    LRESULT     l;

    LogIn( (LPSTR)"HOOKCALL:WH_MOUSE FARPROC+int+WORD+LONG+",
        fp, nCode, wParam, lParam );

    l = (* fp)( nCode, wParam, lParam );

    LogOut( (LPSTR)"HOOKRET:WH_MOUSE LONG+FARPROC+int+WORD+LONG+",
        l, fp, nCode, wParam, lParam );

    return( l );
}

LRESULT WH_DEBUGHook(
    HOOKPROC    fp,
    int         nCode,
    WPARAM      wParam,
    LPARAM      lParam
) {
    LONG    l;

    LogIn( (LPSTR)"HOOKCALL:WH_DEBUG FARPROC+int+WORD+LONG+",
        fp, nCode, wParam, lParam );

    l = (* fp)( nCode, wParam, lParam );

    LogOut( (LPSTR)"HOOKRET:WH_DEBUG LONG+FARPROC+int+WORD+LONG+",
        l, fp, nCode, wParam, lParam );

    return( l );
}


HHOOK zSetWindowsHookA( int pp1, HOOKPROC pp2 )
{
   HHOOK    r;
   HOOKPROC fp = pp2 ;
   BOOL     fUsable;

   /*
   ** Log IN Parameters (No Create/Destroy Checking Yet!)
   */
   LogIn( (LPSTR)"APICALL:SetWindowsHookA int+FARPROC+",
       pp1, pp2 );
   fUsable = TRUE;

   switch( pp1 )
   {
      case WH_CALLWNDPROC:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_CALLWNDPROCHook,     (FARPROC)pp2 );
         break ;
      case WH_GETMESSAGE:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_GETMESSAGEHook,      (FARPROC)pp2 );
         break  ;
      case WH_JOURNALPLAYBACK:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_JOURNALPLAYBACKHook, (FARPROC)pp2 );
         break ;
      case WH_JOURNALRECORD:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_JOURNALRECORDHook,   (FARPROC)pp2 );
         break ;
      case WH_KEYBOARD:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_KEYBOARDHook,        (FARPROC)pp2 );
         break ;
      case WH_MSGFILTER:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_MSGFILTERHook,       (FARPROC)pp2 );
         break ;
      case WH_SYSMSGFILTER:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_SYSMSGFILTERHook,    (FARPROC)pp2 );
         break ;
      case WH_CBT:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_CBTHook,             (FARPROC)pp2 );
         break ;
      case WH_MOUSE:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_MOUSEHook,           (FARPROC)pp2 );
         break ;
      case WH_DEBUG:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_DEBUGHook,           (FARPROC)pp2 );
         break ;
      default:
        fUsable = FALSE;
        break;
   }

   /*
   ** Call the API!
   */
   r = SetWindowsHookA(pp1,fp);

   /*
   ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
   */
   if ( fUsable ) {
       LogOut( (LPSTR)"APIRET:SetWindowsHookA FARPROC+++",
           r, (short)0, (short)0 );
   } else {
       LogOut( (LPSTR)"APIRET:SetWindowsHookA FARPROC+++LPSTR+",
           r, (short)0, (short)0, (LPSTR)"WARNING! HOOK TYPE NOT KNOWN!!!" );
   }

   return( r );
}

HHOOK zSetWindowsHookW( int pp1, HOOKPROC pp2 )
{
   HHOOK    r;
   HOOKPROC fp = pp2 ;
   BOOL     fUsable;

   /*
   ** Log IN Parameters (No Create/Destroy Checking Yet!)
   */
   LogIn( (LPSTR)"APICALL:SetWindowsHookW int+FARPROC+",
       pp1, pp2 );
   fUsable = TRUE;

   switch( pp1 )
   {
      case WH_CALLWNDPROC:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_CALLWNDPROCHook,     (FARPROC)pp2 );
         break ;
      case WH_GETMESSAGE:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_GETMESSAGEHook,      (FARPROC)pp2 );
         break  ;
      case WH_JOURNALPLAYBACK:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_JOURNALPLAYBACKHook, (FARPROC)pp2 );
         break ;
      case WH_JOURNALRECORD:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_JOURNALRECORDHook,   (FARPROC)pp2 );
         break ;
      case WH_KEYBOARD:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_KEYBOARDHook,        (FARPROC)pp2 );
         break ;
      case WH_MSGFILTER:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_MSGFILTERHook,       (FARPROC)pp2 );
         break ;
      case WH_SYSMSGFILTER:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_SYSMSGFILTERHook,    (FARPROC)pp2 );
         break ;
      case WH_CBT:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_CBTHook,             (FARPROC)pp2 );
         break ;
      case WH_MOUSE:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_MOUSEHook,           (FARPROC)pp2 );
         break ;
      case WH_DEBUG:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_DEBUGHook,           (FARPROC)pp2 );
         break ;
      default:
        fUsable = FALSE;
        break;
   }

   /*
   ** Call the API!
   */
   r = SetWindowsHookW(pp1,fp);

   /*
   ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
   */
   if ( fUsable ) {
       LogOut( (LPSTR)"APIRET:SetWindowsHookW FARPROC+++",
           r, (short)0, (short)0 );
   } else {
       LogOut( (LPSTR)"APIRET:SetWindowsHookW FARPROC+++LPSTR+",
           r, (short)0, (short)0, (LPSTR)"WARNING! HOOK TYPE NOT KNOWN!!!" );
   }

   return( r );
}


BOOL zUnhookWindowsHook( int pp1, HOOKPROC pp2 )
{
    BOOL r;
    HOOKPROC fp ;

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:UnhookWindowsHook int+FARPROC+",
        pp1, pp2 );

    fp = (HOOKPROC)HookFind( (FARPROC)pp2 ) ;
    if ( fp == NULL ) {     /* Unhooking an unknown hook type */
        fp = pp2;
    }

    /*
    ** Call the API!
    */
    r = UnhookWindowsHook(pp1,fp);

    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:UnhookWindowsHook BOOL+++",
        r, (short)0, (short)0 );

    return( r );
}

HHOOK  zSetWindowsHookExA( int pp1, HOOKPROC pp2, HINSTANCE pp3, DWORD pp4 )
{
   HHOOK    r;
   HOOKPROC fp = pp2 ;
   BOOL     fUsable;

   /*
   ** Log IN Parameters (No Create/Destroy Checking Yet!)
   */
    LogIn( (LPSTR)"APICALL:SetWindowsHookExA int+HOOKPROC+HINSTANCE+DWORD+",
        pp1, pp2, pp3, pp4 );

   fUsable = TRUE;

   switch( pp1 )
   {
      case WH_CALLWNDPROC:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_CALLWNDPROCHook,     (FARPROC)pp2 );
         break ;
      case WH_GETMESSAGE:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_GETMESSAGEHook,      (FARPROC)pp2 );
         break  ;
      case WH_JOURNALPLAYBACK:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_JOURNALPLAYBACKHook, (FARPROC)pp2 );
         break ;
      case WH_JOURNALRECORD:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_JOURNALRECORDHook,   (FARPROC)pp2 );
         break ;
      case WH_KEYBOARD:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_KEYBOARDHook,        (FARPROC)pp2 );
         break ;
      case WH_MSGFILTER:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_MSGFILTERHook,       (FARPROC)pp2 );
         break ;
      case WH_SYSMSGFILTER:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_SYSMSGFILTERHook,    (FARPROC)pp2 );
         break ;
      case WH_CBT:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_CBTHook,             (FARPROC)pp2 );
         break ;
      case WH_MOUSE:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_MOUSEHook,           (FARPROC)pp2 );
         break ;
      case WH_DEBUG:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_DEBUGHook,           (FARPROC)pp2 );
         break ;
      default:
        fUsable = FALSE;
        break;
   }

   /*
   ** Call the API!
   */
   r = SetWindowsHookExA(pp1,fp,pp3,pp4);

   /*
   ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
   */
   if ( fUsable ) {
       LogOut( (LPSTR)"APIRET:SetWindowsHookExA FARPROC+++",
           r, (short)0, (short)0 );
   } else {
       LogOut( (LPSTR)"APIRET:SetWindowsHookExA FARPROC+++LPSTR+",
           r, (short)0, (short)0, (LPSTR)"WARNING! HOOK TYPE NOT KNOWN!!!" );
   }

   return( r );
}


HHOOK  zSetWindowsHookExW( int pp1, HOOKPROC pp2, HINSTANCE pp3, DWORD pp4 )
{
   HHOOK    r;
   HOOKPROC fp = pp2 ;
   BOOL     fUsable;

   /*
   ** Log IN Parameters (No Create/Destroy Checking Yet!)
   */
    LogIn( (LPSTR)"APICALL:SetWindowsHookExW int+HOOKPROC+HINSTANCE+DWORD+",
        pp1, pp2, pp3, pp4 );

   fUsable = TRUE;

   switch( pp1 )
   {
      case WH_CALLWNDPROC:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_CALLWNDPROCHook,     (FARPROC)pp2 );
         break ;
      case WH_GETMESSAGE:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_GETMESSAGEHook,      (FARPROC)pp2 );
         break  ;
      case WH_JOURNALPLAYBACK:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_JOURNALPLAYBACKHook, (FARPROC)pp2 );
         break ;
      case WH_JOURNALRECORD:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_JOURNALRECORDHook,   (FARPROC)pp2 );
         break ;
      case WH_KEYBOARD:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_KEYBOARDHook,        (FARPROC)pp2 );
         break ;
      case WH_MSGFILTER:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_MSGFILTERHook,       (FARPROC)pp2 );
         break ;
      case WH_SYSMSGFILTER:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_SYSMSGFILTERHook,    (FARPROC)pp2 );
         break ;
      case WH_CBT:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_CBTHook,             (FARPROC)pp2 );
         break ;
      case WH_MOUSE:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_MOUSEHook,           (FARPROC)pp2 );
         break ;
      case WH_DEBUG:
         fp = (HOOKPROC)HookAdd( (FARPROC)WH_DEBUGHook,           (FARPROC)pp2 );
         break ;
      default:
        fUsable = FALSE;
        break;
   }

   /*
   ** Call the API!
   */
   r = SetWindowsHookExW(pp1,fp,pp3,pp4);

   /*
   ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
   */
   if ( fUsable ) {
       LogOut( (LPSTR)"APIRET:SetWindowsHookExW FARPROC+++",
           r, (short)0, (short)0 );
   } else {
       LogOut( (LPSTR)"APIRET:SetWindowsHookExW FARPROC+++LPSTR+",
           r, (short)0, (short)0, (LPSTR)"WARNING! HOOK TYPE NOT KNOWN!!!" );
   }

   return( r );
}


BOOL  zUnhookWindowsHookEx( HHOOK pp1 )
{
    BOOL r;
    HOOKPROC fp ;

    // Log IN Parameters USER32 hook
    LogIn( (LPSTR)"APICALL:UnhookWindowsHookEx HHOOK+",
        pp1 );

    fp = (HOOKPROC)HookFind( (FARPROC)pp1 ) ;
    if ( fp == NULL ) {     /* Unhooking an unknown hook type */
        fp = pp1;
    }

    // Call the API!
    r = UnhookWindowsHookEx(fp);

    // Log Return Code & OUT Parameters
    LogOut( (LPSTR)"APIRET:UnhookWindowsHookEx BOOL++",
        r, (short)0 );

    return( r );
}



BOOL EnumThreadWin(
    WNDENUMPROC fp,
    HWND        hwnd,
    LPARAM      lParam
) {
    BOOL   l;

    LogIn( (LPSTR)"ENUMCALL:EnumThreadWindows FARPROC+HWND+LPARAM+",
        fp, hwnd, lParam ) ;

    l = (* fp)( hwnd, lParam );

    LogOut( (LPSTR)"ENUMRET:EnumThreadWindows BOOL+FARPROC+HWND+LPARAM+",
        l, fp, hwnd, lParam ) ;

    return( l );

}

BOOL zEnumThreadWindows( DWORD pp1, WNDENUMPROC pp2, LPARAM pp3 )
{
    BOOL r;

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:EnumTaskWindows HANDLE+FARPROC+long+",
        pp1, pp2, pp3 );

    pp2 = (WNDENUMPROC) HookAdd( (FARPROC)EnumThreadWin, (FARPROC)pp2 ) ;

    /*
    ** Call the API!
    */
    r = EnumThreadWindows(pp1,(WNDENUMPROC)pp2,pp3);

    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:EnumTaskWindows BOOL++++",
        r, (short)0, (short)0, (short)0 );

    return( r );
}

LONG zSetWindowLongW( HWND pp1, int pp2, LONG pp3 )
{
    long r;
    FARPROC fp ;

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:SetWindowLongW HWND+int+long+",
        pp1, pp2, pp3 );

    if( pp2 == GWL_WNDPROC ) {
       FARPROC fp ;
       
       fp = (WNDPROC)HookFind( (FARPROC)pp3 );
       if( fp )
         pp3 = (LONG)fp ;
       else   
         pp3 = (long)((FARPROC)HookAdd( (FARPROC)MesgProc, (FARPROC)pp3 ));
    }
    /*
    ** Call the API!
    */
    r = SetWindowLongW(pp1,pp2,pp3);

    if( pp2 == GWL_WNDPROC ) {
       // return what the app set for a WndProc...
       fp = IsHook( r ) ;
       if( fp != NULL )
         r = fp ;
      }   
    
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:SetWindowLongW long++++",
        r, (short)0, (short)0, (short)0 );

    return( r );
}

LONG zSetWindowLongA( HWND pp1, int pp2, LONG pp3 )
{
    long r;
    FARPROC fp ;

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:SetWindowLongA HWND+int+long+",
        pp1, pp2, pp3 );

    if( pp2 == GWL_WNDPROC ) {
       FARPROC fp ;
       
       fp = (WNDPROC)HookFind( (FARPROC)pp3 );
       if( fp )
         pp3 = (LONG)fp ;
       else   
         pp3 = (long)((FARPROC)HookAdd( (FARPROC)MesgProc, (FARPROC)pp3 ));
    }
    /*
    ** Call the API!
    */
    r = SetWindowLongA(pp1,pp2,pp3);

    if( pp2 == GWL_WNDPROC ) {
       // return what the app set for a WndProc...
       fp = IsHook( r ) ;
       if( fp != NULL )
         r = fp ;
    }
    
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:SetWindowLongA long++++",
        r, (short)0, (short)0, (short)0 );

    return( r );
}

/*
** TIMER STUFF
**
*/
VOID TimerRtn(
    TIMERPROC   fp,
    HWND        hwnd,
    UINT        lParam,
    UINT        nId,
    DWORD       dwTime
) {
    LogIn( (LPSTR)"TIMECALL:SetTimer FARPROC+HWND+DWORD+int+DWORD+",
        fp, hwnd, lParam, nId, dwTime ) ;

    (* fp)( hwnd, lParam, nId, dwTime );

    LogOut( (LPSTR)"TIMERET:SetTimer FARPROC+HWND+DWORD+int+DWORD+",
        fp, hwnd, lParam, nId, dwTime ) ;
}

WORD zSetTimer( HWND pp1, int pp2, WORD pp3, FARPROC pp4 )
{
    WORD r;

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:SetTimer HWND+int+WORD+FARPROC+",
        pp1, pp2, pp3, pp4 );

    if ( pp4 != NULL ) {
        pp4 = (FARPROC) HookAdd( (FARPROC)TimerRtn, (FARPROC)pp4 );
    }

    /*
    ** Call the API!
    */
    r = SetTimer(pp1,pp2,pp3,(TIMERPROC)pp4);

    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:SetTimer WORD+++++",
        r, (short)0, (short)0, (short)0, (short)0 );

    return( r );
}

BOOL zGetKeyboardState( PBYTE pp1 )
{
    BOOL    b;

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:GetKeyboardState +",
        (short)0 );

    /*
    ** Call the API!
    */
    b = GetKeyboardState(pp1);

    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:GetKeyboardState BOOL+FixedString+",
        b, pp1, (DWORD) 256 );

    return( b );
}

BOOL zSetKeyboardState( LPBYTE pp1 )
{
    BOOL    b;

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:SetKeyboardState FixedString+",
        pp1, (DWORD) 256 );

    /*
    ** Call the API!
    */
    b = SetKeyboardState(pp1);

    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:SetKeyboardState BOOL+",
        b, (short)0 );

    return( b );
}

LRESULT zCallWindowProcA( WNDPROC pp1, HWND pp2, UINT pp3, WPARAM pp4, LPARAM pp5 )
{
    LRESULT r;
    WNDPROC fp;

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:CallWindowProcA FARPROC+HWND+UINT+WPARAM+LPARAM+",
        pp1, pp2, pp3, pp4, pp5 );


    fp = (WNDPROC)HookFind( (FARPROC)pp1 );
    if ( fp != NULL ) {
       pp1 = fp;
    }

    /*
    ** Call the API!
    */
    r = CallWindowProcA(pp1,pp2,pp3,pp4,pp5);

    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:CallWindowProcA long++++++",
        r, (short)0, (short)0, (short)0, (short)0, (short)0 );

    return( r );
}

LRESULT zCallWindowProcW( WNDPROC pp1, HWND pp2, UINT pp3, WPARAM pp4, LPARAM pp5 )
{
    LRESULT r;
    WNDPROC fp;

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:CallWindowProcW FARPROC+HWND+UINT+WPARAM+LPARAM+",
        pp1, pp2, pp3, pp4, pp5 );


    fp = (WNDPROC)HookFind( (FARPROC)pp1 );
    if ( fp != NULL ) {
       pp1 = fp;
    }

    /*
    ** Call the API!
    */
    r = CallWindowProcW(pp1,pp2,pp3,pp4,pp5);

    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:CallWindowProcW long++++++",
        r, (short)0, (short)0, (short)0, (short)0, (short)0 );

    return( r );
}



BOOL  zGetClassInfoA( HINSTANCE pp1, LPCSTR pp2, LPWNDCLASSA pp3 )
{
    BOOL r;
    FARPROC fp ;

    // Log IN Parameters USER32 class
    LogIn( (LPSTR)"APICALL:GetClassInfoA HINSTANCE+LPCSTR++",
        pp1, pp2, (short)0 );

    // Call the API!
    r = GetClassInfoA(pp1,pp2,pp3);
    
    // return what the app set for a WndProc...
    fp = IsHook( pp3->lpfnWndProc ) ;
    if( fp != NULL )
      pp3->lpfnWndProc = fp ;
    
    // Log Return Code & OUT Parameters
    LogOut( (LPSTR)"APIRET:GetClassInfoA BOOL+++LPWNDCLASSA+",
        r, (short)0, (short)0, pp3 );

    return( r );
}

BOOL  zGetClassInfoW( HINSTANCE pp1, LPCWSTR pp2, LPWNDCLASSW pp3 )
{
    BOOL r;
    FARPROC fp ;

    // Log IN Parameters USER32 class
    LogIn( (LPSTR)"APICALL:GetClassInfoW HINSTANCE+LPCWSTR++",
        pp1, pp2, (short)0 );

    // Call the API!
    r = GetClassInfoW(pp1,pp2,pp3);

    // return what the app set for a WndProc...
    fp = IsHook( pp3->lpfnWndProc ) ;
    if( fp != NULL )
      pp3->lpfnWndProc = fp ;
    
    // Log Return Code & OUT Parameters
    LogOut( (LPSTR)"APIRET:GetClassInfoW BOOL+++LPWNDCLASSW+",
        r, (short)0, (short)0, pp3 );

    return( r );
}
