/*++

Copyright (c) 1989  Microsoft Corporation

Module Name:

    nls.c

Abstract:

    This module implements includes the OS/2 V1.21 NLS tables.

Author:

    Michael Jarus (mjarus) 15-Apr-1992

Revision History:

--*/

#include <windows.h>
#include "os2nls.h"


COUNTRYINFO USCtryInfo =
    {
        CTRY_UNITED_STATES,
        CODEPAGE_US,
        DATEFMT_MM_DD_YY,
        "$\0\0\0",
        ",",
        ".",
        "-",
        ":",
        0 /* BUGBUG?? CURRENCY_DECIMAL*/,
        2,
        TIMEFMT_12_HOUR,
         { 0, 0 },
        ",",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO CanadaCtryInfo =
    {
        CTRY_CANADA,
        CODEPAGE_CANADIAN,
        DATEFMT_YY_MM_DD,
        "$\0\0\0",
        " ",
        ",",
        "-",
        ":",
        CURRENCY_FOLLOW | CURRENCY_SPACE,
        2,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ";",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO LatinAmCtryInfo =
    {
        COUNTRY_LATIN_AMERICA,
        CODEPAGE_US,
        DATEFMT_DD_MM_YY,
        "$\0\0\0",
        ",",
        ".",
        "/",
        ":",
        CURRENCY_FOLLOW | CURRENCY_SPACE,
        2,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ";",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO DutchCtryInfo =
    {
        CTRY_NETHERLANDS,
        CODEPAGE_MULTI,
        DATEFMT_DD_MM_YY,
        "\237\0\0\0",
        ".",
        ",",
        "-",
        ":",
        CURRENCY_SPACE,
        2,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ";",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO BelgiunCtryInfo =
    {
        CTRY_BELGIUM,
        CODEPAGE_MULTI,
        DATEFMT_DD_MM_YY,
        "BEF\0",
        ".",
        ",",
        "/",
        ":",
        CURRENCY_SPACE,
        2,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ";",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO FranceCtryInfo =
    {
        CTRY_FRANCE,
        CODEPAGE_US,
        DATEFMT_DD_MM_YY,
        "F\0\0\0",
        " ",
        ",",
        "/",
        ":",
        CURRENCY_FOLLOW | CURRENCY_SPACE,
        2,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ";",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO SpainCtryInfo =
    {
        CTRY_SPAIN,
        CODEPAGE_MULTI,
        DATEFMT_DD_MM_YY,
        "Pts\0",
        ".",
        ",",
        "/",
        ":",
        CURRENCY_FOLLOW | CURRENCY_SPACE,
        2,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ";",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO ItalyCtryInfo =
    {
        CTRY_ITALY,
        CODEPAGE_US,
        DATEFMT_DD_MM_YY,
        "L.\0\0",
        ".",
        ",",
        "/",
        ":",
        0,
        0,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ";",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO SwitzCtryInfo =
    {
        CTRY_SWITZERLAND,
        CODEPAGE_MULTI,
        DATEFMT_DD_MM_YY,
        "Fr\0\0",
        "'",
        ".",
        ".",
        ".",
        CURRENCY_SPACE,
        2,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ",",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO AustriaCtryInfo =
    {
        CTRY_GERMANY,
        CODEPAGE_US,
        DATEFMT_DD_MM_YY,
        "DM\0\0",
        ".",
        ",",
        ".",
        ".",
        CURRENCY_SPACE,
        2,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ";",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO UKCtryInfo =
    {
        CTRY_UNITED_KINGDOM,
        CODEPAGE_US,
        DATEFMT_DD_MM_YY,
        "\234\0\0\0",
        ",",
        ".",
        "-",
        ":",
        0,
        2,
        TIMEFMT_12_HOUR,
        { 0, 0 },
        ",",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO DenmarkCtryInfo =
    {
        CTRY_DENMARK,
        CODEPAGE_MULTI,
        DATEFMT_DD_MM_YY,
        "kr\0\0",
        ".",
        ",",
        "-",
        ".",
        CURRENCY_SPACE,
        2,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ";",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO SwedenCtryInfo =
    {
        CTRY_SWEDEN,
        CODEPAGE_US,
        DATEFMT_YY_MM_DD,
        "SEK\0",
        ".",
        ",",
        "-",
        ".",
        CURRENCY_SPACE,
        2,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ";",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO NorwayCtryInfo =
    {
        CTRY_NORWAY,
        CODEPAGE_MULTI,
        DATEFMT_DD_MM_YY,
        "Kr\0\0",
        ".",
        ",",
        ".",
        ".",
        CURRENCY_SPACE,
        2,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ";",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO GermanyCtryInfo =
    {
        CTRY_GERMANY,
        CODEPAGE_US,
        DATEFMT_DD_MM_YY,
        "DM\0\0",
        ".",
        ",",
        ".",
        ".",
        CURRENCY_SPACE,
        2,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ";",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO MexicoCtryInfo =
    {
        CTRY_MEXICO,
        CODEPAGE_US,
        DATEFMT_DD_MM_YY,
        "$\0\0\0",
        ",",
        ".",
        "/",
        ":",
        CURRENCY_FOLLOW | CURRENCY_SPACE,
        2,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ";",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO BrazilCtryInfo =
    {
        CTRY_BRAZIL,
        CODEPAGE_US,
        DATEFMT_DD_MM_YY,
        "$\0\0\0",
        ",",
        ".",
        "/",
        ":",
        CURRENCY_FOLLOW | CURRENCY_SPACE,
        2,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ";",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO AustraliaCtryInfo =
    {
        CTRY_AUSTRALIA,
        CODEPAGE_US,
        DATEFMT_DD_MM_YY,
        "$\0\0\0",
        ",",
        ".",
        "-",
        ":",
        0,
        2,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ",",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO NewZelandCtryInfo =
    {
        CTRY_NEW_ZEALAND,
        CODEPAGE_US,
        DATEFMT_DD_MM_YY,
        "$\0\0\0",
        ",",
        ".",
        "-",
        ":",
        0,
        2,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ",",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO PortugalCtryInfo =
    {
        CTRY_PORTUGAL,
        CODEPAGE_PORTUGESE,
        DATEFMT_DD_MM_YY,
        "$\0\0\0",
        ".",
        ",",
        "/",
        ":",
        CURRENCY_DECIMAL,
        2,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ";",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO IrelandCtryInfo =
    {
        CTRY_IRELAND,
        CODEPAGE_US,
        DATEFMT_DD_MM_YY,
        "\234\0\0\0",
        ",",
        ".",
        "-",
        ":",
        0,
        2,
        TIMEFMT_12_HOUR,
        { 0, 0 },
        ",",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO IcelandCtryInfo =
    {
        CTRY_ICELAND,
        CODEPAGE_MULTI,
        DATEFMT_DD_MM_YY,
        "Kr\0\0",
        ".",
        ",",
        ".",
        ".",
        CURRENCY_SPACE,
        2,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ";",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO FinlandCtryInfo =
    {
        CTRY_FINLAND,
        CODEPAGE_MULTI,
        DATEFMT_DD_MM_YY,
        "mk\0\0",
        " ",
        ",",
        ".",
        ".",
        CURRENCY_FOLLOW | CURRENCY_SPACE,
        2,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ";",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO JapanCtryInfo =
    {
        CTRY_JAPAN,
        CODEPAGE_JAPAN,
        DATEFMT_YY_MM_DD,
        "\\\0\0\0",
        ",",
        ".",
        "-",
        ":",
        0,
        0,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ",",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO KoreaCtryInfo =
    {
        CTRY_SOUTH_KOREA,
        CODEPAGE_KOREA,
        DATEFMT_YY_MM_DD,
        "\\\0\0\0",
        ",",
        ".",
        "-",
        ":",
        0,
        0,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ",",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO TaiwanCtryInfo =
    {
        CTRY_TAIWAN,
        CODEPAGE_TAIWAN,
        DATEFMT_MM_DD_YY,
        "NT$\0",
        ",",
        ".",
        "-",
        ":",
        0,
        2,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ",",
        { 0, 0, 0, 0, 0 }
    };

COUNTRYINFO Taiwan2CtryInfo =
    {
        COUNTRY_TAIWAN,
        CODEPAGE_TAIWAN,
        DATEFMT_MM_DD_YY,
        "NT$\0",
        ",",
        ".",
        "-",
        ":",
        0,
        2,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ",",
        { 0, 0, 0, 0, 0 }
    };

//#ifdef OS2SS_INCLUDE_HEBREW
COUNTRYINFO HebrewCtryInfo =
    {
        COUNTRY_HEBREW,
        CODEPAGE_HEBREW,
        DATEFMT_DD_MM_YY,
        "\231\0\0\0",
        ",",
        ".",
        " ",
        ":",
        CURRENCY_SPACE,
        2,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ",",
        { 0, 0, 0, 0, 0 }
    };
//#endif

//#ifdef OS2SS_INCLUDE_ARABIC
COUNTRYINFO ArabicCtryInfo =
    {
        COUNTRY_ARABIC,
        CODEPAGE_ARABIC,
        DATEFMT_DD_MM_YY,
        "\317\0\0\0",
        ".",
        ",",
        "/",
        ":",
        CURRENCY_FOLLOW | CURRENCY_SPACE,
        3,
        TIMEFMT_12_HOUR,
        { 0, 0 },
        ";",
        { 0, 0, 0, 0, 0 }
    };
//#endif

//#ifdef OS2SS_INCLUDE_PRCHINA
COUNTRYINFO ChinaCtryInfo =
    {
        CTRY_PRCHINA,
        CODEPAGE_PRC,
        DATEFMT_YY_MM_DD,
        "\\\0\0\0",
        ",",
        ".",
        "-",
        ":",
        0,
        2,
        TIMEFMT_24_HOUR,
        { 0, 0 },
        ",",
        { 0, 0, 0, 0, 0 }
    };
//#endif

OD2_COUNTRY_ENTRY OD2_COUNTRY_TABLE[] =
    {
        {   /*   United States    */

            CTRY_UNITED_STATES,
            LANG_ENGLISH,
            SUBLANG_ENGLISH_US,
            &USCtryInfo,
            INDEX_CODEPAGE_US,
            INDEX_CODEPAGE_MULTI,
            INDEX_FIX_CASE_UNITED_STATES
        },
        {   /*   Canadian-French  */

            CTRY_CANADA,
            LANG_FRENCH,
            SUBLANG_FRENCH_CANADIAN,
            &CanadaCtryInfo,
            INDEX_CODEPAGE_CANADIAN,
            INDEX_CODEPAGE_MULTI,
            INDEX_FIX_CASE_CANADA
        },
        {   /*   Latin-America    */

            COUNTRY_LATIN_AMERICA,
            LANG_SPANISH,
            SUBLANG_SPANISH_MEXICAN,
            &LatinAmCtryInfo,
            INDEX_CODEPAGE_US,
            INDEX_CODEPAGE_MULTI,
            INDEX_FIX_CASE_LATIN_AMERICA
        },
        {   /*   Netherlands      */

            CTRY_NETHERLANDS,
            LANG_DUTCH,
            SUBLANG_DUTCH,
            &DutchCtryInfo,
            INDEX_CODEPAGE_MULTI,
            INDEX_CODEPAGE_US,         /* INDEX_CODEPAGE_PORTUGESE */
            INDEX_FIX_CASE_NETHERLANDS
        },
        {   /*   Belgiun          */

            CTRY_BELGIUM,
            LANG_FRENCH,
            SUBLANG_FRENCH_BELGIAN,
            &BelgiunCtryInfo,
            INDEX_CODEPAGE_MULTI,
            INDEX_CODEPAGE_US,
            INDEX_FIX_CASE_BELGIUM
        },
        {   /*   France           */

            CTRY_FRANCE,
            LANG_FRENCH,
            SUBLANG_FRENCH,
            &FranceCtryInfo,
            INDEX_CODEPAGE_US,
            INDEX_CODEPAGE_MULTI,
            INDEX_FIX_CASE_FRANCE
        },
        {   /*   Spain            */

            CTRY_SPAIN,
            LANG_SPANISH,
            SUBLANG_SPANISH,
            &SpainCtryInfo,
            INDEX_CODEPAGE_MULTI,
            INDEX_CODEPAGE_US,
            INDEX_FIX_CASE_SPAIN
        },
        {   /*   Italy            */

            CTRY_ITALY,
            LANG_ITALIAN,
            SUBLANG_ITALIAN,
            &ItalyCtryInfo,
            INDEX_CODEPAGE_US,
            INDEX_CODEPAGE_MULTI,
            INDEX_FIX_CASE_ITALY
        },
        {   /*   Switzerland      */

            CTRY_SWITZERLAND,
            LANG_FRENCH,
            SUBLANG_FRENCH_SWISS,
            &SwitzCtryInfo,
            INDEX_CODEPAGE_MULTI,
            INDEX_CODEPAGE_US,
            INDEX_FIX_CASE_SWITZERLAND
        },
        {   /*   Austria          */

            CTRY_AUSTRIA,
            LANG_GERMAN,
            SUBLANG_GERMAN,
            &AustriaCtryInfo,
            INDEX_CODEPAGE_US,
            INDEX_CODEPAGE_MULTI,
            INDEX_FIX_CASE_AUSTRIA
        },
        {   /*   United Kingdom   */

            CTRY_UNITED_KINGDOM,
            LANG_ENGLISH,
            SUBLANG_ENGLISH_UK,
            &UKCtryInfo,
            INDEX_CODEPAGE_US,
            INDEX_CODEPAGE_MULTI,
            INDEX_FIX_CASE_UNITED_KINGDOM
        },
        {   /*   Denmark          */

            CTRY_DENMARK,
            LANG_DANISH,
            SUBLANG_NEUTRAL,
            &DenmarkCtryInfo,
            INDEX_CODEPAGE_MULTI,
            INDEX_CODEPAGE_NORDIC,
            INDEX_FIX_CASE_DENMARK
        },
        {   /*   Sweden           */

            CTRY_SWEDEN,
            LANG_SWEDISH,
            SUBLANG_NEUTRAL,
            &SwedenCtryInfo,
            INDEX_CODEPAGE_US,
            INDEX_CODEPAGE_MULTI,
            INDEX_FIX_CASE_SWEDEN
        },
        {   /*   Norway           */

            CTRY_NORWAY,
            LANG_NORWEGIAN,
            SUBLANG_NORWEGIAN_BOKMAL,  /* or  SUBLANG_NORWEGIAN_NYNORSK */
            &NorwayCtryInfo,
            INDEX_CODEPAGE_MULTI,
            INDEX_CODEPAGE_NORDIC,
            INDEX_FIX_CASE_NORWAY
        },
        {   /*   Germany          */

            CTRY_GERMANY,
            LANG_GERMAN,
            SUBLANG_GERMAN,
            &GermanyCtryInfo,
            INDEX_CODEPAGE_US,
            INDEX_CODEPAGE_MULTI,
            INDEX_FIX_CASE_GERMANY
        },
        {   /*   Mexico           */

            CTRY_MEXICO,
            LANG_SPANISH,
            SUBLANG_SPANISH_MEXICAN,
            &MexicoCtryInfo,
            INDEX_CODEPAGE_US,
            INDEX_CODEPAGE_MULTI,
            INDEX_FIX_CASE_MEXICO
        },
        {   /*   Brazil           */

            CTRY_BRAZIL,
            LANG_SPANISH,
            SUBLANG_SPANISH_MEXICAN,
            &BrazilCtryInfo,
            INDEX_CODEPAGE_US,
            INDEX_CODEPAGE_MULTI,
            INDEX_FIX_CASE_BRAZIL
        },
        {   /*   Australia        */

            CTRY_AUSTRALIA,
            LANG_ENGLISH,
            SUBLANG_ENGLISH_AUS,
            &AustraliaCtryInfo,
            INDEX_CODEPAGE_US,
            INDEX_CODEPAGE_MULTI,
            INDEX_FIX_CASE_AUSTRALIA
        },
        {   /*   New-Zeland       */

            CTRY_NEW_ZEALAND,
            LANG_ENGLISH,
            SUBLANG_ENGLISH_AUS,
            &NewZelandCtryInfo,
            INDEX_CODEPAGE_US,
            INDEX_CODEPAGE_MULTI,
            INDEX_FIX_CASE_NEW_ZEALAND
        },
        {   /*   Portugal         */

            CTRY_PORTUGAL,
            LANG_PORTUGUESE,
            SUBLANG_PORTUGUESE,
            &PortugalCtryInfo,
            INDEX_CODEPAGE_PORTUGESE,
            INDEX_CODEPAGE_MULTI,
            INDEX_FIX_CASE_PORTUGAL
        },
        {   /*   Ireland          */

            CTRY_IRELAND,
            LANG_ENGLISH,
            SUBLANG_ENGLISH_UK,
            &IrelandCtryInfo,
            INDEX_CODEPAGE_US,
            INDEX_CODEPAGE_MULTI,
            INDEX_FIX_CASE_IRELAND
        },
        {   /*   Iceland          */

            CTRY_ICELAND,
            LANG_NORWEGIAN,
            SUBLANG_NORWEGIAN_BOKMAL,  /* or  SUBLANG_NORWEGIAN_NYNORSK */
            &IcelandCtryInfo,
            INDEX_CODEPAGE_MULTI,
            INDEX_CODEPAGE_NORDIC,
            INDEX_FIX_CASE_ICELAND
        },
        {   /*   Finland          */

            CTRY_FINLAND,
            LANG_FINNISH,
            SUBLANG_NEUTRAL,
            &FinlandCtryInfo,
            INDEX_CODEPAGE_MULTI,
            INDEX_CODEPAGE_US,
            INDEX_FIX_CASE_FINLAND
        },
        {   /*   Japan            */

            CTRY_JAPAN,
            LANG_JAPANESE,
            SUBLANG_NEUTRAL,
            &JapanCtryInfo,
            INDEX_CODEPAGE_JAPAN,
            INDEX_CODEPAGE_US,
            INDEX_FIX_CASE_JAPAN
        },
        {   /*   Korea            */

            CTRY_SOUTH_KOREA,
            LANG_KOREAN,
            SUBLANG_NEUTRAL,
            &KoreaCtryInfo,
            INDEX_CODEPAGE_KOREA,
            INDEX_CODEPAGE_US,
            INDEX_FIX_CASE_SOUTH_KOREA
        },
#if 0
        {   /*   Taiwan            */

            CTRY_TAIWAN,
            LANG_THAI,
            SUBLANG_NEUTRAL,
            &TaiwanCtryInfo,
            INDEX_CODEPAGE_TAIWAN,
            INDEX_CODEPAGE_US,
            INDEX_FIX_CASE_TAIWAN
        },
        {   /*   Taiwan (old)      */

            COUNTRY_TAIWAN,
            LANG_THAI,
            SUBLANG_NEUTRAL,
            &Taiwan2CtryInfo,
            INDEX_CODEPAGE_TAIWAN,
            INDEX_CODEPAGE_US,
            INDEX_FIX_CASE_TAIWAN
        },
//#ifdef OS2SS_INCLUDE_HEBREW
        {   /*   Hebrew speaking  */

            COUNTRY_HEBREW,
            LANG_HEBREW,
            SUBLANG_NEUTRAL,
            &HebrewCtryInfo,
            INDEX_CODEPAGE_MULTI,
            INDEX_CODEPAGE_HEBREW,
            INDEX_FIX_CASE_HEBREW
        },
//#endif
//#ifdef OS2SS_INCLUDE_ARABIC
        {   /*   Arabic speaking  */

            COUNTRY_ARABIC,
            LANG_ARABIC,
            SUBLANG_NEUTRAL,
            &ArabicCtryInfo,
            INDEX_CODEPAGE_MULTI,
            INDEX_CODEPAGE_ARABIC,
            INDEX_FIX_CASE_ARABIC
        },
#endif
//#endif
//#ifdef OS2SS_INCLUDE_PRCHINA
        {   /*   Peoples Republic of China */

            CTRY_PRCHINA,
            LANG_CHINESE,
            SUBLANG_NEUTRAL,
            &ChinaCtryInfo,
            INDEX_CODEPAGE_PRC,
            INDEX_CODEPAGE_US,
            INDEX_FIX_CASE_PRCHINA
        },
//#endif
        {   /*   End of Table     */

            0,
            0,
            0,
            NULL,
            0,
            0
        }
    };


OD2_CODEPAGE_ENTRY    OD2_CODEPAGE_TABLE[] =
    {
        {
            437,
            INDEX_COLLATE_437,
            INDEX_CASEMAP_437,
            INDEX_DBCS_437
        },
        {
            850,
            INDEX_COLLATE_850,
            INDEX_CASEMAP_850,
            INDEX_DBCS_850
        },
        {
            860,
            INDEX_COLLATE_860,
            INDEX_CASEMAP_860,
            INDEX_DBCS_860
        },
        {
            863,
            INDEX_COLLATE_863,
            INDEX_CASEMAP_863,
            INDEX_DBCS_863
        },
        {
            865,
            INDEX_COLLATE_865,
            INDEX_CASEMAP_865,
            INDEX_DBCS_865
        },
        {
            932,
            INDEX_COLLATE_932,
            INDEX_CASEMAP_932,
            INDEX_DBCS_932
        },
        {
            934,
            INDEX_COLLATE_934,
            INDEX_CASEMAP_934,
            INDEX_DBCS_934
        },
        {
            938,
            INDEX_COLLATE_938,
            INDEX_CASEMAP_938,
            INDEX_DBCS_938
        },
//#ifdef OS2SS_INCLUDE_HEBREW
        {
            862,
            INDEX_COLLATE_862,
            INDEX_CASEMAP_862,
            INDEX_DBCS_862
        },
//#endif
//#ifdef OS2SS_INCLUDE_ARABIC
        {
            864,
            INDEX_COLLATE_864,
            INDEX_CASEMAP_864,
            INDEX_DBCS_864
        },
//#endif
//#ifdef OS2SS_INCLUDE_PRCHINA
        {
            936,
            INDEX_COLLATE_936,
            INDEX_CASEMAP_936,
            INDEX_DBCS_936
        },
//#endif
        {
            0,
            0,
            0,
            0
        }
    };



OD2_DBCS_VECTOR_ENTRY OD2_DBCS_VECTOR_TABLE[] =
    {
        {
            /*   SBCS DBCS EV       */

            2,
            { 0, 0 }
        },
        {
            /*   Japanese DBCS EV   */

            6,
            { 0x81, 0x9F, 0xE0, 0xFC, 0, 0 }
        },
        {
            /*   Korean DBCS EV     */

            4,
            { 0x81, 0xBF, 0, 0 }
        },
        {
            /*   Taiwan DBCS EV     */

            4,
            { 0x81, 0xFC, 0, 0 }
        },
//#ifdef OS2SS_INCLUDE_PRCHINA
        {
            /*   PRC DBCS EV        */

            4,
            { 0x81, 0xFC, 0, 0 }
        },
//#endif
        {
            /*   End of Table       */

            2,
            { 0, 0 }
        },
    };

/*
 *  It shows the diff between char offset and its case map
 *

UCHAR  CollateUpdate_437[] =
    {
        0x00, 0x00
    };
*/
UCHAR  CollateUpdate_850[] =
    {
        0x9B, 0x4F,
        0x9D, 0x4F,
        0x9E, 0x9E,
        0xB5, 0x41,
        0xB6, 0x41,
        0xB7, 0x41,
        0xBD, 0x24,
        0xBE, 0x24,
        0xC6, 0x41,
        0xC7, 0x41,
        0xCF, 0x24,
        0xD0, 0x44,
        0xD1, 0x44,
        0xD2, 0x45,
        0xD3, 0x45,
        0xD4, 0x45,
        0xD5, 0x49,
        0xD6, 0x49,
        0xD7, 0x49,
        0xD8, 0x49,
        0xDE, 0x49,
        0xE0, 0x4F,
        0xE2, 0x4f,
        0xE3, 0x4f,
        0xE4, 0x4f,
        0xE5, 0x4f,
        0xE7, 0xE8,
        0xE9, 0x55,
        0xEA, 0x55,
        0xEB, 0x55,
        0xEC, 0x59,
        0xED, 0x59,
        0x00, 0x00
    };

UCHAR  CollateUpdate_860[] =
    {
        0x8C, 0x4F,
        0x92, 0x45,
        0x98, 0x49,
        0x9D, 0x55,
        0x9F, 0x4F,
        0xA6, 0x41,
        0xA7, 0x4F,
        0xA9, 0x4F,
        0x00, 0x00
    };

UCHAR  CollateUpdate_863[] =
    {
        0x86, 0x86,
        0x8D, 0x8D,
        0x8F, 0x8F,
        0x91, 0x45,
        0x92, 0x45,
        0x94, 0x45,
        0x95, 0x49,
        0x98, 0x98,
        0x9B, 0x9B,
        0x9C, 0x9C,
        0x9D, 0x55,
        0x9E, 0x55,
        0x9F, 0x9F,
        0xA0, 0xA0,
        0xA1, 0xA1,
        0xA4, 0xA4,
        0xA5, 0xA5,
        0xA8, 0x49,
        0xAD, 0xAD,
        0xAE, 0xAE,
        0xAF, 0xAF,
        0xE1, 0xE1,
        0x00, 0x00
    };

UCHAR  CollateUpdate_865[] =
    {
        0x5B, 0x28,
        0x5C, 0x2F,
        0x5D, 0x29,
        0x7B, 0x28,
        0x7C, 0x2F,
        0x7D, 0x29,
        0x81, 0x59,
        0x84, 0x5B,
        0x86, 0x5D,
        0x8E, 0x5B,
        0x8F, 0x5D,
        0x91, 0x5B,
        0x92, 0x5B,
        0x94, 0x5C,
        0x99, 0x5C,
        0x9A, 0x59,
        0x9B, 0x5C,
        0x9D, 0x5C,
        0xA6, 0x41,
        0xA7, 0x4F,
        0xAF, 0x24,
        0x00, 0x00
    };

UCHAR  CollateUpdate_932[] =
    {
        0x80, 0x80,
        0x81, 0xC1,
        0x82, 0xC2,
        0x83, 0xC3,
        0x84, 0xC4,
        0x85, 0xC5,
        0x86, 0xC6,
        0x87, 0xC7,
        0x88, 0xC8,
        0x89, 0xC9,
        0x8A, 0xCA,
        0x8B, 0xCB,
        0x8C, 0xCC,
        0x8D, 0xCD,
        0x8E, 0xCE,
        0x8F, 0xCF,
        0x90, 0xD0,
        0x91, 0xD1,
        0x92, 0xD2,
        0x93, 0xD3,
        0x94, 0xD4,
        0x95, 0xD5,
        0x96, 0xD6,
        0x97, 0xD7,
        0x98, 0xD8,
        0x99, 0xD9,
        0x9A, 0xDA,
        0x9B, 0xDB,
        0x9C, 0xDC,
        0x9D, 0xDD,
        0x9E, 0xDE,
        0x9F, 0xDF,
        0xA0, 0x81,
        0xA1, 0x82,
        0xA2, 0x83,
        0xA3, 0x84,
        0xA4, 0x85,
        0xA5, 0xBD,
        0xA6, 0x86,
        0xA7, 0x87,
        0xA8, 0x88,
        0xA9, 0x89,
        0xAA, 0x8A,
        0xAB, 0x8B,
        0xAC, 0x8C,
        0xAD, 0x8D,
        0xAE, 0x8E,
        0xAF, 0x8F,
        0xB0, 0x90,
        0xB1, 0x91,
        0xB2, 0x92,
        0xB3, 0x93,
        0xB4, 0x94,
        0xB5, 0x95,
        0xB6, 0x96,
        0xB7, 0x97,
        0xB8, 0x98,
        0xB9, 0x99,
        0xBA, 0x9A,
        0xBB, 0x9B,
        0xBC, 0x9C,
        0xBD, 0x9D,
        0xBE, 0x9E,
        0xBF, 0x9F,
        0xC0, 0xA0,
        0xC1, 0xA1,
        0xC2, 0xA2,
        0xC3, 0xA3,
        0xC4, 0xA4,
        0xC5, 0xA5,
        0xC6, 0xA6,
        0xC7, 0xA7,
        0xC8, 0xA8,
        0xC9, 0xA9,
        0xCA, 0xAA,
        0xCB, 0xAB,
        0xCC, 0xAC,
        0xCD, 0xAD,
        0xCE, 0xAE,
        0xCF, 0xAF,
        0xD0, 0xB0,
        0xD1, 0xB1,
        0xD2, 0xB2,
        0xD3, 0xB3,
        0xD4, 0xB4,
        0xD5, 0xB5,
        0xD6, 0xB6,
        0xD7, 0xB7,
        0xD8, 0xB8,
        0xD9, 0xB9,
        0xDA, 0xBA,
        0xDB, 0xBB,
        0xDC, 0xBC,
        0xDD, 0xBE,
        0xDE, 0xBF,
        0xDF, 0xC0,
        0xE1, 0xE1,
        0x00, 0x00
    };

UCHAR  CollateUpdate_934[] =
    {
        0x80, 0x80,
        0x81, 0xBE,
        0x82, 0xBF,
        0x83, 0xC0,
        0x84, 0xC1,
        0x85, 0xC2,
        0x86, 0xC3,
        0x87, 0xC4,
        0x88, 0xC5,
        0x89, 0xC6,
        0x8A, 0xC7,
        0x8B, 0xC8,
        0x8C, 0xC9,
        0x8D, 0xCA,
        0x8E, 0xCB,
        0x8F, 0xCC,
        0x90, 0xCD,
        0x91, 0xCE,
        0x92, 0xCF,
        0x93, 0xD0,
        0x94, 0xD1,
        0x95, 0xD2,
        0x96, 0xD3,
        0x97, 0xD4,
        0x98, 0xD5,
        0x99, 0xD6,
        0x9A, 0xD7,
        0x9B, 0xD8,
        0x9C, 0xD9,
        0x9D, 0xDA,
        0x9E, 0xDB,
        0x9F, 0xDC,
        0xA0, 0xDD,
        0xA1, 0xDE,
        0xA2, 0xDF,
        0xA3, 0xE0,
        0xA4, 0xE1,
        0xA5, 0xE2,
        0xA6, 0xE3,
        0xA7, 0xE4,
        0xA8, 0xE5,
        0xA9, 0xE6,
        0xAA, 0xE7,
        0xAB, 0xE8,
        0xAC, 0xE9,
        0xAD, 0xEA,
        0xAE, 0xEB,
        0xAF, 0xEC,
        0xB0, 0xED,
        0xB1, 0xEE,
        0xB2, 0xEF,
        0xB3, 0xF0,
        0xB4, 0xF1,
        0xB5, 0xF2,
        0xB6, 0xF3,
        0xB7, 0xF4,
        0xB8, 0xF5,
        0xB9, 0xF6,
        0xBA, 0xF7,
        0xBB, 0xF8,
        0xBC, 0xF9,
        0xBD, 0xFA,
        0xBE, 0xFB,
        0xBF, 0xFC,
        0xC0, 0x81,
        0xC1, 0x82,
        0xC2, 0x83,
        0xC3, 0x84,
        0xC4, 0x85,
        0xC5, 0x86,
        0xC6, 0x87,
        0xC7, 0x88,
        0xC8, 0x89,
        0xC9, 0x8A,
        0xCA, 0x8B,
        0xCB, 0x8C,
        0xCC, 0x8D,
        0xCD, 0x8E,
        0xCE, 0x8F,
        0xCF, 0x90,
        0xD0, 0x91,
        0xD1, 0x92,
        0xD2, 0x93,
        0xD3, 0x94,
        0xD4, 0x95,
        0xD5, 0x96,
        0xD6, 0x97,
        0xD7, 0x98,
        0xD8, 0x99,
        0xD9, 0x9A,
        0xDA, 0x9B,
        0xDB, 0x9C,
        0xDC, 0x9D,
        0xDD, 0x9E,
        0xDE, 0x9F,
        0xDF, 0xA0,
        0xE0, 0xA1,
        0xE1, 0xA2,
        0xE2, 0xA3,
        0xE3, 0xA4,
        0xE4, 0xA5,
        0xE5, 0xA6,
        0xE6, 0xA7,
        0xE7, 0xA8,
        0xE8, 0xA9,
        0xE9, 0xAA,
        0xEA, 0xAB,
        0xEB, 0xAC,
        0xEC, 0xAD,
        0xED, 0xAE,
        0xEE, 0xAF,
        0xEF, 0xB0,
        0xF0, 0xB1,
        0xF1, 0xB2,
        0xF2, 0xB3,
        0xF3, 0xB4,
        0xF4, 0xB5,
        0xF5, 0xB6,
        0xF6, 0xB7,
        0xF7, 0xB8,
        0xF8, 0xB9,
        0xF9, 0xBA,
        0xFA, 0xBB,
        0xFB, 0xBC,
        0xFC, 0xBD,
        0x00, 0x00
    };

UCHAR  CollateUpdate_938[] =
    {
        0x80, 0x80,
        0x81, 0x81,
        0x82, 0x82,
        0x83, 0x83,
        0x84, 0x84,
        0x85, 0x85,
        0x86, 0x86,
        0x87, 0x87,
        0x88, 0x88,
        0x89, 0x89,
        0x8A, 0x8A,
        0x8B, 0x8B,
        0x8C, 0x8C,
        0x8D, 0x8D,
        0x8E, 0x8E,
        0x8F, 0x8F,
        0x90, 0x90,
        0x91, 0x91,
        0x92, 0x92,
        0x93, 0x93,
        0x94, 0x94,
        0x95, 0x95,
        0x96, 0x96,
        0x97, 0x97,
        0x98, 0x98,
        0x99, 0x99,
        0x9A, 0x9A,
        0x9B, 0x9B,
        0x9C, 0x9C,
        0x9D, 0x9D,
        0x9E, 0x9E,
        0x9F, 0x9F,
        0xA0, 0xA0,
        0xA1, 0xA1,
        0xA2, 0xA2,
        0xA3, 0xA3,
        0xA4, 0xA4,
        0xA5, 0xA5,
        0xA8, 0xA8,
        0xAD, 0xAD,
        0xAE, 0xAE,
        0xAF, 0xAF,
        0xE1, 0xE1,
        0x00, 0x00
    };

UCHAR  CollateUpdate_862[] =
    {
        0x80, 0x80,
        0x81, 0x81,
        0x82, 0x82,
        0x83, 0x83,
        0x84, 0x84,
        0x85, 0x85,
        0x86, 0x86,
        0x87, 0x87,
        0x88, 0x88,
        0x89, 0x89,
        0x8A, 0x8A,
        0x8B, 0x8B,
        0x8C, 0x8C,
        0x8D, 0x8D,
        0x8E, 0x8E,
        0x8F, 0x8F,
        0x90, 0x90,
        0x91, 0x91,
        0x92, 0x92,
        0x93, 0x93,
        0x94, 0x94,
        0x95, 0x95,
        0x96, 0x96,
        0x97, 0x97,
        0x98, 0x98,
        0x99, 0x99,
        0x9A, 0x9A,
        0x00, 0x00
    };

UCHAR  CollateUpdate_864[] =
    {
        0x80, 0x80,
        0x81, 0x81,
        0x82, 0x82,
        0x83, 0x83,
        0x84, 0x84,
        0x85, 0x85,
        0x86, 0x86,
        0x87, 0x87,
        0x88, 0x88,
        0x89, 0x89,
        0x8A, 0x8A,
        0x8B, 0x8B,
        0x8C, 0x8C,
        0x8D, 0x8D,
        0x8E, 0x8E,
        0x8F, 0x8F,
        0x90, 0x90,
        0x91, 0x91,
        0x92, 0x92,
        0x93, 0x93,
        0x94, 0x94,
        0x95, 0x95,
        0x96, 0x96,
        0x97, 0x97,
        0x98, 0x98,
        0x99, 0xE9,
        0x9A, 0xEA,
        0x9B, 0xFB,
        0x9C, 0xFF,
        0x9D, 0xEB,
        0x9E, 0xEC,
        0x9F, 0xB3,
        0xA0, 0x99,
        0xA1, 0x9A,
        0xA2, 0xB6,
        0xA3, 0x9B,
        0xA4, 0x9C,
        0xA5, 0xB8,
        0xA6, 0xFD,
        0xA7, 0xFE,
        0xA8, 0xBC,
        0xA9, 0xBD,
        0xAA, 0xC0,
        0xAB, 0xC2,
        0xAC, 0xA3,
        0xAD, 0xC4,
        0xAE, 0xC6,
        0xAF, 0xC8,
        0xB0, 0xA4,
        0xB1, 0xA5,
        0xB2, 0xA6,
        0xB3, 0xA7,
        0xB4, 0xA8,
        0xB5, 0xA9,
        0xB6, 0xAA,
        0xB7, 0xAB,
        0xB8, 0xAC,
        0xB9, 0xAD,
        0xBA, 0xE0,
        0xBB, 0xAE,
        0xBC, 0xCE,
        0xBD, 0xD0,
        0xBE, 0xD2,
        0xBF, 0xAF,
        0xC0, 0x9D,
        0xC1, 0xB4,
        0xC2, 0xB5,
        0xC3, 0xB7,
        0xC4, 0xB9,
        0xC5, 0xD9,
        0xC6, 0xBA,
        0xC7, 0xBB,
        0xC8, 0xBE,
        0xC9, 0xBF,
        0xCA, 0xC1,
        0xCB, 0xC3,
        0xCC, 0xC5,
        0xCD, 0xC7,
        0xCE, 0xC9,
        0xCF, 0xCA,
        0xD0, 0xCB,
        0xD1, 0xCC,
        0xD2, 0xCD,
        0xD3, 0xCF,
        0xD4, 0xD1,
        0xD5, 0xD3,
        0xD6, 0xD5,
        0xD7, 0xD6,
        0xD8, 0xD7,
        0xD9, 0xDA,
        0xDA, 0xDE,
        0xDB, 0x9E,
        0xDC, 0x9F,
        0xDD, 0xA0,
        0xDE, 0xA1,
        0xDF, 0xD8,
        0xE0, 0xB2,
        0xE1, 0xE1,
        0xE2, 0xE3,
        0xE3, 0xE5,
        0xE4, 0xED,
        0xE5, 0xEF,
        0xE6, 0xF1,
        0xE7, 0xF3,
        0xE8, 0xF5,
        0xE9, 0xF6,
        0xEA, 0xFA,
        0xEB, 0xD4,
        0xEC, 0xDB,
        0xED, 0xDD,
        0xEE, 0xDC,
        0xEF, 0xEE,
        0xF0, 0xB1,
        0xF1, 0xB0,
        0xF2, 0xF0,
        0xF3, 0xF2,
        0xF5, 0xF7,
        0xF6, 0xF9,
        0xF7, 0xDF,
        0xF8, 0xE2,
        0xF9, 0xE7,
        0xFA, 0xE8,
        0xFB, 0xE6,
        0xFC, 0xE4,
        0xFD, 0xF8,
        0xFE, 0xA2,
        0x00, 0x00
    };

PUCHAR  OD2_COLLATE_CP_TABLE[] =
    {
        NULL,               /*  CollateUpdate_437,  */
        CollateUpdate_850,
        CollateUpdate_860,
        CollateUpdate_863,
        CollateUpdate_865,
        CollateUpdate_932,
        CollateUpdate_934,
        CollateUpdate_938,
//#ifdef OS2SS_INCLUDE_HEBREW
        CollateUpdate_862,
//#endif
//#ifdef OS2SS_INCLUDE_ARABIC
        CollateUpdate_864,
//#endif
//#ifdef OS2SS_INCLUDE_PRCHINA
        CollateUpdate_938,
//#endif
        NULL
    };

UCHAR CollateUpdate_437LatAm[] =
    {
        0x80, 0x80,
        0x87, 0x80,
        0xA4, 0xA5,
        0xA5, 0xA5,
        0x00, 0x00
    };

UCHAR CollateUpdate_850Dutch[] =
    {
        0x86, 0x8F,
        0x8F, 0x8F,
        0x91, 0x92,
        0x92, 0x92,
        0x98, 0x98,
        0x9C, 0x9C,
        0x9F, 0x9F,
        0xA4, 0xA5,
        0xA5, 0xA5,
        0xA8, 0xA8,
        0xAD, 0xAD,
        0xAE, 0xAE,
        0xAF, 0xAF,
        0xBD, 0xBD,
        0xBE, 0xBE,
        0xCF, 0xCF,
        0xD0, 0xD1,
        0xD1, 0xD1,
        0xE1, 0xE1,
        0x00, 0x00
    };

UCHAR CollateUpdate_437Dutch[] =
    {
        0x80, 0x80,
        0x81, 0x9A,
        0x82, 0x90,
        0x84, 0x8E,
        0x86, 0x8F,
        0x87, 0x80,
        0x8E, 0x8E,
        0x8F, 0x8F,
        0x90, 0x90,
        0x91, 0x92,
        0x92, 0x92,
        0x98, 0x98,
        0x9B, 0x9B,
        0x9C, 0x9C,
        0x9D, 0x9D,
        0x9E, 0x9E,
        0x9F, 0x9F,
        0xA4, 0xA5,
        0xA5, 0xA5,
        0xA8, 0xA8,
        0xAD, 0xAD,
        0xAE, 0xAE,
        0xAF, 0xAF,
        0xE1, 0xE1,
        0x00, 0x00
    };

UCHAR CollateUpdate_850Belg[] =
    {
        0x00, 0xFF,
        0x01, 0xFF,
        0x02, 0xFF,
        0x03, 0xFF,
        0x04, 0xFF,
        0x05, 0xFF,
        0x06, 0xFF,
        0x07, 0xFF,
        0x08, 0xFF,
        0x09, 0xFF,
        0x0A, 0xFF,
        0x0B, 0xFF,
        0x0C, 0xFF,
        0x0D, 0xFF,
        0x0E, 0xFF,
        0x0F, 0xFF,
        0x10, 0xFF,
        0x11, 0xFF,
        0x12, 0xFF,
        0x13, 0xFF,
        0x14, 0xFF,
        0x15, 0xFF,
        0x16, 0xFF,
        0x17, 0xFF,
        0x18, 0xFF,
        0x19, 0xFF,
        0x1A, 0xFF,
        0x1B, 0xFF,
        0x1C, 0xFF,
        0x1D, 0xFF,
        0x1E, 0xFF,
        0x1F, 0xFF,
        0x20, 0xFF,
        0x27, 0xFF,
        0x2D, 0xFF,
        0x9C, 0x9C,
        0x9F, 0x9F,
        0xA5, 0xA4,
        0xA8, 0xA8,
        0xAD, 0xAD,
        0xAE, 0xAE,
        0xAF, 0xAF,
        0xB0, 0xFF,
        0xB1, 0xFF,
        0xB2, 0xFF,
        0xB3, 0xFF,
        0xB4, 0xFF,
        0xB9, 0xFF,
        0xBA, 0xFF,
        0xBB, 0xFF,
        0xBC, 0xFF,
        0xBD, 0xBD,
        0xBE, 0xBE,
        0xBF, 0xFF,
        0xC0, 0xFF,
        0xC1, 0xFF,
        0xC2, 0xFF,
        0xC3, 0xFF,
        0xC4, 0xFF,
        0xC5, 0xFF,
        0xC8, 0xFF,
        0xC9, 0xFF,
        0xCA, 0xFF,
        0xCB, 0xFF,
        0xCC, 0xFF,
        0xCD, 0xFF,
        0xCE, 0xFF,
        0xCF, 0xCF,
        0xD9, 0xFF,
        0xDA, 0xFF,
        0xDB, 0xFF,
        0xDC, 0xFF,
        0xDF, 0xFF,
        0xE7, 0x54,
        0xE8, 0x54,
        0xF0, 0xFF,
        0xFE, 0xFF,
        0x00, 0x00
    };

UCHAR CollateUpdate_437Belg[] =
    {
        0x00, 0xFF,
        0x01, 0xFF,
        0x02, 0xFF,
        0x03, 0xFF,
        0x04, 0xFF,
        0x05, 0xFF,
        0x06, 0xFF,
        0x07, 0xFF,
        0x08, 0xFF,
        0x09, 0xFF,
        0x0A, 0xFF,
        0x0B, 0xFF,
        0x0C, 0xFF,
        0x0D, 0xFF,
        0x0E, 0xFF,
        0x0F, 0xFF,
        0x10, 0xFF,
        0x11, 0xFF,
        0x12, 0xFF,
        0x13, 0xFF,
        0x14, 0xFF,
        0x15, 0xFF,
        0x16, 0xFF,
        0x17, 0xFF,
        0x18, 0xFF,
        0x19, 0xFF,
        0x1A, 0xFF,
        0x1B, 0xFF,
        0x1C, 0xFF,
        0x1D, 0xFF,
        0x1E, 0xFF,
        0x1F, 0xFF,
        0x20, 0xFF,
        0x27, 0xFF,
        0x2D, 0xFF,
        0x9B, 0x9B,
        0x9C, 0x9C,
        0x9D, 0x9D,
        0x9E, 0x9E,
        0x9F, 0x9F,
        0xA8, 0xA8,
        0xAD, 0xAD,
        0xAE, 0xAE,
        0xAF, 0xAF,
        0xB0, 0xFF,
        0xB1, 0xFF,
        0xB2, 0xFF,
        0xB3, 0xFF,
        0xB4, 0xFF,
        0xB5, 0xFF,
        0xB6, 0xFF,
        0xB7, 0xFF,
        0xB8, 0xFF,
        0xB9, 0xFF,
        0xBA, 0xFF,
        0xBB, 0xFF,
        0xBC, 0xFF,
        0xBD, 0xFF,
        0xBE, 0xFF,
        0xBF, 0xFF,
        0xC0, 0xFF,
        0xC1, 0xFF,
        0xC2, 0xFF,
        0xC3, 0xFF,
        0xC4, 0xFF,
        0xC5, 0xFF,
        0xC6, 0xFF,
        0xC7, 0xFF,
        0xC8, 0xFF,
        0xC9, 0xFF,
        0xCA, 0xFF,
        0xCB, 0xFF,
        0xCC, 0xFF,
        0xCD, 0xFF,
        0xCE, 0xFF,
        0xCF, 0xFF,
        0xD0, 0xFF,
        0xD1, 0xFF,
        0xD2, 0xFF,
        0xD3, 0xFF,
        0xD4, 0xFF,
        0xD5, 0xFF,
        0xD6, 0xFF,
        0xD7, 0xFF,
        0xD8, 0xFF,
        0xD9, 0xFF,
        0xDA, 0xFF,
        0xDB, 0xFF,
        0xDC, 0xFF,
        0xDD, 0xFF,
        0xDE, 0xFF,
        0xDF, 0xFF,
        0xFE, 0xFF,
        0x00, 0x00
    };

UCHAR CollateUpdate_850Swis[] =
    {
        0x00, 0xE0,
        0x01, 0xE1,
        0x02, 0xE2,
        0x03, 0xE3,
        0x04, 0xE4,
        0x05, 0xE5,
        0x06, 0xE6,
        0x07, 0xE7,
        0x08, 0xE8,
        0x09, 0xE9,
        0x0A, 0xEA,
        0x0B, 0xEB,
        0x0C, 0xEC,
        0x0D, 0xED,
        0x0E, 0xEE,
        0x0F, 0xEF,
        0x10, 0xF0,
        0x11, 0xF1,
        0x12, 0xF2,
        0x13, 0xF3,
        0x14, 0xF4,
        0x15, 0xF5,
        0x16, 0xF6,
        0x17, 0xF7,
        0x18, 0xF8,
        0x19, 0xF9,
        0x1A, 0xFA,
        0x1B, 0xFB,
        0x1C, 0xFC,
        0x1D, 0xFD,
        0x1E, 0xFE,
        0x1F, 0xFF,
        0x20, 0x00,
        0x21, 0xA5,
        0x22, 0xA8,
        0x23, 0x85,
        0x24, 0xB9,
        0x25, 0x86,
        0x26, 0x87,
        0x27, 0xA9,
        0x28, 0xAA,
        0x29, 0xAB,
        0x2A, 0x88,
        0x2B, 0x9E,
        0x2C, 0xAC,
        0x2D, 0xAE,
        0x2E, 0xAF,
        0x2F, 0xB0,
        0x30, 0x75,
        0x31, 0x76,
        0x32, 0x78,
        0x33, 0x7A,
        0x34, 0x7C,
        0x35, 0x7D,
        0x36, 0x7E,
        0x37, 0x7F,
        0x38, 0x80,
        0x39, 0x81,
        0x3A, 0xB1,
        0x3B, 0xB2,
        0x3C, 0xA0,
        0x3D, 0xA1,
        0x3E, 0xA2,
        0x3F, 0xB3,
        0x40, 0x89,
        0x41, 0x02,
        0x42, 0x12,
        0x43, 0x14,
        0x44, 0x18,
        0x45, 0x1C,
        0x46, 0x26,
        0x47, 0x28,
        0x48, 0x2A,
        0x49, 0x2C,
        0x4A, 0x37,
        0x4B, 0x39,
        0x4C, 0x3B,
        0x4D, 0x3D,
        0x4E, 0x3F,
        0x4F, 0x43,
        0x50, 0x51,
        0x51, 0x53,
        0x52, 0x55,
        0x53, 0x57,
        0x54, 0x5A,
        0x55, 0x5E,
        0x56, 0x68,
        0x57, 0x6A,
        0x58, 0x6C,
        0x59, 0x6E,
        0x5A, 0x73,
        0x5B, 0x8A,
        0x5C, 0x8B,
        0x5D, 0x8C,
        0x5E, 0xBF,
        0x5F, 0xAD,
        0x60, 0xBE,
        0x61, 0x03,
        0x62, 0x13,
        0x63, 0x15,
        0x64, 0x19,
        0x65, 0x1D,
        0x66, 0x27,
        0x67, 0x29,
        0x68, 0x2B,
        0x69, 0x38,
        0x6A, 0x2D,
        0x6B, 0x3A,
        0x6C, 0x3C,
        0x6D, 0x3E,
        0x6E, 0x40,
        0x6F, 0x44,
        0x70, 0x52,
        0x71, 0x54,
        0x72, 0x56,
        0x73, 0x58,
        0x74, 0x5B,
        0x75, 0x5F,
        0x76, 0x69,
        0x77, 0x6B,
        0x78, 0x6D,
        0x79, 0x6F,
        0x7A, 0x74,
        0x7B, 0x8E,
        0x7C, 0x8F,
        0x7D, 0x90,
        0x7E, 0xC1,
        0x7F, 0x9D,
        0x80, 0x16,
        0x81, 0x67,
        0x82, 0x1F,
        0x83, 0x09,
        0x84, 0x0B,
        0x85, 0x07,
        0x86, 0x0F,
        0x87, 0x17,
        0x88, 0x23,
        0x89, 0x25,
        0x8A, 0x21,
        0x8B, 0x35,
        0x8C, 0x33,
        0x8D, 0x31,
        0x8E, 0x0A,
        0x8F, 0x0E,
        0x90, 0x1E,
        0x91, 0x11,
        0x92, 0x10,
        0x93, 0x4A,
        0x94, 0x4C,
        0x95, 0x48,
        0x96, 0x65,
        0x97, 0x63,
        0x98, 0x72,
        0x99, 0x4B,
        0x9A, 0x66,
        0x9B, 0x50,
        0x9C, 0xB8,
        0x9E, 0xA4,
        0x9F, 0xBC,
        0xA0, 0x05,
        0xA1, 0x2F,
        0xA2, 0x46,
        0xA3, 0x61,
        0xA4, 0x42,
        0xA5, 0x41,
        0xA6, 0x95,
        0xA7, 0x94,
        0xA8, 0xB4,
        0xA9, 0x9A,
        0xAA, 0x9C,
        0xAB, 0x83,
        0xAC, 0x82,
        0xAD, 0xA6,
        0xAE, 0xB5,
        0xAF, 0xB6,
        0xB0, 0xCF,
        0xB1, 0xD0,
        0xB2, 0xD1,
        0xB3, 0xCE,
        0xB4, 0xCC,
        0xB5, 0x04,
        0xB6, 0x08,
        0xB7, 0x06,
        0xB8, 0x99,
        0xB9, 0xD2,
        0xBA, 0xD3,
        0xBB, 0xD4,
        0xBC, 0xD5,
        0xBD, 0xBA,
        0xBE, 0xBB,
        0xBF, 0xC6,
        0xC0, 0xC5,
        0xC1, 0xCA,
        0xC2, 0xC9,
        0xC3, 0xCB,
        0xC4, 0xCD,
        0xC5, 0xC8,
        0xC6, 0x0D,
        0xC7, 0x0C,
        0xC8, 0xD6,
        0xC9, 0xD7,
        0xCA, 0xD8,
        0xCB, 0xD9,
        0xCC, 0xDA,
        0xCD, 0xDB,
        0xCE, 0xDC,
        0xCF, 0xB7,
        0xD0, 0x1B,
        0xD1, 0x1A,
        0xD2, 0x22,
        0xD3, 0x24,
        0xD4, 0x20,
        0xD5, 0x36,
        0xD6, 0x2E,
        0xD7, 0x32,
        0xD8, 0x34,
        0xD9, 0xC7,
        0xDA, 0xC4,
        0xDB, 0xDF,
        0xDC, 0xDD,
        0xDD, 0x9B,
        0xDE, 0x30,
        0xDF, 0xDE,
        0xE0, 0x45,
        0xE1, 0x59,
        0xE2, 0x49,
        0xE3, 0x47,
        0xE4, 0x4E,
        0xE5, 0x4D,
        0xE6, 0x92,
        0xE7, 0x5C,
        0xE8, 0x5D,
        0xE9, 0x60,
        0xEA, 0x64,
        0xEB, 0x62,
        0xEC, 0x71,
        0xED, 0x70,
        0xEE, 0x91,
        0xEF, 0xBD,
        0xF0, 0xA7,
        0xF1, 0x9F,
        0xF2, 0x8D,
        0xF3, 0x84,
        0xF4, 0x97,
        0xF5, 0x96,
        0xF6, 0xA3,
        0xF7, 0xC2,
        0xF8, 0x93,
        0xF9, 0xC0,
        0xFA, 0xC3,
        0xFB, 0x77,
        0xFC, 0x7B,
        0xFD, 0x79,
        0xFE, 0x98,
        0xFF, 0x01,
        0x00, 0x00
    };

UCHAR CollateUpdate_437Swis[] =
    {
        0x00, 0x01,
        0x01, 0xC8,
        0x02, 0xC9,
        0x03, 0xCA,
        0x04, 0xCB,
        0x05, 0xCC,
        0x06, 0xCD,
        0x07, 0xCE,
        0x08, 0xCF,
        0x09, 0xD0,
        0x0A, 0xD1,
        0x0B, 0xD2,
        0x0C, 0xD3,
        0x0D, 0xD4,
        0x0E, 0xD5,
        0x0F, 0xD6,
        0x10, 0xD7,
        0x11, 0xD8,
        0x12, 0xD9,
        0x13, 0xDA,
        0x14, 0x8C,
        0x15, 0x8D,
        0x16, 0xDB,
        0x17, 0xDC,
        0x18, 0xDD,
        0x19, 0xDE,
        0x1A, 0xDF,
        0x1B, 0xE0,
        0x1C, 0xE1,
        0x1D, 0xE2,
        0x1E, 0xE3,
        0x1F, 0xE4,
        0x20, 0x01,
        0x21, 0x3C,
        0x22, 0x3D,
        0x23, 0x3E,
        0x24, 0x3F,
        0x25, 0x40,
        0x26, 0x41,
        0x27, 0x42,
        0x28, 0x43,
        0x29, 0x44,
        0x2A, 0x45,
        0x2B, 0x46,
        0x2C, 0x47,
        0x2D, 0x48,
        0x2E, 0x49,
        0x2F, 0x4A,
        0x30, 0x20,
        0x31, 0x21,
        0x32, 0x22,
        0x33, 0x23,
        0x34, 0x24,
        0x35, 0x25,
        0x36, 0x26,
        0x37, 0x27,
        0x38, 0x28,
        0x39, 0x29,
        0x3A, 0x4B,
        0x3B, 0x4C,
        0x3C, 0x4D,
        0x3D, 0x4E,
        0x3E, 0x4F,
        0x3F, 0x50,
        0x40, 0x51,
        0x41, 0x02,
        0x42, 0x03,
        0x43, 0x04,
        0x44, 0x05,
        0x45, 0x07,
        0x46, 0x08,
        0x47, 0x09,
        0x48, 0x0A,
        0x49, 0x0B,
        0x4A, 0x0C,
        0x4B, 0x0D,
        0x4C, 0x0E,
        0x4D, 0x0F,
        0x4E, 0x10,
        0x4F, 0x12,
        0x50, 0x13,
        0x51, 0x14,
        0x52, 0x15,
        0x53, 0x16,
        0x54, 0x18,
        0x55, 0x1A,
        0x56, 0x1B,
        0x57, 0x1C,
        0x58, 0x1D,
        0x59, 0x1E,
        0x5A, 0x1F,
        0x5B, 0x52,
        0x5C, 0x53,
        0x5D, 0x54,
        0x5E, 0x34,
        0x5F, 0x55,
        0x60, 0x33,
        0x61, 0x02,
        0x62, 0x03,
        0x63, 0x04,
        0x64, 0x05,
        0x65, 0x07,
        0x66, 0x08,
        0x67, 0x09,
        0x68, 0x0A,
        0x69, 0x0B,
        0x6A, 0x0C,
        0x6B, 0x0D,
        0x6C, 0x0E,
        0x6D, 0x0F,
        0x6E, 0x10,
        0x6F, 0x12,
        0x70, 0x13,
        0x71, 0x14,
        0x72, 0x15,
        0x73, 0x16,
        0x74, 0x18,
        0x75, 0x1A,
        0x76, 0x1B,
        0x77, 0x1C,
        0x78, 0x1D,
        0x79, 0x1E,
        0x7A, 0x1F,
        0x7B, 0x56,
        0x7C, 0x57,
        0x7D, 0x58,
        0x7E, 0x36,
        0x7F, 0x59,
        0x80, 0x04,
        0x81, 0x1A,
        0x82, 0x07,
        0x83, 0x02,
        0x84, 0x02,
        0x85, 0x02,
        0x86, 0x02,
        0x87, 0x04,
        0x88, 0x07,
        0x89, 0x07,
        0x8A, 0x07,
        0x8B, 0x0B,
        0x8C, 0x0B,
        0x8D, 0x0B,
        0x8E, 0x02,
        0x8F, 0x02,
        0x90, 0x07,
        0x91, 0x02,
        0x92, 0x02,
        0x93, 0x12,
        0x94, 0x12,
        0x95, 0x12,
        0x96, 0x1A,
        0x97, 0x1A,
        0x98, 0x1E,
        0x99, 0x12,
        0x9A, 0x1A,
        0x9B, 0x6F,
        0x9C, 0x5A,
        0x9D, 0x70,
        0x9E, 0x96,
        0x9F, 0x5C,
        0xA0, 0x02,
        0xA1, 0x0B,
        0xA2, 0x12,
        0xA3, 0x1A,
        0xA4, 0x11,
        0xA5, 0x11,
        0xA6, 0x02,
        0xA7, 0x12,
        0xA8, 0x5D,
        0xA9, 0x97,
        0xAA, 0x5F,
        0xAB, 0x60,
        0xAC, 0x61,
        0xAD, 0x62,
        0xAE, 0x63,
        0xAF, 0x64,
        0xB0, 0x65,
        0xB1, 0x66,
        0xB2, 0x67,
        0xB3, 0x68,
        0xB4, 0x69,
        0xB5, 0x98,
        0xB6, 0x99,
        0xB7, 0x9A,
        0xB8, 0x9B,
        0xB9, 0x6B,
        0xBA, 0x6C,
        0xBB, 0x6D,
        0xBC, 0x6E,
        0xBD, 0x9C,
        0xBE, 0x9D,
        0xBF, 0x71,
        0xC0, 0x72,
        0xC1, 0x73,
        0xC2, 0x74,
        0xC3, 0x75,
        0xC4, 0x76,
        0xC5, 0x77,
        0xC6, 0x9E,
        0xC7, 0x9F,
        0xC8, 0x78,
        0xC9, 0x79,
        0xCA, 0x7A,
        0xCB, 0x7B,
        0xCC, 0x7C,
        0xCD, 0x7D,
        0xCE, 0x7E,
        0xCF, 0xA0,
        0xD0, 0xA1,
        0xD1, 0xA2,
        0xD2, 0xA3,
        0xD3, 0xA4,
        0xD4, 0xA5,
        0xD5, 0xA6,
        0xD6, 0xA7,
        0xD7, 0xA8,
        0xD8, 0xA9,
        0xD9, 0x80,
        0xDA, 0x81,
        0xDB, 0x82,
        0xDC, 0x83,
        0xDD, 0xAA,
        0xDE, 0xAB,
        0xDF, 0x85,
        0xE0, 0xAC,
        0xE1, 0x17,
        0xE2, 0xAD,
        0xE3, 0xAE,
        0xE4, 0xAF,
        0xE5, 0xB0,
        0xE6, 0x86,
        0xE7, 0xB1,
        0xE8, 0xB2,
        0xE9, 0xB3,
        0xEA, 0xB4,
        0xEB, 0xB5,
        0xEC, 0xB6,
        0xED, 0xB7,
        0xEE, 0xB8,
        0xEF, 0xB9,
        0xF0, 0xBA,
        0xF1, 0x89,
        0xF2, 0xBB,
        0xF3, 0xBC,
        0xF4, 0xBD,
        0xF5, 0xBE,
        0xF6, 0x8E,
        0xF7, 0xBF,
        0xF8, 0x8F,
        0xF9, 0xC0,
        0xFA, 0x90,
        0xFB, 0xC1,
        0xFC, 0xC2,
        0xFD, 0x93,
        0xFE, 0x94,
        0xFF, 0x01,
        0x00, 0x00
    };

UCHAR CollateUpdate_850Denm[] =
    {
        0x5B, 0x28,
        0x5C, 0x2F,
        0x5D, 0x29,
        0x7B, 0x28,
        0x7C, 0x2F,
        0x7D, 0x29,
        0x81, 0x59,
        0x84, 0x5B,
        0x86, 0x5D,
        0x8E, 0x5B,
        0x8F, 0x5D,
        0x91, 0x5B,
        0x92, 0x5B,
        0x94, 0x5C,
        0x99, 0x5C,
        0x9A, 0x59,
        0x9B, 0x5C,
        0x9D, 0x5C,
        0xA6, 0x41,
        0xA7, 0x4F,
        0xE7, 0x50,
        0xE8, 0x50,
        0x00, 0x00
    };

UCHAR CollateUpdate_850Swed[] =
    {
        0x81, 0x59,
        0x84, 0x5C,
        0x86, 0x5B,
        0x8E, 0x5C,
        0x8F, 0x5B,
        0x91, 0x5C,
        0x92, 0x5C,
        0x94, 0x5D,
        0x99, 0x5D,
        0x9A, 0x59,
        0x9B, 0x5D,
        0x9D, 0x5D,
        0xE4, 0x5D,
        0xE5, 0x5D,
        0x00, 0x00
    };

UCHAR CollateUpdate_437Swed[] =
    {
        0x81, 0x59,
        0x84, 0x5C,
        0x86, 0x5B,
        0x8E, 0x5C,
        0x8F, 0x5B,
        0x91, 0x5C,
        0x92, 0x5C,
        0x94, 0x5D,
        0x99, 0x5D,
        0x9A, 0x59,
        0x00, 0x00
    };

UCHAR CollateUpdate_850Norw[] =
    {
        0x84, 0x5B,
        0x86, 0x5D,
        0x8E, 0x5B,
        0x8F, 0x5D,
        0x91, 0x5B,
        0x92, 0x5B,
        0x94, 0x5C,
        0x99, 0x5C,
        0x9A, 0x59,
        0x9B, 0x5C,
        0x9D, 0x5C,
        0xA6, 0x41,
        0xA7, 0x4F,
        0xE7, 0x50,
        0xE8, 0x50,
        0x00, 0x00
    };

UCHAR CollateUpdate_865Norw[] =
    {
        0x5B, 0x5B,
        0x5C, 0x5C,
        0x5D, 0x5D,
        0x7B, 0x7B,
        0x7C, 0x7C,
        0x7D, 0x7D,
        0x00, 0x00
    };

UCHAR CollateUpdate_850Finl[] =
    {
        0x81, 0x59,
        0x84, 0x5C,
        0x86, 0x5B,
        0x8E, 0x5C,
        0x8F, 0x5B,
        0x91, 0x5C,
        0x92, 0x5C,
        0x94, 0x5D,
        0x99, 0x5D,
        0x9A, 0x59,
        0x9B, 0x5D,
        0x9D, 0x5D,
        0x00, 0x00
    };

UCHAR CollateUpdate_437Finl[] =
    {
        0x81, 0x59,
        0x84, 0x5C,
        0x86, 0x5B,
        0x8E, 0x5C,
        0x8F, 0x5B,
        0x91, 0x5C,
        0x92, 0x5C,
        0x94, 0x5D,
        0x99, 0x5D,
        0x9A, 0x59,
        0x00, 0x00
    };

OD2_COLLATE_CTRY_ENTRY OD2_COLLATE_CTRY_TABLE[] =
    {
        {
            COUNTRY_LATIN_AMERICA,
            CODEPAGE_US,
            CollateUpdate_437LatAm
        },
        {
            CTRY_MEXICO,
            CODEPAGE_US,
            CollateUpdate_437LatAm
        },
        {
            CTRY_NETHERLANDS,
            CODEPAGE_MULTI,
            CollateUpdate_850Dutch
        },
        {
            CTRY_NETHERLANDS,
            CODEPAGE_US,
            CollateUpdate_437Dutch
        },
        {
            CTRY_BELGIUM,
            CODEPAGE_MULTI,
            CollateUpdate_850Belg
        },
        {
            CTRY_BELGIUM,
            CODEPAGE_US,
            CollateUpdate_437Belg
        },
        {
            CTRY_SPAIN,
            CODEPAGE_US,
            CollateUpdate_437LatAm
        },
        {
            CTRY_SWITZERLAND,
            CODEPAGE_MULTI,
            CollateUpdate_850Swis
        },
        {
            CTRY_SWITZERLAND,
            CODEPAGE_US,
            CollateUpdate_437Swis
        },
        {
            CTRY_DENMARK,
            CODEPAGE_MULTI,
            CollateUpdate_850Denm
        },
        {
            CTRY_SWEDEN,
            CODEPAGE_MULTI,
            CollateUpdate_850Swed
        },
        {
            CTRY_SWEDEN,
            CODEPAGE_US,
            CollateUpdate_437Swed
        },
        {
            CTRY_NORWAY,
            CODEPAGE_MULTI,
            CollateUpdate_850Norw
        },
        {
            CTRY_NORWAY,
            CODEPAGE_NORDIC,
            CollateUpdate_865Norw
        },
        {
            CTRY_FINLAND,
            CODEPAGE_MULTI,
            CollateUpdate_850Finl
        },
        {
            CTRY_FINLAND,
            CODEPAGE_US,
            CollateUpdate_437Finl
        },
        {
            0,
            0,
            NULL
        }
    };


UCHAR Od2BaseCollateTable[256] =
    {
        0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
        0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
        0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
        0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
        0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
        0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
        0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
        0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
        0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
        0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
        0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
        0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,
        0x60, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
        0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
        0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
        0x58, 0x59, 0x5A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F,
        0x43, 0x55, 0x45, 0x41, 0x41, 0x41, 0x41, 0x43,
        0x45, 0x45, 0x45, 0x49, 0x49, 0x49, 0x41, 0x41,
        0x45, 0x41, 0x41, 0x4F, 0x4F, 0x4F, 0x55, 0x55,
        0x59, 0x4F, 0x55, 0x24, 0x24, 0x24, 0x24, 0x24,
        0x41, 0x49, 0x4F, 0x55, 0x4E, 0x4E, 0xA6, 0xA7,
        0x3F, 0xA9, 0xAA, 0xAB, 0xAC, 0x21, 0x22, 0x22,
        0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7,
        0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF,
        0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,
        0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
        0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7,
        0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF,
        0xE0, 0x53, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7,
        0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
        0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
        0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF,
    };


UCHAR Od2BaseCaseMapTable[256] =
    {
        0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
        0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
        0X10, 0X11, 0X12, 0X13, 0X14, 0X15, 0X16, 0X17,
        0X18, 0X19, 0X1A, 0X1B, 0X1C, 0X1D, 0X1E, 0X1F,
        0X20, 0X21, 0X22, 0X23, 0X24, 0X25, 0X26, 0X27,
        0X28, 0X29, 0X2A, 0X2B, 0X2C, 0X2D, 0X2E, 0X2F,
        0X30, 0X31, 0X32, 0X33, 0X34, 0X35, 0X36, 0X37,
        0X38, 0X39, 0X3A, 0X3B, 0X3C, 0X3D, 0X3E, 0X3F,
        0X40, 0X41, 0X42, 0X43, 0X44, 0X45, 0X46, 0X47,
        0X48, 0X49, 0X4A, 0X4B, 0X4C, 0X4D, 0X4E, 0X4F,
        0X50, 0X51, 0X52, 0X53, 0X54, 0X55, 0X56, 0X57,
        0X58, 0X59, 0X5A, 0X5B, 0X5C, 0X5D, 0X5E, 0X5F,
        0x60, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
        0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
        0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
        0x58, 0x59, 0x5A, 0X7B, 0X7C, 0X7D, 0X7E, 0X7F,
        0X80, 0X9A, 0X45, 0X41, 0X8E, 0X41, 0X8F, 0X80,
        0X45, 0X45, 0X45, 0X49, 0X49, 0X49, 0X8E, 0X8F,
        0X90, 0X92, 0X92, 0X4F, 0X99, 0X4F, 0X55, 0X55,
        0X59, 0X99, 0X9A, 0X9B, 0X9C, 0X9D, 0X9E, 0X9F,
        0X41, 0X49, 0X4F, 0X55, 0XA5, 0XA5, 0XA6, 0XA7,
//      0X60, 0X61, 0X62, 0X63, 0X64, 0X65, 0X66, 0X67,
//      0X68, 0X69, 0X6A, 0X6B, 0X6C, 0X6D, 0X6E, 0X6F,
//      0X70, 0X71, 0X72, 0X73, 0X74, 0X75, 0X76, 0X77,
//      0X78, 0X79, 0X7A, 0X7B, 0X7C, 0X7D, 0X7E, 0X7F,
//      0X80, 0X81, 0X82, 0X83, 0X84, 0X85, 0X86, 0X87,
//      0X88, 0X89, 0X8A, 0X8B, 0X8C, 0X8D, 0X8E, 0X8F,
//      0X90, 0X91, 0X92, 0X93, 0X94, 0X95, 0X96, 0X97,
//      0X98, 0X99, 0X9A, 0X9B, 0X9C, 0X9D, 0X9E, 0X9F,
//      0XA0, 0XA1, 0XA2, 0XA3, 0XA4, 0XA5, 0XA6, 0XA7,
        0XA8, 0XA9, 0XAA, 0XAB, 0XAC, 0XAD, 0XAE, 0XAF,
        0XB0, 0XB1, 0XB2, 0XB3, 0XB4, 0XB5, 0XB6, 0XB7,
        0XB8, 0XB9, 0XBA, 0XBB, 0XBC, 0XBD, 0XBE, 0XBF,
        0XC0, 0XC1, 0XC2, 0XC3, 0XC4, 0XC5, 0XC6, 0XC7,
        0XC8, 0XC9, 0XCA, 0XCB, 0XCC, 0XCD, 0XCE, 0XCF,
        0XD0, 0XD1, 0XD2, 0XD3, 0XD4, 0XD5, 0XD6, 0XD7,
        0XD8, 0XD9, 0XDA, 0XDB, 0XDC, 0XDD, 0XDE, 0XDF,
        0XE0, 0XE1, 0XE2, 0XE3, 0XE4, 0XE5, 0XE6, 0XE7,
        0XE8, 0XE9, 0XEA, 0XEB, 0XEC, 0XED, 0XEE, 0XEF,
        0XF0, 0XF1, 0XF2, 0XF3, 0XF4, 0XF5, 0XF6, 0XF7,
        0XF8, 0XF9, 0XFA, 0XFB, 0XFC, 0XFD, 0XFE, 0XFF,
    };

/*
 *  It shows the diff between char offset and its case map
 *

UCHAR  CaseMapUpdate_437[] =
    {
        0X61, 0x41,
        0X62, 0x42,
        0X63, 0x43,
        0X64, 0x44,
        0X65, 0x45,
        0X66, 0x46,
        0X67, 0x47,
        0X68, 0x48,
        0X69, 0x49,
        0X6A, 0x4A,
        0X6B, 0x4B,
        0X6C, 0x4C,
        0X6D, 0x4D,
        0X6E, 0x4E,
        0X6F, 0x4F,
        0X70, 0x50,
        0X71, 0x51,
        0X72, 0x52,
        0X73, 0x53,
        0X74, 0x54,
        0X75, 0x55,
        0X76, 0x56,
        0X77, 0x57,
        0X78, 0x58,
        0X79, 0x59,
        0X7A, 0x5A,
        0X81, 0X9A,
        0X82, 0X45,
        0X83, 0X41,
        0X84, 0X8E,
        0X85, 0X41,
        0X86, 0X8F,
        0X87, 0X80,
        0X88, 0X45,
        0X89, 0X45,
        0X8A, 0X45,
        0X8B, 0X49,
        0X8C, 0X49,
        0X8D, 0X49,
        0X93, 0X4F,
        0X94, 0X99,
        0X95, 0X4F,
        0X96, 0X55,
        0X97, 0X55,
        0X98, 0X59,
        0XA0, 0X41,
        0XA1, 0X49,
        0XA2, 0X4F,
        0XA3, 0X55,
        0XA4, 0XA5,
        0x00, 0x00
    };
*/

UCHAR  CaseMapUpdate_850[] =
    {
        0x82, 0x90,
        0x83, 0xB6,
        0x85, 0xB7,
        0x88, 0xD2,
        0x89, 0xD3,
        0x8A, 0xD4,
        0x8B, 0xD8,
        0x8C, 0xD7,
        0x8D, 0xDE,
        0x93, 0xE2,
        0x95, 0xE3,
        0x96, 0xEA,
        0x97, 0xEB,
        0x9B, 0x9D,
        0xA0, 0xB5,
        0xA1, 0xD6,
        0xA2, 0xE0,
        0xA3, 0xE9,
        0xC6, 0xC7,
        0xD0, 0xD1,
        0xD5, 0x49,
        0xE4, 0xE5,
        0xE7, 0xE8,
        0xEC, 0xED,
        0x00, 0x00
    };

UCHAR  CaseMapUpdate_860[] =
    {
        0x82, 0x90,
        0x83, 0x8F,
        0x85, 0x91,
        0x86, 0x86,
        0x88, 0x89,
        0x89, 0x89,
        0x8A, 0x92,
        0x8B, 0x8B,
        0x8C, 0x8C,
        0x8D, 0x98,
        0x91, 0x91,
        0x93, 0x8C,
        0x95, 0xA9,
        0x96, 0x96,
        0x97, 0x9D,
        0x98, 0x98,
        0xA0, 0x86,
        0xA1, 0x8B,
        0xA2, 0x9F,
        0xA3, 0x96,
        0x00, 0x00
    };

UCHAR  CaseMapUpdate_863[] =
    {
        0x80, 0x43,
        0x81, 0x55,
        0x84, 0x41,
        0x86, 0x86,
        0x87, 0x43,
        0x8D, 0x8D,
        0x8E, 0x41,
        0x90, 0x45,
        0x91, 0x45,
        0x92, 0x45,
        0x94, 0x45,
        0x95, 0x49,
        0x98, 0x98,
        0x99, 0x4F,
        0x9A, 0x55,
        0x9D, 0x55,
        0x9E, 0x55,
        0xA0, 0xA0,
        0xA1, 0xA1,
        0xA4, 0xA4,
        0xA8, 0x49,
        0x00, 0x00
    };

UCHAR  CaseMapUpdate_865[] =
    {
        0x81, 0x9A,
        0x82, 0x90,
        0x83, 0x41,
        0x84, 0x8E,
        0x85, 0x41,
        0x86, 0x8F,
        0x87, 0x80,
        0x88, 0x45,
        0x89, 0x45,
        0x8A, 0x45,
        0x8B, 0x49,
        0x8C, 0x49,
        0x8D, 0x49,
        0x91, 0x92,
        0x93, 0x4F,
        0x94, 0x99,
        0x95, 0x4F,
        0x96, 0x55,
        0x97, 0x55,
        0x98, 0x59,
        0x9B, 0x9D,
        0xA0, 0x41,
        0xA1, 0x49,
        0xA2, 0x4F,
        0xA3, 0x55,
        0xA4, 0xA5,
        0x00, 0x00
    };

UCHAR  CaseMapUpdate_DBCS[] =
    {
        0X81, 0X81,
        0X82, 0X82,
        0X83, 0X83,
        0X84, 0X84,
        0X85, 0X85,
        0X86, 0X86,
        0X87, 0X87,
        0X88, 0X88,
        0X89, 0X89,
        0X8A, 0X8A,
        0X8B, 0X8B,
        0X8C, 0X8C,
        0X8D, 0X8D,
        0X91, 0X91,
        0X93, 0X93,
        0X94, 0X94,
        0X95, 0X95,
        0X96, 0X96,
        0X97, 0X97,
        0X98, 0X98,
        0XA0, 0XA0,
        0XA1, 0XA1,
        0XA2, 0XA2,
        0XA3, 0XA3,
        0XA4, 0XA4,
        0x00, 0x00
    };

UCHAR  CaseMapUpdate_862[] =
    {
        0x81, 0x81,
        0x82, 0x82,
        0x83, 0x83,
        0x84, 0x84,
        0x85, 0x85,
        0x86, 0x86,
        0x87, 0x87,
        0x88, 0x88,
        0x89, 0x89,
        0x8A, 0x8A,
        0x8B, 0x8B,
        0x8C, 0x8C,
        0x8D, 0x8D,
        0x91, 0x91,
        0x93, 0x93,
        0x94, 0x94,
        0x95, 0x95,
        0x96, 0x96,
        0x97, 0x97,
        0x98, 0x98,
        0x00, 0x00
    };

UCHAR  CaseMapUpdate_864[] =
    {
        0x00, 0x00
    };

PUCHAR  OD2_CASEMAP_TABLE[] =
    {
        NULL,               /*  CaseMapUpdate_437,  */
        CaseMapUpdate_850,
        CaseMapUpdate_860,
        CaseMapUpdate_863,
        CaseMapUpdate_865,
        CaseMapUpdate_DBCS,
        CaseMapUpdate_DBCS,
        CaseMapUpdate_DBCS,
//#ifdef OS2SS_INCLUDE_HEBREW
        CaseMapUpdate_862,
//#endif
//#ifdef OS2SS_INCLUDE_ARABIC
        CaseMapUpdate_864,
//#endif
//#ifdef OS2SS_INCLUDE_PRCHINA
        CaseMapUpdate_DBCS,
//#endif
        NULL
    };

UCHAR CaseMapUpdate_US[] =
    {
        0x00, 0x00
    };

UCHAR CaseMapUpdate_Belg[] =
    {
        0x82, 0x90,
        0x00, 0x00
    };

UCHAR CaseMapUpdate_Dutch[] =
    {
        0x81, 0x55,
        0x84, 0x41,
        0x8E, 0x41,
        0x90, 0x45,
        0x94, 0x4F,
        0x98, 0x98,
        0x99, 0x4F,
        0x9A, 0x55,
        0x00, 0x00
    };

PUCHAR OD2_FIX_CASEMAP_TABLE[] =
    {
        NULL,               /*  CaseMapUpdate_US,  */
        CaseMapUpdate_Belg,
        CaseMapUpdate_Dutch,
        NULL
    };
