/************************************************************************/
/*                                                                      */
/*                              MODES_M.H                               */
/*                                                                      */
/*        Aug 25  1993 (c) 1993, ATI Technologies Incorporated.         */
/************************************************************************/

/**********************       PolyTron RCS Utilities
   
  $Revision:   1.0  $
      $Date:   31 Jan 1994 11:42:30  $
	$Author:   RWOLFF  $
	   $Log:   S:/source/wnt/ms11/miniport/vcs/modes_m.h  $
 * 
 *    Rev 1.0   31 Jan 1994 11:42:30   RWOLFF
 * Initial revision.
 * 
 *    Rev 1.2   14 Jan 1994 15:23:04   RWOLFF
 * Added definitions and data for SetTextMode_m()
 * 
 *    Rev 1.1   08 Oct 1993 11:11:50   RWOLFF
 * Added "_m" to function names to identify them as being specific to the
 * 8514/A-compatible family of ATI accelerators.
 * 
 *    Rev 1.0   03 Sep 1993 14:28:44   RWOLFF
 * Initial revision.

End of PolyTron RCS section                             *****************/

#ifdef DOC
MODES_M.H - Header file for MODES_M.C

#endif


/*
 * Card-independent definitions for mode setting.
 */
#define SHOW_VGA    1   /* Display driven by VGA */
#define SHOW_ACCEL  0   /* Display driven by accelerator */

/*
 * Prototypes for mode setting functions.
 */
extern void setmode_m(struct st_mode_table *, ULONG, ULONG);
extern void Passth8514_m(int status);
extern void InitTi_8_m(WORD ext_ge_config);
extern void InitTi_16_m(WORD ext_ge_config, ULONG rom_address);
extern void InitTi_24_m(WORD ext_ge_config, ULONG rom_address);
extern void UninitTiDac_m(void);
extern void SetPalette_m(PULONG lpPalette, USHORT StartIndex, USHORT Count);
extern void SetTextMode_m(void);

/*
 * Definitions and data structures used internally by MODES_M.C
 */
#ifdef INCLUDE_MODES_M

/*
 * Red, Green, and Blue values for the default 16 colurs in VGA
 * 80x25 text mode. On the DEC ALPHA, the RGB ordering is reversed.
 */
unsigned char TextDAC_m[0x10*3] =
{
#if defined (ALPHA) || defined (_ALPHA_)
    0x00, 0x00, 0x00,   /* Black */
    0x2A, 0x00, 0x00,   /* Blue */
    0x00, 0x2A, 0x00,   /* Green */
    0x2A, 0x2A, 0x00,   /* Cyan */
    0x00, 0x00, 0x2A,   /* Red */
    0x2A, 0x00, 0x2A,   /* Magenta */
    0x00, 0x15, 0x2A,   /* Brown */
    0x2A, 0x2A, 0x2A,   /* White */
    0x15, 0x15, 0x15,   /* Grey */
    0x3F, 0x15, 0x15,   /* High intensity Blue */
    0x15, 0x3F, 0x15,   /* High intensity Green */
    0x3F, 0x3F, 0x15,   /* High intensity Cyan */
    0x15, 0x15, 0x3F,   /* High intensity Red */
    0x3F, 0x15, 0x3F,   /* High intensity Magenta */
    0x15, 0x3F, 0x3F,   /* Yellow */
    0x3F, 0x3F, 0x3F    /* High intensity White */
#else
    0x00, 0x00, 0x00,   /* Black */
    0x00, 0x00, 0x2A,   /* Blue */
    0x00, 0x2A, 0x00,   /* Green */
    0x00, 0x2A, 0x2A,   /* Cyan */
    0x2A, 0x00, 0x00,   /* Red */
    0x2A, 0x00, 0x2A,   /* Magenta */
    0x2A, 0x15, 0x00,   /* Brown */
    0x2A, 0x2A, 0x2A,   /* White */
    0x15, 0x15, 0x15,   /* Grey */
    0x15, 0x15, 0x3F,   /* High intensity Blue */
    0x15, 0x3F, 0x15,   /* High intensity Green */
    0x15, 0x3F, 0x3F,   /* High intensity Cyan */
    0x3F, 0x15, 0x15,   /* High intensity Red */
    0x3F, 0x15, 0x3F,   /* High intensity Magenta */
    0x3F, 0x3F, 0x15,   /* Yellow */
    0x3F, 0x3F, 0x3F    /* High intensity White */
#endif
};


/*
 * Indices into StdTextCRTC_m[] array
 */
#define S_PARM      5                   /* Start of sequencer parameters */
#define S_LEN       4                   /* Number of sequencer parameters */
#define MIS_PARM    S_PARM + S_LEN      /* Start of miscelaneous parameters */
#define MIS_LEN     1                   /* Number of miscelaneous parameters */
#define C_PARM      MIS_PARM + MIS_LEN  /* Start of CRTC parameters */
#define C_LEN       0x19                /* Number of CRTC parameters */
#define A_PARM      C_PARM + C_LEN      /* Start of attribute parameters */
#define A_LEN       0x14                /* Number of attribute parameters */
#define G_PARM      A_PARM + A_LEN      /* Start of Graphics parameters */
#define G_LEN       0x09                /* Number of graphics parameters */

/*
 * Values written to the standard VGA registers when switching into
 * 80x25 16 colour text mode.
 */
unsigned char StdTextCRTC_m[0x40] =
{
    0x50, 0x18, 0x10,
    0x00, 0x10,
    0x00, 0x03, 0x00, 0x02,
    0x67,
    0x5F, 0x4F, 0x50, 0x82, 0x55, 0x81, 0xBF, 0x1F,
    0x00, 0x4F, 0x0D, 0x0E, 0x00, 0x00, 0x00, 0x00,
    0x9C, 0x8E, 0x8F, 0x28, 0x1F, 0x96, 0xB9, 0xA3, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07,
    0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
    0x0C, 0x00, 0x0F, 0x08,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0E, 0x00, 0xFF
};

/*
 * Values written to the ATI extended VGA registers when switching into
 * 80x25 16 colour text mode. Within each triplet of bytes, the first
 * byte is the extended register, the second is the AND mask for the
 * contents of the register, and the third byte is the OR mask. A register
 * value of zero signals that all necessary registers have been programmed.
 */
unsigned char ExtTextCRTC_m[] =
{
    0xB0, 0xC1, 0x00,
    0xB1, 0x87, 0x00,
    0xB2, 0xBE, 0x00,
    0xB5, 0x7F, 0x00,
    0xB6, 0xE7, 0x00,
    0xB8, 0x7F, 0x40,
    0x00
};

/*
 * Font data
 */
unsigned char FontData_m[256*16] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x00 '' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x7C, 0x82, 0x82, 0xAA, 0x82, 0x82, /* 0x01 '' */
    0xC6, 0xBA, 0x82, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x7C, 0xFE, 0xFE, 0xD6, 0xFE, 0xFE, /* 0x02 '' */
    0xBA, 0xC6, 0xFE, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x6C, 0xEE, 0xFE, 0xFE, 0xFE, /* 0x03 '' */
    0xFE, 0x7C, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x10, 0x38, 0x7C, 0xFE, 0x7C, /* 0x04 '' */
    0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x10, 0x38, 0x38, 0x10, 0x6C, /* 0x05 '' */
    0xEE, 0x6C, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x10, 0x38, 0x7C, 0x7C, 0xFE, 0xFE, /* 0x06 '' */
    0xFE, 0x6C, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3C, 0x3C, /* 0x07 '' */
    0x3C, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0xC3, 0xC3, /* 0x08 '' */
    0xC3, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,

    0x00, 0x00, 0x00, 0x00, 0x18, 0x3C, 0x66, 0x66, /* 0x09 <unprintable> */
    0x66, 0x3C, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,

    0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0xC3, 0x99, 0x99, /* 0x0A '
' */
    0x99, 0xC3, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,

    0x00, 0x00, 0x1E, 0x0E, 0x1E, 0x36, 0x78, 0xCC, /* 0x0B '' */
    0xCC, 0xCC, 0xCC, 0x78, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x3C, 0x66, 0x66, 0x66, 0x3C, 0x18, /* 0x0C '' */
    0x7E, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x1E, 0x1A, 0x1E, 0x18, 0x18, 0x18, /* 0x0D <unprintable> */
    0x18, 0x78, 0xF8, 0x70, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x3E, 0x36, 0x3E, 0x36, 0x36, 0x76, /* 0x0E '' */
    0xF6, 0x66, 0x0E, 0x1E, 0x0C, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x18, 0xDB, 0x7E, 0x3C, 0x66, 0x66, /* 0x0F '' */
    0x3C, 0x7E, 0xDB, 0x18, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x80, 0xE0, 0xF0, 0xFC, 0xFE, /* 0x10 '' */
    0xFC, 0xF0, 0xE0, 0x80, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x02, 0x0E, 0x3E, 0x7E, 0xFE, /* 0x11 '' */
    0x7E, 0x3E, 0x0E, 0x02, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x18, 0x3C, 0x7E, 0x18, 0x18, 0x18, /* 0x12 '' */
    0x18, 0x7E, 0x3C, 0x18, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, /* 0x13 '' */
    0x66, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x7F, 0xDB, 0xDB, 0xDB, 0xDB, 0x7B, /* 0x14 '' */
    0x1B, 0x1B, 0x1B, 0x1B, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x7C, 0xC6, 0xC6, 0x60, 0x7C, 0xF6, /* 0x15 '' */
    0xDE, 0x7C, 0x0C, 0xC6, 0xC6, 0x7C, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x16 '' */
    0xFE, 0xFE, 0xFE, 0xFE, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x18, 0x3C, 0x7E, 0x18, 0x18, 0x18, /* 0x17 '' */
    0x7E, 0x3C, 0x18, 0x7E, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x18, 0x3C, 0x7E, 0x18, 0x18, 0x18, /* 0x18 '' */
    0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, /* 0x19 '' */
    0x18, 0x7E, 0x3C, 0x18, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0E, 0xFF, /* 0x1A '' */
    0x0E, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x70, 0xFE, /* 0x1B '' */
    0x70, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, /* 0x1C '' */
    0xC0, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x66, 0xFF, /* 0x1D '' */
    0x66, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x10, 0x38, 0x38, 0x38, 0x7C, /* 0x1E '' */
    0x7C, 0xFE, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0xFE, 0xFE, 0x7C, 0x7C, 0x7C, /* 0x1F '' */
    0x38, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x20 ' ' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x18, 0x3C, 0x3C, 0x3C, 0x3C, 0x18, /* 0x21 '!' */
    0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x36, 0x36, 0x36, 0x36, 0x14, 0x00, 0x00, /* 0x22 '"' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x6C, 0x6C, 0x6C, 0xFE, 0x6C, 0x6C, /* 0x23 '#' */
    0xFE, 0x6C, 0x6C, 0x6C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x18, 0x18, 0x7C, 0xC6, 0xC0, 0x78, /* 0x24 '$' */
    0x3C, 0x06, 0xC6, 0x7C, 0x18, 0x18, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x66, 0x0C, /* 0x25 '%' */
    0x18, 0x30, 0x66, 0xC6, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x38, 0x6C, 0x38, 0x30, 0x76, 0x7E, /* 0x26 '&' */
    0xCC, 0xCC, 0xCC, 0x76, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x0C, 0x0C, 0x0C, 0x18, 0x00, 0x00, 0x00, /* 0x27 ''' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x0C, 0x18, 0x30, 0x30, 0x30, 0x30, /* 0x28 '(' */
    0x30, 0x30, 0x18, 0x0C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x30, 0x18, 0x0C, 0x0C, 0x0C, 0x0C, /* 0x29 ')' */
    0x0C, 0x0C, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x38, 0xFE, /* 0x2A '*' */
    0x38, 0x6C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7E, /* 0x2B '+' */
    0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x2C ',' */
    0x00, 0x0C, 0x0C, 0x0C, 0x18, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, /* 0x2D '-' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x2E '.' */
    0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0C, 0x18, /* 0x2F '/' */
    0x30, 0x60, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xD6, 0xD6, /* 0x30 '0' */
    0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x18, 0x78, 0x18, 0x18, 0x18, 0x18, /* 0x31 '1' */
    0x18, 0x18, 0x18, 0x7E, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x7C, 0xC6, 0xC6, 0x06, 0x0C, 0x18, /* 0x32 '2' */
    0x30, 0x60, 0xC6, 0xFE, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x7C, 0xC6, 0x06, 0x06, 0x3C, 0x06, /* 0x33 '3' */
    0x06, 0x06, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x0C, 0x1C, 0x3C, 0x6C, 0xCC, 0xCC, /* 0x34 '4' */
    0xFE, 0x0C, 0x0C, 0x1E, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xFE, 0xC0, 0xC0, 0xC0, 0xFC, 0x06, /* 0x35 '5' */
    0x06, 0x06, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x7C, 0xC6, 0xC0, 0xC0, 0xFC, 0xC6, /* 0x36 '6' */
    0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xFE, 0xC6, 0x06, 0x0C, 0x18, 0x30, /* 0x37 '7' */
    0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0x7C, 0xC6, /* 0x38 '8' */
    0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0x7E, /* 0x39 '9' */
    0x06, 0x06, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x00, /* 0x3A ':' */
    0x00, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x00, /* 0x3B ';' */
    0x00, 0x0C, 0x0C, 0x0C, 0x18, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x0C, 0x18, 0x30, 0x60, 0xC0, /* 0x3C '<' */
    0x60, 0x30, 0x18, 0x0C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, /* 0x3D '=' */
    0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x60, 0x30, 0x18, 0x0C, 0x06, /* 0x3E '>' */
    0x0C, 0x18, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x7C, 0xC6, 0xC6, 0x0C, 0x18, 0x18, /* 0x3F '?' */
    0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xDE, 0xDE, /* 0x40 '@' */
    0xDE, 0xDC, 0xC0, 0x7E, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x38, 0x6C, 0xC6, 0xC6, 0xC6, 0xFE, /* 0x41 'A' */
    0xC6, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xFC, 0x66, 0x66, 0x66, 0x7C, 0x66, /* 0x42 'B' */
    0x66, 0x66, 0x66, 0xFC, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x3C, 0x66, 0xC2, 0xC0, 0xC0, 0xC0, /* 0x43 'C' */
    0xC0, 0xC2, 0x66, 0x3C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xF8, 0x6C, 0x66, 0x66, 0x66, 0x66, /* 0x44 'D' */
    0x66, 0x66, 0x6C, 0xF8, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xFE, 0x66, 0x60, 0x64, 0x7C, 0x64, /* 0x45 'E' */
    0x60, 0x60, 0x66, 0xFE, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xFE, 0x66, 0x60, 0x64, 0x7C, 0x64, /* 0x46 'F' */
    0x60, 0x60, 0x60, 0xF0, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC0, 0xC0, 0xC0, /* 0x47 'G' */
    0xCE, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xFE, 0xC6, /* 0x48 'H' */
    0xC6, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x3C, 0x18, 0x18, 0x18, 0x18, 0x18, /* 0x49 'I' */
    0x18, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x3C, 0x18, 0x18, 0x18, 0x18, 0x18, /* 0x4A 'J' */
    0x18, 0xD8, 0xD8, 0x70, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xC6, 0xC6, 0xCC, 0xD8, 0xF0, 0xF0, /* 0x4B 'K' */
    0xD8, 0xCC, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xF0, 0x60, 0x60, 0x60, 0x60, 0x60, /* 0x4C 'L' */
    0x60, 0x62, 0x66, 0xFE, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xC6, 0xC6, 0xEE, 0xEE, 0xFE, 0xD6, /* 0x4D 'M' */
    0xD6, 0xD6, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xC6, 0xC6, 0xE6, 0xE6, 0xF6, 0xDE, /* 0x4E 'N' */
    0xCE, 0xCE, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, /* 0x4F 'O' */
    0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xFC, 0x66, 0x66, 0x66, 0x66, 0x7C, /* 0x50 'P' */
    0x60, 0x60, 0x60, 0xF0, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, /* 0x51 'Q' */
    0xC6, 0xD6, 0xD6, 0x7C, 0x06, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xFC, 0x66, 0x66, 0x66, 0x7C, 0x78, /* 0x52 'R' */
    0x6C, 0x66, 0x66, 0xE6, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x7C, 0xC6, 0xC0, 0xC0, 0x70, 0x1C, /* 0x53 'S' */
    0x06, 0x06, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x7E, 0x5A, 0x18, 0x18, 0x18, 0x18, /* 0x54 'T' */
    0x18, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, /* 0x55 'U' */
    0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, /* 0x56 'V' */
    0xC6, 0x6C, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xC6, 0xC6, 0xC6, 0xD6, 0xD6, 0xD6, /* 0x57 'W' */
    0xFE, 0xEE, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xC6, 0xC6, 0xC6, 0x6C, 0x38, 0x38, /* 0x58 'X' */
    0x6C, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3C, /* 0x59 'Y' */
    0x18, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xFE, 0xC6, 0x86, 0x0C, 0x18, 0x30, /* 0x5A 'Z' */
    0x60, 0xC2, 0xC6, 0xFE, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x7C, 0x60, 0x60, 0x60, 0x60, 0x60, /* 0x5B '[' */
    0x60, 0x60, 0x60, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x80, 0xC0, 0x60, 0x30, /* 0x5C '\' */
    0x18, 0x0C, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x7C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, /* 0x5D ']' */
    0x0C, 0x0C, 0x0C, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x10, 0x38, 0x6C, 0xC6, 0x00, 0x00, 0x00, /* 0x5E '^' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x5F '_' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,

    0x00, 0x18, 0x18, 0x18, 0x0C, 0x00, 0x00, 0x00, /* 0x60 '`' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x0C, 0x7C, /* 0x61 'a' */
    0xCC, 0xCC, 0xDC, 0x76, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xE0, 0x60, 0x60, 0x7C, 0x66, 0x66, /* 0x62 'b' */
    0x66, 0x66, 0x66, 0xFC, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xC6, 0xC0, /* 0x63 'c' */
    0xC0, 0xC0, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x1C, 0x0C, 0x0C, 0x7C, 0xCC, 0xCC, /* 0x64 'd' */
    0xCC, 0xCC, 0xCC, 0x7E, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xC6, 0xC6, /* 0x65 'e' */
    0xFE, 0xC0, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x1C, 0x36, 0x30, 0x30, 0xFC, 0x30, /* 0x66 'f' */
    0x30, 0x30, 0x30, 0x78, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xCE, 0xC6, /* 0x67 'g' */
    0xC6, 0xCE, 0x76, 0x06, 0xC6, 0x7C, 0x00, 0x00,

    0x00, 0x00, 0xE0, 0x60, 0x60, 0x7C, 0x66, 0x66, /* 0x68 'h' */
    0x66, 0x66, 0x66, 0xE6, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x18, 0x18, 0x00, 0x38, 0x18, 0x18, /* 0x69 'i' */
    0x18, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x0C, 0x0C, 0x00, 0x1C, 0x0C, 0x0C, /* 0x6A 'j' */
    0x0C, 0x0C, 0x0C, 0xCC, 0xCC, 0x78, 0x00, 0x00,

    0x00, 0x00, 0xE0, 0x60, 0x60, 0x66, 0x66, 0x6C, /* 0x6B 'k' */
    0x78, 0x6C, 0x66, 0xE6, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, /* 0x6C 'l' */
    0x18, 0x18, 0x18, 0x1C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0xFE, 0xD6, /* 0x6D 'm' */
    0xD6, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0xDC, 0x66, 0x66, /* 0x6E 'n' */
    0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xC6, 0xC6, /* 0x6F 'o' */
    0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0xDC, 0x66, 0x66, /* 0x70 'p' */
    0x66, 0x66, 0x7C, 0x60, 0x60, 0xF0, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xCC, 0xCC, /* 0x71 'q' */
    0xCC, 0xCC, 0x7C, 0x0C, 0x0C, 0x1E, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0xDC, 0x66, 0x60, /* 0x72 'r' */
    0x60, 0x60, 0x60, 0xF0, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xC6, 0xC0, /* 0x73 's' */
    0x7C, 0x06, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x30, 0x30, 0x30, 0xFC, 0x30, 0x30, /* 0x74 't' */
    0x30, 0x30, 0x36, 0x1C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0xCC, 0xCC, 0xCC, /* 0x75 'u' */
    0xCC, 0xCC, 0xCC, 0x76, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0xC6, 0xC6, /* 0x76 'v' */
    0xC6, 0x6C, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0xC6, 0xD6, /* 0x77 'w' */
    0xD6, 0xD6, 0xFE, 0x6C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0xC6, 0x6C, /* 0x78 'x' */
    0x38, 0x6C, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0xC6, 0xC6, /* 0x79 'y' */
    0xC6, 0xCE, 0x76, 0x06, 0xC6, 0x7C, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x86, 0x0C, /* 0x7A 'z' */
    0x18, 0x30, 0x62, 0xFE, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x0E, 0x18, 0x18, 0x18, 0x70, 0x18, /* 0x7B '{' */
    0x18, 0x18, 0x18, 0x0E, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, /* 0x7C '|' */
    0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x70, 0x18, 0x18, 0x18, 0x0E, 0x18, /* 0x7D '}' */
    0x18, 0x18, 0x18, 0x70, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x76, 0xDC, 0x00, 0x00, 0x00, 0x00, /* 0x7E '~' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x38, /* 0x7F '' */
    0x6C, 0x6C, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x3C, 0x66, 0xC0, 0xC0, 0xC0, 0xC6, /* 0x80 '' */
    0x66, 0x3C, 0x18, 0x0C, 0xCC, 0x38, 0x00, 0x00,

    0x00, 0x00, 0xC6, 0x00, 0x00, 0xC6, 0xC6, 0xC6, /* 0x81 '' */
    0xC6, 0xC6, 0xCE, 0x76, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x0C, 0x18, 0x30, 0x00, 0x7C, 0xC6, 0xC6, /* 0x82 '' */
    0xFE, 0xC0, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x30, 0x78, 0xCC, 0x00, 0x78, 0x0C, 0x7C, /* 0x83 '' */
    0xCC, 0xCC, 0xDC, 0x76, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xCC, 0x00, 0x00, 0x78, 0x0C, 0x7C, /* 0x84 '' */
    0xCC, 0xCC, 0xDC, 0x76, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x60, 0x30, 0x18, 0x00, 0x78, 0x0C, 0x7C, /* 0x85 '' */
    0xCC, 0xCC, 0xDC, 0x76, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x38, 0x6C, 0x38, 0x00, 0x78, 0x0C, 0x7C, /* 0x86 '' */
    0xCC, 0xCC, 0xDC, 0x76, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x7C, 0xC6, 0xC0, 0xC0, /* 0x87 '' */
    0xC6, 0x7C, 0x18, 0x0C, 0x6C, 0x38, 0x00, 0x00,

    0x00, 0x30, 0x78, 0xCC, 0x00, 0x7C, 0xC6, 0xC6, /* 0x88 '' */
    0xFE, 0xC0, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xCC, 0x00, 0x00, 0x7C, 0xC6, 0xC6, /* 0x89 '' */
    0xFE, 0xC0, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x30, 0x18, 0x0C, 0x00, 0x7C, 0xC6, 0xC6, /* 0x8A '' */
    0xFE, 0xC0, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x66, 0x00, 0x00, 0x38, 0x18, 0x18, /* 0x8B '' */
    0x18, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x18, 0x3C, 0x66, 0x00, 0x38, 0x18, 0x18, /* 0x8C '' */
    0x18, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x60, 0x30, 0x18, 0x00, 0x38, 0x18, 0x18, /* 0x8D '' */
    0x18, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0xC6, 0x00, 0x38, 0x6C, 0xC6, 0xC6, 0xC6, /* 0x8E '' */
    0xFE, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00,

    0x38, 0x6C, 0x38, 0x00, 0x38, 0x6C, 0xC6, 0xC6, /* 0x8F '' */
    0xFE, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00,

    0x0C, 0x18, 0x30, 0x00, 0xFE, 0x60, 0x60, 0x7C, /* 0x90 '' */
    0x60, 0x60, 0x60, 0xFE, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x66, 0xDB, 0x1B, 0x7F, /* 0x91 '' */
    0xD8, 0xD8, 0xDF, 0x76, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x7E, 0xD8, 0xD8, 0xD8, 0xD8, 0xFE, /* 0x92 '' */
    0xd8, 0xD8, 0xD8, 0xDE, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x30, 0x78, 0xCC, 0x00, 0x7C, 0xC6, 0xC6, /* 0x93 '' */
    0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xC6, 0x00, 0x00, 0x7C, 0xC6, 0xC6, /* 0x94 '' */
    0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x30, 0x18, 0x0C, 0x00, 0x7C, 0xC6, 0xC6, /* 0x95 '' */
    0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x30, 0x78, 0xCC, 0x00, 0xC6, 0xC6, 0xC6, /* 0x96 '' */
    0xC6, 0xC6, 0xCE, 0x76, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x60, 0x30, 0x18, 0x00, 0xC6, 0xC6, 0xC6, /* 0x97 '' */
    0xC6, 0xC6, 0xCE, 0x76, 0x00, 0x00, 0x00, 0x00,

    0x00, 0xC6, 0x00, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, /* 0x98 '' */
    0xCE, 0x76, 0x06, 0x06, 0xC6, 0x7C, 0x00, 0x00,

    0x00, 0xC6, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6, /* 0x99 '' */
    0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0xC6, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, /* 0x9A '' */
    0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x18, 0x18, 0x7C, 0xC6, 0xC0, 0xC0, /* 0x9B '' */
    0xC6, 0x7C, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x38, 0x6C, 0x60, 0x60, 0xF0, 0x60, 0x60, /* 0x9C '' */
    0x60, 0x66, 0xF6, 0x6C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x18, 0x7E, /* 0x9D '' */
    0x18, 0x3C, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,

    0x00, 0xFC, 0xC6, 0xC6, 0xFC, 0xC0, 0xCC, 0xDE, /* 0x9E '' */
    0xCC, 0xCC, 0xCC, 0xC6, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x0E, 0x1B, 0x18, 0x18, 0x18, 0x7E, 0x18, /* 0x9F '' */
    0x18, 0x18, 0x18, 0x18, 0xD8, 0x70, 0x00, 0x00,

    0x00, 0x0C, 0x18, 0x30, 0x00, 0x78, 0x0C, 0x7C, /* 0xA0 '' */
    0xCC, 0xCC, 0xDC, 0x76, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x0C, 0x18, 0x30, 0x00, 0x38, 0x18, 0x18, /* 0xA1 '' */
    0x18, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x0C, 0x18, 0x30, 0x00, 0x7C, 0xC6, 0xC6, /* 0xA2 '' */
    0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x18, 0x30, 0x60, 0x00, 0xCC, 0xCC, 0xCC, /* 0xA3 '' */
    0xCC, 0xCC, 0xDC, 0x76, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x76, 0xDC, 0x00, 0xBC, 0x66, 0x66, /* 0xA4 '' */
    0x66, 0x66, 0x66, 0xE6, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x76, 0xBC, 0x00, 0xC6, 0xC6, 0xE6, 0xF6, /* 0xA5 '' */
    0xDE, 0xCE, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x3C, 0x6C, 0x6C, 0x3E, 0x00, 0x7E, 0x00, /* 0xA6 '' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x38, 0x6C, 0x6C, 0x38, 0x00, 0x7E, 0x00, /* 0xA7 '' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x30, /* 0xA8 '' */
    0x60, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, /* 0xA9 '' */
    0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, /* 0xAA '' */
    0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x60, 0x60, 0x62, 0x66, 0x6C, 0x18, 0x30, /* 0xAB '' */
    0x60, 0xDC, 0x36, 0x0C, 0x18, 0x3E, 0x00, 0x00,

    0x00, 0x60, 0x60, 0x62, 0x66, 0x6C, 0x18, 0x36, /* 0xAC '' */
    0x6E, 0xDE, 0x36, 0x7E, 0x06, 0x06, 0x00, 0x00,

    0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x3C, /* 0xAD '' */
    0x3C, 0x3C, 0x3C, 0x18, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x6C, 0xD8, /* 0xAE '' */
    0x6C, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0x6C, 0x36, /* 0xAF '' */
    0x6C, 0xD8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, /* 0xB0 '' */
    0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44,

    0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, /* 0xB1 '' */
    0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55,

    0xDD, 0x77, 0xDD, 0x77, 0xDD, 0x77, 0xDD, 0x77, /* 0xB2 '' */
    0xDD, 0x77, 0xDD, 0x77, 0xDD, 0x77, 0xDD, 0x77,

    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, /* 0xB3 '' */
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,

    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF8, /* 0xB4 '' */
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,

    0x18, 0x18, 0x18, 0x18, 0x18, 0xF8, 0x18, 0xF8, /* 0xB5 '' */
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,

    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xF6, /* 0xB6 '' */
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, /* 0xB7 '' */
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,

    0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x18, 0xF8, /* 0xB8 '' */
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,

    0x36, 0x36, 0x36, 0x36, 0x36, 0xF6, 0x36, 0xF6, /* 0xB9 '' */
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,

    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, /* 0xBA '' */
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,

    0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x06, 0xF6, /* 0xBB '' */
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,

    0x36, 0x36, 0x36, 0x36, 0x36, 0xF6, 0x06, 0xFE, /* 0xBC '' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xFE, /* 0xBD '' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x18, 0x18, 0x18, 0x18, 0x18, 0xF8, 0x18, 0xF8, /* 0xBE '' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, /* 0xBF '' */
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,

    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1F, /* 0xC0 '' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xFF, /* 0xC1 '' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, /* 0xC2 '' */
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,

    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1F, /* 0xC3 '' */
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, /* 0xC4 '' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xFF, /* 0xC5 '' */
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,

    0x18, 0x18, 0x18, 0x18, 0x18, 0x1F, 0x18, 0x1F, /* 0xC6 '' */
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,

    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, /* 0xC7 '' */
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,

    0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 0x30, 0x3F, /* 0xC8 '' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x30, 0x37, /* 0xC9 '' */
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,

    0x36, 0x36, 0x36, 0x36, 0x36, 0xF7, 0x00, 0xFF, /* 0xCA '' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xF7, /* 0xCB '' */
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,

    0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 0x30, 0x37, /* 0xCC '' */
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,

    0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, /* 0xCD '' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x36, 0x36, 0x36, 0x36, 0x36, 0xF7, 0x00, 0xF7, /* 0xCE '' */
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,

    0x18, 0x18, 0x18, 0x18, 0x18, 0xFF, 0x00, 0xFF, /* 0xCF '' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xFF, /* 0xD0 '' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, /* 0xD1 '' */
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, /* 0xD2 '' */
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,

    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x3F, /* 0xD3 '' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x18, 0x18, 0x18, 0x18, 0x18, 0x1F, 0x18, 0x1F, /* 0xD4 '' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x18, 0x1F, /* 0xD5 '' */
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, /* 0xD6 '' */
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,

    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xFF, /* 0xD7 '' */
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,

    0x18, 0x18, 0x18, 0x18, 0x18, 0xFF, 0x18, 0xFF, /* 0xD8 '' */
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,

    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF8, /* 0xD9 '' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, /* 0xDA '' */
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,

    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, /* 0xDB '' */
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0xDC '' */
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,

    0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, /* 0xDD '' */
    0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0,

    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, /* 0xDE '' */
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,

    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, /* 0xDF '' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x76, 0xDC, 0xD8, 0xD8, /* 0xE0 '' */
    0xD8, 0xD8, 0xDC, 0x76, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x78, 0xCC, 0xCC, 0xD8, 0xFC, 0xC6, /* 0xE1 '' */
    0xC6, 0xC6, 0xC6, 0xCC, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xFE, 0x66, 0x62, 0x60, 0x60, 0x60, /* 0xE2 '' */
    0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x6C, 0x6C, /* 0xE3 '' */
    0x6C, 0x6C, 0x6C, 0x6C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xFE, 0xC6, 0x62, 0x30, 0x18, 0x18, /* 0xE4 '' */
    0x30, 0x62, 0xC6, 0xFE, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0xD8, 0xCC, /* 0xE5 '' */
    0xCC, 0xCC, 0xD8, 0x70, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, /* 0xE6 '' */
    0x66, 0x7C, 0x60, 0xC0, 0x80, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xDC, 0x18, /* 0xE7 '' */
    0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xFE, 0x38, 0x38, 0x6C, 0xC6, 0xC6, /* 0xE8 '' */
    0x6C, 0x38, 0x38, 0xFE, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x38, 0x6C, 0xC6, 0xC6, 0xFE, /* 0xE9 '' */
    0xC6, 0xC6, 0x6C, 0x38, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x38, 0x6C, 0xC6, 0xC6, 0xC6, 0xC6, /* 0xEA '' */
    0x6C, 0x6C, 0x6C, 0xEE, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x3E, 0x60, 0x60, 0x3C, 0x66, 0xC6, /* 0xEB '' */
    0xC6, 0xC6, 0xCC, 0x78, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0xDB, 0xDB, /* 0xEC '' */
    0xDB, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x02, 0x06, 0x7C, 0xCE, 0xDE, 0xF6, /* 0xED '' */
    0xF6, 0x7C, 0x60, 0xC0, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x1C, 0x30, 0x60, 0x60, 0x7C, /* 0xEE '' */
    0x60, 0x60, 0x30, 0x1C, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, /* 0xEF '' */
    0xC6, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0xFE, /* 0xF0 '' */
    0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7E, 0x18, /* 0xF1 '' */
    0x18, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x30, 0x18, 0x0C, 0x06, 0x0C, 0x18, /* 0xF2 '' */
    0x30, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x0C, 0x18, 0x30, 0x60, 0x30, 0x18, /* 0xF3 '' */
    0x0C, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x0C, 0x1E, 0x1A, 0x18, /* 0xF4 '' */
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,

    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, /* 0xF5 '' */
    0x18, 0x18, 0x58, 0x78, 0x30, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x7E, /* 0xF6 '' */
    0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xDC, /* 0xF7 '' */
    0x00, 0x76, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x78, 0xCC, 0xCC, 0x78, 0x00, 0x00, /* 0xF8 '' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, /* 0xF9 '' */
    0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0xFA '' */
    0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x1F, 0x18, 0x18, 0x18, 0x18, 0x18, /* 0xFB '' */
    0xD8, 0xD8, 0x78, 0x38, 0x18, 0x00, 0x00, 0x00,

    0x00, 0x00, 0xD8, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, /* 0xFC '' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x70, 0xD8, 0x18, 0x30, 0x60, 0xF8, /* 0xFD '' */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x7E, 0x7E, /* 0xFE '' */
    0x7E, 0x7E, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0xFF ''*/
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#endif

