/*++

Copyright (c) 1991 Microsoft Corporation

Module Name:

    ws.h

Abstract:

    Private header file for the NT Workstation service included by every
    module of the Workstation service.

Author:

    Rita Wong (ritaw) 15-Feb-1991

Revision History:

--*/

#ifndef _WS_INCLUDED_
#define _WS_INCLUDED_


#include <nt.h>                   // NT definitions
#include <ntrtl.h>                // NT runtime library definitions
#include <nturtl.h>

#include <windef.h>               // Win32 type definitions
#include <winbase.h>              // Win32 base API prototypes
#include <winsvc.h>               // Win32 service control APIs

#include <lmcons.h>               // LAN Manager common definitions
#include <lmerr.h>                // LAN Manager network error definitions
#include <lmsname.h>              // LAN Manager service names
#include <lmapibuf.h>             // NetApiBufferFree

#include <netlib.h>               // LAN Man utility routines
#include <netlibnt.h>             // NetpNtStatusToApiStatus
#include <netdebug.h>             // NetpDbgPrint
#include <tstring.h>              // Transitional string functions
#include <icanon.h>               // I_Net canonicalize functions
#include <align.h>                // ROUND_UP_COUNT macro

#include <rpc.h>                  // DataTypes and runtime APIs
#include <rpcutil.h>              // Prototypes for MIDL user functions
#include <wkssvc.h>               // Generated by the MIDL complier


//
// Debug trace level bits for turning on/off trace statements in the
// Workstation service
//

//
// NetWksta[Get|Set]Info APIs
//
#define WKSTA_DEBUG_INFO         0x00000001

//
// NetWkstaUser APIs
//
#define WKSTA_DEBUG_USER         0x00000002

//
// NetUse APIs
//
#define WKSTA_DEBUG_USE          0x00000004

//
// NetAlert APIs
//
#define WKSTA_DEBUG_ALERT        0x00000008

//
// NetServerEnum
//
#define WKSTA_DEBUG_SERVER_ENUM  0x00000010

//
// Utility trace statements
//
#define WKSTA_DEBUG_UTIL         0x00000020

//
// Configuration trace statements
//
#define WKSTA_DEBUG_CONFIG       0x00000040

//
// Main service functionality
//
#define WKSTA_DEBUG_MAIN         0x00000080

//
// NetMessageBufferSend
//
#define WKSTA_DEBUG_MESSAGE      0x00000100

//
// Logon support trace statements
//
#define WKSTA_DEBUG_LOGON        0x00000200

//
// All debug flags on
//
#define WKSTA_DEBUG_ALL          0xFFFFFFFF


#if DBG

#define STATIC

extern DWORD WorkstationTrace;

#define DEBUG if (TRUE)

#define IF_DEBUG(Function) if (WorkstationTrace & WKSTA_DEBUG_ ## Function)

#else

#define STATIC static

#define DEBUG if (FALSE)

#define IF_DEBUG(Function) if (FALSE)

#endif // DBG


#endif // ifdef _WS_INCLUDED_
