/*++

Copyright (c) 1991-1993  Microsoft Corporation

Module Name:

    ReplBind.c

Abstract:

    Routines which use RPC to bind and unbind the client to the replicator
    service.

Author:

    John Rogers (JohnRo) 16-Jan-1992

Environment:

    User Mode -Win32

Revision History:

    16-Jan-1992 JohnRo
        Created the repl service RPC stuff from Rita's workstation RPC stuff.
        I'm just going to use identify handles if possible.
    23-Jan-1992 JohnRo
        Correct calls to NetpBindRpc.
    27-Jan-1992 JohnRo
        Changed to use LPTSTR etc.
    30-Jan-1992 JohnRo
        Made changes suggested by PC-LINT.
    05-Feb-1992 JohnRo
        Changes required by new RPC.
    08-Apr-1992 JohnRo
        Fixed UNICODE handling.
    08-Aug-1992 JohnRo
        RAID 2252 (old 9963): repl should prevent export on Windows/NT.
    16-Dec-1992 JohnRo
        Made changes suggested by PC-LINT 5.0
        Added some IN and OUT keywords.
    30-Apr-1993 JohnRo
        Use NetpKdPrint() where possible.
        Use PREFIX_ equates.

--*/


// These must be included first:

#include <windef.h>     // IN, DWORD, etc.
#include <rpc.h>        // Needed by <repl.h>
#include <lmcons.h>     // Needed by <lmapibuf.h>

// These may be included in any order:

#include <netdebug.h>   // NetpKdPrint(), FORMAT_ equates.
#include <prefix.h>     // PREFIX_ equates.
#include <repl.h>       // Generated by MIDL compiler.
#include <repldefs.h>   // IF_DEBUG(), etc.
#include <replname.h>   // REPLICATOR_INTERFACE_NAME.
#include <rpcutil.h>    // NetpBindRpc(), etc.


// Define this for ifdef'ed code below.
#define IMPERSONATE_FOR_ALL_APIS



#if 0

handle_t
REPL_IMPERSONATE_HANDLE_bind(
    IN REPL_IMPERSONATE_HANDLE ServerName
    )

/*++

Routine Description:

    This routine is called from the replicator service client stubs when
    it is necessary create an RPC binding to the server end with
    impersonation level of impersonation.

Arguments:

    ServerName - A pointer to a string containing the name of the server
        to bind with.

Return Value:

    The binding handle is returned to the stub routine.  If the bind is
    unsuccessful, a NULL will be returned.

--*/
{
    handle_t BindHandle;
    RPC_STATUS RpcStatus;

    IF_DEBUG( DLLSTUB ) {
        NetpKdPrint(( PREFIX_REPL
                "REPL_IMPERSONATE_HANDLE_bind: server name " FORMAT_LPTSTR
                ".\n", ServerName ? ServerName : (LPTSTR) TEXT("--NONE--") ));
    }

    RpcStatus = NetpBindRpc (
                    ServerName,
                    REPLICATOR_INTERFACE_NAME,
                    (LPTSTR) TEXT("Security=Impersonation Static True"),
                    &BindHandle
                    );

    if (RpcStatus != RPC_S_OK) {
        NetpKdPrint(( PREFIX_REPL
                "REPL_IMPERSONATE_HANDLE_bind failed: " FORMAT_NTSTATUS "\n",
                RpcStatus ));
    }

    return BindHandle;
}

#endif // 0


handle_t
REPL_IDENTIFY_HANDLE_bind(
    IN REPL_IDENTIFY_HANDLE ServerName
    )

/*++

Routine Description:

    This routine is called from the replicator service client stubs when
    it is necessary create an RPC binding to the server end with
    identification level of impersonation.

Arguments:

    ServerName - A pointer to a string containing the name of the server
        to bind with.

Return Value:

    The binding handle is returned to the stub routine.  If the bind is
    unsuccessful, a NULL will be returned.

--*/
{
    handle_t BindHandle;
    RPC_STATUS RpcStatus;

    IF_DEBUG( DLLSTUB ) {
        LPTSTR DebugServerName;
        LPSTR DebugText;

        if (ServerName != NULL) {
            DebugServerName = ServerName;
        } else {
            DebugServerName = (LPTSTR) TEXT("--NONE--");
        }

        DebugText = PREFIX_REPL "REPL_IDENTIFY_HANDLE_bind: "
#ifndef IMPERSONATE_FOR_ALL_APIS
                "(identify) "
#else
                "(really impersonate) "
#endif
                "server name " FORMAT_LPTSTR ".\n";

        NetpKdPrint((
                DebugText,
                DebugServerName ));
    }

    RpcStatus = NetpBindRpc (
                    ServerName,
                    REPLICATOR_INTERFACE_NAME,
#ifndef IMPERSONATE_FOR_ALL_APIS
                    (LPTSTR) TEXT("Security=Identification Static True"),
#else
                    (LPTSTR) TEXT("Security=Impersonation Static True"),
#endif
                    &BindHandle
                    );

    if (RpcStatus != RPC_S_OK) {
        NetpKdPrint(( PREFIX_REPL
                "REPL_IDENTIFY_HANDLE_bind failed: " FORMAT_NTSTATUS "\n",
                RpcStatus ));
    }

    return BindHandle;
}



#if 0

void
REPL_IMPERSONATE_HANDLE_unbind(
    IN REPL_IMPERSONATE_HANDLE ServerName,
    handle_t BindHandle
    )

/*++

Routine Description:

    This routine calls a common unbind routine that is shared by all services.
    This routine is called from the replicator service client stubs when it is
    necessary to unbind from the server end.

Arguments:

    ServerName - This is the name of the server from which to unbind.

    BindingHandle - This is the binding handle that is to be closed.

Return Value:

    None.

--*/
{
    UNREFERENCED_PARAMETER(ServerName);

    IF_DEBUG(RPCBIND) {
        NetpKdPrint(( PREFIX_REPL
                "REPL_IMPERSONATE_HANDLE_unbind: handle="
                FORMAT_HEX_DWORD "\n", BindHandle ));
    }

    (void) NetpUnbindRpc(BindHandle);
}

#endif // 0


void
REPL_IDENTIFY_HANDLE_unbind(
    IN REPL_IDENTIFY_HANDLE ServerName,
    handle_t BindHandle
    )

/*++

Routine Description:

    This routine calls a common unbind routine that is shared by all services.
    This routine is called from the server service client stubs when it is
    necessary to unbind from a server.

Arguments:

    ServerName - This is the name of the server from which to unbind.

    BindingHandle - This is the binding handle that is to be closed.

Return Value:

    None.

--*/
{
    UNREFERENCED_PARAMETER(ServerName);

    IF_DEBUG(RPCBIND) {
        NetpKdPrint(( PREFIX_REPL
                "REPL_IDENTIFY_HANDLE_unbind: handle="
                FORMAT_HEX_DWORD "\n", BindHandle ));
    }

    (void) NetpUnbindRpc(BindHandle);
}
