/*++

Copyright (c) 1991  Microsoft Corporation

Module Name:

    msgstub.c

Abstract:

    These are the Messenger Service API RPC client stubs.

Author:

    Dan Lafferty    (danl)  06-Feb-1991

Environment:

    User Mode - Win32

Revision History:
    
    27-Aug-1992     Danl
        Added downlevel support & removed error mapping for RPC errors.

    06-Feb-1991     Danl
        Created

--*/

//
// INCLUDES
//

#include <nt.h>         // DbgPrint prototype
#include <ntrtl.h>      // DbgPrint prototype
#include <rpc.h>        // DataTypes and runtime APIs

#include <msgsvc.h>     // generated by the MIDL complier
#include <rpcutil.h>    // NetRpc utils

#include <lmsvc.h> 
#include <lmcons.h>     // NET_API_STATUS
#include <lmerr.h>      // NetError codes
#include <rxmsg.h>      // RxNetMessage API
#include <netlib.h>     // NetpServiceIsStarted() (needed by netrpc.h).
#include <netdebug.h>   // needed for netrpc.h
#include <netrpc.h>     // NET_REMOTE macros.



NET_API_STATUS NET_API_FUNCTION
NetMessageNameAdd (
    IN  LPTSTR  servername,
    IN  LPTSTR  msgname
    )

/*++

Routine Description:

    This is the DLL entrypoint for NetMessageNameAdd.  This API adds a name
    to the message name table.

Arguments:

    servername - Pointer to a string containing the name of the computer
        that is to execute the API function.

    msgname - Pointer to a string containing the name to be added.


Return Value:

    NERR_Success - The operation was successful.

--*/
{
    NET_API_STATUS          apiStatus;
    DWORD                   OptionsSupported = 0;


    NET_REMOTE_TRY_RPC

        apiStatus = NetrMessageNameAdd (servername,msgname);

    NET_REMOTE_RPC_FAILED("NetMessageNameAdd",
        servername,
        apiStatus,
        NET_REMOTE_FLAG_NORMAL,
        SERVICE_MESSENGER)

        //
        // Call downlevel version of the API.
        //
        apiStatus = RxNetMessageNameAdd(servername,msgname);

    NET_REMOTE_END

    return(apiStatus);
}


NET_API_STATUS NET_API_FUNCTION
NetMessageNameEnum (
    IN  LPTSTR      servername,
    IN  DWORD       level,
    OUT LPBYTE      *bufptr,
    IN  DWORD       prefmaxlen,
    OUT LPDWORD     entriesread,
    OUT LPDWORD     totalentries,
    IN OUT LPDWORD  resume_handle
    )
/*++

Routine Description:

    This is the DLL entrypoint for NetMessageNameEnum.

Arguments:

    servername - Pointer to a string containing the name of the computer
        that is to execute the API function.

    level - This indicates the level of information that is desired.

    bufptr - A pointer to the location where the pointer to the returned
        array of info structures is to be placed.

    prefmaxlen - Indicates a maximum size limit that the caller will allow
        for the return buffer.

    entriesread - A pointer to the location where the number of entries
        (data structures)read is to be returned.

    totalentries - A pointer to the location which upon return indicates
        the total number of entries in the table.

    resumehandle - Pointer to a value that indicates where to resume
        enumerating data.

Return Value:

    Nerr_Success - The operation was successful.


Note:


--*/
{
    NET_API_STATUS          apiStatus;
    GENERIC_ENUM_STRUCT     infoStruct;
    GENERIC_INFO_CONTAINER  genericInfoContainer;
    DWORD                   OptionsSupported = 0;


    genericInfoContainer.Buffer = NULL;
    genericInfoContainer.EntriesRead = 0;

    infoStruct.Container = &genericInfoContainer;
    infoStruct.Level = level;


    NET_REMOTE_TRY_RPC

        apiStatus = NetrMessageNameEnum (
                servername,
                (LPMSG_ENUM_STRUCT) &infoStruct,
                prefmaxlen,
                totalentries,
                resume_handle);

        if (apiStatus == NERR_Success || apiStatus == ERROR_MORE_DATA) {
            *bufptr = (LPBYTE) genericInfoContainer.Buffer;
            *entriesread = genericInfoContainer.EntriesRead;
        }

    NET_REMOTE_RPC_FAILED("NetMessageNameEnum",
            servername,
            apiStatus,
            NET_REMOTE_FLAG_NORMAL,
            SERVICE_MESSENGER )

        //
        // Call downlevel version of the API.
        //
        apiStatus = RxNetMessageNameEnum(
                servername,
                level,
                bufptr,
                prefmaxlen,
                entriesread,
                totalentries,
                resume_handle);
        
    NET_REMOTE_END


    return(apiStatus);
}



NET_API_STATUS NET_API_FUNCTION
NetMessageNameGetInfo (
    IN  LPTSTR  servername,
    IN  LPTSTR  msgname,
    IN  DWORD   level,
    OUT LPBYTE  *bufptr
    )

/*++

Routine Description:

    This is the DLL entrypoint for NetMessageNameGetInfo.

Arguments:

    servername - Pointer to a string containing the name of the computer
        that is to execute the API function.  Since this function is
        executing on that computer, this information is not useful
        by the time it gets here.  It is really only useful on the RPC
        client side.

    msgname - Pointer to a string containing the name in the table
        for which information is desired.

    level - This indicates the level of information that is desired.

    bufptr - Pointer to a Location where the pointer to the returned
        information structure is to be placed.

Return Value:

    NERR_Success - The operation was successful.


--*/

{
    NET_API_STATUS          apiStatus;
    DWORD                   OptionsSupported = 0;


    *bufptr = NULL;         // Must be NULL so RPC knows to till it in.

    NET_REMOTE_TRY_RPC

        apiStatus = NetrMessageNameGetInfo (
            servername,
            msgname,
            level,
            (LPMSG_INFO) bufptr);

    NET_REMOTE_RPC_FAILED("NetMessageNameGetInfo",
            servername,
            apiStatus,
            NET_REMOTE_FLAG_NORMAL,
            SERVICE_MESSENGER)

        //
        // Call downlevel version of the API.
        //
        apiStatus = RxNetMessageNameGetInfo(
                        servername,
                        msgname,
                        level,
                        bufptr);
    NET_REMOTE_END


    return(apiStatus);
}


NET_API_STATUS NET_API_FUNCTION
NetMessageNameDel (
    IN  LPTSTR  servername,
    IN  LPTSTR  msgname
    )
/*++

Routine Description:

    This is the DLL entrypoint for NetMessageNameDel.  This API deletes
    a name from the message name table.

Arguments:

    servername - Points to a string containing the name of the computer
        that is to execute the API function.

    msgname - Points to a string containing the name that is to be deleted
        from the message name table.


Return Value:

    NERR_Success - The operation was successful



--*/

{
    NET_API_STATUS          apiStatus;
    DWORD                   OptionsSupported = 0;



    NET_REMOTE_TRY_RPC

        apiStatus = NetrMessageNameDel (servername, msgname);

    NET_REMOTE_RPC_FAILED("NetMessageNameDel",
        servername,
        apiStatus,
        NET_REMOTE_FLAG_NORMAL,
        SERVICE_MESSENGER)

        //
        // Call downlevel version of the API.
        //
        apiStatus = RxNetMessageNameDel(servername,msgname);

    NET_REMOTE_END

    return(apiStatus);
}


