/*++
 *
 *  WOW v1.0
 *
 *  Copyright (c) 1991, Microsoft Corporation
 *
 *  WMTBL32.C
 *  WOW32 32-bit message thunk tables
 *
 *  History:
 *  Created 19-Feb-1992 by Chandan Chauhan (ChandanC)
 *  Changed 12-May-1992 by Mike Tricker (MikeTri) Added MultiMedia calls - 3A0 to 3CF
--*/
#include "precomp.h"
#pragma hdrstop

MODNAME(wmtbl32.c);

//
// Note: If any of the message thunks is changed from a 'validthunk' to
//       WM32NoThunking  make sure that 16->32 messages  are not affected
//       (see thunkwmmsg16/unthunkwmmsg16 in msg16.c).  If a 16->32 thunk
//       does exist for the message in question you must use W32Thunk16To32
//       instead of WM32NoThunking.
//                                                     - nanduri

M32 aw32Msg[] = {
    {W32MSGFUN(WM32NoThunking,        "WM_NULL-0x0000",                0)},
    {W32MSGFUN(WM32Create,            "WM_CREATE-0x0001",              0)},
    {W32MSGFUN(WM32Destroy,           "WM_DESTROY-0x0002",             0)},
    {W32MSGFUN(WM32NoThunking,        "WM_MOVE-0x0003",                0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_SIZEWAIT-0x0004",            0)},
    {W32MSGFUN(WM32NoThunking,        "WM_SIZE-0x0005",                0)},
    {W32MSGFUN(WM32Activate,          "WM_ACTIVATE-0x0006",            0)},
    {W32MSGFUN(WM32SetFocus,          "WM_SETFOCUS-0x0007",            0)},
    {W32MSGFUN(WM32SetFocus,          "WM_KILLFOCUS-0x0008",           0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_SETVISIBLE-0x0009",          0)},

  /*** 0010 ***/
    {W32MSGFUN(WM32NoThunking,        "WM_ENABLE-0x000A",              0)},
    {W32MSGFUN(WM32Thunk16To32,       "WM_SETREDRAW-0x000B",           0)},
    {W32MSGFUN(WM32SetText,           "WM_SETTEXT-0x000C",             0)},
    {W32MSGFUN(WM32GetText,           "WM_GETTEXT-0x000D",             0)},
    {W32MSGFUN(WM32NoThunking,        "WM_GETTEXTLENGTH-0x000E",       0)},
    {W32MSGFUN(WM32NCPaint,           "WM_PAINT-0x000F",               0)},
    {W32MSGFUN(WM32NoThunking,        "WM_CLOSE-0x0010",               0)},
    {W32MSGFUN(WM32NoThunking,        "WM_QUERYENDSESSION-0x0011",     0)},
    {W32MSGFUN(WM32NoThunking,        "WM_QUIT-0x0012",                0)},
    {W32MSGFUN(WM32NoThunking,        "WM_QUERYOPEN-0x0013",           0)},

  /*** 0020 ***/
    {W32MSGFUN(WM32EraseBkGnd,        "WM_ERASEBKGND-0x0014",          0)},
    {W32MSGFUN(WM32NoThunking,        "WM_SYSCOLORCHANGE-0x0015",      0)},
    {W32MSGFUN(WM32NoThunking,        "WM_ENDSESSION-0x0016",          0)},
    {W32MSGFUN(WM32NoThunking,        "WM_SYSTEMERROR-0x0017",         0)},
    {W32MSGFUN(WM32NoThunking,        "WM_SHOWWINDOW-0x0018",          0)},
    {W32MSGFUN(WM32CtlColor,          "WM_CTLCOLOR-0x0019",            0)},
    {W32MSGFUN(WM32SetText,           "WM_WININICHANGE-0x001A",        0)},
    {W32MSGFUN(WM32SetText,           "WM_DEVMODECHANGE-0x001B",       0)},
    {W32MSGFUN(WM32ActivateApp,       "WM_ACTIVATEAPP-0x001C",         0)},
    {W32MSGFUN(WM32NoThunking,        "WM_FONTCHANGE-0x001D",          0)},

  /*** 0030 ***/
    {W32MSGFUN(WM32NoThunking,        "WM_TIMECHANGE-0x001E",          0)},
    {W32MSGFUN(WM32NoThunking,        "WM_CANCELMODE-0x001F",          0)},
    {W32MSGFUN(WM32SetFocus,          "WM_SETCURSOR-0x0020",           0)},
    {W32MSGFUN(WM32SetFocus,          "WM_MOUSEACTIVATE-0x0021",       0)},
    {W32MSGFUN(WM32NoThunking,        "WM_CHILDACTIVATE-0x0022",       0)},
    {W32MSGFUN(WM32NoThunking,        "WM_QUEUESYNC-0x0023",           0)},
    {W32MSGFUN(WM32GetMinMaxInfo,     "WM_GETMINMAXINFO-0x0024",       0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0025",                  0)},
    {W32MSGFUN(WM32NoThunking,        "WM_PAINTICON-0x0026",           0)},
    {W32MSGFUN(WM32EraseBkGnd,        "WM_ICONERASEBKGND-0x0027",      0)},

  /*** 0040 ***/
    {W32MSGFUN(WM32NextDlgCtl,        "WM_NEXTDLGCTL-0x0028",          0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_ALTTABACTIVE-0x0029",        0)},
    {W32MSGFUN(WM32NoThunking,        "WM_SPOOLERSTATUS-0x002A",       0)},
    {W32MSGFUN(WM32DrawItem,          "WM_DRAWITEM-0x002B",            0)},
    {W32MSGFUN(WM32MeasureItem,       "WM_MEASUREITEM-0x002C",         0)},
    {W32MSGFUN(WM32DeleteItem,        "WM_DELETEITEM-0x002D",          0)},
    {W32MSGFUN(WM32VKeyToItem,        "WM_VKEYTOITEM-0x002E",          0)},
    {W32MSGFUN(WM32VKeyToItem,        "WM_CHARTOITEM-0x002F",          0)},
    {W32MSGFUN(WM32SetFont,           "WM_SETFONT-0x0030",             0)},
    {W32MSGFUN(WM32GetFont,           "WM_GETFONT-0x0031",             0)},

  /*** 0050 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_FULLSCREEN-0x0032",          0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0033",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_FILESYSCHANGE-0x0034",       0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_ISACTIVEICON-0x0035",        0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_QUERYPARKICON-0x0036",       0)},
    {W32MSGFUN(WM32QueryDragIcon,     "WM_QUERYDRAGICON-0x0037",       0)},
    {W32MSGFUN(WM32WinHelp,           "WM_WINHELP-0x0038",             0)},
    {W32MSGFUN(WM32CompareItem,       "WM_COMPAREITEM-0x0039",         0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x003A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x003B",                  0)},

  /*** 0060 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x003C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x003D",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x003E",                  0)},
    {W32MSGFUN(WM32MMCalcScroll,      "MM_CALCSCROLL-0x003F",          0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_TESTING-0x0040",             0)},
    {W32MSGFUN(WM32NoThunking,        "WM_COMPACTING-0x0041",          0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_OTHERWINDOWCREATED-0x0042",  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_OTHERWINDOWDESTROYED-0x0043",0)},
    {W32MSGFUN(WM32NoThunking,        "WM_COMMNOTIFY-0x0044",          0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_HOTKEYEVENT-0x0045",         0)},

  /*** 0070 ***/
    {W32MSGFUN(WM32WindowPosChanging, "WM_WINDOWPOSCHANGING-0x0046",   0)},
    {W32MSGFUN(WM32WindowPosChanging, "WM_WINDOWPOSCHANGED-0x0047",    0)},
    {W32MSGFUN(WM32NoThunking,        "WM_POWER-0x000",                0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0049",                  0)},
    {W32MSGFUN(WM32CopyData,          "WM_COPYDATA!0x004A",            0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x004B",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x004C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x004D",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x004E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_ACCESS_WINDOW-0x004F",       0)},

  /*** 0080 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x50",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x51",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x52",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x53",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x54",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x55",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x56",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x57",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x58",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x59",                    0)},

  /*** 0090 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x5A",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x5B",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x5C",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x5D",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x5E",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x5F",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x60",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x61",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x62",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x63",                    0)},

  /*** 0100 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x64",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x65",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x66",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x67",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x68",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x69",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x6A",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x6B",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x6C",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x6D",                    0)},

  /*** 0110 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x6E",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x6F",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x70",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x71",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x72",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x73",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x74",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x75",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x76",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x77",                    0)},

  /*** 0120 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x78",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x79",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x7A",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x7B",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x7C",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x7D",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x7E",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x7F",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0080",                  0)},
    {W32MSGFUN(WM32Create,            "WM_NCCREATE-0x0081",            0)},

  /*** 0130 ***/
    {W32MSGFUN(WM32NoThunking,        "WM_NCDESTROY-0x0082",           0)},
    {W32MSGFUN(WM32NCCalcSize,        "WM_NCCALCSIZE-0x0083",          0)},
    {W32MSGFUN(WM32NoThunking,        "WM_NCHITTEST-0x0084",           0)},
    {W32MSGFUN(WM32NCPaint,           "WM_NCPAINT-0x0085",             0)},
    {W32MSGFUN(WM32Activate,          "WM_NCACTIVATE-0x0086",          0)},
    {W32MSGFUN(WM32GetDlgCode,        "WM_GETDLGCODE-0x0087",          0)},
    {W32MSGFUN(WM32NoThunking,        "WM_SYNCPAINT-0x0088",           0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_SYNCTASK-0x0089",            0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x8A",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x8B",                    0)},

  /*** 0140 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x8C",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x8D",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x8E",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x8F",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x90",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x91",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x92",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x93",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x94",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x95",                    0)},

  /*** 0150 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x96",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x97",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x98",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x99",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x9A",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x9B",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x9C",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x9D",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x9E",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x9F",                    0)},

  /*** 0160 ***/
    {W32MSGFUN(WM32NoThunking,        "WM_NCMOUSEMOVE-0x00A0",         0)},
    {W32MSGFUN(WM32NoThunking,        "WM_NCLBUTTONDOWN-0x00A1",       0)},
    {W32MSGFUN(WM32NoThunking,        "WM_NCLBUTTONUP-0x00A2",         0)},
    {W32MSGFUN(WM32NoThunking,        "WM_NCLBUTTONDBLCLK-0x00A3",     0)},
    {W32MSGFUN(WM32NoThunking,        "WM_NCRBUTTONDOWN-0x00A4",       0)},
    {W32MSGFUN(WM32NoThunking,        "WM_NCRBUTTONUP-0x00A5",         0)},
    {W32MSGFUN(WM32NoThunking,        "WM_NCRBUTTONDBLCLK-0x00A6",     0)},
    {W32MSGFUN(WM32NoThunking,        "WM_NCMBUTTONDOWN-0x00A7",       0)},
    {W32MSGFUN(WM32NoThunking,        "WM_NCMBUTTONUP-0x00A8",         0)},
    {W32MSGFUN(WM32NoThunking,        "WM_NCMBUTTONDBLCLK-0x00A9",     0)},

  /*** 0170 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xAA",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xAB",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xAC",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xAD",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xAE",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xAF",                    0)},
    {W32MSGFUN(WM32EMControl,         "EM_GETSEL-x00B0",               0)},
    {W32MSGFUN(WM32EMSetSel,          "EM_SETSEL-0x00B1",              0)},
    {W32MSGFUN(WM32EMGetRect,         "EM_GETRECT-0x00B2",             0)},
    {W32MSGFUN(WM32EMSetRect,         "EM_SETRECT-0x00B3",             0)},

  /*** 0180 ***/
    {W32MSGFUN(WM32EMSetRect,         "EM_SETRECTNP-0x00B4",           0)},
    {W32MSGFUN(WM32EMControl,         "EM_SCROLL-0x00B5",              0)},
    {W32MSGFUN(WM32EMLineScroll,      "EM_LINESCROLL-0x00B6",          0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x00B7",                  0)},
    {W32MSGFUN(WM32EMControl,         "EM_GETMODIFY-0x00B8",           0)},
    {W32MSGFUN(WM32EMControl,         "EM_SETMODIFY-0x00B9",           0)},
    {W32MSGFUN(WM32EMControl,         "EM_GETLINECOUNT-0x00BA",        0)},
    {W32MSGFUN(WM32EMControl,         "EM_LINEINDEX-0x00BB",           0)},
    {W32MSGFUN(WM32EMControl,         "EM_SETHANDLE-0x00BC",           0)},
    {W32MSGFUN(WM32EMControl,         "EM_GETHANDLE-0x00BD",           0)},

  /*** 0190 ***/
    {W32MSGFUN(WM32EMControl,         "EM_GETTHUMB-0x00BE",            0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x00BF",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x00C0",                  0)},
    {W32MSGFUN(WM32EMControl,         "EM_LINELENGTH-0x00C1",          0)},
    {W32MSGFUN(WM32EMReplaceSel,      "EM_REPLACESEL-0x00C2",          0)},
    {W32MSGFUN(WM32SetFont,           "EM_SETFONT-0x00C3",             0)},
    {W32MSGFUN(WM32EMGetLine,         "EM_GETLINE-0x00C4",             0)},
    {W32MSGFUN(WM32EMControl,         "EM_LIMITTEX-0x00C5",            0)},
    {W32MSGFUN(WM32EMControl,         "EM_CANUNDO-0x00C6",             0)},
    {W32MSGFUN(WM32EMControl,         "EM_UNDO-0x00C7",                0)},

  /*** 0200 ***/
    {W32MSGFUN(WM32EMControl,         "EM_FMTLINES-0x00C8",            0)},
    {W32MSGFUN(WM32EMControl,         "EM_LINEFROMCHAR-0x00C9",        0)},
    {W32MSGFUN(WM32EMControl,         "EM_SETWORDBREAK-0x00CA",        0)},
    {W32MSGFUN(WM32EMSetTabStops,     "EM_SETTABSTOPS-0x00CB",         0)},
    {W32MSGFUN(WM32EMControl,         "EM_SETPASSWORDCHAR-0x00CC",     0)},
    {W32MSGFUN(WM32EMControl,         "EM_EMPTYUNDOBUFFER-0x00CD",     0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EM_GETFIRSTVISIBLELINE-0x00CE", 0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EM_SETREADONLY-0x00CF",         0)},
    {W32MSGFUN(WM32EMSetWordBreakProc,"EM_SETWORDBREAKPROC-0x00D0",    0)},
    {W32MSGFUN(WM32EMGetWordBreakProc,"EM_GETWORDBREAKPROC-0x00D1",    0)},

  /*** 0210 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EM_GETPASSWORDCHAR-0x00D2",     0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EM_MSGMAX-0x00D3",              0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xD4",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xD5",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xD6",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xD7",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xD8",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xD9",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xDA",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xDB",                    0)},

  /*** 0220 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xDC",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xDD",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xDE",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xDF",                    0)},
    {W32MSGFUN(WM32SBMControl,        "SBM_SETPOS-0x00E0",             0)},
    {W32MSGFUN(WM32SBMControl,        "SBM_GETPOS-0x00E1",             0)},
    {W32MSGFUN(WM32SBMSetRange,       "SBM_SETRANGE-0x00E2",           0)},
    {W32MSGFUN(WM32SBMGetRange,       "SBM_GETRANGE-0x00E3",           0)},
    {W32MSGFUN(WM32SBMControl,        "SBM_ENABLE_ARROWS-0x00E4",      0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xE5",                    0)},

  /*** 0230 ***/
    {W32MSGFUN(WM32SBMSetRange,       "SBM_SETRANGEREDRAW-0xE6",       0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xE7",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xE8",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xE9",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xEA",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xEB",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xEC",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xED",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xEE",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xEF",                    0)},

  /*** 0240 ***/
    {W32MSGFUN(WM32BMControl,         "BM_GETCHECK-0x00F0",            0)},
    {W32MSGFUN(WM32BMControl,         "BM_SETCHECK-0x00F1",            0)},
    {W32MSGFUN(WM32BMControl,         "BM_GETSTATE-0x00F2",            0)},
    {W32MSGFUN(WM32BMControl,         "BM_SETSTATE-0x00F3",            0)},
    {W32MSGFUN(WM32BMControl,         "BM_SETSTYLE-0x00F4",            0)},
    {W32MSGFUN(WM32BMClick,           "BM_CLICK-0x00F5",               0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xF6",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xF7",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xF8",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xF9",                    0)},

  /*** 0250 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xFA",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xFB",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xFC",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xFD",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xFE",                    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0xFF",                    0)},
    {W32MSGFUN(WM32NoThunking,        "WM_KEYDOWN-0x0100",             0)},
    {W32MSGFUN(WM32NoThunking,        "WM_KEYUP-0x0101",               0)},
    {W32MSGFUN(WM32NoThunking,        "WM_CHAR-0x0102",                0)},
    {W32MSGFUN(WM32NoThunking,        "WM_DEADCHAR-0x0103",            0)},

  /*** 0260 ***/
    {W32MSGFUN(WM32NoThunking,        "WM_SYSKEYDOWN-0x0104",          0)},
    {W32MSGFUN(WM32NoThunking,        "WM_SYSKEYUP-0x0105",            0)},
    {W32MSGFUN(WM32NoThunking,        "WM_SYSCHAR-0x0106",             0)},
    {W32MSGFUN(WM32NoThunking,        "WM_SYSDEADCHAR-0x0107",         0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_YOMICHAR-0x0108",            0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0109",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_CONVERTREQUEST-0x010A",      0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_CONVERTRESULT-0x010B",       0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x010C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x010D",                  0)},

  /*** 0270 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x010E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x010F",                  0)},
    {W32MSGFUN(WM32SetFocus  ,        "WM_INITDIALOG-0x0110",          0)},
    {W32MSGFUN(WM32Command,           "WM_COMMAND-0x0111",             0)},
    {W32MSGFUN(WM32Thunk16To32,       "WM_SYSCOMMAND-0x0112",          0)},
    {W32MSGFUN(WM32Timer,             "WM_TIMER-0x0113",               0)},
    {W32MSGFUN(WM32HScroll,           "WM_HSCROLL-0x0114",             0)},
    {W32MSGFUN(WM32HScroll,           "WM_VSCROLL-0x0115",             0)},
    {W32MSGFUN(WM32InitMenu,          "WM_INITMENU-0x0116",            0)},
    {W32MSGFUN(WM32InitMenu,          "WM_INITMENUPOPUP-0x0117",       0)},

  /*** 0280 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_SYSTIMER-0x0118",            0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0119",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x011A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x011B",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x011C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x011D",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x011E",                  0)},
    {W32MSGFUN(WM32MenuSelect,        "WM_MENUSELECT-0x011F",          0)},
    {W32MSGFUN(WM32MenuChar,          "WM_MENUCHAR-0x0120",            0)},
    {W32MSGFUN(WM32EnterIdle,         "WM_ENTERIDLE-0x0121",           0)},

  /*** 0290 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0122",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0123",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0124",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0125",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0126",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0127",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0128",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0129",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x012A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x012B",                  0)},

  /*** 0300 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x012C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x012D",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x012E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x012F",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0130",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_LBTRACKPOINT-0x0131",        0)},
    {W32MSGFUN(WM32CtlColor,          "WM_CTLCOLORMSGBOX-0x0132",      0)},
    {W32MSGFUN(WM32CtlColor,          "WM_CTLCOLOREDIT-0x0133",        0)},
    {W32MSGFUN(WM32CtlColor,          "WM_CTLCOLORLISTBOX-0x0134",     0)},
    {W32MSGFUN(WM32CtlColor,          "WM_CTLCOLORBTN-0x0135",         0)},

  /*** 0310 ***/
    {W32MSGFUN(WM32CtlColor,          "WM_CTLCOLORDLG-0x0136",         0)},
    {W32MSGFUN(WM32CtlColor,          "WM_CTLCOLORSCROLLBAR-0x0137",   0)},
    {W32MSGFUN(WM32CtlColor,          "WM_CTLCOLORSTATIC-0x0138",      0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0139",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x013A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x013B",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x013C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x013D",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x013E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x013F",                  0)},

  /*** 0320 ***/
    {W32MSGFUN(WM32CBControl,         "CB_GETEDITSEL-0x0140",          0)},
    {W32MSGFUN(WM32CBControl,         "CB_LIMITTEXT-0x0141",           0)},
    {W32MSGFUN(WM32CBControl,         "CB_SETEDITSEL-0x0142",          0)},
    {W32MSGFUN(WM32CBAddString,       "CB_ADDSTRING-0x0143",           0)},
    {W32MSGFUN(WM32CBControl,         "CB_DELETESTRING-0x0144",        0)},
    {W32MSGFUN(WM32CBDir,             "CB_DIR-0x0145",                 0)},
    {W32MSGFUN(WM32CBControl,         "CB_GETCOUNT-0x0146",            0)},
    {W32MSGFUN(WM32CBControl,         "CB_GETCURSEL-0x0147",           0)},
    {W32MSGFUN(WM32CBGetLBText,       "CB_GETLBTEXT-0x010",            0)},
    {W32MSGFUN(WM32CBControl,         "CB_GETLBTEXTLEN-0x0149",        0)},

  /*** 0330 ***/
    {W32MSGFUN(WM32CBAddString,       "CB_INSERTSTRING-0x014A",        0)},
    {W32MSGFUN(WM32CBControl,         "CB_RESETCONTENT-0x014B",        0)},
    {W32MSGFUN(WM32CBAddString,       "CB_FINDSTRING-0x014C",          0)},
    {W32MSGFUN(WM32CBAddString,       "CB_SELECTSTRING-0x014D",        0)},
    {W32MSGFUN(WM32CBControl,         "CB_SETCURSEL-0x014E",           0)},
    {W32MSGFUN(WM32CBControl,         "CB_SHOWDROPDOWN-0x014F",        0)},
    {W32MSGFUN(WM32CBControl,         "CB_GETITEMDATA-0x0150",         0)},
    {W32MSGFUN(WM32CBControl,         "CB_SETITEMDATA-0x0151",         0)},
    {W32MSGFUN(WM32CBGetDropDownControlRect,"CB_GETDROPDOWNCONTROLRECT-0x0152",0)},
    {W32MSGFUN(WM32CBControl,         "CB_SETITEMHEIGHT-0X0153",       0)},

  /*** 0340 ***/
    {W32MSGFUN(WM32CBControl,         "CB_GETITEMHEIGHT-0x0154",       0)},
    {W32MSGFUN(WM32CBControl,         "CB_SETTEXTEXTENDEDUI-0x0155",   0)},
    {W32MSGFUN(WM32CBControl,         "CB_GETTEXTEXTENDEDUI-0x0156",   0)},
    {W32MSGFUN(WM32CBControl,         "CB_GETDROPPEDSTATE-0x0157",     0)},
    {W32MSGFUN(WM32CBAddString,       "CB_FINDSTRINGEXACT-0x0158",     0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0159",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x015A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x015B",                  0)},
    {W32MSGFUN(WM32CBComboFocus,      "EMPTY!0x015C",                  0)},
    {W32MSGFUN(WM32CBComboFocus,      "EMPTY!0x015D",                  0)},

  /*** 0350 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x015E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x015F",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0160",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0161",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0162",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0163",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0164",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0165",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0166",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0167",                  0)},

  /*** 0360 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0168",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0169",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x016A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x016B",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x016C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x016D",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x016E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x016F",                  0)},
    {W32MSGFUN(WM32STMControl,        "STM_SETICON-0x0170",            0)},
    {W32MSGFUN(WM32STMControl,        "STM_GETICON-0x0171",            0)},

  /*** 0370 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "STM_MSGMAX-0x0172",             0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0173",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0174",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0175",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0176",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0177",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0178",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0179",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x017A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x017B",                  0)},

  /*** 0380 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x017C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x017D",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x017E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x017F",                  0)},
    {W32MSGFUN(WM32LBAddString,       "LB_ADDSTRING-0x0180",           0)},
    {W32MSGFUN(WM32LBAddString,       "LB_INSERTSTRING-0x0181",        0)},
    {W32MSGFUN(WM32LBControl,         "LB_DELETESTRING-0x0182",        0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0183",                  0)},
    {W32MSGFUN(WM32LBControl,         "LB_RESETCONTENT-0x0184",        0)},
    {W32MSGFUN(WM32LBSetSel,          "LB_SETSEL-0x0185",              0)},

  /*** 0390 ***/
    {W32MSGFUN(WM32LBControl,         "LB_SETCURSEL-0x0186",           0)},
    {W32MSGFUN(WM32LBControl,         "LB_GETSEL-0x0187",              0)},
    {W32MSGFUN(WM32LBControl,         "LB_GETCURSEL-0x0188",           0)},
    {W32MSGFUN(WM32LBGetText,         "LB_GETTEXT-0x0189",             0)},
    {W32MSGFUN(WM32LBGetTextLen,      "LB_GETTEXTLEN-0x018A",          0)},
    {W32MSGFUN(WM32LBControl,         "LB_GETCOUNT-0x018B",            0)},
    {W32MSGFUN(WM32LBAddString,       "LB_SELECTSTRING-0x018C",        0)},
    {W32MSGFUN(WM32LBDir,             "LB_DIR-0x018D",                 0)},
    {W32MSGFUN(WM32LBControl,         "LB_GETTOPINDEX-0x018E",         0)},
    {W32MSGFUN(WM32LBAddString,       "LB_FINDSTRING-0x018F",          0)},

  /*** 0400 ***/
    {W32MSGFUN(WM32LBControl,         "LB_GETSELCOUNT-0x0190",         0)},
    {W32MSGFUN(WM32LBGetSelItems,     "LB_GETSELITEMS-0x0191",         0)},
    {W32MSGFUN(WM32LBSetTabStops,     "LB_SETTABSTOPS-0x0192",         0)},
    {W32MSGFUN(WM32LBControl,         "LB_GETHORIZONTALEXTENT-0x0193", 0)},
    {W32MSGFUN(WM32LBControl,         "LB_SETHORIZONTALEXTENT-0x0194", 0)},
    {W32MSGFUN(WM32LBControl,         "LB_SETCOLUMNWIDTH-0x0195",      0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "LB_ADDFILE-0x0196",             0)},
    {W32MSGFUN(WM32LBControl,         "LB_SETTOPINDEX-0x0197",         0)},
    {W32MSGFUN(WM32LBGetItemRect,     "LB_GETITEMRECT-0x0198",         0)},
    {W32MSGFUN(WM32LBControl,         "LB_GETITEMDATA-0x0199",         0)},

  /*** 0410 ***/
    {W32MSGFUN(WM32LBControl,         "LB_SETITEMDATA-0x019A",         0)},
    {W32MSGFUN(WM32LBControl,         "LB_SELITEMRANGE-0x019B",        0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "LB_SETANCHORINDEX-0x019C",      0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "LB_GETANCHORINDEX-0x019D",      0)},
    {W32MSGFUN(WM32LBControl,         "LB_SETCARETINDEX-0x019E",       0)},
    {W32MSGFUN(WM32LBControl,         "LB_GETCARETINDEX-0x019F",       0)},
    {W32MSGFUN(WM32LBControl,         "LB_SETITEMHEIGHT-0x01A0",       0)},
    {W32MSGFUN(WM32LBControl,         "LB_GETITEMHEIGHT-0x01A1",       0)},
    {W32MSGFUN(WM32LBAddString,       "LB_FINDSTRINGEXACT-0x01A2",     0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "LBCB_CARETON",                  0)},

  /*** 0420 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "LBCB_CARETOFF",                 0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01A5",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01A6",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01A7",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01A8",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01A9",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01AA",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01AB",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01AC",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01AD",                  0)},

  /*** 0430 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01AE",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01AF",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01B0",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01B1",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01B2",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01B3",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01B4",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01B5",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01B6",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01B7",                  0)},

  /*** 0440 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01B8",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01B9",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01BA",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01BB",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01BC",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01BD",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01BE",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01BF",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01C0",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01C1",                  0)},

  /*** 0450 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01C2",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01C3",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01C4",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01C5",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01C6",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01C7",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01C8",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01C9",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01CA",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01CB",                  0)},

  /*** 0460 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01CC",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01CD",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01CE",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01CF",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01D0",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01D1",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01D2",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01D3",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01D4",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01D5",                  0)},

  /*** 0470 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01D6",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01D7",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01D8",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01D9",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01DA",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01DB",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01DC",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01DD",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01DE",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01DF",                  0)},

  /*** 0480 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01E0",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01E1",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01E2",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01E3",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01E4",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01E5",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01E6",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01E7",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01E8",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01E9",                  0)},

  /*** 0490 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01EA",                  0)},
    {W32MSGFUN(WM32MNFindMenuWindow,  "MN_FINDMENUWINDOWFROMPOINT-0x01EB",0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01EC",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01ED",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01EE",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01EF",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01F0",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01F1",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01F2",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01F3",                  0)},

  /*** 0500 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01F4",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01F5",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01F6",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01F7",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01F8",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01F9",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01FA",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01FB",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01FC",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01FD",                  0)},

  /*** 0510 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01FE",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x01FF",                  0)},
    {W32MSGFUN(WM32NoThunking,        "WM_MOUSEMOVE-0x0200",           0)},
    {W32MSGFUN(WM32NoThunking,        "WM_LBUTTONDOWN-0x0201",         0)},
    {W32MSGFUN(WM32NoThunking,        "WM_LBUTTONUP-0x0202",           0)},
    {W32MSGFUN(WM32NoThunking,        "WM_LBUTTONDBLCLK-0x0203",       0)},
    {W32MSGFUN(WM32NoThunking,        "WM_RBUTTONDOWN-0x0204",         0)},
    {W32MSGFUN(WM32NoThunking,        "WM_RBUTTONUP-0x0205",           0)},
    {W32MSGFUN(WM32NoThunking,        "WM_RBUTTONDBLCLK-0x0206",       0)},
    {W32MSGFUN(WM32NoThunking,        "WM_MBUTTONDOWN-0x0207",         0)},

  /*** 0520 ***/
    {W32MSGFUN(WM32NoThunking,        "WM_MBUTTONUP-0x0208",           0)},
    {W32MSGFUN(WM32NoThunking,        "WM_MBUTTONDBLCLK-0x0209",       0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x020A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x020B",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x020C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x020D",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x020E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x020F",                  0)},
    {W32MSGFUN(WM32ParentNotify,      "WM_PARENTNOTIFY-0x0210",        0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_ENTERMENULOOP-0x0211",       0)},

  /*** 0530 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_EXITMENULOOP-0x0212",        0)},
    {W32MSGFUN(WM32NextMenu,          "WM_NEXTMENU-0x0213",            0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0214",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0215",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0216",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0217",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0218",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0219",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x021A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x021B",                  0)},

  /*** 0540 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x021C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x021D",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x021E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x021F",                  0)},
    {W32MSGFUN(WM32MDICreate,         "WM_MDICREATE-0x0220",           0)},
    {W32MSGFUN(WM32SetFocus,          "WM_MDIDESTROY-0x0221",          0)},
    {W32MSGFUN(WM32MDIActivate,       "WM_MDIACTIVATE-0x0222",         0)},
    {W32MSGFUN(WM32SetFocus,          "WM_MDIRESTORE-0x0223",          0)},
    {W32MSGFUN(WM32SetFocus,          "WM_MDINEXT-0x0224",             0)},
    {W32MSGFUN(WM32SetFocus,          "WM_MDIMAXIMIZE-0x0225",         0)},

  /*** 0550 ***/
    {W32MSGFUN(WM32Thunk16To32,       "WM_MDITILE-0x0226",             0)},
    {W32MSGFUN(WM32Thunk16To32,       "WM_MDICASCADE-0x0227",          0)},
    {W32MSGFUN(WM32NoThunking,        "WM_MDIICONARRANGE-0x0228",      0)},
    {W32MSGFUN(WM32MDIGetActive,      "WM_MDIGETACTIVE-0x0229",        0)},
    {W32MSGFUN(WM32DropObject,        "WM_DROPOBJECT-0x022A",          0)},
    {W32MSGFUN(WM32DropObject,        "WM_QUERYDROPOBJECT-0x022B",     0)},
    {W32MSGFUN(WM32Thunk16To32,       "WM_BEGINDRAG-0x022C",           0)},
    {W32MSGFUN(WM32DropObject,        "WM_DRAGLOOP-0x022D",            0)},
    {W32MSGFUN(WM32DropObject,        "WM_DRAGSELECT-0x022E",          0)},
    {W32MSGFUN(WM32DropObject,        "WM_DRAGMOVE-0x022F",            0)},

  /*** 0560 ***/
    {W32MSGFUN(WM32MDISetMenu,        "WM_MDISETMENU-0x0230",          0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_ENTERSIZEMOVE-0x0231",       0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_EXITSIZEMOVE-0x0232",        0)},
    {W32MSGFUN(WM32DropFiles,         "WM_DROPFILES-0x0233",           0)},
    {W32MSGFUN(WM32MDISetMenu,        "WM_MDIREFRESHMENU-0x0234",      0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0235",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0236",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0237",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0238",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0239",                  0)},

  /*** 0570 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x023A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x023B",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x023C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x023D",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x023E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x023F",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0240",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0241",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0242",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0243",                  0)},

  /*** 0580 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0244",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0245",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0246",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0247",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0248",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0249",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x024A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x024B",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x024C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x024D",                  0)},

  /*** 0590 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x024E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x024F",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0250",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0251",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0252",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0253",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0254",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0255",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0256",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0257",                  0)},

  /*** 0600 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0258",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0259",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x025A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x025B",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x025C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x025D",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x025E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x025F",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0260",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0261",                  0)},

  /*** 0610 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0262",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0263",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0264",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0265",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0266",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0267",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0268",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0269",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x026A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x026B",                  0)},

  /*** 0620 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x026C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x026D",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x026E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x026F",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0270",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0271",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0272",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0273",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0274",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0275",                  0)},

  /*** 0630 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0276",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0277",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0278",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0279",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x027A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x027B",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x027C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x027D",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x027E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x027F",                  0)},

  /*** 0640 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_KANJIFIRST0x0280",           0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0281",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0282",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0283",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0284",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0285",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0286",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0287",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0288",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0289",                  0)},

  /*** 0650 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x028A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x028B",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x028C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x028D",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x028E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x028F",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0290",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0291",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0292",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0293",                  0)},

  /*** 0660 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0294",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0295",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0296",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0297",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0298",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0299",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x029A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x029B",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x029C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x029D",                  0)},

  /*** 0670 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x029E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_KANJILAST-0x029F",           0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02A0",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02A1",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02A2",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02A3",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02A4",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02A5",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02A6",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02A7",                  0)},

  /*** 0680 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02A8",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02A9",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02AA",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02AB",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02AC",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02AD",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02AE",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02AF",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02B0",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02B1",                  0)},

  /*** 0690 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02B2",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02B3",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02B4",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02B5",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02B6",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02B7",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02B8",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02B9",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02BA",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02BB",                  0)},

  /*** 0700 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02BC",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02BD",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02BE",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02BF",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02C0",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02C1",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02C2",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02C3",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02C4",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02C5",                  0)},

  /*** 0710 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02C6",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02C7",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02C8",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02C9",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02CA",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02CB",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02CC",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02CD",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02CE",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02CF",                  0)},

  /*** 0720 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02D0",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02D1",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02D2",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02D3",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02D4",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02D5",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02D6",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02D7",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02D8",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02D9",                  0)},

  /*** 0730 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02DA",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02DB",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02DC",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02DD",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02DE",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02DF",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02E0",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02E1",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02E2",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02E3",                  0)},

  /*** 0740 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02E4",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02E5",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02E6",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02E7",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02E8",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02E9",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02EA",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02EB",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02EC",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02ED",                  0)},

  /*** 0750 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02EE",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02EF",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02F0",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02F1",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02F2",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02F3",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02F4",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02F5",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02F6",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02F7",                  0)},

  /*** 0760 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02F8",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02F9",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02FA",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02FB",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02FC",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02FD",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02FE",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x02FF",                  0)},
    {W32MSGFUN(WM32NoThunking,        "WM_CUT-0x0300",                 0)},
    {W32MSGFUN(WM32NoThunking,        "WM_COPY-0x0301",                0)},

  /*** 0770 ***/
    {W32MSGFUN(WM32NoThunking,        "WM_PASTE-0x0302",               0)},
    {W32MSGFUN(WM32NoThunking,        "WM_CLEAR-0x0303",               0)},
    {W32MSGFUN(WM32NoThunking,        "WM_UNDO-0x0304",                0)},
    {W32MSGFUN(WM32NoThunking,        "WM_RENDERFORMAT-0x0305",        0)},
    {W32MSGFUN(WM32NoThunking,        "WM_RENDERALLFORMATS-0x0306",    0)},
    {W32MSGFUN(WM32NoThunking,        "WM_DESTROYCLIPBOARD-0x0307",    0)},
    {W32MSGFUN(WM32NoThunking,        "WM_DRAWCLIPBOARD-0x0308",       0)},
    {W32MSGFUN(WM32SizeClipBoard,     "WM_PAINTCLIPBOARD-0x0309",      0)},
    {W32MSGFUN(WM32SetFocus,          "WM_VSCROLLCLIPBOARD-0x030A",    0)},
    {W32MSGFUN(WM32SizeClipBoard,     "WM_SIZECLIPBOARD-0x030B",       0)},

  /*** 0780 ***/
    {W32MSGFUN(WM32AskCBFormatName,   "WM_ASKCBFORMATNAME-0x030C",     0)},
    {W32MSGFUN(WM32ChangeCBChain,     "WM_CHANGECBCHAIN-0x030D",       0)},
    {W32MSGFUN(WM32SetFocus,          "WM_HSCROLLCLIPBOARD-0x030E",    0)},
    {W32MSGFUN(WM32NoThunking,        "WM_QUERYNEWPALETTE-0x030F",     0)},
    {W32MSGFUN(WM32SetFocus,          "WM_PALETTEISCHANGING-0x0310",   0)},
    {W32MSGFUN(WM32SetFocus,          "WM_PALETTECHANGED-0x0311",      0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_HOTKEY-0x0312",              0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0313",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0314",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0315",                  0)},

  /*** 0790 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0316",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0317",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0318",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0319",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x031A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x031B",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x031C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x031D",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x031E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x031F",                  0)},

  /*** 0800 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0320",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0321",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0322",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0323",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0324",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0325",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0326",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0327",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0328",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0329",                  0)},

  /*** 0810 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x032A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x032B",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x032C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x032D",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x032E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x032F",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0330",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0331",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0332",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0333",                  0)},

  /*** 0820 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0334",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0335",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0336",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0337",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0338",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0339",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x033A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x033B",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x033C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x033D",                  0)},

  /*** 0830 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x033E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x033F",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0340",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0341",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0342",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0343",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0344",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0345",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0346",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0347",                  0)},

  /*** 0840 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0348",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0349",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x034A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x034B",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x034C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x034D",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x034E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x034F",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0350",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0351",                  0)},

  /*** 0850 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0352",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0353",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0354",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0355",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0356",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0357",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0358",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0359",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x035A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x035B",                  0)},

  /*** 0860 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x035C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x035D",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x035E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x035F",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0360",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0361",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0362",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0363",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0364",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0365",                  0)},

  /*** 0870 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0366",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0367",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0368",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0369",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x036A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x036B",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x036C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x036D",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x036E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x036F",                  0)},

  /*** 0880 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0370",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0371",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0372",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0373",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0374",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0375",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0376",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0377",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0378",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0379",                  0)},

  /*** 0890 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x037A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x037B",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x037C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x037D",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x037E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x037F",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0380",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0381",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0382",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0383",                  0)},

  /*** 0900 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0384",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0385",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0386",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0387",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0388",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0389",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x038A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x038B",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x038C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x038D",                  0)},

  /*** 0910 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x038E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x038F",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0390",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0391",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0392",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0393",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0394",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0395",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0396",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0397",                  0)},

  /*** 0920 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0398",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x0399",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x039A",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x039B",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x039C",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x039D",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x039E",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x039F",                  0)},
    {W32MSGFUN(WM32NoThunking,        "MM_JOY1MOVE-0x03A0",            0)},
    {W32MSGFUN(WM32NoThunking,        "MM_JOY2MOVE-0x03A1",            0)},

  /*** 0930 ***/
    {W32MSGFUN(WM32NoThunking,        "MM_JOY1ZMOVE-0x03A2",           0)},
    {W32MSGFUN(WM32NoThunking,        "MM_JOY2ZMOVE-0x03A3",           0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03A4",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03A5",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03A6",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03A7",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03A8",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03A9",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03AA",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03AB",                  0)},

  /*** 0940 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03AC",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03AD",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03AE",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03AF",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03B0",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03B1",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03B2",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03B3",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03B4",                  0)},
    {W32MSGFUN(WM32NoThunking,        "MM_JOY1BUTTONDOWN-0x03B5",      0)},

  /*** 0950 ***/
    {W32MSGFUN(WM32NoThunking,        "MM_JOY2BUTTONDOWN-0x03B6",      0)},
    {W32MSGFUN(WM32NoThunking,        "MM_JOY1BUTTONUP-0x03B7",        0)},
    {W32MSGFUN(WM32NoThunking,        "MM_JOY2BUTTONUP-0x03B8",        0)},
    {W32MSGFUN(WM32NoThunking,        "MM_MCINOTIFY-0x03B9",           0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03BA",                  0)},
    {W32MSGFUN(WM32NoThunking,        "MM_WOM_OPEN-0x03BB",            0)},
    {W32MSGFUN(WM32NoThunking,        "MM_WOM_CLOSE-0x03BC",           0)},
    {W32MSGFUN(WM32NoThunking,        "MM_WOM_DONE-0x03BD",            0)},
    {W32MSGFUN(WM32NoThunking,        "MM_WIM_OPEN-0x03BE",            0)},
    {W32MSGFUN(WM32NoThunking,        "MM_WIM_CLOSE-0x03BF",           0)},

  /*** 0960 ***/
    {W32MSGFUN(WM32NoThunking,        "MM_WIM_DATA-0x03C0",            0)},
    {W32MSGFUN(WM32NoThunking,        "MM_MIM_OPEN-0x03C1",            0)},
    {W32MSGFUN(WM32NoThunking,        "MM_MIM_CLOSE-0x03C2",           0)},
    {W32MSGFUN(WM32NoThunking,        "MM_MIM_DATA-0x03C3",            0)},
    {W32MSGFUN(WM32NoThunking,        "MM_MIM_LONGDATA-0x03C4",        0)},
    {W32MSGFUN(WM32NoThunking,        "MM_MIM_ERROR-0x03C5",           0)},
    {W32MSGFUN(WM32NoThunking,        "MM_MIM_LONGERROR-0x03C6",       0)},
    {W32MSGFUN(WM32NoThunking,        "MM_MOM_OPEN-0x03C7",            0)},
    {W32MSGFUN(WM32NoThunking,        "MM_MOM_CLOSE-0x03C8",           0)},
    {W32MSGFUN(WM32NoThunking,        "MM_MOM_DONE-0x03C9",            0)},

  /*** 0970 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "MM_MCISYSTEM_STRING-0x03CA",    0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03CB",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03CC",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03CD",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03CE",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03CF",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03D0",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03D1",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03D2",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03D3",                  0)},

  /*** 0980 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03D4",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03D5",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03D6",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03D7",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03D8",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03D9",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03DA",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03DB",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03DC",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03DD",                  0)},

  /*** 0990 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03DE",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03DF",                  0)},
    {W32MSGFUN(WM32DDEInitiate,       "WM_DDE_INITIATE-0x03E0",        0)},
    {W32MSGFUN(WM32DDERequest,        "WM_DDE_TERMINATE-0x03E1",       0)},
    {W32MSGFUN(WM32DDEAdvise,         "WM_DDE_ADVISE-0x03E2",          0)},
    {W32MSGFUN(WM32DDERequest,        "WM_DDE_UNADVISE-0x03E3",        0)},
    {W32MSGFUN(WM32DDEAck,            "WM_DDE_ACK-0x03E4",             0)},
    {W32MSGFUN(WM32DDEData,           "WM_DDE_DATA-0x03E5",            0)},
    {W32MSGFUN(WM32DDERequest,        "WM_DDE_REQUEST-0x03E6",         0)},
    {W32MSGFUN(WM32DDEPoke,           "WM_DDE_POKE-0x03E7",            0)},

  /*** 1000 ***/
    {W32MSGFUN(WM32DDEExecute,        "WM_DDE_EXECUTE-0x03E8",         0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03E9",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03EA",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03EB",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03EC",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03ED",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03EE",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03EF",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03F0",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03F1",                  0)},

  /*** 1010 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03F2",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03F3",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03F4",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03F5",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03F6",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03F7",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03F8",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03F9",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03FA",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03FB",                  0)},

  /*** 1020 ***/
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03FC",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03FD",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03FE",                  0)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EMPTY!0x03FF",                  0)},
};


#ifdef DEBUG_OR_WOWPROFILE
INT  iMsgMax  = NUMEL(aw32Msg);
PM32 paw32Msg = aw32Msg;
#endif
