/*++
 *
 *  WOW v1.0
 *
 *  Copyright (c) 1991, Microsoft Corporation
 *
 *  WALIAS.C
 *  WOW32 16-bit handle alias support
 *
 *  History:
 *  Created 27-Jan-1991 by Jeff Parsons (jeffpar)
 *  Modified 12-May-1992 by Mike Tricker (miketri) to add MultiMedia support
--*/

#include "precomp.h"
#pragma hdrstop

MODNAME(walias.c);


#ifdef  DEBUG
extern  BOOL fSkipLog;          // TRUE to temporarily skip certain logging
#endif

typedef struct _stdclass {
    LPSTR   lpszClassName;
    ATOM    aClassAtom;
    WNDPROC lpfnWndProc;
    INT     iOrdinal;
    DWORD   vpfnWndProc;
} STDCLASS;

// Some cool defines stolen from USERSRV.H
#define MENUCLASS       MAKEINTATOM(0x8000)
#define DESKTOPCLASS    MAKEINTATOM(0x8001)
#define DIALOGCLASS     MAKEINTATOM(0x8002)
#define SWITCHWNDCLASS  MAKEINTATOM(0x8003)
#define ICONTITLECLASS  MAKEINTATOM(0x8004)

// See WARNING below!
STDCLASS stdClasses[] = {
    NULL,           0,                      NULL,   0,                      0,  // WOWCLASS_UNKNOWN
    NULL,           0,                      NULL,   0,                      0,  // WOWCLASS_WIN16
    "BUTTON",       0,                      NULL,   FUN_BUTTONWNDPROC,      0,  // WOWCLASS_BUTTON,
    "COMBOBOX",     0,                      NULL,   FUN_COMBOBOXCTLWNDPROC, 0,  // WOWCLASS_COMBOBOX,
    "EDIT",         0,                      NULL,   FUN_EDITWNDPROC,        0,  // WOWCLASS_EDIT,
    "LISTBOX",      0,                      NULL,   FUN_LBOXCTLWNDPROC,     0,  // WOWCLASS_LISTBOX,
    "MDICLIENT",    0,                      NULL,   FUN_MDICLIENTWNDPROC,   0,  // WOWCLASS_MDICLIENT,
    "SCROLLBAR",    0,                      NULL,   FUN_SBWNDPROC,          0,  // WOWCLASS_SCROLLBAR,
    "STATIC",       0,                      NULL,   FUN_STATICWNDPROC,      0,  // WOWCLASS_STATIC,
    "#32769",       (WORD)DESKTOPCLASS,     NULL,   FUN_DESKTOPWNDPROC,     0,  // WOWCLASS_DESKTOP,
    "#32770",       (WORD)DIALOGCLASS,      NULL,   FUN_DEFDLGPROCTHUNK,    0,  // WOWCLASS_DIALOG,
    "#32772",       (WORD)ICONTITLECLASS,   NULL,   FUN_TITLEWNDPROC,       0,  // WOWCLASS_ICONTITLE,
    "#32768",       (WORD)MENUCLASS,        NULL,   FUN_MENUWNDPROC,        0,  // WOWCLASS_MENU,
    "#32771",       (WORD)SWITCHWNDCLASS,   NULL,   0,                      0,  // WOWCLASS_SWITCHWND,
    "COMBOLBOX",    0,                      NULL,   FUN_LBOXCTLWNDPROC,     0,  // WOWCLASS_COMBOLBOX
};
//
// WARNING! The above sequence and values must be maintained otherwise the
// table in WMSG16.C for message thunking must be changed.  Same goes for
// the #define's in WALIAS.H
//
// The above COMBOLBOX case is special because it is class that is
// almost identical to a listbox.  Therefore we lie about it.

INT GetStdClassNumber(
    PSZ pszClass
) {
    INT     i;

    if ( HIWORD(pszClass) ) {

        // They passed us a string

        for ( i = WOWCLASS_BUTTON; i < NUMEL(stdClasses); i++ ) {
            if ( strcmpi(pszClass, stdClasses[i].lpszClassName) == 0 ) {
                return( i );
            }
        }
    } else {

        // They passed us an atom

        for ( i = WOWCLASS_BUTTON; i < NUMEL(stdClasses); i++ ) {
            if ( stdClasses[i].aClassAtom == 0 ) {
                // RegisterWindowMessage is an undocumented way of determining
                // an atom value in the context of the server-side heap.
                stdClasses[i].aClassAtom = RegisterWindowMessage(stdClasses[i].lpszClassName);
            }
            if ( (ATOM)LOWORD(pszClass) == stdClasses[i].aClassAtom ) {
                return( i );
            }
        }
    }
    return( WOWCLASS_UNKNOWN );
}

// Returns a 32 window proc given a class index

WNDPROC GetStdClassWndProc(
    DWORD   iClass
) {
    WNDPROC lpfn32;

    if ( iClass < WOWCLASS_UNKNOWN || iClass > WOWCLASS_MAX ) {
        WOW32ASSERT(FALSE);
        return( NULL );
    }

    lpfn32 = stdClasses[iClass].lpfnWndProc;

    if ( lpfn32 == NULL ) {
        WNDCLASS    wc;
        BOOL        f;

        f = GetClassInfo( NULL, stdClasses[iClass].lpszClassName, &wc );

        if ( f ) {
            VPVOID  vp;
	    DWORD UNALIGNED * lpdw;

            lpfn32 = wc.lpfnWndProc;
            stdClasses[iClass].lpfnWndProc = lpfn32;

            vp = GetStdClassThunkProc(iClass);
            vp = (VPVOID)((DWORD)vp - sizeof(DWORD)*3);

            GETVDMPTR( vp, sizeof(DWORD)*3, lpdw );

            WOW32ASSERT(*lpdw == SUBCLASS_MAGIC);   // Are we editing the right stuff?

            *(lpdw+2) = (DWORD)lpfn32;

            FLUSHVDMCODEPTR( vp, sizeof(DWORD)*3, lpdw );
            FREEVDMPTR( lpdw );

        }
    }
    return( lpfn32 );
}

// Returns a 16 window proc thunk given a class index

DWORD GetStdClassThunkProc(
    INT     iClass
) {
    DWORD   dwResult;
    INT     iOrdinal;
    PARM16  Parm16;

    if ( iClass < WOWCLASS_UNKNOWN || iClass > WOWCLASS_MAX ) {
        WOW32ASSERT(FALSE);
        return( 0 );
    }

    iOrdinal = stdClasses[iClass].iOrdinal;

    if ( iOrdinal == 0 ) {
        return( (DWORD)NULL );
    }

    // If we've already gotten this proc, then don't bother calling into 16-bit
    dwResult = stdClasses[iClass].vpfnWndProc;

    if ( dwResult == (DWORD)NULL ) {

        // Callback into the 16-bit world asking for the 16:16 address

        Parm16.SubClassProc.iOrdinal = iOrdinal;

        if (!CallBack16(RET_SUBCLASSPROC, &Parm16, (VPPROC)NULL,
                          (PVPVOID)&dwResult)) {
            WOW32ASSERT(FALSE);
            return( 0 );
        }
        // Save it since it is a constant.
        stdClasses[iClass].vpfnWndProc = dwResult;
    }
    return( dwResult );
}

PWW FindPWW(HANDLE h32, INT iClass)
{

    PWW pww;
    CHAR szClassName[16];

    if (!h32) {
        return (PWW) NULL;
    }
    else {
        try {
            pww = (PWW) GetWindowLong(h32, GWL_WOWWORDS);
        }
        except (EXCEPTION_ACCESS_VIOLATION == GetExceptionCode()) {
            pww = (PWW) NULL;
        }

        if (pww) {
            if (WOWCLASS_UNKNOWN == pww->iClass &&
                !(pww->flState & WWSTATE_ICLASSISSET)) {

                if (WOWCLASS_UNKNOWN == iClass &&
                    GetClassName(h32, szClassName, sizeof(szClassName))) {

                    iClass = GetStdClassNumber(szClassName);

                }

                if (WOWCLASS_UNKNOWN != iClass) {
                    SETWL(h32, GWL_WOWiClassAndflState,
                            MAKECLASSANDSTATE(iClass, pww->flState | WWSTATE_ICLASSISSET));
                } else {
                    SETWL(h32, GWL_WOWiClassAndflState,
                            MAKECLASSANDSTATE(pww->iClass, pww->flState | WWSTATE_ICLASSISSET));
                }
            }
        }
        else {
            LOGDEBUG(2,("WOW::FindPWW(): *** Invalid hwnd32 %08x\n", h32));
        }
    }

    return (pww);
}

PWC FindPWC(HANDLE h32)
{
    PWC pwc;

    try {
        pwc = (PWC) GetClassLong(h32, GCL_WOWWORDS);
        WOW32ASSERT(pwc);
    }
    except (EXCEPTION_ACCESS_VIOLATION == GetExceptionCode()) {
        pwc = (PWC) NULL;
        LOGDEBUG(LOG_ALWAYS,("WOW::FindPWC(): *** Invalid hwnd32 %08x\n", h32));
        WOW32ASSERT(FALSE);
    }

    return (pwc);
}

/*
 * PWC GetClassWOWWords(hInst, pszClass)
 *   is a ***private*** API for WOW only. It returns a pointer to the
 *   WOW Class structure in the server's window class structure.
 *   This is similar to GetClassLong(hwnd32, GCL_WOWWORDS) (see FindPWC),
 *   but in this case we don't have a hwnd32, we have the class name
 *   and instance handle.
 */

PWC FindClass16(LPCSTR pszClass, HAND16 hInst)
{
    register PWC pwc;

    if (!(pwc = (PWC)(pfnOut.pfnGetClassWOWWords)(HMODINST32(hInst), pszClass))) {
        LOGDEBUG(LOG_ALWAYS,("WOW::FindClass16(): *** pwc is NULL, pszClass -> %s and hInst -> %04x\n", pszClass, hInst));
        WOW32ASSERT(FALSE);
    }

    return (pwc);
}


/*
 * WOWCleanup(hModule16, fDll)
 *   is a ***private*** API for WOW only.  It cleans up any USER
 *   objects created by this hModule, most notably classes. The
 *   argument is a 32-bit handle, USER looks only at the upper
 *   16 bits to find the hModule16
 */
VOID WOWCleanup(HANDLE hModule16, BOOL fDll);

VOID DestroyClasses16(HAND16 hModule16, BOOL fDll)
{
    (pfnOut.pfnWOWCleanup)((HANDLE) MAKELONG(0, hModule16), fDll);
}



#ifdef DEBUG

INT nAliases;
INT iLargestListSlot;

PSZ apszHandleClasses[] = {
    "Unknown",      // WOWCLASS_UNKNOWN
    "Window",       // WOWCLASS_WIN16
    "Button",       // WOWCLASS_BUTTON
    "ComboBox",     // WOWCLASS_COMBOBOX
    "Edit",         // WOWCLASS_EDIT
    "ListBox",      // WOWCLASS_LISTBOX
    "MDIClient",    // WOWCLASS_MDICLIENT
    "Scrollbar",    // WOWCLASS_SCROLLBAR
    "Static",       // WOWCLASS_STATIC
    "Desktop",      // WOWCLASS_DESKTOP
    "Dialog",       // WOWCLASS_DIALOG
    "Menu",         // WOWCLASS_MENU
    "IconTitle",    // WOWCLASS_ICONTITLE
    "Accel",        // WOWCLASS_ACCEL
    "Cursor",       // WOWCLASS_CURSOR
    "Icon",         // WOWCLASS_ICON
    "DC",           // WOWCLASS_DC
    "Font",         // WOWCLASS_FONT
    "MetaFile",     // WOWCLASS_METAFILE
    "Region",       // WOWCLASS_RGN
    "Bitmap",       // WOWCLASS_BITMAP
    "Brush",        // WOWCLASS_BRUSH
    "Palette",      // WOWCLASS_PALETTE
    "Pen",          // WOWCLASS_PEN
    "Object"        // WOWCLASS_OBJECT
};


BOOL MessageNeedsThunking(UINT uMsg)
{
    switch (uMsg) {
        case WM_CREATE:
        case WM_ACTIVATE:
        case WM_SETFOCUS:
        case WM_KILLFOCUS:
        case WM_SETTEXT:
        case WM_GETTEXT:
        case WM_ERASEBKGND:
        case WM_WININICHANGE:
        case WM_DEVMODECHANGE:
        case WM_ACTIVATEAPP:
        case WM_SETCURSOR:
        case WM_MOUSEACTIVATE:
        case WM_GETMINMAXINFO:
        case WM_ICONERASEBKGND:
        case WM_NEXTDLGCTL:
        case WM_DRAWITEM:
        case WM_MEASUREITEM:
        case WM_DELETEITEM:
        case WM_VKEYTOITEM:
        case WM_CHARTOITEM:
        case WM_SETFONT:
        case WM_GETFONT:
        case WM_QUERYDRAGICON:
        case WM_COMPAREITEM:
        case WM_OTHERWINDOWCREATED:
        case WM_OTHERWINDOWDESTROYED:
        case WM_COMMNOTIFY:
        case WM_WINDOWPOSCHANGING:
        case WM_WINDOWPOSCHANGED:
        case WM_NCCREATE:
        case WM_NCCALCSIZE:
        case WM_COMMAND:
        case WM_HSCROLL:
        case WM_VSCROLL:
        case WM_INITMENU:
        case WM_INITMENUPOPUP:
        case WM_MENUSELECT:
        case WM_MENUCHAR:
        case WM_ENTERIDLE:
        case WM_CTLCOLORMSGBOX:
        case WM_CTLCOLOREDIT:
        case WM_CTLCOLORLISTBOX:
        case WM_CTLCOLORBTN:
        case WM_CTLCOLORDLG:
        case WM_CTLCOLORSCROLLBAR:
        case WM_CTLCOLORSTATIC:
        case WM_PARENTNOTIFY:
        case WM_MDICREATE:
        case WM_MDIDESTROY:
        case WM_MDIACTIVATE:
        case WM_MDIGETACTIVE:
        case WM_MDISETMENU:
        case WM_RENDERFORMAT:
        case WM_PAINTCLIPBOARD:
        case WM_VSCROLLCLIPBOARD:
        case WM_SIZECLIPBOARD:
        case WM_ASKCBFORMATNAME:
        case WM_CHANGECBCHAIN:
        case WM_HSCROLLCLIPBOARD:
        case WM_PALETTEISCHANGING:
        case WM_PALETTECHANGED:
        case MM_JOY1MOVE:
        case MM_JOY2MOVE:
        case MM_JOY1ZMOVE:
        case MM_JOY2ZMOVE:
        case MM_JOY1BUTTONDOWN:
        case MM_JOY2BUTTONDOWN:
        case MM_JOY1BUTTONUP:
        case MM_JOY2BUTTONUP:
        case MM_MCINOTIFY:
        case MM_MCISYSTEM_STRING:
        case MM_WOM_OPEN:
        case MM_WOM_CLOSE:
        case MM_WOM_DONE:
        case MM_WIM_OPEN:
        case MM_WIM_CLOSE:
        case MM_WIM_DATA:
        case MM_MIM_OPEN:
        case MM_MIM_CLOSE:
        case MM_MIM_DATA:
        case MM_MIM_LONGDATA:
        case MM_MIM_ERROR:
        case MM_MIM_LONGERROR:
        case MM_MOM_OPEN:
        case MM_MOM_CLOSE:
        case MM_MOM_DONE:
            LOGDEBUG(LOG_IMPORTANT,
                ("MessageNeedsThunking: WM_msg %04x is not thunked\n", uMsg));
            return TRUE;

        default:
            return FALSE;

    }
}

#endif


extern PTD gptdTaskHead;

PTD ThreadID32toPTD(DWORD ThreadID32)
{
    PTD  ptd;

    ptd = gptdTaskHead;

    while(ptd) {

        if(ptd->dwThreadID == ThreadID32)
            return(ptd);

        ptd = ptd->ptdNext;
    }

    return((PTD)NULL);

}

PTD Htask16toPTD(
    HTASK16 htask16
) {
    PTD  ptd;

    ptd = gptdTaskHead;

    while(ptd) {

        if ( ptd->htask16 == htask16 ) {
            return( ptd );
        }
        ptd = ptd->ptdNext;
    }

    return((PTD)NULL);
}


HTASK16 ThreadID32toHtask16(
    DWORD   ThreadID32
) {
    PTD ptd;
    HTASK16 htask16;

    if ( ThreadID32 == 0 ) {
        LOGDEBUG (LOG_ALWAYS, ("WOW::ThreadID32tohTask16: Thread ID is 0\n"));
        WOW32ASSERT (FALSE);
        return( 0 );
    }

    ptd = ThreadID32toPTD( ThreadID32 );
    if ( ptd ) {
        // Good, its one of our wow threads.
        return( ptd->htask16 );
    } else {
        // Nope, its is some other 32-bit thread
        htask16 = FindHtaskAlias( ThreadID32 );
        if ( htask16 == 0 ) {
            //
            // See the comment in WOLE2.C for a nice description
            //
            htask16 = AddHtaskAlias( ThreadID32 );
        }
        return( htask16 );
    }
}

DWORD Htask16toThreadID32(
    HTASK16 htask16
) {
    if ( htask16 == 0 ) {
        return( 0 );
    }

    if ( ISTASKALIAS(htask16) ) {
        return( GetHtaskAlias(htask16,NULL) );
    } else {
        return( THREADID32(htask16) );
    }
}

//***************************************************************************
// GetGCL_HMODULE - returns the valid hmodule if the window corresponds to
//                  a 16bit class else returns the hmodule of 16bit user.exe
//                  if the window is of a standard class.
//
// These cases are required for compatibility sake.
//         apps like VirtualMonitor, hDC etc depend on such behaviour.
//                                                              - Nanduri
//***************************************************************************
WORD gUser16hInstance = 0;

ULONG GetGCL_HMODULE(HWND hwnd)
{
    ULONG ul;

    ul = (ULONG)GetClassLong(hwnd, GCL_HMODULE);
    if (ul != 0 && (WORD)ul == 0) {          // hMod32 = 0xZZZZ0000
        ul = (ULONG) gUser16hInstance;
        WOW32ASSERT(ul);
    }
    else {
        ul = (ULONG)GETHMOD16(ul);      // 32-bit hmod is HMODINST32
    }

    return ul;
}

//
// EXPORTED handle mapping functions.  WOW32 code should use the
// macros defined in walias.h -- these functions are for use by
// third-party 32-bit code running in WOW, for example called
// using generic thunks from WOW-specific 16-bit code.
//

HANDLE WOWHandle32 (WORD h16, WOW_HANDLE_TYPE htype)
{
    switch (htype) {
        case WOW_TYPE_HWND:
            return HWND32(h16);
        case WOW_TYPE_HMENU:
            return HMENU32(h16);
        case WOW_TYPE_HDWP:
            return HDWP32(h16);
        case WOW_TYPE_HDROP:
            return HDROP32(h16);
        case WOW_TYPE_HDC:
            return HDC32(h16);
        case WOW_TYPE_HFONT:
            return HFONT32(h16);
        case WOW_TYPE_HMETAFILE:
            return HMETA32(h16);
        case WOW_TYPE_HRGN:
            return HRGN32(h16);
        case WOW_TYPE_HBITMAP:
            return HBITMAP32(h16);
        case WOW_TYPE_HBRUSH:
            return HBRUSH32(h16);
        case WOW_TYPE_HPALETTE:
            return HPALETTE32(h16);
        case WOW_TYPE_HPEN:
            return HPEN32(h16);
        case WOW_TYPE_HACCEL:
            return HACCEL32(h16);
        case WOW_TYPE_HTASK:
            return (HANDLE)HTASK32(h16);
        case WOW_TYPE_FULLHWND:
            return FULLHWND32(h16);
        default:
            return(INVALID_HANDLE_VALUE);
    }
}

WORD WOWHandle16 (HANDLE h32, WOW_HANDLE_TYPE htype)
{
    switch (htype) {
        case WOW_TYPE_HWND:
            return GETHWND16(h32);
        case WOW_TYPE_HMENU:
            return GETHMENU16(h32);
        case WOW_TYPE_HDWP:
            return GETHDWP16(h32);
        case WOW_TYPE_HDROP:
            return GETHDROP16(h32);
        case WOW_TYPE_HDC:
            return GETHDC16(h32);
        case WOW_TYPE_HFONT:
            return GETHFONT16(h32);
        case WOW_TYPE_HMETAFILE:
            return GETHMETA16(h32);
        case WOW_TYPE_HRGN:
            return GETHRGN16(h32);
        case WOW_TYPE_HBITMAP:
            return GETHBITMAP16(h32);
        case WOW_TYPE_HBRUSH:
            return GETHBRUSH16(h32);
        case WOW_TYPE_HPALETTE:
            return GETHPALETTE16(h32);
        case WOW_TYPE_HPEN:
            return GETHPEN16(h32);
        case WOW_TYPE_HACCEL:
            return GETHACCEL16(h32);
        case WOW_TYPE_HTASK:
            return GETHTASK16(h32);
        default:
            return(0xffff);
    }
}

