// Microsoft OLE library. 
// Copyright (C) 1992 Microsoft Corporation, 
// All rights reserved. 

// olecoll.h - global defines for collections and element definitions

#ifndef __OLECOLL_H__
#define __OLECOLL_H__


// ---------------------------------------------------------------------------
// general defines for collections

typedef void FAR* POSITION;

#define BEFORE_START_POSITION ((POSITION)(ULONG)-1L)
#define _AFX_FP_OFF(thing) (*((UINT FAR*)&(thing)))
#define _AFX_FP_SEG(lp) (*((UINT FAR*)&(lp)+1))

#ifdef _DEBUG
#define ASSERT_VALID(p) p->AssertValid()
#else
#define ASSERT_VALID(p)
#endif


// ---------------------------------------------------------------------------
// element defintions; can only depend upon definitions in ole2int.h

// per-task data; warning, there is no destructor and so 
// releasing the elements of the mapping must be done by hand;
// this also means that RemoveAll should not be called and that
// RemoveKey should be called only after freeing the contained maps.
struct FAR Etask
{
	DWORD m_pid;						// unique process id 
	DWORD m_inits;						// number of times init'd
	DWORD m_oleinits;					// number of OleInit
	DWORD m_reserved;					// reserved
	IMalloc FAR* m_pMalloc;				// task allocator (always one)
	IMalloc FAR* m_pMallocShared;		// shared allocator (always one)
	IMalloc FAR* m_pMallocSBlock;		// shared block allocator (if one)
	IMalloc FAR* m_pMallocPrivate;		// private allocator (if one)
	class CDlls FAR* m_pDlls;			// list of dlls loaded and their counts
	class CMapGUIDToPtr FAR* m_pMapToServerCO;//server class obj if reg/loaded
	class CMapGUIDToPtr FAR* m_pMapToHandlerCO;//handler CO obj if reg/loaded

	class CSHArray FAR* m_pArraySH;		// array of server/handler entries

	class CThrd FAR* m_pCThrd;			// pointer to header of thread list
	HWND  m_hwndClip;					// hwnd of our clip window
	HWND  m_hwndDde;					// hwnd of system dde window
	IUnknown FAR* m_punkState;		// Storage for CoGet/SetState
};

//
// BUGBUG - This header file was taken from \\ole\slm\src\dll\src\inc
// But it appears to need everything in the world, even though it doesn't
// use it.  Bad factoring of header file info I bet.  For now I'm commenting
// this out until its proven that I need it.
//
#ifdef LATER
// per-proxy/stub dll info (Epsdll); must release elements by hand as above.
struct FAR Epsdll
{
	IPSFactory FAR* m_pPSFactory;		// pointer to ps factory
	class CPtrArray FAR* m_rgPS;		// proxies/stubs which are loaded
};
#endif

#endif //!__OLECOLL_H__
