//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft shared
// source or premium shared source license agreement under which you licensed
// this source code. If you did not accept the terms of the license agreement,
// you are not authorized to use this source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the SOURCE.RTF on your install media or the root of your tools installation.
// THE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
/***
*wcscat.c - contains wcscat() and wcscpy()
*
*	Copyright (c) Microsoft Corporation. All rights reserved.
*
*Purpose:
*	wcscat() appends one wchar_t string onto another.
*	wcscpy() copies one wchar_t string into another.
*
*	wcscat() concatenates (appends) a copy of the source string to the
*	end of the destination string, returning the destination string.
*	Strings are wide-character strings.
*
*	wcscpy() copies the source string to the spot pointed to be
*	the destination string, returning the destination string.
*	Strings are wide-character strings.
*
*Revision History:
*	09-09-91  ETC	Created from strcat.c.
*	04-07-92  KRS	Updated and ripped out _INTL switches.
*	04-06-93  SKS	Replace _CRTAPI* with __cdecl
*       02-07-94  CFW   POSIXify.
*
*******************************************************************************/

#ifndef _POSIX_

#include <cruntime.h>
#include <string.h>

#if defined(_M_X64) || defined(_M_IX86) || defined(_M_ARM)
#pragma warning(disable:4163)
#pragma function(wcscpy, wcscat)
#endif

/***
*wchar_t *wcscat(dst, src) - concatenate (append) one wchar_t string to another
*
*Purpose:
*	Concatenates src onto the end of dest.	Assumes enough
*	space in dest.
*
*Entry:
*	wchar_t *dst - wchar_t string to which "src" is to be appended
*	const wchar_t *src - wchar_t string to be appended to the end of "dst"
*
*Exit:
*	The address of "dst"
*
*Exceptions:
*
*******************************************************************************/

wchar_t * __cdecl wcscat (
	wchar_t * dst,
	const wchar_t * src
	)
{
	wchar_t * cp = dst;

	while( *cp )
		cp++;			/* find end of dst */

	while( *cp++ = *src++ ) ;	/* Copy src to end of dst */

	return( dst );			/* return dst */

}


/***
*wchar_t *wcscpy(dst, src) - copy one wchar_t string over another
*
*Purpose:
*	Copies the wchar_t string src into the spot specified by
*	dest; assumes enough room.
*
*Entry:
*	wchar_t * dst - wchar_t string over which "src" is to be copied
*	const wchar_t * src - wchar_t string to be copied over "dst"
*
*Exit:
*	The address of "dst"
*
*Exceptions:
*******************************************************************************/

wchar_t * __cdecl wcscpy(wchar_t * dst, const wchar_t * src)
{
	wchar_t * cp = dst;

	while( *cp++ = *src++ )
		;		/* Copy src over dst */

	return( dst );
}

#endif /* _POSIX_ */
