//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft shared
// source or premium shared source license agreement under which you licensed
// this source code. If you did not accept the terms of the license agreement,
// you are not authorized to use this source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the SOURCE.RTF on your install media or the root of your tools installation.
// THE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
/***
*fsetpos.c - Contains fsetpos runtime
*
*       Copyright (c) Microsoft Corporation. All rights reserved.
*
*Purpose:
*       Fsetpos sets the file position using an internal value returned by an
*       earlier fgetpos call.
*
*Revision History:
*       01-16-87  JCR   Module created
*       04-13-87  JCR   Added const to declaration
*       12-11-87  JCR   Added "_LOAD_DS" to declaration
*       02-15-90  GJF   Fixed copyright and indents
*       03-19-90  GJF   Replaced _LOAD_DS with _CALLTYPE1 and added #include
*                       <cruntime.h>.
*       10-02-90  GJF   New-style function declarators.
*       04-06-93  SKS   Replace _CRTAPI* with __cdecl
*       12-23-94  GJF   Use 64-bit file position (_fseeki64) for non-_MAC_.
*       01-05-94  GJF   Temporarily commented out above change due to MFC/IDE
*                       bugs.
*       01-24-95  GJF   Restored 64-bit fpos_t support.
*       06-28-96  SKS   Enable 64-bit fpos_t support for the MAC
*       05-17-99  PML   Remove all Macintosh support.
*       09-11-03  SJ    Secure CRT Work - Assertions & Validations
*       02-03-04  SJ    VSW#190341 - validate param to fgetpos
*
*******************************************************************************/

#include <cruntime.h>
#include <stdio.h>
#include <internal.h>

/***
*int fsetpos(stream,pos) - Set file positioning
*
*Purpose:
*       Fsetpos sets the file position for the file indicated by [stream] to
*       the position indicated by [pos].  The [pos] value is defined to be in
*       an internal format (not to be interpreted by the user) and has been
*       generated by an earlier fgetpos call.
*
*Entry:
*       FILE *stream = pointer to a file stream value
*       fpos_t *pos = pointer to a file positioning value
*
*Exit:
*       Successful call returns 0.
*       Unsuccessful call returns non-zero (!0).
*
*Exceptions:
*       None.
*******************************************************************************/

int __cdecl fsetpos (
        FILE *stream,
        const fpos_t *pos
        )
{
        _VALIDATE_RETURN( (stream != NULL), EINVAL, -1);
        _VALIDATE_RETURN( (pos != NULL), EINVAL, -1);
        
#ifdef _POSIX_
        return( fseek(stream, *pos, SEEK_SET) );
#else
        return( _fseeki64(stream, *pos, SEEK_SET) );
#endif
}
