//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft shared
// source or premium shared source license agreement under which you licensed
// this source code. If you did not accept the terms of the license agreement,
// you are not authorized to use this source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the SOURCE.RTF on your install media or the root of your tools installation.
// THE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
//

#define PERFSCEN_NAMESPACE_THROUGHPUT_WR            L"Filesys\\Throughput Writefile"
#define PERFSCEN_NAMESPACE_THROUGHPUT_RD            L"Filesys\\Throughput Readfile"
#define PERFSCEN_NAMESPACE_THROUGHPUT_WR_RAND       L"Filesys\\Throughput Writefile Random"
#define PERFSCEN_NAMESPACE_THROUGHPUT_RD_RAND       L"Filesys\\Throughput Readfile Random"
#define PERFSCEN_NAMESPACE_THROUGHPUT_RD_REVERSE    L"Filesys\\Throughput Reverse Readfile"
#define PERFSCEN_NAMESPACE_THROUGHPUT_OVRWR         L"Filesys\\Throughput Overwrite"
#define PERFSCEN_NAMESPACE_DEEPTREE                 L"Filesys\\Create Directory Tree"
#define PERFSCEN_NAMESPACE_SETENDOFFILE             L"Filesys\\SetFilePointer and SetEndOfFile"
#define PERFSCEN_NAMESPACE_SEEKSPEED                L"Filesys\\Seek Speed"
#define PERFSCEN_NAMESPACE_READAPPENDFRAG           L"Filesys\\Read/Append to Fragmented File"
#define PERFSCEN_NAMESPACE_COPYFILES                L"Filesys\\Copy Files"
#define PERFSCEN_NAMESPACE_FINDFIRST                L"Filesys\\FindFirstFile FindNextFile"
#define PERFSCEN_NAMESPACE_FINDFIRSTRAND            L"Filesys\\FindFirstFile FindNextFile Random"
#define PERFSCEN_NAMESPACE_CREATEFILENEW            L"Filesys\\Create File CREATE_NEW"
#define PERFSCEN_NAMESPACE_CREATEFILEEXISTING       L"Filesys\\Create File OPEN_EXISTING"

#define PERFSCEN_NAME_THROUGHPUT_WR         L"Throughput Writefile; BufferSize(%d bytes)"
#define PERFSCEN_NAME_THROUGHPUT_RD         L"Throughput Readfile; BufferSize(%d bytes)"
#define PERFSCEN_NAME_THROUGHPUT_WR_RAND    L"Throughput Writefile Random; BufferSize(%d bytes)"
#define PERFSCEN_NAME_THROUGHPUT_RD_RAND    L"Throughput Readfile Random; BufferSize(%d bytes)"
#define PERFSCEN_NAME_THROUGHPUT_RD_REVERSE L"Throughput Reverse Readfile; BufferSize(%d bytes)"
#define PERFSCEN_NAME_THROUGHPUT_OVRWR      L"Throughput Overwrite; BufferSize(%d bytes)"

#define PERFSCEN_NAME_DEEPTREE              L"Create Directory Tree; Depth(%d levels)"
#define PERFSCEN_NAME_SETENDOFFILE          L"SetFilePointer and SetEndOfFile; FileSize(%d bytes)"
#define PERFSCEN_NAME_SEEKSPEED             L"Seek Speed; Operation(%s)"
#define PERFSCEN_NAME_READAPPENDFRAG        L"Read/Append to Fragmented File; TotalDataTransferSize(%d bytes)"
#define PERFSCEN_NAME_COPYFILES             L"Copy Files; Direction(%s)"
#define PERFSCEN_NAME_FINDFIRST             L"FindFirstFile FindNextFile; SearchString(%s); TotalNumFiles(%d files)"
#define PERFSCEN_NAME_FINDFIRSTRAND         L"FindFirstFile FindNextFile Random; SearchString(%s); TotalNumFiles(%d files)"
#define PERFSCEN_NAME_CREATEFILENEW         L"Create File CREATE_NEW; TotalNumFiles(%d files)"
#define PERFSCEN_NAME_CREATEFILEEXISTING    L"Create File OPEN_EXISTING; TotalNumFiles(%d files)"

#define STR_THROUGHPUT                      L"Throughput (bytes/s)"

#define GUID_OFFSET_THROUGHPUT_128B     0
#define GUID_OFFSET_THROUGHPUT_256B     6
#define GUID_OFFSET_THROUGHPUT_512B     12
#define GUID_OFFSET_THROUGHPUT_1KB      18
#define GUID_OFFSET_THROUGHPUT_2KB      24
#define GUID_OFFSET_THROUGHPUT_4KB      30
#define GUID_OFFSET_THROUGHPUT_8KB      36
#define GUID_OFFSET_THROUGHPUT_16KB     42
#define GUID_OFFSET_THROUGHPUT_32KB     48
#define GUID_OFFSET_THROUGHPUT_64KB     54
#define GUID_OFFSET_THROUGHPUT_128KB    60
#define GUID_OFFSET_THROUGHPUT_256KB    66
#define GUID_OFFSET_THROUGHPUT_512KB    72
#define GUID_OFFSET_THROUGHPUT_1M       78

#define GUID_OFFSET_DEEPTREE            84
#define GUID_OFFSET_SETENDOFFILE        87
#define GUID_OFFSET_SEEKSPEED           88
#define GUID_OFFSET_READAPPENDFRAG      90
#define GUID_OFFSET_COPYFILES           91
#define GUID_OFFSET_FINDFIRST           93
#define GUID_OFFSET_FINDFIRSTRAND       102
#define GUID_OFFSET_CREATEFILENEW       111
#define GUID_OFFSET_CREATEFILEEXISTING  112

extern __declspec(selectany) GUID g_PERFGUID[] = {
{ 0x437a46f2, 0x82ac, 0x4069, { 0x92, 0x7e, 0x61, 0xd7, 0xfe, 0x4d, 0xe8, 0x42 } }, // 0,  2001, WriteFile,       128B
{ 0x7d934e37, 0x9ab9, 0x4639, { 0xb0, 0x82, 0xb8, 0x2a, 0xc4, 0x06, 0x71, 0xeb } }, // 1,  2001, ReadFile,        128B 
{ 0x13afb036, 0x5db2, 0x4cdc, { 0x98, 0x8c, 0xae, 0xa4, 0xbe, 0x5d, 0x92, 0x9e } }, // 2,  2001, WriteFileRandom, 128B 
{ 0x4d10e224, 0x4bcf, 0x4932, { 0x8d, 0x6d, 0xf4, 0x2e, 0x74, 0x8f, 0x37, 0x3f } }, // 3,  2001, ReadFileRandom,  128B 
{ 0xe082247e, 0xc276, 0x417c, { 0x81, 0x63, 0xb5, 0x10, 0xd0, 0x00, 0xdd, 0x0a } }, // 4,  2001, ReverseReadFile, 128B 
{ 0xc71ade17, 0xa1cb, 0x4d4c, { 0xa9, 0xd3, 0x65, 0x34, 0x3d, 0xec, 0x91, 0x64 } }, // 5,  2001, OverWriteFile,   128B 

{ 0x7b615a29, 0x2b8b, 0x4f58, { 0x82, 0x8f, 0xfa, 0xc8, 0x6b, 0x30, 0xe7, 0x99 } }, // 6,  2002, WriteFile,       256B
{ 0xb7db4424, 0x1edc, 0x4a22, { 0xb2, 0xdc, 0x76, 0x62, 0x2d, 0x74, 0x6d, 0xb3 } }, // 7,  2002, ReadFile,        256B
{ 0x8eb9e93e, 0xe4fc, 0x4578, { 0xb3, 0xb8, 0x53, 0x99, 0x3b, 0x83, 0xc7, 0xb7 } }, // 8,  2002, WriteFileRandom, 256B
{ 0xd35945b1, 0x1239, 0x48b7, { 0xab, 0x56, 0xff, 0x4c, 0x3b, 0x2c, 0x9f, 0x77 } }, // 9,  2002, ReadFileRandom,  256B
{ 0xcb2d4540, 0x86f3, 0x40a0, { 0x8a, 0x8c, 0xdb, 0xd8, 0xf7, 0x4e, 0x24, 0x3f } }, // 10, 2002, ReverseReadFile, 256B 
{ 0x30fe2d4c, 0xad29, 0x46ca, { 0x93, 0xd8, 0xe5, 0x1e, 0x89, 0x63, 0x5a, 0xdb } }, // 11, 2002, OverWriteFile,   256B

{ 0x58f4de97, 0x13ed, 0x4f7d, { 0xa9, 0x6c, 0x83, 0xe3, 0x11, 0xa6, 0x2d, 0x01 } }, // 12,  2003, WriteFile,       512B
{ 0xf289edf0, 0xd350, 0x4b83, { 0xb7, 0x3a, 0x42, 0xe9, 0x7c, 0xf1, 0x34, 0xa5 } }, // 13,  2003, ReadFile,        512B
{ 0x2cfbb1b0, 0xe6b5, 0x4311, { 0xa3, 0x04, 0x5f, 0xa7, 0x2d, 0x4f, 0x0d, 0xf1 } }, // 14,  2003, WriteFileRandom, 512B
{ 0xd25afcaa, 0x9300, 0x4da2, { 0x8d, 0xe8, 0xb2, 0x4f, 0xd8, 0x1b, 0x00, 0x88 } }, // 15,  2003, ReadFileRandom,  512B
{ 0x5ed6784f, 0x8492, 0x40fa, { 0x9f, 0xe1, 0x8e, 0x52, 0x22, 0xa7, 0x1d, 0x07 } }, // 16,  2003, ReverseReadFile, 512B 
{ 0x45ca4f1f, 0x8eba, 0x4b70, { 0xb8, 0x86, 0x34, 0x1a, 0x10, 0xa2, 0x14, 0xb4 } }, // 17,  2003, OverWriteFile,   512B

{ 0x5bb2f3ad, 0x7596, 0x4f7f, { 0x8a, 0x7f, 0xbb, 0x5b, 0x0d, 0x9d, 0xc3, 0x22 } }, // 18,  2004, WriteFile,       1KB
{ 0x7436ed6f, 0x265b, 0x4e06, { 0x9c, 0x0c, 0x9e, 0x3d, 0x69, 0x59, 0x29, 0x49 } }, // 19,  2004, ReadFile,        1KB
{ 0x1428fd37, 0xab6a, 0x4295, { 0x97, 0x8d, 0xc1, 0xde, 0x9a, 0xcf, 0x58, 0x9b } }, // 20,  2004, WriteFileRandom, 1KB
{ 0xdecfb313, 0x8793, 0x4427, { 0xb7, 0x00, 0xb0, 0x47, 0xda, 0x9e, 0xa7, 0x1c } }, // 21,  2004, ReadFileRandom,  1KB
{ 0xb37f2984, 0x7419, 0x485f, { 0xad, 0x10, 0xb2, 0x3a, 0x2c, 0xc1, 0xe6, 0xe0 } }, // 22,  2004, ReverseReadFile, 1KB 
{ 0x9c1e6c9b, 0x9ad2, 0x4048, { 0x89, 0xed, 0x25, 0x07, 0x74, 0x2f, 0x88, 0x16 } }, // 23,  2004, OverWriteFile,   1KB

{ 0xc3cc4147, 0xb6be, 0x43f8, { 0xb7, 0x1d, 0x38, 0xdb, 0x0e, 0xb1, 0x55, 0xfb } }, // 24,  2005, WriteFile,       2KB
{ 0xebccd84d, 0x0dd9, 0x451f, { 0xb5, 0xb6, 0x90, 0x51, 0x5d, 0x36, 0xce, 0x79 } }, // 25,  2005, ReadFile,        2KB
{ 0xcd4d2337, 0xa500, 0x4852, { 0x86, 0x07, 0xf0, 0x03, 0xd8, 0x30, 0x4c, 0xcf } }, // 26,  2005, WriteFileRandom, 2KB
{ 0x8e7e655c, 0x840f, 0x4d5a, { 0xae, 0x9c, 0x3b, 0x9d, 0x09, 0x4b, 0x87, 0x62 } }, // 27,  2005, ReadFileRandom,  2KB
{ 0x0b053970, 0x4081, 0x4093, { 0xb2, 0xe6, 0x75, 0x75, 0x0f, 0x38, 0x47, 0x85 } }, // 28,  2005, ReverseReadFile, 2KB 
{ 0xc211629c, 0x6272, 0x4d73, { 0x8f, 0xed, 0x00, 0x84, 0xb8, 0x16, 0x5c, 0xfd } }, // 29,  2005, OverWriteFile,   2KB

{ 0x051fe22a, 0xee74, 0x442c, { 0x8f, 0x6c, 0x9d, 0x7d, 0x8b, 0x92, 0xbc, 0x9e } }, // 30,  2006, WriteFile,       4KB
{ 0x20df4b0c, 0xc5d4, 0x43e6, { 0xb7, 0x4f, 0x5b, 0x6c, 0x2c, 0x26, 0xbf, 0xd6 } }, // 31,  2006, ReadFile,        4KB
{ 0xa0fc2735, 0x7bb3, 0x42ba, { 0x8d, 0x4b, 0x25, 0x16, 0x7c, 0x9b, 0x39, 0xd1 } }, // 32,  2006, WriteFileRandom, 4KB
{ 0xe9cd3074, 0xf3ca, 0x4647, { 0xb4, 0x6f, 0x6b, 0x3f, 0xf3, 0xa5, 0x8d, 0x12 } }, // 33,  2006, ReadFileRandom,  4KB
{ 0xea532f72, 0xac6c, 0x43b7, { 0x9f, 0x70, 0x66, 0x64, 0xbe, 0xbf, 0xbb, 0xde } }, // 34,  2006, ReverseReadFile, 4KB 
{ 0xdd17ed64, 0x207c, 0x4899, { 0xa9, 0x7c, 0xe0, 0x56, 0x40, 0x0c, 0xad, 0x9a } }, // 35,  2006, OverWriteFile,   4KB

{ 0x43dd169c, 0x2d06, 0x4454, { 0x8b, 0x7e, 0x37, 0x86, 0xc2, 0x7b, 0x5c, 0x5c } }, // 36,  2007, WriteFile,       8KB
{ 0x6dd90568, 0x0560, 0x4a99, { 0xb3, 0xca, 0xf9, 0xb3, 0xb3, 0xac, 0xd8, 0x77 } }, // 37,  2007, ReadFile,        8KB
{ 0x4d12e5d9, 0x9578, 0x4a00, { 0x8f, 0x13, 0x63, 0x50, 0x1a, 0xca, 0xb6, 0x89 } }, // 38,  2007, WriteFileRandom, 8KB
{ 0x101f0ee9, 0xc4f1, 0x48ad, { 0xb8, 0xec, 0x8f, 0x32, 0xe4, 0x99, 0x75, 0xb6 } }, // 39,  2007, ReadFileRandom,  8KB
{ 0xc5c2b090, 0x281f, 0x4ad5, { 0xa0, 0x47, 0x64, 0x69, 0x79, 0x41, 0x00, 0x3b } }, // 40,  2007, ReverseReadFile, 8KB 
{ 0x6acd3295, 0xfae7, 0x4e50, { 0x9b, 0xba, 0xc6, 0x5f, 0x3e, 0x0d, 0x93, 0xca } }, // 41,  2007, OverWriteFile,   8KB

{ 0xdb4d5f3d, 0xfd7c, 0x4dbf, { 0xb3, 0x1d, 0x6b, 0x0a, 0x8b, 0x29, 0xa1, 0x70 } }, // 42,  2008, WriteFile,       16KB
{ 0x488497d0, 0xb34a, 0x48d5, { 0xb3, 0xcc, 0x1d, 0x6f, 0x1d, 0x2d, 0x7c, 0x4e } }, // 43,  2008, ReadFile,        16KB
{ 0x86286a78, 0x1462, 0x44a2, { 0x86, 0xa4, 0x17, 0xeb, 0x51, 0xa5, 0x1d, 0xab } }, // 44,  2008, WriteFileRandom, 16KB
{ 0x1d7b670c, 0x5dc8, 0x46e8, { 0xb1, 0x4d, 0x48, 0xd0, 0x50, 0x16, 0xdf, 0x32 } }, // 45,  2008, ReadFileRandom,  16KB
{ 0x5be2485f, 0x1387, 0x4fc4, { 0x85, 0xd4, 0xd2, 0xae, 0x45, 0x4c, 0x12, 0x4d } }, // 46,  2008, ReverseReadFile, 16KB 
{ 0x88b97dbb, 0x1fbc, 0x4e40, { 0xbf, 0xca, 0x3b, 0x9a, 0xf5, 0x5f, 0x76, 0x1a } }, // 47,  2008, OverWriteFile,   16KB

{ 0x1d8b5806, 0x15e8, 0x42ed, { 0x81, 0x48, 0x42, 0xf6, 0xa5, 0xdd, 0x1c, 0xd8 } }, // 48,  2009, WriteFile,       32KB
{ 0xad7adc0f, 0xb790, 0x41f4, { 0x9e, 0x6e, 0x5a, 0xc9, 0x1e, 0xfd, 0x9d, 0xbb } }, // 49,  2009, ReadFile,        32KB
{ 0xf6083c3c, 0x841f, 0x4cb1, { 0x89, 0xf0, 0x98, 0x07, 0xda, 0xea, 0x8e, 0x1e } }, // 50,  2009, WriteFileRandom, 32KB
{ 0xab56afcc, 0x3439, 0x4532, { 0xb9, 0x3a, 0xd7, 0xb1, 0x24, 0xe2, 0xf8, 0xd6 } }, // 51,  2009, ReadFileRandom,  32KB
{ 0x5f1436cf, 0xffe7, 0x4007, { 0xa4, 0xd9, 0x77, 0x7b, 0xb4, 0x17, 0x11, 0xa4 } }, // 52,  2009, ReverseReadFile, 32KB 
{ 0x7e18ffa0, 0xcecb, 0x4b8f, { 0xa6, 0x37, 0xc3, 0x27, 0xc4, 0x7a, 0x91, 0xea } }, // 53,  2009, OverWriteFile,   32KB

{ 0x4405c2b9, 0x981b, 0x4ce4, { 0x9b, 0x04, 0x70, 0xc0, 0xe2, 0xf8, 0x4f, 0x00 } }, // 54,  2010, WriteFile,       64KB
{ 0x13ec974b, 0xf257, 0x46c6, { 0x95, 0x96, 0xb0, 0x21, 0xb3, 0x0c, 0x78, 0xa7 } }, // 55,  2010, ReadFile,        64KB
{ 0x0f1fa62c, 0xf1d0, 0x4b25, { 0x84, 0x5f, 0x7f, 0xe3, 0x5c, 0x9f, 0xc2, 0x9f } }, // 56,  2010, WriteFileRandom, 64KB
{ 0x21ecc4eb, 0x3d35, 0x4af3, { 0xba, 0xe9, 0x24, 0x78, 0xbc, 0x80, 0x5c, 0x3a } }, // 57,  2010, ReadFileRandom,  64KB
{ 0xb966dd78, 0x4b98, 0x402d, { 0x87, 0xad, 0x80, 0x93, 0x7d, 0xce, 0x58, 0x61 } }, // 58,  2010, ReverseReadFile, 64KB 
{ 0xcf3aa666, 0xc2d2, 0x41e7, { 0x91, 0x84, 0xb6, 0xb3, 0x9b, 0xc1, 0xfa, 0x68 } }, // 59,  2010, OverWriteFile,   64KB

{ 0x3294dc2b, 0xe55b, 0x43fe, { 0x80, 0xd2, 0x65, 0x85, 0x48, 0x55, 0x76, 0xed } }, // 60,  2011, WriteFile,       128KB
{ 0x1094b800, 0x0250, 0x4c0e, { 0xa7, 0xd2, 0xf0, 0x0e, 0x72, 0x8a, 0xb6, 0x8b } }, // 61,  2011, ReadFile,        128KB
{ 0xce3bdbf6, 0x9a35, 0x4eca, { 0xb9, 0xfa, 0x5d, 0x63, 0xc7, 0x20, 0x24, 0xef } }, // 62,  2011, WriteFileRandom, 128KB
{ 0xc71ae586, 0x43e7, 0x4930, { 0x93, 0x0f, 0xa8, 0x1a, 0xd3, 0x2e, 0x26, 0xd2 } }, // 63,  2011, ReadFileRandom,  128KB
{ 0xb71e3165, 0x3812, 0x4c10, { 0x86, 0x86, 0xe3, 0xe0, 0xe3, 0x87, 0x64, 0xde } }, // 64,  2011, ReverseReadFile, 128KB 
{ 0xb7134e44, 0x04a4, 0x4312, { 0x9f, 0x81, 0x1f, 0xc0, 0x2c, 0xb7, 0x56, 0x2d } }, // 65,  2011, OverWriteFile,   128KB

{ 0xfa88238f, 0xd9e3, 0x454d, { 0xa5, 0x73, 0xad, 0x70, 0x77, 0x12, 0xd4, 0x64 } }, // 66,  2012, WriteFile,       256KB
{ 0x70ea8e62, 0x72dc, 0x4e65, { 0x84, 0x4f, 0x31, 0x06, 0x8c, 0xcf, 0xb4, 0x14 } }, // 67,  2012, ReadFile,        256KB
{ 0x888bc14f, 0x14aa, 0x43ac, { 0xb1, 0x93, 0x13, 0xbb, 0xb8, 0x68, 0xc2, 0x46 } }, // 68,  2012, WriteFileRandom, 256KB
{ 0x2751cdaf, 0xc008, 0x4ce9, { 0xb5, 0xe5, 0xbf, 0xee, 0x67, 0x04, 0xa4, 0x26 } }, // 69,  2012, ReadFileRandom,  256KB
{ 0x0dc730e0, 0xcc52, 0x4fe0, { 0x9d, 0xe5, 0x98, 0xa4, 0x06, 0xd6, 0x3f, 0xeb } }, // 70,  2012, ReverseReadFile, 256KB 
{ 0xf0e6a088, 0xcc51, 0x4e98, { 0x8a, 0xf7, 0x5c, 0xa8, 0xd5, 0xc7, 0xd3, 0x27 } }, // 71,  2012, OverWriteFile,   256KB

{ 0x4a40e6a3, 0x901c, 0x4b1e, { 0xb5, 0x49, 0x87, 0xc8, 0x82, 0xd5, 0xcd, 0x56 } }, // 72,  2001, WriteFile,       512KB
{ 0xc163bf1e, 0x6d84, 0x490a, { 0x91, 0xa6, 0x6a, 0x3a, 0x16, 0x8b, 0xb4, 0x24 } }, // 73,  2001, ReadFile,        512KB
{ 0x4f22fbf9, 0x68a8, 0x4d3a, { 0xaa, 0xb7, 0x4e, 0x50, 0xbc, 0xf4, 0x74, 0xef } }, // 74,  2001, WriteFileRandom, 512KB
{ 0xe0144b16, 0x97b3, 0x477b, { 0xac, 0xd1, 0x2c, 0x5d, 0xad, 0xbf, 0x17, 0xbf } }, // 75,  2001, ReadFileRandom,  512KB
{ 0x5aae205e, 0x9dc0, 0x40cd, { 0xac, 0x38, 0xdf, 0xf1, 0xf0, 0x9e, 0xf3, 0xb6 } }, // 76,  2001, ReverseReadFile, 512KB 
{ 0xdbc1e12b, 0x1aed, 0x4e14, { 0xba, 0x6b, 0xf1, 0x19, 0xc0, 0x64, 0x8f, 0x70 } }, // 77,  2001, OverWriteFile,   512KB

{ 0x3879b49d, 0xf7fd, 0x41dd, { 0x83, 0xa4, 0x5f, 0xbe, 0xae, 0x65, 0x8b, 0x26 } }, // 78,  2001, WriteFile,       1MB
{ 0xc163bf1e, 0x6d84, 0x490a, { 0x91, 0xa6, 0x6a, 0x3a, 0x16, 0x8b, 0xb4, 0x24 } }, // 79,  2001, ReadFile,        1MB
{ 0x4f22fbf9, 0x68a8, 0x4d3a, { 0xaa, 0xb7, 0x4e, 0x50, 0xbc, 0xf4, 0x74, 0xef } }, // 80,  2001, WriteFileRandom, 1MB
{ 0xe0144b16, 0x97b3, 0x477b, { 0xac, 0xd1, 0x2c, 0x5d, 0xad, 0xbf, 0x17, 0xbf } }, // 81,  2001, ReadFileRandom,  1MB
{ 0x5aae205e, 0x9dc0, 0x40cd, { 0xac, 0x38, 0xdf, 0xf1, 0xf0, 0x9e, 0xf3, 0xb6 } }, // 82,  2001, ReverseReadFile, 1MB 
{ 0xdbc1e12b, 0x1aed, 0x4e14, { 0xba, 0x6b, 0xf1, 0x19, 0xc0, 0x64, 0x8f, 0x70 } }, // 83,  2001, OverWriteFile,   1MB

{ 0x30d450f8, 0x9db5, 0x4f3d, { 0xbe, 0xf1, 0xd6, 0x01, 0x17, 0x16, 0x2a, 0x59 } }, // 84, 3001, DeepTree, 10
{ 0x1f5a46e7, 0x2f76, 0x4ee1, { 0xa6, 0xec, 0x48, 0xbc, 0x3d, 0xe8, 0x05, 0x7b } }, // 85, 3002, DeepTree, 15
{ 0xc5ae1b3d, 0x2c2b, 0x4ca9, { 0xa4, 0x3a, 0x50, 0xb0, 0xba, 0xbc, 0x88, 0x78 } }, // 86, 3003, DeepTree, 20

{ 0xb1cff719, 0x5a8d, 0x469e, { 0xa3, 0xd1, 0x89, 0x8e, 0x5a, 0x4c, 0x4b, 0x83 } }, // 87, 3004, SetEndOfFile

{ 0xf64b6cbe, 0xd026, 0x418b, { 0xaf, 0x73, 0x0f, 0xaa, 0x49, 0x98, 0xed, 0x76 } }, // 88, 3005, SeekSpeed, read
{ 0x135d4b8e, 0xfa4d, 0x42d2, { 0xb3, 0xa9, 0x6a, 0xfc, 0x68, 0x7d, 0x7e, 0x12 } }, // 89, 3006, SeekSpeed, write

{ 0x57964fde, 0x432d, 0x4e3a, { 0x83, 0xfe, 0xc4, 0xd7, 0x55, 0xce, 0xa8, 0x8d } }, // 90, 4001, ReadAppendFragmented

{ 0x227a5053, 0x3182, 0x4a95, { 0x8f, 0xd2, 0x48, 0x35, 0x06, 0xfb, 0x10, 0x77 } }, // 91, 4002, CopyFiles, storage->root
{ 0x5188e8cd, 0x06f5, 0x4570, { 0x9b, 0x6f, 0xb3, 0xa7, 0x86, 0x31, 0x09, 0x9e } }, // 92, 4003, CopyFiles, root->storage

{ 0x7701a12f, 0xeaea, 0x4dc7, { 0x98, 0x38, 0xdd, 0x95, 0x9e, 0x7f, 0x08, 0x94 } }, // 93, 5001, FindFirstNext, perf.file1.jpg, 50
{ 0xd95f7919, 0xb7b0, 0x4891, { 0xbe, 0x48, 0xf6, 0x7d, 0x6b, 0x38, 0xe4, 0xad } }, // 94                       perf.file?.*
{ 0xad3e6036, 0x6593, 0x49c0, { 0xae, 0x69, 0xd9, 0x2c, 0xb6, 0x6e, 0xf2, 0x6a } }, // 95                       perf.file*.*
{ 0x48a16fef, 0x0b55, 0x4007, { 0xbc, 0xc6, 0x99, 0x23, 0x3d, 0x13, 0xbc, 0x36 } }, // 96, 5002, FindFirstNext, perf.file1.jpg, 100
{ 0xfa131220, 0x9bb5, 0x44ca, { 0xbe, 0xbd, 0x3a, 0x0d, 0xe6, 0xc2, 0x2d, 0x69 } }, // 97                       perf.file?.*
{ 0xbc96ae3e, 0xf60e, 0x44d0, { 0xaa, 0xab, 0x0a, 0xbf, 0xc7, 0xef, 0x4b, 0xf3 } }, // 98                       perf.file*.*
{ 0x54934ff3, 0x1f21, 0x40b0, { 0x92, 0x82, 0xcc, 0x9c, 0xb9, 0x28, 0xf5, 0x5c } }, // 99, 5003, FindFirstNext, perf.file1.jpg, 200
{ 0xa9cf9be4, 0x49cd, 0x4e70, { 0x96, 0x8c, 0xa3, 0xd8, 0xfd, 0x6a, 0x63, 0x38 } }, // 100                      perf.file?.*
{ 0x76bacdda, 0xc63b, 0x4e29, { 0xb4, 0x0d, 0x33, 0xf8, 0x26, 0xa8, 0x46, 0xca } }, // 101                      perf.file*.*

{ 0x7f457252, 0x4da7, 0x4950, { 0x8f, 0x46, 0x96, 0x89, 0x64, 0xca, 0x75, 0x68 } }, // 102, 6001, FindFirstNextRand, perf.file1.jpg, 50
{ 0x058cfeb9, 0x826e, 0x455b, { 0xa7, 0x89, 0x58, 0x16, 0xe2, 0x18, 0x67, 0xa2 } }, // 103                           perf.file?.*
{ 0x26d388e5, 0xe6f5, 0x40fb, { 0x88, 0x2f, 0xac, 0xe6, 0xc3, 0x10, 0x84, 0x08 } }, // 104                           perf.file*.*
{ 0x947acda8, 0xba20, 0x4034, { 0xaf, 0x4a, 0xf6, 0x5b, 0xc1, 0x97, 0x8f, 0x3a } }, // 105, 6002, FindFirstNextRand, perf.file1.jpg, 100
{ 0xc813c22f, 0xfb29, 0x465f, { 0x90, 0x77, 0x64, 0x90, 0x7b, 0xf4, 0xea, 0x4d } }, // 106                           perf.file?.*
{ 0x4a6ce956, 0x1bb1, 0x47bb, { 0x96, 0xa2, 0xf5, 0x53, 0xc6, 0x6c, 0x41, 0x95 } }, // 107                           perf.file*.*
{ 0x42b488cb, 0x8c22, 0x4cde, { 0x87, 0x4b, 0x4c, 0x82, 0x82, 0x14, 0x93, 0x63 } }, // 108, 6003, FindFirstNextRand, perf.file1.jpg, 200
{ 0xc3878163, 0xd8a6, 0x4aa5, { 0xa6, 0x19, 0x5b, 0xeb, 0x08, 0x02, 0xdf, 0xd2 } }, // 109                           perf.file?.*
{ 0x1768145f, 0xefdf, 0x4d10, { 0x8b, 0xce, 0x67, 0x8a, 0xa3, 0x3c, 0x7b, 0x61 } }, // 110                           perf.file*.*

{ 0x6ad5e27f, 0x4b28, 0x414e, { 0x98, 0xf4, 0xef, 0xf5, 0x39, 0xb1, 0x9b, 0x3d } }, // 111, 7001, CreateFileNew
{ 0xe65b5617, 0xb3b3, 0x4189, { 0xa2, 0x61, 0x45, 0x8a, 0xc1, 0x74, 0x43, 0x56 } }, // 112, 7002, CreateFileExisting
};