//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft shared
// source or premium shared source license agreement under which you licensed
// this source code. If you did not accept the terms of the license agreement,
// you are not authorized to use this source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the SOURCE.RTF on your install media or the root of your tools installation.
// THE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES.
//
#pragma once
#include <windows.h>
#include <d3dm.h>

HRESULT SetOneArgStates(LPDIRECT3DMOBILEDEVICE pDevice,
                          DWORD dwTableIndex);

HRESULT GetOneArgColors(LPDIRECT3DMOBILEDEVICE pDevice,
                          DWORD dwTableIndex,
                          PDWORD *ppdwDiffuse, 
                          PDWORD *ppdwSpecular,
                          PDWORD *ppdwTFactor, 
                          PDWORD *ppdwTexture); 

BOOL IsOneArgTestOpSupported(LPDIRECT3DMOBILEDEVICE pDevice,
                               DWORD dwTableIndex);

typedef struct _ONE_ARG_OP_TESTS {
	D3DMTEXTUREOP TextureOp;
	D3DMCOLOR ColorValue0;
	D3DMCOLOR ColorValue1;
	D3DMCOLOR ColorValue2;
	DWORD TextureArg0;
	DWORD TextureArg1;
	DWORD TextureArg2;
} ONE_ARG_OP_TESTS;

#define D3DQA_ONE_ARG_OP_TESTS_COUNT 64

__declspec(selectany) ONE_ARG_OP_TESTS OneArgOpCases[D3DQA_ONE_ARG_OP_TESTS_COUNT] = {
// |           TextureOp             | ColorValue0 | ColorValue1 | ColorValue2 |   TextureArg0   |   TextureArg1   |   TextureArg2   |
// +---------------------------------+-------------+-------------+-------------+-----------------+-----------------+-----------------+

//
// D3DMTOP_SELECTARG1 Operation Tests (no D3DMTA_OPTIONMASK options)
//
{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFFFF0000,   0xFF0000FF,  D3DMTA_DIFFUSE,     D3DMTA_TEXTURE,   D3DMTA_TFACTOR}, // RED
{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFF00FF00,   0xFF0000FF,  D3DMTA_DIFFUSE,     D3DMTA_TEXTURE,  D3DMTA_SPECULAR}, // GREEN
{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFF0000FF,   0xFF0000FF,  D3DMTA_DIFFUSE,     D3DMTA_TFACTOR,   D3DMTA_TEXTURE}, // BLUE
{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFFFFFF00,   0xFF0000FF,  D3DMTA_DIFFUSE,     D3DMTA_TFACTOR,  D3DMTA_SPECULAR}, // YELLOW
{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFF00FFFF,   0xFF0000FF,  D3DMTA_DIFFUSE,    D3DMTA_SPECULAR,   D3DMTA_TEXTURE}, // CYAN
{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFFFF00FF,   0xFF0000FF,  D3DMTA_DIFFUSE,    D3DMTA_SPECULAR,   D3DMTA_TFACTOR}, // MAGENTA

{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFFFF0000,   0xFF0000FF,  D3DMTA_TEXTURE,     D3DMTA_DIFFUSE,   D3DMTA_TFACTOR}, // RED
{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFF00FF00,   0xFF0000FF,  D3DMTA_TEXTURE,     D3DMTA_DIFFUSE,  D3DMTA_SPECULAR}, // GREEN
{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFF0000FF,   0xFF0000FF,  D3DMTA_TEXTURE,     D3DMTA_TFACTOR,   D3DMTA_DIFFUSE}, // BLUE
{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFFFFFF00,   0xFF0000FF,  D3DMTA_TEXTURE,     D3DMTA_TFACTOR,  D3DMTA_SPECULAR}, // YELLOW
{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFF00FFFF,   0xFF0000FF,  D3DMTA_TEXTURE,    D3DMTA_SPECULAR,   D3DMTA_DIFFUSE}, // CYAN
{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFFFF00FF,   0xFF0000FF,  D3DMTA_TEXTURE,    D3DMTA_SPECULAR,   D3DMTA_TFACTOR}, // MAGENTA

{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFFFF0000,   0xFF0000FF,  D3DMTA_TFACTOR,     D3DMTA_DIFFUSE,   D3DMTA_TEXTURE}, // RED
{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFF00FF00,   0xFF0000FF,  D3DMTA_TFACTOR,     D3DMTA_DIFFUSE,  D3DMTA_SPECULAR}, // GREEN
{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFF0000FF,   0xFF0000FF,  D3DMTA_TFACTOR,     D3DMTA_TEXTURE,   D3DMTA_DIFFUSE}, // BLUE
{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFFFFFF00,   0xFF0000FF,  D3DMTA_TFACTOR,     D3DMTA_TEXTURE,  D3DMTA_SPECULAR}, // YELLOW
{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFF00FFFF,   0xFF0000FF,  D3DMTA_TFACTOR,    D3DMTA_SPECULAR,   D3DMTA_DIFFUSE}, // CYAN
{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFFFF00FF,   0xFF0000FF,  D3DMTA_TFACTOR,    D3DMTA_SPECULAR,   D3DMTA_TEXTURE}, // MAGENTA

{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFFFF0000,   0xFF0000FF,  D3DMTA_SPECULAR,     D3DMTA_DIFFUSE,   D3DMTA_TEXTURE}, // RED
{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFF00FF00,   0xFF0000FF,  D3DMTA_SPECULAR,     D3DMTA_DIFFUSE,   D3DMTA_TFACTOR}, // GREEN
{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFF0000FF,   0xFF0000FF,  D3DMTA_SPECULAR,     D3DMTA_TEXTURE,   D3DMTA_DIFFUSE}, // BLUE
{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFFFFFF00,   0xFF0000FF,  D3DMTA_SPECULAR,     D3DMTA_TEXTURE,   D3DMTA_TFACTOR}, // YELLOW
{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFF00FFFF,   0xFF0000FF,  D3DMTA_SPECULAR,     D3DMTA_TFACTOR,   D3DMTA_DIFFUSE}, // CYAN
{                   D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFFFF00FF,   0xFF0000FF,  D3DMTA_SPECULAR,     D3DMTA_TFACTOR,   D3DMTA_TEXTURE}, // MAGENTA

//
// D3DMTOP_SELECTARG1 Operation Tests (with D3DMTA_COMPLEMENT)
//
{                  D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFFFF3FFF,   0xFF0000FF,  D3DMTA_SPECULAR,     D3DMTA_DIFFUSE | D3DMTA_COMPLEMENT,   D3DMTA_TFACTOR }, // GREEN (LIGHT)
{                  D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFFFF7FFF,   0xFF0000FF,  D3DMTA_DIFFUSE ,     D3DMTA_TFACTOR | D3DMTA_COMPLEMENT,   D3DMTA_TEXTURE }, //    ||       
{                  D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFFFFBFFF,   0xFF0000FF,  D3DMTA_TFACTOR ,     D3DMTA_TEXTURE | D3DMTA_COMPLEMENT,   D3DMTA_SPECULAR}, //    \/       
{                  D3DMTOP_SELECTARG1,   0xFFFF0000,   0xFFFFFFFF,   0xFF0000FF,  D3DMTA_TEXTURE ,    D3DMTA_SPECULAR | D3DMTA_COMPLEMENT,   D3DMTA_DIFFUSE }, //   BLACK       
																												  
//
// D3DMTOP_SELECTARG1 Operation Tests (with D3DMTA_ALPHAREPLICATE)
//
{                  D3DMTOP_SELECTARG1,   0xFF000000,   0x3F00FF00,   0xFF0000FF,  D3DMTA_SPECULAR,     D3DMTA_DIFFUSE | D3DMTA_ALPHAREPLICATE,   D3DMTA_TFACTOR }, // GRAY (DARK)
{                  D3DMTOP_SELECTARG1,   0xFF000000,   0x7F00FF00,   0xFF0000FF,  D3DMTA_DIFFUSE ,     D3DMTA_TFACTOR | D3DMTA_ALPHAREPLICATE,   D3DMTA_TEXTURE }, //   ||       
{                  D3DMTOP_SELECTARG1,   0xFF000000,   0xBF00FF00,   0xFF0000FF,  D3DMTA_TFACTOR ,     D3DMTA_TEXTURE | D3DMTA_ALPHAREPLICATE,   D3DMTA_SPECULAR}, //   \/       
{                  D3DMTOP_SELECTARG1,   0xFF000000,   0xFF00FF00,   0xFF0000FF,  D3DMTA_TEXTURE ,    D3DMTA_SPECULAR | D3DMTA_ALPHAREPLICATE,   D3DMTA_DIFFUSE }, // WHITE       


//
// D3DMTOP_SELECTARG2 Operation Tests (no D3DMTA_OPTIONMASK options)
//
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFFFF0000,  D3DMTA_DIFFUSE,     D3DMTA_TEXTURE,   D3DMTA_TFACTOR}, // RED
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFF00FF00,  D3DMTA_DIFFUSE,     D3DMTA_TEXTURE,  D3DMTA_SPECULAR}, // GREEN
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFF0000FF,  D3DMTA_DIFFUSE,     D3DMTA_TFACTOR,   D3DMTA_TEXTURE}, // BLUE
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFFFFFF00,  D3DMTA_DIFFUSE,     D3DMTA_TFACTOR,  D3DMTA_SPECULAR}, // YELLOW
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFF00FFFF,  D3DMTA_DIFFUSE,    D3DMTA_SPECULAR,   D3DMTA_TEXTURE}, // CYAN
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFFFF00FF,  D3DMTA_DIFFUSE,    D3DMTA_SPECULAR,   D3DMTA_TFACTOR}, // MAGENTA
																  
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFFFF0000,  D3DMTA_TEXTURE,     D3DMTA_DIFFUSE,   D3DMTA_TFACTOR}, // RED
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFF00FF00,  D3DMTA_TEXTURE,     D3DMTA_DIFFUSE,  D3DMTA_SPECULAR}, // GREEN
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFF0000FF,  D3DMTA_TEXTURE,     D3DMTA_TFACTOR,   D3DMTA_DIFFUSE}, // BLUE
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFFFFFF00,  D3DMTA_TEXTURE,     D3DMTA_TFACTOR,  D3DMTA_SPECULAR}, // YELLOW
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFF00FFFF,  D3DMTA_TEXTURE,    D3DMTA_SPECULAR,   D3DMTA_DIFFUSE}, // CYAN
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFFFF00FF,  D3DMTA_TEXTURE,    D3DMTA_SPECULAR,   D3DMTA_TFACTOR}, // MAGENTA
																  
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFFFF0000,  D3DMTA_TFACTOR,     D3DMTA_DIFFUSE,   D3DMTA_TEXTURE}, // RED
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFF00FF00,  D3DMTA_TFACTOR,     D3DMTA_DIFFUSE,  D3DMTA_SPECULAR}, // GREEN
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFF0000FF,  D3DMTA_TFACTOR,     D3DMTA_TEXTURE,   D3DMTA_DIFFUSE}, // BLUE
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFFFFFF00,  D3DMTA_TFACTOR,     D3DMTA_TEXTURE,  D3DMTA_SPECULAR}, // YELLOW
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFF00FFFF,  D3DMTA_TFACTOR,    D3DMTA_SPECULAR,   D3DMTA_DIFFUSE}, // CYAN
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFFFF00FF,  D3DMTA_TFACTOR,    D3DMTA_SPECULAR,   D3DMTA_TEXTURE}, // MAGENTA
																  
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFFFF0000,  D3DMTA_SPECULAR,     D3DMTA_DIFFUSE,   D3DMTA_TEXTURE}, // RED
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFF00FF00,  D3DMTA_SPECULAR,     D3DMTA_DIFFUSE,   D3DMTA_TFACTOR}, // GREEN
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFF0000FF,  D3DMTA_SPECULAR,     D3DMTA_TEXTURE,   D3DMTA_DIFFUSE}, // BLUE
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFFFFFF00,  D3DMTA_SPECULAR,     D3DMTA_TEXTURE,   D3DMTA_TFACTOR}, // YELLOW
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFF00FFFF,  D3DMTA_SPECULAR,     D3DMTA_TFACTOR,   D3DMTA_DIFFUSE}, // CYAN
{                   D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFFFF00FF,  D3DMTA_SPECULAR,     D3DMTA_TFACTOR,   D3DMTA_TEXTURE}, // MAGENTA

//
// D3DMTOP_SELECTARG2 Operation Tests (with D3DMTA_COMPLEMENT)
//
{                  D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFFFF3FFF,  D3DMTA_SPECULAR,     D3DMTA_DIFFUSE,   D3DMTA_TFACTOR  | D3DMTA_COMPLEMENT}, // GREEN (LIGHT)
{                  D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFFFF7FFF,  D3DMTA_DIFFUSE ,     D3DMTA_TFACTOR,   D3DMTA_TEXTURE  | D3DMTA_COMPLEMENT}, //    ||       
{                  D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFFFFBFFF,  D3DMTA_TFACTOR ,     D3DMTA_TEXTURE,   D3DMTA_SPECULAR | D3DMTA_COMPLEMENT}, //    \/       
{                  D3DMTOP_SELECTARG2,   0xFFFF0000,   0xFF0000FF,   0xFFFFFFFF,  D3DMTA_TEXTURE ,    D3DMTA_SPECULAR,   D3DMTA_DIFFUSE  | D3DMTA_COMPLEMENT}, //   BLACK       
																												  
//
// D3DMTOP_SELECTARG2 Operation Tests (with D3DMTA_ALPHAREPLICATE)
//
{                  D3DMTOP_SELECTARG2,   0xFF000000,   0xFF0000FF,   0x3F00FF00,  D3DMTA_SPECULAR,     D3DMTA_DIFFUSE,   D3DMTA_TFACTOR  | D3DMTA_ALPHAREPLICATE}, // GRAY (DARK)
{                  D3DMTOP_SELECTARG2,   0xFF000000,   0xFF0000FF,   0x7F00FF00,  D3DMTA_DIFFUSE ,     D3DMTA_TFACTOR,   D3DMTA_TEXTURE  | D3DMTA_ALPHAREPLICATE}, //   ||       
{                  D3DMTOP_SELECTARG2,   0xFF000000,   0xFF0000FF,   0xBF00FF00,  D3DMTA_TFACTOR ,     D3DMTA_TEXTURE,   D3DMTA_SPECULAR | D3DMTA_ALPHAREPLICATE}, //   \/       
{                  D3DMTOP_SELECTARG2,   0xFF000000,   0xFF0000FF,   0xFF00FF00,  D3DMTA_TEXTURE ,    D3DMTA_SPECULAR,   D3DMTA_DIFFUSE  | D3DMTA_ALPHAREPLICATE}, // WHITE       


};
