//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// This source code is licensed under Microsoft Shared Source License
// Version 1.0 for Windows CE.
// For a copy of the license visit http://go.microsoft.com/fwlink/?LinkId=3223.
//
// --------------------------------------------------------------------------
//
//
// Module:
//
//     edbaccess.h
//
// Purpose:
//
//    Internal include file used by the core dll.
//
// --------------------------------------------------------------------------

#ifndef __EDBACCESS_H__
#define __EDBACCESS_H__

typedef BOOL  (APIENTRY *PFNSQLCEMOUNTDBVOL)( PCEGUID pGuid,LPWSTR pwszDBVol,const CEVOLUMEOPTIONS* pOptions, DWORD dwFlags);
typedef BOOL  (APIENTRY *PFNSQLCEUNMOUNTDBVOL)( PCEGUID pGuid);
typedef BOOL  (APIENTRY *PFNSQLCEFLUSHDBVOL)(PCEGUID pGuid);
 
// New EDB database API's
typedef CEOID (APIENTRY *PFNSQLCECREATEDATABASE)( PCEGUID pGuid, CEDBASEINFOEX* pInfo, DWORD cProps, CEPROPSPEC* rgProps);
typedef BOOL  (APIENTRY *PFNSQLCEADDDATABASEPROPS)( PCEGUID pGuid, CEOID oidDb, DWORD cProps, CEPROPSPEC* prgProps);
typedef BOOL  (APIENTRY *PFNSQLCEREMOVEDATABASEPROPS)( PCEGUID pGuid, CEOID oidDb, DWORD cPropID,CEPROPID* prgPropID);
typedef BOOL (APIENTRY  *PFNSQLCEGETDATABASEPROPS)(HANDLE hHandle, WORD* pcPropId, CEPROPID* prgPropId, CEPROPSPEC* prgProps);


//Database API's
typedef BOOL   (APIENTRY *PFNSQLCESETDATABASEINFO)( PCEGUID pGuid, CEOID oidDb, CEDBASEINFOEX* pInfo);
typedef BOOL   (APIENTRY *PFNSQLCEGETDBINFORMATIONBYHANDLE)(HANDLE hHandle, BY_HANDLE_DB_INFORMATION* pInfo);
typedef BOOL   (APIENTRY *PFNSQLCEDELETEDATABASE)( PCEGUID pGuid, CEOID oidDb);
typedef BOOL   (APIENTRY *PFNSQLCEENUMDBVOLUMES)( PCEGUID pGuid, LPWSTR pwszName,DWORD cchMaxName);
typedef HANDLE (APIENTRY *PFNSQLCEFINDFIRSTDATABASE)( PCEGUID pGuid, DWORD dwDbaseType);
typedef CEOID  (APIENTRY *PFNSQLCEFINDNEXTDATABASE)( HANDLE hEnum,PCEGUID pGuid);
typedef HANDLE (APIENTRY *PFNSQLCEOPENDATABASE)( HANDLE hSession,PCEGUID pGuid, PCEOID poid,LPWSTR pwszName, SORTORDERSPECEX* pSort, DWORD dwFlags, CENOTIFYREQUEST* pRequest);
typedef CEOID  (APIENTRY *PFNSQLCESEEKDATABASE)( HANDLE hDatabase, DWORD dwSeekType, DWORD dwValue, WORD wNumVals, DWORD* pdwIndex);
typedef CEOID  (APIENTRY *PFNSQLCEREADRECORDPROPS)( HANDLE hDatabase, DWORD dwFlags, WORD* pcPropId, CEPROPID* prgPropIdT, LPBYTE* ppbBuffer,  DWORD* pcbBuffer, HANDLE hHeap);
typedef CEOID  (APIENTRY *PFNSQLCEWRITERECORDPROPS)( HANDLE hDatabase, CEOID oidRecord, WORD cValues, CEPROPVAL* prgValue);
typedef BOOL   (APIENTRY *PFNSQLCEDELETERECORD)( HANDLE hDatabase, CEOID oidRecord);
typedef HANDLE (APIENTRY *PFNSQLCEOPENSTREAM)( HANDLE hDatabase, CEPROPID propid, DWORD dwMode);
typedef BOOL   (APIENTRY *PFNSQLCESTREAMREAD)( HANDLE hStream, BYTE* prgbBuffer, const DWORD cbRead, DWORD* pcbRead);
typedef BOOL   (APIENTRY *PFNSQLCESTREAMWRITE)( HANDLE hStream, const BYTE* prgbBuffer, const DWORD cbWrite, DWORD* pcbWritten);
typedef BOOL   (APIENTRY *PFNSQLCESTREAMSAVECHANGES)( HANDLE hStream);
typedef BOOL   (APIENTRY *PFNSQLCESTREAMSEEK)( HANDLE hStream, DWORD cbMove, DWORD dwOrigin, DWORD* pcbNewOffset);
typedef BOOL   (APIENTRY *PFNSQLCESTREAMSETSIZE)( HANDLE hStream, const DWORD cbSize);
typedef BOOL   (APIENTRY *PFNSQLCEOIDGETINFO)( PCEGUID pGuid, CEOID oid, CEOIDINFOEX *poidInfo);
typedef BOOL   (APIENTRY *PFNSQLCECLOSEHANDLE)( HANDLE hHandle);
typedef BOOL   (APIENTRY *PFNSQLCEFREENOTIFICATION)( CENOTIFYREQUEST* pRequest, CENOTIFICATION* pNotification);
typedef void   (APIENTRY *PFNSQLCECHANGEDATABASELCID)( PCEGUID pceguid, DWORD lcid);
typedef void   (APIENTRY *PFNSQLCEUNINITIALIZE)(void);

// Session API's
typedef HANDLE (APIENTRY *PFNSQLCECREATESESSION)( PCEGUID pGuid);
typedef BOOL   (APIENTRY *PFNSQLCESETSESSIONOPTION)( HANDLE hSession,ULONG ulOptionId, DWORD dwValue);
typedef HANDLE (APIENTRY *PFNSQLCEGETDATABASESESSION)(HANDLE hDatabase);
typedef BOOL   (APIENTRY *PFNSQLCEBEGINTRANSACTION)( HANDLE hSession, CEDBISOLATIONLEVEL isoLevel);
typedef BOOL   (APIENTRY *PFNSQLCEENDTRANSACTION)( HANDLE hSession, BOOL fCommit);

//-----------------------------------------------------------------------
// Tracking functions
//
typedef BOOL  (APIENTRY *PFNSQLCEADDSYNCPARTNER)(PCEGUID pVolGuid, PCEGUID pSyncPartnerGuid, LPCWSTR pwszFriendlyName, LPCWSTR pwszFullName  );
typedef BOOL  (APIENTRY *PFNSQLCEREMOVESYNCPARTNER)( PCEGUID pVolGuid, PCEGUID pSyncPartnerGuid );
typedef BOOL  (APIENTRY *PFNSQLCETRACKDATABASE)( PCEGUID pVolGuid, PCEGUID pSyncPartnerGuid, CEOID oidDB, DWORD dwTrackingFlags );
typedef BOOL  (APIENTRY *PFNSQLCEREMOVEDATABASETRACKING)( PCEGUID pVolGuid, PCEGUID pSyncPartnerGuid, CEOID oidDB );
typedef BOOL  (APIENTRY *PFNSQLCETRACKPROPERTY)( PCEGUID pVolGuid, CEOID oidDB, CEPROPID  propid, BOOL  fAddToScheme );
typedef BOOL  (APIENTRY *PFNSQLCEBEGINSYNCSESSION)(HANDLE  hSession, PCEGUID pSyncPartnerGuid, CEDBGEN genFrom, CEDBGEN genTo, DWORD dwFlags,CEDBGEN* pGenCur );
typedef BOOL  (APIENTRY *PFNSQLCEENDSYNCSESSION)( HANDLE  hSession, DWORD dwOutcome );
typedef BOOL  (APIENTRY *PFNSQLCEGETCHANGEDRECORDCNT)( HANDLE  hSession, CEOID oidDB, DWORD*  pdwCnt );
typedef HANDLE  (APIENTRY *PFNSQLCEGETCHANGEDRECORDS)( HANDLE  hSession, CEOID oidDB, DWORD dwChangeType  );
typedef BOOL  (APIENTRY *PFNSQLCEFINDNEXTCHANGEDRECORD)( HANDLE  hChangeEnum );
typedef BOOL  (APIENTRY *PFNSQLCEGETPROPCHANGEINFO)( HANDLE  hChangeEnum, CEOID oidChangedRecord, CEPROPID  propid, BOOL* pfPropChanged );
typedef CEOID (APIENTRY *PFNSQLCEGETRECORDCHANGEINFO)( HANDLE hChangeEnum, CEOID  oidChangedRecord, CECHANGEINFO* pInfo );
typedef BOOL  (APIENTRY *PFNSQLCEMARKRECORD)( HANDLE  hChangeEnum, CEOID oidChangedRecord, BOOL  fChanged );
typedef BOOL  (APIENTRY *PFNSQLCEATTACHCUSTOMTRACKINGDATA)( HANDLE  hDB, CEOID oidChangedRecord, BYTE* rgbData, DWORD ccb );
typedef BOOL  (APIENTRY *PFNSQLCEGETCUSTOMTRACKINGDATA)( HANDLE  hChangeEnum, CEOID oidChangedRecord,  BYTE* rgbData, DWORD*  pccb );
typedef BOOL  (APIENTRY *PFNSQLCEPURGETRACKINGDATA)( PCEGUID pVolGuid, PCEGUID pSyncPartnerGuid, SYSTEMTIME *pstThreshold);
typedef BOOL (APIENTRY *PFNSQLCEPURGETRACKINGGENERATIONS)(PCEGUID  pVolGuid,PCEGUID   pSyncPartnerGuid,CEDBGEN genThreshold);

typedef struct tagEDBACCESS {
    HMODULE                                         hEDB;
    PFNSQLCEMOUNTDBVOL                          pSQLCEMOUNTDBVOL;
    PFNSQLCEUNMOUNTDBVOL                        pSQLCEUNMOUNTDBVOL;
    PFNSQLCEFLUSHDBVOL                          pSQLCEFLUSHDBVOL;                
    PFNSQLCECREATEDATABASE                      pSQLCECREATEDATABASE;
    PFNSQLCEADDDATABASEPROPS              pSQLCEADDDATABASEPROPS;
    PFNSQLCEREMOVEDATABASEPROPS           pSQLCEREMOVEDATABASEPROPS;
    PFNSQLCEGETDATABASEPROPS            pSQLCEGETDATABASEPROPS;
    PFNSQLCESETDATABASEINFO               pSQLCESETDATABASEINFO;
    PFNSQLCEGETDBINFORMATIONBYHANDLE      pSQLCEGETDBINFORMATIONBYHANDLE;
    PFNSQLCEDELETEDATABASE                   pSQLCEDELETEDATABASE;
    PFNSQLCEENUMDBVOLUMES                 pSQLCEENUMDBVOLUMES;
    PFNSQLCEFINDFIRSTDATABASE             pSQLCEFINDFIRSTDATABASE;
    PFNSQLCEFINDNEXTDATABASE              pSQLCEFINDNEXTDATABASE;
    PFNSQLCEOPENDATABASE                  pSQLCEOPENDATABASE;
    PFNSQLCESEEKDATABASE                  pSQLCESEEKDATABASE;
    PFNSQLCEREADRECORDPROPS               pSQLCEREADRECORDPROPS;
    PFNSQLCEWRITERECORDPROPS              pSQLCEWRITERECORDPROPS;
    PFNSQLCEDELETERECORD                  pSQLCEDELETERECORD;
    PFNSQLCEOPENSTREAM                    pSQLCEOPENSTREAM;
    PFNSQLCESTREAMREAD                    pSQLCESTREAMREAD;
    PFNSQLCESTREAMWRITE                   pSQLCESTREAMWRITE;
    PFNSQLCESTREAMSAVECHANGES             pSQLCESTREAMSAVECHANGES;
    PFNSQLCESTREAMSEEK                    pSQLCESTREAMSEEK;
    PFNSQLCESTREAMSETSIZE                 pSQLCESTREAMSETSIZE;
    PFNSQLCEOIDGETINFO                    pSQLCEOIDGETINFO;
    PFNSQLCECLOSEHANDLE                   pSQLCECLOSEHANDLE;
    PFNSQLCEFREENOTIFICATION              pSQLCEFREENOTIFICATION;
    PFNSQLCECHANGEDATABASELCID            pSQLCECHANGEDATABASELCID;
    PFNSQLCECREATESESSION                 pSQLCECREATESESSION;
    PFNSQLCESETSESSIONOPTION              pSQLCESETSESSIONOPTION;
    PFNSQLCEGETDATABASESESSION            pSQLCEGETDATABASESESSION;
    PFNSQLCEBEGINTRANSACTION              pSQLCEBEGINTRANSACTION;
    PFNSQLCEENDTRANSACTION                pSQLCEENDTRANSACTION;
    PFNSQLCEADDSYNCPARTNER                pSQLCEADDSYNCPARTNER;
    PFNSQLCEREMOVESYNCPARTNER             pSQLCEREMOVESYNCPARTNER;
    PFNSQLCETRACKDATABASE                 pSQLCETRACKDATABASE;
    PFNSQLCEREMOVEDATABASETRACKING        pSQLCEREMOVEDATABASETRACKING;
    PFNSQLCETRACKPROPERTY                 pSQLCETRACKPROPERTY;
    PFNSQLCEBEGINSYNCSESSION              pSQLCEBEGINSYNCSESSION;
    PFNSQLCEENDSYNCSESSION                pSQLCEENDSYNCSESSION;
    PFNSQLCEGETCHANGEDRECORDCNT           pSQLCEGETCHANGEDRECORDCNT;
    PFNSQLCEGETCHANGEDRECORDS             pSQLCEGETCHANGEDRECORDS;
    PFNSQLCEFINDNEXTCHANGEDRECORD         pSQLCEFINDNEXTCHANGEDRECORD;
    PFNSQLCEGETPROPCHANGEINFO             pSQLCEGETPROPCHANGEINFO;
    PFNSQLCEGETRECORDCHANGEINFO           pSQLCEGETRECORDCHANGEINFO;
    PFNSQLCEMARKRECORD                    pSQLCEMARKRECORD;
    PFNSQLCEATTACHCUSTOMTRACKINGDATA      pSQLCEATTACHCUSTOMTRACKINGDATA;
    PFNSQLCEGETCUSTOMTRACKINGDATA         pSQLCEGETCUSTOMTRACKINGDATA;
    PFNSQLCEPURGETRACKINGDATA             pSQLCEPURGETRACKINGDATA;
    PFNSQLCEPURGETRACKINGGENERATIONS    pSQLCEPURGETRACKINGGENERATIONS;
} EDBACCESS, *PEDBACCESS;


#define ISEDBHANDLE(x) ( (x != INVALID_HANDLE_VALUE) && ((DWORD)x & 0x1))
//#define ISEDBPGUID(x) ( x && (((x->Data1) & 0xFF000000) == 1))
#define ISEDBPGUID(x) ( x && (*((BYTE *)x) == 0xFF))
//#define ISEDBPGUID(x) (TRUE)
#define ISEDBOID(x) ((x & 0xC0000000) == 0x40000000)
#define MAKEEDBHANDLE(x) (HANDLE)((DWORD)x | 0x1)
#define PATCHEDBHANDLE(x) (x = (HANDLE)((DWORD)x & 0xFFFFFFF0))
#define ISEDBFLAG(x) (x & EDB_MOUNT_FLAG)
#define PATCHMOUNTFLAG(x) ((x & (~EDB_MOUNT_FLAG)))

#define VERIFYEDBPTR(function) \
            if (pEDBAccess) { \
                if (!(function)) { \
                    LocalFree( pEDBAccess); \
                    pEDBAccess = NULL;\
                }\
            }

#endif /* __EDBACCESS_H__ */

