//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// This source code is licensed under Microsoft Shared Source License
// Version 1.0 for Windows CE.
// For a copy of the license visit http://go.microsoft.com/fwlink/?LinkId=3223.
//
/***
*fsetpos.c - Contains fsetpos runtime
*
*
*Purpose:
*       Fsetpos sets the file position using an internal value returned by an
*       earlier fgetpos call.
*
*******************************************************************************/

#include <cruntime.h>
#include <stdio.h>
#include <internal.h>

/***
*int fsetpos(stream,pos) - Set file positioning
*
*Purpose:
*       Fsetpos sets the file position for the file indicated by [stream] to
*       the position indicated by [pos].  The [pos] value is defined to be in
*       an internal format (not to be interpreted by the user) and has been
*       generated by an earlier fgetpos call.
*
*Entry:
*       FILEX *stream = pointer to a file stream value
*       fpos_t *pos = pointer to a file positioning value
*
*Exit:
*       Successful call returns 0.
*       Unsuccessful call returns non-zero (!0).
*
*Exceptions:
*       None.
*******************************************************************************/

int __cdecl fsetpos (
        FILEX *stream,
        const fpos_t *pos
        )
{
    if(!CheckStdioInit())
        return -1L;

#if _INTEGRAL_MAX_BITS >= 64
        return( _fseeki64(stream, *pos, SEEK_SET) );
#else
        return( fseek(stream, *pos, SEEK_SET) );
#endif
}
