/* A lexical scanner generated by flex */

/* scanner skeleton version:
 */

#define FLEX_SCANNER

#include <stdio.h>
#include <stdlib.h>
#include <io.h>  // required under NT


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#include <osfcn.h>

/* use prototypes in function declarations */
#define YY_USE_PROTOS

/* the "const" storage-class-modifier is valid */
#define YY_USE_CONST

#else   /* ! __cplusplus */

#ifdef __STDC__

#ifdef __GNUC__
#include <stddef.h>
void *malloc( size_t );
void free( void* );
#else
#include <stdlib.h>
#endif  /* __GNUC__ */

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif  /* __STDC__ */
#endif  /* ! __cplusplus */


#ifdef __TURBOC__
#define YY_USE_CONST
#endif


#ifndef YY_USE_CONST
#define const
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
/* we can't get here if it's an ANSI C compiler, or a C++ compiler,
 * so it's got to be a K&R compiler, and therefore there's no standard
 * place from which to include these definitions
 */
#endif


/* amount of stuff to slurp up with each read */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* returned upon end-of-file */
#define YY_END_TOK 0

/* copy whatever the last rule matched to the standard output */

/* cast to (char *) is because for 8-bit chars, yytext is (unsigned char *) */
/* this used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite()
 */
#define ECHO (void) fwrite( (char *) yytext, yyleng, 1, yyout )

/* gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#define YY_INPUT(buf,result,max_size) \
        if ( (result = _read( _fileno(yyin), (char *) buf, max_size )) < 0 ) \
            YY_FATAL_ERROR( "read() in flex scanner failed" );
#define YY_NULL 0

/* no semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#define yyterminate() return ( YY_NULL )

/* report a fatal error */

/* The funky do-while is used to turn this macro definition into
 * a single C statement (which needs a semi-colon terminator).
 * This avoids problems with code like:
 *
 *      if ( something_happens )
 *              YY_FATAL_ERROR( "oops, the something happened" );
 *      else
 *              everything_okay();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the YY_FATAL_ERROR() call.
 */

#define YY_FATAL_ERROR(msg) \
        do \
                { \
                (void) fputs( msg, stderr ); \
                (void) putc( '\n', stderr ); \
                exit( 1 ); \
                } \
        while ( 0 )

/* default yywrap function - always treat EOF as an EOF */
#define yywrap() 1

/* enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN
 */
#define BEGIN yy_start = 1 + 2 *

/* action number for EOF rule of a given start state */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* special action meaning "start processing a new file" */
#define YY_NEW_FILE \
        do \
                { \
                yy_init_buffer( yy_current_buffer, yyin ); \
                yy_load_buffer_state(); \
                } \
        while ( 0 )

/* default declaration of generated scanner - a define so the user can
 * easily add parameters
 */
#define YY_DECL int yylex YY_PROTO(( void ))

/* code executed at the end of each rule */
#define YY_BREAK break;

#define YY_END_OF_BUFFER_CHAR 0

#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE (YY_READ_BUF_SIZE * 2) /* size of default input buffer */
#endif

typedef struct yy_buffer_state *YY_BUFFER_STATE;

#define YY_CHAR unsigned char
#define INITIAL 0

#ifdef __cplusplus
static int yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif

/*++

Copyright (c) 1992-1996  Microsoft Corporation

Module Name:

    miblex.l

Abstract:

    This file is the FLEX specification for the MIB compiler.

Environment:

    User Mode - Win32

Revision History:

    10-May-1996 DonRyan
        Removed banner from Technology Dynamics, Inc.

--*/

#include<string.h>

#ifdef WIN32    /* if compiling for NT */
#include<io.h>
#endif

#include "mibyacc.h"    /* for defines for token ids */
#include "mibcc.h"      /* for global variables */


//#define DONTSUCKEXPORTS
//#define DONTSUCKIMPORTS

extern int yy_init;             /* whether we need to initialize */

void mark_flex_to_init(void) {
   yy_init = 1;
}

BOOL warning_level(unsigned int nLevel) {
   if (nWarningLevel >= nLevel)
      return TRUE;
   else
      return FALSE;
}

void comment (void)
{
   char c, lastc=' ';
   while(c = (char) input()) {
      if ('\n' == c) { /* line feed ends a comment */
         // increment the number of lines seen
         lineno++;
         break;
      }
      if ((lastc == '-') && (c == '-')) { /* two dashes ends a comment */
         break;
      }
      lastc = c;
   }
}

void string (void)
{
   char c;
   while(c = (char) input()) {
      if ('\"' == c)
         break;
      if ('\n' == c) /* keep track of line feeds */
         lineno++;
   }
}

void suckUpImports (void)
{
   char c;
   if (warning_level(2)) {
      fprintf (error_out, "warning : IMPORTS on line %i not supported (ignored)\n", lineno);
   }
   while(c = (char) input()) {
      if (';' == c)
         break;
      if ('\n' == c) /* keep track of line feeds */
         lineno++;
   }
}

void suckUpExports (void)
{
   char c;
   if (warning_level(2)) {
      fprintf (error_out, "warning : EXPORTS on line %i not supported (ignored)\n", lineno);
   }
   while(c = (char) input()) {
      if (';' == c)
         break;
      if ('\n' == c) /* keep track of line feeds */
         lineno++;
   }
}


/* done after the current pattern has been matched and before the
 * corresponding action - sets up yytext
 */
#define YY_DO_BEFORE_ACTION \
        yytext = yy_bp; \
        yyleng = yy_cp - yy_bp; \
        yy_hold_char = *yy_cp; \
        *yy_cp = '\0'; \
        yy_c_buf_p = yy_cp;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* return all but the first 'n' matched characters back to the input stream */
#define yyless(n) \
        do \
                { \
                /* undo effects of setting up yytext */ \
                *yy_cp = yy_hold_char; \
                yy_c_buf_p = yy_cp = yy_bp + n; \
                YY_DO_BEFORE_ACTION; /* set up yytext again */ \
                } \
        while ( 0 )

#define unput(c) yyunput( c, yytext )


struct yy_buffer_state
    {
    FILE *yy_input_file;

    YY_CHAR *yy_ch_buf;         /* input buffer */
    YY_CHAR *yy_buf_pos;        /* current position in input buffer */

    /* size of input buffer in bytes, not including room for EOB characters*/
    int yy_buf_size;

    /* number of characters read into yy_ch_buf, not including EOB characters */
    int yy_n_chars;

    int yy_eof_status;          /* whether we've seen an EOF on this buffer */
#define EOF_NOT_SEEN 0
    /* "pending" happens when the EOF has been seen but there's still
     * some text process
     */
#define EOF_PENDING 1
#define EOF_DONE 2
    };

static YY_BUFFER_STATE yy_current_buffer = NULL;

/* we provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state"
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed */
static YY_CHAR yy_hold_char;

static int yy_n_chars;          /* number of characters read into yy_ch_buf */



#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

#ifndef YY_USER_INIT
#define YY_USER_INIT
#endif

extern YY_CHAR *yytext;
extern int yyleng;
extern FILE *yyin, *yyout;

YY_CHAR *yytext;
int yyleng;

FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;

#define YY_END_OF_BUFFER 69
typedef int yy_state_type;
static const short int yy_accept[352] =
    {   0,
        0,    0,   69,   67,    5,    1,    4,    2,    3,   60,
       67,   62,   63,   64,   67,   67,   57,   57,   57,   67,
       55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
       55,   55,   55,   55,   55,   55,   55,   55,   65,   66,
        0,    0,    0,   61,   53,    0,   57,   57,   57,    0,
       55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
       55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
       36,   55,   55,   55,   55,   55,   55,   55,   55,   55,
       55,   55,   58,   59,    0,    0,    0,    0,   57,   54,
       55,   55,   55,   55,   55,   55,   55,   15,   55,   55,

       55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
       55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
       55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
        0,    0,    0,    0,   55,   55,   55,   55,   55,   55,
       55,   55,   55,   55,   55,   18,   55,   55,   55,   55,
       55,   55,   55,   55,   55,   55,   55,   55,   31,   55,
       55,   55,   55,   55,   55,   55,   55,   43,   55,   55,
       55,   55,   55,   49,   55,   55,   55,    0,    0,    0,
       55,    7,   55,   55,   55,   55,   55,   55,   55,   55,
       55,   19,   55,   55,   55,   23,   55,   55,   27,   55,

       55,   55,   55,   55,   55,   35,   55,   55,   55,   55,
       55,   55,   55,   55,   55,   55,   51,   55,   55,    0,
        0,    0,    0,    6,    8,   55,   55,   55,   12,   55,
       55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
       55,   55,   32,   55,   37,   55,   55,   55,   55,   55,
       44,   45,   46,   55,   55,   55,   55,   56,   56,   56,
        9,   10,   55,   55,   55,   55,   17,   55,   55,   22,
       24,   55,   55,   55,   55,   55,   55,   55,   55,   55,
       55,   55,   55,   55,   55,   55,   55,   56,   56,   56,
       55,   55,   55,   55,   55,   21,   55,   55,   55,   55,

       30,   55,   34,   38,   55,   55,   55,   42,   55,   55,
       55,   55,   55,   55,   55,   55,   55,   25,   26,   55,
       55,   55,   39,   55,   41,   47,   48,   50,   55,   55,
       13,   55,   16,   20,   55,   55,   55,   40,   52,   11,
       14,   55,   55,   33,   55,   55,   55,   55,   28,   29,
        0
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        4,    5,    6,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    2,    1,    1,    1,    1,
        1,    2,    1,    7,    1,    1,    1,    1,    8,    9,
       10,    1,    1,   11,   12,   13,    1,   14,   15,   16,
       17,   17,   17,   18,   18,   18,   18,   19,    1,    1,
       20,    1,    1,    1,   21,   22,   23,   24,   25,   26,
       27,   28,   29,   30,   31,   32,   33,   34,   35,   36,
       37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
        1,    1,    1,    1,   47,    1,   48,   49,   48,   48,

       50,   48,   51,   52,   53,   51,   51,   51,   51,   51,
       51,   51,   51,   51,   54,   51,   51,   51,   51,   51,
       51,   46,   55,    1,   56,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,   51,   51,   51,   51,   51,   51,   51,   51,   51,

       51,   51,   51,   51,   51,   51,   51,   51,   51,   51,
       51,   51,   51,   51,   51,   51,   51,   51,   51,   51,
       51,   51,   51,   51,   51,   51,   51,   51,   51,   51,
       51,   51,   51,   51,   51,   51,   51,   51,   51,   51,
       51,   51,   51,   51,   51,   51,   51,   51,   51,   51,
       51,   51,   51,   51,   51
    } ;

static const YY_CHAR yy_meta[57] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    2,    1,    1,
        1,    3,    1,    4,    4,    4,    4,    4,    1,    1,
        4,    4,    4,    4,    4,    4,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    4,    4,    4,
        3,    3,    3,    3,    1,    1
    } ;

static const short int yy_base[354] =
    {   0,
        0,    0,  496,  497,  497,  497,  497,  497,  497,  497,
       49,  497,  497,  497,  483,  481,   52,   58,   64,  474,
      469,  466,   55,  465,   50,  451,  467,    0,   62,  466,
       62,   66,  461,   75,   72,  464,  446,   32,  497,  497,
       77,   98,  475,  497,  497,  107,  117,  123,  129,  462,
        0,  458,  453,  444,  437,  122,   67,  441,  441,  434,
      449,  437,   69,  451,   85,  431,  430,  437,   88,  428,
        0,  128,   90,  430,  420,  129,  431,  431,  442,  426,
      119,  432,  497,  497,  124,  156,  164,  170,  148,  497,
      435,  430,  429,  423,  168,  418,  432,    0,  429,  418,

      419,  424,  416,   27,  424,  423,  423,  408,  421,  401,
      178,  411,  417,  406,  415,  402,  409,  413,  411,  394,
      150,  394,  404,  392,  406,  394,  404,  387,  398,  386,
      177,  412,  188,  198,  385,  389,  399,  381,  379,  385,
      397,  392,  378,  377,  376,    0,  388,  372,  382,  372,
      365,  381,  383,  371,  384,  369,  382,  362,    0,  378,
      368,  359,  357,  362,  384,  357,  369,    0,  352,  358,
      370,  350,  377,    0,  363,  366,  361,  203,  209,  215,
      346,    0,  359,  358,  350,  352,  348,  356,  349,  341,
      336,    0,  346,  351,  333,    0,  347,  333,    0,  330,

      331,  345,  338,  326,  340,    0,  339,  329,  199,  337,
      327,  321,  332,  314,  328,  316,    0,  333,  342,  221,
      340,  230,  236,    0,    0,  314,  311,  310,    0,  328,
      312,  309,  307,  319,  315,  304,  304,  316,  305,  308,
      315,  302,  324,  295,    0,  313,  299,  294,  297,  307,
        0,    0,    0,  306,  283,  295,  291,  240,  245,  250,
        0,    0,  296,  284,  283,  293,    0,  292,  280,    0,
        0,  280,  280,  296,  291,  281,  274,  288,  280,  279,
      281,  286,  283,  276,  270,  280,  270,  497,  255,  139,
      268,  277,  272,  261,  274,    0,  259,  252,  272,  256,

        0,  249,    0,    0,  248,  252,  266,    0,  251,  264,
      249,  255,  252,  261,  249,  258,  244,    0,    0,  257,
      241,  243,    0,  250,    0,    0,    0,    0,  196,  201,
        0,  175,    0,    0,  170,  178,  173,    0,    0,    0,
        0,  171,  138,    0,  120,   82,   21,   33,    0,    0,
      497,  272,  274
    } ;

static const short int yy_def[354] =
    {   0,
      351,    1,  351,  351,  351,  351,  351,  351,  351,  351,
      352,  351,  351,  351,  351,  351,  351,  351,  351,  351,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  353,  351,  351,
      351,  352,  352,  351,  351,  351,  351,  351,  351,  351,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  351,  351,  351,  351,  351,  351,  351,  351,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,

      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      351,  351,  351,  351,  353,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  351,  351,  351,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,

      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  351,
      351,  351,  351,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  351,  351,  351,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  351,  351,  351,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,

      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
        0,  351,  351
    } ;

static const short int yy_nxt[554] =
    {   0,
        4,    5,    6,    7,    8,    9,   10,   11,   12,   13,
       14,   15,   16,   17,   18,   19,   17,   17,   20,    4,
       21,   22,   23,   24,   25,   26,   27,   28,   29,   28,
       28,   28,   30,   31,   32,   28,   28,   33,   34,   35,
       28,   36,   37,   28,   28,   28,    4,   28,   28,   28,
       28,   28,   28,   38,   39,   40,   41,  350,  149,  349,
       75,  150,   42,   42,   46,   47,   47,   47,   47,   47,
       46,   48,   48,   48,   48,   48,   46,   49,   49,   49,
       49,   47,   54,   57,   75,   61,   66,   69,   70,   55,
       98,   71,  105,   58,   62,   63,   67,   64,   83,   74,

       78,   72,   68,   75,   84,   41,   99,  108,  106,   79,
      118,   42,   42,  348,   76,  119,   80,  113,  109,   77,
       86,   87,   88,   86,   86,   83,  114,   75,   84,   46,
       89,   89,   89,   89,   89,   46,   47,   47,   47,   47,
       47,   46,   47,   47,   47,   47,   89,   95,  116,  122,
      128,   84,  288,  288,  288,  288,  129,   96,  347,  346,
       97,   89,   89,   89,   89,   89,  123,  117,  131,  132,
      132,  132,  132,  132,  168,   84,  131,  133,  133,  133,
      133,  133,  131,  134,  134,  134,  134,  132,  139,  157,
      178,  179,  180,  178,  178,  345,  140,  344,  158,  168,

      131,  132,  132,  132,  132,  132,  343,  342,  341,  141,
      131,  132,  132,  132,  132,  220,  221,  221,  221,  221,
      221,  220,  222,  222,  222,  222,  222,  220,  223,  223,
      223,  223,  221,  247,  258,  259,  260,  258,  258,  340,
      339,  248,  220,  221,  221,  221,  221,  221,  220,  221,
      221,  221,  221,  288,  288,  288,  288,  288,  289,  289,
      289,  289,  289,  290,  290,  290,  290,  288,  288,  288,
      288,  288,  288,   43,  338,   43,   51,   51,  337,  336,
      335,  334,  333,  332,  331,  330,  329,  328,  327,  326,
      325,  324,  323,  322,  321,  320,  319,  318,  317,  316,

      315,  314,  313,  312,  311,  310,  309,  308,  307,  306,
      305,  304,  303,  302,  301,  300,  299,  298,  297,  296,
      295,  294,  293,  292,  291,  287,  286,  285,  284,  283,
      282,  281,  280,  279,  278,  277,  276,  275,  274,  273,
      272,  271,  270,  269,  268,  267,  266,  265,  264,  263,
      262,  261,  220,  257,  256,  255,  254,  253,  252,  251,
      250,  249,  246,  245,  244,  243,  242,  241,  240,  239,
      238,  237,  236,  235,  234,  233,  232,  231,  230,  229,
      228,  227,  226,  225,  224,  219,  218,  217,  216,  215,
      214,  213,  212,  211,  210,  209,  208,  207,  206,  205,

      204,  203,  202,  201,  200,  199,  198,  197,  196,  195,
      194,  193,  192,  191,  190,  189,  188,  187,  186,  185,
      184,  183,  182,  181,  131,  177,  176,  175,  174,  173,
      172,  171,  170,  169,  167,  166,  165,  164,  163,  162,
      161,  160,  159,  156,  155,  154,  153,  152,  151,  148,
      147,  146,  145,  144,  143,  142,  138,  137,  136,  135,
      130,  127,  126,  125,  124,  121,  120,  115,  112,  111,
      110,  107,  104,  103,  102,  101,  100,   94,   93,   92,
       91,   90,   85,   82,   81,   73,   65,   60,   59,   56,
       53,   52,   50,   45,   44,  351,    3,  351,  351,  351,

      351,  351,  351,  351,  351,  351,  351,  351,  351,  351,
      351,  351,  351,  351,  351,  351,  351,  351,  351,  351,
      351,  351,  351,  351,  351,  351,  351,  351,  351,  351,
      351,  351,  351,  351,  351,  351,  351,  351,  351,  351,
      351,  351,  351,  351,  351,  351,  351,  351,  351,  351,
      351,  351,  351
    } ;

static const short int yy_chk[554] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,   11,  348,  104,  347,
       38,  104,   11,   11,   17,   17,   17,   17,   17,   17,
       18,   18,   18,   18,   18,   18,   19,   19,   19,   19,
       19,   19,   23,   25,   38,   29,   31,   32,   32,   23,
       57,   32,   63,   25,   29,   29,   31,   29,   41,   34,

       35,   32,   31,   34,   41,   42,   57,   65,   63,   35,
       73,   42,   42,  346,   34,   73,   35,   69,   65,   34,
       46,   46,   46,   46,   46,   41,   69,   34,   41,   47,
       47,   47,   47,   47,   47,   48,   48,   48,   48,   48,
       48,   49,   49,   49,   49,   49,   49,   56,   72,   76,
       81,   85,  290,  290,  290,  290,   81,   56,  345,  343,
       56,   89,   89,   89,   89,   89,   76,   72,   86,   86,
       86,   86,   86,   86,  121,   85,   87,   87,   87,   87,
       87,   87,   88,   88,   88,   88,   88,   88,   95,  111,
      131,  131,  131,  131,  131,  342,   95,  337,  111,  121,

      133,  133,  133,  133,  133,  133,  336,  335,  332,   95,
      134,  134,  134,  134,  134,  178,  178,  178,  178,  178,
      178,  179,  179,  179,  179,  179,  179,  180,  180,  180,
      180,  180,  180,  209,  220,  220,  220,  220,  220,  330,
      329,  209,  222,  222,  222,  222,  222,  222,  223,  223,
      223,  223,  223,  258,  258,  258,  258,  258,  259,  259,
      259,  259,  259,  260,  260,  260,  260,  260,  289,  289,
      289,  289,  289,  352,  324,  352,  353,  353,  322,  321,
      320,  317,  316,  315,  314,  313,  312,  311,  310,  309,
      307,  306,  305,  302,  300,  299,  298,  297,  295,  294,

      293,  292,  291,  287,  286,  285,  284,  283,  282,  281,
      280,  279,  278,  277,  276,  275,  274,  273,  272,  269,
      268,  266,  265,  264,  263,  257,  256,  255,  254,  250,
      249,  248,  247,  246,  244,  243,  242,  241,  240,  239,
      238,  237,  236,  235,  234,  233,  232,  231,  230,  228,
      227,  226,  221,  219,  218,  216,  215,  214,  213,  212,
      211,  210,  208,  207,  205,  204,  203,  202,  201,  200,
      198,  197,  195,  194,  193,  191,  190,  189,  188,  187,
      186,  185,  184,  183,  181,  177,  176,  175,  173,  172,
      171,  170,  169,  167,  166,  165,  164,  163,  162,  161,

      160,  158,  157,  156,  155,  154,  153,  152,  151,  150,
      149,  148,  147,  145,  144,  143,  142,  141,  140,  139,
      138,  137,  136,  135,  132,  130,  129,  128,  127,  126,
      125,  124,  123,  122,  120,  119,  118,  117,  116,  115,
      114,  113,  112,  110,  109,  108,  107,  106,  105,  103,
      102,  101,  100,   99,   97,   96,   94,   93,   92,   91,
       82,   80,   79,   78,   77,   75,   74,   70,   68,   67,
       66,   64,   62,   61,   60,   59,   58,   55,   54,   53,
       52,   50,   43,   37,   36,   33,   30,   27,   26,   24,
       22,   21,   20,   16,   15,    3,  351,  351,  351,  351,

      351,  351,  351,  351,  351,  351,  351,  351,  351,  351,
      351,  351,  351,  351,  351,  351,  351,  351,  351,  351,
      351,  351,  351,  351,  351,  351,  351,  351,  351,  351,
      351,  351,  351,  351,  351,  351,  351,  351,  351,  351,
      351,  351,  351,  351,  351,  351,  351,  351,  351,  351,
      351,  351,  351
    } ;

static yy_state_type yy_last_accepting_state;
static YY_CHAR *yy_last_accepting_cpos;

/* the intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0

/* these variables are all declared out here so that section 3 code can
 * manipulate them
 */
/* points to current character in buffer */
static YY_CHAR *yy_c_buf_p = (YY_CHAR *) 0;
static int yy_init = 1;         /* whether we need to initialize */
static int yy_start = 0;        /* start state number */

/* flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

static yy_state_type yy_get_previous_state YY_PROTO(( void ));
static yy_state_type yy_try_NUL_trans YY_PROTO(( yy_state_type current_state ));
static int yy_get_next_buffer YY_PROTO(( void ));
static void yyunput YY_PROTO(( YY_CHAR c, YY_CHAR *buf_ptr ));
void yyrestart YY_PROTO(( FILE *input_file ));
void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));

#define yy_new_buffer yy_create_buffer

YY_DECL
    {
    register yy_state_type yy_current_state;
    register YY_CHAR *yy_cp, *yy_bp;
    register int yy_act;



    if ( yy_init )
        {
        YY_USER_INIT;

        if ( ! yy_start )
            yy_start = 1;       /* first start state */

        if ( ! yyin )
            yyin = stdin;

        if ( ! yyout )
            yyout = stdout;

        if ( yy_current_buffer )
            yy_init_buffer( yy_current_buffer, yyin );
        else
            yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

        yy_load_buffer_state();

        yy_init = 0;
        }

    while ( 1 )         /* loops until end-of-file is reached */
        {
        yy_cp = yy_c_buf_p;

        /* support of yytext */
        *yy_cp = yy_hold_char;

        /* yy_bp points to the position in yy_ch_buf of the start of the
         * current run.
         */
        yy_bp = yy_cp;

        yy_current_state = yy_start;
yy_match:
        do
            {
            register YY_CHAR yy_c = yy_ec[*yy_cp];
            if ( yy_accept[yy_current_state] )
                {
                yy_last_accepting_state = yy_current_state;
                yy_last_accepting_cpos = yy_cp;
                }
            while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
                {
                yy_current_state = yy_def[yy_current_state];
                if ( yy_current_state >= 352 )
                    yy_c = yy_meta[yy_c];
                }
            yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
            ++yy_cp;
            }
        while ( yy_current_state != 351 );
        yy_cp = yy_last_accepting_cpos;
        yy_current_state = yy_last_accepting_state;

yy_find_action:
        yy_act = yy_accept[yy_current_state];

        YY_DO_BEFORE_ACTION;
        YY_USER_ACTION;

do_action:      /* this label is used only to access EOF actions */


        switch ( yy_act )
            {
            case 0: /* must backtrack */
            /* undo the effects of YY_DO_BEFORE_ACTION */
            *yy_cp = yy_hold_char;
            yy_cp = yy_last_accepting_cpos;
            yy_current_state = yy_last_accepting_state;
            goto yy_find_action;

case 1:
{ lineno++; /* line feed */ }
        YY_BREAK
case 2:
{ /* form feed */ }
        YY_BREAK
case 3:
{ /* carriage return (no line feed) */ }
        YY_BREAK
case 4:
{ /* vertical tab */ }
        YY_BREAK
case 5:
{ /* white space */ }
        YY_BREAK
case 6:
{ return (kwACCESS); }
        YY_BREAK
case 7:
{ return (kwBEGIN); }
        YY_BREAK
case 8:
{ return (kwCHOICE); }
        YY_BREAK
case 9:
{ return (kwCOUNTER); }
        YY_BREAK
case 10:
{ return (kwDEFAULT); }
        YY_BREAK
case 11:
{ return (kwDEFINITIONS); }
        YY_BREAK
case 12:
{ return (kwDEFVAL); }
        YY_BREAK
case 13:
{ return (kwDEPRECATED); }
        YY_BREAK
case 14:
{ return (kwDESCRIPTION); }
        YY_BREAK
case 15:
{ return (kwEND); }
        YY_BREAK
case 16:
{ return (kwENTERPRISE); }
        YY_BREAK
case 17:
{
                                        #ifdef DONTSUCKEXPORTS
                                                return (kwEXPORTS);
                                        #else
                                                suckUpExports ();
                                        #endif
                                        }
        YY_BREAK
case 18:
{ return (kwFROM); }
        YY_BREAK
case 19:
{ return (kwGAUGE); }
        YY_BREAK
case 20:
{ return (kwIDENTIFIER); }
        YY_BREAK
case 21:
{ return (kwIMPLICIT); }
        YY_BREAK
case 22:
{
                                        #ifdef DONTSUCKIMPORTS
                                                return (kwIMPORTS);
                                        #else
                                                suckUpImports ();
                                        #endif
                                        }
        YY_BREAK
case 23:
{ return (kwINDEX); }
        YY_BREAK
case 24:
{ return (kwINTEGER); }
        YY_BREAK
case 25:
{ return (kwIPADDRESS); }
        YY_BREAK
case 26:
{ return (kwMANDATORY); }
        YY_BREAK
case 27:
{ return (kwMACRO); }
        YY_BREAK
case 28:
{ return (kwNETWORKADDRESS); }
        YY_BREAK
case 29:
{ return (kwNOT_ACCESSIBLE); }
        YY_BREAK
case 30:
{ return (kwNOTATION); }
        YY_BREAK
case 31:
{ return (kwNULL); }
        YY_BREAK
case 32:
{ return (kwOBJECT); }
        YY_BREAK
case 33:
{ return (kwOBJECT_TYPE); }
        YY_BREAK
case 34:
{ return (kwOBSOLETE); }
        YY_BREAK
case 35:
{ return (kwOCTET); }
        YY_BREAK
case 36:
{ return (kwOF); }
        YY_BREAK
case 37:
{ return (kwOPAQUE); }
        YY_BREAK
case 38:
{ return (kwOPTIONAL); }
        YY_BREAK
case 39:
{ return (kwREAD_ONLY); }
        YY_BREAK
case 40:
{ return (kwREAD_WRITE); }
        YY_BREAK
case 41:
{ return (kwREFERENCE); }
        YY_BREAK
case 42:
{ return (kwSEQUENCE); }
        YY_BREAK
case 43:
{ return (kwSIZE); }
        YY_BREAK
case 44:
{ return (kwSTATUS); }
        YY_BREAK
case 45:
{ return (kwSTRING); }
        YY_BREAK
case 46:
{ return (kwSYNTAX); }
        YY_BREAK
case 47:
{ return (kwTIMETICKS); }
        YY_BREAK
case 48:
{ return (kwTRAP_TYPE); }
        YY_BREAK
case 49:
{ return (kwTYPE); }
        YY_BREAK
case 50:
{ return (kwVARIABLES); }
        YY_BREAK
case 51:
{ return (kwVALUE); }
        YY_BREAK
case 52:
{ return (kwWRITE_ONLY); }
        YY_BREAK
case 53:
{ return (tokDOTDOT); }
        YY_BREAK
case 54:
{ return (tokIS); }
        YY_BREAK
case 55:
{ strcpy (yylval.strval, yytext);
                                          return (tokNAME); }
        YY_BREAK
case 56:
{ return (tokIP); }
        YY_BREAK
case 57:
{ yylval.numval = atol (yytext);
                                          return (tokNUMBER); }
        YY_BREAK
case 58:
{ return (tokBINARYSTR); }
        YY_BREAK
case 59:
{ return (tokHEXSTR); }
        YY_BREAK
case 60:
{ string (); return (tokSTRING); }
        YY_BREAK
case 61:
{ comment (); }
        YY_BREAK
case 62:
case 63:
case 64:
case 65:
case 66:
{ return (yytext[0]); }
        YY_BREAK
case 67:
{ return (yytext[0]); /* return the bad character */ }
        YY_BREAK
case 68:
YY_FATAL_ERROR( "flex scanner jammed" );
        YY_BREAK
case YY_STATE_EOF(INITIAL):
    yyterminate();

            case YY_END_OF_BUFFER:
                {
                /* amount of text matched not including the EOB char */
                int yy_amount_of_matched_text = yy_cp - yytext - 1;

                /* undo the effects of YY_DO_BEFORE_ACTION */
                *yy_cp = yy_hold_char;

                /* note that here we test for yy_c_buf_p "<=" to the position
                 * of the first EOB in the buffer, since yy_c_buf_p will
                 * already have been incremented past the NUL character
                 * (since all states make transitions on EOB to the end-
                 * of-buffer state).  Contrast this with the test in yyinput().
                 */
                if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
                    /* this was really a NUL */
                    {
                    yy_state_type yy_next_state;

                    yy_c_buf_p = yytext + yy_amount_of_matched_text;

                    yy_current_state = yy_get_previous_state();

                    /* okay, we're now positioned to make the
                     * NUL transition.  We couldn't have
                     * yy_get_previous_state() go ahead and do it
                     * for us because it doesn't know how to deal
                     * with the possibility of jamming (and we
                     * don't want to build jamming into it because
                     * then it will run more slowly)
                     */

                    yy_next_state = yy_try_NUL_trans( yy_current_state );

                    yy_bp = yytext + YY_MORE_ADJ;

                    if ( yy_next_state )
                        {
                        /* consume the NUL */
                        yy_cp = ++yy_c_buf_p;
                        yy_current_state = yy_next_state;
                        goto yy_match;
                        }

                    else
                        {
                            yy_cp = yy_last_accepting_cpos;
                            yy_current_state = yy_last_accepting_state;
                        goto yy_find_action;
                        }
                    }

                else switch ( yy_get_next_buffer() )
                    {
                    case EOB_ACT_END_OF_FILE:
                        {
                        yy_did_buffer_switch_on_eof = 0;

                        if ( yywrap() )
                            {
                            /* note: because we've taken care in
                             * yy_get_next_buffer() to have set up yytext,
                             * we can now set up yy_c_buf_p so that if some
                             * total hoser (like flex itself) wants
                             * to call the scanner after we return the
                             * YY_NULL, it'll still work - another YY_NULL
                             * will get returned.
                             */
                            yy_c_buf_p = yytext + YY_MORE_ADJ;

                            yy_act = YY_STATE_EOF((yy_start - 1) / 2);
                            goto do_action;
                            }

                        else
                            {
                            if ( ! yy_did_buffer_switch_on_eof )
                                YY_NEW_FILE;
                            }
                        }
                        break;

                    case EOB_ACT_CONTINUE_SCAN:
                        yy_c_buf_p = yytext + yy_amount_of_matched_text;

                        yy_current_state = yy_get_previous_state();

                        yy_cp = yy_c_buf_p;
                        yy_bp = yytext + YY_MORE_ADJ;
                        goto yy_match;

                    case EOB_ACT_LAST_MATCH:
                        yy_c_buf_p =
                            &yy_current_buffer->yy_ch_buf[yy_n_chars];

                        yy_current_state = yy_get_previous_state();

                        yy_cp = yy_c_buf_p;
                        yy_bp = yytext + YY_MORE_ADJ;
                        goto yy_find_action;
                    }
                break;
                }

            default:
#ifdef FLEX_DEBUG
                printf( "action # %d\n", yy_act );
#endif
                YY_FATAL_ERROR(
                        "fatal flex scanner internal error--no action found" );
            }
        }
    }


/* yy_get_next_buffer - try to read in a new buffer
 *
 * synopsis
 *     int yy_get_next_buffer();
 *
 * returns a code representing an action
 *     EOB_ACT_LAST_MATCH -
 *     EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *     EOB_ACT_END_OF_FILE - end of file
 */

static int yy_get_next_buffer()

    {
    register YY_CHAR *dest = yy_current_buffer->yy_ch_buf;
    register YY_CHAR *source = yytext - 1; /* copy prev. char, too */
    register int number_to_move, i;
    int ret_val;

    if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
        YY_FATAL_ERROR(
                "fatal flex scanner internal error--end of buffer missed" );

    /* try to read more data */

    /* first move last chars to start of buffer */
    number_to_move = yy_c_buf_p - yytext;

    for ( i = 0; i < number_to_move; ++i )
        *(dest++) = *(source++);

    if ( yy_current_buffer->yy_eof_status != EOF_NOT_SEEN )
        /* don't do the read, it's not guaranteed to return an EOF,
         * just force an EOF
         */
        yy_n_chars = 0;

    else
        {
        int num_to_read = yy_current_buffer->yy_buf_size - number_to_move - 1;

        if ( num_to_read > YY_READ_BUF_SIZE )
            num_to_read = YY_READ_BUF_SIZE;

        else if ( num_to_read <= 0 )
            YY_FATAL_ERROR( "fatal error - scanner input buffer overflow" );

        /* read in more data */
        YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
                  yy_n_chars, num_to_read );
        }

    if ( yy_n_chars == 0 )
        {
        if ( number_to_move == 1 )
            {
            ret_val = EOB_ACT_END_OF_FILE;
            yy_current_buffer->yy_eof_status = EOF_DONE;
            }

        else
            {
            ret_val = EOB_ACT_LAST_MATCH;
            yy_current_buffer->yy_eof_status = EOF_PENDING;
            }
        }

    else
        ret_val = EOB_ACT_CONTINUE_SCAN;

    yy_n_chars += number_to_move;
    yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
    yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

    /* yytext begins at the second character in yy_ch_buf; the first
     * character is the one which preceded it before reading in the latest
     * buffer; it needs to be kept around in case it's a newline, so
     * yy_get_previous_state() will have with '^' rules active
     */

    yytext = &yy_current_buffer->yy_ch_buf[1];

    return ( ret_val );
    }


/* yy_get_previous_state - get the state just before the EOB char was reached
 *
 * synopsis
 *     yy_state_type yy_get_previous_state();
 */

static yy_state_type yy_get_previous_state()

    {
    register yy_state_type yy_current_state;
    register YY_CHAR *yy_cp;

    yy_current_state = yy_start;

    for ( yy_cp = yytext + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
        {
        register YY_CHAR yy_c = (*yy_cp ? yy_ec[*yy_cp] : 1);
        if ( yy_accept[yy_current_state] )
            {
            yy_last_accepting_state = yy_current_state;
            yy_last_accepting_cpos = yy_cp;
            }
        while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
            {
            yy_current_state = yy_def[yy_current_state];
            if ( yy_current_state >= 352 )
                yy_c = yy_meta[yy_c];
            }
        yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
        }

    return ( yy_current_state );
    }


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *     next_state = yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static yy_state_type yy_try_NUL_trans( register yy_state_type yy_current_state )
#else
static yy_state_type yy_try_NUL_trans( yy_current_state )
register yy_state_type yy_current_state;
#endif

    {
    register int yy_is_jam;
    register YY_CHAR *yy_cp = yy_c_buf_p;

    register YY_CHAR yy_c = 1;
    if ( yy_accept[yy_current_state] )
        {
        yy_last_accepting_state = yy_current_state;
        yy_last_accepting_cpos = yy_cp;
        }
    while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
        {
        yy_current_state = yy_def[yy_current_state];
        if ( yy_current_state >= 352 )
            yy_c = yy_meta[yy_c];
        }
    yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
    yy_is_jam = (yy_current_state == 351);

    return ( yy_is_jam ? 0 : yy_current_state );
    }


#ifdef YY_USE_PROTOS
static void yyunput( YY_CHAR c, register YY_CHAR *yy_bp )
#else
static void yyunput( c, yy_bp )
YY_CHAR c;
register YY_CHAR *yy_bp;
#endif

    {
    register YY_CHAR *yy_cp = yy_c_buf_p;

    /* undo effects of setting up yytext */
    *yy_cp = yy_hold_char;

    if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
        { /* need to shift things up to make room */
        register int number_to_move = yy_n_chars + 2; /* +2 for EOB chars */
        register YY_CHAR *dest =
            &yy_current_buffer->yy_ch_buf[yy_current_buffer->yy_buf_size + 2];
        register YY_CHAR *source =
            &yy_current_buffer->yy_ch_buf[number_to_move];

        while ( source > yy_current_buffer->yy_ch_buf )
            *--dest = *--source;

        yy_cp += dest - source;
        yy_bp += dest - source;
        yy_n_chars = yy_current_buffer->yy_buf_size;

        if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
            YY_FATAL_ERROR( "flex scanner push-back overflow" );
        }

    if ( yy_cp > yy_bp && yy_cp[-1] == '\n' )
        yy_cp[-2] = '\n';

    *--yy_cp = c;

    /* note: the formal parameter *must* be called "yy_bp" for this
     *       macro to now work correctly
     */
    YY_DO_BEFORE_ACTION; /* set up yytext again */
    }


#ifdef __cplusplus
static int yyinput()
#else
static int input()
#endif

    {
    int c;
    YY_CHAR *yy_cp = yy_c_buf_p;

    *yy_cp = yy_hold_char;

    if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
        {
        /* yy_c_buf_p now points to the character we want to return.
         * If this occurs *before* the EOB characters, then it's a
         * valid NUL; if not, then we've hit the end of the buffer.
         */
        if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
            /* this was really a NUL */
            *yy_c_buf_p = '\0';

        else
            { /* need more input */
            yytext = yy_c_buf_p;
            ++yy_c_buf_p;

            switch ( yy_get_next_buffer() )
                {
                case EOB_ACT_END_OF_FILE:
                    {
                    if ( yywrap() )
                        {
                        yy_c_buf_p = yytext + YY_MORE_ADJ;
                        return ( EOF );
                        }

                    YY_NEW_FILE;

#ifdef __cplusplus
                    return ( yyinput() );
#else
                    return ( input() );
#endif
                    }
                    break;

                case EOB_ACT_CONTINUE_SCAN:
                    yy_c_buf_p = yytext + YY_MORE_ADJ;
                    break;

                case EOB_ACT_LAST_MATCH:
#ifdef __cplusplus
                    YY_FATAL_ERROR( "unexpected last match in yyinput()" );
#else
                    YY_FATAL_ERROR( "unexpected last match in input()" );
#endif
                }
            }
        }

    c = *yy_c_buf_p;
    yy_hold_char = *++yy_c_buf_p;

    return ( c );
    }


#ifdef YY_USE_PROTOS
void yyrestart( FILE *input_file )
#else
void yyrestart( input_file )
FILE *input_file;
#endif

    {
    yy_init_buffer( yy_current_buffer, input_file );
    yy_load_buffer_state();
    }


#ifdef YY_USE_PROTOS
void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif

    {
    if ( yy_current_buffer == new_buffer )
        return;

    if ( yy_current_buffer )
        {
        /* flush out information for old buffer */
        *yy_c_buf_p = yy_hold_char;
        yy_current_buffer->yy_buf_pos = yy_c_buf_p;
        yy_current_buffer->yy_n_chars = yy_n_chars;
        }

    yy_current_buffer = new_buffer;
    yy_load_buffer_state();

    /* we don't actually know whether we did this switch during
     * EOF (yywrap()) processing, but the only time this flag
     * is looked at is after yywrap() is called, so it's safe
     * to go ahead and always set it.
     */
    yy_did_buffer_switch_on_eof = 1;
    }


#ifdef YY_USE_PROTOS
void yy_load_buffer_state( void )
#else
void yy_load_buffer_state()
#endif

    {
    yy_n_chars = yy_current_buffer->yy_n_chars;
    yytext = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
    yyin = yy_current_buffer->yy_input_file;
    yy_hold_char = *yy_c_buf_p;
    }


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
#endif

    {
    YY_BUFFER_STATE b;

    b = (YY_BUFFER_STATE) malloc( sizeof( struct yy_buffer_state ) );

    if ( ! b )
        YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

    b->yy_buf_size = size;

    /* yy_ch_buf has to be 2 characters longer than the size given because
     * we need to put in 2 end-of-buffer characters.
     */
    b->yy_ch_buf = (YY_CHAR *) malloc( (unsigned) (b->yy_buf_size + 2) );

    if ( ! b->yy_ch_buf )
        YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

    yy_init_buffer( b, file );

    return ( b );
    }


#ifdef YY_USE_PROTOS
void yy_delete_buffer( YY_BUFFER_STATE b )
#else
void yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif

    {
    if ( b == yy_current_buffer )
        yy_current_buffer = (YY_BUFFER_STATE) 0;

    free( (char *) b->yy_ch_buf );
    free( (char *) b );
    }


#ifdef YY_USE_PROTOS
void yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif

    {
    b->yy_input_file = file;

    /* we put in the '\n' and start reading from [1] so that an
     * initial match-at-newline will be true.
     */

    b->yy_ch_buf[0] = '\n';
    b->yy_n_chars = 1;

    /* we always need two end-of-buffer characters.  The first causes
     * a transition to the end-of-buffer state.  The second causes
     * a jam in that state.
     */
    b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;
    b->yy_ch_buf[2] = YY_END_OF_BUFFER_CHAR;

    b->yy_buf_pos = &b->yy_ch_buf[1];

    b->yy_eof_status = EOF_NOT_SEEN;
    }
