/*++
 *
 *  WOW v1.0
 *
 *  Copyright (c) 1991, 1992, 1993 Microsoft Corporation
 *
 *  WUTBL2.h
 *  WOW32 user API thunks
 *
 *  This file is included into the master thunk table.
 *
--*/


    {W32FUN(UNIMPLEMENTEDAPI,               "DUMMYENTRY",           MOD_USER,      0)},
    {W32FUN(WU32MessageBox,                 "MESSAGEBOX",           MOD_USER,      sizeof(MESSAGEBOX16))},
    {W32FUN(LOCALAPI,                       "OLDEXITWINDOWS",       MOD_USER,      0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "ENABLEOEMLAYER",       MOD_USER,      0)},
    {W32FUN(NOPAPI,                         "DISABLEOEMLAYER",      MOD_USER,      0)},
    {W32FUN(LOCALAPI,                       "INITAPP",              MOD_USER,      0)},
    {W32FUN(WU32PostQuitMessage,            "POSTQUITMESSAGE",      MOD_USER,      sizeof(POSTQUITMESSAGE16))},
    {W32FUN(WU32ExitWindows,                "EXITWINDOWS",          MOD_USER,      sizeof(EXITWINDOWS16))},
    {W32FUN(UNIMPLEMENTED95API,             "PlaySoundEvent",       MOD_USER,      sizeof(PLAYSOUNDEVENT16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                     MOD_USER,      0)},

  /*** 0010 ***/
    {W32FUN(WU32SetTimer,                   "SETTIMER",              MOD_USER,     sizeof(SETTIMER16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "SETSYSTEMTIMER",        MOD_USER,     0)},
    {W32FUN(WU32KillTimer,                  "KILLTIMER",             MOD_USER,     sizeof(KILLTIMER16))},
    {W32FUN(WU32GETTICKCOUNT,               "GETTICKCOUNT",          MOD_USER,     0)},
    {W32FUN(WU32GetTimerResolution,         "GETTIMERRESOLUTION",    MOD_USER,     0)},
    {W32FUN(WU32GETTICKCOUNT,               "GETCURRENTTIME",        MOD_USER,     0)},
    {W32FUN(WU32ClipCursor,                 "CLIPCURSOR",            MOD_USER,     sizeof(CLIPCURSOR16))},
    {W32FUN(WU32GETCURSORPOS,               "GETCURSORPOS",          MOD_USER,     sizeof(GETCURSORPOS16))},
    {W32FUN(WU32SetCapture,                 "SetCapture",            MOD_USER,     sizeof(SETCAPTURE16))},
    {W32FUN(IT(ReleaseCapture),             "ReleaseCapture",        MOD_USER,     0)},

  /*** 0020 ***/
    {W32FUN(IT(SetDoubleClickTime),         "SetDoubleClickTime",    MOD_USER,     sizeof(SETDOUBLECLICKTIME16))},
    {W32FUN(IT(GetDoubleClickTime),         "GetDoubleClickTime",    MOD_USER,     0)},
    {W32FUN(IT(SetFocus),                   "SetFocus",              MOD_USER,     sizeof(SETFOCUS16))},
    {W32FUN(IT(GetFocus),                   "GetFocus",              MOD_USER,     0)},
    {W32FUN(IT(RemoveProp),                 "RemoveProp",            MOD_USER,     sizeof(REMOVEPROP16))},
    {W32FUN(IT(GetProp),                    "GetProp",               MOD_USER,     sizeof(GETPROP16))},
    {W32FUN(IT(SetProp),                    "SetProp",               MOD_USER,     sizeof(SETPROP16))},
    {W32FUN(WU32EnumProps,                  "ENUMPROPS",             MOD_USER,     sizeof(ENUMPROPS16))},
    {W32FUN(WU32CLIENTTOSCREEN,             "CLIENTTOSCREEN",        MOD_USER,     sizeof(CLIENTTOSCREEN16))},
    {W32FUN(WU32SCREENTOCLIENT,             "SCREENTOCLIENT",        MOD_USER,     sizeof(SCREENTOCLIENT16))},

  /*** 0030 ***/
    {W32FUN(WU32WindowFromPoint,            "WindowFromPoint",        MOD_USER,    sizeof(WINDOWFROMPOINT16))},
    {W32FUN(WU32ISICONIC,                   "IsIconic",               MOD_USER,    sizeof(ISICONIC16))},
    {W32FUN(WU32GETWINDOWRECT,              "GetWindowRect",          MOD_USER,    sizeof(GETWINDOWRECT16))},
    {W32FUN(WU32GETCLIENTRECT,              "GetClientRect",          MOD_USER,    sizeof(GETCLIENTRECT16))},
    {W32FUN(IT(EnableWindow),               "EnableWindow",           MOD_USER,    sizeof(ENABLEWINDOW16))},
    {W32FUN(WU32ISWINDOWENABLED,            "IsWindowEnabled",        MOD_USER,    sizeof(ISWINDOWENABLED16))},
    {W32FUN(WU32GetWindowText,              "GetWindowText",          MOD_USER,    sizeof(GETWINDOWTEXT16))},
    {W32FUN(WU32SetWindowText,              "SetWindowText",          MOD_USER,    sizeof(SETWINDOWTEXT16))},
    {W32FUN(IT(GetWindowTextLength),        "GetWindowTextLength",    MOD_USER,    sizeof(GETWINDOWTEXTLENGTH16))},
    {W32FUN(WU32BeginPaint,                 "BEGINPAINT",             MOD_USER,    sizeof(BEGINPAINT16))},

  /*** 0040 ***/
    {W32FUN(WU32EndPaint,                   "ENDPAINT",               MOD_USER,    sizeof(ENDPAINT16))},
    {W32FUN(WU32CreateWindow,               "CreateWindow",           MOD_USER,    sizeof(CREATEWINDOW16))},
    {W32FUN(IT(ShowWindow),                 "ShowWindow",             MOD_USER,    sizeof(SHOWWINDOW16))},
    {W32FUN(IT(CloseWindow),                "CloseWindow",            MOD_USER,    sizeof(CLOSEWINDOW16))},
    {W32FUN(IT(OpenIcon),                   "OpenIcon",               MOD_USER,    sizeof(OPENICON16))},
    {W32FUN(IT(BringWindowToTop),           "BringWindowToTop",       MOD_USER,    sizeof(BRINGWINDOWTOTOP16))},
    {W32FUN(WU32GETPARENT,                  "GetParent",              MOD_USER,    sizeof(GETPARENT16))},
    {W32FUN(WU32ISWINDOW,                   "IsWindow",               MOD_USER,    sizeof(ISWINDOW16))},
    {W32FUN(WU32ISCHILD,                    "ISCHILD",                MOD_USER,    sizeof(ISCHILD16))},
    {W32FUN(WU32ISWINDOWVISIBLE,            "IsWindowVisible",        MOD_USER,    sizeof(ISWINDOWVISIBLE16))},

  /*** 0050 ***/
    {W32FUN(WU32FindWindow,                 "FINDWINDOW",             MOD_USER,    sizeof(FINDWINDOW16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "ISTWOBYTECHARPREFIX",    MOD_USER,    sizeof(ISTWOBYTECHARPREFIX16))},
    {W32FUN(IT(AnyPopup),                   "AnyPopup",               MOD_USER,    0)},
    {W32FUN(WU32DestroyWindow,              "DestroyWindow",          MOD_USER,    sizeof(DESTROYWINDOW16))},
    {W32FUN(WU32EnumWindows,                "EnumWindows",            MOD_USER,    sizeof(ENUMWINDOWS16))},
    {W32FUN(WU32EnumChildWindows,           "EnumChildWindows",       MOD_USER,    sizeof(ENUMCHILDWINDOWS16))},
    {W32FUN(WU32MoveWindow,                 "MoveWindow",             MOD_USER,    sizeof(MOVEWINDOW16))},
    {W32FUN(WU32RegisterClass,              "RegisterClass",          MOD_USER,    sizeof(REGISTERCLASS16))},
    {W32FUN(WU32GETCLASSNAME,               "GetClassName",           MOD_USER,    sizeof(GETCLASSNAME16))},
    {W32FUN(IT(SetActiveWindow),            "SetActiveWindow",        MOD_USER,    sizeof(SETACTIVEWINDOW16))},

  /*** 0060 ***/
    {W32FUN(WU32GetActiveWindow,            "GetActiveWindow",        MOD_USER,    0)},
    {W32FUN(WU32ScrollWindow,               "ScrollWindow",           MOD_USER,    sizeof(SCROLLWINDOW16))},
    {W32FUN(IT(SetScrollPos),               "SetScrollPos",           MOD_USER,    sizeof(SETSCROLLPOS16))},
    {W32FUN(IT(GetScrollPos),               "GetScrollPos",           MOD_USER,    sizeof(GETSCROLLPOS16))},
    {W32FUN(IT(SetScrollRange),             "SetScrollRange",         MOD_USER,    sizeof(SETSCROLLRANGE16))},
    {W32FUN(WU32GetScrollRange,             "GetScrollRange",         MOD_USER,    sizeof(GETSCROLLRANGE16))},
    {W32FUN(WU32GetDC,                      "GetDC",                  MOD_USER,    sizeof(GETDC16))},
    {W32FUN(WU32GetWindowDC,                "GetWindowDC",            MOD_USER,    sizeof(GETWINDOWDC16))},
    {W32FUN(WU32ReleaseDC,                  "ReleaseDC",              MOD_USER,    sizeof(RELEASEDC16))},
    {W32FUN(WU32SetCursor,                  "SetCursor",              MOD_USER,    sizeof(SETCURSOR16))},

  /*** 0070 ***/
    {W32FUN(WU32SetCursorPos,               "SETCURSORPOS",           MOD_USER,    sizeof(SETCURSORPOS16))},
    {W32FUN(WU32ShowCursor,                 "SHOWCURSOR",             MOD_USER,    sizeof(SHOWCURSOR16))},
    {W32FUN(LOCALAPI,                       "SETRECT",                MOD_USER,    sizeof(SETRECT16))},
    {W32FUN(LOCALAPI,                       "SETRECTEMPTY",           MOD_USER,    sizeof(SETRECTEMPTY16))},
    {W32FUN(LOCALAPI,                       "COPYRECT",               MOD_USER,    sizeof(COPYRECT16))},
    {W32FUN(LOCALAPI,                       "ISRECTEMPTY",            MOD_USER,    sizeof(ISRECTEMPTY16))},
    {W32FUN(LOCALAPI,                       "PTINRECT",               MOD_USER,    sizeof(PTINRECT16))},
    {W32FUN(LOCALAPI,                       "OFFSETRECT",             MOD_USER,    sizeof(OFFSETRECT16))},
    {W32FUN(LOCALAPI,                       "INFLATERECT",            MOD_USER,    sizeof(INFLATERECT16))},
    {W32FUN(LOCALAPI,                       "INTERSECTRECT",          MOD_USER,    sizeof(INTERSECTRECT16))},

  /*** 0080 ***/
    {W32FUN(LOCALAPI,                       "UNIONRECT",               MOD_USER,   sizeof(UNIONRECT16))},
    {W32FUN(WU32FillRect,                   "FILLRECT",                MOD_USER,   sizeof(FILLRECT16))},
    {W32FUN(WU32InvertRect,                 "INVERTRECT",              MOD_USER,   sizeof(INVERTRECT16))},
    {W32FUN(WU32FrameRect,                  "FRAMERECT",               MOD_USER,   sizeof(FRAMERECT16))},
    {W32FUN(IT(DrawIcon),                   "DrawIcon",                MOD_USER,   sizeof(DRAWICON16))},
    {W32FUN(WU32DrawText,                   "DrawText",                MOD_USER,   sizeof(DRAWTEXT16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "ICONSIZE",                MOD_USER,   0)},
    {W32FUN(LOCALAPI,                       "DIALOGBOX",               MOD_USER,   sizeof(DIALOGBOX16))},
    {W32FUN(WU32EndDialog,                  "ENDDIALOG",               MOD_USER,   sizeof(ENDDIALOG16))},
    {W32FUN(LOCALAPI,                       "CREATEDIALOG",            MOD_USER,   sizeof(CREATEDIALOG16))},

  /*** 0090 ***/
    {W32FUN(WU32IsDialogMessage,            "ISDIALOGMESSAGE",         MOD_USER,   sizeof(ISDIALOGMESSAGE16))},
    {W32FUN(WU32GETDLGITEM,                 "GETDLGITEM",              MOD_USER,   sizeof(GETDLGITEM16))},
    {W32FUN(WU32SetDlgItemText,             "SETDLGITEMTEXT",          MOD_USER,   sizeof(SETDLGITEMTEXT16))},
    {W32FUN(WU32GetDlgItemText,             "GETDLGITEMTEXT",          MOD_USER,   sizeof(GETDLGITEMTEXT16))},
    {W32FUN(WU32SetDlgItemInt,              "SETDLGITEMINT",           MOD_USER,   sizeof(SETDLGITEMINT16))},
    {W32FUN(WU32GetDlgItemInt,              "GETDLGITEMINT",           MOD_USER,   sizeof(GETDLGITEMINT16))},
    {W32FUN(WU32CheckRadioButton,           "CHECKRADIOBUTTON",        MOD_USER,   sizeof(CHECKRADIOBUTTON16))},
    {W32FUN(WU32CheckDlgButton,             "CHECKDLGBUTTON",          MOD_USER,   sizeof(CHECKDLGBUTTON16))},
    {W32FUN(WU32IsDlgButtonChecked,         "ISDLGBUTTONCHECKED",      MOD_USER,   sizeof(ISDLGBUTTONCHECKED16))},
    {W32FUN(WU32DlgDirSelect,               "DLGDIRSELECT",            MOD_USER,   sizeof(DLGDIRSELECT16))},

  /*** 0100 ***/
    {W32FUN(WU32DlgDirList,                 "DLGDIRLIST",               MOD_USER,  sizeof(DLGDIRLIST16))},
    {W32FUN(WU32SendDlgItemMessage,         "SENDDLGITEMMESSAGE",       MOD_USER,  sizeof(SENDDLGITEMMESSAGE16))},
    {W32FUN(WU32AdjustWindowRect,           "ADJUSTWINDOWRECT",         MOD_USER,  sizeof(ADJUSTWINDOWRECT16))},
    {W32FUN(WU32MapDialogRect,              "MAPDIALOGRECT",            MOD_USER,  sizeof(MAPDIALOGRECT16))},
    {W32FUN(IT(MessageBeep),                "MessageBeep",              MOD_USER,  sizeof(MESSAGEBEEP16))},
    {W32FUN(IT(FlashWindow),                "FlashWindow",              MOD_USER,  sizeof(FLASHWINDOW16))},
    {W32FUN(WU32GetKeyState,                "GETKEYSTATE",              MOD_USER,  sizeof(GETKEYSTATE16))},
    {W32FUN(WU32DefWindowProc,              "DEFWINDOWPROC",            MOD_USER,  sizeof(DEFWINDOWPROC16))},
    {W32FUN(WU32GetMessage,                 "GETMESSAGE",               MOD_USER,  sizeof(GETMESSAGE16))},
    {W32FUN(WU32PeekMessage,                "PEEKMESSAGE",              MOD_USER,  sizeof(PEEKMESSAGE16))},

  /*** 0110 ***/
    {W32FUN(WU32PostMessage,                "POSTMESSAGE",              MOD_USER,  sizeof(POSTMESSAGE16))},
    {W32FUN(WU32SendMessage,                "SENDMESSAGE",              MOD_USER,  sizeof(SENDMESSAGE16))},
    {W32FUN(WU32WaitMessage,                "WAITMESSAGE",              MOD_USER,  0)},
    {W32FUN(WU32TranslateMessage,           "TRANSLATEMESSAGE",         MOD_USER,  sizeof(TRANSLATEMESSAGE16))},
    {W32FUN(WU32DispatchMessage,            "DISPATCHMESSAGE",          MOD_USER,  sizeof(DISPATCHMESSAGE16))},
    {W32FUN(WU32ReplyMessage,               "REPLYMESSAGE",             MOD_USER,  sizeof(REPLYMESSAGE16))},
    {W32FUN(WU32PostAppMessage,             "POSTAPPMESSAGE",           MOD_USER,  sizeof(POSTAPPMESSAGE16))},
    {W32FUN(IT(WindowFromDC),               "WindowFromDC",             MOD_USER,  sizeof(WINDOWFROMDC16))},
    {W32FUN(WU32RegisterWindowMessage,      "RegisterWindowMessage",    MOD_USER,  sizeof(REGISTERWINDOWMESSAGE16))},
    {W32FUN(WU32GetMessagePos,              "GETMESSAGEPOS",            MOD_USER,  0)},

  /*** 0120 ***/
    {W32FUN(WU32GetMessageTime,             "GETMESSAGETIME",           MOD_USER,  0)},
    {W32FUN(WU32SetWindowsHookInternal,     "SETWINDOWSHOOKINTERNAL",   MOD_USER,  sizeof(SETWINDOWSHOOKINTERNAL16))},
    {W32FUN(WU32CallWindowProc,             "CALLWINDOWPROC",           MOD_USER,  sizeof(CALLWINDOWPROC16))},
    {W32FUN(WU32CallMsgFilter,              "CALLMSGFILTER",            MOD_USER,  sizeof(CALLMSGFILTER16))},
    {W32FUN(WU32UpdateWindow,               "UPDATEWINDOW",             MOD_USER,  sizeof(UPDATEWINDOW16))},
    {W32FUN(WU32InvalidateRect,             "INVALIDATERECT",           MOD_USER,  sizeof(INVALIDATERECT16))},
    {W32FUN(WU32InvalidateRgn,              "INVALIDATERGN",            MOD_USER,  sizeof(INVALIDATERGN16))},
    {W32FUN(WU32ValidateRect,               "VALIDATERECT",             MOD_USER,  sizeof(VALIDATERECT16))},
    {W32FUN(WU32ValidateRgn,                "VALIDATERGN",              MOD_USER,  sizeof(VALIDATERGN16))},
    {W32FUN(WU32GetClassWord,               "GETCLASSWORD",             MOD_USER,  sizeof(GETCLASSWORD16))},

  /*** 0130 ***/
    {W32FUN(WU32SetClassWord,               "SETCLASSWORD",             MOD_USER,  sizeof(SETCLASSWORD16))},
    {W32FUN(WU32GetClassLong,               "GETCLASSLONG",             MOD_USER,  sizeof(GETCLASSLONG16))},
    {W32FUN(WU32SetClassLong,               "SETCLASSLONG",             MOD_USER,  sizeof(SETCLASSLONG16))},
    {W32FUN(WU32GetWindowWord,              "GETWINDOWWORD",            MOD_USER,  sizeof(GETWINDOWWORD16))},
    {W32FUN(WU32SetWindowWord,              "SETWINDOWWORD",            MOD_USER,  sizeof(SETWINDOWWORD16))},
    {W32FUN(WU32GetWindowLong,              "GETWINDOWLONG",            MOD_USER,  sizeof(GETWINDOWLONG16))},
    {W32FUN(WU32SetWindowLong,              "SETWINDOWLONG",            MOD_USER,  sizeof(SETWINDOWLONG16))},
    {W32FUN(WU32OpenClipboard,              "OPENCLIPBOARD",            MOD_USER,  sizeof(OPENCLIPBOARD16))},
    {W32FUN(WU32CloseClipboard,             "CLOSECLIPBOARD",           MOD_USER,  0)},
    {W32FUN(WU32EmptyClipboard,             "EMPTYCLIPBOARD",           MOD_USER,  0)},

  /*** 0140 ***/
    {W32FUN(WU32GetClipboardOwner,          "GETCLIPBOARDOWNER",        MOD_USER,  0)},
    {W32FUN(WU32SetClipboardData,           "SETCLIPBOARDDATA",         MOD_USER,  sizeof(SETCLIPBOARDDATA16))},
    {W32FUN(WU32GetClipboardData,           "GETCLIPBOARDDATA",         MOD_USER,  sizeof(GETCLIPBOARDDATA16))},
    {W32FUN(WU32CountClipboardFormats,      "COUNTCLIPBOARDFORMATS",    MOD_USER,  0)},
    {W32FUN(WU32EnumClipboardFormats,       "ENUMCLIPBOARDFORMATS",     MOD_USER,  sizeof(ENUMCLIPBOARDFORMATS16))},
    {W32FUN(WU32RegisterClipboardFormat,    "REGISTERCLIPBOARDFORMAT",  MOD_USER,  sizeof(REGISTERCLIPBOARDFORMAT16))},
    {W32FUN(WU32GetClipboardFormatName,     "GETCLIPBOARDFORMATNAME",   MOD_USER,  sizeof(GETCLIPBOARDFORMATNAME16))},
    {W32FUN(WU32SetClipboardViewer,         "SETCLIPBOARDVIEWER",       MOD_USER,  sizeof(SETCLIPBOARDVIEWER16))},
    {W32FUN(WU32GetClipboardViewer,         "GETCLIPBOARDVIEWER",       MOD_USER,  0)},
    {W32FUN(WU32ChangeClipboardChain,       "CHANGECLIPBOARDCHAIN",     MOD_USER,  sizeof(CHANGECLIPBOARDCHAIN16))},

  /*** 0150 ***/
    {W32FUN(WU32LoadMenu,                   "LOADMENU",                 MOD_USER,  sizeof(LOADMENU16))},
    {W32FUN(WU32CreateMenu,                 "CREATEMENU",               MOD_USER,  0)},
    {W32FUN(WU32DestroyMenu,                "DESTROYMENU",              MOD_USER,  sizeof(DESTROYMENU16))},
    {W32FUN(WU32ChangeMenu,                 "CHANGEMENU",               MOD_USER,  sizeof(CHANGEMENU16))},
    {W32FUN(WU32CheckMenuItem,              "CHECKMENUITEM",            MOD_USER,  sizeof(CHECKMENUITEM16))},
    {W32FUN(IT(EnableMenuItem),             "EnableMenuItem",           MOD_USER,  sizeof(ENABLEMENUITEM16))},
    {W32FUN(WU32GetSystemMenu,              "GETSYSTEMMENU",            MOD_USER,  sizeof(GETSYSTEMMENU16))},
    {W32FUN(WU32GETMENU,                    "GETMENU",                  MOD_USER,  sizeof(GETMENU16))},
    {W32FUN(WU32SetMenu,                    "SETMENU",                  MOD_USER,  sizeof(SETMENU16))},
    {W32FUN(WU32GETSUBMENU,                 "GetSubMenu",               MOD_USER,  sizeof(GETSUBMENU16))},

  /*** 0160 ***/
    {W32FUN(WU32DrawMenuBar,                "DRAWMENUBAR",              MOD_USER,  sizeof(DRAWMENUBAR16))},
    {W32FUN(WU32GetMenuString,              "GETMENUSTRING",            MOD_USER,  sizeof(GETMENUSTRING16))},
    {W32FUN(WU32HiliteMenuItem,             "HILITEMENUITEM",           MOD_USER,  sizeof(HILITEMENUITEM16))},
    {W32FUN(WU32CreateCaret,                "CREATECARET",              MOD_USER,  sizeof(CREATECARET16))},
    {W32FUN(WU32DestroyCaret,               "DESTROYCARET",             MOD_USER,  0)},
    {W32FUN(WU32SetCaretPos,                "SETCARETPOS",              MOD_USER,  sizeof(SETCARETPOS16))},
    {W32FUN(WU32HideCaret,                  "HIDECARET",                MOD_USER,  sizeof(HIDECARET16))},
    {W32FUN(WU32ShowCaret,                  "SHOWCARET",                MOD_USER,  sizeof(SHOWCARET16))},
    {W32FUN(WU32SetCaretBlinkTime,          "SETCARETBLINKTIME",        MOD_USER,  sizeof(SETCARETBLINKTIME16))},
    {W32FUN(WU32GetCaretBlinkTime,          "GETCARETBLINKTIME",        MOD_USER,  0)},

  /*** 0170 ***/
    {W32FUN(IT(ArrangeIconicWindows),       "ArrangeIconicWindows",     MOD_USER,  sizeof(ARRANGEICONICWINDOWS16))},
    {W32FUN(LOCALAPI,                       "WINHELP",                  MOD_USER,  sizeof(WINHELP16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "SWITCHTOTHISWINDOW",       MOD_USER,  0)},
    {W32FUN(WU32LoadCursor,                 "LOADCURSOR",               MOD_USER,  sizeof(LOADCURSOR16))},
    {W32FUN(WU32LoadCursor,                 "LOADICON",                 MOD_USER,  sizeof(LOADICON16))},
    {W32FUN(WU32LoadBitmap,                 "LOADBITMAP",               MOD_USER,  sizeof(LOADBITMAP16))},
    {W32FUN(LOCALAPI,                       "LOADSTRING",               MOD_USER,  sizeof(LOADSTRING16))},
    {W32FUN(LOCALAPI,                       "LOADACCELERATORS",         MOD_USER,  sizeof(LOADACCELERATORS16))},
    {W32FUN(WU32TranslateAccelerator,       "TRANSLATEACCELERATOR",     MOD_USER,  sizeof(TRANSLATEACCELERATOR16))},
    {W32FUN(WU32GETSYSTEMMETRICS,           "GETSYSTEMMETRICS",         MOD_USER,  sizeof(GETSYSTEMMETRICS16))},

  /*** 0180 ***/
    {W32FUN(WU32GETSYSCOLOR,                "GETSYSCOLOR",              MOD_USER,  sizeof(GETSYSCOLOR16))},
    {W32FUN(WU32SetSysColors,               "SETSYSCOLORS",             MOD_USER,  sizeof(SETSYSCOLORS16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "KILLSYSTEMTIMER",          MOD_USER,  0)},
    {W32FUN(WU32GetCaretPos,                "GETCARETPOS",              MOD_USER,  sizeof(GETCARETPOS16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "QUERYSENDMESSAGE",         MOD_USER,  sizeof(QUERYSENDMESSAGE16))},
    {W32FUN(WU32GrayString,                 "GRAYSTRING",               MOD_USER,  sizeof(GRAYSTRING16))},
    {W32FUN(IT(SwapMouseButton),            "SwapMouseButton",          MOD_USER,  sizeof(SWAPMOUSEBUTTON16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "ENDMENU",                  MOD_USER,  0)},
    {W32FUN(LOCALAPI,                       "SETSYSMODALWINDOW",        MOD_USER,  sizeof(SETSYSMODALWINDOW16))},
    {W32FUN(LOCALAPI,                       "GETSYSMODALWINDOW",        MOD_USER,  0)},

  /*** 0190 ***/
    {W32FUN(WU32GetUpdateRect,              "GETUPDATERECT",            MOD_USER, sizeof(GETUPDATERECT16))},
    {W32FUN(WU32ChildWindowFromPoint,       "ChildWindowFromPoint",     MOD_USER, sizeof(CHILDWINDOWFROMPOINT16))},
    {W32FUN(WU32InSendMessage,              "INSENDMESSAGE",            MOD_USER, 0)},
    {W32FUN(WU32IsClipboardFormatAvailable, "ISCLIPBOARDFORMATAVAILABLE",MOD_USER, sizeof(ISCLIPBOARDFORMATAVAILABLE16))},
    {W32FUN(WU32DlgDirSelectComboBox,       "DLGDIRSELECTCOMBOBOX",     MOD_USER, sizeof(DLGDIRSELECTCOMBOBOX16))},
    {W32FUN(WU32DlgDirListComboBox,         "DLGDIRLISTCOMBOBOX",       MOD_USER, sizeof(DLGDIRLISTCOMBOBOX16))},
    {W32FUN(WU32TabbedTextOut,              "TABBEDTEXTOUT",            MOD_USER, sizeof(TABBEDTEXTOUT16))},
    {W32FUN(WU32GetTabbedTextExtent,        "GETTABBEDTEXTEXTENT",      MOD_USER, sizeof(GETTABBEDTEXTEXTENT16))},
    {W32FUN(LOCALAPI,                       "CascadeChildWindows",      MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "TileChildWindows",         MOD_USER, 0)},

  /*** 0200 ***/
    {W32FUN(WU32OpenComm,                   "OPENCOMM",                 MOD_USER,  sizeof(OPENCOMM16))},
    {W32FUN(WU32SetCommState,               "SETCOMMSTATE",             MOD_USER,  sizeof(SETCOMMSTATE16))},
    {W32FUN(WU32GetCommState,               "GETCOMMSTATE",             MOD_USER,  sizeof(GETCOMMSTATE16))},
    {W32FUN(WU32GetCommError,               "GETCOMMERROR",             MOD_USER,  sizeof(GETCOMMERROR16))},
    {W32FUN(WU32ReadComm,                   "READCOMM",                 MOD_USER,  sizeof(READCOMM16))},
    {W32FUN(WU32WriteComm,                  "WRITECOMM",                MOD_USER,  sizeof(WRITECOMM16))},
    {W32FUN(WU32TransmitCommChar,           "TRANSMITCOMMCHAR",         MOD_USER,  sizeof(TRANSMITCOMMCHAR16))},
    {W32FUN(WU32CloseComm,                  "CLOSECOMM",                MOD_USER,  sizeof(CLOSECOMM16))},
    {W32FUN(WU32SetCommEventMask,           "SETCOMMEVENTMASK",         MOD_USER,  sizeof(SETCOMMEVENTMASK16))},
    {W32FUN(WU32GetCommEventMask,           "GETCOMMEVENTMASK",         MOD_USER,  sizeof(GETCOMMEVENTMASK16))},

  /*** 0210 ***/
    {W32FUN(WU32SetCommBreak,               "SETCOMMBREAK",             MOD_USER,  sizeof(SETCOMMBREAK16))},
    {W32FUN(WU32ClearCommBreak,             "CLEARCOMMBREAK",           MOD_USER,  sizeof(CLEARCOMMBREAK16))},
    {W32FUN(WU32UngetCommChar,              "UNGETCOMMCHAR",            MOD_USER,  sizeof(UNGETCOMMCHAR16))},
    {W32FUN(WU32BuildCommDCB,               "BUILDCOMMDCB",             MOD_USER,  sizeof(BUILDCOMMDCB16))},
    {W32FUN(WU32EscapeCommFunction,         "ESCAPECOMMFUNCTION",       MOD_USER,  sizeof(ESCAPECOMMFUNCTION16))},
    {W32FUN(WU32FlushComm,                  "FLUSHCOMM",                MOD_USER,  sizeof(FLUSHCOMM16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "USERSEEUSERDO",            MOD_USER,  0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "LOOKUPMENUHANDLE",         MOD_USER,  0)},
    {W32FUN(LOCALAPI,                       "DIALOGBOXINDIRECT",        MOD_USER,  sizeof(DIALOGBOXINDIRECT16))},
    {W32FUN(LOCALAPI,                       "CREATEDIALOGINDIRECT",     MOD_USER,  sizeof(CREATEDIALOGINDIRECT16))},

  /*** 0220 ***/
    {W32FUN(WU32LoadMenuIndirect,           "LOADMENUINDIRECT",         MOD_USER,  sizeof(LOADMENUINDIRECT16))},
    {W32FUN(WU32ScrollDC,                   "SCROLLDC",                 MOD_USER,  sizeof(SCROLLDC16))},
    {W32FUN(WU32GetKeyboardState,           "GETKEYBOARDSTATE",         MOD_USER,  sizeof(GETKEYBOARDSTATE16))},
    {W32FUN(WU32SetKeyboardState,           "SETKEYBOARDSTATE",         MOD_USER,  sizeof(SETKEYBOARDSTATE16))},
    {W32FUN(WU32GetWindowTask,              "GETWINDOWTASK",            MOD_USER,  sizeof(GETWINDOWTASK16))},
    {W32FUN(WU32EnumTaskWindows,            "ENUMTASKWINDOWS",          MOD_USER,  sizeof(ENUMTASKWINDOWS16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "LOCKINPUT",                MOD_USER,  sizeof(LOCKINPUT16))},
    {W32FUN(WU32GetNextDlgGroupItem,        "GETNEXTDLGGROUPITEM",      MOD_USER,  sizeof(GETNEXTDLGGROUPITEM16))},
    {W32FUN(WU32GetNextDlgTabItem,          "GETNEXTDLGTABITEM",        MOD_USER,  sizeof(GETNEXTDLGTABITEM16))},
    {W32FUN(WU32GETTOPWINDOW,               "GETTOPWINDOW",             MOD_USER,  sizeof(GETTOPWINDOW16))},

  /*** 0230 ***/
    {W32FUN(WU32GETNEXTWINDOW,              "GetNextWindow",            MOD_USER,  sizeof(GETNEXTWINDOW16))},
    {W32FUN(LOCALAPI,                       "GETSYSTEMDEBUGSTATE",      MOD_USER,  0)},
    {W32FUN(WU32SetWindowPos,               "SetWindowPos",             MOD_USER,  sizeof(SETWINDOWPOS16))},
    {W32FUN(IT(SetParent),                  "SetParent",                MOD_USER,  sizeof(SETPARENT16))},
    {W32FUN(WU32UnhookWindowsHook,          "UnhookWindowsHook",        MOD_USER,  sizeof(UNHOOKWINDOWSHOOK16))},
    {W32FUN(WU32DefHookProc,                "DefHookProc",              MOD_USER,  sizeof(DEFHOOKPROC16))},
    {W32FUN(IT(GetCapture),                 "GetCapture",               MOD_USER,  0)},
    {W32FUN(IT(GetUpdateRgn),               "GetUpdateRgn",             MOD_USER,  sizeof(GETUPDATERGN16))},
    {W32FUN(IT(ExcludeUpdateRgn),           "ExcludeUpdateRgn",         MOD_USER,  sizeof(EXCLUDEUPDATERGN16))},
    {W32FUN(WU32DialogBoxParam,             "DialogBoxParam",           MOD_USER,  sizeof(DIALOGBOXPARAM16))},

  /*** 0240 ***/
    {W32FUN(LOCALAPI,                       "DIALOGBOXINDIRECTPARAM",   MOD_USER,  sizeof(DIALOGBOXINDIRECTPARAM16))},
    {W32FUN(LOCALAPI,                       "CREATEDIALOGPARAM",        MOD_USER,  sizeof(CREATEDIALOGPARAM16))},
    {W32FUN(LOCALAPI,                       "CREATEDIALOGINDIRECTPARAM",MOD_USER,  sizeof(CREATEDIALOGINDIRECTPARAM16))},
    {W32FUN(WU32GetDialogBaseUnits,         "GETDIALOGBASEUNITS",       MOD_USER,  0)},
    {W32FUN(LOCALAPI,                       "EQUALRECT",                MOD_USER,  sizeof(EQUALRECT16))},
    {W32FUN(WU32EnableCommNotification,     "ENABLECOMMNOTIFICATION",   MOD_USER,  sizeof(ENABLECOMMNOTIFICATION16))},
    {W32FUN(WU32ExitWindowsExec,            "EXITWINDOWSEXEC",          MOD_USER,  0)},
    {W32FUN(IT(GetCursor),                  "GetCursor",                MOD_USER,  0)},
    {W32FUN(IT(GetOpenClipboardWindow),     "GetOpenClipboardWindow",   MOD_USER,  0)},
    {W32FUN(IT(GetAsyncKeyState),           "GetAsyncKeyState",         MOD_USER,  sizeof(GETASYNCKEYSTATE16))},

  /*** 0250 ***/
    {W32FUN(WU32GETMENUSTATE,               "GetMenuState",             MOD_USER,  sizeof(GETMENUSTATE16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "SENDDRIVERMESSAGE",        MOD_USER,  sizeof(SENDDRIVERMESSAGE16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "OPENDRIVER",               MOD_USER,  sizeof(OPENDRIVER16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "CLOSEDRIVER",              MOD_USER,  sizeof(CLOSEDRIVER16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "GETDRIVERMODULEHANDLE",    MOD_USER,  sizeof(GETDRIVERMODULEHANDLE16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "DEFDRIVERPROC",            MOD_USER,  sizeof(DEFDRIVERPROC16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "GETDRIVERINFO",            MOD_USER,  sizeof(GETDRIVERINFO16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "GETNEXTDRIVER",            MOD_USER,  sizeof(GETNEXTDRIVER16))},
    {W32FUN(WU32MapWindowPoints,            "MAPWINDOWPOINTS",          MOD_USER,  sizeof(MAPWINDOWPOINTS16))},
    {W32FUN(IT(BeginDeferWindowPos),        "BeginDeferWindowPos",      MOD_USER,  sizeof(BEGINDEFERWINDOWPOS16))},

  /*** 0260 ***/
    {W32FUN(WU32DeferWindowPos,             "DEFERWINDOWPOS",           MOD_USER,  sizeof(DEFERWINDOWPOS16))},
    {W32FUN(WU32EndDeferWindowPos,          "ENDDEFERWINDOWPOS",        MOD_USER,  sizeof(ENDDEFERWINDOWPOS16))},
    {W32FUN(WU32GETWINDOW,                  "GetWindow",                MOD_USER,  sizeof(GETWINDOW16))},
    {W32FUN(WU32GETMENUITEMCOUNT,           "GETMENUITEMCOUNT",         MOD_USER,  sizeof(GETMENUITEMCOUNT16))},
    {W32FUN(WU32GETMENUITEMID,              "GetMenuItemID",            MOD_USER,  sizeof(GETMENUITEMID16))},
    {W32FUN(IT(ShowOwnedPopups),            "ShowOwnedPopups",          MOD_USER,  sizeof(SHOWOWNEDPOPUPS16))},
    {W32FUN(LOCALAPI,                       "SetMessageQueue",          MOD_USER,  sizeof(SETMESSAGEQUEUE16))},
    {W32FUN(IT(ShowScrollBar),              "ShowScrollBar",            MOD_USER,  sizeof(SHOWSCROLLBAR16))},
    {W32FUN(WU32GlobalAddAtom,              "GLOBALADDATOM",            MOD_USER,  sizeof(GLOBALADDATOM16))},
    {W32FUN(WU32GlobalDeleteAtom,           "GLOBALDELETEATOM",         MOD_USER,  sizeof(GLOBALDELETEATOM16))},

  /*** 0270 ***/
    {W32FUN(IT(GlobalFindAtom),             "GlobalFindAtom",           MOD_USER,  sizeof(GLOBALFINDATOM16))},
    {W32FUN(WU32GlobalGetAtomName,          "GLOBALGETATOMNAME",        MOD_USER,  sizeof(GLOBALGETATOMNAME16))},
    {W32FUN(WU32ISZOOMED,                   "ISZOOMED",                 MOD_USER,  sizeof(ISZOOMED16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "CONTROLPANELINFO",         MOD_USER,  0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "GETNEXTQUEUEWINDOW",       MOD_USER,  0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "REPAINTSCREEN",            MOD_USER,  0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "LOCKMYTASK",               MOD_USER,  0)},
    {W32FUN(WU32GetDlgCtrlID,               "GETDLGCTRLID",             MOD_USER,  sizeof(GETDLGCTRLID16))},
    {W32FUN(WU32GETDESKTOPWINDOW,           "GETDESKTOPHWND",           MOD_USER,  0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "SETDESKPATTERN",           MOD_USER,  0)},

  /*** 0280 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "SETSYSTEMMENU",            MOD_USER,  0)},
    {W32FUN(IT(GetSysColorBrush),           "GetSysColorBrush",         MOD_USER,  sizeof(GETSYSCOLORBRUSH16))},
    {W32FUN(IT(SelectPalette),              "SelectPalette",            MOD_USER,  sizeof(SELECTPALETTE16))},
    {W32FUN(IT(RealizePalette),             "RealizePalette",           MOD_USER,  sizeof(REALIZEPALETTE16))},
    {W32FUN(WU32GetFreeSystemResources,     "GETFREESYSTEMRESOURCES",   MOD_USER,  sizeof(GETFREESYSTEMRESOURCES16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "SETDESKWALLPAPER",         MOD_USER,  0)},
    {W32FUN(WU32GETDESKTOPWINDOW,           "GETDESKTOPWINDOW",         MOD_USER,  0)},
    {W32FUN(IT(GetLastActivePopup),         "GetLastActivePopup",       MOD_USER,  sizeof(GETLASTACTIVEPOPUP16))},
    {W32FUN(IT(GetMessageExtraInfo),        "GetMessageExtraInfo",      MOD_USER,  0)},
    {W32FUN(LOCALAPI,                       "KEYBD_EVENT",              MOD_USER,  0)},

  /*** 0290 ***/
    {W32FUN(WU32RedrawWindow,               "REDRAWWINDOW",             MOD_USER,  sizeof(REDRAWWINDOW16))},
    {W32FUN(WU32SetWindowsHookEx,           "SETWINDOWSHOOKEX",         MOD_USER,  sizeof(SETWINDOWSHOOKEX16))},
    {W32FUN(WU32UnhookWindowsHookEx,        "UNHOOKWINDOWSHOOKEX",      MOD_USER,  sizeof(UNHOOKWINDOWSHOOKEX16))},
    {W32FUN(WU32CallNextHookEx,             "CALLNEXTHOOKEX",           MOD_USER,  sizeof(CALLNEXTHOOKEX16))},
    {W32FUN(IT(LockWindowUpdate),           "LockWindowUpdate",         MOD_USER,  0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_USER,  0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_USER,  0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_USER,  0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_USER,  0)},
    {W32FUN(LOCALAPI,                       "MOUSE_EVENT",              MOD_USER,  0)},

  /*** 0300 ***/
    {W32FUN(UNIMPLEMENTED95API,             "UnloadInstallableDrivers", MOD_USER,  sizeof(UNLOADINSTALLABLEDRIVERS16))},
    {W32FUN(LOCALAPI,                       "EDITWNDPROC",              MOD_USER,  sizeof(SENDMESSAGE16))},
    {W32FUN(LOCALAPI,                       "STATICWNDPROC",            MOD_USER,  sizeof(SENDMESSAGE16))},
    {W32FUN(LOCALAPI,                       "BUTTONWNDPROC",            MOD_USER,  sizeof(SENDMESSAGE16))},
    {W32FUN(LOCALAPI,                       "SBWNDPROC",                MOD_USER,  sizeof(SENDMESSAGE16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "DESKTOPWNDPROC",           MOD_USER,  0)},
    {W32FUN(LOCALAPI,                       "MENUWINDOWPROC",           MOD_USER,  sizeof(SENDMESSAGE16))},
    {W32FUN(LOCALAPI,                       "LBOXCTLWNDPROC",           MOD_USER,  sizeof(SENDMESSAGE16))},
    {W32FUN(WU32DefDlgProc,                 "DEFDLGPROC",               MOD_USER,  sizeof(DEFDLGPROC16))},
    {W32FUN(WU32GetClipCursor,              "GETCLIPCURSOR",            MOD_USER,  sizeof(GETCLIPCURSOR16))},

  /*** 0310 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "CONTSCROLL",               MOD_USER,  0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "CARETBLINKPROC",           MOD_USER,  0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "SENDMESSAGE2",             MOD_USER,  0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "POSTMESSAGE2",             MOD_USER,  0)},
    {W32FUN(WU32SignalProc,                 "SIGNALPROC",               MOD_USER,  sizeof(SIGNALPROC16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "XCSTODS",                  MOD_USER,  0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "COMPUPDATERECT",           MOD_USER,  0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "COMPUPDATERGN",            MOD_USER,  0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "GETWC2",                   MOD_USER,  0)},
    {W32FUN(WU32ScrollWindowEx,             "SCROLLWINDOWEX",           MOD_USER,  sizeof(SCROLLWINDOWEX16))},

  /*** 0320 ***/
    {W32FUN(WU32SysErrorBox,                "SYSERRORBOX",              MOD_USER,  sizeof(SYSERRORBOX16))},
    {W32FUN(WU32SetEventHook,               "SETEVENTHOOK",             MOD_USER,  sizeof(SETEVENTHOOK16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "WINOLDAPPHACKOMATIC",      MOD_USER,  0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "GETMESSAGE2",              MOD_USER,  0)},
    {W32FUN(WU32FillWindow,                 "FillWindow",               MOD_USER,  sizeof(FILLWINDOW16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "PAINTRECT",                MOD_USER,  0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "GETCONTROLBRUSH",          MOD_USER,  0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "KILLTIMER2",               MOD_USER,  0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "SETTIMER2",                MOD_USER,  0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "MENUITEMSTATE",            MOD_USER,  0)},

  /*** 0330 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "SETGETKBDSTATE",            MOD_USER, 0)},
    {W32FUN(NOPAPI,                         "EnableHardwareInput",       MOD_USER, sizeof(ENABLEHARDWAREINPUT16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "USERYIELD",                 MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "ISUSERIDLE",                MOD_USER, 0)},
    {W32FUN(IT(GetQueueStatus),             "GetQueueStatus",            MOD_USER, sizeof(GETQUEUESTATUS16))},
    {W32FUN(IT(GetInputState),              "GetInputState",             MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "LOADCURSORICONHANDLER",     MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "GETMOUSEEVENTPROC",         MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},

  /*** 0340 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "WINFARFRAME",               MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "_FFFE_FARFRAME",            MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "GETFILEPORTNAME",           MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "COMBOBOXCTLWNDPROC",        MOD_USER, sizeof(SENDMESSAGE16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "TITLEWNDPROC",              MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "FILEPORTDLGPROC",           MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "SWITCHWNDPROC",             MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},

  /*** 0350 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "TABTHETEXTOUTFORWIMPS",     MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "BROADCASTMESSAGE",          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "LOADDIBCURSORHANDLER",      MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "LOADDIBICONHANDLER",        MOD_USER, 0)},
    {W32FUN(IT(IsMenu),                     "IsMenu",                    MOD_USER, sizeof(ISMENU16))},
    {W32FUN(WU32GetDCEx,                    "GETDCEX",                   MOD_USER, sizeof(GETDCEX16))},

  /*** 0360 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(IT(LookupIconIdFromDirectoryEx),"LookupIconIdFromDirectoryEx",MOD_USER,sizeof(LOOKUPICONIDFROMDIRECTORYEX16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "COPYICON",                  MOD_USER,  sizeof(COPYICON16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "COPYCURSOR",                MOD_USER,  sizeof(COPYCURSOR16))},

  /*** 0370 ***/
    {W32FUN(WU32GetWindowPlacement,         "GETWINDOWPLACEMENT",        MOD_USER, sizeof(GETWINDOWPLACEMENT16))},
    {W32FUN(WU32SetWindowPlacement,         "SETWINDOWPLACEMENT",        MOD_USER, sizeof(SETWINDOWPLACEMENT16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "SUBTRACTRECT",              MOD_USER, sizeof(SUBTRACTRECT16))},
    {W32FUN(UNIMPLEMENTED95API,             "DllEntryPoint",             MOD_USER, sizeof(DLLENTRYPOINT16))},
    {W32FUN(WU32DrawTextEx,                 "DrawTextEx",                MOD_USER, sizeof(DRAWTEXTEX16))},
    {W32FUN(IT(SetMessageExtraInfo),        "SetMessageExtraInfo",       MOD_USER, sizeof(SETMESSAGEEXTRAINFO16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(IT(SetPropEx),                  "SetPropEx",                 MOD_USER, sizeof(SETPROPEX16))},
    {W32FUN(IT(GetPropEx),                  "GetPropEx",                 MOD_USER, sizeof(GETPROPEX16))},

  /*** 0380 ***/
    {W32FUN(IT(RemovePropEx),               "RemovePropEx",              MOD_USER, sizeof(REMOVEPROPEX16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(IT(SetWindowContextHelpId),     "SetWindowContextHelpId",    MOD_USER, sizeof(SETWINDOWCONTEXTHELPID16))},
    {W32FUN(IT(GetWindowContextHelpId),     "GetWindowContextHelpId",    MOD_USER, sizeof(GETWINDOWCONTEXTHELPID16))},
    {W32FUN(IT(SetMenuContextHelpId),       "SetMenuContextHelpId",      MOD_USER, sizeof(SETMENUCONTEXTHELPID16))},
    {W32FUN(IT(GetMenuContextHelpId),       "GetMenuContextHelpId",      MOD_USER, sizeof(GETMENUCONTEXTHELPID16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(IT(LoadImage),                  "LoadImage",                 MOD_USER, sizeof(LOADIMAGE16))},

  /*** 0390 ***/
    {W32FUN(WU32CopyImage,                  "CopyImage",                 MOD_USER, sizeof(COPYIMAGE16))},
    {W32FUN(UNIMPLEMENTED95API,             "SignalProc32",              MOD_USER, sizeof(SIGNALPROC3216))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(IT(DrawIconEx),                 "DrawIconEx",                MOD_USER, sizeof(DRAWICONEX16))},
    {W32FUN(WU32GetIconInfo,                "GetIconInfo",               MOD_USER, sizeof(GETICONINFO16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTED95API,             "RegisterClassEx",           MOD_USER, sizeof(REGISTERCLASSEX16))},
    {W32FUN(UNIMPLEMENTED95API,             "GetClassInfoEx",            MOD_USER, sizeof(GETCLASSINFOEX16))},
    {W32FUN(WU32ChildWindowFromPointEx,     "ChildWindowFromPointEx",    MOD_USER, sizeof(CHILDWINDOWFROMPOINTEX16))},

  /*** 0400 ***/
    {W32FUN(NOPAPI,                         "FinalUserInit",             MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(WU32GetPriorityClipboardFormat, "GETPRIORITYCLIPBOARDFORMAT",MOD_USER, sizeof(GETPRIORITYCLIPBOARDFORMAT16))},
    {W32FUN(IT(UnregisterClass),            "UnregisterClass",           MOD_USER, sizeof(UNREGISTERCLASS16))},
    {W32FUN(WU32GetClassInfo,               "GETCLASSINFO",              MOD_USER, sizeof(GETCLASSINFO16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(WU32CreateCursor,               "CREATECURSOR",              MOD_USER, sizeof(CREATECURSOR16))},
    {W32FUN(WU32CreateIcon,                 "CREATEICON",                MOD_USER, sizeof(CREATEICON16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "CREATECURSORICONINDIRECT",  MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTED95API,             "InitThreadInput",           MOD_USER, sizeof(INITTHREADINPUT16))},

  /*** 0410 ***/
    {W32FUN(WU32InsertMenu,                 "INSERTMENU",                MOD_USER, sizeof(INSERTMENU16))},
    {W32FUN(WU32AppendMenu,                 "APPENDMENU",                MOD_USER, sizeof(APPENDMENU16))},
    {W32FUN(WU32RemoveMenu,                 "REMOVEMENU",                MOD_USER, sizeof(REMOVEMENU16))},
    {W32FUN(WU32DeleteMenu,                 "DELETEMENU",                MOD_USER, sizeof(DELETEMENU16))},
    {W32FUN(WU32ModifyMenu,                 "MODIFYMENU",                MOD_USER, sizeof(MODIFYMENU16))},
    {W32FUN(WU32CreatePopupMenu,            "CREATEPOPUPMENU",           MOD_USER, 0)},
    {W32FUN(WU32TrackPopupMenu,             "TRACKPOPUPMENU",            MOD_USER, sizeof(TRACKPOPUPMENU16))},
    {W32FUN(WU32GetMenuCheckMarkDimensions, "GETMENUCHECKMARKDIMENSIONS",MOD_USER, 0)},
    {W32FUN(WU32SetMenuItemBitmaps,         "SETMENUITEMBITMAPS",        MOD_USER, sizeof(SETMENUITEMBITMAPS16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},

  /*** 0420 ***/
    {W32FUN(LOCALAPI,                       "_WSPRINTF",                 MOD_USER, sizeof(WSPRINTF16))},
    {W32FUN(LOCALAPI,                       "WVSPRINTF",                 MOD_USER, sizeof(WVSPRINTF16))},
    {W32FUN(WU32DlgDirSelectEx,             "DLGDIRSELECTEX",            MOD_USER, sizeof(DLGDIRSELECTEX16))},
    {W32FUN(WU32DlgDirSelectComboBoxEx,     "DLGDIRSELECTCOMBOBOXEX",    MOD_USER, sizeof(DLGDIRSELECTCOMBOBOXEX16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(IT(FindWindowEx),               "FindWindowEx",              MOD_USER, sizeof(FINDWINDOWEX16))},
    {W32FUN(WU32TileWindows,                "TileWindows",               MOD_USER, sizeof(TILEWINDOWS16))},
    {W32FUN(WU32CascadeWindows,             "CascadeWindows",            MOD_USER, sizeof(CASCADEWINDOWS16))},

  /*** 0430 ***/
    {W32FUN(WU32lstrcmp,                    "LSTRCMP",                   MOD_USER, 0)},
    {W32FUN(WU32AnsiUpper,                  "ANSIUPPER",                 MOD_USER, sizeof(ANSIUPPER16))},
    {W32FUN(WU32AnsiLower,                  "ANSILOWER",                 MOD_USER, sizeof(ANSILOWER16))},
    {W32FUN(WU32IsCharAlpha,                "ISCHARALPHA",               MOD_USER, sizeof(ISCHARALPHA16))},
    {W32FUN(WU32IsCharAlphaNumeric,         "ISCHARALPHANUMERIC",        MOD_USER, sizeof(ISCHARALPHANUMERIC16))},
    {W32FUN(WU32IsCharUpper,                "ISCHARUPPER",               MOD_USER, sizeof(ISCHARUPPER16))},
    {W32FUN(WU32IsCharLower,                "ISCHARLOWER",               MOD_USER, sizeof(ISCHARLOWER16))},
    {W32FUN(WU32AnsiUpperBuff,              "ANSIUPPERBUFF",             MOD_USER, sizeof(ANSIUPPERBUFF16))},
    {W32FUN(WU32AnsiLowerBuff,              "ANSILOWERBUFF",             MOD_USER, sizeof(ANSILOWERBUFF16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},

  /*** 0440 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(WU32InsertMenuItem,             "InsertMenuItem",            MOD_USER, sizeof(INSERTMENUITEM16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(WU32GetMenuItemInfo,            "GetMenuItemInfo",           MOD_USER, sizeof(GETMENUITEMINFO16))},
    {W32FUN(LOCALAPI,                       "MDIClientWndProc",          MOD_USER, sizeof(SENDMESSAGE16))},
    {W32FUN(WU32DefFrameProc,               "DefFrameProc",              MOD_USER, sizeof(DEFFRAMEPROC16))},
    {W32FUN(WU32SetMenuItemInfo,            "SetMenuItemInfo",           MOD_USER, sizeof(SETMENUITEMINFO16))},
    {W32FUN(WU32DefMDIChildProc,            "DefMDIChildProc",           MOD_USER, sizeof(DEFMDICHILDPROC16))},
    {W32FUN(WU32DrawAnimatedRects,          "DrawAnimatedRects",         MOD_USER, sizeof(DRAWANIMATEDRECTS16))},
    {W32FUN(WU32DrawState,                  "DrawState",                 MOD_USER, sizeof(DRAWSTATE16))},

  /*** 0450 ***/
    {W32FUN(IT(CreateIconFromResourceEx),   "CreateIconFromResourceEx",  MOD_USER, sizeof(CREATEICONFROMRESOURCEEX16))},
    {W32FUN(WU32TranslateMDISysAccel,       "TRANSLATEMDISYSACCEL",      MOD_USER, sizeof(TRANSLATEMDISYSACCEL16))},
    {W32FUN(WU32CreateWindowEx,             "CREATEWINDOWEX",            MOD_USER, sizeof(CREATEWINDOWEX16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "LBOXCARETBLINKER",          MOD_USER, 0)},
    {W32FUN(WU32AdjustWindowRectEx,         "ADJUSTWINDOWRECTEX",        MOD_USER, sizeof(ADJUSTWINDOWRECTEX16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "GETICONID",                 MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "LOADICONHANDLER",           MOD_USER, 0)},
    {W32FUN(WU32DestroyIcon,                "DESTROYICON",               MOD_USER, sizeof(DESTROYICON16))},
    {W32FUN(WU32DestroyCursor,              "DESTROYCURSOR",             MOD_USER, sizeof(DESTROYCURSOR16))},
    {W32FUN(LOCALAPI,                       "DUMPICON",                  MOD_USER, 0)},

  /*** 0460 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "GETINTERNALWINDOWPOS",      MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "SETINTERNALWINDOWPOS",      MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "CALCCHILDSCROLL",           MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "SCROLLCHILDREN",            MOD_USER, 0)},
    {W32FUN(IT(DragObject),                 "DragObject",                MOD_USER, sizeof(DRAGOBJECT16))},
    {W32FUN(WU32DragDetect,                 "DragDetect",                MOD_USER, sizeof(DRAGDETECT16))},
    {W32FUN(WU32DrawFocusRect,              "DrawFocusRect",             MOD_USER, sizeof(DRAWFOCUSRECT16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},

  /*** 0470 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "STRINGFUNC",                MOD_USER, 0)},
    {W32FUN(WU32lstrcmpi,                   "LSTRCMPI",                  MOD_USER, 0)},
    {W32FUN(WU32AnsiNext,                   "ANSINEXT",                  MOD_USER, sizeof(ANSINEXT16))},
    {W32FUN(WU32AnsiPrev,                   "ANSIPREV",                  MOD_USER, sizeof(ANSIPREV16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(IT(SetScrollInfo),              "SetScrollInfo",             MOD_USER, sizeof(SETSCROLLINFO16))},
    {W32FUN(IT(GetScrollInfo),              "GetScrollInfo",             MOD_USER, sizeof(GETSCROLLINFO16))},
    {W32FUN(IT(GetKeyboardLayoutName),      "GetKeyboardLayoutName",     MOD_USER, sizeof(GETKEYBOARDLAYOUTNAME16))},
    {W32FUN(IT(LoadKeyboardLayout),         "LoadKeyboardLayout",        MOD_USER, sizeof(LOADKEYBOARDLAYOUT16))},
    {W32FUN(WU32MenuItemFromPoint,          "MenuItemFromPoint",         MOD_USER, sizeof(MENUITEMFROMPOINT16))},

  /*** 0480 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(IT(EnableScrollBar),            "EnableSrollBar",            MOD_USER, sizeof(ENABLESCROLLBAR16))},
    {W32FUN(WU32SystemParametersInfo,       "SystemParametersInfo",      MOD_USER, sizeof(SYSTEMPARAMETERSINFO16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},

  /*** 0490 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(WU32GetAppVer,                  "GetAppVer",                 MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},

  /*** 0500 ***/
    {W32FUN(LOCALAPI,                       "FARCALLNETDRIVER",          MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETOPENJOB",               MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETCLOSEJOB",              MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                          MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETHOLDJOB",               MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETRELEASEJOB",            MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETCANCELJOB",             MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETSETJOBCOPIES",          MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETWATCHQUEUE",            MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETUNWATCHQUEUE",          MOD_USER, 0)},

  /*** 0510 ***/
    {W32FUN(LOCALAPI,                       "WNETLOCKQUEUEDATA",         MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETUNLOCKQUEUEDATA",       MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETGETCONNECTION",         MOD_USER, sizeof(WNETGETCONNECTION16))},
    {W32FUN(LOCALAPI,                       "WNETGETCAPS",               MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETDEVICEMODE",            MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETBROWSEDIALOG",          MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETGETUSER",               MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETADDCONNECTION",         MOD_USER, sizeof(WNETADDCONNECTION16))},
    {W32FUN(LOCALAPI,                       "WNETCANCELCONNECTION",      MOD_USER, sizeof(WNETCANCELCONNECTION16))},
    {W32FUN(LOCALAPI,                       "WNETGETERROR",              MOD_USER, 0)},

  /*** 0520 ***/
    {W32FUN(LOCALAPI,                       "WNETGETERRORTEXT",          MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETENABLE",                MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETDISABLE",               MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETRESTORECONNECTION",     MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETWRITEJOB",              MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETCONNECTDIALOG",         MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETDISCONNECTDIALOG",      MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETCONNECTIONDIALOG",      MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETVIEWQUEUEDIALOG",       MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETPROPERTYDIALOG",        MOD_USER, 0)},

  /*** 0530 ***/
    {W32FUN(LOCALAPI,                       "WNETGETDIRECTORYTYPE",      MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETDIRECTORYNOTIFY",       MOD_USER, 0)},
    {W32FUN(LOCALAPI,                       "WNETGETPROPERTYTEXT",       MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTED95API,             "WNetInitialize",            MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTED95API,             "WNetLogon",                 MOD_USER, sizeof(WNETLOGON16))},
    {W32FUN(WU32NotifyWow,                  "NOTIFYWOW",                 MOD_USER, sizeof(NOTIFYWOW16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "--Available--",             MOD_USER, 0)},
    {W32FUN(WU32WOWWordBreakProc,           "WOWWordBreakProc",          MOD_USER, sizeof(WOWWORDBREAKPROC16))},
    {W32FUN(WU32MouseEvent,                 "MOUSEEVENT",                MOD_USER, sizeof(MOUSEEVENT16))},
    {W32FUN(WU32KeybdEvent,                 "KEYBDEVENT",                MOD_USER, sizeof(KEYBDEVENT16))},

  /*** 0540 ***/
    {W32FUN(IT(GetShellWindow),             "GetShellWindow",            MOD_USER, 0)},
    {W32FUN(NOPAPI,                         "DoHotKeyStuff",             MOD_USER, sizeof(DOHOTKEYSTUFF16))},
    {W32FUN(NOPAPI,                         "SetCheckCursorTimer",       MOD_USER, sizeof(SETCHECKCURSORTIMER16))},
    {W32FUN(IT(SetMenuDefaultItem),         "SetMenuDefaultItem",        MOD_USER, sizeof(SETMENUDEFAULTITEM16))},
    {W32FUN(UNIMPLEMENTED95API,             "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                          MOD_USER, 0)},

  /*** 0550 ***/
    {W32FUN(UNIMPLEMENTED95API,             "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                          MOD_USER, 0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                          MOD_USER, 0)},
    {W32FUN(IT(DestroyIcon32),              "DestroyIcon32",             MOD_USER, sizeof(DESTROYICON3216))},
    {W32FUN(UNIMPLEMENTED95API,             "BroadcastSystemMessage",    MOD_USER, sizeof(BROADCASTSYSTEMMESSAGE16))},
    {W32FUN(UNIMPLEMENTED95API,             "HackTaskMonitor",           MOD_USER, sizeof(HACKTASKMONITOR16))},
    {W32FUN(UNIMPLEMENTED95API,             "FormatMessage",             MOD_USER, sizeof(FORMATMESSAGE16))},
    {W32FUN(IT(ChangeDisplaySettings),      "ChangeDisplaySettings",     MOD_USER, sizeof(CHANGEDISPLAYSETTINGS16))},
    {W32FUN(IT(GetForegroundWindow),        "GetForegroundWindow",       MOD_USER, 0)},
    {W32FUN(IT(SetForegroundWindow),        "SetForegroundWindow",       MOD_USER, sizeof(SETFOREGROUNDWINDOW16))},

  /*** 0560 ***/
    {W32FUN(IT(EnumDisplaySettings),        "EnumDisplaySettings",       MOD_USER, sizeof(ENUMDISPLAYSETTINGS16))},
    {W32FUN(IT(MsgWaitForMultipleObjects),  "MsgWaitForMultipleObjects", MOD_USER, sizeof(MSGWAITFORMULTIPLEOBJECTS16))},
    {W32FUN(IT(ActivateKeyboardLayout),     "ActivateKeyboardLayout",    MOD_USER, sizeof(ACTIVATEKEYBOARDLAYOUT16))},
    {W32FUN(IT(GetKeyboardLayout),          "GetKeyboardLayout",         MOD_USER, sizeof(GETKEYBOARDLAYOUT16))},
    {W32FUN(IT(GetKeyboardLayoutList),      "GetKeyboardLayoutList",     MOD_USER, sizeof(GETKEYBOARDLAYOUTLIST16))},
    {W32FUN(IT(UnloadKeyboardLayout),       "UnloadKeyboardLayout",      MOD_USER, sizeof(UNLOADKEYBOARDLAYOUT16))},
    {W32FUN(UNIMPLEMENTED95API,             "PostPostedMessages",        MOD_USER, 0)},
    {W32FUN(WU32DrawFrameControl,           "DrawFrameControl",          MOD_USER, sizeof(DRAWFRAMECONTROL16))},
    {W32FUN(UNIMPLEMENTED95API,             "DrawCaptionTemp",           MOD_USER, sizeof(DRAWCAPTIONTEMP16))},
    {W32FUN(NOPAPI,                         "DispatchInput",             MOD_USER, 0)},

  /*** 0570 ***/
    {W32FUN(WU32DrawEdge,                   "DrawEdge",                  MOD_USER, sizeof(DRAWEDGE16))},
    {W32FUN(WU32DrawCaption,                "DrawCaption",               MOD_USER, sizeof(DRAWCAPTION16))},
    {W32FUN(UNIMPLEMENTED95API,             "SetSysColorsTemp",          MOD_USER, sizeof(SETSYSCOLORSTEMP16))},
    {W32FUN(UNIMPLEMENTED95API,             "DrawMenuBarTemp",           MOD_USER, sizeof(DRAWMENUBARTEMP16))},
    {W32FUN(IT(GetMenuDefaultItem),         "GetMenuDefaultItem",        MOD_USER, sizeof(GETMENUDEFAULTITEM16))},
    {W32FUN(WU32GetMenuItemRect,            "GetMenuItemRect",           MOD_USER, sizeof(GETMENUITEMRECT16))},
    {W32FUN(IT(CheckMenuRadioItem),         "CheckMenuRadioItem",        MOD_USER, sizeof(CHECKMENURADIOITEM16))},
    {W32FUN(WU32TrackPopupMenuEx,           "TrackPopupMenuEx",          MOD_USER, sizeof(TRACKPOPUPMENUEX16))},
    {W32FUN(IT(SetWindowRgn),               "SetWindowRgn",              MOD_USER, sizeof(SETWINDOWRGN16))},
    {W32FUN(IT(GetWindowRgn),               "GetWindowRgn",              MOD_USER, sizeof(GETWINDOWRGN16))},

  /*** 0580 ***/
    {W32FUN(UNIMPLEMENTED95API,             "ChooseFont_Callback16",     MOD_USER, sizeof(CHOOSEFONT_CALLBACK1616))},
    {W32FUN(UNIMPLEMENTED95API,             "FindReplace_Callback16",    MOD_USER, sizeof(FINDREPLACE_CALLBACK1616))},
    {W32FUN(UNIMPLEMENTED95API,             "OpenFilename_Callback16",   MOD_USER, sizeof(OPENFILENAME_CALLBACK1616))},
    {W32FUN(UNIMPLEMENTED95API,             "PrintDlg_Callback16",       MOD_USER, sizeof(PRINTDLG_CALLBACK1616))},
    {W32FUN(UNIMPLEMENTED95API,             "ChooseColor_Callback16",    MOD_USER, sizeof(CHOOSECOLOR_CALLBACK1616))},
    {W32FUN(UNIMPLEMENTED95API,             "PeekMessage32",             MOD_USER, sizeof(PEEKMESSAGE3216))},
    {W32FUN(UNIMPLEMENTED95API,             "GetMessage32",              MOD_USER, sizeof(GETMESSAGE3216))},
    {W32FUN(UNIMPLEMENTED95API,             "TranslateMessage32",        MOD_USER, sizeof(TRANSLATEMESSAGE3216))},
    {W32FUN(IT(DispatchMessage32),          "DispatchMessage32",         MOD_USER, sizeof(DISPATCHMESSAGE3216))},
    {W32FUN(UNIMPLEMENTED95API,             "CallMsgFilter32",           MOD_USER, sizeof(CALLMSGFILTER3216))},

  /*** 0590 ***/
    {W32FUN(UNIMPLEMENTED95API,             "IsDialogMessage32",         MOD_USER, sizeof(ISDIALOGMESSAGE3216))},
    {W32FUN(UNIMPLEMENTED95API,             "PostMessage32",             MOD_USER, sizeof(POSTMESSAGE3216))},
    {W32FUN(UNIMPLEMENTED95API,             "PostThreadMessage32",       MOD_USER, sizeof(POSTTHREADMESSAGE3216))},
    {W32FUN(WU32MessageBoxIndirect,         "MessageBoxIndirect",        MOD_USER, sizeof(MESSAGEBOXINDIRECT16))},
    {W32FUN(UNIMPLEMENTED95API,             "InstallIMT",                MOD_USER, sizeof(INSTALLIMT16))},
    {W32FUN(UNIMPLEMENTED95API,             "UninstallIMT",              MOD_USER, sizeof(UNINSTALLIMT16))},
