/*++
 *
 *  WOW v1.0
 *
 *  Copyright (c) 1991, Microsoft Corporation
 *
 *  WGTBL2.h
 *  WOW32 16-bit GDI API tables
 *
 *  History:
 *  Created 27-Jan-1991 by Jeff Parsons (jeffpar)
--*/

    {W32FUN(UNIMPLEMENTEDAPI,               "DUMMYENTRY",               MOD_GDI,   0)},
    {W32FUN(IT(SetBkColor),                 "SetBkColor",               MOD_GDI,   sizeof(SETBKCOLOR16))},
    {W32FUN(IT(SetBkMode),                  "SetBkMode",                MOD_GDI,   sizeof(SETBKMODE16))},
    {W32FUN(IT(SetMapMode),                 "SetMapMode",               MOD_GDI,   sizeof(SETMAPMODE16))},
    {W32FUN(IT(SetROP2),                    "SetROP2",                  MOD_GDI,   sizeof(SETROP216))},
    {W32FUN(IT(SetRelAbs),                  "SetRelAbs",                MOD_GDI,   sizeof(SETRELABS16))},
    {W32FUN(IT(SetPolyFillMode),            "SetPolyFillMode",          MOD_GDI,   sizeof(SETPOLYFILLMODE16))},
    {W32FUN(IT(SetStretchBltMode),          "SetStretchBltMode",        MOD_GDI,   sizeof(SETSTRETCHBLTMODE16))},
    {W32FUN(IT(SetTextCharacterExtra),      "SetTextCharacterExtra",    MOD_GDI,   sizeof(SETTEXTCHARACTEREXTRA16))},
    {W32FUN(IT(SetTextColor),               "SetTextColor",             MOD_GDI,   sizeof(SETTEXTCOLOR16))},

  /*** 0010 ***/
    {W32FUN(IT(SetTextJustification),       "SetTextJustification",     MOD_GDI,   sizeof(SETTEXTJUSTIFICATION16))},
    {W32FUN(WG32SetWindowOrg,               "SETWINDOWORG",             MOD_GDI,   sizeof(SETWINDOWORG16))},
    {W32FUN(WG32SetWindowExt,               "SETWINDOWEXT",             MOD_GDI,   sizeof(SETWINDOWEXT16))},
    {W32FUN(WG32SetViewportOrg,             "SETVIEWPORTORG",           MOD_GDI,   sizeof(SETVIEWPORTORG16))},
    {W32FUN(WG32SetViewportExt,             "SETVIEWPORTEXT",           MOD_GDI,   sizeof(SETVIEWPORTEXT16))},
    {W32FUN(WG32OffsetWindowOrg,            "OFFSETWINDOWORG",          MOD_GDI,   sizeof(OFFSETWINDOWORG16))},
    {W32FUN(WG32ScaleWindowExt,             "SCALEWINDOWEXT",           MOD_GDI,   sizeof(SCALEWINDOWEXT16))},
    {W32FUN(WG32OffsetViewportOrg,          "OFFSETVIEWPORTORG",        MOD_GDI,   sizeof(OFFSETVIEWPORTORG16))},
    {W32FUN(WG32ScaleViewportExt,           "SCALEVIEWPORTEXT",         MOD_GDI,   sizeof(SCALEVIEWPORTEXT16))},
    {W32FUN(IT(LineTo),                     "LineTo",                   MOD_GDI,   sizeof(LINETO16))},

  /*** 0020 ***/
    {W32FUN(WG32MoveTo,                     "MoveTo",                   MOD_GDI,   sizeof(MOVETO16))},
    {W32FUN(IT(ExcludeClipRect),            "ExcludeClipRect",          MOD_GDI,   sizeof(EXCLUDECLIPRECT16))},
    {W32FUN(IT(IntersectClipRect),          "IntersectClipRect",        MOD_GDI,   sizeof(INTERSECTCLIPRECT16))},
    {W32FUN(IT(Arc),                        "Arc",                      MOD_GDI,   sizeof(ARC16))},
    {W32FUN(IT(Ellipse),                    "Ellipse",                  MOD_GDI,   sizeof(ELLIPSE16))},
    {W32FUN(IT(FloodFill),                  "FloodFill",                MOD_GDI,   sizeof(FLOODFILL16))},
    {W32FUN(IT(Pie),                        "Pie",                      MOD_GDI,   sizeof(PIE16))},
    {W32FUN(IT(Rectangle),                  "Rectangle",                MOD_GDI,   sizeof(RECTANGLE16))},
    {W32FUN(IT(RoundRect),                  "RoundRect",                MOD_GDI,   sizeof(ROUNDRECT16))},
    {W32FUN(IT(PatBlt),                     "PatBlt",                   MOD_GDI,   sizeof(PATBLT16))},

  /*** 0030 ***/
    {W32FUN(IT(SaveDC),                     "SaveDC",                   MOD_GDI,   sizeof(SAVEDC16))},
    {W32FUN(IT(SetPixel),                   "SetPixel",                 MOD_GDI,   sizeof(SETPIXEL16))},
    {W32FUN(IT(OffsetClipRgn),              "OffsetClipRgn",            MOD_GDI,   sizeof(OFFSETCLIPRGN16))},
    {W32FUN(IT(TextOut),                    "TextOut",                  MOD_GDI,   sizeof(TEXTOUT16))},
    {W32FUN(IT(BitBlt),                     "BitBlt",                   MOD_GDI,   sizeof(BITBLT16))},
    {W32FUN(IT(StretchBlt),                 "StretchBlt",               MOD_GDI,   sizeof(STRETCHBLT16))},
    {W32FUN(WG32Polygon,                    "Polygon",                  MOD_GDI,   sizeof(POLYGON16))},
    {W32FUN(WG32Polyline,                   "Polyline",                 MOD_GDI,   sizeof(POLYLINE16))},
    {W32FUN(WG32Escape,                     "Escape",                   MOD_GDI,   sizeof(ESCAPE16))},
    {W32FUN(IT(RestoreDC),                  "RestoreDC",                MOD_GDI,   sizeof(RESTOREDC16))},

  /*** 0040 ***/
    {W32FUN(IT(FillRgn),                    "FillRgn",                  MOD_GDI,   sizeof(FILLRGN16))},
    {W32FUN(IT(FrameRgn),                   "FrameRgn",                 MOD_GDI,   sizeof(FRAMERGN16))},
    {W32FUN(IT(InvertRgn),                  "InvertRgn",                MOD_GDI,   sizeof(INVERTRGN16))},
    {W32FUN(IT(PaintRgn),                   "PaintRgn",                 MOD_GDI,   sizeof(PAINTRGN16))},
    {W32FUN(IT(SelectClipRgn),              "SelectClipRgn",            MOD_GDI,   sizeof(SELECTCLIPRGN16))},
    {W32FUN(IT(SelectObject),               "SelectObject",             MOD_GDI,   sizeof(SELECTOBJECT16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "BITMAPBITS",               MOD_GDI,   0)},
    {W32FUN(IT(CombineRgn),                 "CombineRgn",               MOD_GDI,   sizeof(COMBINERGN16))},
    {W32FUN(WG32CreateBitmap,               "CREATEBITMAP",             MOD_GDI,   sizeof(CREATEBITMAP16))},
    {W32FUN(WG32CreateBitmapIndirect,       "CREATEBITMAPINDIRECT",     MOD_GDI,   sizeof(CREATEBITMAPINDIRECT16))},

  /*** 0050 ***/
    {W32FUN(WG32CreateBrushIndirect,        "CREATEBRUSHINDIRECT",      MOD_GDI,   sizeof(CREATEBRUSHINDIRECT16))},
    {W32FUN(IT(CreateCompatibleBitmap),     "CreateCompatibleBitmap",   MOD_GDI,   sizeof(CREATECOMPATIBLEBITMAP16))},
    {W32FUN(WG32CreateCompatibleDC,         "CREATECOMPATIBLEDC",       MOD_GDI,   sizeof(CREATECOMPATIBLEDC16))},
    {W32FUN(WG32CreateDC,                   "CREATEDC",                 MOD_GDI,   sizeof(CREATEDC16))},
    {W32FUN(IT(CreateEllipticRgn),          "CreateEllipticRgn",        MOD_GDI,   sizeof(CREATEELLIPTICRGN16))},
    {W32FUN(WG32CreateEllipticRgnIndirect,  "CREATEELLIPTICRGNINDIRECT",MOD_GDI,   sizeof(CREATEELLIPTICRGNINDIRECT16))},
    {W32FUN(WG32CreateFont,                 "CREATEFONT",               MOD_GDI,   sizeof(CREATEFONT16))},
    {W32FUN(WG32CreateFontIndirect,         "CREATEFONTINDIRECT",       MOD_GDI,   sizeof(CREATEFONTINDIRECT16))},
    {W32FUN(IT(CreateHatchBrush),           "CreateHatchBrush",         MOD_GDI,   sizeof(CREATEHATCHBRUSH16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},

  /*** 0060 ***/
    {W32FUN(WG32CreatePatternBrush,         "CREATEPATTERNBRUSH",       MOD_GDI,   sizeof(CREATEPATTERNBRUSH16))},
    {W32FUN(IT(CreatePen),                  "CreatePen",                MOD_GDI,   sizeof(CREATEPEN16))},
    {W32FUN(WG32CreatePenIndirect,          "CREATEPENINDIRECT",        MOD_GDI,   sizeof(CREATEPENINDIRECT16))},
    {W32FUN(WG32CreatePolygonRgn,           "CREATEPOLYGONRGN",         MOD_GDI,   sizeof(CREATEPOLYGONRGN16))},
    {W32FUN(IT(CreateRectRgn),              "CreateRectRgn",            MOD_GDI,   sizeof(CREATERECTRGN16))},
    {W32FUN(WG32CreateRectRgnIndirect,      "CreateRectRgnIndirect",    MOD_GDI,   sizeof(CREATERECTRGNINDIRECT16))},
    {W32FUN(IT(CreateSolidBrush),           "CreateSolidBrush",         MOD_GDI,   sizeof(CREATESOLIDBRUSH16))},
    {W32FUN(WG32DPtoLP,                     "DPTOLP",                   MOD_GDI,   sizeof(DPTOLP16))},
    {W32FUN(WG32DeleteDC,                   "DELETEDC",                 MOD_GDI,   sizeof(DELETEDC16))},
    {W32FUN(WG32DeleteObject,               "DELETEOBJECT",             MOD_GDI,   sizeof(DELETEOBJECT16))},

  /*** 0070 ***/
    {W32FUN(WG32EnumFonts,                  "ENUMFONTS",                MOD_GDI,   sizeof(ENUMFONTS16))},
    {W32FUN(WG32EnumObjects,                "ENUMOBJECTS",              MOD_GDI,   sizeof(ENUMOBJECTS16))},
    {W32FUN(IT(EqualRgn),                   "EqualRgn",                 MOD_GDI,   sizeof(EQUALRGN16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "EXCLUDEVISRECT",           MOD_GDI,   0)},
    {W32FUN(IT(GetBitmapBits),              "GetBitmapBits",            MOD_GDI,   sizeof(GETBITMAPBITS16))},
    {W32FUN(IT(GetBkColor),                 "GetBkColor",               MOD_GDI,   sizeof(GETBKCOLOR16))},
    {W32FUN(IT(GetBkMode),                  "GetBkMode",                MOD_GDI,   sizeof(GETBKMODE16))},
    {W32FUN(WG32GetClipBox,                 "GETCLIPBOX",               MOD_GDI,   sizeof(GETCLIPBOX16))},
    {W32FUN(WG32GetCurrentPosition,         "GETCURRENTPOSITION",       MOD_GDI,   sizeof(GETCURRENTPOSITION16))},
    {W32FUN(WG32GetDCOrg,                   "GETDCORG",                 MOD_GDI,   sizeof(GETDCORG16))},

  /*** 0080 ***/
    {W32FUN(WG32GetDeviceCaps,              "GETDEVICECAPS",            MOD_GDI,   sizeof(GETDEVICECAPS16))},
    {W32FUN(IT(GetMapMode),                 "GetMapMode",               MOD_GDI,   sizeof(GETMAPMODE16))},
    {W32FUN(WG32GetObject,                  "GETOBJECT",                MOD_GDI,   sizeof(GETOBJECT16))},
    {W32FUN(IT(GetPixel),                   "GetPixel",                 MOD_GDI,   sizeof(GETPIXEL16))},
    {W32FUN(IT(GetPolyFillMode),            "GetPolyFillMode",          MOD_GDI,   sizeof(GETPOLYFILLMODE16))},
    {W32FUN(IT(GetROP2),                    "GetROP2",                  MOD_GDI,   sizeof(GETROP216))},
    {W32FUN(IT(GetRelAbs),                  "GetRelAbs",                MOD_GDI,   sizeof(GETRELABS16))},
    {W32FUN(IT(GetStockObject),             "GetStockObject",           MOD_GDI,   sizeof(GETSTOCKOBJECT16))},
    {W32FUN(IT(GetStretchBltMode),          "GetStretchBltMode",        MOD_GDI,   sizeof(GETSTRETCHBLTMODE16))},
    {W32FUN(IT(GetTextCharacterExtra),      "GetTextCharacterExtra",    MOD_GDI,   sizeof(GETTEXTCHARACTEREXTRA16))},

  /*** 0090 ***/
    {W32FUN(IT(GetTextColor),               "GetTextColor",             MOD_GDI,   sizeof(GETTEXTCOLOR16))},
    {W32FUN(WG32GetTextExtent,              "GetTextExtent",            MOD_GDI,   sizeof(GETTEXTEXTENT16))},
    {W32FUN(IT(GetTextFace),                "GetTextFace",              MOD_GDI,   sizeof(GETTEXTFACE16))},
    {W32FUN(WG32GetTextMetrics,             "GetTextMetrics",           MOD_GDI,   sizeof(GETTEXTMETRICS16))},
    {W32FUN(WG32GetViewportExt,             "GetViewportExt",           MOD_GDI,   sizeof(GETVIEWPORTEXT16))},
    {W32FUN(WG32GetViewportOrg,             "GetViewportOrg",           MOD_GDI,   sizeof(GETVIEWPORTORG16))},
    {W32FUN(WG32GetWindowExt,               "GetWindowExt",             MOD_GDI,   sizeof(GETWINDOWEXT16))},
    {W32FUN(WG32GetWindowOrg,               "GetWindowOrg",             MOD_GDI,   sizeof(GETWINDOWORG16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "INTERSECTVISRECT",         MOD_GDI,   0)},
    {W32FUN(WG32LPtoDP,                     "LPtoDP",                   MOD_GDI,   sizeof(LPTODP16))},

  /*** 0100 ***/
    {W32FUN(WG32LineDDA,                    "LineDDA",                  MOD_GDI,   sizeof(LINEDDA16))},
    {W32FUN(IT(OffsetRgn),                  "OffsetRgn",                MOD_GDI,   sizeof(OFFSETRGN16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "OFFSETVISRGN",             MOD_GDI,   0)},
    {W32FUN(IT(PtVisible),                  "PtVisible",                MOD_GDI,   sizeof(PTVISIBLE16))},
    {W32FUN(WG32RectVisible,                "RectVisible",              MOD_GDI,   sizeof(RECTVISIBLE16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "SELECTVISRGN",             MOD_GDI,   0)},
    {W32FUN(WG32SetBitmapBits,              "SetBitmapBits",            MOD_GDI,   sizeof(SETBITMAPBITS16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},

  /*** 0110 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "SETDCORG",                 MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "INTERNALCREATEDC",         MOD_GDI,   0)},
    {W32FUN(WG32AddFontResource,            "ADDFONTRESOURCE",          MOD_GDI,   sizeof(ADDFONTRESOURCE16))},

  /*** 0120 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "DEATH",                    MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "RESURRECTION",             MOD_GDI,   0)},
    {W32FUN(WG32PlayMetaFile,               "PLAYMETAFILE",             MOD_GDI,   sizeof(PLAYMETAFILE16))},
    {W32FUN(WG32GetMetaFile,                "GETMETAFILE",              MOD_GDI,   sizeof(GETMETAFILE16))},
    {W32FUN(WG32CreateMetaFile,             "CREATEMETAFILE",           MOD_GDI,   sizeof(CREATEMETAFILE16))},
    {W32FUN(WG32CloseMetaFile,              "CLOSEMETAFILE",            MOD_GDI,   sizeof(CLOSEMETAFILE16))},
    {W32FUN(WG32DeleteMetaFile,             "DELETEMETAFILE",           MOD_GDI,   sizeof(DELETEMETAFILE16))},
    {W32FUN(LOCALAPI,                       "MULDIV",                   MOD_GDI,   sizeof(MULDIV16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "SAVEVISRGN",               MOD_GDI,   0)},

  /*** 0130 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "RESTOREVISRGN",            MOD_GDI,   0)},
    {W32FUN(WG32InquireVisRgn,              "INQUIREVISRGN",            MOD_GDI,   0)},
    {W32FUN(NOPAPI,                         "SETENVIRONMENT",           MOD_GDI,   sizeof(SETENVIRONMENT16))},
    {W32FUN(WG32GetEnvironment,             "GETENVIRONMENT",           MOD_GDI,   sizeof(GETENVIRONMENT16))},
    {W32FUN(WG32GetRgnBox,                  "GETRGNBOX",                MOD_GDI,   sizeof(GETRGNBOX16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "SCANLR",                   MOD_GDI,   0)},
    {W32FUN(WG32RemoveFontResource,         "REMOVEFONTRESOURCE",       MOD_GDI,   sizeof(REMOVEFONTRESOURCE16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "GSV",                      MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "DPXLATE",                  MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "SETWINVIEWEXT",            MOD_GDI,   0)},

  /*** 0140 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "SCALEEXT",                 MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "WORDSET",                  MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "RECTSTUFF",                MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "OFFSETORG",                MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(WG32SetBrushOrg,                "SETBRUSHORG",              MOD_GDI,   sizeof(SETBRUSHORG16))},
    {W32FUN(WG32GetBrushOrg,                "GETBRUSHORG",              MOD_GDI,   sizeof(GETBRUSHORG16))},

  /*** 0150 ***/
    {W32FUN(IT(UnrealizeObject),            "UnrealizeObject",          MOD_GDI,   sizeof(UNREALIZEOBJECT16))},
    {W32FUN(WG32CopyMetaFile,               "COPYMETAFILE",             MOD_GDI,   sizeof(COPYMETAFILE16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(WG32CreateIC,                   "CREATEIC",                 MOD_GDI,   sizeof(CREATEIC16))},
    {W32FUN(IT(GetNearestColor),            "GetNearestColor",          MOD_GDI,   sizeof(GETNEARESTCOLOR16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "QUERYABORT",               MOD_GDI,   0)},
    {W32FUN(IT(CreateDiscardableBitmap),    "CreateDiscardableBitmap",  MOD_GDI,   sizeof(CREATEDISCARDABLEBITMAP16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "COMPATIBLEBITMAP",         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "ENUMCALLBACK",             MOD_GDI,   0)},
    {W32FUN(LOCALAPI,                       "GETMETAFILEBITS",          MOD_GDI,   0)},

  /*** 0160 ***/
    {W32FUN(LOCALAPI,                       "SETMETAFILEBITS",          MOD_GDI,   0)},
    {W32FUN(IT(PtInRegion),                 "PtInRegion",               MOD_GDI,   sizeof(PTINREGION16))},
    {W32FUN(WG32GetBitmapDimension,         "GETBITMAPDIMENSION",       MOD_GDI,   sizeof(GETBITMAPDIMENSION16))},
    {W32FUN(WG32SetBitmapDimension,         "SETBITMAPDIMENSION",       MOD_GDI,   sizeof(SETBITMAPDIMENSION16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "PIXTOLINE",                MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "ISDCDIRTY",                MOD_GDI,   0)},

  /*** 0170 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "SETDCSTATUS",              MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "LVBUNION",                 MOD_GDI,   0)},
    {W32FUN(IT(SetRectRgn),                 "SetRectRgn",               MOD_GDI,   sizeof(SETRECTRGN16))},
    {W32FUN(WG32GetClipRgn,                 "GetClipRgn",               MOD_GDI,   sizeof(GETCLIPRGN16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(WG32EnumMetaFile,               "ENUMMETAFILE",             MOD_GDI,   sizeof(ENUMMETAFILE16))},
    {W32FUN(WG32PlayMetaFileRecord,         "PLAYMETAFILERECORD",       MOD_GDI,   sizeof(PLAYMETAFILERECORD16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "RCOS",                     MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "RSIN",                     MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "GETDCSTATE",               MOD_GDI,   0)},

  /*** 0180 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "SETDCSTATE",               MOD_GDI,   0)},
    {W32FUN(WG32RectInRegion,               "RECTINREGION",             MOD_GDI,   sizeof(RECTINREGION16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "STUFFVISIBLE",             MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "STUFFINREGION",            MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "DELETEABOVELINEFONTS",     MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "GetTextExtentEx",          MOD_GDI,   sizeof(GETTEXTEXTENTEX16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},

  /*** 0190 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(WG32SetBoundsRect,              "SETBOUNDSRECT",            MOD_GDI,   sizeof(SETBOUNDSRECT16))},
    {W32FUN(WG32GetBoundsRect,              "GETBOUNDSRECT",            MOD_GDI,   sizeof(GETBOUNDSRECT16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(LOCALAPI,                       "SETMETAFILEBITSBETTER",    MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},

  /*** 0200 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(WG32DMBitBlt,                   "DMBITBLT",                 MOD_GDI,   sizeof(DMBITBLT16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "DMCOLORINFO",              MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "DMENUMDFONTS",             MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "DMENUMOBJ",                MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "DMOUTPUT",                 MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "DMPIXEL",                  MOD_GDI,   0)},

  /*** 0210 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "DMREALIZEOBJECT",          MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "DMSTRBLT",                 MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "DMSCANLR",                 MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "BRUTE",                    MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "DMEXTTEXTOUT",             MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "DMGETCHARWIDTH",           MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "DMSTRETCHBLT",             MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "DMDIBBITS",                MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "DMSTRETCHDIBITS",          MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "DMSETDIBTODEV",            MOD_GDI,   0)},

  /*** 0220 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "DMTRANSPOSE",              MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},

  /*** 0230 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "CREATEPQ",                 MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "MINPQ",                    MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "EXTRACTPQ",                MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "INSERTPQ",                 MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "SIZEPQ",                   MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "DELETEPQ",                 MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},

  /*** 0240 ***/
    {W32FUN(WG32OpenJob,                    "OPENJOB",                  MOD_GDI,   sizeof(OPENJOB16))},
    {W32FUN(WG32WriteSpool,                 "WRITESPOOL",               MOD_GDI,   sizeof(WRITESPOOL16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "WRITEDIALOG",              MOD_GDI,   sizeof(WRITEDIALOG16))},
    {W32FUN(WG32CloseJob,                   "CLOSEJOB",                 MOD_GDI,   sizeof(CLOSEJOB16))},
    {W32FUN(WG32DeleteJob,                  "DELETEJOB",                MOD_GDI,   sizeof(DELETEJOB16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "GETSPOOLJOB",              MOD_GDI,   0)},
    {W32FUN(WG32StartSpoolPage,             "STARTSPOOLPAGE",           MOD_GDI,   sizeof(STARTSPOOLPAGE16))},
    {W32FUN(WG32EndSpoolPage,               "ENDSPOOLPAGE",             MOD_GDI,   sizeof(ENDSPOOLPAGE16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "QUERYJOB",                 MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},

  /*** 0250 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "COPY",                     MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "DELETESPOOLPAGE",          MOD_GDI,   0)},
    {W32FUN(WG32SpoolFile,                  "SPOOLFILE",                MOD_GDI,   sizeof(SPOOLFILE16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},

  /*** 0260 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "GETOBJECTTYPE",            MOD_GDI,   0)},
    {W32FUN(IT(GetCurrentObject),           "GetCurrentObject",         MOD_GDI,   sizeof(GETCURRENTOBJECT16))},
    {W32FUN(IT(GetRegionData),              "GetRegionData",            MOD_GDI,   sizeof(GETREGIONDATA16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "OpenPrinterA",             MOD_GDI,   sizeof(OPENPRINTERA16))},
    {W32FUN(UNIMPLEMENTED95API,             "StartDocPrinterA",         MOD_GDI,   sizeof(STARTDOCPRINTERA16))},
    {W32FUN(UNIMPLEMENTED95API,             "StartPagePrinter",         MOD_GDI,   sizeof(STARTPAGEPRINTER16))},
    {W32FUN(UNIMPLEMENTED95API,             "WritePrinter",             MOD_GDI,   sizeof(WRITEPRINTER16))},

  /*** 0270 ***/
    {W32FUN(UNIMPLEMENTED95API,             "EndPagePrinter",           MOD_GDI,   sizeof(ENDPAGEPRINTER16))},
    {W32FUN(UNIMPLEMENTED95API,             "AbortPrinter",             MOD_GDI,   sizeof(ABORTPRINTER16))},
    {W32FUN(UNIMPLEMENTED95API,             "EndDocPrinter",            MOD_GDI,   sizeof(ENDDOCPRINTER16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "ClosePrinter",             MOD_GDI,   sizeof(CLOSEPRINTER16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},

  /*** 0280 ***/
    {W32FUN(UNIMPLEMENTED95API,             "GetRealDriverInfo",        MOD_GDI,   sizeof(GETREALDRIVERINFO16))},
    {W32FUN(UNIMPLEMENTED95API,             "DrvSetPrinterData",        MOD_GDI,   sizeof(DRVSETPRINTERDATA16))},
    {W32FUN(UNIMPLEMENTED95API,             "DrvGetPrinterData",        MOD_GDI,   sizeof(DRVGETPRINTERDATA16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},

  /*** 0290 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "EngineGetCharWidthEx",     MOD_GDI,   sizeof(ENGINEGETCHARWIDTHEX16))},

  /*** 0300 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "ENGINEENUMERATEFONT",      MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "ENGINEDELETEFONT",         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "ENGINEREALIZEFONT",        MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "ENGINEGETCHARWIDTH",       MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "ENGINESETFONTCONTEXT",     MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "EngineGetGlyphBmpExt",     MOD_GDI,   sizeof(ENGINEGETGLYPHBMPEXT16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "ENGINEMAKEFONTDIR",        MOD_GDI,   0)},
    {W32FUN(WG32GetCharABCWidths,           "GETCHARABCWIDTHS",         MOD_GDI,   sizeof(GETCHARABCWIDTHS16))},
    {W32FUN(WG32GetOutlineTextMetrics,      "GETOUTLINETEXTMETRICS",    MOD_GDI,   sizeof(GETOUTLINETEXTMETRICS16))},
    {W32FUN(WG32GetGlyphOutline,            "GETGLYPHOUTLINE",          MOD_GDI,   sizeof(GETGLYPHOUTLINE16))},

  /*** 0310 ***/
    {W32FUN(WG32CreateScalableFontResource, "CreateScalableFontResource",MOD_GDI,  sizeof(CREATESCALABLEFONTRESOURCE16))},
    {W32FUN(IT(GetFontData),                "GetFontData",              MOD_GDI,   sizeof(GETFONTDATA16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "CONVERTOUTLINEFONTFILE",   MOD_GDI,   0)},
    {W32FUN(WG32GetRasterizerCaps,          "GETRASTERIZERCAPS",        MOD_GDI,   sizeof(GETRASTERIZERCAPS16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "ENGINEEXTTEXTOUT",         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "EngineRealizeFontExt",     MOD_GDI,   sizeof(ENGINEREALIZEFONTEXT16))},
    {W32FUN(UNIMPLEMENTED95API,             "EngineGetCharWidthStr",    MOD_GDI,   sizeof(ENGINEGETCHARWIDTHSTR16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},

  /*** 0320 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},

  /*** 0330 ***/
    {W32FUN(WG32EnumFontFamilies,           "ENUMFONTFAMILIES",         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(WG32GetKerningPairs,            "GETKERNINGPAIRS",          MOD_GDI,   sizeof(GETKERNINGPAIRS16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},

  /*** 0340 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(IT(GetTextAlign),               "GetTextAlign",             MOD_GDI,   sizeof(GETTEXTALIGN16))},
    {W32FUN(IT(SetTextAlign),               "SetTextAlign",             MOD_GDI,   sizeof(SETTEXTALIGN16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "MFDRAWTEXT",               MOD_GDI,   0)},
    {W32FUN(IT(Chord),                      "Chord",                    MOD_GDI,   sizeof(CHORD16))},
    {W32FUN(IT(SetMapperFlags),             "SetMapperFlags",           MOD_GDI,   sizeof(SETMAPPERFLAGS16))},

  /*** 0350 ***/
    {W32FUN(WG32GetCharWidth,               "GETCHARWIDTH",             MOD_GDI,   sizeof(GETCHARWIDTH16))},
    {W32FUN(WG32ExtTextOut,                 "EXTTEXTOUT",               MOD_GDI,   sizeof(EXTTEXTOUT16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "GETPHYSICALFONTHANDLE",    MOD_GDI,   0)},
    {W32FUN(WG32GetAspectRatioFilter,       "GETASPECTRATIOFILTER",     MOD_GDI,   sizeof(GETASPECTRATIOFILTER16))},
    {W32FUN(NOPAPI,                         "SHRINKGDIHEAP",            MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "FTRAPPING0",               MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},

  /*** 0360 ***/
    {W32FUN(IT(CreatePalette),              "CreatePalette",            MOD_GDI,   sizeof(CREATEPALETTE16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "GDISELECTPALETTE",         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "GDIREALIZEPALETTE",        MOD_GDI,   0)},
    {W32FUN(IT(GetPaletteEntries),          "GetPaletteEntries",        MOD_GDI,   sizeof(GETPALETTEENTRIES16))},
    {W32FUN(IT(SetPaletteEntries),          "SetPaletteEntries",        MOD_GDI,   sizeof(SETPALETTEENTRIES16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "REALIZEDEFAULTPALETTE",    MOD_GDI,   0)},
    {W32FUN(IT(UpdateColors),               "UpdateColors",             MOD_GDI,   sizeof(UPDATECOLORS16))},
    {W32FUN(IT(AnimatePalette),             "AnimatePalette",           MOD_GDI,   sizeof(ANIMATEPALETTE16))},
    {W32FUN(IT(ResizePalette),              "ResizePalette",            MOD_GDI,   sizeof(RESIZEPALETTE16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},

  /*** 0370 ***/
    {W32FUN(IT(GetNearestPaletteIndex),     "GetNearestPaletteIndex",   MOD_GDI,   sizeof(GETNEARESTPALETTEINDEX16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(IT(ExtFloodFill),               "ExtFloodFill",             MOD_GDI,   sizeof(EXTFLOODFILL16))},
    {W32FUN(IT(SetSystemPaletteUse),        "SetSystemPaletteUse",      MOD_GDI,   sizeof(SETSYSTEMPALETTEUSE16))},
    {W32FUN(IT(GetSystemPaletteUse),        "GetSystemPaletteUse",      MOD_GDI,   sizeof(GETSYSTEMPALETTEUSE16))},
    {W32FUN(WG32GetSystemPaletteEntries,    "GetSystemPaletteEntries",  MOD_GDI,   sizeof(GETSYSTEMPALETTEENTRIES16))},
    {W32FUN(WG32ResetDC,                    "ResetDC",                  MOD_GDI,   sizeof(RESETDC16))},
    {W32FUN(WG32StartDoc,                   "StartDoc",                 MOD_GDI,   sizeof(STARTDOC16))},
    {W32FUN(WG32EndDoc,                     "EndDoc",                   MOD_GDI,   sizeof(ENDDOC16))},
    {W32FUN(IT(StartPage),                  "StartPage",                MOD_GDI,   sizeof(STARTPAGE16))},

  /*** 0380 ***/
    {W32FUN(IT(EndPage),                    "EndPage",                  MOD_GDI,   sizeof(ENDPAGE16))},
    {W32FUN(WG32SetAbortProc,               "SetAbortProc",             MOD_GDI,   sizeof(SETABORTPROC16))},
    {W32FUN(WG32AbortDoc,                   "AbortDoc",                 MOD_GDI,   sizeof(ABORTDOC16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},

  /*** 0390 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},

  /*** 0400 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "FASTWINDOWFRAME",          MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "GDIMOVEBITMAP",            MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "GDIINIT2",                 MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "GetTTGlyphIndexMap",       MOD_GDI,   sizeof(GETTTGLYPHINDEXMAP16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "FINALGDIINIT",             MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "CREATEREALBITMAPINDIRECT", MOD_GDI,   0)},
    {W32FUN(WG32CreateBitmap,               "CREATEUSERBITMAP",         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "CREATEREALBITMAP",         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "CREATEUSERDISCARDABLEBITMAP",MOD_GDI, 0)},

  /*** 0410 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "ISVALIDMETAFILE",          MOD_GDI,   0)},
    {W32FUN(WG32GetCurLogFont,              "GETCURLOGFONT",            MOD_GDI,   sizeof(GETCURLOGFONT16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "ISDCCURRENTPALETTE",       MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},

  /*** 0420 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},

  /*** 0430 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(WG32StretchDIBits,              "STRETCHDIBITS",            MOD_GDI,   sizeof(STRETCHDIBITS16))},

  /*** 0440 ***/
    {W32FUN(WG32SetDIBits,                  "SETDIBITS",                MOD_GDI,   sizeof(SETDIBITS16))},
    {W32FUN(WG32GetDIBits,                  "GETDIBITS",                MOD_GDI,   sizeof(GETDIBITS16))},
    {W32FUN(WG32CreateDIBitmap,             "CREATEDIBITMAP",           MOD_GDI,   sizeof(CREATEDIBITMAP16))},
    {W32FUN(WG32SetDIBitsToDevice,          "SETDIBITSTODEVICE",        MOD_GDI,   sizeof(SETDIBITSTODEVICE16))},
    {W32FUN(IT(CreateRoundRectRgn),         "CreateRoundRectRgn",       MOD_GDI,   sizeof(CREATEROUNDRECTRGN16))},
    {W32FUN(WG32CreateDIBPatternBrush,      "CreateDIBPatternBrush",    MOD_GDI,   sizeof(CREATEDIBPATTERNBRUSH16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "DEVICECOLORMATCH",         MOD_GDI,   0)},

  /*** 0450 ***/
    {W32FUN(WG32PolyPolygon,                "PolyPolygon",              MOD_GDI,   sizeof(POLYPOLYGON16))},
    {W32FUN(WG32CreatePolyPolygonRgn,       "CreatePolyPolygonRgn",     MOD_GDI,   sizeof(CREATEPOLYPOLYGONRGN16))},
    {W32FUN(WG32DeviceMode,                 "DeviceMode",               MOD_GDI,   sizeof(DEVICEMODE16))},
    {W32FUN(WG32ExtDeviceMode,              "ExtDeviceMode",            MOD_GDI,   sizeof(EXTDEVICEMODE16))},
    {W32FUN(WG32DeviceCapabilities,         "DeviceCapabilities",       MOD_GDI,   sizeof(DEVICECAPABILITIES16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
#ifdef FE_SB //add GetFontAssocStatus(), pisuih, 10/6/94'
    {W32FUN(WG32GetFontAssocStatus,         "GETFONTASSOCSTATUS",       MOD_GDI,   sizeof(GETFONTASSOCSTATUS16))},
#else   // FE_SB
    {W32FUN(UNIMPLEMENTEDAPI,               "",                         MOD_GDI,   0)},
#endif  // FE_SB

  /*** 0460 ***/
    {W32FUN(UNIMPLEMENTEDAPI,               "GDITASKTERMINATION",       MOD_GDI,   0)},
    {W32FUN(NOPAPI,                         "SetObjectOwner",           MOD_GDI,   0)},
    {W32FUN(IT(IsGDIObject),                "IsGDIObject",              MOD_GDI,   sizeof(ISGDIOBJECT16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "MAKEOBJECTPRIVATE",        MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "FIXUPBOGUSPUBLISHERMETAFILE",MOD_GDI, 0)},
    {W32FUN(WG32RectVisible,                "RECTVISIBLE_EHH",          MOD_GDI,   sizeof(RECTVISIBLE16))},
    {W32FUN(UNIMPLEMENTEDAPI,               "RECTINREGION_EHH",         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTEDAPI,               "UNICODETOANSI",            MOD_GDI,   0)},
    {W32FUN(WG32GetBitmapDimensionEx,       "GETBITMAPDIMENSIONEX",     MOD_GDI,   sizeof(GETBITMAPDIMENSIONEX16))},
    {W32FUN(WG32GetBrushOrgEx,              "GETBRUSHORGEX",            MOD_GDI,   sizeof(GETBRUSHORGEX16))},

  /*** 0470 ***/
    {W32FUN(WG32GetCurrentPositionEx,       "GETCURRENTPOSITIONEX",     MOD_GDI,   sizeof(GETCURRENTPOSITIONEX16))},
    {W32FUN(WG32GetTextExtentPoint,         "GETTEXTEXTENTPOINT",       MOD_GDI,   sizeof(GETTEXTEXTENTPOINT16))},
    {W32FUN(WG32GetViewportExtEx,           "GETVIEWPORTEXTEX",         MOD_GDI,   sizeof(GETVIEWPORTEXTEX16))},
    {W32FUN(WG32GetViewportOrgEx,           "GETVIEWPORTORGEX",         MOD_GDI,   sizeof(GETVIEWPORTORGEX16))},
    {W32FUN(WG32GetWindowExtEx,             "GETWINDOWEXTEX",           MOD_GDI,   sizeof(GETWINDOWEXTEX16))},
    {W32FUN(WG32GetWindowOrgEx,             "GETWINDOWORGEX",           MOD_GDI,   sizeof(GETWINDOWORGEX16))},
    {W32FUN(WG32OffsetViewportOrgEx,        "OFFSETVIEWPORTORGEX",      MOD_GDI,   sizeof(OFFSETVIEWPORTORGEX16))},
    {W32FUN(WG32OffsetWindowOrgEx,          "OFFSETWINDOWORGEX",        MOD_GDI,   sizeof(OFFSETWINDOWORGEX16))},
    {W32FUN(WG32SetBitmapDimensionEx,       "SETBITMAPDIMENSIONEX",     MOD_GDI,   sizeof(SETBITMAPDIMENSIONEX16))},
    {W32FUN(WG32SetViewportExtEx,           "SETVIEWPORTEXTEX",         MOD_GDI,   sizeof(SETVIEWPORTEXTEX16))},

  /*** 0480 ***/
    {W32FUN(WG32SetViewportOrgEx,           "SETVIEWPORTORGEX",         MOD_GDI,   sizeof(SETVIEWPORTORGEX16))},
    {W32FUN(WG32SetWindowExtEx,             "SETWINDOWEXTEX",           MOD_GDI,   sizeof(SETWINDOWEXTEX16))},
    {W32FUN(WG32SetWindowOrgEx,             "SETWINDOWORGEX",           MOD_GDI,   sizeof(SETWINDOWORGEX16))},
    {W32FUN(WG32MoveToEx,                   "MOVETOEX",                 MOD_GDI,   sizeof(MOVETOEX16))},
    {W32FUN(WG32ScaleViewportExtEx,         "SCALEVIEWPORTEXTEX",       MOD_GDI,   sizeof(SCALEVIEWPORTEXTEX16))},
    {W32FUN(WG32ScaleWindowExtEx,           "SCALEWINDOWEXTEX",         MOD_GDI,   sizeof(SCALEWINDOWEXTEX16))},
    {W32FUN(WG32GetAspectRatioFilterEx,     "GETASPECTRATIOFILTEREX",   MOD_GDI,   sizeof(GETASPECTRATIOFILTEREX16))},
    {W32FUN(WG32PolyPolylineWOW,            "POLYPOLYLINEWOW",          MOD_GDI,   sizeof(POLYPOLYLINEWOW16))},
    {W32FUN(WG32SetDIBColorTable,           "SETDIBCOLORTABLE",         MOD_GDI,   sizeof(SETDIBCOLORTABLE16))},
    {W32FUN(WG32CreateDIBSection,           "CREATEDIBSECTION",         MOD_GDI,   sizeof(CREATEDIBSECTION16))},

  /*** 0490 ***/
    {W32FUN(IT(CloseEnhMetaFile),           "CloseEnhMetaFile",         MOD_GDI,   sizeof(CLOSEENHMETAFILE16))},
    {W32FUN(IT(CopyEnhMetaFile),            "CopyEnhMetaFile",          MOD_GDI,   sizeof(COPYENHMETAFILE16))},
    {W32FUN(WG32CreateEnhMetaFile,          "CreateEnhMetaFile",        MOD_GDI,   sizeof(CREATEENHMETAFILE16))},
    {W32FUN(IT(DeleteEnhMetaFile),          "DeleteEnhMetaFile",        MOD_GDI,   sizeof(DELETEENHMETAFILE16))},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(IT(GdiComment),                 "GdiComment",               MOD_GDI,   sizeof(GDICOMMENT16))},
    {W32FUN(IT(GetEnhMetaFile),             "GetEnhMetaFile",           MOD_GDI,   sizeof(GETENHMETAFILE16))},
    {W32FUN(IT(GetEnhMetaFileBits),         "GetEnhMetaFileBits",       MOD_GDI,   sizeof(GETENHMETAFILEBITS16))},
    {W32FUN(IT(GetEnhMetaFileDescription),  "GetEnhMetaFileDescription",MOD_GDI,   sizeof(GETENHMETAFILEDESCRIPTION16))},
    {W32FUN(IT(GetEnhMetaFileHeader),       "GetEnhMetaFileHeader",     MOD_GDI,   sizeof(GETENHMETAFILEHEADER16))},

  /*** 0500 ***/
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(IT(GetEnhMetaFilePaletteEntries), "GetEnhMetaFilePaletteEntries", MOD_GDI,sizeof(GETENHMETAFILEPALETTEENTRIES16))},
    {W32FUN(UNIMPLEMENTED95API,             "PolyBezier",               MOD_GDI,   sizeof(POLYBEZIER16))},
    {W32FUN(UNIMPLEMENTED95API,             "PolyBezierTo",             MOD_GDI,   sizeof(POLYBEZIERTO16))},
    {W32FUN(IT(PlayEnhMetaFileRecord),      "PlayEnhMetaFileRecord",    MOD_GDI,   sizeof(PLAYENHMETAFILERECORD16))},
    {W32FUN(IT(SetEnhMetaFileBits),         "SetEnhMetaFileBits",       MOD_GDI,   sizeof(SETENHMETAFILEBITS16))},
    {W32FUN(IT(SetMetaRgn),                 "SetMetaRgn",               MOD_GDI,   sizeof(SETMETARGN16))},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(IT(ExtSelectClipRgn),           "ExtSelectClipRgn",         MOD_GDI,   sizeof(EXTSELECTCLIPRGN16))},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},

  /*** 0510 ***/
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(IT(AbortPath),                  "AbortPath",                MOD_GDI,   sizeof(ABORTPATH16))},
    {W32FUN(IT(BeginPath),                  "BeginPath",                MOD_GDI,   sizeof(BEGINPATH16))},
    {W32FUN(IT(CloseFigure),                "CloseFigure",              MOD_GDI,   sizeof(CLOSEFIGURE16))},
    {W32FUN(IT(EndPath),                    "EndPath",                  MOD_GDI,   sizeof(ENDPATH16))},
    {W32FUN(IT(FillPath),                   "FillPath",                 MOD_GDI,   sizeof(FILLPATH16))},
    {W32FUN(IT(FlattenPath),                "FlattenPath",              MOD_GDI,   sizeof(FLATTENPATH16))},
    {W32FUN(IT(GetPath),                    "GetPath",                  MOD_GDI,   sizeof(GETPATH16))},
    {W32FUN(IT(PathToRegion),               "PathToRegion",             MOD_GDI,   sizeof(PATHTOREGION16))},
    {W32FUN(IT(SelectClipPath),             "SelectClipPath",           MOD_GDI,   sizeof(SELECTCLIPPATH16))},

  /*** 0520 ***/
    {W32FUN(IT(StrokeAndFillPath),          "StrokeAndFillPath",        MOD_GDI,   sizeof(STROKEANDFILLPATH16))},
    {W32FUN(IT(StrokePath),                 "StrokePath",               MOD_GDI,   sizeof(STROKEPATH16))},
    {W32FUN(IT(WidenPath),                  "WidenPath",                MOD_GDI,   sizeof(WIDENPATH16))},
    {W32FUN(IT(ExtCreatePen),               "ExtCreatePen",             MOD_GDI,   sizeof(EXTCREATEPEN16))},
    {W32FUN(IT(GetArcDirection),            "GetArcDirection",          MOD_GDI,   sizeof(GETARCDIRECTION16))},
    {W32FUN(IT(SetArcDirection),            "SetArcDirection",          MOD_GDI,   sizeof(SETARCDIRECTION16))},
    {W32FUN(IT(GetMiterLimit),              "GetMiterLimit",            MOD_GDI,   sizeof(GETMITERLIMIT16))},
    {W32FUN(IT(SetMiterLimit),              "SetMiterLimit",            MOD_GDI,   sizeof(SETMITERLIMIT16))},
    {W32FUN(UNIMPLEMENTED95API,             "GdiParametersInfo",        MOD_GDI,   sizeof(GDIPARAMETERSINFO16))},
    {W32FUN(IT(CreateHalftonePalette),      "CreateHalftonePalette",    MOD_GDI,   sizeof(CREATEHALFTONEPALETTE16))},

  /*** 0530 ***/
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},

  /*** 0540 ***/
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},

  /*** 0550 ***/
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},

  /*** 0560 ***/
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},

  /*** 0570 ***/
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},

  /*** 0580 ***/
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},

  /*** 0590 ***/
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},

  /*** 0600 ***/
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(UNIMPLEMENTED95API,             "",                         MOD_GDI,   0)},
    {W32FUN(WG32SetDIBColorTable,           "SETDIBCOLORTABLE",         MOD_GDI,   sizeof(SETDIBCOLORTABLE16))},
    {W32FUN(WG32GetDIBColorTable,           "GETDIBCOLORTABLE",         MOD_GDI,   sizeof(GETDIBCOLORTABLE16))},
    {W32FUN(UNIMPLEMENTED95API,             "SetSolidBrush",            MOD_GDI,   sizeof(SETSOLIDBRUSH16))},
    {W32FUN(UNIMPLEMENTED95API,             "SysDeleteObject",          MOD_GDI,   sizeof(SYSDELETEOBJECT16))},
    {W32FUN(IT(SetMagicColors),             "SetMagicColors",           MOD_GDI,   sizeof(SETMAGICCOLORS16))},
    {W32FUN(IT(GetRegionData),              "GetRegionData",            MOD_GDI,   sizeof(GETREGIONDATA16))},
    {W32FUN(IT(ExtCreateRegion),            "ExtCreateRegion",          MOD_GDI,   sizeof(EXTCREATEREGION16))},
    {W32FUN(LOCALAPI,                       "Avail - GdiFreeResources", MOD_GDI,   0)},

  /*** 0610 ***/
    {W32FUN(UNIMPLEMENTED95API,             "GdiSignalProc32",          MOD_GDI,   sizeof(GDISIGNALPROC3216))},
    {W32FUN(IT(GetRandomRgn),               "GetRandomRgn",             MOD_GDI,   sizeof(GETRANDOMRGN16))},
    {W32FUN(IT(GetTextCharset),             "GetTextCharset",           MOD_GDI,   sizeof(GETTEXTCHARSET16))},
    {W32FUN(UNIMPLEMENTED95API,             "EnumFontFamiliesEx",       MOD_GDI,   sizeof(ENUMFONTFAMILIESEX16))},
    {W32FUN(UNIMPLEMENTED95API,             "AddLPKtoGDI",              MOD_GDI,   sizeof(ADDLPKTOGDI16))},
    {W32FUN(WG32GetCharacterPlacement,      "GetCharacterPlacement",    MOD_GDI,   sizeof(GETCHARACTERPLACEMENT16))},
    {W32FUN(IT(GetFontLanguageInfo),        "GetFontLanguageInfo",      MOD_GDI,   sizeof(GETFONTLANGUAGEINFO16))},
    {W32FUN(UNIMPLEMENTED95API,             "BuildInverseTableDIB",     MOD_GDI,   sizeof(BUILDINVERSETABLEDIB16))},
    {W32FUN(UNIMPLEMENTED95API,             "ICMCreateTransform",       MOD_GDI,   sizeof(ICMCREATETRANSFORM16))},
    {W32FUN(UNIMPLEMENTED95API,             "ICMDeleteTransform",       MOD_GDI,   sizeof(ICMDELETETRANSFORM16))},

  /*** 0620 ***/
    {W32FUN(UNIMPLEMENTED95API,             "ICMTranslateRGB",          MOD_GDI,   sizeof(ICMTRANSLATERGB16))},
    {W32FUN(UNIMPLEMENTED95API,             "ICMTranslateRGBs",         MOD_GDI,   sizeof(ICMTRANSLATERGBS16))},
    {W32FUN(UNIMPLEMENTED95API,             "ICMCheckColorsInGamut",    MOD_GDI,   sizeof(ICMCHECKCOLORSINGAMUT16))},
