//+------------------------------------------------------------------------
//
//  File:       FORMKRNL.CXX
//
//  Contents:   Root object of the standard forms kernel
//
//  Classes:    (part of) CDoc
//
//-------------------------------------------------------------------------

#include "headers.hxx"

#ifndef X_SHEETS_HXX_
#define X_SHEETS_HXX_
#include "sheets.hxx"
#endif

#ifndef X_SCRIPT_HXX_
#define X_SCRIPT_HXX_
#include "script.hxx"
#endif

#ifndef X_QI_IMPL_H_
#define X_QI_IMPL_H_
#include "qi_impl.h"
#endif

#ifndef X_EVNTPRM_HXX_
#define X_EVNTPRM_HXX_
#include "evntprm.hxx"
#endif

#ifndef X_EVENTOBJ_HXX_
#define X_EVENTOBJ_HXX_
#include "eventobj.hxx"
#endif

#ifndef X_DOCGLBS_HXX_
#define X_DOCGLBS_HXX_
#include "docglbs.hxx"
#endif

#ifndef X_SITECNST_HXX_
#define X_SITECNST_HXX_
#include "sitecnst.hxx"
#endif

#ifndef X_TIMER_HXX_
#define X_TIMER_HXX_
#include "timer.hxx"
#endif

#ifndef X_WINDOW_HXX_
#define X_WINDOW_HXX_
#include "window.hxx"
#endif

#ifndef X_EANCHOR_HXX_
#define X_EANCHOR_HXX_
#include "eanchor.hxx"
#endif

#ifndef X_FRAMESET_HXX_
#define X_FRAMESET_HXX_
#include "frameset.hxx"
#endif

#ifndef X_HEDELEMS_HXX_
#define X_HEDELEMS_HXX_
#include "hedelems.hxx"
#endif

#ifndef X_PROGSINK_HXX_
#define X_PROGSINK_HXX_
#include "progsink.hxx"
#endif

#ifndef X_PERHIST_HXX_
#define X_PERHIST_HXX_
#include "perhist.hxx"
#endif

#ifndef X_BODYLYT_HXX_
#define X_BODYLYT_HXX_
#include "bodylyt.hxx"
#endif

#ifndef X_TREEPOS_HXX_
#define X_TREEPOS_HXX_
#include "treepos.hxx"
#endif

#ifndef X_WINABLE_H_
#define X_WINABLE_H_
#include "winable.h"
#endif

#ifndef X_CUTIL_HXX_
#define X_CUTIL_HXX_
#include "cutil.hxx"
#endif

#ifndef X_EAREA_HXX_
#define X_EAREA_HXX_
#include "earea.hxx"
#endif

#ifndef X_IMGELEM_HXX_
#define X_IMGELEM_HXX_
#include "imgelem.hxx"
#endif

#ifndef X_DBTASK_HXX_
#define X_DBTASK_HXX_
#include "dbtask.hxx"
#endif

#ifndef X_IDISPIDS_H_
#define X_IDISPIDS_H_
#include "idispids.h"
#endif

#ifndef X_INTL_HXX_
#define X_INTL_HXX_
#include "intl.hxx"
#endif

#ifndef X_OTHRGUID_H_
#define X_OTHRGUID_H_
#include "othrguid.h"
#endif

#ifndef X_FRAME_HXX_
#define X_FRAME_HXX_
#include "frame.hxx"
#endif

#ifndef X_EBODY_HXX_
#define X_EBODY_HXX_
#include "ebody.hxx"
#endif

#ifndef X_DOWNLOAD_HXX_
#define X_DOWNLOAD_HXX_
#include "download.hxx"
#endif

#ifndef X_IMGANIM_HXX_
#define X_IMGANIM_HXX_
#include "imganim.hxx"
#endif

#ifndef X_EOBJECT_HXX_
#define X_EOBJECT_HXX_
#include "eobject.hxx"
#endif

#ifndef X_DEBUGPAINT_HXX_
#define X_DEBUGPAINT_HXX_
#include "debugpaint.hxx"
#endif

#ifndef X_DWNNOT_H_
#define X_DWNNOT_H_
#include <dwnnot.h>
#endif

#ifndef X_SAFEOCX_H_
#define X_SAFEOCX_H_
#include <safeocx.h>
#endif

#ifndef X_HTIFACE_H_
#define X_HTIFACE_H_
#include <htiface.h>
#endif

#ifndef X_OBJEXT_H_
#define X_OBJEXT_H_
#include <objext.h>
#endif

#ifndef X_PERHIST_H_
#define X_PERHIST_H_
#include <perhist.h>
#endif

#ifndef X_MSDATSRC_H_
#define X_MSDATSRC_H_
#include <msdatsrc.h>
#endif

#ifndef X_MSHTMCID_H_
#define X_MSHTMCID_H_
#include <mshtmcid.h>
#endif

#ifndef X_URLHIST_H_
#define X_URLHIST_H_
#include <urlhist.h>
#endif

#ifndef X_HLINK_H_
#define X_HLINK_H_
#include <hlink.h>
#endif

#ifndef X_MARQINFO_H_
#define X_MARQINFO_H_
#include <marqinfo.h>
#endif

#ifndef X_HTMVER_HXX_
#define X_HTMVER_HXX_
#include "htmver.hxx"
#endif

#ifndef X_VERVEC_H_
#define X_VERVEC_H_
#include "vervec.h"
#endif

#ifndef X_STYLE_HXX_
#define X_STYLE_HXX_
#include "style.hxx"
#endif

#ifndef X_EXTDL_HXX_
#define X_EXTDL_HXX_
#include "extdl.hxx"
#endif

#ifndef X_ROOTELEMENT_HXX_
#define X_ROOTELEMENT_HXX_
#include "rootelem.hxx"
#endif

#ifndef X_DISPROOT_HXX_
#define X_DISPROOT_HXX_
#include "disproot.hxx"
#endif

#ifndef X_DISPCONTEXT_HXX_
#define X_DISPCONTEXT_HXX_
#include "dispcontext.hxx"
#endif

#ifndef X_CGLYPH_HXX_
#define X_CGLYPH_HXX_
#include "cglyph.hxx"
#endif

#ifndef X_UNDO_HXX_
#define X_UNDO_HXX_
#include "undo.hxx"
#endif

#ifndef X_PEERFACT_HXX_
#define X_PEERFACT_HXX_
#include "peerfact.hxx"
#endif

#ifndef X_MARKUPUNDO_HXX_
#define X_MARKUPUNDO_HXX_
#include "markupundo.hxx"
#endif

#ifndef X_LSCACHE_HXX_
#define X_LSCACHE_HXX_
#include "lscache.hxx"
#endif

#ifndef X_PEER_HXX_
#define X_PEER_HXX_
#include "peer.hxx"
#endif

#ifndef X_INPUTTXT_HXX_
#define X_INPUTTXT_HXX_
#include "inputtxt.hxx"
#endif

#ifndef X_XMLNS_HXX_
#define X_XMLNS_HXX_
#include "xmlns.hxx"
#endif

#ifndef X_DEBUGGER_HXX_
#define X_DEBUGGER_HXX_
#include "debugger.hxx"
#endif

#ifndef _X_SELDRAG_HXX_
#define _X_SELDRAG_HXX_
#include "seldrag.hxx"
#endif

#ifdef QUILL

#ifndef X_QDOCGLUE_HXX_
#define X_QDOCGLUE_HXX_
#include "..\lequill\qdocglue.hxx"
#endif

#endif  // QUILL

#ifndef NO_SCRIPT_DEBUGGER
extern void    DeinitScriptDebugging();
#endif // NO_SCRIPT_DEBUGGER

#ifndef NODD
extern void         ClearSurfaceCache();        // out of offscreen.cxx to clear allocated DD surfaces
#endif

CFlowLayout * GetFlowLayoutForSelection(CTreeNode * pNode); // defined in viewserv.cxx

HRESULT RemoveSpecialUrl(LPTSTR pchUrlSrc, BSTR * pbstrUrlRes);

#ifndef X_ACCWIND_HXX_
#define X_ACCWIND_HXX_
#include "accwind.hxx"
#endif

extern "C" const IID IID_IObjectSafety;
extern "C" const IID IID_IThumbnailView;
extern "C" const IID IID_IRenMailEditor;
extern "C" const IID IID_IRenVersionCheck;
extern "C" const IID IID_IHTMLEditorViewManager;
extern "C" const IID SID_SHTMLEditorViewManager;
extern "C" const CLSID  CLSID_HTMLEditor;
extern "C" const CLSID CLSID_HTMLPluginDocument;
extern "C" const CLSID CLSID_HTMLDialog;
extern "C" const IID IID_IHTMLDialog;
extern "C" const IID IID_IHTMLViewServices;
#define SID_SElementBehaviorFactory IID_IElementBehaviorFactory
extern "C" const GUID SID_SHTMLEditor;
extern "C" const CLSID CLSID_HTMLPluginDocument;
extern "C" const CLSID CLSID_HTMLDialog;
extern "C" const IID IID_IHTMLDialog;
#define SID_SElementBehaviorFactory IID_IElementBehaviorFactory
extern "C" const GUID SID_SSelectionManager;
extern "C" const IID SID_DefView;

#if TREE_SYNC
// this is a big HACK, to temporarily get markup-sync working for netdocs.  it
// will totally change in the future.
extern "C" const IID IID_IMarkupSyncServices;
#endif // TREE_SYNC
#ifdef XMV_PARSE
extern "C" const IID IID_IXMLGenericParse;
#endif // XMV_PARSE

#define EXPANDOS_DEFAULT true

DeclareTag(tagCDoc, "Form", "Form base class methods")
DeclareTag(tagUpdateUI, "Form", "Form UpdateUI calls")
DeclareTag(tagUrlImgCtx, "UrlImgCtx", "Trace UrlImgCtx methods")
DeclareTag(tagAssertParentDocChangeToDebugIsPrintDocCache, "Print", "Assert parent doc change")
DeclareTag(tagCompatMsMoney, "Compat", "Microsoft Money")
ExternTag(tagDisableLockAR);
ExternTag(tagFilter)

PerfTag(tagGasGauge, "GasGauge", "MSHTML Info")
PerfDbgExtern(tagPerfWatch)
PerfDbgTag(tagDocBytesRead, "Doc", "Show bytes read on done")

MtDefine(CDefaultElement, Elements, "CDefaultElement")
MtDefine(OptionSettings, CDoc, "CDoc::_pOptionSettings")
MtDefine(OSCodePageAry_pv, OptionSettings, "CDoc::_pOptionSettings::aryCodePageSettings::_pv")
MtDefine(OSContextMenuAry_pv, OptionSettings, "CDoc::_pOptionSettings::aryContextMenuExts::_pv")
MtDefine(CPendingEvents, CDoc, "CDoc::_pPendingEvents")
MtDefine(CPendingEvents_aryPendingEvents_pv, CPendingEvents, "CDoc::_pPendingEvents::_aryPendingEvents::_pv")
MtDefine(CPendingEvents_aryEventType_pv, CPendingEvents, "CDoc::_pPendingEvents::_aryEventType::_pv")
MtDefine(CTimeoutEventList, CDoc, "CDoc::_TimeoutEvents")
MtDefine(CTimeoutEventList_aryTimeouts_pv, CTimeoutEventList, "CDoc::_TimeoutEvents::_aryTimeouts::_pv")
MtDefine(CTimeoutEventList_aryPendingTimeouts_pv, CTimeoutEventList, "CDoc::_TimeoutEvents::_aryPendingTimeouts::_pv")
MtDefine(CTimeoutEventList_aryPendingClears_pv, CTimeoutEventList, "CDoc::_TimeoutEvents::_aryPendingClears::_pv")
MtDefine(CDoc, Mem, "CDoc")
MtDefine(CDoc_arySitesUnDetached_pv, CDoc, "CDoc::_arySitesUnDetached::_pv")
MtDefine(CDoc_aryElementDeferredScripts_pv, CDoc, "CDoc::_aryElementDeferredScripts::_pv")
MtDefine(CDoc_aryElementReleaseNotify_pv, CDoc, "CDoc::_aryElementReleaseNotify::_pv")
MtDefine(CDoc_aryDefunctObjects_pv, CDoc, "CDoc::_aryDefunctObjects::_pv")
MtDefine(CDoc_aryChildDownloads_pv, CDoc, "CDoc::_aryChildDownloads::_pv")
MtDefine(CDoc_aryUndoData_pv, CDoc, "CDoc::_aryUndoData::_pv")
MtDefine(CDoc_aryUrlImgCtx_aryElems_pv, CDoc, "CDoc::_aryUrlImgCtx_aryElems::_pv")
MtDefine(CDoc_aryUrlImgCtx_pv, CDoc, "CDoc::_aryUrlImgCtx::_pv")
MtDefine(CDocEnumObjects_paryUnk, Locals, "CDoc::EnumObjects paryUnk")
MtDefine(CDocEnumObjects_paryUnk_pv, CDocEnumObjects_paryUnk, "CDoc::EnumObjects paryUnk::_pv")
MtDefine(CDragDropSrcInfo, ObjectModel, "CDragDropSrcInfo")
MtDefine(CDragDropTargetInfo, ObjectModel, "CDragDropTargetInfo")
MtDefine(CDocUpdateIntSink, CDoc, "CDoc::_pUpdateIntSink")
MtDefine(CDragStartInfo, ObjectModel, "CDragStartInfo")
MtDefine(CDoc_aryFocusItems_pv, CDoc, "CDoc::_aryFocusItems::_pv")
MtDefine(CDoc_aryAccessKeyItems_pv, CDoc, "CDoc::_aryAccessKeyItems::_pv")
MtDefine(LoadMSHTMLEd, PerfPigs, "Loading MSHTMLEd")
MtDefine(CDoc_aryDelayReleaseItems_pv, CDoc, "CDoc::_aryDelayReleaseItems::_pv")
MtDefine(CDoc_CLock, "CDoc", "CDoc::CLock")
MtDefine(CDoc_aryMarkupNotifyInPlace, CDoc, "CDoc::_aryMarkupNotifyInPlace")

//
//  Globals
//

// When we have more time I need to change pdlparser to generate externs
EXTERN_C const PROPERTYDESC_METHOD s_methdescCBasesetMember;
EXTERN_C const PROPERTYDESC_METHOD s_methdescCBasegetMember;
EXTERN_C const PROPERTYDESC_METHOD s_methdescCBaseremoveMember;


#define _cxx_
#include "document.hdl"

extern HRESULT  InitFormatCache(THREADSTATE *);

BOOL        g_fDocClassInitialized = FALSE;
BOOL        g_fInMoney98;
BOOL        g_fInHomePublisher98;
BOOL        g_fInWin98Discover;
int         g_iDragScrollDelay;
SIZE        g_sizeDragScrollInset;
int         g_iDragDelay;
int         g_iDragScrollInterval;
static char s_achWindows[] = "windows"; //  Localization: Do not localize
CCriticalSection g_csJitting;
BYTE g_bUSPJitState = JIT_OK;    //  For UniScribe JIT (USP10.DLL)
BYTE g_bJGJitState = JIT_OK;     //  JG ART library for AOL (JG*.DLL)
BOOL        g_fNoFileMenu = FALSE;      //  IEAK Restrictions

#ifdef  IE6_ROTATE

MAT         g_matUnit;      // the unit & zero matrix: zero rotation, no offset

#endif  // IE6_ROTATE

OLEMENUGROUPWIDTHS CDoc::s_amgw[] =
{
    { 0, 1, 0, 3, 0, 0 },   //  Design mode info
    { 0, 1, 0, 1, 0, 0 },   //  Run mode info
};


BEGIN_TEAROFF_TABLE(CDoc, IRequireClasses)
    TEAROFF_METHOD(CDoc, CountRequiredClasses, countrequiredclasses, (ULONG * pcClasses))
    TEAROFF_METHOD(CDoc, GetRequiredClasses, getrequiredclasses, (ULONG index, CLSID *pclsid))
END_TEAROFF_TABLE()

BEGIN_TEAROFF_TABLE(CDoc, IMarqueeInfo)
    TEAROFF_METHOD(CDoc, GetDocCoords, getdoccoords, (LPRECT pViewRect, BOOL bGetOnlyIfFullyLoaded, BOOL *pfFullyLoaded, int WidthToFormatPageTo))
END_TEAROFF_TABLE()

BEGIN_TEAROFF_TABLE(CDoc, IOleItemContainer)
    // IParseDisplayName methods
    TEAROFF_METHOD(CDoc, ParseDisplayName, parsedisplayname, (IBindCtx *pbc, LPOLESTR pszDisplayName,ULONG *pchEaten, IMoniker **ppmkOut))
    // IOleContainer methods
    TEAROFF_METHOD(CDoc, EnumObjects, enumobjects, (DWORD grfFlags, IEnumUnknown **ppenum))
    TEAROFF_METHOD(CDoc, LockContainer, lockcontainer, (BOOL fLock))
    // IOleItemContainer methods
    TEAROFF_METHOD(CDoc, GetObject, getobject, (LPTSTR pszItem, DWORD dwSpeedNeeded, IBindCtx *pbc, REFIID riid, void **ppvObject))
    TEAROFF_METHOD(CDoc, GetObjectStorage, getobjectstorage, (LPOLESTR pszItem, IBindCtx *pbc, REFIID riid, void **ppvStorage))
    TEAROFF_METHOD(CDoc, IsRunning, isrunning, (LPOLESTR pszItem))
END_TEAROFF_TABLE()


BEGIN_TEAROFF_TABLE(CDoc, IServiceProvider)
    TEAROFF_METHOD(CDoc, QueryService, queryservice, (REFGUID rsid, REFIID iid, void ** ppvObj))
END_TEAROFF_TABLE()

BEGIN_TEAROFF_TABLE(CDoc, IPersistFile)
    // IPersist methods
    TEAROFF_METHOD(CDoc, GetClassID, getclassid, (CLSID *))
    // IPersistFile methods
    TEAROFF_METHOD(CDoc, IsDirty, isdirty, ())
    TEAROFF_METHOD(CDoc, Load, load, (LPCOLESTR pszFileName, DWORD dwMode))
    TEAROFF_METHOD(CDoc, Save, save, (LPCOLESTR pszFileName, BOOL fRemember))
    TEAROFF_METHOD(CDoc, SaveCompleted, savecompleted, (LPCOLESTR pszFileName))
    TEAROFF_METHOD(CDoc, GetCurFile, getcurfile, (LPOLESTR *ppszFileName))
END_TEAROFF_TABLE()

BEGIN_TEAROFF_TABLE(CDoc, IPersistMoniker)
    // IPersist methods
    TEAROFF_METHOD(CDoc, GetClassID, getclassid, (LPCLSID lpClassID))
    // IPersistMoniker methods
    TEAROFF_METHOD(CDoc, IsDirty, isdirty, ())
    TEAROFF_METHOD(CDoc, Load, load, (BOOL fFullyAvailable, IMoniker *pmkName, LPBC pbc, DWORD grfMode))
    TEAROFF_METHOD(CDoc, Save, save, (IMoniker *pmkName, LPBC pbc, BOOL fRemember))
    TEAROFF_METHOD(CDoc, SaveCompleted, savecompleted, (IMoniker *pmkName, LPBC pibc))
    TEAROFF_METHOD(CDoc, GetCurMoniker, getcurmoniker, (IMoniker  **ppimkName))
END_TEAROFF_TABLE()

BEGIN_TEAROFF_TABLE(CDoc, IPersistHistory)
    // IPersist methods
    TEAROFF_METHOD(CDoc, GetClassID, getclassid, (LPCLSID lpClassID))
    // IPersistHistory methods
    TEAROFF_METHOD(CDoc, LoadHistory, loadhistory, (IStream *pStream, IBindCtx *pbc))
    TEAROFF_METHOD(CDoc, SaveHistory, savehistory, (IStream *pStream))
    TEAROFF_METHOD(CDoc, SetPositionCookie, setpositioncookie, (DWORD dwCookie))
    TEAROFF_METHOD(CDoc, GetPositionCookie, getpositioncookie, (DWORD *pdwCookie))
END_TEAROFF_TABLE()

BEGIN_TEAROFF_TABLE(CDoc, IHlinkTarget)
    TEAROFF_METHOD(CDoc, SetBrowseContext, setbrowsecontext, (IHlinkBrowseContext *pihlbc))
    TEAROFF_METHOD(CDoc, GetBrowseContext, getbrowsecontext, (IHlinkBrowseContext **ppihlbc))
    TEAROFF_METHOD(CDoc, Navigate, navigate, (DWORD grfHLNF, LPCWSTR wzJumpLocation))
    // NOTE: the following is renamed in tearoff to avoid multiple inheritance problem with IOleObject::GetMoniker
    TEAROFF_METHOD(CDoc, GetMonikerHlink, getmonikerhlink, (LPCWSTR wzLocation, DWORD dwAssign, IMoniker **ppimkLocation))
    TEAROFF_METHOD(CDoc, GetFriendlyName, getfriendlyname, (LPCWSTR wzLocation, LPWSTR *pwzFriendlyName))
END_TEAROFF_TABLE()


BEGIN_TEAROFF_TABLE(CDoc, ITargetContainer)
    TEAROFF_METHOD(CDoc, GetFrameUrl, getframeurl, (LPWSTR *ppszFrameSrc))
    TEAROFF_METHOD(CDoc, GetFramesContainer, getframescontainer, (IOleContainer **ppContainer))
END_TEAROFF_TABLE()

#ifndef WIN16
BEGIN_TEAROFF_TABLE(CDoc, IShellPropSheetExt)
    TEAROFF_METHOD(CDoc, AddPages, addpages, (LPFNADDPROPSHEETPAGE lpfnAddPage, LPARAM lParam))
    TEAROFF_METHOD(CDoc, ReplacePage, replacepage, (UINT uPageID, LPFNADDPROPSHEETPAGE lpfnReplaceWith, LPARAM lParam))
END_TEAROFF_TABLE()
#endif //!WIN16

BEGIN_TEAROFF_TABLE(CDoc, IObjectSafety)
    TEAROFF_METHOD(CDoc, GetInterfaceSafetyOptions, getinterfacesafetyoptions, (REFIID riid, DWORD *pdwSupportedOptions, DWORD *pdwEnabledOptions))
    TEAROFF_METHOD(CDoc, SetInterfaceSafetyOptions, setinterfacesafetyoptions, (REFIID riid, DWORD dwOptionSetMask, DWORD dwEnabledOptions))
END_TEAROFF_TABLE()

BEGIN_TEAROFF_TABLE(CDoc, IInternetHostSecurityManager)
    TEAROFF_METHOD(CDoc, HostGetSecurityId, hostgetsecurityid, (BYTE *pbSID, DWORD *pcb, LPCWSTR pwszDomain))
    TEAROFF_METHOD(CDoc, HostProcessUrlAction, hostprocessurlaction, (DWORD dwAction, BYTE *pPolicy, DWORD cbPolicy, BYTE *pContext, DWORD cbContext, DWORD dwFlags, DWORD dwReserved))
    TEAROFF_METHOD(CDoc, HostQueryCustomPolicy, hostquerycustompolicy, (REFGUID guidKey, BYTE **ppPolicy, DWORD *pcbPolicy, BYTE *pContext, DWORD cbContext, DWORD dwReserved))
END_TEAROFF_TABLE()

BEGIN_TEAROFF_TABLE(CDoc, ICustomDoc)
    TEAROFF_METHOD(CDoc, SetUIHandler, setuihandler, (IDocHostUIHandler * pUIHandler))
END_TEAROFF_TABLE()

BEGIN_TEAROFF_TABLE(CDoc, IAuthenticate)
    TEAROFF_METHOD(CDoc, Authenticate, authenticate, (HWND * phwnd, LPWSTR * pszUsername, LPWSTR * pszPassword))
END_TEAROFF_TABLE()

BEGIN_TEAROFF_TABLE(CDoc, IWindowForBindingUI)
    TEAROFF_METHOD(CDoc, GetWindowBindingUI, getwindowbindingui, (REFGUID rguidReason, HWND * phwnd))
END_TEAROFF_TABLE()

BEGIN_TEAROFF_TABLE(CDoc, IMarkupServices)
    TEAROFF_METHOD(CDoc, CreateMarkupPointer, createmakruppointer, (IMarkupPointer **ppPointer))
    TEAROFF_METHOD(CDoc, CreateMarkupContainer, createmarkupcontainer, (IMarkupContainer **ppMarkupContainer))
    TEAROFF_METHOD(CDoc, CreateElement, createelement, (ELEMENT_TAG_ID, OLECHAR *, IHTMLElement **))
    TEAROFF_METHOD(CDoc, CloneElement, cloneelement, (IHTMLElement *, IHTMLElement * *))
    TEAROFF_METHOD(CDoc, InsertElement, insertelement, (IHTMLElement *pElementInsert, IMarkupPointer *pPointerStart, IMarkupPointer *pPointerFinish))
    TEAROFF_METHOD(CDoc, RemoveElement, removeelement, (IHTMLElement *pElementRemove))
    TEAROFF_METHOD(CDoc, Remove, remove, (IMarkupPointer *, IMarkupPointer *))
    TEAROFF_METHOD(CDoc, Copy, copy, (IMarkupPointer *, IMarkupPointer *, IMarkupPointer *))
    TEAROFF_METHOD(CDoc, Move, move, (IMarkupPointer *, IMarkupPointer *, IMarkupPointer *))
    TEAROFF_METHOD(CDoc, InsertText, inserttext, (OLECHAR *, long, IMarkupPointer *))
    TEAROFF_METHOD(CDoc, ParseString, parsestring, (OLECHAR *, DWORD, IMarkupContainer **, IMarkupPointer *, IMarkupPointer *))
    TEAROFF_METHOD(CDoc, ParseGlobal, parseglobal, (HGLOBAL, DWORD, IMarkupContainer **, IMarkupPointer *, IMarkupPointer *))
    TEAROFF_METHOD(CDoc, IsScopedElement, isscopedelement, (IHTMLElement *, BOOL *))
    TEAROFF_METHOD(CDoc, GetElementTagId, getelementtagid, (IHTMLElement *, ELEMENT_TAG_ID *))
    TEAROFF_METHOD(CDoc, GetTagIDForName, gettagidforname, (BSTR, ELEMENT_TAG_ID *))
    TEAROFF_METHOD(CDoc, GetNameForTagID, getnamefortagid, (ELEMENT_TAG_ID, BSTR *))
    TEAROFF_METHOD(CDoc, MovePointersToRange, movepointerstorange, (IHTMLTxtRange *, IMarkupPointer *, IMarkupPointer *))
    TEAROFF_METHOD(CDoc, MoveRangeToPointers, moverangetopointers, (IMarkupPointer *, IMarkupPointer *, IHTMLTxtRange *))
    TEAROFF_METHOD(CDoc, BeginUndoUnit, beginundounit, (OLECHAR *))
    TEAROFF_METHOD(CDoc, EndUndoUnit, beginundounit, ())
END_TEAROFF_TABLE()

BEGIN_TEAROFF_TABLE(CDoc, IHTMLViewServices)
    TEAROFF_METHOD(CDoc, MoveMarkupPointerToPoint, movemarkuppointertopoint, (POINT pt, IMarkupPointer *pPointer, BOOL * pfNotAtBOL, BOOL * pfAtLogicalBOL, BOOL * pfRightOfCp, BOOL fScrollIntoView))
    TEAROFF_METHOD(CDoc, MoveMarkupPointerToPointEx, movemarkuppointertopointex, (POINT pt, IMarkupPointer *pPointer, BOOL fGlobalCoordinates, BOOL * pfNotAtBOL, BOOL * pfAtLogicalBOL, BOOL * pfRightOfCp, BOOL fScrollIntoView))
    TEAROFF_METHOD(CDoc, MoveMarkupPointerToMessage, movemarkuppointertomessage, ( IMarkupPointer *pPointer, SelectionMessage * pMessage, BOOL * pfNotAtBOL, BOOL * pfAtLogicalBOL, BOOL * pfRightOfCp, BOOL * pfValidTree, BOOL fScrollIntoView, IHTMLElement* pIContainerElement, BOOL* pfSameLayout, BOOL fHitTestEOL ))
    TEAROFF_METHOD(CDoc, GetCharFormatInfo, getcharformatinfo, (IMarkupPointer *pPointer, WORD family, HTMLCharFormatData *pInfo))
    TEAROFF_METHOD(CDoc, GetLineInfo, getlineinfo, (IMarkupPointer *pPointer, BOOL fAtEndOfLine, HTMLPtrDispInfoRec *pInfo))
    TEAROFF_METHOD(CDoc, IsPointerBetweenLines, ispointerbetweenlines,  (IMarkupPointer* pPointer, BOOL* pfBetweenLines))
    TEAROFF_METHOD(CDoc, GetElementsInZOrder, getelementsinzorder, (POINT pt, IHTMLElement **rgElements, DWORD *pCount))
    TEAROFF_METHOD(CDoc, GetTopElement, gettopelement, (POINT pt, IHTMLElement **ppElement))
    TEAROFF_METHOD(CDoc, MoveMarkupPointer, movemarkuppointer, (IMarkupPointer *pPointer, LAYOUT_MOVE_UNIT eUnit, LONG lXCurReally, BOOL* fNotAtBOL, BOOL* fAtLogicalBOL ))
    TEAROFF_METHOD(CDoc, RegionFromMarkupPointers, regionfrommarkuppointers, (IMarkupPointer *pPointerStart, IMarkupPointer *pPointerEnd, HRGN *phrgn))
    TEAROFF_METHOD(CDoc, GetCurrentSelectionRenderingServices, getcurrentselectionrenderingservices, ( ISelectionRenderingServices ** ppSelRenSvc ))
    TEAROFF_METHOD(CDoc, GetCurrentSelectionSegmentList, getcurrentsegmentlist , ( ISegmentList **ppSegmentList ))
    TEAROFF_METHOD(CDoc, FireOnSelectStart, fireonselectstart , (IHTMLElement* pIElement ))
    TEAROFF_METHOD(CDoc, FireCancelableEvent, firecancelableevent, (IHTMLElement * pIElement, LONG dispidMethod, LONG dispidProp, BSTR bstrEventType, BOOL * pfResult))
    TEAROFF_METHOD(CDoc, GetCaret, getcaret, ( IHTMLCaret ** ppCaret ))
    TEAROFF_METHOD(CDoc, ConvertVariantFromHTMLToTwips, convertvariantfromhtmltotwips, (VARIANT *pvar))
    TEAROFF_METHOD(CDoc, ConvertVariantFromTwipsToHTML, convertvariantfromtwipstohtml, (VARIANT *pvar))
    TEAROFF_METHOD(CDoc, IsBlockElement, isblockelement, ( IHTMLElement * pIElement, BOOL * pfResult ))
    TEAROFF_METHOD(CDoc, IsLayoutElement, islayoutelement, ( IHTMLElement * pIElement, BOOL * pfResult ))
    TEAROFF_METHOD(CDoc, IsContainerElement, iscontainerelement, ( IHTMLElement * pIElement, BOOL * pfContainer, BOOL *pfHTML ))
    TEAROFF_METHOD(CDoc, GetFlowElement, getflowelement, ( IMarkupPointer * pIPointer, IHTMLElement  ** ppIElement ))
    TEAROFF_METHOD(CDoc, GetElementFromCookie, getelementfromcookie, ( void* elementCookie , IHTMLElement  ** ppIElement))
    TEAROFF_METHOD(CDoc, AddElementAdorner, addelementadorner, ( IHTMLElement* pElement, IElementAdorner* pElementAdorner, DWORD_PTR* ppeAdornerCookie ))
    TEAROFF_METHOD(CDoc, RemoveElementAdorner, removeelementadorner, ( DWORD_PTR eAdornerCookie ))
    TEAROFF_METHOD(CDoc, GetElementAdornerBounds, getelementadornerbounds, ( DWORD_PTR eAdornerCookie, RECT* pRectBounds ))
    TEAROFF_METHOD(CDoc, InflateBlockElement, inflateblockelement, (IHTMLElement * pElem ))
    TEAROFF_METHOD(CDoc, IsInflatedBlockElement, isinflatedblockelement, (IHTMLElement * pElem , BOOL * pfIsInflated ))
    TEAROFF_METHOD(CDoc, IsMultiLineFlowElement, ismultilineflowelement, (IHTMLElement * pIElement, BOOL * fMultiLine ))
    TEAROFF_METHOD(CDoc, GetElementAttributeCount, getelementattributecount, (IHTMLElement * pIElement, UINT * pCount ))
    TEAROFF_METHOD(CDoc, IsEditableElement, iseditableelement, ( IHTMLElement * pIElement, BOOL * pfResult ))
    TEAROFF_METHOD(CDoc, GetOuterContainer, getoutercontainer, ( IHTMLElement* pIElement, IHTMLElement** ppIOuterElement, BOOL fIgnoreOutermostContainer, BOOL * pfHitContainer    ))
    TEAROFF_METHOD(CDoc, IsNoScopeElement, isnoscopeelement, ( IHTMLElement * pIElement, BOOL * pfResult ))  
    TEAROFF_METHOD(CDoc, ShouldObjectHaveBorder, shouldobjecthaveborder, (IHTMLElement* pIElement, BOOL* pfDrawBorder ) )
    TEAROFF_METHOD(CDoc, DoTheDarnPasteHTML, dothedarnpastehtml, ( IMarkupPointer*, IMarkupPointer*, HGLOBAL))
    TEAROFF_METHOD(CDoc, ConvertRTFToHTML, convertrtftohtml, ( LPOLESTR pszRtf, HGLOBAL* phglobalHTML))
    TEAROFF_METHOD(CDoc, GetViewHWND, getviewhwnd, ( HWND* pHWND ))
    TEAROFF_METHOD(CDoc, GetActiveIMM, getactiveimm, ( IActiveIMMApp **ppActiveIMM ))
    TEAROFF_METHOD(CDoc, IsRtfConverterEnabled, isrtfconvertenabled, ( BOOL* pfEnabled ))
    TEAROFF_METHOD(CDoc, ScrollElement, scrollelement, ( IHTMLElement* pIElement, LONG lPercentToScroll, POINT * pScrollDelta    ))
    TEAROFF_METHOD(CDoc, GetScrollingElement, getscrollingelement, (IMarkupPointer* pPosition, IHTMLElement* pBoundary, IHTMLElement** ppElement ))          
    TEAROFF_METHOD(CDoc, StartHTMLEditorDblClickTimer, starthtmleditordblclicktimer, ( ))
    TEAROFF_METHOD(CDoc, StopHTMLEditorDblClickTimer, stophtmleditordblclicktimer, ( ))    
    TEAROFF_METHOD(CDoc, HTMLEditorTakeCapture, htmleditortakecapture, ( ))
    TEAROFF_METHOD(CDoc, HTMLEditorReleaseCapture, htmleditorreleasecapture, ( ))
    TEAROFF_METHOD(CDoc, SetHTMLEditorMouseMoveTimer, sethtmleditormousemovetimer, ( ))       

    TEAROFF_METHOD(CDoc, GetEditContext, geteditcontext, ( 
                                                            IHTMLElement* pIStartElement, 
                                                            IHTMLElement** ppIEditThisElement, 
                                                            IMarkupPointer* pIStart, 
                                                            IMarkupPointer* pIEnd, 
                                                            BOOL fDrillingIn,  
                                                            BOOL * pfEditThisEditable ,
                                                            BOOL * pfEditParentEditable ,
                                                            BOOL * pfNoScopeElement))         

    TEAROFF_METHOD(CDoc, EnsureEditContext, ensureeditcontext, ( IMarkupPointer* pIPointer ))                                                            
    TEAROFF_METHOD(CDoc, ScrollPointerIntoView, scrollpointerintoview, ( IMarkupPointer * pPointer, BOOL fNotAtBOL, POINTER_SCROLLPIN eScrollAmount  ))
    TEAROFF_METHOD(CDoc, ScrollPointIntoView, scrollpointintoview, ( IHTMLElement* pIElement , POINT* ptGlobal ))
    
    TEAROFF_METHOD(CDoc, ArePointersInSameMarkup, arepointersinsamemarkup, ( IMarkupPointer * pP1, IMarkupPointer * pP2, BOOL * pfSameMarkup ))
    TEAROFF_METHOD(CDoc, DragElement, dragelement, ( IHTMLElement* pIElement, DWORD dwKeyState ))
    TEAROFF_METHOD(CDoc, BecomeCurrent, becomecurrent, ( IHTMLElement *     pIElement,
                                                         SelectionMessage * pSelMessage))
    TEAROFF_METHOD(CDoc, TransformPoint, transformpoint, ( POINT        * pPoint, 
                                                           COORD_SYSTEM eSource, 
                                                           COORD_SYSTEM eDestination, 
                                                           IHTMLElement * pIElement ))
    TEAROFF_METHOD(CDoc, GetElementDragBounds, getelementdragbounds, ( IHTMLElement* pIElement,
                                                                       RECT* pIElementDragBounds ))                                                                         
    TEAROFF_METHOD(CDoc, UpdateAdorner, updateadorner, ( DWORD_PTR eAdornerCookie)) 
    TEAROFF_METHOD(CDoc, InvalidateAdorner, invalidateadorner, (DWORD_PTR eAdornerCookie))     
    TEAROFF_METHOD(CDoc, ScrollIntoView, scrollintoview, (DWORD_PTR peCookie))
    TEAROFF_METHOD(CDoc, IsElementLocked, iselementlocked, (IHTMLElement* pIElement, \
                                                            BOOL* pfLocked))   
    TEAROFF_METHOD(CDoc, MakeParentCurrent, makeparentcurrent, ( IHTMLElement* pIElement ))                                                             
    TEAROFF_METHOD(CDoc, FireOnBeforeEditFocus, fireonbeforeeditfocus, (IHTMLElement *pINextActiveElem, BOOL *pfRet)) 
    TEAROFF_METHOD(CDoc, IsEqualElement , isequalelement, (IHTMLElement* pIElement1, IHTMLElement* pIElement2 ))
    TEAROFF_METHOD(CDoc, GetOuterMostEditableElement, getoutermosteditableelement , ( IHTMLElement* pIEditableElement, 
                                                                                    IHTMLElement** ppIOuterEditableElement))       
    TEAROFF_METHOD(CDoc, IsSite, issite, ( IHTMLElement * pElement, BOOL* pfSite, BOOL* pfText, BOOL* pfMultiLine, BOOL* pfScrollable ))
    TEAROFF_METHOD(CDoc, QueryBreaks, querybreaks, (IMarkupPointer * pPointer, DWORD * pdwBreaks, BOOL fWantPendingBreak ))
    TEAROFF_METHOD(CDoc, MergeDeletion, mergedeletion, (IMarkupPointer * pPointer ))
    TEAROFF_METHOD(CDoc, GetElementForSelection , getelementforselection, ( IHTMLElement * pElement, IHTMLElement** ppISiteSelectableElement ))
    TEAROFF_METHOD(CDoc, IsContainedBy, iscontainedby, ( IMarkupContainer* pIOuterContainer, IMarkupContainer* pIInnerContainer ))
    TEAROFF_METHOD(CDoc, CurrentScopeOrSlave, currentscopoeorslave, ( IMarkupPointer * pPointer, IHTMLElement ** ppElemCurrent ))
    TEAROFF_METHOD(CDoc, LeftOrSlave, leftorslave, ( IMarkupPointer * pPointer, BOOL fMove, MARKUP_CONTEXT_TYPE *pContext, IHTMLElement** ppElement, long *pcch, OLECHAR* pchText))
    TEAROFF_METHOD(CDoc, RightOrSlave, rightorslave, ( IMarkupPointer * pPointer, BOOL fMove, MARKUP_CONTEXT_TYPE *pContext, IHTMLElement** ppElement, long *pcch, OLECHAR* pchText))
    TEAROFF_METHOD(CDoc, MoveToContainerOrSlave, movetocontainerorslave, ( IMarkupPointer *pPointer, IMarkupContainer* pContainer, BOOL fAtStart))
    TEAROFF_METHOD(CDoc, MergeAttributes, mergeattributes, (IHTMLElement *pIHTMLElementMergeTarget, IHTMLElement *pIHTMLElementMergeSrc, BOOL fCopyId))
    TEAROFF_METHOD(CDoc, FindUrl, findurl, (IMarkupPointer* pStart, IMarkupPointer* pEnd, IMarkupPointer* pUrlStart, IMarkupPointer* pUrlEnd))
    TEAROFF_METHOD(CDoc, IsEnabled, isenabled, ( IHTMLElement* pIElement, BOOL* pfEnabled))
    TEAROFF_METHOD(CDoc, GetElementBlockDirection, getelementblockdirection, (IHTMLElement *pElement, BSTR *pbstrDir))
    TEAROFF_METHOD(CDoc, SetElementBlockDirection, setelementblockdirection, (IHTMLElement *pElement, LONG eHTMLDir))
    TEAROFF_METHOD(CDoc, IsBidiEnabled, isbidienabled, ( BOOL* pfEnabled))
    TEAROFF_METHOD(CDoc, SetDocDirection, setdocdirection, (LONG eHTMLDir))
    TEAROFF_METHOD(CDoc, AllowSelection, allowselection, ( IHTMLElement* pIElement, SelectionMessage* peMessage)) 
    TEAROFF_METHOD(CDoc, MoveWord , moveword , ( IMarkupPointer * pPointerToMove, MOVEUNIT_ACTION  muAction, IMarkupPointer * pLeftBoundary, IMarkupPointer * pRightBoundary ))
    TEAROFF_METHOD(CDoc, GetAdjacencyForPoint, getadjacencyforpoint, ( IHTMLElement* pIElement, POINT ptGlobal, ELEMENT_ADJACENCY *peAdjacent  ))    
#ifndef UNIX
    TEAROFF_METHOD(CDoc, SaveSegmentsToClipboard , savesegmentstoclipboard , ( ISegmentList * pSegmentList ))
#else
    TEAROFF_METHOD(CDoc, SaveSegmentsToClipboard , savesegmentstoclipboard , ( ISegmentList * pSegmentList, VARIANTARG * pvarargOut ))
#endif
    TEAROFF_METHOD(CDoc, InsertMaximumText, insertmaximumtext, ( OLECHAR* pstrText, LONG cch, IMarkupPointer* pMarkupPointer ))
    TEAROFF_METHOD(CDoc, IsInsideURL , isinsideurl , ( IMarkupPointer*, IMarkupPointer*, BOOL* ))
    TEAROFF_METHOD(CDoc, GetDocHostUIHandler , getdochostuihandler , ( IDocHostUIHandler** ))
    TEAROFF_METHOD(CDoc, GetClientRect , getclientrect , ( IHTMLElement* pIElement, COORD_SYSTEM eSource, RECT* pRect ))    
    TEAROFF_METHOD(CDoc, GetContentRect , getcontentrect , ( IHTMLElement* pIElement, COORD_SYSTEM eSource, RECT* pRect ))        
    TEAROFF_METHOD(CDoc, IsElementSized, iselementsized, ( IHTMLElement* pIElement, BOOL* pfSized ))    
    TEAROFF_METHOD(CDoc, GetLineDirection, getlinedirection, (IMarkupPointer *pPointer, BOOL fAtEndOfLine, long *peHTMLDir))
END_TEAROFF_TABLE()

#if TREE_SYNC
BEGIN_TEAROFF_TABLE(CDoc, IMarkupSyncServices)
    TEAROFF_METHOD(CDoc, GetCpFromPointer, getcpfrompointer, (IMarkupPointer * pPointer, long * pcp ))
    TEAROFF_METHOD(CDoc, MovePointerToCp, movepointertocp, (IMarkupPointer * pPointer, long cp, IMarkupContainer * pIContainer ))
    TEAROFF_METHOD(CDoc, RegisterLogSink, registerlogsink, (IMarkupSyncLogSink * pLogSink ))
    TEAROFF_METHOD(CDoc, UnregisterLogSink, unregisterlogsink, (IMarkupSyncLogSink * pLogSink ))
END_TEAROFF_TABLE()
#endif // TREE_SYNC

#ifdef XMV_PARSE
BEGIN_TEAROFF_TABLE(CDoc, IXMLGenericParse)
    TEAROFF_METHOD(CDoc, SetGenericParse, setgenericparse, (VARIANT_BOOL fDoGeneric))
END_TEAROFF_TABLE()
#endif

#if DBG == 1
    //
    // IEditDebugServices Methods
    //
BEGIN_TEAROFF_TABLE( CDoc, IEditDebugServices)
    TEAROFF_METHOD( CDoc, GetCp, getcp , ( IMarkupPointer* pIPointer, long* pcp))                                                
    TEAROFF_METHOD( CDoc, SetDebugName, setdebugname, ( IMarkupPointer* pIPointer, LPCTSTR strDebugName ))
    TEAROFF_METHOD( CDoc, DumpTree , dumptree, ( IMarkupPointer* pIPointer))
END_TEAROFF_TABLE()   
#endif // IEditDebugServices

// GetData format information
// note: the LINKSRCDESCRIPTOR and OBJECTDESCRIPTOR are identical structures
//       so we use the OBJECTDESCRIPTOR get/set fns for both.

FORMATETC CDoc::s_GetFormatEtc[] =
{
    STANDARD_FMTETCGET
//  { cfFormat,                         ptd,  dwAspect,   lindex,  tymed },
    { CF_COMMON(ICF_LINKSRCDESCRIPTOR), NULL, DVASPECT_CONTENT, -1L, TYMED_HGLOBAL },
    { CF_COMMON(ICF_LINKSRCDESCRIPTOR), NULL, DVASPECT_ICON, -1L, TYMED_HGLOBAL },
    { CF_COMMON(ICF_LINKSOURCE),        NULL, DVASPECT_CONTENT, -1L, TYMED_ISTREAM },
    { CF_COMMON(ICF_LINKSOURCE),        NULL, DVASPECT_ICON, -1L, TYMED_ISTREAM },
    { CF_TEXT,                          NULL, DVASPECT_CONTENT, -1L, TYMED_ISTREAM },
    { CF_TEXT,                          NULL, DVASPECT_ICON, -1L, TYMED_ISTREAM },
#ifndef WIN16
    { CF_UNICODETEXT,                   NULL, DVASPECT_CONTENT, -1L, TYMED_ISTREAM },
    { CF_UNICODETEXT,                   NULL, DVASPECT_ICON, -1L, TYMED_ISTREAM },
#endif //!WIN16
#ifndef NO_RTF
    { (WORD)RegisterClipboardFormat(_T("CF_RTF")),    NULL, DVASPECT_CONTENT, -1L, TYMED_ISTREAM },
    { (WORD)RegisterClipboardFormat(_T("CF_RTF")),    NULL, DVASPECT_ICON, -1L, TYMED_ISTREAM },
#endif // ndef NO_RTF
};

CServer::LPFNGETDATA CDoc::s_GetFormatFuncs[] =
{
    STANDARD_PFNGETDATA
    &CServer::GetOBJECTDESCRIPTOR,  //  Actually LINKSRCDESCRIPTOR
    &CServer::GetOBJECTDESCRIPTOR,  //  Actually LINKSRCDESCRIPTOR
    &CServer::GetLINKSOURCE,
    &CServer::GetLINKSOURCE,
    &CDoc::GetTEXT,
    &CDoc::GetTEXT,
#ifdef UNICODE
    &CDoc::GetUNICODETEXT,
    &CDoc::GetUNICODETEXT,
#endif // UNICODE
#ifndef NO_RTF
    &CDoc::GetRTF,
    &CDoc::GetRTF,
#endif // !NO_RTF
};

#ifndef NO_PROPERTY_PAGE
const CLSID * CDoc::s_apClsidPages[] =
{
    // Browse-time Pages
    &CLSID_CDocBrowsePropertyPage,
    NULL,
    // Edit-time Pages
#if DBG==1    
    &CLSID_CCDGenericPropertyPage,
#endif // DBG==1    
    NULL
};
#endif // NO_PROPERTY_PAGE


const CServer::CLASSDESC CDoc::s_classdesc =
{
    {                                            // _classdescBase
        &CLSID_HTMLDocument,                     // _pclsid
        IDR_BASE_HTMLFORM,                       // _idrBase
#ifndef NO_PROPERTY_PAGE
        s_apClsidPages,                          // _apClsidPages
#endif // NO_PROPERTY_PAGE
        s_acpi,                                  // _pcpi
        SERVERDESC_CREATE_UNDOMGR |              // _dwFlags
        SERVERDESC_ACTIVATEONDRAG |
        SERVERDESC_SUPPORT_DRAG_DROP |
        SERVERDESC_HAS_MENU |
        SERVERDESC_HAS_TOOLBAR,
        &IID_IHTMLDocument2,                     // _piidDispinterface
        &s_apHdlDescs,                           // _apHdlDesc
    },
    MISC_STATUS_FORM,                            // _dwMiscStatus
    0,                                           // _dwViewStatus
    ARRAY_SIZE(g_aOleVerbStandard),              // _cOleVerbTable
    g_aOleVerbStandard,                          // _pOleVerbTable
    g_apfnDoVerbStandard,                        // _pfnDoVerb
    ARRAY_SIZE(s_GetFormatFuncs),                // _cGetFmtTable
    s_GetFormatEtc,                              // _pGetFmtTable
    s_GetFormatFuncs,                            // _pGetFuncs
    0,                                           // _cSetFmtTable
    NULL,                                        // _pSetFmtTable
    NULL,                                        // _pSetFuncs
    OFFSETOFITF(CDoc, IHTMLDocument2),           // _ibItfPrimary
    DISPID_UNKNOWN,                              // _dispidRowset
    0,                                           // _wVFFlags  (match Value property typelib)
    DISPID_UNKNOWN,                              // _dispIDBind
    ~0UL,                                        // _uGetBindIndex
    ~0UL,                                        // _uPutBindIndex
    VT_EMPTY,                                    // _vtBindType
    ~0UL,                                        // _uGetValueIndex
    ~0UL,                                        // _uPutValueIndex
    VT_EMPTY,                                    // _vtValueType
    ~0UL,                                        // _uSetRowset
    0,                                           // _sef
    //{                                            // _se
    //    (PFN_CLICK)     NULL,                    // pfnClick
    //    (PFN_DBLCLICK)  NULL,                    // pfnDblClick
    //    (PFN_KEYDOWN)   &IFormEvents::KeyDown,   // pfnKeyDown
    //    (PFN_KEYUP)     &IFormEvents::KeyUp,     // pfnKeyUp
    //    (PFN_KEYPRESS)  &IFormEvents::KeyPress,  // pfnKeyPress
    //    (PFN_MOUSEDOWN) NULL,                    // pfnMouseDown
    //    (PFN_MOUSEUP)   NULL,                    // pfnMouseUp
    //    (PFN_MOUSEMOVE) NULL,                    // pfnMouseMove
    //    (PFN_CHANGE)    NULL,                    // pfnChange
    //    (PFN_ERROR)     &IFormEvents::Error,     // pfnError
    //    (PFN_BEFOREDRAGOVER) NULL,               // pfnBeforeDragOver
    //    (PFN_BEFOREDROP)     NULL,               // pfnBeforeDrop
    //},
};


#if DBG == 1
void DebugDocStartupCheck()
{
    // verify CLIENTLAYERS and BEHAVIORRENDERINFO constants are in sync
    Assert(CLIENTLAYERS_BEFOREBACKGROUND    == BEHAVIORRENDERINFO_BEFOREBACKGROUND);
    Assert(CLIENTLAYERS_AFTERBACKGROUND     == BEHAVIORRENDERINFO_AFTERBACKGROUND);
    Assert(CLIENTLAYERS_BEFORECONTENT       == BEHAVIORRENDERINFO_BEFORECONTENT);
    Assert(CLIENTLAYERS_AFTERCONTENT        == BEHAVIORRENDERINFO_AFTERCONTENT);
    Assert(CLIENTLAYERS_AFTERFOREGROUND     == BEHAVIORRENDERINFO_AFTERFOREGROUND);

    Assert(CLIENTLAYERS_DISABLEBACKGROUND   == BEHAVIORRENDERINFO_DISABLEBACKGROUND);
    Assert(CLIENTLAYERS_DISABLENEGATIVEZ    == BEHAVIORRENDERINFO_DISABLENEGATIVEZ);
    Assert(CLIENTLAYERS_DISABLECONTENT      == BEHAVIORRENDERINFO_DISABLECONTENT);
    Assert(CLIENTLAYERS_DISABLEPOSITIVEZ    == BEHAVIORRENDERINFO_DISABLEPOSITIVEZ);
}
#endif

//+---------------------------------------------------------------
//
//  Member:     InitDocClass
//
//  Synopsis:   Initializes the CDoc class
//
//  Returns:    TRUE iff the class could be initialized successfully
//
//  Notes:      This method initializes the verb tables in the
//              class descriptor.  Called by the LibMain
//              of the DLL.
//
//---------------------------------------------------------------

HRESULT
InitDocClass()
{
    if (!g_fDocClassInitialized)
    {
        LOCK_GLOBALS;

        // If another thread completed initialization while this thread waited
        // for the global lock, immediately return
        //
        if (g_fDocClassInitialized)
            return(S_OK);

        int     i;

        // Fetch parameters from the registry.  Use GetProfileIntA because
        // its faster on Win95 and the strings are smaller.
        //
        // CONSIDER: centralize this stuff and update on profile change.
        //
        // BUGBUG: Confirm that GetProfileInt calls are actually fetching
        // profile data. (Are these the APIs to use? Are the key names correct?)
        //
        //  Localization: Do not localize the profile strings below.
        //

        i = GetProfileIntA(s_achWindows, "DragScrollInset", DD_DEFSCROLLINSET);
        g_sizeDragScrollInset.cx = i;
        g_sizeDragScrollInset.cy = i;
        g_iDragScrollDelay = GetProfileIntA(
                s_achWindows,
                "DragScrollDelay",
                DD_DEFSCROLLDELAY);

#ifndef _MAC
        g_iDragDelay = GetProfileIntA(
                s_achWindows,
                "DragDelay",
                DD_DEFDRAGDELAY),
#else
        g_iDragDelay = GetProfileIntA(s_achWindows, "DragDelay", 20),
#endif

        g_iDragScrollInterval = GetProfileIntA(
                s_achWindows,
                "DragScrollInterval",
                DD_DEFSCROLLINTERVAL);

        SetCommonClipFormats(
                CDoc::s_GetFormatEtc,
                ARRAY_SIZE(CDoc::s_GetFormatEtc));

        char szModule[MAX_PATH];
        GetModuleFileNameA(NULL, szModule, MAX_PATH);
        g_fInMoney98         =  NULL != StrStrIA(szModule, "msmoney.exe")
                            ||  IsTagEnabled(tagCompatMsMoney);
        g_fInHomePublisher98 =  NULL != StrStrIA(szModule, "homepub.exe")
#if DBG==1
                            ||  NULL != StrStrIA(szModule, "homepubd.exe")
#endif
                            ;
        // discover.exe is too common. We wanted to use the version resource to
        // figure out that this was from win98, but it turns out that not only
        // does every different language have a different version number,
        // every one stores the resource in a different character set.
        // We hack and just look for "tour\discover.exe".
        if (NULL != StrStrIA(szModule, "discover.exe"))
        {
            HINSTANCE hInst;
            hInst = GetModuleHandle(NULL);
            if (hInst)
            {
                char achPath[MAX_PATH];
                char *sz;

                if (GetModuleFileNameA( hInst, achPath, sizeof(achPath) ))
                {
                    // Compare the last part of the full path.
                    sz = achPath + strlen(achPath) - strlen("\\tour\\discover.exe");
                    g_fInWin98Discover = NULL != StrStrIA(achPath, "\\tour\\discover.exe");
                }
            }
        }

        // Read restrictions from registry
        DWORD dwSize, dwType, dw;
        dwSize = sizeof(dw);
        if (ERROR_SUCCESS == SHGetValue(HKEY_CURRENT_USER, EXPLORER_REG_KEY, NO_FILE_MENU_RESTR,
                                        &dwType, &dw, &dwSize))
        {
            g_fNoFileMenu = dw;
        }

#ifdef  IE6_ROTATE

        g_matUnit.Init();

#endif  // IE6_ROTATE

        g_fDocClassInitialized = TRUE;
    }

    return(S_OK);
}

//+---------------------------------------------------------------
//
//  Member:     CDefaultElement
//
//---------------------------------------------------------------

const CElement::CLASSDESC CDefaultElement::s_classdesc =
{
    {
        NULL,                   // _pclsid
        0,                      // _idrBase
#ifndef NO_PROPERTY_PAGE
        0,                      // _apClsidPages
#endif // NO_PROPERTY_PAGE
        NULL,                   // _pcpi
        0,                      // _dwFlags
        NULL,                   // _piidDispinterface
        NULL
    },
    NULL,
    NULL,                       // _paccelsDesign
    NULL                        // _paccelsRun
};

CDefaultElement::CDefaultElement ( CDoc * pDoc )
  : CElement ( ETAG_DEFAULT, pDoc )
{
}

//+---------------------------------------------------------------
//
//  Member:     CDoc::CDoc, protected
//
//  Synopsis:   Constructor for the CDoc class
//
//  Arguments:  [pUnkOuter] -- the controlling unknown or NULL if we are
//                             not being created as part of an aggregate
//
//  Notes:      This is the first part of a two-stage construction process.
//              The second part is in the Init method.  Use the static
//              Create method to properly instantiate an CDoc object
//
//---------------------------------------------------------------

#pragma warning(disable:4355)   // 'this' argument to base-member init list

CDoc::CDoc(LPUNKNOWN pUnkOuter, DOCTYPE doctype)
  : CServer(pUnkOuter, doctype == DOCTYPE_CHROME), _HtPvPv()
{
    Assert( g_fDocClassInitialized );
    Assert( _pUrlHistoryStg == NULL );
    Assert( _safetylevel == SAFETY_NOTSET );
    Assert( ! _hwndCached );
    Assert( ! _fDeferredScripts );
    Assert( !_fUIHandlerSet );

    //
    //
    //

#ifdef WIN16
    m_baseOffset = ((BYTE *) (void *) (CBase *)this) - ((BYTE *) this);
#endif

    _dwTID = GetCurrentThreadId();
    TraceTag((tagCDoc, "%lx constructing CDoc SSN=0x%x TID=0x%x", this, _ulSSN, _dwTID));

    //
    // Start things off with the cache invalid.
    // The tree version is initialized to 1 so that other versions can be
    // initialized to 0 to automatically sugest invalidness.
    //

    __lDocTreeVersion = 1;
    __lDocContentsVersion = 1;

    //
    // Initialize the document to a default size
    //

    // NB (cthrash) Start at an absolute pixel size.  Compute the himetric
    // based on that, rather than the reverse.  This reduces rounding errors.

    {
        SIZEL sizelDefault;

        sizelDefault.cx = MulDivQuick( 100, 2540, g_sizePixelsPerInch.cx );
        sizelDefault.cy = MulDivQuick( 100, 2540, g_sizePixelsPerInch.cy );

        _dci.CTransform::Init(sizelDefault);
        _dci._pDoc = this;
    }

    Assert( ! _pElemCurrent );
    Assert( ! _pElemUIActive );

    _view.Initialize(this);

    _fEnabled = TRUE;

    _fShownSpin = TRUE;
    _fIsUpToDate = TRUE;
    _iStatusTop = STL_LAYERS;

    _fInheritDesignMode = TRUE;
    _sizelGrid.cx = GRIDX_DEFAULTVALUE;
    _sizelGrid.cy = GRIDY_DEFAULTVALUE;

    _fExpando = EXPANDOS_DEFAULT;

    // Support for document-level object safety settings.

    _fFullWindowEmbed = doctype == DOCTYPE_FULLWINDOWEMBED;
    _fTrustedDoc = doctype == DOCTYPE_HTA;
    _fMhtmlDoc = doctype == DOCTYPE_MHTML;

    _fEnableInteraction = TRUE;

    _sBaselineFont = BASELINEFONTDEFAULT;

    // Internationalization
    _codepage = _codepageURL = _codepageFamily = g_cpDefault;

    _triOMOffscreenOK = -1; // set offscreen to auto

    _cstrUrl.Set(_T("about:blank"));
    _cstrCOMPAT_OMUrl.Set(_T(""));

    // Append to thread doc array
    TLS(_paryDoc).Append(this);

    MemSetName((this, "CDoc SSN=%d", _ulSSN));

    // Register the window message (if not registered)
    if(_g_msgHtmlGetobject == 0)
    {
        _g_msgHtmlGetobject = RegisterWindowMessage(MSGNAME_WM_HTML_GETOBJECT);
        Assert(_g_msgHtmlGetobject != 0);
    }
#if !defined(NO_IME) && defined(IME_RECONVERSION)
    if (   g_dwPlatformVersion < 0x4000a
        && _g_msgImeReconvert == 0)
    {
        _g_msgImeReconvert  = RegisterWindowMessage(RWM_RECONVERT);
        Assert(_g_msgImeReconvert != 0);
    }
#endif // !NO_IME

    //
    // If we are in edit mode, then by default we are not in HTML edit mode
    //
    _fInHTMLEditMode = FALSE;

    _fNeedTabOut = FALSE;

    _fRegionCollection = FALSE; // default no need to build region collection
    _fDisableReaderMode = FALSE;

    _fPlaintextSave = FALSE;

    _pCaret = NULL;

    //
    // initialize current element history
    //

    _historyCurElem.lIndex = -1L;
    _historyCurElem.dwCode = 0;
    _historyCurElem.lSubDivision = 0;
    
    // CHROME
    // This boolean indicates whether, when firing an event,
    // the client coordinates stored in the Chrome cursor
    // pos structure should be used in place of ScreenToClient.
    // Chrome cursor pos caches the mouse events passed in
    // from the container.
    _chromeCursorPos._fInUse = FALSE;

    // reset the accessibility object, we don't need it until we're asked
    _pAccWindow = NULL;
    _pAccTypeInfo = NULL;
    _fPassivateCalled = FALSE;

#if DBG == 1
    DebugDocStartupCheck();
#endif
}

#pragma warning(default:4355)

//+---------------------------------------------------------------
//
//  Member:     CDoc::~CDoc
//
//  Synopsis:   Destructor for the CDoc class
//
//---------------------------------------------------------------

CDoc::~CDoc ( )
{
    TraceTag((tagCDoc, "%lx CDoc::~CDoc", this));

    Assert(!_pNodeGotButtonDown);

    ClearInterface(&_pUrlHistoryStg);

    //
    // Destroy host stylesheets collection subobject (if anyone held refs on it, we
    // should never have gotten here since the doc should then have subrefs
    // keeping it alive).  This is the only place where we directly access the
    // CBase impl. of IUnk. for the CStyleSheetArray -- we do this instead of
    // just calling delete in order to assure that the CBase part of the CSSA
    // is properly destroyed (CBase::Passivate gets called etc.)
    //
    // StyleSheets moved to CMarkup

    if (_pHostStyleSheets)  // BUGBUG (alexz) investigate why is refcounting so complicated
    {
        _pHostStyleSheets->Free ( );
        _pHostStyleSheets->CBase::PrivateRelease();
        _pHostStyleSheets = NULL;
    }

    // Remove Doc from Thread state array
    TLS(_paryDoc).DeleteByValue(this);

    TraceTag((tagCDoc, "%lx destructed CDoc", this));

    // CVersions object
    if (_pVersions)
    {
        _pVersions->Release();
        _pVersions = NULL;
    }

    // In case any extra expandos were added after CDoc::Passivate (see bug 55425)
    _AtomTable.Free();

#ifdef QUILL

    delete _pqdocGlue;

#endif  // QUILL

#if DBG == 1
    // Make sure there is nothing in the image context cache

    {
        URLIMGCTX * purlimgctx = _aryUrlImgCtx;
        LONG        curlimgctx = _aryUrlImgCtx.Size();
        LONG        iurlimgctx;

        for (iurlimgctx = 0; iurlimgctx < curlimgctx;
             ++iurlimgctx, ++purlimgctx)
        {
            if (purlimgctx->ulRefs > 0)
                break;
        }

        AssertSz(iurlimgctx == curlimgctx, "Image context cache leak");
    }
#endif

    // if we have an accessible object created, clean it up.
    if ( _pAccWindow )
        delete _pAccWindow;

    // If we had to get type information for IAccessible, release type info
    if ( _pAccTypeInfo )
        _pAccTypeInfo->Release();
        
}

//+-------------------------------------------------------------------------
//
//  Method:     CDoc::CreateRoot
//
//  Synopsis:   Create a main root for this doc
//
//--------------------------------------------------------------------------

HRESULT
CDoc::CreateRoot()
{
    HRESULT         hr = S_OK;

    Assert( ! _pPrimaryMarkup );


    hr = THR( CreateMarkup( &_pPrimaryMarkup ) );
    if (hr)
        goto Cleanup;

    _pElemCurrent = _pPrimaryMarkup->Root();

Cleanup:
    RRETURN( hr );
}

//+-------------------------------------------------------------------------
//
//  Method:     CDoc::Init
//
//  Synopsis:    Second phase of construction
//
//--------------------------------------------------------------------------

HRESULT
CDoc::Init()
{
    HRESULT hr;
    THREADSTATE * pts = GetThreadState();

    hr = THR( super::Init() );

    if (hr)
        goto Cleanup;

    //
    // Create the default site (not to be confused with a root site)
    //

    Assert( ! _pElementDefault );

    _pElementDefault = new CDefaultElement ( this );

    if (!_pElementDefault)
    {
        hr = E_OUTOFMEMORY;
        goto Cleanup;
    }

    _pElemCurrent = _pElementDefault;

    _icfDefault = -1;

    //
    // Make a root site to keep everybody happy until we're loaded
    //

    hr = THR( CreateRoot() );

    if (hr)
        goto Cleanup;

    //
    // Initialize format caches
    //

    if (!TLS(_pCharFormatCache))
        InitFormatCache( pts );

    PerfTags();

    _dwStylesheetDownloadingCookie = 1;

    // Set the default block tag to P.
    SetDefaultBlockTag(ETAG_P);

#ifdef QUILL

    _pqdocGlue = new CQDocGlue((IUnknown *)(IHTMLDocument *)this);
    if (!_pqdocGlue)
    {
        hr = E_OUTOFMEMORY;
        goto Cleanup;
    }
    hr = _pqdocGlue->Init();
    if (hr)
        goto Cleanup;

#endif  // QUILL

    _iFontHistoryVersion = pts->_iFontHistoryVersion;

Cleanup:

    RRETURN( hr );
}



void
CDoc::SetLoadfFromPrefs()
{
    // Read in the preferences, if we don't already have them
    if( _pOptionSettings == NULL )
    {
        if (IsPrintDoc())
            IGNORE_HR( UpdateFromRegistry(REGUPDATE_REFRESH) );
        else
            IGNORE_HR( UpdateFromRegistry( ) );
        Assert( _pOptionSettings );
    }

    _dwLoadf =
        ((_pOptionSettings->fShowImages || _fInTrustedHTMLDlg)
            ? DLCTL_DLIMAGES     : 0) |
#ifndef NO_AVI
        (_pOptionSettings->fShowVideos  ? DLCTL_VIDEOS       : 0) |
#endif
        ((_pOptionSettings->fPlaySounds
                     && !IsPrintDoc())  ? DLCTL_BGSOUNDS     : 0);

    if (_fDesignMode || DontRunScripts())
    {
        _dwLoadf |= DLCTL_NO_SCRIPTS;
    }

    if (_pHostPeerFactory)
    {
        SetPeersPossible();
    }

    GetLoadFlag(DISPID_AMBIENT_SILENT);
    GetLoadFlag(DISPID_AMBIENT_OFFLINEIFNOTCONNECTED);

    if (_dwFlagsHostInfo & DOCHOSTUIFLAG_URL_ENCODING_DISABLE_UTF8)
        _dwLoadf |= DLCTL_URL_ENCODING_DISABLE_UTF8;
    else if (_dwFlagsHostInfo & DOCHOSTUIFLAG_URL_ENCODING_ENABLE_UTF8)
        _dwLoadf |= DLCTL_URL_ENCODING_ENABLE_UTF8;
}

#ifdef WIN16
void
CDoc::AddToHistoryStg(TCHAR *pstrTitle)
{
    if (_pUrlHistoryStg ||
        (CServer::QueryService(CLSID_CUrlHistory, IID_IUrlHistoryStg,
                              (void **)&_pUrlHistoryStg) == S_OK))
    {
        _pUrlHistoryStg->AddUrl(_cstrUrl, pstrTitle, 0L);
    }
}
#endif // WIN16

//+-------------------------------------------------------------------------
//
//  Method:     CDoc::Passivate
//
//  Synopsis:   Shutdown main object by releasing references to
//              other objects and generally cleaning up.  This
//              function is called when the main reference count
//              goes to zero.  The destructor is called when
//              the reference count for the main object and all
//              embedded sub-objects goes to zero.
//
//              Release any event connections held by the form.
//
//--------------------------------------------------------------------------

void
CDoc::Passivate ( )
{
    if (_fPassivateCalled)
    {
        Assert("Passivate called too many times " && _fPassivateCalled);
        return;
    }

    _fPassivateCalled = TRUE;

    //
    // behaviors support
    //

    ClearInterface(&_pDefaultPeerFactory);
    ClearInterface (&_pHostPeerFactory);
    
    
    //
    // When my last reference is released, don't accept any excuses
    // while shutting down

    _fForceCurrentElem = TRUE;

    //  Containers are not required to call IOleObject::Close on
    //    objects; containers are allowed to just release all pointers
    //    to an embedded object.  This means that the last reference
    //    to an object can disappear while the object is still in
    //    the OS_RUNNING state.  So, we demote it if necessary.
    //
    //  This duplicates logic in CServer::Passivate, which we don't
    //    call since it also calls CBase::Passivate, which we call
    //    separately.  We transition to the loaded state before
    //    we completely shut down since we can be called back by
    //    controls as they are being unloaded.

    if (_hwndCached)
    {
        Assert(IsWindow(_hwndCached));
        Verify(DestroyWindow(_hwndCached));
        _hwndCached = NULL;
    }


    Assert(_state <= OS_RUNNING);
    if (_state > OS_LOADED)
    {
        Verify(!TransitionTo(OS_LOADED));
    }

    ClearInterface(&_pTimerDraw);

    // Unload the contents of the document

    UnloadContents( FALSE, FALSE );

    //
    // Tear down the editor
    //

    _EditRouter.Passivate();
    ReleaseInterface( _pIHTMLEditor );
    _pIHTMLEditor = NULL;
    //
    // Release caret
    //
    
    ReleaseInterface( _pCaret );
    _pCaret = NULL;
    
    if( _pPrimaryMarkup )
    {
        Assert( _pElemCurrent == _pPrimaryMarkup->Root() );
        _pElemCurrent = _pElementDefault;
        _pPrimaryMarkup->Release();
        _pPrimaryMarkup = NULL;
    }

    Assert( _pElementDefault );

    CElement::ClearPtr( (CElement**)&_pElementDefault );

    if (_pActiveXSafetyProvider &&
        _pActiveXSafetyProvider != (IActiveXSafetyProvider *)-1) {
        _pActiveXSafetyProvider->Release();
    }

    ClearInterface(&_pDownloadNotify);

    FormsFreeString(_bstrUserAgent);
    _bstrUserAgent = NULL;

    if ( _pHostStyleSheets )
    {
        _pHostStyleSheets->Release();
        // we will delete in destructor
    }

    // Release all typeinfos associated w/ this document.
    _clsTab.Reset();

    // Release the parent doc pointer
    if( _pDocParent )
    {
        _pDocParent->SubRelease( );
        _pDocParent = NULL;
    }

    ClearInterface(&_phlbc);

    //  Now, we can safely shut down the form.

    if (_pOmWindow)
    {
        _pOmWindow->_fTrusted = FALSE;

        _pOmWindow->PrivateRelease();   // because doc always holds private reference on OmWindow,
                                        // the last release should be PrivateRelease
        _pOmWindow = NULL;
    }

    GWKillMethodCall(this, NULL, 0);

    ClearInterface(&_pHostUIHandler);
    ClearInterface(&_pBackupHostUIHandler);
    ClearInterface(&_pHostUICommandHandler);
    ClearInterface(&_pSecurityMgr);

#ifdef QUILL

    if (_pqdocGlue)
    {
        _pqdocGlue->Passivate();
    }

#endif  // QUILL

    if (_hpalDocument)
    {
        DeleteObject(_hpalDocument);
        _hpalDocument = 0;
    }

    if (_pColors)
    {
        CoTaskMemFree(_pColors);
        _pColors = 0;
    }
    // release caches if needed...
    if (IsRootDoc())
    {
#ifndef NODD
        ClearSurfaceCache();
#endif
    }
    ClearInterface(&_pDSL);

    ClearDefaultCharFormat();

    NotifySelection( SELECT_NOTIFY_DOC_ENDED, NULL );

    CServer::Passivate();
}

//----------------------------------------------------------
//
//  Member   : CDoc::UnloadContents
//
//  Synopsis : Frees resources
//
//----------------------------------------------------------

void
CDoc::UnloadContents(BOOL fPrecreated, BOOL fRestartLoad )
{
    // Don't allow WM_PAINT or WM_ERASEBKGND to get processed while
    // the tree is being deleted.  Some controls when deleting their
    // HWNDs will cause WM_ERASEBKGND to get sent to our window.  That
    // starts the paint cycle which is bad news when the site tree is
    // being destroyed.

    CLock   Lock(this, SERVERLOCK_BLOCKPAINT | FORMLOCK_UNLOADING);
    long    i;
    
    // Indicate to anybody who checks that the document has been unloaded
    _cDie++;


    if (_pGlyphTable)
    {
        delete _pGlyphTable;
        _pGlyphTable = NULL;
    }

    // We manually stop the HTM downloading here because
    // (1) there is a check in ExecStop which won't do anything
    // if the document was created through script.
    // (2) We need to do a "hard" stop so that the htmload
    // stops right away instead of a "soft" stop that lets
    // the download run a bit more to wind down+finish.
    // If we are unloading the document, we really do want
    // to unload everything right away.

    if (_pPrimaryMarkup)
    {
        _pPrimaryMarkup->StopDownload();
    }

    IGNORE_HR(ExecStop(FALSE));

    _cStylesheetDownloading         = 0;
    _dwStylesheetDownloadingCookie += 1;

    _aryMarkupNotifyInPlace.DeleteAll();

    UnregisterUrlImgCtxCallbacks();

    delete _pScriptCookieTable;
    _pScriptCookieTable = NULL;

    if (_dwAsyncCookie && GetProgSink())
    {
        IGNORE_HR(GetProgSink()->DelProgress(_dwAsyncCookie));
        _dwAsyncCookie = 0;
    }

    //
    // Clear up any modeless dialogs that are hanging around
    ClearCachedDialogs();

    UpdateInterval(0);

    _recalcHost.Detach();

    _aryFocusItems.DeleteAll();
    _aryAccessKeyItems.DeleteAll();

    _cstrSetDomain.Free();

    IGNORE_HR(CommitDeferredScripts(0));

    GWKillMethodCall(this, ONCALL_METHOD(CDoc, FirePostedOnPropertyChange, firepostedonpropertychange), 0);
    GWKillMethodCall(this, ONCALL_METHOD(CDoc, FaultInUSP, faultinusp), 0);
    GWKillMethodCall(this, ONCALL_METHOD(CDoc, FaultInJG, faultinjg), 0);

    Assert(_aryChildDownloads.Size() == 0); // ExecStop should have emptied.

    // Delete stored focus rect info
    if (_pRectFocus)
    {
        delete _pRectFocus;
        _pRectFocus = NULL;
    }

    if (_pHistoryLoadCtx)
    {
        delete _pHistoryLoadCtx;
        _pHistoryLoadCtx = NULL;
    }

    _cstrHistoryUserData.Free();
    ClearInterface(&_pXMLHistoryUserData);
    ClearInterface(&_pShortcutUserData);

#ifndef NO_DATABINDING
    ReleaseDataBinding();
#endif // ndef NO_DATABINDING

    if (!fRestartLoad)
        ClearInterface(&_pctPics);

    if (_pvPics != (void *)(LONG_PTR)(-1))
        MemFree(_pvPics);
    _pvPics = NULL;

    ClearInterface(&_pLicenseMgr);
    ClearInterface(&_pSecurityMgr);

    FormsKillTimer(this, TIMER_ID_MOUSE_EXIT);
    _fMouseOverTimer = FALSE;

    CTreeNode::ClearPtr( & _pNodeLastMouseOver );
    CTreeNode::ClearPtr( & _pNodeGotButtonDown );

    releaseCapture();

    // nothing depends on the tree now; release the tree
    //
    // Detach all sites still not detached
    //

    if (_pPrimaryMarkup)
    {
        if (_pInPlace)
        {
            _pInPlace->_fDeactivating = TRUE;
        }

        _view.Unload();

        _pElemCurrent = _pElementDefault;
        _pElemUIActive = NULL;

        _pPrimaryMarkup->UnloadContents();

    }

    Assert( _pElemCurrent == _pElementDefault );
    Assert( ! _pElemUIActive );

    if (_pPrimaryMarkup)
        _pElemCurrent = _pPrimaryMarkup->Root();

    ReleaseNotify(); // NOTE (alexz) this has to happen before doing PeerDequeueTasks.

    //
    // behaviors UnloadContents
    //

    PeerDequeueTasks(/* fDocUnloadingNow = */TRUE);

    Assert (0 == _aryPeerQueue.Size());
    Assert (0 == _aryElementReleaseNotify.Size());

    for (i = _aryPeerFactoriesUrl.Size(); i > 0; i--)
    {
        _aryPeerFactoriesUrl[i-1]->Release();
    }
    _aryPeerFactoriesUrl.DeleteAll();

    // reset _fPeersPossible, unless it was set because host supplies peer factory. In that case after refresh
    // we won't be requerying again for any css, namespace, and other information provided by host so the bit
    // can't be turned back on
    if (!_pHostPeerFactory)
        _fPeersPossible = FALSE;

    // There might be some filter element tasks pending but we don't care

    // If a filter instantiate caused a navigate and unloaded the doc
    // we will be in a bit of trouble.  This doesn't happen today but just in case.
    Assert(!TestLock(FORMLOCK_FILTER));
    
    _fPendingFilterCallback = FALSE;
    GWKillMethodCall(this, ONCALL_METHOD(CDoc, FilterCallback, filtercallback), 0);
    _aryPendingFilterElements.DeleteAll();


    //
    // misc
    //

    delete _pXmlUrnAtomTable;
    _pXmlUrnAtomTable = NULL;

    if (_pInPlace)
    {
        _pInPlace->_fDeactivating = FALSE;
    }

    if (_pPrimaryMarkup)
    {
        _pPrimaryMarkup->UpdateMarkupTreeVersion();
    }

    _lFocusTreeVersion = 0;
    
    _fDelayLoadHistoryDone = FALSE;
    _fUserInteracted = FALSE;
    _fGotHttpExpires = FALSE;
    _fFiredOnLoad    = FALSE;
    _fImageFile      = FALSE;
    _fNeedInPlaceActivation = FALSE;
    _fTagsInFrameset = FALSE;
    _fFramesetInBody = FALSE;
    _fSslSuppressedLoad = FALSE;
    _fRegionCollection = FALSE;
    _fFrameBorderCacheValid = FALSE;
    _fHasScriptForEvent = FALSE;
    _fIsUpToDate = TRUE;
    _fExpando = EXPANDOS_DEFAULT;
    _fHasOleSite = FALSE;
    _fHasBaseTag = FALSE;
    _fCurrencySet = FALSE;
    _fInHomePublisherDoc = FALSE;
    _fDeleteUrlCacheEntry = FALSE;

    _readyState = READYSTATE_UNINITIALIZED;
    GWKillMethodCall(this, ONCALL_METHOD(CDoc, SetInteractive, setinteractive), 0);
    GWKillMethodCall(this, ONCALL_METHOD(CDoc, SendSetCursor, sendsetcursor), 0);

    {
        LONG c;
        CStr *pcstr;

        for (pcstr = _acstrStatus, c = STL_LAYERS; c; pcstr += 1, c -= 1)
            pcstr->Free();

        _iStatusTop = STL_LAYERS;
        _fSeenDefaultStatus = FALSE;
    }

    ClearInterface(&_pTypInfo);
    ClearInterface(&_pTypInfoCoClass);

    // Only free expandos if not precreated from shdocvw (window.open).
    if (!fPrecreated)
        _AtomTable.Free();

    ClearDwnPost();

    ClearInterface(&_punkMimeOle);

    ClearInterface(&_pmkName);
    ClearInterface(&_pStmDirty);

    _cstrUrl.Set(_T("about:blank"));
    _cstrCOMPAT_OMUrl.Set(_T(""));

    _codepageURL = g_cpDefault;
    _codepage = g_cpDefault;
    _codepageFamily = g_cpDefault;

    _fCPSelChange = 0;
    _fVisualOrder = 0;

    if (_pScriptCollection)
    {
        // NOTE that after this Release call the collection could still be alive,
        // as there can be locks on it from callers of this function
        _pScriptCollection->Release();
        _pScriptCollection = NULL;
    }

    // Reset to false just in case scriptoids exist w/o any script on the page.
    _fEngineSuspended = FALSE;

    // Kill all the timers
    CleanupScriptTimers();

    // Reset document-wide safety indicators
    _safetylevel = SAFETY_NOTSET;
    _fSafetyInformed = FALSE;

    TerminateLookForBookmarkTask();

    // Free cached radio groups
    while (_pRadioGrpName)
    {
        RADIOGRPNAME  *pRadioGroup = _pRadioGrpName->_pNext;

        SysFreeString((BSTR)_pRadioGrpName->lpstrName);
        delete _pRadioGrpName;
        _pRadioGrpName = pRadioGroup;
    }

    //
    // Cleanup window attrarray.  Don't just release the window object
    // here because there are other people outside who are holding
    // refs onto the real window object like shdocvw.  If we did release
    // they don't know that we've just tossed the window object away.
    //

    if (_pOmWindow)
    {
        GWKillMethodCall(_pOmWindow, NULL, 0);

        if (!fPrecreated)
        {
            COmWindow2  *pWindow = _pOmWindow->Window();

            Assert(pWindow);
            if (*(pWindow->GetAttrArray()))
                (*(pWindow->GetAttrArray()))->FreeSpecial();

            // clear up the window proxy also, since that is where the
            // scipt holder is
            delete *(_pOmWindow->GetAttrArray());
            _pOmWindow->SetAttrArray(NULL);
        }
    }

    //
    // Don't delete our attr array outright since we've stored lotsa things
    // in there like prop notify sinks.  We're going to call FreeSpecial to
    // free everything else except these things.
    //

    if (*GetAttrArray())
    {
        (*GetAttrArray())->FreeSpecial();
    }

    _bufferDepth = 0;       // reset the buffer depth
    _triOMOffscreenOK = -1; // reset offscreen to auto

    // reset SSL security/prompting state
    _sslPrompt = SSL_PROMPT_ALLOW;
    _sslSecurity = SSL_SECURITY_UNSECURE;


    if (_pDwnDoc)
    {
        _pDwnDoc->Disconnect();
        _pDwnDoc->Release();
        _pDwnDoc = NULL;
    }

    _aryDefunctObjects.DeleteAll();

    if (_fHasOleSite)
    {
        CoFreeUnusedLibraries();
    }
    
    //
    // NOTE(SujalP): Our current usage pattern dictates that at this point there
    // should be no used entries in the cache. However, when we start caching a
    // plsline inside the cache at that point we will have used entries here and
    // then VerifyNonUsed() cannot be called.
    //
    WHEN_DBG( TLS(_pLSCache)->VerifyNoneUsed(); )
    TLS(_pLSCache)->Dispose(TRUE);
    
    NotifySelection( SELECT_NOTIFY_DOC_ENDED, NULL );
    
    Assert(_lRecursionLevel == 0);
}


//+---------------------------------------------------------------
//
//  Member:     CDoc::ClearCachedDialogs
//
//  Synopsis:   
//
//---------------------------------------------------------------
void
CDoc::ClearCachedDialogs ()
{
    HWND hwndDlg = NULL;
    int i = 0;

    for (i=0; i < _aryActiveModeless.Size(); i++ )
    {
        hwndDlg = _aryActiveModeless[i];
        if (hwndDlg && !!IsWindow(hwndDlg))
        {
            PostMessage(hwndDlg, WM_CLOSE, 0, 0);
        }
    }
    _aryActiveModeless.DeleteAll();
}

//+---------------------------------------------------------------
//
//  Member:     CDoc::RequestReleaseNotify
//
//---------------------------------------------------------------

HRESULT
CDoc::RequestReleaseNotify(CElement * pElement)
{
    HRESULT     hr = S_OK;

    _aryElementReleaseNotify.Append(pElement);
    pElement->SubAddRef();

    RRETURN (hr);
}

//+---------------------------------------------------------------
//
//  Member:     CDoc::RevokeRequestReleaseNotify
//
//---------------------------------------------------------------

HRESULT
CDoc::RevokeRequestReleaseNotify(CElement * pElement)
{
    HRESULT     hr = S_OK;
    LONG        idx = _aryElementReleaseNotify.Find(pElement);

    if (0 <= idx)
    {
        _aryElementReleaseNotify.Delete(idx);
        pElement->SubRelease();
    }

    RRETURN (hr);
}

//+---------------------------------------------------------------
//
//  Member:     CDoc::ReleaseNotify
//
//  Synopsis:   Notifies registered elements to release contained objects.
//
//  Notes:      elements must register to get this notification using RequestReleaseNotify
//
//---------------------------------------------------------------

HRESULT
CDoc::ReleaseNotify()
{
    CElement *      pElement;
    CNotification   nf;
    int             c;

    while (0 < (c = _aryElementReleaseNotify.Size()))
    {
        pElement = _aryElementReleaseNotify[c - 1];

        _aryElementReleaseNotify.Delete(c - 1);

        if (0 < pElement->GetObjectRefs())
        {
            nf.ReleaseExternalObjects(pElement);
            pElement->Notify(&nf);
        }

        pElement->SubRelease();
    }

    Assert (0 == _aryElementReleaseNotify.Size());

    return S_OK;
}

//+---------------------------------------------------------------
//
//  Member:         CDoc::OnCssChange
//
//---------------------------------------------------------------

HRESULT
CDoc::OnCssChange()
{
    HRESULT     hr;

    hr = THR(ForceRelayout());

    RRETURN (hr);
}

//+---------------------------------------------------------------
//
//  Member:         CDoc::EnsureXmlUrnAtomTable
//
//
//---------------------------------------------------------------

HRESULT
CDoc::EnsureXmlUrnAtomTable(CXmlUrnAtomTable ** ppXmlUrnAtomTable)
{
    HRESULT     hr = S_OK;

    if (!_pXmlUrnAtomTable)
    {
        _pXmlUrnAtomTable = new CXmlUrnAtomTable();
        if (!_pXmlUrnAtomTable)
        {
            hr = E_OUTOFMEMORY;
            goto Cleanup;
        }
    }

    if (ppXmlUrnAtomTable)
    {
        *ppXmlUrnAtomTable = _pXmlUrnAtomTable;
    }

Cleanup:

    RRETURN (hr);
}

//+---------------------------------------------------------------
//
//  Member:         CDoc::EnsureScriptCookieTable
//
//
//---------------------------------------------------------------

HRESULT
CDoc::EnsureScriptCookieTable(CScriptCookieTable ** ppScriptCookieTable)
{
    HRESULT     hr = S_OK;

    if (!_pScriptCookieTable)
    {
        _pScriptCookieTable = new CScriptCookieTable();
        if (!_pScriptCookieTable)
        {
            hr = E_OUTOFMEMORY;
            goto Cleanup;
        }
    }

    if (ppScriptCookieTable)
    {
        *ppScriptCookieTable = _pScriptCookieTable;
    }

Cleanup:

    RRETURN (hr);
}

//+---------------------------------------------------------------
//
//  Member:     CDoc::PrivateQueryInterface
//
//  Synopsis:   QueryInterface on our private unknown
//
//---------------------------------------------------------------

HRESULT
CDoc::PrivateQueryInterface(REFIID iid, void ** ppv)
{
    *ppv = NULL;

    // Obsolete (replaced by ITargetContainer)
    Assert(!IsEqualIID(iid, IID_ITargetFrame));

    switch (iid.Data1)
    {
        QI_TEAROFF(this, IOleItemContainer, _pUnkOuter)
        QI_TEAROFF2(this, IOleContainer, IOleItemContainer, _pUnkOuter)
        QI_TEAROFF2(this, IParseDisplayName, IOleItemContainer, _pUnkOuter)
        QI_TEAROFF(this, IServiceProvider, _pUnkOuter)
        QI_TEAROFF(this, IRequireClasses, _pUnkOuter)
        QI_TEAROFF(this, IMarqueeInfo, _pUnkOuter)
        QI_TEAROFF(this, IPersistFile, _pUnkOuter)
        QI_TEAROFF2(this, IPersist, IPersistFile, _pUnkOuter)
        QI_TEAROFF(this, IPersistMoniker, _pUnkOuter)
        QI_TEAROFF(this, IHlinkTarget, _pUnkOuter)
#ifndef WIN16
        QI_TEAROFF(this, IPersistStreamInit, _pUnkOuter)
        QI_TEAROFF(this, DataSource, _pUnkOuter)
#endif // ndef WIN16
        QI_TEAROFF(this, ITargetContainer, _pUnkOuter)
        QI_INHERITS(this, IDispatchEx)
        QI_INHERITS2(this, IDispatch, IHTMLDocument2)
        QI_INHERITS(this, IHTMLDocument)
        QI_INHERITS(this, IHTMLDocument2)
        QI_INHERITS(this, IHTMLDocument3)
        QI_TEAROFF(this, IObjectSafety, _pUnkOuter)
        IF_NOT_WIN16(QI_TEAROFF(this, IShellPropSheetExt, _pUnkOuter))
        QI_TEAROFF(this, IPersistHistory, _pUnkOuter)
        QI_TEAROFF(this, IInternetHostSecurityManager, _pUnkOuter)
        QI_TEAROFF(this, ICustomDoc, _pUnkOuter)
        QI_TEAROFF(this, IObjectIdentity, _pUnkOuter)
        QI_TEAROFF(this, IMarkupServices, _pUnkOuter)
        QI_TEAROFF(this, IHTMLViewServices, _pUnkOuter)
#if TREE_SYNC
        QI_TEAROFF(this, IMarkupSyncServices, _pUnkOuter)
#endif // TREE_SYNC
#ifdef XMV_PARSE
       QI_TEAROFF(this, IXMLGenericParse, _pUnkOuter)
#endif // XMV_PARSE
#if DBG == 1
        QI_TEAROFF( this, IEditDebugServices, _pUnkOuter )
#endif
     default:
        {
            void *          pvTearoff = NULL;
            const void *    apfnTearoff = NULL;

            if (DispNonDualDIID(iid))
            {
                *ppv = (IHTMLDocument2 *)this;
                break;
            }
            else if (IsEqualIID(iid, CLSID_HTMLDocument))
            {
                *ppv = this;
                return S_OK;
            }
            else if (IsEqualIID(iid, CLSID_CMarkup) && _pPrimaryMarkup)
            {
                *ppv = _pPrimaryMarkup;
                return S_OK;
            }
            else if (IsEqualIID(iid, IID_IMarkupContainer) && _pPrimaryMarkup)
            {
                pvTearoff = _pPrimaryMarkup;
                apfnTearoff = (const void *)CMarkup::s_apfnIMarkupContainer;
            }
            else if (IsEqualIID(iid, IID_ISelectionRenderingServices) && _pPrimaryMarkup)
            {
                pvTearoff = _pPrimaryMarkup;
                apfnTearoff = (const void *)CMarkup::s_apfnISelectionRenderingServices;
            }
            else if (IsEqualIID(iid, IID_ISegmentList) && _pPrimaryMarkup)
            {
                pvTearoff = _pPrimaryMarkup;
                apfnTearoff = (const void *)CMarkup::s_apfnISelectionRenderingServices;
            }
            else if (IsEqualIID(iid, IID_IMarkupTextFrags) && _pPrimaryMarkup)
            {
                pvTearoff = _pPrimaryMarkup;
                apfnTearoff = (const void *)CMarkup::s_apfnIMarkupTextFrags;
            }

            // Create the tearoff if we need to
            if (pvTearoff)
            {
                HRESULT hr;

                Assert(apfnTearoff);

                hr = THR(CreateTearOffThunk(
                        pvTearoff,
                        apfnTearoff, 
                        NULL, 
                        ppv, 
                        (IUnknown *)(IPrivateUnknown *)this, 
                        *(void **)(IUnknown *)(IPrivateUnknown *)this,
                        QI_MASK,
                        NULL,
                        NULL));
                if (hr)
                    RRETURN(hr);
            }
#ifdef QUILL
            else if (!IsEqualIID(iid, IID_IUnknown) &&
                        _pqdocGlue &&
                        SUCCEEDED(_pqdocGlue->PrivateQueryInterfaceNonIUnknown(iid, ppv)))
            {
                return S_OK;
            }
#endif  // QUILL

            else
            {
                RRETURN(CServer::PrivateQueryInterface(iid, ppv));
            }
        }
    }

    if (!*ppv)
        RRETURN(E_NOINTERFACE);

    ((IUnknown *) *ppv)->AddRef();

    DbgTrackItf(iid, "CDoc", FALSE, ppv);

    return S_OK;
}


//+---------------------------------------------------------------
//
//  Member:     CDoc::RunningToLoaded
//
//  Synopsis:   Effects the running to loaded state transition
//
//  Returns:    SUCCESS in all but catastrophic circumstances
//
//  Notes:      This method stops all embeddings
//              in addition to normal CServer base processing.
//
//---------------------------------------------------------------

HRESULT
CDoc::RunningToLoaded ( )
{
    TraceTag((tagCDoc, "%lx CDoc::RunningToLoaded", this));

    HRESULT         hr;
    CNotification   nf;

    hr = THR(CServer::RunningToLoaded());
    if (_fHasOleSite)
    {
        nf.DocStateChange1(PrimaryRoot(), (void *)OS_RUNNING);
        BroadcastNotify(&nf);
    }
    
    _view.Deactivate();

    RRETURN(hr);
}

//+---------------------------------------------------------------------------
//
//  Member:     CDoc::HitTestPoint
//
//  Synopsis:   Find site at given position
//
//  Arguments   pt              The position.
//              ppSite          The site, can be null on return.
//              dwFlags         HT_xxx flags
//
//  Returns:    HTC
//
//----------------------------------------------------------------------------

HTC
CDoc::HitTestPoint(CMessage *pMessage,
                   CTreeNode ** ppNodeElement,
                   DWORD dwFlags)
{
    HTC         htc;
    CTreeNode * pNodeElement;

    Assert(pMessage);

    // Ensure that pointers are set for simple code down the line.

    if (ppNodeElement == NULL)
    {
        ppNodeElement = &pNodeElement;
    }


    htc = _view.HitTestPoint(
                        pMessage,
                        ppNodeElement,
                        dwFlags);

    return htc;
}


//+---------------------------------------------------------------
//
//  Member:     CDoc::Update, IOleObject
//
//  Synopsis:   Update object's view cache
//
//---------------------------------------------------------------

STDMETHODIMP
CDoc::Update()
{
    HRESULT         hr;

    hr = THR(super::Update());
    if (hr)
        goto Cleanup;

    if (_fHasOleSite)
    {
        CNotification   nf;

        nf.UpdateViewCache(PrimaryRoot());
        BroadcastNotify(&nf);
    }
    
Cleanup:
    RRETURN(hr);
}


//+---------------------------------------------------------------
//
//  Member:     CDoc::IsUpToDate, IOleObject
//
//  Synopsis:   Is view cache up to date?
//
//---------------------------------------------------------------

STDMETHODIMP
CDoc::IsUpToDate ( )
{
    HRESULT         hr;

    hr = THR(super::IsUpToDate());
    if (hr)
        goto Cleanup;

    if (_fHasOleSite)
    {
        CNotification   nf;
        
        nf.UpdateDocUptodate(PrimaryRoot());
        BroadcastNotify(&nf);
        hr = _fIsUpToDate ? S_OK : S_FALSE;
    }
    
Cleanup:
    RRETURN1(hr, S_FALSE);
}


//+---------------------------------------------------------------
//
//  Member:     CDoc::GetUserClassID
//
//  Synopsis:   Method of IOleObject interface
//
//  Notes:      This method supplies the class id from the server's
//              CLASSDESC structure
//
//---------------------------------------------------------------

STDMETHODIMP
CDoc::GetUserClassID(CLSID FAR* pClsid)
{
    if (pClsid == NULL)
    {
        RRETURN(E_INVALIDARG);
    }

    if (!_fFullWindowEmbed)
        *pClsid = *BaseDesc()->_pclsid;
    else
        *pClsid = CLSID_HTMLPluginDocument;

    return S_OK;
}



//+---------------------------------------------------------------
//
//  Member:     CDoc::Close, IOleObject
//
//  Synopsis:   Close this object
//
//---------------------------------------------------------------

STDMETHODIMP
CDoc::Close(DWORD dwSaveOption)
{
    HRESULT hr;

    if (dwSaveOption == OLECLOSE_NOSAVE)
        _fForceCurrentElem = TRUE;

    // Remove all the posted refresh messages (bug 59289)
    GWKillMethodCall(this, ONCALL_METHOD(CDoc, ExecRefreshCallback, execrefreshcallback), 0);

    hr = THR(super::Close(dwSaveOption));
    if (hr)
        goto Cleanup;

    if (_pScriptCollection)
    {
        _pScriptCollection->Release();
        _pScriptCollection = NULL;
    }

Cleanup:
    RRETURN(hr);
}

//+---------------------------------------------------------------------------
//
//  Member:     CDoc::ParentFrameSite
//
//  Synopsis:   returns the "parent" frame site if this document
//              is hosted inside a frameset.
//
//  Returns:    null if we're not hosted in a frameset
//
//----------------------------------------------------------------------------

CFrameSite* CDoc::ParentFrameSite()
{
    CFrameSite *pFrameSite = NULL;
    COleSite *pSite;
    if (!CServer::QueryService(CLSID_HTMLFrameBase,
                               CLSID_HTMLFrameBase,
                               (void**)&pSite))
    {
        // the value returned by QueryService for this CLSID
        // is not AddRef'ed so we don't need to release()
        // it here
        Assert(pSite->Tag() == ETAG_FRAME);
        pFrameSite = (CFrameSite*) pSite;
    }
    return pFrameSite;
}

//+---------------------------------------------------------------------------
//
//  Member:     CDoc::ParentIFrameSite
//
//  Synopsis:   returns the "parent" frame site if this document
//              is hosted inside an IFrame.
//
//  Returns:    null if we're not hosted in an IFrame
//
//----------------------------------------------------------------------------

CFrameSite* CDoc::ParentIFrameSite()
{
    CFrameSite *pFrameSite = NULL;
    COleSite *pSite;
    if (!CServer::QueryService(CLSID_HTMLIFrame,
                               CLSID_HTMLIFrame,
                               (void**)&pSite))
    {
        // the value returned by QueryService for this CLSID
        // is not AddRef'ed so we don't need to release()
        // it here
        Assert(pSite->Tag() == ETAG_IFRAME);
        pFrameSite = (CFrameSite*) pSite;
    }
    return pFrameSite;
}


//+---------------------------------------------------------------------------
//
//  Member:     CDoc::BroadcastNotify
//
//  Synopsis:   Broadcast this notification through the tree
//
//----------------------------------------------------------------------------

void
CDoc::BroadcastNotify(CNotification *pNF)
{
    Assert (pNF);

    CMarkup *   pMarkup = pNF->Element()->GetMarkup();

    if (pMarkup)
    {
        pMarkup->Notify(pNF);
    }
}


//+---------------------------------------------------------------------------
//
//  Member:     CDoc::SetDocParent
//
//  Synopsis:   Makes sure we have valid _pDocParent pointer.
//              Should only be called from SetClientSite.
//
//  Returns:    HRESULT
//
//----------------------------------------------------------------------------

HRESULT
CDoc::SetDocParent(LPOLECLIENTSITE pClientSite)
{
    // Make sure we do not already have a parent doc pointer
    if (_pDocParent)
    {
        _pDocParent->SubRelease();
        _pDocParent = NULL;
    }

    // If we have a null client site don't bother with the QueryService
    if (pClientSite == NULL)
        return S_OK;

    // N.B. (johnv) Doing a QueryService for a CLSID_HTMLDocument does not
    //  AddRef the returned pointer.
    if (CServer::QueryService(CLSID_HTMLDocument, CLSID_HTMLDocument,
                              (void **)&_pDocParent) == S_OK)
    {
        // if this is the parent
        // we don't want to forward upwards (frankman)
        if (_pDocParent == this)
            _pDocParent = NULL;
        else
        {
        #if DBG==1
            if (IsTagEnabled(tagAssertParentDocChangeToDebugIsPrintDocCache))
                Assert(!_fIdentifiedRootDocAsCDoc && "CDoc::IsPrintDoc() has prematurely labeled the root doc as a CDoc");
        #endif // DBG == 1

            // Now that _pDocParent was set, we don't yet know anything about our ancestry.
            _fIdentifiedRootDocAsCDoc = FALSE;

            _pDocParent->SubAddRef();
        }
    }

    return S_OK;            // this method should never fail
}


//+---------------------------------------------------------------------------
//
//  Member:     CDoc::SetClientSite, IOleObject
//
//  Synopsis:   Overridden method so we can initialize our state from
//              ambient properties.
//
//  Arguments:  pClientSite    New client site.
//
//  Returns:    HRESULT obtained from CServer::SetClientSite
//
//  Notes:      Delegates to CServer::SetClientSite for the real work.
//
//----------------------------------------------------------------------------

STDMETHODIMP
CDoc::SetClientSite(LPOLECLIENTSITE pClientSite)
{
    ITargetFrame *pTargetFrame;
    HRESULT hr;
    HRESULT hr2;
    IUnknown *          pIThumbNailView;
    IUnknown *          pIRenMailEditor = NULL;
    IUnknown *          pIHTMLEditorViewManager;
    IUnknown *          pUnkDefView;
    IUnknown *          pUnkActiveDesktop;
    IOleCommandTarget * pCommandTarget;
#ifdef VSTUDIO7
    IIdentityBehaviorFactory * pIdentityFactory = NULL;
#endif //VSTUDIO7

    // Do not set the client site to the same place more than once

    if (IsSameObject(pClientSite, _pClientSite))
        return S_OK;

    TraceTag((tagCDoc, "%lx CDoc::SetClientSite", this));

    //
    // We delay loading the resource dll until client site is set.
    //

    hr = THR(CServer::SetClientSite(pClientSite));
    if (!OK(hr))
        goto Cleanup;

    // Set the parent document pointer
    hr = THR(SetDocParent(pClientSite));
    if(!OK(hr))
        goto Cleanup;

    // If this is the root doc, the trusted flag will be set in the CDoc
    // constructor.
    if (!IsRootDoc())
    {
        // If this is a trusted frame/iframe, and the immediate parent doc is trusted,
        // we will trust this frame as well.
        CFrameSite * pFrameSite = ParentFrameSite();
        if (!pFrameSite)
            pFrameSite = ParentIFrameSite();

        if (pFrameSite && pFrameSite->_fTrustedFrame)
        {
            if (_pDocParent)
                _fTrustedDoc = _pDocParent->_fTrustedDoc;
        }
    }
    
    // hook up design mode (bug 35089)
    _fDesignMode = !_fUserMode;

    if (!_fUIHandlerSet)
    {
        SetHostUIHandler(pClientSite);

        // Cache DocHost flags.
        _dwFlagsHostInfo = 0;
    }

    if (pClientSite)
    {
        OnAmbientPropertyChange(DISPID_UNKNOWN);
    }

    // Workaround for bugs 4.0 60383, 4.01SP1 #?, 5.0 5781: (also see CDoc::OnAmbientPropertyChange)
    // if hosted in a frame, grab the DOCHOSTUIFLAG_DISABLE_SCRIPT_INACTIVE flag from the top doc
    // so that nested frames don't block waiting for in-place activation when the top doc doesn't.
    if (_pDocParent)
    {
        _dwFlagsHostInfo = (_dwFlagsHostInfo & ~DOCHOSTUIFLAG_DISABLE_SCRIPT_INACTIVE) |
                           (GetRootDoc()->_dwFlagsHostInfo & DOCHOSTUIFLAG_DISABLE_SCRIPT_INACTIVE);
    }

    // Cache Frame flags.

    if (OK(THR_NOTRACE(QueryService(
            IID_ITargetFrame,
            IID_ITargetFrame,
            (void**)&pTargetFrame))))
    {
        THR(pTargetFrame->GetFrameOptions(&_dwFrameOptions));
        pTargetFrame->Release();
    }

    // Get an option settings pointer from the registry, now that we have the
    //  client site
    hr = THR(UpdateFromRegistry());
    if(!OK(hr))
        goto Cleanup;

    if (_fInHTMLDlg)
    {
        // HTML dialogs are assumed to be encoded in cpDefault, and must use
        // a META tag to override this if desired.
        SwitchCodePage(g_cpDefault);
    }
    else if (_pDocParent)
    {
        // Inherit the codepage from our parent, if we have one
        SwitchCodePage(_pDocParent->GetCodePage());
    }

    if (pClientSite)
    {
        // Determine if host is ThumbNailView
        if (OK(pClientSite->QueryInterface(IID_IThumbnailView,
                                            (void **)&pIThumbNailView)))
        {
            _fThumbNailView = TRUE;
            ReleaseInterface(pIThumbNailView);
        }

        // Determine if host is Outlook98
        if (OK( pClientSite->QueryInterface( IID_IRenMailEditor,
                                             (void **) & pIRenMailEditor)))
        {
            ClearInterface( & pIRenMailEditor );
            //
            // Host is Outlook, now see if it's Outlook2000 and greater, or Outlook98
            //
            if (OK( pClientSite->QueryInterface( IID_IRenVersionCheck,
                                                 (void **) & pIRenMailEditor)))
            {
                pIRenMailEditor->Release();
            }
            else
            {
                _fOutlook98 = TRUE;
            }
        }

        // Determine if host is VID
        if (OK(THR_NOTRACE(QueryService(
                SID_SHTMLEditorViewManager,
                IID_IHTMLEditorViewManager,
                (void**) &pIHTMLEditorViewManager))))
        {
            _fVID = TRUE;
            pIHTMLEditorViewManager->Release();
        }

        // Determine if hosted inside webview/defview.  
        if (OK(THR_NOTRACE(QueryService(
                SID_DefView,
                IID_IUnknown,
                (void**) &pUnkDefView))))
        {
            _fDefView = TRUE;
            pUnkDefView->Release();

            if (OK(THR_NOTRACE(QueryService(
                    SID_SShellDesktop,
                    IID_IUnknown,
                    (void**) &pUnkActiveDesktop))))
            {
                _fActiveDesktop = TRUE;
                pUnkActiveDesktop->Release();
            }
        }

        // Determine if host listens to progress status text by QSing OLECMDID_SETPROGRESSTEXT

        _fProgressStatus = FALSE;
        
        // IE5 bug 59311: outlook 98 doesn't want progress status

        if (!_fOutlook98 && OK(THR_NOTRACE(_pClientSite->QueryInterface(IID_IOleCommandTarget, (void **)&pCommandTarget))))
        {
            OLECMD cmd;
            
            cmd.cmdID = OLECMDID_SETPROGRESSTEXT;
            cmd.cmdf = 0;
            
            if (OK(THR_NOTRACE(pCommandTarget->QueryStatus(NULL, 1, &cmd, NULL))))
            {
                if ((cmd.cmdf & (OLECMDF_ENABLED)) && !(cmd.cmdf & (OLECMDF_INVISIBLE)))
                    _fProgressStatus = TRUE;
            }
                
            ReleaseInterface(pCommandTarget);
        }

        // QS host for behavior factory

        ClearInterface(&_pHostPeerFactory);

        hr2 = THR_NOTRACE(QueryService(
            SID_SElementBehaviorFactory, IID_IElementBehaviorFactory, (void**)&_pHostPeerFactory));
        if (S_OK == hr2 && _pHostPeerFactory)
        {
            SetPeersPossible();
            
#ifdef VSTUDIO7
            hr2 = THR(_pHostPeerFactory->QueryInterface(IID_IIdentityBehaviorFactory,
                        (void **)&pIdentityFactory));
            if (S_OK == hr2 && pIdentityFactory)
            {
                _fHasHostIdentityPeerFactory = TRUE;
            }
#endif //VSTUDIO7
        }

        
        RefreshStatusUI();
    }

    IGNORE_HR(QueryVersionHost());

Cleanup:
    
#ifdef VSTUDIO7
    ReleaseInterface(pIdentityFactory);
#endif //VSTUDIO7

    RRETURN(hr);
}

//+---------------------------------------------------------------
//
//  Member:     CDoc::SetHostUIHandler
//
//  Synopsis:   Set _pHostUIHandler by using a passed in client
//              site.
//
//  Returns:    HRESULT, always S_OK
//
//---------------------------------------------------------------
HRESULT
CDoc::SetHostUIHandler(IOleClientSite * pClientSite)
{
    HRESULT             hr = S_OK;

    // First off, get rid of the old interface
    ClearInterface(&_pHostUIHandler);

    if(!pClientSite)
        goto Cleanup;


    if(!OK(pClientSite->QueryInterface(IID_IDocHostUIHandler,
                                       (void **)&_pHostUIHandler)))
    {
        _pHostUIHandler = NULL;
    }
    else
    {
        if (!OK(_pHostUIHandler->QueryInterface(IID_IOleCommandTarget,
                                                (void**)&_pHostUICommandHandler)))
        _pHostUICommandHandler = NULL;
    }


Cleanup:

    RRETURN(hr);
}

//+---------------------------------------------------------------
//
//  Member:     CDoc::EnsureBackupUIHandler
//
//  Synopsis:   Ensure our backup UI handler, or CoCreate one if needed.
//
//  Returns:    HRESULT, always S_OK
//
//---------------------------------------------------------------
HRESULT
CDoc::EnsureBackupUIHandler()
{
    HRESULT            hr = S_OK;

    if (_pBackupHostUIHandler)
        goto Cleanup;

    hr = THR(CoCreateInstance(CLSID_DocHostUIHandler,
                              NULL,
                              CLSCTX_INPROC_SERVER,
                              IID_IDocHostUIHandler,
                              (void**)&_pBackupHostUIHandler));

Cleanup:
    RRETURN(hr);
}

//+---------------------------------------------------------------
//
//  Member:     CDoc::SetHostNames
//
//  Synopsis:   Method of IOleObject interface
//
//---------------------------------------------------------------

STDMETHODIMP
CDoc::SetHostNames(LPCTSTR lpstrCntrApp, LPCTSTR lpstrCntrObj)
{
    //  make copies of the new strings and hold on

    _cstrCntrApp.Set(lpstrCntrApp);

    // It's legal for the container object name to be NULL.

    _cstrCntrObj.Set(lpstrCntrObj);

    return S_OK;
}

//+---------------------------------------------------------------
//
//  Member:     CDoc::GetMoniker
//
//  Synopsis:   Method of IOleObject interface
//
//  Notes:      returns cached moniker on the most recent
//              text file representation of the document;
//              fails if there is no such
//              The text file may be out of sync with actual
//              document
//
//---------------------------------------------------------------

STDMETHODIMP
CDoc::GetMoniker(DWORD dwAssign, DWORD dwWhichMoniker, LPMONIKER * ppmk)
{
    HRESULT     hr = S_OK;

    if (!ppmk)
        RRETURN(E_POINTER);

    if (OLEGETMONIKER_UNASSIGN == dwAssign)
        RRETURN(E_INVALIDARG);

    *ppmk = NULL;

    switch (dwWhichMoniker)
    {
    case OLEWHICHMK_OBJFULL:

        if (_pmkName)
        {
            *ppmk = _pmkName;
            _pmkName->AddRef();
        }
        else if (_cstrUrl)
        {
            hr = THR(CreateURLMoniker(NULL, _cstrUrl, ppmk));
        }
        else
        {
            Assert(0);
//          hr = THR(super::GetMoniker(dwAssign, dwWhichMoniker, ppmk));
        }

        break;

    case OLEWHICHMK_CONTAINER:
    case OLEWHICHMK_OBJREL:

        hr = THR(super::GetMoniker(dwAssign, dwWhichMoniker, ppmk));

        break;
    }

    RRETURN(hr);
}

//+---------------------------------------------------------------
//
//  Member:     CDoc::ParseDisplayName
//
//  Synopsis:   Method of IParseDisplayName interface
//
//---------------------------------------------------------------

STDMETHODIMP
CDoc::ParseDisplayName(LPBC pbc,
        LPTSTR lpszDisplayName,
        ULONG FAR* pchEaten,
        LPMONIKER FAR* ppmkOut)
{
    *ppmkOut = 0;
    *pchEaten = 0;
    return E_NOTIMPL;
}

//+---------------------------------------------------------------
//
//  Member:     CDoc::EnumObjects
//
//  Synopsis:   Method of IOleContainer interface
//
//---------------------------------------------------------------

DECLARE_CPtrAry(CDocEnumObjectsAry, IUnknown *, Mt(CDocEnumObjects_paryUnk), Mt(CDocEnumObjects_paryUnk_pv))

STDMETHODIMP
CDoc::EnumObjects(DWORD grfFlags, LPENUMUNKNOWN FAR* ppenumUnknown)
{
    HRESULT             hr;
    CDocEnumObjectsAry *paryUnk = NULL;
    int                 i;
    int                 c;
    CElement          * pElement;
    CCollectionCache  * pCollectionCache;

    // The defined flags are EMBEDDINGS, LINKS, OTHERS, ONLY_USER, and
    // RUNNING.  We only care about EMBEDDINGS and RUNNING.  Return an
    // enumerator for the site array with the appripriate filters.

    Assert(_pPrimaryMarkup);
    hr = THR(_pPrimaryMarkup->EnsureCollectionCache(CMarkup::ELEMENT_COLLECTION));
    if ( hr )
        goto Cleanup;

    pCollectionCache = _pPrimaryMarkup->CollectionCache();
    Assert(pCollectionCache);

    c = pCollectionCache->SizeAry(CMarkup::ELEMENT_COLLECTION);

    paryUnk = new CDocEnumObjectsAry;
    if (!paryUnk)
    {
        hr = E_OUTOFMEMORY;
        goto Cleanup;
    }

    hr = THR(paryUnk->EnsureSize(c));
    if (hr)
        goto Cleanup;

    // Copy the elements into an array.

    for (i = 0; i < c; i++)
    {
        Verify(!pCollectionCache->GetIntoAry(CMarkup::ELEMENT_COLLECTION, i, &pElement));

        if (grfFlags & OLECONTF_EMBEDDINGS)
        {
            // Skip elements that are not OLE Sites

            if (!pElement->TestClassFlag(CElement::ELEMENTDESC_OLESITE) ||
                    !(DYNCAST(COleSite, pElement)->PunkCtrl()))
                continue;
        }

#if 0
        //
        // This code doesn't make too much sense anymore.  All olesites
        // pretty much always go into at least the running state.
        // (anandra) 04/07/98
        //

        if (grfFlags & OLECONTF_ONLYIFRUNNING)
        {
            // Skip elements that are not running.

            if (pElement->NeedsLayout() && (S_OK != pElement->Notify(SN_ISATLEASTRUNNING, 0)))
                continue;
        }
#endif
        pElement->AddRef();
        Verify(!paryUnk->Append((IUnknown*)pElement));
    }

    // create an enumerator that:
    // - makes and maintains addrefs on its contained (IUnknown*)s
    // - allocates its own copy of the array of (IUnknown*)s
    // - deletes its array when it goes away

    hr = THR(paryUnk->EnumElements(IID_IEnumUnknown,
                (void **)ppenumUnknown, TRUE, FALSE, TRUE));
    if (hr)
        goto Cleanup;

    paryUnk = NULL;

Cleanup:
    if (paryUnk)
    {
        paryUnk->ReleaseAll();
        delete paryUnk;
    }
    RRETURN(hr);
}

//+---------------------------------------------------------------
//
//  Member:     CDoc::LockContainer
//
//  Synopsis:   Method of IOleContainer interface
//
//---------------------------------------------------------------

STDMETHODIMP
CDoc::LockContainer(BOOL fLock)
{
    TraceTag((tagCDoc, "%lx CDoc::LockContainer", this));

    //
    // When we support linking to embedded objects then we need to
    // implement this method.
    //
    return S_OK;
}


//+---------------------------------------------------------------
//
//  Member:     CDoc::GetObject
//
//  Synopsis:   Method of IOleItemContainer interface
//
//---------------------------------------------------------------

STDMETHODIMP
CDoc::GetObject(
        LPTSTR lpszItem,
        DWORD dwSpeedNeeded,
        LPBINDCTX pbc,
        REFIID iid,
        void ** ppv)
{
    *ppv = 0;
    return E_NOTIMPL;
}

//+---------------------------------------------------------------
//
//  Member:     CDoc::GetObjectStorage
//
//  Synopsis:   Method of IOleItemContainer interface
//
//---------------------------------------------------------------

STDMETHODIMP
CDoc::GetObjectStorage(
        LPTSTR lpszItem,
        LPBINDCTX pbc,
        REFIID iid,
        void ** ppvStorage)
{
    *ppvStorage = NULL;
    return E_NOTIMPL;
}

//+---------------------------------------------------------------
//
//  Member:     CDoc::IsRunning
//
//  Synopsis:   Method of IOleItemContainer interface
//
//---------------------------------------------------------------

STDMETHODIMP
CDoc::IsRunning(LPTSTR lpszItem)
{
    return E_NOTIMPL;
}

//+------------------------------------------------------------------------
//
//  Member:     CDoc::StgMode
//
//  Synopsis:   Returns the mode that should be used to open substorages
//              and streams for this form
//
//  Returns:    DWORD
//
//-------------------------------------------------------------------------

DWORD
CDoc::StgMode( )
{
    TraceTag((tagCDoc, "%lx CDoc::StgMode", this));

    return _fReadOnly ? STGM_SRO : STGM_SALL;
}

//+---------------------------------------------------------------------------
//
//  Member:     CDoc::SetCurrentElem
//
//  Synopsis:   Sets the current element - the element that is or will shortly
//              become UI Active. All keyboard messages and commands will
//              be routed to this element.
//
//  Notes:      Note that this function could be called AFTER _pElemCurrent
//              has been removed from the tree.
//
//  Callee:     If SetCurrentElem succeeds, then the callee should do anything
//              appropriate with gaining currency.  The callee must remember
//              that any action performed here must be cleaned up in
//              YieldCurrency.
//
//----------------------------------------------------------------------------

HRESULT
CDoc::SetCurrentElem(CElement * pElemNext, long lSubNext, BOOL *pfYieldFailed)
{
    HRESULT             hr              = S_OK;
    CElement *          pElemPrev       = _pElemCurrent;
    BOOL                fFireEvent;
    BOOL                fFireOnblur     = TRUE;
    BOOL                fPrevDetached   = !(pElemPrev && pElemPrev->GetFirstBranch());
    CElement::CLock *   pLockPrev       = NULL;
    CTreeNode::CLock *  pNodeLockPrev   = NULL;
    CElement *          pElemNewDefault = NULL;
    CElement *          pElemOldDefault = NULL;
    CElement *          pElemFireTarget = NULL;
    long                lSubPrev        = _lSubCurrent;
    BOOL                fSameElem       = (pElemPrev == pElemNext);
    BOOL                fDirty          = FALSE;

    Assert(pElemNext);

    if (pfYieldFailed)
        *pfYieldFailed = FALSE;

    if (fSameElem && lSubNext == _lSubCurrent)
        return S_OK;

    if (!pElemNext || !pElemNext->IsInMarkup())
        return S_FALSE;

    // Someone is trying to set currency to pElemNext from its own onfocus handler (#43161)!
    // Break this loop. Note that it is possible to be in pElemNext's onfocus handler
    // even though pElemNext is the current element.
    if (pElemNext->TestLock(CElement::ELEMENTLOCK_FOCUS))
        return S_OK;

    Assert(this == pElemNext->Doc());

    // We would simply assert here and leave it for the caller to ensure that
    // the element is enabled. Most often, the processing needs to stops way
    // before getting here if the element is disabled. Returning quietly here
    // instead of asserting would hide those bugs.
    Assert(pElemNext->IsEnabled());

#ifdef WIN16
    // in case we were are on some other thread's stack (e.g. Java)...
    // impersonate our own
    CThreadImpersonate cimp(_dwThreadId);
#endif
    // Prevent attempts to delete the sites.

    Assert( pElemNext->GetFirstBranch() );

    CLock LockForm(this, FORMLOCK_CURRENT);


    if (!fPrevDetached)
    {
        pLockPrev = new CElement::CLock(pElemPrev, CElement::ELEMENTLOCK_DELETE);
        pNodeLockPrev = new CTreeNode::CLock(pElemPrev->GetFirstBranch());
    }
    CElement::CLock     LockNext(pElemNext, CElement::ELEMENTLOCK_DELETE);
    CTreeNode::CLock    NodeLockNext( pElemNext->GetFirstBranch() );


    // window onblur will be fired only if body was the current site
    // and we are not refreshing
    if (_pElemCurrent == GetPrimaryElementClient() && !_fForceCurrentElem)
        Fire_onblur();

    _pElemNext = pElemNext;

    // inhibit onblur if the element losing focus is not a select or if a frame in
    // a frameset is not the current one and a previously current site in it is
    // going to be current again.

    // CHROME
    // If we are chrome hosted then we have no HWND.
    // Therefore simply ask our container whether we have focus.
    fFireOnblur = !fPrevDetached &&
                    (_pInPlace &&
                    (!IsChromeHosted() ? (::GetFocus() == _pInPlace->_hwnd) : GetFocus()) || pElemPrev->Tag() == ETAG_SELECT);

    if (!fPrevDetached && !fSameElem)
    {
        fFireEvent = !pElemPrev->TestLock(CElement::ELEMENTLOCK_UPDATE);
        CElement::CLock LockUpdate(pElemPrev, CElement::ELEMENTLOCK_UPDATE);

        if (fFireEvent)
        {
            hr = THR_NOTRACE(pElemPrev->RequestYieldCurrency(_fForceCurrentElem));
            // yield if currency changed to a different or the same element that is
            // going to become current.
            if (FAILED(hr) || _pElemNext != pElemNext || _pElemCurrent == pElemNext)
            {
                if (pfYieldFailed)
                    *pfYieldFailed = TRUE;

                goto CanNotYield;
            }
        }

        fFireEvent = !pElemPrev->TestLock(CElement::ELEMENTLOCK_CHANGE);
        CElement::CLock LockChange(pElemPrev, CElement::ELEMENTLOCK_CHANGE);

        if (fFireEvent) // BUGBUG: Why check for fFireEvent here?
        {
            hr = THR_NOTRACE(pElemPrev->YieldCurrency(pElemNext));
            if (hr)
            {
                if (pfYieldFailed)
                    *pfYieldFailed = TRUE;

                goto Error;
            }

            // bail out if currency changed
            if (_pElemNext != pElemNext)
                goto Error;
       }
    }

    // bail out if the elem to become current is no longer in the tree, due to some event code
    if (!pElemNext->IsInMarkup())
        goto Error;

    _pElemCurrent = pElemNext;
    _lSubCurrent = lSubNext;

    // Set focus to the current element
    if (State() >= OS_UIACTIVE)
    {
        _view.SetFocus(_pElemCurrent, _lSubCurrent);
    }

    // Has currency been set in a non-trivial sense?
    if (!_fCurrencySet && _pElemCurrent->Tag() != ETAG_ROOT && _pElemCurrent->Tag() != ETAG_DEFAULT)
    {
        _fCurrencySet = TRUE;
        GWKillMethodCall(this, ONCALL_METHOD(CDoc, DeferSetCurrency, defersetcurrency), 0);
    }

    //
    // marka BUGBUG. OnPropertyChange is dirtying the documnet
    // which is bad for editing clients (bugs 10161)
    // this will go away for beta2.
    //
    fDirty = !!_lDirtyVersion;
    IGNORE_HR(OnPropertyChange(DISPID_CDoc_activeElement, FORMCHNG_NOINVAL));
    if (    !fDirty
        &&  _lDirtyVersion)
    {
        _lDirtyVersion = 0;
    }

    // We fire the blur event AFTER we change the current site. This is
    // because if the onBlur event handler throws up a dialog box then
    // focus will go to the current site (which, if we donot change the
    // current site to be the new one, will still be the previous
    // site which has just yielded currency!).

    if (fFireOnblur)
    {
        Assert(pElemPrev);
        pElemFireTarget = pElemPrev->GetFocusBlurFireTarget(lSubPrev);

        Assert(pElemPrev != _pElemCurrent || lSubPrev != _lSubCurrent);

        hr = THR(GWPostMethodCall(pElemFireTarget, ONCALL_METHOD(CElement, Fire_onblur, fire_onblur), 0, TRUE, "CElement::Fire_onblur"));
        if (hr)
            goto Error;
    }

    if (_pElemCurrent && !_fDontFireOnFocusForOutlook98)
    {
        pElemFireTarget = _pElemCurrent->GetFocusBlurFireTarget(_lSubCurrent);

        Assert(pElemPrev != _pElemCurrent || lSubPrev != _lSubCurrent);
        hr = THR(GWPostMethodCall(pElemFireTarget, ONCALL_METHOD(CElement, Fire_onfocus, fire_onfocus), 0, TRUE, "CElement::Fire_onfocus"));
        if (hr)
            goto Error;
    }

Cleanup:
    // if forcing, always change the current site as asked
    if (_fForceCurrentElem &&
        _pElemCurrent != pElemNext)
    {
        _pElemCurrent = pElemNext;
        IGNORE_HR(OnPropertyChange(DISPID_CDoc_activeElement, 0));
        hr = S_OK;
    }

    if (pElemNext == _pElemCurrent)
    {
        if (!fSameElem)
        {
            // if the button is already the default or a button
            pElemNewDefault = _pElemCurrent->_fActsLikeButton
                                    ? _pElemCurrent
                                    : _pElemCurrent->FindDefaultElem(TRUE);

            if (    pElemNewDefault
                &&  !pElemNewDefault->_fDefault)
            {
                pElemNewDefault->SendNotification(NTYPE_AMBIENT_PROP_CHANGE, (void *)DISPID_AMBIENT_DISPLAYASDEFAULT);
                pElemNewDefault->_fDefault = TRUE;
                pElemNewDefault->Invalidate();
            }
        }
    }

    if (!fPrevDetached && (pElemPrev != _pElemCurrent))
    {
        // if the button is already the default or a button
        pElemOldDefault = pElemPrev->_fActsLikeButton
                                ? pElemPrev
                                : pElemPrev->FindDefaultElem(TRUE);

        if (    pElemOldDefault
            &&  pElemOldDefault != pElemNewDefault)
        {
            pElemOldDefault->SendNotification(NTYPE_AMBIENT_PROP_CHANGE, (void *)DISPID_AMBIENT_DISPLAYASDEFAULT);
            pElemOldDefault->_fDefault = FALSE;
            pElemOldDefault->Invalidate();
       }
    }

CanNotYield:
    if (pLockPrev)
        delete pLockPrev;
    if (pNodeLockPrev)
        delete pNodeLockPrev;

    RRETURN1(hr, S_FALSE);

Error:
    hr = E_FAIL;
    goto Cleanup;
}

void BUGCALL
CDoc::DeferSetCurrency(DWORD_PTR dwContext)
{
    BOOL    fWaitParseDone = FALSE;

    // If the currency is already set, or we are not yet inplace active 
    // there is nothing to do... 
    if (_fCurrencySet || (State() < OS_INPLACE))
        return;

    // If we are in a dialog, or webview hosting scenario,
    // If parsing is done, then we can activate the first tabbable object.
    if (_fInHTMLDlg || !_fMsoDocMode
                    || (_dwFlagsHostInfo & DOCHOSTUIFLAG_DIALOG))
    {
        if (LoadStatus() >= LOADSTATUS_PARSE_DONE)
        {
            // Parsing is complete, we know which element is the current element, 
            // we can set that element to be the active element
            CElement *      pElement    = NULL;
            long            lSubNext    = 0;

            FindNextTabOrder(DIRECTION_FORWARD, NULL, 0, &pElement, &lSubNext);
            if (pElement)
            {
                Assert(pElement->IsTabbable(lSubNext));

                // If we are not UI active yet, only set the current element,
                // do not try to activate and scroll in the element.
                // If we are UI active, then we can activate the current element
                // and scroll it into the view.
                if (State() < OS_UIACTIVE)
                {
                    // if the document is not UI Active, then we should not UI activate
                    // the olesite either. If the Olesite becomes UI active, it will force
                    // the containing document to go UI active too.
                    _fDontUIActivateOleSite = TRUE;

                    IGNORE_HR(pElement->BecomeCurrent(lSubNext, NULL, NULL));

                    // reset flag
                    _fDontUIActivateOleSite = FALSE;
                }
                else
                {
                    if (S_OK == pElement->BecomeCurrentAndActive(NULL, lSubNext, FALSE))
                    {
                        IGNORE_HR(THR(pElement->ScrollIntoView()));
                        _fFirstTimeTab = FALSE;
                    }
                }
            }
        }
        else
        {
            // Parsing is not done yet. 
            fWaitParseDone = TRUE;
        }
    }

    // if the currency is not yet set, then make the element client the 
    // current element.
    if (!_fCurrencySet)
    {
        CElement *  pel         = GetPrimaryElementTop();

        BOOL        fTakeFocus  = (State() >= OS_UIACTIVE) && 
                                    _pInPlace->_fFrameActive;
    
        // 49336 - work around Outlook98 bug which interprets Element_onFocus
        // event that would get fired in the BecomeCurrent below as indication
        // that Trident window gains focus and turns on an internal flag to that
        // effect. The fix is to not fire this onFocus, when the window does
        // not have focus
        _fDontFireOnFocusForOutlook98 = (   _fOutlook98
                                         && !fTakeFocus
                                         && ::GetFocus() != _pInPlace->_hwnd);

        pel->BecomeCurrent(0, NULL, NULL, fTakeFocus);

        _fDontFireOnFocusForOutlook98 = FALSE;

        // If we are waiting for the parsing to be completed, we have to make sure 
        // that we think the currency is not set when we receive the parse done notification.
        // We will activate the first available object when we receive the parse done
        // notification.
        if (fWaitParseDone)
            _fCurrencySet = FALSE;
    }
}

//+---------------------------------------------------------------
//
//  Member:     CDoc::SetUIActiveElement
//
//  Synopsis:   UIActivate a given site, often as part of
//              IOleInPlaceSite::OnUIActivate
//
//---------------------------------------------------------------

HRESULT
CDoc::SetUIActiveElement(CElement *pElemNext)
{
    HRESULT     hr = S_OK;
    CElement *  pElemPrev = _pElemUIActive;

    // Bail out if we are deactivating from Inplace or UI Active.
    if (_pInPlace->_fDeactivating)
        goto Cleanup;

    Assert(!pElemNext || pElemNext->HasLayout() || pElemNext->Tag() == ETAG_ROOT || pElemNext->Tag() == ETAG_DEFAULT);
    Assert(!pElemPrev || pElemPrev->HasLayout() || pElemPrev->Tag() == ETAG_ROOT || pElemPrev->Tag() == ETAG_DEFAULT);

    if (pElemNext != pElemPrev)
    {
        _pElemUIActive = pElemNext;

        // Tell the old ui-active guy to remove it's ui.

        if (pElemPrev)
        {
            pElemPrev->YieldUI(pElemNext);

            if (pElemPrev->_fActsLikeButton)
            {
                CNotification   nf;

                nf.AmbientPropChange(pElemPrev, (void *)DISPID_AMBIENT_DISPLAYASDEFAULT);
                pElemPrev->_fDefault = FALSE;
                pElemPrev->Notify(&nf);
            }
        }
    }

    if (_state < OS_UIACTIVE)
    {
        // A site is trying to activate.  Tell CServer not to do any
        // menu or border stuff.

        Assert(!_pInPlace->_fChildActivating);
        _pInPlace->_fChildActivating = TRUE;

        // If an embedding is UI active, then the document must be UI active.

        if (TestLock(SERVERLOCK_TRANSITION))
        {
            // We arrived here because CDoc::InPlaceToUIActive is attempting
            // to UI activate one of its sites.  Since we are already in the
            // middle of CDoc::InPlaceToUIActive, all we need to is is call
            // CServer::InPlaceToUIActive to finish the work.
            hr = THR(CServer::InPlaceToUIActive(NULL));
        }
        else
        {
            // Do the normal transition to the UI active state.
            hr = THR(TransitionTo(OS_UIACTIVE, NULL));
        }

        _pInPlace->_fChildActivating = FALSE;

        if (hr)
            goto Cleanup;
    }

    if (_fDesignMode)
    {
        // Erase the grab handles.

        if (    pElemPrev && pElemPrev != PrimaryRoot()
            &&  pElemNext != pElemPrev && pElemPrev->HasLayout())
        {
            pElemPrev->GetCurLayout()->Invalidate();
        }

        if (pElemNext && pElemNext != PrimaryRoot() && pElemNext->HasLayout())
            pElemNext->GetCurLayout()->Invalidate();
        // Notify selection change.

        if (!_pInPlace->_fDeactivating)
        {
            //
            //  Since we report the UI Active control as the contents of
            //  the selected collection, we need to update the property
            //  frame
            //

            IGNORE_HR(OnSelectChange());
        }
    }

Cleanup:
    RRETURN(hr);
}

//+------------------------------------------------------------------------
//
//  Member:     CDoc::DeferUpdateUI, DeferUpdateTitle, SetUpdateTimer
//
//  Synopsis:   Post a request to ourselves to update the UI.
//
//-------------------------------------------------------------------------

void
CDoc::DeferUpdateUI()
{
    TraceTag((tagUpdateUI, "CDoc::DeferUpdateUI"));

    _fNeedUpdateUI = TRUE;

    SetUpdateTimer();
}

void
CDoc::DeferUpdateTitle()
{
    if (IsRootDoc())
    {
        TraceTag((tagUpdateUI, "CDoc::DeferUpdateTitle"));

        _fNeedUpdateTitle = TRUE;
        
        SetUpdateTimer();
    }
}

void
CDoc::SetUpdateTimer()
{
    // If called before we're inplace or have a window, just return.
    if (!_pInPlace || !_pInPlace->_hwnd)
        return;

    if (!_fUpdateUIPending)
    {
        _fUpdateUIPending = TRUE;
        SetTimer(_pInPlace->_hwnd, TIMER_DEFERUPDATEUI, 100, NULL);
    }
}

//+------------------------------------------------------------------------
//
//  Member:     CDoc::OnUpdateUI
//
//  Synopsis:   Process UpdateUI message.
//
//-------------------------------------------------------------------------

void
CDoc::OnUpdateUI()
{
    IOleCommandTarget * pCommandTarget = NULL;

    TraceTag((tagUpdateUI, "CDoc::OnUpdateUI"));

    Assert(InPlace());

    KillTimer(_pInPlace->_hwnd, TIMER_DEFERUPDATEUI);
    _fUpdateUIPending = FALSE;

    if (_fNeedUpdateUI)
    {
        if (_pHostUIHandler)
        {
           _pHostUIHandler->UpdateUI();
        }

        Assert(_pClientSite);
        if (_pClientSite)
        {
            IGNORE_HR(_pClientSite->QueryInterface(IID_IOleCommandTarget, (void **)&pCommandTarget));
        }

        // update container UI.

        if (pCommandTarget)
        {
#ifndef NO_OLEUI
            // update menu/toolbar
            pCommandTarget->Exec(NULL, OLECMDID_UPDATECOMMANDS, MSOCMDEXECOPT_DONTPROMPTUSER, NULL, NULL);
            pCommandTarget->Release();
#endif // NO_OLEUI
        }

        _fNeedUpdateUI = FALSE;
    }

    if (_fNeedUpdateTitle)
    {
        UpdateTitle();
    }
}

void
CDoc::UpdateTitle()
{
    VARIANTARG var;
    IOleCommandTarget * pCommandTarget = NULL;
    TCHAR szBuf[1024];
    TCHAR achUrl[pdlUrlLen + sizeof(DWORD)/sizeof(TCHAR)];
    DWORD cchUrl;
    HRESULT hr;
    CStr cstrFile;

    TraceTag((tagUpdateUI, "CDoc::UpdateTitle"));

    if (!_pClientSite)
    {
        return;
    }

    hr = _pClientSite->QueryInterface(IID_IOleCommandTarget, (void **)&pCommandTarget);
    if (hr)
        goto Cleanup;

    // update title
    var.vt      = VT_BSTR;
    if (_pPrimaryMarkup->GetTitleElement() && _pPrimaryMarkup->GetTitleElement()->Length())
    {
        var.bstrVal = _pPrimaryMarkup->GetTitleElement()->GetTitle();
    }
    else if (_cstrUrl && GetUrlScheme(_cstrUrl) == URL_SCHEME_FILE)
    {
        TCHAR achFile[MAX_PATH];
        ULONG cchFile = ARRAY_SIZE(achFile);

        hr = THR(PathCreateFromUrl(_cstrUrl, achFile, &cchFile, 0));
        if (hr)
            goto Cleanup;

        hr = THR(cstrFile.Set(achFile)); // need memory format of a BSTR
        if (hr)
            goto Cleanup;

        var.bstrVal = cstrFile;
    }
    else if (_cstrUrl && !_fDesignMode)
    {
        // need to unescape the url when setting title

        if (S_OK == CoInternetParseUrl(_cstrUrl, PARSE_ENCODE, 0,
                                       achUrl + sizeof(DWORD) / sizeof(TCHAR),
                                       ARRAY_SIZE(achUrl) - sizeof(DWORD) / sizeof(TCHAR),
                                       &cchUrl, 0))
        {
            var.bstrVal = achUrl + sizeof(DWORD) / sizeof(TCHAR);
        }
        else
        {
            var.bstrVal = _cstrUrl;
        }

        hr = THR(RemoveSpecialUrl(V_BSTR(&var), NULL));
        if (hr)
            goto Cleanup;

        *(DWORD *)achUrl = _tcslen(V_BSTR(&var)); // this should be done after RemoveSpecialUrl (length may change there)
    }
    else
    {
        *((DWORD *)szBuf)=LoadString(GetResourceHInst(),
                                     IDS_NULL_TITLE,
                                     szBuf+sizeof(DWORD)/sizeof(TCHAR),
                                     ARRAY_SIZE(szBuf) -
                                         sizeof(DWORD) / sizeof(TCHAR));
        Assert(*((DWORD *)szBuf) != 0);
        var.bstrVal = szBuf + sizeof(DWORD) / sizeof(TCHAR);
    }

    pCommandTarget->Exec(
            NULL,
            OLECMDID_SETTITLE,
            MSOCMDEXECOPT_DONTPROMPTUSER,
            &var,
            NULL);

    TraceTag((tagUpdateUI, "CDoc::UpdateTitle to \"%ls\"", var.bstrVal));

Cleanup:
    ReleaseInterface(pCommandTarget);
    _fNeedUpdateTitle = FALSE;
}

//+------------------------------------------------------------------------
//
//  Member:     CDoc::CountRequiredClasses, IRequireClasses
//
//  Synopsis:   Return number of classes used by the form.
//
//-------------------------------------------------------------------------

HRESULT
CDoc::CountRequiredClasses(ULONG *pcClasses)
{
    *pcClasses = _clsTab.Size();
    return S_OK;
}

//+------------------------------------------------------------------------
//
//  Member:     CDoc::GetRequiredClasses, IRequireClasses
//
//  Synopsis:   Return classes used by the form.
//
//-------------------------------------------------------------------------

HRESULT
CDoc::GetRequiredClasses(ULONG iclsid, CLSID *pclsid)
{
    if (iclsid >= (ULONG)_clsTab.Size())
        RRETURN(E_FAIL);

    *pclsid = *_clsTab.GetpCLSID((int)iclsid);
    return S_OK;
}


//+------------------------------------------------------------------------
//
//  Member:     CDoc::GetDocCoords, IMarqueeInfo
//
//  Synopsis:   Returns the size information anbout the current doc. This method is
//              called only when the mshtml is hosted inside the marquee control.
//
//-------------------------------------------------------------------------

HRESULT
CDoc::GetDocCoords(LPRECT pViewRect, BOOL bGetOnlyIfFullyLoaded, BOOL *pfFullyLoaded, int WidthToFormatPageTo)
{
    BOOL        fReady = (_readyState == READYSTATE_COMPLETE);
    HRESULT     hr     = S_OK;
    SIZE        lsize;
    CSize       size;
    RECT        rc;
    CElement *  pElement = GetPrimaryElementClient();

    // Marquee control should support doc host interface, but it does not.
    // Fix things up for it.
    _dwFlagsHostInfo  |= DOCHOSTUIFLAG_NO3DBORDER | DOCHOSTUIFLAG_SCROLL_NO;

    *pfFullyLoaded = fReady;

    pViewRect->left   =
    pViewRect->top    =
    pViewRect->right  =
    pViewRect->bottom = 0;

    if (bGetOnlyIfFullyLoaded && !fReady)
        return S_FALSE;

    if(!_pPrimaryMarkup || !GetPrimaryElementClient() || GetPrimaryElementClient() == PrimaryRoot())
    {
        hr = E_FAIL;
        goto Cleanup;
    }

    Assert(pElement);
    //
    // Make sure that document is at least running, otherwise CalcSize will assert.
    //

    if (State() < OS_RUNNING)
    {
        hr = THR(TransitionTo(OS_RUNNING, NULL));
        if (hr)
            goto Cleanup;
    }

    if (_view.IsActive())
    {
        _view.Activate();
        _view.SetFlag(CView::VF_FULLSIZE);
    }

    size.cx = WidthToFormatPageTo;
    size.cy = 0;

    // No scrollbars wanted inside the marquee ocx.
    if (!(_dwFrameOptions & FRAMEOPTIONS_SCROLL_NO))
    {
        _dwFrameOptions = FRAMEOPTIONS_SCROLL_NO;

        // Suppress scrollbar only if doc has a body (no frameset).
        if (pElement && pElement->_etag == ETAG_BODY)
        {
            IGNORE_HR(pElement->OnPropertyChange(DISPID_A_SCROLL, ELEMCHNG_SIZECHANGED) );
        }
    }

    _view.SetViewSize(size);
    _view.EnsureView(LAYOUT_SYNCHRONOUS | LAYOUT_FORCE);

    if (pElement)
    {
        pElement->GetUpdatedLayout()->GetContentSize(&size, FALSE);
    }

    //
    // Ensure size is a safe minimum and convert to HIMETRIC
    //

    size.Max(CSize(WidthToFormatPageTo,1));

    HimetricFromDevice(&lsize, size);

    //
    // Copied from CDoc::SetExtent, but this function is a hack anyway.
    //
    rc.left    =
    rc.top     = 0;

#ifdef  IE5_ZOOM

    rc.right   = max((long)_dci.DxzFromDxt(_dci.DxtFromHim(lsize.cx)), 1L);
    rc.bottom  = max((long)_dci.DyzFromDyt(_dci.DytFromHim(lsize.cy)), 1L);

#if DBG==1
    {
        long cxNew = _dci.DxzFromDxt(_dci.DxtFromHim(lsize.cx));
        long cyNew = _dci.DyzFromDyt(_dci.DytFromHim(lsize.cy));
        long cxOld = MulDivQuick(lsize.cx, _dci._sizeInch.cx, 2540L);
        long cyOld = MulDivQuick(lsize.cy, _dci._sizeInch.cy, 2540L);
        Assert(cxNew == cxOld || _dci.IsZoomed());
        Assert(cyNew == cyOld || _dci.IsZoomed());
    }
#endif  // DBG==1

#else   // !IE5_ZOOM

    rc.right   = max((long)MulDivQuick(lsize.cx, _dci._sizeInch.cx, 2540L), 1L);
    rc.bottom  = max((long)MulDivQuick(lsize.cy, _dci._sizeInch.cy, 2540L), 1L);

#endif  // IE5_ZOOM

    _dci.CTransform::Init(&rc, lsize);

    CServer::SetExtent(DVASPECT_CONTENT, &lsize);

    pViewRect->right  = size.cx;
    pViewRect->bottom = size.cy;

Cleanup:
    RRETURN(hr);
}



#ifdef XMV_PARSE
//+------------------------------------------------------------------------
//
//  Member:     CDoc::SetGenericParse, IXMLGenericParse
//
//  Synopsis:   If true, throws tokenizer and stylesheet selector parser into a mode
//              where all unqualified tags are treated as generic tags and real
//              html tags must be prefaced by html: namespace
//
//-------------------------------------------------------------------------
HRESULT
CDoc::SetGenericParse(VARIANT_BOOL fDoGeneric)
{
    if (!_pPrimaryMarkup)
        return E_FAIL;
    _pPrimaryMarkup->SetXML(fDoGeneric == VARIANT_TRUE);
    return S_OK;
}
#endif


//+---------------------------------------------------------------------------
//
//  Member:     CDoc::OnPropertyChange
//
//  Synopsis:   Invalidate, fire property change, and so on.
//
//  Arguments:  [dispidProperty] -- PROPID of property that changed
//              [dwFlags]        -- Flags to inhibit behavior
//
//----------------------------------------------------------------------------

HRESULT
CDoc::OnPropertyChange(
        DISPID dispidProperty,
        DWORD  dwFlags)
{
    HRESULT hr = S_OK;

    switch ( dispidProperty )
    {
        case DISPID_BACKCOLOR :
            OnAmbientPropertyChange(DISPID_AMBIENT_BACKCOLOR);
            break;

        case DISPID_FORECOLOR :
            OnAmbientPropertyChange(DISPID_AMBIENT_FORECOLOR);
            break;

        case DISPID_A_DIR :
            OnAmbientPropertyChange(DISPID_AMBIENT_RIGHTTOLEFT);
            break;

    }

    if ((dwFlags & (SERVERCHNG_NOVIEWCHANGE|FORMCHNG_NOINVAL)) == 0)
    {
        Invalidate();
    }

    if (dwFlags & ELEMCHNG_CLEARCACHES )
    {
        PrimaryRoot()->GetFirstBranch()->VoidCachedInfo();
    }

    if (dwFlags & FORMCHNG_LAYOUT)
    {
        PrimaryRoot()->ResizeElement(NFLAGS_FORCE);
    }

    Verify(!CServer::OnPropertyChange(dispidProperty, dwFlags));

    // see bugbug in CElement:OnPropertyChange
    // if ( fSomeoneIsListening )

    // Post the call to fire onpropertychange if dispid is that of activeElement, this
    // is so that the order of event firing is maintained in SetCurrentElem.
    if (dispidProperty == DISPID_CDoc_activeElement)
    {
        hr = THR(GWPostMethodCall(this, ONCALL_METHOD(CDoc, FirePostedOnPropertyChange, firepostedonpropertychange), 0, TRUE, "CDoc::FirePostedOnPropertyChange"));
    }
    else
        hr = THR(Fire_PropertyChangeHelper(dispidProperty, dwFlags));

    RRETURN( hr );
}

//+---------------------------------------------------------------------------
//
//  Member:     CDoc::Fire_PropertyChangeHelper
//
//
//+---------------------------------------------------------------------------
HRESULT
CDoc::Fire_PropertyChangeHelper(DISPID dispidProperty, DWORD dwFlags)
{
    LPCTSTR pszName;
    PROPERTYDESC *ppropdesc;

    if (S_OK == FindPropDescFromDispID(dispidProperty, &ppropdesc, NULL, NULL))
    {
        Assert(ppropdesc);

        pszName = ppropdesc->pstrExposedName ? ppropdesc->pstrExposedName : ppropdesc->pstrName;

        if (pszName != NULL)
        {
            Fire_onpropertychange(pszName);
        }
    }

    return S_OK;
}



//+---------------------------------------------------------------------------
//
//  Member:     CDoc::EnsureHostStyleSheets
//
//  Synopsis:   Ensure the document's stylesheets collection exists, and create it if not
//
//----------------------------------------------------------------------------

HRESULT
CDoc::EnsureHostStyleSheets()
{
    CStyleSheet *   pSS = NULL;
    HRESULT         hr = S_OK;
    
    if (_pHostStyleSheets || !_cstrHostCss)
        return S_OK;

    _pHostStyleSheets = new CStyleSheetArray(this, NULL, 0);
    if (!_pHostStyleSheets || _pHostStyleSheets->_fInvalid)
        return E_OUTOFMEMORY;

    hr = THR(_pHostStyleSheets->CreateNewStyleSheet(NULL, &pSS));
    if (hr)
        goto Cleanup;

    {
#ifdef XMV_PARSE
        CCSSParser  cssparser(pSS, NULL, _pPrimaryMarkup->IsXML());
#else
        CCSSParser  cssparser(pSS, NULL);
#endif

        cssparser.Write(_cstrHostCss, lstrlen(_cstrHostCss));

        cssparser.Close();
    }
    
Cleanup:
    RRETURN(hr);
}


//+---------------------------------------------------------------------------
//
//  Member:     CDoc::PreSetErrorInfo
//
//  Synopsis:   Update the UI whenever the form is returned from.
//
//----------------------------------------------------------------------------

void
CDoc::PreSetErrorInfo()
{
    super::PreSetErrorInfo();

    DeferUpdateUI();
}

//+------------------------------------------------------------------------
//
//  Member:     CreateDoc
//
//  Synopsis:   Creates a new doc instance.
//
//  Arguments:  pUnkOuter   Outer unknown
//
//  Returns:    HRESULT
//
//-------------------------------------------------------------------------

CBase * STDMETHODCALLTYPE
CreateDoc(IUnknown * pUnkOuter)
{
    CBase * pBase;
    PerfDbgLog(tagPerfWatch, NULL, "+CreateDoc");
    pBase = new CDoc(pUnkOuter);
    PerfDbgLog(tagPerfWatch, NULL, "-CreateDoc");
    return(pBase);
}

//+------------------------------------------------------------------------
//
//  Member:     CreateMhtmlDoc
//
//  Synopsis:   Creates a new MHTML doc instance.  This is identical to
//              a regular doc instance, except that IPersistMoniker::Load
//              first needs to convert the moniker to one that points
//              to actual HTML.
//
//  Arguments:  pUnkOuter   Outer unknown
//
//  Returns:    HRESULT
//
//-------------------------------------------------------------------------

CBase *
CreateMhtmlDoc(IUnknown * pUnkOuter)
{
    CBase * pBase;
    PerfDbgLog(tagPerfWatch, NULL, "+CreateMhtmlDoc");
    pBase = new CDoc(pUnkOuter, CDoc::DOCTYPE_MHTML);
    PerfDbgLog(tagPerfWatch, NULL, "-CreateMhtmlDoc");
    return(pBase);
}

//+------------------------------------------------------------------------
//
//  Member:     CreateHTADoc
//
//  Synopsis:   Creates a new doc instance.  This version creates a doc
//              set up to understand HTA behavior
//
//  Arguments:  pUnkOuter   Outer unknown
//
//  Returns:    HRESULT
//
//-------------------------------------------------------------------------

CBase *
CreateHTADoc(IUnknown * pUnkOuter)
{
    CBase * pBase;
    PerfDbgLog(tagPerfWatch, NULL, "+CreateHTADoc");
    pBase = new CDoc(pUnkOuter, CDoc::DOCTYPE_HTA);
    PerfDbgLog(tagPerfWatch, NULL, "-CreateHTADoc");
    return(pBase);
}

//+------------------------------------------------------------------------
//
//  Member:     CreateDocFullWindowEmbed
//
//  Synopsis:   Creates a new doc instance.  This version creates a doc
//              set up to perform the implicit full-window-embed support
//              for a URL referencing a plugin handled object.
//
//  Arguments:  pUnkOuter   Outer unknown
//
//  Returns:    HRESULT
//
//-------------------------------------------------------------------------

CBase *
CreateDocFullWindowEmbed(IUnknown * pUnkOuter)
{
    CBase * pBase;
    PerfDbgLog(tagPerfWatch, NULL, "+CreateDocFullWindowEmbed");
    pBase = new CDoc(pUnkOuter, CDoc::DOCTYPE_FULLWINDOWEMBED);
    PerfDbgLog(tagPerfWatch, NULL, "-CreateDocFullWindowEmbed");
    return(pBase);
}

// CHROME

//+------------------------------------------------------------------------
//
//  Member:     CreateChromeDoc
//
//  Synopsis:   Creates a new doc instance.  This version creates a doc
//              with the CHROME windowless-mshtml changes enabled.
//
//  Arguments:  pUnkOuter   Outer unknown
//
//  Returns:    HRESULT
//
//-------------------------------------------------------------------------

CBase * STDMETHODCALLTYPE
CreateChromeDoc(IUnknown * pUnkOuter)
{
    CBase * pBase;
    PerfDbgLog(tagPerfWatch, NULL, "+CreateChromeDoc");
    pBase = new CDoc(pUnkOuter, CDoc::DOCTYPE_CHROME);
    PerfDbgLog(tagPerfWatch, NULL, "-CreateChromeDoc");
    return(pBase);
}

//+------------------------------------------------------------------------
//
//  Member:     CDoc::GetClassDesc, CBase
//
//  Synopsis:   Return the class descriptor.
//
//-------------------------------------------------------------------------

const CBase::CLASSDESC *
CDoc::GetClassDesc() const
{
    return (CBase::CLASSDESC *)&s_classdesc;
}

//+------------------------------------------------------------------------
//
//  Member:     CDoc::SetReadyState
//
//  Synopsis:   Use this to set the ready state;
//              it fires OnReadyStateChange if needed.
//
//  Returns:    HRESULT
//
//-------------------------------------------------------------------------
HRESULT
CDoc::SetReadyState(long readyState)
{
    if (_readyState != readyState)
    {
        AssertSz(readyState > _readyState, "Readystate changed in wrong direction");

        PerfLog2(tagGasGauge, this, "%d 0 0 %ls", 100 + readyState, _cstrUrl ? _cstrUrl : _T(""));
        PerfDbgLog1(tagPerfWatch, this, "+CDoc::SetReadyState %s",
            readyState == READYSTATE_LOADING ? "LOADING" :
            readyState == READYSTATE_LOADED ? "LOADED" :
            readyState == READYSTATE_INTERACTIVE ? "INTERACTIVE" :
            readyState == READYSTATE_COMPLETE ? "COMPLETE" : "(Unknown)");

        _readyState = readyState;

        if ( _readyState == READYSTATE_COMPLETE )
        {
            if (_fNeedUpdateTitle)
            {
                PerfDbgLog(tagPerfWatch, this, "CDoc::SetReadyState (UpdateTitle)");
                UpdateTitle();
            }

            if (_pDSL)
            {
                PerfDbgLog(tagPerfWatch, this, "CDoc::SetReadyState (_pDSL->dataMemberChanged())");
                _pDSL->dataMemberChanged(_T(""));
            }
        }

        PerfDbgLog(tagPerfWatch, this, "CDoc::SetReadyState (FirePropertyNotify)");
        FirePropertyNotify( DISPID_READYSTATE, TRUE );
        
        PerfDbgLog(tagPerfWatch, this, "CDoc::SetReadyState (Fire_onreadystatechange)");
        Fire_onreadystatechange();

        PerfDbgLog(tagPerfWatch, this, "-CDoc::SetReadyState");
    }

    RRETURN(S_OK);
}

//+------------------------------------------------------------------------
//
//  Member:     CDoc::SetSpin
//
//  Synopsis:   Sets the animation state (the spinny globe)
//
//  Arguments:  fSpin: TRUE to spin the globe, FALSE to stop it
//
//  Returns:    HRESULT
//
//-------------------------------------------------------------------------
void
CDoc::SetSpin(BOOL fSpin)
{
    if (!!_fSpin != !!fSpin)
    {
        _fSpin = ENSURE_BOOL(fSpin);
        _fShownSpin = FALSE;

        UpdateLoadStatusUI();
    }
}


//+------------------------------------------------------------------------
//
//  Member:     CDoc::SetProgress
//
//  Synopsis:   Sets the position of the progress text+thermometer.
//
//  Arguments:  pchStatusText:  progress string, can be NULL
//              ulProgress:     less than or equal to ulProgressMax
//              ulProgressMax:  if zero, hides the thermometer
//              fFlash:         if TRUE, progress is cleared next time
//                              a SetStatusText string is shown
//
//  Returns:    HRESULT
//
//-------------------------------------------------------------------------
HRESULT
CDoc::SetProgress(DWORD dwFlags, TCHAR *pchText, ULONG ulPos, ULONG ulMax, BOOL fFlash)
{
    HRESULT hr;

    if (dwFlags & PROGSINK_SET_TEXT)
    {
        hr = THR(_acstrStatus[STL_PROGSTATUS].Set(pchText));
        if (hr)
            goto Cleanup;

        if (_iStatusTop >= STL_PROGSTATUS)
        {
            _iStatusTop = (pchText && *pchText) ? STL_PROGSTATUS : STL_LAYERS;
            _fShownProgText = FALSE;
        }
    }

    if (    (dwFlags & PROGSINK_SET_MAX)
        &&  _ulProgressMax != ulMax)
    {
        _ulProgressMax = ulMax;
        _fShownProgMax = FALSE;
    }

    if (    (dwFlags & PROGSINK_SET_POS)
        &&  _ulProgressPos != ulPos)
    {
        _ulProgressPos = ulPos;
        _fShownProgPos = FALSE;
    }

    _fProgressFlash = fFlash;

    hr = THR(UpdateLoadStatusUI());

Cleanup:
    RRETURN(hr);
}

void CDoc::Fire_onfocus()
{
    // if onblur was last fired then fire onfocus
    EnsureOmWindow();
    if (!_fFiredWindowFocus && _pOmWindow && !_fDesignMode && LoadStatus() >= LOADSTATUS_DONE)
    {
        // Enable window onblur firing next
        _fFiredWindowFocus = TRUE;
        GWPostMethodCall(_pOmWindow, ONCALL_METHOD(COmWindowProxy, Fire_onfocus, fire_onfocus), 0, TRUE, "COmWindowProxy::Fire_onfocus");
    }
}

void CDoc::Fire_onblur(BOOL fOnblurFiredFromWM)
{
    // if onfocus was last fired then fire onblur
    EnsureOmWindow();
    if (_fFiredWindowFocus && _pOmWindow && !_fDesignMode && LoadStatus() >= LOADSTATUS_DONE)
    {
        // Enable window onfocus firing next
        _fFiredWindowFocus = FALSE;
        GWPostMethodCall(_pOmWindow, ONCALL_METHOD(COmWindowProxy, Fire_onblur, fire_onblur), fOnblurFiredFromWM, TRUE, "COmWindowProxy::Fire_onblur");
    }
}

//+----------------------------------------------------------------------------
//
//  Member:     CDoc::Fire_onpropertychange
//
//  Synopsis:   Fires the onpropertychange event, sets up the event param
//
//+----------------------------------------------------------------------------

void
CDoc::Fire_onpropertychange(LPCTSTR strPropName)
{
    EVENTPARAM param(this, TRUE);

    param.SetType(_T("propertychange"));
    param.SetPropName(strPropName);

    FireEventHelper(DISPID_EVMETH_ONPROPERTYCHANGE,
                 DISPID_EVPROP_ONPROPERTYCHANGE,
                 (BYTE *) VTS_NONE);

}


void CDoc::SetFocusWithoutFiringOnfocus()
{
    BOOL fOldFiredWindowFocus = _fFiredWindowFocus;
    BOOL fInhibitFocusFiring = _fInhibitFocusFiring;

    // Do not fire window onfocus if the inplace window didn't
    // previously have the focus (NS compat)
    if (fInhibitFocusFiring)
        _fFiredWindowFocus = TRUE;
    // CHROME
    // If Chrome hosted there is no valid HWND so ::SetFocus() cannot be
    // used. Instead use CServer::SetFocus() which handles the windowless
    // case
    if (!IsChromeHosted())
        ::SetFocus(_pInPlace->_hwnd);
    else
        SetFocus(TRUE);
    // restore the old FiredFocus state
    if (fInhibitFocusFiring)
        _fFiredWindowFocus = fOldFiredWindowFocus;
}

//+------------------------------------------------------------------------
//
//  Member:     CDoc::OnLoadStatus
//
//  Synopsis:   Handles feedback from the downloader.
//
//  Arguments:  LoadStatus    The current type of feedback to give
//
//-------------------------------------------------------------------------

// Nonvirtual version for GWPostMethodCall
void BUGCALL
CDoc::OnLoadStatusCallback(DWORD_PTR LoadStatus)
{
    OnLoadStatus(LOADSTATUS( LoadStatus ));
}


void
CDoc::OnLoadStatus(LOADSTATUS LoadStatus)
{
    PerfDbgLog1(tagPerfWatch, this, "+CDoc::OnLoadStatus %s",
        LoadStatus == LOADSTATUS_INTERACTIVE ? "INTERACTIVE" :
        LoadStatus == LOADSTATUS_PARSE_DONE ? "PARSE_DONE" :
        LoadStatus == LOADSTATUS_QUICK_DONE ? "QUICK_DONE" :
        LoadStatus == LOADSTATUS_DONE ? "DONE" : "?");

    // this assert catches those who call CDoc::OnLoadStatus directly bypassing OnLoadStatus of primary markup;
    // that would lead to state of markup lower then requested state of the doc with all the bad consequences
    Assert (PrimaryMarkup()->LoadStatus() == LoadStatus);

    switch (LoadStatus)
    {
        case LOADSTATUS_INTERACTIVE:
        {
            // If we have a task to look for a certain scroll position,
            // make sure we have recalc'd at least to that point before
            // display.

            // Supress scrollbits if we're about to inval the entire window anyway
            NavigateNow(!_fInvalNoninteractive);

            // If we have prviously supressed invalidations before LOADSTATUS_INTERACTIVE,
            // we must invalidate now.
            if (_fInvalNoninteractive)
            {
                _fInvalNoninteractive = FALSE;
                Invalidate(NULL, NULL, NULL, INVAL_CHILDWINDOWS);
            }

            if (_readyState < READYSTATE_INTERACTIVE)
            {
                IGNORE_HR(GWPostMethodCall(this,
                    ONCALL_METHOD(CDoc, SetInteractive, setinteractive), READYSTATE_INTERACTIVE, FALSE, "CDoc::SetInteractive"));
            }

            break;
        }

        case LOADSTATUS_PARSE_DONE:
        {
            //  If the document's state is inplace, then it means that we could not fire 
            //  the onpropertychange in Fire. We should fire it here.
            if (_fOnPropertyChangePending)
            {   
                IGNORE_HR(GWPostMethodCall(this, 
                                            ONCALL_METHOD(CDoc, FirePostedOnPropertyChange, firepostedonpropertychange), 
                                            0, 
                                            TRUE, 
                                            "CDoc::FirePostedOnPropertyChange"));
            }

            // In design mode, set META generator tag to Trident, and
            // clear the dirty bit.
            if (_fDesignMode)
            {
                // Setting this meta tag is still part of the 
                // parse phase.  Becuase of this, we can safely
                // not save undo info if we end up sticking in a
                // meta tag here.
                Assert( ! PrimaryMarkup()->_fNoUndoInfo );
                PrimaryMarkup()->_fNoUndoInfo = TRUE;

                IGNORE_HR(SetMetaToTrident());

                PrimaryMarkup()->_fNoUndoInfo = FALSE;              
            }

            CHtmCtx *   pHtmCtx = HtmCtx();

            // When htm loading is complete, first check for failure
            // and alternate URL. If they exist, do a reload
            Assert(pHtmCtx);
            if (pHtmCtx && (pHtmCtx->GetState() & DWNLOAD_ERROR))
            {
                if (pHtmCtx->GetFailureUrl())
                {
                    IStream *pStreamRefresh;

                    pStreamRefresh = pHtmCtx->GetRefreshStream();
                    if (pStreamRefresh)
                    {
                        pStreamRefresh->AddRef();

                        IGNORE_HR(LoadFailureUrl(pHtmCtx->GetFailureUrl(), pStreamRefresh));
                        ClearInterface(&pStreamRefresh);
                        return;
                    }
                }
                else if (!(_dwLoadf & DLCTL_SILENT) && pHtmCtx->GetBindResult())
                {
                    IGNORE_HR(ShowLoadError(pHtmCtx));
                }
            }

            // If the currency has not been set, set it to the client element.
            DeferSetCurrency(0);

            UnwedgeFromPrinting();

            // Now is the time to ask the sites to load any history
            // that they could not earlier (e.g. scroll/caret positions
            // because they require the doc to be recalced, the site
            // arrays built, etc.)
            if (!_fDelayLoadHistoryDone && State() >= OS_INPLACE)
            {
                CNotification   nf;

                _fDelayLoadHistoryDone = TRUE;
                nf.DelayLoadHistory(PrimaryRoot());
                
                Assert( ! PrimaryMarkup()->_fNoUndoInfo );
                PrimaryMarkup()->_fNoUndoInfo = TRUE;

                BroadcastNotify(&nf);

                PrimaryMarkup()->_fNoUndoInfo = FALSE;
            }

            if (_pctPics)
            {
                _pctPics->Exec(&CGID_ShellDocView, SHDVID_NOMOREPICSLABELS,
                    0, NULL, NULL);
                ClearInterface(&_pctPics);
            }

            // Let the host know that parsing is done and they are free
            // to modify the document.

            if (_pClientSite)
            {
                CTExec(_pClientSite, (GUID *)&CGID_MSHTML,
                    IDM_PARSECOMPLETE, 0, NULL, NULL);
            }

            // If we tried to do DeleteUrlCacheEntry in meta.cxx and could not, do it here.
            if (_fDeleteUrlCacheEntry)
            {
                _fDeleteUrlCacheEntry = FALSE;
                DeleteUrlCacheEntry(_cstrUrl);        // Can't do much else if this fails.
            }

            break;
        }

        case LOADSTATUS_QUICK_DONE:
        {
            if (_fDelegateWindowOM)
            {
                CVariant varIn(VT_BOOL);
                V_BOOL(&varIn) = FALSE;

                // If we are delegating window methods to shdocvw, inform it that it 
                // shouldn't delegate back to us.
                CTExec(_pClientSite, (GUID *)&CGID_ShellDocView,
                    SHDVID_DELEGATEWINDOWOM, 0, &varIn, NULL);
                
            }
            
            IGNORE_HR(CommitScripts());


            if (!_fDesignMode && _pScriptCollection)
            {
                IGNORE_HR(_pScriptCollection->SetState(SCRIPTSTATE_CONNECTED));
            }

            // if any <OBJECT>s have failed to instantiate, let's Fire_onerror
            // and hopefully replace them with the altHtml!

            if (!_fDesignMode)
            {
                int i = _aryDefunctObjects.Size();
                CObjectElement ** ppDefunctElement = _aryDefunctObjects;
                for ( ; i--; ++ppDefunctElement)
                {
                    //
                    // fire the onerror event to see if anyone wants to handle this case for us.
                    // unless we get back FALSE, do the default processing
                    //

                    BOOL fRet = (*ppDefunctElement)->Fire_onerror();
                    if (fRet)
                    {
                        TCHAR * pchAltHtml = (LPTSTR)(*ppDefunctElement)->GetAAaltHtml();
                        
                        if (pchAltHtml)
                        {
                            IGNORE_HR(
                                (*ppDefunctElement)->Inject(
                                    CElement::Outside, TRUE, pchAltHtml, _tcslen( pchAltHtml ) ) );
                        }
                    }
                }
            }

#if DBG==1
            Assert( _pPrimaryMarkup );
            Assert( _pPrimaryMarkup->IsSplayValid() );
#endif

#ifndef NO_DATABINDING
            SetDataBindingEnabled(TRUE);    // do any deferred databinding
#endif // ndef NO_DATABINDING

#ifdef VSTUDIO7
            // Fire readyState event notification for QuickDone.
            PerfDbgLog(tagPerfWatch, this, "CDoc::SetReadyState (FirePropertyNotify)");
            FirePropertyNotify( DISPID_READYSTATE, TRUE );

            PerfDbgLog(tagPerfWatch, this, "CDoc::SetReadyState (Fire_onreadystatechange)");
            Fire_onreadystatechange();
#endif //VSTUDIO7
            break;
        }

        case LOADSTATUS_DONE:
        {
            GWKillMethodCall(this, ONCALL_METHOD(CDoc, SetInteractive, setinteractive), 0);

            if (_pClientSite)
            {
                CTExec(_pClientSite, NULL, OLECMDID_HTTPEQUIV_DONE,
                    0, NULL, NULL);
            }

            // Unfreeze events now that document is fully loaded.
            {
                CNotification nf;
                
                nf.FreezeEvents(PrimaryRoot(), (void *)FALSE);
                BroadcastNotify(&nf);
            }
            
            SetReadyState(READYSTATE_COMPLETE);

            // Fire window onfocus() to start with, if we have the focus, after frameset
            // or body has become current as this will not be fired in BecomeCurrent()
            if (   _pElemCurrent == GetPrimaryElementClient() 
                && _pInPlace
                && ::GetFocus() == _pInPlace->_hwnd)
            {
                Assert(_state >= OS_UIACTIVE);
                Fire_onfocus();
            }

            // Do not fire onload if we are not inplace & either scripting is
            // disabled or we are a dialog.

            if (    !_fFiredOnLoad
                && (   State() >= OS_INPLACE
                    || (    !(_dwFlagsHostInfo & DOCHOSTUIFLAG_DISABLE_SCRIPT_INACTIVE)
                                  && !_fInHTMLDlg)))
            {
                // Note that Netscape fires onunload later even if it hadn't fired onload
                _fFiredOnLoad = TRUE;

                if (_pOmWindow)
                {
                    CDoc::CLock Lock(this);

                    // 18849: fire onload only if load was not interrupted

                    if (HtmCtx() && !(HtmCtx()->GetState() & (DWNLOAD_ERROR | DWNLOAD_STOPPED)))
                    {
                        // BUGBUG (carled) this is temporary until we can fix the parser to allow
                        // these events at enterTree time.
                        if (_cstrHistoryUserData || _pShortcutUserData)
                            FirePersistOnloads();

                        _pOmWindow->Fire_onload();
                    }

                    // Let the client site know we are loaded
                    // Only HTMLDialog pays attention to this
                    if (_pClientSite && _fInHTMLDlg)
                    {
                        CTExec(_pClientSite, &CLSID_HTMLDialog,
                               0, 0, NULL, NULL);
                    }
                }
            }

            if (!_fDesignMode)
            {
                CElement * pElemDefault = _pElemCurrent ?
                                _pElemCurrent->FindDefaultElem(TRUE) : 0;
                if (pElemDefault)
                {
                    CNotification   nf;

                    nf.AmbientPropChange(pElemDefault, (void *)DISPID_AMBIENT_DISPLAYASDEFAULT);
                    pElemDefault->_fDefault = TRUE;
                    pElemDefault->Notify(&nf);
                } 
            }
            else
            {
                //
                // We may have been flipped from edit to browse back to edit.
                // In which case the _fShowZeroBorder Bit is correctly set,
                // but we need to fire a notification through the document to 
                // let everyone know.
                //
                if ( _fShowZeroBorderAtDesignTime )
                {
                    _view.SetFlag(CView::VF_ZEROBORDER); 
                    
                    CNotification nf;
                    nf.ZeroGrayChange(GetPrimaryElementTop());
                    BroadcastNotify( & nf );
                } 
            }
            
            // From now on, new downloads don't follow the refresh binding
            // flags used to load the document.

            _pDwnDoc->SetBindf(_pDwnDoc->GetBindf() &
                ~(BINDF_RESYNCHRONIZE|BINDF_GETNEWESTVERSION|
                    BINDF_PRAGMA_NO_CACHE));

            // If the document was loaded due to an http 449 status code, we need to kick off a refresh
            // now that we're done loading

            if (HtmCtx() && HtmCtx()->IsHttp449())
            {
                IGNORE_HR(GWPostMethodCall(this,
                                           ONCALL_METHOD(CDoc, ExecRefreshCallback, execrefreshcallback),
                                           OLECMDIDF_REFRESH_NORMAL | OLECMDIDF_REFRESH_CLEARUSERINPUT,
                                          FALSE, "CDoc::ExecRefreshCallback"));
            }

            #if DBG==1 || defined(PERFTAGS)
            if (IsPerfDbgEnabled(tagDocBytesRead))
            {
                VARIANT vt;
                Exec((GUID *)&CGID_MSHTML, IDM_GETBYTESDOWNLOADED,
                    MSOCMDEXECOPT_DONTPROMPTUSER, NULL, &vt);
                Assert(_pDwnDoc->GetBytesRead() == (DWORD)vt.lVal);
                PerfDbgLog1(tagDocBytesRead, this, "CDoc::OnLoadStatus (%ld bytes downloaded)", vt.lVal);
            }
            #endif

            if (g_pHtmPerfCtl && (g_pHtmPerfCtl->dwFlags & HTMPF_CALLBACK_ONLOAD) && IsRootDoc())
            {
                // We shouldn't calc a print doc at this point because our view isn't initialized yet (42603).
                if (!IsPrintDoc())
                    WaitForRecalc();

                g_pHtmPerfCtl->pfnCall(HTMPF_CALLBACK_ONLOAD, _cstrUrl);
            }

            break;
        }

        default:
        {
            Assert(0 && "Bad enum value");
            return;
        }
    }

    PerfDbgLog(tagPerfWatch, this, "-CDoc::OnLoadStatus");
}

//+------------------------------------------------------------------------
//
//  Member:     CDoc::SetStatusText
//
//  Synopsis:   Sets status text, remembering it if not in-place active.
//              Passing NULL clears status text.
//
//  Returns:    HRESULT
//
//-------------------------------------------------------------------------
HRESULT
CDoc::SetStatusText(TCHAR *pchStatusText, LONG statusLayer)
{
    HRESULT hr = S_OK;
    
    // A child frame's call to SetStatusText seems to be blocked by shdocvw;
    // so need to get the root doc, as it will always allow access to IOleInPlaceFrame's functions.
    // for non-frame documents, GetRootDoc will return this, so we are ok.
    
    if (_pDocParent)
    {
        RRETURN(GetRootDoc()->SetStatusText(pchStatusText, statusLayer));
    }

    // _fProgressFlash means that next time we have real status to show,
    // the progress text should be cleared (used for "Done"). So if we have
    // real status, clear progress.

    if (_fProgressFlash && pchStatusText && *pchStatusText)
    {
        SetProgress(PROGSINK_SET_TEXT | PROGSINK_SET_POS | PROGSINK_SET_MAX, NULL, 0, 0);
        _fProgressFlash = FALSE;
    }

    // NS compat: after window.defaultStatus has been set, the behavior changes
    if (statusLayer == STL_DEFSTATUS)
        _fSeenDefaultStatus = TRUE;
        
    LONG c;
    CStr *pcstr;

    hr = THR(_acstrStatus[statusLayer].Set(pchStatusText));
    if (hr)
        goto Cleanup;
        
    // Figure out what should be showing on the status bar (_iStatusTop):
    if (pchStatusText && *pchStatusText)
    {
        // NS compat: when nonempty, rollstatus, status, or defaultStatus go directly to the status bar
        // (For NS compat examples, see IE5 bug 65272, 65880)
        
        if (_iStatusTop >= statusLayer || statusLayer <= STL_DEFSTATUS)
        {
            _iStatusTop = statusLayer;
            UpdateStatusText();
        }
    }
    else
    {
        // NS compat: when clearing rollstatus, status, or default status, status bar will show:
        // window.status or lower layers if .defaultStatus has never been set or
        // window.defaultStatus or lower layers if .defaultStatus has been set.
        
        if (_iStatusTop <= statusLayer || statusLayer <= STL_DEFSTATUS)
        {
            LONG startLayer;

            startLayer = (_fSeenDefaultStatus ? STL_DEFSTATUS : STL_TOPSTATUS);
            for (pcstr = _acstrStatus + startLayer, c = STL_LAYERS - startLayer; c; pcstr += 1, c -= 1)
            {
                if (*pcstr && **pcstr)
                    break;
            }
            _iStatusTop = pcstr - _acstrStatus;
            UpdateStatusText();
        }
    }

Cleanup:
    RRETURN(hr);
}


//+------------------------------------------------------------------------
//
//  Member:     CDoc::UpdateStatusText
//
//  Synopsis:   Sets status text, remembering it if not in-place active.
//              Passing NULL clears status text.
//
//  Returns:    HRESULT
//
//-------------------------------------------------------------------------
HRESULT
CDoc::UpdateStatusText()
{
    HRESULT hr = S_OK;
    
    if (_pInPlace && _pInPlace->_pFrame)
    {
        TCHAR *pchStatusText;

        // IE5 59311: don't report progress text to Outlook 98

        if (_iStatusTop < STL_LAYERS && (_fProgressStatus || _iStatusTop < STL_PROGSTATUS))
            pchStatusText = _acstrStatus[_iStatusTop];
        else
            pchStatusText = NULL;
        
        hr = THR(_pInPlace->_pFrame->SetStatusText(pchStatusText));
    }

    RRETURN(hr);
}


//+------------------------------------------------------------------------
//
//  Member:     CDoc::RefreshStatusUI
//
//  Synopsis:   Causes all status UI to be refreshed; used when becoming
//              in-place active.
//
//  Returns:    HRESULT
//
//-------------------------------------------------------------------------
void
CDoc::RefreshStatusUI()
{
    _fShownProgPos  = FALSE;
    _fShownProgMax  = FALSE;
    _fShownProgText = FALSE;
    _fShownSpin     = !_fSpin;
    UpdateLoadStatusUI();
}

//+------------------------------------------------------------------------
//
//  Member:     CDoc::UpdateStatusUI
//
//  Synopsis:   Updates status text, progress text, progress thermometer,
//              and spinning globe of client.
//
//  Returns:    HRESULT
//
//-------------------------------------------------------------------------
HRESULT
CDoc::UpdateLoadStatusUI()
{
    IOleCommandTarget * pCommandTarget;
    HRESULT hr = S_OK;

    if (IsRootDoc() && _pClientSite)
    {
        VARIANTARG var;

        hr = THR_NOTRACE(_pClientSite->QueryInterface(
                IID_IOleCommandTarget,
                (void **)&pCommandTarget));
        if (hr)
            goto Cleanup;

        if (!_fShownProgText)
        {
            THR_NOTRACE(UpdateStatusText());
            _fShownProgText = TRUE;
        }

        if (!_fShownProgMax)
        {
            var.vt = VT_I4;
            var.lVal = _ulProgressMax;
            pCommandTarget->Exec(NULL, OLECMDID_SETPROGRESSMAX,
                MSOCMDEXECOPT_DONTPROMPTUSER, &var, NULL);
            _fShownProgMax = TRUE;
        }

        if (!_fShownProgPos)
        {
            var.vt = VT_I4;
            var.lVal = _ulProgressPos;
            pCommandTarget->Exec(NULL, OLECMDID_SETPROGRESSPOS,
                MSOCMDEXECOPT_DONTPROMPTUSER, &var, NULL);
            _fShownProgPos = TRUE;
        }

        if (!_fShownSpin)
        {
            var.vt = VT_I4;
            var.lVal = _fSpin;
            pCommandTarget->Exec(NULL, OLECMDID_SETDOWNLOADSTATE,
                    MSOCMDEXECOPT_DONTPROMPTUSER, &var, NULL);
            _fShownSpin = TRUE;
        }

        pCommandTarget->Release();
    }

Cleanup:
    RRETURN(hr);
}


//+--------------------------------------------------------------
//
//  Member:     CDoc::HandleKeyNavigate
//
//  Synopsis:   Navigate to the next CSite/CElement that can take focus
//              based on the message.
//
//---------------------------------------------------------------

HRESULT
CDoc::HandleKeyNavigate(CMessage * pmsg, BOOL fAccessKeyNeedCycle)
{
    HRESULT         hr       = S_FALSE;
    FOCUS_DIRECTION dir = (pmsg->dwKeyState & FSHIFT) ?
                            DIRECTION_BACKWARD: DIRECTION_FORWARD;
    CElement *      pCurrent = NULL;
    CElement *      pNext = NULL;
    CElement *      pStart = NULL;
    long            lSubNew = _lSubCurrent;
    BOOL            fFindNext = FALSE;
    CElement *      pElementClient = GetPrimaryElementClient();

    // It is possible to have site selection even at browse time, if the user
    // is tabbing in an editable container such as HTMLAREA.
    BOOL            fSiteSelected   = (GetSelectionType() == SELECTION_TYPE_Control);
    BOOL            fSiteSelectMode = (_fDesignMode || fSiteSelected);
    BOOL            fYieldFailed = FALSE;

    if (!pElementClient)
    {
        hr = S_FALSE;
        goto Cleanup;
    }

    // FrameTab key is used to tab among frames. If this is not a frameset,
    // the usual thing to do is to pass up the message so that it goes to the
    // parent frameset document. However, if pmsg->lParam == 0, then it means
    // that pmsg is passed down from the parent document's CFrameSite, so
    // _pElemClient is activated.
    if (pElementClient->Tag() != ETAG_FRAMESET && IsFrameTabKey(pmsg))
    {
        if (pmsg->lParam)
        {
            hr = S_FALSE;
        }
        else
        {
            hr = THR(pElementClient->BecomeCurrentAndActive(pmsg, pmsg->lSubDivision, TRUE));
        }
        goto Cleanup;
    }

    //
    // Detect time when this is the first time tabbing into the doc
    // and bail out in that case.  Let the shell take focus.
    //

    if (_fFirstTimeTab)
    {
        // This bit should only be set under certain circumstances.
        Assert(this == GetRootDoc());
        hr = S_FALSE;
        _fFirstTimeTab = FALSE;
        goto Cleanup;
    }

    //
    // First find the element from which to start
    //

    if ((!fSiteSelectMode && _pElemCurrent == PrimaryRoot()) ||
        (fAccessKeyNeedCycle && pmsg->message == WM_SYSKEYDOWN) ||
        (IsTabKey(pmsg) && !pmsg->lParam))
    {
        if ((IsTabKey(pmsg)) && (!pmsg->lParam) && (DIRECTION_FORWARD == dir))
        {
            // Raid 61972
            // we just tab down to a frame CBodyElement, need to set the flag
            // so we know we need to tab out when SHIFT+_TAB
            //
            _fNeedTabOut = TRUE;
        }
        pStart = NULL;
        fFindNext = TRUE;
    }
    else if (!fSiteSelectMode && _pElemCurrent->IsTabbable(_lSubCurrent))
    {
        pStart = _pElemCurrent;
        fFindNext = TRUE;
    }
    else if (_pElemCurrent->Tag() != ETAG_ROOT)
    {
        // Tab to the element next to the caret/selection (unless the root element is
        // current - bug #65023)
        IHTMLEditor*    pEditor     = GetHTMLEditor(TRUE);
        IHTMLElement *  pIElement   = NULL;
        CElement *      pElemStart  = NULL;
        BOOL            fNext       = TRUE;

        Assert(pEditor);
        if ( pEditor && S_OK == pEditor->GetElementToTabFrom( dir == DIRECTION_FORWARD, &pIElement, &fNext)
            &&  pIElement)
        {
            Verify(S_OK == pIElement->QueryInterface(CLSID_CElement, ( void**) & pElemStart));
            Assert(pElemStart);

            if (pElemStart->Tag() == ETAG_TXTSLAVE)
            {
                pElemStart = pElemStart->MarkupMaster();
            }
            if (pElemStart)
            {
                pStart = pElemStart;
                fFindNext = fNext || !pStart->IsTabbable(_lSubCurrent);
                if (!fFindNext)
                {
                    pCurrent = pStart;
                }
            }
            pIElement->Release();
        }
        if (!pElemStart)
        {
            pStart = _pElemCurrent;
            fFindNext = TRUE;
        }
    }
    else
    {
        pStart = NULL;
        fFindNext = TRUE;
    }

    if (pStart && pStart == pElementClient && !pStart->IsTabbable(_lSubCurrent))
    {
        pStart = NULL;
    }

    if (fFindNext)
    {
        Assert(!pCurrent);
        if (IsTabKey(pmsg) || IsFrameTabKey(pmsg))
            FindNextTabOrder(dir, pStart, _lSubCurrent, &pCurrent, &lSubNew);
        else
            SearchAccessKeyArray(dir, pStart, &pCurrent, pmsg);
    }

    hr = S_FALSE;
    if (!pCurrent)
        goto Cleanup;

    // This better not be FrameTab unless the doc is a frameset doc.
    Assert (pElementClient->Tag() == ETAG_FRAMESET || !IsFrameTabKey(pmsg));

    if (IsTabKey(pmsg) || IsFrameTabKey(pmsg))
    {
        do
        {
            if (pNext)
            {
                pCurrent = pNext;
            }

            pmsg->lSubDivision = lSubNew;

            // Raid 61972
            // Set _fNeedTabOut if pCurrent is a CBodyElement so that we will
            // not try to SHIFT+TAB to CBodyElement again.
            //
            _fNeedTabOut = (!_fDesignMode && (pCurrent->Tag() == ETAG_BODY))
                         ? TRUE : FALSE;

            hr = THR_NOTRACE(pCurrent->HandleMnemonic(pmsg, FALSE, &fYieldFailed));
            Assert(!(hr == S_OK && fYieldFailed));
            if(hr && fYieldFailed)
            {
                hr = S_OK;
            }
        }
        while (hr == S_FALSE &&
               FindNextTabOrder(dir, pCurrent, pmsg->lSubDivision, &pNext, &lSubNew) &&
               pNext);
    }
    else
    {
        // accessKey case here
        //
        _fNeedTabOut = FALSE;
        do
        {
            if (pNext)
                pCurrent = pNext;

            FOCUS_ITEM fi = pCurrent->GetMnemonicTarget();

            if (fi.pElement)
            {
                if (fi.pElement == pCurrent)
                {
                    pmsg->lSubDivision = fi.lSubDivision;
                    hr = THR_NOTRACE(fi.pElement->HandleMnemonic(pmsg, TRUE));
                }
                else
                {
                    CMessage msg;

                    msg.message = WM_KEYDOWN;
                    msg.wParam = VK_TAB;
                    msg.lSubDivision = fi.lSubDivision;
                    hr = THR_NOTRACE(fi.pElement->HandleMnemonic(&msg, TRUE));
                }
            }

            if (hr == S_FALSE)
            {
                SearchAccessKeyArray(dir, pCurrent, &pNext, pmsg);
            }
        }
        while (hr == S_FALSE && pNext);
    }

Cleanup:
    RRETURN1(hr, S_FALSE);
}


//+---------------------------------------------------------------------------
//
//  Member:     CDoc::FindNextTabOrder
//
//  Synopsis:   Given an element and a subdivision within it, find the
//              next tabbable item.
//
//----------------------------------------------------------------------------

BOOL
CDoc::FindNextTabOrder(
    FOCUS_DIRECTION dir,
    CElement * pCurrent,
    long lSubCurrent,
    CElement **ppNext,
    long *plSubNext)
{
    BOOL        fFound      = FALSE;
    CElement *  pElemTemp   = pCurrent;
    long        lSubTemp    = lSubCurrent;

    for(;;)
    {
        *ppNext    = NULL;
        *plSubNext = 0;

        // When Shift+Tabbing, start the search with those not in the Focus array (because
        // they are at the bottom of the tab order)
        if (!pCurrent && DIRECTION_BACKWARD == dir)
            break;

        fFound = SearchFocusArray(dir, pElemTemp, lSubTemp, ppNext, plSubNext);
        
        if (!fFound || !*ppNext || (*ppNext)->IsTabbable(*plSubNext))
            break;

        Assert(pElemTemp != *ppNext || lSubTemp != *plSubNext);

        pElemTemp   = *ppNext;
        lSubTemp    = *plSubNext;
    }

    if (!*ppNext)
    {
        if (fFound)
        {
            if (DIRECTION_BACKWARD == dir)
            {
                return TRUE;
            }
            else
            {
                //
                // Means pCurrent was in focus array, but next tabbable item is not
                // Just retrieve the first tabbable item from the tree.
                //

                pCurrent = NULL;
                lSubCurrent = 0;
            }
        }

        fFound = SearchFocusTree(dir, pCurrent, lSubCurrent, ppNext, plSubNext);

        //
        // If element was found, but next item is not in
        // the tree and we're going backwards, return the last element in
        // the focus array.
        //

        if (!*ppNext &&
            (fFound || !pCurrent) &&
            dir == DIRECTION_BACKWARD &&
            _aryFocusItems.Size() > 0)
        {
            long    lLast = _aryFocusItems.Size() - 1;

            while (lLast >= 0)
            {
                pElemTemp = _aryFocusItems[lLast].pElement;
                lSubTemp = _aryFocusItems[lLast].lSubDivision;
                if (pElemTemp->IsTabbable(lSubTemp))
                {
                    *ppNext = pElemTemp;
                    *plSubNext = lSubTemp;
                    fFound = TRUE;
                    break;
                }
                lLast--;
            }
        }
    }

    return fFound;
}


//+--------------------------------------------------------------
//
//  Member:     CDoc::DocTraverseGroup
//
//  Synopsis:   Called by (e.g.)a radioButton, this function
//      takes the groupname and queries the document's collection for the
//      rest of the group and calls the provided CLEARGROUP function on that
//      element. The traversal stops if the visit function returns S_OK or
//      and an error.
//
//---------------------------------------------------------------

HRESULT
CDoc::DocTraverseGroup(
        LPCTSTR                 strGroupName,
        PFN_VISIT               pfn,
        DWORD_PTR               dw,
        BOOL                    fForward)
{
    HRESULT             hr;
    long                i, c;
    CElement          * pElement;
    CCollectionCache  * pCollectionCache;
    LPCTSTR             lpName;

    _fInTraverseGroup = TRUE;

    // The control is at the document level. Clear all other controls,
    // also at document level, which are in the same group as this control.
    Assert(_pPrimaryMarkup);
    hr = THR(_pPrimaryMarkup->EnsureCollectionCache(CMarkup::ELEMENT_COLLECTION));
    if (hr)
        goto Cleanup;

    pCollectionCache = _pPrimaryMarkup->CollectionCache();
    Assert(pCollectionCache);

    // get size of collection
    c = pCollectionCache->SizeAry(CMarkup::ELEMENT_COLLECTION);

    if (fForward)
        i = 0;
    else
        i = c - 1;

    // if nothing is in the collection, default answer is S_FALSE.
    hr = S_FALSE;

    while (c--)
    {
        hr = THR(pCollectionCache->GetIntoAry(CMarkup::ELEMENT_COLLECTION, i, &pElement));
        if (fForward)
            i++;
        else
            i--;
        if (hr)
            goto Cleanup;

        hr = S_FALSE;                   // default answer again.

        // ignore the element if it is not a site
        if (!pElement->NeedsLayout())
            continue;

        // ignore the element if it is in a form
        if (pElement->GetParentForm())
            continue;

        lpName = pElement->GetAAname();

        // is this item in the target group?
        if ( lpName && FormsStringICmp(strGroupName, lpName) == 0 )
        {
            // Call the function and break out of the
            // loop if it doesn't return S_FALSE.
#ifdef WIN16
            hr = THR( (*pfn)(pElement, dw) );
#else
            hr = THR( CALL_METHOD(pElement, pfn, (dw)) );
#endif
            if (hr != S_FALSE)
                break;
        }
    }

Cleanup:
    _fInTraverseGroup = FALSE;
    RRETURN1(hr, S_FALSE);
}

//+--------------------------------------------------------------
//
//  Member:     CDoc::FindDefaultElem
//
//  Synopsis:   find the default/Cancel button in the Doc
//
//              fCurrent means looking for the current default layout
//
//---------------------------------------------------------------
CElement *
CDoc::FindDefaultElem(BOOL fDefault, BOOL fCurrent /* FALSE */)
{
    HRESULT             hr      = S_FALSE;
    long                c       = 0;
    long                i       = 0;
    CElement          * pElem   = NULL;
    CCollectionCache  * pCollectionCache;

    Assert(_pPrimaryMarkup);
    hr = THR(_pPrimaryMarkup->EnsureCollectionCache(CMarkup::ELEMENT_COLLECTION));
    if (hr)
        goto Cleanup;

    pCollectionCache = _pPrimaryMarkup->CollectionCache();
    Assert(pCollectionCache);

    // Collection walker cached the value on the doc, go get it

    // get size of collection
    c = pCollectionCache->SizeAry(CMarkup::ELEMENT_COLLECTION);

    while (c--)
    {
        hr = THR(pCollectionCache->GetIntoAry(CMarkup::ELEMENT_COLLECTION,
                        i++,
                        &pElem));

        if (hr)
        {
            pElem = NULL;
            goto Cleanup;
        }

        if (!pElem || pElem->_fExittreePending)
            continue;

        if (fCurrent)
        {
            if (pElem->_fDefault)
                goto Cleanup;
            continue;
        }

        if (pElem->TestClassFlag(fDefault?
                    CElement::ELEMENTDESC_DEFAULT
                    : CElement::ELEMENTDESC_CANCEL)
            && !pElem->GetParentForm()
            && pElem->IsVisible(TRUE)
            && pElem->IsEnabled())
        {
            goto Cleanup;
        }
    }
    pElem = NULL;

Cleanup:
    return pElem;
}

//+----------------------------------------------------------------------
//
//  Member:     CDoc::GetElementClient
//
//  Synopsis:   returns CFrameSetSite in document, if the doc contains one
//
//-----------------------------------------------------------------------

CElement *
CDoc::GetPrimaryElementClient ( )
{
    return _pPrimaryMarkup ? _pPrimaryMarkup->GetElementClient() : NULL;
}

CElement *
CDoc::GetPrimaryElementTop ( )
{
    return _pPrimaryMarkup ? _pPrimaryMarkup->GetElementTop() : NULL;
}

//+----------------------------------------------------------------------
//
//  Member:     CDoc::GetOmWindow
//
//  Synopsis:   returns IDispatch of frame # nFrame;
//              the IDispatch is script window of doc inside the frame
//
//-----------------------------------------------------------------------

HRESULT
CDoc::GetOmWindow (LONG nFrame, IHTMLWindow2 ** ppOmWindow)
{
    CElement * pElem;
    HRESULT hr;

    hr = THR(_pPrimaryMarkup->EnsureCollectionCache(CMarkup::FRAMES_COLLECTION));
    if (hr)
        goto Cleanup;

    hr = THR(_pPrimaryMarkup->CollectionCache()->GetIntoAry (CMarkup::FRAMES_COLLECTION, nFrame, &pElem ));
    if ( hr )
        goto Cleanup;

    hr = THR((DYNCAST(CFrameSite,pElem))->GetOmWindow ( ppOmWindow ));

Cleanup:
    RRETURN (hr);
}

//+----------------------------------------------------------------------
//
//  Member:     CDoc::GetFramesCount
//
//  Synopsis:   returns number of frames in frameset;
//              fails if the doc does not contain frameset
//
//-----------------------------------------------------------------------

HRESULT
CDoc::GetFramesCount (LONG * pcFrames)
{
    HRESULT             hr;
    CElement      *     pElement;

    if (!pcFrames)
        RRETURN (E_POINTER);

#if 0 // Is this comment still valid here?
    // Bad coding practice - taking the address of a ptr and
    // casting it to be a ptr to a ptr of something else is just
    // not portable. -> hr = THR(GetElementClient((CSite**)&pFrameSet));
#endif

    pElement = GetPrimaryElementClient();

    if (!pElement || pElement->Tag() != ETAG_FRAMESET)
    {
        *pcFrames = 0;

        hr = S_OK;  // BUGBUG: Why return S_OK if GetClientSite failed?
    }
    else
        hr = THR( DYNCAST( CFrameSetSite, pElement )->GetFramesCount( pcFrames ) );

    RRETURN( hr );
}

#ifndef NO_DATABINDING
//+-------------------------------------------------------------------------
//
// Member:              Get Data Bind Task (public)
//
// Synopsis:    return my databind task, creating one if necessary.
//              Used only by databinding code, where the real work is done.
//
//-------------------------------------------------------------------------

CDataBindTask *
CDoc::GetDataBindTask()
{
    if (!_pDBTask)
    {
        _pDBTask = new CDataBindTask(this);
        if (_pDBTask)
            _pDBTask->SetEnabled(_fDataBindingEnabled);
    }
    return _pDBTask;
}


//+-------------------------------------------------------------------------
//
// Member:              Get Simple Data Converter (public)
//
// Synopsis:    return my data converter, creating one if necessary.
//              Used only by databinding code, to handle elements bound with
//              dataFormatAs = localized-text.
//
//-------------------------------------------------------------------------

ISimpleDataConverter *
CDoc::GetSimpleDataConverter()
{
    AssertSz(_pDBTask, "SimpleDataConverter used when no databinding present");
    return _pDBTask->GetSimpleDataConverter();
}


//+-------------------------------------------------------------------------
//
// Member:      SetDataBindingEnabled (public)
//
// Synopsis:    Set the enabled flag on my databind task (if any).
//              If this enables the task, then tell it to run.
//
// Returns:     previous value of enabled flag
//-------------------------------------------------------------------------

BOOL
CDoc::SetDataBindingEnabled(BOOL fEnabled)
{
    BOOL fOldValue = _fDataBindingEnabled;

    _fDataBindingEnabled = fEnabled;
    if (_pDBTask)
    {
        _pDBTask->SetEnabled(fEnabled);
        if (!fOldValue && fEnabled)
            TickleDataBinding();
    }
    return fOldValue;
}


//+-------------------------------------------------------------------------
//
// Member:              TickleDataBinding (public)
//
// Synopsis:    Ask my databind task to try to bind all the deferred
//              bindings.  This can be called repeatedly, as more bindings
//              enter the world.
//-------------------------------------------------------------------------

void
CDoc::TickleDataBinding()
{
    if (_pDBTask)
        _pDBTask->DecideToRun();
}


//+-------------------------------------------------------------------------
//
// Member:              ReleaseDataBinding (public)
//
// Synopsis:    Release my databinding resources.
//
//-------------------------------------------------------------------------

void
CDoc::ReleaseDataBinding()
{
    if (_pDBTask)
    {
        _pDBTask->Terminate();
        _pDBTask->Release();
        _pDBTask = 0;
    }
    SetDataBindingEnabled(FALSE);
}
#endif // ndef NO_DATABINDING

//+------------------------------------------------------------------------
//
// Utility function to force layout on all windows in the thread
//
//-------------------------------------------------------------------------

void
OnSettingsChangeAllDocs(BOOL fNeedLayout)
{
    int i;

    for (i = 0; i < TLS(_paryDoc).Size(); i++)
    {
        TLS(_paryDoc)[i]->OnSettingsChange(fNeedLayout);
    }
}

//+---------------------------------------------------------------------------
//
// OnOptionSettingsChange()
//
//----------------------------------------------------------------------------
HRESULT
CDoc::OnSettingsChange(BOOL fForce /* =FALSE */)
{
    BOOL fNeedLayout = FALSE;

    if (!IsPrintDoc())
    {
#ifndef NO_SCRIPT_DEBUGGER
        BYTE fDisableScriptDebuggerOld = _pOptionSettings ?
            _pOptionSettings->fDisableScriptDebugger : BYTE(-1);
#endif // NO_SCRIPT_DEBUGGER

        IGNORE_HR(UpdateFromRegistry(REGUPDATE_REFRESH, &fNeedLayout));

        if (_pOptionSettings)
        {
            THREADSTATE * pts = GetThreadState();

    #ifndef NO_SCRIPT_DEBUGGER
            Assert (fDisableScriptDebuggerOld != BYTE(-1));

            if (!_pOptionSettings->fDisableScriptDebugger &&
                 (fDisableScriptDebuggerOld == 1))
            {
                //
                // The user has chosen to enable the script debugger, which had
                // been disabled.  Now any scripts need to be re-parsed, which
                // means that the document needs to be reloaded.
                //
                ExecRefresh(OLECMDIDF_REFRESH_RELOAD);
            }
            else
            {
                if (_pOptionSettings->fDisableScriptDebugger &&
                    !fDisableScriptDebuggerOld &&
                    _pScriptCollection)
                {
                    //
                    // The user has chosen to turn off the script debugger,
                    // which was previously enabled.
                    //

                    DeinitScriptDebugging();
                }
    #endif // NO_SCRIPT_DEBUGGER

                if (fNeedLayout || fForce)
                {
                    ClearDefaultCharFormat();
                    ForceRelayout();
                }

    #ifndef NO_SCRIPT_DEBUGGER
            }
    #endif // NO_SCRIPT_DEBUGGER
            pts->_iFontHistoryVersion++;

        }
        UpdateDefaultPrinter();
    }
    return S_OK;
}

//+------------------------------------------------------------------------
//
//  Member:     SwitchCodePage
//
//  Synopsis:   Change the codepage of the document.  Should only be used
//              when we are already at a valid codepage setting.
//
//-------------------------------------------------------------------------

HRESULT
CDoc::SwitchCodePage( CODEPAGE codepage )
{
    HRESULT hr = S_OK;
    BOOL fReadCodePageSettings;
    UINT uiFamilyCodePage = CP_UNDEFINED;

#ifndef WIN16
    // Remember if we were autodetected
    _fCodePageWasAutoDetect = _codepage == CP_AUTO_JP;

    // If codepage settings don't exist or the information is stale,
    // reset the information, as well as the charformat cache.
    
    if (_pCodepageSettings)
    {
        if (_pCodepageSettings->uiFamilyCodePage != codepage)
        {
            uiFamilyCodePage = WindowsCodePageFromCodePage(codepage);

            fReadCodePageSettings = _pCodepageSettings->uiFamilyCodePage != uiFamilyCodePage;
        }
        else
        {
            fReadCodePageSettings = FALSE;
        }
    }
    else
    {
        uiFamilyCodePage = WindowsCodePageFromCodePage(codepage);
        fReadCodePageSettings = TRUE;
    }

    if (fReadCodePageSettings)
    {
        // Read the settings from the registry
        // Note that this call modifies CDoc::_codepage.

        hr = THR( ReadCodepageSettingsFromRegistry( codepage, uiFamilyCodePage, FALSE ) );

        if (_pCodepageSettings)
        {
            _sBaselineFont = _pCodepageSettings->sBaselineFontDefault;
        }

        ClearDefaultCharFormat();
        ForceRelayout();
    }
        
    // Set the codepage
    _codepage = codepage;
    _codepageFamily = _pCodepageSettings->uiFamilyCodePage;

    if (HtmCtx())
    {
        HtmCtx()->SetCodePage(codepage);
    }
#endif // ndef WIN16

    RRETURN(hr);
}

//+---------------------------------------------------------------------------
//
//  Member:     CDoc::BubbleDownCodePage
//
//  Synopsis:   Updates code page of all nested documents.
//
//----------------------------------------------------------------------------

void
CDoc::BubbleDownCodePage( CODEPAGE codepage )
{
    HRESULT hr;
    IHTMLFramesCollection2 * pFramesCollection = 0;
    CElement               * pElement;
    CFrameSite             * pFrameSite;
    CDoc                   * pNestedDoc;

    // get frames collection
    hr = THR(get_frames(&pFramesCollection));
    if (hr)
        goto Cleanup;

    if (pFramesCollection)
    {
        // get frames count
        long cFrames;
        hr = THR(pFramesCollection->get_length(&cFrames));
        if (hr || (cFrames == 0))
            goto Cleanup;

        hr = THR(_pPrimaryMarkup->EnsureCollectionCache(CMarkup::FRAMES_COLLECTION));
        if (hr)
            goto Cleanup;

        for (long i = 0; i < cFrames; i++)
        {
            hr = THR(_pPrimaryMarkup->CollectionCache()->GetIntoAry(CMarkup::FRAMES_COLLECTION, i, &pElement));
            if (hr)
                goto Cleanup;

            pFrameSite = DYNCAST(CFrameSite, pElement);
            if (pFrameSite)
            {
                // Get document associated with the frame.
                if (    S_OK == pFrameSite->GetCDoc(&pNestedDoc) 
                    &&  pNestedDoc)
                {
                    // Switch codepage of nested document.
                    pNestedDoc->SwitchCodePage(codepage);
                    pNestedDoc->_fCodepageOverridden = _fCodepageOverridden;

                    // Bubble down codepage
                    pNestedDoc->BubbleDownCodePage(codepage);
                }
            }
        }
    }

Cleanup:
    if (pFramesCollection)
        pFramesCollection->Release();
}

//+---------------------------------------------------------------------------
//
//  Member:     CDoc::IsAvailableOffline
//
//  Synopsis:   Determines if URL is availble when off line.
//
//----------------------------------------------------------------------------

BOOL
CDoc::IsAvailableOffline(LPCTSTR pchUrl, CElement *pElementContext)
{
    HRESULT hr;
    BOOL    fResult = FALSE;
    DWORD   f;
    DWORD   dwSize;
    TCHAR   cBuf[pdlUrlLen];
    TCHAR * pchExpUrl = cBuf;

    if (!pchUrl)
        goto Cleanup;

    hr = THR(ExpandUrl(pchUrl, ARRAY_SIZE(cBuf), pchExpUrl, pElementContext));
    if (hr)
        goto Cleanup;

    hr = THR(CoInternetQueryInfo(pchExpUrl,
            QUERY_USES_NETWORK,
            0,
            &f,
            sizeof(f),
            &dwSize,
            0));

    if (FAILED(hr) || !f)
    {
        fResult = TRUE;
        goto Cleanup;
    }

    hr = THR(CoInternetQueryInfo(pchExpUrl,
            QUERY_IS_CACHED_OR_MAPPED,
            0,
            &f,
            sizeof(f),
            &dwSize,
            0));

    if (FAILED(hr))
        goto Cleanup;

    fResult = f;

Cleanup:
    return fResult;
}

//+---------------------------------------------------------------------------
//
//  Member:     CDoc::AddRefUrlImgCtx
//
//  Synopsis:   Returns a cookie to the background image specified by the
//              given Url and element context.
//
//  Arguments:  lpszUrl         Relative URL of the background image
//              pElemContext    Element to begin search for nearest <BASE> tag
//
//  Returns:    Cookie which refers to the background image
//
//----------------------------------------------------------------------------

HRESULT
CDoc::AddRefUrlImgCtx(LPCTSTR lpszUrl, CElement *pElemContext, LONG *plCookie)
{
    CDwnCtx *   pDwnCtx;
    CImgCtx *   pImgCtx;
    URLIMGCTX * purlimgctx;
    LONG        iurlimgctx;
    LONG        iurlimgctxFree = -1;
    LONG        curlimgctx;
    HRESULT     hr;
    TCHAR       cBuf[pdlUrlLen];
    TCHAR *     pszExpUrl   = cBuf;
    SSL_SECURITY_STATE sslSecurity;
    SSL_PROMPT_STATE   sslPrompt;

    *plCookie = 0;

    hr = THR(ExpandUrl(lpszUrl, ARRAY_SIZE(cBuf), pszExpUrl, pElemContext));
    if (hr)
        goto Cleanup;

    // See if we've already got a background image with this Url

    purlimgctx = _aryUrlImgCtx;
    curlimgctx = _aryUrlImgCtx.Size();

    for (iurlimgctx = 0; iurlimgctx < curlimgctx; ++iurlimgctx, ++purlimgctx)
    {
        if (purlimgctx->ulRefs == 0)
        {
            iurlimgctxFree = iurlimgctx;
        }
        else
        {
            const TCHAR *pchSlotUrl;

            pchSlotUrl = purlimgctx->pImgCtx ? purlimgctx->pImgCtx->GetUrl() : purlimgctx->cstrUrl;
            Assert(pchSlotUrl);
        
            if (pchSlotUrl && StrCmpC(pchSlotUrl, pszExpUrl) == 0)
            {
                // Found it.  Increment the reference count on this entry and
                // hand out a cookie to it.

                purlimgctx->ulRefs += 1;
                *plCookie = iurlimgctx + 1;

                TraceTag((tagUrlImgCtx, "AddRefUrlImgCtx (#%ld,url=%ls,cRefs=%ld,elem=%ld(%ls))",
                    *plCookie, purlimgctx->pImgCtx ? purlimgctx->pImgCtx->GetUrl() : purlimgctx->cstrUrl, purlimgctx->ulRefs,
                    pElemContext->_nSerialNumber, pElemContext->TagName()));

                hr = THR(purlimgctx->aryElems.Append(pElemContext));

                goto Cleanup;
             }
        }
    }

    // No luck finding an existing image.  Get a new one and add it to array.

    if (iurlimgctxFree == -1)
    {
        hr = THR(_aryUrlImgCtx.EnsureSize(iurlimgctx + 1));
        if (hr)
            goto Cleanup;

        iurlimgctxFree = iurlimgctx;

        _aryUrlImgCtx.SetSize(iurlimgctx + 1);

        // N.B. (johnv) We need this so that the CPtrAry inside URLIMGCTX
        // gets initialized.
        memset(&_aryUrlImgCtx[iurlimgctxFree], 0, sizeof(URLIMGCTX));
    }

    purlimgctx = &_aryUrlImgCtx[iurlimgctxFree];

    // grab the current security state
    GetRootSslState(&sslSecurity, &sslPrompt);
    
    // If the URL is not secure....
    if (sslPrompt == SSL_PROMPT_QUERY && !IsUrlSecure(pszExpUrl))
    {
        // If a query is required, save the url and post a message to start download later
        
        GWPostMethodCallEx(GetThreadState(), (void *)this,
                           ONCALL_METHOD(CDoc, OnUrlImgCtxDeferredDownload, onurlimgctxdeferreddownload),
                           0, FALSE, "CDoc::OnUrlImgCtxDeferredDownload");
                           
        if (!_dwCookieUrlImgCtxDef && GetProgSink())
        {
            GetProgSink()->AddProgress(PROGSINK_CLASS_MULTIMEDIA, &_dwCookieUrlImgCtxDef);
            GetProgSink()->SetProgress(_dwCookieUrlImgCtxDef, PROGSINK_SET_STATE | PROGSINK_SET_POS | PROGSINK_SET_MAX, PROGSINK_STATE_LOADING, NULL, 0, 0, 1);
        }
        
        pImgCtx = NULL;
        hr = THR(purlimgctx->cstrUrl.Set(pszExpUrl));
        if (hr)
            goto Cleanup;
    }
    else if (sslPrompt == SSL_PROMPT_DENY && !IsUrlSecure(pszExpUrl))
    {
        pImgCtx = NULL;
        hr = THR(purlimgctx->cstrUrl.Set(pszExpUrl));
        if (hr)
            goto Cleanup;
    }
    else
    {
        // BUGBUG Pass lpszUrl, not pszExpUrl, due to ExpandUrl bug.
        hr = THR(NewDwnCtx(DWNCTX_IMG, lpszUrl, pElemContext,
                    &pDwnCtx, TRUE));
        if (hr)
            goto Cleanup;
            
        pImgCtx = (CImgCtx *)pDwnCtx;

    }

    if (pImgCtx)
    {
        pImgCtx->SetProgSink(GetProgSink());
        pImgCtx->SetCallback(OnUrlImgCtxCallback, this);
        pImgCtx->SelectChanges((!IsPrintDoc() && _pOptionSettings->fPlayAnimations) ? IMGCHG_COMPLETE|IMGCHG_ANIMATE
            : IMGCHG_COMPLETE, 0, TRUE); // TRUE: disallow prompting
    }

    hr = THR(purlimgctx->aryElems.Append(pElemContext));
    if (hr)
        goto Cleanup;
        
    purlimgctx->ulRefs   = 1;
    purlimgctx->pImgCtx  = pImgCtx;
    *plCookie            = iurlimgctxFree + 1;

    TraceTag((tagUrlImgCtx, "AddRefUrlImgCtx (#%ld,url=%ls,cRefs=%ld,elem=%d(%ls))",
        *plCookie, purlimgctx->pImgCtx ? purlimgctx->pImgCtx->GetUrl() : purlimgctx->cstrUrl, purlimgctx->ulRefs,
        pElemContext->_nSerialNumber, pElemContext->TagName()));

Cleanup:
    RRETURN(hr);
}


//+---------------------------------------------------------------------------
//
//  Member:     CDoc::OnUrlImgCtxDeferredDownload
//
//  Synopsis:   Callback to validate security of backround images.
//
//----------------------------------------------------------------------------
void
CDoc::OnUrlImgCtxDeferredDownload(DWORD_PTR dwContext)
{
    // loop through array of urlimgctx's and kick off downloads for all
    // those that have urls without imgctx's.

    CDwnCtx *   pDwnCtx;
    CImgCtx *   pImgCtx;
    LONG        iurlimgctx;
    URLIMGCTX * purlimgctx;
    LONG        curlimgctx;
    HRESULT     hr;
    CStr        cstrUrl;
    
    if (InRootSslPrompt())
    {
        _fNeedUrlImgCtxDeferredDownload = TRUE;
        return;
    }
    
    curlimgctx = _aryUrlImgCtx.Size();

    // structured inefficiently to withstand array motion on reentrancy

    for (iurlimgctx = 0; iurlimgctx < curlimgctx; ++iurlimgctx)
    {
        purlimgctx = _aryUrlImgCtx + iurlimgctx;
        
        if (purlimgctx->ulRefs > 0 && purlimgctx->pImgCtx == NULL && purlimgctx->cstrUrl)
        {
            // make a copy (motivated by stress crash where AddRefUrlImgCtx is called inside pushed message loop of NewDwnCtx)
            
            cstrUrl.Set(purlimgctx->cstrUrl);
            
            hr = THR(NewDwnCtx(DWNCTX_IMG, cstrUrl, NULL, &pDwnCtx, FALSE)); // FALSE: allow prompting
            if (!hr)
            {
                // Check for sanity of aryUrlImgCtx after possible pushed message loop in NewDwnCtx (motivated by stress crash)

                if (    iurlimgctx < _aryUrlImgCtx.Size()
                    && !_aryUrlImgCtx[iurlimgctx].pImgCtx
                    && _aryUrlImgCtx[iurlimgctx].cstrUrl
                    && !StrCmpC(cstrUrl, _aryUrlImgCtx[iurlimgctx].cstrUrl))
                {
                    pImgCtx = (CImgCtx *)pDwnCtx;
                    
                    if (pImgCtx)
                    {
                        pImgCtx->SetProgSink(GetProgSink());
                        pImgCtx->SetCallback(OnUrlImgCtxCallback, this);
                        pImgCtx->SelectChanges((!IsPrintDoc() && _pOptionSettings->fPlayAnimations) ? IMGCHG_COMPLETE|IMGCHG_ANIMATE
                            : IMGCHG_COMPLETE, 0, TRUE);
                            
                        _aryUrlImgCtx[iurlimgctx].cstrUrl.Free();
                    }
                    _aryUrlImgCtx[iurlimgctx].pImgCtx  = pImgCtx;
                }
                else
                {
                    pDwnCtx->Release();
                }
            }
            cstrUrl.Free();
        }
    }

    if (_dwCookieUrlImgCtxDef)
    {
        GetProgSink()->DelProgress(_dwCookieUrlImgCtxDef);
        _dwCookieUrlImgCtxDef = NULL;
    }
}


//+---------------------------------------------------------------------------
//
//  Member:     CDoc::AddRefUrlImgCtx
//
//  Synopsis:   Adds a reference to the background image specified by the
//              given cookie.
//
//  Arguments:  lCookie         Cookie given out by AddRefUrlImgCtx
//
//----------------------------------------------------------------------------

HRESULT
CDoc::AddRefUrlImgCtx(LONG lCookie, CElement * pElem)
{
    HRESULT hr;

    if (!lCookie)
        return S_OK;

    Assert(lCookie > 0 && lCookie <= _aryUrlImgCtx.Size());
    Assert(_aryUrlImgCtx[lCookie-1].ulRefs > 0);

    hr = THR(_aryUrlImgCtx[lCookie-1].aryElems.Append(pElem));
    if (hr)
        goto Cleanup;

    _aryUrlImgCtx[lCookie-1].ulRefs += 1;

    TraceTag((tagUrlImgCtx, "AddRefUrlImgCtx (#%ld,url=%ls,cRefs=%ld,elem=%ld)",
        lCookie, _aryUrlImgCtx[lCookie-1].pImgCtx ? _aryUrlImgCtx[lCookie-1].pImgCtx->GetUrl() : _aryUrlImgCtx[lCookie-1].cstrUrl,
        _aryUrlImgCtx[lCookie-1].ulRefs, pElem->_nSerialNumber));

Cleanup:
    RRETURN(hr);
}

//+---------------------------------------------------------------------------
//
//  Member:     CDoc::GetUrlImgCtx
//
//  Synopsis:   Returns the CImgCtx at the specified cookie
//
//  Arguments:  lCookie         Cookie given out by AddRefUrlImgCtx
//
//----------------------------------------------------------------------------

CImgCtx *
CDoc::GetUrlImgCtx(LONG lCookie)
{
    if (!lCookie)
        return(NULL);

    Assert(lCookie > 0 && lCookie <= _aryUrlImgCtx.Size());
    Assert(_aryUrlImgCtx[lCookie-1].ulRefs > 0);

    return(_aryUrlImgCtx[lCookie-1].pImgCtx);
}

//+---------------------------------------------------------------------------
//
//  Member:     CDoc::GetImgAnimState
//
//  Synopsis:   Returns an IMGANIMSTATE for the specified cookie, null if
//              there is none
//
//  Arguments:  lCookie         Cookie given out by AddRefUrlImgCtx
//
//----------------------------------------------------------------------------

IMGANIMSTATE *
CDoc::GetImgAnimState(LONG lCookie)
{
    CImgAnim * pImgAnim = GetImgAnim();
    LONG lAnimCookie;

    if (!lCookie || !pImgAnim)
        return(NULL);

    Assert(lCookie > 0 && lCookie <= _aryUrlImgCtx.Size());
    Assert(_aryUrlImgCtx[lCookie-1].ulRefs > 0);

    lAnimCookie = _aryUrlImgCtx[lCookie-1].lAnimCookie;

    if (lAnimCookie)
        return(pImgAnim->GetImgAnimState(lAnimCookie));

    return NULL;
}


//+---------------------------------------------------------------------------
//
//  Member:     CDoc::ReleaseUrlImgCtx
//
//  Synopsis:   Releases a reference to the background image specified by
//              the given cookie.
//
//  Arguments:  lCookie         Cookie given out by AddRefUrlImgCtx
//              pElem           An element associated with this cookie
//
//----------------------------------------------------------------------------

void
CDoc::ReleaseUrlImgCtx(LONG lCookie, CElement * pElem)
{
    if (!lCookie)
        return;

    Assert(lCookie > 0 && lCookie <= _aryUrlImgCtx.Size());
    URLIMGCTX * purlimgctx = &_aryUrlImgCtx[lCookie-1];
    Assert(purlimgctx->ulRefs > 0);


    TraceTag((tagUrlImgCtx, "ReleaseUrlImgCtx (#%ld,url=%ls,cRefs=%ld,elem=%d)",
        lCookie, _aryUrlImgCtx[lCookie-1].pImgCtx ? _aryUrlImgCtx[lCookie-1].pImgCtx->GetUrl() : NULL,
        _aryUrlImgCtx[lCookie-1].ulRefs - 1,
        pElem->_nSerialNumber));

    Verify(purlimgctx->aryElems.DeleteByValue(pElem));

    if (--purlimgctx->ulRefs == 0)
    {
        Assert(purlimgctx->aryElems.Size() == 0);

        // Release our animation cookie if we have one
        if (purlimgctx->lAnimCookie)
        {
            CImgAnim * pImgAnim = GetImgAnim();

            if (pImgAnim)
            {
                pImgAnim->UnregisterForAnim(this, purlimgctx->lAnimCookie);
            }
        }

        purlimgctx->aryElems.DeleteAll();
        if (purlimgctx->pImgCtx)
        {
            purlimgctx->pImgCtx->SetProgSink(NULL); // detach download from document's load progress
            purlimgctx->pImgCtx->Disconnect();
            purlimgctx->pImgCtx->Release();
        }
        purlimgctx->cstrUrl.Free();
        memset(purlimgctx, 0, sizeof(*purlimgctx));
    }
}

//----------------------------------------------------------
//
//  Member   : CDoc::StopUrlImgCtx
//
//  Synopsis : Stops downloading of all background images
//
//----------------------------------------------------------

void
CDoc::StopUrlImgCtx()
{
    URLIMGCTX * purlimgctx;
    LONG        curlimgctx;

    purlimgctx = _aryUrlImgCtx;
    curlimgctx = _aryUrlImgCtx.Size();

    for (; curlimgctx > 0; --curlimgctx, ++purlimgctx)
    {
        if (purlimgctx->pImgCtx)
        {
            purlimgctx->pImgCtx->SetLoad(FALSE, NULL, FALSE);
        }
    }
    
    if (_dwCookieUrlImgCtxDef && GetProgSink())
    {
        GWKillMethodCallEx(GetThreadState(), this, ONCALL_METHOD(CDoc, OnUrlImgCtxDeferredDownload, onurlimgctxdeferreddownload), 0);
        _fNeedUrlImgCtxDeferredDownload = FALSE;
        GetProgSink()->DelProgress(_dwCookieUrlImgCtxDef);
        _dwCookieUrlImgCtxDef = NULL;
    }
}

//----------------------------------------------------------
//
//  Member   : CDoc::UnregisterUrlImageCtxCallbacks
//
//  Synopsis : Cancels any image callbacks for the doc.  Does
//             not release the image context itself.
//
//----------------------------------------------------------

void
CDoc::UnregisterUrlImgCtxCallbacks()
{
    CImgAnim  * pImgAnim = GetImgAnim();
    URLIMGCTX * purlimgctx;
    LONG        iurlimgctx;
    LONG        curlimgctx;

    purlimgctx = _aryUrlImgCtx;
    curlimgctx = _aryUrlImgCtx.Size();

    for (iurlimgctx = 0; iurlimgctx < curlimgctx; ++iurlimgctx, ++purlimgctx)
    {
        if (purlimgctx->ulRefs)
        {
            // Unregister callbacks from the animation object, if any
            if (pImgAnim && purlimgctx->lAnimCookie)
            {
                pImgAnim->UnregisterForAnim(this, purlimgctx->lAnimCookie);
                purlimgctx->lAnimCookie = 0;
            }

            if (purlimgctx->pImgCtx)
            {
                // Unregister callbacks from the image context
                purlimgctx->pImgCtx->SetProgSink(NULL); // detach download from document's load progress
                purlimgctx->pImgCtx->Disconnect();
            }
        }
    }
}

//+---------------------------------------------------------------------------
//
//  Member:     CDoc::OnUrlImgCtxCallback
//
//  Synopsis:   Callback from background image reporting that it is finished
//              loading.
//
//  Arguments:  pvObj         The pImgCtx that is calling back
//              pbArg         The CDoc pointer
//
//----------------------------------------------------------------------------

void CALLBACK
CDoc::OnUrlImgCtxCallback(void * pvObj, void * pvArg)
{
    CDoc *      pDoc       = (CDoc *)pvArg;
    CImgCtx *   pImgCtx    = (CImgCtx *)pvObj;
    LONG        iurlimgctx;
    LONG        curlimgctx = pDoc->_aryUrlImgCtx.Size();
    URLIMGCTX * purlimgctx = pDoc->_aryUrlImgCtx;
    SIZE        size;
    ULONG       ulState    = pImgCtx->GetState(TRUE, &size);

    pImgCtx->AddRef();

    for (iurlimgctx = 0; iurlimgctx < curlimgctx; ++iurlimgctx, ++purlimgctx)
    {
        if (pImgCtx && purlimgctx->pImgCtx == pImgCtx)
        {
            TraceTag((tagUrlImgCtx, "OnUrlImgCtxCallback (#%ld,url=%ls,cRefs=%ld)",
                iurlimgctx + 1, purlimgctx->pImgCtx ? purlimgctx->pImgCtx->GetUrl() : purlimgctx->cstrUrl, purlimgctx->ulRefs));

            if (ulState & IMGCHG_ANIMATE)
            {
                // Register for animation callbacks
                CImgAnim * pImgAnim = CreateImgAnim();

                if (!purlimgctx->lAnimCookie)
                {
                    pImgAnim->RegisterForAnim(pDoc, (DWORD_PTR) pDoc->GetRootDoc(),
                                              pImgCtx->GetImgId(),
                                              OnAnimSyncCallback,
                                              (void *)(DWORD_PTR)iurlimgctx,
                                              &purlimgctx->lAnimCookie);
                }

                if (purlimgctx->lAnimCookie)
                {
                    pImgAnim->ProgAnim(purlimgctx->lAnimCookie);
                }
            }
            if (ulState & (IMGLOAD_COMPLETE | IMGLOAD_STOPPED | IMGLOAD_ERROR))
            {
                pImgCtx->SetProgSink(NULL); // detach download from document's load progress
            }
            if (ulState & IMGLOAD_COMPLETE)
            {
                pDoc->OnUrlImgCtxChange(purlimgctx, IMGCHG_COMPLETE);
            }

            break;
        }
    }
    pImgCtx->Release();
}

//+---------------------------------------------------------------------------
//
//  Member:     CDoc::OnAnimSyncCallback
//
//  Synopsis:   Called back on an animation event
//
//----------------------------------------------------------------------------

void
CDoc::OnAnimSyncCallback(void * pvObj, DWORD dwReason, void * pvArg,
                         void ** ppvDataOut, IMGANIMSTATE * pImgAnimState)
{
    CDoc * pDoc  = (CDoc *) pvObj;
    URLIMGCTX * purlimgctx = &pDoc->_aryUrlImgCtx[(LONG)(LONG_PTR)pvArg];

    switch (dwReason)
    {
    case ANIMSYNC_GETIMGCTX:
        *(CImgCtx **) ppvDataOut = purlimgctx->pImgCtx;
        break;

    case ANIMSYNC_GETHWND:
        *(HWND *) ppvDataOut = pDoc->_pInPlace ? pDoc->_pInPlace->_hwnd : NULL;
        break;

    case ANIMSYNC_TIMER:
    case ANIMSYNC_INVALIDATE:
        *(BOOL *) ppvDataOut = pDoc->OnUrlImgCtxChange(purlimgctx, IMGCHG_ANIMATE);
        break;

    default:
        Assert(FALSE);
    }
}

//+---------------------------------------------------------------------------
//
//  Member:     CDoc::OnUrlImgCtxChange
//
//  Synopsis:   Called when this image context has changed, does the necessary
//              invalidating.
//
//  Arguments:  purlimgctx    The url image ctx that changed
//              ulState       The reason for the callback
//
//----------------------------------------------------------------------------

BOOL
CDoc::OnUrlImgCtxChange(URLIMGCTX * purlimgctx, ULONG ulState)
{
    if (!_pInPlace)
        return FALSE;             // no window yet, nothing to do

    BOOL        fSynchronousPaint = TRUE;
    int         n;
    CElement ** ppElem;
    CLayout   * pLayout;

    TraceTag((tagUrlImgCtx, "OnChange for doc %ls, img %ls, %ld elements",
              (TCHAR *)_cstrUrl,
              purlimgctx->pImgCtx ? purlimgctx->pImgCtx->GetUrl() : purlimgctx->cstrUrl,
              purlimgctx->aryElems.Size()));

    Assert(purlimgctx->pImgCtx);
    
    // If the image turned out to be unsecure, blow away the lock icon
    if (ulState & IMGCHG_COMPLETE)
    {
        OnSubDownloadSecFlags(purlimgctx->pImgCtx->GetUrl(), purlimgctx->pImgCtx->GetSecFlags());
    }

    for (n = purlimgctx->aryElems.Size(), ppElem = purlimgctx->aryElems;
         n > 0;
         n--, ppElem++)
    {
        CElement * pElement = * ppElem;
        //
        // marka - check that element still in tree - bug # 15481.
        //
        if (pElement->IsInMarkup())
        {
            pLayout = pElement->GetFirstBranch()->GetUpdatedNearestLayout();

            //
            // if the background is on HTML element or any other ancestor of
            // body/top element, the inval the top element.
            //
            if (!pLayout)
            {
                CElement * pElemClient = pElement->GetMarkup()->GetElementClient();

                if(pElemClient)
                {
                    pLayout = pElemClient->GetUpdatedLayout();
                }
            }

            if(pLayout)
            {
                if (pLayout->ElementOwner() == pElement)
                {
                    if (OpenView())
                    {
                        CDispNodeInfo   dni;

                        pLayout->GetDispNodeInfo(&dni);
                        pLayout->EnsureDispNodeBackground(dni);
                    }
                }


                // Some elements require a resize, others a simple invalidation
                if (pElement->_fResizeOnImageChange && (ulState & IMGCHG_COMPLETE))
                {
                    pElement->ResizeElement();
                    fSynchronousPaint = FALSE;
                }
                else
                {
                    // We can get away with just an invalidate
                    pElement->Invalidate();
                }
            }
        }
    }

    return fSynchronousPaint;
}


//+------------------------------------------------------------------------
//
//  Member:     CDoc::EnsureOmWindow
//
//  Synopsis:   Ensures that the pointer to the script window is correct.
//              The script window is the automatable window object.
//
//-------------------------------------------------------------------------

HRESULT
CDoc::EnsureOmWindow()
{
    HRESULT         hr = S_OK;
    IUnknown *      pUnkHTMLDlg = NULL;
    COmWindow2 *    pWindow = NULL;
    BYTE            abSID[MAX_SIZE_SECURITY_ID];
    DWORD           cbSID = ARRAY_SIZE(abSID);

    if (!_pOmWindow)
    {
        //
        // find out if there is aggregating HTMLDlg
        //

        hr = THR_NOTRACE(QueryService (IID_IHTMLDialog, IID_IUnknown, (void**)&pUnkHTMLDlg));
        if (hr)
        {
            pUnkHTMLDlg = NULL;
            hr = S_OK;
            _fInHTMLDlg = FALSE;
        }
        else
        {
            // We set this here and in CHTMLDlg::SetTrustedOnDoc() .
            // otherwise it is 0
            // we don't want a pointer to the dlg object, but in numerous
            // places we want to block, or modify, behavior.
            _fInHTMLDlg = TRUE;
        }

        pWindow = new COmWindow2(this);
        if (!pWindow)
        {
            hr = E_OUTOFMEMORY;
            goto Cleanup;
        }

        _pOmWindow = new COmWindowProxy;
        if (!_pOmWindow)
        {
            hr = E_OUTOFMEMORY;
            goto Error;
        }

        _pOmWindow->_fTrusted = TRUE;
        _pOmWindow->_fTrustedDoc = _fTrustedDoc;

        hr = THR(GetSecurityID(abSID, &cbSID));
        if (hr)
            goto Error;

        hr = THR(_pOmWindow->Init((IHTMLWindow2 *)pWindow, abSID, cbSID));
        if (hr)
            goto Error;

        //
        // Add this entry to the thread local cache.
        //

        hr = THR(EnsureWindowInfo());
        if (hr)
            goto Cleanup;

        hr = THR(TLS(windowInfo.paryWindowTbl)->AddTuple(
                (IHTMLWindow2 *)pWindow,
                abSID,
                cbSID,
                _fTrustedDoc,
                (IHTMLWindow2 *)_pOmWindow));
        if (hr)
            goto Cleanup;
    }

Cleanup:
    ReleaseInterface (pUnkHTMLDlg);
    if (pWindow)
    {
        pWindow->Release();
    }
    RRETURN(hr);

Error:
    if (_pOmWindow)
    {
        _pOmWindow->_fTrusted = FALSE;
        _pOmWindow->Release();
        _pOmWindow = NULL;
    }
    goto Cleanup;
}


//+----------------------------------------------------------------
//
//  Member   : EnumFrameURLs
//
//  Arguments: paryURLs [OUT] : ptr to array of (relative) frame URLs
//             paryPrettyURLs [OUT] : prt to array of pretty URLs for Windows spooler
//             paryPrintInfos [OUT] : ptr to array of PrintInfo group of flags
//
//  Synopsis : Returns an array of URLs containing all the frames
//      of a CDoc.  Careful:  Those URLs are relative to CDoc.
//
//-----------------------------------------------------------------

HRESULT CDoc::EnumFrameURLs(CURLAry *paryURLs, CURLAry *paryPrettyURLs, CPrintInfoFlagsAry *paryPrintInfos)
{
    CElement      * pElement;
    CFrameSetSite * pFrameSet;
    CFrameElement * pFrame;
    CStr *          pstrFrameUrl;
    CStr *          pstrPrettyUrl;
    LONG            i, cFrames;
    HRESULT         hr = S_OK;

    Assert(paryURLs && paryPrettyURLs && paryPrintInfos && "E_POINTER");

    // Make sure we have a frameset.

    // Bad coding practice - taking the address of a ptr and
    // casting it to be a ptr to a ptr of something else is just
    // not portable. -> hr = THR(GetElementClient((CSite**)&pFrameSet));
    pElement = GetPrimaryElementClient();
    
    if (!pElement || pElement->Tag() != ETAG_FRAMESET)
    {
        hr = E_UNEXPECTED;
        goto Cleanup;
    }

    Assert (ETAG_FRAMESET == pElement->Tag());
    pFrameSet = (CFrameSetSite *)pElement;

    // Obtain the number of frames available.
    IGNORE_HR(GetFramesCount(&cFrames));

    // Add each frame URL to the array.
    for (i = cFrames-1 ; i >= 0 ; i--)
    {
        // Get next frame.
        if (pFrameSet->GetFrameFlat(i, NULL, &pFrame) && pFrame)
        {
            CDoc *pDoc;
            DWORD dwPrintInfoFlags;

            // Increase URL array size.
            hr = paryURLs->AppendIndirect(NULL, &pstrFrameUrl);
            if (hr)
            {
                goto Cleanup;
            }

            // Copy frame URL string over to array.
            hr = THR(pstrFrameUrl->Set(pFrame->GetAAsrc()));
            if (hr)
            {
                goto Cleanup;
            }

            // Increase pretty URL array size.
            IGNORE_HR( paryPrettyURLs->AppendIndirect(NULL, &pstrPrettyUrl) );

            // Start out with empty pretty url.
            IGNORE_HR( pstrPrettyUrl->Set(NULL) );



            // An about url in a frame indicates that loading an external doc
            // might have gone wrong.  Take the conservative approach here
            // and don't assume html for about urls.
            if (S_OK == pFrame->GetCDoc(&pDoc) && pDoc && URL_SCHEME_ABOUT != GetUrlScheme(pDoc->_cstrUrl))
            {
                TCHAR *pchBaseUrlFromBaseTag = NULL;

                dwPrintInfoFlags = PIF_HTMLDOCUMENT;

                if (S_OK == THR(pDoc->GetBaseUrl(&pchBaseUrlFromBaseTag)) && pchBaseUrlFromBaseTag)
                {
                    if (S_OK == THR(pstrPrettyUrl->Set(pchBaseUrlFromBaseTag)))
                    {
                        dwPrintInfoFlags |= PIF_USEPRETTYURL;
                    }
                }
            }
            else
            {
                dwPrintInfoFlags = 0;
            }
            // Increase print info flag array size and append.
            IGNORE_HR( paryPrintInfos->Append(dwPrintInfoFlags) );
        }
    }

Cleanup:
    RRETURN1 (hr, S_FALSE);
}


//+----------------------------------------------------------------
//
//  Member   : CDoc::EnumFrameIPrintObjects()
//
//  Arguments: paryIPrint [OUT] : ptr to array of IPrint interface pointers
//
//  Synopsis : Returns an array of IPrint interface pointers to be printed
//             synchronously from the UI-thread.
//
//-----------------------------------------------------------------

HRESULT CDoc::EnumFrameIPrintObjects(CIPrintAry *paryIPrint)
{
    CElement      * pElement;
    CFrameSetSite * pFrameSet;
    CFrameElement * pFrame;
    LONG            i, cFrames;
    HRESULT         hr;

    if (!paryIPrint)
    {
        Assert(!"Null pointer to IPrint array");
        hr = E_POINTER;
        goto Cleanup;
    }

    // Make sure we have a frameset.
    pElement = GetPrimaryElementClient();
    if (!pElement || pElement->Tag() != ETAG_FRAMESET)
    {
        hr = E_UNEXPECTED;
        goto Cleanup;
    }

    Assert (ETAG_FRAMESET == pElement->Tag());
    pFrameSet = DYNCAST(CFrameSetSite, pElement);

    // Obtain the number of frames available.
    hr = THR(GetFramesCount(&cFrames));

    // Add each frame URL to the array.
    for (i = cFrames-1 ; i >= 0 ; i--)
    {
        // Get next frame.
        if (pFrameSet->GetFrameFlat(i, NULL, &pFrame) && pFrame)
        {
            IPrint *pPrint = NULL, **ppPrintInArray = NULL;

            pFrame->_fHoldingIPrint = FALSE;

            hr = pFrame->GetIPrintObject(&pPrint);
            if (S_OK == hr && pPrint)
            {
                // Increase URL array size.
                hr = paryIPrint->AppendIndirect(NULL, &ppPrintInArray);
                if (hr || !ppPrintInArray)
                {
                    ReleaseInterface(pPrint);
                    goto Cleanup;
                }

                // Array takes ownership of IPrint refcount.
                *ppPrintInArray = pPrint;

                pFrame->_fHoldingIPrint = TRUE;
            }

            // It's Ok for a doc not to support IPrint.
            hr = S_OK;
        }
    }

Cleanup:
    RRETURN(hr);
}


//+----------------------------------------------------------------
//
//  Member   : GetActiveFrame
//
//  Arguments: pstrUrl (out): pointer to Url of active frame
//                            needs to be at least pdlUrlLen
//                            characters long.
//             ppActiveFrameDoc (out): pointer to pointer to active doc if it
//                            exists (a frame is active, and it hosts a doc).
//                            We do not addref the doc.
//             ppPrint (out): IPrint object (Office)
//
//  Synopsis : Returns the Url of active frame if it exists.
//             Otherwise returns S_FALSE.
//
//-----------------------------------------------------------------

HRESULT CDoc::GetActiveFrame(TCHAR *pchUrl, DWORD cchUrl, CDoc **ppActiveFrameDoc, IPrint **ppPrint)
{
    CFrameSite *pFrameSite;
    CDoc *      pDoc = NULL;
    HRESULT     hr = S_FALSE;

    // Make sure we return NULL as active doc and IPrint* if anything goes wrong.
    if (ppActiveFrameDoc)
        *ppActiveFrameDoc = NULL;
    if (ppPrint)
        *ppPrint = NULL;

    if ( _state >= OS_UIACTIVE && (!_pElemUIActive || (ETAG_FRAME != _pElemUIActive->Tag() && ETAG_IFRAME != _pElemUIActive->Tag())) )
    {
        // Success: return URL of active frame's CDoc.
        if ( pchUrl )
        {
            _tcscpy(pchUrl, _cstrUrl);
        }
        
        // Return this doc.
        if (ppActiveFrameDoc)
        {
            *ppActiveFrameDoc = this;
        }

        hr = S_OK;
        goto Cleanup;
    }

    // Since the CDoc is not UIActive, we need have a UI active CFrameSite.
    if ( !_pElemUIActive || (ETAG_FRAME != _pElemUIActive->Tag() && ETAG_IFRAME != _pElemUIActive->Tag()) )
    {
        Assert(_state < OS_UIACTIVE);
        goto Cleanup;
    }

    Assert(_pElemUIActive && (_pElemUIActive->Tag() == ETAG_FRAME || _pElemUIActive->Tag() == ETAG_IFRAME));

    // Get the frame site.
    pFrameSite = DYNCAST(CFrameSite, _pElemUIActive);

    // Obtain the frame site's CDoc.  This does not addref the CDoc!!!
    hr = THR(pFrameSite->GetCDoc(&pDoc));

    // Maybe we are not a CDoc, but an external Doc.  In that case
    // ask the Webbrowser OCX for the URL since the FrameSite does
    // not update its URL.
    if (hr == E_NOINTERFACE || !pDoc)
    {
        // Try to get an IPrint pointer to the document if we can get one at this point.
        IGNORE_HR(pFrameSite->GetIPrintObject(ppPrint));
        
        if ( pchUrl )
        {
            hr = THR(pFrameSite->GetCurrentFrameURL(pchUrl, cchUrl));
        }
        else
        {
            hr = S_OK;
        }
        
        goto Cleanup;
    }

    // Recurse to examine frames of nested framesets.
    hr = THR(pDoc->GetActiveFrame(pchUrl, cchUrl, ppActiveFrameDoc, ppPrint));

Cleanup:

    // Because pDoc was not addref'ed, there is no need to "if (pDoc) pDoc->Release();"

    RRETURN1(hr, S_FALSE);
}

//+---------------------------------------------------------------------------
//
//  Member:     CDoc::SetInteractive
//
//  Synopsis:   Changes the readyState of the document to interactive if
//              the document is still being loaded.
//
//----------------------------------------------------------------------------

void BUGCALL
CDoc::SetInteractive(DWORD_PTR dwContext)
{
    if (_readyState < READYSTATE_INTERACTIVE)
    {
        SetReadyState(READYSTATE_INTERACTIVE);
    }
}

//+---------------------------------------------------------------------------
//
//  Member:     CDoc::CLock::CLock
//
//  Synopsis:
//
//----------------------------------------------------------------------------

CDoc::CLock::CLock(CDoc * pDoc, WORD wLockFlags)
    : CServer::CLock(pDoc, wLockFlags)
{
#if DBG==1
    extern BOOL g_fDisableBaseTrace;
    g_fDisableBaseTrace = TRUE;
#endif

    _pScriptCollection = pDoc->_pScriptCollection;
#if DBG==1
    if (!IsTagEnabled(tagDisableLockAR))
#endif
    {
        if (_pScriptCollection)
            _pScriptCollection->AddRef();
    }
    
#if DBG==1
    g_fDisableBaseTrace = FALSE;
#endif

}

CDoc::CLock::~CLock()
{
#if DBG==1
    extern BOOL g_fDisableBaseTrace;
    g_fDisableBaseTrace = TRUE;
#endif

#if DBG==1
    if (!IsTagEnabled(tagDisableLockAR))
#endif
    {
        if (_pScriptCollection)
            _pScriptCollection->Release();
    }

#if DBG==1
    g_fDisableBaseTrace = FALSE;
#endif
}

//+---------------------------------------------------------------------------
//
//  Member:     CDoc::PostAAEvent
//
//  Synopsis:   Translate our trident event into an Accessibility event and
//      post it to the window.
//
//----------------------------------------------------------------------------
typedef void (CALLBACK* NOTIFYWINEVENTPROC)(UINT, HWND, LONG, LONG);
NOTIFYWINEVENTPROC g_pfnNotifyWinEvent=NULL;
#define DONOTHING_NOTIFYWINEVENT (NOTIFYWINEVENTPROC )1

HRESULT
CDoc::FireAccesibilityEvents(DISPID dispidEvent, long lElemId)
{
    HRESULT hr  = S_OK;
    
    // map of trident events to the accesiblity events.

//
//FerhanE:
//  This is list is searched using a linear search algo. However, to make the 
//  search faster, events that are fired more often are at the top of the list.
//  Be careful when adding things in here.
    static const struct { DISPID a;
                          DWORD  b; } aEventTable[] = {
                              { NULL,                   EVENT_OBJECT_STATECHANGE},
                              { DISPID_EVMETH_ONFOCUS,  EVENT_OBJECT_FOCUS},
                              { DISPID_EVMETH_ONBLUR,   EVENT_OBJECT_STATECHANGE},
                              { DISPID_EVMETH_ONLOAD,   EVENT_OBJECT_CREATE},
                              { DISPID_EVMETH_ONUNLOAD, EVENT_OBJECT_DESTROY},
                        };

    // do we have enabled accessiblity?
    if (g_pfnNotifyWinEvent != DONOTHING_NOTIFYWINEVENT &&
        _pInPlace)
    {
        if (!g_pfnNotifyWinEvent )
        {
            HMODULE hmod = GetModuleHandle(TEXT("USER32"));

            if (hmod)
                g_pfnNotifyWinEvent = (NOTIFYWINEVENTPROC)GetProcAddress(
                                                            hmod,
                                                            "NotifyWinEvent");

            if (!g_pfnNotifyWinEvent)
            {
                g_pfnNotifyWinEvent = DONOTHING_NOTIFYWINEVENT;
                goto Cleanup;
            }
        }

        // we have a fx Ptr
        for (int iPos=0; iPos < ARRAY_SIZE(aEventTable); iPos++)
        {
            // If we can map this event, send the message and leave
           if (aEventTable[iPos].a == dispidEvent)
           {
                // make the event notification call.       
                (* g_pfnNotifyWinEvent)( aEventTable[iPos].b,   // the Accesibility event id
                                         _pInPlace->_hwnd,      // the inplace hwnd
                                         lElemId,               // parent?
                                         CHILDID_SELF);         // child id

                break;
           }
        }

    }

Cleanup:
    RRETURN(hr);
}

//+---------------------------------------------------------------------------
//
//  Member:     CDoc::FireEvent
//
//  Synopsis:   Lock the document while firing an event
//
//  return value :   S_OK  -- normal return value.  and event did not return
//                           false
//                  S_FALSE - event explictly returned false
//----------------------------------------------------------------------------
HRESULT
CDoc::FireEventHelper(DISPID dispidEvent,
                      DISPID dispidProp,
                      BYTE * pbTypes,
                      ...)
{
    va_list     valParms;
    HRESULT     hr = S_OK;
    CVariant    Var;
    IHTMLEventObj  *pEventObj = NULL;

    if (_state >= OS_LOADED) // Don't fire events before init is complete.
    {
        CLock       Lock(this);

        va_start(valParms, pbTypes);

        // If appropriate, create an event object.
        if (_pparam)
        {
            CEventObj::Create(&pEventObj, this);
        }

		hr = FireEventV(
                dispidEvent,
                dispidProp,
                pEventObj,
                &Var,
                pbTypes,
                valParms);
        va_end(valParms);

        ReleaseInterface(pEventObj);

        if ( V_VT(&Var) == VT_BOOL )
            hr = (V_BOOL(&Var) != VB_TRUE) ? S_FALSE : S_OK;
    }

    RRETURN1(hr, S_FALSE);
}


HRESULT
CDoc::FireEvent(DISPID dispidEvent,
                DISPID dispidProp,
                LPCTSTR pchEventType,
                BYTE * pbTypes,
                ...)
{
    EVENTPARAM param(this, TRUE);
    HRESULT    hr;

    param.SetType(pchEventType);

    hr = THR_NOTRACE(FireEventHelper(dispidEvent,
                            dispidProp,
                            pbTypes));

    //mask off S_FALSE since callers of this fx aren't concerned with
    // canceled return values.
    RRETURN( (hr == S_FALSE) ? S_OK : hr);
}

//+---------------------------------------------------------------------------
//
//  Member:     CDoc::GetRootDoc
//
//  Synopsis:   Gets the root document.  Never returns NULL.
//
//----------------------------------------------------------------------------
CDoc *
CDoc::GetRootDoc()
{
    CDoc *pDoc = this;
    while (pDoc->_pDocParent)
    {
        pDoc = pDoc->_pDocParent;
    }
    return pDoc;
}

//+---------------------------------------------------------------------------
//
//  Member:     CDoc::GetTopDoc
//
//  Synopsis:   Gets the topmost document.  Never returns NULL.  Sensitive to
//              trust issues regarding frames/iframes.
//
//----------------------------------------------------------------------------
CDoc *
CDoc::GetTopDoc()
{
    CDoc *pDoc = this;
    while (pDoc->_pDocParent)
    {
        if (!pDoc->_fTrustedDoc && pDoc->_pDocParent->_fTrustedDoc)
            break;
        pDoc = pDoc->_pDocParent;
    }
    return pDoc;
}

void
CDoc::FlushUndoData()
{
    // Nuke undo/redo stacks.  Release references.

    UndoManager()->DiscardFrom(NULL);
}

//+-------------------------------------------------------------------------
//
//  Method:     CDoc::QueryCreateUndo
//
//  Synopsis:   Query whether to create undo or not.  Also dirties 
//              the doc if fFlushOnError.
//
//--------------------------------------------------------------------------

#ifndef NO_EDIT
BOOL 
CDoc::QueryCreateUndo(BOOL fRequiresParent, BOOL fDirtyChange)
{
    if( fDirtyChange )
    {
        switch( TLS(nUndoState) )
        {
        case UNDO_BASESTATE:
            if( _lDirtyVersion < 0 )
                // If someone has reset the dirty version and then called undo
                // multiple times, a regular action will make us permenantly dirty.
                _lDirtyVersion = MAXLONG;
            else
                _lDirtyVersion++;
            break;
        case UNDO_UNDOSTATE:
            _lDirtyVersion--;
            break;
        case UNDO_REDOSTATE:
            _lDirtyVersion++;
            break;
        }
    }

    return super::QueryCreateUndo( fRequiresParent, fDirtyChange );
}
#endif // NO_EDIT


//+---------------------------------------------------------------------------
//
//  Member:     CDoc::OnFrameOptionScrollChange
//
//  Synopsis:   Called after scrolling of Frame option  has changed
//
//----------------------------------------------------------------------------

HRESULT
CDoc::OnFrameOptionScrollChange(void)
{
    ITargetFrame *  pTargetFrame = NULL;
    DWORD           dwFrameOptionsOld = _dwFrameOptions;

    // Update Cached Frame flags.
    if (OK(THR_NOTRACE(QueryService(
            IID_ITargetFrame,
            IID_ITargetFrame,
            (void**)&pTargetFrame))))
    {
        CBodyElement * pBody;

        THR(pTargetFrame->GetFrameOptions(&_dwFrameOptions));
        pTargetFrame->Release();

        IGNORE_HR(GetBodyElement(&pBody));
        if (pBody && dwFrameOptionsOld != _dwFrameOptions)
        {
            pBody->ResizeElement(NFLAGS_FORCE);
        }
    }

    return S_OK;
}

//+---------------------------------------------------------------------------
//
//  Function:   CallBackEnumChild
//
//  Synopsis:   Called from EnumChildWindows, used to determine if
//              we have child windows
//
//----------------------------------------------------------------------------

static BOOL CALLBACK
CallBackEnumChild(HWND hwnd, LPARAM lparam)
{
    *(BOOL *)lparam = (::GetFocus() == hwnd);

    return !(*(BOOL *)lparam);
}

BOOL
CDoc::HasFocus()
{
    BOOL    fHasFocus = FALSE;

    if (_pInPlace && _pInPlace->_hwnd)
    {
        Assert(IsWindow(_pInPlace->_hwnd));
        fHasFocus = (::GetFocus() == _pInPlace->_hwnd);
        if (!fHasFocus)
        {
            EnumChildWindows(_pInPlace->_hwnd, CallBackEnumChild, (LPARAM)&fHasFocus);
        }
    }
    // CHROME
    // If we are chrome hosted then we have no HWND (and by definition no child windows).
    // Therefore simply ask our container whether we have focus.
    else if (IsChromeHosted())
    {
        fHasFocus = GetFocus();
    }


    return fHasFocus;
}

CODEPAGE
CDoc::GetURLCodePage()
{
    return NavigatableCodePage( _codepageURL );
}

//+-------------------------------------------------------------------
//
//  Member:     CDoc::EnterStylesheetDownload
//
//  Synopsis:   Note that a stylesheet is being downloaded
//
//--------------------------------------------------------------------

void
CDoc::EnterStylesheetDownload(DWORD * pdwCookie)
{
    if (*pdwCookie != _dwStylesheetDownloadingCookie)
    {
        *pdwCookie = _dwStylesheetDownloadingCookie;
        _cStylesheetDownloading++;
    }
}

//+-------------------------------------------------------------------
//
//  Member:     CDoc::LeaveStylesheetDownload
//
//  Synopsis:   Note that stylesheet is finished downloading
//
//--------------------------------------------------------------------

void
CDoc::LeaveStylesheetDownload(DWORD * pdwCookie)
{
    if (*pdwCookie == _dwStylesheetDownloadingCookie)
    {
        *pdwCookie = 0;
        _cStylesheetDownloading--;
    }
}

//+------------------------------------------------------------------------
//
//  Member:     CDoc::GetActiveXSafetyProvider
//
//  Synopsis:   Get an IActiveXSafetyProvider pointer, or return NULL if
//              there isn't one installed.
//
//-------------------------------------------------------------------------

HRESULT
   CDoc::GetActiveXSafetyProvider(IActiveXSafetyProvider **ppProvider)
{
    HRESULT hr;
    LONG l;
    HKEY hKey;

    if (_pActiveXSafetyProvider) {
        if (_pActiveXSafetyProvider == (IActiveXSafetyProvider *)-1) {
            //
            // A previous call has determined that there is no safety
            // provider installed.  Return S_OK, but set *ppProvider to NULL.
            //
            *ppProvider = NULL;
        } else {
            //
            // Use the cached ActiveXSafetyProvider.
            //
            *ppProvider = _pActiveXSafetyProvider;
        }
        TraceTag((tagCDoc, "CDoc::GetActiveXSafetyProvider returning cached value 0x%x", *ppProvider));
        return S_OK;
    }

    //
    // See if an IActiveXSafetyProvider is present by peeking into the
    // registry.
    //
    l = RegOpenKeyA(HKEY_CLASSES_ROOT,
                    "CLSID\\{aaf8c6ce-f972-11d0-97eb-00aa00615333}",
                    &hKey
                   );
    if (l != ERROR_SUCCESS) {
        //
        // No ActiveXSafetyProvider installed.  Cache this information.
        //
        _pActiveXSafetyProvider = (IActiveXSafetyProvider *)-1;
        *ppProvider = NULL;
        TraceTag((tagCDoc, "CDoc::GetActiveXSafetyProvider - provider not installed"));
        return S_OK;
    }
    RegCloseKey(hKey);

    //
    // Call OLE to instantiate the ActiveXSafetyProvider.  If this fails,
    // _pActiveXSafetyProvider will remain NULL, so the operation will
    // be retried next time someone calls this routine.
    //
    hr = CoCreateInstance(CLSID_IActiveXSafetyProvider,
                          NULL,
                          CLSCTX_INPROC_SERVER,
                          IID_IActiveXSafetyProvider,
                          (void **)&_pActiveXSafetyProvider
                         );

    *ppProvider = _pActiveXSafetyProvider;
    TraceTag((tagCDoc, "CDoc::GetActiveXSafetyProvider - caching provider 0x%x", *ppProvider));
    return hr;
}

//+-------------------------------------------------------------------
//
//  Member:     CDoc::GetWindowForBinding
//
//  Synopsis:   Gets a window for binding UI
//
//--------------------------------------------------------------------

void
CDoc::GetWindowForBinding(HWND * phwnd)
{
    IOleWindow *        pOleWindow = NULL;

    // try in-place window
    *phwnd = GetHWND();

    // try client site window
    if (!*phwnd && _pClientSite)
        if (!_pClientSite->QueryInterface(IID_IOleWindow, (void **)&pOleWindow))
            IGNORE_HR(pOleWindow->GetWindow(phwnd));

    // resort to desktop window
    if (!*phwnd)
        *phwnd = GetDesktopWindow();

    ReleaseInterface(pOleWindow);
}



//+-------------------------------------------------------------------
//
//  Member:     CDoc::GetWindow, IWindowForBindingUI
//
//  Synopsis:   Default implementation of the IWindowForBindingUI
//              service
//
//--------------------------------------------------------------------

HRESULT
CDoc::GetWindowBindingUI(REFGUID rguidReason, HWND * phwnd)
{
    if (IsPrintDoc())
    {
        *phwnd = HWND_DESKTOP;
        return S_OK;
    }

    if (_dwLoadf & DLCTL_SILENT)
    {
        *phwnd = (HWND)INVALID_HANDLE_VALUE;
        return(S_FALSE);
    }

    GetWindowForBinding(phwnd);

    return S_OK;
}



//+-------------------------------------------------------------------
//
//  Member:     CDoc::Authenticate, IAuthenticate
//
//  Synopsis:   Default implementation of the IAuthenticate service
//
//--------------------------------------------------------------------

HRESULT
CDoc::Authenticate(HWND * phwnd, LPWSTR * ppszUsername, LPWSTR * ppszPassword)
{
    if (_dwLoadf & DLCTL_SILENT)
        *phwnd = (HWND)-1;
    else
    {
        GetWindowForBinding(phwnd);
    }

    *ppszUsername = NULL;
    *ppszPassword = NULL;

    return(S_OK);
}


//+-------------------------------------------------------------------
//
//  Member:     CDoc::ShowLoadError
//
//  Synopsis:   Shows a message box stating that the document could
//              not be loaded, the URL, and the reason.
//
//--------------------------------------------------------------------

HRESULT
CDoc::ShowLoadError(CHtmCtx *pHtmCtx)
{
    TCHAR *pchMessage = NULL;
    TCHAR achReason[256];
    TCHAR *pchReason;
    HRESULT hr;

    // If there was an explicit error-reason message, show it
    pchReason = pHtmCtx->GetErrorString();

    // Otherwise, format up a generic error message based on GetBindResult
    if (!pchReason)
    {
        hr = THR(GetErrorText(pHtmCtx->GetBindResult(), achReason, ARRAY_SIZE(achReason)));
        if (hr)
            goto Cleanup;

        pchReason = achReason;
    }

    // Internet Explorer cannot open the internet site <url>.\n<reason>

    hr = THR(Format(FMT_OUT_ALLOC,
           &pchMessage,
           64,
           MAKEINTRESOURCE(IDS_CANNOTLOAD),
           (LPTSTR)_cstrUrl,
           pchReason));
    if (hr)
        goto Cleanup;

    hr = THR(ShowMessageEx(NULL,
                  MB_OK | MB_ICONSTOP | MB_SETFOREGROUND,
                  NULL,
                  0,
                  pchMessage));
    if (hr)
        goto Cleanup;

Cleanup:
    MemFree(pchMessage);

    RRETURN(hr);
}

//+-------------------------------------------------------------------
//
//  Member:     CDoc::MoveSystemCaret
//
//  Synopsis:   Decides if the system caret should be moved to track
//              user moves ---  for accessibility purposes.
//
//--------------------------------------------------------------------
extern BOOL g_fScreenReader;

BOOL
CDoc::MoveSystemCaret()
{
    BOOL fMove = g_fScreenReader;

    //
    // If the screen reader is installed, then ignore what the registry says,
    // and always move the system caret.
    //
    if (!fMove)
    {
        //
        // If screen reader is not installed, then we need to look at what
        // registry has to say about moving the system caret.
        //
        HRESULT hr = THR(EnsureOptionSettings());
        if (hr)
            goto Cleanup;

        fMove = _pOptionSettings->fMoveSystemCaret;
    }

Cleanup:
    return fMove;
}

//+-------------------------------------------------------------------
//
//  Member:         CDoc::recalc
//
//  Parameters:     fForce - tells the recalc engine to re-evaluate all expressions
//                           not just dirty ones
//
//  Description:    Forces the recalc engine to do a recalc now
//
//--------------------------------------------------------------------

STDMETHODIMP
CDoc::recalc(VARIANT_BOOL fForce)
{
    RRETURN(SetErrorInfo(_recalcHost.EngineRecalcAll(fForce)));
}

//+-------------------------------------------------------------------
//
//  Member:     CDoc::suspendRecalc
//
//--------------------------------------------------------------------
STDMETHODIMP
CDoc::suspendRecalc(BOOL fSuspend)
{
    RRETURN(_recalcHost.SuspendRecalc(!!fSuspend));
}



#ifdef IE5_ZOOM
//+-------------------------------------------------------------------
//
//  Member:     CDoc::zoom
//
//--------------------------------------------------------------------

HRESULT
CDoc::zoom(long Numer, long Denom)
{
    if (Denom <= 0)
        return E_INVALIDARG;

    _dci.zoom(Numer, Numer, Denom);
    ForceRelayout();

    return S_OK;
}

//+-------------------------------------------------------------------
//
//  Member:     CDoc::get_zoomNumerator
//
//--------------------------------------------------------------------

HRESULT
CDoc::get_zoomNumerator(long * pNumer)
{
    if (pNumer != NULL)
    {
#ifdef IE5_ZOOM
        *pNumer = _dci.GetNumerX();
#else
        *pNumer = 1;
#endif
    }

    return S_OK;
}

//+-------------------------------------------------------------------
//
//  Member:     CDoc::get_zoomDenominator
//
//--------------------------------------------------------------------

HRESULT
CDoc::get_zoomDenominator(long * pDenom)
{
    if (pDenom != NULL)
#ifdef IE5_ZOOM
        *pDenom = _dci.GetDenom();
#else
        *pDenom = 1;
#endif

    return S_OK;
}

#endif IE5_ZOOM



//+-------------------------------------------------------------------
//
//  Member:     CDoc::SetCpAutoDetect 
//
//  Synopsis:   Set the flag that indicates cp is to be auto-detected
//              [review] this also refresh the 'autodetect' reg entry
//                       could we find better place to do this?
//
//  Returns:    S_OK - if auto detect is flipped
//
//--------------------------------------------------------------------
static const TCHAR s_szAutoDetect[] = TEXT("AutoDetect");
static const TCHAR s_szDefaultCodepage[] = TEXT("Default_CodePage");
HRESULT
CDoc::SetCpAutoDetect(BOOL fSet)
{
    HRESULT hr = S_OK;

    if (_pOptionSettings)
    {
        if (_pOptionSettings->fCpAutoDetect != fSet)
        {
            DWORD dwWrite;
            CStr  cstrPath;

            hr = THR(cstrPath.Set(NULL, _tcslen(_pOptionSettings->achKeyPath)+_tcslen(s_szPathInternational)+1));
            if (hr)
                goto Cleanup;

            _tcscpy(cstrPath, _pOptionSettings->achKeyPath);
            _tcscat(cstrPath, s_szPathInternational);

            dwWrite = fSet ? 1 : 0;

            hr =  SHSetValue(HKEY_CURRENT_USER, cstrPath,  s_szAutoDetect, REG_DWORD, 
                             (void*)&dwWrite,  sizeof(dwWrite));

            if (hr == NO_ERROR)
            {
                _pOptionSettings->fCpAutoDetect = !!fSet;
            }
        }
    }
    else
        hr = E_FAIL;
Cleanup:
    return hr;
}

//+-------------------------------------------------------------------
//
//  Member:     CDoc::IsCpAutoDetect 
//
//  Synopsis:   Get the flag that indicates cp is to be auto-detected
//
//  Returns:    BOOL true if auto mode is set
//
//--------------------------------------------------------------------

BOOL
CDoc::IsCpAutoDetect(void)
{
    BOOL bret;

    if (_pOptionSettings)
        bret = (BOOL)_pOptionSettings->fCpAutoDetect;
    else
        bret = FALSE;

    return bret;
}

HRESULT
CDoc::SaveDefaultCodepage(CODEPAGE cp)
{
    HRESULT hr = S_OK;
    if (_pOptionSettings)
    {
        if ( _pOptionSettings->codepageDefault != cp)
        {
            CStr cstrPath;
            hr = THR(cstrPath.Set(NULL, _tcslen(_pOptionSettings->achKeyPath)+_tcslen(s_szPathInternational)+1));
            if (hr)
                goto Cleanup;

            _tcscpy(cstrPath, _pOptionSettings->achKeyPath);
            _tcscat(cstrPath, s_szPathInternational);

            hr =  SHSetValue(HKEY_CURRENT_USER, cstrPath, s_szDefaultCodepage, 
                                               REG_BINARY, (void *)&cp, sizeof(cp));
            if (hr == NO_ERROR)
                _pOptionSettings->codepageDefault = cp;
        }
    }
Cleanup:
    return hr;
}


HRESULT
CDoc::attachEvent(BSTR event, IDispatch* pDisp, VARIANT_BOOL *pResult)
{
    RRETURN(CBase::attachEvent(event, pDisp, pResult));
}

HRESULT
CDoc::detachEvent(BSTR event, IDispatch* pDisp)
{
    RRETURN(CBase::detachEvent(event, pDisp));
}

#ifdef QUILL

BOOL
CDoc::FExternalLayout()
{
    return (!_pqdocGlue ? FALSE : _pqdocGlue->FExternalLayout());
}


#endif // QUILL

//+---------------------------------------------------------------------------
//
//  Member:     CDoc::QueryVersionHost
//
//  Synopsis:   Sets up the local or global CVersions object
//
//----------------------------------------------------------------------------

HRESULT
CDoc::QueryVersionHost()
{
    HRESULT hr = S_OK;
    IVersionHost *pVersionHost = NULL;
    IVersionVector *pVersionVector = NULL;
    BOOL fUseLocal = FALSE;
    CVersions *pVersions = NULL;

    HKEY hkey = NULL;

    if (_pVersions)
        return S_OK;

    if (!OK(THR_NOTRACE(QueryService(
            SID_SVersionHost,
            IID_IVersionHost,
            (void**)&pVersionHost))))
    {
        pVersionHost = NULL;

        pVersions = GetGlobalVersions();
        if (!pVersions)
            fUseLocal = TRUE;
    }
    else
    {
        hr = THR(pVersionHost->QueryUseLocalVersionVector(&fUseLocal));
        if (hr)
            goto Cleanup;

        if (!fUseLocal)
        {
            pVersions = GetGlobalVersions();
        }
    }

    if (!pVersions)
    {
        pVersions = new CVersions();
        if (pVersions == NULL)
        {
            hr = E_OUTOFMEMORY;
            goto Cleanup;
        }

        hr = THR(pVersions->Init());
        if (hr)
            goto Cleanup;

        hr = THR(pVersions->GetVersionVector(&pVersionVector));
        if (hr)
            goto Cleanup;

        // Enumerate through the HKLM\Software\Microsoft\Internet Explorer\Version Vector key
        // setting versions.
        // We should always find at least "IE", "x.x.xxxx", which is registered in selfreg.inx.
        if (RegOpenKey(HKEY_LOCAL_MACHINE,
                TEXT("Software\\Microsoft\\Internet Explorer\\Version Vector"),
                &hkey) == ERROR_SUCCESS)
        {
            for (int iValue = 0; ;iValue++)
            {
                OLECHAR    wszValue[256];
                OLECHAR    wszVersion[256];
                DWORD      dwType;
                DWORD      cchValue = ARRAY_SIZE(wszValue);
                DWORD      cchVersion = ARRAY_SIZE(wszVersion);

                if (SHEnumValueW(hkey, iValue, wszValue, &cchValue, 
                                 &dwType, wszVersion, &cchVersion)==ERROR_SUCCESS)
                {
                    // BUGBUG HACKHACK (alexz) in IE5, we disable VML for OE4 and Outlook98, per IE5 bug 69437
                    if ((_fOE4 || _fOutlook98) && wszValue && 0 == StrCmpIC(_T("VML"), wszValue))
                        continue;

                    hr = pVersionVector->SetVersion(wszValue, wszVersion);
                    if (hr)
                        goto Cleanup;
                }
                else
                {
                    break;
                }
            }
        }

        // Now give the host a chance to set some version vector info.
        if (pVersionHost)
        {
            hr = THR(pVersionHost->QueryVersionVector(pVersionVector));
            if (hr)
                goto Cleanup;
        }

        if (!fUseLocal)
        {
            if (!SuggestGlobalVersions(pVersions))
            {
                // Another thread has won the race to supply a global version; get it
                pVersions->Release();
                pVersions = GetGlobalVersions();
                Assert(pVersions);
            }
        }
    }
    Assert(pVersions);

    _pVersions = pVersions;
    pVersions = NULL;

Cleanup:
    if (pVersions)
        pVersions->Release();
    ReleaseInterface(pVersionHost);
    ReleaseInterface(pVersionVector);

    if (hkey != NULL)
        RegCloseKey(hkey);
        
    RRETURN(hr);
}

//-----------------------------------------------------------------------------
//
//  Function:   CDoc::FaultInUSP
//
//  Synopsis:   Async callback to JIT install UniScribe (USP10.DLL)
//
//  Arguments:  DWORD (CDoc *)  The current doc from which the hWnd can be gotten
//
//  Returns:    none
//
//-----------------------------------------------------------------------------

void CDoc::FaultInUSP(DWORD_PTR dwContext)
{
    HRESULT hr;
    uCLSSPEC classpec;
    CStr cstrGUID;
    ULONG cDie = _cDie;
    BOOL  fRefresh = FALSE;

    PrivateAddRef();
    g_csJitting.Enter();

    Assert(g_bUSPJitState == JIT_PENDING);

    // Close the door. We only want one of these running.
    g_bUSPJitState = JIT_IN_PROGRESS;

    // Set the GUID for USP10 so JIT can lookup the feature
    cstrGUID.Set(TEXT("{b1ad7c1e-c217-11d1-b367-00c04fb9fbed}"));

    // setup the classpec
    classpec.tyspec = TYSPEC_CLSID;
    hr = CLSIDFromString((BSTR)cstrGUID, &classpec.tagged_union.clsid);

    if(hr == S_OK)
    {
        hr = THR(FaultInIEFeatureHelper(GetHWND(), &classpec, NULL, 0));
    }

    // if we succeeded or the document navigated away (process was killed in
    // CDoc::UnloadContents) set state to JIT_OK so IOD can be attempted
    // again without having to restart the host.
    if(hr == S_OK)
    {
        g_bUSPJitState = JIT_OK;
        if(cDie == _cDie)
            fRefresh = TRUE;
    }
    else
    {
        // The user cancelled or aborted. Don't ask for this again
        // during this session.
        g_bUSPJitState = JIT_DONT_ASK;
    }

    g_csJitting.Leave();
    
    // refresh the view if we have just installed.
    if(fRefresh)
    {
        _view.EnsureView(LAYOUT_SYNCHRONOUS | LAYOUT_FORCE);
    }

    PrivateRelease();
}

//-----------------------------------------------------------------------------
//
//  Function:   CDoc::FaultInJG
//
//  Synopsis:   Async callback to JIT install JG ART library for AOL (JG*.DLL)
//
//-----------------------------------------------------------------------------

void CDoc::FaultInJG(DWORD_PTR dwContext)
{
    HRESULT hr;
    uCLSSPEC classpec;
    CStr cstrGUID;

    if (g_bJGJitState != JIT_PENDING)
        return;

    // Close the door. We only want one of these running.
    g_bJGJitState = JIT_IN_PROGRESS;

    HWND hWnd = GetHWND();
    // Set the GUID for JG*.dll so JIT can lookup the feature
    cstrGUID.Set(_T("{47f67d00-9e55-11d1-baef-00c04fc2d130}"));

    // setup the classpec
    classpec.tyspec = TYSPEC_CLSID;
    hr = CLSIDFromString((BSTR) cstrGUID, &classpec.tagged_union.clsid);

    if (hr == S_OK)
    {
        hr = THR(FaultInIEFeatureHelper(hWnd, &classpec, NULL, 0));
    }

    // if we succeeded or the document navigated away (process was killed in
    // CDoc::UnloadContents) set state to JIT_OK so IOD can be attempted
    // again without having to restart the host.
    if (hr == S_OK)
    {
        g_bJGJitState = JIT_OK;
    }
    else
    {
        // The user cancelled or aborted. Don't ask for this again
        // during this session.
        g_bJGJitState = JIT_DONT_ASK;
    }

}

//+---------------------------------------------------------------------------
//
//  Member:     CBase::ExpandedRelativeUrlInVariant
//
//  Synopsis:   Used by CBase::getAttribute to expand an URL if the property
//              retrieved is an URL and the GETMEMBER_ABSOLUTE is specified.
//
//----------------------------------------------------------------------------

HRESULT
CBase::ExpandedRelativeUrlInVariant(VARIANT *pVariantURL)
{
    HRESULT         hr = S_OK;
    TCHAR           cBuf[pdlUrlLen];
    TCHAR          *pchUrl = cBuf;

    if (pVariantURL && V_VT(pVariantURL) == VT_BSTR)
    {
        BSTR            bstrURL;
        IHTMLElement   *pElement;
        CElement       *pCElement;

        // Are we really an element?
        if (!PrivateQueryInterface(IID_IHTMLElement, (void **)&pElement))
        {
            ReleaseInterface(pElement);

            pCElement = DYNCAST(CElement, this);

            hr = pCElement->Doc()->ExpandUrl(V_BSTR(pVariantURL), ARRAY_SIZE(cBuf), pchUrl, pCElement);
            if (hr)
                goto Cleanup;

            hr = FormsAllocString(pchUrl, &bstrURL);
            if (hr)
                goto Cleanup;

            VariantClear(pVariantURL);

            V_BSTR(pVariantURL) = bstrURL;
            V_VT(pVariantURL) = VT_BSTR;
        }
    }
    else
        hr = S_OK;

Cleanup:

    RRETURN(hr);
}


//+---------------------------------------------------------------------------
//
//  Member:     CDoc::DeferSetCursor
//
//  Synopsis:   After scrolling we want to post a setcursor message to our
//              window so that the cursor shape will get updated. However,
//              because of nested scrolls, we might end up with multiple
//              setcursor calls. To avoid this, we will post a method call
//              to the function which actually does the postmessage. During
//              the setup of the method call we will delete any existing
//              callbacks, and hence this will delete any existing callbaks.
//
//----------------------------------------------------------------------------
void
CDoc::DeferSetCursor()
{
    GWKillMethodCall (this, ONCALL_METHOD(CDoc, SendSetCursor, sendsetcursor), 0);
    IGNORE_HR(GWPostMethodCall (this,
                                ONCALL_METHOD(CDoc, SendSetCursor, sendsetcursor),
                                0, FALSE, "CDoc::SendSetCursor"));
}


//+---------------------------------------------------------------------------
//
//  Member:     CDoc::SendMouseMessage
//
//  Synopsis:   This function actually posts the message to our window.
//
//----------------------------------------------------------------------------
void
CDoc::SendSetCursor(DWORD_PTR dwContext)
{
    // First be sure that we are all OK
    // Do this only if we have focus. We don't want to generate mouse events
    // when we do not have focus (bug 9144)
    if (    _pInPlace
        &&  _pInPlace->_hwnd
        &&  HasFocus())
    {
        CPoint  pt;
        CRect   rc;

        ::GetCursorPos(&pt);
        ::GetClientRect(_pInPlace->_hwnd, &rc);

        // Next be sure that the mouse is in our client rect and only then
        // post ourselves the message.
        if (rc.Contains(pt))
        {
            ::PostMessage(_pInPlace->_hwnd, WM_SETCURSOR, (WORD)_pInPlace->_hwnd, HTCLIENT);
        }
    }
}


//+====================================================================================
//
// Method: SetClick
//
// Synopsis: Enable the Setting and passing of click messages
//
//------------------------------------------------------------------------------------

VOID
CDoc::SetClick(CMessage* pMessage)
{
    BOOL            fEditable   = FALSE;

    CFlowLayout *   pFlowUp     = pMessage->pNodeHit->GetFlowLayout();

    if (pFlowUp)
    {
        fEditable = pFlowUp->ElementOwner()->IsEditable(TRUE);
    }
    else
    {
        fEditable = pMessage->pNodeHit->Element()->IsEditable(TRUE);

    }
    if (!fEditable)
        pMessage->SetNodeClk(pMessage->pNodeHit);
}


//+==========================================================
//
// Method: UpdateCaret
//
// Synopsis: Informs the caret that it's position has been
//           changed externally.
//
//-----------------------------------------------------------

HRESULT
CDoc::UpdateCaret(
    BOOL        fScrollIntoView,    //@parm If TRUE, scroll caret into view if we have
                                    // focus or if not and selection isn't hidden
    BOOL        fForceScroll,       //@parm If TRUE, scroll caret into view regardless
    CDocInfo *  pdci )
{
    HRESULT hr = S_OK;

    if( _pCaret )
        hr = _pCaret->UpdateCaret( fScrollIntoView, fForceScroll, pdci );

    RRETURN( hr );
}

//+==========================================================
//
// Method: HandleSelectionMessage
//
// Synopsis: Dispatch a message to the Selection Manager if it exists.
//
//
//-----------------------------------------------------------
HRESULT
CDoc::HandleSelectionMessage(
    CMessage* pMessage,
    BOOL fForceCreate )
{
    BOOL fNeedToSetEditContext = FALSE;
    BOOL fAllowSelection = TRUE;
    
    if (pMessage->fSelectionHMCalled)
        return S_FALSE;
    else if (   _pElemEditContext
             && pMessage->message >= WM_KEYFIRST
             && pMessage->message <= WM_KEYLAST
             && _pElemEditContext != _pElemCurrent
             && !(      _pElemCurrent->HasSlaveMarkupPtr()
                    &&  _pElemCurrent->GetSlaveMarkupPtr()->FirstElement() == _pElemEditContext
                 )
            )
    {
        // We get here if the selection is in an alement that does not have focus.
        // In such a state, we want commands to be executable on the selection but
        // we do not want keystroke messages to go to the selection.
        return S_FALSE;
    }    
    else
    {
        HRESULT hr = S_FALSE;
        IHTMLEditor * ped = NULL;
        pMessage->fSelectionHMCalled = TRUE;

        CElement* pEditElement = NULL;
        
        if ( (pMessage->pNodeHit) &&
             (pMessage->pNodeHit->Element()->_etag == ETAG_ROOT ) )
            goto Cleanup;

        if ( pMessage->pNodeHit )
            pEditElement = pMessage->pNodeHit->Element();
        else
            pEditElement = NULL;

        AssertSz( !_pDragStartInfo || ( _pDragStartInfo && pMessage->message != WM_MOUSEMOVE ),
                  "Sending a Mouse Message to the tracker during a drag !");

        //
        // We just got a mouse down. If the element is not editable,
        // we need to set the Edit Context ( as SetEditContext may not have already happened)
        // If we don't do this the manager may not have a tracker for the event !
        //
        // 

        fNeedToSetEditContext = (pEditElement  && 
                                (ShouldSetEditContext( pMessage ) && 
                                  ( !pEditElement->IsEditable(FALSE) || 
                                    !pEditElement->IsEnabled() || 
                                    !_pElemEditContext)));

        if ( fNeedToSetEditContext )             // we only check if we think we need to set the ed. context
            fAllowSelection = pEditElement && ! pEditElement->DisallowSelection() ;

        ped = GetHTMLEditor( fForceCreate || ( fNeedToSetEditContext && fAllowSelection ) );

        //
        // Set the ON-Click handler to make sure On-click event still works
        // even if selection is disallowed
        //
        if ( ! ped && 
               pMessage->pNodeHit &&
               pMessage->message == WM_LBUTTONUP )
        {
            SetClick( pMessage );
        }
        
        if ( ped && fNeedToSetEditContext )
        {
            hr = THR( SetEditContext( pEditElement, FALSE, FALSE ));
            if ( hr )
                goto Cleanup;
        }

        if ( ped && (pMessage->pNodeHit == NULL || !pMessage->pNodeHit->IsDead()) )
        {   
            SelectionMessage theMessage;
            DWORD takeAction = FOLLOW_UP_ACTION_None;

            CMessageToSelectionMessage( pMessage, & theMessage );

            hr = ped->HandleMessage( & theMessage, & takeAction );

            // BUGBUG (MohanB) Need to copy any other info?
            // Perhaps call SelectionMessageToCMessage?
            pMessage->fStopForward = theMessage.fStopForward;

            if ( takeAction != FOLLOW_UP_ACTION_None )
            {
                //
                // BUGBUG - we go through this rigmarole to not lose the HR passed back from ed.
                // We want to eventually remove ProcessFollowUp entirely.
                //
                // (jbeda) We want to let S_OK override S_FALSE from either call
                // (HandleMessage or ProcessFollowUpAction) but we want to let
                // any error code through.
                //

                HRESULT hrProcessFollowUp;
                hrProcessFollowUp = ProcessFollowUpAction( pMessage, takeAction );
                if ( hrProcessFollowUp != S_FALSE && SUCCEEDED(hr) )
                    hr = hrProcessFollowUp;
            }                

            pMessage->lresult = theMessage.lResult;
        }

    Cleanup:

        return hr;
    }    
}


//+====================================================================================
//
// Method: Select
//
// Synopsis: 'Select from here to here' a wrapper to the selection manager.
//
//------------------------------------------------------------------------------------

HRESULT
CDoc::Select( 
                IMarkupPointer* pStart, 
                IMarkupPointer* pEnd, 
                SELECTION_TYPE eType )
{
    HRESULT hr = S_OK;

    IHTMLEditingServices * pEdServices = NULL;
    
    DWORD followUpAction = FOLLOW_UP_ACTION_None;
    
    IHTMLEditor* pEditor = GetHTMLEditor();
    if ( ! pEditor )
    {
        hr = E_FAIL;
        goto Cleanup;
    }

    hr = THR( EnsureEditContext( pStart ));
    if ( hr )
    {
        AssertSz(0, "Ensure Edit Context failed");
        goto Cleanup;
    }

    hr = THR( pEditor->QueryInterface(IID_IHTMLEditingServices, ( void**) & pEdServices ));
    if ( hr )
        goto Cleanup;
        
    hr = THR( pEdServices->Select( pStart, pEnd, eType , & followUpAction));  

    if ( followUpAction != FOLLOW_UP_ACTION_None )
        ProcessFollowUpAction ( NULL , followUpAction );
        
Cleanup:
    ReleaseInterface( pEdServices );

    RRETURN ( hr );
}

//+====================================================================================
//
// Method: IsElementSiteselectable
//
// Synopsis: Determine if a given elemnet is site selectable by asking mshtmled.dll.
//
//------------------------------------------------------------------------------------



BOOL
CDoc::IsElementSiteSelectable( CElement* pCurElement)
{
    HRESULT hr = S_OK;
    HRESULT hrSiteSelectable = S_FALSE;
    IHTMLEditor* ped = NULL;
    IHTMLEditingServices * pIEditingServices = NULL;
    IHTMLElement * pICurElement = NULL;    
    
    ped = GetHTMLEditor( TRUE );        
    Assert( ped );

    if ( ped )
    {
        hr = THR( ped->QueryInterface( IID_IHTMLEditingServices, (void** ) & pIEditingServices));
        if ( hr )
            goto Cleanup;
        hr = THR( pCurElement->QueryInterface( IID_IHTMLElement, (void**) & pICurElement));
        if ( hr)
            goto Cleanup;
            
        hrSiteSelectable = pIEditingServices->IsElementSiteSelectable( pICurElement );
    }
    
Cleanup:
    ReleaseInterface( pICurElement);
    ReleaseInterface( pIEditingServices);
    
    return ( hrSiteSelectable == S_OK );
}

//+====================================================================================
//
// Method: IsElementUIActivatable
//
// Synopsis: Determine if a given elemnet is site selectable by asking mshtmled.dll.
//
//------------------------------------------------------------------------------------



BOOL
CDoc::IsElementUIActivatable( CElement* pCurElement)
{
    HRESULT hr = S_OK;
    HRESULT hrActivatable = S_FALSE;
    IHTMLEditor* ped = NULL;
    IHTMLEditingServices * pIEditingServices = NULL;
    IHTMLElement * pICurElement = NULL;    
    
    ped = GetHTMLEditor( TRUE );        
    Assert( ped );

    if ( ped )
    {
        hr = THR( ped->QueryInterface( IID_IHTMLEditingServices, (void** ) & pIEditingServices));
        if ( hr )
            goto Cleanup;
        hr = THR( pCurElement->QueryInterface( IID_IHTMLElement, (void**) & pICurElement));
        if ( hr)
            goto Cleanup;
            
        hrActivatable = pIEditingServices->IsElementUIActivatable( pICurElement );
    }
    
Cleanup:
    ReleaseInterface( pICurElement);
    ReleaseInterface( pIEditingServices);
    
    return ( hrActivatable  == S_OK );
}

//+====================================================================================
//
// Method: IsElementSiteselected
//
// Synopsis: Determine if a given elemnet is currently site selected 
//
//------------------------------------------------------------------------------------



BOOL
CDoc::IsElementSiteSelected( CElement* pCurElement)
{
    HRESULT hr = S_OK;
    HRESULT hrSiteSelected = S_FALSE;
    IHTMLEditor* ped = NULL;
    IHTMLElement * pICurElement = NULL;    
    
    ped = GetHTMLEditor( TRUE );        
    Assert( ped );

    if ( ped && pCurElement)
    {
        hr = THR( pCurElement->QueryInterface( IID_IHTMLElement, (void**) & pICurElement));
        if ( hr)
            goto Cleanup;
            
        hrSiteSelected = ped->IsElementSiteSelected( pICurElement );
    }
    
Cleanup:
    ReleaseInterface( pICurElement);

    return ( hrSiteSelected == S_OK );
}

//+====================================================================================
//
// Method: SetEditContext
//
// Synopsis: Sets the 'Edit Context' - by cocreating a Selection Mgr if necessary.
//
//------------------------------------------------------------------------------------

HRESULT
CDoc::SetEditContext( CElement* pElement, BOOL fForceCreate, BOOL fSetSelection, BOOL fDrillingIn )
{
    HRESULT hr = S_OK;

    IHTMLEditor * ped = NULL;
    IMarkupPointer* pStart = NULL;
    IMarkupPointer* pEnd = NULL;
    CElement* pEditableElement = NULL;
    BOOL fThisEditable = FALSE;
    BOOL fParentEditable = FALSE;
    BOOL fNoScope = FALSE;

    Assert( pElement );

    ped = GetHTMLEditor( fForceCreate );


    if( ped )
    {

        hr = THR( CreateMarkupPointer( & pStart ));
        if ( hr )
            goto Cleanup;

        hr = THR( CreateMarkupPointer( & pEnd ));
        if ( hr )
            goto Cleanup;


        hr = THR( AdjustEditContext( 
                                    pElement,
                                    &pEditableElement,
                                    pStart,
                                    pEnd,
                                    &fThisEditable ,
                                    &fParentEditable,
                                    &fNoScope ,
                                    FALSE,
                                    TRUE,
                                    fDrillingIn ));
                                    
        hr = THR( ped->SetEditContext( 
                                        fThisEditable,
                                        fSetSelection,
                                        fParentEditable,
                                        pStart,
                                        pEnd , 
                                        fNoScope ));
                                        
     }
     AssertSz( ( !_pInPlace    ||
                 !_pElemEditContext ||
                 ! _fDesignMode ||
                 _pElemEditContext == _pElemCurrent || 
                ( _pElemEditContext->TestLock(CElement::ELEMENTLOCK_FOCUS )) ||
                ( _pElemEditContext->MarkupMaster()->TestLock(CElement::ELEMENTLOCK_FOCUS )) ||                 
                (_pElemEditContext && _pElemEditContext->MarkupMaster() == _pElemCurrent)), 
                 "Currency and context do not match" );               

Cleanup:
    ReleaseInterface( pStart );
    ReleaseInterface( pEnd );

    return hr;
}

//+====================================================================================
//
// Method:NotifySelection
//
// Synopsis: Notify the HTMLEditor that "something" happened.
//
//------------------------------------------------------------------------------------

HRESULT
CDoc::NotifySelection(
                        SELECTION_NOTIFICATION eSelectionNotification,
                        IUnknown* pUnknown ,
                        DWORD dword /* = 0 */ )
{
    HRESULT hr = S_OK;

    DWORD theAction = FOLLOW_UP_ACTION_None ;
    IHTMLEditor * ped = NULL;

    if ( ( eSelectionNotification == SELECT_NOTIFY_DOC_ENDED ) && _pIHTMLEditor )
    {
        StopHTMLEditorDblClickTimer();
    }
    //
    // If we get a timer tick - when the doc is shut down this is very bad
    //
    Assert( ! ( (  eSelectionNotification == SELECT_NOTIFY_TIMER_TICK )
            && (_ulRefs == ULREF_IN_DESTRUCTOR)) );

    if( _pIHTMLEditor == NULL && ! ShouldCreateHTMLEditor( eSelectionNotification ))
        goto Cleanup;    // Nothing to do

    ped = GetHTMLEditor( TRUE );

    if ( ped )
    {
        hr = ped->Notify( eSelectionNotification, pUnknown, & theAction, dword );
        if ( theAction != FOLLOW_UP_ACTION_None )
        {
            ProcessFollowUpAction( NULL, theAction );
        }
    }

Cleanup:

    RRETURN ( hr );
}


//+====================================================================================
//
// Method:  GetSelectionType
//
// Synopsis:Check the current selection type of the selection manager
//
//------------------------------------------------------------------------------------


SELECTION_TYPE
CDoc::GetSelectionType()
{
    SELECTION_TYPE theType = SELECTION_TYPE_None;

    if ( _pIHTMLEditor )
    {
         _pIHTMLEditor->GetSelectionType( & theType );
    }

    return theType;
}

//+====================================================================================
//
// Method: HasTextSelection
//
// Synopsis: Is there a "Text Selection"
//
//------------------------------------------------------------------------------------


BOOL
CDoc::HasTextSelection()
{
    return ( GetSelectionType() == SELECTION_TYPE_Selection );
}


//+====================================================================================
//
// Method: HasSelection
//
// Synopsis: Is there any form of Selection ?
//
//------------------------------------------------------------------------------------

BOOL
CDoc::HasSelection()
{
    return ( GetSelectionType() != SELECTION_TYPE_None );
}


//+====================================================================================
//
// Method: PointInSelection
//
// Synopsis: Is the given point in a Selection ? Returns false if there is no selection
//
//------------------------------------------------------------------------------------

BOOL
CDoc::IsPointInSelection(POINT pt, CTreeNode* pNode, BOOL fPtIsContent )
{
    // BUGBUG (MohanB) This function does not check for clipping, because
    // MovePointerToPoint always does virtual hit-testing. We should pass
    // in an argument fDoVirtualHitTest to MovePointerToPoint() and set that
    // argument to FALSE when calling from this function.

    HRESULT hr = S_OK;
    
    IMarkupPointer* pPointer = NULL;
    BOOL fBOL = FALSE;
    BOOL fAtLogicalBOL = FALSE;
    IHTMLEditor* ped = NULL;
    BOOL fPointInSelection = FALSE;
    BOOL fRightOfCp = FALSE;
    CMarkupPointer* pPointerInternal;
    IHTMLElement* pIElementOver = NULL;
    CElement* pElement = NULL;
    SELECTION_TYPE eType = GetSelectionType() ;
    
    if ( eType == SELECTION_TYPE_Control || eType == SELECTION_TYPE_Selection )
    {
        //
        // marka BUGBUG - consider making this take the node - and work out the pointer more directly
        //
        hr = THR( CreateMarkupPointer( & pPointer ));
        if ( hr )
            goto Cleanup;

        if ( pNode && fPtIsContent )
        {
            hr = THR( pPointer->QueryInterface( CLSID_CMarkupPointer, (void**) & pPointerInternal));
            if( hr )
                goto Cleanup;
                
            hr = THR( MovePointerToPointInternal(   pt,
                                                    pNode,
                                                    pPointerInternal,
                                                    & fBOL, & fAtLogicalBOL, & fRightOfCp, FALSE, GetFlowLayoutForSelection( pNode ) ));
            if ( hr )
                goto Cleanup;
        }
        else
        {
            hr = THR( MoveMarkupPointerToPoint( pt, pPointer, & fBOL, & fAtLogicalBOL, & fRightOfCp, FALSE  ));
            if ( hr )
                goto Cleanup;
        }
        ped = GetHTMLEditor(FALSE );
        Assert( ped );

        if ( pNode )
        {
            pElement = pNode->Element();
        }            
        if ( pElement )
        {
            hr = THR( pElement->QueryInterface( IID_IHTMLElement, ( void**) & pIElementOver));
            if ( hr )
                goto Cleanup;
        }

        hr = THR( ped->IsPointerInSelection( pPointer, & fPointInSelection , &pt, pIElementOver));    

        
    }

Cleanup :
    ReleaseInterface( pPointer );
    ReleaseInterface( pIElementOver );
    return fPointInSelection;
    
}



//+====================================================================================
//
// Method: ProcessFollowUpAction
//
// Synopsis: Interpret the FOLLOW_UP_ACTION code given to use after processing a
//           message from the HTMLEditor
//
// Note:     Returning S_FALSE says we didn't do anything.  We only return S_OK from
//           a return to a call to DragElement
//
//------------------------------------------------------------------------------------


HRESULT
CDoc::ProcessFollowUpAction( CMessage* pMessage, DWORD dwFollowUpAction )
{
    HRESULT hr = S_FALSE;
    
    Assert( dwFollowUpAction != FOLLOW_UP_ACTION_None );
    //
    // BUGBUG - consider shifting bits and testing ?
    //

    //********************************************************
    //           !!! WARNING WARNING WARNING !!!
    //
    //  Do not change the order of bits it is significant
    //
    //********************************************************

    if ( ( dwFollowUpAction & FOLLOW_UP_ACTION_OnClick) != 0 )
    {
        SetClick( pMessage );
    }
    if (( dwFollowUpAction & FOLLOW_UP_ACTION_DragElement) != 0)
    {
        hr = THR( DragElement( pMessage ));
        if (hr == S_FALSE)
            hr = S_OK;
    }

    RRETURN1( hr, S_FALSE );
}

//+========================================================================
//
// Method: ShouldCreateHTMLEditor
//
// Synopsis: Certain messages require the creation of a selection ( like Mousedown)
//           For these messages return TRUE.
//
//          Or if the Host will host selection Manager - return TRUE.
//-------------------------------------------------------------------------

BOOL
CDoc::ShouldCreateHTMLEditor( CMessage* pMessage )
{
    if ( _fHostDrivesEditing )
        return true;

    // If this is a MouseDown message, we should force a TSR to be created
    // Per Bug 18568 we should also force a TSR for down/up/right/left arrows
    switch(pMessage->message)
    {
        case WM_LBUTTONDOWN:
        /*case WM_MBUTTONDOWN:
        case WM_RBUTTONDOWN:*/
            return TRUE;

        //
        // marka BUGBUG - this may not be required anymore.
        //
        case WM_KEYDOWN:
            switch(pMessage->wParam)
            {
            case VK_LEFT:
            case VK_UP:
            case VK_RIGHT:
            case VK_DOWN:
                return TRUE;

            }
        default:
            return FALSE;
    }
}


//+====================================================================================
//
// Method:ShouldCreateHTMLEditor
//
// Synopsis: Should we force the creation of a selection manager for this type of notify ?
//
//------------------------------------------------------------------------------------


BOOL
CDoc::ShouldCreateHTMLEditor( SELECTION_NOTIFICATION eSelectionNotification )
{
    if ( _fHostDrivesEditing )
        return TRUE;

    return FALSE;
}

//+========================================================================
//
// Method: ShouldSetEditContext.
//
// Synopsis: On Mouse Down we should always set a new EditContext
//
//-------------------------------------------------------------------------

inline BOOL
CDoc::ShouldSetEditContext( CMessage* pMessage )
{
    switch(pMessage->message)
    {
        case WM_LBUTTONDOWN:
        case WM_RBUTTONDOWN:
                    return TRUE;
        default:
            return FALSE;
    }
}

//+====================================================================================
//
// Method: GetEditingServices
//
// Synopsis: Get a ref-counted IHTMLEditingServices, 
//           forcing creation of the editor if there isn't one
//
//------------------------------------------------------------------------------------


HRESULT 
CDoc::GetEditingServices( IHTMLEditingServices** ppIServices )
{
    HRESULT hr = S_OK;
    
    IHTMLEditor* ped = GetHTMLEditor(TRUE);
    if ( ped )
    {
        hr = THR( ped->QueryInterface( IID_IHTMLEditingServices, (void**) ppIServices));
    }
    else
    {
        hr = E_FAIL;
    }
    
    RRETURN ( hr );
}
//+==========================================================
//
// Method: GetHTMLEditor
//
// Synopsis: This is the real GetHTMLEditor
//                QueryService on the Host for the HTMLEditor Service
//              if it's there - we QI the host for it.
//              if it's not there - we cocreate the HTMLEditor in Mshtmled
//
//-----------------------------------------------------------


IHTMLEditor* 

CDoc::GetHTMLEditor( BOOL fForceCreate /* = TRUE */ )
{
    HRESULT hr = S_OK;

    // If we have an editor already, just return it

    if( _pIHTMLEditor )
        goto Cleanup;


    if( fForceCreate )
    {
    
#if 0   // Do this some day
        // If we don't have one, try to see if the host wants to be the editor

        IServiceProvider * pServiceProvider = NULL;
        hr = this->QueryInterface(IID_IServiceProvider, (void**)&pServiceProvider);
        if (hr)
            goto Error;

        hr = pServiceProvider->QueryService( SID_SHTMLEditor,
                                             IID_IHTMLEditor,
                                             (void **) &_pIHTMLEditor );
        ReleaseInterface( pServiceProvider );

        if( !FAILED( hr ) && _pIHTMLEditor != NULL )
        {
            Assert( _pIHTMLEditor );
            _fHostDrivesEditing = TRUE;
            goto Initialize;
        }
#endif  // Do this some day


        // If the host doesn't want to be the editor, mshtmled sure does!
        MtAdd( Mt( LoadMSHTMLEd ), +1 , 0 );
        hr = ::CoCreateInstance(CLSID_HTMLEditor,
                                NULL,
                                CLSCTX_INPROC_SERVER,
                                IID_IHTMLEditor ,
                                (void**) &_pIHTMLEditor );

        if( FAILED( hr ) || _pIHTMLEditor == NULL )
            goto Error;
        
#if 0  // Do this some day
Initialize:
#endif // Do this some day

        //
        // Use a weak-ref to all doc interfaces. Use _OmDocument for CView while it
        // doesn't exist...
        //
        hr = THR(_pIHTMLEditor->Initialize( (IUnknown *)(IPrivateUnknown *)_pPrimaryMarkup,
                                            (IUnknown *)(IPrivateUnknown *)_pPrimaryMarkup ));
        if ( FAILED(hr) )
            goto Error;
            
    }   // fForceCreate
    
                                            
    goto Cleanup;
    
Error:
    ClearInterface( & _pIHTMLEditor );


Cleanup:
    AssertSz( ! ( fForceCreate && _pIHTMLEditor == NULL ) , "IHTMLEditor Not Found or Allocated on Get!" );

    return( _pIHTMLEditor );    
}




//+================================================================================
//
// Method: HandleSelMgrMessageCapture
//
// Synopsis: Handle a Selection Manager Message - when the Selection Manager
//           has capture.
//
//          This method is given as a Pointer to a F'n when SetHTMLEditorCapture
//--------------------------------------------------------------------------------
    
HRESULT BUGCALL
CDoc::HandleEditMessageCapture(
    CMessage *      pMessage )
{
    HRESULT             hr = S_OK;    
    DWORD               theAction = FOLLOW_UP_ACTION_None;
    SelectionMessage    theMessage;

    if (pMessage->pNodeHit == NULL || !pMessage->pNodeHit->IsDead())
    {    
        CMessageToSelectionMessage( pMessage , & theMessage );    
        theMessage.fFromCapture = TRUE; // Let them know that the actual point is from me...
        HRESULT hrProcessFollowUp; 
        
        // 
        // Pass on to the editor
        //
        if ( _pIHTMLEditor && _fInEditCapture )
        {
            hr = THR( _pIHTMLEditor->HandleMessage( & theMessage , & theAction ));

            // BUGBUG (MohanB) Need to copy any other info?
            // Perhaps call SelectionMessageToCMessage?
            pMessage->fStopForward = theMessage.fStopForward;

            // 
            // Process follow up action, if any. BTW: This is the only reason we need a 
            // CMessage above. If we kill this, populate the SelectionMessage directly.
            //
            
            if ( pMessage->pNodeHit != NULL && theAction != FOLLOW_UP_ACTION_None )
            {
                hrProcessFollowUp = THR( ProcessFollowUpAction( pMessage , theAction ));
                if ( hrProcessFollowUp != S_OK )
                    hr = hrProcessFollowUp;
            }
        }
    }
    
    //
    // Dont return an Error code for failure - it makes SetEditCapture not work.
    //        
    
    return ( hr );
}


//+====================================================================================
//
// Method: OnSelectDblClickTimer
//
// Synopsis: Callback that for WM_TIMER messages inside Trident. Relays the Timer
//           messages back to the HTMLEditor's OnTimerTick method.
//
//------------------------------------------------------------------------------------

HRESULT
CDoc::OnEditDblClkTimer(UINT idTimer)
{
    HRESULT hr ;

    Assert( _pIHTMLEditor );

    hr = NotifySelection( SELECT_NOTIFY_TIMER_TICK, NULL );

    RRETURN ( hr );
}




void
CMessageToSelectionMessage( const CMessage* pMessage, SelectionMessage* pSelMessage )
{
    pSelMessage->message            = pMessage->message;
    pSelMessage->time               = pMessage->time;
    pSelMessage->pt                 = pMessage->pt;

    if ( pMessage->pNodeHit )
    {
        CLayout* pLayout = pMessage->pNodeHit->Doc()->GetLayoutForSelection( pMessage->pNodeHit );
        if ( pLayout )
        {
            // If we have multiple text nodes, pMessage->ptContent can be relative
            // to the text display node. But most of the selection code works with
            // layout relative coordinates. So, translate the pt to layout relative.
            //
            pSelMessage->ptContent = pMessage->pt;
            pLayout->TransformPoint( (CPoint*) &pSelMessage->ptContent, COORDSYS_GLOBAL, COORDSYS_CONTENT );
        }
    }
    else
    {
        pSelMessage->ptContent = pMessage->ptContent;
    }
    pSelMessage->wParam             = pMessage->wParam;
    pSelMessage->lParam             = pMessage->lParam;
    pSelMessage->elementCookie      = (DWORD_PTR)pMessage->pNodeHit;
    pSelMessage->characterCookie    = pMessage->resultsHitTest._cpHit;
    pSelMessage->fCtrl              = pMessage->dwKeyState & FCONTROL;
    pSelMessage->fShift             = pMessage->dwKeyState & FSHIFT;
    pSelMessage->fAlt               = pMessage->dwKeyState & FALT;
    pSelMessage->fStopForward       = pMessage->fStopForward;
    pSelMessage->fFromCapture       = FALSE;
    pSelMessage->fEmptySpace        = pMessage->resultsHitTest._fWantArrow;    
    pSelMessage->hwnd               = pMessage->hwnd;
    pSelMessage->lResult            = pMessage->lresult;
}

void
SelectionMessageToCMessage( const SelectionMessage* pSelMessage, CMessage* pMessage)
{
    pMessage->message               = pSelMessage->message;
    pMessage->time                  = pSelMessage->time;
    pMessage->pt                    = pSelMessage->pt;
    pMessage->ptContent             = pSelMessage->ptContent;
    pMessage->wParam                = pSelMessage->wParam;
    pMessage->lParam                = pSelMessage->lParam;
    pMessage->resultsHitTest._cpHit = pSelMessage->characterCookie;
    
    pMessage->fStopForward          = pSelMessage->fStopForward;
    pMessage->fStopForward          = pSelMessage->fStopForward;
    pMessage->hwnd                  = pSelMessage->hwnd;
    pMessage->lresult               = pSelMessage->lResult;
    pMessage->resultsHitTest._fWantArrow = pSelMessage->fEmptySpace ;
    
    pMessage->SetNodeHit((CTreeNode*)pSelMessage->elementCookie);

    if (pSelMessage->fCtrl)
        pMessage->dwKeyState |= FCONTROL;
    if (pSelMessage->fShift)
        pMessage->dwKeyState |= FSHIFT;
    if (pSelMessage->fAlt)
        pMessage->dwKeyState |= FALT;

    // We assume that this is called only by the selection handler, so we
    // always set this flag to TRUE.
    pMessage->fSelectionHMCalled = TRUE;
}

//+====================================================================================
//
// Method: GetSelectionDragDropSource
//
// Synopsis: If this doc is the source of a drag/drop, and we are drag/dropping a selection
//           return the CSelDragDropSrcInfo. Otherwise return NULL.
//
//------------------------------------------------------------------------------------


CSelDragDropSrcInfo* 
CDoc::GetSelectionDragDropSource()
{
    if ( _fIsDragDropSrc   &&
         _pDragDropSrcInfo &&
         _pDragDropSrcInfo->_srcType == DRAGDROPSRCTYPE_SELECTION )
    {
        return DYNCAST( CSelDragDropSrcInfo, _pDragDropSrcInfo );
    }
    else
        return NULL;
}

//+============================================================================
//
// Method: DragElement
//
// Synopsis: Manage a drag from this Message
//
// BUGBUG - this could be handle via ViewServ DragElement. Do it that way some time
//
//-----------------------------------------------------------------------------


HRESULT  
CDoc::DragElement(CMessage* pMessage)
{
    Assert( _pElemEditContext );
    CParentUndo pu( this );
    HRESULT hr ;
    CFlowLayout* pFlowLayout = NULL;
    
    pu.Start( IDS_UNDOMOVE );
    {
        CSelectionUndo Undo( _pElemCurrent, GetCurrentMarkup() );    
    }

    if ( pMessage->pNodeHit && 
         pMessage->pNodeHit->Element()  &&
         _pElemEditContext &&
         _pElemEditContext->GetFirstBranch() )
    {    
        pFlowLayout = GetFlowLayoutForSelection( _pElemEditContext->GetFirstBranch() );
        if ( ! pFlowLayout )
        {
            hr = E_FAIL;
            goto Cleanup;
        }
        
        pMessage->pNodeHit->Element()->DragElement(
            pFlowLayout ,
            pMessage->dwKeyState, 
            NULL,
            pMessage->lSubDivision);

        hr = S_OK;            
    }
    else 
    {
        hr = E_FAIL;
    }
    //
    // BUGBUG marka - make Drag/Drop return a failure code here - so we give
    // the right value to the failure code.
    //

    {
        CDeferredSelectionUndo DeferredUndo( GetCurrentMarkup() );
    }    

Cleanup:

    pu.Finish( hr );

    RRETURN ( hr );
}


//+---------------------------------------------------------------------------
//
// Helper Function: IsValidAccessKey
//
//----------------------------------------------------------------------------
BOOL
IsValidAccessKey(CDoc * pDoc, CMessage * pmsg)
{
    BOOL fResult =  (pmsg->message == WM_SYSKEYDOWN)
                 || (pDoc->_fInHTMLDlg && pmsg->message == WM_CHAR);
    if (fResult)
    {
        fResult =  (pmsg->wParam != VK_MENU)
                && (pDoc->_aryAccessKeyItems.Size() > 0);
    }
    return fResult;
}

BOOL IsFrameTabKey(CMessage * pMessage);
BOOL IsTabKey(CMessage * pMessage);

//+---------------------------------------------------------------------------
//
//  Member:     PerformTA
//
//  Synopsis:   Handle any accelerators
//
//  Arguments:  [pMessage]  -- message
//
//  Returns:    Returns S_OK if keystroke processed, S_FALSE if not.
//----------------------------------------------------------------------------
HRESULT
CDoc::PerformTA(CMessage * pMessage)
{
    HRESULT     hr    = S_FALSE;

    Assert(State() >= OS_INPLACE);

    // WinUser.h better not change! We are going to assume the order of the
    // navigation keys (Left/Right/Up/Down/Home/End/PageUp/PageDn), so let's
    // assert about it.
    Assert(VK_PRIOR + 1 == VK_NEXT);
    Assert(VK_NEXT  + 1 == VK_END);
    Assert(VK_END   + 1 == VK_HOME);
    Assert(VK_HOME  + 1 == VK_LEFT);
    Assert(VK_LEFT  + 1 == VK_UP);
    Assert(VK_UP    + 1 == VK_RIGHT);
    Assert(VK_RIGHT + 1 == VK_DOWN);

    if (WM_KEYDOWN == pMessage->message || WM_SYSKEYDOWN == pMessage->message)
    {
        // Handle accelerator here.
        //  1. Pass any accelerators that the editor requires
        //  2. Bubble up the element chain starting from _pElemCurrent (or capture elem)
        //     and call PerformTA on them
        //  3. Perform key navigation for TAB and accesskey


        //  Editor requires VK_TAB in <PRE> (61302), VK_BACK(58719, 58774),
        //  and the navigation keys 
        if (    pMessage->message == WM_KEYDOWN
            &&  (   pMessage->wParam == VK_BACK
                 || (pMessage->wParam >= VK_PRIOR && pMessage->wParam <= VK_DOWN)
                 || (pMessage->wParam == VK_TAB && FCaretInPre())
                )
           )
        {
            hr = THR(HandleSelectionMessage(pMessage, FALSE));
            if (hr != S_FALSE)
                goto Cleanup;
        }


        // BGBUG (MohanB) This will be wrong if an element can take keyboard capture without being current
        CElement *  pElemTarget         = _pElemCurrent;

        CTreeNode * pNodeTarget         = pElemTarget->GetFirstBranch();
        BOOL        fGotEnterKey        = (pMessage->message == WM_KEYDOWN && pMessage->wParam == VK_RETURN);
        BOOL        fTranslateEnterKey  = FALSE;

        while (pNodeTarget && pElemTarget && pElemTarget->Tag() != ETAG_ROOT)
        {
            // BUGBUG (MohanB) Clean this up in IE6 by using the subdivision concept (#58231)
            // Hack for tabbing between the button and text regions of InputFile
            if (WM_KEYDOWN == pMessage->message && VK_TAB == pMessage->wParam && pElemTarget->Tag() == ETAG_INPUT)
            {
                CInput * pInput = DYNCAST(CInput, pElemTarget);

                if (pInput->GetType() == htmlInputFile)
                {
                    hr = pInput->HandleFileMessage(pMessage);
                    if (hr != S_FALSE)
                        goto Cleanup;
                }
            }

            hr = pElemTarget->PerformTA(pMessage);
            if (hr != S_FALSE)
                goto Cleanup;

            // Navigation keys are dealt with in HandleMessage, but we need to
            // treat them as accelerators (because many hosts such as HomePublisher
            // and KatieSoft Scroll expect us to - IE5 66735, 63774).

            if (    WM_KEYDOWN  == pMessage->message
                &&  VK_PRIOR    <= pMessage->wParam
                &&  VK_DOWN     >= pMessage->wParam
               )
            {
                // On the other hand, VID6.0 wants the fist shot at some of them if
                // there is a site-selection (they should fix this in VID6.1)
                if (    _fVID
                    &&  pMessage->wParam >= VK_LEFT
                    &&  GetSelectionType() == SELECTION_TYPE_Control)
                {
                    // let go to the host
                }
                else
                {
                    hr = pElemTarget->HandleMessage(pMessage);
                    if (hr != S_FALSE)
                        goto Cleanup;
                }
            }

            // Raid 44891
            // Some hosts like AOL, CompuServe and MSN eat up the Enter Key in their
            // TranslateAccelerator, so we never get it in our WindowProc. We work around
            // by explicitly translating WM_KEYDOWN+VK_RETURN to WM_CHAR+VK_RETURN
            //
            if (fGotEnterKey && !pElemTarget->IsEditable(TRUE))
            {
                if (pElemTarget->_fActsLikeButton)
                {
                    fTranslateEnterKey = TRUE;
                }
                else
                {
                    switch (pElemTarget->Tag())
                    {
                    case ETAG_A:
                    case ETAG_IMG:
                    case ETAG_TEXTAREA:
                        fTranslateEnterKey = TRUE;
                        break;
                    }
                }
                if (fTranslateEnterKey)
                    break;
            }

            // Find the next target
            pNodeTarget = pNodeTarget->Parent();
            if (pNodeTarget)
            {
                pElemTarget = pNodeTarget->Element();
            }
            else
            {
                pElemTarget = pElemTarget->MarkupMaster();
                pNodeTarget = pElemTarget->GetFirstBranch();
            }
        }
        // Pressing 'Enter' should activate the default button
        // (unless the focus is on a SELECT - IE5 #64133)
        if (fGotEnterKey && !fTranslateEnterKey && !_fDesignMode && _pElemCurrent->Tag() != ETAG_SELECT)
        {
             fTranslateEnterKey = !!_pElemCurrent->FindDefaultElem(TRUE);
        }
        if (fTranslateEnterKey)
        {
            ::TranslateMessage(pMessage);
            hr = S_OK;
            goto Cleanup;
        }

        Assert(hr == S_FALSE);

        if (IsFrameTabKey(pMessage)
            || IsTabKey(pMessage)
            || IsValidAccessKey(this, pMessage))
        {
            hr = HandleKeyNavigate(pMessage, FALSE);

            if (hr != S_FALSE)
                goto Cleanup;

            // Comment (jenlc). Say that the document has two frames, the
            // first frame has two controls with access keys ALT+A and ALT+B
            // respectively while the second frame has a control with access
            // key ALT+A. Suppose currently the focus is on the control with
            // access key ALT+B (the second control of the first frame) and
            // ALT+A is pressed, which control should get the focus? Currently
            // Trident let the control in the second frame get the focus.
            //
            if (IsTabKey(pMessage) || IsFrameTabKey(pMessage))
            {
                // Clear any selection
                NotifySelection( SELECT_NOTIFY_DESTROY_ALL_SELECTION, NULL );        

                IGNORE_HR( _pPrimaryMarkup->Root()->BecomeCurrentAndActive());
            }
        }
    }
    // Raid 63207
    // If we call IOleControSite::TranslateAccelerator() here for WM_CHAR
    // in HTML Dialog, this would cause WM_CHAR message to be re-dispatched
    // back to us, which is an infinite loop.
    //
    if (hr == S_FALSE &&
            (!_fInHTMLDlg || pMessage->message != WM_CHAR))
    {
        hr = CallParentTA(pMessage);
    }

    if (IsFrameTabKey(pMessage)
        || IsTabKey(pMessage)
        || IsValidAccessKey(this, pMessage))
    {
        if (hr == S_OK)
        {
            _pElemUIActive = NULL;
        }
        else if (hr == S_FALSE)
        {
            hr = HandleKeyNavigate(pMessage, TRUE);

            if (hr == S_FALSE && pMessage->message != WM_SYSKEYDOWN)
            {
                CElement *pElement = GetPrimaryElementClient();
                if (pElement)
                {
                    pElement->BecomeCurrentAndActive(NULL, pMessage->lSubDivision, TRUE);
                    hr = S_OK;  
                }
            }
        }
    }

Cleanup:
    RRETURN1(hr, S_FALSE);
}


BOOL
CDoc::FCaretInPre()
{
    if (_pCaret)
    {
        CTreeNode * pNode = _pCaret->GetNodeContainer(MPTR_SHOWSLAVE);

        if (pNode)
        {
            const CParaFormat * pPF = pNode->GetParaFormat();
            if (pPF)
            {
                return pPF->_fPre;
            }
        }
    }

    return FALSE;
}



HRESULT
CDoc::GetTagInfo (
        CTreePos *              ptp, 
        int                     gAlign, 
        int                     gPositioning, 
        int                     gOrientation, 
        void *                  invalidateInfo, 
        CGlyphRenderInfoType *  ptagInfo
        )
{
    HRESULT hr = S_OK;

    if (_pGlyphTable != NULL)
    {
        hr = _pGlyphTable->GetTagInfo (ptp, (GLYPH_ALIGNMENT_TYPE)gAlign, 
                  (GLYPH_POSITION_TYPE)gPositioning, (GLYPH_ORIENTATION_TYPE)gOrientation, 
                  invalidateInfo, ptagInfo);
    }
    
    return (hr);
}
//
//
BOOL
CDoc::IsUrlRecursive( TCHAR * pchUrl )
{   
    HRESULT hr = S_OK;
    CDoc *  pDoc = this; // initialize to ourselves
    TCHAR   achUrlOnly[pdlUrlLen];
    LPTSTR  pchLocation;
    BOOL    fRes = FALSE;

    //prepare a copy of the pchUrl, which can be manipulated and changed.
    StrCpy(achUrlOnly, pchUrl);

    // if there is a '#....' at the end of the url, we
    // don't want to have it there for the comparisons.
    pchLocation = (LPTSTR) UrlGetLocation(achUrlOnly);
    
    if (pchLocation)
        * pchLocation = _T('\0');
    
    // if we are pointing to any of the documents in the parent chain, 
    // we would recurse forever. 
    while ( pDoc )
    {
        DWORD   cchParentUrl = pdlUrlLen;
        TCHAR   achParentUrl[pdlUrlLen];

        hr = THR(UrlCanonicalize(
                    (LPTSTR) pDoc->_cstrUrl,
                    (LPTSTR) achParentUrl,
                    &cchParentUrl,
                    URL_ESCAPE_SPACES_ONLY | URL_BROWSER_MODE));
                    
        // if the hr is wrong leave with a no-recursion return value,
        // this is by design (anandra-ferhane)
        if (hr)
            goto Cleanup;
            
        pchLocation = (LPTSTR) UrlGetLocation(achParentUrl);
        if (pchLocation)
            * pchLocation = _T('\0');

        // UrlCompare returns 0 if the urls are the same
        if ( !UrlCompare( achUrlOnly, achParentUrl, TRUE) )
        {
            // if two urls are the same, then the given url is recursive
            fRes = TRUE;
            goto Cleanup;
        }
        
        pDoc = pDoc->_pDocParent;
    }

Cleanup:
    return fRes;
}


#if DBG==1
BOOL    
CDoc::AreLookasidesClear( void *pvKey, int nLookasides)
{
    DWORD * pdwKey = (DWORD*)pvKey;

    for ( ; nLookasides > 0; nLookasides--, pdwKey++ )
    {
        if (_HtPvPv.IsPresent( pdwKey ))
            return FALSE;
    }

    return TRUE;
}
#endif


// Aggregration helper for XML MimeViewer
// RETURN true if we're being aggregated by the XML MimeViewer
extern "C" const IID IID_IXMLViewerIdentity;
BOOL CDoc::IsAggregatedByXMLMime()
{
    if (IsAggregated())
    {
        IUnknown *pXMLViewer = NULL;
        HRESULT hr = PunkOuter()->QueryInterface(IID_IXMLViewerIdentity, (void **)&pXMLViewer);
        if (hr == S_OK)
        {
            pXMLViewer->Release();
            return TRUE;
        }
    }
    return FALSE;
}

BOOL
CDoc::AddFilterTask(CElement *pElement)
{
    if (!pElement->_fHasPendingFilterTask)
    {
        TraceTag((tagFilter, "Adding filter task for element %08x", pElement));

        Assert(_aryPendingFilterElements.Find(pElement) == -1);

        pElement->_fHasPendingFilterTask = SUCCEEDED(_aryPendingFilterElements.Append(pElement));

        PostFilterCallback();
    }

    return pElement->_fHasPendingFilterTask;
}

void
CDoc::RemoveFilterTask(CElement *pElement)
{
    if (pElement->_fHasPendingFilterTask)
    {
        int i = _aryPendingFilterElements.Find(pElement);

        Assert(i >= 0);
        if (i >= 0)
        {
            _aryPendingFilterElements[i] = NULL;
            pElement->_fHasPendingFilterTask = FALSE;

            TraceTag((tagFilter, "%08x Removing filter task", pElement));

            // We don't delete anything from the array, that will happen when the
            // ExecuteFilterTasks is called.

            Assert(_fPendingFilterCallback);
        }
    }
}

//+---------------------------------------------------------------------------
//
//  Member:     ExecuteSingleFilterTask
//
//  Synopsis:   Execute pending filter hookup for a single element
//
//              Can be called at anytime without worrying about trashing
//              the queue array
//
//----------------------------------------------------------------------------

BOOL
CDoc::ExecuteSingleFilterTask(CElement *pElement)
{
    if (!pElement->_fHasPendingFilterTask)
        return FALSE;

    int i = _aryPendingFilterElements.Find(pElement);

    Assert(i >= 0);

    if (i < 0)
        return FALSE;

    Assert(_aryPendingFilterElements[i] == pElement);

    // This function doesn't actually delete the entry, it simply nulls it out
    // The array is cleaned up when ExecuteFilterTasks is complete
    _aryPendingFilterElements[i] = NULL;

    pElement->_fHasPendingFilterTask = FALSE;

    TraceTag((tagFilter, "%08x demand executing filter task", pElement));
    pElement->ApplyFilterCollection();

    return TRUE;
}



//+---------------------------------------------------------------------------
//
//  Member:     ExecuteFilterTasks
//
//  Synopsis:   Execute pending filter hookup
//
//  Notes;      This code is 100% re-entrant safe.  Call it whenever, however
//              you want and it must do the right thing.  Re-entrancy into
//              other functions (like ComputeFormats) is the responsibility
//              of the caller :-)
//
//  Arguments:  grfLayout - Collections of LAYOUT_xxxx flags
//
//  Returns:    TRUE if all tasks were processed, FALSE otherwise
//
//----------------------------------------------------------------------------

BOOL
CDoc::ExecuteFilterTasks()
{
    // We don't want to do this while we're painting
    if (TestLock(SERVERLOCK_BLOCKPAINT))
    {
        if (_aryPendingFilterElements.Size())
        {
            PostFilterCallback();
            return FALSE;
        }

        return TRUE;    // No tasks means that they all got done, right?
    }

    // Sometimes this gets called on demand.  We may have a posted callback, get rid of it now.
    // REVIEW (michaelw) Should this be inside the FORMLOCK_FILTER block?
    if (_fPendingFilterCallback)
    {
        _fPendingFilterCallback = FALSE;
        GWKillMethodCall(this, ONCALL_METHOD(CDoc, FilterCallback, filtercallback), 0);
    }

    // If we're in the middle of doing this (for whatever reason), don't start again
    // The primary reason for not starting again has to do with trying to cleanup the
    // array, otherwise this code is re-entrant safe
    Assert(!TestLock(FORMLOCK_FILTER));
    if (!TestLock(FORMLOCK_FILTER))
    {
        CLock lock(this, FORMLOCK_FILTER);

        // We're only going to do as many elements as are there when we start
        int c = _aryPendingFilterElements.Size();

        if (c > 0)
        {
            for (int i = 0 ; i < c ; i++)
            {
                CElement *pElement = _aryPendingFilterElements[i];

                if (pElement)
                {
                    _aryPendingFilterElements[i] = NULL;

                    Assert(pElement->_fHasPendingFilterTask);
                    pElement->_fHasPendingFilterTask = FALSE;

                    TraceTag((tagFilter, "%08x Executing filter task from filter task list (also removes)", pElement));

                    // This calls out to external code, anything could happen?
                    pElement->ApplyFilterCollection();
                    if (_aryPendingFilterElements.Size() < c)
                        return FALSE;
                }
            }

            // Adding filters occasionally causes more filter
            // work.  Rather than doing it immediately, we'll
            // just wait until next time.
            Assert(_aryPendingFilterElements.Size() >= c);

            if (_aryPendingFilterElements.Size() > c)
                PostFilterCallback();
            _aryPendingFilterElements.DeleteMultiple(0, c - 1);
        }
    }

    return (_aryPendingFilterElements.Size() == 0);
}

void
CDoc::PostFilterCallback()
{
    if (!_fPendingFilterCallback)
    {
        TraceTag((tagFilter, "PostFilterCallback"));
        _fPendingFilterCallback = SUCCEEDED(GWPostMethodCall(this,ONCALL_METHOD(CDoc, FilterCallback, filtercallback), 0, FALSE, "CDoc::FilterCallback"));
        Assert(_fPendingFilterCallback);
    }
}

void
CDoc::FilterCallback(DWORD_PTR)
{
    Assert(_fPendingFilterCallback);
    if (_fPendingFilterCallback)
    {
        TraceTag((tagFilter, "FilterCallback"));
        _fPendingFilterCallback = FALSE;
        ExecuteFilterTasks();
    }
}

