//+---------------------------------------------------------------------
//
//   File:      element.cxx
//
//  Contents:   Element class
//
//  Classes:    CElement
//
//------------------------------------------------------------------------

#include "headers.hxx"

#ifndef X_FORMKRNL_HXX_
#define X_FORMKRNL_HXX_
#include "formkrnl.hxx"
#endif

#ifndef X_CONNECT_HXX_
#define X_CONNECT_HXX_
#include "connect.hxx"
#endif

#ifndef X_COLLECT_HXX_
#define X_COLLECT_HXX_
#include "collect.hxx"
#endif

#ifndef X_MSHTMLRC_H_
#define X_MSHTMLRC_H_
#include "mshtmlrc.h"
#endif

#ifndef X_ELEMENT_HXX_
#define X_ELEMENT_HXX_
#include "element.hxx"
#endif

#ifndef X_CFPF_HXX_
#define X_CFPF_HXX_
#include "cfpf.hxx"
#endif

#ifndef X_HTMTAGS_HXX_
#define X_HTMTAGS_HXX_
#include "htmtags.hxx"
#endif

#ifndef X_STRBUF_HXX_
#define X_STRBUF_HXX_
#include "strbuf.hxx"
#endif

#ifndef X__DOC_H_
#define X__DOC_H_
#include "_doc.h"
#endif

#ifndef X_TREEPOS_HXX_
#define X_TREEPOS_HXX_
#include <treepos.hxx>
#endif

#ifndef X_IRANGE_HXX_
#define X_IRANGE_HXX_
#include "irange.hxx"
#endif

#ifndef X__TXTSAVE_H_
#define X__TXTSAVE_H_
#include "_txtsave.h"
#endif

#ifndef X_STYLE_HXX_
#define X_STYLE_HXX_
#include "style.hxx"
#endif

#ifndef X_HYPLNK_HXX_
#define X_HYPLNK_HXX_
#include "hyplnk.hxx"
#endif

#ifndef X_EANCHOR_HXX_
#define X_EANCHOR_HXX_
#include "eanchor.hxx"
#endif

#ifndef X_ELABEL_HXX_
#define X_ELABEL_HXX_
#include "elabel.hxx"
#endif

#ifndef X_INPUTTXT_HXX_
#define X_INPUTTXT_HXX_
#include "inputtxt.hxx"
#endif

#ifndef X_DOWNLOAD_HXX_
#define X_DOWNLOAD_HXX_
#include "download.hxx"
#endif

#ifndef X_DISPEX_H_
#define X_DISPEX_H_
#include "dispex.h"
#endif

#ifndef X_WINDOW_HXX_
#define X_WINDOW_HXX_
#include "window.hxx"
#endif

#ifndef X_EBODY_HXX_
#define X_EBODY_HXX_
#include "ebody.hxx"    // for body's dispids
#endif

#ifndef X_MISCPROT_H_
#define X_MISCPROT_H_
#include "miscprot.h"
#endif

#ifndef X_OMRECT_HXX_
#define X_OMRECT_HXX_
#include "omrect.hxx"
#endif

#ifndef X_EMAP_HXX_
#define X_EMAP_HXX_
#include "emap.hxx"
#endif

#ifndef X_EAREA_HXX_
#define X_EAREA_HXX_
#include "earea.hxx"
#endif

#ifndef X_FILTCOL_HXX_
#define X_FILTCOL_HXX_
#include "filtcol.hxx"
#endif

#ifndef X_CSITE_HXX_
#define X_CSITE_HXX_
#include "csite.hxx"
#endif

#ifndef X_FILTER_HXX_
#define X_FILTER_HXX_
#include "filter.hxx"
#endif

#ifndef X_AVUNDO_HXX_
#define X_AVUNDO_HXX_
#include "avundo.hxx"
#endif

#ifndef X_PEER_HXX_
#define X_PEER_HXX_
#include "peer.hxx"
#endif

#ifndef X_INTL_HXX_
#define X_INTL_HXX_
#include "intl.hxx"
#endif

#ifndef X_HEDELEMS_HXX_
#define X_HEDELEMS_HXX_
#include "hedelems.hxx"
#endif

#ifndef X_LAYOUT_HXX_
#define X_LAYOUT_HXX_
#include "layout.hxx"
#endif

#ifndef X_LTCELL_HXX_
#define X_LTCELL_HXX_
#include "ltcell.hxx"
#endif

#ifndef X_CURSTYLE_HXX_
#define X_CURSTYLE_HXX_
#include "curstyle.hxx"
#endif

#ifndef X_LTCELL_HXX_
#define X_LTCELL_HXX_
#include "ltcell.hxx"
#endif

#ifndef X_STRING_H_
#define X_STRING_H_
#include "string.h"
#endif

#ifndef X_SCRIPT_HXX_
#define X_SCRIPT_HXX_
#include "script.hxx"
#endif

#ifndef X_WCHDEFS_H_
#define X_WCHDEFS_H_
#include "wchdefs.h"
#endif

#ifndef X_TXTDEFS_H_
#define X_TXTDEFS_H_
#include "txtdefs.h"
#endif

#ifndef X_SHEETS_HXX_
#define X_SHEETS_HXX_
#include "sheets.hxx"
#endif

#ifndef X_EVNTPRM_HXX_
#define X_EVNTPRM_HXX_
#include "evntprm.hxx"
#endif

#ifndef X_DOCGLBS_HXX_
#define X_DOCGLBS_HXX_
#include "docglbs.hxx"
#endif

#ifndef X_CBUFSTR_HXX_
#define X_CBUFSTR_HXX_
#include "cbufstr.hxx"
#endif

#ifndef X_FRAMESET_HXX
#define X_FRAMESET_HXX
#include "frameset.hxx"
#endif

#ifndef X__TEXT_H_
#define X__TEXT_H_
#include "_text.h"
#endif

#ifndef X_TPOINTER_HXX_
#define X_TPOINTER_HXX_
#include "tpointer.hxx"
#endif

#ifndef X_DISPTREE_H_
#define X_DISPTREE_H_
#pragma INCMSG("--- Beg <disptree.h>")
#include <disptree.h>
#pragma INCMSG("--- End <disptree.h>")
#endif

#ifndef X_DISPTYPE_HXX_
#define X_DISPTYPE_HXX_
#include "disptype.hxx"
#endif

#ifndef X_DISPITEMPLUS_HXX_
#define X_DISPITEMPLUS_HXX_
#include "dispitemplus.hxx"
#endif

#ifndef X_DISPROOT_HXX_
#define X_DISPROOT_HXX_
#include "disproot.hxx"
#endif

#ifndef X_DISPCONTAINERPLUS_HXX_
#define X_DISPCONTAINERPLUS_HXX_
#include "dispcontainerplus.hxx"
#endif

#ifndef X_DISPSCROLLERPLUS_HXX_
#define X_DISPSCROLLERPLUS_HXX_
#include "dispscrollerplus.hxx"
#endif

#ifndef X_SBBASE_HXX_
#define X_SBBASE_HXX_
#include "sbbase.hxx"
#endif

#ifndef X_COLLBASE_HXX_
#define X_COLLBASE_HXX_
#include "collbase.hxx"
#endif

#ifndef X_DOMCOLL_HXX_
#define X_DOMCOLL_HXX_
#include "domcoll.hxx"
#endif

#ifndef X_DOM_HXX_
#define X_DOM_HXX_
#include "dom.hxx"
#endif

#ifndef X_URLCOMP_HXX_
#define X_URLCOMP_HXX_
#include "urlcomp.hxx"
#endif

#ifndef X_MSHTMDID_H_
#define X_MSHTMDID_H_
#include <mshtmdid.h>
#endif

MtDefine(CElementGetBoundingRect_aryRects_pv, Locals, "CElement::GetBoundingRect aryRects::_pv")
MtDefine(CElementgetClientRects_aryRects_pv, Locals, "CElement::getClientRects aryRects::_pv")
PerfDbgTag(tagInject, "Inject", "Inject");

DeclareTag(tagOM_DontFireMouseEvents, "ObjectModel", "don't fire mouse events");

ExternTag(tagRecalcStyle);

class CAnchorElement;

//+------------------------------------------------------------------------
//
//  Member:     IElement, Get_document
//
//  Synopsis:   Returns the Idocument of this
//
//-------------------------------------------------------------------------

HRESULT
CElement::get_document(IDispatch ** ppIDoc)
{
    HRESULT hr = CTL_E_METHODNOTAPPLICABLE;
    CDoc * pDoc = Doc();

    if (!ppIDoc)
    {
        hr = E_POINTER;
        goto Cleanup;
    }

    *ppIDoc = NULL;

    if (pDoc)
    {
        CMarkup *pMarkup;
        hr = THR(EnsureInMarkup());
        if (hr)
            goto Cleanup;
        
        pMarkup = GetMarkup();
        Assert(pMarkup);

        hr = THR_NOTRACE(pMarkup->QueryInterface(IID_IHTMLDocument2, (void**)ppIDoc));
    }

Cleanup:
    RRETURN(SetErrorInfo(hr));
}

//+------------------------------------------------------------------------
//
//  Member:     GettagName
//
//  Synopsis:   Returns the tag name of the current node.
//
//-------------------------------------------------------------------------

#ifdef VSTUDIO7
STDMETHODIMP
CElement::GettagName(BSTR * pTagName)
#else
HRESULT
CElement::get_tagName(BSTR * pTagName)
#endif //VSTUDIO7
{
    *pTagName = SysAllocString(TagName());

    RRETURN( SetErrorInfoPGet(*pTagName ? S_OK : E_OUTOFMEMORY, DISPID_CElement_tagName));
}

//+------------------------------------------------------------------------
//
//  Member:     GetscopeName
//
//  Synopsis:   Returns the scope name of the current node.
//
//-------------------------------------------------------------------------

HRESULT
#ifdef VSTUDIO7
CElement::GetscopeName(BSTR * pScopeName)
#else
CElement::get_scopeName(BSTR * pScopeName)
#endif //VSTUDIO7
{
    *pScopeName = SysAllocString(NamespaceHtml());

    RRETURN( SetErrorInfoPGet(*pScopeName ? S_OK : E_OUTOFMEMORY, DISPID_CElement_scopeName));
}

//+----------------------------------------------------------------------------
//
//  Member:     get_parentElement
//
//  Synopsis:   Exposes the parent element of this element.
//
//  Note:       This pays close attention to whether or not this interface is
//              based on a proxy element.  If so, use the parent of the proxy.
//
//-----------------------------------------------------------------------------

STDMETHODIMP
CElement::get_parentElement(IHTMLElement * * ppDispParent, CTreeNode * pNode)
{
    HRESULT hr = S_OK;

    *ppDispParent = NULL;

    if (!pNode || pNode->IsDead() )
    {
        pNode = GetFirstBranch();
        // Assert that either the node is not in the tree or that if it is, it is not dead
        Assert( !pNode || !pNode->IsDead() );
    }

    // if still no node, we are not in the tree, return NULL
    if (!pNode)
        goto Cleanup;

    Assert(pNode->Element() == this);

    pNode = pNode->Parent();

    // We should never hand out the root node with a tearoff
    // (root node is only one which has null parent)
    Assert(pNode);

    // don't hand out root node
    if (pNode->Tag() == ETAG_ROOT)
        goto Cleanup;

    hr = THR( pNode->GetElementInterface( IID_IHTMLElement, (void **) ppDispParent ) );

Cleanup:
    RRETURN(SetErrorInfoPGet(hr, STDPROPID_XOBJ_PARENT));
}

STDMETHODIMP
CElement::get_children(IDispatch **ppDispChildren)
{
    HRESULT hr = S_OK;
    CMarkup *pMarkup;

    if ( !ppDispChildren )
    {
        hr = E_INVALIDARG;
        goto Cleanup;
    }

    *ppDispChildren = NULL;

    hr = THR(EnsureInMarkup());
    if (hr)
        goto Cleanup;

    pMarkup = GetMarkupPtr();

    hr = THR(pMarkup->InitCollections());
    if (hr)
        goto Cleanup;

    hr = THR(pMarkup->CollectionCache()->CreateChildrenCollection(CMarkup::ELEMENT_COLLECTION, this, ppDispChildren, FALSE));

Cleanup:
    RRETURN(SetErrorInfoPGet(hr, DISPID_CElement_children));
}

HRESULT
GetAll(CElement *pel, IDispatch **ppDispChildren)
{
    HRESULT             hr = S_OK;
    CMarkup           * pMarkup;

    if ( !ppDispChildren )
    {
        hr = E_INVALIDARG;
        goto Cleanup;
    }

    Assert(pel);
    *ppDispChildren = NULL;

    hr = THR(pel->EnsureInMarkup());
    if (hr)
        goto Cleanup;

    pMarkup = pel->GetMarkupPtr();

    hr = THR(pMarkup->InitCollections());
    if (hr)
        goto Cleanup;

    hr = THR(pMarkup->CollectionCache()->CreateChildrenCollection(CMarkup::ELEMENT_COLLECTION, pel, ppDispChildren, TRUE));

Cleanup:
    RRETURN(hr);
}

STDMETHODIMP
CElement::get_all(IDispatch **ppDispChildren)
{
    HRESULT hr;
    hr = THR(GetAll(this, ppDispChildren));
    RRETURN(SetErrorInfoPGet(hr, DISPID_CElement_all));
}

HRESULT
CElement::getElementsByTagName(BSTR v, IHTMLElementCollection** ppDisp)
{
    HRESULT hr = E_INVALIDARG;
    IDispatch *pDispChildren = NULL;
    CElementCollection *pelColl = NULL;

    if (!ppDisp || !v)
        goto Cleanup;

    *ppDisp = NULL;

    hr = THR(GetAll(this, &pDispChildren));
    if (hr)
        goto Cleanup;

    Assert(pDispChildren);
    hr = THR(pDispChildren->QueryInterface(CLSID_CElementCollection, (void **)&pelColl));
    if (hr)
        goto Cleanup;

    Assert(pelColl);

    // Get a collection of the specified tags.
    hr = THR(pelColl->Tags(v, (IDispatch **)ppDisp));

Cleanup:
    ReleaseInterface(pDispChildren);
    RRETURN(SetErrorInfo(hr));
}

//+------------------------------------------------------------------------------
//
//  Memvber : IsOverflowFrame
//
//  Synopsis : Returns TRUE if the element passed in is a frame, and is in a frameset,
//      and is beyond the number of frames that are provided for in the frameset.
//      this is here for NS compat (and ie4.0X) compat.
//      e.g. <FRAMESET rows = "50%,50%> <Frame id=f1 /> <Frame id=f2 /> <Frame id-f3 /></FS>
//      only frame f1 & f2 are passed (false return) and f3 is blockec (returns true)
//+------------------------------------------------------------------------------

BOOL
CElement::IsOverflowFrame()
{
    BOOL fRes = FALSE;

    // do we have a frame element at all?
    if (Tag() != ETAG_FRAME &&
        Tag() != ETAG_IFRAME &&
        Tag() != ETAG_FRAMESET)
        goto Cleanup;

    // To fix bug 33055(et al.), don't remember this frame if it's overflowing
    if (GetFirstBranch())
    {
        if (GetFirstBranch()->Parent())
        {
            CTreeNode *pNodeFS = GetFirstBranch()->Parent()->SearchBranchToRootForTag(ETAG_FRAMESET);

            if (pNodeFS)
            {
                CFrameSetSite *pFS = DYNCAST(CFrameSetSite, pNodeFS->Element());
                if (pFS)
                {
                    fRes = pFS->IsOverflowFrame(this);
                }
            }
        }
    }

Cleanup:
    return fRes;
}

#ifdef VSTUDIO7
//+-------------------------------------------------------------------
//      Member : get_currentStyle
//
//      Synopsis : for use by the IDispatch Invoke to retrieve the
//      IHTMLStyle for this object's current style.  If an identity behavior
//      exists, delegate to that IHTMLStyle.  Otherwise, get the internal 
//      "base" current style interface.
//+-------------------------------------------------------------------

HRESULT
CElement::get_currentStyle ( IHTMLCurrentStyle ** ppICurStyle, CTreeNode * pNode )
{
    HRESULT hr = S_OK;
    *ppICurStyle = NULL;

    CPeerHolder *pPeer = GetIdentityPeerHolder();
    IIdentityBehavior *pIdentity = NULL;
    if (pPeer) 
    {
        HRESULT hr;
        hr = pPeer->QueryPeerInterface(IID_IIdentityBehavior, (void **)&pIdentity);
        if (SUCCEEDED(hr)) 
        {
            hr = THR_NOTRACE(pIdentity->GetCurrentStyle(ppICurStyle));
            if (SUCCEEDED(hr) && *ppICurStyle != NULL) 
               goto Cleanup;
        }
    }

    hr = get_baseCurrentStyle(ppICurStyle, pNode);

Cleanup:
    ReleaseInterface(pIdentity);
    RRETURN(SetErrorInfo( hr ));
}

//+-------------------------------------------------------------------
//      Member : get_runtimeStyle
//
//      Synopsis : for use by the IDispatch Invoke to retrieve the
//      IHTMLStyle for this object's runtime style.  If an identity behavior
//      exists, delegate to that rutime IHTMLStyle.  Otherwise, get the internal 
//      "base" runtime style interface.
//+-------------------------------------------------------------------

HRESULT
CElement::get_runtimeStyle ( IHTMLStyle ** ppISTYLE )
{
    HRESULT hr = S_OK;
    *ppISTYLE = NULL;

    CPeerHolder *pPeer = GetIdentityPeerHolder();
    IIdentityBehavior *pIdentity = NULL;
    if (pPeer) 
    {
        HRESULT hr;
        hr = pPeer->QueryPeerInterface(IID_IIdentityBehavior, (void **)&pIdentity);
        if (SUCCEEDED(hr)) 
        {
            hr = THR_NOTRACE(pIdentity->GetRuntimeStyle(ppISTYLE));
            if (SUCCEEDED(hr) && *ppISTYLE != NULL) 
               goto Cleanup;
        }
    }

    hr = get_baseRuntimeStyle(ppISTYLE);

Cleanup:
    ReleaseInterface(pIdentity);
    RRETURN(SetErrorInfo( hr ));
}

//+-------------------------------------------------------------------
//      Member : get_style
//
//      Synopsis : for use by the IDispatch Invoke to retrieve the
//      IHTMLStyle for this object's inline style.  If an identity behavior
//      exists, delegate to that IHTMLStyle.  Otherwise, get the internal 
//      "base" style interface.
//+-------------------------------------------------------------------

STDMETHODIMP
CElement::get_style(IHTMLStyle ** ppISTYLE)
{
    HRESULT hr = S_OK;
    *ppISTYLE = NULL;

    CPeerHolder *pPeer = GetIdentityPeerHolder();
    IIdentityBehavior *pIdentity = NULL;
    if (pPeer) 
    {
        HRESULT hr;
        hr = pPeer->QueryPeerInterface(IID_IIdentityBehavior, (void **)&pIdentity);
        if (SUCCEEDED(hr)) 
        {
            hr = THR_NOTRACE(pIdentity->GetStyle(ppISTYLE));
            if (SUCCEEDED(hr) && *ppISTYLE != NULL) 
               goto Cleanup;
        }
    }

    hr = get_baseStyle(ppISTYLE);

Cleanup:
    ReleaseInterface(pIdentity);
    RRETURN(SetErrorInfoPGet(hr, STDPROPID_XOBJ_STYLE));
}
#endif // VSTUDIO7

//+-------------------------------------------------------------------
//      Member : get_style
//
//      Synopsis : for use by IDispatch Invoke to retrieve the
//      IHTMLStyle for this object's inline style.  Get it from
//      CStyle. If none currently exists, make one.
//+-------------------------------------------------------------------

#ifdef VSTUDIO7
HRESULT
CElement::get_baseStyle(IHTMLStyle ** ppISTYLE)
#else
HRESULT
CElement::get_style(IHTMLStyle ** ppISTYLE)
#endif //VSTUDIO7

{
    HRESULT hr = S_OK;
    CStyle *pStyleInline = NULL;
    *ppISTYLE = NULL;

    hr = GetStyleObject(&pStyleInline);
    if (hr)
        goto Cleanup;

    hr = THR_NOTRACE(pStyleInline->QueryInterface(IID_IHTMLStyle, (LPVOID *)ppISTYLE));

Cleanup:
    RRETURN(SetErrorInfoPGet(hr, STDPROPID_XOBJ_STYLE));
}



//+----------------------------------------------------
//
//  member : get_currentStyle: IHTMLElement2
//
//  synopsis : returns the IHTMLCurrentStyle interface to
//             the currentStyle Object
//
//-----------------------------------------------------

#ifdef VSTUDIO7
HRESULT
CElement::get_baseCurrentStyle ( IHTMLCurrentStyle ** ppICurStyle, CTreeNode * pNode )
#else
HRESULT
CElement::get_currentStyle ( IHTMLCurrentStyle ** ppICurStyle, CTreeNode * pNode )
#endif //VSTUDIO7
{
    HRESULT hr = S_OK;
    CCurrentStyle * pCurStyleObj = NULL;

    if (!ppICurStyle)
    {
        hr = E_POINTER;
        goto Cleanup;
    }

    *ppICurStyle = NULL;

    if (!pNode || pNode->IsDead() )
    {
        pNode = GetFirstBranch();
        // Assert that either the node is not in the tree or that if it is, it is not dead
        Assert( !pNode || !pNode->IsDead() );
    }

#ifdef VSTUDIO7
    // if still no node, we are not in the tree, return NULL
    if (!pNode)
    {
        EnsureInMarkup();
        pNode = GetFirstBranch();
        Assert(pNode && !pNode->IsDead());
    }
#else
    // if still no node, we are not in the tree, return NULL
    if (!pNode)
        goto Cleanup;
#endif //VSTUDIO7

    Assert(pNode->Element() ==  this);

    // Reuse a current style object if we have one
    if( pNode->HasCurrentStyle() )
    {
        pCurStyleObj = pNode->GetCurrentStyle();
        pCurStyleObj->PrivateAddRef();
    }
    else
    {
        pCurStyleObj = new CCurrentStyle(pNode);
        if (!pCurStyleObj)
        {
            hr = E_OUTOFMEMORY;
            goto Cleanup;
        }

        // Add the CCurrentStyle to a lookaside on the node
        // If we run out of memory here -- no big deal, we will
        // just won't ever reuse this current style
        IGNORE_HR( pNode->SetCurrentStyle( pCurStyleObj ) );
    }

    hr = THR_NOTRACE(pCurStyleObj->PrivateQueryInterface(IID_IHTMLCurrentStyle,
        (VOID **)ppICurStyle));
    if ( hr )
    {
        pCurStyleObj->PrivateRelease();
        goto Cleanup;
    }

Cleanup:
    if( pCurStyleObj )
        pCurStyleObj->PrivateRelease();

    RRETURN(SetErrorInfo( hr ));
}

//+----------------------------------------------------
//
//  member : get_runtimeStyle: IHTMLElement
//
//  synopsis : returns the runtime Style Object
//
//-----------------------------------------------------

#ifdef VSTUDIO7
HRESULT
CElement::get_baseRuntimeStyle ( IHTMLStyle ** ppIStyle )
#else
HRESULT
CElement::get_runtimeStyle ( IHTMLStyle ** ppIStyle )
#endif // VSTUDIO7

{
    HRESULT hr = S_OK;
    CStyle * pStyleObj = NULL;

    if (!ppIStyle)
    {
        hr = E_POINTER;
        goto Cleanup;
    }

    *ppIStyle = NULL;

    GetPointerAt ( FindAAIndex ( DISPID_INTERNAL_CRUNTIMESTYLEPTRCACHE,
                             CAttrValue::AA_Internal ),
                   (void **)&pStyleObj );

    //Get existing styleObject or create a new one
    if (pStyleObj)
    {
        hr = THR_NOTRACE(pStyleObj->PrivateQueryInterface(IID_IHTMLStyle,
            (VOID **)ppIStyle));
    }
    else
    {
        pStyleObj = new CStyle(
            this, DISPID_INTERNAL_RUNTIMESTYLEAA, 0);
        if (!pStyleObj)
        {
            hr = E_OUTOFMEMORY;
            goto Cleanup;
        }

        hr = THR_NOTRACE(pStyleObj->PrivateQueryInterface(IID_IHTMLStyle,
            (VOID **)ppIStyle)); // My SubRef count +1
        if ( hr )
        {
            delete pStyleObj;
            goto Cleanup;
        }

        AddPointer ( DISPID_INTERNAL_CRUNTIMESTYLEPTRCACHE,
                     (void *)pStyleObj,
                     CAttrValue::AA_Internal );

    }

Cleanup:
    RRETURN(SetErrorInfo( hr ));
}

//+----------------------------------------------------------------------------
//
//  Member:     get_sourceIndex
//
//  Synopsis:   Returns the source index (order of appearance) of this element
//              If the element is no longer in the source tree, return -1
//              as source index and hr = S_OK.
//
//-----------------------------------------------------------------------------

STDMETHODIMP
CElement::get_sourceIndex ( long *pSourceIndex )
{
    HRESULT hr = S_OK;

    if (!pSourceIndex)
    {
        hr = E_POINTER;
        goto Cleanup;
    }

    *pSourceIndex = GetSourceIndex();

Cleanup:
    RRETURN( SetErrorInfo( hr ) );
}

//+------------------------------------------------------------------------
//
//  Class:      CAAScriptletIterator
//
//  Synopsis:   a helper class iterating all scriptlets in attr array which
//              need to be commited to script engines via AddScriptlet.
//              While iterating, the class also collect all the necessary
//              data from attr array.
//
//-------------------------------------------------------------------------

class CScriptletIterator
{
public:

    // methods

    void    Init(CBase * pObj, CPeerHolder * pPeerHolder);
    HRESULT Next();
    HRESULT NextStd();
    HRESULT NextPeer();
    BOOL    Done() { return fStdDone && fPeerDone; };

    //data

    CBase *                 pObject;

    LPCTSTR                 pchScriptletName;
    LPTSTR                  pchCode;

    LPTSTR                  pchData;
    ULONG                   uOffset;
    ULONG                   uLine;

    BOOL                    fStdDone;
    BOOL                    fPeerDone;

    CAttrArray *            pAA;
    BASICPROPPARAMS *       pBPP;
    const PROPERTYDESC *    pPropDesc;
    CAttrValue *            pAttrValue;
    CAttrValue *            pAV;
    AAINDEX                 aaIdx;

    CPeerHolder *           pPeerHolder;
    CPeerHolder::CEventsBag * pPeerEvents;
    int                     iPeerEvents;
};

//+------------------------------------------------------------------------
//
//  Member:     CScriptletIterator::Init
//
//  Synopsis:   attaches iterator to CBase object and resets it.
//
//-------------------------------------------------------------------------

void
CScriptletIterator::Init(CBase * pObj, CPeerHolder * pPH)
{
    pObject = pObj;
    pAA = * pObject->GetAttrArray();

    aaIdx = (AAINDEX) -1;

    pPeerHolder = pPH;
    pPeerEvents = NULL;
    iPeerEvents = 0;

    fStdDone  = FALSE;
    fPeerDone = FALSE;
};

//+------------------------------------------------------------------------
//
//  Member:     CScriptletIterator::Next
//
//  Synopsis:   finds the next scriptlet to commit via AddScriptlet and
//              collects all the necessary information for that.
//
//-------------------------------------------------------------------------

HRESULT
CScriptletIterator::Next()
{
    HRESULT     hr = S_OK;

    Assert (!fStdDone || !fPeerDone);

    if (!fStdDone)
    {
        hr = THR(NextStd());
        if (hr)
            goto Cleanup;
    }

    // when standard events are iterated completely, fStdDone is set to true in NextStd.

    if (fStdDone)
    {
        hr = THR(NextPeer());
        if (hr)
            goto Cleanup;
    }

Cleanup:
    RRETURN (hr);
}

//+------------------------------------------------------------------------
//
//  Member:     CScriptletIterator::NextStd
//
//  Synposis:   finds the next standard scriptlet in AA_Attribute section
//
//-------------------------------------------------------------------------

HRESULT
CScriptletIterator::NextStd()
{
    HRESULT     hr = S_OK;

    while ((pAttrValue = pAA->Find(DISPID_UNKNOWN, CAttrValue::AA_Attribute, &aaIdx)) != NULL)
    {
        //
        // find out if it is a scriptlet
        //

        pPropDesc = pAttrValue->GetPropDesc();
        if (!pPropDesc)
            continue;

        pBPP = (BASICPROPPARAMS *)(pPropDesc + 1);

        if (!(pBPP->dwPPFlags & PROPPARAM_SCRIPTLET))
            continue;

        //
        // get code
        //

        hr = THR (pObject->GetStringAt(aaIdx, (const TCHAR**)&pchCode));
        if (hr)
            goto Cleanup;

        if (!pchCode)
            continue; // this could happen, e.g., in this case: <img language = VBScript onclick>

        //
        // try to get line/offset information
        //

        hr = THR(GetLineAndOffsetInfo(pAA, pBPP->dispid, &uLine, &uOffset));
        if (S_FALSE == hr)      // if no line/offset information stored, which happens if we connected the event
        {                       // using function pointers mechanism
            hr = S_OK;
            continue;
        }
        if (hr)
            goto Cleanup;

        //
        // finalize
        //

        pchScriptletName = pPropDesc->pstrName;

        goto Cleanup; // found the next scriptlet to commit; get out now
    }

    fStdDone = TRUE;   // done iterating standard scriptlets

Cleanup:
    RRETURN (hr);
}

//+------------------------------------------------------------------------
//
//  Member:     CScriptletIterator::NextPeer
//
//  Synposis:   finds the next custom peer event in pPeerEvents bag
//
//-------------------------------------------------------------------------

HRESULT
CScriptletIterator::NextPeer()
{
    HRESULT     hr;
    DISPID      dispidEvent;
    DISPID      dispidExpando;

    //
    // find the next custom peer event to hook up
    //

    while (pPeerHolder)
    {
        pPeerEvents = pPeerHolder->_pEventsBag;

        while (pPeerEvents && iPeerEvents < pPeerHolder->CustomEventsCount())
        {
            pchScriptletName = pPeerHolder->CustomEventName  (iPeerEvents);
            dispidEvent      = pPeerHolder->CustomEventDispid(iPeerEvents);
            iPeerEvents++;

            hr = pObject->GetExpandoDispID((LPTSTR)pchScriptletName, &dispidExpando, 0);
            if (S_OK == hr)
            {
                //
                // check if it is connected already - as indicated by presence of
                // corresponding IDispatch attr in AA_Internal section of attr array
                //

                aaIdx = AA_IDX_UNKNOWN;
                pAV = pAA->Find(
                    dispidEvent,
                    CAttrValue::AA_Internal,
                    &aaIdx);
                if (pAV && VT_DISPATCH == pAV->GetAVType())
                {
                    continue;
                }

                //
                // try to get line/offset information (stored with dispid of expando)
                //

                hr = THR(GetLineAndOffsetInfo(pAA, dispidExpando, &uLine, &uOffset));
                // if no line/offset information stored, which happens if we connected the event
                // using function pointers mechanism, then the function returns S_FALSE and uLine = uOffset = 0
                if (FAILED(hr))
                    goto Cleanup;

                //
                // get code
                //

                aaIdx = AA_IDX_UNKNOWN;
                pAV = pAA->Find(dispidExpando, CAttrValue::AA_Expando, &aaIdx);
                if (!pAV || VT_LPWSTR != pAV->GetAVType())
                {
                    continue;
                }

                hr = pObject->GetStringAt(aaIdx, (LPCTSTR*)&pchCode);

                goto Cleanup; // found the next event
            }
        } // eo while (pPeerEvents && iPeerEvents < pPeerHolder->CustomEventsCount())

        iPeerEvents = 0;
        pPeerHolder = pPeerHolder->_pPeerHolderNext;
    } // eo for (;;)

    hr = S_OK;

    fPeerDone = true;

Cleanup:
    RRETURN (hr);
}

//+------------------------------------------------------------------------
//
//  Member:     CElement::AddAllScriptlets
//
//  Arguments:  pchExposedName  name exposed in type info; could be id, name,
//                              or calculated unique id. If incoming value is
//                              NULL, and there is a scriptlet here to hookup,
//                              it will be set in this function to unique id.
//
//-------------------------------------------------------------------------

HRESULT
CElement::AddAllScriptlets(TCHAR * pchExposedName)
{
    HRESULT                 hr = S_OK;
    TCHAR *                 pchScope;
    TCHAR *                 pchLanguage;
    BSTR                    bstrFuncName;
    BOOL                    fBodyOrFrameset=FALSE;
    CStr                    cstrUniqueName;
    CBase **                ppPropHost;
    CBase *                 pPropHosts[3];
    BOOL                    fSetUniqueName = FALSE;
    CAttrArray *            pAA = *GetAttrArray();
    CDoc *                  pDoc = Doc();

    CScriptletIterator      itr;

    switch (Tag())
    {
    case ETAG_BODY:
    case ETAG_FRAMESET:
        fBodyOrFrameset = TRUE;
        break;
    }

    if (!pDoc->_pScriptCollection)
        goto Cleanup;

    if (!fBodyOrFrameset &&     // (1) for body or frameset, always attempt the hookup -
                                // there may be attrs stored attr array of window
        !pAA)                   // (2) for other elements, attempt hookup only if attr array present
        goto Cleanup;

    SetEventsShouldFire();

    //
    // calculate scope
    //

    switch (Tag())
    {
    case ETAG_BODY:
    case ETAG_FRAMESET:
    case ETAG_A:
        pchScope = (TCHAR *)DEFAULT_OM_SCOPE;
        break;

    default:
        pchScope = (TCHAR *) NameOrIDOfParentForm(); // this can return NULL

        if (!pchScope)
            pchScope = (TCHAR *)DEFAULT_OM_SCOPE;

        break;
    }

    Assert (pchScope); // VBScript is paranoid about this

    //
    // get language
    //

    if (!pAA ||
        !pAA->FindString (DISPID_A_LANGUAGE, (const TCHAR **) &pchLanguage, CAttrValue::AA_Attribute))
    {
        pchLanguage = NULL;
    }

    //
    // setup prop hosts
    //
    // prop hosts are:
    //      (1) normally, only 'this' element,
    //      (2) for body or frameset, 'this' element and window

    if (fBodyOrFrameset)
    {
        Assert (3 <= ARRAY_SIZE(pPropHosts));

        pPropHosts[0] = this;
        pPropHosts[1] = GetOmWindow();
        pPropHosts[2] = NULL;
    }
    else
    {
        Assert (2 <= ARRAY_SIZE(pPropHosts));

        pPropHosts[0] = this;
        pPropHosts[1] = NULL;
    }

    //
    // for all prop hosts ...
    //

    for (
        ppPropHost = pPropHosts;
        *ppPropHost;
        ppPropHost++, pchExposedName = (TCHAR *)DEFAULT_OM_SCOPE)
    {
        if (!*((*ppPropHost)->GetAttrArray()))
            continue;

        //
        //  for each scriptlet in this prop host ...
        //

        itr.Init(
            *ppPropHost,
            (this == (*ppPropHost)) ? GetPeerHolder() : NULL);

        for (;;)
        {
            hr = THR(itr.Next());
            if (hr)
                goto Cleanup;

            if (itr.Done())
                break;

            // set pchExposedName if not yet
            if (!pchExposedName)
            {
                // pchExposedName could be empty only when we get here first time when
                // this == pPropHost; if pPropHost is OM window, then pchExposedName is set to "window".
                Assert (this == (*ppPropHost));

                // NOTE: because we are looping through attr array, we should not attempt to modify the
                // array by setting UniqueName into it within this loop
                hr = THR(GetUniqueIdentifier(&cstrUniqueName,FALSE));
                if (hr)
                    goto Cleanup;

                fSetUniqueName = TRUE;

                pchExposedName = (TCHAR*) cstrUniqueName;
            }

            //
            // add scriptlet
            //

            bstrFuncName = NULL;

            // we ignore hr so that in case of syntax error it still adds other scriptlets
            IGNORE_HR(pDoc->_pScriptCollection->AddScriptlet(
                pchLanguage,                    // pchLanguage
                GetMarkup(),                    // pMarkup
                NULL,                           // pchType
                itr.pchCode,                    // pchCode
                pchScope,                       // pchItemName
                pchExposedName,                 // pchSubItemName
                (LPTSTR) itr.pchScriptletName,  // pchEventName
                _T("\""),                       // pchDelimiter
                itr.uOffset,                    // ulOffset
                itr.uLine,                      // ulStartingLine
                GetMarkup(),                    // pSourceObject
                SCRIPTTEXT_ISVISIBLE | SCRIPTPROC_HOSTMANAGESSOURCE, // dwFlags
                &bstrFuncName));                // pbstrName

            FormsFreeString(bstrFuncName);

        } // eo for (;;)

        if (fSetUniqueName)
        {
            fSetUniqueName = FALSE;

            hr = THR(SetUniqueNameHelper(pchExposedName));
            if (hr)
                goto Cleanup;
        }
    } // eo for (ppPropHost)


Cleanup:

    RRETURN (hr);
}

//+----------------------------------------------------------------------------
//
//  Member:     Inject
//
//  Synopsis:   Stuff text or HTML is various places relative to an element
//
//-----------------------------------------------------------------------------

static BOOL
IsInTableThingy ( CTreeNode * pNode )
{
    //
    // See if we are between a table and its cells
    //
    
    for ( ; pNode ; pNode = pNode->Parent() )
    {
        switch ( pNode->Tag() )
        {
        case ETAG_TABLE :
            return TRUE;
            
        case ETAG_TH :
        case ETAG_TC :
        case ETAG_CAPTION :
        case ETAG_TD :
            return FALSE;
        }
    }

    return FALSE;
}

HRESULT
CElement::Inject (
    Where where, BOOL fIsHtml, LPTSTR pStr, long cch )
{
    HRESULT        hr = S_OK;
    CDoc *         pDoc = Doc();
    CMarkup *      pMarkup;
    BOOL           fEnsuredMarkup = FALSE;
    CMarkupPointer pointerStart ( pDoc );
    CMarkupPointer pointerFinish ( pDoc );
    CParentUndo    Undo(pDoc);
    ELEMENT_TAG    etag = Tag();
    IHTMLEditingServices * pedserv = NULL;

    PerfDbgLog1( tagInject, this, "+Inject %ls", TagName() );

    //
    // See if one is attempting to place stuff IN a noscope element
    //

    if ((where == Inside || where == AfterBegin || where == BeforeEnd) && IsNoScope())
    {
        //
        // Some elements can do inside, but in the slave tree.
        // Also, disallow HTML for those things with a slave markup.  If you
        // can't get to them with the DOM or makrup services, you should not
        // be able to with innerHTML.
        //

        if (!SlaveMarkup() || fIsHtml)
        {
            hr = CTL_E_INVALIDPASTETARGET;
            goto Cleanup;
        }

        if (IsContainer() && !TestClassFlag(CElement::ELEMENTDESC_OMREADONLY))
        {
            CElement * pElementTextSlave = SlaveMarkup()->GetElementClient();

            if (pElementTextSlave && pElementTextSlave->Tag() == ETAG_TXTSLAVE)
            {
                hr = THR( pElementTextSlave->Inject( where, fIsHtml, pStr, cch ) );

                if (hr)
                    goto Cleanup;

                goto Cleanup;
            }
        }
        
        hr = CTL_E_INVALIDPASTETARGET;
        goto Cleanup;
    }

    //
    // Disallow inner/outer on the head and html elements
    //

    if ((etag == ETAG_HTML || etag == ETAG_HEAD || etag == ETAG_TITLE_ELEMENT) &&
        (where == Inside || where == Outside))
    {
        hr = CTL_E_INVALIDPASTETARGET;
        goto Cleanup;
    }

    //
    // Prevent the elimination of the client element
    //
    
    pMarkup = GetMarkup();
    
    if (pMarkup && (where == Inside || where == Outside))
    {
        CElement * pElementClient = pMarkup->GetElementClient();

        //
        // It's ok to do an inner on the client
        //

        if (pElementClient && (where != Inside || this != pElementClient))
        {
            //
            // If we can see the client above this, then the client
            // will get blown away.  Prevent this.
            //
            
            if (pMarkup->SearchBranchForScopeInStory( pElementClient->GetFirstBranch(), this ))
            {
                hr = CTL_E_INVALIDPASTETARGET;
                goto Cleanup;
            }
        }
    }
    
    //
    // In IE4, an element had to be in a markup to do this operation.  Now,
    // we are looser.  In order to do validation, the element must be in a
    // markup.  Here we also remember is we placed the element in a markup
    // so that if the injection fails, we can restore it to its "original"
    // state.
    //

    if (!pMarkup)
    {
        hr = THR( EnsureInMarkup() );

        if (hr)
            goto Cleanup;
        
        fEnsuredMarkup = TRUE;
        
        pMarkup = GetMarkup();
        
        Assert( pMarkup );
    }

    //
    // Locate the pointer such that they surround the stuff which should
    // go away, and are located where the new stuff should be placed.
    //

    {
        ELEMENT_ADJACENCY adjLeft = ELEM_ADJ_BeforeEnd;
        ELEMENT_ADJACENCY adjRight = ELEM_ADJ_BeforeEnd;

        switch ( where )
        {
            case Inside :
                adjLeft = ELEM_ADJ_AfterBegin;
                adjRight = ELEM_ADJ_BeforeEnd;
                break;
                
            case Outside :
                adjLeft = ELEM_ADJ_BeforeBegin;
                adjRight = ELEM_ADJ_AfterEnd;
                break;
                
            case BeforeBegin :
                adjLeft = ELEM_ADJ_BeforeBegin;
                adjRight = ELEM_ADJ_BeforeBegin;
                break;
                
            case AfterBegin :
                adjLeft = ELEM_ADJ_AfterBegin;
                adjRight = ELEM_ADJ_AfterBegin;
                break;
                
            case BeforeEnd :
                adjLeft = ELEM_ADJ_BeforeEnd;
                adjRight = ELEM_ADJ_BeforeEnd;
                break;
                
            case AfterEnd :
                adjLeft = ELEM_ADJ_AfterEnd;
                adjRight = ELEM_ADJ_AfterEnd;
                break;
        }

        hr = THR( pointerStart.MoveAdjacentToElement( this, adjLeft ) );

        if (hr)
            goto Cleanup;

        hr = THR( pointerFinish.MoveAdjacentToElement( this, adjRight ) );

        if (hr)
            goto Cleanup;
    }

    Assert( pointerStart.IsPositioned() );
    Assert( pointerFinish.IsPositioned() );

    {
        CTreeNode * pNodeStart  = pointerStart.Branch();
        CTreeNode * pNodeFinish = pointerFinish.Branch();

        //
        // For the 5.0 version, because we don't have contextual parsing,
        // make sure tables can't we screwed with.
        //

        if (fIsHtml)
        {
            //
            // See if the beginning of the inject is in a table thingy
            //
            
            if (pNodeStart && IsInTableThingy( pNodeStart ))
            {
                hr = CTL_E_INVALIDPASTETARGET;
                goto Cleanup;
            }

            //
            // See if the end of the inject is different from the start.
            // If so, then also check it for being in a table thingy.
            //
            
            if (pNodeFinish && pNodeStart != pNodeFinish &&
                IsInTableThingy( pNodeStart ))
            {
                hr = CTL_E_INVALIDPASTETARGET;
                goto Cleanup;
            }
        }

        //
        // Make sure we record undo information if we should.  I believe that
        // here is where we make the decision to not remembers automation
        // like manipulation, but do remember user editing scenarios.
        //
        // Here, we check the elements above the start and finish to make sure
        // they are editable (in the user sense).
        //

        if (pNodeStart && pNodeFinish &&
            pNodeStart->Element()->IsEditable() &&
            pNodeFinish->Element()->IsEditable())
        {
            Undo.Start( IDS_UNDOGENERICTEXT );
        }
    }

    //
    // Perform the HTML/text injection
    //

    if (fIsHtml)
    {
        HRESULT HandleHTMLInjection (
            CMarkupPointer *, CMarkupPointer *,
            const TCHAR *, long, CElement * );

        hr = THR(
            HandleHTMLInjection(
                & pointerStart, & pointerFinish, pStr, cch,
                where == Inside ? this : NULL ) );

        if (hr == S_FALSE)
        {
            hr = CTL_E_INVALIDPASTESOURCE;
            goto Cleanup;
        }

        if (hr)
            goto Cleanup;
    }
    else
    {
        IHTMLEditor * phtmed;

        HRESULT RemoveWithBreakOnEmpty (
            CMarkupPointer * pPointerStart, CMarkupPointer * pPointerFinish );

        hr = THR( RemoveWithBreakOnEmpty( & pointerStart, & pointerFinish ) );
        
        if (hr)
            goto Cleanup;

        if (where == Inside)
        {
            HRESULT UnoverlapPartials ( CElement * );

            hr = THR( UnoverlapPartials( this ) );

            if (hr)
                goto Cleanup;
        }

        //
        // Get the editing services interface with which I can
        // insert sanitized text
        //

        phtmed = Doc()->GetHTMLEditor();

        if (!phtmed)
        {
            hr = E_FAIL;
            goto Cleanup;
        }

        hr = THR(
            phtmed->QueryInterface(
                IID_IHTMLEditingServices, (void **) & pedserv ) );

        if (hr)
            goto Cleanup;

        hr = THR(
             pedserv->InsertSanitizedText(
                & pointerStart, pStr, TRUE ) );

        if (hr)
            goto Cleanup;

        //
        // BUGBUG - Launder spaces here on the edges
        //
    }

Cleanup:

    //
    // If we are failing, and we had to put this element into a markup
    // at the beginning, take it out now to restore to the origianl state.
    //

    if (hr != S_OK && fEnsuredMarkup && GetMarkup())
        IGNORE_HR( THR( Doc()->RemoveElement( this ) ) );
    
    //
    //
    //

    ReleaseInterface( pedserv );

    Undo.Finish( hr );

    PerfDbgLog( tagInject, this, "-Inject" );

    RRETURN( hr );
}

//+----------------------------------------------------------------------------
//
//  Member:     InsertAdjacent
//
//  Synopsis:   Inserts the given element into the tree, positioned relative
//              to 'this' element as specified.
//
//-----------------------------------------------------------------------------

HRESULT
CElement::InsertAdjacent ( Where where, CElement * pElementInsert )
{
    HRESULT        hr = S_OK;
    CMarkupPointer pointer( Doc() );

    Assert( IsInMarkup() );
    Assert( pElementInsert && !pElementInsert->IsInMarkup() );
    Assert( !pElementInsert->IsRoot() );
    Assert( ! IsRoot() || where == AfterBegin || where == BeforeEnd );

    //
    // Figure out where to put the element
    //

    switch ( where )
    {
    case BeforeBegin :
        hr = THR( pointer.MoveAdjacentToElement( this, ELEM_ADJ_BeforeBegin ) );
        break;

    case AfterEnd :
        hr = THR( pointer.MoveAdjacentToElement( this, ELEM_ADJ_AfterEnd ) );
        break;

    case AfterBegin :
        hr = THR( pointer.MoveAdjacentToElement( this, ELEM_ADJ_AfterBegin ) );
        break;

    case BeforeEnd :
        hr = THR( pointer.MoveAdjacentToElement( this, ELEM_ADJ_BeforeEnd ) );
        break;
    }

    if (hr)
        goto Cleanup;

    hr = THR( Doc()->InsertElement( pElementInsert, & pointer, NULL ) );

Cleanup:

    RRETURN( hr );
}

//+----------------------------------------------------------------------------
//
//  Member:     RemoveOuter
//
//  Synopsis:   Removes 'this' element and everything which 'this' element
//              influences.
//
//-----------------------------------------------------------------------------

HRESULT
CElement::RemoveOuter ( )
{
    HRESULT        hr;
    CMarkupPointer p1( Doc() ), p2( Doc() );

    hr = THR( p1.MoveAdjacentToElement( this, ELEM_ADJ_BeforeBegin ) );

    if (hr)
        goto Cleanup;

    hr = THR( p2.MoveAdjacentToElement( this, ELEM_ADJ_AfterEnd ) );

    if (hr)
        goto Cleanup;

    hr = THR( Doc()->Remove( & p1, & p2 ) );

    if (hr)
        goto Cleanup;

Cleanup:
    
    RRETURN( hr );
}

//+----------------------------------------------------------------------------
//
//  Member:     GetText
//
//  Synopsis:   Gets the specified text for the element.
//
//  Note: invokes saver.  Use WBF_NO_TAG_FOR_CONTEXT to determine whether
//  or not the element itself is saved.
//
//-----------------------------------------------------------------------------

HRESULT
CElement::GetText(BSTR * pbstr, DWORD dwStmFlags)
{
    HRESULT     hr = S_OK;
    IStream * pstm = NULL;

    if(!pbstr)
    {
        hr = E_POINTER;
        goto Cleanup;
    }

    *pbstr = NULL;

    hr = CreateStreamOnHGlobal(NULL, TRUE, &pstm);
    if (hr)
        goto Cleanup;

    {
        CStreamWriteBuff swb(pstm, CP_UCS_2);

        swb.SetFlags(dwStmFlags);
        swb.SetElementContext(this);

        // Save the begin tag of the context element
        hr = THR( Save(&swb, FALSE) );
        if (hr)
            goto Cleanup;

        if (IsInMarkup())
        {
            CTreeSaver ts(this, &swb);
            hr = ts.Save();
            if (hr)
                goto Cleanup;
        }

        // Save the end tag of the context element
        Save(&swb, TRUE);
        if (hr)
            goto Cleanup;

        hr = swb.Terminate();
        if (hr)
            goto Cleanup;
    }

    hr = GetBStrFromStream(pstm, pbstr, TRUE);

Cleanup:
    ReleaseInterface(pstm);
    RRETURN(hr);
}

//+----------------------------------------------------------------------------
//
//  Member:     put_innerHTML
//
//  Synopsis:
//
//-----------------------------------------------------------------------------

STDMETHODIMP
CElement::put_innerHTML ( BSTR bstrHTML )
{
    RECALC_PUT_HELPER(DISPID_CElement_innerHTML)

    HRESULT hr = S_OK;

    hr = THR( Inject( Inside, TRUE, bstrHTML, FormsStringLen( bstrHTML ) ) );

    if (hr)
        goto Cleanup;

    hr = THR(
        OnPropertyChange(
            s_propdescCElementinnerHTML.b.dispid,
            s_propdescCElementinnerHTML.b.dwFlags ) );

    if (hr)
        goto Cleanup;

Cleanup:

    RRETURN( SetErrorInfoPSet( hr, DISPID_CElement_innerHTML ) );
}

//+----------------------------------------------------------------------------
//
//  Member:     get_innerHTML
//
//  Synopsis:
//
//-----------------------------------------------------------------------------

STDMETHODIMP
CElement::get_innerHTML ( BSTR * bstrHTML )
{
    RECALC_GET_HELPER(DISPID_CElement_innerHTML)

    HRESULT hr = THR(GetText(bstrHTML, WBF_NO_WRAP|WBF_NO_TAG_FOR_CONTEXT));

    RRETURN( SetErrorInfoPGet( hr, DISPID_CElement_innerHTML ) );
}

//+----------------------------------------------------------------------------
//
//  Member:     put_innerText
//
//  Synopsis:
//
//-----------------------------------------------------------------------------

STDMETHODIMP
CElement::put_innerText ( BSTR bstrText )
{
    HRESULT hr = S_OK;

    hr = THR( Inject( Inside, FALSE, bstrText, FormsStringLen( bstrText ) ) );

    if (hr)
        goto Cleanup;

    hr = THR(OnPropertyChange ( s_propdescCElementinnerText.b.dispid,
        s_propdescCElementinnerText.b.dwFlags ));

    if (hr)
        goto Cleanup;

Cleanup:

    RRETURN( SetErrorInfoPSet( hr, DISPID_CElement_innerText ) );
}

//+----------------------------------------------------------------------------
//
//  Member:     get_innerText
//
//  Synopsis:
//
//-----------------------------------------------------------------------------

STDMETHODIMP
CElement::get_innerText ( BSTR * pbstrText )
{
    HRESULT hr = THR(GetText(pbstrText,
        WBF_SAVE_PLAINTEXT|WBF_NO_WRAP|WBF_NO_TAG_FOR_CONTEXT));

    RRETURN( SetErrorInfoPGet( hr, DISPID_CElement_innerText ) );
}

//+----------------------------------------------------------------------------
//
//  Member:     put_outerHTML
//
//  Synopsis:
//
//-----------------------------------------------------------------------------

STDMETHODIMP
CElement::put_outerHTML ( BSTR bstrHTML )
{
    HRESULT hr = S_OK;

    hr = THR( Inject( Outside, TRUE, bstrHTML, FormsStringLen( bstrHTML ) ) );

    if (hr)
        goto Cleanup;

    hr = THR(
        OnPropertyChange(
            s_propdescCElementouterHTML.b.dispid,
            s_propdescCElementouterHTML.b.dwFlags ) );

    if (hr)
        goto Cleanup;

Cleanup:

    RRETURN( SetErrorInfoPSet( hr, DISPID_CElement_outerHTML ) );
}

//+----------------------------------------------------------------------------
//
//  Member:     get_outerHTML
//
//  Synopsis:
//
//-----------------------------------------------------------------------------

STDMETHODIMP
CElement::get_outerHTML ( BSTR * pbstrHTML )
{
    HRESULT hr = THR(GetText(pbstrHTML, WBF_NO_WRAP));

    RRETURN( SetErrorInfoPGet( hr, DISPID_CElement_outerHTML ) );
}

//+----------------------------------------------------------------------------
//
//  Member:     put_outerText
//
//  Synopsis:
//
//-----------------------------------------------------------------------------

STDMETHODIMP
CElement::put_outerText ( BSTR bstrText )
{
    HRESULT hr = S_OK;

    hr = THR( Inject( Outside, FALSE, bstrText, FormsStringLen( bstrText ) ) );

    if (hr)
        goto Cleanup;

    hr = THR(OnPropertyChange ( s_propdescCElementouterText.b.dispid,
        s_propdescCElementouterText.b.dwFlags ));

    if (hr)
        goto Cleanup;

Cleanup:

    RRETURN( SetErrorInfoPSet( hr, DISPID_CElement_outerText ) );
}

//+----------------------------------------------------------------------------
//
//  Member:     get_outerText
//
//  Synopsis:
//
//-----------------------------------------------------------------------------

STDMETHODIMP
CElement::get_outerText ( BSTR * pbstrText )
{
    HRESULT hr = THR(GetText(pbstrText,
        WBF_SAVE_PLAINTEXT|WBF_NO_WRAP));

    RRETURN( SetErrorInfoPGet( hr, DISPID_CElement_outerText ) );
}

//+----------------------------------------------------------------------------
//
//  Member:     insertAdjacentHTML
//
//  Synopsis:
//
//-----------------------------------------------------------------------------

static inline CElement::Where ConvertAdjacent ( htmlAdjacency where )
{
    switch ( where )
    {
    case htmlAdjacencyBeforeBegin : return CElement::BeforeBegin;
    case htmlAdjacencyAfterBegin  : return CElement::AfterBegin;
    case htmlAdjacencyBeforeEnd   : return CElement::BeforeEnd;
    case htmlAdjacencyAfterEnd    : return CElement::AfterEnd;
    default                       : Assert( 0 );
    }

    return CElement::BeforeBegin;
}

STDMETHODIMP
CElement::insertAdjacentHTML ( BSTR bstrWhere, BSTR bstrHTML )
{
    HRESULT hr = S_OK;
    htmlAdjacency where;

    hr = THR( ENUMFROMSTRING( htmlAdjacency, bstrWhere, (long *) & where ) );

    if (hr)
        goto Cleanup;

    hr = THR(
        Inject(
            ConvertAdjacent( where ), TRUE, bstrHTML, FormsStringLen( bstrHTML ) ) );

    if (hr)
        goto Cleanup;

Cleanup:

    RRETURN( SetErrorInfo( hr ) );
}

//+----------------------------------------------------------------------------
//
//  Member:     insertAdjacentText
//
//  Synopsis:
//
//-----------------------------------------------------------------------------

STDMETHODIMP
CElement::insertAdjacentText ( BSTR bstrWhere, BSTR bstrText )
{
    HRESULT hr = S_OK;
    htmlAdjacency where;

    hr = THR( ENUMFROMSTRING( htmlAdjacency, bstrWhere, (long *) & where ) );

    if (hr)
        goto Cleanup;

    hr = THR(
        Inject(
            ConvertAdjacent( where ), FALSE, bstrText, FormsStringLen( bstrText ) ) );

    if (hr)
        goto Cleanup;

Cleanup:

    RRETURN( SetErrorInfo( hr ) );
}

//+----------------------------------------------------------------------------
//
//  Member:     get_parentTextEdit
//
//  Synopsis:
//
//-----------------------------------------------------------------------------

STDMETHODIMP
CElement::get_parentTextEdit ( IHTMLElement * * ppDispParent )
{
    HRESULT hr = S_OK;
    CTreeNode * pNodeContext;

    if (!ppDispParent)
    {
        hr = E_INVALIDARG;
        goto Cleanup;
    }

    *ppDispParent = NULL;

    pNodeContext = GetFirstBranch();

    if (!pNodeContext)
        goto Cleanup;

    while ( (pNodeContext = pNodeContext->Parent()) != NULL )
    {
        VARIANT_BOOL vb;

        hr = THR( pNodeContext->Element()->get_isTextEdit ( & vb ) );

        if (hr)
            goto Cleanup;

        if (vb)
            break;
    }

    if (!pNodeContext)
        goto Cleanup;

    hr = THR( pNodeContext->Element()->QueryInterface(
        IID_IHTMLElement, (void * *) ppDispParent ) );

Cleanup:

    RRETURN( SetErrorInfoPGet( hr, DISPID_CElement_parentTextEdit ) );
}

//+----------------------------------------------------------------------------
//
//  Member:     get_isTextEdit
//
//  Synopsis:
//
//-----------------------------------------------------------------------------

STDMETHODIMP
CElement::get_isTextEdit ( VARIANT_BOOL * pvb )
{
    HRESULT hr = S_OK;

    if (!pvb)
    {
        hr = E_POINTER;
        goto Cleanup;
    }

    switch ( Tag() )
    {
    case ETAG_BODY :
    case ETAG_TEXTAREA :
#ifdef  NEVER
    case ETAG_HTMLAREA :
#endif
    case ETAG_BUTTON :
        *pvb = VB_TRUE;
        break;

    case ETAG_INPUT :
        switch (DYNCAST(CInput, this)->GetType())
        {
            case htmlInputButton:
            case htmlInputReset:
            case htmlInputSubmit:
            case htmlInputText:
            case htmlInputPassword:
            case htmlInputHidden:
            case htmlInputFile:
                *pvb = VB_TRUE;
                break;
            default :
                *pvb = VB_FALSE;
                break;
        }
        break;

    default :
        *pvb = VB_FALSE;
        break;
    }

Cleanup:

    RRETURN( SetErrorInfoPGet( hr, DISPID_CElement_isTextEdit ) );
}

// Used to help determine if a Visual Hebrew codpage is specified
static BOOL LocateCodepageMeta ( CMetaElement * pMeta )
{
    return pMeta->IsCodePageMeta();
}


CAttrArray *CElement::GetInLineStyleAttrArray ( void )
{
    CAttrArray *pAA = NULL;
        
    // Apply the in-line style attributes
    AAINDEX aaix = FindAAIndex ( DISPID_INTERNAL_INLINESTYLEAA,
            CAttrValue::AA_AttrArray );
    if ( aaix != AA_IDX_UNKNOWN )
    {
        CAttrValue *pAttrValue = (CAttrValue *)**GetAttrArray();
        pAA = pAttrValue[aaix].GetAA();
    }
    return pAA;
}

#ifdef VSTUDIO7
//---------------------------------------------------------------
//
//  Member:     CElement::FlushPeerProperties
//
//  Synopsis:   If there is a peer identity behavior, tell it to update
//              the inline style attributes of this element at this time.
//              This is usually done in preparation for a save.
//
//  Arguments:  none
//
//----------------------------------------------------------------

void CElement::FlushPeerProperties ()
{
    IIdentityBehavior *pIdentity = NULL;
    IDispatchEx *pDispatch = NULL;
    HRESULT hr;
    CStyle *pStyle = NULL;
    CPeerHolder *pPeer = NULL;
    
    pPeer = GetIdentityPeerHolder();
    if (!pPeer)
        goto Cleanup;

    hr = pPeer->QueryPeerInterface(IID_IIdentityBehavior, (void **)&pIdentity);
    if (FAILED(hr)) 
        goto Cleanup;

    hr = GetStyleObject(&pStyle);
    if (FAILED(hr)) 
        goto Cleanup;

    pStyle->MaskPropertyChanges(TRUE);
    // HACKHACK - peterost - What SHOULD be done is get a safearray of attributes and
    //            values from the identity behavior and update the attribute array from that.
    //            Currently FlushPersistentProperties causes a LOT of invoke traffic, which can
    //            greatly slow down save operations.  This should be updated once the PDL
    //            compiler supports an [out] parameter of SAFEARRAY using a new interface 
    //            method on IIdentityBehavior that is something like:
    //            HRESULT GetPersistentProperties(SAFEARRAY** properties);
    pIdentity->FlushPersistentProperties();
    pStyle->MaskPropertyChanges(FALSE);
		
Cleanup:
    ReleaseInterface(pIdentity);
    ReleaseInterface(pDispatch);
}
#endif



CAttrArray **CElement::CreateStyleAttrArray ( DISPID dispID )
{
    AAINDEX aaix = AA_IDX_UNKNOWN;
    if ( ( aaix = FindAAIndex ( dispID,
            CAttrValue::AA_AttrArray ) ) == AA_IDX_UNKNOWN )
    {
            CAttrArray *pAA = new CAttrArray;
            AddAttrArray ( dispID, pAA,
                CAttrValue::AA_AttrArray );
            aaix = FindAAIndex ( dispID,
                CAttrValue::AA_AttrArray );
    }
    if ( aaix == AA_IDX_UNKNOWN )
    {
        return NULL;
    }
    else
    {
        CAttrValue *pAttrValue = (CAttrValue *)**GetAttrArray();
        return (CAttrArray**)(pAttrValue[aaix].GetppAA());
    }
}

//----------------------------------------------------------------
//
//      Member:         CElement::GetStyleObject
//
//  Description Helper function to create the .style sub-object
//
//----------------------------------------------------------------
HRESULT
CElement::GetStyleObject(CStyle **ppStyle)
{
    HRESULT hr;
    CStyle *pStyle = 0;

    hr = GetPointerAt(FindAAIndex( DISPID_INTERNAL_CSTYLEPTRCACHE,CAttrValue::AA_Internal), (void **)&pStyle);

    if (!pStyle)
    {
        pStyle = new CStyle(this, DISPID_INTERNAL_INLINESTYLEAA, 0);
        if (!pStyle)
        {
            hr = E_OUTOFMEMORY;
            goto Cleanup;
        }
        hr = AddPointer(DISPID_INTERNAL_CSTYLEPTRCACHE, (void *)pStyle, CAttrValue::AA_Internal);
        if (hr)
            goto Cleanup;
    }

Cleanup:
    if (!hr)
    {
        *ppStyle = pStyle;
    }
    else
    {
        *ppStyle = 0;
        delete pStyle;
    }

    RRETURN(hr);
}

//+---------------------------------------------------------------------------
//
//  Member:     CElement::SetDim, public
//
//  Synopsis:   Sets a given property (either on the inline style or the
//              attribute directly) to a given pixel value, preserving the
//              original units of that attribute.
//
//  Arguments:  [dispID]       -- Property to set the value of
//              [fValue]       -- Value of the property
//              [uvt]          -- Units [fValue] is in. If UNIT_NULLVALUE then
//                                 [fValue] is assumed to be in whatever the
//                                 current units are for this property.
//              [lDimOf]       -- For percentage values, what the percent is of
//              [fInlineStyle] -- If TRUE, the inline style is changed,
//                                otherwise the HTML attribute is changed
//              [pfChanged]    -- Place to indicate if the value actually
//                                changed
//
//  Returns:    HRESULT
//
//----------------------------------------------------------------------------

HRESULT
CElement::SetDim(DISPID                    dispID,
                 float                     fValue,
                 CUnitValue::UNITVALUETYPE uvt,
                 long                      lDimOf,
                 CAttrArray **             ppAttrArray,
                 BOOL                      fInlineStyle,
                 BOOL *                    pfChanged)
{
    CUnitValue          uvValue;
    HRESULT             hr;
    long                lRawValue;

    Assert(pfChanged);
    uvValue.SetNull();

    if (!ppAttrArray)
    {
        if (fInlineStyle)
        {
            ppAttrArray = CreateStyleAttrArray(DISPID_INTERNAL_INLINESTYLEAA);
        }
        else
        {
            ppAttrArray = GetAttrArray();
        }
    }

    Assert(ppAttrArray);
    
    if (*ppAttrArray)
    {
        (*ppAttrArray)->GetSimpleAt(
            (*ppAttrArray)->FindAAIndex(dispID, CAttrValue::AA_Attribute),
            (DWORD*)&uvValue );
    }

    lRawValue = uvValue.GetRawValue();

    if (uvt == CUnitValue::UNIT_NULLVALUE)
    {
        uvt = uvValue.GetUnitType();

        if (uvt == CUnitValue::UNIT_NULLVALUE)
        {
            uvt = CUnitValue::UNIT_PIXELS;
        }
    }

    if ( dispID == STDPROPID_XOBJ_HEIGHT || dispID == STDPROPID_XOBJ_TOP )
    {
        hr = THR(uvValue.YSetFloatValueKeepUnits (fValue,
                                                  uvt,
                                                  lDimOf,
                                                  GetFirstBranch()->GetFontHeightInTwips(&uvValue)));
    }
    else
    {
        hr = THR(uvValue.XSetFloatValueKeepUnits(fValue,
                                                 uvt,
                                                 lDimOf,
                                                 GetFirstBranch()->GetFontHeightInTwips(&uvValue)));
    }
    if ( hr )
        goto Cleanup;

    if ( uvValue.GetRawValue() == lRawValue ) // Has anything changed ??
        goto Cleanup;

#ifndef NO_EDIT
    if (QueryCreateUndo(TRUE,FALSE))
    {
        VARIANT vtProp;

        vtProp.vt = VT_I4;
        vtProp.lVal = lRawValue;

        IGNORE_HR(CreateUndoAttrValueSimpleChange(
            dispID, vtProp, fInlineStyle, CAttrValue::AA_StyleAttribute ) );
    }
#endif // NO_EDIT

    hr = THR(CAttrArray::AddSimple ( ppAttrArray, dispID, uvValue.GetRawValue(),
                                     CAttrValue::AA_StyleAttribute ));

    if (hr)
        goto Cleanup;

    *pfChanged = TRUE;

Cleanup:
    RRETURN(hr);
}

STDMETHODIMP
CElement::put_onscroll(VARIANT v)
{
    HRESULT hr;

    if ((Tag() == ETAG_BODY) || Tag() == ETAG_FRAMESET)
    {
        CDoc *  pDoc = Doc();

        hr = THR(pDoc->EnsureOmWindow());
        if ( hr )
            goto Cleanup;

        hr = pDoc->_pOmWindow->put_onscroll(v);
    }
    else
        hr = s_propdescCElementonscroll.a.HandleCodeProperty(
                    HANDLEPROP_SET | HANDLEPROP_AUTOMATION | (PROPTYPE_VARIANT << 16),
                    &v,
                    this,
                    CVOID_CAST(GetAttrArray()));

Cleanup:
        RRETURN(SetErrorInfo( hr ));
}

STDMETHODIMP
CElement::get_onscroll(VARIANT * p)
{
    HRESULT hr;

    if ((Tag() == ETAG_BODY) || Tag() == ETAG_FRAMESET)
    {
        CDoc * pDoc = Doc();

        hr = THR(pDoc->EnsureOmWindow());
        if ( hr )
            goto Cleanup;

        hr = pDoc->_pOmWindow->get_onscroll(p);
    }
    else
            hr = s_propdescCElementonscroll.a.HandleCodeProperty(
                    HANDLEPROP_AUTOMATION | (PROPTYPE_VARIANT << 16),
                    p,
                    this,
                    CVOID_CAST(GetAttrArray()));

Cleanup:
        RRETURN(SetErrorInfo( hr ));
}

//+-----------------------------------------------------------------
//
//  member : Fire_onscroll
//
//  synopsis : IHTMLTextContainer event implementation
//
//------------------------------------------------------------------
void
CElement::Fire_onscroll()
{
    if (Tag() == ETAG_BODY || Tag() == ETAG_FRAMESET)
    {
        CDoc * pDoc = Doc();

        if (pDoc->_pOmWindow)
            pDoc->_pOmWindow->Fire_onscroll();
    }
    else
    {
        FireOnChanged(DISPID_IHTMLELEMENT2_SCROLLTOP);
        FireOnChanged(DISPID_IHTMLELEMENT2_SCROLLLEFT);

        FireEvent( DISPID_EVMETH_ONSCROLL,
                  DISPID_EVPROP_ONSCROLL,
                  _T("scroll"),
                 (BYTE *) VTS_NONE);
    }
}



//+----------------------------------------------------------------------------
//
//  Member:     CElement::FireCancelableEvent
//
//  Synopsis:   Fire the event, called from PDL-generated stubs.
//
//  Returns:    TRUE: Take default action, FALSE: Don't take default action
//
//-----------------------------------------------------------------------------

BOOL
CElement::FireCancelableEvent(
    DISPID dispidEvent,
    DISPID dispidProp,
    LPCTSTR pchEventType,
    BYTE * pbTypes,
    ...)
{
    CLayout * pLayout = GetUpdatedNearestLayout();
    BOOL      fRet    = TRUE;

    // No nearest layout->assume enabled (dbau)
    
    if ((!pLayout || !pLayout->ElementOwner()->GetAAdisabled()) &&
        ShouldFireEvents())
    {
        VARIANT_BOOL    vb;
        CVariant        Var;
        CDoc           *pDoc = Doc();
        EVENTPARAM      param(pDoc, TRUE);
        CElement       *pElemFire;
        IDispatch      *pEventObj = NULL;

        CDoc::CLock Lock(pDoc);

        va_list     valParms;


        // The first element in a slave tree is just a proxy for its master,
        // so it lets the master fire the event.
        pElemFire = FireEventWith();

        // NEWTREE: GetFirstBranch is iffy here
        param.SetNodeAndCalcCoordinates(pElemFire->GetFirstBranch());
        param.SetType(pchEventType);

        va_start(valParms, pbTypes);

        // Get the eventObject.
        if (!THR(pDoc->EnsureOmWindow()))
        {
            IGNORE_HR(pDoc->_pOmWindow->get_event((IHTMLEventObj **)&pEventObj));
        }

        (void) pElemFire->FireEventV(
                dispidEvent,
                dispidProp,
                pEventObj,
                &Var,
                pbTypes,
                valParms);

        vb = (V_VT(&Var) == VT_BOOL) ? V_BOOL(&Var) : VB_TRUE;

        fRet = !param.IsCancelled() && VB_TRUE == vb;

        va_end(valParms);

        ReleaseInterface(pEventObj);
    }

    return fRet;
}


//+---------------------------------------------------------------------------
//
//  Member:     CElement::FireEvent, public
//
//  Synopsis:   Fires an event out the primary dispatch event connection point.
//              Called from PDL-generated stubs.  Calls FireEvent Helper For
//              the real work, and is mainly responsible for creating the
//              eventparam
//
//  Arguments:  [dispidEvent]   -- DISPID of event to fire
//              [dispidProp]    -- Dispid of prop storing event function
//              [pchEventType]  -- String of type of event
//              [pbTypes]       -- Pointer to array giving the types of parms
//              [...]           -- Parameters
//
//  Returns:    HRESULT
//
//----------------------------------------------------------------------------

HRESULT
CElement::FireEvent(
    DISPID dispidEvent,
    DISPID dispidProp,
    LPCTSTR pchEventType,
    BYTE * pbTypes,
    ...)
{
    CPeerHolder *   pPeerHolder = GetPeerHolder();
    HRESULT         hr = S_OK;
    CDoc         * pDoc = Doc();
    CElement     * pElemFire = NULL;

    // Onloads can happen before the document is done parsing and before the message pump is hit so
    // deferred scripts may not be hooked up when onload is fired.  If the onload is being fired then
    // hook up any event handlers.
    if (dispidEvent == DISPID_EVMETH_ONLOAD)
    {
        IGNORE_HR(pDoc->CommitDeferredScripts(TRUE));
    }

    // don't fire standard events if there is a behavior attached that wants to fire them instead
    //  or if there is no event handler or connection point attached to this element, don't bother 
    //  with the the work (perffix )
    if (pPeerHolder &&
        IsStandardDispid(dispidProp) &&
        pPeerHolder->HasCustomEventMulti(dispidProp)) 
        return S_OK;

    pElemFire = FireEventWith();

    if (ShouldFireEvents())
    {
        CPeerHolder::CLock lock(pPeerHolder);

        EVENTPARAM  param(pDoc, TRUE);

        // NEWTREE: GetFirstBranch is iffy here
        //          I've seen this be null on a timer event.
        param.SetNodeAndCalcCoordinates(pElemFire->GetFirstBranch());
        param.SetType(pchEventType);


        hr = THR(pElemFire->FireEventHelper(dispidEvent,
                                            dispidProp,
                                            pbTypes));
    }

    //
    // since focus/blur do not bubble, and things like accessibility
    // need to have a centralized place to handle focus changes, if
    // we just fired focus or blur for someone other than the doc,
    // then fire the doc's onfocuschange/onblurchange methods, keeping
    // the event param structure intact.
    //
    // BUGBUG (carled) the ONCHANGEFOCUS/ONCHANGEBLUR need to be removed
    //   from the document's event interface
    //

    if (!hr &&
        ((dispidEvent==DISPID_EVMETH_ONFOCUS)||(dispidEvent==DISPID_EVMETH_ONBLUR)) && 
        (pElemFire->Tag()!=ETAG_ROOT))
    {
        // BUGBUG (carled) the sourceindex is not necessarily up
        //  to date and updateTreeCahce() would need to be called.
        //  DO NOT DO THIS. Accessibility1.0 doen't support DHTML
        //  and we don't want the pref hit.  Also the srcIndex is
        //  unreliable even if ensured and this needs to be changed
        //  when DHTML is actually supported.

        // Since carled doesn't want a monster walk (why?!?) I'll
        // just use __iSourceIndex directly here to avoid annoying
        // asserts that everyone has been complaining about.  (jbeda)

        // FerhanE
        // We have to check is the document has the focus, before firing this, 
        // to prevent firing of accessible focus/blur events when the document
        // does not have the focus. 
        if (pDoc->HasFocus())
            hr = pDoc->FireAccesibilityEvents(dispidEvent, pElemFire->GetSourceIndex() );
    }


    RRETURN(hr);
}


HRESULT
CElement::FireEventHelper(
    DISPID dispidEvent,
    DISPID dispidProp,
    BYTE * pbTypes,
    ...)
{
    HRESULT   hr      = S_OK;

    Assert(FireEventWith() == this);
    if (!GetAAdisabled())
    {
        va_list         valParms;
        CDoc           *pDoc = Doc();
        CDoc::CLock     Lock(pDoc);
        IDispatch      *pEventObj = NULL;

        va_start(valParms, pbTypes);

        // Get the eventObject.
        if (!THR(pDoc->EnsureOmWindow()))
        {
            IGNORE_HR(pDoc->_pOmWindow->get_event((IHTMLEventObj **)&pEventObj));
        }

        hr = FireEventV(
                dispidEvent,
                dispidProp,
                pEventObj,
                NULL,
                pbTypes,
                valParms);

        ReleaseInterface(pEventObj);

        va_end(valParms);
    }

    RRETURN(hr);
}

//+---------------------------------------------------------------------------
//
//  Member:     CElement::BubbleEvent, public
//
//  Synopsis:   Fires an event out the primary dispatch event connection point,
//              and bubbles up the parent chain firing the event from
//              parent sites, as well.   Called from PDL-generated stubs.
//
//  Arguments:  [dispid]  -- DISPID of event to fire
//              [pbTypes] -- Pointer to array giving the types of the params
//              [...]     -- Parameters
//
//  Returns:    HRESULT
//
//----------------------------------------------------------------------------

HRESULT
CElement::BubbleEvent(CTreeNode *pNodeContext, long lSubDivision, DISPID dispidMethod,
                      DISPID dispidProp, LPCTSTR pchEventType,
                      BYTE * pbTypes, ...)
{
    HRESULT hr = S_OK;
    CDoc *pDoc = Doc();

    if (!pNodeContext)
        pNodeContext = GetFirstBranch();

    Assert(pNodeContext && pNodeContext->Element() == this);

    if (!pNodeContext)
        goto Cleanup;

    if (pDoc)
    {
        EVENTPARAM  param(pDoc, TRUE);

        va_list     valParms;

        param.SetNodeAndCalcCoordinates(pNodeContext);
        param.SetType(pchEventType);
        param.lSubDivision = lSubDivision;

        va_start(valParms, pbTypes);

        hr = BubbleEventHelper(pNodeContext, lSubDivision, dispidMethod, dispidProp, FALSE, NULL, pbTypes, valParms);
    }

Cleanup:
    RRETURN(hr);
}

//+----------------------------------------------------------------------------
//
//  Member:     CElement::BubbleCancelableEvent
//
//  Synopsis:   Fire the bubbling event, called from PDL-generated stubs.
//
//  Returns:    TRUE: Take default action, FALSE: Don't take default action
//
//-----------------------------------------------------------------------------

BOOL
CElement::BubbleCancelableEvent(CTreeNode * pNodeContext, long lSubDivision, DISPID dispidMethod, DISPID dispidProp,
                                LPCTSTR pchEventType, BYTE * pbTypes, ...)
{
    BOOL fRet = TRUE;
    CDoc *pDoc = Doc();

    if(!pNodeContext)
        pNodeContext = GetFirstBranch();

    Assert(pNodeContext && pNodeContext->Element() == this);

    if (pDoc)
    {
        CVariant        vb;
        EVENTPARAM      param(pDoc, TRUE);

        va_list     valParms;

        param.SetNodeAndCalcCoordinates(pDoc->_pElementOMCapture
                        &&  pDoc->_pNodeLastMouseOver
                        &&  (  (dispidMethod == DISPID_EVMETH_ONCLICK)
                            || (dispidMethod == DISPID_EVMETH_ONDBLCLICK))
                            ? pDoc->_pNodeLastMouseOver : pNodeContext);
        param.SetType(pchEventType);
        param.lSubDivision = lSubDivision;

        if (dispidMethod == DISPID_EVMETH_ONBEFOREEDITFOCUS)
            param._pNodeTo = pNodeContext;
            
        va_start(valParms, pbTypes);

        (void) BubbleEventHelper(pNodeContext, lSubDivision, dispidMethod, dispidProp, FALSE, &vb, pbTypes, valParms);

        if ( V_VT(&vb) != VT_EMPTY )
            fRet = (V_VT(&vb) == VT_BOOL) ? V_BOOL(&vb)==VB_TRUE : TRUE;

        fRet = fRet && !param.IsCancelled();
    }
    return fRet;
}


// helper
void
TransformSlaveToMaster(CTreeNode ** ppNode)
{
    Assert(ppNode);
    if (!*ppNode || (*ppNode)->Element()->Tag() != ETAG_TXTSLAVE)
        return;

    CElement * pElem = (*ppNode)->Element()->MarkupMaster();

    *ppNode = (pElem) ? pElem->GetFirstBranch() : NULL;
}

//+----------------------------------------------------------------------------
//
//  Function:   BubbleEventHelper
//
//  Synopsis:   Fire the specified event. All the sites in the parent chain
//              are supposed to fire the events (if they can).  Caller has
//              responsibility for setting up any EVENTPARAM.
//
//  Arguments:  [dispidEvent]   -- dispid of the event to fire.
//              [dispidProp]    -- dispid of prop containing event func.
//              [pvb]           -- Boolean return value
//              [pbTypes]       -- Pointer to array giving the types of parms
//              [...]           -- Parameters
//
//  Returns:    S_OK if successful
//
//-----------------------------------------------------------------------------

HRESULT
CElement::BubbleEventHelper(
    CTreeNode * pNodeContext,
    long        lSubDivision,
    DISPID      dispidEvent,
    DISPID      dispidProp,
    BOOL        fRaisedByPeer,
    VARIANT   * pvb,
    BYTE      * pbTypes, ...)
{
    CPeerHolder *   pPeerHolder = GetPeerHolder();

    // don't fire standard events if there is a behavior attached that wants to fire them instead
    if (pPeerHolder && !fRaisedByPeer &&
        IsStandardDispid(dispidProp) &&
        pPeerHolder->HasCustomEventMulti(dispidProp))
        return S_OK;

    CPeerHolder::CLock lock(pPeerHolder);

    CDoc * pDoc = Doc();

    Assert(pNodeContext && pNodeContext->Element() == this);
    Assert(pDoc->_pparam);

    if (!pNodeContext)
        return S_OK;

    CTreeNode *     pNode = pNodeContext;
    CElement *      pElementReal;
    va_list         valParms;
    CVariant        vb;
    CVariant        Var;
    CLayout       * pLayout = pNodeContext->GetUpdatedNearestLayout();
    unsigned int    cInvalOld = pDoc->_cInval;
    long            cSub = 0;

    // By default do not cancel events
    pDoc->_pparam->fCancelBubble = FALSE;

    //
    // If there are any subdivisions, let the subdivisions handle the
    // event.
    //

    if (OK(GetSubDivisionCount(&cSub)) && cSub)
    {
        va_list     valParms;

        va_start(valParms, pbTypes);
        IGNORE_HR(DoSubDivisionEvents(
                lSubDivision,
                dispidEvent,
                dispidProp,
                &Var,
                pbTypes,
                valParms));

        if ( V_VT(&Var) != VT_EMPTY )
        {
            V_VT(&vb)   = VT_BOOL;
            V_BOOL(&vb) = (V_VT(&Var) == VT_BOOL) ? V_BOOL(&Var) : VB_TRUE;
        }
    }

    // if the srcElement is the rootsite, return the HTML element
    Assert(pDoc->_pparam->_pNode);

    if (    (pDoc->_pparam->_pNode->Element()->IsRoot())
        &&  (pDoc->_pElementOMCapture != this))
    {
        CElement * pElemHead = pDoc->_pPrimaryMarkup->GetHtmlElement();

        pDoc->_pparam->SetNodeAndCalcCoordinates(
                    pElemHead ? pElemHead->GetFirstBranch() : NULL);
    }

    CDoc::CLock Lock(pDoc);

    va_start (valParms, pbTypes);

    // if Bubbling cancelled by a sink. Don't bubble anymore
    while (pNode && !pDoc->_pparam->fCancelBubble)
    {
        BOOL fListenerPresent = FALSE;

        // if we're disabled () or in the scope of a disabled site
        // then pass the event to the parent
        //
        pLayout = pNode->GetUpdatedNearestLayout();
        if (pLayout && pLayout->ElementOwner()->GetAAdisabled())
        {
            pNode = pNode->GetUpdatedNearestLayoutNode()->Parent();
            continue;
        }

        pElementReal = pNode->Element();
        CBase * pBase = pElementReal;

        // BUGBUG (MohanB) This logic should change once the root element
        // is gone.

        // If this is the root element in the tree, then the
        // event is to be fired by the CDoc containing the
        // rootsite, rather than the rootsite itself.
        // we do this so that the top of the bubble goes to the doc
        if (pElementReal->IsRoot())
        {
            CElement * pElementMaster = pElementReal->MarkupMaster();

            if (pElementMaster)
            {
                // Bubble through the master's tree
                pNode = pElementMaster->GetFirstBranch();
                if (!pNode)
                    break;
                pBase = pElementReal = pElementMaster;
                pDoc->_pparam->SetNodeAndCalcCoordinates(pNode);

                // BUGBUG (MohanB) What to about _pNodeFrom && _pNodeTo? For now,
                // transform them to respective master elements
                TransformSlaveToMaster(&pDoc->_pparam->_pNodeFrom);
                TransformSlaveToMaster(&pDoc->_pparam->_pNodeTo);
            }
            else
            {
                pBase = pDoc;
            }

            fListenerPresent = TRUE;
        }
        else
        {
            // this is an element in the tree. Check to see if there
            // are any possible listeners for this event. if so, continue
            // if not, don't call FireEventV and let the event continue 
            // in its bubbling.
            fListenerPresent = pElementReal->ShouldFireEvents();
        }

        pNode->NodeAddRef();

        if (fListenerPresent)
        {
            IDispatch  *pEventObj = NULL;

            // Get the eventObject.
            if (!THR(pDoc->EnsureOmWindow()))
            {
                IGNORE_HR(pDoc->_pOmWindow->get_event((IHTMLEventObj **)&pEventObj));
            }

            IGNORE_HR(pBase->FireEventV(
                dispidEvent,
                dispidProp,
                pEventObj,
                &Var,
                pbTypes,
                valParms));

            ReleaseInterface(pEventObj);

            if ( V_VT(&Var) != VT_EMPTY )
            {
                V_VT(&vb)   = VT_BOOL;
                V_BOOL(&vb) = (V_VT(&Var) == VT_BOOL) ? V_BOOL(&Var) : VB_TRUE;
            }
        }

        // If the node is no longer valid we're done.  Script in the event handler caused
        // the tree to change.
        if (!pNode->IsDead())
        {
            pNode->NodeRelease();

            if (ETAG_MAP == pNode->Tag())
            {
                //
                // If we're the map, break out right now, since the associated
                // IMG has already fired its events.
                //
                break;
            }

            pNode = pNode->Parent();
            if(!pNode)
            {
                pNode = pElementReal->GetFirstBranch();
                if(pNode)
                {
                    pNode = pNode->Parent();
                }
            }
        }
        else
        {
            pNode->NodeRelease();
            pNode = NULL;
        }
    }

    // if we're still bubbling, we need to go all the way up to the window also.
    // Currently the only event that does this, is onhelp so this test is here to
    // minimize the work
    if (!pDoc->_pparam->fCancelBubble &&
        GetOmWindow() &&
        dispidEvent == DISPID_EVMETH_ONHELP)
    {
        IDispatch  *pEventObj = NULL;
        CBase      *pBase = GetOmWindow();

        // Get the eventObject.
        if (!THR(pDoc->EnsureOmWindow()))
        {
            IGNORE_HR(pDoc->_pOmWindow->get_event((IHTMLEventObj **)&pEventObj));
        }

        IGNORE_HR(pBase->FireEventV(
                    dispidEvent,
                    dispidProp,
                    pEventObj,
                    &Var,
                    pbTypes,
                    valParms));

        ReleaseInterface(pEventObj);

        if ( V_VT(&Var) != VT_EMPTY )
        {
            V_VT(&vb)   = VT_BOOL;
            V_BOOL(&vb) = (V_VT(&Var) == VT_BOOL) ? V_BOOL(&Var) : VB_TRUE;
        }
    }

    va_end (valParms);

    if (pvb)
        ((CVariant *)pvb)->Copy(&vb);

    // set a flag in doc, if the script caused an invalidation
    if (cInvalOld != pDoc->_cInval)
        pDoc->_fInvalInScript = TRUE;

    return S_OK;
}


//+----------------------------------------------------------------------------
//
//  Function:   DoSubDivisionEvents
//
//  Synopsis:   Fire the specified event on the given subdivision.
//
//  Arguments:  [dispidEvent]   -- dispid of the event to fire.
//              [dispidProp]    -- dispid of prop containing event func.
//              [pvb]           -- Boolean return value
//              [pbTypes]       -- Pointer to array giving the types of parms
//              [...]           -- Parameters
//
//-----------------------------------------------------------------------------

HRESULT
CElement::DoSubDivisionEvents(
    long        lSubDivision,
    DISPID      dispidEvent,
    DISPID      dispidProp,
    VARIANT   * pvb,
    BYTE      * pbTypes, ...)
{
    return S_OK;
}


BOOL AllowCancelKeydown(CMessage * pMessage)
{
    Assert(pMessage->message == WM_SYSKEYDOWN || pMessage->message == WM_KEYDOWN);

    WPARAM wParam = pMessage->wParam;
    DWORD  dwKeyState = pMessage->dwKeyState;
    int i;

    struct KEY
    { 
        WPARAM  wParam;
        DWORD   dwKeyState;
    };

    static KEY s_aryVK[] =
    {
        VK_F1,      0,
        VK_F2,      0,
        VK_F3,      0,
        VK_F4,      0,
        VK_F5,      0,
        VK_F6,      0,
        VK_F7,      0,
        VK_F8,      0,
        VK_F9,      0,
        VK_F10,     0,
        VK_F11,     0,
        VK_F12,     0,
        VK_SHIFT,   MK_SHIFT,
        VK_F4,      MK_CONTROL,
        VK_TAB,     MK_CONTROL,
        VK_TAB,     MK_CONTROL | MK_SHIFT,
        65,         MK_CONTROL, // ctrl-a
        70,         MK_CONTROL, // ctrl-f
        79,         MK_CONTROL, // ctrl-o
        80,         MK_CONTROL, // ctrl-p
    };

    if (dwKeyState == MK_ALT)
        return FALSE;

    for (i = 0; i < ARRAY_SIZE(s_aryVK); i++)
    {
        if (    s_aryVK[i].wParam == wParam
            &&  s_aryVK[i].dwKeyState == dwKeyState)
        {
            return FALSE;
        }
    }

    return TRUE;
}

//+---------------------------------------------------------------------------
//
//  Member:     FireEventOnMessage
//
//  Synopsis:   fires event corresponding to message
//
//  Arguments:  [pMessage]   -- message
//
//  Returns:    return value satisfies same rules as HandleMessage:
//              S_OK        don't do anything - event was cancelled;
//              S_FALSE     keep processing the message - event was not cancelled
//              other       error
//
//----------------------------------------------------------------------------

HRESULT
CElement::FireStdEventOnMessage(CTreeNode * pNodeContext,
                                CMessage * pMessage,
                                CTreeNode * pNodeBeginBubbleWith /* = NULL */,
                                CTreeNode * pNodeEvent /* = NULL */)
{
    Assert(pNodeContext && pNodeContext->Element() == this);

    if (pMessage->fEventsFired)
        return S_FALSE;

    HRESULT     hr = S_FALSE;
    POINT       ptEvent = pMessage->pt;
    CDoc *      pDoc = Doc();
    CTreeNode * pNodeThisCanFire = pNodeContext;
    CTreeNode::CLock lock(pNodeThisCanFire);

    // BUGBUG (alexz) (anandra) need this done in a generic way for all events.
    // about to fire an event; if there are deferred scripts, commit them now.
    pDoc->CommitDeferredScripts(TRUE); // TRUE - early, so don't commit downloaded deferred scripts

    //
    // Keyboard events are fired only once before the message is
    // dispatched.
    //

    switch (pMessage->message)
    {
    case WM_HELP:
        hr = pNodeThisCanFire->Element()->Fire_onhelp(
                pNodeThisCanFire, pMessage ? pMessage->lSubDivision : 0) ? S_FALSE : S_OK;
        break;

    case WM_SYSKEYDOWN:
    case WM_KEYDOWN:
        hr = pNodeThisCanFire->Element()->FireStdEvent_KeyDown(pNodeThisCanFire, pMessage, (int*)&pMessage->wParam, VBShiftState()) ? S_FALSE : S_OK;

        if (    hr == S_OK
            &&  (   (pDoc->_dwCompat & URLCOMPAT_KEYDOWN)
                 || (!pDoc->_fTrustedDoc && !AllowCancelKeydown(pMessage))))
        {
            hr = S_FALSE;
        }

        break;

    case WM_SYSKEYUP:
    case WM_KEYUP:
        pNodeThisCanFire->Element()->FireStdEvent_KeyUp(pNodeThisCanFire, pMessage, (int*)&pMessage->wParam, VBShiftState());
        break;

    case WM_CHAR:
        hr = pNodeThisCanFire->Element()->FireStdEvent_KeyPress(pNodeThisCanFire, pMessage, (int*)&pMessage->wParam) ? S_FALSE : S_OK;
        break;

    case WM_LBUTTONDBLCLK:
        pDoc->_fGotDblClk = TRUE;
        goto Cleanup;       // To not set the event fired bit.

    case WM_LBUTTONDOWN:
    case WM_RBUTTONDOWN:
    case WM_MBUTTONDOWN:
    {
        FireStdEvent_MouseHelper(
            pNodeContext,
            pMessage,
            DISPID_EVMETH_ONMOUSEDOWN,
            DISPID_EVPROP_ONMOUSEDOWN,
            VBButtonState((short)pMessage->wParam),
            VBShiftState(),
            (float)ptEvent.x, (float)ptEvent.y,
            pNodeContext,
            pNodeContext,
            pNodeBeginBubbleWith,
            pNodeEvent);
        break;
    }

    case WM_LBUTTONUP:
    case WM_RBUTTONUP:
    case WM_MBUTTONUP:
        {
            short      sParam;
            CTreeNode *pNodeFireWith = NULL;

            // pMessage->wParam represents the button state
            // not button transition, on up, nothing is down.
            if (pMessage->message == WM_LBUTTONUP)
                sParam = VB_LBUTTON;
            else if (pMessage->message == WM_RBUTTONUP)
                sParam = VB_RBUTTON;
            else if (pMessage->message == WM_MBUTTONUP)
                sParam = VB_MBUTTON;
            else
                sParam = 0;

            // the real element under the mouse should fire mouse up.
            // not the object which had capture. (pElemThisCanFire)

            if (pNodeEvent)
                pNodeFireWith = pNodeThisCanFire;
            else
                pNodeFireWith = pMessage->pNodeHit;

            if( pNodeFireWith == NULL )
                break;

            pNodeFireWith->Element()->FireStdEvent_MouseHelper(
                                pNodeFireWith,
                                pMessage,
                                DISPID_EVMETH_ONMOUSEUP,
                                DISPID_EVPROP_ONMOUSEUP,
                                sParam,
                                VBShiftState(),
                                (float)ptEvent.x, (float)ptEvent.y,
                                NULL,
                                NULL,
                                pNodeBeginBubbleWith,
                                pNodeEvent);
        }
        break;

    case WM_MOUSELEAVE:   // fired for MouseOut event
        pNodeThisCanFire->Element()->FireStdEvent_MouseHelper(
                            pNodeThisCanFire,
                            pMessage,
                            DISPID_EVMETH_ONMOUSEOUT,
                            DISPID_EVPROP_ONMOUSEOUT,
                            VBButtonState((short)pMessage->wParam),
                            VBShiftState(),
                            (float)ptEvent.x,
                            (float)ptEvent.y,
                            pNodeContext,
                            pDoc->_pNodeLastMouseOver,
                            pNodeBeginBubbleWith,
                            pNodeEvent);
        break;

    case WM_MOUSEOVER:    // essentially an Enter event
        pNodeThisCanFire->Element()->FireStdEvent_MouseHelper(
                            pNodeThisCanFire,
                            pMessage,
                            DISPID_EVMETH_ONMOUSEOVER,
                            DISPID_EVPROP_ONMOUSEOVER,
                            VBButtonState((short)pMessage->wParam),
                            VBShiftState(),
                            (float)ptEvent.x,
                            (float)ptEvent.y,
                            pDoc->_pNodeLastMouseOver,
                            pNodeContext,
                            pNodeBeginBubbleWith,
                            pNodeEvent);
        break;

    case WM_MOUSEMOVE:
        // now fire the mousemove event
        hr = (pNodeThisCanFire->Element()->FireStdEvent_MouseHelper(
                            pNodeThisCanFire,
                            pMessage,
                            DISPID_EVMETH_ONMOUSEMOVE,
                            DISPID_EVPROP_ONMOUSEMOVE,
                            VBButtonState((short)pMessage->wParam),
                            VBShiftState(),
                            (float)ptEvent.x,
                            (float)ptEvent.y,
                            pDoc->_pNodeLastMouseOver,
                            pNodeContext,
                            pNodeBeginBubbleWith,
                            pNodeEvent))
                               ? S_FALSE : S_OK;
        break;

    case WM_CONTEXTMENU:
        hr = pNodeThisCanFire->Element()->Fire_oncontextmenu() ? S_FALSE : S_OK;
        break;

#ifdef VSTUDIO7
    case WM_MOUSEHOVER:
        hr = pNodeThisCanFire->Element()->Fire_onmousehover() ? S_FALSE : S_OK;
        break;
#endif
        
    default:
        goto Cleanup;  // don't set fStdEventsFired
    }

    pMessage->fEventsFired = TRUE;

Cleanup:
    RRETURN1 (hr, S_FALSE);
}


//+----------------------------------------------------------------------------
//
//  Member:     CElement::FireStdEvent_KeyDown
//
//  Synopsis:   Fire a key event.
//
//  Returns:    TRUE: Take default action, FALSE: Don't take default action
//
//-----------------------------------------------------------------------------

BOOL
CElement::FireStdEvent_KeyDown(CTreeNode * pNodeContext, CMessage *pMessage, int *piKeyCode, short shift)
{
    BOOL            fRet = TRUE;
    CDoc *          pDoc = Doc();
    HRESULT         hr;

    Assert(pNodeContext && pNodeContext->Element() == this);

    if (pDoc)
    {
        CVariant        varRet;
        EVENTPARAM      param(pDoc, TRUE);

        param.SetNodeAndCalcCoordinates(pNodeContext);
        param._lKeyCode = (long)*piKeyCode;
        param.SetType(_T("keydown"));
        // the 30th bit of the lparam indicates whether this is a repeated WM_
        param.fRepeatCode = !!(HIWORD(pMessage->lParam) & KF_REPEAT);

        hr = THR(BubbleEventHelper(
                    pNodeContext,
                    pMessage->lSubDivision,
                    DISPID_EVMETH_ONKEYDOWN,
                    DISPID_EVPROP_ONKEYDOWN,
                    FALSE,
                    &varRet,
                    (BYTE *) VTS_NONE,
                    shift));
        *piKeyCode = (int)param._lKeyCode;
        fRet = !param.IsCancelled() && (V_VT(&varRet) == VT_EMPTY || VB_TRUE == V_BOOL(&varRet));
    }

    return fRet;
}

//+----------------------------------------------------------------------------
//
//  Member:     CElement::FireStdEvent_KeyUp
//
//  Synopsis:   Fire the key up event.
//
//  Returns:    TRUE: Take default action, FALSE: Don't take default action
//
//-----------------------------------------------------------------------------

BOOL
CElement::FireStdEvent_KeyUp(CTreeNode * pNodeContext, CMessage *pMessage, int *piKeyCode, short shift)
{
    BOOL            fRet = TRUE;
    CDoc *          pDoc = Doc();
    HRESULT         hr;

    Assert(pNodeContext && pNodeContext->Element() == this);

    if (pDoc)
    {
        CVariant        varRet;
        EVENTPARAM      param(pDoc, TRUE);

        param.SetNodeAndCalcCoordinates(pNodeContext);
        param._lKeyCode = (long)*piKeyCode;
        param.SetType(_T("keyup"));

        hr = THR(BubbleEventHelper(
            pNodeContext,
            pMessage->lSubDivision,
            DISPID_EVMETH_ONKEYUP,
            DISPID_EVPROP_ONKEYUP,
            FALSE,
            &varRet,
            (BYTE *) VTS_NONE,
            shift));
        *piKeyCode = (int)param._lKeyCode;
        fRet = !param.IsCancelled() && (V_VT(&varRet) == VT_EMPTY || VB_TRUE == V_BOOL(&varRet));
    }

    return fRet;
}


//+----------------------------------------------------------------------------
//
//  Member:     CElement::FireStdEvent_KeyPress
//
//  Synopsis:   Fire the key press event.
//
//  Returns:    TRUE: Take default action, FALSE: Don't take default action
//
//-----------------------------------------------------------------------------

BOOL
CElement::FireStdEvent_KeyPress(CTreeNode * pNodeContext, CMessage *pMessage, int *piKeyCode)
{
    BOOL            fRet = TRUE;
    CDoc *          pDoc = Doc();
    HRESULT         hr;

    Assert(pNodeContext && pNodeContext->Element() == this);

    if (pDoc)
    {
        CVariant        varRet;
        EVENTPARAM      param(pDoc, TRUE);

        param.SetNodeAndCalcCoordinates(pNodeContext);
        param._lKeyCode = (long)*piKeyCode;
        param.SetType(_T("keypress"));

        hr = THR(BubbleEventHelper(
                pNodeContext,
                pMessage->lSubDivision,
                DISPID_EVMETH_ONKEYPRESS,
                DISPID_EVPROP_ONKEYPRESS,
                FALSE,
                &varRet,
                (BYTE *) VTS_NONE ));
        *piKeyCode = (int)param._lKeyCode;
        fRet = !param.IsCancelled() && (V_VT(&varRet) == VT_EMPTY || VB_TRUE == V_BOOL(&varRet));
    }

    return fRet;
}

//+----------------------------------------------------------------------------
//
//  Member:     CElement::FireStdEvent_MouseHelper
//
//  Synopsis:   Fire any mouse event.
//
//  Returns:    Nothing
//
//-----------------------------------------------------------------------------

BOOL
CElement::FireStdEvent_MouseHelper(
    CTreeNode * pNodeContext,
    CMessage *  pMessage,
    DISPID      dispidMethod,
    DISPID      dispidProp,
    short       button,
    short       shift,
    float       x,
    float       y,
    CTreeNode * pNodeFrom,                   /* = NULL */
    CTreeNode * pNodeTo,                     /* = NULL */
    CTreeNode * pNodeBeginBubbleWith,        /* = NULL */
    CTreeNode * pNodeEvent                   /* = NULL */)
{
    BOOL    fRet = TRUE;
    CDoc *  pDoc = Doc();
    CTreeNode * pNodeSrcElement = pNodeEvent ? pNodeEvent : pNodeContext;

    Assert(pNodeContext && pNodeContext->Element() == this);

    if (!pNodeBeginBubbleWith)
        pNodeBeginBubbleWith = pNodeContext;

    if (pDoc)
    {
        HRESULT         hr;
        CVariant        varRet;
        EVENTPARAM      param(pDoc, FALSE);
        POINT           pt;

        pt.x = x;
        pt.y = y;

        param._clientX = x;
        param._clientY = y;
        param.SetNodeAndCalcCoordinates(pNodeSrcElement);
        // CHROME
        // If Chrome hosted there is no valid HWND to
        // map client to screen coordinates so substitute
        // the current cursor position instead. Screen
        // coordinates will therefore be out of sync with
        // client coordinates but this is not envisaged as
        // being a serious problem
        if (!pDoc->IsChromeHosted())
        {
            if (pDoc->_pInPlace)
                ClientToScreen(pDoc->_pInPlace->_hwnd, &pt);
        }
        else
        {
            ::GetCursorPos(&pt);
        }
        param._screenX = pt.x;
        param._screenY = pt.y;

        param._sKeyState = shift;
        param._lButton = button;
        param.lSubDivision = pMessage->lSubDivision;

        switch(dispidMethod)
        {
            // these have a different parameter lists. i.e. none,
            //  and, they initialize two more members of EVENTPARAM
        case DISPID_EVMETH_ONMOUSEOVER:
            param.SetType(_T("mouseover"));
            param._pNodeFrom   = pNodeFrom;
            param._pNodeTo     = pNodeTo;
#if DBG == 1
            if (!IsTagEnabled(tagOM_DontFireMouseEvents))
            {
#endif
                hr = THR(pNodeBeginBubbleWith->Element()->BubbleEventHelper(
                        pNodeBeginBubbleWith,
                        pMessage->lSubDivision,
                        dispidMethod,
                        dispidProp,
                        FALSE,
                        &varRet,
                        (BYTE *) VTS_NONE));
#if DBG == 1
            }
#endif

            // if the return value is true, then for anchors and areas we
            //  need to set the flag to prevent the status text from being
            //  set.
            if ((V_VT(&varRet) != VT_EMPTY && V_BOOL(&varRet)==VB_TRUE) ||
                ( (V_VT(&param.varReturnValue) == VT_BOOL) &&
                (V_BOOL(&param.varReturnValue) == VB_TRUE) ) )
            {
                if ((Tag() == ETAG_A) || (Tag() == ETAG_AREA))
                    DYNCAST(CHyperlink, this)->_fHasMouseOverCancelled = TRUE;
                else
                {
                    // if we are within the scope of an anchor....
                    CTreeNode * pAnchor = GetFirstBranch()->Ancestor(ETAG_A);
                    if (pAnchor)
                        DYNCAST(CHyperlink, pAnchor->Element())->_fHasMouseOverCancelled = TRUE;
                }
            }
            break;

        case DISPID_EVMETH_ONMOUSEOUT:
            param.SetType(_T("mouseout"));
            param._pNodeFrom   = pNodeFrom;
            param._pNodeTo     = pNodeTo;
#if DBG == 1
            if (!IsTagEnabled(tagOM_DontFireMouseEvents))
            {
#endif
                hr = THR(pNodeBeginBubbleWith->Element()->BubbleEventHelper(
                        pNodeBeginBubbleWith,
                        pMessage->lSubDivision,
                        dispidMethod,
                        dispidProp,
                        FALSE,
                        NULL,
                        (BYTE *) VTS_NONE));
#if DBG == 1
            }
#endif

            if ((Tag() == ETAG_A) || (Tag() == ETAG_AREA))
                DYNCAST(CHyperlink, this)->_fHasMouseOverCancelled = FALSE;
            else
            {
                // if we are within the scope of an anchor....
                CTreeNode * pAnchor = GetFirstBranch()->Ancestor(ETAG_A);
                if (pAnchor)
                    DYNCAST(CHyperlink, pAnchor->Element())->_fHasMouseOverCancelled = FALSE;
            }
            break;

        // BUGBUG (MohanB) For now, allow MouseMove to be cancellable so
        // that script writers can override default actions like drag-drop.
        case DISPID_EVMETH_ONMOUSEMOVE:
            param.SetType(_T("mousemove"));
#if DBG == 1
            if (!IsTagEnabled(tagOM_DontFireMouseEvents))
            {
#endif
                hr = THR(pNodeBeginBubbleWith->Element()->BubbleEventHelper(
                        pNodeBeginBubbleWith,
                        pMessage->lSubDivision,
                        dispidMethod,
                        dispidProp,
                        FALSE,
                        &varRet,
                        (BYTE *) VTS_NONE,
                        button,
                        shift,
                        x, y));
#if DBG == 1
            }
#endif
            fRet = !param.IsCancelled() && (V_VT(&varRet) == VT_EMPTY || VB_TRUE == V_BOOL(&varRet));
            break;

        case DISPID_EVMETH_ONMOUSEUP:
            param.SetType(_T("mouseup"));
#if DBG == 1
            if (!IsTagEnabled(tagOM_DontFireMouseEvents))
            {
#endif
                hr = THR(pNodeBeginBubbleWith->Element()->BubbleEventHelper(
                        pNodeBeginBubbleWith,
                        pMessage->lSubDivision,
                        dispidMethod,
                        dispidProp,
                        FALSE,
                        NULL,
                        (BYTE *) VTS_NONE,
                        button,
                        shift,
                        x, y));
#if DBG == 1
            }
#endif
            break;

        case DISPID_EVMETH_ONMOUSEDOWN:
            param.SetType(_T("mousedown"));
#if DBG == 1
            if (!IsTagEnabled(tagOM_DontFireMouseEvents))
            {
#endif
                hr = THR(pNodeBeginBubbleWith->Element()->BubbleEventHelper(
                        pNodeBeginBubbleWith,
                        pMessage->lSubDivision,
                        dispidMethod,
                        dispidProp,
                        FALSE,
                        NULL,
                        (BYTE *) VTS_NONE,
                        button,
                        shift,
                        x, y));
#if DBG == 1
            }
#endif
            break;

        default:
            Assert(0 && "ignorable assert, if we are here there is no event type");
            hr = THR(pNodeBeginBubbleWith->Element()->BubbleEventHelper(
                    pNodeBeginBubbleWith,
                    pMessage->lSubDivision,
                    dispidMethod,
                    dispidProp,
                    FALSE,
                    NULL,
                    (BYTE *) VTS_NONE,
                    button,
                    shift,
                    x, y));
            break;
        }
    }
    return fRet;
}

//+----------------------------------------------------------------------------
//
//  member  :   click()   IHTMLElement method
//
//-----------------------------------------------------------------------------

HRESULT BUGCALL
CElement::click(CTreeNode *pNodeContext)
{
    HRESULT hr = DoClick(NULL, pNodeContext);
    if(hr == S_FALSE)
        hr = S_OK;
    RRETURN(SetErrorInfo(hr));
}


//+------------------------------------------------------------------------
//
//  Member:     CElement::DoClick
//
//  Arguments:  pMessage    Message that resulted in the click. NULL when
//                          called by OM method click().
//              if this is called on a disabled site, we still want to
//              fire the event (the event code knows to do the right thing
//              and start above the disabled site). and we still want to
//              call click action... but not on us, on the parent
//
//-------------------------------------------------------------------------

HRESULT
CElement::DoClick(CMessage * pMessage /*=NULL*/, CTreeNode *pNodeContext /*=NULL*/,
                  BOOL fFromLabel /*=FALSE*/)
{
    HRESULT hr = S_OK;

    if(!pNodeContext)
        pNodeContext = GetFirstBranch();

    if(!pNodeContext)
    {
        hr = S_FALSE;
        goto Cleanup;
    }

    Assert(pNodeContext && pNodeContext->Element() == this);

    if (!TestLock(ELEMENTLOCK_CLICK))
    {
        CLock              Lock(this, ELEMENTLOCK_CLICK);
        CTreeNode::CLock   NodeLock(pNodeContext);

        if (Fire_onclick(pNodeContext, pMessage ? pMessage->lSubDivision : 0))
        {
            // Bubble clickaction up the parent chain,
            CTreeNode * pNode = pNodeContext;
            while (pNode)
            {
                if (!(pNode->HasLayout() && pNode->Element()->GetAAdisabled()))
                {
                    // we're not a disabled site
                    hr = THR(pNode->Element()->ClickAction(pMessage));
                    if (hr != S_FALSE)
                        break;
                }

                // We need to break if we are called because
                // a label was clicked in case the element is a child
                // of the label. (BUG 19132 - krisma)
                if (ETAG_MAP == pNode->Tag() || fFromLabel == TRUE)
                {
                    //
                    // If we're the map, break out right now, since the associated
                    // IMG has already fired its events.
                    //

                    break;
                }

                if (pNode->Element()->IsRoot())
                {
                    // jump to the master element
                    CElement * pElemMaster = pNode->Element()->MarkupMaster();

                    pNode = (pElemMaster) ? pElemMaster->GetFirstBranch() : NULL;
                }
                else if (pNode->Parent())
                {
                    pNode = pNode->Parent();
                }
                else
                {
                    pNode = pNode->Element()->GetFirstBranch();
                    if(pNode)
                        pNode = pNode->Parent();
                }
            }

            // Propagate error codes from ClickAction, but not S_FALSE
            // because that could confuse callers into thinking that the
            // message was not handled.?
            if (S_FALSE == hr)
                hr = S_OK;
        }
    }

Cleanup:
    RRETURN1(hr, S_FALSE);
}

//+------------------------------------------------------------------------
//
//  Member:     CElement::ClickAction
//
//  Arguments:  pMessage    Message that resulted in the click. NULL when
//                          called by OM method click().
//
//  Synopsis:   Returns S_FALSE if this should bubble up to the parent.
//              Returns S_OK otherwise.
//
//-------------------------------------------------------------------------

HRESULT
CElement::ClickAction(CMessage * pMessage)
{
    return S_FALSE;
}


//+------------------------------------------------------------------------
//
//  Member:     CElement::GetIdentifier
//
//  This fn looks in the current elements' attr array & picks out
// this
//-------------------------------------------------------------------------

LPCTSTR
CElement::GetIdentifier(void)
{
    LPCTSTR             pStr;
    CAttrArray         *pAA;
    
    if ( !IsNamed() )
        return NULL;

    pAA = *GetAttrArray();

    // We're leveraging the fact that we know the dispids of name & ID, & we
    // also have a single _pAA in CElement containing all the attributes
    if (pAA &&
        pAA->HasAnyAttribute() &&
        ((pAA->FindString (STDPROPID_XOBJ_NAME,        &pStr) && pStr) ||
         (pAA->FindString (DISPID_CElement_id,         &pStr) && pStr) ||
          pAA->FindString (DISPID_CElement_uniqueName, &pStr)))
    {
        // This looks dodgy but is safe as long as the return value is treated
        // as a temporary value that is used immediatly, then discarded
        return pStr;
    }
    else
    {
        return NULL;
    }
}


HRESULT
CElement::GetUniqueIdentifier (CStr * pcstr, BOOL fSetWhenCreated /* = FALSE */, BOOL *pfDidCreate /* = NULL */)
{
    HRESULT             hr;
    LPCTSTR             pchUniqueName = GetAAuniqueName();

    if ( pfDidCreate )
        *pfDidCreate = FALSE;

    if (!pchUniqueName)
    {
        CDoc * pDoc = Doc();

        hr = THR(pDoc->GetUniqueIdentifier(pcstr));
        if (hr)
            goto Cleanup;

        if (fSetWhenCreated)
        {
            if ( pfDidCreate )
                *pfDidCreate = TRUE;
            hr = THR(SetUniqueNameHelper(*pcstr));
        }
    }
    else
    {
        hr = THR(pcstr->Set(pchUniqueName));
    }

Cleanup:
    RRETURN(hr);
}

LPCTSTR CElement::GetAAname() const
{
    LPCTSTR     pv;
    CAttrArray *pAA;
    
    if ( !IsNamed() )
        return NULL;

    pAA = *GetAttrArray();

    // We're leveraging the fact that we know the dispids of name & ID, & we
    // also have a single _pAA in CElement containing all the attributes
    if ( pAA && pAA->FindString ( STDPROPID_XOBJ_NAME, &pv) )
    {
        return pv;
    }
    else
    {
        return NULL;
    }
}

BOOL CElement::IsDesignMode ( void )
{
    CDoc *pDoc = Doc();
    return pDoc ? pDoc->_fDesignMode : FALSE;
}

// abstract name property helpers
STDMETHODIMP CElement::put_name(BSTR v)
{
    // If Browse time, setting the name changes the submit name
    if ( IsDesignMode() )
    {
        return s_propdescCElementpropdescname.b.SetStringProperty(v, this, (CVoid *)(void *)(GetAttrArray()));
    }
    else
    {
        return s_propdescCElementsubmitName.b.SetStringProperty(v, this, (CVoid *)(void *)(GetAttrArray()));
    }
}

STDMETHODIMP CElement::get_name(BSTR * p)
{
    // If browse time, get the submit name if set, else get the real name
    if ( IsDesignMode() )
    {
        return s_propdescCElementpropdescname.b.GetStringProperty(p, this, (CVoid *)(void *)(GetAttrArray()));
    }
    else
    {
        RRETURN( SetErrorInfo ( THR( FormsAllocString( GetAAsubmitname(), p ) ) ));
    }
}

LPCTSTR CElement::GetAAsubmitname() const
{
    LPCTSTR             pv;
    CAttrArray         *pAA = *GetAttrArray();

    // We're leveraging the fact that we know the dispids of name & ID, & we
    // also have a single _pAA in CElement containing all the attributes
    if ( pAA )
    {
        if (pAA->FindString ( DISPID_CElement_submitName, &pv) )
        {
            return pv;
        }
        else if ( IsNamed() && pAA->FindString ( STDPROPID_XOBJ_NAME, &pv) )
        {
            return pv;
        }
    }
    return NULL;
}

//+----------------------------------------------------------------------------
//
// Member:      GetBgImgCtx()
//
// Synopsis:    Return the image ctx if the element has a background Image
//
//-----------------------------------------------------------------------------

CImgCtx *
CElement::GetBgImgCtx()
{
    if (g_fHighContrastMode)
        return NULL;        // in high contrast mode there is no background image

    long lCookie = GetFirstBranch()->GetFancyFormat()->_lImgCtxCookie;

    return lCookie ? Doc()->GetUrlImgCtx(lCookie) : NULL;
}

//+---------------------------------------------------------------------------
//
//  Members : the following get_on* and put_on* members are primarily here
//      in order to delegate the assigments to the window.  They are currently
//      mainly used by body and frameset to remap to the window object (Nav
//      compat & consistency).  You should also see GetBaseObjectFor() to see
//      the other place this assignment happens.
//
//      The other half of the work is in the fire_on* code which detects when we
//      are a body, and redirects.
//
//----------------------------------------------------------------------------

HRESULT
CElement:: put_onload(VARIANT v)
{
    CDoc *  pDoc = Doc();
    HRESULT hr = THR(pDoc->EnsureOmWindow());
    if ( hr )
        goto Cleanup;
    hr = THR(pDoc->_pOmWindow->put_onload(v));
Cleanup:
    RRETURN( SetErrorInfo( hr ));
}
HRESULT
CElement:: get_onload(VARIANT *v)
{
    CDoc *  pDoc = Doc();
    HRESULT hr = THR(pDoc->EnsureOmWindow());
    if ( hr )
        goto Cleanup;
    hr = THR(pDoc->_pOmWindow->get_onload(v));
Cleanup:
    RRETURN( SetErrorInfo( hr ));
}


HRESULT
CElement:: put_onunload(VARIANT v)
{
    CDoc *  pDoc = Doc();
    HRESULT hr = THR(pDoc->EnsureOmWindow());
    if ( hr )
        goto Cleanup;
    hr = THR(pDoc->_pOmWindow->put_onunload(v));
Cleanup:
    RRETURN( SetErrorInfo( hr ));
}
HRESULT
CElement:: get_onunload(VARIANT *v)
{
    CDoc *  pDoc = Doc();
    HRESULT hr = THR(pDoc->EnsureOmWindow());
    if ( hr )
        goto Cleanup;
    hr = THR(pDoc->_pOmWindow->get_onunload(v));
Cleanup:
    RRETURN( SetErrorInfo( hr ));
}


STDMETHODIMP
CElement::put_onbeforeunload(VARIANT v)
{
    CDoc *  pDoc = Doc();
    HRESULT hr = THR(pDoc->EnsureOmWindow());
    if ( hr )
        goto Cleanup;

    hr = THR(pDoc->_pOmWindow->put_onbeforeunload(v));
Cleanup:
    RRETURN( SetErrorInfo( hr ));
}

STDMETHODIMP
CElement::get_onbeforeunload(VARIANT * p)
{
    CDoc *  pDoc = Doc();
    HRESULT hr = THR(pDoc->EnsureOmWindow());
    if ( hr )
        goto Cleanup;

    hr = THR(pDoc->_pOmWindow->get_onbeforeunload(p));
Cleanup:
    RRETURN( SetErrorInfo( hr ));
}

STDMETHODIMP
CElement::get_onhelp(VARIANT * p)
{
    HRESULT hr;

    // only delegate if this is body or frameset
    if (Tag()==ETAG_BODY || Tag()==ETAG_FRAMESET)
    {
        CDoc * pDoc = Doc();
        hr = THR(pDoc->EnsureOmWindow());
        if ( hr )
            goto Cleanup;

        hr = THR(pDoc->_pOmWindow->get_onhelp(p));
    }
    else
    {
            hr = THR(s_propdescCElementonhelp.a.HandleCodeProperty(
                    HANDLEPROP_AUTOMATION | (PROPTYPE_VARIANT << 16),
                    p,
                    this,
                    CVOID_CAST(GetAttrArray())));
    }

Cleanup:
    RRETURN(SetErrorInfo( hr));
}
STDMETHODIMP
CElement::put_onhelp(VARIANT v)
{
    HRESULT hr;

    // only delegate if this is body or frameset
    if (Tag()==ETAG_BODY || Tag()==ETAG_FRAMESET)
    {
        CDoc * pDoc = Doc();
        hr = THR(pDoc->EnsureOmWindow());
        if ( hr )
            goto Cleanup;

        hr = THR(pDoc->_pOmWindow->put_onhelp(v));
    }
    else
    {
        hr = THR(s_propdescCElementonhelp.a.HandleCodeProperty(
                    HANDLEPROP_SET | HANDLEPROP_AUTOMATION |
                    (PROPTYPE_VARIANT << 16),
                    &v,
                    this,
                    CVOID_CAST(GetAttrArray())));
    }

Cleanup:
    RRETURN(SetErrorInfo( hr ));
}


HRESULT
CElement:: put_onblur(VARIANT v)
{
    HRESULT hr = E_FAIL;

    // anchors and areas override this, body & frameset delgate, all
    // other cases just go into the scite propdesc for now.. .since
    // those are the only elements that currently have this defined
    if ((Tag() == ETAG_BODY) || Tag() == ETAG_FRAMESET)
    {
        CDoc * pDoc = Doc();
        hr = THR(pDoc->EnsureOmWindow());
        if ( hr )
            goto Cleanup;

        hr = THR(pDoc->_pOmWindow->put_onblur(v));
    }
    else
    {
        hr = THR(s_propdescCElementonblur.a.HandleCodeProperty(
                 HANDLEPROP_SET | HANDLEPROP_AUTOMATION | (PROPTYPE_VARIANT << 16),
                 &v,
                 this,
                 CVOID_CAST(GetAttrArray())));
    }

Cleanup:
    RRETURN( SetErrorInfo( hr ));
}
HRESULT
CElement:: get_onblur(VARIANT *v)
{
    HRESULT hr = E_FAIL;

    // anchors and areas override this, body & frameset delgate, all
    // other cases just go into the scite propdesc for now.. .since
    // those are the only elements that currently have this defined
    if ((Tag() == ETAG_BODY) || Tag() == ETAG_FRAMESET)
    {
        CDoc *pDoc = Doc();
        hr = THR(pDoc->EnsureOmWindow());
        if ( hr )
            goto Cleanup;

        hr = THR(pDoc->_pOmWindow->get_onblur(v));
    }
    else
    {
        hr = THR(s_propdescCElementonblur.a.HandleCodeProperty(
                HANDLEPROP_AUTOMATION | (PROPTYPE_VARIANT << 16),
                v,
                this,
                CVOID_CAST(GetAttrArray())));
    }

Cleanup:
    RRETURN( SetErrorInfo( hr ));
}


HRESULT
CElement:: put_onfocus(VARIANT v)
{
    HRESULT hr=E_FAIL;

    // anchors and areas override this, body & frameset delgate, all
    // other cases just go into the scite propdesc for now.. .since
    // those are the only elements that currently have this defined
    if ((Tag() == ETAG_BODY) || Tag() == ETAG_FRAMESET)
    {
        CDoc *pDoc = Doc();
        hr = THR(pDoc->EnsureOmWindow());
        if ( hr )
            goto Cleanup;

        hr = THR(pDoc->_pOmWindow->put_onfocus(v));
    }
    else
    {
        hr = THR(s_propdescCElementonfocus.a.HandleCodeProperty(
            HANDLEPROP_SET | HANDLEPROP_AUTOMATION | (PROPTYPE_VARIANT << 16),
            &v,
            this,
            CVOID_CAST(GetAttrArray())));
    }

Cleanup:
    RRETURN( SetErrorInfo( hr ));
}
HRESULT
CElement:: get_onfocus(VARIANT *v)
{
    HRESULT hr = E_FAIL;

    // anchors and areas override this, body & frameset delgate, all
    // other cases just go into the scite propdesc for now.. .since
    // those are the only elements that currently have this defined
    if ((Tag() == ETAG_BODY) || Tag() == ETAG_FRAMESET)
    {
        CDoc * pDoc = Doc();
        hr = THR(pDoc->EnsureOmWindow());
        if ( hr )
            goto Cleanup;

        hr = THR(pDoc->_pOmWindow->get_onfocus(v));
    }
    else
    {
        hr = THR(s_propdescCElementonfocus.a.HandleCodeProperty(
            HANDLEPROP_AUTOMATION | (PROPTYPE_VARIANT << 16),
            v,
            this,
            CVOID_CAST(GetAttrArray())));
    }

Cleanup:
    RRETURN( SetErrorInfo( hr ));
}

// NOTE (lmollico): These are print events, implemented
// on CElement only for the body and frameset elements

STDMETHODIMP
CElement::put_onbeforeprint(VARIANT v)
{
    CDoc *  pDoc = Doc();
    HRESULT hr = THR(pDoc->EnsureOmWindow());
    if ( hr )
        goto Cleanup;

    hr = THR(pDoc->_pOmWindow->put_onbeforeprint(v));
Cleanup:
    RRETURN( SetErrorInfo( hr ));
}

STDMETHODIMP
CElement::get_onbeforeprint(VARIANT * p)
{
    CDoc *  pDoc = Doc();
    HRESULT hr = THR(pDoc->EnsureOmWindow());
    if ( hr )
        goto Cleanup;

    hr = THR(pDoc->_pOmWindow->get_onbeforeprint(p));
Cleanup:
    RRETURN( SetErrorInfo( hr ));
}

STDMETHODIMP
CElement::put_onafterprint(VARIANT v)
{
    CDoc *  pDoc = Doc();
    HRESULT hr = THR(pDoc->EnsureOmWindow());
    if ( hr )
        goto Cleanup;

    hr = THR(pDoc->_pOmWindow->put_onafterprint(v));
Cleanup:
    RRETURN( SetErrorInfo( hr ));
}

STDMETHODIMP
CElement::get_onafterprint(VARIANT * p)
{
    CDoc *  pDoc = Doc();
    HRESULT hr = THR(pDoc->EnsureOmWindow());
    if ( hr )
        goto Cleanup;

    hr = THR(pDoc->_pOmWindow->get_onafterprint(p));
Cleanup:
    RRETURN( SetErrorInfo( hr ));
}

//+----------------------------------------------------
//
//  member : get_offsetTop, IHTMLElement
//
//  synopsis : returns the top, coordinate of the
//      element
//
//-----------------------------------------------------

HRESULT
CElement::get_offsetTop ( long *plValue )
{
    HRESULT         hr = S_OK;

    if (!plValue)
    {
        hr = E_POINTER;
    }
    else if(!IsInMarkup() || !Doc()->GetView()->IsActive())
    {
        *plValue = 0;
    }
    else
    {
        *plValue = 0;

        switch (_etag)
        {
        case ETAG_MAP :
            break;

        case ETAG_AREA:
            {
                RECT rectBound;
                DYNCAST(CAreaElement, this)->GetBoundingRect(&rectBound);
                *plValue = rectBound.top;
            }
            break;

        default :
            {
                POINT pt;
                SendNotification(NTYPE_ELEMENT_ENSURERECALC);
                hr = THR(GetElementTopLeft(pt));
               *plValue = pt.y;
            }
            break;
        }
    }

    RRETURN(SetErrorInfo(hr));
}



//+----------------------------------------------------
//
//  member : get_OffsetLeft, IHTMLElement
//
//  synopsis : returns the left coordinate of the
//      element
//
//-----------------------------------------------------

HRESULT
CElement::get_offsetLeft ( long *plValue )
{
    HRESULT       hr = S_OK;

    if (!plValue)
    {
        hr = E_POINTER;
    }
    else if(!IsInMarkup() || !Doc()->GetView()->IsActive())
    {
        *plValue = 0;
    }
    else
    {
        // (paulnel) Are we right to left? If so, we need to convert the offset left
        // amount, that will be a negative value from the parent's top right, to a 
        // positive offset from the parent's top left. To do this we will
        // use the formula "left = parent.width + left"
        CTreeNode * pNodeContext = GetFirstBranch();
        CTreeNode * pNodeParent = NULL;
        long cxParent = 0;
        BOOL fRTL = FALSE;
        if (pNodeContext->GetUpdatedNearestLayout())
        {
            pNodeParent = (NeedsLayout())
                                ? pNodeContext->ZParentBranch()
                                : pNodeContext->GetUpdatedNearestLayoutNode();

            fRTL = (pNodeParent != NULL && pNodeParent->GetCharFormat()->_fRTL);

            if (fRTL)
            {
                CLayout* pLayoutParent = pNodeParent->GetUpdatedNearestLayout();

                // if we have scroll bars, we need to take of the size of the scrolls.
                Assert(pLayoutParent);
                if(pLayoutParent && 
                   pLayoutParent->GetElementDispNode() &&
                   pLayoutParent->GetElementDispNode()->IsScroller())
                {
                    CRect rcClient;
                    pLayoutParent->GetClientRect(&rcClient);
                    cxParent = rcClient.Width();
                }
                else
                {
                    CElement* pElemParent;
                    CSize sizeParent;

                    pElemParent = pNodeParent->Element();
                    Assert(pElemParent && pElemParent != this);
                    if(pElemParent)
                    {
                        pElemParent->GetBoundingSize(sizeParent);
                        cxParent = sizeParent.cx;
                    }
                }
            }
        }
        
        *plValue = 0;
        switch (_etag)
        {
        case ETAG_MAP :
            break;

        case ETAG_AREA:
            {
                RECT rectBound;
                DYNCAST(CAreaElement, this)->GetBoundingRect(&rectBound);

                // convert for Right To Left elements
                if(fRTL)
                    rectBound.left += cxParent;

                *plValue = rectBound.left;
            }
            break;

        default :
            {
                POINT pt;
                SendNotification(NTYPE_ELEMENT_ENSURERECALC);
                hr = THR(GetElementTopLeft(pt));

                // convert for Right To Left elements
                if(fRTL)
                    pt.x += cxParent;

                *plValue = pt.x;
            }
            break;
        }

    }

    RRETURN(SetErrorInfo(hr));
}

// helper function for offset left and top
HRESULT
CElement::GetElementTopLeft(POINT & pt)
{
    HRESULT hr = S_OK;

    pt = g_Zero.pt;

    if (IsInMarkup())
    {
        Assert(GetFirstBranch());

        CLayout *   pLayout = GetUpdatedNearestLayout();

        if (pLayout)
        {
            if (HasLayout())
            {
                pLayout->GetPosition(&pt);

                // if we are a table, then adjust for a captaion and table borders.
                //---------------------------------------------------------------
                if (   (Tag() == ETAG_TD)
                    || (Tag() == ETAG_TH))
                {
                    CTableCellLayout *   pCellLayout  = (CTableCellLayout *)pLayout;
                    CTableLayout * pTableLayout = pCellLayout->TableLayout();
                    if (pTableLayout)
                    {
                        CDispNode * pGridNode = pTableLayout->GetTableInnerDispNode();
                        if (     pCellLayout->_pDispNode 
                             && (pCellLayout->_pDispNode->GetParentNode() == pGridNode))
                        {
                            // if cell is positioned or lives inside of the positioned row - do nothing.
                            if (pTableLayout->_pDispNode != pGridNode)
                            {
                                // if table has a caption and as a result GridNode and the Table Display Node is 
                                // not the same, we need to offset the cell by the caption height and the table border
                                CSize       offsetTableOuterDispNode = (CSize&)g_Zero.size;
                                pGridNode->GetTransformOffset(&offsetTableOuterDispNode, COORDSYS_CONTENT, COORDSYS_PARENT);
                                pt.x += offsetTableOuterDispNode.cx;
                                pt.y += offsetTableOuterDispNode.cy;
                            }
                            else
                            {
                                // need to offset the cell by the border width
                                if (pGridNode->HasBorder())
                                {
                                    RECT rcBorderWidths;
                                    pGridNode->GetBorderWidths(&rcBorderWidths);
                                    pt.x += rcBorderWidths.left;
                                    pt.y += rcBorderWidths.top;
                                }
                            }
                        }
                    }
                }
                else if (!pLayout->ElementOwner()->IsAbsolute())
                {
                    // Absolutely positined elements are already properly reporting their position
                    //
                    // we are not a TD/TH, but our PARENT might be!
                    // if we are in a table cell, then we need to adjust for the cell insets,
                    // in case the content is vertically aligned.
                    //-----------------------------------------------------------
                    CLayout *pParentLayout = pLayout->GetUpdatedParentLayout();

                    if (   pParentLayout 
                        && (   (pParentLayout->Tag() == ETAG_TD) 
                            || (pParentLayout->Tag() == ETAG_TH) 
                            || (pParentLayout->Tag() == ETAG_CAPTION) ))
                    {
                        CDispNode * pDispNode = pParentLayout->GetElementDispNode();

                        if (pDispNode && pDispNode->HasInset())
                        {
                            const CSize & sizeInset = pDispNode->GetInset();
                            pt.x += sizeInset.cx;
                            pt.y += sizeInset.cy;
                        }
                    }

                }
            }
            else
            {
                hr = THR(pLayout->GetChildElementTopLeft(pt, this));
            }
        }
    }

    RRETURN(hr);
}



//+----------------------------------------------------
//
//  member : GetInheritedBackgroundColor
//
//  synopsis : returns the actual background color
//
//-----------------------------------------------------

COLORREF
CElement::GetInheritedBackgroundColor(CTreeNode * pNodeContext /* = NULL */)
{
    CColorValue ccv;

    IGNORE_HR(GetInheritedBackgroundColorValue(&ccv, pNodeContext));

    return ccv.GetColorRef();
}


//+----------------------------------------------------
//
//  member : GetInheritedBackgroundColorValue
//
//  synopsis : returns the actual background color as a CColorValue
//
//-----------------------------------------------------

HRESULT
CElement::GetInheritedBackgroundColorValue(CColorValue *pVal, CTreeNode * pNodeContext /* = NULL */ )
{
    HRESULT     hr = S_OK;
    CTreeNode * pNode = pNodeContext ? pNodeContext : GetFirstBranch();

    if(!pNode)
    {
        hr = E_FAIL;
        goto Cleanup;
    }

    Assert(pVal != NULL);

    do
    {
        *pVal   = pNode->GetFancyFormat()->_ccvBackColor;
        pNode = pNode->Parent();
    }
    while (!pVal->IsDefined() && pNode);

    // The root site should always have a background color defined.
    Assert(pVal->IsDefined());

Cleanup:
    RRETURN(hr);
}


//+------------------------------------------------------------
//
//  member  :   get_offsetWidth,  IHTMLElement
//
//  Synopsis:   Get the calculated height in doc units. if *this*
//          is a site then just return based on the size
//          if it is an element, then we need to get the regions
//          of its parts and add it up.
//
//-------------------------------------------------------------

HRESULT
CElement::get_offsetWidth ( long *plValue )
{
    HRESULT hr = S_OK;
    SIZE    size;

    if (!plValue)
    {
        hr = E_POINTER;
    }
    else if (IsInMarkup() && Doc()->GetView()->IsActive())
    {
        GetBoundingSize(size);

        *plValue = size.cx;
    }
    else
    {
        *plValue = 0;
    }

    RRETURN(SetErrorInfo(hr));
}

//+------------------------------------------------------------
//
//  member  :   get_offsetHeight,  IHTMLElement
//
//  Synopsis:   Get the calculated height in doc units. if *this*
//          is a site then just return based on the size
//          if it is an element, then we need to get the regions
//          of its parts and add it up.
//
//-------------------------------------------------------------

HRESULT
CElement::get_offsetHeight ( long *plValue )
{
    HRESULT hr = S_OK;
    SIZE    size;

    if (!plValue)
    {
        hr = E_POINTER;
    }
    else if (IsInMarkup() && Doc()->GetView()->IsActive())
    {
        GetBoundingSize(size);

        *plValue = size.cy;
    }
    else
    {
        *plValue = 0;
    }

    RRETURN(SetErrorInfo( hr ));
}

// helper function for offset height and width
void
CElement::GetBoundingSize(SIZE & sizeBounds)
{
    CRect       rcBound;

    sizeBounds.cx=0;
    sizeBounds.cy=0;

    GetBoundingRect(&rcBound);

    sizeBounds = rcBound.Size();
}


//+----------------------------------------------------
//
//  member : get_offsetParent, IHTMLElement
//
//  synopsis : returns the parent container (site) which
//      defines the coordinate system of the offset*
//      properties above.
//              returns NULL when no parent makes sense
//
//-----------------------------------------------------

HRESULT
CElement::get_offsetParent (IHTMLElement ** ppIElement)
{
    HRESULT  hr = S_OK;
    CTreeNode * pNodeContext = GetFirstBranch();
    CTreeNode * pNodeRet = NULL;

    if (!ppIElement)
    {
        hr = E_POINTER;
        goto Cleanup;
    }
    else if(!GetFirstBranch())
    {
        hr = E_FAIL;
        goto Cleanup;
    }

    *ppIElement= NULL;

    switch( _etag)
    {

    case ETAG_BODY:
    case ETAG_MAP :
        // return NULL. Maps don't necessarily have a parent
        break;

    case ETAG_AREA:
        // the area's parent is the map
        if (pNodeContext->Parent())
        {
            pNodeRet = pNodeContext->Parent();
        }
        break;

    case ETAG_TD:
    case ETAG_TH:
        if (pNodeContext->GetUpdatedNearestLayout())
        {
            pNodeRet = (NeedsLayout())
                                ? pNodeContext->ZParentBranch()
                                : pNodeContext->GetUpdatedNearestLayoutNode();

            if (pNodeRet && pNodeRet->IsPositionStatic())
            {
                // return pNodeRet's parent
                pNodeRet = pNodeRet->ZParentBranch();
                Assert(pNodeRet && pNodeRet->Tag()==ETAG_TABLE);

            }
        }
        break;

    default:
        if (pNodeContext->GetUpdatedNearestLayout())
        {
            // If this changes, make sure to update GetElementTopLeft()
            pNodeRet = (NeedsLayout())
                                ? pNodeContext->ZParentBranch()
                                : pNodeContext->GetUpdatedNearestLayoutNode();

        }
        break;
    }


    if (pNodeRet &&
        pNodeRet->Tag() != ETAG_ROOT)
    {
        hr = THR( pNodeRet->GetElementInterface( IID_IHTMLElement, (void**) ppIElement ) );
    }

Cleanup:
    RRETURN(SetErrorInfo( hr ));
}

//+-------------------------------------------------------------------------------
//
//  Member:     componentFromPoint
//
//  Synopsis:   Base Implementation of the automation interface IHTMLELEMENT2 method.
//              This method returns none, meaning no component is hit, and is here
//              for future expansion when the component list includes borders and
//              margins and such.
//              Currently, only scrollbar components are implemented, so there is an
//              overriding implementation in CLayout which handles the hit testing
//              against the scrollbar, and determines which component is hit.
//
//+-------------------------------------------------------------------------------
STDMETHODIMP
CElement::componentFromPoint( long x, long y, BSTR * pbstrComponent)
{
    HRESULT       hr;
    WORD          eComp = htmlComponentOutside;

    if (!pbstrComponent)
    {
        hr = E_POINTER;
        goto Cleanup;
    }

    if (HasLayout())
    {
        eComp = GetUpdatedLayout()->ComponentFromPoint(x, y);
    }

    // if we already know what we have, return
    if (eComp == htmlComponentOutside)
    {
        CTreeNode *pNodeElement;
        HTC        htc;
        CMessage   msg;

        msg.pt.x = x;
        msg.pt.y = y;

        // is this point over us?
        htc = Doc()->HitTestPoint(&msg, &pNodeElement, HT_VIRTUALHITTEST);


        if (htc == HTC_NO)
        {
            eComp = htmlComponentOutside;
        }
        else
        {
            // if we are in design mode, worry about grab handles, but only
            // if this element is the current one.   but since these HTC's
            // don't get returned unless we are in debug mode this is fine
            // to test straight.
            switch (htc)
            {
            case HTC_TOPLEFTHANDLE :
                eComp = htmlComponentGHTopLeft;
                break;

            case HTC_LEFTHANDLE :
                eComp = htmlComponentGHLeft;
                break;

            case HTC_TOPHANDLE :
                eComp = htmlComponentGHTop;
                break;

            case HTC_BOTTOMLEFTHANDLE :
                eComp = htmlComponentGHBottomLeft;
                break;

            case HTC_TOPRIGHTHANDLE :
                eComp = htmlComponentGHTopRight;
                break;

            case HTC_BOTTOMHANDLE :
                eComp = htmlComponentGHBottom;
                break;

            case HTC_RIGHTHANDLE :
                eComp = htmlComponentGHRight;
                break;

            case HTC_BOTTOMRIGHTHANDLE :
                eComp = htmlComponentGHBottomRight;
                break;

            default:
                // do nothing
                if (this == pNodeElement->Element())
                    eComp = htmlComponentClient;
                break;
            }
        }
    }

    hr = THR( STRINGFROMENUM( htmlComponent, eComp, pbstrComponent));

Cleanup:
    RRETURN(SetErrorInfo( hr ));
}


//+-------------------------------------------------------------------------------
//
//  Member:     doScroll
//
//  Synopsis:   Implementation of the automation interface method.
//              this simulates a click on the particular component of the scrollbar
//              (if this txtsite has one)
//
//+-------------------------------------------------------------------------------
STDMETHODIMP
CElement::doScroll( VARIANT varComponent)
{
    HRESULT       hr = E_PENDING;
    htmlComponent eComp;
    int           iDir;
    WORD          wComp;
    CVariant      varCompStr;
    CLayout *     pLayout       = GetUpdatedLayout();
    CDoc *        pDoc = Doc();

    SendNotification(NTYPE_ELEMENT_ENSURERECALC);

    //
    // don't scroll if we are still loading the page or not UIActive
    if (pDoc->IsLoading() || pDoc->State() < OS_INPLACE)
        goto Cleanup;

    //
    // the paramter is optional, and if nothing was provide then use the defualt
    hr = THR(varCompStr.CoerceVariantArg(&varComponent, VT_BSTR));
    if ( hr == S_OK )
    {
        if (!SysStringLen(V_BSTR(&varCompStr)))
            eComp = htmlComponentSbPageDown;
        else
        {
            hr = THR( ENUMFROMSTRING( htmlComponent,
                                  V_BSTR(&varCompStr),
                                  (long *) &eComp) );
            if (hr)
                goto Cleanup;
        }
    }
    else if ( hr == S_FALSE )
    {
        // when no argument
        eComp = htmlComponentSbPageDown;
        hr = S_OK;
    }
    else
        goto Cleanup;


    // no that we know what we are doing, initialize the parametes for
    // the onscroll helper fx
    switch (eComp) {
    case htmlComponentSbLeft :
    case htmlComponentSbLeft2:
        iDir = 0;
        wComp = SB_LINELEFT;
        break;
    case htmlComponentSbPageLeft :
    case htmlComponentSbPageLeft2:
        iDir = 0;
        wComp = SB_PAGELEFT;
        break;
    case htmlComponentSbPageRight :
    case htmlComponentSbPageRight2:
        iDir = 0;
        wComp = SB_PAGERIGHT;
        break;
    case htmlComponentSbRight :
    case htmlComponentSbRight2:
        iDir = 0;
        wComp = SB_LINERIGHT;
        break;
    case htmlComponentSbUp :
    case htmlComponentSbUp2:
        // equivalent to up arrow
        iDir = 1;
        wComp = SB_LINEUP;
        break;
    case htmlComponentSbPageUp :
    case htmlComponentSbPageUp2:
        iDir = 1;
        wComp = SB_PAGEUP;
        break;
    case htmlComponentSbPageDown :
    case htmlComponentSbPageDown2:
        iDir = 1;
        wComp = SB_PAGEDOWN;
        break;
    case htmlComponentSbDown :
    case htmlComponentSbDown2:
        iDir = 1;
        wComp = SB_LINEDOWN;
        break;
    case htmlComponentSbTop:
        iDir = 1;
        wComp = SB_TOP;
        break;
    case htmlComponentSbBottom:
        iDir = 1;
        wComp = SB_BOTTOM;
        break;
    default:
        // nothing to do in this case.  hr is S_OK
        goto Cleanup;

    }

    //  Send the request to the layout, if any
    if (pLayout)
    {
        hr = THR(pLayout->OnScroll(iDir, wComp, 0));
    }

Cleanup:
    RRETURN( SetErrorInfo( hr ) );
}

//+----------------------------------------------------------------------------
//
//  Member:     CElement::Fire_onpropertychange
//
//  Synopsis:   Fires the onpropertychange event, sets up the event param
//
//+----------------------------------------------------------------------------

void
CElement::Fire_onpropertychange(LPCTSTR strPropName)
{
    EVENTPARAM param(Doc(), TRUE);

    param.SetType(_T("propertychange"));
    param.SetPropName(strPropName);
    param.SetNodeAndCalcCoordinates(GetFirstBranch());

    FireEventHelper(DISPID_EVMETH_ONPROPERTYCHANGE,
                 DISPID_EVPROP_ONPROPERTYCHANGE,
                 (BYTE *) VTS_NONE);

}


//+----------------------------------------------------------------------------
//
//  Member:     CElement::Fire_PropertyChangeHelper
//
//  Synopsis:   Fires the onpropertychange event, sets up the event param
//
//+----------------------------------------------------------------------------
HRESULT
CElement::Fire_PropertyChangeHelper(DISPID dispid, DWORD dwFlags)
{
    BSTR          strName = NULL;
    PROPERTYDESC *ppropdesc;
    DISPID expDispid;

    // first, find the appropriate propdesc for this property.
    if (dwFlags & ELEMCHNG_INLINESTYLE_PROPERTY)
    {
        CBase *pStyleObj = GetInLineStylePtr();

        if (pStyleObj)
        {
            CBufferedStr cBuf;

            cBuf.Set( (dwFlags & ELEMCHNG_INLINESTYLE_PROPERTY) ? 
                _T("style.") : 
                _T("runtimeStyle."));
            // if we still can't find it, or have no inline
            // then bag this, and continue
            if (S_OK == pStyleObj->FindPropDescFromDispID(dispid,
                                                             &ppropdesc,
                                                             NULL,
                                                             NULL))
            {

                cBuf.QuickAppend((ppropdesc->pstrExposedName)?
                                    ppropdesc->pstrExposedName :
                                    ppropdesc->pstrName);
                strName = SysAllocString(cBuf);
            }
            else if (IsExpandoDISPID(dispid, &expDispid))
            {
                LPCTSTR pszName;
                if (S_OK == pStyleObj->GetExpandoName(expDispid, &pszName))
                {
                    cBuf.QuickAppend(pszName);
                    strName = SysAllocString(cBuf);
                }
            }
        }
    }
    else
    {
        HRESULT     hr2;

        hr2 = THR_NOTRACE(GetMemberName(dispid, &strName));
        if (hr2)
        {
            strName = NULL;
        }
    }

    // we have a property name, and can fire the event
    if (strName)
    {
        Fire_onpropertychange(strName);
        SysFreeString(strName);
    }

    return S_OK;
}




CDragStartInfo::CDragStartInfo(CElement *pElementDrag, DWORD dwStateKey, IUniformResourceLocator * pUrlToDrag)
{
    _pElementDrag = pElementDrag;
    _pElementDrag->SubAddRef();
    _dwStateKey = dwStateKey;
    _pUrlToDrag = pUrlToDrag;
    if (_pUrlToDrag)
        _pUrlToDrag->AddRef();
    _dwEffectAllowed = DROPEFFECT_UNINITIALIZED;
}

CDragStartInfo::~CDragStartInfo()
{
    _pElementDrag->SubRelease();
    ReleaseInterface(_pUrlToDrag);
    ReleaseInterface(_pDataObj);
    ReleaseInterface(_pDropSource);
}

HRESULT
CDragStartInfo::CreateDataObj()
{
    CLayout * pLayout = _pElementDrag->GetUpdatedNearestLayout();

    if (!pLayout)
    {
        CMarkup * pMarkup = _pElementDrag->GetMarkup();

        if (pMarkup->Master())
            pLayout = pMarkup->Master()->GetUpdatedLayout();
    }

    RRETURN(pLayout ? pLayout->DoDrag(_dwStateKey, _pUrlToDrag, TRUE) : E_FAIL);
}


//+----------------------------------------------------------------------------
//
//  Member:     CElement::DragElement
//
//  Synopsis:   calls Fire_ondragstart then executes DoDrag on the
//              layout
//
//-----------------------------------------------------------------------------
BOOL
CElement::DragElement(CLayout *                 pLayout,
                      DWORD                     dwStateKey,
                      IUniformResourceLocator * pUrlToDrag,
                      long                      lSubDivision)
{
    CTreeNode::CLock  Lock(GetFirstBranch());
    BOOL fRet = FALSE;
    CDoc * pDoc = Doc();

    Assert(!pDoc->_pDragStartInfo);
    pDoc->_pDragStartInfo = new CDragStartInfo(this, dwStateKey, pUrlToDrag);

    if (!pDoc->_pDragStartInfo)
        goto Cleanup;

    fRet = Fire_ondragstart(NULL, lSubDivision);

    if (!GetFirstBranch())
    {
        fRet = FALSE;
        goto Cleanup;
    }

    if (fRet)
    {
        Assert(pLayout->ElementOwner()->IsInMarkup());
        IGNORE_HR(pLayout->DoDrag(dwStateKey, pUrlToDrag));
    }

Cleanup:
    if (pDoc->_pDragStartInfo)
    {
        delete pDoc->_pDragStartInfo;
        pDoc->_pDragStartInfo = NULL;
    }
    return fRet;
}

//+----------------------------------------------------------------------------
//
//  Member:     CElement::Fire_ondragenterover
//
//  Synopsis:   Fires the ondragenter or ondragover event, sets up the event param
//              and returns the dropeffect
//
//+----------------------------------------------------------------------------

BOOL
CElement::Fire_ondragHelper(
    long lSubDivision,
    DISPID dispidEvent,
    DISPID dispidProp,
    LPCTSTR pchType,
    DWORD * pdwDropEffect)
{
    EVENTPARAM param(Doc(), TRUE);
    CVariant   vb;
    BOOL fRet;
    CTreeNode *pNodeContext = GetFirstBranch();

    Assert(pdwDropEffect);

    param.dwDropEffect = *pdwDropEffect;

    param.SetNodeAndCalcCoordinates(pNodeContext);
    param.SetType(pchType);

    BubbleEventHelper(
        pNodeContext,
        lSubDivision,
        dispidEvent,
        dispidProp,
        FALSE,
        &vb,
        (BYTE *) VTS_NONE);

    fRet = !param.IsCancelled() && (V_VT(&vb) == VT_EMPTY || VB_TRUE == V_BOOL(&vb));

    if (!fRet)
        *pdwDropEffect = param.dwDropEffect;

    return fRet;
}

//+----------------------------------------------------------------------------
//
//  Member:     CElement::Fire_ondragend
//
//  Synopsis:   Fires the ondragend event
//
//+----------------------------------------------------------------------------
void
CElement::Fire_ondragend(long lSubDivision, DWORD dwDropEffect)
{
    EVENTPARAM param(Doc(), TRUE);
    CTreeNode *pNodeContext = GetFirstBranch();

    param.dwDropEffect = dwDropEffect;

    param.SetNodeAndCalcCoordinates(pNodeContext);
    param.SetType(_T("dragend"));

    BubbleEventHelper(
        pNodeContext,
        lSubDivision,
        DISPID_EVMETH_ONDRAGEND,
        DISPID_EVPROP_ONDRAGEND,
        FALSE,
        NULL,
        (BYTE *) VTS_NONE);
}

//+----------------------------------------------------------------------------
//
//  Member:     CElement::Fire_ondatasetX
//
//  Synopsis:   Helper to fire ondata* events (ondatasetchanged, ondataavailable,
//              and ondatasetcomplete)
//
//  Returns:    TRUE: Take default action, FALSE: Don't take default action
//
//-----------------------------------------------------------------------------

HRESULT
CElement::Fire_ondatasetX(LPTSTR pchQualifier, long lReason, DISPID dispidEvent,
                          DISPID dispidProp)
{
    CTreeNode * pNodeContext = GetFirstBranch();
    CLayout   * pLayout      = pNodeContext->GetUpdatedNearestLayout();
    HRESULT     hr           = S_OK;

    if (pLayout)
    {

        CDoc *          pDoc = Doc();
        EVENTPARAM      param(pDoc, TRUE);

        CDoc::CLock Lock(pDoc);

        param.SetNodeAndCalcCoordinates(pNodeContext);
        param.SetQualifier(pchQualifier);
        param._lReason = lReason;

        hr =  THR(BubbleEventHelper(
                    pNodeContext,
                    0,
                    dispidEvent,
                    dispidProp,
                    FALSE,
                    NULL,
                    (BYTE *) VTS_NONE));
    }

    return hr;
}



//+-----------------------------------------------------------------
//
//  member : CElement::getBoundingClientRect() - External method
//
//  Synopsis:   Returns Bounding rect of the text under element's
//              influence in client coordinates
//------------------------------------------------------------------

HRESULT
CElement::getBoundingClientRect(IHTMLRect **ppIRect)
{
    HRESULT             hr = S_OK;
    CRect               Rect;
    COMRect           * pOMRect = NULL;

    if (!ppIRect)
    {
        hr = E_POINTER;
        goto Cleanup;
    }
    *ppIRect = NULL;

    hr = THR(GetBoundingRect(&Rect, RFE_SCREENCOORD));
    if (hr)
        goto Cleanup;

    // Create the rectangle object
    pOMRect = new COMRect(&Rect);
    if (!pOMRect)
    {
        hr = E_OUTOFMEMORY;
        goto Cleanup;
    }

    // Return  rectangle
    *ppIRect = (IHTMLRect *) pOMRect;

Cleanup:
    RRETURN(SetErrorInfo(hr));
}


//+-----------------------------------------------------------------
//
//  member : CElement::GetBoundingRect
//
//  Synopsis:   Get the region corresponding to the element
//
//  Arguments:  pRect   - bounding rect of the element
//              dwFlags - flags to control the coordinate system
//                        the rect.
//                        0 - returns the region relative to the
//                            parent content
//                        RFE_SCREENCOORD - window/document/global
//
//------------------------------------------------------------------

HRESULT
CElement::GetBoundingRect(CRect *pRect, DWORD dwFlags)
{
    HRESULT         hr      = S_OK;
    CTreeNode *     pNode   = GetFirstBranch();
    CDataAry<RECT>  aryRects(Mt(CElementGetBoundingRect_aryRects_pv));

    Assert(pRect);
    pRect->SetRectEmpty();

    if (!pNode)
    {
        hr = E_FAIL;
        goto Cleanup;
    }

    GetElementRegion(&aryRects, pRect, dwFlags);

Cleanup:
    RRETURN(SetErrorInfo(hr));
}

//+-----------------------------------------------------------------
//
//  Member :    CElement::GetElementRegion
//
//  Synopsis:   Get the region corresponding to the element
//
//  Arguments:  paryRects - array to hold the rects corresponding to
//                          region
//              dwFlags   - flags to control the coordinate system
//                          the rects are returned in.
//                          0 - returns the region relative to the
//                              parent content
//                          RFE_SCREENCOORD - window/document/global
//
//------------------------------------------------------------------

void
CElement::GetElementRegion(CDataAry<RECT> * paryRects, RECT * prcBound, DWORD dwFlags)
{
    CRect   rect;
    BOOL    fAppendRect = FALSE;

    if(!prcBound)
        prcBound = &rect;

    // make sure that current is calced
    SendNotification(NTYPE_ELEMENT_ENSURERECALC);

    // BUGBUG (MohanB) The top-left corner is set to (0,0) because
    // we don't know the context, i.e. the image to which this MAP
    // or AREA is bound.
    switch (Tag())
    {
    case ETAG_MAP :
        DYNCAST(CMapElement, this)->GetBoundingRect(prcBound);
        fAppendRect = TRUE;
        break;

    case ETAG_AREA:
        DYNCAST(CAreaElement, this)->GetBoundingRect(prcBound);
        fAppendRect = TRUE;
        break;

    case ETAG_OPTION:
        *prcBound = g_Zero.rc;
        fAppendRect = TRUE;
        break;

    case ETAG_HTML:
        {
            CSize  size;

            Doc()->GetView()->GetViewSize(&size);
            prcBound->top =
            prcBound->left = 0;
            prcBound->right = size.cx;
            prcBound->bottom = size.cy;

            fAppendRect = TRUE;
        }
        break;

    default:
        {
            CLayout * pLayout = GetUpdatedNearestLayout();

            if (pLayout)
            {
                // Get the array that contains bounding rects for each line of the text
                // We want to account for aligned content contained within the element
                // when computing the region.
                dwFlags |= RFE_ELEMENT_RECT;
                pLayout->RegionFromElement(this, paryRects, prcBound, dwFlags);
            }
        }
        break;
    }

    if(fAppendRect)
    {
        paryRects->AppendIndirect((RECT *)prcBound);
    }
}

//+-----------------------------------------------------------------
//
//  member : CElement::getClientRects() - External method
//
//  Synopsis:   Returns the collection of rectangles for the text under
//               element's influence in client coordinates.
//              Each rectangle represents a line of text on the screen.
//------------------------------------------------------------------

HRESULT
CElement::getClientRects(IHTMLRectCollection **ppIRects)
{
    HRESULT              hr;
    COMRectCollection  * pOMRectCollection;
    CDataAry<RECT>       aryRects(Mt(CElementgetClientRects_aryRects_pv));
    CTreeNode          * pNode;

    if (!ppIRects)
    {
        hr = E_POINTER;
        goto Cleanup;
    }

    *ppIRects = NULL;

    pNode = GetFirstBranch();
    if(!pNode)
    {
        hr = E_FAIL;
        goto Cleanup;
    }

    GetElementRegion(&aryRects, NULL, RFE_SCREENCOORD);

    // Create a rectangle collection class instance
    pOMRectCollection = new COMRectCollection();
    if (!pOMRectCollection)
    {
        hr = E_OUTOFMEMORY;
        goto Cleanup;
    }

    // Fill the collection with values from aryRects
    hr = THR(pOMRectCollection->SetRects(&aryRects));
    if(hr)
        goto Cleanup;

    // Return  rectangle
    *ppIRects = (IHTMLRectCollection *) pOMRectCollection;

Cleanup:
    RRETURN(SetErrorInfo(hr));
}


CDOMChildrenCollection *
CElement::EnsureDOMChildrenCollectionPtr ( )
{
    CDOMChildrenCollection *pDOMPtr = NULL;
    GetPointerAt ( FindAAIndex ( DISPID_INTERNAL_CDOMCHILDRENPTRCACHE,CAttrValue::AA_Internal ),
        (void **)&pDOMPtr );
    if ( !pDOMPtr )
    {
        pDOMPtr = new CDOMChildrenCollection ( this, TRUE /* fIsElement */ );
        if ( pDOMPtr )
        {
            AddPointer ( DISPID_INTERNAL_CDOMCHILDRENPTRCACHE,
                (void *)pDOMPtr,
                CAttrValue::AA_Internal );
        }
    }
    else
    {
        pDOMPtr->AddRef();
    }
    return pDOMPtr;
}



#ifndef NO_EDIT
HRESULT
CElement::CreateUndoAttrValueSimpleChange(
    DISPID dispid,
    VARIANT &  vtProp,
    BOOL fInlineStyle,
    CAttrValue::AATYPE aaType )
{
    HRESULT                      hr;
    CUndoAttrValueSimpleChange * pUndo = NULL;

    if (!QueryCreateUndo(TRUE))
        return S_OK;

    TraceTag((tagUndo,
              "CElement::CreateUndoAttrValueSimpleChange creating an object."));

    pUndo = new CUndoAttrValueSimpleChange(this);
    if (!pUndo)
        RRETURN(E_OUTOFMEMORY);

    hr = THR(pUndo->Init(dispid, vtProp, fInlineStyle, aaType));
    if (hr)
        goto Cleanup;

    hr = THR(UndoManager()->Add(pUndo));

Cleanup:

    ReleaseInterface(pUndo);

    RRETURN(hr);
}

HRESULT
CElement::CreateUndoPropChangeNotification(
    DISPID dispid,
    DWORD dwFlags,
    BOOL fPlaceHolder )
{
    HRESULT                       hr;
    CUndoPropChangeNotification * pUndo = NULL;

    if (!QueryCreateUndo(TRUE))
        return S_OK;

    TraceTag((tagUndo,
              "CElement::CreateUndoPropChangeNotification creating an object."));

    pUndo = new CUndoPropChangeNotification( this );
    if (!pUndo)
        RRETURN(E_OUTOFMEMORY);

    hr = THR(pUndo->Init(dispid, dwFlags, fPlaceHolder));
    if (hr)
        goto Cleanup;

    hr = THR(UndoManager()->Add(pUndo));

Cleanup:

    ReleaseInterface(pUndo);

    RRETURN(hr);
}

#endif // NO_EDIT


//
// Recalc methods
// These methods are tiny stubs that point directly to the recalc host code
//
STDMETHODIMP
CElement::removeExpression(BSTR strPropertyName, VARIANT_BOOL *pfSuccess)
{
    CTreeNode *pNode = GetUpdatedNearestLayoutNode();
    if (pNode)
        pNode->GetFancyFormatIndex();

    RRETURN(SetErrorInfo(Doc()->_recalcHost.removeExpression(this, strPropertyName, pfSuccess)));
}

STDMETHODIMP
CElement::setExpression(BSTR strPropertyName, BSTR strExpression, BSTR strLanguage)
{
    CTreeNode *pNode = GetUpdatedNearestLayoutNode();
    if (pNode)
        pNode->GetFancyFormatIndex();

    RRETURN(SetErrorInfo(Doc()->_recalcHost.setExpression(this, strPropertyName, strExpression, strLanguage)));
}

STDMETHODIMP
CElement::getExpression(BSTR strPropertyName, VARIANT *pvExpression)
{
    CTreeNode *pNode = GetUpdatedNearestLayoutNode();
    if (pNode)
        pNode->GetFancyFormatIndex();

    RRETURN(SetErrorInfo(Doc()->_recalcHost.getExpression(this, strPropertyName, pvExpression)));
}
