////////////////////////////////////////////////////////////////////////////////
// D3DConvert.h
//
// Convert D3D enum values and structures between D3D10, D3D10.1, D3D11, and D3D11.1

#pragma once

#include <D3D11_1.h>
#include <D3D11.h>
#include <D3D10_1.h>
#include <D3D10.h>

namespace D3DConvert
{
	HRESULT Convert( D3D10_INPUT_CLASSIFICATION &out, D3D11_INPUT_CLASSIFICATION in );
	HRESULT Convert( D3D11_INPUT_CLASSIFICATION &out, D3D10_INPUT_CLASSIFICATION in );
	HRESULT Convert( D3D10_INPUT_ELEMENT_DESC &out, const D3D11_INPUT_ELEMENT_DESC &in );
	HRESULT Convert( D3D11_INPUT_ELEMENT_DESC &out, const D3D10_INPUT_ELEMENT_DESC &in );
	HRESULT Convert( D3D10_FILL_MODE &out, D3D11_FILL_MODE in );
	HRESULT Convert( D3D11_FILL_MODE &out, D3D10_FILL_MODE in );
	HRESULT Convert( D3D10_CULL_MODE &out, D3D11_CULL_MODE in );
	HRESULT Convert( D3D11_CULL_MODE &out, D3D10_CULL_MODE in );
	HRESULT Convert( D3D10_SO_DECLARATION_ENTRY &out, const D3D11_SO_DECLARATION_ENTRY &in );
	HRESULT Convert( D3D11_SO_DECLARATION_ENTRY &out, const D3D10_SO_DECLARATION_ENTRY &in );
	HRESULT Convert( D3D10_VIEWPORT &out, const D3D11_VIEWPORT &in );
	HRESULT Convert( D3D11_VIEWPORT &out, const D3D10_VIEWPORT &in );
	HRESULT Convert( D3D10_RESOURCE_DIMENSION &out, D3D11_RESOURCE_DIMENSION in );
	HRESULT Convert( D3D11_RESOURCE_DIMENSION &out, D3D10_RESOURCE_DIMENSION in );
	HRESULT Convert( D3D10_DSV_DIMENSION &out, D3D11_DSV_DIMENSION in );
	HRESULT Convert( D3D11_DSV_DIMENSION &out, D3D10_DSV_DIMENSION in );
	HRESULT Convert( D3D10_RTV_DIMENSION &out, D3D11_RTV_DIMENSION in );
	HRESULT Convert( D3D11_RTV_DIMENSION &out, D3D10_RTV_DIMENSION in );
	HRESULT Convert( D3D10_USAGE &out, D3D11_USAGE in );
	HRESULT Convert( D3D11_USAGE &out, D3D10_USAGE in );
	HRESULT ConvertBindFlag11to10( UINT &out, UINT in );
	HRESULT ConvertBindFlag10to11( UINT &out, UINT in );
	HRESULT ConvertCpuAccessFlag11to10( UINT &out, UINT in );
	HRESULT ConvertCpuAccessFlag10to11( UINT &out, UINT in );
	HRESULT ConvertResourceMiscFlag11to10( UINT &out, UINT in );
	HRESULT ConvertResourceMiscFlag10to11( UINT &out, UINT in );
	HRESULT Convert( D3D10_MAP &out, D3D11_MAP in );
	HRESULT Convert( D3D11_MAP &out, D3D10_MAP in );
	HRESULT ConvertMapFlag11to10( long &out, long in );
	HRESULT ConvertMapFlag10to11( long &out, long in );
	HRESULT ConvertRaiseFlag11to10( long &out, long in );
	HRESULT ConvertRaiseFlag10to11( long &out, long in );
	HRESULT ConvertClearFlag11to10( long &out, long in );
	HRESULT ConvertClearFlag10to11( long &out, long in );
	HRESULT Convert( D3D10_RECT &out, const D3D11_RECT &in );
	HRESULT Convert( D3D10_BOX &out, const D3D11_BOX &in );
	HRESULT Convert( D3D11_BOX &out, const D3D10_BOX &in );
	HRESULT Convert( D3D11_COMPARISON_FUNC &out, D3D10_COMPARISON_FUNC in );
	HRESULT Convert( D3D10_COMPARISON_FUNC &out, D3D11_COMPARISON_FUNC in );
	HRESULT Convert( D3D11_DEPTH_WRITE_MASK &out, D3D10_DEPTH_WRITE_MASK in );
	HRESULT Convert( D3D10_DEPTH_WRITE_MASK &out, D3D11_DEPTH_WRITE_MASK in );
	HRESULT Convert( D3D11_STENCIL_OP &out, D3D10_STENCIL_OP in );
	HRESULT Convert( D3D10_STENCIL_OP &out, D3D11_STENCIL_OP in );
	HRESULT Convert( D3D11_DEPTH_STENCILOP_DESC &out, const D3D10_DEPTH_STENCILOP_DESC &in );
	HRESULT Convert( D3D10_DEPTH_STENCILOP_DESC &out, const D3D11_DEPTH_STENCILOP_DESC &in );
	HRESULT Convert( D3D11_DEPTH_STENCIL_DESC &out, const D3D10_DEPTH_STENCIL_DESC &in );
	HRESULT Convert( D3D10_DEPTH_STENCIL_DESC &out, const D3D11_DEPTH_STENCIL_DESC &in );
	HRESULT Convert( D3D11_BLEND &out, D3D10_BLEND in );
	HRESULT Convert( D3D10_BLEND &out, D3D11_BLEND in );
	HRESULT Convert( D3D11_BLEND_OP  &out, D3D10_BLEND_OP in );
	HRESULT Convert( D3D10_BLEND_OP  &out, D3D11_BLEND_OP in );
	HRESULT Convert( D3D11_COLOR_WRITE_ENABLE &out, D3D10_COLOR_WRITE_ENABLE in );
	HRESULT Convert( D3D10_COLOR_WRITE_ENABLE &out, D3D11_COLOR_WRITE_ENABLE in );
	HRESULT Convert( D3D11_RENDER_TARGET_BLEND_DESC1 &out, const D3D11_RENDER_TARGET_BLEND_DESC &in );
	HRESULT Convert( D3D11_RENDER_TARGET_BLEND_DESC &out, const D3D11_RENDER_TARGET_BLEND_DESC1 &in );
	HRESULT Convert( D3D11_RENDER_TARGET_BLEND_DESC &out, const D3D10_RENDER_TARGET_BLEND_DESC1 &in );
	HRESULT Convert( D3D10_RENDER_TARGET_BLEND_DESC1 &out, const D3D11_RENDER_TARGET_BLEND_DESC &in );
	HRESULT Convert( D3D10_RENDER_TARGET_BLEND_DESC1 &out, const D3D11_RENDER_TARGET_BLEND_DESC1 &in );
	HRESULT Convert( D3D11_RENDER_TARGET_BLEND_DESC1 &out, const D3D10_RENDER_TARGET_BLEND_DESC1 &in );
	HRESULT Convert( D3D11_BLEND_DESC1 &out, const D3D11_BLEND_DESC &in );
	HRESULT Convert( D3D11_BLEND_DESC &out, const D3D11_BLEND_DESC1 &in );
	HRESULT Convert( D3D11_BLEND_DESC1 &out, const D3D10_BLEND_DESC1 &in );
	HRESULT Convert( D3D10_BLEND_DESC1 &out, const D3D11_BLEND_DESC1 &in );
	HRESULT Convert( D3D11_BLEND_DESC1 &out, const D3D10_BLEND_DESC &in );
	HRESULT Convert( D3D10_BLEND_DESC &out, const D3D11_BLEND_DESC1 &in );
	HRESULT Convert( D3D10_BLEND_DESC1 &out, const D3D11_BLEND_DESC &in );
	HRESULT Convert( D3D11_BLEND_DESC &out, const D3D10_BLEND_DESC1 &in );
	HRESULT Convert( D3D10_BLEND_DESC &out, const D3D11_BLEND_DESC &in );
	HRESULT Convert( D3D11_BLEND_DESC &out, const D3D10_BLEND_DESC &in );
	HRESULT Convert( D3D11_RASTERIZER_DESC &out, const D3D11_RASTERIZER_DESC1 &in );
	HRESULT Convert( D3D11_RASTERIZER_DESC1 &out, const D3D11_RASTERIZER_DESC &in );
	HRESULT Convert( D3D10_RASTERIZER_DESC &out, const D3D11_RASTERIZER_DESC &in );
	HRESULT Convert( D3D11_RASTERIZER_DESC1 &out, const D3D10_RASTERIZER_DESC &in );
	HRESULT Convert( D3D10_RASTERIZER_DESC &out, const D3D11_RASTERIZER_DESC1 &in );
	HRESULT Convert( D3D11_RASTERIZER_DESC &out, const D3D10_RASTERIZER_DESC &in );
	HRESULT Convert( D3D11_SUBRESOURCE_DATA &out, const D3D10_SUBRESOURCE_DATA &in );
	HRESULT Convert( D3D10_SUBRESOURCE_DATA &out, const D3D11_SUBRESOURCE_DATA &in );
	HRESULT Convert( D3D11_BUFFER_DESC &out, const D3D10_BUFFER_DESC &in );
	HRESULT Convert( D3D10_BUFFER_DESC &out, const D3D11_BUFFER_DESC &in );
	HRESULT Convert( D3D11_TEXTURE1D_DESC &out, const D3D10_TEXTURE1D_DESC &in );
	HRESULT Convert( D3D10_TEXTURE1D_DESC &out, const D3D11_TEXTURE1D_DESC &in );
	HRESULT Convert( D3D11_TEXTURE2D_DESC &out, const D3D10_TEXTURE2D_DESC &in );
	HRESULT Convert( D3D10_TEXTURE2D_DESC &out, const D3D11_TEXTURE2D_DESC &in );
	HRESULT Convert( D3D11_TEXTURE3D_DESC &out, const D3D10_TEXTURE3D_DESC &in );
	HRESULT Convert( D3D10_TEXTURE3D_DESC &out, const D3D11_TEXTURE3D_DESC &in );
	HRESULT Convert( D3D11_TEXTURECUBE_FACE  &out, D3D10_TEXTURECUBE_FACE  in );
	HRESULT Convert( D3D10_TEXTURECUBE_FACE  &out, D3D11_TEXTURECUBE_FACE  in );
	HRESULT Convert( D3D11_BUFFER_SRV &out, const D3D10_BUFFER_SRV &in );
	HRESULT Convert( D3D10_BUFFER_SRV &out, const D3D11_BUFFER_SRV &in );
	HRESULT Convert( D3D11_TEX1D_SRV &out, const D3D10_TEX1D_SRV &in );
	HRESULT Convert( D3D10_TEX1D_SRV &out, const D3D11_TEX1D_SRV &in );
	HRESULT Convert( D3D11_TEX1D_ARRAY_SRV &out, const D3D10_TEX1D_ARRAY_SRV &in );
	HRESULT Convert( D3D10_TEX1D_ARRAY_SRV &out, const D3D11_TEX1D_ARRAY_SRV &in );
	HRESULT Convert( D3D11_TEX2D_SRV &out, const D3D10_TEX2D_SRV &in );
	HRESULT Convert( D3D10_TEX2D_SRV &out, const D3D11_TEX2D_SRV &in );
	HRESULT Convert( D3D11_TEX2D_ARRAY_SRV &out, const D3D10_TEX2D_ARRAY_SRV &in );
	HRESULT Convert( D3D10_TEX2D_ARRAY_SRV &out, const D3D11_TEX2D_ARRAY_SRV &in );
	HRESULT Convert( D3D11_TEX3D_SRV &out, const D3D10_TEX3D_SRV &in );
	HRESULT Convert( D3D10_TEX3D_SRV &out, const D3D11_TEX3D_SRV &in );
	HRESULT Convert( D3D11_TEXCUBE_SRV &out, const D3D10_TEXCUBE_SRV &in );
	HRESULT Convert( D3D10_TEXCUBE_SRV &out, const D3D11_TEXCUBE_SRV &in );
	HRESULT Convert( D3D11_TEXCUBE_ARRAY_SRV &out, const D3D10_TEXCUBE_ARRAY_SRV1 &in );
	HRESULT Convert( D3D10_TEXCUBE_ARRAY_SRV1 &out, const D3D11_TEXCUBE_ARRAY_SRV &in );
	HRESULT Convert( D3D11_TEX2DMS_SRV &out, const D3D10_TEX2DMS_SRV &in );
	HRESULT Convert( D3D10_TEX2DMS_SRV &out, const D3D11_TEX2DMS_SRV &in );
	HRESULT Convert( D3D11_TEX2DMS_ARRAY_SRV &out, const D3D10_TEX2DMS_ARRAY_SRV &in );
	HRESULT Convert( D3D10_TEX2DMS_ARRAY_SRV &out, const D3D11_TEX2DMS_ARRAY_SRV &in );
	HRESULT Convert( D3D11_SHADER_RESOURCE_VIEW_DESC &out, const D3D10_SHADER_RESOURCE_VIEW_DESC1 &in );
	HRESULT Convert( D3D10_SHADER_RESOURCE_VIEW_DESC1 &out, const D3D11_SHADER_RESOURCE_VIEW_DESC &in );
	HRESULT Convert( D3D10_SHADER_RESOURCE_VIEW_DESC &out, const D3D10_SHADER_RESOURCE_VIEW_DESC1 &in );
	HRESULT Convert( D3D10_SHADER_RESOURCE_VIEW_DESC1 &out, const D3D10_SHADER_RESOURCE_VIEW_DESC &in );
	HRESULT Convert( D3D11_SHADER_RESOURCE_VIEW_DESC &out, const D3D10_SHADER_RESOURCE_VIEW_DESC &in );
	HRESULT Convert( D3D10_SHADER_RESOURCE_VIEW_DESC &out, const D3D11_SHADER_RESOURCE_VIEW_DESC &in );
	HRESULT Convert( D3D11_BUFFER_RTV &out, const D3D10_BUFFER_RTV &in );
	HRESULT Convert( D3D10_BUFFER_RTV &out, const D3D11_BUFFER_RTV &in );
	HRESULT Convert( D3D11_TEX1D_RTV &out, const D3D10_TEX1D_RTV &in );
	HRESULT Convert( D3D10_TEX1D_RTV &out, const D3D11_TEX1D_RTV &in );
	HRESULT Convert( D3D11_TEX1D_ARRAY_RTV &out, const D3D10_TEX1D_ARRAY_RTV &in );
	HRESULT Convert( D3D10_TEX1D_ARRAY_RTV &out, const D3D11_TEX1D_ARRAY_RTV &in );
	HRESULT Convert( D3D11_TEX2D_RTV &out, const D3D10_TEX2D_RTV &in );
	HRESULT Convert( D3D10_TEX2D_RTV &out, const D3D11_TEX2D_RTV &in );
	HRESULT Convert( D3D11_TEX2DMS_RTV &out, const D3D10_TEX2DMS_RTV &in );
	HRESULT Convert( D3D10_TEX2DMS_RTV &out, const D3D11_TEX2DMS_RTV &in );
	HRESULT Convert( D3D11_TEX2D_ARRAY_RTV &out, const D3D10_TEX2D_ARRAY_RTV &in );
	HRESULT Convert( D3D10_TEX2D_ARRAY_RTV &out, const D3D11_TEX2D_ARRAY_RTV &in );
	HRESULT Convert( D3D11_TEX2DMS_ARRAY_RTV &out, const D3D10_TEX2DMS_ARRAY_RTV &in );
	HRESULT Convert( D3D10_TEX2DMS_ARRAY_RTV &out, const D3D11_TEX2DMS_ARRAY_RTV &in );
	HRESULT Convert( D3D11_TEX3D_RTV &out, const D3D10_TEX3D_RTV &in );
	HRESULT Convert( D3D10_TEX3D_RTV &out, const D3D11_TEX3D_RTV &in );
	HRESULT Convert( D3D10_RENDER_TARGET_VIEW_DESC &out, const D3D11_RENDER_TARGET_VIEW_DESC &in );
	HRESULT Convert( D3D11_RENDER_TARGET_VIEW_DESC &out, const D3D10_RENDER_TARGET_VIEW_DESC &in );
	HRESULT Convert( D3D11_TEX1D_DSV &out, const D3D10_TEX1D_DSV &in );
	HRESULT Convert( D3D10_TEX1D_DSV &out, const D3D11_TEX1D_DSV &in );
	HRESULT Convert( D3D11_TEX1D_ARRAY_DSV &out, const D3D10_TEX1D_ARRAY_DSV &in );
	HRESULT Convert( D3D10_TEX1D_ARRAY_DSV &out, const D3D11_TEX1D_ARRAY_DSV &in );
	HRESULT Convert( D3D11_TEX2D_DSV &out, const D3D10_TEX2D_DSV &in );
	HRESULT Convert( D3D10_TEX2D_DSV &out, const D3D11_TEX2D_DSV &in );
	HRESULT Convert( D3D11_TEX2DMS_DSV &out, const D3D10_TEX2DMS_DSV &in );
	HRESULT Convert( D3D10_TEX2DMS_DSV &out, const D3D11_TEX2DMS_DSV &in );
	HRESULT Convert( D3D11_TEX2D_ARRAY_DSV &out, const D3D10_TEX2D_ARRAY_DSV &in );
	HRESULT Convert( D3D10_TEX2D_ARRAY_DSV &out, const D3D11_TEX2D_ARRAY_DSV &in );
	HRESULT Convert( D3D11_TEX2DMS_ARRAY_DSV &out, const D3D10_TEX2DMS_ARRAY_DSV &in );
	HRESULT Convert( D3D10_TEX2DMS_ARRAY_DSV &out, const D3D11_TEX2DMS_ARRAY_DSV &in );
	HRESULT Convert( D3D10_DEPTH_STENCIL_VIEW_DESC &out, const D3D11_DEPTH_STENCIL_VIEW_DESC &in );
	HRESULT Convert( D3D11_DEPTH_STENCIL_VIEW_DESC &out, const D3D10_DEPTH_STENCIL_VIEW_DESC &in );
	HRESULT Convert( D3D10_FILTER &out, D3D11_FILTER in );
	HRESULT Convert( D3D11_FILTER &out, D3D10_FILTER in );
	HRESULT Convert( D3D11_FILTER_TYPE &out, D3D10_FILTER_TYPE in );
	HRESULT Convert( D3D10_FILTER_TYPE &out, D3D11_FILTER_TYPE in );
	HRESULT Convert( D3D11_TEXTURE_ADDRESS_MODE &out, D3D10_TEXTURE_ADDRESS_MODE in );
	HRESULT Convert( D3D10_TEXTURE_ADDRESS_MODE &out, D3D11_TEXTURE_ADDRESS_MODE in );
	HRESULT Convert( D3D11_SAMPLER_DESC &out, const D3D10_SAMPLER_DESC &in );
	HRESULT Convert( D3D10_SAMPLER_DESC &out, const D3D11_SAMPLER_DESC &in );
	HRESULT Convert( D3D11_FORMAT_SUPPORT &out, D3D10_FORMAT_SUPPORT in );
	HRESULT Convert( D3D10_FORMAT_SUPPORT &out, D3D11_FORMAT_SUPPORT in );
	HRESULT ConvertAsyncGetDataFlag11to10( UINT &out, UINT in );
	HRESULT ConvertAsyncGetDataFlag10to11( UINT &out, UINT in );
	HRESULT Convert( D3D11_QUERY &out, D3D10_QUERY in );
	HRESULT Convert( D3D10_QUERY &out, D3D11_QUERY in );
	HRESULT ConvertQueryMiscFlag11to10( UINT &out, UINT in );
	HRESULT ConvertQueryMiscFlag10to11( UINT &out, UINT in );
	HRESULT Convert( D3D11_QUERY_DESC &out, const D3D10_QUERY_DESC &in );
	HRESULT Convert( D3D10_QUERY_DESC &out, const D3D11_QUERY_DESC &in );
	HRESULT Convert( D3D11_QUERY_DATA_TIMESTAMP_DISJOINT &out, const D3D10_QUERY_DATA_TIMESTAMP_DISJOINT &in );
	HRESULT Convert( D3D10_QUERY_DATA_TIMESTAMP_DISJOINT &out, const D3D11_QUERY_DATA_TIMESTAMP_DISJOINT &in );
	HRESULT Convert( D3D11_QUERY_DATA_PIPELINE_STATISTICS &out, const D3D10_QUERY_DATA_PIPELINE_STATISTICS &in );
	HRESULT Convert( D3D10_QUERY_DATA_PIPELINE_STATISTICS &out, const D3D11_QUERY_DATA_PIPELINE_STATISTICS &in );
	HRESULT Convert( D3D11_QUERY_DATA_SO_STATISTICS &out, const D3D10_QUERY_DATA_SO_STATISTICS &in );
	HRESULT Convert( D3D10_QUERY_DATA_SO_STATISTICS &out, const D3D11_QUERY_DATA_SO_STATISTICS &in );
	HRESULT Convert( D3D11_COUNTER &out, D3D10_COUNTER in );
	HRESULT Convert( D3D10_COUNTER &out, D3D11_COUNTER in );
	HRESULT Convert( D3D11_COUNTER_TYPE &out, D3D10_COUNTER_TYPE in );
	HRESULT Convert( D3D10_COUNTER_TYPE &out, D3D11_COUNTER_TYPE in );
	HRESULT Convert( D3D11_COUNTER_DESC &out, const D3D10_COUNTER_DESC &in );
	HRESULT Convert( D3D10_COUNTER_DESC &out, const D3D11_COUNTER_DESC &in );
	HRESULT Convert( D3D11_COUNTER_INFO &out, const D3D10_COUNTER_INFO &in );
	HRESULT Convert( D3D10_COUNTER_INFO &out, const D3D11_COUNTER_INFO &in );
	HRESULT Convert( D3D11_STANDARD_MULTISAMPLE_QUALITY_LEVELS &out, D3D10_STANDARD_MULTISAMPLE_QUALITY_LEVELS in );
	HRESULT Convert( D3D10_STANDARD_MULTISAMPLE_QUALITY_LEVELS &out, D3D11_STANDARD_MULTISAMPLE_QUALITY_LEVELS in );
	HRESULT ConvertCreateDeviceFlag11to10( UINT &out, UINT in );
	HRESULT ConvertCreateDeviceFlag10to11( UINT &out, UINT in );
};