//////////////////////////////////////////////////////////////////////
// File:  DXGITest.h
//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
// Purpose:
// Implementation of a DXGI test base class.
//
// History:
// 11 Sep 2007  SEdmison  Created.
//////////////////////////////////////////////////////////////////////

#pragma once


/////////////////////////////////////////////////////////////////
//
// Includes
//
/////////////////////////////////////////////////////////////////

//
// Project headers
//

#include "DXGITestFramework.h"
#include "HResultHelp.h"

/////////////////////////////////////////////////////////////////
//
// Interfaces
//
/////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////
// Class:  CDXGITest
//
// Purpose:
// Base class for DXGI test groups.
///////////////////////////////////////////////////////
class CDXGITest
:
	public CTest
{
	//
	// Construction/destruction
	//

	public:
		// Constructor.
		CDXGITest();

		// Destructor.
		virtual ~CDXGITest();


	//
	// Framework override methods
	//

	protected:
		virtual void InitTestParameters();


	//
	// Member data
	//

	protected:
		TEST_FEATURE_LEVEL m_TestFeatureLevel;
        testfactor::RFactor m_FeatureLevelFactor;
};
