/*++

Copyright (c) Microsoft Corporation

Module Name:

    tracing.hpp

Abstract:

    Debug stuff

--*/

#pragma once


#define WPP_CONTROL_GUIDS \
            WPP_DEFINE_CONTROL_GUID(USBHUB3, (6E6CC2C5,8110,490e,9905,9F2ED700E455), \
                WPP_DEFINE_BIT(General)             \
                WPP_DEFINE_BIT(Driver)              \
                WPP_DEFINE_BIT(Hub)                 \
                WPP_DEFINE_BIT(Port)                \
                WPP_DEFINE_BIT(Device)              \
                WPP_DEFINE_BIT(HwcPlatform)         \
            )

#define WPP_LEVEL_FLAGS_LOGGER(lvl,flags) WPP_LEVEL_LOGGER(flags)
#define WPP_LEVEL_FLAGS_ENABLED(lvl,flags) (WPP_LEVEL_ENABLED(flags) && WPP_CONTROL(WPP_BIT_ ## flags).Level >= lvl)

#define TL_FATAL        0x01
#define TL_ERROR        0x02
#define TL_WARNING      0x03
#define TL_INFO         0x04
#define TL_VERBOSE      0x05

//
// begin_wpp config
//
// CUSTOM_TYPE(LINKSTATE, ItemListShort(PORT_LINK_STATE_U0,PORT_LINK_STATE_U1,PORT_LINK_STATE_U2,PORT_LINK_STATE_U3,PORT_LINK_STATE_DISABLED,PORT_LINK_STATE_RX_DETECT,PORT_LINK_STATE_INACTIVE,PORT_LINK_STATE_POLLING,PORT_LINK_STATE_RECOVERY,PORT_LINK_STATE_HOT_RESET,PORT_LINK_STATE_COMPLIANCE_MODE,PORT_LINK_STATE_LOOPBACK));
//
// CUSTOM_TYPE(USBDESCRIPTOR, ItemListByte(USB_DEVICE_DESCRIPTOR_TYPE=0x01,USB_CONFIGURATION_DESCRIPTOR_TYPE,USB_STRING_DESCRIPTOR_TYPE,USB_INTERFACE_DESCRIPTOR_TYPE,USB_ENDPOINT_DESCRIPTOR_TYPE,USB_DEVICE_QUALIFIER_DESCRIPTOR_TYPE,USB_OTHER_SPEED_CONFIGURATION_DESCRIPTOR_TYPE,USB_INTERFACE_POWER_DESCRIPTOR_TYPE,USB_OTG_DESCRIPTOR_TYPE,USB_DEBUG_DESCRIPTOR_TYPE,USB_INTERFACE_ASSOCIATION_DESCRIPTOR_TYPE,USB_BOS_DESCRIPTOR_TYPE=0x0F,USB_DEVICE_CAPABILITY_DESCRIPTOR_TYPE=0x10,USB_SUPERSPEED_ENDPOINT_COMPANION_DESCRIPTOR_TYPE=0x30,USB_SUPERSPEEDPLUS_ISOCH_ENDPOINT_COMPANION_DESCRIPTOR_TYPE=0x31));
//
// CUSTOM_TYPE(HUBDESCRIPTOR, ItemListByte(USB_20_HUB_DESCRIPTOR_TYPE=0x29,USB_30_HUB_DESCRIPTOR_TYPE=0x2A));
//
// CUSTOM_TYPE(PORTFEATURESELECTOR, ItemEnum(_USB_PORT_FEATURE_SELECTOR));
//
// CUSTOM_TYPE(HUBFEATURESELECTOR, ItemEnum(_USB_HUB_FEATURE_SELECTOR));
//
// CUSTOM_TYPE(DSMSTATE, ItemEnum(_DSM_STATE));
//
// CUSTOM_TYPE(DSMEVENT, ItemEnum(_DSM_EVENT));
//
// CUSTOM_TYPE(HSMSTATE, ItemEnum(_HSM_STATE));
//
// CUSTOM_TYPE(HSMEVENT, ItemEnum(_HSM_EVENT));
//
// CUSTOM_TYPE(PSM20STATE, ItemEnum(_PSM20_STATE));
//
// CUSTOM_TYPE(PSMEVENT, ItemEnum(_PSM_EVENT));
//
// CUSTOM_TYPE(PSM30STATE, ItemEnum(_PSM30_STATE));
//
// end_wpp
//